/* valaccodememberaccessmodule.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodememberaccessmodule.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valadatatype.h>
#include <vala/valaexpression.h>
#include <vala/valamethod.h>
#include <vala/valabaseaccess.h>
#include <vala/valasymbol.h>
#include <vala/valaclass.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valatypesymbol.h>
#include <ccode/valaccodememberaccess.h>
#include <vala/valainterface.h>
#include <vala/valalocalvariable.h>
#include <gee/list.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valaarraylengthfield.h>
#include <vala/valafield.h>
#include <vala/valamember.h>
#include <vala/valapointertype.h>
#include <vala/valaconstant.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valadynamicproperty.h>
#include <ccode/valaccodecommaexpression.h>
#include <gee/collection.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valaenumvalue.h>
#include <vala/valaformalparameter.h>
#include <vala/valastruct.h>
#include <gobject/valaccodebasemodule.h>




enum  {
	VALA_CCODE_MEMBER_ACCESS_MODULE_DUMMY_PROPERTY
};
static void vala_ccode_member_access_module_real_visit_member_access (ValaCCodeModule* base, ValaMemberAccess* expr);
static gpointer vala_ccode_member_access_module_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeMemberAccessModule* vala_ccode_member_access_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeMemberAccessModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeMemberAccessModule*) vala_ccode_control_flow_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeMemberAccessModule* vala_ccode_member_access_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_member_access_module_construct (VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, codegen, next);
}


static void vala_ccode_member_access_module_real_visit_member_access (ValaCCodeModule* base, ValaMemberAccess* expr) {
	ValaCCodeMemberAccessModule * self;
	ValaCCodeExpression* pub_inst;
	ValaDataType* base_type;
	self = (ValaCCodeMemberAccessModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	pub_inst = NULL;
	base_type = NULL;
	if (vala_member_access_get_inner (expr) != NULL) {
		ValaCCodeExpression* _tmp1;
		ValaCCodeExpression* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		pub_inst = (_tmp1 = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr))), (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0)), (pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL)), _tmp1);
		if (vala_expression_get_value_type (vala_member_access_get_inner (expr)) != NULL) {
			ValaDataType* _tmp3;
			ValaDataType* _tmp2;
			_tmp3 = NULL;
			_tmp2 = NULL;
			base_type = (_tmp3 = (_tmp2 = vala_expression_get_value_type (vala_member_access_get_inner (expr)), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2)), (base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)), _tmp3);
		}
	}
	if (VALA_IS_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
		ValaMethod* _tmp4;
		ValaMethod* m;
		_tmp4 = NULL;
		m = (_tmp4 = VALA_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4));
		if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
			if (vala_method_get_base_method (m) != NULL) {
				ValaClass* _tmp5;
				ValaClass* base_class;
				ValaCCodeIdentifier* _tmp8;
				char* _tmp7;
				char* _tmp6;
				ValaCCodeFunctionCall* _tmp9;
				ValaCCodeFunctionCall* vcast;
				ValaCCodeIdentifier* _tmp12;
				char* _tmp11;
				char* _tmp10;
				ValaCCodeMemberAccess* _tmp13;
				_tmp5 = NULL;
				base_class = (_tmp5 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_method (m))), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
				_tmp8 = NULL;
				_tmp7 = NULL;
				_tmp6 = NULL;
				_tmp9 = NULL;
				vcast = (_tmp9 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new (_tmp7 = g_strdup_printf ("%s_CLASS", _tmp6 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) base_class, NULL))))), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)), _tmp7 = (g_free (_tmp7), NULL), _tmp6 = (g_free (_tmp6), NULL), _tmp9);
				_tmp12 = NULL;
				_tmp11 = NULL;
				_tmp10 = NULL;
				vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new (_tmp11 = g_strdup_printf ("%s_parent_class", _tmp10 = vala_symbol_get_lower_case_cname ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_class, NULL)))));
				(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
				_tmp11 = (g_free (_tmp11), NULL);
				_tmp10 = (g_free (_tmp10), NULL);
				_tmp13 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp13 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, vala_symbol_get_name ((ValaSymbol*) m))));
				(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
				(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
				(vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL));
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				return;
			} else {
				if (vala_method_get_base_interface_method (m) != NULL) {
					ValaInterface* _tmp14;
					ValaInterface* base_iface;
					char* _tmp16;
					char* _tmp15;
					char* _tmp17;
					char* parent_iface_var;
					ValaCCodeMemberAccess* _tmp19;
					ValaCCodeIdentifier* _tmp18;
					_tmp14 = NULL;
					base_iface = (_tmp14 = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_interface_method (m))), (_tmp14 == NULL) ? NULL : vala_code_node_ref (_tmp14));
					_tmp16 = NULL;
					_tmp15 = NULL;
					_tmp17 = NULL;
					parent_iface_var = (_tmp17 = g_strdup_printf ("%s_%s_parent_iface", _tmp15 = vala_symbol_get_lower_case_cname ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_class, NULL), _tmp16 = vala_symbol_get_lower_case_cname ((ValaSymbol*) base_iface, NULL)), _tmp16 = (g_free (_tmp16), NULL), _tmp15 = (g_free (_tmp15), NULL), _tmp17);
					_tmp19 = NULL;
					_tmp18 = NULL;
					vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp19 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new (parent_iface_var)), vala_symbol_get_name ((ValaSymbol*) m))));
					(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
					(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
					(base_iface == NULL) ? NULL : (base_iface = (vala_code_node_unref (base_iface), NULL));
					parent_iface_var = (g_free (parent_iface_var), NULL);
					(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
					(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
					(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
					return;
				}
			}
		}
		if (vala_method_get_base_method (m) != NULL) {
			if (!vala_ccode_module_method_has_wrapper (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_method_get_base_method (m))) {
				ValaCCodeExpression* _tmp20;
				ValaCCodeExpression* inst;
				gboolean _tmp21;
				ValaClass* _tmp23;
				ValaClass* base_class;
				ValaCCodeIdentifier* _tmp26;
				char* _tmp25;
				char* _tmp24;
				ValaCCodeFunctionCall* _tmp27;
				ValaCCodeFunctionCall* vclass;
				ValaCCodeMemberAccess* _tmp28;
				_tmp20 = NULL;
				inst = (_tmp20 = pub_inst, (_tmp20 == NULL) ? NULL : vala_ccode_node_ref (_tmp20));
				_tmp21 = FALSE;
				if (vala_member_access_get_inner (expr) != NULL) {
					_tmp21 = !vala_expression_is_pure (vala_member_access_get_inner (expr));
				} else {
					_tmp21 = FALSE;
				}
				if (_tmp21) {
					ValaLocalVariable* temp_var;
					ValaCCodeIdentifier* ctemp;
					ValaCCodeExpression* _tmp22;
					/* instance expression has side-effects
					 store in temp. variable*/
					temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_member_access_get_inner (expr)), TRUE, NULL);
					gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
					ctemp = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
					_tmp22 = NULL;
					inst = (_tmp22 = (ValaCCodeExpression*) vala_ccode_assignment_new ((ValaCCodeExpression*) ctemp, pub_inst, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp22);
					vala_code_node_set_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr), (ValaCCodeNode*) ctemp);
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
					(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
				}
				_tmp23 = NULL;
				base_class = (_tmp23 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_method (m))), (_tmp23 == NULL) ? NULL : vala_code_node_ref (_tmp23));
				_tmp26 = NULL;
				_tmp25 = NULL;
				_tmp24 = NULL;
				_tmp27 = NULL;
				vclass = (_tmp27 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp26 = vala_ccode_identifier_new (_tmp25 = g_strdup_printf ("%s_GET_CLASS", _tmp24 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) base_class, NULL))))), (_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)), _tmp25 = (g_free (_tmp25), NULL), _tmp24 = (g_free (_tmp24), NULL), _tmp27);
				vala_ccode_function_call_add_argument (vclass, inst);
				_tmp28 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp28 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vclass, vala_symbol_get_name ((ValaSymbol*) m))));
				(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
				(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
				(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
				(vclass == NULL) ? NULL : (vclass = (vala_ccode_node_unref (vclass), NULL));
			} else {
				ValaCCodeIdentifier* _tmp30;
				char* _tmp29;
				_tmp30 = NULL;
				_tmp29 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp30 = vala_ccode_identifier_new (_tmp29 = vala_method_get_cname (vala_method_get_base_method (m)))));
				(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
				_tmp29 = (g_free (_tmp29), NULL);
			}
		} else {
			if (vala_method_get_base_interface_method (m) != NULL) {
				ValaCCodeIdentifier* _tmp32;
				char* _tmp31;
				_tmp32 = NULL;
				_tmp31 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp32 = vala_ccode_identifier_new (_tmp31 = vala_method_get_cname (vala_method_get_base_interface_method (m)))));
				(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
				_tmp31 = (g_free (_tmp31), NULL);
			} else {
				ValaCCodeIdentifier* _tmp34;
				char* _tmp33;
				_tmp34 = NULL;
				_tmp33 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp34 = vala_ccode_identifier_new (_tmp33 = vala_method_get_cname (m))));
				(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
				_tmp33 = (g_free (_tmp33), NULL);
			}
		}
		(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	} else {
		if (VALA_IS_ARRAY_LENGTH_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
			ValaCCodeExpression* _tmp35;
			_tmp35 = NULL;
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp35 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_access_get_inner (expr), 1)));
			(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
		} else {
			if (VALA_IS_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
				ValaField* _tmp36;
				ValaField* f;
				gboolean _tmp73;
				_tmp36 = NULL;
				f = (_tmp36 = VALA_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp36 == NULL) ? NULL : vala_code_node_ref (_tmp36));
				if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
					ValaDataType* instance_target_type;
					ValaClass* _tmp38;
					ValaTypeSymbol* _tmp37;
					ValaClass* cl;
					gboolean _tmp39;
					gboolean is_gtypeinstance;
					ValaCCodeExpression* inst;
					gboolean _tmp41;
					gboolean _tmp45;
					instance_target_type = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) f)));
					_tmp38 = NULL;
					_tmp37 = NULL;
					cl = (_tmp38 = (_tmp37 = vala_data_type_get_data_type (instance_target_type), VALA_IS_CLASS (_tmp37) ? ((ValaClass*) _tmp37) : NULL), (_tmp38 == NULL) ? NULL : vala_code_node_ref (_tmp38));
					_tmp39 = FALSE;
					if ((vala_data_type_get_data_type (instance_target_type) == VALA_TYPESYMBOL (cl))) {
						gboolean _tmp40;
						_tmp40 = FALSE;
						if (cl == NULL) {
							_tmp40 = TRUE;
						} else {
							_tmp40 = !vala_class_get_is_compact (cl);
						}
						_tmp39 = (_tmp40);
					} else {
						_tmp39 = FALSE;
					}
					is_gtypeinstance = (_tmp39);
					inst = NULL;
					_tmp41 = FALSE;
					if (is_gtypeinstance) {
						_tmp41 = vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
					} else {
						_tmp41 = FALSE;
					}
					if (_tmp41) {
						ValaCCodeExpression* _tmp42;
						_tmp42 = NULL;
						inst = (_tmp42 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (pub_inst, "priv"), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp42);
					} else {
						ValaCCodeExpression* _tmp44;
						ValaCCodeExpression* _tmp43;
						_tmp44 = NULL;
						_tmp43 = NULL;
						inst = (_tmp44 = (_tmp43 = pub_inst, (_tmp43 == NULL) ? NULL : vala_ccode_node_ref (_tmp43)), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp44);
					}
					_tmp45 = FALSE;
					if (vala_typesymbol_is_reference_type (vala_data_type_get_data_type (instance_target_type))) {
						_tmp45 = TRUE;
					} else {
						gboolean _tmp46;
						_tmp46 = FALSE;
						if (vala_member_access_get_inner (expr) != NULL) {
							_tmp46 = VALA_IS_POINTER_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (expr)));
						} else {
							_tmp46 = FALSE;
						}
						_tmp45 = (_tmp46);
					}
					if (_tmp45) {
						ValaCCodeMemberAccess* _tmp48;
						char* _tmp47;
						_tmp48 = NULL;
						_tmp47 = NULL;
						vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp48 = vala_ccode_member_access_new_pointer (inst, _tmp47 = vala_field_get_cname (f))));
						(_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL));
						_tmp47 = (g_free (_tmp47), NULL);
					} else {
						ValaCCodeMemberAccess* _tmp50;
						char* _tmp49;
						_tmp50 = NULL;
						_tmp49 = NULL;
						vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp50 = vala_ccode_member_access_new (inst, _tmp49 = vala_field_get_cname (f), FALSE)));
						(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
						_tmp49 = (g_free (_tmp49), NULL);
					}
					(instance_target_type == NULL) ? NULL : (instance_target_type = (vala_code_node_unref (instance_target_type), NULL));
					(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
					(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
				} else {
					if (vala_field_get_binding (f) == MEMBER_BINDING_CLASS) {
						ValaClass* _tmp51;
						ValaClass* cl;
						ValaCCodeIdentifier* _tmp54;
						char* _tmp53;
						char* _tmp52;
						ValaCCodeFunctionCall* _tmp55;
						ValaCCodeFunctionCall* cast;
						ValaCCodeExpression* klass;
						_tmp51 = NULL;
						cl = (_tmp51 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) f)), (_tmp51 == NULL) ? NULL : vala_code_node_ref (_tmp51));
						_tmp54 = NULL;
						_tmp53 = NULL;
						_tmp52 = NULL;
						_tmp55 = NULL;
						cast = (_tmp55 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp54 = vala_ccode_identifier_new (_tmp53 = g_strconcat (_tmp52 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL), "_CLASS", NULL)))), (_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL)), _tmp53 = (g_free (_tmp53), NULL), _tmp52 = (g_free (_tmp52), NULL), _tmp55);
						klass = NULL;
						if (vala_member_access_get_inner (expr) == NULL) {
							if (((ValaCCodeBaseModule*) self)->in_static_or_class_ctor) {
								ValaCCodeExpression* _tmp56;
								/* Accessing the field from a static or class constructor*/
								_tmp56 = NULL;
								klass = (_tmp56 = (ValaCCodeExpression*) vala_ccode_identifier_new ("klass"), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp56);
							} else {
								ValaCCodeIdentifier* _tmp57;
								ValaCCodeFunctionCall* _tmp58;
								ValaCCodeFunctionCall* k;
								ValaCCodeIdentifier* _tmp59;
								ValaCCodeExpression* _tmp61;
								ValaCCodeExpression* _tmp60;
								/* Accessing the field from within an instance method*/
								_tmp57 = NULL;
								_tmp58 = NULL;
								k = (_tmp58 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp57 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL)), _tmp58);
								_tmp59 = NULL;
								vala_ccode_function_call_add_argument (k, (ValaCCodeExpression*) (_tmp59 = vala_ccode_identifier_new ("self")));
								(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
								_tmp61 = NULL;
								_tmp60 = NULL;
								klass = (_tmp61 = (_tmp60 = (ValaCCodeExpression*) k, (_tmp60 == NULL) ? NULL : vala_ccode_node_ref (_tmp60)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp61);
								(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
							}
						} else {
							ValaCCodeIdentifier* _tmp62;
							ValaCCodeFunctionCall* _tmp63;
							ValaCCodeFunctionCall* k;
							ValaCCodeExpression* _tmp65;
							ValaCCodeExpression* _tmp64;
							/* Accessing the field of an instance*/
							_tmp62 = NULL;
							_tmp63 = NULL;
							k = (_tmp63 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp62 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL)), _tmp63);
							vala_ccode_function_call_add_argument (k, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr))));
							_tmp65 = NULL;
							_tmp64 = NULL;
							klass = (_tmp65 = (_tmp64 = (ValaCCodeExpression*) k, (_tmp64 == NULL) ? NULL : vala_ccode_node_ref (_tmp64)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp65);
							(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
						}
						vala_ccode_function_call_add_argument (cast, klass);
						if (vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
							ValaCCodeMemberAccess* _tmp68;
							char* _tmp67;
							ValaCCodeMemberAccess* _tmp66;
							_tmp68 = NULL;
							_tmp67 = NULL;
							_tmp66 = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp68 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp66 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) cast, "priv")), _tmp67 = vala_field_get_cname (f))));
							(_tmp68 == NULL) ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL));
							_tmp67 = (g_free (_tmp67), NULL);
							(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
						} else {
							ValaCCodeMemberAccess* _tmp70;
							char* _tmp69;
							_tmp70 = NULL;
							_tmp69 = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp70 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) cast, _tmp69 = vala_field_get_cname (f))));
							(_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL));
							_tmp69 = (g_free (_tmp69), NULL);
						}
						(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
						(cast == NULL) ? NULL : (cast = (vala_ccode_node_unref (cast), NULL));
						(klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL));
					} else {
						ValaCCodeIdentifier* _tmp72;
						char* _tmp71;
						_tmp72 = NULL;
						_tmp71 = NULL;
						vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp72 = vala_ccode_identifier_new (_tmp71 = vala_field_get_cname (f))));
						(_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL));
						_tmp71 = (g_free (_tmp71), NULL);
					}
				}
				_tmp73 = FALSE;
				if (vala_data_type_get_type_parameter (vala_field_get_field_type (f)) != NULL) {
					_tmp73 = vala_data_type_get_type_parameter (vala_expression_get_value_type ((ValaExpression*) expr)) == NULL;
				} else {
					_tmp73 = FALSE;
				}
				if (_tmp73) {
					ValaCCodeExpression* _tmp74;
					_tmp74 = NULL;
					vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp74 = vala_ccode_base_module_convert_from_generic_pointer ((ValaCCodeBaseModule*) self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)), vala_expression_get_value_type ((ValaExpression*) expr))));
					(_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL));
				}
				(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
			} else {
				if (VALA_IS_CONSTANT (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
					ValaConstant* _tmp75;
					ValaConstant* c;
					ValaCCodeIdentifier* _tmp77;
					char* _tmp76;
					_tmp75 = NULL;
					c = (_tmp75 = VALA_CONSTANT (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp75 == NULL) ? NULL : vala_code_node_ref (_tmp75));
					_tmp77 = NULL;
					_tmp76 = NULL;
					vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp77 = vala_ccode_identifier_new (_tmp76 = vala_constant_get_cname (c))));
					(_tmp77 == NULL) ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL));
					_tmp76 = (g_free (_tmp76), NULL);
					(c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL));
				} else {
					if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
						ValaProperty* _tmp78;
						ValaProperty* prop;
						gboolean _tmp98;
						gboolean _tmp99;
						gboolean _tmp100;
						_tmp78 = NULL;
						prop = (_tmp78 = VALA_PROPERTY (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp78 == NULL) ? NULL : vala_code_node_ref (_tmp78));
						if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
							if (vala_property_get_base_property (prop) != NULL) {
								ValaClass* _tmp79;
								ValaClass* base_class;
								ValaCCodeIdentifier* _tmp82;
								char* _tmp81;
								char* _tmp80;
								ValaCCodeFunctionCall* _tmp83;
								ValaCCodeFunctionCall* vcast;
								ValaCCodeIdentifier* _tmp86;
								char* _tmp85;
								char* _tmp84;
								ValaCCodeMemberAccess* _tmp88;
								char* _tmp87;
								ValaCCodeFunctionCall* _tmp89;
								ValaCCodeFunctionCall* ccall;
								_tmp79 = NULL;
								base_class = (_tmp79 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_property (prop))), (_tmp79 == NULL) ? NULL : vala_code_node_ref (_tmp79));
								_tmp82 = NULL;
								_tmp81 = NULL;
								_tmp80 = NULL;
								_tmp83 = NULL;
								vcast = (_tmp83 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp82 = vala_ccode_identifier_new (_tmp81 = g_strdup_printf ("%s_CLASS", _tmp80 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) base_class, NULL))))), (_tmp82 == NULL) ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL)), _tmp81 = (g_free (_tmp81), NULL), _tmp80 = (g_free (_tmp80), NULL), _tmp83);
								_tmp86 = NULL;
								_tmp85 = NULL;
								_tmp84 = NULL;
								vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) (_tmp86 = vala_ccode_identifier_new (_tmp85 = g_strdup_printf ("%s_parent_class", _tmp84 = vala_symbol_get_lower_case_cname ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_class, NULL)))));
								(_tmp86 == NULL) ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL));
								_tmp85 = (g_free (_tmp85), NULL);
								_tmp84 = (g_free (_tmp84), NULL);
								_tmp88 = NULL;
								_tmp87 = NULL;
								_tmp89 = NULL;
								ccall = (_tmp89 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp88 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, _tmp87 = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp88 == NULL) ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL)), _tmp87 = (g_free (_tmp87), NULL), _tmp89);
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr))));
								vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
								(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
								(vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL));
								(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
								(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
								(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
								(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
								return;
							} else {
								if (vala_property_get_base_interface_property (prop) != NULL) {
									ValaInterface* _tmp90;
									ValaInterface* base_iface;
									char* _tmp92;
									char* _tmp91;
									char* _tmp93;
									char* parent_iface_var;
									ValaCCodeMemberAccess* _tmp96;
									char* _tmp95;
									ValaCCodeIdentifier* _tmp94;
									ValaCCodeFunctionCall* _tmp97;
									ValaCCodeFunctionCall* ccall;
									_tmp90 = NULL;
									base_iface = (_tmp90 = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_interface_property (prop))), (_tmp90 == NULL) ? NULL : vala_code_node_ref (_tmp90));
									_tmp92 = NULL;
									_tmp91 = NULL;
									_tmp93 = NULL;
									parent_iface_var = (_tmp93 = g_strdup_printf ("%s_%s_parent_iface", _tmp91 = vala_symbol_get_lower_case_cname ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_class, NULL), _tmp92 = vala_symbol_get_lower_case_cname ((ValaSymbol*) base_iface, NULL)), _tmp92 = (g_free (_tmp92), NULL), _tmp91 = (g_free (_tmp91), NULL), _tmp93);
									_tmp96 = NULL;
									_tmp95 = NULL;
									_tmp94 = NULL;
									_tmp97 = NULL;
									ccall = (_tmp97 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp96 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp94 = vala_ccode_identifier_new (parent_iface_var)), _tmp95 = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp96 == NULL) ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL)), _tmp95 = (g_free (_tmp95), NULL), (_tmp94 == NULL) ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL)), _tmp97);
									vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr))));
									vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
									(base_iface == NULL) ? NULL : (base_iface = (vala_code_node_unref (base_iface), NULL));
									parent_iface_var = (g_free (parent_iface_var), NULL);
									(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
									(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
									(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
									(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
									return;
								}
							}
						}
						_tmp98 = FALSE;
						_tmp99 = FALSE;
						_tmp100 = FALSE;
						if (vala_property_accessor_get_automatic_body (vala_property_get_get_accessor (prop))) {
							_tmp100 = VALA_SYMBOL (((ValaCCodeBaseModule*) self)->current_type_symbol) == vala_symbol_get_parent_symbol ((ValaSymbol*) prop);
						} else {
							_tmp100 = FALSE;
						}
						if (_tmp100) {
							_tmp99 = vala_property_get_base_property (prop) == NULL;
						} else {
							_tmp99 = FALSE;
						}
						if (_tmp99) {
							_tmp98 = vala_property_get_base_interface_property (prop) == NULL;
						} else {
							_tmp98 = FALSE;
						}
						if (_tmp98) {
							ValaCCodeExpression* inst;
							ValaCCodeExpression* _tmp101;
							ValaCCodeMemberAccess* _tmp103;
							char* _tmp102;
							inst = NULL;
							_tmp101 = NULL;
							inst = (_tmp101 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (pub_inst, "priv"), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp101);
							_tmp103 = NULL;
							_tmp102 = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp103 = vala_ccode_member_access_new_pointer (inst, _tmp102 = vala_field_get_cname (vala_property_get_field (prop)))));
							(_tmp103 == NULL) ? NULL : (_tmp103 = (vala_ccode_node_unref (_tmp103), NULL));
							_tmp102 = (g_free (_tmp102), NULL);
							(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
						} else {
							if (!vala_property_get_no_accessor_method (prop)) {
								ValaProperty* _tmp104;
								ValaProperty* base_property;
								char* getter_cname;
								ValaCCodeIdentifier* _tmp111;
								ValaCCodeFunctionCall* _tmp112;
								ValaCCodeFunctionCall* ccall;
								_tmp104 = NULL;
								base_property = (_tmp104 = prop, (_tmp104 == NULL) ? NULL : vala_code_node_ref (_tmp104));
								if (vala_property_get_base_property (prop) != NULL) {
									ValaProperty* _tmp106;
									ValaProperty* _tmp105;
									_tmp106 = NULL;
									_tmp105 = NULL;
									base_property = (_tmp106 = (_tmp105 = vala_property_get_base_property (prop), (_tmp105 == NULL) ? NULL : vala_code_node_ref (_tmp105)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp106);
								} else {
									if (vala_property_get_base_interface_property (prop) != NULL) {
										ValaProperty* _tmp108;
										ValaProperty* _tmp107;
										_tmp108 = NULL;
										_tmp107 = NULL;
										base_property = (_tmp108 = (_tmp107 = vala_property_get_base_interface_property (prop), (_tmp107 == NULL) ? NULL : vala_code_node_ref (_tmp107)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp108);
									}
								}
								getter_cname = NULL;
								if (VALA_IS_DYNAMIC_PROPERTY (prop)) {
									char* _tmp109;
									_tmp109 = NULL;
									getter_cname = (_tmp109 = vala_ccode_module_get_dynamic_property_getter_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), VALA_DYNAMIC_PROPERTY (prop)), getter_cname = (g_free (getter_cname), NULL), _tmp109);
								} else {
									char* _tmp110;
									_tmp110 = NULL;
									getter_cname = (_tmp110 = vala_property_accessor_get_cname (vala_property_get_get_accessor (base_property)), getter_cname = (g_free (getter_cname), NULL), _tmp110);
								}
								_tmp111 = NULL;
								_tmp112 = NULL;
								ccall = (_tmp112 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp111 = vala_ccode_identifier_new (getter_cname))), (_tmp111 == NULL) ? NULL : (_tmp111 = (vala_ccode_node_unref (_tmp111), NULL)), _tmp112);
								if (vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE) {
									vala_ccode_function_call_add_argument (ccall, pub_inst);
								}
								/* Property acesses to real struct types are handeled different to other properties.
								 They are returned as out parameter.*/
								if (vala_data_type_is_real_struct_type (vala_property_get_property_type (base_property))) {
									ValaCCodeCommaExpression* ccomma;
									ValaLocalVariable* temp_var;
									ValaCCodeIdentifier* ctemp;
									ValaCCodeUnaryExpression* _tmp113;
									ccomma = vala_ccode_comma_expression_new ();
									temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_property_get_property_type (base_property), TRUE, NULL);
									ctemp = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
									gee_collection_add ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars, temp_var);
									_tmp113 = NULL;
									vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp113 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) ctemp)));
									(_tmp113 == NULL) ? NULL : (_tmp113 = (vala_ccode_node_unref (_tmp113), NULL));
									vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ccall);
									vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ctemp);
									vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
									(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
									(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
									(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
								} else {
									vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
								}
								(base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL));
								getter_cname = (g_free (getter_cname), NULL);
								(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
							} else {
								ValaCCodeIdentifier* _tmp114;
								ValaCCodeFunctionCall* _tmp115;
								ValaCCodeFunctionCall* ccall;
								ValaCCodeIdentifier* _tmp116;
								ValaCCodeFunctionCall* _tmp117;
								ValaCCodeFunctionCall* ccast;
								ValaCCodeConstant* _tmp118;
								ValaDataType* temp_type;
								ValaLocalVariable* temp_var;
								ValaCCodeIdentifier* ctemp;
								ValaCCodeUnaryExpression* _tmp119;
								ValaCCodeConstant* _tmp120;
								ValaCCodeCommaExpression* ccomma;
								_tmp114 = NULL;
								_tmp115 = NULL;
								ccall = (_tmp115 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp114 = vala_ccode_identifier_new ("g_object_get"))), (_tmp114 == NULL) ? NULL : (_tmp114 = (vala_ccode_node_unref (_tmp114), NULL)), _tmp115);
								_tmp116 = NULL;
								_tmp117 = NULL;
								ccast = (_tmp117 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp116 = vala_ccode_identifier_new ("G_OBJECT"))), (_tmp116 == NULL) ? NULL : (_tmp116 = (vala_ccode_node_unref (_tmp116), NULL)), _tmp117);
								vala_ccode_function_call_add_argument (ccast, pub_inst);
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) ccast);
								/* property name is second argument of g_object_get*/
								_tmp118 = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp118 = vala_property_get_canonical_cconstant (prop)));
								(_tmp118 == NULL) ? NULL : (_tmp118 = (vala_ccode_node_unref (_tmp118), NULL));
								/* g_object_get always returns owned values*/
								temp_type = vala_data_type_copy (vala_expression_get_value_type ((ValaExpression*) expr));
								vala_data_type_set_value_owned (temp_type, TRUE);
								/* we need a temporary variable to save the property value*/
								temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type ((ValaExpression*) expr), TRUE, NULL);
								gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
								if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, temp_type)) {
									gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_ref_vars, 0, temp_var);
								}
								ctemp = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
								_tmp119 = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp119 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) ctemp)));
								(_tmp119 == NULL) ? NULL : (_tmp119 = (vala_ccode_node_unref (_tmp119), NULL));
								_tmp120 = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp120 = vala_ccode_constant_new ("NULL")));
								(_tmp120 == NULL) ? NULL : (_tmp120 = (vala_ccode_node_unref (_tmp120), NULL));
								ccomma = vala_ccode_comma_expression_new ();
								vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ccall);
								vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ctemp);
								vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
								(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
								(ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL));
								(temp_type == NULL) ? NULL : (temp_type = (vala_code_node_unref (temp_type), NULL));
								(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
								(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
								(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
							}
						}
						(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
					} else {
						if (VALA_IS_ENUM_VALUE (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
							ValaEnumValue* _tmp121;
							ValaEnumValue* ev;
							ValaCCodeConstant* _tmp123;
							char* _tmp122;
							_tmp121 = NULL;
							ev = (_tmp121 = VALA_ENUM_VALUE (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp121 == NULL) ? NULL : vala_code_node_ref (_tmp121));
							_tmp123 = NULL;
							_tmp122 = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp123 = vala_ccode_constant_new (_tmp122 = vala_enum_value_get_cname (ev))));
							(_tmp123 == NULL) ? NULL : (_tmp123 = (vala_ccode_node_unref (_tmp123), NULL));
							_tmp122 = (g_free (_tmp122), NULL);
							(ev == NULL) ? NULL : (ev = (vala_code_node_unref (ev), NULL));
						} else {
							if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
								ValaLocalVariable* _tmp124;
								ValaLocalVariable* local;
								ValaCCodeIdentifier* _tmp126;
								char* _tmp125;
								_tmp124 = NULL;
								local = (_tmp124 = VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp124 == NULL) ? NULL : vala_code_node_ref (_tmp124));
								_tmp126 = NULL;
								_tmp125 = NULL;
								vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp126 = vala_ccode_identifier_new (_tmp125 = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local)))));
								(_tmp126 == NULL) ? NULL : (_tmp126 = (vala_ccode_node_unref (_tmp126), NULL));
								_tmp125 = (g_free (_tmp125), NULL);
								(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
							} else {
								if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
									ValaFormalParameter* _tmp127;
									ValaFormalParameter* p;
									_tmp127 = NULL;
									p = (_tmp127 = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp127 == NULL) ? NULL : vala_code_node_ref (_tmp127));
									if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) p), "this") == 0) {
										ValaStruct* _tmp129;
										ValaTypeSymbol* _tmp128;
										ValaStruct* st;
										gboolean _tmp130;
										_tmp129 = NULL;
										_tmp128 = NULL;
										st = (_tmp129 = (_tmp128 = ((ValaCCodeBaseModule*) self)->current_type_symbol, VALA_IS_STRUCT (_tmp128) ? ((ValaStruct*) _tmp128) : NULL), (_tmp129 == NULL) ? NULL : vala_code_node_ref (_tmp129));
										_tmp130 = FALSE;
										if (st != NULL) {
											_tmp130 = !vala_struct_is_simple_type (st);
										} else {
											_tmp130 = FALSE;
										}
										if (_tmp130) {
											ValaCCodeIdentifier* _tmp131;
											_tmp131 = NULL;
											vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp131 = vala_ccode_identifier_new ("(*self)")));
											(_tmp131 == NULL) ? NULL : (_tmp131 = (vala_ccode_node_unref (_tmp131), NULL));
										} else {
											ValaCCodeIdentifier* _tmp132;
											_tmp132 = NULL;
											vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp132 = vala_ccode_identifier_new ("self")));
											(_tmp132 == NULL) ? NULL : (_tmp132 = (vala_ccode_node_unref (_tmp132), NULL));
										}
										(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
									} else {
										ValaStruct* _tmp134;
										ValaTypeSymbol* _tmp133;
										ValaStruct* type_as_struct;
										gboolean _tmp135;
										_tmp134 = NULL;
										_tmp133 = NULL;
										type_as_struct = (_tmp134 = (_tmp133 = vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (p)), VALA_IS_STRUCT (_tmp133) ? ((ValaStruct*) _tmp133) : NULL), (_tmp134 == NULL) ? NULL : vala_code_node_ref (_tmp134));
										_tmp135 = FALSE;
										if (vala_formal_parameter_get_direction (p) != VALA_PARAMETER_DIRECTION_IN) {
											_tmp135 = TRUE;
										} else {
											gboolean _tmp136;
											gboolean _tmp137;
											_tmp136 = FALSE;
											_tmp137 = FALSE;
											if (type_as_struct != NULL) {
												_tmp137 = !vala_struct_is_simple_type (type_as_struct);
											} else {
												_tmp137 = FALSE;
											}
											if (_tmp137) {
												_tmp136 = !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (p));
											} else {
												_tmp136 = FALSE;
											}
											_tmp135 = (_tmp136);
										}
										if (_tmp135) {
											ValaCCodeIdentifier* _tmp139;
											char* _tmp138;
											_tmp139 = NULL;
											_tmp138 = NULL;
											vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp139 = vala_ccode_identifier_new (_tmp138 = g_strdup_printf ("(*%s)", vala_symbol_get_name ((ValaSymbol*) p)))));
											(_tmp139 == NULL) ? NULL : (_tmp139 = (vala_ccode_node_unref (_tmp139), NULL));
											_tmp138 = (g_free (_tmp138), NULL);
										} else {
											gboolean _tmp140;
											gboolean _tmp141;
											gboolean _tmp142;
											_tmp140 = FALSE;
											_tmp141 = FALSE;
											_tmp142 = FALSE;
											if (((ValaCCodeBaseModule*) self)->current_property_accessor != NULL) {
												_tmp142 = vala_property_accessor_get_writable (((ValaCCodeBaseModule*) self)->current_property_accessor);
											} else {
												_tmp142 = FALSE;
											}
											if (_tmp142) {
												_tmp141 = vala_property_accessor_get_value_parameter (((ValaCCodeBaseModule*) self)->current_property_accessor) == p;
											} else {
												_tmp141 = FALSE;
											}
											if (_tmp141) {
												_tmp140 = vala_data_type_is_real_struct_type (vala_property_get_property_type (vala_property_accessor_get_prop (((ValaCCodeBaseModule*) self)->current_property_accessor)));
											} else {
												_tmp140 = FALSE;
											}
											/* Property setters of non simple structs shall replace all occurences
											 of the "value" formal parameter with a dereferencing version of that
											 parameter.*/
											if (_tmp140) {
												ValaCCodeIdentifier* _tmp143;
												_tmp143 = NULL;
												vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp143 = vala_ccode_identifier_new ("(*value)")));
												(_tmp143 == NULL) ? NULL : (_tmp143 = (vala_ccode_node_unref (_tmp143), NULL));
											} else {
												ValaCCodeIdentifier* _tmp144;
												_tmp144 = NULL;
												vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp144 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) p))));
												(_tmp144 == NULL) ? NULL : (_tmp144 = (vala_ccode_node_unref (_tmp144), NULL));
											}
										}
										(type_as_struct == NULL) ? NULL : (type_as_struct = (vala_code_node_unref (type_as_struct), NULL));
									}
									(p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL));
								}
							}
						}
					}
				}
			}
		}
	}
	(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
	(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
}


static void vala_ccode_member_access_module_class_init (ValaCCodeMemberAccessModuleClass * klass) {
	vala_ccode_member_access_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_member_access = vala_ccode_member_access_module_real_visit_member_access;
}


static void vala_ccode_member_access_module_instance_init (ValaCCodeMemberAccessModule * self) {
}


GType vala_ccode_member_access_module_get_type (void) {
	static GType vala_ccode_member_access_module_type_id = 0;
	if (vala_ccode_member_access_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMemberAccessModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_member_access_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMemberAccessModule), 0, (GInstanceInitFunc) vala_ccode_member_access_module_instance_init, NULL };
		vala_ccode_member_access_module_type_id = g_type_register_static (VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, "ValaCCodeMemberAccessModule", &g_define_type_info, 0);
	}
	return vala_ccode_member_access_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




