/* valanullchecker.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALANULLCHECKER_H__
#define __VALA_VALANULLCHECKER_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodevisitor.h>
#include <vala/valacodecontext.h>
#include <vala/valasourcefile.h>
#include <vala/valaclass.h>
#include <vala/valastruct.h>
#include <vala/valainterface.h>
#include <vala/valaenum.h>
#include <vala/valaerrordomain.h>
#include <vala/valafield.h>
#include <vala/valamethod.h>
#include <vala/valacreationmethod.h>
#include <vala/valaformalparameter.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valaconstructor.h>
#include <vala/valadestructor.h>
#include <vala/valablock.h>
#include <vala/valalocalvariable.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valaifstatement.h>
#include <vala/valaswitchstatement.h>
#include <vala/valaswitchsection.h>
#include <vala/valawhilestatement.h>
#include <vala/valadostatement.h>
#include <vala/valaforstatement.h>
#include <vala/valaforeachstatement.h>
#include <vala/valareturnstatement.h>
#include <vala/valayieldstatement.h>
#include <vala/valathrowstatement.h>
#include <vala/valatrystatement.h>
#include <vala/valacatchclause.h>
#include <vala/valadeletestatement.h>
#include <vala/valamethodcall.h>
#include <vala/valaelementaccess.h>
#include <vala/valapostfixexpression.h>
#include <vala/valaunaryexpression.h>
#include <vala/valareferencetransferexpression.h>
#include <vala/valalambdaexpression.h>
#include <vala/valaassignment.h>

G_BEGIN_DECLS


#define VALA_TYPE_NULL_CHECKER (vala_null_checker_get_type ())
#define VALA_NULL_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NULL_CHECKER, ValaNullChecker))
#define VALA_NULL_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NULL_CHECKER, ValaNullCheckerClass))
#define VALA_IS_NULL_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NULL_CHECKER))
#define VALA_IS_NULL_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NULL_CHECKER))
#define VALA_NULL_CHECKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NULL_CHECKER, ValaNullCheckerClass))

typedef struct _ValaNullChecker ValaNullChecker;
typedef struct _ValaNullCheckerClass ValaNullCheckerClass;
typedef struct _ValaNullCheckerPrivate ValaNullCheckerPrivate;

/**
 * Code visitor checking null references.
 */
struct _ValaNullChecker {
	ValaCodeVisitor parent_instance;
	ValaNullCheckerPrivate * priv;
};

struct _ValaNullCheckerClass {
	ValaCodeVisitorClass parent_class;
};


ValaNullChecker* vala_null_checker_construct (GType object_type);
ValaNullChecker* vala_null_checker_new (void);
void vala_null_checker_check (ValaNullChecker* self, ValaCodeContext* context);
GType vala_null_checker_get_type (void);


G_END_DECLS

#endif
