/* valamethodcall.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAMETHODCALL_H__
#define __VALA_VALAMETHODCALL_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/list.h>
#include <ccode/valaccodeexpression.h>
#include <gee/collection.h>
#include <vala/valaexpression.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_METHOD_CALL (vala_method_call_get_type ())
#define VALA_METHOD_CALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD_CALL, ValaMethodCall))
#define VALA_METHOD_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD_CALL, ValaMethodCallClass))
#define VALA_IS_METHOD_CALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD_CALL))
#define VALA_IS_METHOD_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD_CALL))
#define VALA_METHOD_CALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD_CALL, ValaMethodCallClass))

typedef struct _ValaMethodCallPrivate ValaMethodCallPrivate;

/**
 * Represents an invocation expression in the source code.
 */
struct _ValaMethodCall {
	ValaExpression parent_instance;
	ValaMethodCallPrivate * priv;
	ValaExpression* _call;
};

struct _ValaMethodCallClass {
	ValaExpressionClass parent_class;
};


ValaMethodCall* vala_method_call_construct (GType object_type, ValaExpression* call, ValaSourceReference* source_reference);
ValaMethodCall* vala_method_call_new (ValaExpression* call, ValaSourceReference* source_reference);
void vala_method_call_add_argument (ValaMethodCall* self, ValaExpression* arg);
GeeList* vala_method_call_get_argument_list (ValaMethodCall* self);
void vala_method_call_append_array_size (ValaMethodCall* self, ValaCCodeExpression* size);
GeeList* vala_method_call_get_array_sizes (ValaMethodCall* self);
ValaExpression* vala_method_call_get_call (ValaMethodCall* self);
void vala_method_call_set_call (ValaMethodCall* self, ValaExpression* value);
ValaCCodeExpression* vala_method_call_get_delegate_target (ValaMethodCall* self);
void vala_method_call_set_delegate_target (ValaMethodCall* self, ValaCCodeExpression* value);
GType vala_method_call_get_type (void);


G_END_DECLS

#endif
