/* valaarraycreationexpression.vala
 *
 * Copyright (C) 2006-2008  Raffaele Sandrini, Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaarraycreationexpression.h>
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <gee/readonlylist.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valainitializerlist.h>
#include <vala/valadatatype.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valasemanticanalyzer.h>
#include <vala/valaintegerliteral.h>
#include <vala/valareport.h>
#include <vala/valaliteral.h>
#include <vala/valaarraytype.h>




struct _ValaArrayCreationExpressionPrivate {
	gint _rank;
	GeeList* sizes;
	ValaInitializerList* _initializer_list;
	ValaDataType* _element_type;
};

#define VALA_ARRAY_CREATION_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionPrivate))
enum  {
	VALA_ARRAY_CREATION_EXPRESSION_DUMMY_PROPERTY
};
static void vala_array_creation_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_array_creation_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_array_creation_expression_real_is_pure (ValaExpression* base);
static void vala_array_creation_expression_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gint vala_array_creation_expression_create_sizes_from_initializer_list (ValaArrayCreationExpression* self, ValaSemanticAnalyzer* analyzer, ValaInitializerList* il, gint rank, GeeList* sl);
static gboolean vala_array_creation_expression_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
static gpointer vala_array_creation_expression_parent_class = NULL;
static void vala_array_creation_expression_finalize (ValaCodeNode* obj);



/**
 * Add a size expression.
 */
void vala_array_creation_expression_append_size (ValaArrayCreationExpression* self, ValaExpression* size) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (size != NULL);
	gee_collection_add ((GeeCollection*) self->priv->sizes, size);
}


/**
 * Get the sizes for all dimensions ascending from left to right.
 */
GeeList* vala_array_creation_expression_get_sizes (ValaArrayCreationExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return (GeeList*) gee_read_only_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->sizes);
}


ValaArrayCreationExpression* vala_array_creation_expression_construct (GType object_type, ValaDataType* element_type, gint rank, ValaInitializerList* initializer_list, ValaSourceReference* source_reference) {
	ValaArrayCreationExpression* self;
	g_return_val_if_fail (element_type != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaArrayCreationExpression*) g_type_create_instance (object_type);
	vala_array_creation_expression_set_element_type (self, element_type);
	vala_array_creation_expression_set_rank (self, rank);
	vala_array_creation_expression_set_initializer_list (self, initializer_list);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaArrayCreationExpression* vala_array_creation_expression_new (ValaDataType* element_type, gint rank, ValaInitializerList* initializer_list, ValaSourceReference* source_reference) {
	return vala_array_creation_expression_construct (VALA_TYPE_ARRAY_CREATION_EXPRESSION, element_type, rank, initializer_list, source_reference);
}


static void vala_array_creation_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaArrayCreationExpression * self;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	if (vala_array_creation_expression_get_element_type (self) != NULL) {
		vala_code_node_accept ((ValaCodeNode*) vala_array_creation_expression_get_element_type (self), visitor);
	}
	{
		GeeIterator* e_it;
		e_it = gee_iterable_iterator ((GeeIterable*) self->priv->sizes);
		while (gee_iterator_next (e_it)) {
			ValaExpression* e;
			e = (ValaExpression*) gee_iterator_get (e_it);
			vala_code_node_accept ((ValaCodeNode*) e, visitor);
			(e == NULL) ? NULL : (e = (vala_code_node_unref (e), NULL));
		}
		(e_it == NULL) ? NULL : (e_it = (gee_collection_object_unref (e_it), NULL));
	}
	if (self->priv->_initializer_list != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_initializer_list, visitor);
	}
}


static void vala_array_creation_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaArrayCreationExpression * self;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_array_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static gboolean vala_array_creation_expression_real_is_pure (ValaExpression* base) {
	ValaArrayCreationExpression * self;
	self = (ValaArrayCreationExpression*) base;
	return FALSE;
}


static void vala_array_creation_expression_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaArrayCreationExpression * self;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	if (vala_array_creation_expression_get_element_type (self) == old_type) {
		vala_array_creation_expression_set_element_type (self, new_type);
	}
}


static gint vala_array_creation_expression_create_sizes_from_initializer_list (ValaArrayCreationExpression* self, ValaSemanticAnalyzer* analyzer, ValaInitializerList* il, gint rank, GeeList* sl) {
	char* _tmp0;
	ValaIntegerLiteral* _tmp1;
	ValaIntegerLiteral* init;
	gint subsize;
	gint _tmp10;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (analyzer != NULL, 0);
	g_return_val_if_fail (il != NULL, 0);
	g_return_val_if_fail (sl != NULL, 0);
	_tmp0 = NULL;
	_tmp1 = NULL;
	init = (_tmp1 = vala_integer_literal_new (_tmp0 = g_strdup_printf ("%i", vala_initializer_list_get_size (il)), vala_code_node_get_source_reference ((ValaCodeNode*) il)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	vala_code_node_check ((ValaCodeNode*) init, analyzer);
	gee_collection_add ((GeeCollection*) sl, (ValaLiteral*) init);
	subsize = -1;
	{
		GeeList* _tmp2;
		GeeIterator* _tmp3;
		GeeIterator* e_it;
		_tmp2 = NULL;
		_tmp3 = NULL;
		e_it = (_tmp3 = gee_iterable_iterator ((GeeIterable*) (_tmp2 = vala_initializer_list_get_initializers (il))), (_tmp2 == NULL) ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL)), _tmp3);
		while (gee_iterator_next (e_it)) {
			ValaExpression* e;
			e = (ValaExpression*) gee_iterator_get (e_it);
			if (VALA_IS_INITIALIZER_LIST (e)) {
				gint size;
				gboolean _tmp6;
				if (rank == 1) {
					gint _tmp4;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					vala_code_node_set_error ((ValaCodeNode*) e, TRUE);
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) e), "Expected array element, got array initializer list");
					return (_tmp4 = -1, (e == NULL) ? NULL : (e = (vala_code_node_unref (e), NULL)), (e_it == NULL) ? NULL : (e_it = (gee_collection_object_unref (e_it), NULL)), (init == NULL) ? NULL : (init = (vala_code_node_unref (init), NULL)), _tmp4);
				}
				size = vala_array_creation_expression_create_sizes_from_initializer_list (self, analyzer, VALA_INITIALIZER_LIST (e), rank - 1, sl);
				if (size == (-1)) {
					gint _tmp5;
					return (_tmp5 = -1, (e == NULL) ? NULL : (e = (vala_code_node_unref (e), NULL)), (e_it == NULL) ? NULL : (e_it = (gee_collection_object_unref (e_it), NULL)), (init == NULL) ? NULL : (init = (vala_code_node_unref (init), NULL)), _tmp5);
				}
				_tmp6 = FALSE;
				if (subsize >= 0) {
					_tmp6 = subsize != size;
				} else {
					_tmp6 = FALSE;
				}
				if (_tmp6) {
					char* _tmp7;
					gint _tmp8;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp7 = NULL;
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) il), _tmp7 = g_strdup_printf ("Expected initializer list of size %d, got size %d", subsize, size));
					_tmp7 = (g_free (_tmp7), NULL);
					return (_tmp8 = -1, (e == NULL) ? NULL : (e = (vala_code_node_unref (e), NULL)), (e_it == NULL) ? NULL : (e_it = (gee_collection_object_unref (e_it), NULL)), (init == NULL) ? NULL : (init = (vala_code_node_unref (init), NULL)), _tmp8);
				} else {
					subsize = size;
				}
			} else {
				if (rank != 1) {
					gint _tmp9;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					vala_code_node_set_error ((ValaCodeNode*) e, TRUE);
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) e), "Expected array initializer list, got array element");
					return (_tmp9 = -1, (e == NULL) ? NULL : (e = (vala_code_node_unref (e), NULL)), (e_it == NULL) ? NULL : (e_it = (gee_collection_object_unref (e_it), NULL)), (init == NULL) ? NULL : (init = (vala_code_node_unref (init), NULL)), _tmp9);
				}
			}
			(e == NULL) ? NULL : (e = (vala_code_node_unref (e), NULL));
		}
		(e_it == NULL) ? NULL : (e_it = (gee_collection_object_unref (e_it), NULL));
	}
	return (_tmp10 = vala_initializer_list_get_size (il), (init == NULL) ? NULL : (init = (vala_code_node_unref (init), NULL)), _tmp10);
}


static gboolean vala_array_creation_expression_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaArrayCreationExpression * self;
	GeeList* size;
	ValaInitializerList* _tmp1;
	ValaInitializerList* initlist;
	GeeArrayList* calc_sizes;
	gboolean _tmp5;
	ValaArrayType* _tmp8;
	gboolean _tmp9;
	self = (ValaArrayCreationExpression*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		return !vala_code_node_get_error ((ValaCodeNode*) self);
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	size = vala_array_creation_expression_get_sizes (self);
	_tmp1 = NULL;
	initlist = (_tmp1 = self->priv->_initializer_list, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	if (vala_array_creation_expression_get_element_type (self) != NULL) {
		vala_code_node_check ((ValaCodeNode*) vala_array_creation_expression_get_element_type (self), analyzer);
	}
	{
		GeeIterator* e_it;
		e_it = gee_iterable_iterator ((GeeIterable*) size);
		while (gee_iterator_next (e_it)) {
			ValaExpression* e;
			e = (ValaExpression*) gee_iterator_get (e_it);
			vala_code_node_check ((ValaCodeNode*) e, analyzer);
			(e == NULL) ? NULL : (e = (vala_code_node_unref (e), NULL));
		}
		(e_it == NULL) ? NULL : (e_it = (gee_collection_object_unref (e_it), NULL));
	}
	calc_sizes = gee_array_list_new (VALA_TYPE_LITERAL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	if (initlist != NULL) {
		ValaArrayType* _tmp2;
		gint ret;
		_tmp2 = NULL;
		vala_expression_set_target_type ((ValaExpression*) initlist, (ValaDataType*) (_tmp2 = vala_array_type_new (vala_array_creation_expression_get_element_type (self), self->priv->_rank, vala_code_node_get_source_reference ((ValaCodeNode*) self))));
		(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL));
		vala_code_node_check ((ValaCodeNode*) initlist, analyzer);
		ret = vala_array_creation_expression_create_sizes_from_initializer_list (self, analyzer, initlist, self->priv->_rank, (GeeList*) calc_sizes);
		if (ret == (-1)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
	}
	if (gee_collection_get_size ((GeeCollection*) size) > 0) {
		/* check for errors in the size list */
		{
			GeeIterator* e_it;
			/* check for errors in the size list */
			e_it = gee_iterable_iterator ((GeeIterable*) size);
			/* check for errors in the size list */
			while (gee_iterator_next (e_it)) {
				ValaExpression* e;
				/* check for errors in the size list */
				e = (ValaExpression*) gee_iterator_get (e_it);
				if (vala_expression_get_value_type (e) == NULL) {
					gboolean _tmp3;
					/* return on previous error */
					return (_tmp3 = FALSE, (e == NULL) ? NULL : (e = (vala_code_node_unref (e), NULL)), (e_it == NULL) ? NULL : (e_it = (gee_collection_object_unref (e_it), NULL)), (size == NULL) ? NULL : (size = (gee_collection_object_unref (size), NULL)), (initlist == NULL) ? NULL : (initlist = (vala_code_node_unref (initlist), NULL)), (calc_sizes == NULL) ? NULL : (calc_sizes = (gee_collection_object_unref (calc_sizes), NULL)), _tmp3);
				} else {
					if (!vala_data_type_compatible (vala_expression_get_value_type (e), analyzer->uint64_type)) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) e), "Expression of integer type expected");
					}
				}
				(e == NULL) ? NULL : (e = (vala_code_node_unref (e), NULL));
			}
			(e_it == NULL) ? NULL : (e_it = (gee_collection_object_unref (e_it), NULL));
		}
	} else {
		if (initlist == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			/* this is an internal error because it is already handeld by the parser */
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "internal error: initializer list expected");
		} else {
			{
				GeeIterator* size_it;
				size_it = gee_iterable_iterator ((GeeIterable*) calc_sizes);
				while (gee_iterator_next (size_it)) {
					ValaExpression* size;
					size = (ValaExpression*) ((ValaLiteral*) gee_iterator_get (size_it));
					vala_array_creation_expression_append_size (self, size);
					(size == NULL) ? NULL : (size = (vala_code_node_unref (size), NULL));
				}
				(size_it == NULL) ? NULL : (size_it = (gee_collection_object_unref (size_it), NULL));
			}
		}
	}
	if (vala_code_node_get_error ((ValaCodeNode*) self)) {
		gboolean _tmp4;
		return (_tmp4 = FALSE, (size == NULL) ? NULL : (size = (gee_collection_object_unref (size), NULL)), (initlist == NULL) ? NULL : (initlist = (vala_code_node_unref (initlist), NULL)), (calc_sizes == NULL) ? NULL : (calc_sizes = (gee_collection_object_unref (calc_sizes), NULL)), _tmp4);
	}
	_tmp5 = FALSE;
	if (self->priv->_initializer_list != NULL) {
		_tmp5 = vala_expression_get_value_type ((ValaExpression*) self->priv->_initializer_list) == NULL;
	} else {
		_tmp5 = FALSE;
	}
	/* check for wrong elements inside the initializer */
	if (_tmp5) {
		gboolean _tmp6;
		return (_tmp6 = FALSE, (size == NULL) ? NULL : (size = (gee_collection_object_unref (size), NULL)), (initlist == NULL) ? NULL : (initlist = (vala_code_node_unref (initlist), NULL)), (calc_sizes == NULL) ? NULL : (calc_sizes = (gee_collection_object_unref (calc_sizes), NULL)), _tmp6);
	}
	/* try to construct the type of the array */
	if (vala_array_creation_expression_get_element_type (self) == NULL) {
		gboolean _tmp7;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Cannot determine the element type of the created array");
		return (_tmp7 = FALSE, (size == NULL) ? NULL : (size = (gee_collection_object_unref (size), NULL)), (initlist == NULL) ? NULL : (initlist = (vala_code_node_unref (initlist), NULL)), (calc_sizes == NULL) ? NULL : (calc_sizes = (gee_collection_object_unref (calc_sizes), NULL)), _tmp7);
	}
	vala_data_type_set_value_owned (vala_array_creation_expression_get_element_type (self), TRUE);
	_tmp8 = NULL;
	vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) (_tmp8 = vala_array_type_new (vala_array_creation_expression_get_element_type (self), self->priv->_rank, vala_code_node_get_source_reference ((ValaCodeNode*) self))));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_code_node_unref (_tmp8), NULL));
	vala_data_type_set_value_owned (vala_expression_get_value_type ((ValaExpression*) self), TRUE);
	return (_tmp9 = !vala_code_node_get_error ((ValaCodeNode*) self), (size == NULL) ? NULL : (size = (gee_collection_object_unref (size), NULL)), (initlist == NULL) ? NULL : (initlist = (vala_code_node_unref (initlist), NULL)), (calc_sizes == NULL) ? NULL : (calc_sizes = (gee_collection_object_unref (calc_sizes), NULL)), _tmp9);
}


ValaDataType* vala_array_creation_expression_get_element_type (ValaArrayCreationExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_element_type;
}


void vala_array_creation_expression_set_element_type (ValaArrayCreationExpression* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_element_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_element_type == NULL) ? NULL : (self->priv->_element_type = (vala_code_node_unref (self->priv->_element_type), NULL)), _tmp2);
	vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_element_type, (ValaCodeNode*) self);
}


gint vala_array_creation_expression_get_rank (ValaArrayCreationExpression* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_rank;
}


void vala_array_creation_expression_set_rank (ValaArrayCreationExpression* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_rank = value;
}


ValaInitializerList* vala_array_creation_expression_get_initializer_list (ValaArrayCreationExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_initializer_list;
}


void vala_array_creation_expression_set_initializer_list (ValaArrayCreationExpression* self, ValaInitializerList* value) {
	ValaInitializerList* _tmp2;
	ValaInitializerList* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_initializer_list = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_initializer_list == NULL) ? NULL : (self->priv->_initializer_list = (vala_code_node_unref (self->priv->_initializer_list), NULL)), _tmp2);
}


static void vala_array_creation_expression_class_init (ValaArrayCreationExpressionClass * klass) {
	vala_array_creation_expression_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_array_creation_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaArrayCreationExpressionPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_array_creation_expression_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_array_creation_expression_real_accept;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_array_creation_expression_real_is_pure;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_array_creation_expression_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->check = vala_array_creation_expression_real_check;
}


static void vala_array_creation_expression_instance_init (ValaArrayCreationExpression * self) {
	self->priv = VALA_ARRAY_CREATION_EXPRESSION_GET_PRIVATE (self);
	self->priv->sizes = (GeeList*) gee_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
}


static void vala_array_creation_expression_finalize (ValaCodeNode* obj) {
	ValaArrayCreationExpression * self;
	self = VALA_ARRAY_CREATION_EXPRESSION (obj);
	(self->priv->sizes == NULL) ? NULL : (self->priv->sizes = (gee_collection_object_unref (self->priv->sizes), NULL));
	(self->priv->_initializer_list == NULL) ? NULL : (self->priv->_initializer_list = (vala_code_node_unref (self->priv->_initializer_list), NULL));
	(self->priv->_element_type == NULL) ? NULL : (self->priv->_element_type = (vala_code_node_unref (self->priv->_element_type), NULL));
	VALA_CODE_NODE_CLASS (vala_array_creation_expression_parent_class)->finalize (obj);
}


GType vala_array_creation_expression_get_type (void) {
	static GType vala_array_creation_expression_type_id = 0;
	if (vala_array_creation_expression_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayCreationExpression), 0, (GInstanceInitFunc) vala_array_creation_expression_instance_init, NULL };
		vala_array_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaArrayCreationExpression", &g_define_type_info, 0);
	}
	return vala_array_creation_expression_type_id;
}




