/* valaccodeenum.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeenum.h>
#include <gee/arraylist.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <ccode/valaccodelinedirective.h>




struct _ValaCCodeEnumPrivate {
	char* _name;
	GeeList* values;
};

#define VALA_CCODE_ENUM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_ENUM, ValaCCodeEnumPrivate))
enum  {
	VALA_CCODE_ENUM_DUMMY_PROPERTY
};
static void vala_ccode_enum_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_enum_parent_class = NULL;
static void vala_ccode_enum_finalize (ValaCCodeNode* obj);



ValaCCodeEnum* vala_ccode_enum_construct (GType object_type, const char* name) {
	ValaCCodeEnum* self;
	self = (ValaCCodeEnum*) g_type_create_instance (object_type);
	vala_ccode_enum_set_name (self, name);
	return self;
}


ValaCCodeEnum* vala_ccode_enum_new (const char* name) {
	return vala_ccode_enum_construct (VALA_TYPE_CCODE_ENUM, name);
}


/**
 * Adds the specified value to this enum.
 *
 * @param name  enum value name
 * @param value optional numerical value
 */
void vala_ccode_enum_add_value (ValaCCodeEnum* self, ValaCCodeEnumValue* value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	gee_collection_add ((GeeCollection*) self->priv->values, value);
}


static void vala_ccode_enum_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeEnum * self;
	gboolean first;
	self = (ValaCCodeEnum*) base;
	g_return_if_fail (writer != NULL);
	if (self->priv->_name != NULL) {
		vala_ccode_writer_write_string (writer, "typedef ");
	}
	vala_ccode_writer_write_string (writer, "enum ");
	vala_ccode_writer_write_begin_block (writer);
	first = TRUE;
	{
		GeeIterator* value_it;
		value_it = gee_iterable_iterator ((GeeIterable*) self->priv->values);
		while (gee_iterator_next (value_it)) {
			ValaCCodeEnumValue* value;
			value = (ValaCCodeEnumValue*) gee_iterator_get (value_it);
			if (!first) {
				vala_ccode_writer_write_string (writer, ",");
				vala_ccode_writer_write_newline (writer);
			}
			vala_ccode_writer_write_indent (writer, NULL);
			vala_ccode_node_write ((ValaCCodeNode*) value, writer);
			first = FALSE;
			(value == NULL) ? NULL : (value = (vala_ccode_node_unref (value), NULL));
		}
		(value_it == NULL) ? NULL : (value_it = (gee_collection_object_unref (value_it), NULL));
	}
	if (!first) {
		vala_ccode_writer_write_newline (writer);
	}
	vala_ccode_writer_write_end_block (writer);
	if (self->priv->_name != NULL) {
		vala_ccode_writer_write_string (writer, " ");
		vala_ccode_writer_write_string (writer, self->priv->_name);
	}
	vala_ccode_writer_write_string (writer, ";");
	vala_ccode_writer_write_newline (writer);
}


const char* vala_ccode_enum_get_name (ValaCCodeEnum* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_name;
}


void vala_ccode_enum_set_name (ValaCCodeEnum* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_name = (g_free (self->priv->_name), NULL), _tmp2);
}


static void vala_ccode_enum_class_init (ValaCCodeEnumClass * klass) {
	vala_ccode_enum_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_enum_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeEnumPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_enum_real_write;
}


static void vala_ccode_enum_instance_init (ValaCCodeEnum * self) {
	self->priv = VALA_CCODE_ENUM_GET_PRIVATE (self);
	self->priv->values = (GeeList*) gee_array_list_new (VALA_TYPE_CCODE_ENUM_VALUE, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_equal);
}


static void vala_ccode_enum_finalize (ValaCCodeNode* obj) {
	ValaCCodeEnum * self;
	self = VALA_CCODE_ENUM (obj);
	self->priv->_name = (g_free (self->priv->_name), NULL);
	(self->priv->values == NULL) ? NULL : (self->priv->values = (gee_collection_object_unref (self->priv->values), NULL));
	VALA_CCODE_NODE_CLASS (vala_ccode_enum_parent_class)->finalize (obj);
}


GType vala_ccode_enum_get_type (void) {
	static GType vala_ccode_enum_type_id = 0;
	if (vala_ccode_enum_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeEnumClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_enum_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeEnum), 0, (GInstanceInitFunc) vala_ccode_enum_instance_init, NULL };
		vala_ccode_enum_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeEnum", &g_define_type_info, 0);
	}
	return vala_ccode_enum_type_id;
}




