/* valadbusservermodule.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
*  Copyright (C) 2008  Philip Van Hoof
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Philip Van Hoof <pvanhoof@gnome.org>
 */

#include <gobject/valadbusservermodule.h>
#include <vala/valacodenode.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valaattribute.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valamethod.h>
#include <vala/valacreationmethod.h>
#include <vala/valamember.h>
#include <vala/valasymbol.h>
#include <gee/arraylist.h>
#include <vala/valaformalparameter.h>
#include <gee/collection.h>
#include <vala/valavoidtype.h>
#include <vala/valapointertype.h>
#include <vala/valadatatype.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeformalparameter.h>
#include <vala/valatypesymbol.h>
#include <vala/valaarraytype.h>
#include <gee/list.h>
#include <ccode/valaccodeblock.h>
#include <vala/valastruct.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodenode.h>
#include <vala/valafield.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeelementaccess.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeinitializerlist.h>
#include <vala/valaenum.h>
#include <ccode/valaccodeforstatement.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodereturnstatement.h>
#include <vala/valareport.h>
#include <vala/valasignal.h>
#include <vala/valaproperty.h>
#include <gobject/valaccodebasemodule.h>




enum  {
	VALA_DBUS_SERVER_MODULE_DUMMY_PROPERTY
};
static gboolean vala_dbus_server_module_is_dbus_visible (ValaDBusServerModule* self, ValaCodeNode* node);
static char* vala_dbus_server_module_dbus_result_name (ValaDBusServerModule* self, ValaCodeNode* node);
static ValaCCodeFragment* vala_dbus_server_module_real_register_dbus_info (ValaCCodeModule* base, ValaObjectTypeSymbol* bindable);
static void vala_dbus_server_module_transform_struct_to_value_array (ValaDBusServerModule* self, ValaCCodeBlock* block, ValaStruct* st, ValaCCodeExpression* target, ValaCCodeExpression* st_expr, const char* name);
static void vala_dbus_server_module_transform_struct_hash_table_to_value_array_hash_table (ValaDBusServerModule* self, ValaCCodeBlock* block, ValaStruct* st, ValaCCodeExpression* target, ValaCCodeExpression* table_expr, const char* name);
static char* vala_dbus_server_module_generate_dbus_wrapper (ValaDBusServerModule* self, ValaMethod* m, ValaObjectTypeSymbol* bindable);
static gpointer vala_dbus_server_module_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaDBusServerModule* vala_dbus_server_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaDBusServerModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaDBusServerModule*) vala_dbus_client_module_construct (object_type, codegen, next);
	return self;
}


ValaDBusServerModule* vala_dbus_server_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_dbus_server_module_construct (VALA_TYPE_DBUS_SERVER_MODULE, codegen, next);
}


static gboolean vala_dbus_server_module_is_dbus_visible (ValaDBusServerModule* self, ValaCodeNode* node) {
	ValaAttribute* dbus_attribute;
	gboolean _tmp0;
	gboolean _tmp1;
	gboolean _tmp3;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	dbus_attribute = vala_code_node_get_attribute (node, "DBus");
	_tmp0 = FALSE;
	_tmp1 = FALSE;
	if (dbus_attribute != NULL) {
		_tmp1 = vala_attribute_has_argument (dbus_attribute, "visible");
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		_tmp0 = !vala_attribute_get_bool (dbus_attribute, "visible");
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		gboolean _tmp2;
		return (_tmp2 = FALSE, (dbus_attribute == NULL) ? NULL : (dbus_attribute = (vala_code_node_unref (dbus_attribute), NULL)), _tmp2);
	}
	return (_tmp3 = TRUE, (dbus_attribute == NULL) ? NULL : (dbus_attribute = (vala_code_node_unref (dbus_attribute), NULL)), _tmp3);
}


static char* vala_dbus_server_module_dbus_result_name (ValaDBusServerModule* self, ValaCodeNode* node) {
	ValaAttribute* dbus_attribute;
	gboolean _tmp0;
	char* _tmp3;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	dbus_attribute = vala_code_node_get_attribute (node, "DBus");
	_tmp0 = FALSE;
	if (dbus_attribute != NULL) {
		_tmp0 = vala_attribute_has_argument (dbus_attribute, "result");
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		char* result_name;
		gboolean _tmp1;
		result_name = vala_attribute_get_string (dbus_attribute, "result");
		_tmp1 = FALSE;
		if (result_name != NULL) {
			_tmp1 = _vala_strcmp0 (result_name, "") != 0;
		} else {
			_tmp1 = FALSE;
		}
		if (_tmp1) {
			char* _tmp2;
			_tmp2 = NULL;
			return (_tmp2 = result_name, (dbus_attribute == NULL) ? NULL : (dbus_attribute = (vala_code_node_unref (dbus_attribute), NULL)), _tmp2);
		}
		result_name = (g_free (result_name), NULL);
	}
	_tmp3 = NULL;
	return (_tmp3 = g_strdup ("result"), (dbus_attribute == NULL) ? NULL : (dbus_attribute = (vala_code_node_unref (dbus_attribute), NULL)), _tmp3);
}


static ValaCCodeFragment* vala_dbus_server_module_real_register_dbus_info (ValaCCodeModule* base, ValaObjectTypeSymbol* bindable) {
	ValaDBusServerModule * self;
	ValaCCodeFragment* fragment;
	ValaAttribute* dbus;
	char* dbus_iface_name;
	GString* dbus_methods;
	GString* blob;
	gint method_count;
	glong blob_len;
	GString* dbus_signals;
	GString* dbus_props;
	ValaCCodeDeclaration* dbus_methods_decl;
	ValaCCodeVariableDeclarator* _tmp31;
	ValaCCodeConstant* _tmp30;
	char* _tmp29;
	char* _tmp28;
	ValaCCodeDeclaration* dbus_object_info;
	ValaCCodeVariableDeclarator* _tmp37;
	ValaCCodeConstant* _tmp36;
	char* _tmp35;
	char* _tmp34;
	char* _tmp33;
	char* _tmp32;
	ValaCCodeIdentifier* _tmp38;
	ValaCCodeFunctionCall* _tmp39;
	ValaCCodeFunctionCall* install_call;
	ValaCCodeIdentifier* _tmp41;
	char* _tmp40;
	ValaCCodeUnaryExpression* _tmp45;
	ValaCCodeIdentifier* _tmp44;
	char* _tmp43;
	char* _tmp42;
	ValaCCodeExpressionStatement* _tmp46;
	ValaCCodeFragment* _tmp47;
	self = (ValaDBusServerModule*) base;
	g_return_val_if_fail (bindable != NULL, NULL);
	fragment = vala_ccode_fragment_new ();
	dbus = vala_code_node_get_attribute ((ValaCodeNode*) bindable, "DBus");
	if (dbus == NULL) {
		ValaCCodeFragment* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = fragment, (dbus == NULL) ? NULL : (dbus = (vala_code_node_unref (dbus), NULL)), _tmp0);
	}
	dbus_iface_name = vala_attribute_get_string (dbus, "name");
	if (dbus_iface_name == NULL) {
		ValaCCodeFragment* _tmp1;
		_tmp1 = NULL;
		return (_tmp1 = fragment, (dbus == NULL) ? NULL : (dbus = (vala_code_node_unref (dbus), NULL)), dbus_iface_name = (g_free (dbus_iface_name), NULL), _tmp1);
	}
	((ValaCCodeBaseModule*) self)->dbus_glib_h_needed = TRUE;
	dbus_methods = g_string_new ("");
	g_string_append (dbus_methods, "{\n");
	blob = g_string_new ("");
	g_string_append_c (blob, '"');
	method_count = 0;
	blob_len = (glong) 0;
	{
		GeeList* _tmp2;
		GeeIterator* _tmp3;
		GeeIterator* m_it;
		_tmp2 = NULL;
		_tmp3 = NULL;
		m_it = (_tmp3 = gee_iterable_iterator ((GeeIterable*) (_tmp2 = vala_object_type_symbol_get_methods (bindable))), (_tmp2 == NULL) ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL)), _tmp3);
		while (gee_iterator_next (m_it)) {
			ValaMethod* m;
			gboolean _tmp4;
			gboolean _tmp5;
			gboolean _tmp6;
			GeeArrayList* parameters;
			ValaFormalParameter* _tmp12;
			char* _tmp13;
			char* _tmp14;
			char* _tmp15;
			glong start;
			char* _tmp16;
			m = (ValaMethod*) gee_iterator_get (m_it);
			_tmp4 = FALSE;
			_tmp5 = FALSE;
			_tmp6 = FALSE;
			if (VALA_IS_CREATION_METHOD (m)) {
				_tmp6 = TRUE;
			} else {
				_tmp6 = vala_method_get_binding (m) != MEMBER_BINDING_INSTANCE;
			}
			if (_tmp6) {
				_tmp5 = TRUE;
			} else {
				_tmp5 = vala_method_get_overrides (m);
			}
			if (_tmp5) {
				_tmp4 = TRUE;
			} else {
				_tmp4 = vala_symbol_get_access ((ValaSymbol*) m) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
			}
			if (_tmp4) {
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				continue;
			}
			if (!vala_dbus_server_module_is_dbus_visible (self, (ValaCodeNode*) m)) {
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				continue;
			}
			parameters = gee_array_list_new (VALA_TYPE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
			{
				GeeList* _tmp7;
				GeeIterator* _tmp8;
				GeeIterator* param_it;
				_tmp7 = NULL;
				_tmp8 = NULL;
				param_it = (_tmp8 = gee_iterable_iterator ((GeeIterable*) (_tmp7 = vala_method_get_parameters (m))), (_tmp7 == NULL) ? NULL : (_tmp7 = (gee_collection_object_unref (_tmp7), NULL)), _tmp8);
				while (gee_iterator_next (param_it)) {
					ValaFormalParameter* param;
					param = (ValaFormalParameter*) gee_iterator_get (param_it);
					gee_collection_add ((GeeCollection*) parameters, param);
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				}
				(param_it == NULL) ? NULL : (param_it = (gee_collection_object_unref (param_it), NULL));
			}
			if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
				ValaFormalParameter* _tmp11;
				ValaPointerType* _tmp10;
				ValaVoidType* _tmp9;
				_tmp11 = NULL;
				_tmp10 = NULL;
				_tmp9 = NULL;
				gee_collection_add ((GeeCollection*) parameters, _tmp11 = vala_formal_parameter_new ("result", (ValaDataType*) (_tmp10 = vala_pointer_type_new ((ValaDataType*) (_tmp9 = vala_void_type_new ()), NULL)), NULL));
				(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_code_node_unref (_tmp11), NULL));
				(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_code_node_unref (_tmp10), NULL));
				(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_code_node_unref (_tmp9), NULL));
			}
			_tmp12 = NULL;
			gee_collection_add ((GeeCollection*) parameters, _tmp12 = vala_formal_parameter_new ("error", (ValaDataType*) ((ValaCCodeBaseModule*) self)->gerror_type, NULL));
			(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_code_node_unref (_tmp12), NULL));
			g_string_append (dbus_methods, "{ (GCallback) ");
			_tmp13 = NULL;
			g_string_append (dbus_methods, _tmp13 = vala_dbus_server_module_generate_dbus_wrapper (self, m, bindable));
			_tmp13 = (g_free (_tmp13), NULL);
			g_string_append (dbus_methods, ", ");
			_tmp14 = NULL;
			g_string_append (dbus_methods, _tmp14 = vala_ccode_module_get_marshaller_function (vala_ccode_module_get_head ((ValaCCodeModule*) self), (GeeList*) parameters, ((ValaCCodeBaseModule*) self)->bool_type, NULL, TRUE));
			_tmp14 = (g_free (_tmp14), NULL);
			g_string_append (dbus_methods, ", ");
			_tmp15 = NULL;
			g_string_append (dbus_methods, _tmp15 = g_strdup_printf ("%li", blob_len));
			_tmp15 = (g_free (_tmp15), NULL);
			g_string_append (dbus_methods, " },\n");
			vala_ccode_module_generate_marshaller (vala_ccode_module_get_head ((ValaCCodeModule*) self), (GeeList*) parameters, ((ValaCCodeBaseModule*) self)->bool_type, TRUE);
			start = blob->len;
			g_string_append (blob, dbus_iface_name);
			g_string_append (blob, "\\0");
			start++;
			_tmp16 = NULL;
			g_string_append (blob, _tmp16 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name ((ValaSymbol*) m)));
			_tmp16 = (g_free (_tmp16), NULL);
			g_string_append (blob, "\\0");
			start++;
			/* synchronous*/
			g_string_append (blob, "S\\0");
			start++;
			{
				GeeList* _tmp17;
				GeeIterator* _tmp18;
				GeeIterator* param_it;
				_tmp17 = NULL;
				_tmp18 = NULL;
				param_it = (_tmp18 = gee_iterable_iterator ((GeeIterable*) (_tmp17 = vala_method_get_parameters (m))), (_tmp17 == NULL) ? NULL : (_tmp17 = (gee_collection_object_unref (_tmp17), NULL)), _tmp18);
				while (gee_iterator_next (param_it)) {
					ValaFormalParameter* param;
					char* _tmp19;
					param = (ValaFormalParameter*) gee_iterator_get (param_it);
					g_string_append (blob, vala_symbol_get_name ((ValaSymbol*) param));
					g_string_append (blob, "\\0");
					start++;
					if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
						g_string_append (blob, "I\\0");
						start++;
					} else {
						if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
							g_string_append (blob, "O\\0");
							start++;
							g_string_append (blob, "F\\0");
							start++;
							g_string_append (blob, "N\\0");
							start++;
						} else {
							vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) param), "unsupported parameter direction for D-Bus method");
						}
					}
					_tmp19 = NULL;
					g_string_append (blob, _tmp19 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param)));
					_tmp19 = (g_free (_tmp19), NULL);
					g_string_append (blob, "\\0");
					start++;
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				}
				(param_it == NULL) ? NULL : (param_it = (gee_collection_object_unref (param_it), NULL));
			}
			if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
				char* _tmp20;
				char* _tmp21;
				_tmp20 = NULL;
				g_string_append (blob, _tmp20 = vala_dbus_server_module_dbus_result_name (self, (ValaCodeNode*) m));
				_tmp20 = (g_free (_tmp20), NULL);
				g_string_append (blob, "\\0");
				start++;
				g_string_append (blob, "O\\0");
				start++;
				g_string_append (blob, "F\\0");
				start++;
				g_string_append (blob, "N\\0");
				start++;
				_tmp21 = NULL;
				g_string_append (blob, _tmp21 = vala_data_type_get_type_signature (vala_method_get_return_type (m)));
				_tmp21 = (g_free (_tmp21), NULL);
				g_string_append (blob, "\\0");
				start++;
			}
			g_string_append (blob, "\\0");
			start++;
			blob_len = blob_len + (blob->len - start);
			method_count++;
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
			(parameters == NULL) ? NULL : (parameters = (gee_collection_object_unref (parameters), NULL));
		}
		(m_it == NULL) ? NULL : (m_it = (gee_collection_object_unref (m_it), NULL));
	}
	g_string_append_c (blob, '"');
	g_string_append (dbus_methods, "}\n");
	dbus_signals = g_string_new ("");
	g_string_append_c (dbus_signals, '"');
	{
		GeeList* _tmp22;
		GeeIterator* _tmp23;
		GeeIterator* sig_it;
		_tmp22 = NULL;
		_tmp23 = NULL;
		sig_it = (_tmp23 = gee_iterable_iterator ((GeeIterable*) (_tmp22 = vala_object_type_symbol_get_signals (bindable))), (_tmp22 == NULL) ? NULL : (_tmp22 = (gee_collection_object_unref (_tmp22), NULL)), _tmp23);
		while (gee_iterator_next (sig_it)) {
			ValaSignal* sig;
			char* _tmp24;
			sig = (ValaSignal*) gee_iterator_get (sig_it);
			if (vala_symbol_get_access ((ValaSymbol*) sig) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
				(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
				continue;
			}
			if (!vala_dbus_server_module_is_dbus_visible (self, (ValaCodeNode*) sig)) {
				(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
				continue;
			}
			g_string_append (dbus_signals, dbus_iface_name);
			g_string_append (dbus_signals, "\\0");
			_tmp24 = NULL;
			g_string_append (dbus_signals, _tmp24 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name ((ValaSymbol*) sig)));
			_tmp24 = (g_free (_tmp24), NULL);
			g_string_append (dbus_signals, "\\0");
			(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
		}
		(sig_it == NULL) ? NULL : (sig_it = (gee_collection_object_unref (sig_it), NULL));
	}
	g_string_append_c (dbus_signals, '"');
	dbus_props = g_string_new ("");
	g_string_append_c (dbus_props, '"');
	{
		GeeList* _tmp25;
		GeeIterator* _tmp26;
		GeeIterator* prop_it;
		_tmp25 = NULL;
		_tmp26 = NULL;
		prop_it = (_tmp26 = gee_iterable_iterator ((GeeIterable*) (_tmp25 = vala_object_type_symbol_get_properties (bindable))), (_tmp25 == NULL) ? NULL : (_tmp25 = (gee_collection_object_unref (_tmp25), NULL)), _tmp26);
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			char* _tmp27;
			prop = (ValaProperty*) gee_iterator_get (prop_it);
			if (vala_symbol_get_access ((ValaSymbol*) prop) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			if (!vala_dbus_server_module_is_dbus_visible (self, (ValaCodeNode*) prop)) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			g_string_append (dbus_props, dbus_iface_name);
			g_string_append (dbus_props, "\\0");
			_tmp27 = NULL;
			g_string_append (dbus_props, _tmp27 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name ((ValaSymbol*) prop)));
			_tmp27 = (g_free (_tmp27), NULL);
			g_string_append (dbus_props, "\\0");
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
		}
		(prop_it == NULL) ? NULL : (prop_it = (gee_collection_object_unref (prop_it), NULL));
	}
	g_string_append_c (dbus_props, '"');
	dbus_methods_decl = vala_ccode_declaration_new ("const DBusGMethodInfo");
	vala_ccode_declaration_set_modifiers (dbus_methods_decl, VALA_CCODE_MODIFIERS_STATIC);
	_tmp31 = NULL;
	_tmp30 = NULL;
	_tmp29 = NULL;
	_tmp28 = NULL;
	vala_ccode_declaration_add_declarator (dbus_methods_decl, (ValaCCodeDeclarator*) (_tmp31 = vala_ccode_variable_declarator_new_with_initializer (_tmp29 = g_strdup_printf ("%s_dbus_methods[]", _tmp28 = vala_symbol_get_lower_case_cname ((ValaSymbol*) bindable, NULL)), (ValaCCodeExpression*) (_tmp30 = vala_ccode_constant_new (dbus_methods->str)))));
	(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
	_tmp29 = (g_free (_tmp29), NULL);
	_tmp28 = (g_free (_tmp28), NULL);
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) dbus_methods_decl);
	dbus_object_info = vala_ccode_declaration_new ("const DBusGObjectInfo");
	vala_ccode_declaration_set_modifiers (dbus_object_info, VALA_CCODE_MODIFIERS_STATIC);
	_tmp37 = NULL;
	_tmp36 = NULL;
	_tmp35 = NULL;
	_tmp34 = NULL;
	_tmp33 = NULL;
	_tmp32 = NULL;
	vala_ccode_declaration_add_declarator (dbus_object_info, (ValaCCodeDeclarator*) (_tmp37 = vala_ccode_variable_declarator_new_with_initializer (_tmp33 = g_strdup_printf ("%s_dbus_object_info", _tmp32 = vala_symbol_get_lower_case_cname ((ValaSymbol*) bindable, NULL)), (ValaCCodeExpression*) (_tmp36 = vala_ccode_constant_new (_tmp35 = g_strdup_printf ("{ 0, %s_dbus_methods, %d, %s, %s, %s }", _tmp34 = vala_symbol_get_lower_case_cname ((ValaSymbol*) bindable, NULL), method_count, blob->str, dbus_signals->str, dbus_props->str))))));
	(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
	_tmp35 = (g_free (_tmp35), NULL);
	_tmp34 = (g_free (_tmp34), NULL);
	_tmp33 = (g_free (_tmp33), NULL);
	_tmp32 = (g_free (_tmp32), NULL);
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) dbus_object_info);
	_tmp38 = NULL;
	_tmp39 = NULL;
	install_call = (_tmp39 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp38 = vala_ccode_identifier_new ("dbus_g_object_type_install_info"))), (_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL)), _tmp39);
	_tmp41 = NULL;
	_tmp40 = NULL;
	vala_ccode_function_call_add_argument (install_call, (ValaCCodeExpression*) (_tmp41 = vala_ccode_identifier_new (_tmp40 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) bindable))));
	(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
	_tmp40 = (g_free (_tmp40), NULL);
	_tmp45 = NULL;
	_tmp44 = NULL;
	_tmp43 = NULL;
	_tmp42 = NULL;
	vala_ccode_function_call_add_argument (install_call, (ValaCCodeExpression*) (_tmp45 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp44 = vala_ccode_identifier_new (_tmp43 = g_strdup_printf ("%s_dbus_object_info", _tmp42 = vala_symbol_get_lower_case_cname ((ValaSymbol*) bindable, NULL)))))));
	(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
	(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
	_tmp43 = (g_free (_tmp43), NULL);
	_tmp42 = (g_free (_tmp42), NULL);
	_tmp46 = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp46 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) install_call)));
	(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
	_tmp47 = NULL;
	return (_tmp47 = fragment, (dbus == NULL) ? NULL : (dbus = (vala_code_node_unref (dbus), NULL)), dbus_iface_name = (g_free (dbus_iface_name), NULL), (dbus_methods == NULL) ? NULL : (dbus_methods = (g_string_free (dbus_methods, TRUE), NULL)), (blob == NULL) ? NULL : (blob = (g_string_free (blob, TRUE), NULL)), (dbus_signals == NULL) ? NULL : (dbus_signals = (g_string_free (dbus_signals, TRUE), NULL)), (dbus_props == NULL) ? NULL : (dbus_props = (g_string_free (dbus_props, TRUE), NULL)), (dbus_methods_decl == NULL) ? NULL : (dbus_methods_decl = (vala_ccode_node_unref (dbus_methods_decl), NULL)), (dbus_object_info == NULL) ? NULL : (dbus_object_info = (vala_ccode_node_unref (dbus_object_info), NULL)), (install_call == NULL) ? NULL : (install_call = (vala_ccode_node_unref (install_call), NULL)), _tmp47);
}


static void vala_dbus_server_module_transform_struct_to_value_array (ValaDBusServerModule* self, ValaCCodeBlock* block, ValaStruct* st, ValaCCodeExpression* target, ValaCCodeExpression* st_expr, const char* name) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* array_construct;
	ValaCCodeConstant* _tmp2;
	ValaCCodeExpressionStatement* _tmp4;
	ValaCCodeAssignment* _tmp3;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeFunctionCall* _tmp6;
	ValaCCodeFunctionCall* type_call;
	ValaCCodeConstant* _tmp7;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block != NULL);
	g_return_if_fail (st != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (st_expr != NULL);
	g_return_if_fail (name != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	array_construct = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("g_value_array_new"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (array_construct, (ValaCCodeExpression*) (_tmp2 = vala_ccode_constant_new ("0")));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp4 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp3 = vala_ccode_assignment_new (target, (ValaCCodeExpression*) array_construct, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp5 = NULL;
	_tmp6 = NULL;
	type_call = (_tmp6 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp5 = vala_ccode_identifier_new ("dbus_g_type_get_struct"))), (_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)), _tmp6);
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (type_call, (ValaCCodeExpression*) (_tmp7 = vala_ccode_constant_new ("\"GValueArray\"")));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	{
		GeeList* _tmp8;
		GeeIterator* _tmp9;
		GeeIterator* f_it;
		_tmp8 = NULL;
		_tmp9 = NULL;
		f_it = (_tmp9 = gee_iterable_iterator ((GeeIterable*) (_tmp8 = vala_struct_get_fields (st))), (_tmp8 == NULL) ? NULL : (_tmp8 = (gee_collection_object_unref (_tmp8), NULL)), _tmp9);
		while (gee_iterator_next (f_it)) {
			ValaField* f;
			char* val_name;
			ValaCCodeInitializerList* cvalinit;
			ValaCCodeConstant* _tmp10;
			ValaCCodeDeclaration* cval_decl;
			ValaCCodeVariableDeclarator* _tmp11;
			ValaCCodeIdentifier* _tmp12;
			ValaCCodeUnaryExpression* _tmp13;
			ValaCCodeUnaryExpression* val_ptr;
			char* type_id;
			char* set_value_function;
			ValaCCodeIdentifier* _tmp19;
			ValaCCodeFunctionCall* _tmp20;
			ValaCCodeFunctionCall* cinit_call;
			ValaCCodeIdentifier* _tmp21;
			ValaCCodeExpressionStatement* _tmp22;
			ValaCCodeIdentifier* _tmp23;
			ValaCCodeFunctionCall* _tmp24;
			ValaCCodeFunctionCall* cset_call;
			ValaCCodeExpressionStatement* _tmp28;
			ValaCCodeIdentifier* _tmp29;
			ValaCCodeFunctionCall* _tmp30;
			ValaCCodeFunctionCall* cappend_call;
			ValaCCodeExpressionStatement* _tmp31;
			ValaCCodeIdentifier* _tmp33;
			char* _tmp32;
			f = (ValaField*) gee_iterator_get (f_it);
			if (vala_field_get_binding (f) != MEMBER_BINDING_INSTANCE) {
				(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
				continue;
			}
			val_name = g_strdup_printf ("val_%s_%s", name, vala_symbol_get_name ((ValaSymbol*) f));
			/* 0-initialize struct with struct initializer { 0 }*/
			cvalinit = vala_ccode_initializer_list_new ();
			_tmp10 = NULL;
			vala_ccode_initializer_list_append (cvalinit, (ValaCCodeExpression*) (_tmp10 = vala_ccode_constant_new ("0")));
			(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
			cval_decl = vala_ccode_declaration_new ("GValue");
			_tmp11 = NULL;
			vala_ccode_declaration_add_declarator (cval_decl, (ValaCCodeDeclarator*) (_tmp11 = vala_ccode_variable_declarator_new_with_initializer (val_name, (ValaCCodeExpression*) cvalinit)));
			(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) cval_decl);
			_tmp12 = NULL;
			_tmp13 = NULL;
			val_ptr = (_tmp13 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new (val_name))), (_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)), _tmp13);
			type_id = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_field_get_field_type (f)));
			set_value_function = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (vala_field_get_field_type (f)));
			if (VALA_IS_ENUM (vala_data_type_get_data_type (vala_field_get_field_type (f)))) {
				ValaEnum* _tmp14;
				ValaEnum* en;
				/* dbus-glib does not support enums*/
				_tmp14 = NULL;
				en = (_tmp14 = VALA_ENUM (vala_data_type_get_data_type (vala_field_get_field_type (f))), (_tmp14 == NULL) ? NULL : vala_code_node_ref (_tmp14));
				if (!vala_enum_get_is_flags (en)) {
					char* _tmp15;
					char* _tmp16;
					_tmp15 = NULL;
					type_id = (_tmp15 = g_strdup ("G_TYPE_INT"), type_id = (g_free (type_id), NULL), _tmp15);
					_tmp16 = NULL;
					set_value_function = (_tmp16 = g_strdup ("g_value_set_int"), set_value_function = (g_free (set_value_function), NULL), _tmp16);
				} else {
					char* _tmp17;
					char* _tmp18;
					_tmp17 = NULL;
					type_id = (_tmp17 = g_strdup ("G_TYPE_UINT"), type_id = (g_free (type_id), NULL), _tmp17);
					_tmp18 = NULL;
					set_value_function = (_tmp18 = g_strdup ("g_value_set_uint"), set_value_function = (g_free (set_value_function), NULL), _tmp18);
				}
				(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
			}
			_tmp19 = NULL;
			_tmp20 = NULL;
			cinit_call = (_tmp20 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new ("g_value_init"))), (_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)), _tmp20);
			vala_ccode_function_call_add_argument (cinit_call, (ValaCCodeExpression*) val_ptr);
			_tmp21 = NULL;
			vala_ccode_function_call_add_argument (cinit_call, (ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new (type_id)));
			(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
			_tmp22 = NULL;
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp22 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinit_call)));
			(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
			_tmp23 = NULL;
			_tmp24 = NULL;
			cset_call = (_tmp24 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp23 = vala_ccode_identifier_new (set_value_function))), (_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)), _tmp24);
			vala_ccode_function_call_add_argument (cset_call, (ValaCCodeExpression*) val_ptr);
			if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_field_get_field_type (f)))) {
				ValaCCodeUnaryExpression* _tmp26;
				ValaCCodeMemberAccess* _tmp25;
				_tmp26 = NULL;
				_tmp25 = NULL;
				vala_ccode_function_call_add_argument (cset_call, (ValaCCodeExpression*) (_tmp26 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp25 = vala_ccode_member_access_new (st_expr, vala_symbol_get_name ((ValaSymbol*) f), FALSE)))));
				(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
				(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
			} else {
				ValaCCodeMemberAccess* _tmp27;
				_tmp27 = NULL;
				vala_ccode_function_call_add_argument (cset_call, (ValaCCodeExpression*) (_tmp27 = vala_ccode_member_access_new (st_expr, vala_symbol_get_name ((ValaSymbol*) f), FALSE)));
				(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
			}
			_tmp28 = NULL;
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp28 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cset_call)));
			(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
			_tmp29 = NULL;
			_tmp30 = NULL;
			cappend_call = (_tmp30 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp29 = vala_ccode_identifier_new ("g_value_array_append"))), (_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)), _tmp30);
			vala_ccode_function_call_add_argument (cappend_call, target);
			vala_ccode_function_call_add_argument (cappend_call, (ValaCCodeExpression*) val_ptr);
			_tmp31 = NULL;
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp31 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cappend_call)));
			(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
			_tmp33 = NULL;
			_tmp32 = NULL;
			vala_ccode_function_call_add_argument (type_call, (ValaCCodeExpression*) (_tmp33 = vala_ccode_identifier_new (_tmp32 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_field_get_field_type (f))))));
			(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
			_tmp32 = (g_free (_tmp32), NULL);
			(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
			val_name = (g_free (val_name), NULL);
			(cvalinit == NULL) ? NULL : (cvalinit = (vala_ccode_node_unref (cvalinit), NULL));
			(cval_decl == NULL) ? NULL : (cval_decl = (vala_ccode_node_unref (cval_decl), NULL));
			(val_ptr == NULL) ? NULL : (val_ptr = (vala_ccode_node_unref (val_ptr), NULL));
			type_id = (g_free (type_id), NULL);
			set_value_function = (g_free (set_value_function), NULL);
			(cinit_call == NULL) ? NULL : (cinit_call = (vala_ccode_node_unref (cinit_call), NULL));
			(cset_call == NULL) ? NULL : (cset_call = (vala_ccode_node_unref (cset_call), NULL));
			(cappend_call == NULL) ? NULL : (cappend_call = (vala_ccode_node_unref (cappend_call), NULL));
		}
		(f_it == NULL) ? NULL : (f_it = (gee_collection_object_unref (f_it), NULL));
	}
	(array_construct == NULL) ? NULL : (array_construct = (vala_ccode_node_unref (array_construct), NULL));
	(type_call == NULL) ? NULL : (type_call = (vala_ccode_node_unref (type_call), NULL));
}


static void vala_dbus_server_module_transform_struct_hash_table_to_value_array_hash_table (ValaDBusServerModule* self, ValaCCodeBlock* block, ValaStruct* st, ValaCCodeExpression* target, ValaCCodeExpression* table_expr, const char* name) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* table_construct;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeExpressionStatement* _tmp5;
	ValaCCodeAssignment* _tmp4;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp7;
	char* _tmp6;
	ValaCCodeVariableDeclarator* _tmp9;
	char* _tmp8;
	ValaCCodeVariableDeclarator* _tmp11;
	char* _tmp10;
	ValaCCodeVariableDeclarator* _tmp13;
	char* _tmp12;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeFunctionCall* _tmp15;
	ValaCCodeFunctionCall* get_keys;
	ValaCCodeExpressionStatement* _tmp19;
	ValaCCodeAssignment* _tmp18;
	ValaCCodeIdentifier* _tmp17;
	char* _tmp16;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeFunctionCall* _tmp21;
	ValaCCodeFunctionCall* get_values;
	ValaCCodeExpressionStatement* _tmp25;
	ValaCCodeAssignment* _tmp24;
	ValaCCodeIdentifier* _tmp23;
	char* _tmp22;
	ValaCCodeBlock* loop_body;
	ValaCCodeIdentifier* _tmp27;
	char* _tmp26;
	ValaCCodeForStatement* _tmp28;
	ValaCCodeForStatement* for_stmt;
	ValaCCodeAssignment* _tmp33;
	ValaCCodeIdentifier* _tmp32;
	char* _tmp31;
	ValaCCodeIdentifier* _tmp30;
	char* _tmp29;
	ValaCCodeAssignment* _tmp38;
	ValaCCodeIdentifier* _tmp37;
	char* _tmp36;
	ValaCCodeIdentifier* _tmp35;
	char* _tmp34;
	ValaCCodeAssignment* _tmp44;
	ValaCCodeMemberAccess* _tmp43;
	ValaCCodeIdentifier* _tmp42;
	char* _tmp41;
	ValaCCodeIdentifier* _tmp40;
	char* _tmp39;
	ValaCCodeAssignment* _tmp50;
	ValaCCodeMemberAccess* _tmp49;
	ValaCCodeIdentifier* _tmp48;
	char* _tmp47;
	ValaCCodeIdentifier* _tmp46;
	char* _tmp45;
	ValaCCodeDeclaration* _tmp53;
	char* _tmp52;
	char* _tmp51;
	ValaCCodeVariableDeclarator* _tmp58;
	ValaCCodeMemberAccess* _tmp57;
	ValaCCodeIdentifier* _tmp56;
	char* _tmp55;
	char* _tmp54;
	ValaCCodeDeclaration* _tmp59;
	ValaCCodeVariableDeclarator* _tmp61;
	char* _tmp60;
	ValaCCodeUnaryExpression* _tmp66;
	ValaCCodeIdentifier* _tmp65;
	char* _tmp64;
	ValaCCodeIdentifier* _tmp63;
	char* _tmp62;
	ValaCCodeIdentifier* _tmp67;
	ValaCCodeFunctionCall* _tmp68;
	ValaCCodeFunctionCall* insert_call;
	ValaCCodeMemberAccess* _tmp71;
	ValaCCodeIdentifier* _tmp70;
	char* _tmp69;
	ValaCCodeIdentifier* _tmp73;
	char* _tmp72;
	ValaCCodeExpressionStatement* _tmp74;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block != NULL);
	g_return_if_fail (st != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (table_expr != NULL);
	g_return_if_fail (name != NULL);
	/* FIXME take care of memory management*/
	_tmp0 = NULL;
	_tmp1 = NULL;
	table_construct = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("g_hash_table_new"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (table_construct, (ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new ("g_direct_hash")));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (table_construct, (ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new ("g_direct_equal")));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp5 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp4 = vala_ccode_assignment_new (target, (ValaCCodeExpression*) table_construct, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	cdecl_ = vala_ccode_declaration_new ("GList");
	_tmp7 = NULL;
	_tmp6 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp7 = vala_ccode_variable_declarator_new (_tmp6 = g_strdup_printf ("*%s_keys", name))));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	_tmp6 = (g_free (_tmp6), NULL);
	_tmp9 = NULL;
	_tmp8 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp9 = vala_ccode_variable_declarator_new (_tmp8 = g_strdup_printf ("*%s_keys_it", name))));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	_tmp8 = (g_free (_tmp8), NULL);
	_tmp11 = NULL;
	_tmp10 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp11 = vala_ccode_variable_declarator_new (_tmp10 = g_strdup_printf ("*%s_values", name))));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	_tmp10 = (g_free (_tmp10), NULL);
	_tmp13 = NULL;
	_tmp12 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp13 = vala_ccode_variable_declarator_new (_tmp12 = g_strdup_printf ("*%s_values_it", name))));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	_tmp12 = (g_free (_tmp12), NULL);
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp14 = NULL;
	_tmp15 = NULL;
	get_keys = (_tmp15 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new ("g_hash_table_get_keys"))), (_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)), _tmp15);
	vala_ccode_function_call_add_argument (get_keys, table_expr);
	_tmp19 = NULL;
	_tmp18 = NULL;
	_tmp17 = NULL;
	_tmp16 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp19 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp18 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp17 = vala_ccode_identifier_new (_tmp16 = g_strdup_printf ("%s_keys", name))), (ValaCCodeExpression*) get_keys, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	_tmp16 = (g_free (_tmp16), NULL);
	_tmp20 = NULL;
	_tmp21 = NULL;
	get_values = (_tmp21 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new ("g_hash_table_get_values"))), (_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)), _tmp21);
	vala_ccode_function_call_add_argument (get_values, table_expr);
	_tmp25 = NULL;
	_tmp24 = NULL;
	_tmp23 = NULL;
	_tmp22 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp25 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp24 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp23 = vala_ccode_identifier_new (_tmp22 = g_strdup_printf ("%s_values", name))), (ValaCCodeExpression*) get_values, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
	(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	_tmp22 = (g_free (_tmp22), NULL);
	loop_body = vala_ccode_block_new ();
	_tmp27 = NULL;
	_tmp26 = NULL;
	_tmp28 = NULL;
	for_stmt = (_tmp28 = vala_ccode_for_statement_new ((ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new (_tmp26 = g_strdup_printf ("%s_keys_it", name))), (ValaCCodeStatement*) loop_body), (_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)), _tmp26 = (g_free (_tmp26), NULL), _tmp28);
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) for_stmt);
	_tmp33 = NULL;
	_tmp32 = NULL;
	_tmp31 = NULL;
	_tmp30 = NULL;
	_tmp29 = NULL;
	vala_ccode_for_statement_add_initializer (for_stmt, (ValaCCodeExpression*) (_tmp33 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp30 = vala_ccode_identifier_new (_tmp29 = g_strdup_printf ("%s_keys_it", name))), (ValaCCodeExpression*) (_tmp32 = vala_ccode_identifier_new (_tmp31 = g_strdup_printf ("%s_keys", name))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
	_tmp31 = (g_free (_tmp31), NULL);
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
	_tmp29 = (g_free (_tmp29), NULL);
	_tmp38 = NULL;
	_tmp37 = NULL;
	_tmp36 = NULL;
	_tmp35 = NULL;
	_tmp34 = NULL;
	vala_ccode_for_statement_add_initializer (for_stmt, (ValaCCodeExpression*) (_tmp38 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp35 = vala_ccode_identifier_new (_tmp34 = g_strdup_printf ("%s_values_it", name))), (ValaCCodeExpression*) (_tmp37 = vala_ccode_identifier_new (_tmp36 = g_strdup_printf ("%s_values", name))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
	(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	_tmp36 = (g_free (_tmp36), NULL);
	(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
	_tmp34 = (g_free (_tmp34), NULL);
	_tmp44 = NULL;
	_tmp43 = NULL;
	_tmp42 = NULL;
	_tmp41 = NULL;
	_tmp40 = NULL;
	_tmp39 = NULL;
	vala_ccode_for_statement_add_iterator (for_stmt, (ValaCCodeExpression*) (_tmp44 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp40 = vala_ccode_identifier_new (_tmp39 = g_strdup_printf ("%s_keys_it", name))), (ValaCCodeExpression*) (_tmp43 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp42 = vala_ccode_identifier_new (_tmp41 = g_strdup_printf ("%s_keys_it", name))), "next")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
	(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
	(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
	_tmp41 = (g_free (_tmp41), NULL);
	(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
	_tmp39 = (g_free (_tmp39), NULL);
	_tmp50 = NULL;
	_tmp49 = NULL;
	_tmp48 = NULL;
	_tmp47 = NULL;
	_tmp46 = NULL;
	_tmp45 = NULL;
	vala_ccode_for_statement_add_iterator (for_stmt, (ValaCCodeExpression*) (_tmp50 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp46 = vala_ccode_identifier_new (_tmp45 = g_strdup_printf ("%s_values_it", name))), (ValaCCodeExpression*) (_tmp49 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp48 = vala_ccode_identifier_new (_tmp47 = g_strdup_printf ("%s_values_it", name))), "next")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
	(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
	(_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL));
	_tmp47 = (g_free (_tmp47), NULL);
	(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
	_tmp45 = (g_free (_tmp45), NULL);
	_tmp53 = NULL;
	_tmp52 = NULL;
	_tmp51 = NULL;
	cdecl_ = (_tmp53 = vala_ccode_declaration_new (_tmp52 = g_strconcat (_tmp51 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), "*", NULL)), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp53);
	_tmp52 = (g_free (_tmp52), NULL);
	_tmp51 = (g_free (_tmp51), NULL);
	_tmp58 = NULL;
	_tmp57 = NULL;
	_tmp56 = NULL;
	_tmp55 = NULL;
	_tmp54 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp58 = vala_ccode_variable_declarator_new_with_initializer (_tmp54 = g_strdup_printf ("%s_value", name), (ValaCCodeExpression*) (_tmp57 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp56 = vala_ccode_identifier_new (_tmp55 = g_strdup_printf ("%s_values_it", name))), "data")))));
	(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL));
	(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
	(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
	_tmp55 = (g_free (_tmp55), NULL);
	_tmp54 = (g_free (_tmp54), NULL);
	vala_ccode_block_add_statement (loop_body, (ValaCCodeNode*) cdecl_);
	_tmp59 = NULL;
	cdecl_ = (_tmp59 = vala_ccode_declaration_new ("GValueArray*"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp59);
	_tmp61 = NULL;
	_tmp60 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp61 = vala_ccode_variable_declarator_new (_tmp60 = g_strdup_printf ("%s_value_array", name))));
	(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
	_tmp60 = (g_free (_tmp60), NULL);
	vala_ccode_block_add_statement (loop_body, (ValaCCodeNode*) cdecl_);
	_tmp66 = NULL;
	_tmp65 = NULL;
	_tmp64 = NULL;
	_tmp63 = NULL;
	_tmp62 = NULL;
	vala_dbus_server_module_transform_struct_to_value_array (self, loop_body, st, (ValaCCodeExpression*) (_tmp63 = vala_ccode_identifier_new (_tmp62 = g_strdup_printf ("%s_value_array", name))), (ValaCCodeExpression*) (_tmp66 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp65 = vala_ccode_identifier_new (_tmp64 = g_strdup_printf ("%s_value", name))))), name);
	(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
	(_tmp65 == NULL) ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL));
	_tmp64 = (g_free (_tmp64), NULL);
	(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL));
	_tmp62 = (g_free (_tmp62), NULL);
	_tmp67 = NULL;
	_tmp68 = NULL;
	insert_call = (_tmp68 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp67 = vala_ccode_identifier_new ("g_hash_table_insert"))), (_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL)), _tmp68);
	vala_ccode_function_call_add_argument (insert_call, target);
	_tmp71 = NULL;
	_tmp70 = NULL;
	_tmp69 = NULL;
	vala_ccode_function_call_add_argument (insert_call, (ValaCCodeExpression*) (_tmp71 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp70 = vala_ccode_identifier_new (_tmp69 = g_strdup_printf ("%s_keys_it", name))), "data")));
	(_tmp71 == NULL) ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL));
	(_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL));
	_tmp69 = (g_free (_tmp69), NULL);
	_tmp73 = NULL;
	_tmp72 = NULL;
	vala_ccode_function_call_add_argument (insert_call, (ValaCCodeExpression*) (_tmp73 = vala_ccode_identifier_new (_tmp72 = g_strdup_printf ("%s_value_array", name))));
	(_tmp73 == NULL) ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL));
	_tmp72 = (g_free (_tmp72), NULL);
	_tmp74 = NULL;
	vala_ccode_block_add_statement (loop_body, (ValaCCodeNode*) (_tmp74 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) insert_call)));
	(_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL));
	(table_construct == NULL) ? NULL : (table_construct = (vala_ccode_node_unref (table_construct), NULL));
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(get_keys == NULL) ? NULL : (get_keys = (vala_ccode_node_unref (get_keys), NULL));
	(get_values == NULL) ? NULL : (get_values = (vala_ccode_node_unref (get_values), NULL));
	(loop_body == NULL) ? NULL : (loop_body = (vala_ccode_node_unref (loop_body), NULL));
	(for_stmt == NULL) ? NULL : (for_stmt = (vala_ccode_node_unref (for_stmt), NULL));
	(insert_call == NULL) ? NULL : (insert_call = (vala_ccode_node_unref (insert_call), NULL));
}


static char* vala_dbus_server_module_generate_dbus_wrapper (ValaDBusServerModule* self, ValaMethod* m, ValaObjectTypeSymbol* bindable) {
	char* _tmp0;
	char* _tmp1;
	char* wrapper_name;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp4;
	char* _tmp3;
	char* _tmp2;
	ValaCCodeFormalParameter* _tmp51;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp93;
	char* _tmp92;
	ValaCCodeFunctionCall* _tmp94;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp95;
	ValaCCodeExpression* expr;
	GeeList* _tmp159;
	gboolean _tmp160;
	ValaCCodeExpressionStatement* _tmp162;
	ValaCCodeIdentifier* _tmp223;
	ValaCCodeIdentifier* _tmp222;
	ValaCCodeBinaryExpression* _tmp224;
	ValaCCodeBinaryExpression* no_error;
	ValaCCodeReturnStatement* _tmp225;
	ValaCCodeFunction* _tmp226;
	char* _tmp227;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	g_return_val_if_fail (bindable != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	wrapper_name = (_tmp1 = g_strdup_printf ("_dbus_%s", _tmp0 = vala_method_get_cname (m)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	/* declaration*/
	function = vala_ccode_function_new (wrapper_name, "gboolean");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	vala_code_node_set_ccodenode ((ValaCodeNode*) m, (ValaCCodeNode*) function);
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (function, _tmp4 = vala_ccode_formal_parameter_new ("self", _tmp3 = g_strconcat (_tmp2 = vala_typesymbol_get_cname ((ValaTypeSymbol*) bindable, FALSE), "*", NULL)));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp3 = (g_free (_tmp3), NULL);
	_tmp2 = (g_free (_tmp2), NULL);
	{
		GeeList* _tmp5;
		GeeIterator* _tmp6;
		GeeIterator* param_it;
		_tmp5 = NULL;
		_tmp6 = NULL;
		param_it = (_tmp6 = gee_iterable_iterator ((GeeIterable*) (_tmp5 = vala_method_get_parameters (m))), (_tmp5 == NULL) ? NULL : (_tmp5 = (gee_collection_object_unref (_tmp5), NULL)), _tmp6);
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			const char* _tmp7;
			const char* _tmp8;
			char* ptr;
			ValaArrayType* _tmp10;
			ValaDataType* _tmp9;
			ValaArrayType* array_type;
			gboolean _tmp11;
			param = (ValaFormalParameter*) gee_iterator_get (param_it);
			_tmp7 = NULL;
			if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
				_tmp7 = "*";
			} else {
				_tmp7 = "";
			}
			_tmp8 = NULL;
			ptr = (_tmp8 = (_tmp7), (_tmp8 == NULL) ? NULL : g_strdup (_tmp8));
			_tmp10 = NULL;
			_tmp9 = NULL;
			array_type = (_tmp10 = (_tmp9 = vala_formal_parameter_get_parameter_type (param), VALA_IS_ARRAY_TYPE (_tmp9) ? ((ValaArrayType*) _tmp9) : NULL), (_tmp10 == NULL) ? NULL : vala_code_node_ref (_tmp10));
			_tmp11 = FALSE;
			if (array_type != NULL) {
				_tmp11 = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type);
			} else {
				_tmp11 = FALSE;
			}
			if (_tmp11) {
				if (vala_dbus_client_module_dbus_use_ptr_array ((ValaDBusClientModule*) self, array_type)) {
					ValaCCodeFormalParameter* _tmp14;
					char* _tmp13;
					char* _tmp12;
					_tmp14 = NULL;
					_tmp13 = NULL;
					_tmp12 = NULL;
					vala_ccode_function_add_parameter (function, _tmp14 = vala_ccode_formal_parameter_new (_tmp12 = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)), _tmp13 = g_strconcat ("GPtrArray*", ptr, NULL)));
					(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
					_tmp13 = (g_free (_tmp13), NULL);
					_tmp12 = (g_free (_tmp12), NULL);
				} else {
					ValaCCodeFormalParameter* _tmp17;
					char* _tmp16;
					char* _tmp15;
					_tmp17 = NULL;
					_tmp16 = NULL;
					_tmp15 = NULL;
					vala_ccode_function_add_parameter (function, _tmp17 = vala_ccode_formal_parameter_new (_tmp15 = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)), _tmp16 = g_strconcat ("GArray*", ptr, NULL)));
					(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
					_tmp16 = (g_free (_tmp16), NULL);
					_tmp15 = (g_free (_tmp15), NULL);
				}
			} else {
				char* _tmp18;
				gboolean _tmp19;
				_tmp18 = NULL;
				if ((_tmp19 = g_str_has_prefix (_tmp18 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param)), "("), _tmp18 = (g_free (_tmp18), NULL), _tmp19)) {
					ValaCCodeFormalParameter* _tmp22;
					char* _tmp21;
					char* _tmp20;
					_tmp22 = NULL;
					_tmp21 = NULL;
					_tmp20 = NULL;
					vala_ccode_function_add_parameter (function, _tmp22 = vala_ccode_formal_parameter_new (_tmp20 = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)), _tmp21 = g_strconcat ("GValueArray*", ptr, NULL)));
					(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
					_tmp21 = (g_free (_tmp21), NULL);
					_tmp20 = (g_free (_tmp20), NULL);
				} else {
					char* _tmp23;
					gboolean _tmp24;
					_tmp23 = NULL;
					if ((_tmp24 = g_str_has_prefix (_tmp23 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param)), "a{"), _tmp23 = (g_free (_tmp23), NULL), _tmp24)) {
						GeeList* type_args;
						ValaDataType* value_type;
						char* _tmp25;
						gboolean _tmp26;
						/* hash table output parameter*/
						type_args = vala_data_type_get_type_arguments (vala_formal_parameter_get_parameter_type (param));
						value_type = (ValaDataType*) gee_list_get (type_args, 1);
						_tmp25 = NULL;
						if ((_tmp26 = g_str_has_prefix (_tmp25 = vala_data_type_get_type_signature (value_type), "("), _tmp25 = (g_free (_tmp25), NULL), _tmp26)) {
							ValaCCodeFormalParameter* _tmp29;
							char* _tmp28;
							char* _tmp27;
							/* values are structs*/
							_tmp29 = NULL;
							_tmp28 = NULL;
							_tmp27 = NULL;
							vala_ccode_function_add_parameter (function, _tmp29 = vala_ccode_formal_parameter_new (_tmp27 = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)), _tmp28 = g_strconcat ("GHashTable*", ptr, NULL)));
							(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
							_tmp28 = (g_free (_tmp28), NULL);
							_tmp27 = (g_free (_tmp27), NULL);
						} else {
							vala_ccode_function_add_parameter (function, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode ((ValaCodeNode*) param)));
						}
						(type_args == NULL) ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL));
						(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
					} else {
						vala_ccode_function_add_parameter (function, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode ((ValaCodeNode*) param)));
					}
				}
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			ptr = (g_free (ptr), NULL);
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		}
		(param_it == NULL) ? NULL : (param_it = (gee_collection_object_unref (param_it), NULL));
	}
	if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
		ValaArrayType* _tmp31;
		ValaDataType* _tmp30;
		ValaArrayType* array_type;
		_tmp31 = NULL;
		_tmp30 = NULL;
		array_type = (_tmp31 = (_tmp30 = vala_method_get_return_type (m), VALA_IS_ARRAY_TYPE (_tmp30) ? ((ValaArrayType*) _tmp30) : NULL), (_tmp31 == NULL) ? NULL : vala_code_node_ref (_tmp31));
		if (array_type != NULL) {
			if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
				ValaCCodeFormalParameter* _tmp34;
				char* _tmp33;
				char* _tmp32;
				_tmp34 = NULL;
				_tmp33 = NULL;
				_tmp32 = NULL;
				vala_ccode_function_add_parameter (function, _tmp34 = vala_ccode_formal_parameter_new ("result", _tmp33 = g_strconcat (_tmp32 = vala_data_type_get_cname ((ValaDataType*) array_type), "*", NULL)));
				(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
				_tmp33 = (g_free (_tmp33), NULL);
				_tmp32 = (g_free (_tmp32), NULL);
			} else {
				if (vala_dbus_client_module_dbus_use_ptr_array ((ValaDBusClientModule*) self, array_type)) {
					ValaCCodeFormalParameter* _tmp35;
					_tmp35 = NULL;
					vala_ccode_function_add_parameter (function, _tmp35 = vala_ccode_formal_parameter_new ("dbus_result", "GPtrArray**"));
					(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
				} else {
					ValaCCodeFormalParameter* _tmp36;
					_tmp36 = NULL;
					vala_ccode_function_add_parameter (function, _tmp36 = vala_ccode_formal_parameter_new ("dbus_result", "GArray**"));
					(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
				}
			}
		} else {
			char* _tmp37;
			gboolean _tmp38;
			_tmp37 = NULL;
			if ((_tmp38 = g_str_has_prefix (_tmp37 = vala_data_type_get_type_signature (vala_method_get_return_type (m)), "("), _tmp37 = (g_free (_tmp37), NULL), _tmp38)) {
				ValaCCodeFormalParameter* _tmp39;
				_tmp39 = NULL;
				vala_ccode_function_add_parameter (function, _tmp39 = vala_ccode_formal_parameter_new ("dbus_result", "GValueArray**"));
				(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
			} else {
				char* _tmp40;
				gboolean _tmp41;
				_tmp40 = NULL;
				if ((_tmp41 = g_str_has_prefix (_tmp40 = vala_data_type_get_type_signature (vala_method_get_return_type (m)), "a{"), _tmp40 = (g_free (_tmp40), NULL), _tmp41)) {
					GeeList* type_args;
					ValaDataType* value_type;
					char* _tmp42;
					gboolean _tmp43;
					/* hash table output parameter*/
					type_args = vala_data_type_get_type_arguments (vala_method_get_return_type (m));
					value_type = (ValaDataType*) gee_list_get (type_args, 1);
					_tmp42 = NULL;
					if ((_tmp43 = g_str_has_prefix (_tmp42 = vala_data_type_get_type_signature (value_type), "("), _tmp42 = (g_free (_tmp42), NULL), _tmp43)) {
						ValaCCodeFormalParameter* _tmp44;
						/* values are structs*/
						_tmp44 = NULL;
						vala_ccode_function_add_parameter (function, _tmp44 = vala_ccode_formal_parameter_new ("dbus_result", "GHashTable**"));
						(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
					} else {
						ValaCCodeFormalParameter* _tmp47;
						char* _tmp46;
						char* _tmp45;
						_tmp47 = NULL;
						_tmp46 = NULL;
						_tmp45 = NULL;
						vala_ccode_function_add_parameter (function, _tmp47 = vala_ccode_formal_parameter_new ("result", _tmp46 = g_strconcat (_tmp45 = vala_data_type_get_cname (vala_method_get_return_type (m)), "*", NULL)));
						(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
						_tmp46 = (g_free (_tmp46), NULL);
						_tmp45 = (g_free (_tmp45), NULL);
					}
					(type_args == NULL) ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL));
					(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
				} else {
					ValaCCodeFormalParameter* _tmp50;
					char* _tmp49;
					char* _tmp48;
					_tmp50 = NULL;
					_tmp49 = NULL;
					_tmp48 = NULL;
					vala_ccode_function_add_parameter (function, _tmp50 = vala_ccode_formal_parameter_new ("result", _tmp49 = g_strconcat (_tmp48 = vala_data_type_get_cname (vala_method_get_return_type (m)), "*", NULL)));
					(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
					_tmp49 = (g_free (_tmp49), NULL);
					_tmp48 = (g_free (_tmp48), NULL);
				}
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	}
	_tmp51 = NULL;
	vala_ccode_function_add_parameter (function, _tmp51 = vala_ccode_formal_parameter_new ("error", "GError**"));
	(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
	/* definition*/
	block = vala_ccode_block_new ();
	{
		GeeList* _tmp52;
		GeeIterator* _tmp53;
		GeeIterator* param_it;
		_tmp52 = NULL;
		_tmp53 = NULL;
		param_it = (_tmp53 = gee_iterable_iterator ((GeeIterable*) (_tmp52 = vala_method_get_parameters (m))), (_tmp52 == NULL) ? NULL : (_tmp52 = (gee_collection_object_unref (_tmp52), NULL)), _tmp53);
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			char* _tmp54;
			gboolean _tmp55;
			param = (ValaFormalParameter*) gee_iterator_get (param_it);
			_tmp54 = NULL;
			if ((_tmp55 = g_str_has_prefix (_tmp54 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param)), "("), _tmp54 = (g_free (_tmp54), NULL), _tmp55)) {
				ValaStruct* _tmp56;
				ValaStruct* st;
				char* _tmp57;
				ValaCCodeDeclaration* _tmp58;
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp59;
				_tmp56 = NULL;
				st = (_tmp56 = VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))), (_tmp56 == NULL) ? NULL : vala_code_node_ref (_tmp56));
				_tmp57 = NULL;
				_tmp58 = NULL;
				cdecl_ = (_tmp58 = vala_ccode_declaration_new (_tmp57 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE)), _tmp57 = (g_free (_tmp57), NULL), _tmp58);
				_tmp59 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp59 = vala_ccode_variable_declarator_new (vala_symbol_get_name ((ValaSymbol*) param))));
				(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
				vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
				if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
					gint i;
					/* struct input parameter*/
					i = 0;
					{
						GeeList* _tmp60;
						GeeIterator* _tmp61;
						GeeIterator* f_it;
						_tmp60 = NULL;
						_tmp61 = NULL;
						f_it = (_tmp61 = gee_iterable_iterator ((GeeIterable*) (_tmp60 = vala_struct_get_fields (st))), (_tmp60 == NULL) ? NULL : (_tmp60 = (gee_collection_object_unref (_tmp60), NULL)), _tmp61);
						while (gee_iterator_next (f_it)) {
							ValaField* f;
							f = (ValaField*) gee_iterator_get (f_it);
							if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
								ValaCCodeIdentifier* _tmp63;
								char* _tmp62;
								ValaCCodeFunctionCall* _tmp64;
								ValaCCodeFunctionCall* cget_call;
								ValaCCodeUnaryExpression* _tmp71;
								ValaCCodeElementAccess* _tmp70;
								ValaCCodeConstant* _tmp69;
								char* _tmp68;
								ValaCCodeMemberAccess* _tmp67;
								ValaCCodeIdentifier* _tmp66;
								char* _tmp65;
								ValaCCodeMemberAccess* _tmp73;
								ValaCCodeIdentifier* _tmp72;
								ValaCCodeAssignment* _tmp74;
								ValaCCodeAssignment* assign;
								ValaCCodeExpressionStatement* _tmp75;
								_tmp63 = NULL;
								_tmp62 = NULL;
								_tmp64 = NULL;
								cget_call = (_tmp64 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp63 = vala_ccode_identifier_new (_tmp62 = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_field_get_field_type (f)))))), (_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL)), _tmp62 = (g_free (_tmp62), NULL), _tmp64);
								_tmp71 = NULL;
								_tmp70 = NULL;
								_tmp69 = NULL;
								_tmp68 = NULL;
								_tmp67 = NULL;
								_tmp66 = NULL;
								_tmp65 = NULL;
								vala_ccode_function_call_add_argument (cget_call, (ValaCCodeExpression*) (_tmp71 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp70 = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp67 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp66 = vala_ccode_identifier_new (_tmp65 = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)))), "values")), (ValaCCodeExpression*) (_tmp69 = vala_ccode_constant_new (_tmp68 = g_strdup_printf ("%i", i))))))));
								(_tmp71 == NULL) ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL));
								(_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL));
								(_tmp69 == NULL) ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL));
								_tmp68 = (g_free (_tmp68), NULL);
								(_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL));
								(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
								_tmp65 = (g_free (_tmp65), NULL);
								_tmp73 = NULL;
								_tmp72 = NULL;
								_tmp74 = NULL;
								assign = (_tmp74 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp73 = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp72 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))), vala_symbol_get_name ((ValaSymbol*) f), FALSE)), (ValaCCodeExpression*) cget_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp73 == NULL) ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL)), (_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL)), _tmp74);
								_tmp75 = NULL;
								vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp75 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
								(_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL));
								i++;
								(cget_call == NULL) ? NULL : (cget_call = (vala_ccode_node_unref (cget_call), NULL));
								(assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL));
							}
							(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
						}
						(f_it == NULL) ? NULL : (f_it = (gee_collection_object_unref (f_it), NULL));
					}
				}
				(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
				(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
			} else {
				char* _tmp76;
				gboolean _tmp77;
				_tmp76 = NULL;
				if ((_tmp77 = g_str_has_prefix (_tmp76 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param)), "a{"), _tmp76 = (g_free (_tmp76), NULL), _tmp77)) {
					GeeList* type_args;
					ValaDataType* value_type;
					char* _tmp78;
					gboolean _tmp79;
					/* hash table output parameter*/
					type_args = vala_data_type_get_type_arguments (vala_formal_parameter_get_parameter_type (param));
					value_type = (ValaDataType*) gee_list_get (type_args, 1);
					_tmp78 = NULL;
					if ((_tmp79 = g_str_has_prefix (_tmp78 = vala_data_type_get_type_signature (value_type), "("), _tmp78 = (g_free (_tmp78), NULL), _tmp79)) {
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp80;
						/* values are structs*/
						cdecl_ = vala_ccode_declaration_new ("GHashTable*");
						_tmp80 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp80 = vala_ccode_variable_declarator_new (vala_symbol_get_name ((ValaSymbol*) param))));
						(_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL));
						vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
						(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
					}
					(type_args == NULL) ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL));
					(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
				}
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(param_it == NULL) ? NULL : (param_it = (gee_collection_object_unref (param_it), NULL));
	}
	if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
		ValaArrayType* _tmp82;
		ValaDataType* _tmp81;
		ValaArrayType* array_type;
		_tmp82 = NULL;
		_tmp81 = NULL;
		array_type = (_tmp82 = (_tmp81 = vala_method_get_return_type (m), VALA_IS_ARRAY_TYPE (_tmp81) ? ((ValaArrayType*) _tmp81) : NULL), (_tmp82 == NULL) ? NULL : vala_code_node_ref (_tmp82));
		if (array_type != NULL) {
			ValaCCodeDeclaration* len_cdecl;
			ValaCCodeVariableDeclarator* _tmp86;
			if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
				char* _tmp83;
				ValaCCodeDeclaration* _tmp84;
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp85;
				_tmp83 = NULL;
				_tmp84 = NULL;
				cdecl_ = (_tmp84 = vala_ccode_declaration_new (_tmp83 = vala_data_type_get_cname (vala_method_get_return_type (m))), _tmp83 = (g_free (_tmp83), NULL), _tmp84);
				_tmp85 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp85 = vala_ccode_variable_declarator_new ("result")));
				(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
				vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
				(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
			}
			len_cdecl = vala_ccode_declaration_new ("int");
			_tmp86 = NULL;
			vala_ccode_declaration_add_declarator (len_cdecl, (ValaCCodeDeclarator*) (_tmp86 = vala_ccode_variable_declarator_new ("result_length1")));
			(_tmp86 == NULL) ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL));
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) len_cdecl);
			(len_cdecl == NULL) ? NULL : (len_cdecl = (vala_ccode_node_unref (len_cdecl), NULL));
		} else {
			char* _tmp87;
			gboolean _tmp88;
			_tmp87 = NULL;
			if ((_tmp88 = g_str_has_prefix (_tmp87 = vala_data_type_get_type_signature (vala_method_get_return_type (m)), "a{"), _tmp87 = (g_free (_tmp87), NULL), _tmp88)) {
				GeeList* type_args;
				ValaDataType* value_type;
				char* _tmp89;
				gboolean _tmp90;
				/* hash table return value*/
				type_args = vala_data_type_get_type_arguments (vala_method_get_return_type (m));
				value_type = (ValaDataType*) gee_list_get (type_args, 1);
				_tmp89 = NULL;
				if ((_tmp90 = g_str_has_prefix (_tmp89 = vala_data_type_get_type_signature (value_type), "("), _tmp89 = (g_free (_tmp89), NULL), _tmp90)) {
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp91;
					/* values are structs*/
					cdecl_ = vala_ccode_declaration_new ("GHashTable*");
					_tmp91 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp91 = vala_ccode_variable_declarator_new ("result")));
					(_tmp91 == NULL) ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL));
					vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
					(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
				}
				(type_args == NULL) ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL));
				(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	}
	_tmp93 = NULL;
	_tmp92 = NULL;
	_tmp94 = NULL;
	ccall = (_tmp94 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp93 = vala_ccode_identifier_new (_tmp92 = vala_method_get_cname (m)))), (_tmp93 == NULL) ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL)), _tmp92 = (g_free (_tmp92), NULL), _tmp94);
	_tmp95 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp95 = vala_ccode_identifier_new ("self")));
	(_tmp95 == NULL) ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL));
	{
		GeeList* _tmp96;
		GeeIterator* _tmp97;
		GeeIterator* param_it;
		_tmp96 = NULL;
		_tmp97 = NULL;
		param_it = (_tmp97 = gee_iterable_iterator ((GeeIterable*) (_tmp96 = vala_method_get_parameters (m))), (_tmp96 == NULL) ? NULL : (_tmp96 = (gee_collection_object_unref (_tmp96), NULL)), _tmp97);
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			ValaArrayType* _tmp99;
			ValaDataType* _tmp98;
			ValaArrayType* array_type;
			param = (ValaFormalParameter*) gee_iterator_get (param_it);
			_tmp99 = NULL;
			_tmp98 = NULL;
			array_type = (_tmp99 = (_tmp98 = vala_formal_parameter_get_parameter_type (param), VALA_IS_ARRAY_TYPE (_tmp98) ? ((ValaArrayType*) _tmp98) : NULL), (_tmp99 == NULL) ? NULL : vala_code_node_ref (_tmp99));
			if (array_type != NULL) {
				if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
					if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
						ValaCCodeIdentifier* _tmp100;
						_tmp100 = NULL;
						vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp100 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
						(_tmp100 == NULL) ? NULL : (_tmp100 = (vala_ccode_node_unref (_tmp100), NULL));
						if (!vala_method_get_no_array_length (m)) {
							ValaCCodeIdentifier* _tmp101;
							ValaCCodeFunctionCall* _tmp102;
							ValaCCodeFunctionCall* cstrvlen;
							ValaCCodeIdentifier* _tmp103;
							_tmp101 = NULL;
							_tmp102 = NULL;
							cstrvlen = (_tmp102 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp101 = vala_ccode_identifier_new ("g_strv_length"))), (_tmp101 == NULL) ? NULL : (_tmp101 = (vala_ccode_node_unref (_tmp101), NULL)), _tmp102);
							_tmp103 = NULL;
							vala_ccode_function_call_add_argument (cstrvlen, (ValaCCodeExpression*) (_tmp103 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
							(_tmp103 == NULL) ? NULL : (_tmp103 = (vala_ccode_node_unref (_tmp103), NULL));
							vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) cstrvlen);
							(cstrvlen == NULL) ? NULL : (cstrvlen = (vala_ccode_node_unref (cstrvlen), NULL));
						}
					} else {
						if (vala_dbus_client_module_dbus_use_ptr_array ((ValaDBusClientModule*) self, array_type)) {
							ValaCCodeMemberAccess* _tmp106;
							ValaCCodeIdentifier* _tmp105;
							char* _tmp104;
							_tmp106 = NULL;
							_tmp105 = NULL;
							_tmp104 = NULL;
							vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp106 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp105 = vala_ccode_identifier_new (_tmp104 = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)))), "pdata")));
							(_tmp106 == NULL) ? NULL : (_tmp106 = (vala_ccode_node_unref (_tmp106), NULL));
							(_tmp105 == NULL) ? NULL : (_tmp105 = (vala_ccode_node_unref (_tmp105), NULL));
							_tmp104 = (g_free (_tmp104), NULL);
							if (!vala_method_get_no_array_length (m)) {
								ValaCCodeMemberAccess* _tmp109;
								ValaCCodeIdentifier* _tmp108;
								char* _tmp107;
								_tmp109 = NULL;
								_tmp108 = NULL;
								_tmp107 = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp109 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp108 = vala_ccode_identifier_new (_tmp107 = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)))), "len")));
								(_tmp109 == NULL) ? NULL : (_tmp109 = (vala_ccode_node_unref (_tmp109), NULL));
								(_tmp108 == NULL) ? NULL : (_tmp108 = (vala_ccode_node_unref (_tmp108), NULL));
								_tmp107 = (g_free (_tmp107), NULL);
							}
						} else {
							ValaCCodeMemberAccess* _tmp112;
							ValaCCodeIdentifier* _tmp111;
							char* _tmp110;
							_tmp112 = NULL;
							_tmp111 = NULL;
							_tmp110 = NULL;
							vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp112 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp111 = vala_ccode_identifier_new (_tmp110 = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)))), "data")));
							(_tmp112 == NULL) ? NULL : (_tmp112 = (vala_ccode_node_unref (_tmp112), NULL));
							(_tmp111 == NULL) ? NULL : (_tmp111 = (vala_ccode_node_unref (_tmp111), NULL));
							_tmp110 = (g_free (_tmp110), NULL);
							if (!vala_method_get_no_array_length (m)) {
								ValaCCodeMemberAccess* _tmp115;
								ValaCCodeIdentifier* _tmp114;
								char* _tmp113;
								_tmp115 = NULL;
								_tmp114 = NULL;
								_tmp113 = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp115 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp114 = vala_ccode_identifier_new (_tmp113 = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)))), "len")));
								(_tmp115 == NULL) ? NULL : (_tmp115 = (vala_ccode_node_unref (_tmp115), NULL));
								(_tmp114 == NULL) ? NULL : (_tmp114 = (vala_ccode_node_unref (_tmp114), NULL));
								_tmp113 = (g_free (_tmp113), NULL);
							}
						}
					}
				} else {
					if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
						char* _tmp116;
						ValaCCodeDeclaration* _tmp117;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp118;
						ValaCCodeUnaryExpression* _tmp120;
						ValaCCodeIdentifier* _tmp119;
						_tmp116 = NULL;
						_tmp117 = NULL;
						cdecl_ = (_tmp117 = vala_ccode_declaration_new (_tmp116 = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param))), _tmp116 = (g_free (_tmp116), NULL), _tmp117);
						_tmp118 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp118 = vala_ccode_variable_declarator_new (vala_symbol_get_name ((ValaSymbol*) param))));
						(_tmp118 == NULL) ? NULL : (_tmp118 = (vala_ccode_node_unref (_tmp118), NULL));
						vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
						_tmp120 = NULL;
						_tmp119 = NULL;
						vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp120 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp119 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))))));
						(_tmp120 == NULL) ? NULL : (_tmp120 = (vala_ccode_node_unref (_tmp120), NULL));
						(_tmp119 == NULL) ? NULL : (_tmp119 = (vala_ccode_node_unref (_tmp119), NULL));
						(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
					} else {
						ValaCCodeIdentifier* _tmp121;
						_tmp121 = NULL;
						vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp121 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
						(_tmp121 == NULL) ? NULL : (_tmp121 = (vala_ccode_node_unref (_tmp121), NULL));
					}
					if (!vala_method_get_no_array_length (m)) {
						ValaCCodeDeclaration* len_cdecl;
						ValaCCodeVariableDeclarator* _tmp123;
						char* _tmp122;
						ValaCCodeUnaryExpression* _tmp126;
						ValaCCodeIdentifier* _tmp125;
						char* _tmp124;
						len_cdecl = vala_ccode_declaration_new ("int");
						_tmp123 = NULL;
						_tmp122 = NULL;
						vala_ccode_declaration_add_declarator (len_cdecl, (ValaCCodeDeclarator*) (_tmp123 = vala_ccode_variable_declarator_new (_tmp122 = g_strdup_printf ("%s_length1", vala_symbol_get_name ((ValaSymbol*) param)))));
						(_tmp123 == NULL) ? NULL : (_tmp123 = (vala_ccode_node_unref (_tmp123), NULL));
						_tmp122 = (g_free (_tmp122), NULL);
						vala_ccode_block_add_statement (block, (ValaCCodeNode*) len_cdecl);
						_tmp126 = NULL;
						_tmp125 = NULL;
						_tmp124 = NULL;
						vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp126 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp125 = vala_ccode_identifier_new (_tmp124 = g_strdup_printf ("%s_length1", vala_symbol_get_name ((ValaSymbol*) param)))))));
						(_tmp126 == NULL) ? NULL : (_tmp126 = (vala_ccode_node_unref (_tmp126), NULL));
						(_tmp125 == NULL) ? NULL : (_tmp125 = (vala_ccode_node_unref (_tmp125), NULL));
						_tmp124 = (g_free (_tmp124), NULL);
						(len_cdecl == NULL) ? NULL : (len_cdecl = (vala_ccode_node_unref (len_cdecl), NULL));
					}
				}
			} else {
				char* _tmp127;
				gboolean _tmp128;
				_tmp127 = NULL;
				if ((_tmp128 = g_str_has_prefix (_tmp127 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param)), "("), _tmp127 = (g_free (_tmp127), NULL), _tmp128)) {
					ValaCCodeUnaryExpression* _tmp130;
					ValaCCodeIdentifier* _tmp129;
					/* struct input or output parameters*/
					_tmp130 = NULL;
					_tmp129 = NULL;
					vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp130 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp129 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))))));
					(_tmp130 == NULL) ? NULL : (_tmp130 = (vala_ccode_node_unref (_tmp130), NULL));
					(_tmp129 == NULL) ? NULL : (_tmp129 = (vala_ccode_node_unref (_tmp129), NULL));
				} else {
					char* _tmp131;
					gboolean _tmp132;
					_tmp131 = NULL;
					if ((_tmp132 = g_str_has_prefix (_tmp131 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param)), "a{"), _tmp131 = (g_free (_tmp131), NULL), _tmp132)) {
						GeeList* type_args;
						ValaDataType* value_type;
						char* _tmp133;
						gboolean _tmp134;
						/* hash table output parameter*/
						type_args = vala_data_type_get_type_arguments (vala_formal_parameter_get_parameter_type (param));
						value_type = (ValaDataType*) gee_list_get (type_args, 1);
						_tmp133 = NULL;
						if ((_tmp134 = g_str_has_prefix (_tmp133 = vala_data_type_get_type_signature (value_type), "("), _tmp133 = (g_free (_tmp133), NULL), _tmp134)) {
							ValaCCodeUnaryExpression* _tmp136;
							ValaCCodeIdentifier* _tmp135;
							/* values are structs*/
							_tmp136 = NULL;
							_tmp135 = NULL;
							vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp136 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp135 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))))));
							(_tmp136 == NULL) ? NULL : (_tmp136 = (vala_ccode_node_unref (_tmp136), NULL));
							(_tmp135 == NULL) ? NULL : (_tmp135 = (vala_ccode_node_unref (_tmp135), NULL));
						} else {
							ValaCCodeIdentifier* _tmp137;
							_tmp137 = NULL;
							vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp137 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
							(_tmp137 == NULL) ? NULL : (_tmp137 = (vala_ccode_node_unref (_tmp137), NULL));
						}
						(type_args == NULL) ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL));
						(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
					} else {
						ValaCCodeIdentifier* _tmp138;
						_tmp138 = NULL;
						vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp138 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
						(_tmp138 == NULL) ? NULL : (_tmp138 = (vala_ccode_node_unref (_tmp138), NULL));
					}
				}
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		}
		(param_it == NULL) ? NULL : (param_it = (gee_collection_object_unref (param_it), NULL));
	}
	expr = NULL;
	if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		ValaCCodeExpression* _tmp140;
		ValaCCodeExpression* _tmp139;
		_tmp140 = NULL;
		_tmp139 = NULL;
		expr = (_tmp140 = (_tmp139 = (ValaCCodeExpression*) ccall, (_tmp139 == NULL) ? NULL : vala_ccode_node_ref (_tmp139)), (expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL)), _tmp140);
	} else {
		ValaArrayType* _tmp142;
		ValaDataType* _tmp141;
		ValaArrayType* array_type;
		_tmp142 = NULL;
		_tmp141 = NULL;
		array_type = (_tmp142 = (_tmp141 = vala_method_get_return_type (m), VALA_IS_ARRAY_TYPE (_tmp141) ? ((ValaArrayType*) _tmp141) : NULL), (_tmp142 == NULL) ? NULL : vala_code_node_ref (_tmp142));
		if (array_type != NULL) {
			ValaCCodeUnaryExpression* _tmp144;
			ValaCCodeIdentifier* _tmp143;
			_tmp144 = NULL;
			_tmp143 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp144 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp143 = vala_ccode_identifier_new ("result_length1")))));
			(_tmp144 == NULL) ? NULL : (_tmp144 = (vala_ccode_node_unref (_tmp144), NULL));
			(_tmp143 == NULL) ? NULL : (_tmp143 = (vala_ccode_node_unref (_tmp143), NULL));
			if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
				ValaCCodeExpression* _tmp146;
				ValaCCodeIdentifier* _tmp145;
				_tmp146 = NULL;
				_tmp145 = NULL;
				expr = (_tmp146 = (ValaCCodeExpression*) vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp145 = vala_ccode_identifier_new ("result")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL)), _tmp146);
				(_tmp145 == NULL) ? NULL : (_tmp145 = (vala_ccode_node_unref (_tmp145), NULL));
			} else {
				ValaCCodeExpression* _tmp148;
				ValaCCodeIdentifier* _tmp147;
				_tmp148 = NULL;
				_tmp147 = NULL;
				expr = (_tmp148 = (ValaCCodeExpression*) vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp147 = vala_ccode_identifier_new ("*result")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL)), _tmp148);
				(_tmp147 == NULL) ? NULL : (_tmp147 = (vala_ccode_node_unref (_tmp147), NULL));
			}
		} else {
			char* _tmp149;
			gboolean _tmp150;
			_tmp149 = NULL;
			if ((_tmp150 = g_str_has_prefix (_tmp149 = vala_data_type_get_type_signature (vala_method_get_return_type (m)), "a{"), _tmp149 = (g_free (_tmp149), NULL), _tmp150)) {
				GeeList* type_args;
				ValaDataType* value_type;
				char* _tmp151;
				gboolean _tmp152;
				/* hash table output parameter*/
				type_args = vala_data_type_get_type_arguments (vala_method_get_return_type (m));
				value_type = (ValaDataType*) gee_list_get (type_args, 1);
				_tmp151 = NULL;
				if ((_tmp152 = g_str_has_prefix (_tmp151 = vala_data_type_get_type_signature (value_type), "("), _tmp151 = (g_free (_tmp151), NULL), _tmp152)) {
					ValaCCodeExpression* _tmp154;
					ValaCCodeIdentifier* _tmp153;
					/* values are structs*/
					_tmp154 = NULL;
					_tmp153 = NULL;
					expr = (_tmp154 = (ValaCCodeExpression*) vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp153 = vala_ccode_identifier_new ("result")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL)), _tmp154);
					(_tmp153 == NULL) ? NULL : (_tmp153 = (vala_ccode_node_unref (_tmp153), NULL));
				} else {
					ValaCCodeExpression* _tmp156;
					ValaCCodeIdentifier* _tmp155;
					_tmp156 = NULL;
					_tmp155 = NULL;
					expr = (_tmp156 = (ValaCCodeExpression*) vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp155 = vala_ccode_identifier_new ("*result")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL)), _tmp156);
					(_tmp155 == NULL) ? NULL : (_tmp155 = (vala_ccode_node_unref (_tmp155), NULL));
				}
				(type_args == NULL) ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL));
				(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
			} else {
				ValaCCodeExpression* _tmp158;
				ValaCCodeIdentifier* _tmp157;
				_tmp158 = NULL;
				_tmp157 = NULL;
				expr = (_tmp158 = (ValaCCodeExpression*) vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp157 = vala_ccode_identifier_new ("*result")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL)), _tmp158);
				(_tmp157 == NULL) ? NULL : (_tmp157 = (vala_ccode_node_unref (_tmp157), NULL));
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	}
	_tmp159 = NULL;
	if ((_tmp160 = gee_collection_get_size ((GeeCollection*) (_tmp159 = vala_code_node_get_error_types ((ValaCodeNode*) m))) > 0, (_tmp159 == NULL) ? NULL : (_tmp159 = (gee_collection_object_unref (_tmp159), NULL)), _tmp160)) {
		ValaCCodeIdentifier* _tmp161;
		_tmp161 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp161 = vala_ccode_identifier_new ("error")));
		(_tmp161 == NULL) ? NULL : (_tmp161 = (vala_ccode_node_unref (_tmp161), NULL));
	}
	_tmp162 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp162 = vala_ccode_expression_statement_new (expr)));
	(_tmp162 == NULL) ? NULL : (_tmp162 = (vala_ccode_node_unref (_tmp162), NULL));
	{
		GeeList* _tmp163;
		GeeIterator* _tmp164;
		GeeIterator* param_it;
		_tmp163 = NULL;
		_tmp164 = NULL;
		param_it = (_tmp164 = gee_iterable_iterator ((GeeIterable*) (_tmp163 = vala_method_get_parameters (m))), (_tmp163 == NULL) ? NULL : (_tmp163 = (gee_collection_object_unref (_tmp163), NULL)), _tmp164);
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = (ValaFormalParameter*) gee_iterator_get (param_it);
			if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
				char* _tmp165;
				gboolean _tmp166;
				_tmp165 = NULL;
				if ((_tmp166 = g_str_has_prefix (_tmp165 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param)), "("), _tmp165 = (g_free (_tmp165), NULL), _tmp166)) {
					ValaStruct* _tmp167;
					ValaStruct* st;
					ValaCCodeIdentifier* _tmp169;
					char* _tmp168;
					ValaCCodeUnaryExpression* _tmp170;
					ValaCCodeUnaryExpression* dbus_param;
					ValaCCodeIdentifier* st_expr;
					/* struct output parameter*/
					_tmp167 = NULL;
					st = (_tmp167 = VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))), (_tmp167 == NULL) ? NULL : vala_code_node_ref (_tmp167));
					_tmp169 = NULL;
					_tmp168 = NULL;
					_tmp170 = NULL;
					dbus_param = (_tmp170 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp169 = vala_ccode_identifier_new (_tmp168 = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param))))), (_tmp169 == NULL) ? NULL : (_tmp169 = (vala_ccode_node_unref (_tmp169), NULL)), _tmp168 = (g_free (_tmp168), NULL), _tmp170);
					st_expr = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param));
					vala_dbus_server_module_transform_struct_to_value_array (self, block, st, (ValaCCodeExpression*) dbus_param, (ValaCCodeExpression*) st_expr, vala_symbol_get_name ((ValaSymbol*) param));
					(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
					(dbus_param == NULL) ? NULL : (dbus_param = (vala_ccode_node_unref (dbus_param), NULL));
					(st_expr == NULL) ? NULL : (st_expr = (vala_ccode_node_unref (st_expr), NULL));
				} else {
					char* _tmp171;
					gboolean _tmp172;
					_tmp171 = NULL;
					if ((_tmp172 = g_str_has_prefix (_tmp171 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param)), "a{"), _tmp171 = (g_free (_tmp171), NULL), _tmp172)) {
						GeeList* type_args;
						ValaDataType* value_type;
						char* _tmp173;
						gboolean _tmp174;
						/* hash table output parameter*/
						type_args = vala_data_type_get_type_arguments (vala_formal_parameter_get_parameter_type (param));
						value_type = (ValaDataType*) gee_list_get (type_args, 1);
						_tmp173 = NULL;
						if ((_tmp174 = g_str_has_prefix (_tmp173 = vala_data_type_get_type_signature (value_type), "("), _tmp173 = (g_free (_tmp173), NULL), _tmp174)) {
							ValaStruct* _tmp175;
							ValaStruct* st;
							ValaCCodeIdentifier* _tmp177;
							char* _tmp176;
							ValaCCodeUnaryExpression* _tmp178;
							ValaCCodeUnaryExpression* dbus_param;
							ValaCCodeIdentifier* table_expr;
							/* values are structs*/
							_tmp175 = NULL;
							st = (_tmp175 = VALA_STRUCT (vala_data_type_get_data_type (value_type)), (_tmp175 == NULL) ? NULL : vala_code_node_ref (_tmp175));
							_tmp177 = NULL;
							_tmp176 = NULL;
							_tmp178 = NULL;
							dbus_param = (_tmp178 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp177 = vala_ccode_identifier_new (_tmp176 = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param))))), (_tmp177 == NULL) ? NULL : (_tmp177 = (vala_ccode_node_unref (_tmp177), NULL)), _tmp176 = (g_free (_tmp176), NULL), _tmp178);
							table_expr = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param));
							vala_dbus_server_module_transform_struct_hash_table_to_value_array_hash_table (self, block, st, (ValaCCodeExpression*) dbus_param, (ValaCCodeExpression*) table_expr, vala_symbol_get_name ((ValaSymbol*) param));
							(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
							(dbus_param == NULL) ? NULL : (dbus_param = (vala_ccode_node_unref (dbus_param), NULL));
							(table_expr == NULL) ? NULL : (table_expr = (vala_ccode_node_unref (table_expr), NULL));
						}
						(type_args == NULL) ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL));
						(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
					}
				}
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(param_it == NULL) ? NULL : (param_it = (gee_collection_object_unref (param_it), NULL));
	}
	if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
		ValaArrayType* _tmp180;
		ValaDataType* _tmp179;
		ValaArrayType* array_type;
		gboolean _tmp181;
		_tmp180 = NULL;
		_tmp179 = NULL;
		array_type = (_tmp180 = (_tmp179 = vala_method_get_return_type (m), VALA_IS_ARRAY_TYPE (_tmp179) ? ((ValaArrayType*) _tmp179) : NULL), (_tmp180 == NULL) ? NULL : vala_code_node_ref (_tmp180));
		_tmp181 = FALSE;
		if (array_type != NULL) {
			_tmp181 = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type);
		} else {
			_tmp181 = FALSE;
		}
		if (_tmp181) {
			ValaCCodeIdentifier* _tmp182;
			ValaCCodeUnaryExpression* _tmp183;
			ValaCCodeUnaryExpression* garray;
			ValaCCodeIdentifier* _tmp184;
			ValaCCodeFunctionCall* _tmp185;
			ValaCCodeFunctionCall* sizeof_call;
			ValaCCodeIdentifier* _tmp187;
			char* _tmp186;
			_tmp182 = NULL;
			_tmp183 = NULL;
			garray = (_tmp183 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp182 = vala_ccode_identifier_new ("dbus_result"))), (_tmp182 == NULL) ? NULL : (_tmp182 = (vala_ccode_node_unref (_tmp182), NULL)), _tmp183);
			_tmp184 = NULL;
			_tmp185 = NULL;
			sizeof_call = (_tmp185 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp184 = vala_ccode_identifier_new ("sizeof"))), (_tmp184 == NULL) ? NULL : (_tmp184 = (vala_ccode_node_unref (_tmp184), NULL)), _tmp185);
			_tmp187 = NULL;
			_tmp186 = NULL;
			vala_ccode_function_call_add_argument (sizeof_call, (ValaCCodeExpression*) (_tmp187 = vala_ccode_identifier_new (_tmp186 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
			(_tmp187 == NULL) ? NULL : (_tmp187 = (vala_ccode_node_unref (_tmp187), NULL));
			_tmp186 = (g_free (_tmp186), NULL);
			if (vala_dbus_client_module_dbus_use_ptr_array ((ValaDBusClientModule*) self, array_type)) {
				ValaCCodeIdentifier* _tmp188;
				ValaCCodeFunctionCall* _tmp189;
				ValaCCodeFunctionCall* array_construct;
				ValaCCodeIdentifier* _tmp190;
				ValaCCodeExpressionStatement* _tmp192;
				ValaCCodeAssignment* _tmp191;
				ValaCCodeIdentifier* _tmp193;
				ValaCCodeFunctionCall* _tmp194;
				ValaCCodeFunctionCall* memcpy_call;
				ValaCCodeMemberAccess* _tmp195;
				ValaCCodeIdentifier* _tmp196;
				ValaCCodeBinaryExpression* _tmp198;
				ValaCCodeIdentifier* _tmp197;
				ValaCCodeExpressionStatement* _tmp199;
				ValaCCodeIdentifier* _tmp201;
				ValaCCodeMemberAccess* _tmp200;
				ValaCCodeAssignment* _tmp202;
				ValaCCodeAssignment* len_assignment;
				ValaCCodeExpressionStatement* _tmp203;
				_tmp188 = NULL;
				_tmp189 = NULL;
				array_construct = (_tmp189 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp188 = vala_ccode_identifier_new ("g_ptr_array_sized_new"))), (_tmp188 == NULL) ? NULL : (_tmp188 = (vala_ccode_node_unref (_tmp188), NULL)), _tmp189);
				_tmp190 = NULL;
				vala_ccode_function_call_add_argument (array_construct, (ValaCCodeExpression*) (_tmp190 = vala_ccode_identifier_new ("result_length1")));
				(_tmp190 == NULL) ? NULL : (_tmp190 = (vala_ccode_node_unref (_tmp190), NULL));
				_tmp192 = NULL;
				_tmp191 = NULL;
				vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp192 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp191 = vala_ccode_assignment_new ((ValaCCodeExpression*) garray, (ValaCCodeExpression*) array_construct, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp192 == NULL) ? NULL : (_tmp192 = (vala_ccode_node_unref (_tmp192), NULL));
				(_tmp191 == NULL) ? NULL : (_tmp191 = (vala_ccode_node_unref (_tmp191), NULL));
				_tmp193 = NULL;
				_tmp194 = NULL;
				memcpy_call = (_tmp194 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp193 = vala_ccode_identifier_new ("memcpy"))), (_tmp193 == NULL) ? NULL : (_tmp193 = (vala_ccode_node_unref (_tmp193), NULL)), _tmp194);
				_tmp195 = NULL;
				vala_ccode_function_call_add_argument (memcpy_call, (ValaCCodeExpression*) (_tmp195 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) garray, "pdata")));
				(_tmp195 == NULL) ? NULL : (_tmp195 = (vala_ccode_node_unref (_tmp195), NULL));
				_tmp196 = NULL;
				vala_ccode_function_call_add_argument (memcpy_call, (ValaCCodeExpression*) (_tmp196 = vala_ccode_identifier_new ("result")));
				(_tmp196 == NULL) ? NULL : (_tmp196 = (vala_ccode_node_unref (_tmp196), NULL));
				_tmp198 = NULL;
				_tmp197 = NULL;
				vala_ccode_function_call_add_argument (memcpy_call, (ValaCCodeExpression*) (_tmp198 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp197 = vala_ccode_identifier_new ("result_length1")), (ValaCCodeExpression*) sizeof_call)));
				(_tmp198 == NULL) ? NULL : (_tmp198 = (vala_ccode_node_unref (_tmp198), NULL));
				(_tmp197 == NULL) ? NULL : (_tmp197 = (vala_ccode_node_unref (_tmp197), NULL));
				_tmp199 = NULL;
				vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp199 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) memcpy_call)));
				(_tmp199 == NULL) ? NULL : (_tmp199 = (vala_ccode_node_unref (_tmp199), NULL));
				_tmp201 = NULL;
				_tmp200 = NULL;
				_tmp202 = NULL;
				len_assignment = (_tmp202 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp200 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) garray, "len")), (ValaCCodeExpression*) (_tmp201 = vala_ccode_identifier_new ("result_length1")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp201 == NULL) ? NULL : (_tmp201 = (vala_ccode_node_unref (_tmp201), NULL)), (_tmp200 == NULL) ? NULL : (_tmp200 = (vala_ccode_node_unref (_tmp200), NULL)), _tmp202);
				_tmp203 = NULL;
				vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp203 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) len_assignment)));
				(_tmp203 == NULL) ? NULL : (_tmp203 = (vala_ccode_node_unref (_tmp203), NULL));
				(array_construct == NULL) ? NULL : (array_construct = (vala_ccode_node_unref (array_construct), NULL));
				(memcpy_call == NULL) ? NULL : (memcpy_call = (vala_ccode_node_unref (memcpy_call), NULL));
				(len_assignment == NULL) ? NULL : (len_assignment = (vala_ccode_node_unref (len_assignment), NULL));
			} else {
				ValaCCodeIdentifier* _tmp204;
				ValaCCodeFunctionCall* _tmp205;
				ValaCCodeFunctionCall* array_construct;
				ValaCCodeConstant* _tmp206;
				ValaCCodeConstant* _tmp207;
				ValaCCodeExpressionStatement* _tmp209;
				ValaCCodeAssignment* _tmp208;
				ValaCCodeIdentifier* _tmp210;
				ValaCCodeFunctionCall* _tmp211;
				ValaCCodeFunctionCall* cappend_call;
				ValaCCodeIdentifier* _tmp212;
				ValaCCodeIdentifier* _tmp213;
				ValaCCodeExpressionStatement* _tmp214;
				_tmp204 = NULL;
				_tmp205 = NULL;
				array_construct = (_tmp205 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp204 = vala_ccode_identifier_new ("g_array_new"))), (_tmp204 == NULL) ? NULL : (_tmp204 = (vala_ccode_node_unref (_tmp204), NULL)), _tmp205);
				_tmp206 = NULL;
				vala_ccode_function_call_add_argument (array_construct, (ValaCCodeExpression*) (_tmp206 = vala_ccode_constant_new ("TRUE")));
				(_tmp206 == NULL) ? NULL : (_tmp206 = (vala_ccode_node_unref (_tmp206), NULL));
				_tmp207 = NULL;
				vala_ccode_function_call_add_argument (array_construct, (ValaCCodeExpression*) (_tmp207 = vala_ccode_constant_new ("TRUE")));
				(_tmp207 == NULL) ? NULL : (_tmp207 = (vala_ccode_node_unref (_tmp207), NULL));
				vala_ccode_function_call_add_argument (array_construct, (ValaCCodeExpression*) sizeof_call);
				_tmp209 = NULL;
				_tmp208 = NULL;
				vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp209 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp208 = vala_ccode_assignment_new ((ValaCCodeExpression*) garray, (ValaCCodeExpression*) array_construct, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp209 == NULL) ? NULL : (_tmp209 = (vala_ccode_node_unref (_tmp209), NULL));
				(_tmp208 == NULL) ? NULL : (_tmp208 = (vala_ccode_node_unref (_tmp208), NULL));
				_tmp210 = NULL;
				_tmp211 = NULL;
				cappend_call = (_tmp211 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp210 = vala_ccode_identifier_new ("g_array_append_vals"))), (_tmp210 == NULL) ? NULL : (_tmp210 = (vala_ccode_node_unref (_tmp210), NULL)), _tmp211);
				vala_ccode_function_call_add_argument (cappend_call, (ValaCCodeExpression*) garray);
				_tmp212 = NULL;
				vala_ccode_function_call_add_argument (cappend_call, (ValaCCodeExpression*) (_tmp212 = vala_ccode_identifier_new ("result")));
				(_tmp212 == NULL) ? NULL : (_tmp212 = (vala_ccode_node_unref (_tmp212), NULL));
				_tmp213 = NULL;
				vala_ccode_function_call_add_argument (cappend_call, (ValaCCodeExpression*) (_tmp213 = vala_ccode_identifier_new ("result_length1")));
				(_tmp213 == NULL) ? NULL : (_tmp213 = (vala_ccode_node_unref (_tmp213), NULL));
				_tmp214 = NULL;
				vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp214 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cappend_call)));
				(_tmp214 == NULL) ? NULL : (_tmp214 = (vala_ccode_node_unref (_tmp214), NULL));
				(array_construct == NULL) ? NULL : (array_construct = (vala_ccode_node_unref (array_construct), NULL));
				(cappend_call == NULL) ? NULL : (cappend_call = (vala_ccode_node_unref (cappend_call), NULL));
			}
			(garray == NULL) ? NULL : (garray = (vala_ccode_node_unref (garray), NULL));
			(sizeof_call == NULL) ? NULL : (sizeof_call = (vala_ccode_node_unref (sizeof_call), NULL));
		} else {
			char* _tmp215;
			gboolean _tmp216;
			_tmp215 = NULL;
			if ((_tmp216 = g_str_has_prefix (_tmp215 = vala_data_type_get_type_signature (vala_method_get_return_type (m)), "a{"), _tmp215 = (g_free (_tmp215), NULL), _tmp216)) {
				GeeList* type_args;
				ValaDataType* value_type;
				char* _tmp217;
				gboolean _tmp218;
				/* hash table output parameter*/
				type_args = vala_data_type_get_type_arguments (vala_method_get_return_type (m));
				value_type = (ValaDataType*) gee_list_get (type_args, 1);
				_tmp217 = NULL;
				if ((_tmp218 = g_str_has_prefix (_tmp217 = vala_data_type_get_type_signature (value_type), "("), _tmp217 = (g_free (_tmp217), NULL), _tmp218)) {
					ValaStruct* _tmp219;
					ValaStruct* st;
					ValaCCodeIdentifier* _tmp220;
					ValaCCodeUnaryExpression* _tmp221;
					ValaCCodeUnaryExpression* dbus_param;
					ValaCCodeIdentifier* table_expr;
					/* values are structs*/
					_tmp219 = NULL;
					st = (_tmp219 = VALA_STRUCT (vala_data_type_get_data_type (value_type)), (_tmp219 == NULL) ? NULL : vala_code_node_ref (_tmp219));
					_tmp220 = NULL;
					_tmp221 = NULL;
					dbus_param = (_tmp221 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp220 = vala_ccode_identifier_new ("dbus_result"))), (_tmp220 == NULL) ? NULL : (_tmp220 = (vala_ccode_node_unref (_tmp220), NULL)), _tmp221);
					table_expr = vala_ccode_identifier_new ("result");
					vala_dbus_server_module_transform_struct_hash_table_to_value_array_hash_table (self, block, st, (ValaCCodeExpression*) dbus_param, (ValaCCodeExpression*) table_expr, "result");
					(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
					(dbus_param == NULL) ? NULL : (dbus_param = (vala_ccode_node_unref (dbus_param), NULL));
					(table_expr == NULL) ? NULL : (table_expr = (vala_ccode_node_unref (table_expr), NULL));
				}
				(type_args == NULL) ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL));
				(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	}
	_tmp223 = NULL;
	_tmp222 = NULL;
	_tmp224 = NULL;
	no_error = (_tmp224 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, (ValaCCodeExpression*) (_tmp222 = vala_ccode_identifier_new ("!error")), (ValaCCodeExpression*) (_tmp223 = vala_ccode_identifier_new ("!*error"))), (_tmp223 == NULL) ? NULL : (_tmp223 = (vala_ccode_node_unref (_tmp223), NULL)), (_tmp222 == NULL) ? NULL : (_tmp222 = (vala_ccode_node_unref (_tmp222), NULL)), _tmp224);
	_tmp225 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp225 = vala_ccode_return_statement_new ((ValaCCodeExpression*) no_error)));
	(_tmp225 == NULL) ? NULL : (_tmp225 = (vala_ccode_node_unref (_tmp225), NULL));
	/* append to file*/
	_tmp226 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp226 = vala_ccode_function_copy (function)));
	(_tmp226 == NULL) ? NULL : (_tmp226 = (vala_ccode_node_unref (_tmp226), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	_tmp227 = NULL;
	return (_tmp227 = wrapper_name, (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), (expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL)), (no_error == NULL) ? NULL : (no_error = (vala_ccode_node_unref (no_error), NULL)), _tmp227);
}


static void vala_dbus_server_module_class_init (ValaDBusServerModuleClass * klass) {
	vala_dbus_server_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->register_dbus_info = vala_dbus_server_module_real_register_dbus_info;
}


static void vala_dbus_server_module_instance_init (ValaDBusServerModule * self) {
}


GType vala_dbus_server_module_get_type (void) {
	static GType vala_dbus_server_module_type_id = 0;
	if (vala_dbus_server_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDBusServerModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_dbus_server_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDBusServerModule), 0, (GInstanceInitFunc) vala_dbus_server_module_instance_init, NULL };
		vala_dbus_server_module_type_id = g_type_register_static (VALA_TYPE_DBUS_CLIENT_MODULE, "ValaDBusServerModule", &g_define_type_info, 0);
	}
	return vala_dbus_server_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




