/* valaphifunction.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaphifunction.h>
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <vala/valalocalvariable.h>
#include <gobject/gvaluecollector.h>




struct _ValaPhiFunctionPrivate {
	ValaLocalVariable* _original_variable;
	GeeList* _operands;
};

#define VALA_PHI_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_PHI_FUNCTION, ValaPhiFunctionPrivate))
enum  {
	VALA_PHI_FUNCTION_DUMMY_PROPERTY
};
static void vala_phi_function_set_original_variable (ValaPhiFunction* self, ValaLocalVariable* value);
static void vala_phi_function_set_operands (ValaPhiFunction* self, GeeList* value);
static gpointer vala_phi_function_parent_class = NULL;
static void vala_phi_function_finalize (ValaPhiFunction* obj);



ValaPhiFunction* vala_phi_function_construct (GType object_type, ValaLocalVariable* variable, gint num_of_ops) {
	ValaPhiFunction* self;
	GeeArrayList* _tmp0;
	g_return_val_if_fail (variable != NULL, NULL);
	self = (ValaPhiFunction*) g_type_create_instance (object_type);
	vala_phi_function_set_original_variable (self, variable);
	_tmp0 = NULL;
	vala_phi_function_set_operands (self, (GeeList*) (_tmp0 = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal)));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL));
	{
		gint i;
		i = 0;
		for (; i < num_of_ops; i++) {
			gee_collection_add ((GeeCollection*) self->priv->_operands, VALA_LOCAL_VARIABLE (NULL));
		}
	}
	return self;
}


ValaPhiFunction* vala_phi_function_new (ValaLocalVariable* variable, gint num_of_ops) {
	return vala_phi_function_construct (VALA_TYPE_PHI_FUNCTION, variable, num_of_ops);
}


ValaLocalVariable* vala_phi_function_get_original_variable (ValaPhiFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_original_variable;
}


static void vala_phi_function_set_original_variable (ValaPhiFunction* self, ValaLocalVariable* value) {
	ValaLocalVariable* _tmp2;
	ValaLocalVariable* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_original_variable = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_original_variable == NULL) ? NULL : (self->priv->_original_variable = (vala_code_node_unref (self->priv->_original_variable), NULL)), _tmp2);
}


GeeList* vala_phi_function_get_operands (ValaPhiFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_operands;
}


static void vala_phi_function_set_operands (ValaPhiFunction* self, GeeList* value) {
	GeeList* _tmp2;
	GeeList* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_operands = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : gee_collection_object_ref (_tmp1)), (self->priv->_operands == NULL) ? NULL : (self->priv->_operands = (gee_collection_object_unref (self->priv->_operands), NULL)), _tmp2);
}


static void vala_value_phi_function_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_phi_function_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_phi_function_unref (value->data[0].v_pointer);
	}
}


static void vala_value_phi_function_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_phi_function_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_phi_function_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_phi_function_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaPhiFunction* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_phi_function_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_phi_function_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaPhiFunction** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_phi_function_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_phi_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecPhiFunction* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_PHI_FUNCTION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_phi_function (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_PHI_FUNCTION), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_phi_function (GValue* value, gpointer v_object) {
	ValaPhiFunction* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_PHI_FUNCTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_PHI_FUNCTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_phi_function_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_phi_function_unref (old);
	}
}


static void vala_phi_function_class_init (ValaPhiFunctionClass * klass) {
	vala_phi_function_parent_class = g_type_class_peek_parent (klass);
	VALA_PHI_FUNCTION_CLASS (klass)->finalize = vala_phi_function_finalize;
	g_type_class_add_private (klass, sizeof (ValaPhiFunctionPrivate));
}


static void vala_phi_function_instance_init (ValaPhiFunction * self) {
	self->priv = VALA_PHI_FUNCTION_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_phi_function_finalize (ValaPhiFunction* obj) {
	ValaPhiFunction * self;
	self = VALA_PHI_FUNCTION (obj);
	(self->priv->_original_variable == NULL) ? NULL : (self->priv->_original_variable = (vala_code_node_unref (self->priv->_original_variable), NULL));
	(self->priv->_operands == NULL) ? NULL : (self->priv->_operands = (gee_collection_object_unref (self->priv->_operands), NULL));
}


GType vala_phi_function_get_type (void) {
	static GType vala_phi_function_type_id = 0;
	if (vala_phi_function_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_phi_function_init, vala_value_phi_function_free_value, vala_value_phi_function_copy_value, vala_value_phi_function_peek_pointer, "p", vala_value_phi_function_collect_value, "p", vala_value_phi_function_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaPhiFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_phi_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaPhiFunction), 0, (GInstanceInitFunc) vala_phi_function_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		vala_phi_function_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaPhiFunction", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return vala_phi_function_type_id;
}


gpointer vala_phi_function_ref (gpointer instance) {
	ValaPhiFunction* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_phi_function_unref (gpointer instance) {
	ValaPhiFunction* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_PHI_FUNCTION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}




