/* valaarraycreationexpression.vala
 *
 * Copyright (C) 2006-2008  Raffaele Sandrini, Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAARRAYCREATIONEXPRESSION_H__
#define __VALA_VALAARRAYCREATIONEXPRESSION_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/list.h>
#include <vala/valaexpression.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_ARRAY_CREATION_EXPRESSION (vala_array_creation_expression_get_type ())
#define VALA_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression))
#define VALA_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))
#define VALA_IS_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_IS_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_ARRAY_CREATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))

typedef struct _ValaArrayCreationExpressionPrivate ValaArrayCreationExpressionPrivate;

/**
 * Represents an array creation expression e.g. "new int[] {1,2,3}".
 */
struct _ValaArrayCreationExpression {
	ValaExpression parent_instance;
	ValaArrayCreationExpressionPrivate * priv;
};

struct _ValaArrayCreationExpressionClass {
	ValaExpressionClass parent_class;
};


void vala_array_creation_expression_append_size (ValaArrayCreationExpression* self, ValaExpression* size);
GeeList* vala_array_creation_expression_get_sizes (ValaArrayCreationExpression* self);
ValaArrayCreationExpression* vala_array_creation_expression_construct (GType object_type, ValaDataType* element_type, gint rank, ValaInitializerList* initializer_list, ValaSourceReference* source_reference);
ValaArrayCreationExpression* vala_array_creation_expression_new (ValaDataType* element_type, gint rank, ValaInitializerList* initializer_list, ValaSourceReference* source_reference);
ValaDataType* vala_array_creation_expression_get_element_type (ValaArrayCreationExpression* self);
void vala_array_creation_expression_set_element_type (ValaArrayCreationExpression* self, ValaDataType* value);
gint vala_array_creation_expression_get_rank (ValaArrayCreationExpression* self);
void vala_array_creation_expression_set_rank (ValaArrayCreationExpression* self, gint value);
ValaInitializerList* vala_array_creation_expression_get_initializer_list (ValaArrayCreationExpression* self);
void vala_array_creation_expression_set_initializer_list (ValaArrayCreationExpression* self, ValaInitializerList* value);
GType vala_array_creation_expression_get_type (void);


G_END_DECLS

#endif
