/* valaccodegenerator.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodegenerator.h>
#include <gobject/valadbusservermodule.h>
#include <gobject/valaccodemodule.h>




enum  {
	VALA_CCODE_GENERATOR_DUMMY_PROPERTY
};
static void vala_ccode_generator_real_emit (ValaCodeGenerator* base, ValaCodeContext* context);
static void vala_ccode_generator_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static void vala_ccode_generator_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_ccode_generator_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_ccode_generator_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_ccode_generator_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_ccode_generator_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev);
static void vala_ccode_generator_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain);
static void vala_ccode_generator_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode);
static void vala_ccode_generator_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d);
static void vala_ccode_generator_real_visit_member (ValaCodeVisitor* base, ValaMember* m);
static void vala_ccode_generator_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void vala_ccode_generator_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void vala_ccode_generator_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static void vala_ccode_generator_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void vala_ccode_generator_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p);
static void vala_ccode_generator_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_ccode_generator_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc);
static void vala_ccode_generator_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static void vala_ccode_generator_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c);
static void vala_ccode_generator_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d);
static void vala_ccode_generator_real_visit_block (ValaCodeVisitor* base, ValaBlock* b);
static void vala_ccode_generator_real_visit_empty_statement (ValaCodeVisitor* base, ValaEmptyStatement* stmt);
static void vala_ccode_generator_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt);
static void vala_ccode_generator_real_visit_local_variable (ValaCodeVisitor* base, ValaLocalVariable* local);
static void vala_ccode_generator_real_visit_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list);
static void vala_ccode_generator_real_visit_end_full_expression (ValaCodeVisitor* base, ValaExpression* expr);
static void vala_ccode_generator_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt);
static void vala_ccode_generator_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt);
static void vala_ccode_generator_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt);
static void vala_ccode_generator_real_visit_switch_section (ValaCodeVisitor* base, ValaSwitchSection* section);
static void vala_ccode_generator_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt);
static void vala_ccode_generator_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt);
static void vala_ccode_generator_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt);
static void vala_ccode_generator_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt);
static void vala_ccode_generator_real_visit_break_statement (ValaCodeVisitor* base, ValaBreakStatement* stmt);
static void vala_ccode_generator_real_visit_continue_statement (ValaCodeVisitor* base, ValaContinueStatement* stmt);
static void vala_ccode_generator_real_visit_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt);
static void vala_ccode_generator_real_visit_yield_statement (ValaCodeVisitor* base, ValaYieldStatement* stmt);
static void vala_ccode_generator_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt);
static void vala_ccode_generator_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt);
static void vala_ccode_generator_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause);
static void vala_ccode_generator_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt);
static void vala_ccode_generator_real_visit_delete_statement (ValaCodeVisitor* base, ValaDeleteStatement* stmt);
static void vala_ccode_generator_real_visit_expression (ValaCodeVisitor* base, ValaExpression* expr);
static void vala_ccode_generator_real_visit_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* expr);
static void vala_ccode_generator_real_visit_boolean_literal (ValaCodeVisitor* base, ValaBooleanLiteral* expr);
static void vala_ccode_generator_real_visit_character_literal (ValaCodeVisitor* base, ValaCharacterLiteral* expr);
static void vala_ccode_generator_real_visit_integer_literal (ValaCodeVisitor* base, ValaIntegerLiteral* expr);
static void vala_ccode_generator_real_visit_real_literal (ValaCodeVisitor* base, ValaRealLiteral* expr);
static void vala_ccode_generator_real_visit_string_literal (ValaCodeVisitor* base, ValaStringLiteral* expr);
static void vala_ccode_generator_real_visit_null_literal (ValaCodeVisitor* base, ValaNullLiteral* expr);
static void vala_ccode_generator_real_visit_parenthesized_expression (ValaCodeVisitor* base, ValaParenthesizedExpression* expr);
static void vala_ccode_generator_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr);
static void vala_ccode_generator_real_visit_invocation_expression (ValaCodeVisitor* base, ValaInvocationExpression* expr);
static void vala_ccode_generator_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr);
static void vala_ccode_generator_real_visit_base_access (ValaCodeVisitor* base, ValaBaseAccess* expr);
static void vala_ccode_generator_real_visit_postfix_expression (ValaCodeVisitor* base, ValaPostfixExpression* expr);
static void vala_ccode_generator_real_visit_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr);
static void vala_ccode_generator_real_visit_sizeof_expression (ValaCodeVisitor* base, ValaSizeofExpression* expr);
static void vala_ccode_generator_real_visit_typeof_expression (ValaCodeVisitor* base, ValaTypeofExpression* expr);
static void vala_ccode_generator_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr);
static void vala_ccode_generator_real_visit_cast_expression (ValaCodeVisitor* base, ValaCastExpression* expr);
static void vala_ccode_generator_real_visit_pointer_indirection (ValaCodeVisitor* base, ValaPointerIndirection* expr);
static void vala_ccode_generator_real_visit_addressof_expression (ValaCodeVisitor* base, ValaAddressofExpression* expr);
static void vala_ccode_generator_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr);
static void vala_ccode_generator_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr);
static void vala_ccode_generator_real_visit_type_check (ValaCodeVisitor* base, ValaTypeCheck* expr);
static void vala_ccode_generator_real_visit_conditional_expression (ValaCodeVisitor* base, ValaConditionalExpression* expr);
static void vala_ccode_generator_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l);
static void vala_ccode_generator_real_visit_assignment (ValaCodeVisitor* base, ValaAssignment* a);
static gpointer vala_ccode_generator_parent_class = NULL;
static void vala_ccode_generator_finalize (ValaCodeVisitor* obj);



ValaCCodeGenerator* vala_ccode_generator_construct (GType object_type) {
	ValaCCodeGenerator* self;
	ValaCCodeModule* _tmp0;
	self = ((ValaCCodeGenerator*) (g_type_create_instance (object_type)));
	/* included by inheritance
	head = new CCodeBaseModule (this, head);
	head = new CCodeStructModule (this, head);
	head = new CCodeMethodModule (this, head);
	head = new CCodeMemberAccessModule (this, head);
	head = new CCodeAssignmentModule (this, head);
	head = new CCodeInvocationExpressionModule (this, head);
	head = new CCodeArrayModule (this, head);
	head = new CCodeDelegateModule (this, head);
	head = new CCodeDynamicPropertyModule (this, head);
	head = new CCodeDynamicSignalModule (this, head);
	head = new GErrorModule (this, head);
	head = new GTypeModule (this, head);
	head = new GObjectModule (this, head);
	head = new GSignalModule (this, head);
	head = new GAsyncModule (this, head);
	head = new DBusClientModule (this, head);
	*/
	_tmp0 = NULL;
	self->head = (_tmp0 = ((ValaCCodeModule*) (vala_dbus_server_module_new (self, self->head))), (self->head == NULL ? NULL : (self->head = (vala_ccode_module_unref (self->head), NULL))), _tmp0);
	return self;
}


ValaCCodeGenerator* vala_ccode_generator_new (void) {
	return vala_ccode_generator_construct (VALA_TYPE_CCODE_GENERATOR);
}


static void vala_ccode_generator_real_emit (ValaCodeGenerator* base, ValaCodeContext* context) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (context != NULL);
	vala_ccode_module_emit (self->head, context);
}


static void vala_ccode_generator_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (source_file != NULL);
	vala_ccode_module_visit_source_file (self->head, source_file);
}


static void vala_ccode_generator_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (cl != NULL);
	vala_ccode_module_visit_class (self->head, cl);
}


static void vala_ccode_generator_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (iface != NULL);
	vala_ccode_module_visit_interface (self->head, iface);
}


static void vala_ccode_generator_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (st != NULL);
	vala_ccode_module_visit_struct (self->head, st);
}


static void vala_ccode_generator_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (en != NULL);
	vala_ccode_module_visit_enum (self->head, en);
}


static void vala_ccode_generator_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (ev != NULL);
	vala_ccode_module_visit_enum_value (self->head, ev);
}


static void vala_ccode_generator_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (edomain != NULL);
	vala_ccode_module_visit_error_domain (self->head, edomain);
}


static void vala_ccode_generator_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (ecode != NULL);
	vala_ccode_module_visit_error_code (self->head, ecode);
}


static void vala_ccode_generator_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (d != NULL);
	vala_ccode_module_visit_delegate (self->head, d);
}


static void vala_ccode_generator_real_visit_member (ValaCodeVisitor* base, ValaMember* m) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (m != NULL);
	vala_ccode_module_visit_member (self->head, m);
}


static void vala_ccode_generator_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (c != NULL);
	vala_ccode_module_visit_constant (self->head, c);
}


static void vala_ccode_generator_real_visit_field (ValaCodeVisitor* base, ValaField* f) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (f != NULL);
	vala_ccode_module_visit_field (self->head, f);
}


static void vala_ccode_generator_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (m != NULL);
	vala_ccode_module_visit_method (self->head, m);
}


static void vala_ccode_generator_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (m != NULL);
	vala_ccode_module_visit_creation_method (self->head, m);
}


static void vala_ccode_generator_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (p != NULL);
	vala_ccode_module_visit_formal_parameter (self->head, p);
}


static void vala_ccode_generator_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (prop != NULL);
	vala_ccode_module_visit_property (self->head, prop);
}


static void vala_ccode_generator_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (acc != NULL);
	vala_ccode_module_visit_property_accessor (self->head, acc);
}


static void vala_ccode_generator_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (sig != NULL);
	vala_ccode_module_visit_signal (self->head, sig);
}


static void vala_ccode_generator_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (c != NULL);
	vala_ccode_module_visit_constructor (self->head, c);
}


static void vala_ccode_generator_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (d != NULL);
	vala_ccode_module_visit_destructor (self->head, d);
}


static void vala_ccode_generator_real_visit_block (ValaCodeVisitor* base, ValaBlock* b) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (b != NULL);
	vala_ccode_module_visit_block (self->head, b);
}


static void vala_ccode_generator_real_visit_empty_statement (ValaCodeVisitor* base, ValaEmptyStatement* stmt) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_empty_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_declaration_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_local_variable (ValaCodeVisitor* base, ValaLocalVariable* local) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (local != NULL);
	vala_ccode_module_visit_local_variable (self->head, local);
}


static void vala_ccode_generator_real_visit_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (list != NULL);
	vala_ccode_module_visit_initializer_list (self->head, list);
}


static void vala_ccode_generator_real_visit_end_full_expression (ValaCodeVisitor* base, ValaExpression* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_end_full_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_expression_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_if_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_switch_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_switch_section (ValaCodeVisitor* base, ValaSwitchSection* section) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (section != NULL);
	vala_ccode_module_visit_switch_section (self->head, section);
}


static void vala_ccode_generator_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_while_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_do_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_for_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_foreach_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_break_statement (ValaCodeVisitor* base, ValaBreakStatement* stmt) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_break_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_continue_statement (ValaCodeVisitor* base, ValaContinueStatement* stmt) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_continue_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_return_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_yield_statement (ValaCodeVisitor* base, ValaYieldStatement* stmt) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_yield_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_throw_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_try_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (clause != NULL);
	vala_ccode_module_visit_catch_clause (self->head, clause);
}


static void vala_ccode_generator_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_lock_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_delete_statement (ValaCodeVisitor* base, ValaDeleteStatement* stmt) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (stmt != NULL);
	vala_ccode_module_visit_delete_statement (self->head, stmt);
}


static void vala_ccode_generator_real_visit_expression (ValaCodeVisitor* base, ValaExpression* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_array_creation_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_boolean_literal (ValaCodeVisitor* base, ValaBooleanLiteral* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_boolean_literal (self->head, expr);
}


static void vala_ccode_generator_real_visit_character_literal (ValaCodeVisitor* base, ValaCharacterLiteral* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_character_literal (self->head, expr);
}


static void vala_ccode_generator_real_visit_integer_literal (ValaCodeVisitor* base, ValaIntegerLiteral* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_integer_literal (self->head, expr);
}


static void vala_ccode_generator_real_visit_real_literal (ValaCodeVisitor* base, ValaRealLiteral* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_real_literal (self->head, expr);
}


static void vala_ccode_generator_real_visit_string_literal (ValaCodeVisitor* base, ValaStringLiteral* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_string_literal (self->head, expr);
}


static void vala_ccode_generator_real_visit_null_literal (ValaCodeVisitor* base, ValaNullLiteral* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_null_literal (self->head, expr);
}


static void vala_ccode_generator_real_visit_parenthesized_expression (ValaCodeVisitor* base, ValaParenthesizedExpression* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_parenthesized_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_member_access (self->head, expr);
}


static void vala_ccode_generator_real_visit_invocation_expression (ValaCodeVisitor* base, ValaInvocationExpression* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_invocation_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_element_access (self->head, expr);
}


static void vala_ccode_generator_real_visit_base_access (ValaCodeVisitor* base, ValaBaseAccess* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_base_access (self->head, expr);
}


static void vala_ccode_generator_real_visit_postfix_expression (ValaCodeVisitor* base, ValaPostfixExpression* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_postfix_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_object_creation_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_sizeof_expression (ValaCodeVisitor* base, ValaSizeofExpression* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_sizeof_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_typeof_expression (ValaCodeVisitor* base, ValaTypeofExpression* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_typeof_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_unary_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_cast_expression (ValaCodeVisitor* base, ValaCastExpression* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_cast_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_pointer_indirection (ValaCodeVisitor* base, ValaPointerIndirection* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_pointer_indirection (self->head, expr);
}


static void vala_ccode_generator_real_visit_addressof_expression (ValaCodeVisitor* base, ValaAddressofExpression* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_addressof_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_reference_transfer_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_binary_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_type_check (ValaCodeVisitor* base, ValaTypeCheck* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_type_check (self->head, expr);
}


static void vala_ccode_generator_real_visit_conditional_expression (ValaCodeVisitor* base, ValaConditionalExpression* expr) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (expr != NULL);
	vala_ccode_module_visit_conditional_expression (self->head, expr);
}


static void vala_ccode_generator_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (l != NULL);
	vala_ccode_module_visit_lambda_expression (self->head, l);
}


static void vala_ccode_generator_real_visit_assignment (ValaCodeVisitor* base, ValaAssignment* a) {
	ValaCCodeGenerator * self;
	self = ((ValaCCodeGenerator*) (base));
	g_return_if_fail (a != NULL);
	vala_ccode_module_visit_assignment (self->head, a);
}


static void vala_ccode_generator_class_init (ValaCCodeGeneratorClass * klass) {
	vala_ccode_generator_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = vala_ccode_generator_finalize;
	VALA_CODE_GENERATOR_CLASS (klass)->emit = vala_ccode_generator_real_emit;
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_ccode_generator_real_visit_source_file;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_ccode_generator_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_ccode_generator_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_ccode_generator_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_ccode_generator_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum_value = vala_ccode_generator_real_visit_enum_value;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_domain = vala_ccode_generator_real_visit_error_domain;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_code = vala_ccode_generator_real_visit_error_code;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delegate = vala_ccode_generator_real_visit_delegate;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member = vala_ccode_generator_real_visit_member;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = vala_ccode_generator_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = vala_ccode_generator_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = vala_ccode_generator_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_creation_method = vala_ccode_generator_real_visit_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_formal_parameter = vala_ccode_generator_real_visit_formal_parameter;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = vala_ccode_generator_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property_accessor = vala_ccode_generator_real_visit_property_accessor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = vala_ccode_generator_real_visit_signal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constructor = vala_ccode_generator_real_visit_constructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_destructor = vala_ccode_generator_real_visit_destructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_block = vala_ccode_generator_real_visit_block;
	VALA_CODE_VISITOR_CLASS (klass)->visit_empty_statement = vala_ccode_generator_real_visit_empty_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_declaration_statement = vala_ccode_generator_real_visit_declaration_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_local_variable = vala_ccode_generator_real_visit_local_variable;
	VALA_CODE_VISITOR_CLASS (klass)->visit_initializer_list = vala_ccode_generator_real_visit_initializer_list;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_full_expression = vala_ccode_generator_real_visit_end_full_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_expression_statement = vala_ccode_generator_real_visit_expression_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_if_statement = vala_ccode_generator_real_visit_if_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_statement = vala_ccode_generator_real_visit_switch_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_section = vala_ccode_generator_real_visit_switch_section;
	VALA_CODE_VISITOR_CLASS (klass)->visit_while_statement = vala_ccode_generator_real_visit_while_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_do_statement = vala_ccode_generator_real_visit_do_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_for_statement = vala_ccode_generator_real_visit_for_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_foreach_statement = vala_ccode_generator_real_visit_foreach_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_break_statement = vala_ccode_generator_real_visit_break_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_continue_statement = vala_ccode_generator_real_visit_continue_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_return_statement = vala_ccode_generator_real_visit_return_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_yield_statement = vala_ccode_generator_real_visit_yield_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_throw_statement = vala_ccode_generator_real_visit_throw_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_try_statement = vala_ccode_generator_real_visit_try_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_catch_clause = vala_ccode_generator_real_visit_catch_clause;
	VALA_CODE_VISITOR_CLASS (klass)->visit_lock_statement = vala_ccode_generator_real_visit_lock_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delete_statement = vala_ccode_generator_real_visit_delete_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_expression = vala_ccode_generator_real_visit_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_array_creation_expression = vala_ccode_generator_real_visit_array_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_boolean_literal = vala_ccode_generator_real_visit_boolean_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_character_literal = vala_ccode_generator_real_visit_character_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_integer_literal = vala_ccode_generator_real_visit_integer_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_real_literal = vala_ccode_generator_real_visit_real_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_string_literal = vala_ccode_generator_real_visit_string_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_null_literal = vala_ccode_generator_real_visit_null_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_parenthesized_expression = vala_ccode_generator_real_visit_parenthesized_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member_access = vala_ccode_generator_real_visit_member_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_invocation_expression = vala_ccode_generator_real_visit_invocation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_element_access = vala_ccode_generator_real_visit_element_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_base_access = vala_ccode_generator_real_visit_base_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_postfix_expression = vala_ccode_generator_real_visit_postfix_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_object_creation_expression = vala_ccode_generator_real_visit_object_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_sizeof_expression = vala_ccode_generator_real_visit_sizeof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_typeof_expression = vala_ccode_generator_real_visit_typeof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_unary_expression = vala_ccode_generator_real_visit_unary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_cast_expression = vala_ccode_generator_real_visit_cast_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_pointer_indirection = vala_ccode_generator_real_visit_pointer_indirection;
	VALA_CODE_VISITOR_CLASS (klass)->visit_addressof_expression = vala_ccode_generator_real_visit_addressof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_reference_transfer_expression = vala_ccode_generator_real_visit_reference_transfer_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_binary_expression = vala_ccode_generator_real_visit_binary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_type_check = vala_ccode_generator_real_visit_type_check;
	VALA_CODE_VISITOR_CLASS (klass)->visit_conditional_expression = vala_ccode_generator_real_visit_conditional_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_lambda_expression = vala_ccode_generator_real_visit_lambda_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_assignment = vala_ccode_generator_real_visit_assignment;
}


static void vala_ccode_generator_instance_init (ValaCCodeGenerator * self) {
}


static void vala_ccode_generator_finalize (ValaCodeVisitor* obj) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (obj);
	(self->head == NULL ? NULL : (self->head = (vala_ccode_module_unref (self->head), NULL)));
	VALA_CODE_VISITOR_CLASS (vala_ccode_generator_parent_class)->finalize (obj);
}


GType vala_ccode_generator_get_type (void) {
	static GType vala_ccode_generator_type_id = 0;
	if (vala_ccode_generator_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeGenerator), 0, (GInstanceInitFunc) vala_ccode_generator_instance_init, NULL };
		vala_ccode_generator_type_id = g_type_register_static (VALA_TYPE_CODE_GENERATOR, "ValaCCodeGenerator", &g_define_type_info, 0);
	}
	return vala_ccode_generator_type_id;
}




