/* valaccodedynamicpropertymodule.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __GOBJECT_VALACCODEDYNAMICPROPERTYMODULE_H__
#define __GOBJECT_VALACCODEDYNAMICPROPERTYMODULE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valadynamicproperty.h>
#include <gobject/valaccodedelegatemodule.h>
#include <gobject/valaccodegenerator.h>
#include <gobject/valaccodemodule.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_DYNAMIC_PROPERTY_MODULE (vala_ccode_dynamic_property_module_get_type ())
#define VALA_CCODE_DYNAMIC_PROPERTY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DYNAMIC_PROPERTY_MODULE, ValaCCodeDynamicPropertyModule))
#define VALA_CCODE_DYNAMIC_PROPERTY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DYNAMIC_PROPERTY_MODULE, ValaCCodeDynamicPropertyModuleClass))
#define VALA_IS_CCODE_DYNAMIC_PROPERTY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DYNAMIC_PROPERTY_MODULE))
#define VALA_IS_CCODE_DYNAMIC_PROPERTY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DYNAMIC_PROPERTY_MODULE))
#define VALA_CCODE_DYNAMIC_PROPERTY_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DYNAMIC_PROPERTY_MODULE, ValaCCodeDynamicPropertyModuleClass))

typedef struct _ValaCCodeDynamicPropertyModule ValaCCodeDynamicPropertyModule;
typedef struct _ValaCCodeDynamicPropertyModuleClass ValaCCodeDynamicPropertyModuleClass;
typedef struct _ValaCCodeDynamicPropertyModulePrivate ValaCCodeDynamicPropertyModulePrivate;

/**
 * The link between a dynamic property and generated code.
 */
struct _ValaCCodeDynamicPropertyModule {
	ValaCCodeDelegateModule parent_instance;
	ValaCCodeDynamicPropertyModulePrivate * priv;
};

struct _ValaCCodeDynamicPropertyModuleClass {
	ValaCCodeDelegateModuleClass parent_class;
};


ValaCCodeDynamicPropertyModule* vala_ccode_dynamic_property_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeDynamicPropertyModule* vala_ccode_dynamic_property_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
GType vala_ccode_dynamic_property_module_get_type (void);


G_END_DECLS

#endif
