/* valareturnstatement.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valareturnstatement.h>
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>




struct _ValaReturnStatementPrivate {
	ValaExpression* _return_expression;
};

#define VALA_RETURN_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementPrivate))
enum  {
	VALA_RETURN_STATEMENT_DUMMY_PROPERTY
};
static void vala_return_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_return_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_return_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gpointer vala_return_statement_parent_class = NULL;
static ValaStatementIface* vala_return_statement_vala_statement_parent_iface = NULL;
static void vala_return_statement_finalize (ValaCodeNode* obj);



/**
 * Creates a new return statement.
 *
 * @param return_expression the return expression
 * @param source_reference  reference to source code
 * @return                  newly created return statement
 */
ValaReturnStatement* vala_return_statement_construct (GType object_type, ValaExpression* return_expression, ValaSourceReference* source_reference) {
	ValaReturnStatement* self;
	self = ((ValaReturnStatement*) (g_type_create_instance (object_type)));
	vala_code_node_set_source_reference (((ValaCodeNode*) (self)), source_reference);
	vala_return_statement_set_return_expression (self, return_expression);
	return self;
}


ValaReturnStatement* vala_return_statement_new (ValaExpression* return_expression, ValaSourceReference* source_reference) {
	return vala_return_statement_construct (VALA_TYPE_RETURN_STATEMENT, return_expression, source_reference);
}


static void vala_return_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaReturnStatement * self;
	self = ((ValaReturnStatement*) (base));
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_return_statement (visitor, self);
}


static void vala_return_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaReturnStatement * self;
	self = ((ValaReturnStatement*) (base));
	g_return_if_fail (visitor != NULL);
	if (vala_return_statement_get_return_expression (self) != NULL) {
		vala_code_node_accept (((ValaCodeNode*) (vala_return_statement_get_return_expression (self))), visitor);
		vala_code_visitor_visit_end_full_expression (visitor, vala_return_statement_get_return_expression (self));
	}
}


static void vala_return_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaReturnStatement * self;
	self = ((ValaReturnStatement*) (base));
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	if (vala_return_statement_get_return_expression (self) == old_node) {
		vala_return_statement_set_return_expression (self, new_node);
	}
}


ValaExpression* vala_return_statement_get_return_expression (ValaReturnStatement* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_return_expression;
}


void vala_return_statement_set_return_expression (ValaReturnStatement* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_return_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_return_expression == NULL ? NULL : (self->priv->_return_expression = (vala_code_node_unref (self->priv->_return_expression), NULL))), _tmp2);
	if (self->priv->_return_expression != NULL) {
		vala_code_node_set_parent_node (((ValaCodeNode*) (self->priv->_return_expression)), ((ValaCodeNode*) (self)));
	}
}


static void vala_return_statement_class_init (ValaReturnStatementClass * klass) {
	vala_return_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_return_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaReturnStatementPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_return_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_return_statement_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_return_statement_real_replace_expression;
}


static void vala_return_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_return_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_return_statement_instance_init (ValaReturnStatement * self) {
	self->priv = VALA_RETURN_STATEMENT_GET_PRIVATE (self);
}


static void vala_return_statement_finalize (ValaCodeNode* obj) {
	ValaReturnStatement * self;
	self = VALA_RETURN_STATEMENT (obj);
	(self->priv->_return_expression == NULL ? NULL : (self->priv->_return_expression = (vala_code_node_unref (self->priv->_return_expression), NULL)));
	VALA_CODE_NODE_CLASS (vala_return_statement_parent_class)->finalize (obj);
}


GType vala_return_statement_get_type (void) {
	static GType vala_return_statement_type_id = 0;
	if (vala_return_statement_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaReturnStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_return_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaReturnStatement), 0, (GInstanceInitFunc) vala_return_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_return_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_return_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaReturnStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_return_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
	}
	return vala_return_statement_type_id;
}




