/* valagasyncmodule.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valagasyncmodule.h>
#include <vala/valadatatype.h>
#include <vala/valasymbol.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodestruct.h>
#include <vala/valaformalparameter.h>
#include <vala/valavoidtype.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodefunction.h>
#include <gee/hashmap.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodememberaccess.h>
#include <gee/map.h>
#include <float.h>
#include <math.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <ccode/valaccodemodifiers.h>
#include <vala/valacodenode.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodecasestatement.h>
#include <vala/valacodevisitor.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <vala/valalocalvariable.h>
#include <vala/valamemberaccess.h>
#include <vala/valasourcereference.h>
#include <vala/valaexpression.h>
#include <gobject/valaccodemethodmodule.h>
#include <gobject/valaccodebasemodule.h>




enum  {
	VALA_GASYNC_MODULE_DUMMY_PROPERTY
};
static void vala_gasync_module_real_visit_method (ValaCCodeModule* base, ValaMethod* m);
static void vala_gasync_module_real_visit_yield_statement (ValaCCodeModule* base, ValaYieldStatement* stmt);
static gpointer vala_gasync_module_parent_class = NULL;



ValaGAsyncModule* vala_gasync_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaGAsyncModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = ((ValaGAsyncModule*) (g_type_create_instance (object_type)));
	self = ((ValaGAsyncModule*) (vala_gsignal_module_construct (object_type, codegen, next)));
	return self;
}


ValaGAsyncModule* vala_gasync_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_gasync_module_construct (VALA_TYPE_GASYNC_MODULE, codegen, next);
}


static void vala_gasync_module_real_visit_method (ValaCCodeModule* base, ValaMethod* m) {
	ValaGAsyncModule * self;
	ValaDataType* _tmp0;
	ValaDataType* creturn_type;
	gboolean visible;
	char* _tmp2;
	char* _tmp1;
	char* _tmp3;
	char* dataname;
	char* _tmp4;
	ValaCCodeStruct* _tmp5;
	ValaCCodeStruct* datastruct;
	ValaCCodeTypeDefinition* _tmp10;
	ValaCCodeVariableDeclarator* _tmp9;
	char* _tmp8;
	char* _tmp11;
	ValaCCodeFunction* _tmp12;
	ValaCCodeFunction* asyncfunc;
	GeeHashMap* cparam_map;
	ValaCCodeBlock* asyncblock;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeFunctionCall* _tmp14;
	ValaCCodeFunctionCall* dataalloc;
	ValaCCodeIdentifier* _tmp15;
	char* _tmp16;
	ValaCCodeDeclaration* _tmp17;
	ValaCCodeDeclaration* datadecl;
	ValaCCodeVariableDeclarator* _tmp18;
	ValaCCodeExpressionStatement* _tmp21;
	ValaCCodeAssignment* _tmp20;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeExpressionStatement* _tmp26;
	ValaCCodeAssignment* _tmp25;
	ValaCCodeIdentifier* _tmp24;
	ValaCCodeMemberAccess* _tmp23;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeExpressionStatement* _tmp31;
	ValaCCodeAssignment* _tmp30;
	ValaCCodeIdentifier* _tmp29;
	ValaCCodeMemberAccess* _tmp28;
	ValaCCodeIdentifier* _tmp27;
	ValaCCodeIdentifier* _tmp38;
	char* _tmp37;
	ValaCCodeFunctionCall* _tmp39;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp40;
	ValaCCodeExpressionStatement* _tmp41;
	ValaCCodeFormalParameter* _tmp42;
	ValaCCodeFormalParameter* _tmp43;
	char* _tmp48;
	char* _tmp47;
	char* _tmp46;
	ValaCCodeFunction* _tmp49;
	ValaCCodeFunction* finishfunc;
	GeeHashMap* _tmp50;
	ValaCCodeBlock* finishblock;
	ValaCCodeFormalParameter* _tmp51;
	char* _tmp55;
	char* _tmp54;
	ValaCCodeFunction* _tmp56;
	ValaCCodeFunction* readyfunc;
	ValaCCodeFormalParameter* _tmp57;
	ValaCCodeFormalParameter* _tmp58;
	ValaCCodeFormalParameter* _tmp59;
	ValaCCodeBlock* readyblock;
	ValaCCodeDeclaration* _tmp61;
	char* _tmp60;
	ValaCCodeVariableDeclarator* _tmp62;
	ValaCCodeExpressionStatement* _tmp66;
	ValaCCodeAssignment* _tmp65;
	ValaCCodeIdentifier* _tmp64;
	ValaCCodeIdentifier* _tmp63;
	ValaCCodeExpressionStatement* _tmp71;
	ValaCCodeAssignment* _tmp70;
	ValaCCodeIdentifier* _tmp69;
	ValaCCodeMemberAccess* _tmp68;
	ValaCCodeIdentifier* _tmp67;
	ValaCCodeFunctionCall* _tmp74;
	ValaCCodeIdentifier* _tmp73;
	char* _tmp72;
	ValaCCodeIdentifier* _tmp75;
	ValaCCodeExpressionStatement* _tmp76;
	ValaCCodeFunction* _tmp77;
	self = ((ValaGAsyncModule*) (base));
	g_return_if_fail (m != NULL);
	VALA_CCODE_MODULE_CLASS (vala_gasync_module_parent_class)->visit_method (((ValaCCodeModule*) (VALA_GSIGNAL_MODULE (self))), m);
	if (!vala_method_get_coroutine (m)) {
		return;
	}
	_tmp0 = NULL;
	creturn_type = (_tmp0 = vala_method_get_return_type (m), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	visible = !vala_symbol_is_internal_symbol (((ValaSymbol*) (m)));
	((ValaCCodeBaseModule*) (self))->gio_h_needed = TRUE;
	/* generate struct to hold parameters, local variables, and the return value*/
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp3 = NULL;
	dataname = (_tmp3 = g_strconcat ((_tmp2 = vala_symbol_lower_case_to_camel_case ((_tmp1 = vala_method_get_cname (m)))), "Data", NULL), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 = (g_free (_tmp1), NULL)), _tmp3);
	_tmp4 = NULL;
	_tmp5 = NULL;
	datastruct = (_tmp5 = vala_ccode_struct_new ((_tmp4 = g_strconcat ("_", dataname, NULL))), (_tmp4 = (g_free (_tmp4), NULL)), _tmp5);
	vala_ccode_struct_add_field (datastruct, "int", "state");
	vala_ccode_struct_add_field (datastruct, "GAsyncReadyCallback", "callback");
	vala_ccode_struct_add_field (datastruct, "gpointer", "user_data");
	vala_ccode_struct_add_field (datastruct, "GAsyncResult*", "res");
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (m);
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				char* _tmp6;
				_tmp6 = NULL;
				vala_ccode_struct_add_field (datastruct, (_tmp6 = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param))), vala_symbol_get_name (((ValaSymbol*) (param))));
				_tmp6 = (g_free (_tmp6), NULL);
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
	}
	if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
		char* _tmp7;
		_tmp7 = NULL;
		vala_ccode_struct_add_field (datastruct, (_tmp7 = vala_data_type_get_cname (vala_method_get_return_type (m))), "result");
		_tmp7 = (g_free (_tmp7), NULL);
	}
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_definition, ((ValaCCodeNode*) (datastruct)));
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp8 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_declaration, ((ValaCCodeNode*) ((_tmp10 = vala_ccode_type_definition_new ((_tmp8 = g_strconcat ("struct _", dataname, NULL)), ((ValaCCodeDeclarator*) ((_tmp9 = vala_ccode_variable_declarator_new (dataname)))))))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
	(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
	_tmp8 = (g_free (_tmp8), NULL);
	/* generate async function*/
	_tmp11 = NULL;
	_tmp12 = NULL;
	asyncfunc = (_tmp12 = vala_ccode_function_new ((_tmp11 = vala_method_get_cname (m)), "void"), (_tmp11 = (g_free (_tmp11), NULL)), _tmp12);
	vala_ccode_node_set_line (((ValaCCodeNode*) (asyncfunc)), vala_ccode_node_get_line (((ValaCCodeNode*) (((ValaCCodeBaseModule*) (self))->function))));
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	asyncblock = vala_ccode_block_new ();
	_tmp13 = NULL;
	_tmp14 = NULL;
	dataalloc = (_tmp14 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp13 = vala_ccode_identifier_new ("g_slice_new0"))))), (_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL))), _tmp14);
	_tmp15 = NULL;
	vala_ccode_function_call_add_argument (dataalloc, ((ValaCCodeExpression*) ((_tmp15 = vala_ccode_identifier_new (dataname)))));
	(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
	_tmp16 = NULL;
	_tmp17 = NULL;
	datadecl = (_tmp17 = vala_ccode_declaration_new ((_tmp16 = g_strconcat (dataname, "*", NULL))), (_tmp16 = (g_free (_tmp16), NULL)), _tmp17);
	_tmp18 = NULL;
	vala_ccode_declaration_add_declarator (datadecl, ((ValaCCodeDeclarator*) ((_tmp18 = vala_ccode_variable_declarator_new ("data")))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
	vala_ccode_block_add_statement (asyncblock, ((ValaCCodeNode*) (datadecl)));
	_tmp21 = NULL;
	_tmp20 = NULL;
	_tmp19 = NULL;
	vala_ccode_block_add_statement (asyncblock, ((ValaCCodeNode*) ((_tmp21 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp20 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp19 = vala_ccode_identifier_new ("data")))), ((ValaCCodeExpression*) (dataalloc)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
	(_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)));
	(_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)));
	(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
	_tmp26 = NULL;
	_tmp25 = NULL;
	_tmp24 = NULL;
	_tmp23 = NULL;
	_tmp22 = NULL;
	vala_ccode_block_add_statement (asyncblock, ((ValaCCodeNode*) ((_tmp26 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp25 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp23 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp22 = vala_ccode_identifier_new ("data")))), "callback")))), ((ValaCCodeExpression*) ((_tmp24 = vala_ccode_identifier_new ("callback")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
	(_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)));
	(_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)));
	(_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)));
	(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
	(_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)));
	_tmp31 = NULL;
	_tmp30 = NULL;
	_tmp29 = NULL;
	_tmp28 = NULL;
	_tmp27 = NULL;
	vala_ccode_block_add_statement (asyncblock, ((ValaCCodeNode*) ((_tmp31 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp30 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp28 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp27 = vala_ccode_identifier_new ("data")))), "user_data")))), ((ValaCCodeExpression*) ((_tmp29 = vala_ccode_identifier_new ("user_data")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
	(_tmp31 == NULL ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)));
	(_tmp30 == NULL ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)));
	(_tmp29 == NULL ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)));
	(_tmp28 == NULL ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)));
	(_tmp27 == NULL ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)));
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (m);
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				ValaCCodeExpressionStatement* _tmp36;
				ValaCCodeAssignment* _tmp35;
				ValaCCodeIdentifier* _tmp34;
				ValaCCodeMemberAccess* _tmp33;
				ValaCCodeIdentifier* _tmp32;
				_tmp36 = NULL;
				_tmp35 = NULL;
				_tmp34 = NULL;
				_tmp33 = NULL;
				_tmp32 = NULL;
				vala_ccode_block_add_statement (asyncblock, ((ValaCCodeNode*) ((_tmp36 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp35 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp33 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp32 = vala_ccode_identifier_new ("data")))), vala_symbol_get_name (((ValaSymbol*) (param))))))), ((ValaCCodeExpression*) ((_tmp34 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (param))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
				(_tmp36 == NULL ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)));
				(_tmp35 == NULL ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL)));
				(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
				(_tmp33 == NULL ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)));
				(_tmp32 == NULL ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)));
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
	}
	_tmp38 = NULL;
	_tmp37 = NULL;
	_tmp39 = NULL;
	ccall = (_tmp39 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp38 = vala_ccode_identifier_new ((_tmp37 = vala_method_get_real_cname (m))))))), (_tmp38 == NULL ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL))), (_tmp37 = (g_free (_tmp37), NULL)), _tmp39);
	_tmp40 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp40 = vala_ccode_identifier_new ("data")))));
	(_tmp40 == NULL ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL)));
	_tmp41 = NULL;
	vala_ccode_block_add_statement (asyncblock, ((ValaCCodeNode*) ((_tmp41 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (ccall)))))));
	(_tmp41 == NULL ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL)));
	_tmp42 = NULL;
	gee_map_set (((GeeMap*) (cparam_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), ((double) (-1)), FALSE)), (_tmp42 = vala_ccode_formal_parameter_new ("callback", "GAsyncReadyCallback")));
	(_tmp42 == NULL ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL)));
	_tmp43 = NULL;
	gee_map_set (((GeeMap*) (cparam_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), -0.9, FALSE)), (_tmp43 = vala_ccode_formal_parameter_new ("user_data", "gpointer")));
	(_tmp43 == NULL ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL)));
	vala_ccode_module_generate_cparameters (((ValaCCodeModule*) (self)), m, creturn_type, FALSE, ((GeeMap*) (cparam_map)), asyncfunc, NULL, NULL, NULL, 1);
	if (visible) {
		ValaCCodeFunction* _tmp44;
		_tmp44 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->header_type_member_declaration, ((ValaCCodeNode*) ((_tmp44 = vala_ccode_function_copy (asyncfunc)))));
		(_tmp44 == NULL ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL)));
	} else {
		ValaCCodeFunction* _tmp45;
		vala_ccode_function_set_modifiers (asyncfunc, vala_ccode_function_get_modifiers (asyncfunc) | (VALA_CCODE_MODIFIERS_STATIC));
		_tmp45 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_declaration, ((ValaCCodeNode*) ((_tmp45 = vala_ccode_function_copy (asyncfunc)))));
		(_tmp45 == NULL ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL)));
	}
	vala_ccode_function_set_block (asyncfunc, asyncblock);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_definition, ((ValaCCodeNode*) (asyncfunc)));
	/* generate finish function*/
	_tmp48 = NULL;
	_tmp47 = NULL;
	_tmp46 = NULL;
	_tmp49 = NULL;
	finishfunc = (_tmp49 = vala_ccode_function_new ((_tmp47 = g_strconcat ((_tmp46 = vala_method_get_cname (m)), "_finish", NULL)), (_tmp48 = vala_data_type_get_cname (creturn_type))), (_tmp48 = (g_free (_tmp48), NULL)), (_tmp47 = (g_free (_tmp47), NULL)), (_tmp46 = (g_free (_tmp46), NULL)), _tmp49);
	vala_ccode_node_set_line (((ValaCCodeNode*) (finishfunc)), vala_ccode_node_get_line (((ValaCCodeNode*) (((ValaCCodeBaseModule*) (self))->function))));
	_tmp50 = NULL;
	cparam_map = (_tmp50 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (cparam_map == NULL ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL))), _tmp50);
	finishblock = vala_ccode_block_new ();
	_tmp51 = NULL;
	gee_map_set (((GeeMap*) (cparam_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), 0.1, FALSE)), (_tmp51 = vala_ccode_formal_parameter_new ("res", "GAsyncResult*")));
	(_tmp51 == NULL ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL)));
	vala_ccode_module_generate_cparameters (((ValaCCodeModule*) (self)), m, creturn_type, FALSE, ((GeeMap*) (cparam_map)), finishfunc, NULL, NULL, NULL, 2);
	if (visible) {
		ValaCCodeFunction* _tmp52;
		_tmp52 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->header_type_member_declaration, ((ValaCCodeNode*) ((_tmp52 = vala_ccode_function_copy (finishfunc)))));
		(_tmp52 == NULL ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL)));
	} else {
		ValaCCodeFunction* _tmp53;
		vala_ccode_function_set_modifiers (finishfunc, vala_ccode_function_get_modifiers (finishfunc) | (VALA_CCODE_MODIFIERS_STATIC));
		_tmp53 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_declaration, ((ValaCCodeNode*) ((_tmp53 = vala_ccode_function_copy (finishfunc)))));
		(_tmp53 == NULL ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL)));
	}
	vala_ccode_function_set_block (finishfunc, finishblock);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_definition, ((ValaCCodeNode*) (finishfunc)));
	/* generate ready callback handler*/
	_tmp55 = NULL;
	_tmp54 = NULL;
	_tmp56 = NULL;
	readyfunc = (_tmp56 = vala_ccode_function_new ((_tmp55 = g_strconcat ((_tmp54 = vala_method_get_cname (m)), "_ready", NULL)), "void"), (_tmp55 = (g_free (_tmp55), NULL)), (_tmp54 = (g_free (_tmp54), NULL)), _tmp56);
	vala_ccode_node_set_line (((ValaCCodeNode*) (readyfunc)), vala_ccode_node_get_line (((ValaCCodeNode*) (((ValaCCodeBaseModule*) (self))->function))));
	_tmp57 = NULL;
	vala_ccode_function_add_parameter (readyfunc, (_tmp57 = vala_ccode_formal_parameter_new ("source_object", "GObject*")));
	(_tmp57 == NULL ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL)));
	_tmp58 = NULL;
	vala_ccode_function_add_parameter (readyfunc, (_tmp58 = vala_ccode_formal_parameter_new ("res", "GAsyncResult*")));
	(_tmp58 == NULL ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL)));
	_tmp59 = NULL;
	vala_ccode_function_add_parameter (readyfunc, (_tmp59 = vala_ccode_formal_parameter_new ("user_data", "gpointer")));
	(_tmp59 == NULL ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL)));
	readyblock = vala_ccode_block_new ();
	_tmp61 = NULL;
	_tmp60 = NULL;
	datadecl = (_tmp61 = vala_ccode_declaration_new ((_tmp60 = g_strconcat (dataname, "*", NULL))), (datadecl == NULL ? NULL : (datadecl = (vala_ccode_node_unref (datadecl), NULL))), _tmp61);
	_tmp60 = (g_free (_tmp60), NULL);
	_tmp62 = NULL;
	vala_ccode_declaration_add_declarator (datadecl, ((ValaCCodeDeclarator*) ((_tmp62 = vala_ccode_variable_declarator_new ("data")))));
	(_tmp62 == NULL ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL)));
	vala_ccode_block_add_statement (readyblock, ((ValaCCodeNode*) (datadecl)));
	_tmp66 = NULL;
	_tmp65 = NULL;
	_tmp64 = NULL;
	_tmp63 = NULL;
	vala_ccode_block_add_statement (readyblock, ((ValaCCodeNode*) ((_tmp66 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp65 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp63 = vala_ccode_identifier_new ("data")))), ((ValaCCodeExpression*) ((_tmp64 = vala_ccode_identifier_new ("user_data")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
	(_tmp66 == NULL ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL)));
	(_tmp65 == NULL ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL)));
	(_tmp64 == NULL ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL)));
	(_tmp63 == NULL ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL)));
	_tmp71 = NULL;
	_tmp70 = NULL;
	_tmp69 = NULL;
	_tmp68 = NULL;
	_tmp67 = NULL;
	vala_ccode_block_add_statement (readyblock, ((ValaCCodeNode*) ((_tmp71 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp70 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp68 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp67 = vala_ccode_identifier_new ("data")))), "res")))), ((ValaCCodeExpression*) ((_tmp69 = vala_ccode_identifier_new ("res")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
	(_tmp71 == NULL ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL)));
	(_tmp70 == NULL ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL)));
	(_tmp69 == NULL ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL)));
	(_tmp68 == NULL ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL)));
	(_tmp67 == NULL ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL)));
	_tmp74 = NULL;
	_tmp73 = NULL;
	_tmp72 = NULL;
	ccall = (_tmp74 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp73 = vala_ccode_identifier_new ((_tmp72 = vala_method_get_real_cname (m))))))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp74);
	(_tmp73 == NULL ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL)));
	_tmp72 = (g_free (_tmp72), NULL);
	_tmp75 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp75 = vala_ccode_identifier_new ("data")))));
	(_tmp75 == NULL ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL)));
	_tmp76 = NULL;
	vala_ccode_block_add_statement (readyblock, ((ValaCCodeNode*) ((_tmp76 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (ccall)))))));
	(_tmp76 == NULL ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL)));
	vala_ccode_function_set_modifiers (readyfunc, vala_ccode_function_get_modifiers (readyfunc) | (VALA_CCODE_MODIFIERS_STATIC));
	_tmp77 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_declaration, ((ValaCCodeNode*) ((_tmp77 = vala_ccode_function_copy (readyfunc)))));
	(_tmp77 == NULL ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL)));
	vala_ccode_function_set_block (readyfunc, readyblock);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_definition, ((ValaCCodeNode*) (readyfunc)));
	(creturn_type == NULL ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL)));
	dataname = (g_free (dataname), NULL);
	(datastruct == NULL ? NULL : (datastruct = (vala_ccode_node_unref (datastruct), NULL)));
	(asyncfunc == NULL ? NULL : (asyncfunc = (vala_ccode_node_unref (asyncfunc), NULL)));
	(cparam_map == NULL ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL)));
	(asyncblock == NULL ? NULL : (asyncblock = (vala_ccode_node_unref (asyncblock), NULL)));
	(dataalloc == NULL ? NULL : (dataalloc = (vala_ccode_node_unref (dataalloc), NULL)));
	(datadecl == NULL ? NULL : (datadecl = (vala_ccode_node_unref (datadecl), NULL)));
	(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
	(finishfunc == NULL ? NULL : (finishfunc = (vala_ccode_node_unref (finishfunc), NULL)));
	(finishblock == NULL ? NULL : (finishblock = (vala_ccode_node_unref (finishblock), NULL)));
	(readyfunc == NULL ? NULL : (readyfunc = (vala_ccode_node_unref (readyfunc), NULL)));
	(readyblock == NULL ? NULL : (readyblock = (vala_ccode_node_unref (readyblock), NULL)));
}


static void vala_gasync_module_real_visit_yield_statement (ValaCCodeModule* base, ValaYieldStatement* stmt) {
	ValaGAsyncModule * self;
	ValaCCodeExpressionStatement* _tmp18;
	ValaCCodeFragment* cfrag;
	self = ((ValaGAsyncModule*) (base));
	g_return_if_fail (stmt != NULL);
	if (vala_yield_statement_get_yield_expression (stmt) == NULL) {
		ValaCCodeFragment* cfrag;
		ValaCCodeIdentifier* _tmp0;
		ValaCCodeFunctionCall* _tmp1;
		ValaCCodeFunctionCall* idle_call;
		ValaCCodeCastExpression* _tmp4;
		ValaCCodeIdentifier* _tmp3;
		char* _tmp2;
		ValaCCodeIdentifier* _tmp5;
		gint state;
		ValaCCodeExpressionStatement* _tmp6;
		ValaCCodeExpressionStatement* _tmp12;
		ValaCCodeAssignment* _tmp11;
		ValaCCodeConstant* _tmp10;
		char* _tmp9;
		ValaCCodeMemberAccess* _tmp8;
		ValaCCodeIdentifier* _tmp7;
		ValaCCodeReturnStatement* _tmp14;
		ValaCCodeConstant* _tmp13;
		ValaCCodeCaseStatement* _tmp17;
		ValaCCodeConstant* _tmp16;
		char* _tmp15;
		cfrag = vala_ccode_fragment_new ();
		vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) (cfrag)));
		_tmp0 = NULL;
		_tmp1 = NULL;
		idle_call = (_tmp1 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp0 = vala_ccode_identifier_new ("g_idle_add"))))), (_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL))), _tmp1);
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_ccode_function_call_add_argument (idle_call, ((ValaCCodeExpression*) ((_tmp4 = vala_ccode_cast_expression_new (((ValaCCodeExpression*) ((_tmp3 = vala_ccode_identifier_new ((_tmp2 = vala_method_get_real_cname (((ValaCCodeBaseModule*) (self))->current_method)))))), "GSourceFunc")))));
		(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
		(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
		_tmp2 = (g_free (_tmp2), NULL);
		_tmp5 = NULL;
		vala_ccode_function_call_add_argument (idle_call, ((ValaCCodeExpression*) ((_tmp5 = vala_ccode_identifier_new ("data")))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
		state = ((ValaCCodeBaseModule*) (self))->next_coroutine_state++;
		_tmp6 = NULL;
		vala_ccode_fragment_append (cfrag, ((ValaCCodeNode*) ((_tmp6 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (idle_call)))))));
		(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
		_tmp12 = NULL;
		_tmp11 = NULL;
		_tmp10 = NULL;
		_tmp9 = NULL;
		_tmp8 = NULL;
		_tmp7 = NULL;
		vala_ccode_fragment_append (cfrag, ((ValaCCodeNode*) ((_tmp12 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp11 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp8 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp7 = vala_ccode_identifier_new ("data")))), "state")))), ((ValaCCodeExpression*) ((_tmp10 = vala_ccode_constant_new ((_tmp9 = g_strdup_printf ("%i", state)))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
		(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
		(_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)));
		(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
		_tmp9 = (g_free (_tmp9), NULL);
		(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
		(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
		_tmp14 = NULL;
		_tmp13 = NULL;
		vala_ccode_fragment_append (cfrag, ((ValaCCodeNode*) ((_tmp14 = vala_ccode_return_statement_new (((ValaCCodeExpression*) ((_tmp13 = vala_ccode_constant_new ("FALSE")))))))));
		(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
		(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
		_tmp17 = NULL;
		_tmp16 = NULL;
		_tmp15 = NULL;
		vala_ccode_fragment_append (cfrag, ((ValaCCodeNode*) ((_tmp17 = vala_ccode_case_statement_new (((ValaCCodeExpression*) ((_tmp16 = vala_ccode_constant_new ((_tmp15 = g_strdup_printf ("%i", state)))))))))));
		(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
		(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
		_tmp15 = (g_free (_tmp15), NULL);
		(cfrag == NULL ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)));
		(idle_call == NULL ? NULL : (idle_call = (vala_ccode_node_unref (idle_call), NULL)));
		return;
	}
	vala_code_node_accept_children (((ValaCodeNode*) (stmt)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	if (vala_code_node_get_error (((ValaCodeNode*) (vala_yield_statement_get_yield_expression (stmt))))) {
		vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
		return;
	}
	_tmp18 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) ((_tmp18 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_yield_statement_get_yield_expression (stmt))))))))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
	if (vala_code_node_get_tree_can_fail (((ValaCodeNode*) (stmt))) && vala_code_node_get_tree_can_fail (((ValaCodeNode*) (vala_yield_statement_get_yield_expression (stmt))))) {
		ValaCCodeFragment* cfrag;
		/* simple case, no node breakdown necessary*/
		cfrag = vala_ccode_fragment_new ();
		vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (((ValaCodeNode*) (stmt))));
		vala_ccode_module_add_simple_check (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), ((ValaCodeNode*) (vala_yield_statement_get_yield_expression (stmt))), cfrag);
		vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) (cfrag)));
		(cfrag == NULL ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)));
	}
	/* free temporary objects */
	if (gee_collection_get_size (((GeeCollection*) ((GEE_LIST (((ValaCCodeBaseModule*) (self))->temp_vars))))) == 0) {
		/* nothing to do without temporary variables */
		return;
	}
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_temp_decl (((ValaCCodeBaseModule*) (self)), cfrag, ((GeeList*) (((ValaCCodeBaseModule*) (self))->temp_vars)));
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (((ValaCodeNode*) (stmt))));
	{
		GeeArrayList* local_collection;
		int local_it;
		local_collection = ((ValaCCodeBaseModule*) (self))->temp_ref_vars;
		for (local_it = 0; local_it < gee_collection_get_size (GEE_COLLECTION (local_collection)); local_it = local_it + 1) {
			ValaLocalVariable* local;
			local = ((ValaLocalVariable*) (gee_list_get (GEE_LIST (local_collection), local_it)));
			{
				ValaMemberAccess* ma;
				ValaCCodeExpressionStatement* _tmp21;
				ValaCCodeExpression* _tmp20;
				ValaCCodeIdentifier* _tmp19;
				ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) (local))), NULL);
				vala_expression_set_symbol_reference (((ValaExpression*) (ma)), ((ValaSymbol*) (local)));
				_tmp21 = NULL;
				_tmp20 = NULL;
				_tmp19 = NULL;
				vala_ccode_fragment_append (cfrag, ((ValaCCodeNode*) ((_tmp21 = vala_ccode_expression_statement_new ((_tmp20 = vala_ccode_base_module_get_unref_expression (((ValaCCodeBaseModule*) (self)), ((ValaCCodeExpression*) ((_tmp19 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (local))))))), vala_local_variable_get_variable_type (local), ((ValaExpression*) (ma)))))))));
				(_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)));
				(_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)));
				(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
				(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
				(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
			}
		}
	}
	vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) (cfrag)));
	gee_collection_clear (((GeeCollection*) (((ValaCCodeBaseModule*) (self))->temp_vars)));
	gee_collection_clear (((GeeCollection*) (((ValaCCodeBaseModule*) (self))->temp_ref_vars)));
	(cfrag == NULL ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)));
}


static void vala_gasync_module_class_init (ValaGAsyncModuleClass * klass) {
	vala_gasync_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_method = vala_gasync_module_real_visit_method;
	VALA_CCODE_MODULE_CLASS (klass)->visit_yield_statement = vala_gasync_module_real_visit_yield_statement;
}


static void vala_gasync_module_instance_init (ValaGAsyncModule * self) {
}


GType vala_gasync_module_get_type (void) {
	static GType vala_gasync_module_type_id = 0;
	if (vala_gasync_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGAsyncModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gasync_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGAsyncModule), 0, (GInstanceInitFunc) vala_gasync_module_instance_init, NULL };
		vala_gasync_module_type_id = g_type_register_static (VALA_TYPE_GSIGNAL_MODULE, "ValaGAsyncModule", &g_define_type_info, 0);
	}
	return vala_gasync_module_type_id;
}




