/* valaccodecommaexpression.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodecommaexpression.h>
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <gee/readonlylist.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>




struct _ValaCCodeCommaExpressionPrivate {
	GeeList* inner;
};

#define VALA_CCODE_COMMA_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_COMMA_EXPRESSION, ValaCCodeCommaExpressionPrivate))
enum  {
	VALA_CCODE_COMMA_EXPRESSION_DUMMY_PROPERTY
};
static void vala_ccode_comma_expression_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_comma_expression_parent_class = NULL;
static void vala_ccode_comma_expression_finalize (ValaCCodeNode* obj);



/**
 * Appends the specified expression to the expression list.
 *
 * @param expr a C code expression
 */
void vala_ccode_comma_expression_append_expression (ValaCCodeCommaExpression* self, ValaCCodeExpression* expr) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	gee_collection_add (((GeeCollection*) (self->priv->inner)), expr);
}


GeeList* vala_ccode_comma_expression_get_inner (ValaCCodeCommaExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return ((GeeList*) (gee_read_only_list_new (VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, self->priv->inner)));
}


static void vala_ccode_comma_expression_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeCommaExpression * self;
	gboolean first;
	self = ((ValaCCodeCommaExpression*) (base));
	g_return_if_fail (writer != NULL);
	first = TRUE;
	vala_ccode_writer_write_string (writer, "(");
	{
		GeeList* expr_collection;
		int expr_it;
		expr_collection = self->priv->inner;
		for (expr_it = 0; expr_it < gee_collection_get_size (GEE_COLLECTION (expr_collection)); expr_it = expr_it + 1) {
			ValaCCodeExpression* expr;
			expr = ((ValaCCodeExpression*) (gee_list_get (GEE_LIST (expr_collection), expr_it)));
			{
				if (!first) {
					vala_ccode_writer_write_string (writer, ", ");
				} else {
					first = FALSE;
				}
				vala_ccode_node_write (((ValaCCodeNode*) (expr)), writer);
				(expr == NULL ? NULL : (expr = (vala_ccode_node_unref (expr), NULL)));
			}
		}
	}
	vala_ccode_writer_write_string (writer, ")");
}


/**
 * Represents a comma separated expression list in the C code.
 */
ValaCCodeCommaExpression* vala_ccode_comma_expression_construct (GType object_type) {
	ValaCCodeCommaExpression* self;
	self = ((ValaCCodeCommaExpression*) (g_type_create_instance (object_type)));
	return self;
}


ValaCCodeCommaExpression* vala_ccode_comma_expression_new (void) {
	return vala_ccode_comma_expression_construct (VALA_TYPE_CCODE_COMMA_EXPRESSION);
}


static void vala_ccode_comma_expression_class_init (ValaCCodeCommaExpressionClass * klass) {
	vala_ccode_comma_expression_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_comma_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeCommaExpressionPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_comma_expression_real_write;
}


static void vala_ccode_comma_expression_instance_init (ValaCCodeCommaExpression * self) {
	self->priv = VALA_CCODE_COMMA_EXPRESSION_GET_PRIVATE (self);
	self->priv->inner = ((GeeList*) (gee_array_list_new (VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_equal)));
}


static void vala_ccode_comma_expression_finalize (ValaCCodeNode* obj) {
	ValaCCodeCommaExpression * self;
	self = VALA_CCODE_COMMA_EXPRESSION (obj);
	(self->priv->inner == NULL ? NULL : (self->priv->inner = (gee_collection_object_unref (self->priv->inner), NULL)));
	VALA_CCODE_NODE_CLASS (vala_ccode_comma_expression_parent_class)->finalize (obj);
}


GType vala_ccode_comma_expression_get_type (void) {
	static GType vala_ccode_comma_expression_type_id = 0;
	if (vala_ccode_comma_expression_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeCommaExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_comma_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeCommaExpression), 0, (GInstanceInitFunc) vala_ccode_comma_expression_instance_init, NULL };
		vala_ccode_comma_expression_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeCommaExpression", &g_define_type_info, 0);
	}
	return vala_ccode_comma_expression_type_id;
}




