/* valagirparser.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VAPIGEN_VALAGIRPARSER_H__
#define __VAPIGEN_VALAGIRPARSER_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodevisitor.h>
#include <vala/valacodecontext.h>
#include <vala/valasourcefile.h>
#include <stdlib.h>
#include <string.h>

G_BEGIN_DECLS


#define VALA_TYPE_GIR_PARSER (vala_gir_parser_get_type ())
#define VALA_GIR_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIR_PARSER, ValaGirParser))
#define VALA_GIR_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIR_PARSER, ValaGirParserClass))
#define VALA_IS_GIR_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIR_PARSER))
#define VALA_IS_GIR_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIR_PARSER))
#define VALA_GIR_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIR_PARSER, ValaGirParserClass))

typedef struct _ValaGirParser ValaGirParser;
typedef struct _ValaGirParserClass ValaGirParserClass;
typedef struct _ValaGirParserPrivate ValaGirParserPrivate;

/**
 * Code visitor parsing all Vala source files.
 */
struct _ValaGirParser {
	ValaCodeVisitor parent_instance;
	ValaGirParserPrivate * priv;
};

struct _ValaGirParserClass {
	ValaCodeVisitorClass parent_class;
};


void vala_gir_parser_parse (ValaGirParser* self, ValaCodeContext* context);
void vala_gir_parser_parse_file (ValaGirParser* self, ValaSourceFile* source_file);
void vala_gir_parser_parse_metadata (ValaGirParser* self, const char* metadata_filename);
ValaGirParser* vala_gir_parser_construct (GType object_type);
ValaGirParser* vala_gir_parser_new (void);
GType vala_gir_parser_get_type (void);


G_END_DECLS

#endif
