/* valaexpressionstatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAEXPRESSIONSTATEMENT_H__
#define __VALA_VALAEXPRESSIONSTATEMENT_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodenode.h>
#include <vala/valastatement.h>

G_BEGIN_DECLS


#define VALA_TYPE_EXPRESSION_STATEMENT (vala_expression_statement_get_type ())
#define VALA_EXPRESSION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatement))
#define VALA_EXPRESSION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatementClass))
#define VALA_IS_EXPRESSION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION_STATEMENT))
#define VALA_IS_EXPRESSION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION_STATEMENT))
#define VALA_EXPRESSION_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatementClass))

typedef struct _ValaExpressionStatementPrivate ValaExpressionStatementPrivate;

/**
 * A code statement that evaluates a given expression. The value computed by the
 * expression, if any, is discarded.
 */
struct _ValaExpressionStatement {
	ValaCodeNode parent_instance;
	ValaExpressionStatementPrivate * priv;
};

struct _ValaExpressionStatementClass {
	ValaCodeNodeClass parent_class;
};


ValaExpressionStatement* vala_expression_statement_construct (GType object_type, ValaExpression* expression, ValaSourceReference* source_reference);
ValaExpressionStatement* vala_expression_statement_new (ValaExpression* expression, ValaSourceReference* source_reference);
ValaProperty* vala_expression_statement_assigned_property (ValaExpressionStatement* self);
ValaExpression* vala_expression_statement_get_expression (ValaExpressionStatement* self);
void vala_expression_statement_set_expression (ValaExpressionStatement* self, ValaExpression* value);
GType vala_expression_statement_get_type (void);


G_END_DECLS

#endif
