/* valaelementaccess.vala
 *
 * Copyright (C) 2006-2008  Raffaele Sandrini, Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaelementaccess.h>
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <gee/readonlylist.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>




struct _ValaElementAccessPrivate {
	ValaExpression* _container;
	GeeList* indices;
};

#define VALA_ELEMENT_ACCESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessPrivate))
enum  {
	VALA_ELEMENT_ACCESS_DUMMY_PROPERTY
};
static void vala_element_access_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_element_access_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_element_access_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_element_access_real_is_pure (ValaExpression* base);
static gpointer vala_element_access_parent_class = NULL;
static void vala_element_access_finalize (ValaCodeNode* obj);



void vala_element_access_append_index (ValaElementAccess* self, ValaExpression* index) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (index != NULL);
	gee_collection_add (((GeeCollection*) (self->priv->indices)), index);
	vala_code_node_set_parent_node (((ValaCodeNode*) (index)), ((ValaCodeNode*) (self)));
}


GeeList* vala_element_access_get_indices (ValaElementAccess* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return ((GeeList*) (gee_read_only_list_new (VALA_TYPE_EXPRESSION, ((GBoxedCopyFunc) (vala_code_node_ref)), vala_code_node_unref, self->priv->indices)));
}


ValaElementAccess* vala_element_access_construct (GType object_type, ValaExpression* container, ValaSourceReference* source_reference) {
	ValaElementAccess* self;
	g_return_val_if_fail (container != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = ((ValaElementAccess*) (g_type_create_instance (object_type)));
	vala_code_node_set_source_reference (((ValaCodeNode*) (self)), source_reference);
	vala_element_access_set_container (self, container);
	return self;
}


ValaElementAccess* vala_element_access_new (ValaExpression* container, ValaSourceReference* source_reference) {
	return vala_element_access_construct (VALA_TYPE_ELEMENT_ACCESS, container, source_reference);
}


static void vala_element_access_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaElementAccess * self;
	self = ((ValaElementAccess*) (base));
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_element_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, ((ValaExpression*) (self)));
}


static void vala_element_access_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaElementAccess * self;
	self = ((ValaElementAccess*) (base));
	g_return_if_fail (visitor != NULL);
	vala_code_node_accept (((ValaCodeNode*) (self->priv->_container)), visitor);
	{
		GeeList* e_collection;
		int e_it;
		e_collection = self->priv->indices;
		for (e_it = 0; e_it < gee_collection_get_size (GEE_COLLECTION (e_collection)); e_it = e_it + 1) {
			ValaExpression* e;
			e = ((ValaExpression*) (gee_list_get (GEE_LIST (e_collection), e_it)));
			{
				vala_code_node_accept (((ValaCodeNode*) (e)), visitor);
				(e == NULL ? NULL : (e = (vala_code_node_unref (e), NULL)));
			}
		}
	}
}


static void vala_element_access_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaElementAccess * self;
	gint index;
	self = ((ValaElementAccess*) (base));
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	if (self->priv->_container == old_node) {
		vala_element_access_set_container (self, new_node);
	}
	index = gee_list_index_of (self->priv->indices, old_node);
	if (index >= 0 && vala_code_node_get_parent_node (((ValaCodeNode*) (new_node))) == NULL) {
		gee_list_set (((GeeList*) (self->priv->indices)), index, new_node);
		vala_code_node_set_parent_node (((ValaCodeNode*) (new_node)), ((ValaCodeNode*) (self)));
	}
}


static gboolean vala_element_access_real_is_pure (ValaExpression* base) {
	ValaElementAccess * self;
	self = ((ValaElementAccess*) (base));
	{
		GeeList* index_collection;
		int index_it;
		index_collection = self->priv->indices;
		for (index_it = 0; index_it < gee_collection_get_size (GEE_COLLECTION (index_collection)); index_it = index_it + 1) {
			ValaExpression* index;
			index = ((ValaExpression*) (gee_list_get (GEE_LIST (index_collection), index_it)));
			{
				if (!vala_expression_is_pure (index)) {
					gboolean _tmp0;
					return (_tmp0 = FALSE, (index == NULL ? NULL : (index = (vala_code_node_unref (index), NULL))), _tmp0);
				}
				(index == NULL ? NULL : (index = (vala_code_node_unref (index), NULL)));
			}
		}
	}
	return vala_expression_is_pure (self->priv->_container);
}


ValaExpression* vala_element_access_get_container (ValaElementAccess* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_container;
}


void vala_element_access_set_container (ValaElementAccess* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_container = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_container == NULL ? NULL : (self->priv->_container = (vala_code_node_unref (self->priv->_container), NULL))), _tmp2);
}


static void vala_element_access_class_init (ValaElementAccessClass * klass) {
	vala_element_access_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_element_access_finalize;
	g_type_class_add_private (klass, sizeof (ValaElementAccessPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_element_access_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_element_access_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_element_access_real_replace_expression;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_element_access_real_is_pure;
}


static void vala_element_access_instance_init (ValaElementAccess * self) {
	self->priv = VALA_ELEMENT_ACCESS_GET_PRIVATE (self);
	self->priv->indices = ((GeeList*) (gee_array_list_new (VALA_TYPE_EXPRESSION, ((GBoxedCopyFunc) (vala_code_node_ref)), vala_code_node_unref, g_direct_equal)));
}


static void vala_element_access_finalize (ValaCodeNode* obj) {
	ValaElementAccess * self;
	self = VALA_ELEMENT_ACCESS (obj);
	(self->priv->_container == NULL ? NULL : (self->priv->_container = (vala_code_node_unref (self->priv->_container), NULL)));
	(self->priv->indices == NULL ? NULL : (self->priv->indices = (gee_collection_object_unref (self->priv->indices), NULL)));
	VALA_CODE_NODE_CLASS (vala_element_access_parent_class)->finalize (obj);
}


GType vala_element_access_get_type (void) {
	static GType vala_element_access_type_id = 0;
	if (vala_element_access_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaElementAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_element_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaElementAccess), 0, (GInstanceInitFunc) vala_element_access_instance_init, NULL };
		vala_element_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaElementAccess", &g_define_type_info, 0);
	}
	return vala_element_access_type_id;
}




