/* valaassignment.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAASSIGNMENT_H__
#define __VALA_VALAASSIGNMENT_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valaexpression.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_ASSIGNMENT (vala_assignment_get_type ())
#define VALA_ASSIGNMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ASSIGNMENT, ValaAssignment))
#define VALA_ASSIGNMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ASSIGNMENT, ValaAssignmentClass))
#define VALA_IS_ASSIGNMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ASSIGNMENT))
#define VALA_IS_ASSIGNMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ASSIGNMENT))
#define VALA_ASSIGNMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ASSIGNMENT, ValaAssignmentClass))

typedef struct _ValaAssignmentPrivate ValaAssignmentPrivate;

#define VALA_TYPE_ASSIGNMENT_OPERATOR (vala_assignment_operator_get_type ())

/**
 * Represents an assignment expression in the source code.
 *
 * Supports =, |=, &=, ^=, +=, -=, *=, /=, %=, <<=, >>=.
 */
struct _ValaAssignment {
	ValaExpression parent_instance;
	ValaAssignmentPrivate * priv;
};

struct _ValaAssignmentClass {
	ValaExpressionClass parent_class;
};

typedef enum  {
	VALA_ASSIGNMENT_OPERATOR_NONE,
	VALA_ASSIGNMENT_OPERATOR_SIMPLE,
	VALA_ASSIGNMENT_OPERATOR_BITWISE_OR,
	VALA_ASSIGNMENT_OPERATOR_BITWISE_AND,
	VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR,
	VALA_ASSIGNMENT_OPERATOR_ADD,
	VALA_ASSIGNMENT_OPERATOR_SUB,
	VALA_ASSIGNMENT_OPERATOR_MUL,
	VALA_ASSIGNMENT_OPERATOR_DIV,
	VALA_ASSIGNMENT_OPERATOR_PERCENT,
	VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT,
	VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT
} ValaAssignmentOperator;


ValaAssignment* vala_assignment_construct (GType object_type, ValaExpression* left, ValaExpression* right, ValaAssignmentOperator operator, ValaSourceReference* source_reference);
ValaAssignment* vala_assignment_new (ValaExpression* left, ValaExpression* right, ValaAssignmentOperator operator, ValaSourceReference* source_reference);
ValaExpression* vala_assignment_get_left (ValaAssignment* self);
void vala_assignment_set_left (ValaAssignment* self, ValaExpression* value);
ValaAssignmentOperator vala_assignment_get_operator (ValaAssignment* self);
void vala_assignment_set_operator (ValaAssignment* self, ValaAssignmentOperator value);
ValaExpression* vala_assignment_get_right (ValaAssignment* self);
void vala_assignment_set_right (ValaAssignment* self, ValaExpression* value);
GType vala_assignment_get_type (void);
GType vala_assignment_operator_get_type (void);


G_END_DECLS

#endif
