/* valagsignalmodule.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valagsignalmodule.h>
#include <vala/valapointertype.h>
#include <vala/valaerrortype.h>
#include <vala/valaarraytype.h>
#include <vala/valavoidtype.h>
#include <vala/valaformalparameter.h>
#include <gee/collection.h>
#include <vala/valaclass.h>
#include <vala/valainterface.h>
#include <vala/valastruct.h>
#include <vala/valaenum.h>
#include <vala/valasymbol.h>
#include <vala/valacodenode.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <gobject/valaccodebasemodule.h>




enum  {
	VALA_GSIGNAL_MODULE_DUMMY_PROPERTY
};
static char* vala_gsignal_module_get_marshaller_type_name (ValaGSignalModule* self, ValaDataType* t, gboolean dbus);
static char* vala_gsignal_module_get_marshaller_type_name_for_parameter (ValaGSignalModule* self, ValaFormalParameter* param, gboolean dbus);
static char* vala_gsignal_module_real_get_marshaller_function (ValaCCodeModule* base, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
static char* vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self, ValaDataType* t);
static char* vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self, ValaFormalParameter* p);
static char* vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
static void vala_gsignal_module_real_visit_signal (ValaCCodeModule* base, ValaSignal* sig);
static void vala_gsignal_module_real_generate_marshaller (ValaCCodeModule* base, GeeList* params, ValaDataType* return_type, gboolean dbus);
static ValaCCodeFunctionCall* vala_gsignal_module_real_get_signal_creation (ValaCCodeModule* base, ValaSignal* sig, ValaTypeSymbol* type);
static gpointer vala_gsignal_module_parent_class = NULL;



ValaGSignalModule* vala_gsignal_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaGSignalModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = ((ValaGSignalModule*) (g_type_create_instance (object_type)));
	self = ((ValaGSignalModule*) (vala_gobject_module_construct (object_type, codegen, next)));
	return self;
}


ValaGSignalModule* vala_gsignal_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_gsignal_module_construct (VALA_TYPE_GSIGNAL_MODULE, codegen, next);
}


static char* vala_gsignal_module_get_marshaller_type_name (ValaGSignalModule* self, ValaDataType* t, gboolean dbus) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	if (VALA_IS_POINTER_TYPE (t) || vala_data_type_get_type_parameter (t) != NULL) {
		const char* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = ("POINTER"), (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
	} else {
		if (VALA_IS_ERROR_TYPE (t)) {
			const char* _tmp2;
			_tmp2 = NULL;
			return (_tmp2 = ("POINTER"), (_tmp2 == NULL ? NULL : g_strdup (_tmp2)));
		} else {
			if (VALA_IS_ARRAY_TYPE (t)) {
				if (dbus) {
					const char* _tmp4;
					_tmp4 = NULL;
					return (_tmp4 = ("BOXED"), (_tmp4 == NULL ? NULL : g_strdup (_tmp4)));
				} else {
					if (vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (t)))) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->string_type)) {
						const char* _tmp6;
						_tmp6 = NULL;
						return (_tmp6 = ("BOXED_INT"), (_tmp6 == NULL ? NULL : g_strdup (_tmp6)));
					} else {
						const char* _tmp8;
						_tmp8 = NULL;
						return (_tmp8 = ("POINTER_INT"), (_tmp8 == NULL ? NULL : g_strdup (_tmp8)));
					}
				}
			} else {
				if (VALA_IS_VOID_TYPE (t)) {
					const char* _tmp10;
					_tmp10 = NULL;
					return (_tmp10 = ("VOID"), (_tmp10 == NULL ? NULL : g_strdup (_tmp10)));
				} else {
					char* _tmp12;
					gboolean _tmp13;
					_tmp12 = NULL;
					if ((_tmp13 = dbus && g_str_has_prefix ((_tmp12 = vala_data_type_get_type_signature (t)), "("), (_tmp12 = (g_free (_tmp12), NULL)), _tmp13)) {
						const char* _tmp14;
						_tmp14 = NULL;
						return (_tmp14 = ("BOXED"), (_tmp14 == NULL ? NULL : g_strdup (_tmp14)));
					} else {
						return vala_typesymbol_get_marshaller_type_name (vala_data_type_get_data_type (t));
					}
				}
			}
		}
	}
}


static char* vala_gsignal_module_get_marshaller_type_name_for_parameter (ValaGSignalModule* self, ValaFormalParameter* param, gboolean dbus) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (param != NULL, NULL);
	if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
		const char* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = ("POINTER"), (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
	} else {
		return vala_gsignal_module_get_marshaller_type_name (self, vala_formal_parameter_get_parameter_type (param), dbus);
	}
}


static char* vala_gsignal_module_real_get_marshaller_function (ValaCCodeModule* base, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus) {
	ValaGSignalModule * self;
	char* signature;
	char* ret;
	char* _tmp1;
	char* _tmp0;
	char* _tmp5;
	self = ((ValaGSignalModule*) (base));
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	signature = vala_gsignal_module_get_marshaller_signature (self, params, return_type, dbus);
	ret = NULL;
	if (prefix == NULL) {
		if (gee_collection_contains (((GeeCollection*) (((ValaCCodeBaseModule*) (self))->predefined_marshal_set)), signature)) {
			prefix = "g_cclosure_marshal";
		} else {
			prefix = "g_cclosure_user_marshal";
		}
	}
	_tmp1 = NULL;
	_tmp0 = NULL;
	ret = (_tmp1 = g_strdup_printf ("%s_%s_", prefix, (_tmp0 = vala_gsignal_module_get_marshaller_type_name (self, return_type, dbus))), (ret = (g_free (ret), NULL)), _tmp1);
	_tmp0 = (g_free (_tmp0), NULL);
	if (params == NULL || gee_collection_get_size (((GeeCollection*) (params))) == 0) {
		char* _tmp2;
		_tmp2 = NULL;
		ret = (_tmp2 = g_strconcat (ret, "_VOID", NULL), (ret = (g_free (ret), NULL)), _tmp2);
	} else {
		{
			GeeList* p_collection;
			int p_it;
			p_collection = params;
			for (p_it = 0; p_it < gee_collection_get_size (GEE_COLLECTION (p_collection)); p_it = p_it + 1) {
				ValaFormalParameter* p;
				p = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (p_collection), p_it)));
				{
					char* _tmp4;
					char* _tmp3;
					_tmp4 = NULL;
					_tmp3 = NULL;
					ret = (_tmp4 = g_strdup_printf ("%s_%s", ret, (_tmp3 = vala_gsignal_module_get_marshaller_type_name_for_parameter (self, p, dbus))), (ret = (g_free (ret), NULL)), _tmp4);
					_tmp3 = (g_free (_tmp3), NULL);
					(p == NULL ? NULL : (p = (vala_code_node_unref (p), NULL)));
				}
			}
		}
	}
	_tmp5 = NULL;
	return (_tmp5 = ret, (signature = (g_free (signature), NULL)), _tmp5);
}


static char* vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self, ValaDataType* t) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	if (VALA_IS_POINTER_TYPE (t) || vala_data_type_get_type_parameter (t) != NULL) {
		return g_strdup ("gpointer");
	} else {
		if (VALA_IS_VOID_TYPE (t)) {
			return g_strdup ("void");
		} else {
			if (vala_data_type_get_data_type (t) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->string_type)) {
				return g_strdup ("const char*");
			} else {
				if (VALA_IS_CLASS (vala_data_type_get_data_type (t)) || VALA_IS_INTERFACE (vala_data_type_get_data_type (t))) {
					return g_strdup ("gpointer");
				} else {
					if (VALA_IS_STRUCT (vala_data_type_get_data_type (t))) {
						ValaStruct* _tmp4;
						ValaStruct* st;
						_tmp4 = NULL;
						st = (_tmp4 = VALA_STRUCT (vala_data_type_get_data_type (t)), (_tmp4 == NULL ? NULL : vala_code_node_ref (_tmp4)));
						if (vala_struct_is_simple_type (st)) {
							char* _tmp5;
							_tmp5 = NULL;
							return (_tmp5 = vala_typesymbol_get_cname (vala_data_type_get_data_type (t), FALSE), (st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL))), _tmp5);
						} else {
							char* _tmp6;
							_tmp6 = NULL;
							return (_tmp6 = g_strdup ("gpointer"), (st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL))), _tmp6);
						}
						(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
					} else {
						if (VALA_IS_ENUM (vala_data_type_get_data_type (t))) {
							return g_strdup ("gint");
						} else {
							if (VALA_IS_ARRAY_TYPE (t)) {
								return g_strdup ("gpointer");
							} else {
								if (VALA_IS_ERROR_TYPE (t)) {
									return g_strdup ("gpointer");
								}
							}
						}
					}
				}
			}
		}
	}
	return NULL;
}


static char* vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self, ValaFormalParameter* p) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	if (vala_formal_parameter_get_direction (p) != VALA_PARAMETER_DIRECTION_IN) {
		return g_strdup ("gpointer");
	} else {
		return vala_gsignal_module_get_value_type_name_from_type_reference (self, vala_formal_parameter_get_parameter_type (p));
	}
}


static char* vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus) {
	char* signature;
	char* _tmp1;
	char* _tmp0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	signature = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	signature = (_tmp1 = g_strdup_printf ("%s:", (_tmp0 = vala_gsignal_module_get_marshaller_type_name (self, return_type, dbus))), (signature = (g_free (signature), NULL)), _tmp1);
	_tmp0 = (g_free (_tmp0), NULL);
	if (params == NULL || gee_collection_get_size (((GeeCollection*) (params))) == 0) {
		char* _tmp2;
		_tmp2 = NULL;
		signature = (_tmp2 = g_strconcat (signature, "VOID", NULL), (signature = (g_free (signature), NULL)), _tmp2);
	} else {
		gboolean first;
		first = TRUE;
		{
			GeeList* p_collection;
			int p_it;
			p_collection = params;
			for (p_it = 0; p_it < gee_collection_get_size (GEE_COLLECTION (p_collection)); p_it = p_it + 1) {
				ValaFormalParameter* p;
				p = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (p_collection), p_it)));
				{
					if (first) {
						char* _tmp4;
						char* _tmp3;
						_tmp4 = NULL;
						_tmp3 = NULL;
						signature = (_tmp4 = g_strconcat (signature, (_tmp3 = vala_gsignal_module_get_marshaller_type_name_for_parameter (self, p, dbus)), NULL), (signature = (g_free (signature), NULL)), _tmp4);
						_tmp3 = (g_free (_tmp3), NULL);
						first = FALSE;
					} else {
						char* _tmp6;
						char* _tmp5;
						_tmp6 = NULL;
						_tmp5 = NULL;
						signature = (_tmp6 = g_strdup_printf ("%s,%s", signature, (_tmp5 = vala_gsignal_module_get_marshaller_type_name_for_parameter (self, p, dbus))), (signature = (g_free (signature), NULL)), _tmp6);
						_tmp5 = (g_free (_tmp5), NULL);
					}
					(p == NULL ? NULL : (p = (vala_code_node_unref (p), NULL)));
				}
			}
		}
	}
	return signature;
}


static void vala_gsignal_module_real_visit_signal (ValaCCodeModule* base, ValaSignal* sig) {
	ValaGSignalModule * self;
	GeeList* _tmp4;
	self = ((ValaGSignalModule*) (base));
	g_return_if_fail (sig != NULL);
	/* parent_symbol may be null for late bound signals*/
	if (vala_symbol_get_parent_symbol (((ValaSymbol*) (sig))) != NULL) {
		ValaTypeSymbol* _tmp1;
		ValaSymbol* _tmp0;
		ValaTypeSymbol* dt;
		_tmp1 = NULL;
		_tmp0 = NULL;
		dt = (_tmp1 = (_tmp0 = vala_symbol_get_parent_symbol (((ValaSymbol*) (sig))), (VALA_IS_TYPESYMBOL (_tmp0) ? ((ValaTypeSymbol*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
		if (!vala_typesymbol_is_subtype_of (dt, ((ValaCCodeBaseModule*) (self))->gobject_type)) {
			char* _tmp3;
			char* _tmp2;
			vala_code_node_set_error (((ValaCodeNode*) (sig)), TRUE);
			_tmp3 = NULL;
			_tmp2 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (sig))), (_tmp3 = g_strdup_printf ("Only classes and interfaces deriving from GLib.Object support signals. `%s' does not derive from GLib.Object.", (_tmp2 = vala_symbol_get_full_name (((ValaSymbol*) (dt)))))));
			_tmp3 = (g_free (_tmp3), NULL);
			_tmp2 = (g_free (_tmp2), NULL);
			(dt == NULL ? NULL : (dt = (vala_code_node_unref (dt), NULL)));
			return;
		}
		(dt == NULL ? NULL : (dt = (vala_code_node_unref (dt), NULL)));
	}
	vala_code_node_accept_children (((ValaCodeNode*) (sig)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	_tmp4 = NULL;
	vala_ccode_module_generate_marshaller (((ValaCCodeModule*) (self)), (_tmp4 = vala_signal_get_parameters (sig)), vala_signal_get_return_type (sig), FALSE);
	(_tmp4 == NULL ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL)));
}


static void vala_gsignal_module_real_generate_marshaller (ValaCCodeModule* base, GeeList* params, ValaDataType* return_type, gboolean dbus) {
	ValaGSignalModule * self;
	char* signature;
	gint n_params;
	gint i;
	char* _tmp0;
	char* _tmp1;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* signal_marshaller;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeFormalParameter* _tmp7;
	ValaCCodeFormalParameter* _tmp8;
	ValaCCodeFunction* _tmp9;
	ValaCCodeBlock* marshaller_body;
	char* _tmp10;
	ValaCCodeFunctionDeclarator* _tmp11;
	ValaCCodeFunctionDeclarator* callback_decl;
	ValaCCodeFormalParameter* _tmp12;
	ValaCCodeFormalParameter* _tmp18;
	ValaCCodeTypeDefinition* _tmp20;
	char* _tmp19;
	char* _tmp21;
	ValaCCodeDeclaration* _tmp22;
	ValaCCodeDeclaration* var_decl;
	ValaCCodeVariableDeclarator* _tmp23;
	ValaCCodeDeclaration* _tmp24;
	ValaCCodeVariableDeclarator* _tmp27;
	ValaCCodeCastExpression* _tmp26;
	ValaCCodeIdentifier* _tmp25;
	ValaCCodeDeclaration* _tmp28;
	ValaCCodeVariableDeclarator* _tmp29;
	ValaCCodeVariableDeclarator* _tmp30;
	ValaCCodeFunctionCall* fc;
	ValaCCodeFunctionCall* _tmp41;
	ValaCCodeIdentifier* _tmp40;
	ValaCCodeBinaryExpression* _tmp45;
	ValaCCodeConstant* _tmp44;
	char* _tmp43;
	ValaCCodeIdentifier* _tmp42;
	ValaCCodeExpressionStatement* _tmp46;
	ValaCCodeIdentifier* _tmp47;
	ValaCCodeMemberAccess* _tmp48;
	ValaCCodeMemberAccess* data;
	ValaCCodeMemberAccess* _tmp50;
	ValaCCodeIdentifier* _tmp49;
	ValaCCodeMemberAccess* _tmp51;
	ValaCCodeMemberAccess* param;
	ValaCCodeConstant* _tmp52;
	ValaCCodeFunctionCall* _tmp53;
	ValaCCodeFunctionCall* cond;
	ValaCCodeIdentifier* _tmp54;
	ValaCCodeBlock* true_block;
	ValaCCodeExpressionStatement* _tmp57;
	ValaCCodeAssignment* _tmp56;
	ValaCCodeIdentifier* _tmp55;
	ValaCCodeExpressionStatement* _tmp60;
	ValaCCodeAssignment* _tmp59;
	ValaCCodeIdentifier* _tmp58;
	ValaCCodeBlock* false_block;
	ValaCCodeExpressionStatement* _tmp63;
	ValaCCodeAssignment* _tmp62;
	ValaCCodeIdentifier* _tmp61;
	ValaCCodeExpressionStatement* _tmp66;
	ValaCCodeAssignment* _tmp65;
	ValaCCodeIdentifier* _tmp64;
	ValaCCodeIfStatement* _tmp67;
	ValaCCodeCastExpression* _tmp75;
	char* _tmp74;
	ValaCCodeConditionalExpression* _tmp73;
	ValaCCodeMemberAccess* _tmp72;
	ValaCCodeIdentifier* _tmp71;
	ValaCCodeIdentifier* _tmp70;
	ValaCCodeIdentifier* _tmp69;
	ValaCCodeIdentifier* _tmp68;
	ValaCCodeAssignment* _tmp76;
	ValaCCodeAssignment* c_assign;
	ValaCCodeExpressionStatement* _tmp77;
	ValaCCodeFunctionCall* _tmp79;
	ValaCCodeIdentifier* _tmp78;
	ValaCCodeIdentifier* _tmp80;
	ValaCCodeIdentifier* _tmp103;
	self = ((ValaGSignalModule*) (base));
	g_return_if_fail (params != NULL);
	g_return_if_fail (return_type != NULL);
	signature = NULL;
	n_params = 0;
	i = 0;
	/* check whether a signal with the same signature already exists for this source file (or predefined) */
	_tmp0 = NULL;
	signature = (_tmp0 = vala_gsignal_module_get_marshaller_signature (self, params, return_type, dbus), (signature = (g_free (signature), NULL)), _tmp0);
	if (gee_collection_contains (((GeeCollection*) (((ValaCCodeBaseModule*) (self))->predefined_marshal_set)), signature) || gee_collection_contains (((GeeCollection*) (((ValaCCodeBaseModule*) (self))->user_marshal_set)), signature)) {
		signature = (g_free (signature), NULL);
		return;
	}
	_tmp1 = NULL;
	_tmp2 = NULL;
	signal_marshaller = (_tmp2 = vala_ccode_function_new ((_tmp1 = vala_ccode_module_get_marshaller_function (((ValaCCodeModule*) (self)), params, return_type, NULL, dbus)), "void"), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2);
	vala_ccode_function_set_modifiers (signal_marshaller, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp3 = vala_ccode_formal_parameter_new ("closure", "GClosure *")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp4 = vala_ccode_formal_parameter_new ("return_value", "GValue *")));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp5 = vala_ccode_formal_parameter_new ("n_param_values", "guint")));
	(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp6 = vala_ccode_formal_parameter_new ("param_values", "const GValue *")));
	(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
	_tmp7 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp7 = vala_ccode_formal_parameter_new ("invocation_hint", "gpointer")));
	(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
	_tmp8 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp8 = vala_ccode_formal_parameter_new ("marshal_data", "gpointer")));
	(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
	_tmp9 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_signal_marshaller_declaration, ((ValaCCodeNode*) ((_tmp9 = vala_ccode_function_copy (signal_marshaller)))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
	marshaller_body = vala_ccode_block_new ();
	_tmp10 = NULL;
	_tmp11 = NULL;
	callback_decl = (_tmp11 = vala_ccode_function_declarator_new ((_tmp10 = vala_ccode_module_get_marshaller_function (((ValaCCodeModule*) (self)), params, return_type, "GMarshalFunc", dbus))), (_tmp10 = (g_free (_tmp10), NULL)), _tmp11);
	_tmp12 = NULL;
	vala_ccode_function_declarator_add_parameter (callback_decl, (_tmp12 = vala_ccode_formal_parameter_new ("data1", "gpointer")));
	(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
	n_params = 1;
	{
		GeeList* p_collection;
		int p_it;
		p_collection = params;
		for (p_it = 0; p_it < gee_collection_get_size (GEE_COLLECTION (p_collection)); p_it = p_it + 1) {
			ValaFormalParameter* p;
			p = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (p_collection), p_it)));
			{
				ValaCCodeFormalParameter* _tmp15;
				char* _tmp14;
				char* _tmp13;
				_tmp15 = NULL;
				_tmp14 = NULL;
				_tmp13 = NULL;
				vala_ccode_function_declarator_add_parameter (callback_decl, (_tmp15 = vala_ccode_formal_parameter_new ((_tmp13 = g_strdup_printf ("arg_%d", n_params)), (_tmp14 = vala_gsignal_module_get_value_type_name_from_parameter (self, p)))));
				(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
				_tmp14 = (g_free (_tmp14), NULL);
				_tmp13 = (g_free (_tmp13), NULL);
				n_params++;
				if (vala_data_type_is_array (vala_formal_parameter_get_parameter_type (p)) && !dbus) {
					ValaCCodeFormalParameter* _tmp17;
					char* _tmp16;
					_tmp17 = NULL;
					_tmp16 = NULL;
					vala_ccode_function_declarator_add_parameter (callback_decl, (_tmp17 = vala_ccode_formal_parameter_new ((_tmp16 = g_strdup_printf ("arg_%d", n_params)), "gint")));
					(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
					_tmp16 = (g_free (_tmp16), NULL);
					n_params++;
				}
				(p == NULL ? NULL : (p = (vala_code_node_unref (p), NULL)));
			}
		}
	}
	_tmp18 = NULL;
	vala_ccode_function_declarator_add_parameter (callback_decl, (_tmp18 = vala_ccode_formal_parameter_new ("data2", "gpointer")));
	(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
	_tmp20 = NULL;
	_tmp19 = NULL;
	vala_ccode_block_add_statement (marshaller_body, ((ValaCCodeNode*) ((_tmp20 = vala_ccode_type_definition_new ((_tmp19 = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type)), ((ValaCCodeDeclarator*) (callback_decl)))))));
	(_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)));
	_tmp19 = (g_free (_tmp19), NULL);
	_tmp21 = NULL;
	_tmp22 = NULL;
	var_decl = (_tmp22 = vala_ccode_declaration_new ((_tmp21 = vala_ccode_module_get_marshaller_function (((ValaCCodeModule*) (self)), params, return_type, "GMarshalFunc", dbus))), (_tmp21 = (g_free (_tmp21), NULL)), _tmp22);
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	_tmp23 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, ((ValaCCodeDeclarator*) ((_tmp23 = vala_ccode_variable_declarator_new ("callback")))));
	(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
	vala_ccode_block_add_statement (marshaller_body, ((ValaCCodeNode*) (var_decl)));
	_tmp24 = NULL;
	var_decl = (_tmp24 = vala_ccode_declaration_new ("GCClosure *"), (var_decl == NULL ? NULL : (var_decl = (vala_ccode_node_unref (var_decl), NULL))), _tmp24);
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	_tmp27 = NULL;
	_tmp26 = NULL;
	_tmp25 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, ((ValaCCodeDeclarator*) ((_tmp27 = vala_ccode_variable_declarator_new_with_initializer ("cc", ((ValaCCodeExpression*) ((_tmp26 = vala_ccode_cast_expression_new (((ValaCCodeExpression*) ((_tmp25 = vala_ccode_identifier_new ("closure")))), "GCClosure *")))))))));
	(_tmp27 == NULL ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)));
	(_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)));
	(_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)));
	vala_ccode_block_add_statement (marshaller_body, ((ValaCCodeNode*) (var_decl)));
	_tmp28 = NULL;
	var_decl = (_tmp28 = vala_ccode_declaration_new ("gpointer"), (var_decl == NULL ? NULL : (var_decl = (vala_ccode_node_unref (var_decl), NULL))), _tmp28);
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	_tmp29 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, ((ValaCCodeDeclarator*) ((_tmp29 = vala_ccode_variable_declarator_new ("data1")))));
	(_tmp29 == NULL ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)));
	_tmp30 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, ((ValaCCodeDeclarator*) ((_tmp30 = vala_ccode_variable_declarator_new ("data2")))));
	(_tmp30 == NULL ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)));
	vala_ccode_block_add_statement (marshaller_body, ((ValaCCodeNode*) (var_decl)));
	fc = NULL;
	if (vala_data_type_get_data_type (return_type) != NULL || vala_data_type_is_array (return_type)) {
		ValaCCodeDeclaration* _tmp32;
		char* _tmp31;
		ValaCCodeVariableDeclarator* _tmp33;
		ValaCCodeFunctionCall* _tmp35;
		ValaCCodeIdentifier* _tmp34;
		ValaCCodeBinaryExpression* _tmp38;
		ValaCCodeConstant* _tmp37;
		ValaCCodeIdentifier* _tmp36;
		ValaCCodeExpressionStatement* _tmp39;
		_tmp32 = NULL;
		_tmp31 = NULL;
		var_decl = (_tmp32 = vala_ccode_declaration_new ((_tmp31 = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type))), (var_decl == NULL ? NULL : (var_decl = (vala_ccode_node_unref (var_decl), NULL))), _tmp32);
		_tmp31 = (g_free (_tmp31), NULL);
		_tmp33 = NULL;
		vala_ccode_declaration_add_declarator (var_decl, ((ValaCCodeDeclarator*) ((_tmp33 = vala_ccode_variable_declarator_new ("v_return")))));
		(_tmp33 == NULL ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)));
		vala_ccode_block_add_statement (marshaller_body, ((ValaCCodeNode*) (var_decl)));
		_tmp35 = NULL;
		_tmp34 = NULL;
		fc = (_tmp35 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp34 = vala_ccode_identifier_new ("g_return_if_fail"))))), (fc == NULL ? NULL : (fc = (vala_ccode_node_unref (fc), NULL))), _tmp35);
		(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
		_tmp38 = NULL;
		_tmp37 = NULL;
		_tmp36 = NULL;
		vala_ccode_function_call_add_argument (fc, ((ValaCCodeExpression*) ((_tmp38 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, ((ValaCCodeExpression*) ((_tmp36 = vala_ccode_identifier_new ("return_value")))), ((ValaCCodeExpression*) ((_tmp37 = vala_ccode_constant_new ("NULL")))))))));
		(_tmp38 == NULL ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL)));
		(_tmp37 == NULL ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL)));
		(_tmp36 == NULL ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)));
		_tmp39 = NULL;
		vala_ccode_block_add_statement (marshaller_body, ((ValaCCodeNode*) ((_tmp39 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (fc)))))));
		(_tmp39 == NULL ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL)));
	}
	_tmp41 = NULL;
	_tmp40 = NULL;
	fc = (_tmp41 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp40 = vala_ccode_identifier_new ("g_return_if_fail"))))), (fc == NULL ? NULL : (fc = (vala_ccode_node_unref (fc), NULL))), _tmp41);
	(_tmp40 == NULL ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL)));
	_tmp45 = NULL;
	_tmp44 = NULL;
	_tmp43 = NULL;
	_tmp42 = NULL;
	vala_ccode_function_call_add_argument (fc, ((ValaCCodeExpression*) ((_tmp45 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, ((ValaCCodeExpression*) ((_tmp42 = vala_ccode_identifier_new ("n_param_values")))), ((ValaCCodeExpression*) ((_tmp44 = vala_ccode_constant_new ((_tmp43 = g_strdup_printf ("%i", n_params)))))))))));
	(_tmp45 == NULL ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL)));
	(_tmp44 == NULL ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL)));
	_tmp43 = (g_free (_tmp43), NULL);
	(_tmp42 == NULL ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL)));
	_tmp46 = NULL;
	vala_ccode_block_add_statement (marshaller_body, ((ValaCCodeNode*) ((_tmp46 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (fc)))))));
	(_tmp46 == NULL ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL)));
	_tmp47 = NULL;
	_tmp48 = NULL;
	data = (_tmp48 = vala_ccode_member_access_new (((ValaCCodeExpression*) ((_tmp47 = vala_ccode_identifier_new ("closure")))), "data", TRUE), (_tmp47 == NULL ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL))), _tmp48);
	_tmp50 = NULL;
	_tmp49 = NULL;
	_tmp51 = NULL;
	param = (_tmp51 = vala_ccode_member_access_new (((ValaCCodeExpression*) ((_tmp50 = vala_ccode_member_access_new (((ValaCCodeExpression*) ((_tmp49 = vala_ccode_identifier_new ("param_values")))), "data[0]", TRUE)))), "v_pointer", FALSE), (_tmp50 == NULL ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL))), (_tmp49 == NULL ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL))), _tmp51);
	_tmp52 = NULL;
	_tmp53 = NULL;
	cond = (_tmp53 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp52 = vala_ccode_constant_new ("G_CCLOSURE_SWAP_DATA"))))), (_tmp52 == NULL ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL))), _tmp53);
	_tmp54 = NULL;
	vala_ccode_function_call_add_argument (cond, ((ValaCCodeExpression*) ((_tmp54 = vala_ccode_identifier_new ("closure")))));
	(_tmp54 == NULL ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL)));
	true_block = vala_ccode_block_new ();
	_tmp57 = NULL;
	_tmp56 = NULL;
	_tmp55 = NULL;
	vala_ccode_block_add_statement (true_block, ((ValaCCodeNode*) ((_tmp57 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp56 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp55 = vala_ccode_identifier_new ("data1")))), ((ValaCCodeExpression*) (data)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
	(_tmp57 == NULL ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL)));
	(_tmp56 == NULL ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL)));
	(_tmp55 == NULL ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL)));
	_tmp60 = NULL;
	_tmp59 = NULL;
	_tmp58 = NULL;
	vala_ccode_block_add_statement (true_block, ((ValaCCodeNode*) ((_tmp60 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp59 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp58 = vala_ccode_identifier_new ("data2")))), ((ValaCCodeExpression*) (param)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
	(_tmp60 == NULL ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL)));
	(_tmp59 == NULL ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL)));
	(_tmp58 == NULL ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL)));
	false_block = vala_ccode_block_new ();
	_tmp63 = NULL;
	_tmp62 = NULL;
	_tmp61 = NULL;
	vala_ccode_block_add_statement (false_block, ((ValaCCodeNode*) ((_tmp63 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp62 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp61 = vala_ccode_identifier_new ("data1")))), ((ValaCCodeExpression*) (param)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
	(_tmp63 == NULL ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL)));
	(_tmp62 == NULL ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL)));
	(_tmp61 == NULL ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL)));
	_tmp66 = NULL;
	_tmp65 = NULL;
	_tmp64 = NULL;
	vala_ccode_block_add_statement (false_block, ((ValaCCodeNode*) ((_tmp66 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp65 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp64 = vala_ccode_identifier_new ("data2")))), ((ValaCCodeExpression*) (data)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
	(_tmp66 == NULL ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL)));
	(_tmp65 == NULL ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL)));
	(_tmp64 == NULL ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL)));
	_tmp67 = NULL;
	vala_ccode_block_add_statement (marshaller_body, ((ValaCCodeNode*) ((_tmp67 = vala_ccode_if_statement_new (((ValaCCodeExpression*) (cond)), ((ValaCCodeStatement*) (true_block)), ((ValaCCodeStatement*) (false_block)))))));
	(_tmp67 == NULL ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL)));
	_tmp75 = NULL;
	_tmp74 = NULL;
	_tmp73 = NULL;
	_tmp72 = NULL;
	_tmp71 = NULL;
	_tmp70 = NULL;
	_tmp69 = NULL;
	_tmp68 = NULL;
	_tmp76 = NULL;
	c_assign = (_tmp76 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp68 = vala_ccode_identifier_new ("callback")))), ((ValaCCodeExpression*) ((_tmp75 = vala_ccode_cast_expression_new (((ValaCCodeExpression*) ((_tmp73 = vala_ccode_conditional_expression_new (((ValaCCodeExpression*) ((_tmp69 = vala_ccode_identifier_new ("marshal_data")))), ((ValaCCodeExpression*) ((_tmp70 = vala_ccode_identifier_new ("marshal_data")))), ((ValaCCodeExpression*) ((_tmp72 = vala_ccode_member_access_new (((ValaCCodeExpression*) ((_tmp71 = vala_ccode_identifier_new ("cc")))), "callback", TRUE)))))))), (_tmp74 = vala_ccode_module_get_marshaller_function (((ValaCCodeModule*) (self)), params, return_type, "GMarshalFunc", dbus)))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp75 == NULL ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL))), (_tmp74 = (g_free (_tmp74), NULL)), (_tmp73 == NULL ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL))), (_tmp72 == NULL ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL))), (_tmp71 == NULL ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL))), (_tmp70 == NULL ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL))), (_tmp69 == NULL ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL))), (_tmp68 == NULL ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL))), _tmp76);
	_tmp77 = NULL;
	vala_ccode_block_add_statement (marshaller_body, ((ValaCCodeNode*) ((_tmp77 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (c_assign)))))));
	(_tmp77 == NULL ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL)));
	_tmp79 = NULL;
	_tmp78 = NULL;
	fc = (_tmp79 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp78 = vala_ccode_identifier_new ("callback"))))), (fc == NULL ? NULL : (fc = (vala_ccode_node_unref (fc), NULL))), _tmp79);
	(_tmp78 == NULL ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL)));
	_tmp80 = NULL;
	vala_ccode_function_call_add_argument (fc, ((ValaCCodeExpression*) ((_tmp80 = vala_ccode_identifier_new ("data1")))));
	(_tmp80 == NULL ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL)));
	i = 1;
	{
		GeeList* p_collection;
		int p_it;
		p_collection = params;
		for (p_it = 0; p_it < gee_collection_get_size (GEE_COLLECTION (p_collection)); p_it = p_it + 1) {
			ValaFormalParameter* p;
			p = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (p_collection), p_it)));
			{
				char* get_value_function;
				gboolean is_array;
				ValaCCodeIdentifier* _tmp91;
				ValaCCodeFunctionCall* _tmp92;
				ValaCCodeFunctionCall* inner_fc;
				ValaCCodeBinaryExpression* _tmp96;
				ValaCCodeIdentifier* _tmp95;
				char* _tmp94;
				ValaCCodeIdentifier* _tmp93;
				get_value_function = NULL;
				is_array = vala_data_type_is_array (vala_formal_parameter_get_parameter_type (p));
				if (vala_formal_parameter_get_direction (p) != VALA_PARAMETER_DIRECTION_IN) {
					char* _tmp81;
					_tmp81 = NULL;
					get_value_function = (_tmp81 = g_strdup ("g_value_get_pointer"), (get_value_function = (g_free (get_value_function), NULL)), _tmp81);
				} else {
					if (is_array) {
						if (dbus) {
							char* _tmp82;
							_tmp82 = NULL;
							get_value_function = (_tmp82 = g_strdup ("g_value_get_boxed"), (get_value_function = (g_free (get_value_function), NULL)), _tmp82);
						} else {
							if (vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (p))))) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->string_type)) {
								char* _tmp83;
								_tmp83 = NULL;
								get_value_function = (_tmp83 = g_strdup ("g_value_get_boxed"), (get_value_function = (g_free (get_value_function), NULL)), _tmp83);
							} else {
								char* _tmp84;
								_tmp84 = NULL;
								get_value_function = (_tmp84 = g_strdup ("g_value_get_pointer"), (get_value_function = (g_free (get_value_function), NULL)), _tmp84);
							}
						}
					} else {
						if (VALA_IS_POINTER_TYPE (vala_formal_parameter_get_parameter_type (p)) || vala_data_type_get_type_parameter (vala_formal_parameter_get_parameter_type (p)) != NULL) {
							char* _tmp85;
							_tmp85 = NULL;
							get_value_function = (_tmp85 = g_strdup ("g_value_get_pointer"), (get_value_function = (g_free (get_value_function), NULL)), _tmp85);
						} else {
							if (VALA_IS_ERROR_TYPE (vala_formal_parameter_get_parameter_type (p))) {
								char* _tmp86;
								_tmp86 = NULL;
								get_value_function = (_tmp86 = g_strdup ("g_value_get_pointer"), (get_value_function = (g_free (get_value_function), NULL)), _tmp86);
							} else {
								char* _tmp87;
								gboolean _tmp88;
								_tmp87 = NULL;
								if ((_tmp88 = dbus && g_str_has_prefix ((_tmp87 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (p))), "("), (_tmp87 = (g_free (_tmp87), NULL)), _tmp88)) {
									char* _tmp89;
									_tmp89 = NULL;
									get_value_function = (_tmp89 = g_strdup ("g_value_get_boxed"), (get_value_function = (g_free (get_value_function), NULL)), _tmp89);
								} else {
									char* _tmp90;
									_tmp90 = NULL;
									get_value_function = (_tmp90 = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (p))), (get_value_function = (g_free (get_value_function), NULL)), _tmp90);
								}
							}
						}
					}
				}
				_tmp91 = NULL;
				_tmp92 = NULL;
				inner_fc = (_tmp92 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp91 = vala_ccode_identifier_new (get_value_function))))), (_tmp91 == NULL ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL))), _tmp92);
				_tmp96 = NULL;
				_tmp95 = NULL;
				_tmp94 = NULL;
				_tmp93 = NULL;
				vala_ccode_function_call_add_argument (inner_fc, ((ValaCCodeExpression*) ((_tmp96 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, ((ValaCCodeExpression*) ((_tmp93 = vala_ccode_identifier_new ("param_values")))), ((ValaCCodeExpression*) ((_tmp95 = vala_ccode_identifier_new ((_tmp94 = g_strdup_printf ("%i", i)))))))))));
				(_tmp96 == NULL ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL)));
				(_tmp95 == NULL ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL)));
				_tmp94 = (g_free (_tmp94), NULL);
				(_tmp93 == NULL ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL)));
				vala_ccode_function_call_add_argument (fc, ((ValaCCodeExpression*) (inner_fc)));
				i++;
				if (is_array && !dbus) {
					ValaCCodeFunctionCall* _tmp98;
					ValaCCodeIdentifier* _tmp97;
					ValaCCodeBinaryExpression* _tmp102;
					ValaCCodeIdentifier* _tmp101;
					char* _tmp100;
					ValaCCodeIdentifier* _tmp99;
					_tmp98 = NULL;
					_tmp97 = NULL;
					inner_fc = (_tmp98 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp97 = vala_ccode_identifier_new ("g_value_get_int"))))), (inner_fc == NULL ? NULL : (inner_fc = (vala_ccode_node_unref (inner_fc), NULL))), _tmp98);
					(_tmp97 == NULL ? NULL : (_tmp97 = (vala_ccode_node_unref (_tmp97), NULL)));
					_tmp102 = NULL;
					_tmp101 = NULL;
					_tmp100 = NULL;
					_tmp99 = NULL;
					vala_ccode_function_call_add_argument (inner_fc, ((ValaCCodeExpression*) ((_tmp102 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, ((ValaCCodeExpression*) ((_tmp99 = vala_ccode_identifier_new ("param_values")))), ((ValaCCodeExpression*) ((_tmp101 = vala_ccode_identifier_new ((_tmp100 = g_strdup_printf ("%i", i)))))))))));
					(_tmp102 == NULL ? NULL : (_tmp102 = (vala_ccode_node_unref (_tmp102), NULL)));
					(_tmp101 == NULL ? NULL : (_tmp101 = (vala_ccode_node_unref (_tmp101), NULL)));
					_tmp100 = (g_free (_tmp100), NULL);
					(_tmp99 == NULL ? NULL : (_tmp99 = (vala_ccode_node_unref (_tmp99), NULL)));
					vala_ccode_function_call_add_argument (fc, ((ValaCCodeExpression*) (inner_fc)));
					i++;
				}
				(p == NULL ? NULL : (p = (vala_code_node_unref (p), NULL)));
				get_value_function = (g_free (get_value_function), NULL);
				(inner_fc == NULL ? NULL : (inner_fc = (vala_ccode_node_unref (inner_fc), NULL)));
			}
		}
	}
	_tmp103 = NULL;
	vala_ccode_function_call_add_argument (fc, ((ValaCCodeExpression*) ((_tmp103 = vala_ccode_identifier_new ("data2")))));
	(_tmp103 == NULL ? NULL : (_tmp103 = (vala_ccode_node_unref (_tmp103), NULL)));
	if (vala_data_type_get_data_type (return_type) != NULL || vala_data_type_is_array (return_type)) {
		ValaCCodeExpressionStatement* _tmp106;
		ValaCCodeAssignment* _tmp105;
		ValaCCodeIdentifier* _tmp104;
		ValaCCodeFunctionCall* set_fc;
		ValaCCodeIdentifier* _tmp128;
		ValaCCodeIdentifier* _tmp129;
		ValaCCodeExpressionStatement* _tmp130;
		_tmp106 = NULL;
		_tmp105 = NULL;
		_tmp104 = NULL;
		vala_ccode_block_add_statement (marshaller_body, ((ValaCCodeNode*) ((_tmp106 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp105 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp104 = vala_ccode_identifier_new ("v_return")))), ((ValaCCodeExpression*) (fc)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
		(_tmp106 == NULL ? NULL : (_tmp106 = (vala_ccode_node_unref (_tmp106), NULL)));
		(_tmp105 == NULL ? NULL : (_tmp105 = (vala_ccode_node_unref (_tmp105), NULL)));
		(_tmp104 == NULL ? NULL : (_tmp104 = (vala_ccode_node_unref (_tmp104), NULL)));
		set_fc = NULL;
		if (vala_data_type_is_array (return_type)) {
			if (dbus) {
				ValaCCodeFunctionCall* _tmp108;
				ValaCCodeIdentifier* _tmp107;
				_tmp108 = NULL;
				_tmp107 = NULL;
				set_fc = (_tmp108 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp107 = vala_ccode_identifier_new ("g_value_take_boxed"))))), (set_fc == NULL ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL))), _tmp108);
				(_tmp107 == NULL ? NULL : (_tmp107 = (vala_ccode_node_unref (_tmp107), NULL)));
			} else {
				if (vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (return_type)))) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->string_type)) {
					ValaCCodeFunctionCall* _tmp110;
					ValaCCodeIdentifier* _tmp109;
					_tmp110 = NULL;
					_tmp109 = NULL;
					set_fc = (_tmp110 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp109 = vala_ccode_identifier_new ("g_value_take_boxed"))))), (set_fc == NULL ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL))), _tmp110);
					(_tmp109 == NULL ? NULL : (_tmp109 = (vala_ccode_node_unref (_tmp109), NULL)));
				} else {
					ValaCCodeFunctionCall* _tmp112;
					ValaCCodeIdentifier* _tmp111;
					_tmp112 = NULL;
					_tmp111 = NULL;
					set_fc = (_tmp112 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp111 = vala_ccode_identifier_new ("g_value_set_pointer"))))), (set_fc == NULL ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL))), _tmp112);
					(_tmp111 == NULL ? NULL : (_tmp111 = (vala_ccode_node_unref (_tmp111), NULL)));
				}
			}
		} else {
			if (vala_data_type_get_type_parameter (return_type) != NULL) {
				ValaCCodeFunctionCall* _tmp114;
				ValaCCodeIdentifier* _tmp113;
				_tmp114 = NULL;
				_tmp113 = NULL;
				set_fc = (_tmp114 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp113 = vala_ccode_identifier_new ("g_value_set_pointer"))))), (set_fc == NULL ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL))), _tmp114);
				(_tmp113 == NULL ? NULL : (_tmp113 = (vala_ccode_node_unref (_tmp113), NULL)));
			} else {
				if (VALA_IS_ERROR_TYPE (return_type)) {
					ValaCCodeFunctionCall* _tmp116;
					ValaCCodeIdentifier* _tmp115;
					_tmp116 = NULL;
					_tmp115 = NULL;
					set_fc = (_tmp116 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp115 = vala_ccode_identifier_new ("g_value_set_pointer"))))), (set_fc == NULL ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL))), _tmp116);
					(_tmp115 == NULL ? NULL : (_tmp115 = (vala_ccode_node_unref (_tmp115), NULL)));
				} else {
					if (vala_data_type_get_data_type (return_type) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->string_type)) {
						ValaCCodeFunctionCall* _tmp118;
						ValaCCodeIdentifier* _tmp117;
						_tmp118 = NULL;
						_tmp117 = NULL;
						set_fc = (_tmp118 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp117 = vala_ccode_identifier_new ("g_value_take_string"))))), (set_fc == NULL ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL))), _tmp118);
						(_tmp117 == NULL ? NULL : (_tmp117 = (vala_ccode_node_unref (_tmp117), NULL)));
					} else {
						if (VALA_IS_CLASS (vala_data_type_get_data_type (return_type)) || VALA_IS_INTERFACE (vala_data_type_get_data_type (return_type))) {
							ValaCCodeFunctionCall* _tmp120;
							ValaCCodeIdentifier* _tmp119;
							_tmp120 = NULL;
							_tmp119 = NULL;
							set_fc = (_tmp120 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp119 = vala_ccode_identifier_new ("g_value_take_object"))))), (set_fc == NULL ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL))), _tmp120);
							(_tmp119 == NULL ? NULL : (_tmp119 = (vala_ccode_node_unref (_tmp119), NULL)));
						} else {
							char* _tmp121;
							gboolean _tmp122;
							_tmp121 = NULL;
							if ((_tmp122 = dbus && g_str_has_prefix ((_tmp121 = vala_data_type_get_type_signature (return_type)), "("), (_tmp121 = (g_free (_tmp121), NULL)), _tmp122)) {
								ValaCCodeFunctionCall* _tmp124;
								ValaCCodeIdentifier* _tmp123;
								_tmp124 = NULL;
								_tmp123 = NULL;
								set_fc = (_tmp124 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp123 = vala_ccode_identifier_new ("g_value_take_boxed"))))), (set_fc == NULL ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL))), _tmp124);
								(_tmp123 == NULL ? NULL : (_tmp123 = (vala_ccode_node_unref (_tmp123), NULL)));
							} else {
								ValaCCodeFunctionCall* _tmp127;
								ValaCCodeIdentifier* _tmp126;
								char* _tmp125;
								_tmp127 = NULL;
								_tmp126 = NULL;
								_tmp125 = NULL;
								set_fc = (_tmp127 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp126 = vala_ccode_identifier_new ((_tmp125 = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (return_type)))))))), (set_fc == NULL ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL))), _tmp127);
								(_tmp126 == NULL ? NULL : (_tmp126 = (vala_ccode_node_unref (_tmp126), NULL)));
								_tmp125 = (g_free (_tmp125), NULL);
							}
						}
					}
				}
			}
		}
		_tmp128 = NULL;
		vala_ccode_function_call_add_argument (set_fc, ((ValaCCodeExpression*) ((_tmp128 = vala_ccode_identifier_new ("return_value")))));
		(_tmp128 == NULL ? NULL : (_tmp128 = (vala_ccode_node_unref (_tmp128), NULL)));
		_tmp129 = NULL;
		vala_ccode_function_call_add_argument (set_fc, ((ValaCCodeExpression*) ((_tmp129 = vala_ccode_identifier_new ("v_return")))));
		(_tmp129 == NULL ? NULL : (_tmp129 = (vala_ccode_node_unref (_tmp129), NULL)));
		_tmp130 = NULL;
		vala_ccode_block_add_statement (marshaller_body, ((ValaCCodeNode*) ((_tmp130 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (set_fc)))))));
		(_tmp130 == NULL ? NULL : (_tmp130 = (vala_ccode_node_unref (_tmp130), NULL)));
		(set_fc == NULL ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)));
	} else {
		ValaCCodeExpressionStatement* _tmp131;
		_tmp131 = NULL;
		vala_ccode_block_add_statement (marshaller_body, ((ValaCCodeNode*) ((_tmp131 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (fc)))))));
		(_tmp131 == NULL ? NULL : (_tmp131 = (vala_ccode_node_unref (_tmp131), NULL)));
	}
	vala_ccode_function_set_block (signal_marshaller, marshaller_body);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_signal_marshaller_definition, ((ValaCCodeNode*) (signal_marshaller)));
	gee_collection_add (((GeeCollection*) (((ValaCCodeBaseModule*) (self))->user_marshal_set)), signature);
	signature = (g_free (signature), NULL);
	(signal_marshaller == NULL ? NULL : (signal_marshaller = (vala_ccode_node_unref (signal_marshaller), NULL)));
	(marshaller_body == NULL ? NULL : (marshaller_body = (vala_ccode_node_unref (marshaller_body), NULL)));
	(callback_decl == NULL ? NULL : (callback_decl = (vala_ccode_node_unref (callback_decl), NULL)));
	(var_decl == NULL ? NULL : (var_decl = (vala_ccode_node_unref (var_decl), NULL)));
	(fc == NULL ? NULL : (fc = (vala_ccode_node_unref (fc), NULL)));
	(data == NULL ? NULL : (data = (vala_ccode_node_unref (data), NULL)));
	(param == NULL ? NULL : (param = (vala_ccode_node_unref (param), NULL)));
	(cond == NULL ? NULL : (cond = (vala_ccode_node_unref (cond), NULL)));
	(true_block == NULL ? NULL : (true_block = (vala_ccode_node_unref (true_block), NULL)));
	(false_block == NULL ? NULL : (false_block = (vala_ccode_node_unref (false_block), NULL)));
	(c_assign == NULL ? NULL : (c_assign = (vala_ccode_node_unref (c_assign), NULL)));
}


static ValaCCodeFunctionCall* vala_gsignal_module_real_get_signal_creation (ValaCCodeModule* base, ValaSignal* sig, ValaTypeSymbol* type) {
	ValaGSignalModule * self;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* csignew;
	ValaCCodeConstant* _tmp4;
	char* _tmp3;
	char* _tmp2;
	ValaCCodeIdentifier* _tmp6;
	char* _tmp5;
	ValaCCodeConstant* _tmp7;
	ValaCCodeConstant* _tmp8;
	ValaCCodeConstant* _tmp9;
	ValaCCodeConstant* _tmp10;
	GeeList* _tmp11;
	char* _tmp12;
	char* marshaller;
	ValaCCodeIdentifier* marshal_arg;
	GeeList* params;
	gint params_len;
	ValaCCodeConstant* _tmp19;
	char* _tmp18;
	ValaCCodeFunctionCall* _tmp27;
	self = ((ValaGSignalModule*) (base));
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	csignew = (_tmp1 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp0 = vala_ccode_identifier_new ("g_signal_new"))))), (_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL))), _tmp1);
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (csignew, ((ValaCCodeExpression*) ((_tmp4 = vala_ccode_constant_new ((_tmp3 = g_strdup_printf ("\"%s\"", (_tmp2 = vala_signal_get_cname (sig)))))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	_tmp3 = (g_free (_tmp3), NULL);
	_tmp2 = (g_free (_tmp2), NULL);
	_tmp6 = NULL;
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (csignew, ((ValaCCodeExpression*) ((_tmp6 = vala_ccode_identifier_new ((_tmp5 = vala_typesymbol_get_type_id (type)))))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
	_tmp5 = (g_free (_tmp5), NULL);
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (csignew, ((ValaCCodeExpression*) ((_tmp7 = vala_ccode_constant_new ("G_SIGNAL_RUN_LAST")))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
	_tmp8 = NULL;
	vala_ccode_function_call_add_argument (csignew, ((ValaCCodeExpression*) ((_tmp8 = vala_ccode_constant_new ("0")))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (csignew, ((ValaCCodeExpression*) ((_tmp9 = vala_ccode_constant_new ("NULL")))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
	_tmp10 = NULL;
	vala_ccode_function_call_add_argument (csignew, ((ValaCCodeExpression*) ((_tmp10 = vala_ccode_constant_new ("NULL")))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
	_tmp11 = NULL;
	_tmp12 = NULL;
	marshaller = (_tmp12 = vala_ccode_module_get_marshaller_function (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), (_tmp11 = vala_signal_get_parameters (sig)), vala_signal_get_return_type (sig), NULL, FALSE), (_tmp11 == NULL ? NULL : (_tmp11 = (gee_collection_object_unref (_tmp11), NULL))), _tmp12);
	marshal_arg = vala_ccode_identifier_new (marshaller);
	vala_ccode_function_call_add_argument (csignew, ((ValaCCodeExpression*) (marshal_arg)));
	params = vala_signal_get_parameters (sig);
	if (VALA_IS_POINTER_TYPE (vala_signal_get_return_type (sig)) || vala_data_type_get_type_parameter (vala_signal_get_return_type (sig)) != NULL) {
		ValaCCodeConstant* _tmp13;
		_tmp13 = NULL;
		vala_ccode_function_call_add_argument (csignew, ((ValaCCodeExpression*) ((_tmp13 = vala_ccode_constant_new ("G_TYPE_POINTER")))));
		(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
	} else {
		if (VALA_IS_ERROR_TYPE (vala_signal_get_return_type (sig))) {
			ValaCCodeConstant* _tmp14;
			_tmp14 = NULL;
			vala_ccode_function_call_add_argument (csignew, ((ValaCCodeExpression*) ((_tmp14 = vala_ccode_constant_new ("G_TYPE_POINTER")))));
			(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
		} else {
			if (vala_data_type_get_data_type (vala_signal_get_return_type (sig)) == NULL) {
				ValaCCodeConstant* _tmp15;
				_tmp15 = NULL;
				vala_ccode_function_call_add_argument (csignew, ((ValaCCodeExpression*) ((_tmp15 = vala_ccode_constant_new ("G_TYPE_NONE")))));
				(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
			} else {
				ValaCCodeConstant* _tmp17;
				char* _tmp16;
				_tmp17 = NULL;
				_tmp16 = NULL;
				vala_ccode_function_call_add_argument (csignew, ((ValaCCodeExpression*) ((_tmp17 = vala_ccode_constant_new ((_tmp16 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_signal_get_return_type (sig)))))))));
				(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
				_tmp16 = (g_free (_tmp16), NULL);
			}
		}
	}
	params_len = 0;
	{
		GeeList* param_collection;
		int param_it;
		param_collection = params;
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				params_len++;
				if (vala_data_type_is_array (vala_formal_parameter_get_parameter_type (param))) {
					params_len++;
				}
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			}
		}
	}
	_tmp19 = NULL;
	_tmp18 = NULL;
	vala_ccode_function_call_add_argument (csignew, ((ValaCCodeExpression*) ((_tmp19 = vala_ccode_constant_new ((_tmp18 = g_strdup_printf ("%d", params_len)))))));
	(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
	_tmp18 = (g_free (_tmp18), NULL);
	{
		GeeList* param_collection;
		int param_it;
		param_collection = params;
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				if (vala_data_type_is_array (vala_formal_parameter_get_parameter_type (param))) {
					ValaCCodeConstant* _tmp22;
					if (vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))))) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->string_type)) {
						ValaCCodeConstant* _tmp20;
						_tmp20 = NULL;
						vala_ccode_function_call_add_argument (csignew, ((ValaCCodeExpression*) ((_tmp20 = vala_ccode_constant_new ("G_TYPE_STRV")))));
						(_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)));
					} else {
						ValaCCodeConstant* _tmp21;
						_tmp21 = NULL;
						vala_ccode_function_call_add_argument (csignew, ((ValaCCodeExpression*) ((_tmp21 = vala_ccode_constant_new ("G_TYPE_POINTER")))));
						(_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)));
					}
					_tmp22 = NULL;
					vala_ccode_function_call_add_argument (csignew, ((ValaCCodeExpression*) ((_tmp22 = vala_ccode_constant_new ("G_TYPE_INT")))));
					(_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)));
				} else {
					if (VALA_IS_POINTER_TYPE (vala_formal_parameter_get_parameter_type (param)) || vala_data_type_get_type_parameter (vala_formal_parameter_get_parameter_type (param)) != NULL || vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
						ValaCCodeConstant* _tmp23;
						_tmp23 = NULL;
						vala_ccode_function_call_add_argument (csignew, ((ValaCCodeExpression*) ((_tmp23 = vala_ccode_constant_new ("G_TYPE_POINTER")))));
						(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
					} else {
						if (VALA_IS_ERROR_TYPE (vala_formal_parameter_get_parameter_type (param))) {
							ValaCCodeConstant* _tmp24;
							_tmp24 = NULL;
							vala_ccode_function_call_add_argument (csignew, ((ValaCCodeExpression*) ((_tmp24 = vala_ccode_constant_new ("G_TYPE_POINTER")))));
							(_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)));
						} else {
							ValaCCodeConstant* _tmp26;
							char* _tmp25;
							_tmp26 = NULL;
							_tmp25 = NULL;
							vala_ccode_function_call_add_argument (csignew, ((ValaCCodeExpression*) ((_tmp26 = vala_ccode_constant_new ((_tmp25 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)))))))));
							(_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)));
							_tmp25 = (g_free (_tmp25), NULL);
						}
					}
				}
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			}
		}
	}
	vala_ccode_identifier_set_name (marshal_arg, marshaller);
	_tmp27 = NULL;
	return (_tmp27 = csignew, (marshaller = (g_free (marshaller), NULL)), (marshal_arg == NULL ? NULL : (marshal_arg = (vala_ccode_node_unref (marshal_arg), NULL))), (params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL))), _tmp27);
}


static void vala_gsignal_module_class_init (ValaGSignalModuleClass * klass) {
	vala_gsignal_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->get_marshaller_function = vala_gsignal_module_real_get_marshaller_function;
	VALA_CCODE_MODULE_CLASS (klass)->visit_signal = vala_gsignal_module_real_visit_signal;
	VALA_CCODE_MODULE_CLASS (klass)->generate_marshaller = vala_gsignal_module_real_generate_marshaller;
	VALA_CCODE_MODULE_CLASS (klass)->get_signal_creation = vala_gsignal_module_real_get_signal_creation;
}


static void vala_gsignal_module_instance_init (ValaGSignalModule * self) {
}


GType vala_gsignal_module_get_type (void) {
	static GType vala_gsignal_module_type_id = 0;
	if (vala_gsignal_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGSignalModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gsignal_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGSignalModule), 0, (GInstanceInitFunc) vala_gsignal_module_instance_init, NULL };
		vala_gsignal_module_type_id = g_type_register_static (VALA_TYPE_GOBJECT_MODULE, "ValaGSignalModule", &g_define_type_info, 0);
	}
	return vala_gsignal_module_type_id;
}




