/* valaccodedynamicpropertymodule.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valaccodedynamicpropertymodule.h>
#include <vala/valasymbol.h>
#include <ccode/valaccodefunction.h>
#include <vala/valaproperty.h>
#include <vala/valadatatype.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodeblock.h>
#include <vala/valatypesymbol.h>
#include <vala/valareport.h>
#include <vala/valacodenode.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodeinitializerlist.h>
#include <ccode/valaccodeassignment.h>
#include <gobject/valaccodebasemodule.h>




struct _ValaCCodeDynamicPropertyModulePrivate {
	gint dynamic_property_id;
};

#define VALA_CCODE_DYNAMIC_PROPERTY_MODULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_DYNAMIC_PROPERTY_MODULE, ValaCCodeDynamicPropertyModulePrivate))
enum  {
	VALA_CCODE_DYNAMIC_PROPERTY_MODULE_DUMMY_PROPERTY
};
static char* vala_ccode_dynamic_property_module_real_get_dynamic_property_getter_cname (ValaCCodeModule* base, ValaDynamicProperty* node);
static char* vala_ccode_dynamic_property_module_real_get_dynamic_property_setter_cname (ValaCCodeModule* base, ValaDynamicProperty* node);
static void vala_ccode_dynamic_property_module_generate_gobject_property_getter_wrapper (ValaCCodeDynamicPropertyModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block);
static void vala_ccode_dynamic_property_module_generate_gobject_property_setter_wrapper (ValaCCodeDynamicPropertyModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block);
static void vala_ccode_dynamic_property_module_create_dbus_property_proxy (ValaCCodeDynamicPropertyModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block);
static void vala_ccode_dynamic_property_module_generate_dbus_property_getter_wrapper (ValaCCodeDynamicPropertyModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block);
static void vala_ccode_dynamic_property_module_generate_dbus_property_setter_wrapper (ValaCCodeDynamicPropertyModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block);
static gpointer vala_ccode_dynamic_property_module_parent_class = NULL;
static void vala_ccode_dynamic_property_module_finalize (ValaCCodeModule* obj);



ValaCCodeDynamicPropertyModule* vala_ccode_dynamic_property_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeDynamicPropertyModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = ((ValaCCodeDynamicPropertyModule*) (g_type_create_instance (object_type)));
	self = ((ValaCCodeDynamicPropertyModule*) (vala_ccode_delegate_module_construct (object_type, codegen, next)));
	return self;
}


ValaCCodeDynamicPropertyModule* vala_ccode_dynamic_property_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_dynamic_property_module_construct (VALA_TYPE_CCODE_DYNAMIC_PROPERTY_MODULE, codegen, next);
}


static char* vala_ccode_dynamic_property_module_real_get_dynamic_property_getter_cname (ValaCCodeModule* base, ValaDynamicProperty* node) {
	ValaCCodeDynamicPropertyModule * self;
	char* getter_cname;
	ValaDynamicProperty* _tmp0;
	ValaDynamicProperty* dynamic_property;
	char* _tmp1;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* func;
	ValaCCodeFormalParameter* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp7;
	char* _tmp8;
	self = ((ValaCCodeDynamicPropertyModule*) (base));
	g_return_val_if_fail (node != NULL, NULL);
	getter_cname = g_strdup_printf ("_dynamic_get_%s%d", vala_symbol_get_name (((ValaSymbol*) (node))), self->priv->dynamic_property_id++);
	_tmp0 = NULL;
	dynamic_property = (_tmp0 = VALA_DYNAMIC_PROPERTY (node), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	_tmp1 = NULL;
	_tmp2 = NULL;
	func = (_tmp2 = vala_ccode_function_new (getter_cname, (_tmp1 = vala_data_type_get_cname (vala_property_get_property_type (((ValaProperty*) (node)))))), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2);
	vala_ccode_function_set_modifiers (func, vala_ccode_function_get_modifiers (func) | (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_INLINE));
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (func, (_tmp4 = vala_ccode_formal_parameter_new ("obj", (_tmp3 = vala_data_type_get_cname (vala_dynamic_property_get_dynamic_type (dynamic_property))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	_tmp3 = (g_free (_tmp3), NULL);
	block = vala_ccode_block_new ();
	if (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (dynamic_property)) == ((ValaCCodeBaseModule*) (self))->dbus_object_type) {
		vala_ccode_dynamic_property_module_generate_dbus_property_getter_wrapper (self, node, block);
	} else {
		if (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (dynamic_property)) != NULL && vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (dynamic_property)), ((ValaCCodeBaseModule*) (self))->gobject_type)) {
			vala_ccode_dynamic_property_module_generate_gobject_property_getter_wrapper (self, node, block);
		} else {
			char* _tmp6;
			char* _tmp5;
			_tmp6 = NULL;
			_tmp5 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (node))), (_tmp6 = g_strdup_printf ("dynamic properties are not supported for `%s'", (_tmp5 = vala_code_node_to_string (((ValaCodeNode*) (vala_dynamic_property_get_dynamic_type (dynamic_property))))))));
			_tmp6 = (g_free (_tmp6), NULL);
			_tmp5 = (g_free (_tmp5), NULL);
		}
	}
	/* append to C source file*/
	_tmp7 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_declaration, ((ValaCCodeNode*) ((_tmp7 = vala_ccode_function_copy (func)))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_definition, ((ValaCCodeNode*) (func)));
	_tmp8 = NULL;
	return (_tmp8 = getter_cname, (dynamic_property == NULL ? NULL : (dynamic_property = (vala_code_node_unref (dynamic_property), NULL))), (func == NULL ? NULL : (func = (vala_ccode_node_unref (func), NULL))), (block == NULL ? NULL : (block = (vala_ccode_node_unref (block), NULL))), _tmp8);
}


static char* vala_ccode_dynamic_property_module_real_get_dynamic_property_setter_cname (ValaCCodeModule* base, ValaDynamicProperty* node) {
	ValaCCodeDynamicPropertyModule * self;
	char* setter_cname;
	ValaDynamicProperty* _tmp0;
	ValaDynamicProperty* dynamic_property;
	ValaCCodeFunction* func;
	ValaCCodeFormalParameter* _tmp2;
	char* _tmp1;
	ValaCCodeFormalParameter* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp7;
	char* _tmp8;
	self = ((ValaCCodeDynamicPropertyModule*) (base));
	g_return_val_if_fail (node != NULL, NULL);
	setter_cname = g_strdup_printf ("_dynamic_set_%s%d", vala_symbol_get_name (((ValaSymbol*) (node))), self->priv->dynamic_property_id++);
	_tmp0 = NULL;
	dynamic_property = (_tmp0 = VALA_DYNAMIC_PROPERTY (node), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	func = vala_ccode_function_new (setter_cname, "void");
	vala_ccode_function_set_modifiers (func, vala_ccode_function_get_modifiers (func) | (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_INLINE));
	_tmp2 = NULL;
	_tmp1 = NULL;
	vala_ccode_function_add_parameter (func, (_tmp2 = vala_ccode_formal_parameter_new ("obj", (_tmp1 = vala_data_type_get_cname (vala_dynamic_property_get_dynamic_type (dynamic_property))))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
	_tmp1 = (g_free (_tmp1), NULL);
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (func, (_tmp4 = vala_ccode_formal_parameter_new ("value", (_tmp3 = vala_data_type_get_cname (vala_property_get_property_type (((ValaProperty*) (node))))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	_tmp3 = (g_free (_tmp3), NULL);
	block = vala_ccode_block_new ();
	if (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (dynamic_property)) == ((ValaCCodeBaseModule*) (self))->dbus_object_type) {
		vala_ccode_dynamic_property_module_generate_dbus_property_setter_wrapper (self, node, block);
	} else {
		if (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (dynamic_property)) != NULL && vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (dynamic_property)), ((ValaCCodeBaseModule*) (self))->gobject_type)) {
			vala_ccode_dynamic_property_module_generate_gobject_property_setter_wrapper (self, node, block);
		} else {
			char* _tmp6;
			char* _tmp5;
			_tmp6 = NULL;
			_tmp5 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (node))), (_tmp6 = g_strdup_printf ("dynamic properties are not supported for `%s'", (_tmp5 = vala_code_node_to_string (((ValaCodeNode*) (vala_dynamic_property_get_dynamic_type (dynamic_property))))))));
			_tmp6 = (g_free (_tmp6), NULL);
			_tmp5 = (g_free (_tmp5), NULL);
		}
	}
	/* append to C source file*/
	_tmp7 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_declaration, ((ValaCCodeNode*) ((_tmp7 = vala_ccode_function_copy (func)))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_definition, ((ValaCCodeNode*) (func)));
	_tmp8 = NULL;
	return (_tmp8 = setter_cname, (dynamic_property == NULL ? NULL : (dynamic_property = (vala_code_node_unref (dynamic_property), NULL))), (func == NULL ? NULL : (func = (vala_ccode_node_unref (func), NULL))), (block == NULL ? NULL : (block = (vala_ccode_node_unref (block), NULL))), _tmp8);
}


static void vala_ccode_dynamic_property_module_generate_gobject_property_getter_wrapper (ValaCCodeDynamicPropertyModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block) {
	char* _tmp0;
	ValaCCodeDeclaration* _tmp1;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp2;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeFunctionCall* _tmp4;
	ValaCCodeFunctionCall* call;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeConstant* _tmp6;
	ValaCCodeUnaryExpression* _tmp8;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeConstant* _tmp9;
	ValaCCodeExpressionStatement* _tmp10;
	ValaCCodeReturnStatement* _tmp12;
	ValaCCodeIdentifier* _tmp11;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (block != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	cdecl_ = (_tmp1 = vala_ccode_declaration_new ((_tmp0 = vala_data_type_get_cname (vala_property_get_property_type (((ValaProperty*) (node)))))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp2 = vala_ccode_variable_declarator_new ("result")))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
	vala_ccode_block_add_statement (block, ((ValaCCodeNode*) (cdecl_)));
	_tmp3 = NULL;
	_tmp4 = NULL;
	call = (_tmp4 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp3 = vala_ccode_identifier_new ("g_object_get"))))), (_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL))), _tmp4);
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (call, ((ValaCCodeExpression*) ((_tmp5 = vala_ccode_identifier_new ("obj")))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_function_call_add_argument (call, ((ValaCCodeExpression*) ((_tmp6 = vala_property_get_canonical_cconstant (((ValaProperty*) (node)))))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
	_tmp8 = NULL;
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (call, ((ValaCCodeExpression*) ((_tmp8 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp7 = vala_ccode_identifier_new ("result")))))))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
	(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (call, ((ValaCCodeExpression*) ((_tmp9 = vala_ccode_constant_new ("NULL")))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
	_tmp10 = NULL;
	vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp10 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (call)))))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
	_tmp12 = NULL;
	_tmp11 = NULL;
	vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp12 = vala_ccode_return_statement_new (((ValaCCodeExpression*) ((_tmp11 = vala_ccode_identifier_new ("result")))))))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
	(_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
	(call == NULL ? NULL : (call = (vala_ccode_node_unref (call), NULL)));
}


static void vala_ccode_dynamic_property_module_generate_gobject_property_setter_wrapper (ValaCCodeDynamicPropertyModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* call;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeConstant* _tmp3;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeConstant* _tmp5;
	ValaCCodeExpressionStatement* _tmp6;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (block != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	call = (_tmp1 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp0 = vala_ccode_identifier_new ("g_object_set"))))), (_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL))), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (call, ((ValaCCodeExpression*) ((_tmp2 = vala_ccode_identifier_new ("obj")))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (call, ((ValaCCodeExpression*) ((_tmp3 = vala_property_get_canonical_cconstant (((ValaProperty*) (node)))))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (call, ((ValaCCodeExpression*) ((_tmp4 = vala_ccode_identifier_new ("value")))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (call, ((ValaCCodeExpression*) ((_tmp5 = vala_ccode_constant_new ("NULL")))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp6 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (call)))))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
	(call == NULL ? NULL : (call = (vala_ccode_node_unref (call), NULL)));
}


static void vala_ccode_dynamic_property_module_create_dbus_property_proxy (ValaCCodeDynamicPropertyModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* prop_proxy_call;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeConstant* _tmp3;
	ValaCCodeConstant* _tmp4;
	ValaCCodeDeclaration* prop_proxy_decl;
	ValaCCodeVariableDeclarator* _tmp5;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (block != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	prop_proxy_call = (_tmp1 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp0 = vala_ccode_identifier_new ("dbus_g_proxy_new_from_proxy"))))), (_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL))), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (prop_proxy_call, ((ValaCCodeExpression*) ((_tmp2 = vala_ccode_identifier_new ("obj")))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (prop_proxy_call, ((ValaCCodeExpression*) ((_tmp3 = vala_ccode_constant_new ("DBUS_INTERFACE_PROPERTIES")))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (prop_proxy_call, ((ValaCCodeExpression*) ((_tmp4 = vala_ccode_constant_new ("NULL")))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	prop_proxy_decl = vala_ccode_declaration_new ("DBusGProxy*");
	_tmp5 = NULL;
	vala_ccode_declaration_add_declarator (prop_proxy_decl, ((ValaCCodeDeclarator*) ((_tmp5 = vala_ccode_variable_declarator_new_with_initializer ("property_proxy", ((ValaCCodeExpression*) (prop_proxy_call)))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	vala_ccode_block_add_statement (block, ((ValaCCodeNode*) (prop_proxy_decl)));
	(prop_proxy_call == NULL ? NULL : (prop_proxy_call = (vala_ccode_node_unref (prop_proxy_call), NULL)));
	(prop_proxy_decl == NULL ? NULL : (prop_proxy_decl = (vala_ccode_node_unref (prop_proxy_decl), NULL)));
}


static void vala_ccode_dynamic_property_module_generate_dbus_property_getter_wrapper (ValaCCodeDynamicPropertyModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block) {
	ValaCCodeInitializerList* cvalinit;
	ValaCCodeConstant* _tmp0;
	ValaCCodeDeclaration* cval_decl;
	ValaCCodeVariableDeclarator* _tmp1;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeUnaryExpression* _tmp3;
	ValaCCodeUnaryExpression* val_ptr;
	char* _tmp4;
	ValaCCodeDeclaration* _tmp5;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp6;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeFunctionCall* _tmp8;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeConstant* _tmp10;
	ValaCCodeConstant* _tmp11;
	ValaCCodeIdentifier* _tmp12;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeFunctionCall* _tmp14;
	ValaCCodeFunctionCall* get_iface;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeConstant* _tmp19;
	char* _tmp18;
	char* _tmp17;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeIdentifier* _tmp21;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeExpressionStatement* _tmp23;
	ValaCCodeIdentifier* _tmp24;
	ValaCCodeFunctionCall* _tmp25;
	ValaCCodeFunctionCall* prop_proxy_unref;
	ValaCCodeIdentifier* _tmp26;
	ValaCCodeExpressionStatement* _tmp27;
	ValaCCodeIdentifier* _tmp29;
	char* _tmp28;
	ValaCCodeFunctionCall* _tmp30;
	ValaCCodeFunctionCall* cget_call;
	ValaCCodeIdentifier* _tmp31;
	ValaCCodeAssignment* _tmp32;
	ValaCCodeAssignment* assign;
	ValaCCodeExpressionStatement* _tmp33;
	ValaCCodeReturnStatement* _tmp35;
	ValaCCodeIdentifier* _tmp34;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (block != NULL);
	vala_ccode_dynamic_property_module_create_dbus_property_proxy (self, node, block);
	/* initialize GValue*/
	cvalinit = vala_ccode_initializer_list_new ();
	_tmp0 = NULL;
	vala_ccode_initializer_list_append (cvalinit, ((ValaCCodeExpression*) ((_tmp0 = vala_ccode_constant_new ("0")))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
	cval_decl = vala_ccode_declaration_new ("GValue");
	_tmp1 = NULL;
	vala_ccode_declaration_add_declarator (cval_decl, ((ValaCCodeDeclarator*) ((_tmp1 = vala_ccode_variable_declarator_new_with_initializer ("gvalue", ((ValaCCodeExpression*) (cvalinit)))))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)));
	vala_ccode_block_add_statement (block, ((ValaCCodeNode*) (cval_decl)));
	_tmp2 = NULL;
	_tmp3 = NULL;
	val_ptr = (_tmp3 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp2 = vala_ccode_identifier_new ("gvalue"))))), (_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL))), _tmp3);
	/* call Get method on property proxy*/
	_tmp4 = NULL;
	_tmp5 = NULL;
	cdecl_ = (_tmp5 = vala_ccode_declaration_new ((_tmp4 = vala_data_type_get_cname (vala_property_get_property_type (((ValaProperty*) (node)))))), (_tmp4 = (g_free (_tmp4), NULL)), _tmp5);
	_tmp6 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp6 = vala_ccode_variable_declarator_new ("result")))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
	vala_ccode_block_add_statement (block, ((ValaCCodeNode*) (cdecl_)));
	_tmp7 = NULL;
	_tmp8 = NULL;
	ccall = (_tmp8 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp7 = vala_ccode_identifier_new ("dbus_g_proxy_call"))))), (_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL))), _tmp8);
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp9 = vala_ccode_identifier_new ("property_proxy")))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
	_tmp10 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp10 = vala_ccode_constant_new ("\"Get\"")))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
	_tmp11 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp11 = vala_ccode_constant_new ("NULL")))));
	(_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)));
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp12 = vala_ccode_identifier_new ("G_TYPE_STRING")))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
	_tmp13 = NULL;
	_tmp14 = NULL;
	get_iface = (_tmp14 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp13 = vala_ccode_identifier_new ("dbus_g_proxy_get_interface"))))), (_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL))), _tmp14);
	_tmp15 = NULL;
	vala_ccode_function_call_add_argument (get_iface, ((ValaCCodeExpression*) ((_tmp15 = vala_ccode_identifier_new ("obj")))));
	(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) (get_iface)));
	_tmp16 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp16 = vala_ccode_identifier_new ("G_TYPE_STRING")))));
	(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
	_tmp19 = NULL;
	_tmp18 = NULL;
	_tmp17 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp19 = vala_ccode_constant_new ((_tmp18 = g_strdup_printf ("\"%s\"", (_tmp17 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name (((ValaSymbol*) (node))))))))))));
	(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
	_tmp18 = (g_free (_tmp18), NULL);
	_tmp17 = (g_free (_tmp17), NULL);
	_tmp20 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp20 = vala_ccode_identifier_new ("G_TYPE_INVALID")))));
	(_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)));
	_tmp21 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp21 = vala_ccode_identifier_new ("G_TYPE_VALUE")))));
	(_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)));
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) (val_ptr)));
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp22 = vala_ccode_identifier_new ("G_TYPE_INVALID")))));
	(_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)));
	_tmp23 = NULL;
	vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp23 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (ccall)))))));
	(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
	/* unref property proxy*/
	_tmp24 = NULL;
	_tmp25 = NULL;
	prop_proxy_unref = (_tmp25 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp24 = vala_ccode_identifier_new ("g_object_unref"))))), (_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL))), _tmp25);
	_tmp26 = NULL;
	vala_ccode_function_call_add_argument (prop_proxy_unref, ((ValaCCodeExpression*) ((_tmp26 = vala_ccode_identifier_new ("property_proxy")))));
	(_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)));
	_tmp27 = NULL;
	vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp27 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (prop_proxy_unref)))))));
	(_tmp27 == NULL ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)));
	/* assign value to result variable*/
	_tmp29 = NULL;
	_tmp28 = NULL;
	_tmp30 = NULL;
	cget_call = (_tmp30 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp29 = vala_ccode_identifier_new ((_tmp28 = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_property_get_property_type (((ValaProperty*) (node))))))))))), (_tmp29 == NULL ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL))), (_tmp28 = (g_free (_tmp28), NULL)), _tmp30);
	vala_ccode_function_call_add_argument (cget_call, ((ValaCCodeExpression*) (val_ptr)));
	_tmp31 = NULL;
	_tmp32 = NULL;
	assign = (_tmp32 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp31 = vala_ccode_identifier_new ("result")))), ((ValaCCodeExpression*) (cget_call)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp31 == NULL ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL))), _tmp32);
	_tmp33 = NULL;
	vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp33 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (assign)))))));
	(_tmp33 == NULL ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)));
	/* return result*/
	_tmp35 = NULL;
	_tmp34 = NULL;
	vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp35 = vala_ccode_return_statement_new (((ValaCCodeExpression*) ((_tmp34 = vala_ccode_identifier_new ("result")))))))));
	(_tmp35 == NULL ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL)));
	(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
	(cvalinit == NULL ? NULL : (cvalinit = (vala_ccode_node_unref (cvalinit), NULL)));
	(cval_decl == NULL ? NULL : (cval_decl = (vala_ccode_node_unref (cval_decl), NULL)));
	(val_ptr == NULL ? NULL : (val_ptr = (vala_ccode_node_unref (val_ptr), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
	(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
	(get_iface == NULL ? NULL : (get_iface = (vala_ccode_node_unref (get_iface), NULL)));
	(prop_proxy_unref == NULL ? NULL : (prop_proxy_unref = (vala_ccode_node_unref (prop_proxy_unref), NULL)));
	(cget_call == NULL ? NULL : (cget_call = (vala_ccode_node_unref (cget_call), NULL)));
	(assign == NULL ? NULL : (assign = (vala_ccode_node_unref (assign), NULL)));
}


static void vala_ccode_dynamic_property_module_generate_dbus_property_setter_wrapper (ValaCCodeDynamicPropertyModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block) {
	ValaCCodeInitializerList* cvalinit;
	ValaCCodeConstant* _tmp0;
	ValaCCodeDeclaration* cval_decl;
	ValaCCodeVariableDeclarator* _tmp1;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeUnaryExpression* _tmp3;
	ValaCCodeUnaryExpression* val_ptr;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeFunctionCall* _tmp5;
	ValaCCodeFunctionCall* cinit_call;
	ValaCCodeIdentifier* _tmp7;
	char* _tmp6;
	ValaCCodeExpressionStatement* _tmp8;
	ValaCCodeIdentifier* _tmp10;
	char* _tmp9;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeFunctionCall* cset_call;
	ValaCCodeIdentifier* _tmp12;
	ValaCCodeExpressionStatement* _tmp13;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeFunctionCall* _tmp15;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeConstant* _tmp17;
	ValaCCodeConstant* _tmp18;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeFunctionCall* _tmp21;
	ValaCCodeFunctionCall* get_iface;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeIdentifier* _tmp23;
	ValaCCodeConstant* _tmp26;
	char* _tmp25;
	char* _tmp24;
	ValaCCodeIdentifier* _tmp27;
	ValaCCodeIdentifier* _tmp28;
	ValaCCodeIdentifier* _tmp29;
	ValaCCodeExpressionStatement* _tmp30;
	ValaCCodeIdentifier* _tmp31;
	ValaCCodeFunctionCall* _tmp32;
	ValaCCodeFunctionCall* prop_proxy_unref;
	ValaCCodeIdentifier* _tmp33;
	ValaCCodeExpressionStatement* _tmp34;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (block != NULL);
	vala_ccode_dynamic_property_module_create_dbus_property_proxy (self, node, block);
	/* initialize GValue*/
	cvalinit = vala_ccode_initializer_list_new ();
	_tmp0 = NULL;
	vala_ccode_initializer_list_append (cvalinit, ((ValaCCodeExpression*) ((_tmp0 = vala_ccode_constant_new ("0")))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
	cval_decl = vala_ccode_declaration_new ("GValue");
	_tmp1 = NULL;
	vala_ccode_declaration_add_declarator (cval_decl, ((ValaCCodeDeclarator*) ((_tmp1 = vala_ccode_variable_declarator_new_with_initializer ("gvalue", ((ValaCCodeExpression*) (cvalinit)))))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)));
	vala_ccode_block_add_statement (block, ((ValaCCodeNode*) (cval_decl)));
	_tmp2 = NULL;
	_tmp3 = NULL;
	val_ptr = (_tmp3 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp2 = vala_ccode_identifier_new ("gvalue"))))), (_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL))), _tmp3);
	_tmp4 = NULL;
	_tmp5 = NULL;
	cinit_call = (_tmp5 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp4 = vala_ccode_identifier_new ("g_value_init"))))), (_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL))), _tmp5);
	vala_ccode_function_call_add_argument (cinit_call, ((ValaCCodeExpression*) (val_ptr)));
	_tmp7 = NULL;
	_tmp6 = NULL;
	vala_ccode_function_call_add_argument (cinit_call, ((ValaCCodeExpression*) ((_tmp7 = vala_ccode_identifier_new ((_tmp6 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_property_get_property_type (((ValaProperty*) (node)))))))))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
	_tmp6 = (g_free (_tmp6), NULL);
	_tmp8 = NULL;
	vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp8 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (cinit_call)))))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp11 = NULL;
	cset_call = (_tmp11 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp10 = vala_ccode_identifier_new ((_tmp9 = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (vala_property_get_property_type (((ValaProperty*) (node))))))))))), (_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL))), (_tmp9 = (g_free (_tmp9), NULL)), _tmp11);
	vala_ccode_function_call_add_argument (cset_call, ((ValaCCodeExpression*) (val_ptr)));
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (cset_call, ((ValaCCodeExpression*) ((_tmp12 = vala_ccode_identifier_new ("value")))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
	_tmp13 = NULL;
	vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp13 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (cset_call)))))));
	(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
	/* call Set method on property proxy*/
	_tmp14 = NULL;
	_tmp15 = NULL;
	ccall = (_tmp15 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp14 = vala_ccode_identifier_new ("dbus_g_proxy_call"))))), (_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL))), _tmp15);
	_tmp16 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp16 = vala_ccode_identifier_new ("property_proxy")))));
	(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
	_tmp17 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp17 = vala_ccode_constant_new ("\"Set\"")))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
	_tmp18 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp18 = vala_ccode_constant_new ("NULL")))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
	_tmp19 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp19 = vala_ccode_identifier_new ("G_TYPE_STRING")))));
	(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
	_tmp20 = NULL;
	_tmp21 = NULL;
	get_iface = (_tmp21 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp20 = vala_ccode_identifier_new ("dbus_g_proxy_get_interface"))))), (_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL))), _tmp21);
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (get_iface, ((ValaCCodeExpression*) ((_tmp22 = vala_ccode_identifier_new ("obj")))));
	(_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)));
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) (get_iface)));
	_tmp23 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp23 = vala_ccode_identifier_new ("G_TYPE_STRING")))));
	(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
	_tmp26 = NULL;
	_tmp25 = NULL;
	_tmp24 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp26 = vala_ccode_constant_new ((_tmp25 = g_strdup_printf ("\"%s\"", (_tmp24 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name (((ValaSymbol*) (node))))))))))));
	(_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)));
	_tmp25 = (g_free (_tmp25), NULL);
	_tmp24 = (g_free (_tmp24), NULL);
	_tmp27 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp27 = vala_ccode_identifier_new ("G_TYPE_VALUE")))));
	(_tmp27 == NULL ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)));
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) (val_ptr)));
	_tmp28 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp28 = vala_ccode_identifier_new ("G_TYPE_INVALID")))));
	(_tmp28 == NULL ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)));
	_tmp29 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp29 = vala_ccode_identifier_new ("G_TYPE_INVALID")))));
	(_tmp29 == NULL ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)));
	_tmp30 = NULL;
	vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp30 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (ccall)))))));
	(_tmp30 == NULL ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)));
	/* unref property proxy*/
	_tmp31 = NULL;
	_tmp32 = NULL;
	prop_proxy_unref = (_tmp32 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp31 = vala_ccode_identifier_new ("g_object_unref"))))), (_tmp31 == NULL ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL))), _tmp32);
	_tmp33 = NULL;
	vala_ccode_function_call_add_argument (prop_proxy_unref, ((ValaCCodeExpression*) ((_tmp33 = vala_ccode_identifier_new ("property_proxy")))));
	(_tmp33 == NULL ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)));
	_tmp34 = NULL;
	vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp34 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (prop_proxy_unref)))))));
	(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
	(cvalinit == NULL ? NULL : (cvalinit = (vala_ccode_node_unref (cvalinit), NULL)));
	(cval_decl == NULL ? NULL : (cval_decl = (vala_ccode_node_unref (cval_decl), NULL)));
	(val_ptr == NULL ? NULL : (val_ptr = (vala_ccode_node_unref (val_ptr), NULL)));
	(cinit_call == NULL ? NULL : (cinit_call = (vala_ccode_node_unref (cinit_call), NULL)));
	(cset_call == NULL ? NULL : (cset_call = (vala_ccode_node_unref (cset_call), NULL)));
	(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
	(get_iface == NULL ? NULL : (get_iface = (vala_ccode_node_unref (get_iface), NULL)));
	(prop_proxy_unref == NULL ? NULL : (prop_proxy_unref = (vala_ccode_node_unref (prop_proxy_unref), NULL)));
}


static void vala_ccode_dynamic_property_module_class_init (ValaCCodeDynamicPropertyModuleClass * klass) {
	vala_ccode_dynamic_property_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->finalize = vala_ccode_dynamic_property_module_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeDynamicPropertyModulePrivate));
	VALA_CCODE_MODULE_CLASS (klass)->get_dynamic_property_getter_cname = vala_ccode_dynamic_property_module_real_get_dynamic_property_getter_cname;
	VALA_CCODE_MODULE_CLASS (klass)->get_dynamic_property_setter_cname = vala_ccode_dynamic_property_module_real_get_dynamic_property_setter_cname;
}


static void vala_ccode_dynamic_property_module_instance_init (ValaCCodeDynamicPropertyModule * self) {
	self->priv = VALA_CCODE_DYNAMIC_PROPERTY_MODULE_GET_PRIVATE (self);
}


static void vala_ccode_dynamic_property_module_finalize (ValaCCodeModule* obj) {
	ValaCCodeDynamicPropertyModule * self;
	self = VALA_CCODE_DYNAMIC_PROPERTY_MODULE (obj);
	VALA_CCODE_MODULE_CLASS (vala_ccode_dynamic_property_module_parent_class)->finalize (obj);
}


GType vala_ccode_dynamic_property_module_get_type (void) {
	static GType vala_ccode_dynamic_property_module_type_id = 0;
	if (vala_ccode_dynamic_property_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeDynamicPropertyModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_dynamic_property_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeDynamicPropertyModule), 0, (GInstanceInitFunc) vala_ccode_dynamic_property_module_instance_init, NULL };
		vala_ccode_dynamic_property_module_type_id = g_type_register_static (VALA_TYPE_CCODE_DELEGATE_MODULE, "ValaCCodeDynamicPropertyModule", &g_define_type_info, 0);
	}
	return vala_ccode_dynamic_property_module_type_id;
}




