/* valasourcelocation.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALASOURCELOCATION_H__
#define __VALA_VALASOURCELOCATION_H__

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

typedef struct _ValaSourceLocation ValaSourceLocation;

#define VALA_TYPE_SOURCE_LOCATION (vala_source_location_get_type ())

/**
 * Represents a position in a source file.
 */
struct _ValaSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};


void vala_source_location_init (ValaSourceLocation *self, gchar* _pos, gint _line, gint _column);
ValaSourceLocation* vala_source_location_dup (const ValaSourceLocation* self);
void vala_source_location_free (ValaSourceLocation* self);
GType vala_source_location_get_type (void);


G_END_DECLS

#endif
