/* valamethod.c generated by valac, the Vala compiler
 * generated from valamethod.vala, do not modify */

/* valamethod.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaMethodPrivate {
	ValaList* type_parameters;
	ValaMemberBinding _binding;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	gboolean _is_inline;
	gboolean _entry_point;
	ValaParameter* _this_parameter;
	ValaSignal* _signal_reference;
	gboolean _closure;
	gboolean _coroutine;
	gboolean _is_async_callback;
	ValaList* parameters;
	ValaList* preconditions;
	ValaList* postconditions;
	ValaDataType* _return_type;
	ValaMethod* _base_method;
	ValaMethod* _base_interface_method;
	ValaDataType* _base_interface_type;
	gboolean base_methods_valid;
	ValaMethod* callback_method;
	ValaMethod* end_method;
	ValaList* captured_variables;
};

static gint ValaMethod_private_offset;
static gpointer vala_method_parent_class = NULL;
static ValaList* vala_method__empty_expression_list;
static ValaList* vala_method__empty_expression_list = NULL;
static ValaList* vala_method__empty_type_parameter_list;
static ValaList* vala_method__empty_type_parameter_list = NULL;
static ValaCallableIface * vala_method_vala_callable_parent_iface = NULL;

static void vala_method_find_base_methods (ValaMethod* self);
static void vala_method_set_entry_point (ValaMethod* self,
                                  gboolean value);
static void vala_method_real_add_parameter (ValaCallable* base,
                                     ValaParameter* param);
static ValaList* vala_method_real_get_parameters (ValaCallable* base);
static void vala_method_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_method_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static gboolean vala_method_compatible_internal (ValaMethod* self,
                                          ValaMethod* base_method,
                                          gchar* * invalid_match,
                                          ValaCodeNode* node_reference);
static void vala_method_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference);
static void vala_method_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static void vala_method_find_base_interface_method (ValaMethod* self,
                                             ValaClass* cl);
static void vala_method_find_base_class_method (ValaMethod* self,
                                         ValaClass* cl);
static gboolean vala_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static gboolean vala_method_is_possible_entry_point (ValaMethod* self,
                                              ValaCodeContext* context);
static void vala_method_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection);
static void vala_method_finalize (ValaCodeNode * obj);
static GType vala_method_get_type_once (void);

static inline gpointer
vala_method_get_instance_private (ValaMethod* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethod_private_offset);
}

static ValaDataType*
vala_method_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_method_real_set_return_type (ValaCallable* base,
                                  ValaDataType* value)
{
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean
vala_method_real_get_has_result (ValaSubroutine* base)
{
	gboolean result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	result = !VALA_IS_VOID_TYPE (_tmp1_);
	return result;
}

ValaMemberBinding
vala_method_get_binding (ValaMethod* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}

void
vala_method_set_binding (ValaMethod* self,
                         ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

gboolean
vala_method_get_is_abstract (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_method_set_is_abstract (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_method_get_is_virtual (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_virtual;
	return result;
}

void
vala_method_set_is_virtual (ValaMethod* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}

gboolean
vala_method_get_overrides (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overrides;
	return result;
}

void
vala_method_set_overrides (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_overrides = value;
}

gboolean
vala_method_get_is_inline (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_inline;
	return result;
}

void
vala_method_set_is_inline (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_inline = value;
}

gboolean
vala_method_get_returns_floating_reference (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", FALSE);
	return result;
}

void
vala_method_set_returns_floating_reference (ValaMethod* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", value, NULL);
}

gboolean
vala_method_get_returns_modified_pointer (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_returns_modified_pointer (ValaMethod* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer", value, NULL);
}

ValaMethod*
vala_method_get_base_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_method;
	result = _tmp0_;
	return result;
}

ValaMethod*
vala_method_get_base_interface_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_interface_method;
	result = _tmp0_;
	return result;
}

ValaDataType*
vala_method_get_base_interface_type (ValaMethod* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_interface_type;
	result = _tmp0_;
	return result;
}

void
vala_method_set_base_interface_type (ValaMethod* self,
                                     ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	self->priv->_base_interface_type = _tmp0_;
	_tmp1_ = self->priv->_base_interface_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_method_get_entry_point (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_entry_point;
	return result;
}

static void
vala_method_set_entry_point (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_entry_point = value;
}

ValaParameter*
vala_method_get_this_parameter (ValaMethod* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_this_parameter;
	result = _tmp0_;
	return result;
}

void
vala_method_set_this_parameter (ValaMethod* self,
                                ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	self->priv->_this_parameter = _tmp0_;
}

gboolean
vala_method_get_printf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "PrintfFormat");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_printf_format (ValaMethod* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "PrintfFormat", value, NULL);
}

gboolean
vala_method_get_scanf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ScanfFormat");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_scanf_format (ValaMethod* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ScanfFormat", value, NULL);
}

gboolean
vala_method_get_has_construct_function (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", TRUE);
	return result;
}

void
vala_method_set_has_construct_function (ValaMethod* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", value, NULL);
}

ValaSignal*
vala_method_get_signal_reference (ValaMethod* self)
{
	ValaSignal* result;
	ValaSignal* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_signal_reference;
	result = _tmp0_;
	return result;
}

void
vala_method_set_signal_reference (ValaMethod* self,
                                  ValaSignal* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_signal_reference = value;
}

gboolean
vala_method_get_closure (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_closure;
	return result;
}

void
vala_method_set_closure (ValaMethod* self,
                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_closure = value;
}

gboolean
vala_method_get_coroutine (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_coroutine;
	return result;
}

void
vala_method_set_coroutine (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_coroutine = value;
}

gboolean
vala_method_get_is_async_callback (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_async_callback;
	return result;
}

void
vala_method_set_is_async_callback (ValaMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_async_callback = value;
}

/**
 * Creates a new method.
 *
 * @param name              method name
 * @param return_type       method return type
 * @param source_reference  reference to source code
 * @return                  newly created method
 */
ValaMethod*
vala_method_construct (GType object_type,
                       const gchar* name,
                       ValaDataType* return_type,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaMethod* self = NULL;
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaMethod*) vala_subroutine_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}

ValaMethod*
vala_method_new (const gchar* name,
                 ValaDataType* return_type,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_method_construct (VALA_TYPE_METHOD, name, return_type, source_reference, comment);
}

/**
 * Appends parameter to this method.
 *
 * @param param a formal parameter
 */
static void
vala_method_real_add_parameter (ValaCallable* base,
                                ValaParameter* param)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}

static ValaList*
vala_method_real_get_parameters (ValaCallable* base)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaList* result = NULL;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->parameters;
	result = _tmp0_;
	return result;
}

/**
 * Remove all parameters from this method.
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

void
vala_method_clear_parameters (ValaMethod* self)
{
	ValaList* _tmp15_;
	g_return_if_fail (self != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaParameter* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp7_ = param;
			_tmp8_ = vala_parameter_get_ellipsis (_tmp7_);
			_tmp9_ = _tmp8_;
			if (!_tmp9_) {
				ValaScope* _tmp10_;
				ValaScope* _tmp11_;
				ValaParameter* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
				_tmp11_ = _tmp10_;
				_tmp12_ = param;
				_tmp13_ = vala_symbol_get_name ((ValaSymbol*) _tmp12_);
				_tmp14_ = _tmp13_;
				vala_scope_remove (_tmp11_, _tmp14_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp15_ = self->priv->parameters;
	vala_collection_clear ((ValaCollection*) _tmp15_);
}

gboolean
vala_method_is_variadic (ValaMethod* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaParameter* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp7_ = param;
			_tmp8_ = vala_parameter_get_ellipsis (_tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = FALSE;
	return result;
}

static void
vala_method_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method (visitor, self);
}

static void
vala_method_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaList* _tmp24_;
	ValaLocalVariable* _tmp33_;
	ValaLocalVariable* _tmp34_;
	ValaList* _tmp37_;
	ValaList* _tmp46_;
	ValaBlock* _tmp55_;
	ValaBlock* _tmp56_;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _p_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp0_ = vala_method_get_type_parameters (self);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaTypeParameter* _tmp7_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp5_ = _p_list;
			_tmp6_ = vala_list_get (_tmp5_, _p_index);
			p = (ValaTypeParameter*) _tmp6_;
			_tmp7_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp8_ = vala_method_get_base_interface_type (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp10_ = vala_method_get_base_interface_type (self);
		_tmp11_ = _tmp10_;
		vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
	}
	_tmp12_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaDataType* _tmp14_;
		ValaDataType* _tmp15_;
		_tmp14_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp15_ = _tmp14_;
		vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp16_;
		ValaList* _tmp17_;
		gint _param_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _param_index = 0;
		_tmp16_ = self->priv->parameters;
		_tmp17_ = _vala_iterable_ref0 (_tmp16_);
		_param_list = _tmp17_;
		_tmp18_ = _param_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_param_size = _tmp20_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp21_;
			gpointer _tmp22_;
			ValaParameter* _tmp23_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp21_ = _param_list;
			_tmp22_ = vala_list_get (_tmp21_, _param_index);
			param = (ValaParameter*) _tmp22_;
			_tmp23_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp23_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp24_ = self->error_types;
	if (_tmp24_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp25_;
			ValaList* _tmp26_;
			gint _error_type_size = 0;
			ValaList* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _error_type_index = 0;
			_tmp25_ = self->error_types;
			_tmp26_ = _vala_iterable_ref0 (_tmp25_);
			_error_type_list = _tmp26_;
			_tmp27_ = _error_type_list;
			_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
			_tmp29_ = _tmp28_;
			_error_type_size = _tmp29_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp30_;
				gpointer _tmp31_;
				ValaDataType* _tmp32_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp30_ = _error_type_list;
				_tmp31_ = vala_list_get (_tmp30_, _error_type_index);
				error_type = (ValaDataType*) _tmp31_;
				_tmp32_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp32_, visitor);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	_tmp33_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp34_ = _tmp33_;
	if (_tmp34_ != NULL) {
		ValaLocalVariable* _tmp35_;
		ValaLocalVariable* _tmp36_;
		_tmp35_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp36_ = _tmp35_;
		vala_code_node_accept ((ValaCodeNode*) _tmp36_, visitor);
	}
	_tmp37_ = self->priv->preconditions;
	if (_tmp37_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp38_;
			ValaList* _tmp39_;
			gint _precondition_size = 0;
			ValaList* _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			gint _precondition_index = 0;
			_tmp38_ = self->priv->preconditions;
			_tmp39_ = _vala_iterable_ref0 (_tmp38_);
			_precondition_list = _tmp39_;
			_tmp40_ = _precondition_list;
			_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
			_tmp42_ = _tmp41_;
			_precondition_size = _tmp42_;
			_precondition_index = -1;
			while (TRUE) {
				ValaExpression* precondition = NULL;
				ValaList* _tmp43_;
				gpointer _tmp44_;
				ValaExpression* _tmp45_;
				_precondition_index = _precondition_index + 1;
				if (!(_precondition_index < _precondition_size)) {
					break;
				}
				_tmp43_ = _precondition_list;
				_tmp44_ = vala_list_get (_tmp43_, _precondition_index);
				precondition = (ValaExpression*) _tmp44_;
				_tmp45_ = precondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp45_, visitor);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp46_ = self->priv->postconditions;
	if (_tmp46_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp47_;
			ValaList* _tmp48_;
			gint _postcondition_size = 0;
			ValaList* _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			gint _postcondition_index = 0;
			_tmp47_ = self->priv->postconditions;
			_tmp48_ = _vala_iterable_ref0 (_tmp47_);
			_postcondition_list = _tmp48_;
			_tmp49_ = _postcondition_list;
			_tmp50_ = vala_collection_get_size ((ValaCollection*) _tmp49_);
			_tmp51_ = _tmp50_;
			_postcondition_size = _tmp51_;
			_postcondition_index = -1;
			while (TRUE) {
				ValaExpression* postcondition = NULL;
				ValaList* _tmp52_;
				gpointer _tmp53_;
				ValaExpression* _tmp54_;
				_postcondition_index = _postcondition_index + 1;
				if (!(_postcondition_index < _postcondition_size)) {
					break;
				}
				_tmp52_ = _postcondition_list;
				_tmp53_ = vala_list_get (_tmp52_, _postcondition_index);
				postcondition = (ValaExpression*) _tmp53_;
				_tmp54_ = postcondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp54_, visitor);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp55_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp56_ = _tmp55_;
	if (_tmp56_ != NULL) {
		ValaBlock* _tmp57_;
		ValaBlock* _tmp58_;
		_tmp57_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp58_ = _tmp57_;
		vala_code_node_accept ((ValaCodeNode*) _tmp58_, visitor);
	}
}

/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @param invalid_match error string about which check failed
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible (ValaMethod* self,
                        ValaMethod* base_method,
                        gchar* * invalid_match)
{
	gchar* _vala_invalid_match = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	_tmp1_ = vala_method_compatible_internal (self, base_method, &_tmp0_, (ValaCodeNode*) self);
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = _tmp0_;
	result = _tmp1_;
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible_no_error (ValaMethod* self,
                                 ValaMethod* base_method)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	result = vala_method_compatible_internal (self, base_method, NULL, NULL);
	return result;
}

static gboolean
vala_method_compatible_internal (ValaMethod* self,
                                 ValaMethod* base_method,
                                 gchar* * invalid_match,
                                 ValaCodeNode* node_reference)
{
	gchar* _vala_invalid_match = NULL;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaObjectType* object_type = NULL;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaList* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	ValaList* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	ValaList* method_type_args = NULL;
	ValaDataType* actual_base_type = NULL;
	ValaDataType* _tmp51_;
	ValaDataType* _tmp52_;
	ValaObjectType* _tmp53_;
	ValaList* _tmp54_;
	ValaDataType* _tmp55_;
	ValaDataType* _tmp56_;
	ValaDataType* _tmp57_;
	ValaDataType* _tmp58_;
	ValaIterator* method_params_it = NULL;
	ValaList* _tmp67_;
	ValaIterator* _tmp68_;
	gint param_index = 0;
	ValaIterator* _tmp116_;
	ValaArrayList* base_method_errors = NULL;
	GEqualFunc _tmp118_;
	ValaArrayList* _tmp119_;
	ValaArrayList* _tmp120_;
	ValaList* _tmp121_;
	gboolean _tmp142_;
	gboolean _tmp143_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	if (self == base_method) {
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = NULL;
		result = TRUE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp0_ = self->priv->_binding;
	_tmp1_ = base_method->priv->_binding;
	if (_tmp0_ != _tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("incompatible binding");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp2_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	object_type = NULL;
	_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaObjectType* _tmp7_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
		_vala_code_node_unref0 (object_type);
		object_type = _tmp7_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaObjectType* _tmp8_;
			ValaObjectTypeSymbol* _tmp9_;
			ValaObjectTypeSymbol* _tmp10_;
			ValaList* _tmp11_;
			ValaList* _tmp12_;
			gint _type_parameter_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _type_parameter_index = 0;
			_tmp8_ = object_type;
			_tmp9_ = vala_object_type_get_object_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_object_type_symbol_get_type_parameters (_tmp10_);
			_tmp12_ = _vala_iterable_ref0 (_tmp11_);
			_type_parameter_list = _tmp12_;
			_tmp13_ = _type_parameter_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_type_parameter_size = _tmp15_;
			_type_parameter_index = -1;
			while (TRUE) {
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp16_;
				gpointer _tmp17_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp18_;
				ValaGenericType* _tmp19_;
				ValaGenericType* _tmp20_;
				ValaObjectType* _tmp21_;
				ValaGenericType* _tmp22_;
				_type_parameter_index = _type_parameter_index + 1;
				if (!(_type_parameter_index < _type_parameter_size)) {
					break;
				}
				_tmp16_ = _type_parameter_list;
				_tmp17_ = vala_list_get (_tmp16_, _type_parameter_index);
				type_parameter = (ValaTypeParameter*) _tmp17_;
				_tmp18_ = type_parameter;
				_tmp19_ = vala_generic_type_new (_tmp18_);
				type_arg = _tmp19_;
				_tmp20_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp20_, TRUE);
				_tmp21_ = object_type;
				_tmp22_ = type_arg;
				vala_data_type_add_type_argument ((ValaDataType*) _tmp21_, (ValaDataType*) _tmp22_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp23_ = vala_method_get_type_parameters (self);
	_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_method_get_type_parameters (base_method);
	_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp25_ < _tmp28_) {
		gchar* _tmp29_;
		_tmp29_ = g_strdup ("too few type parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp29_;
		result = FALSE;
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	} else {
		ValaList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		ValaList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		_tmp30_ = vala_method_get_type_parameters (self);
		_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_method_get_type_parameters (base_method);
		_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		if (_tmp32_ > _tmp35_) {
			gchar* _tmp36_;
			_tmp36_ = g_strdup ("too many type parameters");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp36_;
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
	}
	method_type_args = NULL;
	if (vala_method_has_type_parameters (self)) {
		GEqualFunc _tmp37_;
		ValaArrayList* _tmp38_;
		_tmp37_ = g_direct_equal;
		_tmp38_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp37_);
		_vala_iterable_unref0 (method_type_args);
		method_type_args = (ValaList*) _tmp38_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaList* _tmp39_;
			ValaList* _tmp40_;
			gint _type_parameter_size = 0;
			ValaList* _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			gint _type_parameter_index = 0;
			_tmp39_ = vala_method_get_type_parameters (self);
			_tmp40_ = _vala_iterable_ref0 (_tmp39_);
			_type_parameter_list = _tmp40_;
			_tmp41_ = _type_parameter_list;
			_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
			_tmp43_ = _tmp42_;
			_type_parameter_size = _tmp43_;
			_type_parameter_index = -1;
			while (TRUE) {
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp44_;
				gpointer _tmp45_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp46_;
				ValaGenericType* _tmp47_;
				ValaGenericType* _tmp48_;
				ValaList* _tmp49_;
				ValaGenericType* _tmp50_;
				_type_parameter_index = _type_parameter_index + 1;
				if (!(_type_parameter_index < _type_parameter_size)) {
					break;
				}
				_tmp44_ = _type_parameter_list;
				_tmp45_ = vala_list_get (_tmp44_, _type_parameter_index);
				type_parameter = (ValaTypeParameter*) _tmp45_;
				_tmp46_ = type_parameter;
				_tmp47_ = vala_generic_type_new (_tmp46_);
				type_arg = _tmp47_;
				_tmp48_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp48_, TRUE);
				_tmp49_ = method_type_args;
				_tmp50_ = type_arg;
				vala_collection_add ((ValaCollection*) _tmp49_, (ValaDataType*) _tmp50_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp51_ = vala_callable_get_return_type ((ValaCallable*) base_method);
	_tmp52_ = _tmp51_;
	_tmp53_ = object_type;
	_tmp54_ = method_type_args;
	_tmp55_ = vala_data_type_get_actual_type (_tmp52_, (ValaDataType*) _tmp53_, _tmp54_, node_reference);
	actual_base_type = _tmp55_;
	_tmp56_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp57_ = _tmp56_;
	_tmp58_ = actual_base_type;
	if (!vala_data_type_equals (_tmp57_, _tmp58_)) {
		ValaDataType* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		ValaDataType* _tmp62_;
		ValaDataType* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		_tmp59_ = actual_base_type;
		_tmp60_ = vala_data_type_to_prototype_string (_tmp59_, NULL);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp63_ = _tmp62_;
		_tmp64_ = vala_data_type_to_prototype_string (_tmp63_, NULL);
		_tmp65_ = _tmp64_;
		_tmp66_ = g_strdup_printf ("Base method expected return type `%s', but `%s' was provided", _tmp61_, _tmp65_);
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp66_;
		_g_free0 (_tmp65_);
		_g_free0 (_tmp61_);
		result = FALSE;
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp67_ = self->priv->parameters;
	_tmp68_ = vala_iterable_iterator ((ValaIterable*) _tmp67_);
	method_params_it = _tmp68_;
	param_index = 1;
	{
		ValaList* _base_param_list = NULL;
		ValaList* _tmp69_;
		ValaList* _tmp70_;
		gint _base_param_size = 0;
		ValaList* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		gint _base_param_index = 0;
		_tmp69_ = base_method->priv->parameters;
		_tmp70_ = _vala_iterable_ref0 (_tmp69_);
		_base_param_list = _tmp70_;
		_tmp71_ = _base_param_list;
		_tmp72_ = vala_collection_get_size ((ValaCollection*) _tmp71_);
		_tmp73_ = _tmp72_;
		_base_param_size = _tmp73_;
		_base_param_index = -1;
		while (TRUE) {
			ValaParameter* base_param = NULL;
			ValaList* _tmp74_;
			gpointer _tmp75_;
			ValaIterator* _tmp76_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp78_;
			gpointer _tmp79_;
			ValaParameter* _tmp80_;
			gboolean _tmp81_;
			gboolean _tmp82_;
			ValaParameter* _tmp83_;
			gboolean _tmp84_;
			gboolean _tmp85_;
			ValaParameter* _tmp87_;
			gboolean _tmp88_;
			gboolean _tmp89_;
			ValaParameter* _tmp90_;
			gboolean _tmp91_;
			gboolean _tmp92_;
			ValaParameter* _tmp94_;
			gboolean _tmp95_;
			gboolean _tmp96_;
			gint _tmp115_;
			_base_param_index = _base_param_index + 1;
			if (!(_base_param_index < _base_param_size)) {
				break;
			}
			_tmp74_ = _base_param_list;
			_tmp75_ = vala_list_get (_tmp74_, _base_param_index);
			base_param = (ValaParameter*) _tmp75_;
			_tmp76_ = method_params_it;
			if (!vala_iterator_next (_tmp76_)) {
				gchar* _tmp77_;
				_tmp77_ = g_strdup ("too few parameters");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp77_;
				result = FALSE;
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp78_ = method_params_it;
			_tmp79_ = vala_iterator_get (_tmp78_);
			param = (ValaParameter*) _tmp79_;
			_tmp80_ = base_param;
			_tmp81_ = vala_parameter_get_ellipsis (_tmp80_);
			_tmp82_ = _tmp81_;
			_tmp83_ = param;
			_tmp84_ = vala_parameter_get_ellipsis (_tmp83_);
			_tmp85_ = _tmp84_;
			if (_tmp82_ != _tmp85_) {
				gchar* _tmp86_;
				_tmp86_ = g_strdup ("ellipsis parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp86_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp87_ = base_param;
			_tmp88_ = vala_parameter_get_params_array (_tmp87_);
			_tmp89_ = _tmp88_;
			_tmp90_ = param;
			_tmp91_ = vala_parameter_get_params_array (_tmp90_);
			_tmp92_ = _tmp91_;
			if (_tmp89_ != _tmp92_) {
				gchar* _tmp93_;
				_tmp93_ = g_strdup ("params array parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp93_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp94_ = base_param;
			_tmp95_ = vala_parameter_get_ellipsis (_tmp94_);
			_tmp96_ = _tmp95_;
			if (!_tmp96_) {
				ValaParameter* _tmp97_;
				ValaParameterDirection _tmp98_;
				ValaParameterDirection _tmp99_;
				ValaParameter* _tmp100_;
				ValaParameterDirection _tmp101_;
				ValaParameterDirection _tmp102_;
				ValaParameter* _tmp104_;
				ValaDataType* _tmp105_;
				ValaDataType* _tmp106_;
				ValaObjectType* _tmp107_;
				ValaList* _tmp108_;
				ValaDataType* _tmp109_;
				ValaDataType* _tmp110_;
				ValaParameter* _tmp111_;
				ValaDataType* _tmp112_;
				ValaDataType* _tmp113_;
				_tmp97_ = base_param;
				_tmp98_ = vala_parameter_get_direction (_tmp97_);
				_tmp99_ = _tmp98_;
				_tmp100_ = param;
				_tmp101_ = vala_parameter_get_direction (_tmp100_);
				_tmp102_ = _tmp101_;
				if (_tmp99_ != _tmp102_) {
					gchar* _tmp103_;
					_tmp103_ = g_strdup_printf ("incompatible direction of parameter %d", param_index);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp103_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_tmp104_ = base_param;
				_tmp105_ = vala_variable_get_variable_type ((ValaVariable*) _tmp104_);
				_tmp106_ = _tmp105_;
				_tmp107_ = object_type;
				_tmp108_ = method_type_args;
				_tmp109_ = vala_data_type_get_actual_type (_tmp106_, (ValaDataType*) _tmp107_, _tmp108_, node_reference);
				_vala_code_node_unref0 (actual_base_type);
				actual_base_type = _tmp109_;
				_tmp110_ = actual_base_type;
				_tmp111_ = param;
				_tmp112_ = vala_variable_get_variable_type ((ValaVariable*) _tmp111_);
				_tmp113_ = _tmp112_;
				if (!vala_data_type_equals (_tmp110_, _tmp113_)) {
					gchar* _tmp114_;
					_tmp114_ = g_strdup_printf ("incompatible type of parameter %d", param_index);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp114_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
			}
			_tmp115_ = param_index;
			param_index = _tmp115_ + 1;
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (base_param);
		}
		_vala_iterable_unref0 (_base_param_list);
	}
	_tmp116_ = method_params_it;
	if (vala_iterator_next (_tmp116_)) {
		gchar* _tmp117_;
		_tmp117_ = g_strdup ("too many parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp117_;
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp118_ = g_direct_equal;
	_tmp119_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp118_);
	base_method_errors = _tmp119_;
	_tmp120_ = base_method_errors;
	vala_code_node_get_error_types ((ValaCodeNode*) base_method, (ValaCollection*) _tmp120_, NULL);
	_tmp121_ = self->error_types;
	if (_tmp121_ != NULL) {
		{
			ValaList* _method_error_type_list = NULL;
			ValaList* _tmp122_;
			ValaList* _tmp123_;
			gint _method_error_type_size = 0;
			ValaList* _tmp124_;
			gint _tmp125_;
			gint _tmp126_;
			gint _method_error_type_index = 0;
			_tmp122_ = self->error_types;
			_tmp123_ = _vala_iterable_ref0 (_tmp122_);
			_method_error_type_list = _tmp123_;
			_tmp124_ = _method_error_type_list;
			_tmp125_ = vala_collection_get_size ((ValaCollection*) _tmp124_);
			_tmp126_ = _tmp125_;
			_method_error_type_size = _tmp126_;
			_method_error_type_index = -1;
			while (TRUE) {
				ValaDataType* method_error_type = NULL;
				ValaList* _tmp127_;
				gpointer _tmp128_;
				gboolean match = FALSE;
				_method_error_type_index = _method_error_type_index + 1;
				if (!(_method_error_type_index < _method_error_type_size)) {
					break;
				}
				_tmp127_ = _method_error_type_list;
				_tmp128_ = vala_list_get (_tmp127_, _method_error_type_index);
				method_error_type = (ValaDataType*) _tmp128_;
				match = FALSE;
				{
					ValaArrayList* _base_method_error_type_list = NULL;
					ValaArrayList* _tmp129_;
					ValaArrayList* _tmp130_;
					gint _base_method_error_type_size = 0;
					ValaArrayList* _tmp131_;
					gint _tmp132_;
					gint _tmp133_;
					gint _base_method_error_type_index = 0;
					_tmp129_ = base_method_errors;
					_tmp130_ = _vala_iterable_ref0 (_tmp129_);
					_base_method_error_type_list = _tmp130_;
					_tmp131_ = _base_method_error_type_list;
					_tmp132_ = vala_collection_get_size ((ValaCollection*) _tmp131_);
					_tmp133_ = _tmp132_;
					_base_method_error_type_size = _tmp133_;
					_base_method_error_type_index = -1;
					while (TRUE) {
						ValaDataType* base_method_error_type = NULL;
						ValaArrayList* _tmp134_;
						gpointer _tmp135_;
						ValaDataType* _tmp136_;
						ValaDataType* _tmp137_;
						_base_method_error_type_index = _base_method_error_type_index + 1;
						if (!(_base_method_error_type_index < _base_method_error_type_size)) {
							break;
						}
						_tmp134_ = _base_method_error_type_list;
						_tmp135_ = vala_list_get ((ValaList*) _tmp134_, _base_method_error_type_index);
						base_method_error_type = (ValaDataType*) _tmp135_;
						_tmp136_ = method_error_type;
						_tmp137_ = base_method_error_type;
						if (vala_data_type_compatible (_tmp136_, _tmp137_)) {
							match = TRUE;
							_vala_code_node_unref0 (base_method_error_type);
							break;
						}
						_vala_code_node_unref0 (base_method_error_type);
					}
					_vala_iterable_unref0 (_base_method_error_type_list);
				}
				if (!match) {
					ValaDataType* _tmp138_;
					gchar* _tmp139_;
					gchar* _tmp140_;
					gchar* _tmp141_;
					_tmp138_ = method_error_type;
					_tmp139_ = vala_code_node_to_string ((ValaCodeNode*) _tmp138_);
					_tmp140_ = _tmp139_;
					_tmp141_ = g_strdup_printf ("incompatible error type `%s'", _tmp140_);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp141_;
					_g_free0 (_tmp140_);
					result = FALSE;
					_vala_code_node_unref0 (method_error_type);
					_vala_iterable_unref0 (_method_error_type_list);
					_vala_iterable_unref0 (base_method_errors);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_vala_code_node_unref0 (method_error_type);
			}
			_vala_iterable_unref0 (_method_error_type_list);
		}
	}
	_tmp142_ = base_method->priv->_coroutine;
	_tmp143_ = self->priv->_coroutine;
	if (_tmp142_ != _tmp143_) {
		gchar* _tmp144_;
		_tmp144_ = g_strdup ("async mismatch");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp144_;
		result = FALSE;
		_vala_iterable_unref0 (base_method_errors);
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = NULL;
	result = TRUE;
	_vala_iterable_unref0 (base_method_errors);
	_vala_iterator_unref0 (method_params_it);
	_vala_code_node_unref0 (actual_base_type);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (object_type);
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void
vala_method_add_type_parameter (ValaMethod* self,
                                ValaTypeParameter* p)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->type_parameters);
		self->priv->type_parameters = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->type_parameters;
	vala_collection_add ((ValaCollection*) _tmp3_, p);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_symbol_get_name ((ValaSymbol*) p);
	_tmp7_ = _tmp6_;
	vala_scope_add (_tmp5_, _tmp7_, (ValaSymbol*) p);
}

/**
 * Returns the type parameter list.
 *
 * @return list of type parameters
 */
ValaList*
vala_method_get_type_parameters (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	ValaList* _tmp5_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->type_parameters;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_method__empty_type_parameter_list;
	if (_tmp2_ == NULL) {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (vala_method__empty_type_parameter_list);
		vala_method__empty_type_parameter_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_method__empty_type_parameter_list;
	result = _tmp5_;
	return result;
}

gint
vala_method_get_type_parameter_index (ValaMethod* self,
                                      const gchar* name)
{
	ValaList* _tmp0_;
	gint i = 0;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	}
	i = 0;
	{
		ValaList* _parameter_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _parameter_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _parameter_index = 0;
		_tmp1_ = self->priv->type_parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_parameter_list = _tmp2_;
		_tmp3_ = _parameter_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_parameter_size = _tmp5_;
		_parameter_index = -1;
		while (TRUE) {
			ValaTypeParameter* parameter = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaTypeParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gint _tmp11_;
			_parameter_index = _parameter_index + 1;
			if (!(_parameter_index < _parameter_size)) {
				break;
			}
			_tmp6_ = _parameter_list;
			_tmp7_ = vala_list_get (_tmp6_, _parameter_index);
			parameter = (ValaTypeParameter*) _tmp7_;
			_tmp8_ = parameter;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (g_strcmp0 (_tmp10_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (parameter);
				_vala_iterable_unref0 (_parameter_list);
				return result;
			}
			_tmp11_ = i;
			i = _tmp11_ + 1;
			_vala_code_node_unref0 (parameter);
		}
		_vala_iterable_unref0 (_parameter_list);
	}
	result = -1;
	return result;
}

gboolean
vala_method_has_type_parameters (ValaMethod* self)
{
	gboolean _tmp0_ = FALSE;
	ValaList* _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->type_parameters;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->type_parameters;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
 * Adds a precondition to this method.
 *
 * @param precondition a boolean precondition expression
 */
void
vala_method_add_precondition (ValaMethod* self,
                              ValaExpression* precondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (precondition != NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->preconditions);
		self->priv->preconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->preconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, precondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) precondition, (ValaCodeNode*) self);
}

/**
 * Returns the list of preconditions of this method.
 *
 * @return list of preconditions
 */
ValaList*
vala_method_get_preconditions (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	ValaList* _tmp5_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->preconditions;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_method__empty_expression_list;
	if (_tmp2_ == NULL) {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_method__empty_expression_list;
	result = _tmp5_;
	return result;
}

/**
 * Adds a postcondition to this method.
 *
 * @param postcondition a boolean postcondition expression
 */
void
vala_method_add_postcondition (ValaMethod* self,
                               ValaExpression* postcondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (postcondition != NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->postconditions);
		self->priv->postconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->postconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, postcondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) postcondition, (ValaCodeNode*) self);
}

/**
 * Returns the list of postconditions of this method.
 *
 * @return list of postconditions
 */
ValaList*
vala_method_get_postconditions (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	ValaList* _tmp5_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->postconditions;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_method__empty_expression_list;
	if (_tmp2_ == NULL) {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_method__empty_expression_list;
	result = _tmp5_;
	return result;
}

/**
 * Adds an error type to the exceptions that can be
 * thrown by this method.
 */
void
vala_method_add_error_type (ValaMethod* self,
                            ValaDataType* error_type)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_type != NULL);
	_tmp0_ = self->error_types;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->error_types);
		self->error_types = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->error_types;
	vala_collection_add ((ValaCollection*) _tmp3_, error_type);
	vala_code_node_set_parent_node ((ValaCodeNode*) error_type, (ValaCodeNode*) self);
}

static void
vala_method_real_get_error_types (ValaCodeNode* base,
                                  ValaCollection* collection,
                                  ValaSourceReference* source_reference)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->error_types;
	if (_tmp0_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _error_type_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _error_type_index = 0;
			_tmp1_ = self->error_types;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_error_type_list = _tmp2_;
			_tmp3_ = _error_type_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_error_type_size = _tmp5_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp6_;
				gpointer _tmp7_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp6_ = _error_type_list;
				_tmp7_ = vala_list_get (_tmp6_, _error_type_index);
				error_type = (ValaDataType*) _tmp7_;
				if (source_reference != NULL) {
					ValaDataType* type = NULL;
					ValaDataType* _tmp8_;
					ValaDataType* _tmp9_;
					ValaDataType* _tmp10_;
					ValaDataType* _tmp11_;
					_tmp8_ = error_type;
					_tmp9_ = vala_data_type_copy (_tmp8_);
					type = _tmp9_;
					_tmp10_ = type;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp10_, source_reference);
					_tmp11_ = type;
					vala_collection_add (collection, _tmp11_);
					_vala_code_node_unref0 (type);
				} else {
					ValaDataType* _tmp12_;
					_tmp12_ = error_type;
					vala_collection_add (collection, _tmp12_);
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
}

static void
vala_method_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaMethod * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaList* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_method_get_base_interface_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_method_set_base_interface_type (self, new_type);
		return;
	}
	_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
		return;
	}
	_tmp4_ = self->error_types;
	if (_tmp4_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					ValaList* _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					ValaList* _tmp10_;
					gpointer _tmp11_;
					ValaDataType* _tmp12_;
					gboolean _tmp13_;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp7_ = self->error_types;
					_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
					_tmp9_ = _tmp8_;
					if (!(i < _tmp9_)) {
						break;
					}
					_tmp10_ = self->error_types;
					_tmp11_ = vala_list_get (_tmp10_, i);
					_tmp12_ = (ValaDataType*) _tmp11_;
					_tmp13_ = _tmp12_ == old_type;
					_vala_code_node_unref0 (_tmp12_);
					if (_tmp13_) {
						ValaList* _tmp14_;
						_tmp14_ = self->error_types;
						vala_list_set (_tmp14_, i, new_type);
						return;
					}
				}
			}
		}
	}
}

static void
vala_method_find_base_methods (ValaMethod* self)
{
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->base_methods_valid) {
		return;
	}
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_CLASS (_tmp1_)) {
		if (!VALA_IS_CREATION_METHOD (self)) {
			ValaSymbol* _tmp2_;
			ValaSymbol* _tmp3_;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_;
			_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp3_ = _tmp2_;
			vala_method_find_base_interface_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_CLASS, ValaClass));
			_tmp6_ = self->priv->_is_virtual;
			if (_tmp6_) {
				_tmp5_ = TRUE;
			} else {
				gboolean _tmp7_;
				_tmp7_ = self->priv->_is_abstract;
				_tmp5_ = _tmp7_;
			}
			if (_tmp5_) {
				_tmp4_ = TRUE;
			} else {
				gboolean _tmp8_;
				_tmp8_ = self->priv->_overrides;
				_tmp4_ = _tmp8_;
			}
			if (_tmp4_) {
				ValaSymbol* _tmp9_;
				ValaSymbol* _tmp10_;
				_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp10_ = _tmp9_;
				vala_method_find_base_class_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_CLASS, ValaClass));
			}
		}
	} else {
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp12_ = _tmp11_;
		if (VALA_IS_INTERFACE (_tmp12_)) {
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
			_tmp14_ = self->priv->_is_virtual;
			if (_tmp14_) {
				_tmp13_ = TRUE;
			} else {
				gboolean _tmp15_;
				_tmp15_ = self->priv->_is_abstract;
				_tmp13_ = _tmp15_;
			}
			if (_tmp13_) {
				self->priv->_base_interface_method = self;
			}
		}
	}
	self->priv->base_methods_valid = TRUE;
}

static void
vala_method_find_base_class_method (ValaMethod* self,
                                    ValaClass* cl)
{
	ValaSymbol* sym = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp11_;
	ValaClass* _tmp35_;
	ValaClass* _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_scope_lookup (_tmp1_, _tmp3_);
	sym = _tmp4_;
	_tmp5_ = sym;
	if (VALA_IS_SIGNAL (_tmp5_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp6_;
		ValaSignal* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp6_ = sym;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_SIGNAL, ValaSignal);
		_tmp7_ = sig;
		_tmp8_ = vala_signal_get_default_handler (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp9_);
		_vala_code_node_unref0 (sym);
		sym = _tmp10_;
	}
	_tmp11_ = sym;
	if (VALA_IS_METHOD (_tmp11_)) {
		ValaMethod* base_method = NULL;
		ValaSymbol* _tmp12_;
		gboolean _tmp13_ = FALSE;
		ValaMethod* _tmp14_;
		gboolean _tmp15_;
		_tmp12_ = sym;
		base_method = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_METHOD, ValaMethod);
		_tmp14_ = base_method;
		_tmp15_ = _tmp14_->priv->_is_abstract;
		if (_tmp15_) {
			_tmp13_ = TRUE;
		} else {
			ValaMethod* _tmp16_;
			gboolean _tmp17_;
			_tmp16_ = base_method;
			_tmp17_ = _tmp16_->priv->_is_virtual;
			_tmp13_ = _tmp17_;
		}
		if (_tmp13_) {
			gchar* invalid_match = NULL;
			ValaMethod* _tmp18_;
			gchar* _tmp19_ = NULL;
			gboolean _tmp20_;
			ValaMethod* _tmp33_;
			ValaMethod* _tmp34_;
			_tmp18_ = base_method;
			_tmp20_ = vala_method_compatible (self, _tmp18_, &_tmp19_);
			_g_free0 (invalid_match);
			invalid_match = _tmp19_;
			if (!_tmp20_) {
				ValaMethodType* base_method_type = NULL;
				ValaMethod* _tmp21_;
				ValaMethodType* _tmp22_;
				ValaSourceReference* _tmp23_;
				ValaSourceReference* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				ValaMethodType* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp21_ = base_method;
				_tmp22_ = vala_method_type_new (_tmp21_);
				base_method_type = _tmp22_;
				_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp26_ = _tmp25_;
				_tmp27_ = base_method_type;
				_tmp28_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp27_, NULL);
				_tmp29_ = _tmp28_;
				_tmp30_ = invalid_match;
				_tmp31_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp26_, _tmp29_, _tmp30_);
				_tmp32_ = _tmp31_;
				vala_report_error (_tmp24_, _tmp32_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp29_);
				_g_free0 (_tmp26_);
				_vala_code_node_unref0 (base_method_type);
				_g_free0 (invalid_match);
				_vala_code_node_unref0 (sym);
				return;
			}
			_tmp33_ = base_method;
			self->priv->_base_method = _tmp33_;
			_tmp34_ = base_method;
			vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp34_, "CCode", "instance_pos");
			_g_free0 (invalid_match);
			_vala_code_node_unref0 (sym);
			return;
		}
	}
	_tmp35_ = vala_class_get_base_class (cl);
	_tmp36_ = _tmp35_;
	if (_tmp36_ != NULL) {
		ValaClass* _tmp37_;
		ValaClass* _tmp38_;
		_tmp37_ = vala_class_get_base_class (cl);
		_tmp38_ = _tmp37_;
		vala_method_find_base_class_method (self, _tmp38_);
	}
	_vala_code_node_unref0 (sym);
}

static void
vala_method_find_base_interface_method (ValaMethod* self,
                                        ValaClass* cl)
{
	ValaMethod* base_match = NULL;
	gchar* invalid_error = NULL;
	ValaMethod* invalid_base_match = NULL;
	ValaMethod* _tmp67_;
	ValaDataType* _tmp83_;
	ValaDataType* _tmp84_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	base_match = NULL;
	invalid_error = NULL;
	invalid_base_match = NULL;
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = vala_class_get_base_types (cl);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaDataType* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp5_ = _type_list;
			_tmp6_ = vala_list_get (_tmp5_, _type_index);
			type = (ValaDataType*) _tmp6_;
			_tmp7_ = type;
			_tmp8_ = vala_data_type_get_type_symbol (_tmp7_);
			_tmp9_ = _tmp8_;
			if (VALA_IS_INTERFACE (_tmp9_)) {
				gboolean _tmp10_ = FALSE;
				ValaDataType* _tmp11_;
				ValaDataType* _tmp12_;
				ValaSymbol* sym = NULL;
				ValaDataType* _tmp20_;
				ValaTypeSymbol* _tmp21_;
				ValaTypeSymbol* _tmp22_;
				ValaScope* _tmp23_;
				ValaScope* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				ValaSymbol* _tmp27_;
				ValaSymbol* _tmp28_;
				ValaSymbol* _tmp34_;
				_tmp11_ = vala_method_get_base_interface_type (self);
				_tmp12_ = _tmp11_;
				if (_tmp12_ != NULL) {
					ValaDataType* _tmp13_;
					ValaDataType* _tmp14_;
					ValaTypeSymbol* _tmp15_;
					ValaTypeSymbol* _tmp16_;
					ValaDataType* _tmp17_;
					ValaTypeSymbol* _tmp18_;
					ValaTypeSymbol* _tmp19_;
					_tmp13_ = vala_method_get_base_interface_type (self);
					_tmp14_ = _tmp13_;
					_tmp15_ = vala_data_type_get_type_symbol (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = type;
					_tmp18_ = vala_data_type_get_type_symbol (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp10_ = _tmp16_ != _tmp19_;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					_vala_code_node_unref0 (type);
					continue;
				}
				_tmp20_ = type;
				_tmp21_ = vala_data_type_get_type_symbol (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = vala_symbol_get_scope ((ValaSymbol*) _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_scope_lookup (_tmp24_, _tmp26_);
				sym = _tmp27_;
				_tmp28_ = sym;
				if (VALA_IS_SIGNAL (_tmp28_)) {
					ValaSignal* sig = NULL;
					ValaSymbol* _tmp29_;
					ValaSignal* _tmp30_;
					ValaMethod* _tmp31_;
					ValaMethod* _tmp32_;
					ValaSymbol* _tmp33_;
					_tmp29_ = sym;
					sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALA_TYPE_SIGNAL, ValaSignal);
					_tmp30_ = sig;
					_tmp31_ = vala_signal_get_default_handler (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp32_);
					_vala_code_node_unref0 (sym);
					sym = _tmp33_;
				}
				_tmp34_ = sym;
				if (VALA_IS_METHOD (_tmp34_)) {
					ValaMethod* base_method = NULL;
					ValaSymbol* _tmp35_;
					gboolean _tmp36_ = FALSE;
					ValaMethod* _tmp37_;
					gboolean _tmp38_;
					_tmp35_ = sym;
					base_method = G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_METHOD, ValaMethod);
					_tmp37_ = base_method;
					_tmp38_ = _tmp37_->priv->_is_abstract;
					if (_tmp38_) {
						_tmp36_ = TRUE;
					} else {
						ValaMethod* _tmp39_;
						gboolean _tmp40_;
						_tmp39_ = base_method;
						_tmp40_ = _tmp39_->priv->_is_virtual;
						_tmp36_ = _tmp40_;
					}
					if (_tmp36_) {
						ValaDataType* _tmp41_;
						ValaDataType* _tmp42_;
						gchar* invalid_match = NULL;
						ValaMethod* _tmp58_;
						gchar* _tmp59_ = NULL;
						gboolean _tmp60_;
						_tmp41_ = vala_method_get_base_interface_type (self);
						_tmp42_ = _tmp41_;
						if (_tmp42_ == NULL) {
							gboolean has_explicit_implementation = FALSE;
							has_explicit_implementation = FALSE;
							{
								ValaList* _m_list = NULL;
								ValaList* _tmp43_;
								ValaList* _tmp44_;
								gint _m_size = 0;
								ValaList* _tmp45_;
								gint _tmp46_;
								gint _tmp47_;
								gint _m_index = 0;
								_tmp43_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl);
								_tmp44_ = _vala_iterable_ref0 (_tmp43_);
								_m_list = _tmp44_;
								_tmp45_ = _m_list;
								_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
								_tmp47_ = _tmp46_;
								_m_size = _tmp47_;
								_m_index = -1;
								while (TRUE) {
									ValaMethod* m = NULL;
									ValaList* _tmp48_;
									gpointer _tmp49_;
									gboolean _tmp50_ = FALSE;
									ValaMethod* _tmp51_;
									ValaDataType* _tmp52_;
									ValaDataType* _tmp53_;
									_m_index = _m_index + 1;
									if (!(_m_index < _m_size)) {
										break;
									}
									_tmp48_ = _m_list;
									_tmp49_ = vala_list_get (_tmp48_, _m_index);
									m = (ValaMethod*) _tmp49_;
									_tmp51_ = m;
									_tmp52_ = vala_method_get_base_interface_type (_tmp51_);
									_tmp53_ = _tmp52_;
									if (_tmp53_ != NULL) {
										ValaMethod* _tmp54_;
										ValaMethod* _tmp55_;
										ValaMethod* _tmp56_;
										ValaMethod* _tmp57_;
										_tmp54_ = base_method;
										_tmp55_ = m;
										_tmp56_ = vala_method_get_base_interface_method (_tmp55_);
										_tmp57_ = _tmp56_;
										_tmp50_ = _tmp54_ == _tmp57_;
									} else {
										_tmp50_ = FALSE;
									}
									if (_tmp50_) {
										has_explicit_implementation = TRUE;
										_vala_code_node_unref0 (m);
										break;
									}
									_vala_code_node_unref0 (m);
								}
								_vala_iterable_unref0 (_m_list);
							}
							if (has_explicit_implementation) {
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (type);
								continue;
							}
						}
						invalid_match = NULL;
						_tmp58_ = base_method;
						_tmp60_ = vala_method_compatible (self, _tmp58_, &_tmp59_);
						_g_free0 (invalid_match);
						invalid_match = _tmp59_;
						if (!_tmp60_) {
							const gchar* _tmp61_;
							gchar* _tmp62_;
							ValaMethod* _tmp63_;
							ValaMethod* _tmp64_;
							_tmp61_ = invalid_match;
							_tmp62_ = g_strdup (_tmp61_);
							_g_free0 (invalid_error);
							invalid_error = _tmp62_;
							_tmp63_ = base_method;
							_tmp64_ = _vala_code_node_ref0 (_tmp63_);
							_vala_code_node_unref0 (invalid_base_match);
							invalid_base_match = _tmp64_;
						} else {
							ValaMethod* _tmp65_;
							ValaMethod* _tmp66_;
							_tmp65_ = base_method;
							_tmp66_ = _vala_code_node_ref0 (_tmp65_);
							_vala_code_node_unref0 (base_match);
							base_match = _tmp66_;
							_g_free0 (invalid_match);
							_vala_code_node_unref0 (sym);
							_vala_code_node_unref0 (type);
							break;
						}
						_g_free0 (invalid_match);
					}
				}
				_vala_code_node_unref0 (sym);
			}
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	_tmp67_ = base_match;
	if (_tmp67_ != NULL) {
		ValaMethod* _tmp68_;
		ValaMethod* _tmp69_;
		_tmp68_ = base_match;
		self->priv->_base_interface_method = _tmp68_;
		_tmp69_ = base_match;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp69_, "CCode", "instance_pos");
		_vala_code_node_unref0 (invalid_base_match);
		_g_free0 (invalid_error);
		_vala_code_node_unref0 (base_match);
		return;
	} else {
		ValaMethod* _tmp70_;
		_tmp70_ = invalid_base_match;
		if (_tmp70_ != NULL) {
			ValaMethodType* base_method_type = NULL;
			ValaMethod* _tmp71_;
			ValaMethodType* _tmp72_;
			ValaSourceReference* _tmp73_;
			ValaSourceReference* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			ValaMethodType* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			const gchar* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp71_ = invalid_base_match;
			_tmp72_ = vala_method_type_new (_tmp71_);
			base_method_type = _tmp72_;
			_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp74_ = _tmp73_;
			_tmp75_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp76_ = _tmp75_;
			_tmp77_ = base_method_type;
			_tmp78_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp77_, NULL);
			_tmp79_ = _tmp78_;
			_tmp80_ = invalid_error;
			_tmp81_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp76_, _tmp79_, _tmp80_);
			_tmp82_ = _tmp81_;
			vala_report_error (_tmp74_, _tmp82_);
			_g_free0 (_tmp82_);
			_g_free0 (_tmp79_);
			_g_free0 (_tmp76_);
			_vala_code_node_unref0 (base_method_type);
			_vala_code_node_unref0 (invalid_base_match);
			_g_free0 (invalid_error);
			_vala_code_node_unref0 (base_match);
			return;
		}
	}
	_tmp83_ = vala_method_get_base_interface_type (self);
	_tmp84_ = _tmp83_;
	if (_tmp84_ != NULL) {
		ValaSourceReference* _tmp85_;
		ValaSourceReference* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		_tmp85_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp86_ = _tmp85_;
		_tmp87_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp88_ = _tmp87_;
		_tmp89_ = g_strdup_printf ("`%s': no suitable interface method found to implement", _tmp88_);
		_tmp90_ = _tmp89_;
		vala_report_error (_tmp86_, _tmp90_);
		_g_free0 (_tmp90_);
		_g_free0 (_tmp88_);
	}
	_vala_code_node_unref0 (invalid_base_match);
	_g_free0 (invalid_error);
	_vala_code_node_unref0 (base_match);
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_method_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaMethod * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaParameter* _tmp4_;
	ValaAttribute* _tmp6_;
	ValaAttribute* _tmp10_;
	gboolean _tmp11_ = FALSE;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp34_;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_;
	gboolean _tmp103_ = FALSE;
	gboolean _tmp104_ = FALSE;
	gboolean _tmp105_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp110_;
	ValaSemanticAnalyzer* _tmp111_;
	ValaSourceFile* _tmp112_;
	ValaSourceFile* _tmp113_;
	ValaSourceFile* _tmp114_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp115_;
	ValaSemanticAnalyzer* _tmp116_;
	ValaSymbol* _tmp117_;
	ValaSymbol* _tmp118_;
	ValaSymbol* _tmp119_;
	ValaSourceReference* _tmp120_;
	ValaSourceReference* _tmp121_;
	ValaSemanticAnalyzer* _tmp128_;
	ValaSemanticAnalyzer* _tmp129_;
	ValaDataType* _tmp130_;
	ValaDataType* _tmp131_;
	gboolean _tmp132_;
	gboolean _tmp133_;
	ValaDataType* _tmp134_;
	ValaDataType* _tmp135_;
	gboolean _tmp136_;
	gboolean _tmp137_;
	ValaDataType* _tmp142_;
	ValaDataType* _tmp143_;
	ValaTypeSymbol* _tmp144_;
	ValaTypeSymbol* _tmp145_;
	ValaSemanticAnalyzer* _tmp146_;
	ValaSemanticAnalyzer* _tmp147_;
	ValaDataType* _tmp148_;
	ValaTypeSymbol* _tmp149_;
	ValaTypeSymbol* _tmp150_;
	ValaAttribute* init_attr = NULL;
	ValaAttribute* _tmp161_;
	ValaAttribute* _tmp162_;
	ValaAttribute* _tmp163_;
	ValaDataType* _tmp170_;
	ValaDataType* _tmp171_;
	gboolean _tmp174_ = FALSE;
	gboolean _tmp175_ = FALSE;
	gboolean _tmp176_ = FALSE;
	ValaList* _tmp177_;
	gint _tmp178_;
	gint _tmp179_;
	gboolean _tmp193_ = FALSE;
	ValaAttribute* _tmp194_;
	gboolean optional_param = FALSE;
	gboolean _tmp266_;
	ValaList* _tmp280_;
	ValaLocalVariable* _tmp301_;
	ValaLocalVariable* _tmp302_;
	ValaList* _tmp305_;
	ValaList* _tmp314_;
	ValaBlock* _tmp323_;
	ValaBlock* _tmp324_;
	ValaSemanticAnalyzer* _tmp327_;
	ValaSemanticAnalyzer* _tmp328_;
	ValaStruct* _tmp329_;
	ValaStruct* _tmp330_;
	gboolean _tmp369_ = FALSE;
	gboolean _tmp370_ = FALSE;
	ValaDataType* _tmp371_;
	ValaDataType* _tmp372_;
	ValaSemanticAnalyzer* _tmp416_;
	ValaSemanticAnalyzer* _tmp417_;
	ValaSourceFile* _tmp418_;
	ValaSemanticAnalyzer* _tmp419_;
	ValaSemanticAnalyzer* _tmp420_;
	ValaSymbol* _tmp421_;
	gboolean _tmp422_ = FALSE;
	gboolean _tmp423_ = FALSE;
	gboolean _tmp424_ = FALSE;
	gboolean _tmp425_;
	gboolean _tmp426_;
	ValaSemanticAnalyzer* _tmp442_;
	ValaSemanticAnalyzer* _tmp443_;
	ValaDataType* _tmp444_;
	ValaDataType* _tmp445_;
	gboolean _tmp494_ = FALSE;
	ValaBlock* _tmp495_;
	ValaBlock* _tmp496_;
	gboolean _tmp537_ = FALSE;
	gboolean _tmp538_ = FALSE;
	gboolean _tmp539_ = FALSE;
	gboolean _tmp540_ = FALSE;
	gboolean _tmp541_ = FALSE;
	ValaAttribute* _tmp599_;
	gboolean _tmp600_;
	gboolean _tmp601_;
	gboolean result = FALSE;
	self = (ValaMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = self->priv->_this_parameter;
	if (_tmp4_ != NULL) {
		ValaParameter* _tmp5_;
		_tmp5_ = self->priv->_this_parameter;
		vala_code_node_check ((ValaCodeNode*) _tmp5_, context);
	}
	_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DestroysInstance");
	if (_tmp6_ != NULL) {
		ValaParameter* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp7_ = self->priv->_this_parameter;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) _tmp7_);
		_tmp9_ = _tmp8_;
		vala_data_type_set_value_owned (_tmp9_, TRUE);
	}
	_tmp10_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "NoThrow");
	if (_tmp10_ != NULL) {
		_vala_iterable_unref0 (self->error_types);
		self->error_types = NULL;
	}
	_tmp12_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp13_ = _tmp12_;
	if (VALA_IS_CLASS (_tmp13_)) {
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_;
		_tmp15_ = self->priv->_is_abstract;
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			gboolean _tmp16_;
			_tmp16_ = self->priv->_is_virtual;
			_tmp14_ = _tmp16_;
		}
		_tmp11_ = _tmp14_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		gboolean _tmp19_ = FALSE;
		ValaClass* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp17_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp18_ = _tmp17_;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_CLASS, ValaClass);
		_tmp20_ = cl;
		_tmp21_ = vala_class_get_is_compact (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_) {
			ValaClass* _tmp23_;
			ValaClass* _tmp24_;
			ValaClass* _tmp25_;
			_tmp23_ = cl;
			_tmp24_ = vala_class_get_base_class (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp19_ = _tmp25_ != NULL;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			ValaSourceReference* _tmp26_;
			ValaSourceReference* _tmp27_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp27_ = _tmp26_;
			vala_report_error (_tmp27_, "Abstract and virtual methods may not be declared in derived compact cl" \
"asses");
			result = FALSE;
			return result;
		}
	}
	if (vala_method_is_variadic (self)) {
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_;
		_tmp30_ = self->priv->_is_abstract;
		if (_tmp30_) {
			_tmp29_ = TRUE;
		} else {
			gboolean _tmp31_;
			_tmp31_ = self->priv->_is_virtual;
			_tmp29_ = _tmp31_;
		}
		_tmp28_ = _tmp29_;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		ValaSourceReference* _tmp32_;
		ValaSourceReference* _tmp33_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp33_ = _tmp32_;
		vala_report_error (_tmp33_, "Abstract and virtual methods may not be variadic. Use a `va_list' para" \
"meter instead of `...'.");
		result = FALSE;
		return result;
	}
	_tmp34_ = self->priv->_is_abstract;
	if (_tmp34_) {
		ValaSymbol* _tmp35_;
		ValaSymbol* _tmp36_;
		_tmp35_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp36_ = _tmp35_;
		if (VALA_IS_CLASS (_tmp36_)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaClass* _tmp39_;
			gboolean _tmp40_;
			gboolean _tmp41_;
			_tmp37_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp38_ = _tmp37_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_CLASS, ValaClass);
			_tmp39_ = cl;
			_tmp40_ = vala_class_get_is_abstract (_tmp39_);
			_tmp41_ = _tmp40_;
			if (!_tmp41_) {
				ValaSourceReference* _tmp42_;
				ValaSourceReference* _tmp43_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp43_ = _tmp42_;
				vala_report_error (_tmp43_, "Abstract methods may not be declared in non-abstract classes");
				result = FALSE;
				return result;
			}
		} else {
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			_tmp44_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp45_ = _tmp44_;
			if (!VALA_IS_INTERFACE (_tmp45_)) {
				ValaSourceReference* _tmp46_;
				ValaSourceReference* _tmp47_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp47_ = _tmp46_;
				vala_report_error (_tmp47_, "Abstract methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		}
	} else {
		gboolean _tmp48_;
		_tmp48_ = self->priv->_is_virtual;
		if (_tmp48_) {
			gboolean _tmp49_ = FALSE;
			ValaSymbol* _tmp50_;
			ValaSymbol* _tmp51_;
			_tmp50_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp51_ = _tmp50_;
			if (!VALA_IS_CLASS (_tmp51_)) {
				ValaSymbol* _tmp52_;
				ValaSymbol* _tmp53_;
				_tmp52_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp53_ = _tmp52_;
				_tmp49_ = !VALA_IS_INTERFACE (_tmp53_);
			} else {
				_tmp49_ = FALSE;
			}
			if (_tmp49_) {
				ValaSourceReference* _tmp54_;
				ValaSourceReference* _tmp55_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp55_ = _tmp54_;
				vala_report_error (_tmp55_, "Virtual methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		} else {
			gboolean _tmp56_;
			_tmp56_ = self->priv->_overrides;
			if (_tmp56_) {
				ValaSymbol* _tmp57_;
				ValaSymbol* _tmp58_;
				_tmp57_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp58_ = _tmp57_;
				if (!VALA_IS_CLASS (_tmp58_)) {
					ValaSourceReference* _tmp59_;
					ValaSourceReference* _tmp60_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp60_ = _tmp59_;
					vala_report_error (_tmp60_, "Methods may not be overridden outside of classes");
					result = FALSE;
					return result;
				}
			} else {
				ValaSymbolAccessibility _tmp61_;
				ValaSymbolAccessibility _tmp62_;
				_tmp61_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp62_ = _tmp61_;
				if (_tmp62_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
					gboolean _tmp63_ = FALSE;
					ValaSymbol* _tmp64_;
					ValaSymbol* _tmp65_;
					_tmp64_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
					_tmp65_ = _tmp64_;
					if (!VALA_IS_CLASS (_tmp65_)) {
						ValaSymbol* _tmp66_;
						ValaSymbol* _tmp67_;
						_tmp66_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
						_tmp67_ = _tmp66_;
						_tmp63_ = !VALA_IS_INTERFACE (_tmp67_);
					} else {
						_tmp63_ = FALSE;
					}
					if (_tmp63_) {
						ValaSourceReference* _tmp68_;
						ValaSourceReference* _tmp69_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp69_ = _tmp68_;
						vala_report_error (_tmp69_, "Protected methods may not be declared outside of classes and interface" \
"s");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp71_ = self->priv->_is_abstract;
	if (_tmp71_) {
		ValaBlock* _tmp72_;
		ValaBlock* _tmp73_;
		_tmp72_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp73_ = _tmp72_;
		_tmp70_ = _tmp73_ != NULL;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		ValaSourceReference* _tmp74_;
		ValaSourceReference* _tmp75_;
		_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp75_ = _tmp74_;
		vala_report_error (_tmp75_, "Abstract methods cannot have bodies");
	} else {
		gboolean _tmp76_ = FALSE;
		gboolean _tmp77_ = FALSE;
		gboolean _tmp78_;
		_tmp78_ = self->priv->_is_abstract;
		if (_tmp78_) {
			_tmp77_ = TRUE;
		} else {
			gboolean _tmp79_;
			_tmp79_ = self->priv->_is_virtual;
			_tmp77_ = _tmp79_;
		}
		if (_tmp77_) {
			gboolean _tmp80_;
			gboolean _tmp81_;
			_tmp80_ = vala_symbol_get_is_extern ((ValaSymbol*) self);
			_tmp81_ = _tmp80_;
			_tmp76_ = _tmp81_;
		} else {
			_tmp76_ = FALSE;
		}
		if (_tmp76_) {
			ValaSourceReference* _tmp82_;
			ValaSourceReference* _tmp83_;
			_tmp82_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp83_ = _tmp82_;
			vala_report_error (_tmp83_, "Extern methods cannot be abstract or virtual");
		} else {
			gboolean _tmp84_ = FALSE;
			gboolean _tmp85_;
			gboolean _tmp86_;
			_tmp85_ = vala_symbol_get_is_extern ((ValaSymbol*) self);
			_tmp86_ = _tmp85_;
			if (_tmp86_) {
				ValaBlock* _tmp87_;
				ValaBlock* _tmp88_;
				_tmp87_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp88_ = _tmp87_;
				_tmp84_ = _tmp88_ != NULL;
			} else {
				_tmp84_ = FALSE;
			}
			if (_tmp84_) {
				ValaSourceReference* _tmp89_;
				ValaSourceReference* _tmp90_;
				_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp90_ = _tmp89_;
				vala_report_error (_tmp90_, "Extern methods cannot have bodies");
			} else {
				gboolean _tmp91_ = FALSE;
				gboolean _tmp92_ = FALSE;
				gboolean _tmp93_ = FALSE;
				gboolean _tmp94_;
				_tmp94_ = self->priv->_is_abstract;
				if (!_tmp94_) {
					gboolean _tmp95_;
					gboolean _tmp96_;
					_tmp95_ = vala_symbol_get_external ((ValaSymbol*) self);
					_tmp96_ = _tmp95_;
					_tmp93_ = !_tmp96_;
				} else {
					_tmp93_ = FALSE;
				}
				if (_tmp93_) {
					ValaSourceFileType _tmp97_;
					ValaSourceFileType _tmp98_;
					_tmp97_ = vala_symbol_get_source_type ((ValaSymbol*) self);
					_tmp98_ = _tmp97_;
					_tmp92_ = _tmp98_ == VALA_SOURCE_FILE_TYPE_SOURCE;
				} else {
					_tmp92_ = FALSE;
				}
				if (_tmp92_) {
					ValaBlock* _tmp99_;
					ValaBlock* _tmp100_;
					_tmp99_ = vala_subroutine_get_body ((ValaSubroutine*) self);
					_tmp100_ = _tmp99_;
					_tmp91_ = _tmp100_ == NULL;
				} else {
					_tmp91_ = FALSE;
				}
				if (_tmp91_) {
					ValaSourceReference* _tmp101_;
					ValaSourceReference* _tmp102_;
					_tmp101_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp102_ = _tmp101_;
					vala_report_error (_tmp102_, "Non-abstract, non-extern methods must have bodies");
				}
			}
		}
	}
	_tmp105_ = self->priv->_coroutine;
	if (_tmp105_) {
		gboolean _tmp106_;
		gboolean _tmp107_;
		_tmp106_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp107_ = _tmp106_;
		_tmp104_ = !_tmp107_;
	} else {
		_tmp104_ = FALSE;
	}
	if (_tmp104_) {
		_tmp103_ = !vala_code_context_has_package (context, "gio-2.0");
	} else {
		_tmp103_ = FALSE;
	}
	if (_tmp103_) {
		ValaSourceReference* _tmp108_;
		ValaSourceReference* _tmp109_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp108_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp109_ = _tmp108_;
		vala_report_error (_tmp109_, "gio-2.0 package required for async methods");
		result = FALSE;
		return result;
	}
	_tmp110_ = vala_code_context_get_analyzer (context);
	_tmp111_ = _tmp110_;
	_tmp112_ = vala_semantic_analyzer_get_current_source_file (_tmp111_);
	_tmp113_ = _tmp112_;
	_tmp114_ = _vala_source_file_ref0 (_tmp113_);
	old_source_file = _tmp114_;
	_tmp115_ = vala_code_context_get_analyzer (context);
	_tmp116_ = _tmp115_;
	_tmp117_ = vala_semantic_analyzer_get_current_symbol (_tmp116_);
	_tmp118_ = _tmp117_;
	_tmp119_ = _vala_code_node_ref0 (_tmp118_);
	old_symbol = _tmp119_;
	_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp121_ = _tmp120_;
	if (_tmp121_ != NULL) {
		ValaSemanticAnalyzer* _tmp122_;
		ValaSemanticAnalyzer* _tmp123_;
		ValaSourceReference* _tmp124_;
		ValaSourceReference* _tmp125_;
		ValaSourceFile* _tmp126_;
		ValaSourceFile* _tmp127_;
		_tmp122_ = vala_code_context_get_analyzer (context);
		_tmp123_ = _tmp122_;
		_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp125_ = _tmp124_;
		_tmp126_ = vala_source_reference_get_file (_tmp125_);
		_tmp127_ = _tmp126_;
		vala_semantic_analyzer_set_current_source_file (_tmp123_, _tmp127_);
	}
	_tmp128_ = vala_code_context_get_analyzer (context);
	_tmp129_ = _tmp128_;
	vala_semantic_analyzer_set_current_symbol (_tmp129_, (ValaSymbol*) self);
	_tmp130_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp131_ = _tmp130_;
	_tmp132_ = vala_method_get_returns_floating_reference (self);
	_tmp133_ = _tmp132_;
	vala_data_type_set_floating_reference (_tmp131_, _tmp133_);
	_tmp134_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp135_ = _tmp134_;
	vala_code_node_check ((ValaCodeNode*) _tmp135_, context);
	_tmp136_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp137_ = _tmp136_;
	if (!_tmp137_) {
		ValaSemanticAnalyzer* _tmp138_;
		ValaSemanticAnalyzer* _tmp139_;
		ValaDataType* _tmp140_;
		ValaDataType* _tmp141_;
		_tmp138_ = vala_code_context_get_analyzer (context);
		_tmp139_ = _tmp138_;
		_tmp140_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp141_ = _tmp140_;
		vala_semantic_analyzer_check_type (_tmp139_, _tmp141_);
	}
	_tmp142_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp143_ = _tmp142_;
	_tmp144_ = vala_data_type_get_type_symbol (_tmp143_);
	_tmp145_ = _tmp144_;
	_tmp146_ = vala_code_context_get_analyzer (context);
	_tmp147_ = _tmp146_;
	_tmp148_ = _tmp147_->va_list_type;
	_tmp149_ = vala_data_type_get_type_symbol (_tmp148_);
	_tmp150_ = _tmp149_;
	if (_tmp145_ == _tmp150_) {
		ValaSourceReference* _tmp151_;
		ValaSourceReference* _tmp152_;
		ValaDataType* _tmp153_;
		ValaDataType* _tmp154_;
		ValaTypeSymbol* _tmp155_;
		ValaTypeSymbol* _tmp156_;
		gchar* _tmp157_;
		gchar* _tmp158_;
		gchar* _tmp159_;
		gchar* _tmp160_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp152_ = _tmp151_;
		_tmp153_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp154_ = _tmp153_;
		_tmp155_ = vala_data_type_get_type_symbol (_tmp154_);
		_tmp156_ = _tmp155_;
		_tmp157_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp156_);
		_tmp158_ = _tmp157_;
		_tmp159_ = g_strdup_printf ("`%s' not supported as return type", _tmp158_);
		_tmp160_ = _tmp159_;
		vala_report_error (_tmp152_, _tmp160_);
		_g_free0 (_tmp160_);
		_g_free0 (_tmp158_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp161_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ModuleInit");
	_tmp162_ = _vala_code_node_ref0 (_tmp161_);
	init_attr = _tmp162_;
	_tmp163_ = init_attr;
	if (_tmp163_ != NULL) {
		ValaSourceReference* _tmp164_;
		ValaSourceReference* _tmp165_;
		ValaSourceFile* _tmp166_;
		ValaSourceFile* _tmp167_;
		ValaCodeContext* _tmp168_;
		ValaCodeContext* _tmp169_;
		_tmp164_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp165_ = _tmp164_;
		_tmp166_ = vala_source_reference_get_file (_tmp165_);
		_tmp167_ = _tmp166_;
		_tmp168_ = vala_source_file_get_context (_tmp167_);
		_tmp169_ = _tmp168_;
		vala_code_context_set_module_init_method (_tmp169_, self);
	}
	_tmp170_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp171_ = _tmp170_;
	if (_tmp171_ != NULL) {
		ValaDataType* _tmp172_;
		ValaDataType* _tmp173_;
		_tmp172_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp173_ = _tmp172_;
		vala_code_node_check ((ValaCodeNode*) _tmp173_, context);
	}
	_tmp177_ = self->priv->parameters;
	_tmp178_ = vala_collection_get_size ((ValaCollection*) _tmp177_);
	_tmp179_ = _tmp178_;
	if (_tmp179_ == 1) {
		ValaList* _tmp180_;
		gpointer _tmp181_;
		ValaParameter* _tmp182_;
		gboolean _tmp183_;
		gboolean _tmp184_;
		_tmp180_ = self->priv->parameters;
		_tmp181_ = vala_list_get (_tmp180_, 0);
		_tmp182_ = (ValaParameter*) _tmp181_;
		_tmp183_ = vala_parameter_get_ellipsis (_tmp182_);
		_tmp184_ = _tmp183_;
		_tmp176_ = _tmp184_;
		_vala_code_node_unref0 (_tmp182_);
	} else {
		_tmp176_ = FALSE;
	}
	if (_tmp176_) {
		ValaBlock* _tmp185_;
		ValaBlock* _tmp186_;
		_tmp185_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp186_ = _tmp185_;
		_tmp175_ = _tmp186_ != NULL;
	} else {
		_tmp175_ = FALSE;
	}
	if (_tmp175_) {
		ValaMemberBinding _tmp187_;
		_tmp187_ = self->priv->_binding;
		_tmp174_ = _tmp187_ != VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp174_ = FALSE;
	}
	if (_tmp174_) {
		ValaList* _tmp188_;
		gpointer _tmp189_;
		ValaParameter* _tmp190_;
		ValaSourceReference* _tmp191_;
		ValaSourceReference* _tmp192_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp188_ = self->priv->parameters;
		_tmp189_ = vala_list_get (_tmp188_, 0);
		_tmp190_ = (ValaParameter*) _tmp189_;
		_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp190_);
		_tmp192_ = _tmp191_;
		vala_report_error (_tmp192_, "Named parameter required before `...'");
		_vala_code_node_unref0 (_tmp190_);
	}
	_tmp194_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Print");
	if (_tmp194_ != NULL) {
		gboolean _tmp195_ = FALSE;
		ValaList* _tmp196_;
		gint _tmp197_;
		gint _tmp198_;
		_tmp196_ = self->priv->parameters;
		_tmp197_ = vala_collection_get_size ((ValaCollection*) _tmp196_);
		_tmp198_ = _tmp197_;
		if (_tmp198_ != 1) {
			_tmp195_ = TRUE;
		} else {
			ValaList* _tmp199_;
			gpointer _tmp200_;
			ValaParameter* _tmp201_;
			ValaDataType* _tmp202_;
			ValaDataType* _tmp203_;
			ValaTypeSymbol* _tmp204_;
			ValaTypeSymbol* _tmp205_;
			ValaSemanticAnalyzer* _tmp206_;
			ValaSemanticAnalyzer* _tmp207_;
			ValaDataType* _tmp208_;
			ValaTypeSymbol* _tmp209_;
			ValaTypeSymbol* _tmp210_;
			_tmp199_ = self->priv->parameters;
			_tmp200_ = vala_list_get (_tmp199_, 0);
			_tmp201_ = (ValaParameter*) _tmp200_;
			_tmp202_ = vala_variable_get_variable_type ((ValaVariable*) _tmp201_);
			_tmp203_ = _tmp202_;
			_tmp204_ = vala_data_type_get_type_symbol (_tmp203_);
			_tmp205_ = _tmp204_;
			_tmp206_ = vala_code_context_get_analyzer (context);
			_tmp207_ = _tmp206_;
			_tmp208_ = _tmp207_->string_type;
			_tmp209_ = vala_data_type_get_type_symbol (_tmp208_);
			_tmp210_ = _tmp209_;
			_tmp195_ = _tmp205_ != _tmp210_;
			_vala_code_node_unref0 (_tmp201_);
		}
		_tmp193_ = _tmp195_;
	} else {
		_tmp193_ = FALSE;
	}
	if (_tmp193_) {
		ValaSourceReference* _tmp211_;
		ValaSourceReference* _tmp212_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp211_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp212_ = _tmp211_;
		vala_report_error (_tmp212_, "[Print] methods must have exactly one parameter of type `string'");
	}
	optional_param = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp213_;
		ValaList* _tmp214_;
		gint _param_size = 0;
		ValaList* _tmp215_;
		gint _tmp216_;
		gint _tmp217_;
		gint _param_index = 0;
		_tmp213_ = self->priv->parameters;
		_tmp214_ = _vala_iterable_ref0 (_tmp213_);
		_param_list = _tmp214_;
		_tmp215_ = _param_list;
		_tmp216_ = vala_collection_get_size ((ValaCollection*) _tmp215_);
		_tmp217_ = _tmp216_;
		_param_size = _tmp217_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp218_;
			gpointer _tmp219_;
			ValaParameter* _tmp220_;
			gboolean _tmp221_ = FALSE;
			gboolean _tmp222_;
			gboolean _tmp229_ = FALSE;
			gboolean _tmp230_ = FALSE;
			gboolean _tmp231_;
			gboolean _tmp232_;
			gboolean _tmp251_;
			gboolean _tmp252_ = FALSE;
			gboolean _tmp253_ = FALSE;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp218_ = _param_list;
			_tmp219_ = vala_list_get (_tmp218_, _param_index);
			param = (ValaParameter*) _tmp219_;
			_tmp220_ = param;
			vala_code_node_check ((ValaCodeNode*) _tmp220_, context);
			_tmp222_ = self->priv->_coroutine;
			if (_tmp222_) {
				ValaParameter* _tmp223_;
				ValaParameterDirection _tmp224_;
				ValaParameterDirection _tmp225_;
				_tmp223_ = param;
				_tmp224_ = vala_parameter_get_direction (_tmp223_);
				_tmp225_ = _tmp224_;
				_tmp221_ = _tmp225_ == VALA_PARAMETER_DIRECTION_REF;
			} else {
				_tmp221_ = FALSE;
			}
			if (_tmp221_) {
				ValaParameter* _tmp226_;
				ValaSourceReference* _tmp227_;
				ValaSourceReference* _tmp228_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp226_ = param;
				_tmp227_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp226_);
				_tmp228_ = _tmp227_;
				vala_report_error (_tmp228_, "Reference parameters are not supported for async methods");
			}
			_tmp231_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp232_ = _tmp231_;
			if (!_tmp232_) {
				gboolean _tmp233_;
				_tmp233_ = self->priv->_coroutine;
				_tmp230_ = _tmp233_;
			} else {
				_tmp230_ = FALSE;
			}
			if (_tmp230_) {
				gboolean _tmp234_ = FALSE;
				ValaParameter* _tmp235_;
				gboolean _tmp236_;
				gboolean _tmp237_;
				_tmp235_ = param;
				_tmp236_ = vala_parameter_get_ellipsis (_tmp235_);
				_tmp237_ = _tmp236_;
				if (_tmp237_) {
					_tmp234_ = TRUE;
				} else {
					ValaParameter* _tmp238_;
					ValaDataType* _tmp239_;
					ValaDataType* _tmp240_;
					ValaTypeSymbol* _tmp241_;
					ValaTypeSymbol* _tmp242_;
					ValaSemanticAnalyzer* _tmp243_;
					ValaSemanticAnalyzer* _tmp244_;
					ValaDataType* _tmp245_;
					ValaTypeSymbol* _tmp246_;
					ValaTypeSymbol* _tmp247_;
					_tmp238_ = param;
					_tmp239_ = vala_variable_get_variable_type ((ValaVariable*) _tmp238_);
					_tmp240_ = _tmp239_;
					_tmp241_ = vala_data_type_get_type_symbol (_tmp240_);
					_tmp242_ = _tmp241_;
					_tmp243_ = vala_code_context_get_analyzer (context);
					_tmp244_ = _tmp243_;
					_tmp245_ = _tmp244_->va_list_type;
					_tmp246_ = vala_data_type_get_type_symbol (_tmp245_);
					_tmp247_ = _tmp246_;
					_tmp234_ = _tmp242_ == _tmp247_;
				}
				_tmp229_ = _tmp234_;
			} else {
				_tmp229_ = FALSE;
			}
			if (_tmp229_) {
				ValaParameter* _tmp248_;
				ValaSourceReference* _tmp249_;
				ValaSourceReference* _tmp250_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp248_ = param;
				_tmp249_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp248_);
				_tmp250_ = _tmp249_;
				vala_report_error (_tmp250_, "Variadic parameters are not supported for async methods");
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp251_ = self->priv->_coroutine;
			if (_tmp251_) {
				_vala_code_node_unref0 (param);
				continue;
			}
			if (optional_param) {
				ValaParameter* _tmp254_;
				ValaExpression* _tmp255_;
				ValaExpression* _tmp256_;
				_tmp254_ = param;
				_tmp255_ = vala_variable_get_initializer ((ValaVariable*) _tmp254_);
				_tmp256_ = _tmp255_;
				_tmp253_ = _tmp256_ == NULL;
			} else {
				_tmp253_ = FALSE;
			}
			if (_tmp253_) {
				ValaParameter* _tmp257_;
				gboolean _tmp258_;
				gboolean _tmp259_;
				_tmp257_ = param;
				_tmp258_ = vala_parameter_get_ellipsis (_tmp257_);
				_tmp259_ = _tmp258_;
				_tmp252_ = !_tmp259_;
			} else {
				_tmp252_ = FALSE;
			}
			if (_tmp252_) {
				ValaParameter* _tmp260_;
				ValaSourceReference* _tmp261_;
				ValaSourceReference* _tmp262_;
				_tmp260_ = param;
				_tmp261_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp260_);
				_tmp262_ = _tmp261_;
				vala_report_warning (_tmp262_, "parameter without default follows parameter with default");
			} else {
				ValaParameter* _tmp263_;
				ValaExpression* _tmp264_;
				ValaExpression* _tmp265_;
				_tmp263_ = param;
				_tmp264_ = vala_variable_get_initializer ((ValaVariable*) _tmp263_);
				_tmp265_ = _tmp264_;
				if (_tmp265_ != NULL) {
					optional_param = TRUE;
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp266_ = self->priv->_coroutine;
	if (_tmp266_) {
		gboolean requires_pointer = FALSE;
		requires_pointer = FALSE;
		{
			gint i = 0;
			ValaList* _tmp267_;
			gint _tmp268_;
			gint _tmp269_;
			_tmp267_ = self->priv->parameters;
			_tmp268_ = vala_collection_get_size ((ValaCollection*) _tmp267_);
			_tmp269_ = _tmp268_;
			i = _tmp269_ - 1;
			{
				gboolean _tmp270_ = FALSE;
				_tmp270_ = TRUE;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp272_;
					gpointer _tmp273_;
					ValaParameter* _tmp274_;
					ValaParameterDirection _tmp275_;
					ValaParameterDirection _tmp276_;
					if (!_tmp270_) {
						gint _tmp271_;
						_tmp271_ = i;
						i = _tmp271_ - 1;
					}
					_tmp270_ = FALSE;
					if (!(i >= 0)) {
						break;
					}
					_tmp272_ = self->priv->parameters;
					_tmp273_ = vala_list_get (_tmp272_, i);
					param = (ValaParameter*) _tmp273_;
					_tmp274_ = param;
					_tmp275_ = vala_parameter_get_direction (_tmp274_);
					_tmp276_ = _tmp275_;
					if (_tmp276_ == VALA_PARAMETER_DIRECTION_IN) {
						requires_pointer = TRUE;
					} else {
						if (requires_pointer) {
							ValaParameter* _tmp277_;
							ValaSourceReference* _tmp278_;
							ValaSourceReference* _tmp279_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp277_ = param;
							_tmp278_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp277_);
							_tmp279_ = _tmp278_;
							vala_report_error (_tmp279_, "Synchronous out-parameters are not supported in async methods");
						}
					}
					_vala_code_node_unref0 (param);
				}
			}
		}
	}
	_tmp280_ = self->error_types;
	if (_tmp280_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp281_;
			ValaList* _tmp282_;
			gint _error_type_size = 0;
			ValaList* _tmp283_;
			gint _tmp284_;
			gint _tmp285_;
			gint _error_type_index = 0;
			_tmp281_ = self->error_types;
			_tmp282_ = _vala_iterable_ref0 (_tmp281_);
			_error_type_list = _tmp282_;
			_tmp283_ = _error_type_list;
			_tmp284_ = vala_collection_get_size ((ValaCollection*) _tmp283_);
			_tmp285_ = _tmp284_;
			_error_type_size = _tmp285_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp286_;
				gpointer _tmp287_;
				ValaDataType* _tmp288_;
				ValaSemanticAnalyzer* _tmp289_;
				ValaSemanticAnalyzer* _tmp290_;
				ValaDataType* _tmp291_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp286_ = _error_type_list;
				_tmp287_ = vala_list_get (_tmp286_, _error_type_index);
				error_type = (ValaDataType*) _tmp287_;
				_tmp288_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp288_, context);
				_tmp289_ = vala_code_context_get_analyzer (context);
				_tmp290_ = _tmp289_;
				_tmp291_ = error_type;
				if (!vala_semantic_analyzer_is_type_accessible (_tmp290_, (ValaSymbol*) self, _tmp291_)) {
					ValaSourceReference* _tmp292_;
					ValaSourceReference* _tmp293_;
					ValaDataType* _tmp294_;
					gchar* _tmp295_;
					gchar* _tmp296_;
					gchar* _tmp297_;
					gchar* _tmp298_;
					gchar* _tmp299_;
					gchar* _tmp300_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp292_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp293_ = _tmp292_;
					_tmp294_ = error_type;
					_tmp295_ = vala_code_node_to_string ((ValaCodeNode*) _tmp294_);
					_tmp296_ = _tmp295_;
					_tmp297_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp298_ = _tmp297_;
					_tmp299_ = g_strdup_printf ("error type `%s' is less accessible than method `%s'", _tmp296_, _tmp298_);
					_tmp300_ = _tmp299_;
					vala_report_error (_tmp293_, _tmp300_);
					_g_free0 (_tmp300_);
					_g_free0 (_tmp298_);
					_g_free0 (_tmp296_);
					result = FALSE;
					_vala_code_node_unref0 (error_type);
					_vala_iterable_unref0 (_error_type_list);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	_tmp301_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp302_ = _tmp301_;
	if (_tmp302_ != NULL) {
		ValaLocalVariable* _tmp303_;
		ValaLocalVariable* _tmp304_;
		_tmp303_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp304_ = _tmp303_;
		vala_code_node_check ((ValaCodeNode*) _tmp304_, context);
	}
	_tmp305_ = self->priv->preconditions;
	if (_tmp305_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp306_;
			ValaList* _tmp307_;
			gint _precondition_size = 0;
			ValaList* _tmp308_;
			gint _tmp309_;
			gint _tmp310_;
			gint _precondition_index = 0;
			_tmp306_ = self->priv->preconditions;
			_tmp307_ = _vala_iterable_ref0 (_tmp306_);
			_precondition_list = _tmp307_;
			_tmp308_ = _precondition_list;
			_tmp309_ = vala_collection_get_size ((ValaCollection*) _tmp308_);
			_tmp310_ = _tmp309_;
			_precondition_size = _tmp310_;
			_precondition_index = -1;
			while (TRUE) {
				ValaExpression* precondition = NULL;
				ValaList* _tmp311_;
				gpointer _tmp312_;
				ValaExpression* _tmp313_;
				_precondition_index = _precondition_index + 1;
				if (!(_precondition_index < _precondition_size)) {
					break;
				}
				_tmp311_ = _precondition_list;
				_tmp312_ = vala_list_get (_tmp311_, _precondition_index);
				precondition = (ValaExpression*) _tmp312_;
				_tmp313_ = precondition;
				vala_code_node_check ((ValaCodeNode*) _tmp313_, context);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp314_ = self->priv->postconditions;
	if (_tmp314_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp315_;
			ValaList* _tmp316_;
			gint _postcondition_size = 0;
			ValaList* _tmp317_;
			gint _tmp318_;
			gint _tmp319_;
			gint _postcondition_index = 0;
			_tmp315_ = self->priv->postconditions;
			_tmp316_ = _vala_iterable_ref0 (_tmp315_);
			_postcondition_list = _tmp316_;
			_tmp317_ = _postcondition_list;
			_tmp318_ = vala_collection_get_size ((ValaCollection*) _tmp317_);
			_tmp319_ = _tmp318_;
			_postcondition_size = _tmp319_;
			_postcondition_index = -1;
			while (TRUE) {
				ValaExpression* postcondition = NULL;
				ValaList* _tmp320_;
				gpointer _tmp321_;
				ValaExpression* _tmp322_;
				_postcondition_index = _postcondition_index + 1;
				if (!(_postcondition_index < _postcondition_size)) {
					break;
				}
				_tmp320_ = _postcondition_list;
				_tmp321_ = vala_list_get (_tmp320_, _postcondition_index);
				postcondition = (ValaExpression*) _tmp321_;
				_tmp322_ = postcondition;
				vala_code_node_check ((ValaCodeNode*) _tmp322_, context);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp323_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp324_ = _tmp323_;
	if (_tmp324_ != NULL) {
		ValaBlock* _tmp325_;
		ValaBlock* _tmp326_;
		_tmp325_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp326_ = _tmp325_;
		vala_code_node_check ((ValaCodeNode*) _tmp326_, context);
	}
	_tmp327_ = vala_code_context_get_analyzer (context);
	_tmp328_ = _tmp327_;
	_tmp329_ = vala_semantic_analyzer_get_current_struct (_tmp328_);
	_tmp330_ = _tmp329_;
	if (_tmp330_ != NULL) {
		gboolean _tmp331_ = FALSE;
		gboolean _tmp332_ = FALSE;
		gboolean _tmp333_;
		_tmp333_ = self->priv->_is_abstract;
		if (_tmp333_) {
			_tmp332_ = TRUE;
		} else {
			gboolean _tmp334_;
			_tmp334_ = self->priv->_is_virtual;
			_tmp332_ = _tmp334_;
		}
		if (_tmp332_) {
			_tmp331_ = TRUE;
		} else {
			gboolean _tmp335_;
			_tmp335_ = self->priv->_overrides;
			_tmp331_ = _tmp335_;
		}
		if (_tmp331_) {
			ValaSourceReference* _tmp336_;
			ValaSourceReference* _tmp337_;
			gchar* _tmp338_;
			gchar* _tmp339_;
			gchar* _tmp340_;
			gchar* _tmp341_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp336_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp337_ = _tmp336_;
			_tmp338_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp339_ = _tmp338_;
			_tmp340_ = g_strdup_printf ("A struct member `%s' cannot be marked as override, virtual, or abstrac" \
"t", _tmp339_);
			_tmp341_ = _tmp340_;
			vala_report_error (_tmp337_, _tmp341_);
			_g_free0 (_tmp341_);
			_g_free0 (_tmp339_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	} else {
		gboolean _tmp342_ = FALSE;
		gboolean _tmp343_ = FALSE;
		gboolean _tmp344_;
		_tmp344_ = self->priv->_overrides;
		if (_tmp344_) {
			ValaMethod* _tmp345_;
			ValaMethod* _tmp346_;
			_tmp345_ = vala_method_get_base_method (self);
			_tmp346_ = _tmp345_;
			_tmp343_ = _tmp346_ == NULL;
		} else {
			_tmp343_ = FALSE;
		}
		if (_tmp343_) {
			ValaMethod* _tmp347_;
			ValaMethod* _tmp348_;
			_tmp347_ = vala_method_get_base_interface_method (self);
			_tmp348_ = _tmp347_;
			_tmp342_ = _tmp348_ == NULL;
		} else {
			_tmp342_ = FALSE;
		}
		if (_tmp342_) {
			ValaSourceReference* _tmp349_;
			ValaSourceReference* _tmp350_;
			gchar* _tmp351_;
			gchar* _tmp352_;
			gchar* _tmp353_;
			gchar* _tmp354_;
			_tmp349_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp350_ = _tmp349_;
			_tmp351_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp352_ = _tmp351_;
			_tmp353_ = g_strdup_printf ("`%s': no suitable method found to override", _tmp352_);
			_tmp354_ = _tmp353_;
			vala_report_error (_tmp350_, _tmp354_);
			_g_free0 (_tmp354_);
			_g_free0 (_tmp352_);
		} else {
			gboolean _tmp355_ = FALSE;
			gboolean _tmp356_ = FALSE;
			gboolean _tmp357_ = FALSE;
			gboolean _tmp358_;
			_tmp358_ = self->priv->_is_abstract;
			if (_tmp358_) {
				_tmp357_ = TRUE;
			} else {
				gboolean _tmp359_;
				_tmp359_ = self->priv->_is_virtual;
				_tmp357_ = _tmp359_;
			}
			if (_tmp357_) {
				_tmp356_ = TRUE;
			} else {
				gboolean _tmp360_;
				_tmp360_ = self->priv->_overrides;
				_tmp356_ = _tmp360_;
			}
			if (_tmp356_) {
				ValaSymbolAccessibility _tmp361_;
				ValaSymbolAccessibility _tmp362_;
				_tmp361_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp362_ = _tmp361_;
				_tmp355_ = _tmp362_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
			} else {
				_tmp355_ = FALSE;
			}
			if (_tmp355_) {
				ValaSourceReference* _tmp363_;
				ValaSourceReference* _tmp364_;
				gchar* _tmp365_;
				gchar* _tmp366_;
				gchar* _tmp367_;
				gchar* _tmp368_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp363_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp364_ = _tmp363_;
				_tmp365_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp366_ = _tmp365_;
				_tmp367_ = g_strdup_printf ("Private member `%s' cannot be marked as override, virtual, or abstract", _tmp366_);
				_tmp368_ = _tmp367_;
				vala_report_error (_tmp364_, _tmp368_);
				_g_free0 (_tmp368_);
				_g_free0 (_tmp366_);
				result = FALSE;
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
	}
	_tmp371_ = vala_method_get_base_interface_type (self);
	_tmp372_ = _tmp371_;
	if (_tmp372_ != NULL) {
		ValaMethod* _tmp373_;
		ValaMethod* _tmp374_;
		_tmp373_ = vala_method_get_base_interface_method (self);
		_tmp374_ = _tmp373_;
		_tmp370_ = _tmp374_ != NULL;
	} else {
		_tmp370_ = FALSE;
	}
	if (_tmp370_) {
		ValaSymbol* _tmp375_;
		ValaSymbol* _tmp376_;
		_tmp375_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp376_ = _tmp375_;
		_tmp369_ = VALA_IS_CLASS (_tmp376_);
	} else {
		_tmp369_ = FALSE;
	}
	if (_tmp369_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp377_;
		ValaSymbol* _tmp378_;
		_tmp377_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp378_ = _tmp377_;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp378_, VALA_TYPE_CLASS, ValaClass);
		{
			ValaList* _m_list = NULL;
			ValaClass* _tmp379_;
			ValaList* _tmp380_;
			ValaList* _tmp381_;
			gint _m_size = 0;
			ValaList* _tmp382_;
			gint _tmp383_;
			gint _tmp384_;
			gint _m_index = 0;
			_tmp379_ = cl;
			_tmp380_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp379_);
			_tmp381_ = _vala_iterable_ref0 (_tmp380_);
			_m_list = _tmp381_;
			_tmp382_ = _m_list;
			_tmp383_ = vala_collection_get_size ((ValaCollection*) _tmp382_);
			_tmp384_ = _tmp383_;
			_m_size = _tmp384_;
			_m_index = -1;
			while (TRUE) {
				ValaMethod* m = NULL;
				ValaList* _tmp385_;
				gpointer _tmp386_;
				gboolean _tmp387_ = FALSE;
				ValaMethod* _tmp388_;
				_m_index = _m_index + 1;
				if (!(_m_index < _m_size)) {
					break;
				}
				_tmp385_ = _m_list;
				_tmp386_ = vala_list_get (_tmp385_, _m_index);
				m = (ValaMethod*) _tmp386_;
				_tmp388_ = m;
				if (_tmp388_ != self) {
					ValaMethod* _tmp389_;
					ValaMethod* _tmp390_;
					ValaMethod* _tmp391_;
					ValaMethod* _tmp392_;
					ValaMethod* _tmp393_;
					_tmp389_ = m;
					_tmp390_ = vala_method_get_base_interface_method (_tmp389_);
					_tmp391_ = _tmp390_;
					_tmp392_ = vala_method_get_base_interface_method (self);
					_tmp393_ = _tmp392_;
					_tmp387_ = _tmp391_ == _tmp393_;
				} else {
					_tmp387_ = FALSE;
				}
				if (_tmp387_) {
					ValaMethod* _tmp394_;
					ValaMethod* _tmp395_;
					ValaSourceReference* _tmp396_;
					ValaSourceReference* _tmp397_;
					ValaClass* _tmp398_;
					gchar* _tmp399_;
					gchar* _tmp400_;
					ValaMethod* _tmp401_;
					ValaMethod* _tmp402_;
					gchar* _tmp403_;
					gchar* _tmp404_;
					gchar* _tmp405_;
					gchar* _tmp406_;
					ValaMethod* _tmp407_;
					ValaSourceReference* _tmp408_;
					ValaSourceReference* _tmp409_;
					ValaMethod* _tmp410_;
					ValaMethod* _tmp411_;
					gchar* _tmp412_;
					gchar* _tmp413_;
					gchar* _tmp414_;
					gchar* _tmp415_;
					_tmp394_ = m;
					vala_code_node_set_checked ((ValaCodeNode*) _tmp394_, TRUE);
					_tmp395_ = m;
					vala_code_node_set_error ((ValaCodeNode*) _tmp395_, TRUE);
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp396_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp397_ = _tmp396_;
					_tmp398_ = cl;
					_tmp399_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp398_);
					_tmp400_ = _tmp399_;
					_tmp401_ = vala_method_get_base_interface_method (self);
					_tmp402_ = _tmp401_;
					_tmp403_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp402_);
					_tmp404_ = _tmp403_;
					_tmp405_ = g_strdup_printf ("`%s' already contains an implementation for `%s'", _tmp400_, _tmp404_);
					_tmp406_ = _tmp405_;
					vala_report_error (_tmp397_, _tmp406_);
					_g_free0 (_tmp406_);
					_g_free0 (_tmp404_);
					_g_free0 (_tmp400_);
					_tmp407_ = m;
					_tmp408_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp407_);
					_tmp409_ = _tmp408_;
					_tmp410_ = vala_method_get_base_interface_method (self);
					_tmp411_ = _tmp410_;
					_tmp412_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp411_);
					_tmp413_ = _tmp412_;
					_tmp414_ = g_strdup_printf ("previous implementation of `%s' was here", _tmp413_);
					_tmp415_ = _tmp414_;
					vala_report_notice (_tmp409_, _tmp415_);
					_g_free0 (_tmp415_);
					_g_free0 (_tmp413_);
					result = FALSE;
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (_m_list);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
	}
	_tmp416_ = vala_code_context_get_analyzer (context);
	_tmp417_ = _tmp416_;
	_tmp418_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp417_, _tmp418_);
	_tmp419_ = vala_code_context_get_analyzer (context);
	_tmp420_ = _tmp419_;
	_tmp421_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp420_, _tmp421_);
	_tmp425_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp426_ = _tmp425_;
	if (!_tmp426_) {
		gboolean _tmp427_;
		_tmp427_ = self->priv->_overrides;
		_tmp424_ = !_tmp427_;
	} else {
		_tmp424_ = FALSE;
	}
	if (_tmp424_) {
		gboolean _tmp428_;
		gboolean _tmp429_;
		_tmp428_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp429_ = _tmp428_;
		_tmp423_ = !_tmp429_;
	} else {
		_tmp423_ = FALSE;
	}
	if (_tmp423_) {
		ValaSymbol* _tmp430_;
		ValaSymbol* _tmp431_;
		_tmp430_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp431_ = _tmp430_;
		_tmp422_ = _tmp431_ != NULL;
		_vala_code_node_unref0 (_tmp431_);
	} else {
		_tmp422_ = FALSE;
	}
	if (_tmp422_) {
		ValaSourceReference* _tmp432_;
		ValaSourceReference* _tmp433_;
		gchar* _tmp434_;
		gchar* _tmp435_;
		ValaSymbol* _tmp436_;
		ValaSymbol* _tmp437_;
		gchar* _tmp438_;
		gchar* _tmp439_;
		gchar* _tmp440_;
		gchar* _tmp441_;
		_tmp432_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp433_ = _tmp432_;
		_tmp434_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp435_ = _tmp434_;
		_tmp436_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp437_ = _tmp436_;
		_tmp438_ = vala_symbol_get_full_name (_tmp437_);
		_tmp439_ = _tmp438_;
		_tmp440_ = g_strdup_printf ("%s hides inherited method `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp435_, _tmp439_);
		_tmp441_ = _tmp440_;
		vala_report_warning (_tmp433_, _tmp441_);
		_g_free0 (_tmp441_);
		_g_free0 (_tmp439_);
		_vala_code_node_unref0 (_tmp437_);
		_g_free0 (_tmp435_);
	}
	_tmp442_ = vala_code_context_get_analyzer (context);
	_tmp443_ = _tmp442_;
	_tmp444_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp445_ = _tmp444_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp443_, (ValaSymbol*) self, _tmp445_)) {
		ValaSourceReference* _tmp446_;
		ValaSourceReference* _tmp447_;
		ValaDataType* _tmp448_;
		ValaDataType* _tmp449_;
		gchar* _tmp450_;
		gchar* _tmp451_;
		gchar* _tmp452_;
		gchar* _tmp453_;
		gchar* _tmp454_;
		gchar* _tmp455_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp446_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp447_ = _tmp446_;
		_tmp448_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp449_ = _tmp448_;
		_tmp450_ = vala_code_node_to_string ((ValaCodeNode*) _tmp449_);
		_tmp451_ = _tmp450_;
		_tmp452_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp453_ = _tmp452_;
		_tmp454_ = g_strdup_printf ("return type `%s' is less accessible than method `%s'", _tmp451_, _tmp453_);
		_tmp455_ = _tmp454_;
		vala_report_error (_tmp447_, _tmp455_);
		_g_free0 (_tmp455_);
		_g_free0 (_tmp453_);
		_g_free0 (_tmp451_);
		result = FALSE;
		_vala_code_node_unref0 (init_attr);
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp456_;
		ValaList* _tmp457_;
		gint _precondition_size = 0;
		ValaList* _tmp458_;
		gint _tmp459_;
		gint _tmp460_;
		gint _precondition_index = 0;
		_tmp456_ = vala_method_get_preconditions (self);
		_tmp457_ = _vala_iterable_ref0 (_tmp456_);
		_precondition_list = _tmp457_;
		_tmp458_ = _precondition_list;
		_tmp459_ = vala_collection_get_size ((ValaCollection*) _tmp458_);
		_tmp460_ = _tmp459_;
		_precondition_size = _tmp460_;
		_precondition_index = -1;
		while (TRUE) {
			ValaExpression* precondition = NULL;
			ValaList* _tmp461_;
			gpointer _tmp462_;
			ValaExpression* _tmp463_;
			gboolean _tmp464_;
			gboolean _tmp465_;
			ValaExpression* _tmp466_;
			ValaDataType* _tmp467_;
			ValaDataType* _tmp468_;
			ValaSemanticAnalyzer* _tmp469_;
			ValaSemanticAnalyzer* _tmp470_;
			ValaDataType* _tmp471_;
			_precondition_index = _precondition_index + 1;
			if (!(_precondition_index < _precondition_size)) {
				break;
			}
			_tmp461_ = _precondition_list;
			_tmp462_ = vala_list_get (_tmp461_, _precondition_index);
			precondition = (ValaExpression*) _tmp462_;
			_tmp463_ = precondition;
			_tmp464_ = vala_code_node_get_error ((ValaCodeNode*) _tmp463_);
			_tmp465_ = _tmp464_;
			if (_tmp465_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp466_ = precondition;
			_tmp467_ = vala_expression_get_value_type (_tmp466_);
			_tmp468_ = _tmp467_;
			_tmp469_ = vala_code_context_get_analyzer (context);
			_tmp470_ = _tmp469_;
			_tmp471_ = _tmp470_->bool_type;
			if (!vala_data_type_compatible (_tmp468_, _tmp471_)) {
				ValaExpression* _tmp472_;
				ValaSourceReference* _tmp473_;
				ValaSourceReference* _tmp474_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp472_ = precondition;
				_tmp473_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp472_);
				_tmp474_ = _tmp473_;
				vala_report_error (_tmp474_, "Precondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp475_;
		ValaList* _tmp476_;
		gint _postcondition_size = 0;
		ValaList* _tmp477_;
		gint _tmp478_;
		gint _tmp479_;
		gint _postcondition_index = 0;
		_tmp475_ = vala_method_get_postconditions (self);
		_tmp476_ = _vala_iterable_ref0 (_tmp475_);
		_postcondition_list = _tmp476_;
		_tmp477_ = _postcondition_list;
		_tmp478_ = vala_collection_get_size ((ValaCollection*) _tmp477_);
		_tmp479_ = _tmp478_;
		_postcondition_size = _tmp479_;
		_postcondition_index = -1;
		while (TRUE) {
			ValaExpression* postcondition = NULL;
			ValaList* _tmp480_;
			gpointer _tmp481_;
			ValaExpression* _tmp482_;
			gboolean _tmp483_;
			gboolean _tmp484_;
			ValaExpression* _tmp485_;
			ValaDataType* _tmp486_;
			ValaDataType* _tmp487_;
			ValaSemanticAnalyzer* _tmp488_;
			ValaSemanticAnalyzer* _tmp489_;
			ValaDataType* _tmp490_;
			_postcondition_index = _postcondition_index + 1;
			if (!(_postcondition_index < _postcondition_size)) {
				break;
			}
			_tmp480_ = _postcondition_list;
			_tmp481_ = vala_list_get (_tmp480_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp481_;
			_tmp482_ = postcondition;
			_tmp483_ = vala_code_node_get_error ((ValaCodeNode*) _tmp482_);
			_tmp484_ = _tmp483_;
			if (_tmp484_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp485_ = postcondition;
			_tmp486_ = vala_expression_get_value_type (_tmp485_);
			_tmp487_ = _tmp486_;
			_tmp488_ = vala_code_context_get_analyzer (context);
			_tmp489_ = _tmp488_;
			_tmp490_ = _tmp489_->bool_type;
			if (!vala_data_type_compatible (_tmp487_, _tmp490_)) {
				ValaExpression* _tmp491_;
				ValaSourceReference* _tmp492_;
				ValaSourceReference* _tmp493_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp491_ = postcondition;
				_tmp492_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp491_);
				_tmp493_ = _tmp492_;
				vala_report_error (_tmp493_, "Postcondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp495_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp496_ = _tmp495_;
	if (_tmp496_ != NULL) {
		ValaBlock* _tmp497_;
		ValaBlock* _tmp498_;
		gboolean _tmp499_;
		gboolean _tmp500_;
		_tmp497_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp498_ = _tmp497_;
		_tmp499_ = vala_code_node_get_error ((ValaCodeNode*) _tmp498_);
		_tmp500_ = _tmp499_;
		_tmp494_ = !_tmp500_;
	} else {
		_tmp494_ = FALSE;
	}
	if (_tmp494_) {
		ValaArrayList* body_errors = NULL;
		GEqualFunc _tmp501_;
		ValaArrayList* _tmp502_;
		ValaBlock* _tmp503_;
		ValaBlock* _tmp504_;
		ValaArrayList* _tmp505_;
		_tmp501_ = g_direct_equal;
		_tmp502_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp501_);
		body_errors = _tmp502_;
		_tmp503_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp504_ = _tmp503_;
		_tmp505_ = body_errors;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp504_, (ValaCollection*) _tmp505_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp506_;
			ValaArrayList* _tmp507_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp508_;
			gint _tmp509_;
			gint _tmp510_;
			gint _body_error_type_index = 0;
			_tmp506_ = body_errors;
			_tmp507_ = _vala_iterable_ref0 (_tmp506_);
			_body_error_type_list = _tmp507_;
			_tmp508_ = _body_error_type_list;
			_tmp509_ = vala_collection_get_size ((ValaCollection*) _tmp508_);
			_tmp510_ = _tmp509_;
			_body_error_type_size = _tmp510_;
			_body_error_type_index = -1;
			while (TRUE) {
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp511_;
				gpointer _tmp512_;
				gboolean can_propagate_error = FALSE;
				ValaList* _tmp513_;
				gboolean _tmp523_ = FALSE;
				ValaDataType* _tmp524_;
				gboolean is_dynamic_error = FALSE;
				gboolean _tmp528_ = FALSE;
				_body_error_type_index = _body_error_type_index + 1;
				if (!(_body_error_type_index < _body_error_type_size)) {
					break;
				}
				_tmp511_ = _body_error_type_list;
				_tmp512_ = vala_list_get ((ValaList*) _tmp511_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp512_;
				can_propagate_error = FALSE;
				_tmp513_ = self->error_types;
				if (_tmp513_ != NULL) {
					{
						ValaList* _method_error_type_list = NULL;
						ValaList* _tmp514_;
						ValaList* _tmp515_;
						gint _method_error_type_size = 0;
						ValaList* _tmp516_;
						gint _tmp517_;
						gint _tmp518_;
						gint _method_error_type_index = 0;
						_tmp514_ = self->error_types;
						_tmp515_ = _vala_iterable_ref0 (_tmp514_);
						_method_error_type_list = _tmp515_;
						_tmp516_ = _method_error_type_list;
						_tmp517_ = vala_collection_get_size ((ValaCollection*) _tmp516_);
						_tmp518_ = _tmp517_;
						_method_error_type_size = _tmp518_;
						_method_error_type_index = -1;
						while (TRUE) {
							ValaDataType* method_error_type = NULL;
							ValaList* _tmp519_;
							gpointer _tmp520_;
							ValaDataType* _tmp521_;
							ValaDataType* _tmp522_;
							_method_error_type_index = _method_error_type_index + 1;
							if (!(_method_error_type_index < _method_error_type_size)) {
								break;
							}
							_tmp519_ = _method_error_type_list;
							_tmp520_ = vala_list_get (_tmp519_, _method_error_type_index);
							method_error_type = (ValaDataType*) _tmp520_;
							_tmp521_ = body_error_type;
							_tmp522_ = method_error_type;
							if (vala_data_type_compatible (_tmp521_, _tmp522_)) {
								can_propagate_error = TRUE;
							}
							_vala_code_node_unref0 (method_error_type);
						}
						_vala_iterable_unref0 (_method_error_type_list);
					}
				}
				_tmp524_ = body_error_type;
				if (VALA_IS_ERROR_TYPE (_tmp524_)) {
					ValaDataType* _tmp525_;
					gboolean _tmp526_;
					gboolean _tmp527_;
					_tmp525_ = body_error_type;
					_tmp526_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp525_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp527_ = _tmp526_;
					_tmp523_ = _tmp527_;
				} else {
					_tmp523_ = FALSE;
				}
				is_dynamic_error = _tmp523_;
				if (!can_propagate_error) {
					_tmp528_ = !is_dynamic_error;
				} else {
					_tmp528_ = FALSE;
				}
				if (_tmp528_) {
					ValaDataType* _tmp529_;
					ValaSourceReference* _tmp530_;
					ValaSourceReference* _tmp531_;
					ValaDataType* _tmp532_;
					gchar* _tmp533_;
					gchar* _tmp534_;
					gchar* _tmp535_;
					gchar* _tmp536_;
					_tmp529_ = body_error_type;
					_tmp530_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp529_);
					_tmp531_ = _tmp530_;
					_tmp532_ = body_error_type;
					_tmp533_ = vala_code_node_to_string ((ValaCodeNode*) _tmp532_);
					_tmp534_ = _tmp533_;
					_tmp535_ = g_strdup_printf ("unhandled error `%s'", _tmp534_);
					_tmp536_ = _tmp535_;
					vala_report_warning (_tmp531_, _tmp536_);
					_g_free0 (_tmp536_);
					_g_free0 (_tmp534_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
		_vala_iterable_unref0 (body_errors);
	}
	if (!VALA_IS_CREATION_METHOD (self)) {
		ValaMemberBinding _tmp542_;
		_tmp542_ = self->priv->_binding;
		_tmp541_ = _tmp542_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp541_ = FALSE;
	}
	if (_tmp541_) {
		gboolean _tmp543_;
		_tmp543_ = self->priv->_overrides;
		_tmp540_ = !_tmp543_;
	} else {
		_tmp540_ = FALSE;
	}
	if (_tmp540_) {
		ValaSymbolAccessibility _tmp544_;
		ValaSymbolAccessibility _tmp545_;
		_tmp544_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp545_ = _tmp544_;
		_tmp539_ = _tmp545_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	} else {
		_tmp539_ = FALSE;
	}
	if (_tmp539_) {
		ValaSymbol* _tmp546_;
		ValaSymbol* _tmp547_;
		_tmp546_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp547_ = _tmp546_;
		_tmp538_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp547_);
	} else {
		_tmp538_ = FALSE;
	}
	if (_tmp538_) {
		ValaSymbol* _tmp548_;
		ValaSymbol* _tmp549_;
		ValaAttribute* _tmp550_;
		_tmp548_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp549_ = _tmp548_;
		_tmp550_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp549_, "DBus");
		_tmp537_ = _tmp550_ != NULL;
	} else {
		_tmp537_ = FALSE;
	}
	if (_tmp537_) {
		ValaAttribute* dbus_attr = NULL;
		ValaAttribute* _tmp551_;
		ValaAttribute* _tmp552_;
		gboolean _tmp553_ = FALSE;
		ValaAttribute* _tmp554_;
		_tmp551_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DBus");
		_tmp552_ = _vala_code_node_ref0 (_tmp551_);
		dbus_attr = _tmp552_;
		_tmp554_ = dbus_attr;
		if (_tmp554_ == NULL) {
			_tmp553_ = TRUE;
		} else {
			ValaAttribute* _tmp555_;
			_tmp555_ = dbus_attr;
			_tmp553_ = vala_attribute_get_bool (_tmp555_, "visible", TRUE);
		}
		if (_tmp553_) {
			gboolean throws_gerror = FALSE;
			gboolean throws_gioerror = FALSE;
			gboolean throws_gdbuserror = FALSE;
			ValaArrayList* error_types = NULL;
			GEqualFunc _tmp556_;
			ValaArrayList* _tmp557_;
			ValaArrayList* _tmp558_;
			gboolean _tmp575_ = FALSE;
			throws_gerror = FALSE;
			throws_gioerror = FALSE;
			throws_gdbuserror = FALSE;
			_tmp556_ = g_direct_equal;
			_tmp557_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp556_);
			error_types = _tmp557_;
			_tmp558_ = error_types;
			vala_code_node_get_error_types ((ValaCodeNode*) self, (ValaCollection*) _tmp558_, NULL);
			{
				ValaArrayList* _error_type_list = NULL;
				ValaArrayList* _tmp559_;
				ValaArrayList* _tmp560_;
				gint _error_type_size = 0;
				ValaArrayList* _tmp561_;
				gint _tmp562_;
				gint _tmp563_;
				gint _error_type_index = 0;
				_tmp559_ = error_types;
				_tmp560_ = _vala_iterable_ref0 (_tmp559_);
				_error_type_list = _tmp560_;
				_tmp561_ = _error_type_list;
				_tmp562_ = vala_collection_get_size ((ValaCollection*) _tmp561_);
				_tmp563_ = _tmp562_;
				_error_type_size = _tmp563_;
				_error_type_index = -1;
				while (TRUE) {
					ValaDataType* error_type = NULL;
					ValaArrayList* _tmp564_;
					gpointer _tmp565_;
					ValaDataType* _tmp566_;
					ValaErrorDomain* error_domain = NULL;
					ValaDataType* _tmp567_;
					ValaErrorDomain* _tmp568_;
					ValaErrorDomain* _tmp569_;
					ValaErrorDomain* _tmp570_;
					gchar* full_error_domain = NULL;
					ValaErrorDomain* _tmp571_;
					gchar* _tmp572_;
					const gchar* _tmp573_;
					_error_type_index = _error_type_index + 1;
					if (!(_error_type_index < _error_type_size)) {
						break;
					}
					_tmp564_ = _error_type_list;
					_tmp565_ = vala_list_get ((ValaList*) _tmp564_, _error_type_index);
					error_type = (ValaDataType*) _tmp565_;
					_tmp566_ = error_type;
					if (!VALA_IS_ERROR_TYPE (_tmp566_)) {
						_vala_code_node_unref0 (error_type);
						continue;
					}
					_tmp567_ = error_type;
					_tmp568_ = vala_error_type_get_error_domain (G_TYPE_CHECK_INSTANCE_CAST (_tmp567_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp569_ = _tmp568_;
					error_domain = _tmp569_;
					_tmp570_ = error_domain;
					if (_tmp570_ == NULL) {
						throws_gerror = TRUE;
						_vala_code_node_unref0 (error_type);
						break;
					}
					_tmp571_ = error_domain;
					_tmp572_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp571_);
					full_error_domain = _tmp572_;
					_tmp573_ = full_error_domain;
					if (g_strcmp0 (_tmp573_, "GLib.IOError") == 0) {
						throws_gioerror = TRUE;
					} else {
						const gchar* _tmp574_;
						_tmp574_ = full_error_domain;
						if (g_strcmp0 (_tmp574_, "GLib.DBusError") == 0) {
							throws_gdbuserror = TRUE;
						}
					}
					_g_free0 (full_error_domain);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
			if (!throws_gerror) {
				gboolean _tmp576_ = FALSE;
				if (throws_gioerror) {
					_tmp576_ = throws_gdbuserror;
				} else {
					_tmp576_ = FALSE;
				}
				_tmp575_ = !_tmp576_;
			} else {
				_tmp575_ = FALSE;
			}
			if (_tmp575_) {
				ValaSourceReference* _tmp577_;
				ValaSourceReference* _tmp578_;
				_tmp577_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp578_ = _tmp577_;
				vala_report_warning (_tmp578_, "DBus methods are recommended to throw at least `GLib.Error' or `GLib.D" \
"BusError, GLib.IOError'");
			}
			_vala_iterable_unref0 (error_types);
		}
		_vala_code_node_unref0 (dbus_attr);
	}
	if (vala_method_is_possible_entry_point (self, context)) {
		ValaMethod* _tmp579_;
		ValaMethod* _tmp580_;
		gboolean _tmp589_;
		gboolean _tmp590_;
		gboolean _tmp593_;
		gboolean _tmp596_;
		_tmp579_ = vala_code_context_get_entry_point (context);
		_tmp580_ = _tmp579_;
		if (_tmp580_ != NULL) {
			ValaSourceReference* _tmp581_;
			ValaSourceReference* _tmp582_;
			ValaMethod* _tmp583_;
			ValaMethod* _tmp584_;
			gchar* _tmp585_;
			gchar* _tmp586_;
			gchar* _tmp587_;
			gchar* _tmp588_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp581_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp582_ = _tmp581_;
			_tmp583_ = vala_code_context_get_entry_point (context);
			_tmp584_ = _tmp583_;
			_tmp585_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp584_);
			_tmp586_ = _tmp585_;
			_tmp587_ = g_strdup_printf ("program already has an entry point `%s'", _tmp586_);
			_tmp588_ = _tmp587_;
			vala_report_error (_tmp582_, _tmp588_);
			_g_free0 (_tmp588_);
			_g_free0 (_tmp586_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		vala_method_set_entry_point (self, TRUE);
		vala_code_context_set_entry_point (context, self);
		_tmp589_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp590_ = _tmp589_;
		if (_tmp590_) {
			ValaSourceReference* _tmp591_;
			ValaSourceReference* _tmp592_;
			_tmp591_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp592_ = _tmp591_;
			vala_report_error (_tmp592_, "\"main\" method cannot throw errors");
		}
		_tmp593_ = self->priv->_is_inline;
		if (_tmp593_) {
			ValaSourceReference* _tmp594_;
			ValaSourceReference* _tmp595_;
			_tmp594_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp595_ = _tmp594_;
			vala_report_error (_tmp595_, "\"main\" method cannot be inline");
		}
		_tmp596_ = self->priv->_coroutine;
		if (_tmp596_) {
			ValaSourceReference* _tmp597_;
			ValaSourceReference* _tmp598_;
			_tmp597_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp598_ = _tmp597_;
			vala_report_error (_tmp598_, "\"main\" method cannot be async");
		}
	}
	_tmp599_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "GtkCallback");
	if (_tmp599_ != NULL) {
		vala_symbol_set_used ((ValaSymbol*) self, TRUE);
	}
	_tmp600_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp601_ = _tmp600_;
	result = !_tmp601_;
	_vala_code_node_unref0 (init_attr);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static gboolean
vala_method_is_possible_entry_point (ValaMethod* self,
                                     ValaCodeContext* context)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaMemberBinding _tmp14_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaList* params = NULL;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	ValaList* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	ValaList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	ValaIterator* params_it = NULL;
	ValaList* _tmp34_;
	ValaIterator* _tmp35_;
	ValaIterator* _tmp36_;
	ValaParameter* param = NULL;
	ValaIterator* _tmp37_;
	gpointer _tmp38_;
	ValaParameter* _tmp39_;
	ValaParameterDirection _tmp40_;
	ValaParameterDirection _tmp41_;
	ValaParameter* _tmp42_;
	ValaDataType* _tmp43_;
	ValaDataType* _tmp44_;
	ValaArrayType* array_type = NULL;
	ValaParameter* _tmp45_;
	ValaDataType* _tmp46_;
	ValaDataType* _tmp47_;
	ValaArrayType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaTypeSymbol* _tmp51_;
	ValaTypeSymbol* _tmp52_;
	ValaSemanticAnalyzer* _tmp53_;
	ValaSemanticAnalyzer* _tmp54_;
	ValaDataType* _tmp55_;
	ValaTypeSymbol* _tmp56_;
	ValaTypeSymbol* _tmp57_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_code_context_get_entry_point_name (context);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp8_ = _tmp7_;
			_tmp4_ = g_strcmp0 (_tmp8_, "main") != 0;
		}
		if (_tmp4_) {
			result = FALSE;
			return result;
		}
	} else {
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean _tmp13_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_context_get_entry_point_name (context);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strcmp0 (_tmp10_, _tmp12_) != 0;
		_g_free0 (_tmp10_);
		if (_tmp13_) {
			result = FALSE;
			return result;
		}
	}
	_tmp14_ = self->priv->_binding;
	if (_tmp14_ == VALA_MEMBER_BINDING_INSTANCE) {
		result = FALSE;
		return result;
	}
	_tmp15_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp16_ = _tmp15_;
	if (VALA_IS_VOID_TYPE (_tmp16_)) {
	} else {
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaTypeSymbol* _tmp19_;
		ValaTypeSymbol* _tmp20_;
		ValaSemanticAnalyzer* _tmp21_;
		ValaSemanticAnalyzer* _tmp22_;
		ValaDataType* _tmp23_;
		ValaTypeSymbol* _tmp24_;
		ValaTypeSymbol* _tmp25_;
		_tmp17_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_data_type_get_type_symbol (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_context_get_analyzer (context);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_->int_type;
		_tmp24_ = vala_data_type_get_type_symbol (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp20_ == _tmp25_) {
		} else {
			result = FALSE;
			return result;
		}
	}
	_tmp26_ = vala_callable_get_parameters ((ValaCallable*) self);
	_tmp27_ = _vala_iterable_ref0 (_tmp26_);
	params = _tmp27_;
	_tmp28_ = params;
	_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ == 0) {
		result = TRUE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp31_ = params;
	_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
	_tmp33_ = _tmp32_;
	if (_tmp33_ > 1) {
		result = FALSE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp34_ = params;
	_tmp35_ = vala_iterable_iterator ((ValaIterable*) _tmp34_);
	params_it = _tmp35_;
	_tmp36_ = params_it;
	vala_iterator_next (_tmp36_);
	_tmp37_ = params_it;
	_tmp38_ = vala_iterator_get (_tmp37_);
	param = (ValaParameter*) _tmp38_;
	_tmp39_ = param;
	_tmp40_ = vala_parameter_get_direction (_tmp39_);
	_tmp41_ = _tmp40_;
	if (_tmp41_ == VALA_PARAMETER_DIRECTION_OUT) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp42_ = param;
	_tmp43_ = vala_variable_get_variable_type ((ValaVariable*) _tmp42_);
	_tmp44_ = _tmp43_;
	if (!VALA_IS_ARRAY_TYPE (_tmp44_)) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp45_ = param;
	_tmp46_ = vala_variable_get_variable_type ((ValaVariable*) _tmp45_);
	_tmp47_ = _tmp46_;
	array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
	_tmp48_ = array_type;
	_tmp49_ = vala_array_type_get_element_type (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_data_type_get_type_symbol (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_code_context_get_analyzer (context);
	_tmp54_ = _tmp53_;
	_tmp55_ = _tmp54_->string_type;
	_tmp56_ = vala_data_type_get_type_symbol (_tmp55_);
	_tmp57_ = _tmp56_;
	if (_tmp52_ != _tmp57_) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	result = TRUE;
	_vala_code_node_unref0 (param);
	_vala_iterator_unref0 (params_it);
	_vala_iterable_unref0 (params);
	return result;
}

gint
vala_method_get_required_arguments (ValaMethod* self)
{
	gint n = 0;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	n = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			gboolean _tmp7_ = FALSE;
			ValaParameter* _tmp8_;
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			gint _tmp14_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp8_ = param;
			_tmp9_ = vala_variable_get_initializer ((ValaVariable*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != NULL) {
				_tmp7_ = TRUE;
			} else {
				ValaParameter* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				_tmp11_ = param;
				_tmp12_ = vala_parameter_get_ellipsis (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp7_ = _tmp13_;
			}
			if (_tmp7_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp14_ = n;
			n = _tmp14_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = n;
	return result;
}

ValaMethod*
vala_method_get_end_method (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp32_;
	ValaMethod* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->end_method;
	if (_tmp1_ == NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		ValaMethod* _tmp31_;
		_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_method_new ("end", _tmp3_, _tmp5_, NULL);
		_vala_code_node_unref0 (self->priv->end_method);
		self->priv->end_method = _tmp6_;
		_tmp7_ = self->priv->end_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp8_ = self->priv->end_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp8_, TRUE);
		_tmp9_ = self->priv->end_method;
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp11_ = _tmp10_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp9_, _tmp11_);
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp12_;
			gint _param_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _param_index = 0;
			_tmp12_ = vala_method_get_async_end_parameters (self);
			_param_list = _tmp12_;
			_tmp13_ = _param_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_param_size = _tmp15_;
			_param_index = -1;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaList* _tmp16_;
				gpointer _tmp17_;
				ValaMethod* _tmp18_;
				ValaParameter* _tmp19_;
				ValaParameter* _tmp20_;
				ValaParameter* _tmp21_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp16_ = _param_list;
				_tmp17_ = vala_list_get (_tmp16_, _param_index);
				param = (ValaParameter*) _tmp17_;
				_tmp18_ = self->priv->end_method;
				_tmp19_ = param;
				_tmp20_ = vala_parameter_copy (_tmp19_);
				_tmp21_ = _tmp20_;
				vala_callable_add_parameter ((ValaCallable*) _tmp18_, _tmp21_);
				_vala_code_node_unref0 (_tmp21_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp22_;
			ValaList* _tmp23_;
			gint _param_size = 0;
			ValaList* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gint _param_index = 0;
			_tmp22_ = vala_method_get_type_parameters (self);
			_tmp23_ = _vala_iterable_ref0 (_tmp22_);
			_param_list = _tmp23_;
			_tmp24_ = _param_list;
			_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
			_tmp26_ = _tmp25_;
			_param_size = _tmp26_;
			_param_index = -1;
			while (TRUE) {
				ValaTypeParameter* param = NULL;
				ValaList* _tmp27_;
				gpointer _tmp28_;
				ValaMethod* _tmp29_;
				ValaTypeParameter* _tmp30_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp27_ = _param_list;
				_tmp28_ = vala_list_get (_tmp27_, _param_index);
				param = (ValaTypeParameter*) _tmp28_;
				_tmp29_ = self->priv->end_method;
				_tmp30_ = param;
				vala_method_add_type_parameter (_tmp29_, _tmp30_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp31_ = self->priv->end_method;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) _tmp31_, (ValaCodeNode*) self, "CCode", "async_result_pos");
	}
	_tmp32_ = self->priv->end_method;
	result = _tmp32_;
	return result;
}

ValaMethod*
vala_method_get_callback_method (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp24_;
	ValaMethod* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->callback_method;
	if (_tmp1_ == NULL) {
		ValaBooleanType* bool_type = NULL;
		ValaCodeContext* _tmp2_;
		ValaCodeContext* _tmp3_;
		ValaNamespace* _tmp4_;
		ValaNamespace* _tmp5_;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaStruct* _tmp9_;
		ValaBooleanType* _tmp10_;
		ValaBooleanType* _tmp11_;
		ValaBooleanType* _tmp12_;
		ValaBooleanType* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		ValaMethod* _tmp23_;
		_tmp2_ = vala_code_context_get ();
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_context_get_root (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_scope_lookup (_tmp7_, "bool");
		_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp10_ = vala_boolean_type_new (_tmp9_);
		_tmp11_ = _tmp10_;
		_vala_code_node_unref0 (_tmp9_);
		_vala_code_context_unref0 (_tmp3_);
		bool_type = _tmp11_;
		_tmp12_ = bool_type;
		vala_data_type_set_value_owned ((ValaDataType*) _tmp12_, TRUE);
		_tmp13_ = bool_type;
		_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_method_new ("callback", (ValaDataType*) _tmp13_, _tmp15_, NULL);
		_vala_code_node_unref0 (self->priv->callback_method);
		self->priv->callback_method = _tmp16_;
		_tmp17_ = self->priv->callback_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp17_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp18_ = self->priv->callback_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp18_, TRUE);
		_tmp19_ = self->priv->callback_method;
		vala_method_set_binding (_tmp19_, VALA_MEMBER_BINDING_INSTANCE);
		_tmp20_ = self->priv->callback_method;
		_tmp21_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp22_ = _tmp21_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp20_, _tmp22_);
		_tmp23_ = self->priv->callback_method;
		vala_method_set_is_async_callback (_tmp23_, TRUE);
		_vala_code_node_unref0 (bool_type);
	}
	_tmp24_ = self->priv->callback_method;
	result = _tmp24_;
	return result;
}

ValaList*
vala_method_get_async_begin_parameters (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaNamespace* _tmp3_;
	ValaNamespace* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp9_;
	ValaArrayList* _tmp10_;
	ValaParameter* ellipsis = NULL;
	ValaDelegateType* callback_type = NULL;
	ValaSymbol* _tmp28_;
	ValaScope* _tmp29_;
	ValaScope* _tmp30_;
	ValaSymbol* _tmp31_;
	ValaDelegate* _tmp32_;
	ValaDelegateType* _tmp33_;
	ValaDelegateType* _tmp34_;
	ValaDelegateType* _tmp35_;
	ValaDelegateType* _tmp36_;
	ValaDelegateType* _tmp37_;
	ValaParameter* callback_param = NULL;
	ValaDelegateType* _tmp38_;
	ValaParameter* _tmp39_;
	ValaParameter* _tmp40_;
	ValaSourceReference* _tmp41_;
	ValaSourceReference* _tmp42_;
	ValaNullLiteral* _tmp43_;
	ValaNullLiteral* _tmp44_;
	ValaParameter* _tmp45_;
	ValaExpression* _tmp46_;
	ValaExpression* _tmp47_;
	ValaDelegateType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaParameter* _tmp51_;
	ValaParameter* _tmp52_;
	ValaArrayList* _tmp53_;
	ValaParameter* _tmp54_;
	ValaParameter* _tmp55_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = vala_code_context_get ();
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_code_context_get_root (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_scope_lookup (_tmp6_, "GLib");
	_tmp8_ = _tmp7_;
	_vala_code_context_unref0 (_tmp2_);
	glib_ns = _tmp8_;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp9_);
	params = _tmp10_;
	ellipsis = NULL;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp11_;
		ValaList* _tmp12_;
		gint _param_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _param_index = 0;
		_tmp11_ = self->priv->parameters;
		_tmp12_ = _vala_iterable_ref0 (_tmp11_);
		_param_list = _tmp12_;
		_tmp13_ = _param_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_param_size = _tmp15_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			ValaParameter* _tmp18_;
			gboolean _tmp19_;
			gboolean _tmp20_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp16_ = _param_list;
			_tmp17_ = vala_list_get (_tmp16_, _param_index);
			param = (ValaParameter*) _tmp17_;
			_tmp18_ = param;
			_tmp19_ = vala_parameter_get_ellipsis (_tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp20_) {
				ValaParameter* _tmp21_;
				ValaParameter* _tmp22_;
				_tmp21_ = param;
				_tmp22_ = _vala_code_node_ref0 (_tmp21_);
				_vala_code_node_unref0 (ellipsis);
				ellipsis = _tmp22_;
			} else {
				ValaParameter* _tmp23_;
				ValaParameterDirection _tmp24_;
				ValaParameterDirection _tmp25_;
				_tmp23_ = param;
				_tmp24_ = vala_parameter_get_direction (_tmp23_);
				_tmp25_ = _tmp24_;
				if (_tmp25_ == VALA_PARAMETER_DIRECTION_IN) {
					ValaArrayList* _tmp26_;
					ValaParameter* _tmp27_;
					_tmp26_ = params;
					_tmp27_ = param;
					vala_collection_add ((ValaCollection*) _tmp26_, _tmp27_);
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp28_ = glib_ns;
	_tmp29_ = vala_symbol_get_scope (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_scope_lookup (_tmp30_, "AsyncReadyCallback");
	_tmp32_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_DELEGATE, ValaDelegate);
	_tmp33_ = vala_delegate_type_new (_tmp32_);
	_tmp34_ = _tmp33_;
	_vala_code_node_unref0 (_tmp32_);
	callback_type = _tmp34_;
	_tmp35_ = callback_type;
	vala_data_type_set_nullable ((ValaDataType*) _tmp35_, TRUE);
	_tmp36_ = callback_type;
	vala_data_type_set_value_owned ((ValaDataType*) _tmp36_, TRUE);
	_tmp37_ = callback_type;
	vala_delegate_type_set_is_called_once (_tmp37_, TRUE);
	_tmp38_ = callback_type;
	_tmp39_ = vala_parameter_new ("_callback_", (ValaDataType*) _tmp38_, NULL);
	callback_param = _tmp39_;
	_tmp40_ = callback_param;
	_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp42_ = _tmp41_;
	_tmp43_ = vala_null_literal_new (_tmp42_);
	_tmp44_ = _tmp43_;
	vala_variable_set_initializer ((ValaVariable*) _tmp40_, (ValaExpression*) _tmp44_);
	_vala_code_node_unref0 (_tmp44_);
	_tmp45_ = callback_param;
	_tmp46_ = vala_variable_get_initializer ((ValaVariable*) _tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = callback_type;
	_tmp49_ = vala_data_type_copy ((ValaDataType*) _tmp48_);
	_tmp50_ = _tmp49_;
	vala_expression_set_target_type (_tmp47_, _tmp50_);
	_vala_code_node_unref0 (_tmp50_);
	_tmp51_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp51_, "CCode", "pos", (gdouble) -1, NULL);
	_tmp52_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp52_, "CCode", "delegate_target_pos", -0.9, NULL);
	_tmp53_ = params;
	_tmp54_ = callback_param;
	vala_collection_add ((ValaCollection*) _tmp53_, _tmp54_);
	_tmp55_ = ellipsis;
	if (_tmp55_ != NULL) {
		ValaArrayList* _tmp56_;
		ValaParameter* _tmp57_;
		_tmp56_ = params;
		_tmp57_ = ellipsis;
		vala_collection_add ((ValaCollection*) _tmp56_, _tmp57_);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (callback_param);
	_vala_code_node_unref0 (callback_type);
	_vala_code_node_unref0 (ellipsis);
	_vala_code_node_unref0 (glib_ns);
	return result;
}

ValaList*
vala_method_get_async_end_parameters (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp3_;
	ValaCodeContext* _tmp4_;
	ValaNamespace* _tmp5_;
	ValaNamespace* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaObjectType* result_type = NULL;
	ValaSymbol* _tmp11_;
	ValaScope* _tmp12_;
	ValaScope* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaObjectTypeSymbol* _tmp15_;
	ValaObjectType* _tmp16_;
	ValaObjectType* _tmp17_;
	ValaParameter* result_param = NULL;
	ValaObjectType* _tmp18_;
	ValaParameter* _tmp19_;
	ValaParameter* _tmp20_;
	ValaArrayList* _tmp21_;
	ValaParameter* _tmp22_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
	params = _tmp2_;
	_tmp3_ = vala_code_context_get ();
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_code_context_get_root (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_scope_lookup (_tmp8_, "GLib");
	_tmp10_ = _tmp9_;
	_vala_code_context_unref0 (_tmp4_);
	glib_ns = _tmp10_;
	_tmp11_ = glib_ns;
	_tmp12_ = vala_symbol_get_scope (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_scope_lookup (_tmp13_, "AsyncResult");
	_tmp15_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol);
	_tmp16_ = vala_object_type_new (_tmp15_);
	_tmp17_ = _tmp16_;
	_vala_code_node_unref0 (_tmp15_);
	result_type = _tmp17_;
	_tmp18_ = result_type;
	_tmp19_ = vala_parameter_new ("_res_", (ValaDataType*) _tmp18_, NULL);
	result_param = _tmp19_;
	_tmp20_ = result_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp20_, "CCode", "pos", vala_code_node_get_attribute_double ((ValaCodeNode*) self, "CCode", "async_result_pos", 0.1), NULL);
	_tmp21_ = params;
	_tmp22_ = result_param;
	vala_collection_add ((ValaCollection*) _tmp21_, _tmp22_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp23_;
		ValaList* _tmp24_;
		gint _param_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _param_index = 0;
		_tmp23_ = self->priv->parameters;
		_tmp24_ = _vala_iterable_ref0 (_tmp23_);
		_param_list = _tmp24_;
		_tmp25_ = _param_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_param_size = _tmp27_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp28_;
			gpointer _tmp29_;
			ValaParameter* _tmp30_;
			ValaParameterDirection _tmp31_;
			ValaParameterDirection _tmp32_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp28_ = _param_list;
			_tmp29_ = vala_list_get (_tmp28_, _param_index);
			param = (ValaParameter*) _tmp29_;
			_tmp30_ = param;
			_tmp31_ = vala_parameter_get_direction (_tmp30_);
			_tmp32_ = _tmp31_;
			if (_tmp32_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaArrayList* _tmp33_;
				ValaParameter* _tmp34_;
				_tmp33_ = params;
				_tmp34_ = param;
				vala_collection_add ((ValaCollection*) _tmp33_, _tmp34_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (result_param);
	_vala_code_node_unref0 (result_type);
	_vala_code_node_unref0 (glib_ns);
	return result;
}

void
vala_method_add_captured_variable (ValaMethod* self,
                                   ValaLocalVariable* local)
{
	gboolean _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local != NULL);
	_tmp0_ = self->priv->_closure;
	_vala_assert (_tmp0_, "this.closure");
	_tmp1_ = self->priv->captured_variables;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_;
		ValaArrayList* _tmp3_;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
		_vala_iterable_unref0 (self->priv->captured_variables);
		self->priv->captured_variables = (ValaList*) _tmp3_;
	}
	_tmp4_ = self->priv->captured_variables;
	vala_collection_add ((ValaCollection*) _tmp4_, local);
}

void
vala_method_get_captured_variables (ValaMethod* self,
                                    ValaCollection* variables)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variables != NULL);
	_tmp0_ = self->priv->captured_variables;
	if (_tmp0_ != NULL) {
		{
			ValaList* _local_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _local_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _local_index = 0;
			_tmp1_ = self->priv->captured_variables;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_local_list = _tmp2_;
			_tmp3_ = _local_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_local_size = _tmp5_;
			_local_index = -1;
			while (TRUE) {
				ValaLocalVariable* local = NULL;
				ValaList* _tmp6_;
				gpointer _tmp7_;
				ValaLocalVariable* _tmp8_;
				_local_index = _local_index + 1;
				if (!(_local_index < _local_size)) {
					break;
				}
				_tmp6_ = _local_list;
				_tmp7_ = vala_list_get (_tmp6_, _local_index);
				local = (ValaLocalVariable*) _tmp7_;
				_tmp8_ = local;
				vala_collection_add (variables, _tmp8_);
				_vala_code_node_unref0 (local);
			}
			_vala_iterable_unref0 (_local_list);
		}
	}
}

static void
vala_method_real_get_defined_variables (ValaCodeNode* base,
                                        ValaCollection* collection)
{
	ValaMethod * self;
	ValaLocalVariable* _tmp0_;
	ValaLocalVariable* _tmp1_;
	gboolean _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaLocalVariable* _tmp2_;
		ValaLocalVariable* _tmp3_;
		_tmp2_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp3_ = _tmp2_;
		vala_collection_add (collection, (ValaVariable*) _tmp3_);
	}
	_tmp4_ = self->priv->_closure;
	if (_tmp4_) {
		vala_method_get_captured_variables (self, G_TYPE_CHECK_INSTANCE_CAST (collection, VALA_TYPE_COLLECTION, ValaCollection));
	}
}

gint
vala_method_get_format_arg_index (ValaMethod* self)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaParameter* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->parameters;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->parameters;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaParameter*) _tmp6_;
				_tmp8_ = vala_parameter_get_format_arg (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp10_) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}

gboolean
vala_method_has_error_type_parameter (ValaMethod* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ValaMethod* _tmp4_;
	ValaMethod* _tmp5_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	ValaMethod* _tmp12_;
	ValaMethod* _tmp13_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp4_ = vala_method_get_base_method (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		_tmp6_ = vala_method_get_base_method (self);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ != self;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		_tmp8_ = vala_method_get_base_method (self);
		_tmp9_ = _tmp8_;
		_tmp2_ = vala_method_has_error_type_parameter (_tmp9_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp12_ = vala_method_get_base_interface_method (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaMethod* _tmp14_;
		ValaMethod* _tmp15_;
		_tmp14_ = vala_method_get_base_interface_method (self);
		_tmp15_ = _tmp14_;
		_tmp11_ = _tmp15_ != self;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		_tmp16_ = vala_method_get_base_interface_method (self);
		_tmp17_ = _tmp16_;
		_tmp10_ = vala_method_has_error_type_parameter (_tmp17_);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
vala_method_class_init (ValaMethodClass * klass,
                        gpointer klass_data)
{
	vala_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethod_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_real_get_error_types;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_method_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_real_check;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_real_get_defined_variables;
	VALA_SUBROUTINE_CLASS (klass)->get_has_result = vala_method_real_get_has_result;
}

static void
vala_method_vala_callable_interface_init (ValaCallableIface * iface,
                                          gpointer iface_data)
{
	vala_method_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable*, ValaParameter*)) vala_method_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable*)) vala_method_real_get_parameters;
	iface->get_return_type = vala_method_real_get_return_type;
	iface->set_return_type = vala_method_real_set_return_type;
}

static void
vala_method_instance_init (ValaMethod * self,
                           gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}

static void
vala_method_finalize (ValaCodeNode * obj)
{
	ValaMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD, ValaMethod);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_iterable_unref0 (self->priv->preconditions);
	_vala_iterable_unref0 (self->priv->postconditions);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_iterable_unref0 (self->error_types);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	_vala_code_node_unref0 (self->priv->callback_method);
	_vala_code_node_unref0 (self->priv->end_method);
	_vala_iterable_unref0 (self->priv->captured_variables);
	VALA_CODE_NODE_CLASS (vala_method_parent_class)->finalize (obj);
}

/**
 * Represents a type or namespace method.
 */
static GType
vala_method_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethod), 0, (GInstanceInitFunc) vala_method_instance_init, NULL };
	static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_method_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_method_type_id;
	vala_method_type_id = g_type_register_static (VALA_TYPE_SUBROUTINE, "ValaMethod", &g_define_type_info, 0);
	g_type_add_interface_static (vala_method_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
	ValaMethod_private_offset = g_type_add_instance_private (vala_method_type_id, sizeof (ValaMethodPrivate));
	return vala_method_type_id;
}

GType
vala_method_get_type (void)
{
	static volatile gsize vala_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_type_id__volatile)) {
		GType vala_method_type_id;
		vala_method_type_id = vala_method_get_type_once ();
		g_once_init_leave (&vala_method_type_id__volatile, vala_method_type_id);
	}
	return vala_method_type_id__volatile;
}

