/* valaswitchstatement.c generated by valac, the Vala compiler
 * generated from valaswitchstatement.vala, do not modify */

/* valaswitchstatement.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaSwitchStatementPrivate {
	ValaExpression* _expression;
	ValaList* sections;
};

static gint ValaSwitchStatement_private_offset;
static gpointer vala_switch_statement_parent_class = NULL;
static ValaStatementIface * vala_switch_statement_vala_statement_parent_iface = NULL;

static void vala_switch_statement_real_accept (ValaCodeNode* base,
                                        ValaCodeVisitor* visitor);
static void vala_switch_statement_real_accept_children (ValaCodeNode* base,
                                                 ValaCodeVisitor* visitor);
static void vala_switch_statement_real_replace_expression (ValaCodeNode* base,
                                                    ValaExpression* old_node,
                                                    ValaExpression* new_node);
static void vala_switch_statement_real_get_error_types (ValaCodeNode* base,
                                                 ValaCollection* collection,
                                                 ValaSourceReference* source_reference);
static gboolean vala_switch_statement_real_check (ValaCodeNode* base,
                                           ValaCodeContext* context);
static void vala_switch_statement_real_emit (ValaCodeNode* base,
                                      ValaCodeGenerator* codegen);
static void vala_switch_statement_finalize (ValaCodeNode * obj);

static inline gpointer
vala_switch_statement_get_instance_private (ValaSwitchStatement* self)
{
	return G_STRUCT_MEMBER_P (self, ValaSwitchStatement_private_offset);
}

ValaExpression*
vala_switch_statement_get_expression (ValaSwitchStatement* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_expression;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_switch_statement_set_expression (ValaSwitchStatement* self,
                                      ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_expression);
	self->priv->_expression = _tmp0_;
	_tmp1_ = self->priv->_expression;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

/**
 * Creates a new switch statement.
 *
 * @param expression       switch expression
 * @param source_reference reference to source code
 * @return                 newly created switch statement
 */
ValaSwitchStatement*
vala_switch_statement_construct (GType object_type,
                                 ValaExpression* expression,
                                 ValaSourceReference* source_reference)
{
	ValaSwitchStatement* self = NULL;
	g_return_val_if_fail (expression != NULL, NULL);
	self = (ValaSwitchStatement*) vala_code_node_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_switch_statement_set_expression (self, expression);
	return self;
}

ValaSwitchStatement*
vala_switch_statement_new (ValaExpression* expression,
                           ValaSourceReference* source_reference)
{
	return vala_switch_statement_construct (VALA_TYPE_SWITCH_STATEMENT, expression, source_reference);
}

/**
 * Appends the specified section to the list of switch sections.
 *
 * @param section a switch section
 */
void
vala_switch_statement_add_section (ValaSwitchStatement* self,
                                   ValaSwitchSection* section)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	vala_code_node_set_parent_node ((ValaCodeNode*) section, (ValaCodeNode*) self);
	_tmp0_ = self->priv->sections;
	vala_collection_add ((ValaCollection*) _tmp0_, section);
}

/**
 * Returns the list of switch sections.
 *
 * @return section list
 */
ValaList*
vala_switch_statement_get_sections (ValaSwitchStatement* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sections;
	result = _tmp0_;
	return result;
}

static void
vala_switch_statement_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor)
{
	ValaSwitchStatement * self;
	self = (ValaSwitchStatement*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_switch_statement (visitor, self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_switch_statement_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor)
{
	ValaSwitchStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaSwitchStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_switch_statement_get_expression (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_switch_statement_get_expression (self);
	_tmp3_ = _tmp2_;
	vala_code_visitor_visit_end_full_expression (visitor, _tmp3_);
	{
		ValaList* _section_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _section_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _section_index = 0;
		_tmp4_ = self->priv->sections;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_section_list = _tmp5_;
		_tmp6_ = _section_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_section_size = _tmp8_;
		_section_index = -1;
		while (TRUE) {
			ValaSwitchSection* section = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaSwitchSection* _tmp11_;
			_section_index = _section_index + 1;
			if (!(_section_index < _section_size)) {
				break;
			}
			_tmp9_ = _section_list;
			_tmp10_ = vala_list_get (_tmp9_, _section_index);
			section = (ValaSwitchSection*) _tmp10_;
			_tmp11_ = section;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (section);
		}
		_vala_iterable_unref0 (_section_list);
	}
}

static void
vala_switch_statement_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node)
{
	ValaSwitchStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaSwitchStatement*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_switch_statement_get_expression (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_switch_statement_set_expression (self, new_node);
	}
}

static void
vala_switch_statement_real_get_error_types (ValaCodeNode* base,
                                            ValaCollection* collection,
                                            ValaSourceReference* source_reference)
{
	ValaSwitchStatement * self;
	self = (ValaSwitchStatement*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _section_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _section_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _section_index = 0;
		_tmp0_ = self->priv->sections;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_section_list = _tmp1_;
		_tmp2_ = _section_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_section_size = _tmp4_;
		_section_index = -1;
		while (TRUE) {
			ValaSwitchSection* section = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaSwitchSection* _tmp7_;
			_section_index = _section_index + 1;
			if (!(_section_index < _section_size)) {
				break;
			}
			_tmp5_ = _section_list;
			_tmp6_ = vala_list_get (_tmp5_, _section_index);
			section = (ValaSwitchSection*) _tmp6_;
			_tmp7_ = section;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp7_, collection, source_reference);
			_vala_code_node_unref0 (section);
		}
		_vala_iterable_unref0 (_section_list);
	}
}

static gboolean
vala_switch_statement_real_check (ValaCodeNode* base,
                                  ValaCodeContext* context)
{
	ValaSwitchStatement * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaExpression* _tmp32_;
	ValaExpression* _tmp33_;
	ValaExpression* _tmp34_;
	ValaExpression* _tmp35_;
	ValaDataType* _tmp36_;
	ValaDataType* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	ValaExpression* _tmp40_;
	ValaExpression* _tmp41_;
	ValaDataType* _tmp42_;
	ValaDataType* _tmp43_;
	ValaHashSet* labelset = NULL;
	GHashFunc _tmp44_;
	GEqualFunc _tmp45_;
	ValaHashSet* _tmp46_;
	gboolean _tmp96_;
	gboolean _tmp97_;
	gboolean result = FALSE;
	self = (ValaSwitchStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_switch_statement_get_expression (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp7_ = vala_switch_statement_get_expression (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_expression_get_value_type (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == NULL) {
		_tmp6_ = TRUE;
	} else {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		ValaDataType* _tmp15_;
		ValaDataType* _tmp16_;
		_tmp13_ = vala_switch_statement_get_expression (self);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_expression_get_value_type (_tmp14_);
		_tmp16_ = _tmp15_;
		if (!VALA_IS_INTEGER_TYPE (_tmp16_)) {
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaDataType* _tmp19_;
			ValaDataType* _tmp20_;
			_tmp17_ = vala_switch_statement_get_expression (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_expression_get_value_type (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp12_ = !VALA_IS_ENUM_VALUE_TYPE (_tmp20_);
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			ValaExpression* _tmp21_;
			ValaExpression* _tmp22_;
			ValaDataType* _tmp23_;
			ValaDataType* _tmp24_;
			ValaSemanticAnalyzer* _tmp25_;
			ValaSemanticAnalyzer* _tmp26_;
			ValaDataType* _tmp27_;
			_tmp21_ = vala_switch_statement_get_expression (self);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_expression_get_value_type (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_code_context_get_analyzer (context);
			_tmp26_ = _tmp25_;
			_tmp27_ = _tmp26_->string_type;
			_tmp11_ = !vala_data_type_compatible (_tmp24_, _tmp27_);
		} else {
			_tmp11_ = FALSE;
		}
		_tmp6_ = _tmp11_;
	}
	if (_tmp6_) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSourceReference* _tmp30_;
		ValaSourceReference* _tmp31_;
		_tmp28_ = vala_switch_statement_get_expression (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp29_);
		_tmp31_ = _tmp30_;
		vala_report_error (_tmp31_, "Integer or string expression expected");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp32_ = vala_switch_statement_get_expression (self);
	_tmp33_ = _tmp32_;
	_tmp34_ = vala_switch_statement_get_expression (self);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_expression_get_value_type (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_data_type_copy (_tmp37_);
	_tmp39_ = _tmp38_;
	vala_expression_set_target_type (_tmp33_, _tmp39_);
	_vala_code_node_unref0 (_tmp39_);
	_tmp40_ = vala_switch_statement_get_expression (self);
	_tmp41_ = _tmp40_;
	_tmp42_ = vala_expression_get_target_type (_tmp41_);
	_tmp43_ = _tmp42_;
	vala_data_type_set_nullable (_tmp43_, FALSE);
	_tmp44_ = g_str_hash;
	_tmp45_ = g_str_equal;
	_tmp46_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp44_, _tmp45_);
	labelset = _tmp46_;
	{
		ValaList* _section_list = NULL;
		ValaList* _tmp47_;
		ValaList* _tmp48_;
		gint _section_size = 0;
		ValaList* _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		gint _section_index = 0;
		_tmp47_ = self->priv->sections;
		_tmp48_ = _vala_iterable_ref0 (_tmp47_);
		_section_list = _tmp48_;
		_tmp49_ = _section_list;
		_tmp50_ = vala_collection_get_size ((ValaCollection*) _tmp49_);
		_tmp51_ = _tmp50_;
		_section_size = _tmp51_;
		_section_index = -1;
		while (TRUE) {
			ValaSwitchSection* section = NULL;
			ValaList* _tmp52_;
			gpointer _tmp53_;
			ValaSwitchSection* _tmp54_;
			_section_index = _section_index + 1;
			if (!(_section_index < _section_size)) {
				break;
			}
			_tmp52_ = _section_list;
			_tmp53_ = vala_list_get (_tmp52_, _section_index);
			section = (ValaSwitchSection*) _tmp53_;
			_tmp54_ = section;
			vala_code_node_check ((ValaCodeNode*) _tmp54_, context);
			{
				ValaList* _label_list = NULL;
				ValaSwitchSection* _tmp55_;
				ValaList* _tmp56_;
				ValaList* _tmp57_;
				gint _label_size = 0;
				ValaList* _tmp58_;
				gint _tmp59_;
				gint _tmp60_;
				gint _label_index = 0;
				_tmp55_ = section;
				_tmp56_ = vala_switch_section_get_labels (_tmp55_);
				_tmp57_ = _vala_iterable_ref0 (_tmp56_);
				_label_list = _tmp57_;
				_tmp58_ = _label_list;
				_tmp59_ = vala_collection_get_size ((ValaCollection*) _tmp58_);
				_tmp60_ = _tmp59_;
				_label_size = _tmp60_;
				_label_index = -1;
				while (TRUE) {
					ValaSwitchLabel* label = NULL;
					ValaList* _tmp61_;
					gpointer _tmp62_;
					ValaSwitchLabel* _tmp63_;
					ValaExpression* _tmp64_;
					ValaExpression* _tmp65_;
					_label_index = _label_index + 1;
					if (!(_label_index < _label_size)) {
						break;
					}
					_tmp61_ = _label_list;
					_tmp62_ = vala_list_get (_tmp61_, _label_index);
					label = (ValaSwitchLabel*) _tmp62_;
					_tmp63_ = label;
					_tmp64_ = vala_switch_label_get_expression (_tmp63_);
					_tmp65_ = _tmp64_;
					if (_tmp65_ != NULL) {
						gchar* value = NULL;
						ValaSwitchLabel* _tmp66_;
						ValaExpression* _tmp67_;
						ValaExpression* _tmp68_;
						gboolean _tmp87_ = FALSE;
						const gchar* _tmp88_;
						value = NULL;
						_tmp66_ = label;
						_tmp67_ = vala_switch_label_get_expression (_tmp66_);
						_tmp68_ = _tmp67_;
						if (VALA_IS_STRING_LITERAL (_tmp68_)) {
							ValaSwitchLabel* _tmp69_;
							ValaExpression* _tmp70_;
							ValaExpression* _tmp71_;
							gchar* _tmp72_;
							_tmp69_ = label;
							_tmp70_ = vala_switch_label_get_expression (_tmp69_);
							_tmp71_ = _tmp70_;
							_tmp72_ = vala_string_literal_eval (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_STRING_LITERAL, ValaStringLiteral));
							_g_free0 (value);
							value = _tmp72_;
						} else {
							ValaSwitchLabel* _tmp73_;
							ValaExpression* _tmp74_;
							ValaExpression* _tmp75_;
							_tmp73_ = label;
							_tmp74_ = vala_switch_label_get_expression (_tmp73_);
							_tmp75_ = _tmp74_;
							if (VALA_IS_LITERAL (_tmp75_)) {
								ValaSwitchLabel* _tmp76_;
								ValaExpression* _tmp77_;
								ValaExpression* _tmp78_;
								gchar* _tmp79_;
								_tmp76_ = label;
								_tmp77_ = vala_switch_label_get_expression (_tmp76_);
								_tmp78_ = _tmp77_;
								_tmp79_ = vala_code_node_to_string ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_LITERAL, ValaLiteral));
								_g_free0 (value);
								value = _tmp79_;
							} else {
								ValaSwitchLabel* _tmp80_;
								ValaExpression* _tmp81_;
								ValaExpression* _tmp82_;
								_tmp80_ = label;
								_tmp81_ = vala_switch_label_get_expression (_tmp80_);
								_tmp82_ = _tmp81_;
								if (vala_expression_is_constant (_tmp82_)) {
									ValaSwitchLabel* _tmp83_;
									ValaExpression* _tmp84_;
									ValaExpression* _tmp85_;
									gchar* _tmp86_;
									_tmp83_ = label;
									_tmp84_ = vala_switch_label_get_expression (_tmp83_);
									_tmp85_ = _tmp84_;
									_tmp86_ = vala_code_node_to_string ((ValaCodeNode*) _tmp85_);
									_g_free0 (value);
									value = _tmp86_;
								}
							}
						}
						_tmp88_ = value;
						if (_tmp88_ != NULL) {
							ValaHashSet* _tmp89_;
							const gchar* _tmp90_;
							_tmp89_ = labelset;
							_tmp90_ = value;
							_tmp87_ = !vala_collection_add ((ValaCollection*) _tmp89_, _tmp90_);
						} else {
							_tmp87_ = FALSE;
						}
						if (_tmp87_) {
							ValaSwitchLabel* _tmp91_;
							ValaExpression* _tmp92_;
							ValaExpression* _tmp93_;
							ValaSourceReference* _tmp94_;
							ValaSourceReference* _tmp95_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp91_ = label;
							_tmp92_ = vala_switch_label_get_expression (_tmp91_);
							_tmp93_ = _tmp92_;
							_tmp94_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp93_);
							_tmp95_ = _tmp94_;
							vala_report_error (_tmp95_, "Switch statement already contains this label");
						}
						_g_free0 (value);
					}
					_vala_code_node_unref0 (label);
				}
				_vala_iterable_unref0 (_label_list);
			}
			_vala_code_node_unref0 (section);
		}
		_vala_iterable_unref0 (_section_list);
	}
	_tmp96_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp97_ = _tmp96_;
	result = !_tmp97_;
	_vala_iterable_unref0 (labelset);
	return result;
}

static void
vala_switch_statement_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen)
{
	ValaSwitchStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaSwitchStatement*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_switch_statement_get_expression (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	_tmp2_ = vala_switch_statement_get_expression (self);
	_tmp3_ = _tmp2_;
	vala_code_visitor_visit_end_full_expression ((ValaCodeVisitor*) codegen, _tmp3_);
	vala_code_visitor_visit_switch_statement ((ValaCodeVisitor*) codegen, self);
}

static void
vala_switch_statement_class_init (ValaSwitchStatementClass * klass,
                                  gpointer klass_data)
{
	vala_switch_statement_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_switch_statement_finalize;
	g_type_class_adjust_private_offset (klass, &ValaSwitchStatement_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_switch_statement_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_switch_statement_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_switch_statement_real_replace_expression;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_switch_statement_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_switch_statement_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_switch_statement_real_emit;
}

static void
vala_switch_statement_vala_statement_interface_init (ValaStatementIface * iface,
                                                     gpointer iface_data)
{
	vala_switch_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}

static void
vala_switch_statement_instance_init (ValaSwitchStatement * self,
                                     gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_switch_statement_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_SWITCH_SECTION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->sections = (ValaList*) _tmp1_;
}

static void
vala_switch_statement_finalize (ValaCodeNode * obj)
{
	ValaSwitchStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatement);
	_vala_code_node_unref0 (self->priv->_expression);
	_vala_iterable_unref0 (self->priv->sections);
	VALA_CODE_NODE_CLASS (vala_switch_statement_parent_class)->finalize (obj);
}

/**
 * Represents a switch selection statement in the source code.
 */
GType
vala_switch_statement_get_type (void)
{
	static volatile gsize vala_switch_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_switch_statement_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSwitchStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_switch_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSwitchStatement), 0, (GInstanceInitFunc) vala_switch_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_switch_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_switch_statement_type_id;
		vala_switch_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaSwitchStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_switch_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
		ValaSwitchStatement_private_offset = g_type_add_instance_private (vala_switch_statement_type_id, sizeof (ValaSwitchStatementPrivate));
		g_once_init_leave (&vala_switch_statement_type_id__volatile, vala_switch_statement_type_id);
	}
	return vala_switch_statement_type_id__volatile;
}

