/* valainitializerlist.c generated by valac, the Vala compiler
 * generated from valainitializerlist.vala, do not modify */

/* valainitializerlist.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaInitializerListPrivate {
	ValaList* initializers;
};

static gint ValaInitializerList_private_offset;
static gpointer vala_initializer_list_parent_class = NULL;

static void vala_initializer_list_real_accept_children (ValaCodeNode* base,
                                                 ValaCodeVisitor* visitor);
static void vala_initializer_list_real_accept (ValaCodeNode* base,
                                        ValaCodeVisitor* visitor);
static gboolean vala_initializer_list_real_is_constant (ValaExpression* base);
static gboolean vala_initializer_list_real_is_pure (ValaExpression* base);
static gboolean vala_initializer_list_real_is_accessible (ValaExpression* base,
                                                   ValaSymbol* sym);
static gchar* vala_initializer_list_real_to_string (ValaCodeNode* base);
static void vala_initializer_list_real_replace_expression (ValaCodeNode* base,
                                                    ValaExpression* old_node,
                                                    ValaExpression* new_node);
static gboolean vala_initializer_list_real_check (ValaCodeNode* base,
                                           ValaCodeContext* context);
static void vala_initializer_list_real_emit (ValaCodeNode* base,
                                      ValaCodeGenerator* codegen);
static void vala_initializer_list_real_get_used_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_initializer_list_finalize (ValaCodeNode * obj);

static inline gpointer
vala_initializer_list_get_instance_private (ValaInitializerList* self)
{
	return G_STRUCT_MEMBER_P (self, ValaInitializerList_private_offset);
}

/**
 * Appends the specified expression to this initializer
 *
 * @param expr an expression
 */
void
vala_initializer_list_append (ValaInitializerList* self,
                              ValaExpression* expr)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = self->priv->initializers;
	vala_collection_add ((ValaCollection*) _tmp0_, expr);
	vala_code_node_set_parent_node ((ValaCodeNode*) expr, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the expression
 *
 * @return expression list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_initializer_list_get_initializers (ValaInitializerList* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Creates a new initializer
 *
 * @param source_reference reference to source code
 * @return                 newly created initializer list
 */
ValaInitializerList*
vala_initializer_list_construct (GType object_type,
                                 ValaSourceReference* source_reference)
{
	ValaInitializerList* self = NULL;
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaInitializerList*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaInitializerList*
vala_initializer_list_new (ValaSourceReference* source_reference)
{
	return vala_initializer_list_construct (VALA_TYPE_INITIALIZER_LIST, source_reference);
}

static void
vala_initializer_list_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp5_ = _expr_list;
			_tmp6_ = vala_list_get (_tmp5_, _expr_index);
			expr = (ValaExpression*) _tmp6_;
			_tmp7_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}

static void
vala_initializer_list_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_initializer_list (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gboolean
vala_initializer_list_real_is_constant (ValaExpression* base)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			ValaExpression* initializer = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp5_ = _initializer_list;
			_tmp6_ = vala_list_get (_tmp5_, _initializer_index);
			initializer = (ValaExpression*) _tmp6_;
			_tmp7_ = initializer;
			if (!vala_expression_is_constant (_tmp7_)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}

static gboolean
vala_initializer_list_real_is_pure (ValaExpression* base)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			ValaExpression* initializer = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp5_ = _initializer_list;
			_tmp6_ = vala_list_get (_tmp5_, _initializer_index);
			initializer = (ValaExpression*) _tmp6_;
			_tmp7_ = initializer;
			if (!vala_expression_is_pure (_tmp7_)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}

static gboolean
vala_initializer_list_real_is_accessible (ValaExpression* base,
                                          ValaSymbol* sym)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			ValaExpression* initializer = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp5_ = _initializer_list;
			_tmp6_ = vala_list_get (_tmp5_, _initializer_index);
			initializer = (ValaExpression*) _tmp6_;
			_tmp7_ = initializer;
			if (!vala_expression_is_accessible (_tmp7_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}

static gchar*
vala_initializer_list_real_to_string (ValaCodeNode* base)
{
	ValaInitializerList * self;
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	gboolean first = FALSE;
	GString* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	self = (ValaInitializerList*) base;
	_tmp0_ = g_string_new ("{");
	builder = _tmp0_;
	first = TRUE;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _initializer_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _initializer_index = 0;
		_tmp1_ = self->priv->initializers;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_initializer_list = _tmp2_;
		_tmp3_ = _initializer_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_initializer_size = _tmp5_;
		_initializer_index = -1;
		while (TRUE) {
			ValaExpression* initializer = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp6_ = _initializer_list;
			_tmp7_ = vala_list_get (_tmp6_, _initializer_index);
			initializer = (ValaExpression*) _tmp7_;
			if (first) {
				GString* _tmp8_;
				ValaExpression* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp8_ = builder;
				_tmp9_ = initializer;
				_tmp10_ = vala_code_node_to_string ((ValaCodeNode*) _tmp9_);
				_tmp11_ = _tmp10_;
				g_string_append (_tmp8_, _tmp11_);
				_g_free0 (_tmp11_);
				first = FALSE;
			} else {
				GString* _tmp12_;
				ValaExpression* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp12_ = builder;
				_tmp13_ = initializer;
				_tmp14_ = vala_code_node_to_string ((ValaCodeNode*) _tmp13_);
				_tmp15_ = _tmp14_;
				g_string_append_printf (_tmp12_, ", %s", _tmp15_);
				_g_free0 (_tmp15_);
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	_tmp16_ = builder;
	_tmp17_ = _tmp16_->str;
	_tmp18_ = g_strdup (_tmp17_);
	result = _tmp18_;
	_g_string_free0 (builder);
	return result;
}

static void
vala_initializer_list_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaExpression* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->initializers;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->initializers;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaExpression*) _tmp6_;
				_tmp8_ = _tmp7_ == old_node;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->initializers;
					vala_list_set (_tmp9_, i, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
				}
			}
		}
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_initializer_list_real_check (ValaCodeNode* base,
                                  ValaCodeContext* context)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean _error_ = FALSE;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "initializer list used for unknown type");
		result = FALSE;
		return result;
	} else {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp9_ = _tmp8_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_ARRAY_TYPE)) {
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			ValaArrayType* _tmp12_;
			gboolean requires_constants_only = FALSE;
			ValaCodeNode* node = NULL;
			ValaCodeNode* _tmp13_;
			ValaCodeNode* _tmp14_;
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_ = FALSE;
			ValaCodeNode* _tmp22_;
			ValaCodeNode* _tmp23_;
			ValaDataType* inner_target_type = NULL;
			ValaArrayType* _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			_tmp10_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp11_ = _tmp10_;
			_tmp12_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			array_type = _tmp12_;
			requires_constants_only = FALSE;
			_tmp13_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp14_ = _tmp13_;
			node = _tmp14_;
			while (TRUE) {
				ValaCodeNode* _tmp15_;
				ValaCodeNode* _tmp16_;
				ValaCodeNode* _tmp17_;
				ValaCodeNode* _tmp18_;
				ValaCodeNode* _tmp19_;
				_tmp15_ = node;
				if (!(_tmp15_ != NULL)) {
					break;
				}
				_tmp16_ = node;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_CONSTANT)) {
					requires_constants_only = TRUE;
					break;
				}
				_tmp17_ = node;
				_tmp18_ = vala_code_node_get_parent_node (_tmp17_);
				_tmp19_ = _tmp18_;
				node = _tmp19_;
			}
			_tmp22_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp23_ = _tmp22_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALA_TYPE_ARRAY_CREATION_EXPRESSION)) {
				_tmp21_ = !requires_constants_only;
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				gboolean _tmp24_ = FALSE;
				ValaCodeNode* _tmp25_;
				ValaCodeNode* _tmp26_;
				_tmp25_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp26_ = _tmp25_;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, VALA_TYPE_INITIALIZER_LIST)) {
					_tmp24_ = TRUE;
				} else {
					ValaCodeNode* _tmp27_;
					ValaCodeNode* _tmp28_;
					ValaDataType* _tmp29_;
					ValaDataType* _tmp30_;
					ValaTypeSymbol* _tmp31_;
					ValaTypeSymbol* _tmp32_;
					_tmp27_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp28_ = _tmp27_;
					_tmp29_ = vala_expression_get_target_type ((ValaExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
					_tmp30_ = _tmp29_;
					_tmp31_ = vala_data_type_get_data_type (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp24_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, VALA_TYPE_STRUCT);
				}
				_tmp20_ = _tmp24_;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp33_;
				ValaCodeNode* _tmp34_;
				ValaCodeNode* _tmp35_;
				ValaArrayCreationExpression* array_creation = NULL;
				ValaArrayType* _tmp36_;
				ValaDataType* _tmp37_;
				ValaDataType* _tmp38_;
				ValaDataType* _tmp39_;
				ValaDataType* _tmp40_;
				ValaArrayType* _tmp41_;
				gint _tmp42_;
				gint _tmp43_;
				ValaSourceReference* _tmp44_;
				ValaSourceReference* _tmp45_;
				ValaArrayCreationExpression* _tmp46_;
				ValaArrayCreationExpression* _tmp47_;
				ValaArrayCreationExpression* _tmp48_;
				ValaArrayType* _tmp49_;
				ValaDataType* _tmp50_;
				ValaDataType* _tmp51_;
				ValaDataType* _tmp52_;
				ValaDataType* _tmp53_;
				ValaArrayCreationExpression* _tmp54_;
				ValaDataType* _tmp55_;
				ValaDataType* _tmp56_;
				ValaCodeNode* _tmp57_;
				ValaArrayCreationExpression* _tmp58_;
				ValaArrayCreationExpression* _tmp59_;
				_tmp33_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp34_ = _tmp33_;
				_tmp35_ = _vala_code_node_ref0 (_tmp34_);
				old_parent_node = _tmp35_;
				_tmp36_ = array_type;
				_tmp37_ = vala_array_type_get_element_type (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = vala_data_type_copy (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = array_type;
				_tmp42_ = vala_array_type_get_rank (_tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp45_ = _tmp44_;
				_tmp46_ = vala_array_creation_expression_new (_tmp40_, _tmp43_, self, _tmp45_);
				_tmp47_ = _tmp46_;
				_vala_code_node_unref0 (_tmp40_);
				array_creation = _tmp47_;
				_tmp48_ = array_creation;
				_tmp49_ = array_type;
				_tmp50_ = vala_array_type_get_length_type (_tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = vala_data_type_copy (_tmp51_);
				_tmp53_ = _tmp52_;
				vala_array_creation_expression_set_length_type (_tmp48_, _tmp53_);
				_vala_code_node_unref0 (_tmp53_);
				_tmp54_ = array_creation;
				_tmp55_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp56_ = _tmp55_;
				vala_expression_set_target_type ((ValaExpression*) _tmp54_, _tmp56_);
				_tmp57_ = old_parent_node;
				_tmp58_ = array_creation;
				vala_code_node_replace_expression (_tmp57_, (ValaExpression*) self, (ValaExpression*) _tmp58_);
				vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
				_tmp59_ = array_creation;
				result = vala_code_node_check ((ValaCodeNode*) _tmp59_, context);
				_vala_code_node_unref0 (array_creation);
				_vala_code_node_unref0 (old_parent_node);
				_vala_code_node_unref0 (array_type);
				return result;
			}
			_tmp60_ = array_type;
			_tmp61_ = vala_array_type_get_rank (_tmp60_);
			_tmp62_ = _tmp61_;
			if (_tmp62_ > 1) {
				ValaArrayType* inner_array_type = NULL;
				ValaArrayType* _tmp63_;
				ValaDataType* _tmp64_;
				ValaArrayType* _tmp65_;
				gint _tmp66_;
				gint _tmp67_;
				ValaArrayType* _tmp68_;
				ValaDataType* _tmp69_;
				_tmp63_ = array_type;
				_tmp64_ = vala_data_type_copy ((ValaDataType*) _tmp63_);
				inner_array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
				_tmp65_ = inner_array_type;
				_tmp66_ = vala_array_type_get_rank (_tmp65_);
				_tmp67_ = _tmp66_;
				vala_array_type_set_rank (_tmp65_, _tmp67_ - 1);
				_tmp68_ = inner_array_type;
				_tmp69_ = _vala_code_node_ref0 ((ValaDataType*) _tmp68_);
				_vala_code_node_unref0 (inner_target_type);
				inner_target_type = _tmp69_;
				_vala_code_node_unref0 (inner_array_type);
			} else {
				ValaArrayType* _tmp70_;
				ValaDataType* _tmp71_;
				ValaDataType* _tmp72_;
				ValaDataType* _tmp73_;
				_tmp70_ = array_type;
				_tmp71_ = vala_array_type_get_element_type (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = vala_data_type_copy (_tmp72_);
				_vala_code_node_unref0 (inner_target_type);
				inner_target_type = _tmp73_;
			}
			{
				ValaList* _e_list = NULL;
				ValaList* _tmp74_;
				gint _e_size = 0;
				ValaList* _tmp75_;
				gint _tmp76_;
				gint _tmp77_;
				gint _e_index = 0;
				_tmp74_ = vala_initializer_list_get_initializers (self);
				_e_list = _tmp74_;
				_tmp75_ = _e_list;
				_tmp76_ = vala_collection_get_size ((ValaCollection*) _tmp75_);
				_tmp77_ = _tmp76_;
				_e_size = _tmp77_;
				_e_index = -1;
				while (TRUE) {
					ValaExpression* e = NULL;
					ValaList* _tmp78_;
					gpointer _tmp79_;
					ValaExpression* _tmp80_;
					ValaDataType* _tmp81_;
					_e_index = _e_index + 1;
					if (!(_e_index < _e_size)) {
						break;
					}
					_tmp78_ = _e_list;
					_tmp79_ = vala_list_get (_tmp78_, _e_index);
					e = (ValaExpression*) _tmp79_;
					_tmp80_ = e;
					_tmp81_ = inner_target_type;
					vala_expression_set_target_type (_tmp80_, _tmp81_);
					_vala_code_node_unref0 (e);
				}
				_vala_iterable_unref0 (_e_list);
			}
			_vala_code_node_unref0 (inner_target_type);
			_vala_code_node_unref0 (array_type);
		} else {
			ValaDataType* _tmp82_;
			ValaDataType* _tmp83_;
			ValaTypeSymbol* _tmp84_;
			ValaTypeSymbol* _tmp85_;
			_tmp82_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp83_ = _tmp82_;
			_tmp84_ = vala_data_type_get_data_type (_tmp83_);
			_tmp85_ = _tmp84_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp85_, VALA_TYPE_STRUCT)) {
				ValaStruct* st = NULL;
				ValaDataType* _tmp86_;
				ValaDataType* _tmp87_;
				ValaTypeSymbol* _tmp88_;
				ValaTypeSymbol* _tmp89_;
				ValaStruct* _tmp90_;
				ValaIterator* field_it = NULL;
				ValaStruct* _tmp98_;
				ValaList* _tmp99_;
				ValaList* _tmp100_;
				ValaIterator* _tmp101_;
				ValaIterator* _tmp102_;
				_tmp86_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp87_ = _tmp86_;
				_tmp88_ = vala_data_type_get_data_type (_tmp87_);
				_tmp89_ = _tmp88_;
				_tmp90_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, VALA_TYPE_STRUCT, ValaStruct));
				st = _tmp90_;
				while (TRUE) {
					ValaStruct* _tmp91_;
					ValaStruct* _tmp92_;
					ValaStruct* _tmp93_;
					ValaStruct* _tmp94_;
					ValaStruct* _tmp95_;
					ValaStruct* _tmp96_;
					ValaStruct* _tmp97_;
					_tmp91_ = st;
					_tmp92_ = vala_struct_get_base_struct (_tmp91_);
					_tmp93_ = _tmp92_;
					if (!(_tmp93_ != NULL)) {
						break;
					}
					_tmp94_ = st;
					_tmp95_ = vala_struct_get_base_struct (_tmp94_);
					_tmp96_ = _tmp95_;
					_tmp97_ = _vala_code_node_ref0 (_tmp96_);
					_vala_code_node_unref0 (st);
					st = _tmp97_;
				}
				_tmp98_ = st;
				_tmp99_ = vala_struct_get_fields (_tmp98_);
				_tmp100_ = _tmp99_;
				_tmp101_ = vala_iterable_iterator ((ValaIterable*) _tmp100_);
				_tmp102_ = _tmp101_;
				_vala_iterable_unref0 (_tmp100_);
				field_it = _tmp102_;
				{
					ValaList* _e_list = NULL;
					ValaList* _tmp103_;
					gint _e_size = 0;
					ValaList* _tmp104_;
					gint _tmp105_;
					gint _tmp106_;
					gint _e_index = 0;
					_tmp103_ = vala_initializer_list_get_initializers (self);
					_e_list = _tmp103_;
					_tmp104_ = _e_list;
					_tmp105_ = vala_collection_get_size ((ValaCollection*) _tmp104_);
					_tmp106_ = _tmp105_;
					_e_size = _tmp106_;
					_e_index = -1;
					while (TRUE) {
						ValaExpression* e = NULL;
						ValaList* _tmp107_;
						gpointer _tmp108_;
						ValaField* field = NULL;
						ValaExpression* _tmp125_;
						ValaField* _tmp126_;
						ValaDataType* _tmp127_;
						ValaDataType* _tmp128_;
						ValaDataType* _tmp129_;
						ValaDataType* _tmp130_;
						ValaDataType* _tmp131_;
						ValaDataType* _tmp132_;
						gboolean _tmp133_;
						gboolean _tmp134_;
						_e_index = _e_index + 1;
						if (!(_e_index < _e_size)) {
							break;
						}
						_tmp107_ = _e_list;
						_tmp108_ = vala_list_get (_tmp107_, _e_index);
						e = (ValaExpression*) _tmp108_;
						field = NULL;
						while (TRUE) {
							ValaField* _tmp109_;
							ValaIterator* _tmp110_;
							ValaIterator* _tmp120_;
							gpointer _tmp121_;
							ValaField* _tmp122_;
							ValaMemberBinding _tmp123_;
							ValaMemberBinding _tmp124_;
							_tmp109_ = field;
							if (!(_tmp109_ == NULL)) {
								break;
							}
							_tmp110_ = field_it;
							if (!vala_iterator_next (_tmp110_)) {
								ValaExpression* _tmp111_;
								ValaSourceReference* _tmp112_;
								ValaSourceReference* _tmp113_;
								ValaDataType* _tmp114_;
								ValaDataType* _tmp115_;
								gchar* _tmp116_;
								gchar* _tmp117_;
								gchar* _tmp118_;
								gchar* _tmp119_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp111_ = e;
								_tmp112_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp111_);
								_tmp113_ = _tmp112_;
								_tmp114_ = vala_expression_get_target_type ((ValaExpression*) self);
								_tmp115_ = _tmp114_;
								_tmp116_ = vala_code_node_to_string ((ValaCodeNode*) _tmp115_);
								_tmp117_ = _tmp116_;
								_tmp118_ = g_strdup_printf ("too many expressions in initializer list for `%s'", _tmp117_);
								_tmp119_ = _tmp118_;
								vala_report_error (_tmp113_, _tmp119_);
								_g_free0 (_tmp119_);
								_g_free0 (_tmp117_);
								result = FALSE;
								_vala_code_node_unref0 (field);
								_vala_code_node_unref0 (e);
								_vala_iterable_unref0 (_e_list);
								_vala_iterator_unref0 (field_it);
								_vala_code_node_unref0 (st);
								return result;
							}
							_tmp120_ = field_it;
							_tmp121_ = vala_iterator_get (_tmp120_);
							_vala_code_node_unref0 (field);
							field = (ValaField*) _tmp121_;
							_tmp122_ = field;
							_tmp123_ = vala_field_get_binding (_tmp122_);
							_tmp124_ = _tmp123_;
							if (_tmp124_ != VALA_MEMBER_BINDING_INSTANCE) {
								_vala_code_node_unref0 (field);
								field = NULL;
							}
						}
						_tmp125_ = e;
						_tmp126_ = field;
						_tmp127_ = vala_variable_get_variable_type ((ValaVariable*) _tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_data_type_copy (_tmp128_);
						_tmp130_ = _tmp129_;
						vala_expression_set_target_type (_tmp125_, _tmp130_);
						_vala_code_node_unref0 (_tmp130_);
						_tmp131_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp132_ = _tmp131_;
						_tmp133_ = vala_data_type_get_value_owned (_tmp132_);
						_tmp134_ = _tmp133_;
						if (!_tmp134_) {
							ValaExpression* _tmp135_;
							ValaDataType* _tmp136_;
							ValaDataType* _tmp137_;
							_tmp135_ = e;
							_tmp136_ = vala_expression_get_target_type (_tmp135_);
							_tmp137_ = _tmp136_;
							vala_data_type_set_value_owned (_tmp137_, FALSE);
						}
						_vala_code_node_unref0 (field);
						_vala_code_node_unref0 (e);
					}
					_vala_iterable_unref0 (_e_list);
				}
				_vala_iterator_unref0 (field_it);
				_vala_code_node_unref0 (st);
			} else {
				ValaSourceReference* _tmp138_;
				ValaSourceReference* _tmp139_;
				ValaDataType* _tmp140_;
				ValaDataType* _tmp141_;
				gchar* _tmp142_;
				gchar* _tmp143_;
				gchar* _tmp144_;
				gchar* _tmp145_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp138_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp139_ = _tmp138_;
				_tmp140_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp141_ = _tmp140_;
				_tmp142_ = vala_code_node_to_string ((ValaCodeNode*) _tmp141_);
				_tmp143_ = _tmp142_;
				_tmp144_ = g_strdup_printf ("initializer list used for `%s', which is neither array nor struct", _tmp143_);
				_tmp145_ = _tmp144_;
				vala_report_error (_tmp139_, _tmp145_);
				_g_free0 (_tmp145_);
				_g_free0 (_tmp143_);
				result = FALSE;
				return result;
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp146_;
		ValaList* _tmp147_;
		gint _expr_size = 0;
		ValaList* _tmp148_;
		gint _tmp149_;
		gint _tmp150_;
		gint _expr_index = 0;
		_tmp146_ = self->priv->initializers;
		_tmp147_ = _vala_iterable_ref0 (_tmp146_);
		_expr_list = _tmp147_;
		_tmp148_ = _expr_list;
		_tmp149_ = vala_collection_get_size ((ValaCollection*) _tmp148_);
		_tmp150_ = _tmp149_;
		_expr_size = _tmp150_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp151_;
			gpointer _tmp152_;
			ValaExpression* _tmp153_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp151_ = _expr_list;
			_tmp152_ = vala_list_get (_tmp151_, _expr_index);
			expr = (ValaExpression*) _tmp152_;
			_tmp153_ = expr;
			vala_code_node_check ((ValaCodeNode*) _tmp153_, context);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_error_ = FALSE;
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp154_;
		gint _e_size = 0;
		ValaList* _tmp155_;
		gint _tmp156_;
		gint _tmp157_;
		gint _e_index = 0;
		_tmp154_ = vala_initializer_list_get_initializers (self);
		_e_list = _tmp154_;
		_tmp155_ = _e_list;
		_tmp156_ = vala_collection_get_size ((ValaCollection*) _tmp155_);
		_tmp157_ = _tmp156_;
		_e_size = _tmp157_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp158_;
			gpointer _tmp159_;
			ValaExpression* _tmp160_;
			ValaDataType* _tmp161_;
			ValaDataType* _tmp162_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp166_;
			ValaUnaryExpression* _tmp167_;
			gboolean _tmp168_ = FALSE;
			ValaUnaryExpression* _tmp169_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp158_ = _e_list;
			_tmp159_ = vala_list_get (_tmp158_, _e_index);
			e = (ValaExpression*) _tmp159_;
			_tmp160_ = e;
			_tmp161_ = vala_expression_get_value_type (_tmp160_);
			_tmp162_ = _tmp161_;
			if (_tmp162_ == NULL) {
				ValaExpression* _tmp163_;
				ValaSourceReference* _tmp164_;
				ValaSourceReference* _tmp165_;
				_error_ = TRUE;
				_tmp163_ = e;
				_tmp164_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp163_);
				_tmp165_ = _tmp164_;
				vala_report_error (_tmp165_, "expression type not allowed as initializer");
				_vala_code_node_unref0 (e);
				continue;
			}
			_tmp166_ = e;
			_tmp167_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp166_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp166_) : NULL);
			unary = _tmp167_;
			_tmp169_ = unary;
			if (_tmp169_ != NULL) {
				gboolean _tmp170_ = FALSE;
				ValaUnaryExpression* _tmp171_;
				ValaUnaryOperator _tmp172_;
				ValaUnaryOperator _tmp173_;
				_tmp171_ = unary;
				_tmp172_ = vala_unary_expression_get_operator (_tmp171_);
				_tmp173_ = _tmp172_;
				if (_tmp173_ == VALA_UNARY_OPERATOR_REF) {
					_tmp170_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp174_;
					ValaUnaryOperator _tmp175_;
					ValaUnaryOperator _tmp176_;
					_tmp174_ = unary;
					_tmp175_ = vala_unary_expression_get_operator (_tmp174_);
					_tmp176_ = _tmp175_;
					_tmp170_ = _tmp176_ == VALA_UNARY_OPERATOR_OUT;
				}
				_tmp168_ = _tmp170_;
			} else {
				_tmp168_ = FALSE;
			}
			if (_tmp168_) {
			} else {
				ValaExpression* _tmp177_;
				ValaDataType* _tmp178_;
				ValaDataType* _tmp179_;
				ValaExpression* _tmp180_;
				ValaDataType* _tmp181_;
				ValaDataType* _tmp182_;
				_tmp177_ = e;
				_tmp178_ = vala_expression_get_value_type (_tmp177_);
				_tmp179_ = _tmp178_;
				_tmp180_ = e;
				_tmp181_ = vala_expression_get_target_type (_tmp180_);
				_tmp182_ = _tmp181_;
				if (!vala_data_type_compatible (_tmp179_, _tmp182_)) {
					ValaExpression* _tmp183_;
					ValaExpression* _tmp184_;
					ValaSourceReference* _tmp185_;
					ValaSourceReference* _tmp186_;
					ValaExpression* _tmp187_;
					ValaDataType* _tmp188_;
					ValaDataType* _tmp189_;
					gchar* _tmp190_;
					gchar* _tmp191_;
					ValaExpression* _tmp192_;
					ValaDataType* _tmp193_;
					ValaDataType* _tmp194_;
					gchar* _tmp195_;
					gchar* _tmp196_;
					gchar* _tmp197_;
					gchar* _tmp198_;
					_error_ = TRUE;
					_tmp183_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp183_, TRUE);
					_tmp184_ = e;
					_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp184_);
					_tmp186_ = _tmp185_;
					_tmp187_ = e;
					_tmp188_ = vala_expression_get_target_type (_tmp187_);
					_tmp189_ = _tmp188_;
					_tmp190_ = vala_code_node_to_string ((ValaCodeNode*) _tmp189_);
					_tmp191_ = _tmp190_;
					_tmp192_ = e;
					_tmp193_ = vala_expression_get_value_type (_tmp192_);
					_tmp194_ = _tmp193_;
					_tmp195_ = vala_code_node_to_string ((ValaCodeNode*) _tmp194_);
					_tmp196_ = _tmp195_;
					_tmp197_ = g_strdup_printf ("Expected initializer of type `%s' but got `%s'", _tmp191_, _tmp196_);
					_tmp198_ = _tmp197_;
					vala_report_error (_tmp186_, _tmp198_);
					_g_free0 (_tmp198_);
					_g_free0 (_tmp196_);
					_g_free0 (_tmp191_);
				}
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	if (!_error_) {
		ValaDataType* _tmp199_;
		ValaDataType* _tmp200_;
		ValaDataType* _tmp201_;
		ValaDataType* _tmp202_;
		ValaDataType* _tmp203_;
		ValaDataType* _tmp204_;
		_tmp199_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp200_ = _tmp199_;
		_tmp201_ = vala_data_type_copy (_tmp200_);
		_tmp202_ = _tmp201_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp202_);
		_vala_code_node_unref0 (_tmp202_);
		_tmp203_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp204_ = _tmp203_;
		vala_data_type_set_nullable (_tmp204_, FALSE);
	}
	result = !_error_;
	return result;
}

static void
vala_initializer_list_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp5_ = _expr_list;
			_tmp6_ = vala_list_get (_tmp5_, _expr_index);
			expr = (ValaExpression*) _tmp6_;
			_tmp7_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp7_, codegen);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	vala_code_visitor_visit_initializer_list ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_initializer_list_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp5_ = _expr_list;
			_tmp6_ = vala_list_get (_tmp5_, _expr_index);
			expr = (ValaExpression*) _tmp6_;
			_tmp7_ = expr;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp7_, collection);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}

gint
vala_initializer_list_get_size (ValaInitializerList* self)
{
	gint result;
	ValaList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
vala_initializer_list_class_init (ValaInitializerListClass * klass,
                                  gpointer klass_data)
{
	vala_initializer_list_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_initializer_list_finalize;
	g_type_class_adjust_private_offset (klass, &ValaInitializerList_private_offset);
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_initializer_list_real_accept_children;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_initializer_list_real_accept;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_initializer_list_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_initializer_list_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_initializer_list_real_is_accessible;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_initializer_list_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_initializer_list_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_initializer_list_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_initializer_list_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_initializer_list_real_get_used_variables;
}

static void
vala_initializer_list_instance_init (ValaInitializerList * self,
                                     gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_initializer_list_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->initializers = (ValaList*) _tmp1_;
}

static void
vala_initializer_list_finalize (ValaCodeNode * obj)
{
	ValaInitializerList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList);
	_vala_iterable_unref0 (self->priv->initializers);
	VALA_CODE_NODE_CLASS (vala_initializer_list_parent_class)->finalize (obj);
}

/**
 * Represents an array or struct initializer list in the source code.
 */
GType
vala_initializer_list_get_type (void)
{
	static volatile gsize vala_initializer_list_type_id__volatile = 0;
	if (g_once_init_enter (&vala_initializer_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInitializerListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_initializer_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInitializerList), 0, (GInstanceInitFunc) vala_initializer_list_instance_init, NULL };
		GType vala_initializer_list_type_id;
		vala_initializer_list_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaInitializerList", &g_define_type_info, 0);
		ValaInitializerList_private_offset = g_type_add_instance_private (vala_initializer_list_type_id, sizeof (ValaInitializerListPrivate));
		g_once_init_leave (&vala_initializer_list_type_id__volatile, vala_initializer_list_type_id);
	}
	return vala_initializer_list_type_id__volatile;
}

