/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp9_ = _type_arg_list;
			_tmp10_ = vala_list_get (_tmp9_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp10_;
			_tmp11_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_PROPERTY);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaMethod* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp1_) : NULL);
	method = _tmp2_;
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_CONSTANT)) {
		result = TRUE;
		_vala_code_node_unref0 (method);
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp8_ = _tmp7_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_ARRAY_LENGTH_FIELD)) {
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			_tmp9_ = vala_member_access_get_inner (self);
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_expression_get_symbol_reference (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_CONSTANT);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = TRUE;
			_vala_code_node_unref0 (method);
			return result;
		} else {
			gboolean _tmp15_ = FALSE;
			ValaMethod* _tmp16_;
			_tmp16_ = method;
			if (_tmp16_ != NULL) {
				gboolean _tmp17_ = FALSE;
				ValaMethod* _tmp18_;
				ValaMemberBinding _tmp19_;
				ValaMemberBinding _tmp20_;
				_tmp18_ = method;
				_tmp19_ = vala_method_get_binding (_tmp18_);
				_tmp20_ = _tmp19_;
				if (_tmp20_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp17_ = TRUE;
				} else {
					gboolean _tmp21_;
					_tmp21_ = self->priv->_prototype_access;
					_tmp17_ = _tmp21_;
				}
				_tmp15_ = _tmp17_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				result = TRUE;
				_vala_code_node_unref0 (method);
				return result;
			} else {
				result = FALSE;
				_vala_code_node_unref0 (method);
				return result;
			}
		}
	}
	_vala_code_node_unref0 (method);
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	ValaConstant* _tmp3_;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_CONSTANT) ? ((ValaConstant*) _tmp1_) : NULL);
	c = _tmp2_;
	_tmp3_ = c;
	if (_tmp3_ != NULL) {
		gboolean _tmp4_ = FALSE;
		ValaConstant* _tmp5_;
		_tmp5_ = c;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_ENUM_VALUE)) {
			_tmp4_ = TRUE;
		} else {
			ValaConstant* _tmp6_;
			ValaDataType* _tmp7_;
			ValaDataType* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp6_ = c;
			_tmp7_ = vala_constant_get_type_reference (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_data_type_get_nullable (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = !_tmp10_;
		}
		result = _tmp4_;
		_vala_code_node_unref0 (c);
		return result;
	} else {
		result = FALSE;
		_vala_code_node_unref0 (c);
		return result;
	}
	_vala_code_node_unref0 (c);
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp16_;
	gboolean _tmp513_ = FALSE;
	gboolean _tmp514_ = FALSE;
	ValaSymbol* _tmp515_;
	ValaSymbol* _tmp516_;
	ValaSymbol* _tmp540_;
	ValaSymbol* _tmp541_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp564_;
	ValaSymbol* _tmp565_;
	ValaSymbol* _tmp566_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp567_;
	ValaSymbol* _tmp568_;
	ValaSymbol* _tmp990_;
	ValaSymbol* _tmp991_;
	ValaVersionAttribute* _tmp992_;
	ValaVersionAttribute* _tmp993_;
	ValaSourceReference* _tmp994_;
	ValaSourceReference* _tmp995_;
	gboolean _tmp996_ = FALSE;
	ValaSymbolAccessibility _tmp997_;
	gboolean _tmp1056_ = FALSE;
	gboolean _tmp1087_ = FALSE;
	gboolean _tmp1088_ = FALSE;
	gboolean _tmp1343_;
	gboolean _tmp1344_;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp13_ = _type_arg_list;
			_tmp14_ = vala_list_get (_tmp13_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp15_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp16_ = self->priv->_qualified;
	if (_tmp16_) {
		ValaNamespace* _tmp17_;
		ValaNamespace* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		const gchar* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaSymbol* _tmp25_;
		_tmp17_ = vala_code_context_get_root (context);
		_tmp18_ = _tmp17_;
		_tmp19_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp18_);
		_vala_code_node_unref0 (base_symbol);
		base_symbol = _tmp19_;
		_tmp20_ = base_symbol;
		_tmp21_ = vala_symbol_get_scope (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = self->priv->_member_name;
		_tmp24_ = vala_scope_lookup (_tmp22_, _tmp23_);
		_tmp25_ = _tmp24_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp25_);
		_vala_code_node_unref0 (_tmp25_);
	} else {
		ValaExpression* _tmp26_;
		ValaExpression* _tmp27_;
		_tmp26_ = vala_member_access_get_inner (self);
		_tmp27_ = _tmp26_;
		if (_tmp27_ == NULL) {
			const gchar* _tmp28_;
			ValaSemanticAnalyzer* _tmp33_;
			ValaSemanticAnalyzer* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaSymbol* _tmp37_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			ValaSymbol* _tmp42_;
			gboolean _tmp152_ = FALSE;
			ValaSymbol* _tmp153_;
			ValaSymbol* _tmp154_;
			_tmp28_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp28_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp29_;
				ValaSemanticAnalyzer* _tmp30_;
				_tmp29_ = vala_code_context_get_analyzer (context);
				_tmp30_ = _tmp29_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp30_)) {
					ValaSourceReference* _tmp31_;
					ValaSourceReference* _tmp32_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp32_ = _tmp31_;
					vala_report_error (_tmp32_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
			}
			_tmp33_ = vala_code_context_get_analyzer (context);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_semantic_analyzer_get_current_symbol (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = _vala_code_node_ref0 (_tmp36_);
			_vala_code_node_unref0 (base_symbol);
			base_symbol = _tmp37_;
			method_found = FALSE;
			_tmp38_ = vala_code_context_get_analyzer (context);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = _vala_code_node_ref0 (_tmp41_);
			sym = _tmp42_;
			while (TRUE) {
				gboolean _tmp43_ = FALSE;
				ValaSymbol* _tmp44_;
				ValaSymbol* _tmp100_;
				const gchar* _tmp101_;
				ValaSymbol* _tmp102_;
				ValaSymbol* _tmp103_;
				gboolean _tmp104_ = FALSE;
				gboolean _tmp105_ = FALSE;
				ValaSymbol* _tmp106_;
				ValaSymbol* _tmp107_;
				ValaSymbol* _tmp145_;
				ValaSymbol* _tmp146_;
				ValaSymbol* _tmp148_;
				ValaSymbol* _tmp149_;
				ValaSymbol* _tmp150_;
				ValaSymbol* _tmp151_;
				_tmp44_ = sym;
				if (_tmp44_ != NULL) {
					ValaSymbol* _tmp45_;
					ValaSymbol* _tmp46_;
					_tmp45_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp46_ = _tmp45_;
					_tmp43_ = _tmp46_ == NULL;
				} else {
					_tmp43_ = FALSE;
				}
				if (!_tmp43_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp47_;
					_tmp47_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALA_TYPE_CREATION_METHOD)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp48_;
						ValaCreationMethod* _tmp49_;
						ValaCreationMethod* _tmp50_;
						ValaParameter* _tmp51_;
						ValaParameter* _tmp52_;
						ValaParameter* _tmp53_;
						_tmp48_ = sym;
						_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
						cm = _tmp49_;
						_tmp50_ = cm;
						_tmp51_ = vala_method_get_this_parameter ((ValaMethod*) _tmp50_);
						_tmp52_ = _tmp51_;
						_tmp53_ = _vala_code_node_ref0 (_tmp52_);
						_vala_code_node_unref0 (this_parameter);
						this_parameter = _tmp53_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
						_vala_code_node_unref0 (cm);
					} else {
						ValaSymbol* _tmp54_;
						_tmp54_ = sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, VALA_TYPE_PROPERTY)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp55_;
							ValaProperty* _tmp56_;
							ValaProperty* _tmp57_;
							ValaParameter* _tmp58_;
							ValaParameter* _tmp59_;
							ValaParameter* _tmp60_;
							ValaProperty* _tmp61_;
							ValaMemberBinding _tmp62_;
							ValaMemberBinding _tmp63_;
							ValaProperty* _tmp64_;
							ValaMemberBinding _tmp65_;
							ValaMemberBinding _tmp66_;
							_tmp55_ = sym;
							_tmp56_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp56_;
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_this_parameter (_tmp57_);
							_tmp59_ = _tmp58_;
							_tmp60_ = _vala_code_node_ref0 (_tmp59_);
							_vala_code_node_unref0 (this_parameter);
							this_parameter = _tmp60_;
							_tmp61_ = prop;
							_tmp62_ = vala_property_get_binding (_tmp61_);
							_tmp63_ = _tmp62_;
							may_access_instance_members = _tmp63_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp64_ = prop;
							_tmp65_ = vala_property_get_binding (_tmp64_);
							_tmp66_ = _tmp65_;
							may_access_klass_members = _tmp66_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp67_;
							_tmp67_ = sym;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp67_, VALA_TYPE_CONSTRUCTOR)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp68_;
								ValaConstructor* _tmp69_;
								ValaConstructor* _tmp70_;
								ValaParameter* _tmp71_;
								ValaParameter* _tmp72_;
								ValaParameter* _tmp73_;
								ValaConstructor* _tmp74_;
								ValaMemberBinding _tmp75_;
								ValaMemberBinding _tmp76_;
								_tmp68_ = sym;
								_tmp69_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
								c = _tmp69_;
								_tmp70_ = c;
								_tmp71_ = vala_constructor_get_this_parameter (_tmp70_);
								_tmp72_ = _tmp71_;
								_tmp73_ = _vala_code_node_ref0 (_tmp72_);
								_vala_code_node_unref0 (this_parameter);
								this_parameter = _tmp73_;
								_tmp74_ = c;
								_tmp75_ = vala_constructor_get_binding (_tmp74_);
								_tmp76_ = _tmp75_;
								may_access_instance_members = _tmp76_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
								_vala_code_node_unref0 (c);
							} else {
								ValaSymbol* _tmp77_;
								_tmp77_ = sym;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp77_, VALA_TYPE_DESTRUCTOR)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp78_;
									ValaDestructor* _tmp79_;
									ValaDestructor* _tmp80_;
									ValaParameter* _tmp81_;
									ValaParameter* _tmp82_;
									ValaParameter* _tmp83_;
									ValaDestructor* _tmp84_;
									ValaMemberBinding _tmp85_;
									ValaMemberBinding _tmp86_;
									_tmp78_ = sym;
									_tmp79_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_DESTRUCTOR, ValaDestructor));
									d = _tmp79_;
									_tmp80_ = d;
									_tmp81_ = vala_destructor_get_this_parameter (_tmp80_);
									_tmp82_ = _tmp81_;
									_tmp83_ = _vala_code_node_ref0 (_tmp82_);
									_vala_code_node_unref0 (this_parameter);
									this_parameter = _tmp83_;
									_tmp84_ = d;
									_tmp85_ = vala_destructor_get_binding (_tmp84_);
									_tmp86_ = _tmp85_;
									may_access_instance_members = _tmp86_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
									_vala_code_node_unref0 (d);
								} else {
									ValaSymbol* _tmp87_;
									_tmp87_ = sym;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp87_, VALA_TYPE_METHOD)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp88_;
										ValaMethod* _tmp89_;
										ValaMethod* _tmp90_;
										ValaParameter* _tmp91_;
										ValaParameter* _tmp92_;
										ValaParameter* _tmp93_;
										ValaMethod* _tmp94_;
										ValaMemberBinding _tmp95_;
										ValaMemberBinding _tmp96_;
										ValaMethod* _tmp97_;
										ValaMemberBinding _tmp98_;
										ValaMemberBinding _tmp99_;
										_tmp88_ = sym;
										_tmp89_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_METHOD, ValaMethod));
										m = _tmp89_;
										_tmp90_ = m;
										_tmp91_ = vala_method_get_this_parameter (_tmp90_);
										_tmp92_ = _tmp91_;
										_tmp93_ = _vala_code_node_ref0 (_tmp92_);
										_vala_code_node_unref0 (this_parameter);
										this_parameter = _tmp93_;
										_tmp94_ = m;
										_tmp95_ = vala_method_get_binding (_tmp94_);
										_tmp96_ = _tmp95_;
										may_access_instance_members = _tmp96_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp97_ = m;
										_tmp98_ = vala_method_get_binding (_tmp97_);
										_tmp99_ = _tmp98_;
										may_access_klass_members = _tmp99_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
										_vala_code_node_unref0 (m);
									}
								}
							}
						}
					}
				}
				_tmp100_ = sym;
				_tmp101_ = self->priv->_member_name;
				_tmp102_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp100_, _tmp101_);
				_tmp103_ = _tmp102_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp103_);
				_vala_code_node_unref0 (_tmp103_);
				_tmp106_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp107_ = _tmp106_;
				if (_tmp107_ == NULL) {
					ValaSymbol* _tmp108_;
					_tmp108_ = sym;
					_tmp105_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, VALA_TYPE_TYPESYMBOL);
				} else {
					_tmp105_ = FALSE;
				}
				if (_tmp105_) {
					_tmp104_ = may_access_instance_members;
				} else {
					_tmp104_ = FALSE;
				}
				if (_tmp104_) {
					ValaParameter* _tmp109_;
					ValaDataType* _tmp110_;
					ValaDataType* _tmp111_;
					const gchar* _tmp112_;
					ValaSymbol* _tmp113_;
					ValaSymbol* _tmp114_;
					gboolean _tmp115_ = FALSE;
					ValaSymbol* _tmp116_;
					ValaSymbol* _tmp117_;
					_tmp109_ = this_parameter;
					_tmp110_ = vala_variable_get_variable_type ((ValaVariable*) _tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = self->priv->_member_name;
					_tmp113_ = vala_data_type_get_member (_tmp111_, _tmp112_);
					_tmp114_ = _tmp113_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp114_);
					_vala_code_node_unref0 (_tmp114_);
					_tmp116_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp117_ = _tmp116_;
					if (_tmp117_ != NULL) {
						ValaSymbol* _tmp118_;
						ValaSymbol* _tmp119_;
						_tmp118_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp119_ = _tmp118_;
						_tmp115_ = vala_member_access_is_instance_symbol (_tmp119_);
					} else {
						_tmp115_ = FALSE;
					}
					if (_tmp115_) {
						ValaSourceReference* _tmp120_;
						ValaSourceReference* _tmp121_;
						ValaMemberAccess* _tmp122_;
						ValaMemberAccess* _tmp123_;
						ValaExpression* _tmp124_;
						ValaExpression* _tmp125_;
						ValaParameter* _tmp126_;
						ValaDataType* _tmp127_;
						ValaDataType* _tmp128_;
						ValaDataType* _tmp129_;
						ValaDataType* _tmp130_;
						ValaExpression* _tmp131_;
						ValaExpression* _tmp132_;
						ValaDataType* _tmp133_;
						ValaDataType* _tmp134_;
						ValaExpression* _tmp135_;
						ValaExpression* _tmp136_;
						ValaParameter* _tmp137_;
						ValaExpression* _tmp138_;
						ValaExpression* _tmp139_;
						ValaDataType* _tmp140_;
						ValaDataType* _tmp141_;
						const gchar* _tmp142_;
						ValaSymbol* _tmp143_;
						ValaSymbol* _tmp144_;
						_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_member_access_new (NULL, "this", _tmp121_);
						_tmp123_ = _tmp122_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp123_);
						_vala_code_node_unref0 (_tmp123_);
						_tmp124_ = vala_member_access_get_inner (self);
						_tmp125_ = _tmp124_;
						_tmp126_ = this_parameter;
						_tmp127_ = vala_variable_get_variable_type ((ValaVariable*) _tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_data_type_copy (_tmp128_);
						_tmp130_ = _tmp129_;
						vala_expression_set_value_type (_tmp125_, _tmp130_);
						_vala_code_node_unref0 (_tmp130_);
						_tmp131_ = vala_member_access_get_inner (self);
						_tmp132_ = _tmp131_;
						_tmp133_ = vala_expression_get_value_type (_tmp132_);
						_tmp134_ = _tmp133_;
						vala_data_type_set_value_owned (_tmp134_, FALSE);
						_tmp135_ = vala_member_access_get_inner (self);
						_tmp136_ = _tmp135_;
						_tmp137_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp136_, (ValaSymbol*) _tmp137_);
						_tmp138_ = vala_member_access_get_inner (self);
						_tmp139_ = _tmp138_;
						_tmp140_ = vala_expression_get_value_type (_tmp139_);
						_tmp141_ = _tmp140_;
						_tmp142_ = self->priv->_member_name;
						_tmp143_ = vala_data_type_get_member (_tmp141_, _tmp142_);
						_tmp144_ = _tmp143_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp144_);
						_vala_code_node_unref0 (_tmp144_);
					}
				}
				_tmp145_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp146_ = _tmp145_;
				if (_tmp146_ == NULL) {
					ValaSymbol* _tmp147_;
					_tmp147_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp147_, VALA_TYPE_TYPESYMBOL)) {
						_vala_code_node_unref0 (this_parameter);
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp148_ = sym;
				_tmp149_ = vala_symbol_get_parent_symbol (_tmp148_);
				_tmp150_ = _tmp149_;
				_tmp151_ = _vala_code_node_ref0 (_tmp150_);
				_vala_code_node_unref0 (sym);
				sym = _tmp151_;
			}
			_tmp153_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp154_ = _tmp153_;
			if (_tmp154_ == NULL) {
				ValaSourceReference* _tmp155_;
				ValaSourceReference* _tmp156_;
				_tmp155_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp156_ = _tmp155_;
				_tmp152_ = _tmp156_ != NULL;
			} else {
				_tmp152_ = FALSE;
			}
			if (_tmp152_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp157_;
					ValaSourceReference* _tmp158_;
					ValaList* _tmp159_;
					ValaList* _tmp160_;
					ValaList* _tmp161_;
					gint _ns_size = 0;
					ValaList* _tmp162_;
					gint _tmp163_;
					gint _tmp164_;
					gint _ns_index = 0;
					_tmp157_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp158_ = _tmp157_;
					_tmp159_ = vala_source_reference_get_using_directives (_tmp158_);
					_tmp160_ = _tmp159_;
					_tmp161_ = _vala_iterable_ref0 (_tmp160_);
					_ns_list = _tmp161_;
					_tmp162_ = _ns_list;
					_tmp163_ = vala_collection_get_size ((ValaCollection*) _tmp162_);
					_tmp164_ = _tmp163_;
					_ns_size = _tmp164_;
					_ns_index = -1;
					while (TRUE) {
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp165_;
						gpointer _tmp166_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp167_;
						ValaSymbol* _tmp168_;
						ValaSymbol* _tmp169_;
						ValaScope* _tmp170_;
						ValaScope* _tmp171_;
						const gchar* _tmp172_;
						ValaSymbol* _tmp173_;
						ValaSymbol* _tmp174_;
						_ns_index = _ns_index + 1;
						if (!(_ns_index < _ns_size)) {
							break;
						}
						_tmp165_ = _ns_list;
						_tmp166_ = vala_list_get (_tmp165_, _ns_index);
						ns = (ValaUsingDirective*) _tmp166_;
						_tmp167_ = ns;
						_tmp168_ = vala_using_directive_get_namespace_symbol (_tmp167_);
						_tmp169_ = _tmp168_;
						_tmp170_ = vala_symbol_get_scope (_tmp169_);
						_tmp171_ = _tmp170_;
						_tmp172_ = self->priv->_member_name;
						_tmp173_ = vala_scope_lookup (_tmp171_, _tmp172_);
						local_sym = _tmp173_;
						_tmp174_ = local_sym;
						if (_tmp174_ != NULL) {
							gboolean _tmp175_ = FALSE;
							ValaSymbol* _tmp176_;
							ValaSymbol* _tmp177_;
							ValaSymbol* _tmp193_;
							_tmp176_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp177_ = _tmp176_;
							if (_tmp177_ != NULL) {
								ValaSymbol* _tmp178_;
								ValaSymbol* _tmp179_;
								ValaSymbol* _tmp180_;
								_tmp178_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp179_ = _tmp178_;
								_tmp180_ = local_sym;
								_tmp175_ = _tmp179_ != _tmp180_;
							} else {
								_tmp175_ = FALSE;
							}
							if (_tmp175_) {
								ValaSourceReference* _tmp181_;
								ValaSourceReference* _tmp182_;
								const gchar* _tmp183_;
								ValaSymbol* _tmp184_;
								ValaSymbol* _tmp185_;
								gchar* _tmp186_;
								gchar* _tmp187_;
								ValaSymbol* _tmp188_;
								gchar* _tmp189_;
								gchar* _tmp190_;
								gchar* _tmp191_;
								gchar* _tmp192_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp181_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp182_ = _tmp181_;
								_tmp183_ = self->priv->_member_name;
								_tmp184_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp185_ = _tmp184_;
								_tmp186_ = vala_symbol_get_full_name (_tmp185_);
								_tmp187_ = _tmp186_;
								_tmp188_ = local_sym;
								_tmp189_ = vala_symbol_get_full_name (_tmp188_);
								_tmp190_ = _tmp189_;
								_tmp191_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp183_, _tmp187_, _tmp190_);
								_tmp192_ = _tmp191_;
								vala_report_error (_tmp182_, _tmp192_);
								_g_free0 (_tmp192_);
								_g_free0 (_tmp190_);
								_g_free0 (_tmp187_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp193_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp193_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
			_vala_code_node_unref0 (sym);
		} else {
			ValaExpression* _tmp194_;
			ValaExpression* _tmp195_;
			gboolean _tmp196_;
			gboolean _tmp197_;
			ValaExpression* _tmp198_;
			ValaExpression* _tmp199_;
			ValaDataType* _tmp200_;
			ValaDataType* _tmp201_;
			ValaExpression* _tmp220_;
			ValaExpression* _tmp221_;
			gboolean _tmp237_ = FALSE;
			ValaExpression* _tmp238_;
			ValaExpression* _tmp239_;
			gboolean _tmp261_ = FALSE;
			ValaSymbol* _tmp262_;
			ValaSymbol* _tmp263_;
			gboolean _tmp298_ = FALSE;
			gboolean _tmp299_ = FALSE;
			ValaSymbol* _tmp300_;
			ValaSymbol* _tmp301_;
			_tmp194_ = vala_member_access_get_inner (self);
			_tmp195_ = _tmp194_;
			_tmp196_ = vala_code_node_get_error ((ValaCodeNode*) _tmp195_);
			_tmp197_ = _tmp196_;
			if (_tmp197_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_tmp198_ = vala_member_access_get_inner (self);
			_tmp199_ = _tmp198_;
			_tmp200_ = vala_expression_get_value_type (_tmp199_);
			_tmp201_ = _tmp200_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp201_, VALA_TYPE_POINTER_TYPE)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp202_;
				ValaExpression* _tmp203_;
				ValaDataType* _tmp204_;
				ValaDataType* _tmp205_;
				ValaPointerType* _tmp206_;
				gboolean _tmp207_ = FALSE;
				ValaPointerType* _tmp208_;
				_tmp202_ = vala_member_access_get_inner (self);
				_tmp203_ = _tmp202_;
				_tmp204_ = vala_expression_get_value_type (_tmp203_);
				_tmp205_ = _tmp204_;
				_tmp206_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp205_, VALA_TYPE_POINTER_TYPE) ? ((ValaPointerType*) _tmp205_) : NULL);
				pointer_type = _tmp206_;
				_tmp208_ = pointer_type;
				if (_tmp208_ != NULL) {
					ValaPointerType* _tmp209_;
					ValaDataType* _tmp210_;
					ValaDataType* _tmp211_;
					_tmp209_ = pointer_type;
					_tmp210_ = vala_pointer_type_get_base_type (_tmp209_);
					_tmp211_ = _tmp210_;
					_tmp207_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp211_, VALA_TYPE_VALUE_TYPE);
				} else {
					_tmp207_ = FALSE;
				}
				if (_tmp207_) {
					ValaExpression* _tmp212_;
					ValaExpression* _tmp213_;
					ValaSourceReference* _tmp214_;
					ValaSourceReference* _tmp215_;
					ValaPointerIndirection* _tmp216_;
					ValaPointerIndirection* _tmp217_;
					ValaExpression* _tmp218_;
					ValaExpression* _tmp219_;
					_tmp212_ = vala_member_access_get_inner (self);
					_tmp213_ = _tmp212_;
					_tmp214_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp215_ = _tmp214_;
					_tmp216_ = vala_pointer_indirection_new (_tmp213_, _tmp215_);
					_tmp217_ = _tmp216_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp217_);
					_vala_code_node_unref0 (_tmp217_);
					_tmp218_ = vala_member_access_get_inner (self);
					_tmp219_ = _tmp218_;
					vala_code_node_check ((ValaCodeNode*) _tmp219_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
				_vala_code_node_unref0 (pointer_type);
			}
			_tmp220_ = vala_member_access_get_inner (self);
			_tmp221_ = _tmp220_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp221_, VALA_TYPE_MEMBER_ACCESS)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp222_;
				ValaExpression* _tmp223_;
				ValaMemberAccess* _tmp224_;
				ValaMemberAccess* _tmp225_;
				gboolean _tmp226_;
				_tmp222_ = vala_member_access_get_inner (self);
				_tmp223_ = _tmp222_;
				_tmp224_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp223_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				ma = _tmp224_;
				_tmp225_ = ma;
				_tmp226_ = _tmp225_->priv->_prototype_access;
				if (_tmp226_) {
					ValaSourceReference* _tmp227_;
					ValaSourceReference* _tmp228_;
					ValaExpression* _tmp229_;
					ValaExpression* _tmp230_;
					ValaSymbol* _tmp231_;
					ValaSymbol* _tmp232_;
					gchar* _tmp233_;
					gchar* _tmp234_;
					gchar* _tmp235_;
					gchar* _tmp236_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp227_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp228_ = _tmp227_;
					_tmp229_ = vala_member_access_get_inner (self);
					_tmp230_ = _tmp229_;
					_tmp231_ = vala_expression_get_symbol_reference (_tmp230_);
					_tmp232_ = _tmp231_;
					_tmp233_ = vala_symbol_get_full_name (_tmp232_);
					_tmp234_ = _tmp233_;
					_tmp235_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp234_);
					_tmp236_ = _tmp235_;
					vala_report_error (_tmp228_, _tmp236_);
					_g_free0 (_tmp236_);
					_g_free0 (_tmp234_);
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
				_vala_code_node_unref0 (ma);
			}
			_tmp238_ = vala_member_access_get_inner (self);
			_tmp239_ = _tmp238_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp239_, VALA_TYPE_MEMBER_ACCESS)) {
				_tmp237_ = TRUE;
			} else {
				ValaExpression* _tmp240_;
				ValaExpression* _tmp241_;
				_tmp240_ = vala_member_access_get_inner (self);
				_tmp241_ = _tmp240_;
				_tmp237_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp241_, VALA_TYPE_BASE_ACCESS);
			}
			if (_tmp237_) {
				ValaExpression* _tmp242_;
				ValaExpression* _tmp243_;
				ValaSymbol* _tmp244_;
				ValaSymbol* _tmp245_;
				ValaSymbol* _tmp246_;
				gboolean _tmp247_ = FALSE;
				ValaSymbol* _tmp248_;
				ValaSymbol* _tmp249_;
				_tmp242_ = vala_member_access_get_inner (self);
				_tmp243_ = _tmp242_;
				_tmp244_ = vala_expression_get_symbol_reference (_tmp243_);
				_tmp245_ = _tmp244_;
				_tmp246_ = _vala_code_node_ref0 (_tmp245_);
				_vala_code_node_unref0 (base_symbol);
				base_symbol = _tmp246_;
				_tmp248_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp249_ = _tmp248_;
				if (_tmp249_ == NULL) {
					gboolean _tmp250_ = FALSE;
					ValaSymbol* _tmp251_;
					_tmp251_ = base_symbol;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp251_, VALA_TYPE_NAMESPACE)) {
						_tmp250_ = TRUE;
					} else {
						ValaSymbol* _tmp252_;
						_tmp252_ = base_symbol;
						_tmp250_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp252_, VALA_TYPE_TYPESYMBOL);
					}
					_tmp247_ = _tmp250_;
				} else {
					_tmp247_ = FALSE;
				}
				if (_tmp247_) {
					ValaSymbol* _tmp253_;
					ValaScope* _tmp254_;
					ValaScope* _tmp255_;
					const gchar* _tmp256_;
					ValaSymbol* _tmp257_;
					ValaSymbol* _tmp258_;
					ValaExpression* _tmp259_;
					ValaExpression* _tmp260_;
					_tmp253_ = base_symbol;
					_tmp254_ = vala_symbol_get_scope (_tmp253_);
					_tmp255_ = _tmp254_;
					_tmp256_ = self->priv->_member_name;
					_tmp257_ = vala_scope_lookup (_tmp255_, _tmp256_);
					_tmp258_ = _tmp257_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp258_);
					_vala_code_node_unref0 (_tmp258_);
					_tmp259_ = vala_member_access_get_inner (self);
					_tmp260_ = _tmp259_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp260_, VALA_TYPE_BASE_ACCESS)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp262_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp263_ = _tmp262_;
			if (_tmp263_ == NULL) {
				ValaExpression* _tmp264_;
				ValaExpression* _tmp265_;
				ValaDataType* _tmp266_;
				ValaDataType* _tmp267_;
				_tmp264_ = vala_member_access_get_inner (self);
				_tmp265_ = _tmp264_;
				_tmp266_ = vala_expression_get_value_type (_tmp265_);
				_tmp267_ = _tmp266_;
				_tmp261_ = _tmp267_ != NULL;
			} else {
				_tmp261_ = FALSE;
			}
			if (_tmp261_) {
				gboolean _tmp268_;
				ValaSymbol* _tmp296_;
				ValaSymbol* _tmp297_;
				_tmp268_ = self->priv->_pointer_member_access;
				if (_tmp268_) {
					ValaExpression* _tmp269_;
					ValaExpression* _tmp270_;
					ValaDataType* _tmp271_;
					ValaDataType* _tmp272_;
					const gchar* _tmp273_;
					ValaSymbol* _tmp274_;
					ValaSymbol* _tmp275_;
					_tmp269_ = vala_member_access_get_inner (self);
					_tmp270_ = _tmp269_;
					_tmp271_ = vala_expression_get_value_type (_tmp270_);
					_tmp272_ = _tmp271_;
					_tmp273_ = self->priv->_member_name;
					_tmp274_ = vala_data_type_get_pointer_member (_tmp272_, _tmp273_);
					_tmp275_ = _tmp274_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp275_);
					_vala_code_node_unref0 (_tmp275_);
				} else {
					ValaExpression* _tmp276_;
					ValaExpression* _tmp277_;
					ValaDataType* _tmp278_;
					ValaDataType* _tmp279_;
					ValaTypeSymbol* _tmp280_;
					ValaTypeSymbol* _tmp281_;
					ValaExpression* _tmp289_;
					ValaExpression* _tmp290_;
					ValaDataType* _tmp291_;
					ValaDataType* _tmp292_;
					const gchar* _tmp293_;
					ValaSymbol* _tmp294_;
					ValaSymbol* _tmp295_;
					_tmp276_ = vala_member_access_get_inner (self);
					_tmp277_ = _tmp276_;
					_tmp278_ = vala_expression_get_value_type (_tmp277_);
					_tmp279_ = _tmp278_;
					_tmp280_ = vala_data_type_get_data_type (_tmp279_);
					_tmp281_ = _tmp280_;
					if (_tmp281_ != NULL) {
						ValaExpression* _tmp282_;
						ValaExpression* _tmp283_;
						ValaDataType* _tmp284_;
						ValaDataType* _tmp285_;
						ValaTypeSymbol* _tmp286_;
						ValaTypeSymbol* _tmp287_;
						ValaSymbol* _tmp288_;
						_tmp282_ = vala_member_access_get_inner (self);
						_tmp283_ = _tmp282_;
						_tmp284_ = vala_expression_get_value_type (_tmp283_);
						_tmp285_ = _tmp284_;
						_tmp286_ = vala_data_type_get_data_type (_tmp285_);
						_tmp287_ = _tmp286_;
						_tmp288_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp287_);
						_vala_code_node_unref0 (base_symbol);
						base_symbol = _tmp288_;
					}
					_tmp289_ = vala_member_access_get_inner (self);
					_tmp290_ = _tmp289_;
					_tmp291_ = vala_expression_get_value_type (_tmp290_);
					_tmp292_ = _tmp291_;
					_tmp293_ = self->priv->_member_name;
					_tmp294_ = vala_data_type_get_member (_tmp292_, _tmp293_);
					_tmp295_ = _tmp294_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp295_);
					_vala_code_node_unref0 (_tmp295_);
				}
				_tmp296_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp297_ = _tmp296_;
				if (_tmp297_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp300_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp301_ = _tmp300_;
			if (_tmp301_ == NULL) {
				ValaExpression* _tmp302_;
				ValaExpression* _tmp303_;
				ValaDataType* _tmp304_;
				ValaDataType* _tmp305_;
				_tmp302_ = vala_member_access_get_inner (self);
				_tmp303_ = _tmp302_;
				_tmp304_ = vala_expression_get_value_type (_tmp303_);
				_tmp305_ = _tmp304_;
				_tmp299_ = _tmp305_ != NULL;
			} else {
				_tmp299_ = FALSE;
			}
			if (_tmp299_) {
				ValaExpression* _tmp306_;
				ValaExpression* _tmp307_;
				ValaDataType* _tmp308_;
				ValaDataType* _tmp309_;
				gboolean _tmp310_;
				gboolean _tmp311_;
				_tmp306_ = vala_member_access_get_inner (self);
				_tmp307_ = _tmp306_;
				_tmp308_ = vala_expression_get_value_type (_tmp307_);
				_tmp309_ = _tmp308_;
				_tmp310_ = vala_data_type_get_is_dynamic (_tmp309_);
				_tmp311_ = _tmp310_;
				_tmp298_ = _tmp311_;
			} else {
				_tmp298_ = FALSE;
			}
			if (_tmp298_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp312_;
				ValaExpression* _tmp313_;
				ValaDataType* _tmp314_;
				ValaDataType* _tmp315_;
				ValaObjectType* _tmp316_;
				ValaCodeNode* _tmp317_;
				ValaCodeNode* _tmp318_;
				ValaSymbol* _tmp461_;
				ValaSymbol* _tmp462_;
				ValaSymbol* _tmp511_;
				ValaSymbol* _tmp512_;
				_tmp312_ = vala_member_access_get_inner (self);
				_tmp313_ = _tmp312_;
				_tmp314_ = vala_expression_get_value_type (_tmp313_);
				_tmp315_ = _tmp314_;
				_tmp316_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp315_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp316_;
				_tmp317_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp318_ = _tmp317_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp318_, VALA_TYPE_METHOD_CALL)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp319_;
					ValaCodeNode* _tmp320_;
					ValaMethodCall* _tmp321_;
					ValaMethodCall* _tmp322_;
					ValaExpression* _tmp323_;
					ValaExpression* _tmp324_;
					_tmp319_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp320_ = _tmp319_;
					_tmp321_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp320_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
					invoc = _tmp321_;
					_tmp322_ = invoc;
					_tmp323_ = vala_method_call_get_call (_tmp322_);
					_tmp324_ = _tmp323_;
					if (_tmp324_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp325_;
						ValaDataType* _tmp326_;
						ValaDataType* _tmp327_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp342_;
						ValaExpression* _tmp343_;
						ValaDataType* _tmp344_;
						ValaDataType* _tmp345_;
						const gchar* _tmp346_;
						ValaDataType* _tmp347_;
						ValaSourceReference* _tmp348_;
						ValaSourceReference* _tmp349_;
						ValaDynamicMethod* _tmp350_;
						ValaDynamicMethod* _tmp351_;
						ValaMethodCall* _tmp352_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp353_;
						ValaErrorType* _tmp354_;
						ValaDynamicMethod* _tmp355_;
						ValaErrorType* _tmp356_;
						ValaDynamicMethod* _tmp357_;
						ValaDynamicMethod* _tmp358_;
						ValaParameter* _tmp359_;
						ValaParameter* _tmp360_;
						ValaObjectType* _tmp361_;
						ValaObjectTypeSymbol* _tmp362_;
						ValaObjectTypeSymbol* _tmp363_;
						ValaScope* _tmp364_;
						ValaScope* _tmp365_;
						ValaDynamicMethod* _tmp366_;
						ValaDynamicMethod* _tmp367_;
						_tmp325_ = invoc;
						_tmp326_ = vala_expression_get_target_type ((ValaExpression*) _tmp325_);
						_tmp327_ = _tmp326_;
						if (_tmp327_ != NULL) {
							ValaMethodCall* _tmp328_;
							ValaDataType* _tmp329_;
							ValaDataType* _tmp330_;
							ValaDataType* _tmp331_;
							ValaDataType* _tmp332_;
							_tmp328_ = invoc;
							_tmp329_ = vala_expression_get_target_type ((ValaExpression*) _tmp328_);
							_tmp330_ = _tmp329_;
							_tmp331_ = vala_data_type_copy (_tmp330_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp331_;
							_tmp332_ = ret_type;
							vala_data_type_set_value_owned (_tmp332_, TRUE);
						} else {
							ValaMethodCall* _tmp333_;
							ValaCodeNode* _tmp334_;
							ValaCodeNode* _tmp335_;
							_tmp333_ = invoc;
							_tmp334_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp333_);
							_tmp335_ = _tmp334_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp335_, VALA_TYPE_EXPRESSION_STATEMENT)) {
								ValaVoidType* _tmp336_;
								_tmp336_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp336_;
							} else {
								ValaExpression* _tmp337_;
								ValaExpression* _tmp338_;
								ValaDataType* _tmp339_;
								ValaDataType* _tmp340_;
								ValaDataType* _tmp341_;
								_tmp337_ = vala_member_access_get_inner (self);
								_tmp338_ = _tmp337_;
								_tmp339_ = vala_expression_get_value_type (_tmp338_);
								_tmp340_ = _tmp339_;
								_tmp341_ = vala_data_type_copy (_tmp340_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp341_;
							}
						}
						_tmp342_ = vala_member_access_get_inner (self);
						_tmp343_ = _tmp342_;
						_tmp344_ = vala_expression_get_value_type (_tmp343_);
						_tmp345_ = _tmp344_;
						_tmp346_ = self->priv->_member_name;
						_tmp347_ = ret_type;
						_tmp348_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp349_ = _tmp348_;
						_tmp350_ = vala_dynamic_method_new (_tmp345_, _tmp346_, _tmp347_, _tmp349_, NULL);
						m = _tmp350_;
						_tmp351_ = m;
						_tmp352_ = invoc;
						vala_dynamic_method_set_invocation (_tmp351_, _tmp352_);
						_tmp353_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp353_;
						_tmp354_ = err;
						vala_error_type_set_dynamic_error (_tmp354_, TRUE);
						_tmp355_ = m;
						_tmp356_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp355_, (ValaDataType*) _tmp356_);
						_tmp357_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp357_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp358_ = m;
						_tmp359_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp360_ = _tmp359_;
						vala_callable_add_parameter ((ValaCallable*) _tmp358_, _tmp360_);
						_vala_code_node_unref0 (_tmp360_);
						_tmp361_ = dynamic_object_type;
						_tmp362_ = vala_object_type_get_type_symbol (_tmp361_);
						_tmp363_ = _tmp362_;
						_tmp364_ = vala_symbol_get_scope ((ValaSymbol*) _tmp363_);
						_tmp365_ = _tmp364_;
						_tmp366_ = m;
						vala_scope_add (_tmp365_, NULL, (ValaSymbol*) _tmp366_);
						_tmp367_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp367_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
					_vala_code_node_unref0 (invoc);
				} else {
					ValaCodeNode* _tmp368_;
					ValaCodeNode* _tmp369_;
					_tmp368_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp369_ = _tmp368_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp369_, VALA_TYPE_ASSIGNMENT)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp370_;
						ValaCodeNode* _tmp371_;
						ValaAssignment* _tmp372_;
						ValaAssignment* _tmp373_;
						ValaExpression* _tmp374_;
						ValaExpression* _tmp375_;
						_tmp370_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp371_ = _tmp370_;
						_tmp372_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp371_, VALA_TYPE_ASSIGNMENT, ValaAssignment));
						a = _tmp372_;
						_tmp373_ = a;
						_tmp374_ = vala_assignment_get_left (_tmp373_);
						_tmp375_ = _tmp374_;
						if (_tmp375_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp376_;
							ValaExpression* _tmp377_;
							ValaDataType* _tmp378_;
							ValaDataType* _tmp379_;
							const gchar* _tmp380_;
							ValaSourceReference* _tmp381_;
							ValaSourceReference* _tmp382_;
							ValaDynamicProperty* _tmp383_;
							ValaDynamicProperty* _tmp384_;
							ValaDynamicProperty* _tmp385_;
							ValaDynamicProperty* _tmp386_;
							ValaSourceReference* _tmp387_;
							ValaSourceReference* _tmp388_;
							ValaPropertyAccessor* _tmp389_;
							ValaPropertyAccessor* _tmp390_;
							ValaDynamicProperty* _tmp391_;
							ValaExpression* _tmp392_;
							ValaExpression* _tmp393_;
							ValaDataType* _tmp394_;
							ValaDataType* _tmp395_;
							ValaTypeSymbol* _tmp396_;
							ValaTypeSymbol* _tmp397_;
							ValaScope* _tmp398_;
							ValaScope* _tmp399_;
							ValaObjectType* _tmp400_;
							ValaObjectTypeSymbol* _tmp401_;
							ValaObjectTypeSymbol* _tmp402_;
							ValaScope* _tmp403_;
							ValaScope* _tmp404_;
							ValaDynamicProperty* _tmp405_;
							ValaDynamicProperty* _tmp406_;
							_tmp376_ = vala_member_access_get_inner (self);
							_tmp377_ = _tmp376_;
							_tmp378_ = vala_expression_get_value_type (_tmp377_);
							_tmp379_ = _tmp378_;
							_tmp380_ = self->priv->_member_name;
							_tmp381_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp382_ = _tmp381_;
							_tmp383_ = vala_dynamic_property_new (_tmp379_, _tmp380_, _tmp382_, NULL);
							prop = _tmp383_;
							_tmp384_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp384_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp385_ = prop;
							_tmp386_ = prop;
							_tmp387_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp386_);
							_tmp388_ = _tmp387_;
							_tmp389_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp388_, NULL);
							_tmp390_ = _tmp389_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp385_, _tmp390_);
							_vala_code_node_unref0 (_tmp390_);
							_tmp391_ = prop;
							_tmp392_ = vala_member_access_get_inner (self);
							_tmp393_ = _tmp392_;
							_tmp394_ = vala_expression_get_value_type (_tmp393_);
							_tmp395_ = _tmp394_;
							_tmp396_ = vala_data_type_get_data_type (_tmp395_);
							_tmp397_ = _tmp396_;
							_tmp398_ = vala_symbol_get_scope ((ValaSymbol*) _tmp397_);
							_tmp399_ = _tmp398_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp391_, _tmp399_);
							_tmp400_ = dynamic_object_type;
							_tmp401_ = vala_object_type_get_type_symbol (_tmp400_);
							_tmp402_ = _tmp401_;
							_tmp403_ = vala_symbol_get_scope ((ValaSymbol*) _tmp402_);
							_tmp404_ = _tmp403_;
							_tmp405_ = prop;
							vala_scope_add (_tmp404_, NULL, (ValaSymbol*) _tmp405_);
							_tmp406_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp406_);
							_vala_code_node_unref0 (prop);
						}
						_vala_code_node_unref0 (a);
					} else {
						gboolean _tmp407_ = FALSE;
						gboolean _tmp408_ = FALSE;
						ValaCodeNode* _tmp409_;
						ValaCodeNode* _tmp410_;
						_tmp409_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp410_ = _tmp409_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp410_, VALA_TYPE_MEMBER_ACCESS)) {
							ValaExpression* _tmp411_;
							ValaExpression* _tmp412_;
							_tmp411_ = vala_member_access_get_inner (self);
							_tmp412_ = _tmp411_;
							_tmp408_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp412_, VALA_TYPE_MEMBER_ACCESS);
						} else {
							_tmp408_ = FALSE;
						}
						if (_tmp408_) {
							ValaCodeNode* _tmp413_;
							ValaCodeNode* _tmp414_;
							ValaCodeNode* _tmp415_;
							ValaCodeNode* _tmp416_;
							_tmp413_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp414_ = _tmp413_;
							_tmp415_ = vala_code_node_get_parent_node (_tmp414_);
							_tmp416_ = _tmp415_;
							_tmp407_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp416_, VALA_TYPE_METHOD_CALL);
						} else {
							_tmp407_ = FALSE;
						}
						if (_tmp407_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp417_;
							ValaCodeNode* _tmp418_;
							ValaMemberAccess* _tmp419_;
							gboolean _tmp420_ = FALSE;
							ValaMemberAccess* _tmp421_;
							const gchar* _tmp422_;
							_tmp417_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp418_ = _tmp417_;
							_tmp419_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp418_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
							ma = _tmp419_;
							_tmp421_ = ma;
							_tmp422_ = _tmp421_->priv->_member_name;
							if (g_strcmp0 (_tmp422_, "connect") == 0) {
								_tmp420_ = TRUE;
							} else {
								ValaMemberAccess* _tmp423_;
								const gchar* _tmp424_;
								_tmp423_ = ma;
								_tmp424_ = _tmp423_->priv->_member_name;
								_tmp420_ = g_strcmp0 (_tmp424_, "connect_after") == 0;
							}
							if (_tmp420_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp425_;
								ValaExpression* _tmp426_;
								ValaDataType* _tmp427_;
								ValaDataType* _tmp428_;
								const gchar* _tmp429_;
								ValaVoidType* _tmp430_;
								ValaVoidType* _tmp431_;
								ValaSourceReference* _tmp432_;
								ValaSourceReference* _tmp433_;
								ValaDynamicSignal* _tmp434_;
								ValaDynamicSignal* _tmp435_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp436_;
								ValaCodeNode* _tmp437_;
								ValaCodeNode* _tmp438_;
								ValaCodeNode* _tmp439_;
								ValaMethodCall* _tmp440_;
								ValaMethodCall* _tmp441_;
								ValaList* _tmp442_;
								ValaList* _tmp443_;
								gint _tmp444_;
								gint _tmp445_;
								gboolean _tmp446_;
								ValaDynamicSignal* _tmp453_;
								ValaObjectType* _tmp454_;
								ValaObjectTypeSymbol* _tmp455_;
								ValaObjectTypeSymbol* _tmp456_;
								ValaScope* _tmp457_;
								ValaScope* _tmp458_;
								ValaDynamicSignal* _tmp459_;
								ValaDynamicSignal* _tmp460_;
								_tmp425_ = vala_member_access_get_inner (self);
								_tmp426_ = _tmp425_;
								_tmp427_ = vala_expression_get_value_type (_tmp426_);
								_tmp428_ = _tmp427_;
								_tmp429_ = self->priv->_member_name;
								_tmp430_ = vala_void_type_new (NULL);
								_tmp431_ = _tmp430_;
								_tmp432_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp433_ = _tmp432_;
								_tmp434_ = vala_dynamic_signal_new (_tmp428_, _tmp429_, (ValaDataType*) _tmp431_, _tmp433_, NULL);
								_tmp435_ = _tmp434_;
								_vala_code_node_unref0 (_tmp431_);
								s = _tmp435_;
								_tmp436_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp437_ = _tmp436_;
								_tmp438_ = vala_code_node_get_parent_node (_tmp437_);
								_tmp439_ = _tmp438_;
								_tmp440_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp439_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp440_;
								_tmp441_ = mcall;
								_tmp442_ = vala_method_call_get_argument_list (_tmp441_);
								_tmp443_ = _tmp442_;
								_tmp444_ = vala_collection_get_size ((ValaCollection*) _tmp443_);
								_tmp445_ = _tmp444_;
								_tmp446_ = _tmp445_ > 0;
								_vala_iterable_unref0 (_tmp443_);
								if (_tmp446_) {
									ValaDynamicSignal* _tmp447_;
									ValaMethodCall* _tmp448_;
									ValaList* _tmp449_;
									ValaList* _tmp450_;
									gpointer _tmp451_;
									ValaExpression* _tmp452_;
									_tmp447_ = s;
									_tmp448_ = mcall;
									_tmp449_ = vala_method_call_get_argument_list (_tmp448_);
									_tmp450_ = _tmp449_;
									_tmp451_ = vala_list_get (_tmp450_, 0);
									_tmp452_ = (ValaExpression*) _tmp451_;
									vala_dynamic_signal_set_handler (_tmp447_, _tmp452_);
									_vala_code_node_unref0 (_tmp452_);
									_vala_iterable_unref0 (_tmp450_);
								}
								_tmp453_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp453_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp454_ = dynamic_object_type;
								_tmp455_ = vala_object_type_get_type_symbol (_tmp454_);
								_tmp456_ = _tmp455_;
								_tmp457_ = vala_symbol_get_scope ((ValaSymbol*) _tmp456_);
								_tmp458_ = _tmp457_;
								_tmp459_ = s;
								vala_scope_add (_tmp458_, NULL, (ValaSymbol*) _tmp459_);
								_tmp460_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp460_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
							_vala_code_node_unref0 (ma);
						}
					}
				}
				_tmp461_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp462_ = _tmp461_;
				if (_tmp462_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp463_;
					ValaExpression* _tmp464_;
					ValaDataType* _tmp465_;
					ValaDataType* _tmp466_;
					const gchar* _tmp467_;
					ValaSourceReference* _tmp468_;
					ValaSourceReference* _tmp469_;
					ValaDynamicProperty* _tmp470_;
					ValaDataType* _tmp471_;
					ValaDataType* _tmp472_;
					ValaDynamicProperty* _tmp483_;
					ValaDynamicProperty* _tmp484_;
					ValaDynamicProperty* _tmp485_;
					ValaDataType* _tmp486_;
					ValaDataType* _tmp487_;
					ValaDataType* _tmp488_;
					ValaDataType* _tmp489_;
					ValaDynamicProperty* _tmp490_;
					ValaSourceReference* _tmp491_;
					ValaSourceReference* _tmp492_;
					ValaPropertyAccessor* _tmp493_;
					ValaPropertyAccessor* _tmp494_;
					ValaDynamicProperty* _tmp495_;
					ValaExpression* _tmp496_;
					ValaExpression* _tmp497_;
					ValaDataType* _tmp498_;
					ValaDataType* _tmp499_;
					ValaTypeSymbol* _tmp500_;
					ValaTypeSymbol* _tmp501_;
					ValaScope* _tmp502_;
					ValaScope* _tmp503_;
					ValaObjectType* _tmp504_;
					ValaObjectTypeSymbol* _tmp505_;
					ValaObjectTypeSymbol* _tmp506_;
					ValaScope* _tmp507_;
					ValaScope* _tmp508_;
					ValaDynamicProperty* _tmp509_;
					ValaDynamicProperty* _tmp510_;
					_tmp463_ = vala_member_access_get_inner (self);
					_tmp464_ = _tmp463_;
					_tmp465_ = vala_expression_get_value_type (_tmp464_);
					_tmp466_ = _tmp465_;
					_tmp467_ = self->priv->_member_name;
					_tmp468_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp469_ = _tmp468_;
					_tmp470_ = vala_dynamic_property_new (_tmp466_, _tmp467_, _tmp469_, NULL);
					prop = _tmp470_;
					_tmp471_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp472_ = _tmp471_;
					if (_tmp472_ != NULL) {
						ValaDynamicProperty* _tmp473_;
						ValaDataType* _tmp474_;
						ValaDataType* _tmp475_;
						_tmp473_ = prop;
						_tmp474_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp475_ = _tmp474_;
						vala_property_set_property_type ((ValaProperty*) _tmp473_, _tmp475_);
					} else {
						ValaDynamicProperty* _tmp476_;
						ValaExpression* _tmp477_;
						ValaExpression* _tmp478_;
						ValaDataType* _tmp479_;
						ValaDataType* _tmp480_;
						ValaDataType* _tmp481_;
						ValaDataType* _tmp482_;
						_tmp476_ = prop;
						_tmp477_ = vala_member_access_get_inner (self);
						_tmp478_ = _tmp477_;
						_tmp479_ = vala_expression_get_value_type (_tmp478_);
						_tmp480_ = _tmp479_;
						_tmp481_ = vala_data_type_copy (_tmp480_);
						_tmp482_ = _tmp481_;
						vala_property_set_property_type ((ValaProperty*) _tmp476_, _tmp482_);
						_vala_code_node_unref0 (_tmp482_);
					}
					_tmp483_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp483_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp484_ = prop;
					_tmp485_ = prop;
					_tmp486_ = vala_property_get_property_type ((ValaProperty*) _tmp485_);
					_tmp487_ = _tmp486_;
					_tmp488_ = vala_data_type_copy (_tmp487_);
					_tmp489_ = _tmp488_;
					_tmp490_ = prop;
					_tmp491_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp490_);
					_tmp492_ = _tmp491_;
					_tmp493_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp489_, NULL, _tmp492_, NULL);
					_tmp494_ = _tmp493_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp484_, _tmp494_);
					_vala_code_node_unref0 (_tmp494_);
					_vala_code_node_unref0 (_tmp489_);
					_tmp495_ = prop;
					_tmp496_ = vala_member_access_get_inner (self);
					_tmp497_ = _tmp496_;
					_tmp498_ = vala_expression_get_value_type (_tmp497_);
					_tmp499_ = _tmp498_;
					_tmp500_ = vala_data_type_get_data_type (_tmp499_);
					_tmp501_ = _tmp500_;
					_tmp502_ = vala_symbol_get_scope ((ValaSymbol*) _tmp501_);
					_tmp503_ = _tmp502_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp495_, _tmp503_);
					_tmp504_ = dynamic_object_type;
					_tmp505_ = vala_object_type_get_type_symbol (_tmp504_);
					_tmp506_ = _tmp505_;
					_tmp507_ = vala_symbol_get_scope ((ValaSymbol*) _tmp506_);
					_tmp508_ = _tmp507_;
					_tmp509_ = prop;
					vala_scope_add (_tmp508_, NULL, (ValaSymbol*) _tmp509_);
					_tmp510_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp510_);
					_vala_code_node_unref0 (prop);
				}
				_tmp511_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp512_ = _tmp511_;
				if (_tmp512_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
		}
	}
	_tmp515_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp516_ = _tmp515_;
	if (_tmp516_ == NULL) {
		ValaDataType* _tmp517_;
		ValaDataType* _tmp518_;
		_tmp517_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp518_ = _tmp517_;
		_tmp514_ = _tmp518_ != NULL;
	} else {
		_tmp514_ = FALSE;
	}
	if (_tmp514_) {
		ValaDataType* _tmp519_;
		ValaDataType* _tmp520_;
		ValaTypeSymbol* _tmp521_;
		ValaTypeSymbol* _tmp522_;
		_tmp519_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp520_ = _tmp519_;
		_tmp521_ = vala_data_type_get_data_type (_tmp520_);
		_tmp522_ = _tmp521_;
		_tmp513_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp522_, VALA_TYPE_ENUM);
	} else {
		_tmp513_ = FALSE;
	}
	if (_tmp513_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp523_;
		ValaDataType* _tmp524_;
		ValaTypeSymbol* _tmp525_;
		ValaTypeSymbol* _tmp526_;
		ValaEnum* _tmp527_;
		_tmp523_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp524_ = _tmp523_;
		_tmp525_ = vala_data_type_get_data_type (_tmp524_);
		_tmp526_ = _tmp525_;
		_tmp527_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp526_, VALA_TYPE_ENUM, ValaEnum));
		enum_type = _tmp527_;
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp528_;
			ValaList* _tmp529_;
			gint _val_size = 0;
			ValaList* _tmp530_;
			gint _tmp531_;
			gint _tmp532_;
			gint _val_index = 0;
			_tmp528_ = enum_type;
			_tmp529_ = vala_enum_get_values (_tmp528_);
			_val_list = _tmp529_;
			_tmp530_ = _val_list;
			_tmp531_ = vala_collection_get_size ((ValaCollection*) _tmp530_);
			_tmp532_ = _tmp531_;
			_val_size = _tmp532_;
			_val_index = -1;
			while (TRUE) {
				ValaEnumValue* val = NULL;
				ValaList* _tmp533_;
				gpointer _tmp534_;
				const gchar* _tmp535_;
				ValaEnumValue* _tmp536_;
				const gchar* _tmp537_;
				const gchar* _tmp538_;
				_val_index = _val_index + 1;
				if (!(_val_index < _val_size)) {
					break;
				}
				_tmp533_ = _val_list;
				_tmp534_ = vala_list_get (_tmp533_, _val_index);
				val = (ValaEnumValue*) _tmp534_;
				_tmp535_ = self->priv->_member_name;
				_tmp536_ = val;
				_tmp537_ = vala_symbol_get_name ((ValaSymbol*) _tmp536_);
				_tmp538_ = _tmp537_;
				if (g_strcmp0 (_tmp535_, _tmp538_) == 0) {
					ValaEnumValue* _tmp539_;
					_tmp539_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp539_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
		_vala_code_node_unref0 (enum_type);
	}
	_tmp540_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp541_ = _tmp540_;
	if (_tmp541_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp542_;
		gboolean _tmp543_ = FALSE;
		ValaExpression* _tmp544_;
		ValaExpression* _tmp545_;
		ValaSourceReference* _tmp558_;
		ValaSourceReference* _tmp559_;
		const gchar* _tmp560_;
		const gchar* _tmp561_;
		gchar* _tmp562_;
		gchar* _tmp563_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp542_ = g_strdup ("(null)");
		base_type_name = _tmp542_;
		_tmp544_ = vala_member_access_get_inner (self);
		_tmp545_ = _tmp544_;
		if (_tmp545_ != NULL) {
			ValaExpression* _tmp546_;
			ValaExpression* _tmp547_;
			ValaDataType* _tmp548_;
			ValaDataType* _tmp549_;
			_tmp546_ = vala_member_access_get_inner (self);
			_tmp547_ = _tmp546_;
			_tmp548_ = vala_expression_get_value_type (_tmp547_);
			_tmp549_ = _tmp548_;
			_tmp543_ = _tmp549_ != NULL;
		} else {
			_tmp543_ = FALSE;
		}
		if (_tmp543_) {
			ValaExpression* _tmp550_;
			ValaExpression* _tmp551_;
			ValaDataType* _tmp552_;
			ValaDataType* _tmp553_;
			gchar* _tmp554_;
			_tmp550_ = vala_member_access_get_inner (self);
			_tmp551_ = _tmp550_;
			_tmp552_ = vala_expression_get_value_type (_tmp551_);
			_tmp553_ = _tmp552_;
			_tmp554_ = vala_code_node_to_string ((ValaCodeNode*) _tmp553_);
			_g_free0 (base_type_name);
			base_type_name = _tmp554_;
		} else {
			ValaSymbol* _tmp555_;
			_tmp555_ = base_symbol;
			if (_tmp555_ != NULL) {
				ValaSymbol* _tmp556_;
				gchar* _tmp557_;
				_tmp556_ = base_symbol;
				_tmp557_ = vala_symbol_get_full_name (_tmp556_);
				_g_free0 (base_type_name);
				base_type_name = _tmp557_;
			}
		}
		_tmp558_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp559_ = _tmp558_;
		_tmp560_ = self->priv->_member_name;
		_tmp561_ = base_type_name;
		_tmp562_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'", _tmp560_, _tmp561_);
		_tmp563_ = _tmp562_;
		vala_report_error (_tmp559_, _tmp563_);
		_g_free0 (_tmp563_);
		result = FALSE;
		_g_free0 (base_type_name);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp564_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp565_ = _tmp564_;
	_tmp566_ = _vala_code_node_ref0 (_tmp565_);
	member = _tmp566_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp567_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp567_, context)) {
		result = FALSE;
		_vala_code_node_unref0 (member);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp568_ = member;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp568_, VALA_TYPE_LOCAL_VARIABLE)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp569_;
		ValaLocalVariable* _tmp570_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp571_;
		ValaSymbol* _tmp572_;
		ValaSymbol* _tmp573_;
		ValaBlock* _tmp574_;
		gboolean _tmp575_ = FALSE;
		ValaBlock* _tmp576_;
		_tmp569_ = member;
		_tmp570_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp569_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable));
		local = _tmp570_;
		_tmp571_ = local;
		_tmp572_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp571_);
		_tmp573_ = _tmp572_;
		_tmp574_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp573_, VALA_TYPE_BLOCK) ? ((ValaBlock*) _tmp573_) : NULL);
		block = _tmp574_;
		_tmp576_ = block;
		if (_tmp576_ != NULL) {
			ValaSemanticAnalyzer* _tmp577_;
			ValaSemanticAnalyzer* _tmp578_;
			ValaBlock* _tmp579_;
			ValaSymbol* _tmp580_;
			ValaSymbol* _tmp581_;
			ValaSemanticAnalyzer* _tmp582_;
			ValaSemanticAnalyzer* _tmp583_;
			ValaSymbol* _tmp584_;
			ValaSymbol* _tmp585_;
			_tmp577_ = vala_code_context_get_analyzer (context);
			_tmp578_ = _tmp577_;
			_tmp579_ = block;
			_tmp580_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp578_, (ValaSymbol*) _tmp579_);
			_tmp581_ = _tmp580_;
			_tmp582_ = vala_code_context_get_analyzer (context);
			_tmp583_ = _tmp582_;
			_tmp584_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp583_);
			_tmp585_ = _tmp584_;
			_tmp575_ = _tmp581_ != _tmp585_;
			_vala_code_node_unref0 (_tmp581_);
		} else {
			_tmp575_ = FALSE;
		}
		if (_tmp575_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp586_;
			ValaSemanticAnalyzer* _tmp587_;
			ValaSymbol* _tmp588_;
			ValaSymbol* _tmp589_;
			ValaSymbol* _tmp590_;
			ValaLocalVariable* _tmp603_;
			ValaBlock* _tmp604_;
			_tmp586_ = vala_code_context_get_analyzer (context);
			_tmp587_ = _tmp586_;
			_tmp588_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp587_);
			_tmp589_ = _tmp588_;
			_tmp590_ = _vala_code_node_ref0 (_tmp589_);
			sym = _tmp590_;
			while (TRUE) {
				ValaSymbol* _tmp591_;
				ValaBlock* _tmp592_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp593_;
				ValaMethod* _tmp594_;
				ValaMethod* _tmp595_;
				ValaSymbol* _tmp599_;
				ValaSymbol* _tmp600_;
				ValaSymbol* _tmp601_;
				ValaSymbol* _tmp602_;
				_tmp591_ = sym;
				_tmp592_ = block;
				if (!(_tmp591_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp592_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp593_ = sym;
				_tmp594_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp593_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp593_) : NULL);
				method = _tmp594_;
				_tmp595_ = method;
				if (_tmp595_ != NULL) {
					ValaMethod* _tmp596_;
					ValaMethod* _tmp597_;
					ValaLocalVariable* _tmp598_;
					_tmp596_ = method;
					vala_method_set_closure (_tmp596_, TRUE);
					_tmp597_ = method;
					_tmp598_ = local;
					vala_method_add_captured_variable (_tmp597_, _tmp598_);
				}
				_tmp599_ = sym;
				_tmp600_ = vala_symbol_get_parent_symbol (_tmp599_);
				_tmp601_ = _tmp600_;
				_tmp602_ = _vala_code_node_ref0 (_tmp601_);
				_vala_code_node_unref0 (sym);
				sym = _tmp602_;
				_vala_code_node_unref0 (method);
			}
			_tmp603_ = local;
			vala_local_variable_set_captured (_tmp603_, TRUE);
			_tmp604_ = block;
			vala_block_set_captured (_tmp604_, TRUE);
			_vala_code_node_unref0 (sym);
		}
		_vala_code_node_unref0 (block);
		_vala_code_node_unref0 (local);
	} else {
		ValaSymbol* _tmp605_;
		_tmp605_ = member;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp605_, VALA_TYPE_PARAMETER)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp606_;
			ValaParameter* _tmp607_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp608_;
			ValaSymbol* _tmp609_;
			ValaSymbol* _tmp610_;
			ValaMethod* _tmp611_;
			gboolean _tmp612_ = FALSE;
			gboolean _tmp613_ = FALSE;
			ValaMethod* _tmp614_;
			_tmp606_ = member;
			_tmp607_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp606_, VALA_TYPE_PARAMETER, ValaParameter));
			param = _tmp607_;
			_tmp608_ = param;
			_tmp609_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp608_);
			_tmp610_ = _tmp609_;
			_tmp611_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp610_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp610_) : NULL);
			m = _tmp611_;
			_tmp614_ = m;
			if (_tmp614_ != NULL) {
				ValaMethod* _tmp615_;
				ValaSemanticAnalyzer* _tmp616_;
				ValaSemanticAnalyzer* _tmp617_;
				ValaSymbol* _tmp618_;
				ValaSymbol* _tmp619_;
				_tmp615_ = m;
				_tmp616_ = vala_code_context_get_analyzer (context);
				_tmp617_ = _tmp616_;
				_tmp618_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp617_);
				_tmp619_ = _tmp618_;
				_tmp613_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp615_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp619_;
			} else {
				_tmp613_ = FALSE;
			}
			if (_tmp613_) {
				ValaParameter* _tmp620_;
				ValaMethod* _tmp621_;
				ValaParameter* _tmp622_;
				ValaParameter* _tmp623_;
				_tmp620_ = param;
				_tmp621_ = m;
				_tmp622_ = vala_method_get_this_parameter (_tmp621_);
				_tmp623_ = _tmp622_;
				_tmp612_ = _tmp620_ != _tmp623_;
			} else {
				_tmp612_ = FALSE;
			}
			if (_tmp612_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp624_;
				ValaSemanticAnalyzer* _tmp625_;
				ValaSymbol* _tmp626_;
				ValaSymbol* _tmp627_;
				ValaSymbol* _tmp628_;
				ValaParameter* _tmp639_;
				ValaMethod* _tmp640_;
				ValaBlock* _tmp641_;
				ValaBlock* _tmp642_;
				ValaParameter* _tmp643_;
				ValaParameterDirection _tmp644_;
				ValaParameterDirection _tmp645_;
				_tmp624_ = vala_code_context_get_analyzer (context);
				_tmp625_ = _tmp624_;
				_tmp626_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp625_);
				_tmp627_ = _tmp626_;
				_tmp628_ = _vala_code_node_ref0 (_tmp627_);
				sym = _tmp628_;
				while (TRUE) {
					ValaSymbol* _tmp629_;
					ValaMethod* _tmp630_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp631_;
					ValaMethod* _tmp632_;
					ValaMethod* _tmp633_;
					ValaSymbol* _tmp635_;
					ValaSymbol* _tmp636_;
					ValaSymbol* _tmp637_;
					ValaSymbol* _tmp638_;
					_tmp629_ = sym;
					_tmp630_ = m;
					if (!(_tmp629_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp630_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp631_ = sym;
					_tmp632_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp631_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp631_) : NULL);
					method = _tmp632_;
					_tmp633_ = method;
					if (_tmp633_ != NULL) {
						ValaMethod* _tmp634_;
						_tmp634_ = method;
						vala_method_set_closure (_tmp634_, TRUE);
					}
					_tmp635_ = sym;
					_tmp636_ = vala_symbol_get_parent_symbol (_tmp635_);
					_tmp637_ = _tmp636_;
					_tmp638_ = _vala_code_node_ref0 (_tmp637_);
					_vala_code_node_unref0 (sym);
					sym = _tmp638_;
					_vala_code_node_unref0 (method);
				}
				_tmp639_ = param;
				vala_parameter_set_captured (_tmp639_, TRUE);
				_tmp640_ = m;
				_tmp641_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp640_);
				_tmp642_ = _tmp641_;
				vala_block_set_captured (_tmp642_, TRUE);
				_tmp643_ = param;
				_tmp644_ = vala_parameter_get_direction (_tmp643_);
				_tmp645_ = _tmp644_;
				if (_tmp645_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp646_;
					ValaSourceReference* _tmp647_;
					ValaParameter* _tmp648_;
					gchar* _tmp649_;
					gchar* _tmp650_;
					gchar* _tmp651_;
					gchar* _tmp652_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp646_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp647_ = _tmp646_;
					_tmp648_ = param;
					_tmp649_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp648_);
					_tmp650_ = _tmp649_;
					_tmp651_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp650_);
					_tmp652_ = _tmp651_;
					vala_report_error (_tmp647_, _tmp652_);
					_g_free0 (_tmp652_);
					_g_free0 (_tmp650_);
				}
				_vala_code_node_unref0 (sym);
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp653_;
				ValaSymbol* _tmp654_;
				ValaSymbol* _tmp655_;
				ValaSymbol* _tmp656_;
				ValaSymbol* _tmp657_;
				ValaPropertyAccessor* _tmp658_;
				gboolean _tmp659_ = FALSE;
				gboolean _tmp660_ = FALSE;
				ValaPropertyAccessor* _tmp661_;
				_tmp653_ = param;
				_tmp654_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp653_);
				_tmp655_ = _tmp654_;
				_tmp656_ = vala_symbol_get_parent_symbol (_tmp655_);
				_tmp657_ = _tmp656_;
				_tmp658_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp657_, VALA_TYPE_PROPERTY_ACCESSOR) ? ((ValaPropertyAccessor*) _tmp657_) : NULL);
				acc = _tmp658_;
				_tmp661_ = acc;
				if (_tmp661_ != NULL) {
					ValaPropertyAccessor* _tmp662_;
					ValaSemanticAnalyzer* _tmp663_;
					ValaSemanticAnalyzer* _tmp664_;
					ValaSymbol* _tmp665_;
					ValaSymbol* _tmp666_;
					_tmp662_ = acc;
					_tmp663_ = vala_code_context_get_analyzer (context);
					_tmp664_ = _tmp663_;
					_tmp665_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp664_);
					_tmp666_ = _tmp665_;
					_tmp660_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp662_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp666_;
				} else {
					_tmp660_ = FALSE;
				}
				if (_tmp660_) {
					ValaParameter* _tmp667_;
					ValaPropertyAccessor* _tmp668_;
					ValaProperty* _tmp669_;
					ValaProperty* _tmp670_;
					ValaParameter* _tmp671_;
					ValaParameter* _tmp672_;
					_tmp667_ = param;
					_tmp668_ = acc;
					_tmp669_ = vala_property_accessor_get_prop (_tmp668_);
					_tmp670_ = _tmp669_;
					_tmp671_ = vala_property_get_this_parameter (_tmp670_);
					_tmp672_ = _tmp671_;
					_tmp659_ = _tmp667_ != _tmp672_;
				} else {
					_tmp659_ = FALSE;
				}
				if (_tmp659_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp673_;
					ValaSemanticAnalyzer* _tmp674_;
					ValaSymbol* _tmp675_;
					ValaSymbol* _tmp676_;
					ValaSymbol* _tmp677_;
					ValaParameter* _tmp688_;
					ValaPropertyAccessor* _tmp689_;
					ValaBlock* _tmp690_;
					ValaBlock* _tmp691_;
					_tmp673_ = vala_code_context_get_analyzer (context);
					_tmp674_ = _tmp673_;
					_tmp675_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp674_);
					_tmp676_ = _tmp675_;
					_tmp677_ = _vala_code_node_ref0 (_tmp676_);
					sym = _tmp677_;
					while (TRUE) {
						ValaSymbol* _tmp678_;
						ValaMethod* _tmp679_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp680_;
						ValaMethod* _tmp681_;
						ValaMethod* _tmp682_;
						ValaSymbol* _tmp684_;
						ValaSymbol* _tmp685_;
						ValaSymbol* _tmp686_;
						ValaSymbol* _tmp687_;
						_tmp678_ = sym;
						_tmp679_ = m;
						if (!(_tmp678_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp679_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp680_ = sym;
						_tmp681_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp680_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp680_) : NULL);
						method = _tmp681_;
						_tmp682_ = method;
						if (_tmp682_ != NULL) {
							ValaMethod* _tmp683_;
							_tmp683_ = method;
							vala_method_set_closure (_tmp683_, TRUE);
						}
						_tmp684_ = sym;
						_tmp685_ = vala_symbol_get_parent_symbol (_tmp684_);
						_tmp686_ = _tmp685_;
						_tmp687_ = _vala_code_node_ref0 (_tmp686_);
						_vala_code_node_unref0 (sym);
						sym = _tmp687_;
						_vala_code_node_unref0 (method);
					}
					_tmp688_ = param;
					vala_parameter_set_captured (_tmp688_, TRUE);
					_tmp689_ = acc;
					_tmp690_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp689_);
					_tmp691_ = _tmp690_;
					vala_block_set_captured (_tmp691_, TRUE);
					_vala_code_node_unref0 (sym);
				}
				_vala_code_node_unref0 (acc);
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (param);
		} else {
			ValaSymbol* _tmp692_;
			_tmp692_ = member;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp692_, VALA_TYPE_FIELD)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp693_;
				ValaField* _tmp694_;
				ValaField* _tmp695_;
				ValaSymbolAccessibility _tmp696_;
				ValaSymbolAccessibility _tmp697_;
				ValaField* _tmp698_;
				ValaMemberBinding _tmp699_;
				ValaMemberBinding _tmp700_;
				ValaField* _tmp701_;
				ValaMemberBinding _tmp702_;
				ValaMemberBinding _tmp703_;
				ValaField* _tmp704_;
				ValaDataType* _tmp705_;
				ValaDataType* _tmp706_;
				_tmp693_ = member;
				_tmp694_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp693_, VALA_TYPE_FIELD, ValaField));
				f = _tmp694_;
				_tmp695_ = f;
				_tmp696_ = vala_symbol_get_access ((ValaSymbol*) _tmp695_);
				_tmp697_ = _tmp696_;
				access = _tmp697_;
				_tmp698_ = f;
				_tmp699_ = vala_field_get_binding (_tmp698_);
				_tmp700_ = _tmp699_;
				instance = _tmp700_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp701_ = f;
				_tmp702_ = vala_field_get_binding (_tmp701_);
				_tmp703_ = _tmp702_;
				klass = _tmp703_ == VALA_MEMBER_BINDING_CLASS;
				_tmp704_ = f;
				_tmp705_ = vala_variable_get_variable_type ((ValaVariable*) _tmp704_);
				_tmp706_ = _tmp705_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp706_, VALA_TYPE_GENERIC_TYPE)) {
					generics = TRUE;
				}
				_vala_code_node_unref0 (f);
			} else {
				ValaSymbol* _tmp707_;
				_tmp707_ = member;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp707_, VALA_TYPE_CONSTANT)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp708_;
					ValaConstant* _tmp709_;
					ValaConstant* _tmp710_;
					ValaSymbolAccessibility _tmp711_;
					ValaSymbolAccessibility _tmp712_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp713_;
					ValaSymbol* _tmp714_;
					ValaSymbol* _tmp715_;
					ValaBlock* _tmp716_;
					gboolean _tmp717_ = FALSE;
					ValaBlock* _tmp718_;
					_tmp708_ = member;
					_tmp709_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp708_, VALA_TYPE_CONSTANT, ValaConstant));
					c = _tmp709_;
					_tmp710_ = c;
					_tmp711_ = vala_symbol_get_access ((ValaSymbol*) _tmp710_);
					_tmp712_ = _tmp711_;
					access = _tmp712_;
					_tmp713_ = c;
					_tmp714_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp713_);
					_tmp715_ = _tmp714_;
					_tmp716_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp715_, VALA_TYPE_BLOCK) ? ((ValaBlock*) _tmp715_) : NULL);
					block = _tmp716_;
					_tmp718_ = block;
					if (_tmp718_ != NULL) {
						ValaSemanticAnalyzer* _tmp719_;
						ValaSemanticAnalyzer* _tmp720_;
						ValaBlock* _tmp721_;
						ValaSymbol* _tmp722_;
						ValaSymbol* _tmp723_;
						ValaSemanticAnalyzer* _tmp724_;
						ValaSemanticAnalyzer* _tmp725_;
						ValaSymbol* _tmp726_;
						ValaSymbol* _tmp727_;
						_tmp719_ = vala_code_context_get_analyzer (context);
						_tmp720_ = _tmp719_;
						_tmp721_ = block;
						_tmp722_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp720_, (ValaSymbol*) _tmp721_);
						_tmp723_ = _tmp722_;
						_tmp724_ = vala_code_context_get_analyzer (context);
						_tmp725_ = _tmp724_;
						_tmp726_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp725_);
						_tmp727_ = _tmp726_;
						_tmp717_ = _tmp723_ != _tmp727_;
						_vala_code_node_unref0 (_tmp723_);
					} else {
						_tmp717_ = FALSE;
					}
					if (_tmp717_) {
						ValaSourceReference* _tmp728_;
						ValaSourceReference* _tmp729_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp728_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp729_ = _tmp728_;
						vala_report_error (_tmp729_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_code_node_unref0 (block);
						_vala_code_node_unref0 (c);
						_vala_code_node_unref0 (member);
						_vala_code_node_unref0 (this_parameter);
						_vala_code_node_unref0 (base_symbol);
						return result;
					}
					_vala_code_node_unref0 (block);
					_vala_code_node_unref0 (c);
				} else {
					ValaSymbol* _tmp730_;
					_tmp730_ = member;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp730_, VALA_TYPE_METHOD)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp731_;
						ValaMethod* _tmp732_;
						ValaMethod* _tmp733_;
						gboolean _tmp734_;
						gboolean _tmp735_;
						ValaMethod* _tmp837_;
						ValaSymbolAccessibility _tmp838_;
						ValaSymbolAccessibility _tmp839_;
						ValaMethod* _tmp840_;
						ValaMethod* _tmp844_;
						ValaMemberBinding _tmp845_;
						ValaMemberBinding _tmp846_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp865_;
						ValaDataType* _tmp866_;
						ValaDataType* _tmp867_;
						ValaGenericType* _tmp868_;
						gboolean _tmp869_ = FALSE;
						ValaGenericType* _tmp870_;
						_tmp731_ = member;
						_tmp732_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp731_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp732_;
						_tmp733_ = m;
						_tmp734_ = vala_method_get_is_async_callback (_tmp733_);
						_tmp735_ = _tmp734_;
						if (_tmp735_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp736_;
							ValaSemanticAnalyzer* _tmp737_;
							ValaMethod* _tmp738_;
							ValaMethod* _tmp739_;
							ValaMethod* _tmp740_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp741_;
							ValaMethod* _tmp774_;
							ValaSemanticAnalyzer* _tmp775_;
							ValaSemanticAnalyzer* _tmp776_;
							ValaMethod* _tmp777_;
							ValaMethod* _tmp778_;
							ValaMethod* _tmp797_;
							ValaMethod* _tmp798_;
							ValaMethod* _tmp799_;
							ValaSymbol* _tmp800_;
							ValaSymbol* _tmp801_;
							ValaSymbol* _tmp802_;
							_tmp736_ = vala_code_context_get_analyzer (context);
							_tmp737_ = _tmp736_;
							_tmp738_ = vala_semantic_analyzer_get_current_async_method (_tmp737_);
							_tmp739_ = _tmp738_;
							_tmp740_ = _vala_code_node_ref0 (_tmp739_);
							async_method = _tmp740_;
							is_valid_access = FALSE;
							_tmp741_ = async_method;
							if (_tmp741_ != NULL) {
								ValaMethod* _tmp742_;
								ValaMethod* _tmp743_;
								ValaMethod* _tmp744_;
								ValaMethod* _tmp745_;
								gboolean _tmp746_;
								_tmp742_ = m;
								_tmp743_ = async_method;
								_tmp744_ = vala_method_get_callback_method (_tmp743_);
								_tmp745_ = _tmp744_;
								_tmp746_ = _tmp742_ == _tmp745_;
								_vala_code_node_unref0 (_tmp745_);
								if (_tmp746_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp747_ = FALSE;
									ValaMethod* _tmp748_;
									ValaMethod* _tmp749_;
									ValaMethod* _tmp750_;
									_tmp748_ = async_method;
									_tmp749_ = vala_method_get_base_method (_tmp748_);
									_tmp750_ = _tmp749_;
									if (_tmp750_ != NULL) {
										ValaMethod* _tmp751_;
										ValaMethod* _tmp752_;
										ValaMethod* _tmp753_;
										ValaMethod* _tmp754_;
										ValaMethod* _tmp755_;
										ValaMethod* _tmp756_;
										_tmp751_ = m;
										_tmp752_ = async_method;
										_tmp753_ = vala_method_get_base_method (_tmp752_);
										_tmp754_ = _tmp753_;
										_tmp755_ = vala_method_get_callback_method (_tmp754_);
										_tmp756_ = _tmp755_;
										_tmp747_ = _tmp751_ == _tmp756_;
										_vala_code_node_unref0 (_tmp756_);
									} else {
										_tmp747_ = FALSE;
									}
									if (_tmp747_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp757_ = FALSE;
										ValaMethod* _tmp758_;
										ValaMethod* _tmp759_;
										ValaMethod* _tmp760_;
										_tmp758_ = async_method;
										_tmp759_ = vala_method_get_base_interface_method (_tmp758_);
										_tmp760_ = _tmp759_;
										if (_tmp760_ != NULL) {
											ValaMethod* _tmp761_;
											ValaMethod* _tmp762_;
											ValaMethod* _tmp763_;
											ValaMethod* _tmp764_;
											ValaMethod* _tmp765_;
											ValaMethod* _tmp766_;
											_tmp761_ = m;
											_tmp762_ = async_method;
											_tmp763_ = vala_method_get_base_interface_method (_tmp762_);
											_tmp764_ = _tmp763_;
											_tmp765_ = vala_method_get_callback_method (_tmp764_);
											_tmp766_ = _tmp765_;
											_tmp757_ = _tmp761_ == _tmp766_;
											_vala_code_node_unref0 (_tmp766_);
										} else {
											_tmp757_ = FALSE;
										}
										if (_tmp757_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp767_;
								ValaSourceReference* _tmp768_;
								ValaMethod* _tmp769_;
								gchar* _tmp770_;
								gchar* _tmp771_;
								gchar* _tmp772_;
								gchar* _tmp773_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp767_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp768_ = _tmp767_;
								_tmp769_ = m;
								_tmp770_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp769_);
								_tmp771_ = _tmp770_;
								_tmp772_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp771_);
								_tmp773_ = _tmp772_;
								vala_report_error (_tmp768_, _tmp773_);
								_g_free0 (_tmp773_);
								_g_free0 (_tmp771_);
								result = FALSE;
								_vala_code_node_unref0 (async_method);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp774_ = async_method;
							_tmp775_ = vala_code_context_get_analyzer (context);
							_tmp776_ = _tmp775_;
							_tmp777_ = vala_semantic_analyzer_get_current_method (_tmp776_);
							_tmp778_ = _tmp777_;
							if (_tmp774_ != _tmp778_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp779_;
								ValaSemanticAnalyzer* _tmp780_;
								ValaMethod* _tmp781_;
								ValaMethod* _tmp782_;
								ValaSymbol* _tmp783_;
								ValaMethod* _tmp794_;
								ValaBlock* _tmp795_;
								ValaBlock* _tmp796_;
								_tmp779_ = vala_code_context_get_analyzer (context);
								_tmp780_ = _tmp779_;
								_tmp781_ = vala_semantic_analyzer_get_current_method (_tmp780_);
								_tmp782_ = _tmp781_;
								_tmp783_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp782_);
								sym = _tmp783_;
								while (TRUE) {
									ValaSymbol* _tmp784_;
									ValaMethod* _tmp785_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp786_;
									ValaMethod* _tmp787_;
									ValaMethod* _tmp788_;
									ValaSymbol* _tmp790_;
									ValaSymbol* _tmp791_;
									ValaSymbol* _tmp792_;
									ValaSymbol* _tmp793_;
									_tmp784_ = sym;
									_tmp785_ = async_method;
									if (!(_tmp784_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp785_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp786_ = sym;
									_tmp787_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp786_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp786_) : NULL);
									method = _tmp787_;
									_tmp788_ = method;
									if (_tmp788_ != NULL) {
										ValaMethod* _tmp789_;
										_tmp789_ = method;
										vala_method_set_closure (_tmp789_, TRUE);
									}
									_tmp790_ = sym;
									_tmp791_ = vala_symbol_get_parent_symbol (_tmp790_);
									_tmp792_ = _tmp791_;
									_tmp793_ = _vala_code_node_ref0 (_tmp792_);
									_vala_code_node_unref0 (sym);
									sym = _tmp793_;
									_vala_code_node_unref0 (method);
								}
								_tmp794_ = async_method;
								_tmp795_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp794_);
								_tmp796_ = _tmp795_;
								vala_block_set_captured (_tmp796_, TRUE);
								_vala_code_node_unref0 (sym);
							}
							_tmp797_ = async_method;
							_tmp798_ = vala_method_get_callback_method (_tmp797_);
							_vala_code_node_unref0 (m);
							m = _tmp798_;
							_tmp799_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp799_);
							_tmp800_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp801_ = _tmp800_;
							_tmp802_ = _vala_code_node_ref0 (_tmp801_);
							_vala_code_node_unref0 (member);
							member = _tmp802_;
							_vala_code_node_unref0 (async_method);
						} else {
							ValaMethod* _tmp803_;
							ValaMethod* _tmp804_;
							ValaMethod* _tmp805_;
							_tmp803_ = m;
							_tmp804_ = vala_method_get_base_method (_tmp803_);
							_tmp805_ = _tmp804_;
							if (_tmp805_ != NULL) {
								ValaMethod* _tmp806_;
								ValaMethod* _tmp807_;
								ValaMethod* _tmp808_;
								ValaMethod* _tmp809_;
								ValaMethod* _tmp810_;
								ValaSignal* _tmp811_;
								ValaSignal* _tmp812_;
								ValaSymbol* _tmp817_;
								ValaSymbol* _tmp818_;
								ValaSymbol* _tmp819_;
								_tmp806_ = m;
								_tmp807_ = vala_method_get_base_method (_tmp806_);
								_tmp808_ = _tmp807_;
								_tmp809_ = _vala_code_node_ref0 (_tmp808_);
								_vala_code_node_unref0 (m);
								m = _tmp809_;
								_tmp810_ = m;
								_tmp811_ = vala_method_get_signal_reference (_tmp810_);
								_tmp812_ = _tmp811_;
								if (_tmp812_ != NULL) {
									ValaMethod* _tmp813_;
									ValaSignal* _tmp814_;
									ValaSignal* _tmp815_;
									_tmp813_ = m;
									_tmp814_ = vala_method_get_signal_reference (_tmp813_);
									_tmp815_ = _tmp814_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp815_);
								} else {
									ValaMethod* _tmp816_;
									_tmp816_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp816_);
								}
								_tmp817_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp818_ = _tmp817_;
								_tmp819_ = _vala_code_node_ref0 (_tmp818_);
								_vala_code_node_unref0 (member);
								member = _tmp819_;
							} else {
								ValaMethod* _tmp820_;
								ValaMethod* _tmp821_;
								ValaMethod* _tmp822_;
								_tmp820_ = m;
								_tmp821_ = vala_method_get_base_interface_method (_tmp820_);
								_tmp822_ = _tmp821_;
								if (_tmp822_ != NULL) {
									ValaMethod* _tmp823_;
									ValaMethod* _tmp824_;
									ValaMethod* _tmp825_;
									ValaMethod* _tmp826_;
									ValaMethod* _tmp827_;
									ValaSignal* _tmp828_;
									ValaSignal* _tmp829_;
									ValaSymbol* _tmp834_;
									ValaSymbol* _tmp835_;
									ValaSymbol* _tmp836_;
									_tmp823_ = m;
									_tmp824_ = vala_method_get_base_interface_method (_tmp823_);
									_tmp825_ = _tmp824_;
									_tmp826_ = _vala_code_node_ref0 (_tmp825_);
									_vala_code_node_unref0 (m);
									m = _tmp826_;
									_tmp827_ = m;
									_tmp828_ = vala_method_get_signal_reference (_tmp827_);
									_tmp829_ = _tmp828_;
									if (_tmp829_ != NULL) {
										ValaMethod* _tmp830_;
										ValaSignal* _tmp831_;
										ValaSignal* _tmp832_;
										_tmp830_ = m;
										_tmp831_ = vala_method_get_signal_reference (_tmp830_);
										_tmp832_ = _tmp831_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp832_);
									} else {
										ValaMethod* _tmp833_;
										_tmp833_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp833_);
									}
									_tmp834_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp835_ = _tmp834_;
									_tmp836_ = _vala_code_node_ref0 (_tmp835_);
									_vala_code_node_unref0 (member);
									member = _tmp836_;
								}
							}
						}
						_tmp837_ = m;
						_tmp838_ = vala_symbol_get_access ((ValaSymbol*) _tmp837_);
						_tmp839_ = _tmp838_;
						access = _tmp839_;
						_tmp840_ = m;
						if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp840_, VALA_TYPE_CREATION_METHOD)) {
							ValaMethod* _tmp841_;
							ValaMemberBinding _tmp842_;
							ValaMemberBinding _tmp843_;
							_tmp841_ = m;
							_tmp842_ = vala_method_get_binding (_tmp841_);
							_tmp843_ = _tmp842_;
							instance = _tmp843_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp844_ = m;
						_tmp845_ = vala_method_get_binding (_tmp844_);
						_tmp846_ = _tmp845_;
						klass = _tmp846_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp847_;
							ValaList* _tmp848_;
							gint _param_size = 0;
							ValaList* _tmp849_;
							gint _tmp850_;
							gint _tmp851_;
							gint _param_index = 0;
							_tmp847_ = m;
							_tmp848_ = vala_callable_get_parameters ((ValaCallable*) _tmp847_);
							_param_list = _tmp848_;
							_tmp849_ = _param_list;
							_tmp850_ = vala_collection_get_size ((ValaCollection*) _tmp849_);
							_tmp851_ = _tmp850_;
							_param_size = _tmp851_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp852_;
								gpointer _tmp853_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp854_;
								ValaDataType* _tmp855_;
								ValaDataType* _tmp856_;
								ValaGenericType* _tmp857_;
								gboolean _tmp858_ = FALSE;
								ValaGenericType* _tmp859_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp852_ = _param_list;
								_tmp853_ = vala_list_get (_tmp852_, _param_index);
								param = (ValaParameter*) _tmp853_;
								_tmp854_ = param;
								_tmp855_ = vala_variable_get_variable_type ((ValaVariable*) _tmp854_);
								_tmp856_ = _tmp855_;
								_tmp857_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp856_, VALA_TYPE_GENERIC_TYPE) ? ((ValaGenericType*) _tmp856_) : NULL);
								generic_type = _tmp857_;
								_tmp859_ = generic_type;
								if (_tmp859_ != NULL) {
									ValaGenericType* _tmp860_;
									ValaTypeParameter* _tmp861_;
									ValaTypeParameter* _tmp862_;
									ValaSymbol* _tmp863_;
									ValaSymbol* _tmp864_;
									_tmp860_ = generic_type;
									_tmp861_ = vala_generic_type_get_type_parameter (_tmp860_);
									_tmp862_ = _tmp861_;
									_tmp863_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp862_);
									_tmp864_ = _tmp863_;
									_tmp858_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp864_, VALA_TYPE_TYPESYMBOL);
								} else {
									_tmp858_ = FALSE;
								}
								if (_tmp858_) {
									generics = TRUE;
									_vala_code_node_unref0 (generic_type);
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (generic_type);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp865_ = m;
						_tmp866_ = vala_callable_get_return_type ((ValaCallable*) _tmp865_);
						_tmp867_ = _tmp866_;
						_tmp868_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp867_, VALA_TYPE_GENERIC_TYPE) ? ((ValaGenericType*) _tmp867_) : NULL);
						generic_type = _tmp868_;
						_tmp870_ = generic_type;
						if (_tmp870_ != NULL) {
							ValaGenericType* _tmp871_;
							ValaTypeParameter* _tmp872_;
							ValaTypeParameter* _tmp873_;
							ValaSymbol* _tmp874_;
							ValaSymbol* _tmp875_;
							_tmp871_ = generic_type;
							_tmp872_ = vala_generic_type_get_type_parameter (_tmp871_);
							_tmp873_ = _tmp872_;
							_tmp874_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp873_);
							_tmp875_ = _tmp874_;
							_tmp869_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp875_, VALA_TYPE_TYPESYMBOL);
						} else {
							_tmp869_ = FALSE;
						}
						if (_tmp869_) {
							generics = TRUE;
						}
						_vala_code_node_unref0 (generic_type);
						_vala_code_node_unref0 (m);
					} else {
						ValaSymbol* _tmp876_;
						_tmp876_ = member;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp876_, VALA_TYPE_PROPERTY)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp877_;
							ValaProperty* _tmp878_;
							ValaProperty* _tmp879_;
							ValaProperty* _tmp880_;
							ValaProperty* _tmp881_;
							ValaProperty* _tmp882_;
							ValaProperty* _tmp902_;
							ValaSymbolAccessibility _tmp903_;
							ValaSymbolAccessibility _tmp904_;
							gboolean _tmp905_;
							gboolean _tmp906_;
							ValaProperty* _tmp971_;
							ValaMemberBinding _tmp972_;
							ValaMemberBinding _tmp973_;
							ValaProperty* _tmp974_;
							ValaDataType* _tmp975_;
							ValaDataType* _tmp976_;
							_tmp877_ = member;
							_tmp878_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp877_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp878_;
							_tmp879_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp879_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_code_node_unref0 (prop);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp880_ = prop;
							_tmp881_ = vala_property_get_base_property (_tmp880_);
							_tmp882_ = _tmp881_;
							if (_tmp882_ != NULL) {
								ValaProperty* _tmp883_;
								ValaProperty* _tmp884_;
								ValaProperty* _tmp885_;
								ValaProperty* _tmp886_;
								ValaProperty* _tmp887_;
								ValaSymbol* _tmp888_;
								ValaSymbol* _tmp889_;
								ValaSymbol* _tmp890_;
								_tmp883_ = prop;
								_tmp884_ = vala_property_get_base_property (_tmp883_);
								_tmp885_ = _tmp884_;
								_tmp886_ = _vala_code_node_ref0 (_tmp885_);
								_vala_code_node_unref0 (prop);
								prop = _tmp886_;
								_tmp887_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp887_);
								_tmp888_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp889_ = _tmp888_;
								_tmp890_ = _vala_code_node_ref0 (_tmp889_);
								_vala_code_node_unref0 (member);
								member = _tmp890_;
							} else {
								ValaProperty* _tmp891_;
								ValaProperty* _tmp892_;
								ValaProperty* _tmp893_;
								_tmp891_ = prop;
								_tmp892_ = vala_property_get_base_interface_property (_tmp891_);
								_tmp893_ = _tmp892_;
								if (_tmp893_ != NULL) {
									ValaProperty* _tmp894_;
									ValaProperty* _tmp895_;
									ValaProperty* _tmp896_;
									ValaProperty* _tmp897_;
									ValaProperty* _tmp898_;
									ValaSymbol* _tmp899_;
									ValaSymbol* _tmp900_;
									ValaSymbol* _tmp901_;
									_tmp894_ = prop;
									_tmp895_ = vala_property_get_base_interface_property (_tmp894_);
									_tmp896_ = _tmp895_;
									_tmp897_ = _vala_code_node_ref0 (_tmp896_);
									_vala_code_node_unref0 (prop);
									prop = _tmp897_;
									_tmp898_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp898_);
									_tmp899_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp900_ = _tmp899_;
									_tmp901_ = _vala_code_node_ref0 (_tmp900_);
									_vala_code_node_unref0 (member);
									member = _tmp901_;
								}
							}
							_tmp902_ = prop;
							_tmp903_ = vala_symbol_get_access ((ValaSymbol*) _tmp902_);
							_tmp904_ = _tmp903_;
							access = _tmp904_;
							_tmp905_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp906_ = _tmp905_;
							if (_tmp906_) {
								ValaProperty* _tmp907_;
								ValaPropertyAccessor* _tmp908_;
								ValaPropertyAccessor* _tmp909_;
								ValaProperty* _tmp917_;
								ValaSymbolAccessibility _tmp918_;
								ValaSymbolAccessibility _tmp919_;
								_tmp907_ = prop;
								_tmp908_ = vala_property_get_set_accessor (_tmp907_);
								_tmp909_ = _tmp908_;
								if (_tmp909_ == NULL) {
									ValaSourceReference* _tmp910_;
									ValaSourceReference* _tmp911_;
									ValaProperty* _tmp912_;
									gchar* _tmp913_;
									gchar* _tmp914_;
									gchar* _tmp915_;
									gchar* _tmp916_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp910_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp911_ = _tmp910_;
									_tmp912_ = prop;
									_tmp913_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp912_);
									_tmp914_ = _tmp913_;
									_tmp915_ = g_strdup_printf ("Property `%s' is read-only", _tmp914_);
									_tmp916_ = _tmp915_;
									vala_report_error (_tmp911_, _tmp916_);
									_g_free0 (_tmp916_);
									_g_free0 (_tmp914_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp917_ = prop;
								_tmp918_ = vala_symbol_get_access ((ValaSymbol*) _tmp917_);
								_tmp919_ = _tmp918_;
								if (_tmp919_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp920_;
									ValaPropertyAccessor* _tmp921_;
									ValaPropertyAccessor* _tmp922_;
									ValaSymbolAccessibility _tmp923_;
									ValaSymbolAccessibility _tmp924_;
									_tmp920_ = prop;
									_tmp921_ = vala_property_get_set_accessor (_tmp920_);
									_tmp922_ = _tmp921_;
									_tmp923_ = vala_symbol_get_access ((ValaSymbol*) _tmp922_);
									_tmp924_ = _tmp923_;
									access = _tmp924_;
								} else {
									gboolean _tmp925_ = FALSE;
									ValaProperty* _tmp926_;
									ValaSymbolAccessibility _tmp927_;
									ValaSymbolAccessibility _tmp928_;
									_tmp926_ = prop;
									_tmp927_ = vala_symbol_get_access ((ValaSymbol*) _tmp926_);
									_tmp928_ = _tmp927_;
									if (_tmp928_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp929_;
										ValaPropertyAccessor* _tmp930_;
										ValaPropertyAccessor* _tmp931_;
										ValaSymbolAccessibility _tmp932_;
										ValaSymbolAccessibility _tmp933_;
										_tmp929_ = prop;
										_tmp930_ = vala_property_get_set_accessor (_tmp929_);
										_tmp931_ = _tmp930_;
										_tmp932_ = vala_symbol_get_access ((ValaSymbol*) _tmp931_);
										_tmp933_ = _tmp932_;
										_tmp925_ = _tmp933_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp925_ = FALSE;
									}
									if (_tmp925_) {
										ValaProperty* _tmp934_;
										ValaPropertyAccessor* _tmp935_;
										ValaPropertyAccessor* _tmp936_;
										ValaSymbolAccessibility _tmp937_;
										ValaSymbolAccessibility _tmp938_;
										_tmp934_ = prop;
										_tmp935_ = vala_property_get_set_accessor (_tmp934_);
										_tmp936_ = _tmp935_;
										_tmp937_ = vala_symbol_get_access ((ValaSymbol*) _tmp936_);
										_tmp938_ = _tmp937_;
										access = _tmp938_;
									}
								}
							} else {
								ValaProperty* _tmp939_;
								ValaPropertyAccessor* _tmp940_;
								ValaPropertyAccessor* _tmp941_;
								ValaProperty* _tmp949_;
								ValaSymbolAccessibility _tmp950_;
								ValaSymbolAccessibility _tmp951_;
								_tmp939_ = prop;
								_tmp940_ = vala_property_get_get_accessor (_tmp939_);
								_tmp941_ = _tmp940_;
								if (_tmp941_ == NULL) {
									ValaSourceReference* _tmp942_;
									ValaSourceReference* _tmp943_;
									ValaProperty* _tmp944_;
									gchar* _tmp945_;
									gchar* _tmp946_;
									gchar* _tmp947_;
									gchar* _tmp948_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp942_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp943_ = _tmp942_;
									_tmp944_ = prop;
									_tmp945_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp944_);
									_tmp946_ = _tmp945_;
									_tmp947_ = g_strdup_printf ("Property `%s' is write-only", _tmp946_);
									_tmp948_ = _tmp947_;
									vala_report_error (_tmp943_, _tmp948_);
									_g_free0 (_tmp948_);
									_g_free0 (_tmp946_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp949_ = prop;
								_tmp950_ = vala_symbol_get_access ((ValaSymbol*) _tmp949_);
								_tmp951_ = _tmp950_;
								if (_tmp951_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp952_;
									ValaPropertyAccessor* _tmp953_;
									ValaPropertyAccessor* _tmp954_;
									ValaSymbolAccessibility _tmp955_;
									ValaSymbolAccessibility _tmp956_;
									_tmp952_ = prop;
									_tmp953_ = vala_property_get_get_accessor (_tmp952_);
									_tmp954_ = _tmp953_;
									_tmp955_ = vala_symbol_get_access ((ValaSymbol*) _tmp954_);
									_tmp956_ = _tmp955_;
									access = _tmp956_;
								} else {
									gboolean _tmp957_ = FALSE;
									ValaProperty* _tmp958_;
									ValaSymbolAccessibility _tmp959_;
									ValaSymbolAccessibility _tmp960_;
									_tmp958_ = prop;
									_tmp959_ = vala_symbol_get_access ((ValaSymbol*) _tmp958_);
									_tmp960_ = _tmp959_;
									if (_tmp960_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp961_;
										ValaPropertyAccessor* _tmp962_;
										ValaPropertyAccessor* _tmp963_;
										ValaSymbolAccessibility _tmp964_;
										ValaSymbolAccessibility _tmp965_;
										_tmp961_ = prop;
										_tmp962_ = vala_property_get_get_accessor (_tmp961_);
										_tmp963_ = _tmp962_;
										_tmp964_ = vala_symbol_get_access ((ValaSymbol*) _tmp963_);
										_tmp965_ = _tmp964_;
										_tmp957_ = _tmp965_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp957_ = FALSE;
									}
									if (_tmp957_) {
										ValaProperty* _tmp966_;
										ValaPropertyAccessor* _tmp967_;
										ValaPropertyAccessor* _tmp968_;
										ValaSymbolAccessibility _tmp969_;
										ValaSymbolAccessibility _tmp970_;
										_tmp966_ = prop;
										_tmp967_ = vala_property_get_get_accessor (_tmp966_);
										_tmp968_ = _tmp967_;
										_tmp969_ = vala_symbol_get_access ((ValaSymbol*) _tmp968_);
										_tmp970_ = _tmp969_;
										access = _tmp970_;
									}
								}
							}
							_tmp971_ = prop;
							_tmp972_ = vala_property_get_binding (_tmp971_);
							_tmp973_ = _tmp972_;
							instance = _tmp973_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp974_ = prop;
							_tmp975_ = vala_property_get_property_type (_tmp974_);
							_tmp976_ = _tmp975_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp976_, VALA_TYPE_GENERIC_TYPE)) {
								generics = TRUE;
							}
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp977_;
							_tmp977_ = member;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp977_, VALA_TYPE_SIGNAL)) {
								ValaSymbol* _tmp978_;
								ValaSymbolAccessibility _tmp979_;
								ValaSymbolAccessibility _tmp980_;
								instance = TRUE;
								_tmp978_ = member;
								_tmp979_ = vala_symbol_get_access (_tmp978_);
								_tmp980_ = _tmp979_;
								access = _tmp980_;
							} else {
								gboolean _tmp981_ = FALSE;
								gboolean _tmp982_;
								_tmp982_ = self->priv->_creation_member;
								if (!_tmp982_) {
									ValaSymbol* _tmp983_;
									_tmp983_ = member;
									_tmp981_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp983_, VALA_TYPE_ERROR_CODE);
								} else {
									_tmp981_ = FALSE;
								}
								if (_tmp981_) {
									ValaSymbol* _tmp984_;
									ValaConstant* _tmp985_;
									ValaConstant* _tmp986_;
									ValaSymbol* _tmp987_;
									ValaSymbol* _tmp988_;
									ValaSymbol* _tmp989_;
									_tmp984_ = member;
									_tmp985_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp984_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp986_ = _tmp985_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp986_);
									_tmp987_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp988_ = _tmp987_;
									_tmp989_ = _vala_code_node_ref0 (_tmp988_);
									_vala_code_node_unref0 (member);
									member = _tmp989_;
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp990_ = member;
	vala_symbol_set_used (_tmp990_, TRUE);
	_tmp991_ = member;
	_tmp992_ = vala_symbol_get_version (_tmp991_);
	_tmp993_ = _tmp992_;
	_tmp994_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp995_ = _tmp994_;
	vala_version_attribute_check (_tmp993_, _tmp995_);
	_tmp997_ = access;
	if (_tmp997_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp998_;
		ValaSymbol* _tmp999_;
		ValaSymbol* _tmp1000_;
		_tmp998_ = member;
		_tmp999_ = vala_symbol_get_parent_symbol (_tmp998_);
		_tmp1000_ = _tmp999_;
		_tmp996_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1000_, VALA_TYPE_TYPESYMBOL);
	} else {
		_tmp996_ = FALSE;
	}
	if (_tmp996_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1001_;
		ValaSymbol* _tmp1002_;
		ValaSymbol* _tmp1003_;
		ValaTypeSymbol* _tmp1004_;
		gboolean in_subtype = FALSE;
		_tmp1001_ = member;
		_tmp1002_ = vala_symbol_get_parent_symbol (_tmp1001_);
		_tmp1003_ = _tmp1002_;
		_tmp1004_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1003_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		target_type = _tmp1004_;
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1005_;
			ValaSemanticAnalyzer* _tmp1006_;
			ValaSymbol* _tmp1007_;
			ValaSymbol* _tmp1008_;
			ValaSymbol* _tmp1009_;
			_tmp1005_ = vala_code_context_get_analyzer (context);
			_tmp1006_ = _tmp1005_;
			_tmp1007_ = vala_semantic_analyzer_get_current_symbol (_tmp1006_);
			_tmp1008_ = _tmp1007_;
			_tmp1009_ = _vala_code_node_ref0 (_tmp1008_);
			this_symbol = _tmp1009_;
			{
				gboolean _tmp1010_ = FALSE;
				_tmp1010_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1015_;
					ValaSymbol* _tmp1016_;
					ValaTypeSymbol* _tmp1017_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1018_;
					ValaClass* _tmp1019_;
					gboolean _tmp1020_ = FALSE;
					ValaClass* _tmp1021_;
					if (!_tmp1010_) {
						ValaSymbol* _tmp1011_;
						ValaSymbol* _tmp1012_;
						ValaSymbol* _tmp1013_;
						ValaSymbol* _tmp1014_;
						_tmp1011_ = this_symbol;
						_tmp1012_ = vala_symbol_get_parent_symbol (_tmp1011_);
						_tmp1013_ = _tmp1012_;
						_tmp1014_ = _vala_code_node_ref0 (_tmp1013_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1014_;
					}
					_tmp1010_ = FALSE;
					_tmp1015_ = this_symbol;
					if (!(_tmp1015_ != NULL)) {
						break;
					}
					_tmp1016_ = this_symbol;
					_tmp1017_ = target_type;
					if (_tmp1016_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1017_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1018_ = this_symbol;
					_tmp1019_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1018_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp1018_) : NULL);
					cl = _tmp1019_;
					_tmp1021_ = cl;
					if (_tmp1021_ != NULL) {
						ValaClass* _tmp1022_;
						ValaTypeSymbol* _tmp1023_;
						_tmp1022_ = cl;
						_tmp1023_ = target_type;
						_tmp1020_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1022_, _tmp1023_);
					} else {
						_tmp1020_ = FALSE;
					}
					if (_tmp1020_) {
						in_subtype = TRUE;
						_vala_code_node_unref0 (cl);
						break;
					}
					_vala_code_node_unref0 (cl);
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1024_;
			ValaSourceReference* _tmp1025_;
			ValaSymbol* _tmp1026_;
			gchar* _tmp1027_;
			gchar* _tmp1028_;
			gchar* _tmp1029_;
			gchar* _tmp1030_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1024_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1025_ = _tmp1024_;
			_tmp1026_ = member;
			_tmp1027_ = vala_symbol_get_full_name (_tmp1026_);
			_tmp1028_ = _tmp1027_;
			_tmp1029_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1028_);
			_tmp1030_ = _tmp1029_;
			vala_report_error (_tmp1025_, _tmp1030_);
			_g_free0 (_tmp1030_);
			_g_free0 (_tmp1028_);
			result = FALSE;
			_vala_code_node_unref0 (target_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (target_type);
	} else {
		ValaSymbolAccessibility _tmp1031_;
		_tmp1031_ = access;
		if (_tmp1031_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1032_;
			ValaSymbol* _tmp1033_;
			ValaSymbol* _tmp1034_;
			ValaSymbol* _tmp1035_;
			gboolean in_target_type = FALSE;
			_tmp1032_ = member;
			_tmp1033_ = vala_symbol_get_parent_symbol (_tmp1032_);
			_tmp1034_ = _tmp1033_;
			_tmp1035_ = _vala_code_node_ref0 (_tmp1034_);
			target_type = _tmp1035_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1036_;
				ValaSemanticAnalyzer* _tmp1037_;
				ValaSymbol* _tmp1038_;
				ValaSymbol* _tmp1039_;
				ValaSymbol* _tmp1040_;
				_tmp1036_ = vala_code_context_get_analyzer (context);
				_tmp1037_ = _tmp1036_;
				_tmp1038_ = vala_semantic_analyzer_get_current_symbol (_tmp1037_);
				_tmp1039_ = _tmp1038_;
				_tmp1040_ = _vala_code_node_ref0 (_tmp1039_);
				this_symbol = _tmp1040_;
				{
					gboolean _tmp1041_ = FALSE;
					_tmp1041_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1046_;
						ValaSymbol* _tmp1047_;
						ValaSymbol* _tmp1048_;
						if (!_tmp1041_) {
							ValaSymbol* _tmp1042_;
							ValaSymbol* _tmp1043_;
							ValaSymbol* _tmp1044_;
							ValaSymbol* _tmp1045_;
							_tmp1042_ = this_symbol;
							_tmp1043_ = vala_symbol_get_parent_symbol (_tmp1042_);
							_tmp1044_ = _tmp1043_;
							_tmp1045_ = _vala_code_node_ref0 (_tmp1044_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1045_;
						}
						_tmp1041_ = FALSE;
						_tmp1046_ = this_symbol;
						if (!(_tmp1046_ != NULL)) {
							break;
						}
						_tmp1047_ = target_type;
						_tmp1048_ = this_symbol;
						if (_tmp1047_ == _tmp1048_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1049_;
				ValaSourceReference* _tmp1050_;
				ValaSymbol* _tmp1051_;
				gchar* _tmp1052_;
				gchar* _tmp1053_;
				gchar* _tmp1054_;
				gchar* _tmp1055_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1049_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1050_ = _tmp1049_;
				_tmp1051_ = member;
				_tmp1052_ = vala_symbol_get_full_name (_tmp1051_);
				_tmp1053_ = _tmp1052_;
				_tmp1054_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1053_);
				_tmp1055_ = _tmp1054_;
				vala_report_error (_tmp1050_, _tmp1055_);
				_g_free0 (_tmp1055_);
				_g_free0 (_tmp1053_);
				result = FALSE;
				_vala_code_node_unref0 (target_type);
				_vala_code_node_unref0 (member);
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_vala_code_node_unref0 (target_type);
		}
	}
	if (generics) {
		ValaExpression* _tmp1057_;
		ValaExpression* _tmp1058_;
		_tmp1057_ = vala_member_access_get_inner (self);
		_tmp1058_ = _tmp1057_;
		_tmp1056_ = _tmp1058_ != NULL;
	} else {
		_tmp1056_ = FALSE;
	}
	if (_tmp1056_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1059_;
		ValaExpression* _tmp1060_;
		ValaDataType* _tmp1061_;
		ValaDataType* _tmp1062_;
		ValaDataType* _tmp1063_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1064_;
		ValaExpression* _tmp1065_;
		ValaDataType* _tmp1066_;
		ValaDataType* _tmp1067_;
		ValaPointerType* _tmp1068_;
		ValaPointerType* _tmp1069_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1074_;
		ValaObjectType* _tmp1075_;
		gboolean _tmp1076_ = FALSE;
		gboolean _tmp1077_ = FALSE;
		ValaObjectType* _tmp1078_;
		_tmp1059_ = vala_member_access_get_inner (self);
		_tmp1060_ = _tmp1059_;
		_tmp1061_ = vala_expression_get_value_type (_tmp1060_);
		_tmp1062_ = _tmp1061_;
		_tmp1063_ = _vala_code_node_ref0 (_tmp1062_);
		instance_type = _tmp1063_;
		_tmp1064_ = vala_member_access_get_inner (self);
		_tmp1065_ = _tmp1064_;
		_tmp1066_ = vala_expression_get_value_type (_tmp1065_);
		_tmp1067_ = _tmp1066_;
		_tmp1068_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1067_, VALA_TYPE_POINTER_TYPE) ? ((ValaPointerType*) _tmp1067_) : NULL);
		pointer_type = _tmp1068_;
		_tmp1069_ = pointer_type;
		if (_tmp1069_ != NULL) {
			ValaPointerType* _tmp1070_;
			ValaDataType* _tmp1071_;
			ValaDataType* _tmp1072_;
			ValaDataType* _tmp1073_;
			_tmp1070_ = pointer_type;
			_tmp1071_ = vala_pointer_type_get_base_type (_tmp1070_);
			_tmp1072_ = _tmp1071_;
			_tmp1073_ = _vala_code_node_ref0 (_tmp1072_);
			_vala_code_node_unref0 (instance_type);
			instance_type = _tmp1073_;
		}
		_tmp1074_ = instance_type;
		_tmp1075_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1074_, VALA_TYPE_OBJECT_TYPE) ? ((ValaObjectType*) _tmp1074_) : NULL);
		object_type = _tmp1075_;
		_tmp1078_ = object_type;
		if (_tmp1078_ != NULL) {
			ValaObjectType* _tmp1079_;
			ValaObjectTypeSymbol* _tmp1080_;
			ValaObjectTypeSymbol* _tmp1081_;
			_tmp1079_ = object_type;
			_tmp1080_ = vala_object_type_get_type_symbol (_tmp1079_);
			_tmp1081_ = _tmp1080_;
			_tmp1077_ = vala_object_type_symbol_has_type_parameters (_tmp1081_);
		} else {
			_tmp1077_ = FALSE;
		}
		if (_tmp1077_) {
			ValaDataType* _tmp1082_;
			_tmp1082_ = instance_type;
			_tmp1076_ = !vala_data_type_has_type_arguments (_tmp1082_);
		} else {
			_tmp1076_ = FALSE;
		}
		if (_tmp1076_) {
			ValaExpression* _tmp1083_;
			ValaExpression* _tmp1084_;
			ValaSourceReference* _tmp1085_;
			ValaSourceReference* _tmp1086_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1083_ = vala_member_access_get_inner (self);
			_tmp1084_ = _tmp1083_;
			_tmp1085_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1084_);
			_tmp1086_ = _tmp1085_;
			vala_report_error (_tmp1086_, "missing generic type arguments");
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			_vala_code_node_unref0 (pointer_type);
			_vala_code_node_unref0 (instance_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (object_type);
		_vala_code_node_unref0 (pointer_type);
		_vala_code_node_unref0 (instance_type);
	}
	if (instance) {
		_tmp1088_ = !may_access_instance_members;
	} else {
		_tmp1088_ = FALSE;
	}
	if (_tmp1088_) {
		_tmp1087_ = TRUE;
	} else {
		gboolean _tmp1089_ = FALSE;
		if (klass) {
			_tmp1089_ = !may_access_klass_members;
		} else {
			_tmp1089_ = FALSE;
		}
		_tmp1087_ = _tmp1089_;
	}
	if (_tmp1087_) {
		ValaSymbol* _tmp1090_;
		ValaSymbol* _tmp1091_;
		ValaDataType* _tmp1114_;
		ValaDataType* _tmp1115_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1090_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1091_ = _tmp1090_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1091_, VALA_TYPE_METHOD)) {
			ValaSemanticAnalyzer* _tmp1092_;
			ValaSemanticAnalyzer* _tmp1093_;
			ValaSymbol* _tmp1094_;
			ValaSymbol* _tmp1095_;
			gboolean _tmp1096_;
			gboolean _tmp1097_;
			ValaDataType* _tmp1098_;
			ValaDataType* _tmp1099_;
			_tmp1092_ = vala_code_context_get_analyzer (context);
			_tmp1093_ = _tmp1092_;
			_tmp1094_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1095_ = _tmp1094_;
			_tmp1096_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1097_ = _tmp1096_;
			_tmp1098_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1093_, _tmp1095_, _tmp1097_);
			_tmp1099_ = _tmp1098_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1099_);
			_vala_code_node_unref0 (_tmp1099_);
		} else {
			ValaSymbol* _tmp1100_;
			ValaSymbol* _tmp1101_;
			_tmp1100_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1101_ = _tmp1100_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1101_, VALA_TYPE_FIELD)) {
				ValaSymbol* _tmp1102_;
				ValaSymbol* _tmp1103_;
				ValaFieldPrototype* _tmp1104_;
				ValaFieldPrototype* _tmp1105_;
				_tmp1102_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1103_ = _tmp1102_;
				_tmp1104_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1103_, VALA_TYPE_FIELD, ValaField));
				_tmp1105_ = _tmp1104_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1105_);
				_vala_code_node_unref0 (_tmp1105_);
			} else {
				ValaSymbol* _tmp1106_;
				ValaSymbol* _tmp1107_;
				_tmp1106_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1107_ = _tmp1106_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1107_, VALA_TYPE_PROPERTY)) {
					ValaSymbol* _tmp1108_;
					ValaSymbol* _tmp1109_;
					ValaPropertyPrototype* _tmp1110_;
					ValaPropertyPrototype* _tmp1111_;
					_tmp1108_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1109_ = _tmp1108_;
					_tmp1110_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1109_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1111_ = _tmp1110_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1111_);
					_vala_code_node_unref0 (_tmp1111_);
				} else {
					ValaInvalidType* _tmp1112_;
					ValaInvalidType* _tmp1113_;
					_tmp1112_ = vala_invalid_type_new ();
					_tmp1113_ = _tmp1112_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1113_);
					_vala_code_node_unref0 (_tmp1113_);
				}
			}
		}
		_tmp1114_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1115_ = _tmp1114_;
		if (_tmp1115_ != NULL) {
			ValaDataType* _tmp1116_;
			ValaDataType* _tmp1117_;
			ValaDataType* _tmp1118_;
			ValaDataType* _tmp1119_;
			gboolean _tmp1120_;
			gboolean _tmp1121_;
			_tmp1116_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1117_ = _tmp1116_;
			_tmp1118_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1119_ = _tmp1118_;
			_tmp1120_ = vala_data_type_get_value_owned (_tmp1119_);
			_tmp1121_ = _tmp1120_;
			vala_data_type_set_value_owned (_tmp1117_, _tmp1121_);
		}
	} else {
		gboolean _tmp1122_ = FALSE;
		gboolean _tmp1143_ = FALSE;
		gboolean _tmp1144_ = FALSE;
		gboolean _tmp1145_ = FALSE;
		gboolean _tmp1146_ = FALSE;
		gboolean _tmp1163_ = FALSE;
		gboolean _tmp1164_ = FALSE;
		gboolean _tmp1165_ = FALSE;
		gboolean _tmp1166_ = FALSE;
		gboolean _tmp1167_ = FALSE;
		gboolean _tmp1168_;
		gboolean _tmp1169_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1196_;
		ValaSymbol* _tmp1197_;
		ValaMethod* _tmp1198_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1199_;
		ValaExpression* _tmp1200_;
		ValaMemberAccess* _tmp1201_;
		gboolean _tmp1202_ = FALSE;
		gboolean _tmp1203_ = FALSE;
		gboolean _tmp1204_ = FALSE;
		gboolean _tmp1205_ = FALSE;
		gboolean _tmp1206_ = FALSE;
		ValaMethod* _tmp1207_;
		ValaSemanticAnalyzer* _tmp1244_;
		ValaSemanticAnalyzer* _tmp1245_;
		ValaSymbol* _tmp1246_;
		ValaSymbol* _tmp1247_;
		gboolean _tmp1248_;
		gboolean _tmp1249_;
		ValaDataType* _tmp1250_;
		ValaDataType* _tmp1251_;
		gboolean _tmp1252_ = FALSE;
		ValaExpression* _tmp1253_;
		ValaExpression* _tmp1254_;
		ValaSymbol* _tmp1267_;
		ValaSymbol* _tmp1268_;
		if (instance) {
			ValaExpression* _tmp1123_;
			ValaExpression* _tmp1124_;
			_tmp1123_ = vala_member_access_get_inner (self);
			_tmp1124_ = _tmp1123_;
			_tmp1122_ = _tmp1124_ == NULL;
		} else {
			_tmp1122_ = FALSE;
		}
		if (_tmp1122_) {
			ValaSourceReference* _tmp1125_;
			ValaSourceReference* _tmp1126_;
			ValaMemberAccess* _tmp1127_;
			ValaMemberAccess* _tmp1128_;
			ValaExpression* _tmp1129_;
			ValaExpression* _tmp1130_;
			ValaParameter* _tmp1131_;
			ValaDataType* _tmp1132_;
			ValaDataType* _tmp1133_;
			ValaDataType* _tmp1134_;
			ValaDataType* _tmp1135_;
			ValaExpression* _tmp1136_;
			ValaExpression* _tmp1137_;
			ValaDataType* _tmp1138_;
			ValaDataType* _tmp1139_;
			ValaExpression* _tmp1140_;
			ValaExpression* _tmp1141_;
			ValaParameter* _tmp1142_;
			_tmp1125_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1126_ = _tmp1125_;
			_tmp1127_ = vala_member_access_new (NULL, "this", _tmp1126_);
			_tmp1128_ = _tmp1127_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1128_);
			_vala_code_node_unref0 (_tmp1128_);
			_tmp1129_ = vala_member_access_get_inner (self);
			_tmp1130_ = _tmp1129_;
			_tmp1131_ = this_parameter;
			_tmp1132_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1131_);
			_tmp1133_ = _tmp1132_;
			_tmp1134_ = vala_data_type_copy (_tmp1133_);
			_tmp1135_ = _tmp1134_;
			vala_expression_set_value_type (_tmp1130_, _tmp1135_);
			_vala_code_node_unref0 (_tmp1135_);
			_tmp1136_ = vala_member_access_get_inner (self);
			_tmp1137_ = _tmp1136_;
			_tmp1138_ = vala_expression_get_value_type (_tmp1137_);
			_tmp1139_ = _tmp1138_;
			vala_data_type_set_value_owned (_tmp1139_, FALSE);
			_tmp1140_ = vala_member_access_get_inner (self);
			_tmp1141_ = _tmp1140_;
			_tmp1142_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1141_, (ValaSymbol*) _tmp1142_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1146_ = !klass;
		} else {
			_tmp1146_ = FALSE;
		}
		if (_tmp1146_) {
			ValaSymbol* _tmp1147_;
			ValaSymbol* _tmp1148_;
			_tmp1147_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1148_ = _tmp1147_;
			_tmp1145_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1148_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp1145_ = FALSE;
		}
		if (_tmp1145_) {
			_tmp1144_ = may_access_instance_members;
		} else {
			_tmp1144_ = FALSE;
		}
		if (_tmp1144_) {
			ValaExpression* _tmp1149_;
			ValaExpression* _tmp1150_;
			_tmp1149_ = vala_member_access_get_inner (self);
			_tmp1150_ = _tmp1149_;
			_tmp1143_ = _tmp1150_ != NULL;
		} else {
			_tmp1143_ = FALSE;
		}
		if (_tmp1143_) {
			ValaExpression* _tmp1151_;
			ValaExpression* _tmp1152_;
			ValaSymbol* _tmp1153_;
			ValaSymbol* _tmp1154_;
			_tmp1151_ = vala_member_access_get_inner (self);
			_tmp1152_ = _tmp1151_;
			_tmp1153_ = vala_expression_get_symbol_reference (_tmp1152_);
			_tmp1154_ = _tmp1153_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1154_, VALA_TYPE_METHOD)) {
			} else {
				ValaSourceReference* _tmp1155_;
				ValaSourceReference* _tmp1156_;
				ValaSymbol* _tmp1157_;
				ValaSymbol* _tmp1158_;
				gchar* _tmp1159_;
				gchar* _tmp1160_;
				gchar* _tmp1161_;
				gchar* _tmp1162_;
				_tmp1155_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1156_ = _tmp1155_;
				_tmp1157_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1158_ = _tmp1157_;
				_tmp1159_ = vala_symbol_get_full_name (_tmp1158_);
				_tmp1160_ = _tmp1159_;
				_tmp1161_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1160_);
				_tmp1162_ = _tmp1161_;
				vala_report_warning (_tmp1156_, _tmp1162_);
				_g_free0 (_tmp1162_);
				_g_free0 (_tmp1160_);
			}
		}
		_tmp1168_ = vala_code_context_get_experimental_non_null (context);
		_tmp1169_ = _tmp1168_;
		if (_tmp1169_) {
			_tmp1167_ = instance;
		} else {
			_tmp1167_ = FALSE;
		}
		if (_tmp1167_) {
			ValaExpression* _tmp1170_;
			ValaExpression* _tmp1171_;
			ValaDataType* _tmp1172_;
			ValaDataType* _tmp1173_;
			gboolean _tmp1174_;
			gboolean _tmp1175_;
			_tmp1170_ = vala_member_access_get_inner (self);
			_tmp1171_ = _tmp1170_;
			_tmp1172_ = vala_expression_get_value_type (_tmp1171_);
			_tmp1173_ = _tmp1172_;
			_tmp1174_ = vala_data_type_get_nullable (_tmp1173_);
			_tmp1175_ = _tmp1174_;
			_tmp1166_ = _tmp1175_;
		} else {
			_tmp1166_ = FALSE;
		}
		if (_tmp1166_) {
			ValaExpression* _tmp1176_;
			ValaExpression* _tmp1177_;
			ValaDataType* _tmp1178_;
			ValaDataType* _tmp1179_;
			_tmp1176_ = vala_member_access_get_inner (self);
			_tmp1177_ = _tmp1176_;
			_tmp1178_ = vala_expression_get_value_type (_tmp1177_);
			_tmp1179_ = _tmp1178_;
			_tmp1165_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1179_, VALA_TYPE_POINTER_TYPE);
		} else {
			_tmp1165_ = FALSE;
		}
		if (_tmp1165_) {
			ValaExpression* _tmp1180_;
			ValaExpression* _tmp1181_;
			ValaDataType* _tmp1182_;
			ValaDataType* _tmp1183_;
			_tmp1180_ = vala_member_access_get_inner (self);
			_tmp1181_ = _tmp1180_;
			_tmp1182_ = vala_expression_get_value_type (_tmp1181_);
			_tmp1183_ = _tmp1182_;
			_tmp1164_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1183_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1164_ = FALSE;
		}
		if (_tmp1164_) {
			ValaExpression* _tmp1184_;
			ValaExpression* _tmp1185_;
			ValaDataType* _tmp1186_;
			ValaDataType* _tmp1187_;
			_tmp1184_ = vala_member_access_get_inner (self);
			_tmp1185_ = _tmp1184_;
			_tmp1186_ = vala_expression_get_value_type (_tmp1185_);
			_tmp1187_ = _tmp1186_;
			_tmp1163_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1187_, VALA_TYPE_ARRAY_TYPE);
		} else {
			_tmp1163_ = FALSE;
		}
		if (_tmp1163_) {
			ValaSourceReference* _tmp1188_;
			ValaSourceReference* _tmp1189_;
			ValaSymbol* _tmp1190_;
			ValaSymbol* _tmp1191_;
			gchar* _tmp1192_;
			gchar* _tmp1193_;
			gchar* _tmp1194_;
			gchar* _tmp1195_;
			_tmp1188_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1189_ = _tmp1188_;
			_tmp1190_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1191_ = _tmp1190_;
			_tmp1192_ = vala_symbol_get_full_name (_tmp1191_);
			_tmp1193_ = _tmp1192_;
			_tmp1194_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1193_);
			_tmp1195_ = _tmp1194_;
			vala_report_error (_tmp1189_, _tmp1195_);
			_g_free0 (_tmp1195_);
			_g_free0 (_tmp1193_);
		}
		_tmp1196_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1197_ = _tmp1196_;
		_tmp1198_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1197_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp1197_) : NULL);
		m = _tmp1198_;
		_tmp1199_ = vala_member_access_get_inner (self);
		_tmp1200_ = _tmp1199_;
		_tmp1201_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1200_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp1200_) : NULL);
		inner_ma = _tmp1201_;
		_tmp1207_ = m;
		if (_tmp1207_ != NULL) {
			ValaMethod* _tmp1208_;
			ValaMemberBinding _tmp1209_;
			ValaMemberBinding _tmp1210_;
			_tmp1208_ = m;
			_tmp1209_ = vala_method_get_binding (_tmp1208_);
			_tmp1210_ = _tmp1209_;
			_tmp1206_ = _tmp1210_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1206_ = FALSE;
		}
		if (_tmp1206_) {
			ValaMethod* _tmp1211_;
			ValaSymbol* _tmp1212_;
			ValaSymbol* _tmp1213_;
			_tmp1211_ = m;
			_tmp1212_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1211_);
			_tmp1213_ = _tmp1212_;
			_tmp1205_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1213_, VALA_TYPE_OBJECT_TYPE_SYMBOL);
		} else {
			_tmp1205_ = FALSE;
		}
		if (_tmp1205_) {
			ValaExpression* _tmp1214_;
			ValaExpression* _tmp1215_;
			_tmp1214_ = vala_member_access_get_inner (self);
			_tmp1215_ = _tmp1214_;
			_tmp1204_ = _tmp1215_ != NULL;
		} else {
			_tmp1204_ = FALSE;
		}
		if (_tmp1204_) {
			ValaExpression* _tmp1216_;
			ValaExpression* _tmp1217_;
			ValaDataType* _tmp1218_;
			ValaDataType* _tmp1219_;
			_tmp1216_ = vala_member_access_get_inner (self);
			_tmp1217_ = _tmp1216_;
			_tmp1218_ = vala_expression_get_value_type (_tmp1217_);
			_tmp1219_ = _tmp1218_;
			_tmp1203_ = _tmp1219_ == NULL;
		} else {
			_tmp1203_ = FALSE;
		}
		if (_tmp1203_) {
			ValaMemberAccess* _tmp1220_;
			ValaList* _tmp1221_;
			gint _tmp1222_;
			gint _tmp1223_;
			_tmp1220_ = inner_ma;
			_tmp1221_ = _tmp1220_->priv->type_argument_list;
			_tmp1222_ = vala_collection_get_size ((ValaCollection*) _tmp1221_);
			_tmp1223_ = _tmp1222_;
			_tmp1202_ = _tmp1223_ > 0;
		} else {
			_tmp1202_ = FALSE;
		}
		if (_tmp1202_) {
			ValaExpression* _tmp1224_;
			ValaExpression* _tmp1225_;
			ValaMethod* _tmp1226_;
			ValaSymbol* _tmp1227_;
			ValaSymbol* _tmp1228_;
			ValaObjectType* _tmp1229_;
			ValaObjectType* _tmp1230_;
			_tmp1224_ = vala_member_access_get_inner (self);
			_tmp1225_ = _tmp1224_;
			_tmp1226_ = m;
			_tmp1227_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1226_);
			_tmp1228_ = _tmp1227_;
			_tmp1229_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1228_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1230_ = _tmp1229_;
			vala_expression_set_value_type (_tmp1225_, (ValaDataType*) _tmp1230_);
			_vala_code_node_unref0 (_tmp1230_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1231_;
				ValaList* _tmp1232_;
				ValaList* _tmp1233_;
				gint _type_argument_size = 0;
				ValaList* _tmp1234_;
				gint _tmp1235_;
				gint _tmp1236_;
				gint _type_argument_index = 0;
				_tmp1231_ = inner_ma;
				_tmp1232_ = _tmp1231_->priv->type_argument_list;
				_tmp1233_ = _vala_iterable_ref0 (_tmp1232_);
				_type_argument_list = _tmp1233_;
				_tmp1234_ = _type_argument_list;
				_tmp1235_ = vala_collection_get_size ((ValaCollection*) _tmp1234_);
				_tmp1236_ = _tmp1235_;
				_type_argument_size = _tmp1236_;
				_type_argument_index = -1;
				while (TRUE) {
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1237_;
					gpointer _tmp1238_;
					ValaExpression* _tmp1239_;
					ValaExpression* _tmp1240_;
					ValaDataType* _tmp1241_;
					ValaDataType* _tmp1242_;
					ValaDataType* _tmp1243_;
					_type_argument_index = _type_argument_index + 1;
					if (!(_type_argument_index < _type_argument_size)) {
						break;
					}
					_tmp1237_ = _type_argument_list;
					_tmp1238_ = vala_list_get (_tmp1237_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1238_;
					_tmp1239_ = vala_member_access_get_inner (self);
					_tmp1240_ = _tmp1239_;
					_tmp1241_ = vala_expression_get_value_type (_tmp1240_);
					_tmp1242_ = _tmp1241_;
					_tmp1243_ = type_argument;
					vala_data_type_add_type_argument (_tmp1242_, _tmp1243_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1244_ = vala_code_context_get_analyzer (context);
		_tmp1245_ = _tmp1244_;
		_tmp1246_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1247_ = _tmp1246_;
		_tmp1248_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1249_ = _tmp1248_;
		_tmp1250_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1245_, _tmp1247_, _tmp1249_);
		_tmp1251_ = _tmp1250_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1251_);
		_vala_code_node_unref0 (_tmp1251_);
		_tmp1253_ = vala_member_access_get_inner (self);
		_tmp1254_ = _tmp1253_;
		if (_tmp1254_ != NULL) {
			ValaDataType* _tmp1255_;
			ValaDataType* _tmp1256_;
			_tmp1255_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1256_ = _tmp1255_;
			_tmp1252_ = _tmp1256_ != NULL;
		} else {
			_tmp1252_ = FALSE;
		}
		if (_tmp1252_) {
			ValaDataType* _tmp1257_;
			ValaDataType* _tmp1258_;
			ValaExpression* _tmp1259_;
			ValaExpression* _tmp1260_;
			ValaDataType* _tmp1261_;
			ValaDataType* _tmp1262_;
			ValaDataType* _tmp1263_;
			ValaDataType* _tmp1264_;
			_tmp1257_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1258_ = _tmp1257_;
			_tmp1259_ = vala_member_access_get_inner (self);
			_tmp1260_ = _tmp1259_;
			_tmp1261_ = vala_expression_get_value_type (_tmp1260_);
			_tmp1262_ = _tmp1261_;
			_tmp1263_ = vala_data_type_get_actual_type (_tmp1258_, _tmp1262_, NULL, (ValaCodeNode*) self);
			_tmp1264_ = _tmp1263_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1264_);
			_vala_code_node_unref0 (_tmp1264_);
		} else {
			ValaDataType* _tmp1265_;
			ValaDataType* _tmp1266_;
			_tmp1265_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1266_ = _tmp1265_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1266_);
		}
		_tmp1267_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1268_ = _tmp1267_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1268_, VALA_TYPE_METHOD)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1269_;
			ValaSymbol* _tmp1270_;
			ValaMethod* _tmp1271_;
			ValaDataType* _tmp1272_;
			ValaDataType* _tmp1273_;
			gboolean _tmp1280_ = FALSE;
			_tmp1269_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1270_ = _tmp1269_;
			_tmp1271_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1270_, VALA_TYPE_METHOD, ValaMethod));
			method = _tmp1271_;
			_tmp1272_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1273_ = _tmp1272_;
			if (_tmp1273_ != NULL) {
				ValaDataType* _tmp1274_;
				ValaDataType* _tmp1275_;
				ValaDataType* _tmp1276_;
				ValaDataType* _tmp1277_;
				gboolean _tmp1278_;
				gboolean _tmp1279_;
				_tmp1274_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1275_ = _tmp1274_;
				_tmp1276_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1277_ = _tmp1276_;
				_tmp1278_ = vala_data_type_get_value_owned (_tmp1277_);
				_tmp1279_ = _tmp1278_;
				vala_data_type_set_value_owned (_tmp1275_, _tmp1279_);
			}
			if (instance) {
				ValaMethod* _tmp1281_;
				ValaSymbol* _tmp1282_;
				ValaSymbol* _tmp1283_;
				_tmp1281_ = method;
				_tmp1282_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1281_);
				_tmp1283_ = _tmp1282_;
				_tmp1280_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1283_, VALA_TYPE_TYPESYMBOL);
			} else {
				_tmp1280_ = FALSE;
			}
			if (_tmp1280_) {
				ValaExpression* _tmp1284_;
				ValaExpression* _tmp1285_;
				ValaMethod* _tmp1286_;
				ValaSymbol* _tmp1287_;
				ValaSymbol* _tmp1288_;
				ValaDataType* _tmp1289_;
				ValaDataType* _tmp1290_;
				ValaExpression* _tmp1291_;
				ValaExpression* _tmp1292_;
				ValaDataType* _tmp1293_;
				ValaDataType* _tmp1294_;
				ValaMethod* _tmp1295_;
				ValaParameter* _tmp1296_;
				ValaParameter* _tmp1297_;
				ValaDataType* _tmp1298_;
				ValaDataType* _tmp1299_;
				gboolean _tmp1300_;
				gboolean _tmp1301_;
				_tmp1284_ = vala_member_access_get_inner (self);
				_tmp1285_ = _tmp1284_;
				_tmp1286_ = method;
				_tmp1287_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1286_);
				_tmp1288_ = _tmp1287_;
				_tmp1289_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1288_);
				_tmp1290_ = _tmp1289_;
				vala_expression_set_target_type (_tmp1285_, _tmp1290_);
				_vala_code_node_unref0 (_tmp1290_);
				_tmp1291_ = vala_member_access_get_inner (self);
				_tmp1292_ = _tmp1291_;
				_tmp1293_ = vala_expression_get_target_type (_tmp1292_);
				_tmp1294_ = _tmp1293_;
				_tmp1295_ = method;
				_tmp1296_ = vala_method_get_this_parameter (_tmp1295_);
				_tmp1297_ = _tmp1296_;
				_tmp1298_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1297_);
				_tmp1299_ = _tmp1298_;
				_tmp1300_ = vala_data_type_get_value_owned (_tmp1299_);
				_tmp1301_ = _tmp1300_;
				vala_data_type_set_value_owned (_tmp1294_, _tmp1301_);
			}
			_vala_code_node_unref0 (method);
		} else {
			ValaSymbol* _tmp1302_;
			ValaSymbol* _tmp1303_;
			_tmp1302_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1303_ = _tmp1302_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1303_, VALA_TYPE_PROPERTY)) {
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp1304_;
				ValaSymbol* _tmp1305_;
				ValaProperty* _tmp1306_;
				gboolean _tmp1307_ = FALSE;
				_tmp1304_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1305_ = _tmp1304_;
				_tmp1306_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1305_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp1306_;
				if (instance) {
					ValaProperty* _tmp1308_;
					ValaSymbol* _tmp1309_;
					ValaSymbol* _tmp1310_;
					_tmp1308_ = prop;
					_tmp1309_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1308_);
					_tmp1310_ = _tmp1309_;
					_tmp1307_ = _tmp1310_ != NULL;
				} else {
					_tmp1307_ = FALSE;
				}
				if (_tmp1307_) {
					ValaExpression* _tmp1311_;
					ValaExpression* _tmp1312_;
					ValaProperty* _tmp1313_;
					ValaSymbol* _tmp1314_;
					ValaSymbol* _tmp1315_;
					ValaDataType* _tmp1316_;
					ValaDataType* _tmp1317_;
					_tmp1311_ = vala_member_access_get_inner (self);
					_tmp1312_ = _tmp1311_;
					_tmp1313_ = prop;
					_tmp1314_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1313_);
					_tmp1315_ = _tmp1314_;
					_tmp1316_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1315_);
					_tmp1317_ = _tmp1316_;
					vala_expression_set_target_type (_tmp1312_, _tmp1317_);
					_vala_code_node_unref0 (_tmp1317_);
				}
				_vala_code_node_unref0 (prop);
			} else {
				gboolean _tmp1318_ = FALSE;
				gboolean _tmp1319_ = FALSE;
				gboolean _tmp1320_ = FALSE;
				ValaSymbol* _tmp1321_;
				ValaSymbol* _tmp1322_;
				_tmp1321_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1322_ = _tmp1321_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1322_, VALA_TYPE_FIELD)) {
					_tmp1320_ = TRUE;
				} else {
					ValaSymbol* _tmp1323_;
					ValaSymbol* _tmp1324_;
					_tmp1323_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1324_ = _tmp1323_;
					_tmp1320_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1324_, VALA_TYPE_SIGNAL);
				}
				if (_tmp1320_) {
					_tmp1319_ = instance;
				} else {
					_tmp1319_ = FALSE;
				}
				if (_tmp1319_) {
					ValaSymbol* _tmp1325_;
					ValaSymbol* _tmp1326_;
					ValaSymbol* _tmp1327_;
					ValaSymbol* _tmp1328_;
					_tmp1325_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1326_ = _tmp1325_;
					_tmp1327_ = vala_symbol_get_parent_symbol (_tmp1326_);
					_tmp1328_ = _tmp1327_;
					_tmp1318_ = _tmp1328_ != NULL;
				} else {
					_tmp1318_ = FALSE;
				}
				if (_tmp1318_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1329_;
					ValaSymbol* _tmp1330_;
					ValaSymbol* _tmp1331_;
					ValaSymbol* _tmp1332_;
					ValaDataType* _tmp1333_;
					ValaExpression* _tmp1334_;
					ValaExpression* _tmp1335_;
					ValaDataType* _tmp1336_;
					ValaExpression* _tmp1337_;
					ValaExpression* _tmp1338_;
					ValaDataType* _tmp1339_;
					ValaDataType* _tmp1340_;
					ValaDataType* _tmp1341_;
					ValaDataType* _tmp1342_;
					_tmp1329_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1330_ = _tmp1329_;
					_tmp1331_ = vala_symbol_get_parent_symbol (_tmp1330_);
					_tmp1332_ = _tmp1331_;
					_tmp1333_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1332_);
					parent_type = _tmp1333_;
					_tmp1334_ = vala_member_access_get_inner (self);
					_tmp1335_ = _tmp1334_;
					_tmp1336_ = parent_type;
					_tmp1337_ = vala_member_access_get_inner (self);
					_tmp1338_ = _tmp1337_;
					_tmp1339_ = vala_expression_get_value_type (_tmp1338_);
					_tmp1340_ = _tmp1339_;
					_tmp1341_ = vala_data_type_get_actual_type (_tmp1336_, _tmp1340_, NULL, (ValaCodeNode*) self);
					_tmp1342_ = _tmp1341_;
					vala_expression_set_target_type (_tmp1335_, _tmp1342_);
					_vala_code_node_unref0 (_tmp1342_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_vala_code_node_unref0 (inner_ma);
		_vala_code_node_unref0 (m);
	}
	_tmp1343_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1344_ = _tmp1343_;
	result = !_tmp1344_;
	_vala_code_node_unref0 (member);
	_vala_code_node_unref0 (this_parameter);
	_vala_code_node_unref0 (base_symbol);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_FIELD)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_METHOD)) {
			_tmp4_ = !G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_PROPERTY)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_SIGNAL)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp56_;
	ValaExpression* _tmp57_;
	ValaMemberAccess* _tmp58_;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	ValaMemberAccess* _tmp61_;
	gboolean _tmp69_ = FALSE;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_ = FALSE;
	gboolean _tmp72_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_FIELD)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_METHOD)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_PROPERTY)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, VALA_TYPE_PARAMETER)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		gboolean _tmp46_ = FALSE;
		ValaCodeContext* _tmp47_;
		ValaCodeContext* _tmp48_;
		ValaProfile _tmp49_;
		ValaProfile _tmp50_;
		gboolean _tmp51_;
		_tmp47_ = vala_code_context_get ();
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_code_context_get_profile (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = _tmp50_ == VALA_PROFILE_GOBJECT;
		_vala_code_context_unref0 (_tmp48_);
		if (_tmp51_) {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaDataType* _tmp54_;
			ValaDataType* _tmp55_;
			_tmp52_ = vala_member_access_get_inner (self);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_expression_get_value_type (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp46_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp55_, VALA_TYPE_ARRAY_TYPE);
		} else {
			_tmp46_ = FALSE;
		}
		_tmp34_ = _tmp46_;
	}
	struct_or_array = _tmp34_;
	_tmp56_ = vala_member_access_get_inner (self);
	_tmp57_ = _tmp56_;
	_tmp58_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp57_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp57_) : NULL);
	ma = _tmp58_;
	_tmp61_ = ma;
	if (_tmp61_ == NULL) {
		_tmp60_ = struct_or_array;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		ValaExpression* _tmp62_;
		ValaExpression* _tmp63_;
		_tmp62_ = vala_member_access_get_inner (self);
		_tmp63_ = _tmp62_;
		_tmp59_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp63_, VALA_TYPE_POINTER_INDIRECTION);
	} else {
		_tmp59_ = FALSE;
	}
	if (_tmp59_) {
		ValaExpression* _tmp64_;
		ValaExpression* _tmp65_;
		ValaExpression* _tmp66_;
		ValaExpression* _tmp67_;
		ValaMemberAccess* _tmp68_;
		_tmp64_ = vala_member_access_get_inner (self);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp67_ = _tmp66_;
		_tmp68_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp67_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp67_) : NULL);
		_vala_code_node_unref0 (ma);
		ma = _tmp68_;
	}
	if (instance) {
		_tmp72_ = struct_or_array;
	} else {
		_tmp72_ = FALSE;
	}
	if (_tmp72_) {
		gboolean _tmp73_ = FALSE;
		ValaSymbol* _tmp74_;
		ValaSymbol* _tmp75_;
		_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp75_ = _tmp74_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, VALA_TYPE_METHOD)) {
			_tmp73_ = TRUE;
		} else {
			gboolean _tmp76_;
			gboolean _tmp77_;
			_tmp76_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp77_ = _tmp76_;
			_tmp73_ = _tmp77_;
		}
		_tmp71_ = _tmp73_;
	} else {
		_tmp71_ = FALSE;
	}
	if (_tmp71_) {
		gboolean _tmp78_ = FALSE;
		gboolean _tmp79_ = FALSE;
		ValaMemberAccess* _tmp80_;
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaSymbol* _tmp82_;
			ValaSymbol* _tmp83_;
			_tmp81_ = ma;
			_tmp82_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp81_);
			_tmp83_ = _tmp82_;
			_tmp79_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp83_, VALA_TYPE_VARIABLE);
		} else {
			_tmp79_ = FALSE;
		}
		if (_tmp79_) {
			_tmp78_ = TRUE;
		} else {
			ValaExpression* _tmp84_;
			ValaExpression* _tmp85_;
			_tmp84_ = vala_member_access_get_inner (self);
			_tmp85_ = _tmp84_;
			_tmp78_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp85_, VALA_TYPE_ELEMENT_ACCESS);
		}
		_tmp70_ = _tmp78_;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		_tmp69_ = !this_access;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaMemberAccess* _tmp88_;
		_tmp86_ = vala_member_access_get_inner (self);
		_tmp87_ = _tmp86_;
		vala_expression_set_lvalue (_tmp87_, TRUE);
		_tmp88_ = ma;
		if (_tmp88_ != NULL) {
			ValaMemberAccess* _tmp89_;
			ValaMemberAccess* _tmp90_;
			_tmp89_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp89_, TRUE);
			_tmp90_ = ma;
			vala_member_access_check_lvalue_access (_tmp90_);
		}
	}
	_vala_code_node_unref0 (ma);
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaLocalVariable* _tmp6_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaParameter* _tmp9_;
	ValaLocalVariable* _tmp10_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp5_) : NULL);
	local = _tmp6_;
	_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp8_) : NULL);
	param = _tmp9_;
	_tmp10_ = local;
	if (_tmp10_ != NULL) {
		ValaLocalVariable* _tmp11_;
		_tmp11_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp11_);
	} else {
		gboolean _tmp12_ = FALSE;
		ValaParameter* _tmp13_;
		_tmp13_ = param;
		if (_tmp13_ != NULL) {
			ValaParameter* _tmp14_;
			ValaParameterDirection _tmp15_;
			ValaParameterDirection _tmp16_;
			_tmp14_ = param;
			_tmp15_ = vala_parameter_get_direction (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp12_ = _tmp16_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			ValaParameter* _tmp17_;
			_tmp17_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp17_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
		GType vala_member_access_type_id;
		vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
		ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

