/* valalocalvariable.c generated by valac, the Vala compiler
 * generated from valalocalvariable.vala, do not modify */

/* valalocalvariable.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaLocalVariablePrivate {
	gboolean _is_result;
	gboolean _captured;
	gboolean _init;
};

static gint ValaLocalVariable_private_offset;
static gpointer vala_local_variable_parent_class = NULL;

static void vala_local_variable_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_local_variable_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static void vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                                  ValaExpression* old_node,
                                                  ValaExpression* new_node);
static void vala_local_variable_real_replace_type (ValaCodeNode* base,
                                            ValaDataType* old_type,
                                            ValaDataType* new_type);
static gboolean vala_local_variable_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_local_variable_finalize (ValaCodeNode * obj);

static inline gpointer
vala_local_variable_get_instance_private (ValaLocalVariable* self)
{
	return G_STRUCT_MEMBER_P (self, ValaLocalVariable_private_offset);
}

/**
 * Creates a new local variable.
 *
 * @param name              name of the variable
 * @param initializer       optional initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created variable declarator
 */
ValaLocalVariable*
vala_local_variable_construct (GType object_type,
                               ValaDataType* variable_type,
                               const gchar* name,
                               ValaExpression* initializer,
                               ValaSourceReference* source_reference)
{
	ValaLocalVariable* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaLocalVariable*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, NULL);
	return self;
}

ValaLocalVariable*
vala_local_variable_new (ValaDataType* variable_type,
                         const gchar* name,
                         ValaExpression* initializer,
                         ValaSourceReference* source_reference)
{
	return vala_local_variable_construct (VALA_TYPE_LOCAL_VARIABLE, variable_type, name, initializer, source_reference);
}

static void
vala_local_variable_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_local_variable (visitor, self);
}

static void
vala_local_variable_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp5_);
	}
	_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
}

static void
vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}

static void
vala_local_variable_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type)
{
	ValaLocalVariable * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_local_variable_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaLocalVariable * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	ValaDataType* _tmp18_;
	ValaDataType* _tmp19_;
	gboolean is_initializer_list = FALSE;
	gint initializer_size = 0;
	ValaExpression* _tmp26_;
	ValaExpression* _tmp27_;
	ValaDataType* _tmp40_;
	ValaDataType* _tmp41_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp87_;
	ValaDataType* _tmp88_;
	gboolean _tmp89_ = FALSE;
	gboolean _tmp90_ = FALSE;
	gboolean _tmp91_ = FALSE;
	ValaArrayType* _tmp92_;
	gboolean _tmp104_ = FALSE;
	ValaExpression* _tmp105_;
	ValaExpression* _tmp106_;
	ValaSemanticAnalyzer* _tmp222_;
	ValaSemanticAnalyzer* _tmp223_;
	ValaSymbol* _tmp224_;
	ValaSymbol* _tmp225_;
	ValaScope* _tmp226_;
	ValaScope* _tmp227_;
	const gchar* _tmp228_;
	const gchar* _tmp229_;
	ValaBlock* block = NULL;
	ValaSemanticAnalyzer* _tmp230_;
	ValaSemanticAnalyzer* _tmp231_;
	ValaSymbol* _tmp232_;
	ValaSymbol* _tmp233_;
	ValaBlock* _tmp234_;
	ValaBlock* _tmp235_;
	gboolean _tmp237_;
	gboolean _tmp238_;
	self = (ValaLocalVariable*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_experimental_non_null (context);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp7_ = _tmp6_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_REFERENCE_TYPE)) {
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp8_;
			ValaDataType* _tmp9_;
			ValaArrayType* _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaArrayType* _tmp12_;
			_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp9_ = _tmp8_;
			_tmp10_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp9_) : NULL);
			array_type = _tmp10_;
			_tmp12_ = array_type;
			if (_tmp12_ != NULL) {
				ValaArrayType* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
				_tmp13_ = array_type;
				_tmp14_ = vala_array_type_get_fixed_length (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp11_ = _tmp15_;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
			} else {
				ValaDataType* _tmp16_;
				ValaDataType* _tmp17_;
				_tmp16_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp17_ = _tmp16_;
				vala_data_type_set_nullable (_tmp17_, TRUE);
			}
			_vala_code_node_unref0 (array_type);
		}
	}
	_tmp18_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != NULL) {
		ValaDataType* _tmp20_;
		ValaDataType* _tmp21_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		_tmp20_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp21_ = _tmp20_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, VALA_TYPE_VOID_TYPE)) {
			ValaSourceReference* _tmp22_;
			ValaSourceReference* _tmp23_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp23_ = _tmp22_;
			vala_report_error (_tmp23_, "'void' not supported as variable type");
			result = FALSE;
			return result;
		}
		_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp25_ = _tmp24_;
		vala_code_node_check ((ValaCodeNode*) _tmp25_, context);
	}
	is_initializer_list = FALSE;
	initializer_size = -1;
	_tmp26_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp27_ = _tmp26_;
	if (_tmp27_ != NULL) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaDataType* _tmp30_;
		ValaDataType* _tmp31_;
		ValaExpression* _tmp32_;
		ValaExpression* _tmp33_;
		ValaExpression* _tmp38_;
		ValaExpression* _tmp39_;
		_tmp28_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp31_ = _tmp30_;
		vala_expression_set_target_type (_tmp29_, _tmp31_);
		_tmp32_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp33_ = _tmp32_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_INITIALIZER_LIST)) {
			ValaExpression* _tmp34_;
			ValaExpression* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			_tmp34_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp37_ = _tmp36_;
			initializer_size = _tmp37_;
			is_initializer_list = TRUE;
		}
		_tmp38_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp39_ = _tmp38_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp39_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp40_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp41_ = _tmp40_;
	if (_tmp41_ == NULL) {
		ValaExpression* _tmp42_;
		ValaExpression* _tmp43_;
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		gboolean _tmp52_ = FALSE;
		ValaExpression* _tmp53_;
		ValaExpression* _tmp54_;
		ValaDataType* _tmp55_;
		ValaDataType* _tmp56_;
		ValaExpression* _tmp73_;
		ValaExpression* _tmp74_;
		ValaDataType* _tmp75_;
		ValaDataType* _tmp76_;
		ValaDataType* _tmp77_;
		ValaDataType* _tmp78_;
		ValaDataType* _tmp79_;
		ValaDataType* _tmp80_;
		ValaDataType* _tmp81_;
		ValaDataType* _tmp82_;
		ValaExpression* _tmp83_;
		ValaExpression* _tmp84_;
		ValaDataType* _tmp85_;
		ValaDataType* _tmp86_;
		_tmp42_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp43_ = _tmp42_;
		if (_tmp43_ == NULL) {
			ValaSourceReference* _tmp44_;
			ValaSourceReference* _tmp45_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp45_ = _tmp44_;
			vala_report_error (_tmp45_, "var declaration not allowed without initializer");
			result = FALSE;
			return result;
		}
		_tmp46_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		if (_tmp49_ == NULL) {
			ValaSourceReference* _tmp50_;
			ValaSourceReference* _tmp51_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp50_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp51_ = _tmp50_;
			vala_report_error (_tmp51_, "var declaration not allowed with non-typed initializer");
			result = FALSE;
			return result;
		}
		_tmp53_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_expression_get_value_type (_tmp54_);
		_tmp56_ = _tmp55_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp56_, VALA_TYPE_FIELD_PROTOTYPE)) {
			_tmp52_ = TRUE;
		} else {
			ValaExpression* _tmp57_;
			ValaExpression* _tmp58_;
			ValaDataType* _tmp59_;
			ValaDataType* _tmp60_;
			_tmp57_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp58_ = _tmp57_;
			_tmp59_ = vala_expression_get_value_type (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp52_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp60_, VALA_TYPE_PROPERTY_PROTOTYPE);
		}
		if (_tmp52_) {
			ValaExpression* _tmp61_;
			ValaExpression* _tmp62_;
			ValaSourceReference* _tmp63_;
			ValaSourceReference* _tmp64_;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaSymbol* _tmp67_;
			ValaSymbol* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			gchar* _tmp71_;
			gchar* _tmp72_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp61_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_expression_get_symbol_reference (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = vala_symbol_get_full_name (_tmp68_);
			_tmp70_ = _tmp69_;
			_tmp71_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp70_);
			_tmp72_ = _tmp71_;
			vala_report_error (_tmp64_, _tmp72_);
			_g_free0 (_tmp72_);
			_g_free0 (_tmp70_);
			result = FALSE;
			return result;
		}
		_tmp73_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp74_ = _tmp73_;
		_tmp75_ = vala_expression_get_value_type (_tmp74_);
		_tmp76_ = _tmp75_;
		_tmp77_ = vala_data_type_copy (_tmp76_);
		_tmp78_ = _tmp77_;
		vala_variable_set_variable_type ((ValaVariable*) self, _tmp78_);
		_vala_code_node_unref0 (_tmp78_);
		_tmp79_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp80_ = _tmp79_;
		vala_data_type_set_value_owned (_tmp80_, TRUE);
		_tmp81_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp82_ = _tmp81_;
		vala_data_type_set_floating_reference (_tmp82_, FALSE);
		_tmp83_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp84_ = _tmp83_;
		_tmp85_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp86_ = _tmp85_;
		vala_expression_set_target_type (_tmp84_, _tmp86_);
	}
	_tmp87_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp88_ = _tmp87_;
	variable_array_type = G_TYPE_CHECK_INSTANCE_TYPE (_tmp88_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp88_) : NULL;
	_tmp92_ = variable_array_type;
	if (_tmp92_ != NULL) {
		ValaArrayType* _tmp93_;
		gboolean _tmp94_;
		gboolean _tmp95_;
		_tmp93_ = variable_array_type;
		_tmp94_ = vala_array_type_get_fixed_length (_tmp93_);
		_tmp95_ = _tmp94_;
		_tmp91_ = _tmp95_;
	} else {
		_tmp91_ = FALSE;
	}
	if (_tmp91_) {
		ValaExpression* _tmp96_;
		ValaExpression* _tmp97_;
		_tmp96_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp97_ = _tmp96_;
		_tmp90_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp97_, VALA_TYPE_ARRAY_CREATION_EXPRESSION);
	} else {
		_tmp90_ = FALSE;
	}
	if (_tmp90_) {
		ValaExpression* _tmp98_;
		ValaExpression* _tmp99_;
		ValaInitializerList* _tmp100_;
		ValaInitializerList* _tmp101_;
		_tmp98_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp99_ = _tmp98_;
		_tmp100_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp101_ = _tmp100_;
		_tmp89_ = _tmp101_ == NULL;
	} else {
		_tmp89_ = FALSE;
	}
	if (_tmp89_) {
		ValaSourceReference* _tmp102_;
		ValaSourceReference* _tmp103_;
		_tmp102_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp103_ = _tmp102_;
		vala_report_warning (_tmp103_, "Arrays with fixed length don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp105_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp106_ = _tmp105_;
	if (_tmp106_ != NULL) {
		ValaExpression* _tmp107_;
		ValaExpression* _tmp108_;
		gboolean _tmp109_;
		gboolean _tmp110_;
		_tmp107_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp108_ = _tmp107_;
		_tmp109_ = vala_code_node_get_error ((ValaCodeNode*) _tmp108_);
		_tmp110_ = _tmp109_;
		_tmp104_ = !_tmp110_;
	} else {
		_tmp104_ = FALSE;
	}
	if (_tmp104_) {
		ValaExpression* _tmp111_;
		ValaExpression* _tmp112_;
		ValaDataType* _tmp113_;
		ValaDataType* _tmp114_;
		ValaExpression* _tmp160_;
		ValaExpression* _tmp161_;
		ValaDataType* _tmp162_;
		ValaDataType* _tmp163_;
		ValaDataType* _tmp164_;
		ValaDataType* _tmp165_;
		gboolean _tmp180_ = FALSE;
		gboolean _tmp181_ = FALSE;
		gboolean _tmp182_ = FALSE;
		ValaArrayType* _tmp183_;
		gboolean _tmp197_ = FALSE;
		gboolean _tmp198_ = FALSE;
		ValaArrayType* _tmp199_;
		ValaExpression* _tmp209_;
		ValaExpression* _tmp210_;
		ValaDataType* _tmp211_;
		ValaDataType* _tmp212_;
		_tmp111_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp112_ = _tmp111_;
		_tmp113_ = vala_expression_get_value_type (_tmp112_);
		_tmp114_ = _tmp113_;
		if (_tmp114_ == NULL) {
			gboolean _tmp115_ = FALSE;
			ValaExpression* _tmp116_;
			ValaExpression* _tmp117_;
			gboolean _tmp122_ = FALSE;
			ValaExpression* _tmp123_;
			ValaExpression* _tmp124_;
			ValaSymbol* _tmp125_;
			ValaSymbol* _tmp126_;
			_tmp116_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp117_ = _tmp116_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp117_, VALA_TYPE_MEMBER_ACCESS)) {
				ValaExpression* _tmp118_;
				ValaExpression* _tmp119_;
				_tmp118_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp119_ = _tmp118_;
				_tmp115_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp119_, VALA_TYPE_LAMBDA_EXPRESSION);
			} else {
				_tmp115_ = FALSE;
			}
			if (_tmp115_) {
				ValaSourceReference* _tmp120_;
				ValaSourceReference* _tmp121_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp121_ = _tmp120_;
				vala_report_error (_tmp121_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
			_tmp123_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp124_ = _tmp123_;
			_tmp125_ = vala_expression_get_symbol_reference (_tmp124_);
			_tmp126_ = _tmp125_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp126_, VALA_TYPE_METHOD)) {
				ValaDataType* _tmp127_;
				ValaDataType* _tmp128_;
				_tmp127_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp128_ = _tmp127_;
				_tmp122_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp128_, VALA_TYPE_DELEGATE_TYPE);
			} else {
				_tmp122_ = FALSE;
			}
			if (_tmp122_) {
				ValaMethod* m = NULL;
				ValaExpression* _tmp129_;
				ValaExpression* _tmp130_;
				ValaSymbol* _tmp131_;
				ValaSymbol* _tmp132_;
				ValaMethod* _tmp133_;
				ValaDelegateType* dt = NULL;
				ValaDataType* _tmp134_;
				ValaDataType* _tmp135_;
				ValaDelegateType* _tmp136_;
				ValaDelegate* cb = NULL;
				ValaDelegateType* _tmp137_;
				ValaDelegate* _tmp138_;
				ValaDelegate* _tmp139_;
				ValaDelegate* _tmp140_;
				ValaDelegate* _tmp141_;
				ValaMethod* _tmp142_;
				ValaDelegateType* _tmp143_;
				ValaExpression* _tmp154_;
				ValaExpression* _tmp155_;
				ValaDataType* _tmp156_;
				ValaDataType* _tmp157_;
				_tmp129_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp130_ = _tmp129_;
				_tmp131_ = vala_expression_get_symbol_reference (_tmp130_);
				_tmp132_ = _tmp131_;
				_tmp133_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, VALA_TYPE_METHOD, ValaMethod));
				m = _tmp133_;
				_tmp134_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp135_ = _tmp134_;
				_tmp136_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp135_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				dt = _tmp136_;
				_tmp137_ = dt;
				_tmp138_ = vala_delegate_type_get_delegate_symbol (_tmp137_);
				_tmp139_ = _tmp138_;
				_tmp140_ = _vala_code_node_ref0 (_tmp139_);
				cb = _tmp140_;
				_tmp141_ = cb;
				_tmp142_ = m;
				_tmp143_ = dt;
				if (!vala_delegate_matches_method (_tmp141_, _tmp142_, (ValaDataType*) _tmp143_)) {
					ValaSourceReference* _tmp144_;
					ValaSourceReference* _tmp145_;
					ValaMethod* _tmp146_;
					gchar* _tmp147_;
					gchar* _tmp148_;
					ValaDelegate* _tmp149_;
					gchar* _tmp150_;
					gchar* _tmp151_;
					gchar* _tmp152_;
					gchar* _tmp153_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp144_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp145_ = _tmp144_;
					_tmp146_ = m;
					_tmp147_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp146_);
					_tmp148_ = _tmp147_;
					_tmp149_ = cb;
					_tmp150_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp149_);
					_tmp151_ = _tmp150_;
					_tmp152_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp148_, _tmp151_);
					_tmp153_ = _tmp152_;
					vala_report_error (_tmp145_, _tmp153_);
					_g_free0 (_tmp153_);
					_g_free0 (_tmp151_);
					_g_free0 (_tmp148_);
					result = FALSE;
					_vala_code_node_unref0 (cb);
					_vala_code_node_unref0 (dt);
					_vala_code_node_unref0 (m);
					return result;
				}
				_tmp154_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp155_ = _tmp154_;
				_tmp156_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp157_ = _tmp156_;
				vala_expression_set_value_type (_tmp155_, _tmp157_);
				_vala_code_node_unref0 (cb);
				_vala_code_node_unref0 (dt);
				_vala_code_node_unref0 (m);
			} else {
				ValaSourceReference* _tmp158_;
				ValaSourceReference* _tmp159_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp158_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp159_ = _tmp158_;
				vala_report_error (_tmp159_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
		}
		_tmp160_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp161_ = _tmp160_;
		_tmp162_ = vala_expression_get_value_type (_tmp161_);
		_tmp163_ = _tmp162_;
		_tmp164_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp165_ = _tmp164_;
		if (!vala_data_type_compatible (_tmp163_, _tmp165_)) {
			ValaSourceReference* _tmp166_;
			ValaSourceReference* _tmp167_;
			ValaExpression* _tmp168_;
			ValaExpression* _tmp169_;
			ValaDataType* _tmp170_;
			ValaDataType* _tmp171_;
			gchar* _tmp172_;
			gchar* _tmp173_;
			ValaDataType* _tmp174_;
			ValaDataType* _tmp175_;
			gchar* _tmp176_;
			gchar* _tmp177_;
			gchar* _tmp178_;
			gchar* _tmp179_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp166_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp167_ = _tmp166_;
			_tmp168_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp169_ = _tmp168_;
			_tmp170_ = vala_expression_get_value_type (_tmp169_);
			_tmp171_ = _tmp170_;
			_tmp172_ = vala_code_node_to_string ((ValaCodeNode*) _tmp171_);
			_tmp173_ = _tmp172_;
			_tmp174_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp175_ = _tmp174_;
			_tmp176_ = vala_code_node_to_string ((ValaCodeNode*) _tmp175_);
			_tmp177_ = _tmp176_;
			_tmp178_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp173_, _tmp177_);
			_tmp179_ = _tmp178_;
			vala_report_error (_tmp167_, _tmp179_);
			_g_free0 (_tmp179_);
			_g_free0 (_tmp177_);
			_g_free0 (_tmp173_);
			result = FALSE;
			return result;
		}
		_tmp183_ = variable_array_type;
		if (_tmp183_ != NULL) {
			ValaArrayType* _tmp184_;
			gboolean _tmp185_;
			gboolean _tmp186_;
			_tmp184_ = variable_array_type;
			_tmp185_ = vala_array_type_get_inline_allocated (_tmp184_);
			_tmp186_ = _tmp185_;
			_tmp182_ = _tmp186_;
		} else {
			_tmp182_ = FALSE;
		}
		if (_tmp182_) {
			ValaArrayType* _tmp187_;
			gboolean _tmp188_;
			gboolean _tmp189_;
			_tmp187_ = variable_array_type;
			_tmp188_ = vala_array_type_get_fixed_length (_tmp187_);
			_tmp189_ = _tmp188_;
			_tmp181_ = !_tmp189_;
		} else {
			_tmp181_ = FALSE;
		}
		if (_tmp181_) {
			_tmp180_ = is_initializer_list;
		} else {
			_tmp180_ = FALSE;
		}
		if (_tmp180_) {
			ValaArrayType* _tmp190_;
			gchar* _tmp191_;
			gchar* _tmp192_;
			ValaIntegerLiteral* _tmp193_;
			ValaIntegerLiteral* _tmp194_;
			ValaArrayType* _tmp195_;
			ValaArrayType* _tmp196_;
			_tmp190_ = variable_array_type;
			_tmp191_ = g_strdup_printf ("%i", initializer_size);
			_tmp192_ = _tmp191_;
			_tmp193_ = vala_integer_literal_new (_tmp192_, NULL);
			_tmp194_ = _tmp193_;
			vala_array_type_set_length (_tmp190_, (ValaExpression*) _tmp194_);
			_vala_code_node_unref0 (_tmp194_);
			_g_free0 (_tmp192_);
			_tmp195_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp195_, TRUE);
			_tmp196_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp196_, FALSE);
		}
		_tmp199_ = variable_array_type;
		if (_tmp199_ != NULL) {
			ValaArrayType* _tmp200_;
			gboolean _tmp201_;
			gboolean _tmp202_;
			_tmp200_ = variable_array_type;
			_tmp201_ = vala_array_type_get_inline_allocated (_tmp200_);
			_tmp202_ = _tmp201_;
			_tmp198_ = _tmp202_;
		} else {
			_tmp198_ = FALSE;
		}
		if (_tmp198_) {
			ValaExpression* _tmp203_;
			ValaExpression* _tmp204_;
			ValaDataType* _tmp205_;
			ValaDataType* _tmp206_;
			_tmp203_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp204_ = _tmp203_;
			_tmp205_ = vala_expression_get_value_type (_tmp204_);
			_tmp206_ = _tmp205_;
			_tmp197_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp206_, VALA_TYPE_ARRAY_TYPE) == FALSE;
		} else {
			_tmp197_ = FALSE;
		}
		if (_tmp197_) {
			ValaSourceReference* _tmp207_;
			ValaSourceReference* _tmp208_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp207_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp208_ = _tmp207_;
			vala_report_error (_tmp208_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			return result;
		}
		_tmp209_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp210_ = _tmp209_;
		_tmp211_ = vala_expression_get_value_type (_tmp210_);
		_tmp212_ = _tmp211_;
		if (vala_data_type_is_disposable (_tmp212_)) {
			gboolean _tmp213_ = FALSE;
			ValaDataType* _tmp214_;
			ValaDataType* _tmp215_;
			_tmp214_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp215_ = _tmp214_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp215_, VALA_TYPE_POINTER_TYPE)) {
				ValaDataType* _tmp216_;
				ValaDataType* _tmp217_;
				gboolean _tmp218_;
				gboolean _tmp219_;
				_tmp216_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp217_ = _tmp216_;
				_tmp218_ = vala_data_type_get_value_owned (_tmp217_);
				_tmp219_ = _tmp218_;
				_tmp213_ = !_tmp219_;
			} else {
				_tmp213_ = FALSE;
			}
			if (_tmp213_) {
				ValaSourceReference* _tmp220_;
				ValaSourceReference* _tmp221_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp220_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp221_ = _tmp220_;
				vala_report_error (_tmp221_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				return result;
			}
		}
	}
	_tmp222_ = vala_code_context_get_analyzer (context);
	_tmp223_ = _tmp222_;
	_tmp224_ = vala_semantic_analyzer_get_current_symbol (_tmp223_);
	_tmp225_ = _tmp224_;
	_tmp226_ = vala_symbol_get_scope (_tmp225_);
	_tmp227_ = _tmp226_;
	_tmp228_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp229_ = _tmp228_;
	vala_scope_add (_tmp227_, _tmp229_, (ValaSymbol*) self);
	_tmp230_ = vala_code_context_get_analyzer (context);
	_tmp231_ = _tmp230_;
	_tmp232_ = vala_semantic_analyzer_get_current_symbol (_tmp231_);
	_tmp233_ = _tmp232_;
	_tmp234_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp233_, VALA_TYPE_BLOCK) ? ((ValaBlock*) _tmp233_) : NULL);
	block = _tmp234_;
	_tmp235_ = block;
	if (_tmp235_ != NULL) {
		ValaBlock* _tmp236_;
		_tmp236_ = block;
		vala_block_add_local_variable (_tmp236_, self);
	}
	vala_symbol_set_active ((ValaSymbol*) self, TRUE);
	_tmp237_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp238_ = _tmp237_;
	result = !_tmp238_;
	_vala_code_node_unref0 (block);
	return result;
}

gboolean
vala_local_variable_get_is_result (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_result;
	return result;
}

void
vala_local_variable_set_is_result (ValaLocalVariable* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_result = value;
}

gboolean
vala_local_variable_get_captured (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_captured;
	return result;
}

void
vala_local_variable_set_captured (ValaLocalVariable* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_captured = value;
}

gboolean
vala_local_variable_get_init (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_init;
	return result;
}

void
vala_local_variable_set_init (ValaLocalVariable* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_init = value;
}

static void
vala_local_variable_class_init (ValaLocalVariableClass * klass,
                                gpointer klass_data)
{
	vala_local_variable_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_local_variable_finalize;
	g_type_class_adjust_private_offset (klass, &ValaLocalVariable_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_local_variable_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_local_variable_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_local_variable_real_check;
}

static void
vala_local_variable_instance_init (ValaLocalVariable * self,
                                   gpointer klass)
{
	self->priv = vala_local_variable_get_instance_private (self);
}

static void
vala_local_variable_finalize (ValaCodeNode * obj)
{
	ValaLocalVariable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
	VALA_CODE_NODE_CLASS (vala_local_variable_parent_class)->finalize (obj);
}

/**
 * Represents a local variable declaration in the source code.
 */
GType
vala_local_variable_get_type (void)
{
	static volatile gsize vala_local_variable_type_id__volatile = 0;
	if (g_once_init_enter (&vala_local_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLocalVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_local_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLocalVariable), 0, (GInstanceInitFunc) vala_local_variable_instance_init, NULL };
		GType vala_local_variable_type_id;
		vala_local_variable_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaLocalVariable", &g_define_type_info, 0);
		ValaLocalVariable_private_offset = g_type_add_instance_private (vala_local_variable_type_id, sizeof (ValaLocalVariablePrivate));
		g_once_init_leave (&vala_local_variable_type_id__volatile, vala_local_variable_type_id);
	}
	return vala_local_variable_type_id__volatile;
}

