/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};

static gint ValaMethodCall_private_offset;
static gpointer vala_method_call_parent_class = NULL;

static void vala_method_call_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base,
                                              ValaSymbol* sym);
static void vala_method_call_real_get_error_types (ValaCodeNode* base,
                                            ValaCollection* collection,
                                            ValaSourceReference* source_reference);
static gboolean vala_method_call_real_check (ValaCodeNode* base,
                                      ValaCodeContext* context);
static void vala_method_call_set_is_assert (ValaMethodCall* self,
                                     gboolean value);
static void vala_method_call_set_is_chainup (ValaMethodCall* self,
                                      gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                                 gboolean value);
static void vala_method_call_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection);
static gchar* vala_method_call_real_to_string (ValaCodeNode* base);
static void vala_method_call_finalize (ValaCodeNode * obj);

static inline gpointer
vala_method_call_get_instance_private (ValaMethodCall* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethodCall_private_offset);
}

/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
ValaMethodCall*
vala_method_call_construct (GType object_type,
                            ValaExpression* call,
                            ValaSourceReference* source_reference)
{
	ValaMethodCall* self = NULL;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_method_call_set_call (self, call);
	return self;
}

ValaMethodCall*
vala_method_call_new (ValaExpression* call,
                      ValaSourceReference* source_reference)
{
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_method_call_add_argument (ValaMethodCall* self,
                               ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the argument list.
 *
 * @return argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_method_call_get_argument_list (ValaMethodCall* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
vala_method_call_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_method_call_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _expr_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _expr_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_expr_list = _tmp3_;
		_tmp4_ = _expr_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_expr_size = _tmp6_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp7_ = _expr_list;
			_tmp8_ = vala_list_get (_tmp7_, _expr_index);
			expr = (ValaExpression*) _tmp8_;
			_tmp9_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}

static void
vala_method_call_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_method_call_set_call (self, new_node);
	}
	_tmp2_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp2_, old_node);
	if (index >= 0) {
		ValaList* _tmp3_;
		_tmp3_ = self->priv->argument_list;
		vala_list_set (_tmp3_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_method_call_real_is_constant (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gboolean _tmp11_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strcmp0 (_tmp10_, "GLib.N_") == 0;
		_g_free0 (_tmp10_);
		if (_tmp11_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			gboolean _tmp15_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, 0);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_expression_is_constant (_tmp14_);
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp15_;
			_vala_code_node_unref0 (method_type);
			return result;
		} else {
			ValaMethodType* _tmp16_;
			ValaMethod* _tmp17_;
			ValaMethod* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gboolean _tmp21_;
			_tmp16_ = method_type;
			_tmp17_ = vala_method_type_get_method_symbol (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strcmp0 (_tmp20_, "GLib.NC_") == 0;
			_g_free0 (_tmp20_);
			if (_tmp21_) {
				ValaList* _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				_tmp22_ = self->priv->argument_list;
				_tmp23_ = vala_list_get (_tmp22_, 1);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = vala_expression_is_constant (_tmp24_);
				_vala_code_node_unref0 (_tmp24_);
				result = _tmp25_;
				_vala_code_node_unref0 (method_type);
				return result;
			}
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (method_type);
	return result;
}

static gboolean
vala_method_call_real_is_pure (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_accessible (ValaExpression* base,
                                     ValaSymbol* sym)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp5_ = _arg_list;
			_tmp6_ = vala_list_get (_tmp5_, _arg_index);
			arg = (ValaExpression*) _tmp6_;
			_tmp7_ = arg;
			if (!vala_expression_is_accessible (_tmp7_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp8_ = vala_method_call_get_call (self);
	_tmp9_ = _tmp8_;
	result = vala_expression_is_accessible (_tmp9_, sym);
	return result;
}

static void
vala_method_call_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference)
{
	ValaMethodCall * self;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	if (source_reference == NULL) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp1_ = _tmp0_;
		source_reference = _tmp1_;
	}
	_tmp2_ = vala_method_call_get_call (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_expression_get_value_type (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (_tmp5_);
	mtype = _tmp6_;
	_tmp7_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_METHOD_TYPE)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp8_;
		ValaMethod* _tmp9_;
		ValaMethod* _tmp10_;
		ValaMethod* _tmp11_;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		ValaMethod* _tmp15_;
		_tmp8_ = mtype;
		_tmp9_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp10_ = _tmp9_;
		_tmp11_ = _vala_code_node_ref0 (_tmp10_);
		m = _tmp11_;
		_tmp15_ = m;
		if (_tmp15_ != NULL) {
			ValaMethod* _tmp16_;
			gboolean _tmp17_;
			gboolean _tmp18_;
			_tmp16_ = m;
			_tmp17_ = vala_method_get_coroutine (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp14_ = _tmp18_;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			gboolean _tmp19_;
			_tmp19_ = self->priv->_is_yield_expression;
			_tmp13_ = !_tmp19_;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			ValaExpression* _tmp20_;
			ValaExpression* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp20_ = vala_method_call_get_call (self);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp23_ = _tmp22_;
			_tmp12_ = g_strcmp0 (_tmp23_, "end") != 0;
		} else {
			_tmp12_ = FALSE;
		}
		if (!_tmp12_) {
			ValaMethod* _tmp24_;
			_tmp24_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp24_, collection, source_reference);
		}
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp25_;
		_tmp25_ = mtype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALA_TYPE_OBJECT_TYPE)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp26_;
			ValaObjectTypeSymbol* _tmp27_;
			ValaObjectTypeSymbol* _tmp28_;
			ValaClass* _tmp29_;
			ValaCreationMethod* m = NULL;
			ValaClass* _tmp30_;
			ValaCreationMethod* _tmp31_;
			ValaCreationMethod* _tmp32_;
			ValaCreationMethod* _tmp33_;
			ValaCreationMethod* _tmp34_;
			_tmp26_ = mtype;
			_tmp27_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp28_ = _tmp27_;
			_tmp29_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp29_;
			_tmp30_ = cl;
			_tmp31_ = vala_class_get_default_construction_method (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = _vala_code_node_ref0 (_tmp32_);
			m = _tmp33_;
			_tmp34_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp34_, collection, source_reference);
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (cl);
		} else {
			ValaDataType* _tmp35_;
			_tmp35_ = mtype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, VALA_TYPE_DELEGATE_TYPE)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp36_;
				ValaDelegate* _tmp37_;
				ValaDelegate* _tmp38_;
				ValaDelegate* _tmp39_;
				ValaDelegate* _tmp40_;
				_tmp36_ = mtype;
				_tmp37_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp38_ = _tmp37_;
				_tmp39_ = _vala_code_node_ref0 (_tmp38_);
				d = _tmp39_;
				_tmp40_ = d;
				vala_code_node_get_error_types ((ValaCodeNode*) _tmp40_, collection, source_reference);
				_vala_code_node_unref0 (d);
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp41_;
		ValaList* _tmp42_;
		gint _expr_size = 0;
		ValaList* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		gint _expr_index = 0;
		_tmp41_ = self->priv->argument_list;
		_tmp42_ = _vala_iterable_ref0 (_tmp41_);
		_expr_list = _tmp42_;
		_tmp43_ = _expr_list;
		_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
		_tmp45_ = _tmp44_;
		_expr_size = _tmp45_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp46_;
			gpointer _tmp47_;
			ValaExpression* _tmp48_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp46_ = _expr_list;
			_tmp47_ = vala_list_get (_tmp46_, _expr_index);
			expr = (ValaExpression*) _tmp47_;
			_tmp48_ = expr;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp48_, collection, source_reference);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_vala_code_node_unref0 (mtype);
}

static gboolean
vala_method_call_real_check (ValaCodeNode* base,
                             ValaCodeContext* context)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp108_;
	ValaExpression* _tmp109_;
	ValaDataType* _tmp110_;
	ValaDataType* _tmp111_;
	ValaDataType* _tmp112_;
	gboolean _tmp113_ = FALSE;
	ValaProfile _tmp114_;
	ValaProfile _tmp115_;
	gboolean gobject_chainup = FALSE;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp145_;
	gboolean _tmp238_ = FALSE;
	ValaExpression* _tmp239_;
	ValaExpression* _tmp240_;
	gboolean _tmp310_ = FALSE;
	gboolean _tmp311_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp326_;
	ValaDataType* _tmp327_;
	ValaList* params = NULL;
	ValaDataType* _tmp328_;
	ValaList* _tmp329_;
	ValaDataType* _tmp330_;
	ValaExpression* last_arg = NULL;
	ValaList* args = NULL;
	ValaList* _tmp397_;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp398_;
	ValaIterator* _tmp399_;
	gboolean _tmp448_ = FALSE;
	ValaDataType* _tmp449_;
	gboolean _tmp469_ = FALSE;
	ValaDataType* _tmp470_;
	gboolean force_lambda_method_closure = FALSE;
	ValaDataType* _tmp554_;
	ValaDataType* _tmp565_;
	ValaDataType* _tmp566_;
	ValaDataType* _tmp567_;
	ValaDataType* _tmp568_;
	ValaDataType* _tmp569_;
	ValaDataType* _tmp570_;
	ValaList* _tmp571_;
	ValaDataType* _tmp572_;
	ValaDataType* _tmp573_;
	ValaDataType* _tmp574_;
	ValaSemanticAnalyzer* _tmp798_;
	ValaSemanticAnalyzer* _tmp799_;
	ValaDataType* _tmp800_;
	ValaList* _tmp801_;
	ValaList* _tmp802_;
	ValaList* _tmp803_;
	gboolean _tmp804_;
	gboolean _tmp805_ = FALSE;
	gboolean _tmp806_ = FALSE;
	ValaCreationMethod* _tmp807_;
	gboolean _tmp836_;
	gboolean _tmp837_;
	gboolean _tmp890_;
	gboolean _tmp891_;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_method_call_get_call (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp6_ = vala_method_call_get_call (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_value_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp10_ = vala_method_call_get_call (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_expression_get_value_type (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _vala_code_node_ref0 (_tmp13_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp14_;
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_MEMBER_ACCESS)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaMemberAccess* _tmp19_;
			ValaMemberAccess* _tmp20_;
			gboolean _tmp21_;
			gboolean _tmp22_;
			ValaMemberAccess* _tmp33_;
			ValaList* _tmp34_;
			ValaMemberAccess* _tmp35_;
			ValaExpression* _tmp36_;
			ValaExpression* _tmp37_;
			gboolean _tmp91_ = FALSE;
			ValaMemberAccess* _tmp92_;
			ValaSymbol* _tmp93_;
			ValaSymbol* _tmp94_;
			_tmp17_ = vala_method_call_get_call (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp19_;
			_tmp20_ = ma;
			_tmp21_ = vala_member_access_get_prototype_access (_tmp20_);
			_tmp22_ = _tmp21_;
			if (_tmp22_) {
				ValaSourceReference* _tmp23_;
				ValaSourceReference* _tmp24_;
				ValaExpression* _tmp25_;
				ValaExpression* _tmp26_;
				ValaSymbol* _tmp27_;
				ValaSymbol* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_method_call_get_call (self);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_expression_get_symbol_reference (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_symbol_get_full_name (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp30_);
				_tmp32_ = _tmp31_;
				vala_report_error (_tmp24_, _tmp32_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp30_);
				result = FALSE;
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp33_ = ma;
			_tmp34_ = vala_member_access_get_type_arguments (_tmp33_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp34_;
			_tmp35_ = ma;
			_tmp36_ = vala_member_access_get_inner (_tmp35_);
			_tmp37_ = _tmp36_;
			if (_tmp37_ != NULL) {
				ValaMemberAccess* _tmp38_;
				ValaExpression* _tmp39_;
				ValaExpression* _tmp40_;
				ValaDataType* _tmp41_;
				ValaDataType* _tmp42_;
				ValaDataType* _tmp43_;
				ValaMemberAccess* _tmp44_;
				ValaExpression* _tmp45_;
				ValaExpression* _tmp46_;
				ValaSymbol* _tmp47_;
				ValaSymbol* _tmp48_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp60_;
				ValaSymbol* _tmp61_;
				ValaSymbol* _tmp62_;
				ValaMethod* _tmp63_;
				gboolean _tmp64_ = FALSE;
				ValaMethod* _tmp65_;
				_tmp38_ = ma;
				_tmp39_ = vala_member_access_get_inner (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_expression_get_value_type (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = _vala_code_node_ref0 (_tmp42_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp43_;
				_tmp44_ = ma;
				_tmp45_ = vala_member_access_get_inner (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_expression_get_symbol_reference (_tmp46_);
				_tmp48_ = _tmp47_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, VALA_TYPE_SIGNAL)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp49_;
					ValaExpression* _tmp50_;
					ValaExpression* _tmp51_;
					ValaMemberAccess* _tmp52_;
					ValaMemberAccess* _tmp53_;
					_tmp49_ = ma;
					_tmp50_ = vala_member_access_get_inner (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp51_) : NULL);
					sig = _tmp52_;
					_tmp53_ = sig;
					if (_tmp53_ != NULL) {
						ValaMemberAccess* _tmp54_;
						ValaExpression* _tmp55_;
						ValaExpression* _tmp56_;
						ValaDataType* _tmp57_;
						ValaDataType* _tmp58_;
						ValaDataType* _tmp59_;
						_tmp54_ = sig;
						_tmp55_ = vala_member_access_get_inner (_tmp54_);
						_tmp56_ = _tmp55_;
						_tmp57_ = vala_expression_get_value_type (_tmp56_);
						_tmp58_ = _tmp57_;
						_tmp59_ = _vala_code_node_ref0 (_tmp58_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp59_;
					}
					_vala_code_node_unref0 (sig);
				}
				_tmp60_ = ma;
				_tmp61_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp60_);
				_tmp62_ = _tmp61_;
				_tmp63_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp62_) : NULL);
				m = _tmp63_;
				_tmp65_ = m;
				if (_tmp65_ != NULL) {
					ValaMethod* _tmp66_;
					gboolean _tmp67_;
					gboolean _tmp68_;
					_tmp66_ = m;
					_tmp67_ = vala_method_get_coroutine (_tmp66_);
					_tmp68_ = _tmp67_;
					_tmp64_ = _tmp68_;
				} else {
					_tmp64_ = FALSE;
				}
				if (_tmp64_) {
					gboolean _tmp69_ = FALSE;
					ValaMemberAccess* _tmp70_;
					const gchar* _tmp71_;
					const gchar* _tmp72_;
					_tmp70_ = ma;
					_tmp71_ = vala_member_access_get_member_name (_tmp70_);
					_tmp72_ = _tmp71_;
					if (g_strcmp0 (_tmp72_, "begin") == 0) {
						_tmp69_ = TRUE;
					} else {
						ValaMemberAccess* _tmp73_;
						const gchar* _tmp74_;
						const gchar* _tmp75_;
						_tmp73_ = ma;
						_tmp74_ = vala_member_access_get_member_name (_tmp73_);
						_tmp75_ = _tmp74_;
						_tmp69_ = g_strcmp0 (_tmp75_, "end") == 0;
					}
					if (_tmp69_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp76_;
						ValaExpression* _tmp77_;
						ValaExpression* _tmp78_;
						ValaMemberAccess* _tmp79_;
						gboolean _tmp80_ = FALSE;
						ValaMemberAccess* _tmp81_;
						_tmp76_ = ma;
						_tmp77_ = vala_member_access_get_inner (_tmp76_);
						_tmp78_ = _tmp77_;
						_tmp79_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp78_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp78_) : NULL);
						method_access = _tmp79_;
						_tmp81_ = method_access;
						if (_tmp81_ != NULL) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							_tmp82_ = method_access;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp80_ = _tmp84_ != NULL;
						} else {
							_tmp80_ = FALSE;
						}
						if (_tmp80_) {
							ValaMemberAccess* _tmp85_;
							ValaExpression* _tmp86_;
							ValaExpression* _tmp87_;
							ValaDataType* _tmp88_;
							ValaDataType* _tmp89_;
							ValaDataType* _tmp90_;
							_tmp85_ = method_access;
							_tmp86_ = vala_member_access_get_inner (_tmp85_);
							_tmp87_ = _tmp86_;
							_tmp88_ = vala_expression_get_value_type (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp90_ = _vala_code_node_ref0 (_tmp89_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp90_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
						_vala_code_node_unref0 (method_access);
					}
				}
				_vala_code_node_unref0 (m);
			}
			_tmp92_ = ma;
			_tmp93_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp92_);
			_tmp94_ = _tmp93_;
			if (_tmp94_ != NULL) {
				ValaMemberAccess* _tmp95_;
				ValaSymbol* _tmp96_;
				ValaSymbol* _tmp97_;
				ValaAttribute* _tmp98_;
				_tmp95_ = ma;
				_tmp96_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp95_);
				_tmp97_ = _tmp96_;
				_tmp98_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp97_, "Assert");
				_tmp91_ = _tmp98_ != NULL;
			} else {
				_tmp91_ = FALSE;
			}
			if (_tmp91_) {
				ValaList* args = NULL;
				ValaList* _tmp99_;
				ValaList* _tmp100_;
				gint _tmp101_;
				gint _tmp102_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp99_ = vala_method_call_get_argument_list (self);
				args = _tmp99_;
				_tmp100_ = args;
				_tmp101_ = vala_collection_get_size ((ValaCollection*) _tmp100_);
				_tmp102_ = _tmp101_;
				if (_tmp102_ == 1) {
					ValaList* _tmp103_;
					gpointer _tmp104_;
					ValaExpression* _tmp105_;
					ValaSourceReference* _tmp106_;
					ValaSourceReference* _tmp107_;
					_tmp103_ = args;
					_tmp104_ = vala_list_get (_tmp103_, 0);
					_tmp105_ = (ValaExpression*) _tmp104_;
					_tmp106_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp105_);
					_tmp107_ = _tmp106_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp107_);
					_vala_code_node_unref0 (_tmp105_);
				}
				_vala_iterable_unref0 (args);
			}
			_vala_code_node_unref0 (ma);
		}
	}
	_tmp108_ = vala_method_call_get_call (self);
	_tmp109_ = _tmp108_;
	_tmp110_ = vala_expression_get_value_type (_tmp109_);
	_tmp111_ = _tmp110_;
	_tmp112_ = _vala_code_node_ref0 (_tmp111_);
	mtype = _tmp112_;
	_tmp114_ = vala_code_context_get_profile (context);
	_tmp115_ = _tmp114_;
	if (_tmp115_ == VALA_PROFILE_GOBJECT) {
		ValaExpression* _tmp116_;
		ValaExpression* _tmp117_;
		ValaSymbol* _tmp118_;
		ValaSymbol* _tmp119_;
		ValaSemanticAnalyzer* _tmp120_;
		ValaSemanticAnalyzer* _tmp121_;
		ValaClass* _tmp122_;
		_tmp116_ = vala_method_call_get_call (self);
		_tmp117_ = _tmp116_;
		_tmp118_ = vala_expression_get_symbol_reference (_tmp117_);
		_tmp119_ = _tmp118_;
		_tmp120_ = vala_code_context_get_analyzer (context);
		_tmp121_ = _tmp120_;
		_tmp122_ = _tmp121_->object_type;
		_tmp113_ = _tmp119_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp122_, VALA_TYPE_SYMBOL, ValaSymbol);
	} else {
		_tmp113_ = FALSE;
	}
	gobject_chainup = _tmp113_;
	vala_method_call_set_is_chainup (self, gobject_chainup);
	if (!gobject_chainup) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp123_;
		ValaExpression* _tmp124_;
		ValaExpression* _tmp125_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp126_;
		ValaMemberAccess* _tmp127_;
		gboolean _tmp128_ = FALSE;
		ValaMemberAccess* _tmp129_;
		gboolean _tmp139_ = FALSE;
		ValaMemberAccess* _tmp140_;
		_tmp123_ = vala_method_call_get_call (self);
		_tmp124_ = _tmp123_;
		_tmp125_ = _vala_code_node_ref0 (_tmp124_);
		expr = _tmp125_;
		_tmp126_ = expr;
		_tmp127_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp126_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp126_) : NULL);
		ma = _tmp127_;
		_tmp129_ = ma;
		if (_tmp129_ != NULL) {
			ValaMemberAccess* _tmp130_;
			ValaSymbol* _tmp131_;
			ValaSymbol* _tmp132_;
			_tmp130_ = ma;
			_tmp131_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp130_);
			_tmp132_ = _tmp131_;
			_tmp128_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp132_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp128_ = FALSE;
		}
		if (_tmp128_) {
			ValaMemberAccess* _tmp133_;
			ValaExpression* _tmp134_;
			ValaExpression* _tmp135_;
			ValaExpression* _tmp136_;
			ValaExpression* _tmp137_;
			ValaMemberAccess* _tmp138_;
			_tmp133_ = ma;
			_tmp134_ = vala_member_access_get_inner (_tmp133_);
			_tmp135_ = _tmp134_;
			_tmp136_ = _vala_code_node_ref0 (_tmp135_);
			_vala_code_node_unref0 (expr);
			expr = _tmp136_;
			_tmp137_ = expr;
			_tmp138_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp137_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp137_) : NULL);
			_vala_code_node_unref0 (ma);
			ma = _tmp138_;
		}
		_tmp140_ = ma;
		if (_tmp140_ != NULL) {
			ValaMemberAccess* _tmp141_;
			const gchar* _tmp142_;
			const gchar* _tmp143_;
			_tmp141_ = ma;
			_tmp142_ = vala_member_access_get_member_name (_tmp141_);
			_tmp143_ = _tmp142_;
			_tmp139_ = g_strcmp0 (_tmp143_, "this") == 0;
		} else {
			_tmp139_ = FALSE;
		}
		if (_tmp139_) {
			vala_method_call_set_is_chainup (self, TRUE);
		} else {
			ValaExpression* _tmp144_;
			_tmp144_ = expr;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp144_, VALA_TYPE_BASE_ACCESS)) {
				vala_method_call_set_is_chainup (self, TRUE);
			}
		}
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (expr);
	}
	base_cm = NULL;
	_tmp145_ = self->priv->_is_chainup;
	if (_tmp145_) {
		ValaCreationMethod* cm = NULL;
		ValaSemanticAnalyzer* _tmp146_;
		ValaSemanticAnalyzer* _tmp147_;
		ValaMethod* _tmp148_;
		ValaCreationMethod* _tmp149_;
		ValaCreationMethod* _tmp150_;
		ValaCreationMethod* _tmp158_;
		ValaDataType* _tmp159_;
		_tmp146_ = vala_code_context_get_analyzer (context);
		_tmp147_ = _tmp146_;
		_tmp148_ = vala_semantic_analyzer_find_current_method (_tmp147_);
		_tmp149_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp148_, VALA_TYPE_CREATION_METHOD) ? ((ValaCreationMethod*) _tmp148_) : NULL;
		if (_tmp149_ == NULL) {
			_vala_code_node_unref0 (_tmp148_);
		}
		cm = _tmp149_;
		_tmp150_ = cm;
		if (_tmp150_ == NULL) {
			ValaSourceReference* _tmp151_;
			ValaSourceReference* _tmp152_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp152_ = _tmp151_;
			vala_report_error (_tmp152_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (cm);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp153_;
			gboolean _tmp154_;
			gboolean _tmp155_;
			_tmp153_ = cm;
			_tmp154_ = vala_creation_method_get_chain_up (_tmp153_);
			_tmp155_ = _tmp154_;
			if (_tmp155_) {
				ValaSourceReference* _tmp156_;
				ValaSourceReference* _tmp157_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp156_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp157_ = _tmp156_;
				vala_report_error (_tmp157_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (cm);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp158_ = cm;
		vala_creation_method_set_chain_up (_tmp158_, TRUE);
		_tmp159_ = mtype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp159_, VALA_TYPE_OBJECT_TYPE)) {
			ValaObjectType* otype = NULL;
			ValaDataType* _tmp160_;
			ValaObjectType* _tmp161_;
			ValaClass* cl = NULL;
			ValaObjectType* _tmp162_;
			ValaObjectTypeSymbol* _tmp163_;
			ValaObjectTypeSymbol* _tmp164_;
			ValaClass* _tmp165_;
			ValaClass* _tmp166_;
			ValaCreationMethod* _tmp167_;
			ValaCreationMethod* _tmp168_;
			ValaCreationMethod* _tmp169_;
			ValaCreationMethod* _tmp170_;
			_tmp160_ = mtype;
			_tmp161_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			otype = _tmp161_;
			_tmp162_ = otype;
			_tmp163_ = vala_object_type_get_type_symbol (_tmp162_);
			_tmp164_ = _tmp163_;
			_tmp165_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp164_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp165_;
			_tmp166_ = cl;
			_tmp167_ = vala_class_get_default_construction_method (_tmp166_);
			_tmp168_ = _tmp167_;
			_tmp169_ = _vala_code_node_ref0 (_tmp168_);
			_vala_code_node_unref0 (base_cm);
			base_cm = _tmp169_;
			_tmp170_ = base_cm;
			if (_tmp170_ == NULL) {
				ValaSourceReference* _tmp171_;
				ValaSourceReference* _tmp172_;
				ValaClass* _tmp173_;
				gchar* _tmp174_;
				gchar* _tmp175_;
				gchar* _tmp176_;
				gchar* _tmp177_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp171_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp172_ = _tmp171_;
				_tmp173_ = cl;
				_tmp174_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp173_);
				_tmp175_ = _tmp174_;
				_tmp176_ = g_strdup_printf ("chain up to `%s' not supported", _tmp175_);
				_tmp177_ = _tmp176_;
				vala_report_error (_tmp172_, _tmp177_);
				_g_free0 (_tmp177_);
				_g_free0 (_tmp175_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (otype);
				_vala_code_node_unref0 (cm);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp178_;
				gboolean _tmp179_;
				gboolean _tmp180_;
				_tmp178_ = base_cm;
				_tmp179_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp178_);
				_tmp180_ = _tmp179_;
				if (!_tmp180_) {
					ValaSourceReference* _tmp181_;
					ValaSourceReference* _tmp182_;
					ValaCreationMethod* _tmp183_;
					gchar* _tmp184_;
					gchar* _tmp185_;
					gchar* _tmp186_;
					gchar* _tmp187_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp181_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp182_ = _tmp181_;
					_tmp183_ = base_cm;
					_tmp184_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp183_);
					_tmp185_ = _tmp184_;
					_tmp186_ = g_strdup_printf ("chain up to `%s' not supported", _tmp185_);
					_tmp187_ = _tmp186_;
					vala_report_error (_tmp182_, _tmp187_);
					_g_free0 (_tmp187_);
					_g_free0 (_tmp185_);
					result = FALSE;
					_vala_code_node_unref0 (cl);
					_vala_code_node_unref0 (otype);
					_vala_code_node_unref0 (cm);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (otype);
		} else {
			gboolean _tmp188_ = FALSE;
			ValaExpression* _tmp189_;
			ValaExpression* _tmp190_;
			ValaSymbol* _tmp191_;
			ValaSymbol* _tmp192_;
			_tmp189_ = vala_method_call_get_call (self);
			_tmp190_ = _tmp189_;
			_tmp191_ = vala_expression_get_symbol_reference (_tmp190_);
			_tmp192_ = _tmp191_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp192_, VALA_TYPE_CREATION_METHOD)) {
				ValaExpression* _tmp193_;
				ValaExpression* _tmp194_;
				ValaSymbol* _tmp195_;
				ValaSymbol* _tmp196_;
				ValaSymbol* _tmp197_;
				ValaSymbol* _tmp198_;
				_tmp193_ = vala_method_call_get_call (self);
				_tmp194_ = _tmp193_;
				_tmp195_ = vala_expression_get_symbol_reference (_tmp194_);
				_tmp196_ = _tmp195_;
				_tmp197_ = vala_symbol_get_parent_symbol (_tmp196_);
				_tmp198_ = _tmp197_;
				_tmp188_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp198_, VALA_TYPE_CLASS);
			} else {
				_tmp188_ = FALSE;
			}
			if (_tmp188_) {
				ValaExpression* _tmp199_;
				ValaExpression* _tmp200_;
				ValaSymbol* _tmp201_;
				ValaSymbol* _tmp202_;
				ValaCreationMethod* _tmp203_;
				ValaCreationMethod* _tmp204_;
				gboolean _tmp205_;
				gboolean _tmp206_;
				_tmp199_ = vala_method_call_get_call (self);
				_tmp200_ = _tmp199_;
				_tmp201_ = vala_expression_get_symbol_reference (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp202_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
				_vala_code_node_unref0 (base_cm);
				base_cm = _tmp203_;
				_tmp204_ = base_cm;
				_tmp205_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp204_);
				_tmp206_ = _tmp205_;
				if (!_tmp206_) {
					ValaSourceReference* _tmp207_;
					ValaSourceReference* _tmp208_;
					ValaCreationMethod* _tmp209_;
					gchar* _tmp210_;
					gchar* _tmp211_;
					gchar* _tmp212_;
					gchar* _tmp213_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp207_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp208_ = _tmp207_;
					_tmp209_ = base_cm;
					_tmp210_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp209_);
					_tmp211_ = _tmp210_;
					_tmp212_ = g_strdup_printf ("chain up to `%s' not supported", _tmp211_);
					_tmp213_ = _tmp212_;
					vala_report_error (_tmp208_, _tmp213_);
					_g_free0 (_tmp213_);
					_g_free0 (_tmp211_);
					result = FALSE;
					_vala_code_node_unref0 (cm);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				if (gobject_chainup) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp214_;
					ValaSymbol* _tmp215_;
					ValaSymbol* _tmp216_;
					ValaClass* _tmp217_;
					gboolean _tmp218_ = FALSE;
					ValaClass* _tmp219_;
					ValaExpression* _tmp226_;
					ValaExpression* _tmp227_;
					ValaSemanticAnalyzer* _tmp228_;
					ValaSemanticAnalyzer* _tmp229_;
					ValaClass* _tmp230_;
					ValaObjectType* _tmp231_;
					ValaObjectType* _tmp232_;
					ValaExpression* _tmp233_;
					ValaExpression* _tmp234_;
					ValaDataType* _tmp235_;
					ValaDataType* _tmp236_;
					ValaDataType* _tmp237_;
					_tmp214_ = cm;
					_tmp215_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp214_);
					_tmp216_ = _tmp215_;
					_tmp217_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp216_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp216_) : NULL);
					cl = _tmp217_;
					_tmp219_ = cl;
					if (_tmp219_ == NULL) {
						_tmp218_ = TRUE;
					} else {
						ValaClass* _tmp220_;
						ValaSemanticAnalyzer* _tmp221_;
						ValaSemanticAnalyzer* _tmp222_;
						ValaClass* _tmp223_;
						_tmp220_ = cl;
						_tmp221_ = vala_code_context_get_analyzer (context);
						_tmp222_ = _tmp221_;
						_tmp223_ = _tmp222_->object_type;
						_tmp218_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp220_, (ValaTypeSymbol*) _tmp223_);
					}
					if (_tmp218_) {
						ValaSourceReference* _tmp224_;
						ValaSourceReference* _tmp225_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp224_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp225_ = _tmp224_;
						vala_report_error (_tmp225_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (cl);
						_vala_code_node_unref0 (cm);
						_vala_code_node_unref0 (base_cm);
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp226_ = vala_method_call_get_call (self);
					_tmp227_ = _tmp226_;
					_tmp228_ = vala_code_context_get_analyzer (context);
					_tmp229_ = _tmp228_;
					_tmp230_ = _tmp229_->object_type;
					_tmp231_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp230_);
					_tmp232_ = _tmp231_;
					vala_expression_set_value_type (_tmp227_, (ValaDataType*) _tmp232_);
					_vala_code_node_unref0 (_tmp232_);
					_tmp233_ = vala_method_call_get_call (self);
					_tmp234_ = _tmp233_;
					_tmp235_ = vala_expression_get_value_type (_tmp234_);
					_tmp236_ = _tmp235_;
					_tmp237_ = _vala_code_node_ref0 (_tmp236_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp237_;
					_vala_code_node_unref0 (cl);
				}
			}
		}
		_vala_code_node_unref0 (cm);
	}
	_tmp239_ = vala_method_call_get_call (self);
	_tmp240_ = _tmp239_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp240_, VALA_TYPE_MEMBER_ACCESS)) {
		gboolean _tmp241_ = FALSE;
		gboolean _tmp242_ = FALSE;
		ValaExpression* _tmp243_;
		ValaExpression* _tmp244_;
		ValaSymbol* _tmp245_;
		ValaSymbol* _tmp246_;
		_tmp243_ = vala_method_call_get_call (self);
		_tmp244_ = _tmp243_;
		_tmp245_ = vala_expression_get_symbol_reference (_tmp244_);
		_tmp246_ = _tmp245_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp246_, VALA_TYPE_CREATION_METHOD)) {
			ValaExpression* _tmp247_;
			ValaExpression* _tmp248_;
			ValaSymbol* _tmp249_;
			ValaSymbol* _tmp250_;
			ValaSymbol* _tmp251_;
			ValaSymbol* _tmp252_;
			_tmp247_ = vala_method_call_get_call (self);
			_tmp248_ = _tmp247_;
			_tmp249_ = vala_expression_get_symbol_reference (_tmp248_);
			_tmp250_ = _tmp249_;
			_tmp251_ = vala_symbol_get_parent_symbol (_tmp250_);
			_tmp252_ = _tmp251_;
			_tmp242_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp252_, VALA_TYPE_STRUCT);
		} else {
			_tmp242_ = FALSE;
		}
		if (_tmp242_) {
			_tmp241_ = TRUE;
		} else {
			ValaExpression* _tmp253_;
			ValaExpression* _tmp254_;
			ValaSymbol* _tmp255_;
			ValaSymbol* _tmp256_;
			_tmp253_ = vala_method_call_get_call (self);
			_tmp254_ = _tmp253_;
			_tmp255_ = vala_expression_get_symbol_reference (_tmp254_);
			_tmp256_ = _tmp255_;
			_tmp241_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp256_, VALA_TYPE_STRUCT);
		}
		_tmp238_ = _tmp241_;
	} else {
		_tmp238_ = FALSE;
	}
	if (_tmp238_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp257_;
		ValaExpression* _tmp258_;
		ValaSymbol* _tmp259_;
		ValaSymbol* _tmp260_;
		ValaStruct* _tmp261_;
		gboolean _tmp262_ = FALSE;
		gboolean _tmp263_ = FALSE;
		ValaStruct* _tmp264_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp275_;
		ValaExpression* _tmp276_;
		ValaSourceReference* _tmp277_;
		ValaSourceReference* _tmp278_;
		ValaObjectCreationExpression* _tmp279_;
		ValaObjectCreationExpression* _tmp280_;
		ValaObjectCreationExpression* _tmp289_;
		ValaDataType* _tmp290_;
		ValaDataType* _tmp291_;
		ValaSemanticAnalyzer* _tmp292_;
		ValaSemanticAnalyzer* _tmp293_;
		ValaList* _tmp294_;
		ValaCodeNode* _tmp295_;
		ValaCodeNode* _tmp296_;
		ValaObjectCreationExpression* _tmp297_;
		ValaObjectCreationExpression* _tmp298_;
		_tmp257_ = vala_method_call_get_call (self);
		_tmp258_ = _tmp257_;
		_tmp259_ = vala_expression_get_symbol_reference (_tmp258_);
		_tmp260_ = _tmp259_;
		_tmp261_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp260_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp260_) : NULL);
		st = _tmp261_;
		_tmp264_ = st;
		if (_tmp264_ != NULL) {
			ValaStruct* _tmp265_;
			ValaCreationMethod* _tmp266_;
			ValaCreationMethod* _tmp267_;
			_tmp265_ = st;
			_tmp266_ = vala_struct_get_default_construction_method (_tmp265_);
			_tmp267_ = _tmp266_;
			_tmp263_ = _tmp267_ == NULL;
		} else {
			_tmp263_ = FALSE;
		}
		if (_tmp263_) {
			gboolean _tmp268_ = FALSE;
			gboolean _tmp269_ = FALSE;
			ValaStruct* _tmp270_;
			_tmp270_ = st;
			if (vala_struct_is_boolean_type (_tmp270_)) {
				_tmp269_ = TRUE;
			} else {
				ValaStruct* _tmp271_;
				_tmp271_ = st;
				_tmp269_ = vala_struct_is_integer_type (_tmp271_);
			}
			if (_tmp269_) {
				_tmp268_ = TRUE;
			} else {
				ValaStruct* _tmp272_;
				_tmp272_ = st;
				_tmp268_ = vala_struct_is_floating_type (_tmp272_);
			}
			_tmp262_ = _tmp268_;
		} else {
			_tmp262_ = FALSE;
		}
		if (_tmp262_) {
			ValaSourceReference* _tmp273_;
			ValaSourceReference* _tmp274_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp273_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp274_ = _tmp273_;
			vala_report_error (_tmp274_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp275_ = vala_method_call_get_call (self);
		_tmp276_ = _tmp275_;
		_tmp277_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp278_ = _tmp277_;
		_tmp279_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp276_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp278_);
		struct_creation_expression = _tmp279_;
		_tmp280_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp280_, TRUE);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp281_;
			gint _arg_size = 0;
			ValaList* _tmp282_;
			gint _tmp283_;
			gint _tmp284_;
			gint _arg_index = 0;
			_tmp281_ = vala_method_call_get_argument_list (self);
			_arg_list = _tmp281_;
			_tmp282_ = _arg_list;
			_tmp283_ = vala_collection_get_size ((ValaCollection*) _tmp282_);
			_tmp284_ = _tmp283_;
			_arg_size = _tmp284_;
			_arg_index = -1;
			while (TRUE) {
				ValaExpression* arg = NULL;
				ValaList* _tmp285_;
				gpointer _tmp286_;
				ValaObjectCreationExpression* _tmp287_;
				ValaExpression* _tmp288_;
				_arg_index = _arg_index + 1;
				if (!(_arg_index < _arg_size)) {
					break;
				}
				_tmp285_ = _arg_list;
				_tmp286_ = vala_list_get (_tmp285_, _arg_index);
				arg = (ValaExpression*) _tmp286_;
				_tmp287_ = struct_creation_expression;
				_tmp288_ = arg;
				vala_object_creation_expression_add_argument (_tmp287_, _tmp288_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp289_ = struct_creation_expression;
		_tmp290_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp291_ = _tmp290_;
		vala_expression_set_target_type ((ValaExpression*) _tmp289_, _tmp291_);
		_tmp292_ = vala_code_context_get_analyzer (context);
		_tmp293_ = _tmp292_;
		_tmp294_ = _tmp293_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp294_, (ValaCodeNode*) self);
		_tmp295_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp296_ = _tmp295_;
		_tmp297_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp296_, (ValaExpression*) self, (ValaExpression*) _tmp297_);
		_tmp298_ = struct_creation_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp298_, context);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (st);
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp299_ = FALSE;
		gboolean _tmp300_ = FALSE;
		gboolean _tmp301_;
		_tmp301_ = self->priv->_is_chainup;
		if (!_tmp301_) {
			ValaExpression* _tmp302_;
			ValaExpression* _tmp303_;
			_tmp302_ = vala_method_call_get_call (self);
			_tmp303_ = _tmp302_;
			_tmp300_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp303_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp300_ = FALSE;
		}
		if (_tmp300_) {
			ValaExpression* _tmp304_;
			ValaExpression* _tmp305_;
			ValaSymbol* _tmp306_;
			ValaSymbol* _tmp307_;
			_tmp304_ = vala_method_call_get_call (self);
			_tmp305_ = _tmp304_;
			_tmp306_ = vala_expression_get_symbol_reference (_tmp305_);
			_tmp307_ = _tmp306_;
			_tmp299_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp307_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp299_ = FALSE;
		}
		if (_tmp299_) {
			ValaSourceReference* _tmp308_;
			ValaSourceReference* _tmp309_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp308_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp309_ = _tmp308_;
			vala_report_error (_tmp309_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp311_ = self->priv->_is_chainup;
	if (!_tmp311_) {
		ValaDataType* _tmp312_;
		_tmp312_ = mtype;
		_tmp310_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp312_, VALA_TYPE_OBJECT_TYPE);
	} else {
		_tmp310_ = FALSE;
	}
	if (_tmp310_) {
		ValaSourceReference* _tmp313_;
		ValaSourceReference* _tmp314_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp313_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp314_ = _tmp313_;
		vala_report_error (_tmp314_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp315_ = FALSE;
		ValaDataType* _tmp316_;
		_tmp316_ = mtype;
		if (_tmp316_ != NULL) {
			ValaDataType* _tmp317_;
			_tmp317_ = mtype;
			_tmp315_ = vala_data_type_is_invokable (_tmp317_);
		} else {
			_tmp315_ = FALSE;
		}
		if (_tmp315_) {
		} else {
			ValaExpression* _tmp318_;
			ValaExpression* _tmp319_;
			ValaSymbol* _tmp320_;
			ValaSymbol* _tmp321_;
			_tmp318_ = vala_method_call_get_call (self);
			_tmp319_ = _tmp318_;
			_tmp320_ = vala_expression_get_symbol_reference (_tmp319_);
			_tmp321_ = _tmp320_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp321_, VALA_TYPE_CLASS)) {
				ValaSourceReference* _tmp322_;
				ValaSourceReference* _tmp323_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp322_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp323_ = _tmp322_;
				vala_report_error (_tmp323_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp324_;
				ValaSourceReference* _tmp325_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp324_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp325_ = _tmp324_;
				vala_report_error (_tmp325_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp326_ = mtype;
	_tmp327_ = vala_data_type_get_return_type (_tmp326_);
	ret_type = _tmp327_;
	_tmp328_ = mtype;
	_tmp329_ = vala_data_type_get_parameters (_tmp328_);
	params = _tmp329_;
	_tmp330_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp330_, VALA_TYPE_METHOD_TYPE)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp331_;
		ValaMethod* _tmp332_;
		ValaMethod* _tmp333_;
		ValaMethod* _tmp334_;
		gboolean _tmp335_ = FALSE;
		ValaMethod* _tmp336_;
		ValaMethod* _tmp373_;
		_tmp331_ = mtype;
		_tmp332_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp331_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp333_ = _tmp332_;
		_tmp334_ = _vala_code_node_ref0 (_tmp333_);
		m = _tmp334_;
		_tmp336_ = m;
		if (_tmp336_ != NULL) {
			ValaMethod* _tmp337_;
			gboolean _tmp338_;
			gboolean _tmp339_;
			_tmp337_ = m;
			_tmp338_ = vala_method_get_coroutine (_tmp337_);
			_tmp339_ = _tmp338_;
			_tmp335_ = _tmp339_;
		} else {
			_tmp335_ = FALSE;
		}
		if (_tmp335_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp340_;
			ValaExpression* _tmp341_;
			ValaMemberAccess* _tmp342_;
			gboolean _tmp343_;
			_tmp340_ = vala_method_call_get_call (self);
			_tmp341_ = _tmp340_;
			_tmp342_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp341_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp342_;
			_tmp343_ = self->priv->_is_yield_expression;
			if (!_tmp343_) {
				ValaMemberAccess* _tmp344_;
				const gchar* _tmp345_;
				const gchar* _tmp346_;
				_tmp344_ = ma;
				_tmp345_ = vala_member_access_get_member_name (_tmp344_);
				_tmp346_ = _tmp345_;
				if (g_strcmp0 (_tmp346_, "end") != 0) {
					ValaMemberAccess* _tmp347_;
					const gchar* _tmp348_;
					const gchar* _tmp349_;
					ValaMethod* _tmp353_;
					ValaList* _tmp354_;
					ValaVoidType* _tmp355_;
					_tmp347_ = ma;
					_tmp348_ = vala_member_access_get_member_name (_tmp347_);
					_tmp349_ = _tmp348_;
					if (g_strcmp0 (_tmp349_, "begin") != 0) {
						ValaMemberAccess* _tmp350_;
						ValaSourceReference* _tmp351_;
						ValaSourceReference* _tmp352_;
						_tmp350_ = ma;
						_tmp351_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp350_);
						_tmp352_ = _tmp351_;
						vala_report_deprecated (_tmp352_, "implicit .begin is deprecated");
					}
					_tmp353_ = m;
					_tmp354_ = vala_method_get_async_begin_parameters (_tmp353_);
					_vala_iterable_unref0 (params);
					params = _tmp354_;
					_tmp355_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp355_;
				} else {
					ValaMethod* _tmp356_;
					ValaList* _tmp357_;
					_tmp356_ = m;
					_tmp357_ = vala_method_get_async_end_parameters (_tmp356_);
					_vala_iterable_unref0 (params);
					params = _tmp357_;
				}
			} else {
				gboolean _tmp358_ = FALSE;
				ValaMemberAccess* _tmp359_;
				const gchar* _tmp360_;
				const gchar* _tmp361_;
				_tmp359_ = ma;
				_tmp360_ = vala_member_access_get_member_name (_tmp359_);
				_tmp361_ = _tmp360_;
				if (g_strcmp0 (_tmp361_, "begin") == 0) {
					_tmp358_ = TRUE;
				} else {
					ValaMemberAccess* _tmp362_;
					const gchar* _tmp363_;
					const gchar* _tmp364_;
					_tmp362_ = ma;
					_tmp363_ = vala_member_access_get_member_name (_tmp362_);
					_tmp364_ = _tmp363_;
					_tmp358_ = g_strcmp0 (_tmp364_, "end") == 0;
				}
				if (_tmp358_) {
					ValaMemberAccess* _tmp365_;
					ValaSourceReference* _tmp366_;
					ValaSourceReference* _tmp367_;
					ValaMemberAccess* _tmp368_;
					const gchar* _tmp369_;
					const gchar* _tmp370_;
					gchar* _tmp371_;
					gchar* _tmp372_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp365_ = ma;
					_tmp366_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp365_);
					_tmp367_ = _tmp366_;
					_tmp368_ = ma;
					_tmp369_ = vala_member_access_get_member_name (_tmp368_);
					_tmp370_ = _tmp369_;
					_tmp371_ = g_strdup_printf ("use of `%s' not allowed in yield statement", _tmp370_);
					_tmp372_ = _tmp371_;
					vala_report_error (_tmp367_, _tmp372_);
					_g_free0 (_tmp372_);
				}
			}
			_vala_code_node_unref0 (ma);
		}
		_tmp373_ = m;
		if (_tmp373_ != NULL) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp374_;
			ValaExpression* _tmp375_;
			ValaMemberAccess* _tmp376_;
			gint n_type_params = 0;
			ValaMethod* _tmp377_;
			ValaList* _tmp378_;
			ValaList* _tmp379_;
			gint _tmp380_;
			gint _tmp381_;
			gint _tmp382_;
			gint n_type_args = 0;
			ValaMemberAccess* _tmp383_;
			ValaList* _tmp384_;
			ValaList* _tmp385_;
			gint _tmp386_;
			gint _tmp387_;
			gint _tmp388_;
			gboolean _tmp389_ = FALSE;
			_tmp374_ = vala_method_call_get_call (self);
			_tmp375_ = _tmp374_;
			_tmp376_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp375_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp376_;
			_tmp377_ = m;
			_tmp378_ = vala_method_get_type_parameters (_tmp377_);
			_tmp379_ = _tmp378_;
			_tmp380_ = vala_collection_get_size ((ValaCollection*) _tmp379_);
			_tmp381_ = _tmp380_;
			_tmp382_ = _tmp381_;
			_vala_iterable_unref0 (_tmp379_);
			n_type_params = _tmp382_;
			_tmp383_ = ma;
			_tmp384_ = vala_member_access_get_type_arguments (_tmp383_);
			_tmp385_ = _tmp384_;
			_tmp386_ = vala_collection_get_size ((ValaCollection*) _tmp385_);
			_tmp387_ = _tmp386_;
			_tmp388_ = _tmp387_;
			_vala_iterable_unref0 (_tmp385_);
			n_type_args = _tmp388_;
			if (n_type_args > 0) {
				_tmp389_ = n_type_args < n_type_params;
			} else {
				_tmp389_ = FALSE;
			}
			if (_tmp389_) {
				ValaMemberAccess* _tmp390_;
				ValaSourceReference* _tmp391_;
				ValaSourceReference* _tmp392_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp390_ = ma;
				_tmp391_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp390_);
				_tmp392_ = _tmp391_;
				vala_report_error (_tmp392_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (ma);
				_vala_code_node_unref0 (m);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				gboolean _tmp393_ = FALSE;
				if (n_type_args > 0) {
					_tmp393_ = n_type_args > n_type_params;
				} else {
					_tmp393_ = FALSE;
				}
				if (_tmp393_) {
					ValaMemberAccess* _tmp394_;
					ValaSourceReference* _tmp395_;
					ValaSourceReference* _tmp396_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp394_ = ma;
					_tmp395_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp394_);
					_tmp396_ = _tmp395_;
					vala_report_error (_tmp396_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (params);
					_vala_code_node_unref0 (ret_type);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
			_vala_code_node_unref0 (ma);
		}
		_vala_code_node_unref0 (m);
	}
	last_arg = NULL;
	_tmp397_ = vala_method_call_get_argument_list (self);
	args = _tmp397_;
	_tmp398_ = args;
	_tmp399_ = vala_iterable_iterator ((ValaIterable*) _tmp398_);
	arg_it = _tmp399_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp400_;
		ValaList* _tmp401_;
		gint _param_size = 0;
		ValaList* _tmp402_;
		gint _tmp403_;
		gint _tmp404_;
		gint _param_index = 0;
		_tmp400_ = params;
		_tmp401_ = _vala_iterable_ref0 (_tmp400_);
		_param_list = _tmp401_;
		_tmp402_ = _param_list;
		_tmp403_ = vala_collection_get_size ((ValaCollection*) _tmp402_);
		_tmp404_ = _tmp403_;
		_param_size = _tmp404_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp405_;
			gpointer _tmp406_;
			ValaParameter* _tmp407_;
			ValaParameter* _tmp408_;
			gboolean _tmp409_;
			gboolean _tmp410_;
			ValaParameter* _tmp411_;
			gboolean _tmp412_;
			gboolean _tmp413_;
			ValaIterator* _tmp431_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp405_ = _param_list;
			_tmp406_ = vala_list_get (_tmp405_, _param_index);
			param = (ValaParameter*) _tmp406_;
			_tmp407_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp407_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp408_ = param;
			_tmp409_ = vala_parameter_get_ellipsis (_tmp408_);
			_tmp410_ = _tmp409_;
			if (_tmp410_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp411_ = param;
			_tmp412_ = vala_parameter_get_params_array (_tmp411_);
			_tmp413_ = _tmp412_;
			if (_tmp413_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp414_;
				ValaDataType* _tmp415_;
				ValaDataType* _tmp416_;
				ValaArrayType* _tmp417_;
				_tmp414_ = param;
				_tmp415_ = vala_variable_get_variable_type ((ValaVariable*) _tmp414_);
				_tmp416_ = _tmp415_;
				_tmp417_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp416_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp417_;
				while (TRUE) {
					ValaIterator* _tmp418_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp419_;
					gpointer _tmp420_;
					ValaExpression* _tmp421_;
					ValaArrayType* _tmp422_;
					ValaDataType* _tmp423_;
					ValaDataType* _tmp424_;
					ValaExpression* _tmp425_;
					ValaDataType* _tmp426_;
					ValaDataType* _tmp427_;
					ValaArrayType* _tmp428_;
					gboolean _tmp429_;
					gboolean _tmp430_;
					_tmp418_ = arg_it;
					if (!vala_iterator_next (_tmp418_)) {
						break;
					}
					_tmp419_ = arg_it;
					_tmp420_ = vala_iterator_get (_tmp419_);
					arg = (ValaExpression*) _tmp420_;
					_tmp421_ = arg;
					_tmp422_ = array_type;
					_tmp423_ = vala_array_type_get_element_type (_tmp422_);
					_tmp424_ = _tmp423_;
					vala_expression_set_target_type (_tmp421_, _tmp424_);
					_tmp425_ = arg;
					_tmp426_ = vala_expression_get_target_type (_tmp425_);
					_tmp427_ = _tmp426_;
					_tmp428_ = array_type;
					_tmp429_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp428_);
					_tmp430_ = _tmp429_;
					vala_data_type_set_value_owned (_tmp427_, _tmp430_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp431_ = arg_it;
			if (vala_iterator_next (_tmp431_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp432_;
				gpointer _tmp433_;
				ValaExpression* _tmp434_;
				ValaParameter* _tmp435_;
				ValaDataType* _tmp436_;
				ValaDataType* _tmp437_;
				ValaExpression* _tmp438_;
				ValaExpression* _tmp439_;
				ValaDataType* _tmp440_;
				ValaDataType* _tmp441_;
				ValaDataType* _tmp442_;
				ValaList* _tmp443_;
				ValaDataType* _tmp444_;
				ValaDataType* _tmp445_;
				ValaExpression* _tmp446_;
				ValaExpression* _tmp447_;
				_tmp432_ = arg_it;
				_tmp433_ = vala_iterator_get (_tmp432_);
				arg = (ValaExpression*) _tmp433_;
				_tmp434_ = arg;
				_tmp435_ = param;
				_tmp436_ = vala_variable_get_variable_type ((ValaVariable*) _tmp435_);
				_tmp437_ = _tmp436_;
				vala_expression_set_formal_target_type (_tmp434_, _tmp437_);
				_tmp438_ = arg;
				_tmp439_ = arg;
				_tmp440_ = vala_expression_get_formal_target_type (_tmp439_);
				_tmp441_ = _tmp440_;
				_tmp442_ = target_object_type;
				_tmp443_ = method_type_args;
				_tmp444_ = vala_data_type_get_actual_type (_tmp441_, _tmp442_, _tmp443_, (ValaCodeNode*) self);
				_tmp445_ = _tmp444_;
				vala_expression_set_target_type (_tmp438_, _tmp445_);
				_vala_code_node_unref0 (_tmp445_);
				_tmp446_ = arg;
				_tmp447_ = _vala_code_node_ref0 (_tmp446_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp447_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp449_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp449_, VALA_TYPE_METHOD_TYPE)) {
		ValaDataType* _tmp450_;
		ValaMethod* _tmp451_;
		ValaMethod* _tmp452_;
		ValaAttribute* _tmp453_;
		_tmp450_ = mtype;
		_tmp451_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp450_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp452_ = _tmp451_;
		_tmp453_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp452_, "Print");
		_tmp448_ = _tmp453_ != NULL;
	} else {
		_tmp448_ = FALSE;
	}
	if (_tmp448_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp454_;
		ValaSourceReference* _tmp455_;
		ValaTemplate* _tmp456_;
		ValaList* _tmp467_;
		ValaTemplate* _tmp468_;
		_tmp454_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp455_ = _tmp454_;
		_tmp456_ = vala_template_new (_tmp455_);
		template = _tmp456_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp457_;
			ValaList* _tmp458_;
			gint _arg_size = 0;
			ValaList* _tmp459_;
			gint _tmp460_;
			gint _tmp461_;
			gint _arg_index = 0;
			_tmp457_ = self->priv->argument_list;
			_tmp458_ = _vala_iterable_ref0 (_tmp457_);
			_arg_list = _tmp458_;
			_tmp459_ = _arg_list;
			_tmp460_ = vala_collection_get_size ((ValaCollection*) _tmp459_);
			_tmp461_ = _tmp460_;
			_arg_size = _tmp461_;
			_arg_index = -1;
			while (TRUE) {
				ValaExpression* arg = NULL;
				ValaList* _tmp462_;
				gpointer _tmp463_;
				ValaExpression* _tmp464_;
				ValaTemplate* _tmp465_;
				ValaExpression* _tmp466_;
				_arg_index = _arg_index + 1;
				if (!(_arg_index < _arg_size)) {
					break;
				}
				_tmp462_ = _arg_list;
				_tmp463_ = vala_list_get (_tmp462_, _arg_index);
				arg = (ValaExpression*) _tmp463_;
				_tmp464_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp464_, NULL);
				_tmp465_ = template;
				_tmp466_ = arg;
				vala_template_add_expression (_tmp465_, _tmp466_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp467_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp467_);
		_tmp468_ = template;
		vala_method_call_add_argument (self, (ValaExpression*) _tmp468_);
		_vala_code_node_unref0 (template);
	}
	_tmp470_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp470_, VALA_TYPE_METHOD_TYPE)) {
		ValaDataType* _tmp471_;
		ValaMethod* _tmp472_;
		ValaMethod* _tmp473_;
		gboolean _tmp474_;
		gboolean _tmp475_;
		_tmp471_ = mtype;
		_tmp472_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp471_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp473_ = _tmp472_;
		_tmp474_ = vala_method_get_printf_format (_tmp473_);
		_tmp475_ = _tmp474_;
		_tmp469_ = _tmp475_;
	} else {
		_tmp469_ = FALSE;
	}
	if (_tmp469_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp476_;
		ValaStringLiteral* _tmp521_;
		format_literal = NULL;
		_tmp476_ = last_arg;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp476_, VALA_TYPE_NULL_LITERAL)) {
		} else {
			ValaExpression* _tmp477_;
			_tmp477_ = last_arg;
			if (_tmp477_ != NULL) {
				ValaExpression* _tmp478_;
				ValaStringLiteral* _tmp479_;
				gboolean _tmp480_ = FALSE;
				ValaStringLiteral* _tmp481_;
				_tmp478_ = last_arg;
				_tmp479_ = vala_string_literal_get_format_literal (_tmp478_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp479_;
				_tmp481_ = format_literal;
				if (_tmp481_ == NULL) {
					ValaList* _tmp482_;
					gint _tmp483_;
					gint _tmp484_;
					ValaList* _tmp485_;
					gint _tmp486_;
					gint _tmp487_;
					_tmp482_ = args;
					_tmp483_ = vala_collection_get_size ((ValaCollection*) _tmp482_);
					_tmp484_ = _tmp483_;
					_tmp485_ = params;
					_tmp486_ = vala_collection_get_size ((ValaCollection*) _tmp485_);
					_tmp487_ = _tmp486_;
					_tmp480_ = _tmp484_ == (_tmp487_ - 1);
				} else {
					_tmp480_ = FALSE;
				}
				if (_tmp480_) {
					ValaStringLiteral* _tmp488_;
					ValaStringLiteral* _tmp489_;
					ValaSemanticAnalyzer* _tmp490_;
					ValaSemanticAnalyzer* _tmp491_;
					ValaDataType* _tmp492_;
					ValaDataType* _tmp493_;
					ValaDataType* _tmp494_;
					ValaList* _tmp495_;
					ValaList* _tmp496_;
					gint _tmp497_;
					gint _tmp498_;
					ValaStringLiteral* _tmp499_;
					ValaList* _tmp500_;
					ValaIterator* _tmp501_;
					_tmp488_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp488_;
					_tmp489_ = format_literal;
					_tmp490_ = vala_code_context_get_analyzer (context);
					_tmp491_ = _tmp490_;
					_tmp492_ = _tmp491_->string_type;
					_tmp493_ = vala_data_type_copy (_tmp492_);
					_tmp494_ = _tmp493_;
					vala_expression_set_target_type ((ValaExpression*) _tmp489_, _tmp494_);
					_vala_code_node_unref0 (_tmp494_);
					_tmp495_ = self->priv->argument_list;
					_tmp496_ = args;
					_tmp497_ = vala_collection_get_size ((ValaCollection*) _tmp496_);
					_tmp498_ = _tmp497_;
					_tmp499_ = format_literal;
					vala_list_insert (_tmp495_, _tmp498_ - 1, (ValaExpression*) _tmp499_);
					_tmp500_ = self->priv->argument_list;
					_tmp501_ = vala_iterable_iterator ((ValaIterable*) _tmp500_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp501_;
					{
						ValaList* _param_list = NULL;
						ValaList* _tmp502_;
						ValaList* _tmp503_;
						gint _param_size = 0;
						ValaList* _tmp504_;
						gint _tmp505_;
						gint _tmp506_;
						gint _param_index = 0;
						_tmp502_ = params;
						_tmp503_ = _vala_iterable_ref0 (_tmp502_);
						_param_list = _tmp503_;
						_tmp504_ = _param_list;
						_tmp505_ = vala_collection_get_size ((ValaCollection*) _tmp504_);
						_tmp506_ = _tmp505_;
						_param_size = _tmp506_;
						_param_index = -1;
						while (TRUE) {
							ValaParameter* param = NULL;
							ValaList* _tmp507_;
							gpointer _tmp508_;
							ValaParameter* _tmp509_;
							gboolean _tmp510_;
							gboolean _tmp511_;
							ValaIterator* _tmp512_;
							_param_index = _param_index + 1;
							if (!(_param_index < _param_size)) {
								break;
							}
							_tmp507_ = _param_list;
							_tmp508_ = vala_list_get (_tmp507_, _param_index);
							param = (ValaParameter*) _tmp508_;
							_tmp509_ = param;
							_tmp510_ = vala_parameter_get_ellipsis (_tmp509_);
							_tmp511_ = _tmp510_;
							if (_tmp511_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp512_ = arg_it;
							vala_iterator_next (_tmp512_);
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
				}
			} else {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp513_;
				ValaExpression* _tmp514_;
				ValaMemberAccess* _tmp515_;
				ValaMemberAccess* _tmp516_;
				_tmp513_ = vala_method_call_get_call (self);
				_tmp514_ = _tmp513_;
				_tmp515_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp514_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp514_) : NULL);
				ma = _tmp515_;
				_tmp516_ = ma;
				if (_tmp516_ != NULL) {
					ValaMemberAccess* _tmp517_;
					ValaExpression* _tmp518_;
					ValaExpression* _tmp519_;
					ValaStringLiteral* _tmp520_;
					_tmp517_ = ma;
					_tmp518_ = vala_member_access_get_inner (_tmp517_);
					_tmp519_ = _tmp518_;
					_tmp520_ = vala_string_literal_get_format_literal (_tmp519_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp520_;
				}
				_vala_code_node_unref0 (ma);
			}
		}
		_tmp521_ = format_literal;
		if (_tmp521_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp522_;
			gchar* _tmp523_;
			ValaSemanticAnalyzer* _tmp524_;
			ValaSemanticAnalyzer* _tmp525_;
			const gchar* _tmp526_;
			ValaIterator* _tmp527_;
			ValaSourceReference* _tmp528_;
			ValaSourceReference* _tmp529_;
			_tmp522_ = format_literal;
			_tmp523_ = vala_string_literal_eval (_tmp522_);
			format = _tmp523_;
			_tmp524_ = vala_code_context_get_analyzer (context);
			_tmp525_ = _tmp524_;
			_tmp526_ = format;
			_tmp527_ = arg_it;
			_tmp528_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp529_ = _tmp528_;
			if (!vala_semantic_analyzer_check_print_format (_tmp525_, _tmp526_, _tmp527_, _tmp529_)) {
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_iterable_unref0 (args);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	force_lambda_method_closure = FALSE;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp530_;
		gint _arg_size = 0;
		ValaList* _tmp531_;
		gint _tmp532_;
		gint _tmp533_;
		gint _arg_index = 0;
		_tmp530_ = vala_method_call_get_argument_list (self);
		_arg_list = _tmp530_;
		_tmp531_ = _arg_list;
		_tmp532_ = vala_collection_get_size ((ValaCollection*) _tmp531_);
		_tmp533_ = _tmp532_;
		_arg_size = _tmp533_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp534_;
			gpointer _tmp535_;
			ValaExpression* _tmp536_;
			gboolean _tmp537_ = FALSE;
			ValaExpression* _tmp538_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp534_ = _arg_list;
			_tmp535_ = vala_list_get (_tmp534_, _arg_index);
			arg = (ValaExpression*) _tmp535_;
			_tmp536_ = arg;
			vala_code_node_check ((ValaCodeNode*) _tmp536_, context);
			_tmp538_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp538_, VALA_TYPE_LAMBDA_EXPRESSION)) {
				ValaExpression* _tmp539_;
				ValaMethod* _tmp540_;
				ValaMethod* _tmp541_;
				gboolean _tmp542_;
				gboolean _tmp543_;
				_tmp539_ = arg;
				_tmp540_ = vala_lambda_expression_get_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp539_, VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression));
				_tmp541_ = _tmp540_;
				_tmp542_ = vala_method_get_closure (_tmp541_);
				_tmp543_ = _tmp542_;
				_tmp537_ = _tmp543_;
			} else {
				_tmp537_ = FALSE;
			}
			if (_tmp537_) {
				force_lambda_method_closure = TRUE;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	if (force_lambda_method_closure) {
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp544_;
			gint _arg_size = 0;
			ValaList* _tmp545_;
			gint _tmp546_;
			gint _tmp547_;
			gint _arg_index = 0;
			_tmp544_ = vala_method_call_get_argument_list (self);
			_arg_list = _tmp544_;
			_tmp545_ = _arg_list;
			_tmp546_ = vala_collection_get_size ((ValaCollection*) _tmp545_);
			_tmp547_ = _tmp546_;
			_arg_size = _tmp547_;
			_arg_index = -1;
			while (TRUE) {
				ValaExpression* arg = NULL;
				ValaList* _tmp548_;
				gpointer _tmp549_;
				ValaExpression* _tmp550_;
				_arg_index = _arg_index + 1;
				if (!(_arg_index < _arg_size)) {
					break;
				}
				_tmp548_ = _arg_list;
				_tmp549_ = vala_list_get (_tmp548_, _arg_index);
				arg = (ValaExpression*) _tmp549_;
				_tmp550_ = arg;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp550_, VALA_TYPE_LAMBDA_EXPRESSION)) {
					ValaExpression* _tmp551_;
					ValaMethod* _tmp552_;
					ValaMethod* _tmp553_;
					_tmp551_ = arg;
					_tmp552_ = vala_lambda_expression_get_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp551_, VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression));
					_tmp553_ = _tmp552_;
					vala_method_set_closure (_tmp553_, TRUE);
				}
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
	}
	_tmp554_ = ret_type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp554_, VALA_TYPE_VOID_TYPE)) {
		gboolean _tmp555_ = FALSE;
		gboolean _tmp556_ = FALSE;
		ValaCodeNode* _tmp557_;
		ValaCodeNode* _tmp558_;
		_tmp557_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp558_ = _tmp557_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp558_, VALA_TYPE_EXPRESSION_STATEMENT)) {
			ValaCodeNode* _tmp559_;
			ValaCodeNode* _tmp560_;
			_tmp559_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp560_ = _tmp559_;
			_tmp556_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp560_, VALA_TYPE_FOR_STATEMENT);
		} else {
			_tmp556_ = FALSE;
		}
		if (_tmp556_) {
			ValaCodeNode* _tmp561_;
			ValaCodeNode* _tmp562_;
			_tmp561_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp562_ = _tmp561_;
			_tmp555_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp562_, VALA_TYPE_YIELD_STATEMENT);
		} else {
			_tmp555_ = FALSE;
		}
		if (_tmp555_) {
			ValaSourceReference* _tmp563_;
			ValaSourceReference* _tmp564_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp563_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp564_ = _tmp563_;
			vala_report_error (_tmp564_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_iterable_unref0 (args);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp565_ = ret_type;
	_tmp566_ = vala_data_type_copy (_tmp565_);
	_tmp567_ = _tmp566_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp567_);
	_vala_code_node_unref0 (_tmp567_);
	_tmp568_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp569_ = _tmp568_;
	_tmp570_ = target_object_type;
	_tmp571_ = method_type_args;
	_tmp572_ = vala_data_type_get_actual_type (_tmp569_, _tmp570_, _tmp571_, (ValaCodeNode*) self);
	_tmp573_ = _tmp572_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp573_);
	_vala_code_node_unref0 (_tmp573_);
	_tmp574_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp574_, VALA_TYPE_METHOD_TYPE)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp575_;
		ValaMethod* _tmp576_;
		ValaMethod* _tmp577_;
		ValaMethod* _tmp578_;
		gboolean _tmp579_;
		ValaMethod* _tmp598_;
		gboolean _tmp599_;
		gboolean _tmp600_;
		ValaMethod* _tmp603_;
		gboolean _tmp604_;
		gboolean _tmp605_;
		gboolean _tmp610_ = FALSE;
		gboolean _tmp611_ = FALSE;
		gboolean _tmp612_ = FALSE;
		gboolean _tmp613_;
		gboolean _tmp614_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp626_;
		ValaSymbol* _tmp627_;
		ValaSymbol* _tmp628_;
		ValaDynamicSignal* _tmp629_;
		gboolean _tmp630_ = FALSE;
		ValaDynamicSignal* _tmp631_;
		gboolean _tmp673_ = FALSE;
		ValaMethod* _tmp674_;
		gboolean _tmp783_ = FALSE;
		ValaMethod* _tmp784_;
		_tmp575_ = mtype;
		_tmp576_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp575_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp577_ = _tmp576_;
		_tmp578_ = _vala_code_node_ref0 (_tmp577_);
		m = _tmp578_;
		_tmp579_ = self->priv->_is_yield_expression;
		if (_tmp579_) {
			ValaMethod* _tmp580_;
			gboolean _tmp581_;
			gboolean _tmp582_;
			gboolean _tmp585_ = FALSE;
			ValaSemanticAnalyzer* _tmp586_;
			ValaSemanticAnalyzer* _tmp587_;
			ValaMethod* _tmp588_;
			ValaMethod* _tmp589_;
			_tmp580_ = m;
			_tmp581_ = vala_method_get_coroutine (_tmp580_);
			_tmp582_ = _tmp581_;
			if (!_tmp582_) {
				ValaSourceReference* _tmp583_;
				ValaSourceReference* _tmp584_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp583_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp584_ = _tmp583_;
				vala_report_error (_tmp584_, "yield expression requires async method");
			}
			_tmp586_ = vala_code_context_get_analyzer (context);
			_tmp587_ = _tmp586_;
			_tmp588_ = vala_semantic_analyzer_get_current_method (_tmp587_);
			_tmp589_ = _tmp588_;
			if (_tmp589_ == NULL) {
				_tmp585_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp590_;
				ValaSemanticAnalyzer* _tmp591_;
				ValaMethod* _tmp592_;
				ValaMethod* _tmp593_;
				gboolean _tmp594_;
				gboolean _tmp595_;
				_tmp590_ = vala_code_context_get_analyzer (context);
				_tmp591_ = _tmp590_;
				_tmp592_ = vala_semantic_analyzer_get_current_method (_tmp591_);
				_tmp593_ = _tmp592_;
				_tmp594_ = vala_method_get_coroutine (_tmp593_);
				_tmp595_ = _tmp594_;
				_tmp585_ = !_tmp595_;
			}
			if (_tmp585_) {
				ValaSourceReference* _tmp596_;
				ValaSourceReference* _tmp597_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp596_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp597_ = _tmp596_;
				vala_report_error (_tmp597_, "yield expression not available outside async method");
			}
		}
		_tmp598_ = m;
		_tmp599_ = vala_method_get_returns_floating_reference (_tmp598_);
		_tmp600_ = _tmp599_;
		if (_tmp600_) {
			ValaDataType* _tmp601_;
			ValaDataType* _tmp602_;
			_tmp601_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp602_ = _tmp601_;
			vala_data_type_set_floating_reference (_tmp602_, TRUE);
		}
		_tmp603_ = m;
		_tmp604_ = vala_method_get_returns_modified_pointer (_tmp603_);
		_tmp605_ = _tmp604_;
		if (_tmp605_) {
			ValaExpression* _tmp606_;
			ValaExpression* _tmp607_;
			ValaExpression* _tmp608_;
			ValaExpression* _tmp609_;
			_tmp606_ = vala_method_call_get_call (self);
			_tmp607_ = _tmp606_;
			_tmp608_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp607_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp609_ = _tmp608_;
			vala_expression_set_lvalue (_tmp609_, TRUE);
		}
		_tmp613_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp614_ = _tmp613_;
		if (_tmp614_) {
			ValaDataType* _tmp615_;
			ValaDataType* _tmp616_;
			gboolean _tmp617_;
			gboolean _tmp618_;
			_tmp615_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp616_ = _tmp615_;
			_tmp617_ = vala_data_type_get_nullable (_tmp616_);
			_tmp618_ = _tmp617_;
			_tmp612_ = !_tmp618_;
		} else {
			_tmp612_ = FALSE;
		}
		if (_tmp612_) {
			ValaDataType* _tmp619_;
			ValaDataType* _tmp620_;
			gboolean _tmp621_;
			gboolean _tmp622_;
			_tmp619_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp620_ = _tmp619_;
			_tmp621_ = vala_data_type_get_floating_reference (_tmp620_);
			_tmp622_ = _tmp621_;
			_tmp611_ = _tmp622_;
		} else {
			_tmp611_ = FALSE;
		}
		if (_tmp611_) {
			ValaDataType* _tmp623_;
			_tmp623_ = ret_type;
			_tmp610_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp623_, VALA_TYPE_OBJECT_TYPE);
		} else {
			_tmp610_ = FALSE;
		}
		if (_tmp610_) {
			ValaDataType* _tmp624_;
			ValaDataType* _tmp625_;
			_tmp624_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp625_ = _tmp624_;
			vala_data_type_set_nullable (_tmp625_, TRUE);
		}
		_tmp626_ = m;
		_tmp627_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp626_);
		_tmp628_ = _tmp627_;
		_tmp629_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp628_, VALA_TYPE_DYNAMIC_SIGNAL) ? ((ValaDynamicSignal*) _tmp628_) : NULL);
		dynamic_sig = _tmp629_;
		_tmp631_ = dynamic_sig;
		if (_tmp631_ != NULL) {
			ValaDynamicSignal* _tmp632_;
			ValaExpression* _tmp633_;
			ValaExpression* _tmp634_;
			_tmp632_ = dynamic_sig;
			_tmp633_ = vala_dynamic_signal_get_handler (_tmp632_);
			_tmp634_ = _tmp633_;
			_tmp630_ = _tmp634_ != NULL;
		} else {
			_tmp630_ = FALSE;
		}
		if (_tmp630_) {
			ValaDynamicSignal* _tmp635_;
			ValaDynamicSignal* _tmp636_;
			ValaExpression* _tmp637_;
			ValaExpression* _tmp638_;
			ValaDataType* _tmp639_;
			ValaDataType* _tmp640_;
			ValaDataType* _tmp641_;
			ValaDataType* _tmp642_;
			ValaDataType* _tmp643_;
			ValaDataType* _tmp644_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp660_;
			ValaExpression* _tmp661_;
			ValaExpression* _tmp662_;
			ValaDynamicSignal* _tmp663_;
			ValaDynamicSignal* _tmp664_;
			ValaSymbol* _tmp665_;
			ValaSymbol* _tmp666_;
			ValaObjectType* _tmp667_;
			ValaObjectType* _tmp668_;
			ValaDelegate* _tmp669_;
			ValaDelegate* _tmp670_;
			ValaDelegateType* _tmp671_;
			ValaDelegateType* _tmp672_;
			_tmp635_ = dynamic_sig;
			_tmp636_ = dynamic_sig;
			_tmp637_ = vala_dynamic_signal_get_handler (_tmp636_);
			_tmp638_ = _tmp637_;
			_tmp639_ = vala_expression_get_value_type (_tmp638_);
			_tmp640_ = _tmp639_;
			_tmp641_ = vala_data_type_get_return_type (_tmp640_);
			_tmp642_ = _tmp641_;
			_tmp643_ = vala_data_type_copy (_tmp642_);
			_tmp644_ = _tmp643_;
			vala_callable_set_return_type ((ValaCallable*) _tmp635_, _tmp644_);
			_vala_code_node_unref0 (_tmp644_);
			_vala_code_node_unref0 (_tmp642_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp645_;
				ValaExpression* _tmp646_;
				ValaExpression* _tmp647_;
				ValaDataType* _tmp648_;
				ValaDataType* _tmp649_;
				ValaList* _tmp650_;
				gint _param_size = 0;
				ValaList* _tmp651_;
				gint _tmp652_;
				gint _tmp653_;
				gint _param_index = 0;
				_tmp645_ = dynamic_sig;
				_tmp646_ = vala_dynamic_signal_get_handler (_tmp645_);
				_tmp647_ = _tmp646_;
				_tmp648_ = vala_expression_get_value_type (_tmp647_);
				_tmp649_ = _tmp648_;
				_tmp650_ = vala_data_type_get_parameters (_tmp649_);
				_param_list = _tmp650_;
				_tmp651_ = _param_list;
				_tmp652_ = vala_collection_get_size ((ValaCollection*) _tmp651_);
				_tmp653_ = _tmp652_;
				_param_size = _tmp653_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp654_;
					gpointer _tmp655_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp654_ = _param_list;
					_tmp655_ = vala_list_get (_tmp654_, _param_index);
					param = (ValaParameter*) _tmp655_;
					if (first) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp656_;
						ValaParameter* _tmp657_;
						ValaParameter* _tmp658_;
						ValaParameter* _tmp659_;
						_tmp656_ = dynamic_sig;
						_tmp657_ = param;
						_tmp658_ = vala_parameter_copy (_tmp657_);
						_tmp659_ = _tmp658_;
						vala_callable_add_parameter ((ValaCallable*) _tmp656_, _tmp659_);
						_vala_code_node_unref0 (_tmp659_);
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp660_ = dynamic_sig;
			_tmp661_ = vala_dynamic_signal_get_handler (_tmp660_);
			_tmp662_ = _tmp661_;
			_tmp663_ = dynamic_sig;
			_tmp664_ = dynamic_sig;
			_tmp665_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp664_);
			_tmp666_ = _tmp665_;
			_tmp667_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp666_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp668_ = _tmp667_;
			_tmp669_ = vala_signal_get_delegate ((ValaSignal*) _tmp663_, (ValaDataType*) _tmp668_, (ValaCodeNode*) self);
			_tmp670_ = _tmp669_;
			_tmp671_ = vala_delegate_type_new (_tmp670_);
			_tmp672_ = _tmp671_;
			vala_expression_set_target_type (_tmp662_, (ValaDataType*) _tmp672_);
			_vala_code_node_unref0 (_tmp672_);
			_vala_code_node_unref0 (_tmp670_);
			_vala_code_node_unref0 (_tmp668_);
		}
		_tmp674_ = m;
		if (_tmp674_ != NULL) {
			ValaMethod* _tmp675_;
			_tmp675_ = m;
			_tmp673_ = vala_method_has_type_parameters (_tmp675_);
		} else {
			_tmp673_ = FALSE;
		}
		if (_tmp673_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp676_;
			ValaExpression* _tmp677_;
			ValaMemberAccess* _tmp678_;
			ValaMemberAccess* _tmp679_;
			ValaList* _tmp680_;
			ValaList* _tmp681_;
			gint _tmp682_;
			gint _tmp683_;
			gboolean _tmp684_;
			_tmp676_ = vala_method_call_get_call (self);
			_tmp677_ = _tmp676_;
			_tmp678_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp677_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp678_;
			_tmp679_ = ma;
			_tmp680_ = vala_member_access_get_type_arguments (_tmp679_);
			_tmp681_ = _tmp680_;
			_tmp682_ = vala_collection_get_size ((ValaCollection*) _tmp681_);
			_tmp683_ = _tmp682_;
			_tmp684_ = _tmp683_ == 0;
			_vala_iterable_unref0 (_tmp681_);
			if (_tmp684_) {
				ValaList* _tmp750_;
				ValaIterator* _tmp751_;
				ValaDataType* _tmp777_;
				ValaDataType* _tmp778_;
				ValaDataType* _tmp779_;
				ValaList* _tmp780_;
				ValaDataType* _tmp781_;
				ValaDataType* _tmp782_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp685_;
					ValaList* _tmp686_;
					gint _type_param_size = 0;
					ValaList* _tmp687_;
					gint _tmp688_;
					gint _tmp689_;
					gint _type_param_index = 0;
					_tmp685_ = m;
					_tmp686_ = vala_method_get_type_parameters (_tmp685_);
					_type_param_list = _tmp686_;
					_tmp687_ = _type_param_list;
					_tmp688_ = vala_collection_get_size ((ValaCollection*) _tmp687_);
					_tmp689_ = _tmp688_;
					_type_param_size = _tmp689_;
					_type_param_index = -1;
					while (TRUE) {
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp690_;
						gpointer _tmp691_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp692_;
						ValaIterator* _tmp693_;
						gboolean _tmp728_ = FALSE;
						ValaDataType* _tmp729_;
						ValaDataType* _tmp739_;
						ValaMemberAccess* _tmp748_;
						ValaDataType* _tmp749_;
						_type_param_index = _type_param_index + 1;
						if (!(_type_param_index < _type_param_size)) {
							break;
						}
						_tmp690_ = _type_param_list;
						_tmp691_ = vala_list_get (_tmp690_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp691_;
						type_arg = NULL;
						_tmp692_ = args;
						_tmp693_ = vala_iterable_iterator ((ValaIterable*) _tmp692_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp693_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp694_;
							ValaList* _tmp695_;
							gint _param_size = 0;
							ValaList* _tmp696_;
							gint _tmp697_;
							gint _tmp698_;
							gint _param_index = 0;
							_tmp694_ = params;
							_tmp695_ = _vala_iterable_ref0 (_tmp694_);
							_param_list = _tmp695_;
							_tmp696_ = _param_list;
							_tmp697_ = vala_collection_get_size ((ValaCollection*) _tmp696_);
							_tmp698_ = _tmp697_;
							_param_size = _tmp698_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp699_;
								gpointer _tmp700_;
								gboolean _tmp701_ = FALSE;
								ValaParameter* _tmp702_;
								gboolean _tmp703_;
								gboolean _tmp704_;
								ValaIterator* _tmp708_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp699_ = _param_list;
								_tmp700_ = vala_list_get (_tmp699_, _param_index);
								param = (ValaParameter*) _tmp700_;
								_tmp702_ = param;
								_tmp703_ = vala_parameter_get_ellipsis (_tmp702_);
								_tmp704_ = _tmp703_;
								if (_tmp704_) {
									_tmp701_ = TRUE;
								} else {
									ValaParameter* _tmp705_;
									gboolean _tmp706_;
									gboolean _tmp707_;
									_tmp705_ = param;
									_tmp706_ = vala_parameter_get_params_array (_tmp705_);
									_tmp707_ = _tmp706_;
									_tmp701_ = _tmp707_;
								}
								if (_tmp701_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp708_ = arg_it;
								if (vala_iterator_next (_tmp708_)) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp709_;
									gpointer _tmp710_;
									ValaParameter* _tmp711_;
									ValaDataType* _tmp712_;
									ValaDataType* _tmp713_;
									ValaTypeParameter* _tmp714_;
									ValaExpression* _tmp715_;
									ValaDataType* _tmp716_;
									ValaDataType* _tmp717_;
									ValaDataType* _tmp718_;
									ValaDataType* _tmp719_;
									ValaExpression* _tmp720_;
									ValaExpression* _tmp721_;
									ValaDataType* _tmp722_;
									ValaDataType* _tmp723_;
									ValaDataType* _tmp724_;
									ValaList* _tmp725_;
									ValaDataType* _tmp726_;
									ValaDataType* _tmp727_;
									_tmp709_ = arg_it;
									_tmp710_ = vala_iterator_get (_tmp709_);
									arg = (ValaExpression*) _tmp710_;
									_tmp711_ = param;
									_tmp712_ = vala_variable_get_variable_type ((ValaVariable*) _tmp711_);
									_tmp713_ = _tmp712_;
									_tmp714_ = type_param;
									_tmp715_ = arg;
									_tmp716_ = vala_expression_get_value_type (_tmp715_);
									_tmp717_ = _tmp716_;
									_tmp718_ = vala_data_type_infer_type_argument (_tmp713_, _tmp714_, _tmp717_);
									_vala_code_node_unref0 (type_arg);
									type_arg = _tmp718_;
									_tmp719_ = type_arg;
									if (_tmp719_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp720_ = arg;
									_tmp721_ = arg;
									_tmp722_ = vala_expression_get_formal_target_type (_tmp721_);
									_tmp723_ = _tmp722_;
									_tmp724_ = target_object_type;
									_tmp725_ = method_type_args;
									_tmp726_ = vala_data_type_get_actual_type (_tmp723_, _tmp724_, _tmp725_, (ValaCodeNode*) self);
									_tmp727_ = _tmp726_;
									vala_expression_set_target_type (_tmp720_, _tmp727_);
									_vala_code_node_unref0 (_tmp727_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp729_ = type_arg;
						if (_tmp729_ == NULL) {
							ValaDataType* _tmp730_;
							ValaDataType* _tmp731_;
							_tmp730_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp731_ = _tmp730_;
							_tmp728_ = _tmp731_ != NULL;
						} else {
							_tmp728_ = FALSE;
						}
						if (_tmp728_) {
							ValaMethod* _tmp732_;
							ValaDataType* _tmp733_;
							ValaDataType* _tmp734_;
							ValaTypeParameter* _tmp735_;
							ValaDataType* _tmp736_;
							ValaDataType* _tmp737_;
							ValaDataType* _tmp738_;
							_tmp732_ = m;
							_tmp733_ = vala_callable_get_return_type ((ValaCallable*) _tmp732_);
							_tmp734_ = _tmp733_;
							_tmp735_ = type_param;
							_tmp736_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp737_ = _tmp736_;
							_tmp738_ = vala_data_type_infer_type_argument (_tmp734_, _tmp735_, _tmp737_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp738_;
						}
						_tmp739_ = type_arg;
						if (_tmp739_ == NULL) {
							ValaMemberAccess* _tmp740_;
							ValaSourceReference* _tmp741_;
							ValaSourceReference* _tmp742_;
							ValaTypeParameter* _tmp743_;
							gchar* _tmp744_;
							gchar* _tmp745_;
							gchar* _tmp746_;
							gchar* _tmp747_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp740_ = ma;
							_tmp741_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp740_);
							_tmp742_ = _tmp741_;
							_tmp743_ = type_param;
							_tmp744_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp743_);
							_tmp745_ = _tmp744_;
							_tmp746_ = g_strdup_printf ("cannot infer generic type argument for type parameter `%s'", _tmp745_);
							_tmp747_ = _tmp746_;
							vala_report_error (_tmp742_, _tmp747_);
							_g_free0 (_tmp747_);
							_g_free0 (_tmp745_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterable_unref0 (_type_param_list);
							_vala_code_node_unref0 (ma);
							_vala_code_node_unref0 (dynamic_sig);
							_vala_code_node_unref0 (m);
							_vala_iterator_unref0 (arg_it);
							_vala_iterable_unref0 (args);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (base_cm);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp748_ = ma;
						_tmp749_ = type_arg;
						vala_member_access_add_type_argument (_tmp748_, _tmp749_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_tmp750_ = args;
				_tmp751_ = vala_iterable_iterator ((ValaIterable*) _tmp750_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp751_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp752_;
					ValaList* _tmp753_;
					gint _param_size = 0;
					ValaList* _tmp754_;
					gint _tmp755_;
					gint _tmp756_;
					gint _param_index = 0;
					_tmp752_ = params;
					_tmp753_ = _vala_iterable_ref0 (_tmp752_);
					_param_list = _tmp753_;
					_tmp754_ = _param_list;
					_tmp755_ = vala_collection_get_size ((ValaCollection*) _tmp754_);
					_tmp756_ = _tmp755_;
					_param_size = _tmp756_;
					_param_index = -1;
					while (TRUE) {
						ValaParameter* param = NULL;
						ValaList* _tmp757_;
						gpointer _tmp758_;
						gboolean _tmp759_ = FALSE;
						ValaParameter* _tmp760_;
						gboolean _tmp761_;
						gboolean _tmp762_;
						ValaIterator* _tmp766_;
						_param_index = _param_index + 1;
						if (!(_param_index < _param_size)) {
							break;
						}
						_tmp757_ = _param_list;
						_tmp758_ = vala_list_get (_tmp757_, _param_index);
						param = (ValaParameter*) _tmp758_;
						_tmp760_ = param;
						_tmp761_ = vala_parameter_get_ellipsis (_tmp760_);
						_tmp762_ = _tmp761_;
						if (_tmp762_) {
							_tmp759_ = TRUE;
						} else {
							ValaParameter* _tmp763_;
							gboolean _tmp764_;
							gboolean _tmp765_;
							_tmp763_ = param;
							_tmp764_ = vala_parameter_get_params_array (_tmp763_);
							_tmp765_ = _tmp764_;
							_tmp759_ = _tmp765_;
						}
						if (_tmp759_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp766_ = arg_it;
						if (vala_iterator_next (_tmp766_)) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp767_;
							gpointer _tmp768_;
							ValaExpression* _tmp769_;
							ValaExpression* _tmp770_;
							ValaDataType* _tmp771_;
							ValaDataType* _tmp772_;
							ValaDataType* _tmp773_;
							ValaList* _tmp774_;
							ValaDataType* _tmp775_;
							ValaDataType* _tmp776_;
							_tmp767_ = arg_it;
							_tmp768_ = vala_iterator_get (_tmp767_);
							arg = (ValaExpression*) _tmp768_;
							_tmp769_ = arg;
							_tmp770_ = arg;
							_tmp771_ = vala_expression_get_formal_target_type (_tmp770_);
							_tmp772_ = _tmp771_;
							_tmp773_ = target_object_type;
							_tmp774_ = method_type_args;
							_tmp775_ = vala_data_type_get_actual_type (_tmp772_, _tmp773_, _tmp774_, (ValaCodeNode*) self);
							_tmp776_ = _tmp775_;
							vala_expression_set_target_type (_tmp769_, _tmp776_);
							_vala_code_node_unref0 (_tmp776_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
					_vala_iterable_unref0 (_param_list);
				}
				_tmp777_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp778_ = _tmp777_;
				_tmp779_ = target_object_type;
				_tmp780_ = method_type_args;
				_tmp781_ = vala_data_type_get_actual_type (_tmp778_, _tmp779_, _tmp780_, (ValaCodeNode*) self);
				_tmp782_ = _tmp781_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp782_);
				_vala_code_node_unref0 (_tmp782_);
			}
			_vala_code_node_unref0 (ma);
		}
		_tmp784_ = m;
		if (_tmp784_ != NULL) {
			ValaMethod* _tmp785_;
			gboolean _tmp786_;
			gboolean _tmp787_;
			_tmp785_ = m;
			_tmp786_ = vala_method_get_coroutine (_tmp785_);
			_tmp787_ = _tmp786_;
			_tmp783_ = _tmp787_;
		} else {
			_tmp783_ = FALSE;
		}
		if (_tmp783_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp788_;
			ValaExpression* _tmp789_;
			ValaMemberAccess* _tmp790_;
			ValaMemberAccess* _tmp791_;
			const gchar* _tmp792_;
			const gchar* _tmp793_;
			_tmp788_ = vala_method_call_get_call (self);
			_tmp789_ = _tmp788_;
			_tmp790_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp789_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp790_;
			_tmp791_ = ma;
			_tmp792_ = vala_member_access_get_member_name (_tmp791_);
			_tmp793_ = _tmp792_;
			if (g_strcmp0 (_tmp793_, "end") == 0) {
				ValaMethod* _tmp794_;
				ValaMethod* _tmp795_;
				ValaMethod* _tmp796_;
				ValaMethodType* _tmp797_;
				_tmp794_ = m;
				_tmp795_ = vala_method_get_end_method (_tmp794_);
				_tmp796_ = _tmp795_;
				_tmp797_ = vala_method_type_new (_tmp796_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp797_;
				_vala_code_node_unref0 (_tmp796_);
			}
			_vala_code_node_unref0 (ma);
		}
		_vala_code_node_unref0 (dynamic_sig);
		_vala_code_node_unref0 (m);
	}
	_tmp798_ = vala_code_context_get_analyzer (context);
	_tmp799_ = _tmp798_;
	_tmp800_ = mtype;
	_tmp801_ = params;
	_tmp802_ = vala_method_call_get_argument_list (self);
	_tmp803_ = _tmp802_;
	_tmp804_ = !vala_semantic_analyzer_check_arguments (_tmp799_, (ValaExpression*) self, _tmp800_, _tmp801_, _tmp803_);
	_vala_iterable_unref0 (_tmp803_);
	if (_tmp804_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_iterable_unref0 (args);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	_tmp807_ = base_cm;
	if (_tmp807_ != NULL) {
		ValaCreationMethod* _tmp808_;
		_tmp808_ = base_cm;
		_tmp806_ = vala_method_is_variadic ((ValaMethod*) _tmp808_);
	} else {
		_tmp806_ = FALSE;
	}
	if (_tmp806_) {
		ValaList* _tmp809_;
		gint _tmp810_;
		gint _tmp811_;
		ValaCreationMethod* _tmp812_;
		ValaList* _tmp813_;
		ValaList* _tmp814_;
		gint _tmp815_;
		gint _tmp816_;
		_tmp809_ = args;
		_tmp810_ = vala_collection_get_size ((ValaCollection*) _tmp809_);
		_tmp811_ = _tmp810_;
		_tmp812_ = base_cm;
		_tmp813_ = vala_callable_get_parameters ((ValaCallable*) _tmp812_);
		_tmp814_ = _tmp813_;
		_tmp815_ = vala_collection_get_size ((ValaCollection*) _tmp814_);
		_tmp816_ = _tmp815_;
		_tmp805_ = _tmp811_ == _tmp816_;
		_vala_iterable_unref0 (_tmp814_);
	} else {
		_tmp805_ = FALSE;
	}
	if (_tmp805_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp817_;
		ValaList* _tmp818_;
		gint _tmp819_;
		gint _tmp820_;
		gpointer _tmp821_;
		gboolean _tmp822_ = FALSE;
		ValaExpression* _tmp823_;
		ValaDataType* _tmp824_;
		ValaDataType* _tmp825_;
		_tmp817_ = args;
		_tmp818_ = args;
		_tmp819_ = vala_collection_get_size ((ValaCollection*) _tmp818_);
		_tmp820_ = _tmp819_;
		_tmp821_ = vala_list_get (_tmp817_, _tmp820_ - 1);
		this_last_arg = (ValaExpression*) _tmp821_;
		_tmp823_ = this_last_arg;
		_tmp824_ = vala_expression_get_value_type (_tmp823_);
		_tmp825_ = _tmp824_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp825_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
			ValaExpression* _tmp826_;
			ValaDataType* _tmp827_;
			ValaDataType* _tmp828_;
			ValaTypeSymbol* _tmp829_;
			ValaTypeSymbol* _tmp830_;
			ValaSemanticAnalyzer* _tmp831_;
			ValaSemanticAnalyzer* _tmp832_;
			ValaDataType* _tmp833_;
			ValaTypeSymbol* _tmp834_;
			ValaTypeSymbol* _tmp835_;
			_tmp826_ = this_last_arg;
			_tmp827_ = vala_expression_get_value_type (_tmp826_);
			_tmp828_ = _tmp827_;
			_tmp829_ = vala_data_type_get_data_type (_tmp828_);
			_tmp830_ = _tmp829_;
			_tmp831_ = vala_code_context_get_analyzer (context);
			_tmp832_ = _tmp831_;
			_tmp833_ = _tmp832_->va_list_type;
			_tmp834_ = vala_data_type_get_data_type (_tmp833_);
			_tmp835_ = _tmp834_;
			_tmp822_ = _tmp830_ == _tmp835_;
		} else {
			_tmp822_ = FALSE;
		}
		if (_tmp822_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp836_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp837_ = _tmp836_;
	if (_tmp837_) {
		gboolean _tmp838_ = FALSE;
		ValaCodeNode* _tmp839_;
		ValaCodeNode* _tmp840_;
		_tmp839_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp840_ = _tmp839_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp840_, VALA_TYPE_LOCAL_VARIABLE)) {
			_tmp838_ = TRUE;
		} else {
			ValaCodeNode* _tmp841_;
			ValaCodeNode* _tmp842_;
			_tmp841_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp842_ = _tmp841_;
			_tmp838_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp842_, VALA_TYPE_EXPRESSION_STATEMENT);
		}
		if (_tmp838_) {
		} else {
			ValaSemanticAnalyzer* _tmp843_;
			ValaSemanticAnalyzer* _tmp844_;
			ValaSymbol* _tmp845_;
			ValaSymbol* _tmp846_;
			_tmp843_ = vala_code_context_get_analyzer (context);
			_tmp844_ = _tmp843_;
			_tmp845_ = vala_semantic_analyzer_get_current_symbol (_tmp844_);
			_tmp846_ = _tmp845_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp846_, VALA_TYPE_BLOCK)) {
				ValaSourceReference* _tmp847_;
				ValaSourceReference* _tmp848_;
				_tmp847_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp848_ = _tmp847_;
				vala_report_error (_tmp848_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp849_;
				ValaCodeNode* _tmp850_;
				ValaCodeNode* _tmp851_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp852_;
				ValaDataType* _tmp853_;
				ValaDataType* _tmp854_;
				ValaDataType* _tmp855_;
				gchar* _tmp856_;
				gchar* _tmp857_;
				ValaSourceReference* _tmp858_;
				ValaSourceReference* _tmp859_;
				ValaLocalVariable* _tmp860_;
				ValaLocalVariable* _tmp861_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp862_;
				ValaSourceReference* _tmp863_;
				ValaSourceReference* _tmp864_;
				ValaDeclarationStatement* _tmp865_;
				ValaSemanticAnalyzer* _tmp866_;
				ValaSemanticAnalyzer* _tmp867_;
				ValaBlock* _tmp868_;
				ValaDeclarationStatement* _tmp869_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp870_;
				ValaDataType* _tmp871_;
				ValaDataType* _tmp872_;
				ValaExpression* _tmp873_;
				ValaLocalVariable* _tmp874_;
				ValaDeclarationStatement* _tmp875_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp876_;
				ValaSemanticAnalyzer* _tmp877_;
				ValaSymbol* _tmp878_;
				ValaSymbol* _tmp879_;
				ValaBlock* _tmp880_;
				ValaBlock* _tmp881_;
				ValaLocalVariable* _tmp882_;
				ValaSemanticAnalyzer* _tmp883_;
				ValaSemanticAnalyzer* _tmp884_;
				ValaBlock* _tmp885_;
				ValaLocalVariable* _tmp886_;
				ValaCodeNode* _tmp887_;
				ValaExpression* _tmp888_;
				ValaExpression* _tmp889_;
				_tmp849_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp850_ = _tmp849_;
				_tmp851_ = _vala_code_node_ref0 (_tmp850_);
				old_parent_node = _tmp851_;
				_tmp852_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp853_ = _tmp852_;
				_tmp854_ = vala_data_type_copy (_tmp853_);
				_tmp855_ = _tmp854_;
				_tmp856_ = vala_code_node_get_temp_name ();
				_tmp857_ = _tmp856_;
				_tmp858_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp859_ = _tmp858_;
				_tmp860_ = vala_local_variable_new (_tmp855_, _tmp857_, NULL, _tmp859_);
				_tmp861_ = _tmp860_;
				_g_free0 (_tmp857_);
				_vala_code_node_unref0 (_tmp855_);
				local = _tmp861_;
				_tmp862_ = local;
				_tmp863_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp864_ = _tmp863_;
				_tmp865_ = vala_declaration_statement_new ((ValaSymbol*) _tmp862_, _tmp864_);
				decl = _tmp865_;
				_tmp866_ = vala_code_context_get_analyzer (context);
				_tmp867_ = _tmp866_;
				_tmp868_ = _tmp867_->insert_block;
				_tmp869_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp868_, (ValaStatement*) _tmp869_);
				_tmp870_ = local;
				_tmp871_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp872_ = _tmp871_;
				_tmp873_ = vala_semantic_analyzer_create_temp_access (_tmp870_, _tmp872_);
				temp_access = _tmp873_;
				_tmp874_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp874_, (ValaExpression*) self);
				_tmp875_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp875_, context);
				_tmp876_ = vala_code_context_get_analyzer (context);
				_tmp877_ = _tmp876_;
				_tmp878_ = vala_semantic_analyzer_get_current_symbol (_tmp877_);
				_tmp879_ = _tmp878_;
				_tmp880_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp879_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp880_;
				_tmp881_ = block;
				_tmp882_ = local;
				vala_block_remove_local_variable (_tmp881_, _tmp882_);
				_tmp883_ = vala_code_context_get_analyzer (context);
				_tmp884_ = _tmp883_;
				_tmp885_ = _tmp884_->insert_block;
				_tmp886_ = local;
				vala_block_add_local_variable (_tmp885_, _tmp886_);
				_tmp887_ = old_parent_node;
				_tmp888_ = temp_access;
				vala_code_node_replace_expression (_tmp887_, (ValaExpression*) self, _tmp888_);
				_tmp889_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp889_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp890_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp891_ = _tmp890_;
	result = !_tmp891_;
	_vala_iterator_unref0 (arg_it);
	_vala_iterable_unref0 (args);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (base_cm);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}

static void
vala_method_call_real_emit (ValaCodeNode* base,
                            ValaCodeGenerator* codegen)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaMethodType* _tmp6_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp6_ = method_type;
	if (_tmp6_ != NULL) {
		ValaMethodType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp7_ = method_type;
		_tmp8_ = vala_method_type_get_method_symbol (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_SIGNAL);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaExpression* signal_access = NULL;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		_tmp12_ = vala_method_call_get_call (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp15_ = _tmp14_;
		_tmp16_ = _vala_code_node_ref0 (_tmp15_);
		signal_access = _tmp16_;
		_tmp17_ = signal_access;
		vala_code_node_emit ((ValaCodeNode*) _tmp17_, codegen);
		_vala_code_node_unref0 (signal_access);
	} else {
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		_tmp18_ = vala_method_call_get_call (self);
		_tmp19_ = _tmp18_;
		vala_code_node_emit ((ValaCodeNode*) _tmp19_, codegen);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _expr_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _expr_index = 0;
		_tmp20_ = self->priv->argument_list;
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_expr_list = _tmp21_;
		_tmp22_ = _expr_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_expr_size = _tmp24_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp25_;
			gpointer _tmp26_;
			ValaExpression* _tmp27_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp25_ = _expr_list;
			_tmp26_ = vala_list_get (_tmp25_, _expr_index);
			expr = (ValaExpression*) _tmp26_;
			_tmp27_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp27_, codegen);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
	_vala_code_node_unref0 (method_type);
}

static void
vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp9_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}

static void
vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                          ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp9_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}

ValaStringLiteral*
vala_method_call_get_format_literal (ValaMethodCall* self)
{
	ValaStringLiteral* result = NULL;
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaMethodType* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	mtype = _tmp4_;
	_tmp5_ = mtype;
	if (_tmp5_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		gboolean _tmp9_ = FALSE;
		_tmp6_ = mtype;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		format_arg = vala_method_get_format_arg_index (_tmp8_);
		if (format_arg >= 0) {
			ValaList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			_tmp10_ = self->priv->argument_list;
			_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp9_ = format_arg < _tmp12_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaExpression* _tmp15_;
			ValaStringLiteral* _tmp16_;
			ValaStringLiteral* _tmp17_;
			_tmp13_ = self->priv->argument_list;
			_tmp14_ = vala_list_get (_tmp13_, format_arg);
			_tmp15_ = (ValaExpression*) _tmp14_;
			_tmp16_ = vala_string_literal_get_format_literal (_tmp15_);
			_tmp17_ = _tmp16_;
			_vala_code_node_unref0 (_tmp15_);
			result = _tmp17_;
			_vala_code_node_unref0 (mtype);
			return result;
		}
	}
	result = NULL;
	_vala_code_node_unref0 (mtype);
	return result;
}

static gchar*
vala_method_call_real_to_string (ValaCodeNode* base)
{
	ValaMethodCall * self;
	gchar* result = NULL;
	GString* b = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	gboolean _tmp2_;
	GString* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean first = FALSE;
	GString* _tmp22_;
	GString* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	self = (ValaMethodCall*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = b;
	g_string_append_c (_tmp1_, '(');
	_tmp2_ = self->priv->_is_yield_expression;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = b;
	_tmp5_ = vala_method_call_get_call (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_node_to_string ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = b;
	g_string_append_c (_tmp9_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		gint _expr_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _expr_index = 0;
		_tmp10_ = self->priv->argument_list;
		_tmp11_ = _vala_iterable_ref0 (_tmp10_);
		_expr_list = _tmp11_;
		_tmp12_ = _expr_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_expr_size = _tmp14_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			GString* _tmp18_;
			ValaExpression* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp15_ = _expr_list;
			_tmp16_ = vala_list_get (_tmp15_, _expr_index);
			expr = (ValaExpression*) _tmp16_;
			if (!first) {
				GString* _tmp17_;
				_tmp17_ = b;
				g_string_append (_tmp17_, ", ");
			}
			_tmp18_ = b;
			_tmp19_ = expr;
			_tmp20_ = vala_code_node_to_string ((ValaCodeNode*) _tmp19_);
			_tmp21_ = _tmp20_;
			g_string_append (_tmp18_, _tmp21_);
			_g_free0 (_tmp21_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_tmp22_ = b;
	g_string_append (_tmp22_, "))");
	_tmp23_ = b;
	_tmp24_ = _tmp23_->str;
	_tmp25_ = g_strdup (_tmp24_);
	result = _tmp25_;
	_g_string_free0 (b);
	return result;
}

ValaExpression*
vala_method_call_get_call (ValaMethodCall* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}

void
vala_method_call_set_call (ValaMethodCall* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
	_tmp1_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_method_call_get_is_yield_expression (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_yield_expression;
	return result;
}

void
vala_method_call_set_is_yield_expression (ValaMethodCall* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}

gboolean
vala_method_call_get_is_assert (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_assert;
	return result;
}

static void
vala_method_call_set_is_assert (ValaMethodCall* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_assert = value;
}

gboolean
vala_method_call_get_is_constructv_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_constructv_chainup;
	return result;
}

static void
vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_constructv_chainup = value;
}

gboolean
vala_method_call_get_is_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_chainup;
	return result;
}

static void
vala_method_call_set_is_chainup (ValaMethodCall* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chainup = value;
}

static void
vala_method_call_class_init (ValaMethodCallClass * klass,
                             gpointer klass_data)
{
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethodCall_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_call_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_method_call_real_to_string;
}

static void
vala_method_call_instance_init (ValaMethodCall * self,
                                gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_call_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}

static void
vala_method_call_finalize (ValaCodeNode * obj)
{
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}

/**
 * Represents an invocation expression in the source code.
 */
GType
vala_method_call_get_type (void)
{
	static volatile gsize vala_method_call_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_call_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
		GType vala_method_call_type_id;
		vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
		ValaMethodCall_private_offset = g_type_add_instance_private (vala_method_call_type_id, sizeof (ValaMethodCallPrivate));
		g_once_init_leave (&vala_method_call_type_id__volatile, vala_method_call_type_id);
	}
	return vala_method_call_type_id__volatile;
}

