/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
typedef struct _ValaGLibValuePrivate ValaGLibValuePrivate;
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGLibValue {
	ValaTargetValue parent_instance;
	ValaCCodeExpression* cvalue;
	gboolean lvalue;
	gboolean non_null;
	gchar* ctype;
	ValaList* array_length_cvalues;
	ValaCCodeExpression* array_size_cvalue;
	gboolean array_null_terminated;
	ValaCCodeExpression* array_length_cexpr;
	ValaCCodeExpression* delegate_target_cvalue;
	ValaCCodeExpression* delegate_target_destroy_notify_cvalue;
	ValaGLibValuePrivate * priv;
};

struct _ValaGLibValueClass {
	ValaTargetValueClass parent_class;
};

static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                                      ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean vala_ccode_method_call_module_has_ref_out_param (ValaCCodeMethodCallModule* self,
                                                          ValaCallable* c);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}

static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp15_;
	ValaDataType* _tmp16_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp164_;
	GEqualFunc _tmp165_;
	GEqualFunc _tmp166_;
	ValaHashMap* _tmp167_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp168_;
	ValaHashMap* _tmp169_;
	gboolean _tmp170_ = FALSE;
	ValaMethod* _tmp171_;
	gboolean _tmp315_ = FALSE;
	ValaMethod* _tmp316_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp479_;
	ValaCCodeExpression* _tmp480_;
	ValaMethod* _tmp481_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp505_ = FALSE;
	ValaMethod* _tmp506_;
	gboolean _tmp660_ = FALSE;
	ValaMethod* _tmp661_;
	ValaMethod* _tmp698_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp880_;
	ValaIterator* _tmp881_;
	ValaIterator* _tmp1215_;
	gboolean _tmp1225_ = FALSE;
	gboolean _tmp1226_ = FALSE;
	ValaMethod* _tmp1227_;
	gboolean _tmp1349_ = FALSE;
	ValaDelegate* _tmp1350_;
	gboolean _tmp1450_ = FALSE;
	ValaMethod* _tmp1451_;
	gboolean _tmp1467_;
	gboolean _tmp1468_;
	ValaDataType* _tmp1507_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1531_;
	ValaDataType* _tmp1532_;
	ValaDataType* _tmp1533_;
	gboolean _tmp1534_;
	gboolean _tmp1535_ = FALSE;
	ValaDataType* _tmp1536_;
	ValaCCodeFunctionCall* _tmp1565_;
	ValaCCodeFunctionCall* _tmp1566_;
	ValaCCodeExpression* out_param_ref = NULL;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1581_;
	ValaCCodeFunctionCall* _tmp1582_;
	ValaCCodeFunctionCall* _tmp1597_;
	gboolean _tmp1612_;
	gboolean _tmp1613_;
	gboolean _tmp1637_;
	gboolean _tmp1638_;
	gboolean _tmp1673_ = FALSE;
	gboolean _tmp1674_ = FALSE;
	ValaMethod* _tmp1675_;
	gboolean _tmp1713_ = FALSE;
	gboolean _tmp1714_ = FALSE;
	ValaMethod* _tmp1715_;
	ValaMethod* _tmp1734_;
	gboolean _tmp1851_ = FALSE;
	ValaCodeNode* _tmp1852_;
	ValaCodeNode* _tmp1853_;
	ValaList* _tmp1933_;
	ValaIterator* _tmp1934_;
	gboolean _tmp2015_ = FALSE;
	gboolean _tmp2016_ = FALSE;
	ValaMethod* _tmp2017_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccall = _tmp5_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp6_ = vala_method_call_get_call (expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp7_) : NULL);
	ma = _tmp8_;
	_tmp9_ = vala_method_call_get_call (expr);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	itype = _tmp13_;
	_tmp14_ = itype;
	_tmp15_ = vala_data_type_get_parameters (_tmp14_);
	_vala_iterable_unref0 (params);
	params = _tmp15_;
	_tmp16_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp17_;
		ValaDataType* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaMethod* _tmp22_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		ValaMemberAccess* _tmp26_;
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp17_ = ma;
		_vala_assert (_tmp17_ != NULL, "ma != null");
		_tmp18_ = itype;
		_tmp19_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (m);
		m = _tmp21_;
		_tmp22_ = m;
		if (!vala_get_ccode_simple_generics (_tmp22_)) {
			ValaMemberAccess* _tmp23_;
			_tmp23_ = ma;
			vala_ccode_base_module_check_type_arguments ((ValaCCodeBaseModule*) self, _tmp23_);
		}
		_tmp26_ = ma;
		_tmp27_ = vala_member_access_get_inner (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ != NULL) {
			ValaMemberAccess* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			_tmp29_ = ma;
			_tmp30_ = vala_member_access_get_inner (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_expression_get_value_type (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			ValaMemberAccess* _tmp34_;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaMethod* _tmp39_;
			ValaMethod* _tmp40_;
			ValaMethod* _tmp41_;
			_tmp34_ = ma;
			_tmp35_ = vala_member_access_get_inner (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_expression_get_value_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp40_ = _tmp39_;
			_tmp41_ = m;
			_tmp24_ = _tmp40_ == _tmp41_;
			_vala_code_node_unref0 (_tmp40_);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			ValaTypeSymbol* _tmp47_;
			ValaTypeSymbol* _tmp48_;
			ValaEnum* _tmp49_;
			ValaCCodeFunctionCall* _tmp50_;
			ValaEnum* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			ValaCCodeIdentifier* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_data_type_get_data_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_ENUM, ValaEnum));
			en = _tmp49_;
			_tmp50_ = ccall;
			_tmp51_ = en;
			_tmp52_ = vala_ccode_method_call_module_generate_enum_tostring_function (self, _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_identifier_new (_tmp53_);
			_tmp55_ = _tmp54_;
			vala_ccode_function_call_set_call (_tmp50_, (ValaCCodeExpression*) _tmp55_);
			_vala_ccode_node_unref0 (_tmp55_);
			_g_free0 (_tmp53_);
			_vala_code_node_unref0 (en);
		} else {
			gboolean _tmp56_ = FALSE;
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			ValaCodeContext* _tmp60_;
			ValaCodeContext* _tmp61_;
			ValaProfile _tmp62_;
			ValaProfile _tmp63_;
			_tmp60_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_code_context_get_profile (_tmp61_);
			_tmp63_ = _tmp62_;
			if (_tmp63_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp64_;
				ValaExpression* _tmp65_;
				ValaExpression* _tmp66_;
				_tmp64_ = ma;
				_tmp65_ = vala_member_access_get_inner (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp59_ = _tmp66_ != NULL;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaMemberAccess* _tmp67_;
				ValaExpression* _tmp68_;
				ValaExpression* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				_tmp67_ = ma;
				_tmp68_ = vala_member_access_get_inner (_tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = vala_expression_get_value_type (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp58_ = _tmp71_ != NULL;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaMemberAccess* _tmp72_;
				ValaExpression* _tmp73_;
				ValaExpression* _tmp74_;
				ValaDataType* _tmp75_;
				ValaDataType* _tmp76_;
				ValaTypeSymbol* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaDataType* _tmp79_;
				ValaTypeSymbol* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				_tmp72_ = ma;
				_tmp73_ = vala_member_access_get_inner (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = vala_expression_get_value_type (_tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = vala_data_type_get_data_type (_tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp80_ = vala_data_type_get_data_type (_tmp79_);
				_tmp81_ = _tmp80_;
				_tmp57_ = _tmp78_ == _tmp81_;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaMemberAccess* _tmp82_;
				const gchar* _tmp83_;
				const gchar* _tmp84_;
				_tmp82_ = ma;
				_tmp83_ = vala_member_access_get_member_name (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp56_ = g_strcmp0 (_tmp84_, "printf") == 0;
			} else {
				_tmp56_ = FALSE;
			}
			if (_tmp56_) {
				ValaCCodeFunctionCall* _tmp85_;
				gchar* _tmp86_;
				gchar* _tmp87_;
				ValaCCodeIdentifier* _tmp88_;
				ValaCCodeIdentifier* _tmp89_;
				_tmp85_ = ccall;
				_tmp86_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp87_ = _tmp86_;
				_tmp88_ = vala_ccode_identifier_new (_tmp87_);
				_tmp89_ = _tmp88_;
				vala_ccode_function_call_set_call (_tmp85_, (ValaCCodeExpression*) _tmp89_);
				_vala_ccode_node_unref0 (_tmp89_);
				_g_free0 (_tmp87_);
			} else {
				gboolean _tmp90_;
				gboolean _tmp91_;
				_tmp90_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp91_ = _tmp90_;
				if (_tmp91_) {
					ValaCCodeFunctionCall* _tmp92_;
					ValaMethod* _tmp93_;
					gchar* _tmp94_;
					gchar* _tmp95_;
					ValaCCodeIdentifier* _tmp96_;
					ValaCCodeIdentifier* _tmp97_;
					_tmp92_ = ccall;
					_tmp93_ = m;
					_tmp94_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp95_ = _tmp94_;
					_tmp96_ = vala_ccode_identifier_new (_tmp95_);
					_tmp97_ = _tmp96_;
					vala_ccode_function_call_set_call (_tmp92_, (ValaCCodeExpression*) _tmp97_);
					_vala_ccode_node_unref0 (_tmp97_);
					_g_free0 (_tmp95_);
				}
			}
		}
	} else {
		ValaDataType* _tmp98_;
		_tmp98_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp98_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp99_;
			ValaSignalType* _tmp100_;
			gboolean _tmp101_ = FALSE;
			gboolean _tmp102_ = FALSE;
			ValaMemberAccess* _tmp103_;
			_tmp99_ = itype;
			_tmp100_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp100_;
			_tmp103_ = ma;
			if (_tmp103_ != NULL) {
				ValaMemberAccess* _tmp104_;
				ValaExpression* _tmp105_;
				ValaExpression* _tmp106_;
				_tmp104_ = ma;
				_tmp105_ = vala_member_access_get_inner (_tmp104_);
				_tmp106_ = _tmp105_;
				_tmp102_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp106_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp102_ = FALSE;
			}
			if (_tmp102_) {
				ValaSignalType* _tmp107_;
				ValaSignal* _tmp108_;
				ValaSignal* _tmp109_;
				gboolean _tmp110_;
				gboolean _tmp111_;
				_tmp107_ = sig_type;
				_tmp108_ = vala_signal_type_get_signal_symbol (_tmp107_);
				_tmp109_ = _tmp108_;
				_tmp110_ = vala_signal_get_is_virtual (_tmp109_);
				_tmp111_ = _tmp110_;
				_tmp101_ = _tmp111_;
			} else {
				_tmp101_ = FALSE;
			}
			if (_tmp101_) {
				ValaSignalType* _tmp112_;
				ValaSignal* _tmp113_;
				ValaSignal* _tmp114_;
				ValaMethod* _tmp115_;
				ValaMethod* _tmp116_;
				ValaMethod* _tmp117_;
				_tmp112_ = sig_type;
				_tmp113_ = vala_signal_type_get_signal_symbol (_tmp112_);
				_tmp114_ = _tmp113_;
				_tmp115_ = vala_signal_get_default_handler (_tmp114_);
				_tmp116_ = _tmp115_;
				_tmp117_ = _vala_code_node_ref0 (_tmp116_);
				_vala_code_node_unref0 (m);
				m = _tmp117_;
			} else {
				ValaExpression* _tmp118_;
				ValaExpression* _tmp119_;
				ValaCCodeExpression* _tmp120_;
				_tmp118_ = vala_method_call_get_call (expr);
				_tmp119_ = _tmp118_;
				_tmp120_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp119_);
				_vala_ccode_node_unref0 (ccall);
				ccall = G_TYPE_CHECK_INSTANCE_CAST (_tmp120_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall);
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp121_;
			_tmp121_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp121_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp122_;
				ValaObjectTypeSymbol* _tmp123_;
				ValaObjectTypeSymbol* _tmp124_;
				ValaClass* _tmp125_;
				ValaClass* _tmp126_;
				ValaCreationMethod* _tmp127_;
				ValaCreationMethod* _tmp128_;
				ValaMethod* _tmp129_;
				ValaMethod* _tmp130_;
				ValaCCodeFile* _tmp131_;
				gchar* real_name = NULL;
				ValaMethod* _tmp132_;
				gchar* _tmp133_;
				gboolean _tmp134_;
				gboolean _tmp135_;
				const gchar* _tmp138_;
				ValaCCodeIdentifier* _tmp139_;
				ValaCCodeIdentifier* _tmp140_;
				ValaCCodeFunctionCall* _tmp141_;
				_tmp122_ = itype;
				_tmp123_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp122_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp124_ = _tmp123_;
				_tmp125_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp125_;
				_tmp126_ = cl;
				_tmp127_ = vala_class_get_default_construction_method (_tmp126_);
				_tmp128_ = _tmp127_;
				_tmp129_ = _vala_code_node_ref0 ((ValaMethod*) _tmp128_);
				_vala_code_node_unref0 (m);
				m = _tmp129_;
				_tmp130_ = m;
				_tmp131_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp130_, _tmp131_);
				_tmp132_ = m;
				_tmp133_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp132_);
				real_name = _tmp133_;
				_tmp134_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp135_ = _tmp134_;
				if (_tmp135_) {
					ValaMethod* _tmp136_;
					gchar* _tmp137_;
					_tmp136_ = m;
					_tmp137_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp136_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp137_;
				}
				_tmp138_ = real_name;
				_tmp139_ = vala_ccode_identifier_new (_tmp138_);
				_tmp140_ = _tmp139_;
				_tmp141_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp140_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp141_;
				_vala_ccode_node_unref0 (_tmp140_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp142_;
				_tmp142_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp142_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp143_;
					ValaTypeSymbol* _tmp144_;
					ValaTypeSymbol* _tmp145_;
					ValaStruct* _tmp146_;
					ValaStruct* _tmp147_;
					ValaCreationMethod* _tmp148_;
					ValaCreationMethod* _tmp149_;
					ValaMethod* _tmp150_;
					ValaMethod* _tmp151_;
					ValaCCodeFile* _tmp152_;
					ValaMethod* _tmp153_;
					gchar* _tmp154_;
					gchar* _tmp155_;
					ValaCCodeIdentifier* _tmp156_;
					ValaCCodeIdentifier* _tmp157_;
					ValaCCodeFunctionCall* _tmp158_;
					_tmp143_ = itype;
					_tmp144_ = vala_value_type_get_type_symbol ((ValaValueType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp143_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp145_ = _tmp144_;
					_tmp146_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp146_;
					_tmp147_ = st;
					_tmp148_ = vala_struct_get_default_construction_method (_tmp147_);
					_tmp149_ = _tmp148_;
					_tmp150_ = _vala_code_node_ref0 ((ValaMethod*) _tmp149_);
					_vala_code_node_unref0 (m);
					m = _tmp150_;
					_tmp151_ = m;
					_tmp152_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp151_, _tmp152_);
					_tmp153_ = m;
					_tmp154_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp153_);
					_tmp155_ = _tmp154_;
					_tmp156_ = vala_ccode_identifier_new (_tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp157_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp158_;
					_vala_ccode_node_unref0 (_tmp157_);
					_g_free0 (_tmp155_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp159_;
					_tmp159_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp159_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp160_;
						ValaDelegate* _tmp161_;
						ValaDelegate* _tmp162_;
						ValaDelegate* _tmp163_;
						_tmp160_ = itype;
						_tmp161_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp162_ = _tmp161_;
						_tmp163_ = _vala_code_node_ref0 (_tmp162_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp163_;
					}
				}
			}
		}
	}
	_tmp164_ = g_direct_hash;
	_tmp165_ = g_direct_equal;
	_tmp166_ = g_direct_equal;
	_tmp167_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp164_, _tmp165_, _tmp166_);
	in_arg_map = _tmp167_;
	_tmp168_ = in_arg_map;
	_tmp169_ = _vala_map_ref0 (_tmp168_);
	out_arg_map = _tmp169_;
	_tmp171_ = m;
	if (_tmp171_ != NULL) {
		ValaMethod* _tmp172_;
		gboolean _tmp173_;
		gboolean _tmp174_;
		_tmp172_ = m;
		_tmp173_ = vala_method_get_coroutine (_tmp172_);
		_tmp174_ = _tmp173_;
		_tmp170_ = _tmp174_;
	} else {
		_tmp170_ = FALSE;
	}
	if (_tmp170_) {
		ValaMethod* _tmp175_;
		gchar* _tmp176_;
		gchar* _tmp177_;
		ValaCCodeIdentifier* _tmp178_;
		ValaCCodeIdentifier* _tmp179_;
		ValaCCodeFunctionCall* _tmp180_;
		ValaMethod* _tmp181_;
		gchar* _tmp182_;
		gchar* _tmp183_;
		ValaCCodeIdentifier* _tmp184_;
		ValaCCodeIdentifier* _tmp185_;
		ValaCCodeFunctionCall* _tmp186_;
		ValaMemberAccess* _tmp187_;
		ValaExpression* _tmp188_;
		ValaExpression* _tmp189_;
		gboolean _tmp265_ = FALSE;
		ValaMemberAccess* _tmp266_;
		const gchar* _tmp267_;
		const gchar* _tmp268_;
		_tmp175_ = m;
		_tmp176_ = vala_get_ccode_name ((ValaCodeNode*) _tmp175_);
		_tmp177_ = _tmp176_;
		_tmp178_ = vala_ccode_identifier_new (_tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp179_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp180_;
		_vala_ccode_node_unref0 (_tmp179_);
		_g_free0 (_tmp177_);
		_tmp181_ = m;
		_tmp182_ = vala_get_ccode_finish_name (_tmp181_);
		_tmp183_ = _tmp182_;
		_tmp184_ = vala_ccode_identifier_new (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp185_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp186_;
		_vala_ccode_node_unref0 (_tmp185_);
		_g_free0 (_tmp183_);
		_tmp187_ = ma;
		_tmp188_ = vala_member_access_get_inner (_tmp187_);
		_tmp189_ = _tmp188_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp189_, VALA_TYPE_BASE_ACCESS)) {
			ValaMethod* _tmp190_;
			ValaMethod* _tmp191_;
			ValaMethod* _tmp192_;
			_tmp190_ = m;
			_tmp191_ = vala_method_get_base_method (_tmp190_);
			_tmp192_ = _tmp191_;
			if (_tmp192_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp193_;
				ValaMethod* _tmp194_;
				ValaMethod* _tmp195_;
				ValaSymbol* _tmp196_;
				ValaSymbol* _tmp197_;
				ValaClass* _tmp198_;
				ValaCCodeFunctionCall* vcast = NULL;
				ValaClass* _tmp199_;
				gchar* _tmp200_;
				gchar* _tmp201_;
				ValaCCodeIdentifier* _tmp202_;
				ValaCCodeIdentifier* _tmp203_;
				ValaCCodeFunctionCall* _tmp204_;
				ValaCCodeFunctionCall* _tmp205_;
				ValaCCodeFunctionCall* _tmp206_;
				ValaClass* _tmp207_;
				ValaClass* _tmp208_;
				gchar* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				ValaCCodeIdentifier* _tmp213_;
				ValaCCodeIdentifier* _tmp214_;
				ValaCCodeFunctionCall* _tmp215_;
				ValaCCodeFunctionCall* _tmp216_;
				ValaMethod* _tmp217_;
				gchar* _tmp218_;
				gchar* _tmp219_;
				ValaCCodeMemberAccess* _tmp220_;
				ValaCCodeMemberAccess* _tmp221_;
				ValaCCodeFunctionCall* _tmp222_;
				ValaCCodeFunctionCall* _tmp223_;
				ValaMethod* _tmp224_;
				gchar* _tmp225_;
				gchar* _tmp226_;
				ValaCCodeMemberAccess* _tmp227_;
				ValaCCodeMemberAccess* _tmp228_;
				_tmp193_ = m;
				_tmp194_ = vala_method_get_base_method (_tmp193_);
				_tmp195_ = _tmp194_;
				_tmp196_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp197_, VALA_TYPE_CLASS, ValaClass));
				base_class = _tmp198_;
				_tmp199_ = base_class;
				_tmp200_ = vala_get_ccode_class_type_function (_tmp199_);
				_tmp201_ = _tmp200_;
				_tmp202_ = vala_ccode_identifier_new (_tmp201_);
				_tmp203_ = _tmp202_;
				_tmp204_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp203_);
				_tmp205_ = _tmp204_;
				_vala_ccode_node_unref0 (_tmp203_);
				_g_free0 (_tmp201_);
				vcast = _tmp205_;
				_tmp206_ = vcast;
				_tmp207_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp208_ = _tmp207_;
				_tmp209_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp208_, NULL);
				_tmp210_ = _tmp209_;
				_tmp211_ = g_strdup_printf ("%s_parent_class", _tmp210_);
				_tmp212_ = _tmp211_;
				_tmp213_ = vala_ccode_identifier_new (_tmp212_);
				_tmp214_ = _tmp213_;
				vala_ccode_function_call_add_argument (_tmp206_, (ValaCCodeExpression*) _tmp214_);
				_vala_ccode_node_unref0 (_tmp214_);
				_g_free0 (_tmp212_);
				_g_free0 (_tmp210_);
				_tmp215_ = async_call;
				_tmp216_ = vcast;
				_tmp217_ = m;
				_tmp218_ = vala_get_ccode_vfunc_name (_tmp217_);
				_tmp219_ = _tmp218_;
				_tmp220_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp216_, _tmp219_);
				_tmp221_ = _tmp220_;
				vala_ccode_function_call_set_call (_tmp215_, (ValaCCodeExpression*) _tmp221_);
				_vala_ccode_node_unref0 (_tmp221_);
				_g_free0 (_tmp219_);
				_tmp222_ = finish_call;
				_tmp223_ = vcast;
				_tmp224_ = m;
				_tmp225_ = vala_get_ccode_finish_vfunc_name (_tmp224_);
				_tmp226_ = _tmp225_;
				_tmp227_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp223_, _tmp226_);
				_tmp228_ = _tmp227_;
				vala_ccode_function_call_set_call (_tmp222_, (ValaCCodeExpression*) _tmp228_);
				_vala_ccode_node_unref0 (_tmp228_);
				_g_free0 (_tmp226_);
				_vala_ccode_node_unref0 (vcast);
				_vala_code_node_unref0 (base_class);
			} else {
				ValaMethod* _tmp229_;
				ValaMethod* _tmp230_;
				ValaMethod* _tmp231_;
				_tmp229_ = m;
				_tmp230_ = vala_method_get_base_interface_method (_tmp229_);
				_tmp231_ = _tmp230_;
				if (_tmp231_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp232_;
					ValaMethod* _tmp233_;
					ValaMethod* _tmp234_;
					ValaSymbol* _tmp235_;
					ValaSymbol* _tmp236_;
					ValaInterface* _tmp237_;
					gchar* parent_iface_var = NULL;
					ValaClass* _tmp238_;
					ValaClass* _tmp239_;
					gchar* _tmp240_;
					gchar* _tmp241_;
					ValaInterface* _tmp242_;
					gchar* _tmp243_;
					gchar* _tmp244_;
					gchar* _tmp245_;
					gchar* _tmp246_;
					ValaCCodeFunctionCall* _tmp247_;
					const gchar* _tmp248_;
					ValaCCodeIdentifier* _tmp249_;
					ValaCCodeIdentifier* _tmp250_;
					ValaMethod* _tmp251_;
					gchar* _tmp252_;
					gchar* _tmp253_;
					ValaCCodeMemberAccess* _tmp254_;
					ValaCCodeMemberAccess* _tmp255_;
					ValaCCodeFunctionCall* _tmp256_;
					const gchar* _tmp257_;
					ValaCCodeIdentifier* _tmp258_;
					ValaCCodeIdentifier* _tmp259_;
					ValaMethod* _tmp260_;
					gchar* _tmp261_;
					gchar* _tmp262_;
					ValaCCodeMemberAccess* _tmp263_;
					ValaCCodeMemberAccess* _tmp264_;
					_tmp232_ = m;
					_tmp233_ = vala_method_get_base_interface_method (_tmp232_);
					_tmp234_ = _tmp233_;
					_tmp235_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp234_);
					_tmp236_ = _tmp235_;
					_tmp237_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp236_, VALA_TYPE_INTERFACE, ValaInterface));
					base_iface = _tmp237_;
					_tmp238_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp239_ = _tmp238_;
					_tmp240_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp239_, NULL);
					_tmp241_ = _tmp240_;
					_tmp242_ = base_iface;
					_tmp243_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp242_, NULL);
					_tmp244_ = _tmp243_;
					_tmp245_ = g_strdup_printf ("%s_%s_parent_iface", _tmp241_, _tmp244_);
					_tmp246_ = _tmp245_;
					_g_free0 (_tmp244_);
					_g_free0 (_tmp241_);
					parent_iface_var = _tmp246_;
					_tmp247_ = async_call;
					_tmp248_ = parent_iface_var;
					_tmp249_ = vala_ccode_identifier_new (_tmp248_);
					_tmp250_ = _tmp249_;
					_tmp251_ = m;
					_tmp252_ = vala_get_ccode_vfunc_name (_tmp251_);
					_tmp253_ = _tmp252_;
					_tmp254_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp250_, _tmp253_);
					_tmp255_ = _tmp254_;
					vala_ccode_function_call_set_call (_tmp247_, (ValaCCodeExpression*) _tmp255_);
					_vala_ccode_node_unref0 (_tmp255_);
					_g_free0 (_tmp253_);
					_vala_ccode_node_unref0 (_tmp250_);
					_tmp256_ = finish_call;
					_tmp257_ = parent_iface_var;
					_tmp258_ = vala_ccode_identifier_new (_tmp257_);
					_tmp259_ = _tmp258_;
					_tmp260_ = m;
					_tmp261_ = vala_get_ccode_finish_vfunc_name (_tmp260_);
					_tmp262_ = _tmp261_;
					_tmp263_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp259_, _tmp262_);
					_tmp264_ = _tmp263_;
					vala_ccode_function_call_set_call (_tmp256_, (ValaCCodeExpression*) _tmp264_);
					_vala_ccode_node_unref0 (_tmp264_);
					_g_free0 (_tmp262_);
					_vala_ccode_node_unref0 (_tmp259_);
					_g_free0 (parent_iface_var);
					_vala_code_node_unref0 (base_iface);
				}
			}
		}
		_tmp266_ = ma;
		_tmp267_ = vala_member_access_get_member_name (_tmp266_);
		_tmp268_ = _tmp267_;
		if (g_strcmp0 (_tmp268_, "begin") == 0) {
			ValaMemberAccess* _tmp269_;
			ValaExpression* _tmp270_;
			ValaExpression* _tmp271_;
			ValaSymbol* _tmp272_;
			ValaSymbol* _tmp273_;
			ValaMemberAccess* _tmp274_;
			ValaSymbol* _tmp275_;
			ValaSymbol* _tmp276_;
			_tmp269_ = ma;
			_tmp270_ = vala_member_access_get_inner (_tmp269_);
			_tmp271_ = _tmp270_;
			_tmp272_ = vala_expression_get_symbol_reference (_tmp271_);
			_tmp273_ = _tmp272_;
			_tmp274_ = ma;
			_tmp275_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp274_);
			_tmp276_ = _tmp275_;
			_tmp265_ = _tmp273_ == _tmp276_;
		} else {
			_tmp265_ = FALSE;
		}
		if (_tmp265_) {
			ValaCCodeFunctionCall* _tmp277_;
			ValaCCodeFunctionCall* _tmp278_;
			ValaMethod* _tmp279_;
			ValaList* _tmp280_;
			_tmp277_ = async_call;
			_tmp278_ = _vala_ccode_node_ref0 (_tmp277_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp278_;
			_tmp279_ = m;
			_tmp280_ = vala_method_get_async_begin_parameters (_tmp279_);
			_vala_iterable_unref0 (params);
			params = _tmp280_;
		} else {
			gboolean _tmp281_ = FALSE;
			ValaMemberAccess* _tmp282_;
			const gchar* _tmp283_;
			const gchar* _tmp284_;
			_tmp282_ = ma;
			_tmp283_ = vala_member_access_get_member_name (_tmp282_);
			_tmp284_ = _tmp283_;
			if (g_strcmp0 (_tmp284_, "end") == 0) {
				ValaMemberAccess* _tmp285_;
				ValaExpression* _tmp286_;
				ValaExpression* _tmp287_;
				ValaSymbol* _tmp288_;
				ValaSymbol* _tmp289_;
				ValaMemberAccess* _tmp290_;
				ValaSymbol* _tmp291_;
				ValaSymbol* _tmp292_;
				_tmp285_ = ma;
				_tmp286_ = vala_member_access_get_inner (_tmp285_);
				_tmp287_ = _tmp286_;
				_tmp288_ = vala_expression_get_symbol_reference (_tmp287_);
				_tmp289_ = _tmp288_;
				_tmp290_ = ma;
				_tmp291_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp290_);
				_tmp292_ = _tmp291_;
				_tmp281_ = _tmp289_ == _tmp292_;
			} else {
				_tmp281_ = FALSE;
			}
			if (_tmp281_) {
				ValaCCodeFunctionCall* _tmp293_;
				ValaCCodeFunctionCall* _tmp294_;
				ValaMethod* _tmp295_;
				ValaList* _tmp296_;
				_tmp293_ = finish_call;
				_tmp294_ = _vala_ccode_node_ref0 (_tmp293_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp294_;
				_tmp295_ = m;
				_tmp296_ = vala_method_get_async_end_parameters (_tmp295_);
				_vala_iterable_unref0 (params);
				params = _tmp296_;
			} else {
				gboolean _tmp297_;
				gboolean _tmp298_;
				_tmp297_ = vala_method_call_get_is_yield_expression (expr);
				_tmp298_ = _tmp297_;
				if (!_tmp298_) {
					ValaCCodeFunctionCall* _tmp299_;
					ValaCCodeFunctionCall* _tmp300_;
					ValaMethod* _tmp301_;
					ValaList* _tmp302_;
					_tmp299_ = async_call;
					_tmp300_ = _vala_ccode_node_ref0 (_tmp299_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp300_;
					_tmp301_ = m;
					_tmp302_ = vala_method_get_async_begin_parameters (_tmp301_);
					_vala_iterable_unref0 (params);
					params = _tmp302_;
				} else {
					ValaCCodeFunctionCall* _tmp303_;
					ValaCCodeFunctionCall* _tmp304_;
					GHashFunc _tmp305_;
					GEqualFunc _tmp306_;
					GEqualFunc _tmp307_;
					ValaHashMap* _tmp308_;
					ValaHashMap* _tmp309_;
					ValaMethod* _tmp310_;
					ValaCCodeIdentifier* _tmp311_;
					ValaCCodeIdentifier* _tmp312_;
					ValaCCodeMemberAccess* _tmp313_;
					ValaCCodeMemberAccess* _tmp314_;
					_tmp303_ = finish_call;
					_tmp304_ = _vala_ccode_node_ref0 (_tmp303_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp304_;
					_tmp305_ = g_direct_hash;
					_tmp306_ = g_direct_equal;
					_tmp307_ = g_direct_equal;
					_tmp308_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp305_, _tmp306_, _tmp307_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp308_;
					_tmp309_ = out_arg_map;
					_tmp310_ = m;
					_tmp311_ = vala_ccode_identifier_new ("_data_");
					_tmp312_ = _tmp311_;
					_tmp313_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp312_, "_res_");
					_tmp314_ = _tmp313_;
					vala_map_set ((ValaMap*) _tmp309_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp310_), FALSE)), (ValaCCodeExpression*) _tmp314_);
					_vala_ccode_node_unref0 (_tmp314_);
					_vala_ccode_node_unref0 (_tmp312_);
				}
			}
		}
	}
	_tmp316_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp316_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp317_;
		ValaSymbol* _tmp318_;
		ValaSymbol* _tmp319_;
		_tmp317_ = m;
		_tmp318_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp317_);
		_tmp319_ = _tmp318_;
		_tmp315_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp319_, VALA_TYPE_CLASS);
	} else {
		_tmp315_ = FALSE;
	}
	if (_tmp315_) {
		ValaCodeContext* _tmp320_;
		ValaCodeContext* _tmp321_;
		ValaProfile _tmp322_;
		ValaProfile _tmp323_;
		ValaClass* _tmp335_;
		ValaClass* _tmp336_;
		gboolean _tmp337_;
		gboolean _tmp338_;
		_tmp320_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp321_ = _tmp320_;
		_tmp322_ = vala_code_context_get_profile (_tmp321_);
		_tmp323_ = _tmp322_;
		if (_tmp323_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp324_;
			ValaSymbol* _tmp325_;
			ValaSymbol* _tmp326_;
			gboolean _tmp327_;
			gboolean _tmp328_;
			_tmp324_ = m;
			_tmp325_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp324_);
			_tmp326_ = _tmp325_;
			_tmp327_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp326_, VALA_TYPE_CLASS, ValaClass));
			_tmp328_ = _tmp327_;
			if (!_tmp328_) {
				ValaCCodeFunctionCall* _tmp329_;
				ValaCCodeExpression* _tmp330_;
				ValaCCodeExpression* _tmp331_;
				_tmp329_ = ccall;
				_tmp330_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp331_ = _tmp330_;
				vala_ccode_function_call_add_argument (_tmp329_, _tmp331_);
				_vala_ccode_node_unref0 (_tmp331_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp332_;
			ValaCCodeExpression* _tmp333_;
			ValaCCodeExpression* _tmp334_;
			_tmp332_ = ccall;
			_tmp333_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp334_ = _tmp333_;
			vala_ccode_function_call_add_argument (_tmp332_, _tmp334_);
			_vala_ccode_node_unref0 (_tmp334_);
		}
		_tmp335_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp336_ = _tmp335_;
		_tmp337_ = vala_class_get_is_compact (_tmp336_);
		_tmp338_ = _tmp337_;
		if (!_tmp338_) {
			ValaClass* _tmp339_;
			ValaClass* _tmp340_;
			ValaMethod* _tmp341_;
			ValaSymbol* _tmp342_;
			ValaSymbol* _tmp343_;
			_tmp339_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp340_ = _tmp339_;
			_tmp341_ = m;
			_tmp342_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp341_);
			_tmp343_ = _tmp342_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp340_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp343_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp344_;
					ValaClass* _tmp345_;
					ValaList* _tmp346_;
					gint _base_type_size = 0;
					ValaList* _tmp347_;
					gint _tmp348_;
					gint _tmp349_;
					gint _base_type_index = 0;
					_tmp344_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp345_ = _tmp344_;
					_tmp346_ = vala_class_get_base_types (_tmp345_);
					_base_type_list = _tmp346_;
					_tmp347_ = _base_type_list;
					_tmp348_ = vala_collection_get_size ((ValaCollection*) _tmp347_);
					_tmp349_ = _tmp348_;
					_base_type_size = _tmp349_;
					_base_type_index = -1;
					while (TRUE) {
						ValaDataType* base_type = NULL;
						ValaList* _tmp350_;
						gpointer _tmp351_;
						ValaDataType* _tmp352_;
						ValaTypeSymbol* _tmp353_;
						ValaTypeSymbol* _tmp354_;
						_base_type_index = _base_type_index + 1;
						if (!(_base_type_index < _base_type_size)) {
							break;
						}
						_tmp350_ = _base_type_list;
						_tmp351_ = vala_list_get (_tmp350_, _base_type_index);
						base_type = (ValaDataType*) _tmp351_;
						_tmp352_ = base_type;
						_tmp353_ = vala_data_type_get_data_type (_tmp352_);
						_tmp354_ = _tmp353_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp354_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp355_;
							gchar* _tmp356_;
							gchar* _tmp357_;
							gboolean _tmp358_;
							ValaHashMap* _tmp363_;
							ValaDataType* _tmp364_;
							ValaList* _tmp365_;
							ValaList* _tmp366_;
							ValaList* _tmp367_;
							type_parameters = NULL;
							_tmp355_ = m;
							_tmp356_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp355_);
							_tmp357_ = _tmp356_;
							_tmp358_ = g_strcmp0 (_tmp357_, "g_object_new") == 0;
							_g_free0 (_tmp357_);
							if (_tmp358_) {
								ValaDataType* _tmp359_;
								ValaTypeSymbol* _tmp360_;
								ValaTypeSymbol* _tmp361_;
								ValaList* _tmp362_;
								_tmp359_ = base_type;
								_tmp360_ = vala_data_type_get_data_type (_tmp359_);
								_tmp361_ = _tmp360_;
								_tmp362_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp361_, VALA_TYPE_CLASS, ValaClass));
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp362_;
							}
							_tmp363_ = in_arg_map;
							_tmp364_ = base_type;
							_tmp365_ = vala_data_type_get_type_arguments (_tmp364_);
							_tmp366_ = _tmp365_;
							_tmp367_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp363_, _tmp366_, (ValaCodeNode*) expr, TRUE, _tmp367_);
							_vala_iterable_unref0 (_tmp366_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp368_;
				ValaSymbol* _tmp369_;
				ValaSymbol* _tmp370_;
				ValaClass* _tmp371_;
				type_param_index = 0;
				_tmp368_ = m;
				_tmp369_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp368_);
				_tmp370_ = _tmp369_;
				_tmp371_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp370_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp371_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp372_;
					ValaList* _tmp373_;
					gint _type_param_size = 0;
					ValaList* _tmp374_;
					gint _tmp375_;
					gint _tmp376_;
					gint _type_param_index = 0;
					_tmp372_ = cl;
					_tmp373_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp372_);
					_type_param_list = _tmp373_;
					_tmp374_ = _type_param_list;
					_tmp375_ = vala_collection_get_size ((ValaCollection*) _tmp374_);
					_tmp376_ = _tmp375_;
					_type_param_size = _tmp376_;
					_type_param_index = -1;
					while (TRUE) {
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp377_;
						gpointer _tmp378_;
						ValaHashMap* _tmp379_;
						ValaTypeParameter* _tmp380_;
						const gchar* _tmp381_;
						const gchar* _tmp382_;
						gchar* _tmp383_;
						gchar* _tmp384_;
						gchar* _tmp385_;
						gchar* _tmp386_;
						ValaCCodeIdentifier* _tmp387_;
						ValaCCodeIdentifier* _tmp388_;
						ValaHashMap* _tmp389_;
						ValaTypeParameter* _tmp390_;
						const gchar* _tmp391_;
						const gchar* _tmp392_;
						gchar* _tmp393_;
						gchar* _tmp394_;
						gchar* _tmp395_;
						gchar* _tmp396_;
						ValaCCodeIdentifier* _tmp397_;
						ValaCCodeIdentifier* _tmp398_;
						ValaHashMap* _tmp399_;
						ValaTypeParameter* _tmp400_;
						const gchar* _tmp401_;
						const gchar* _tmp402_;
						gchar* _tmp403_;
						gchar* _tmp404_;
						gchar* _tmp405_;
						gchar* _tmp406_;
						ValaCCodeIdentifier* _tmp407_;
						ValaCCodeIdentifier* _tmp408_;
						gint _tmp409_;
						_type_param_index = _type_param_index + 1;
						if (!(_type_param_index < _type_param_size)) {
							break;
						}
						_tmp377_ = _type_param_list;
						_tmp378_ = vala_list_get (_tmp377_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp378_;
						_tmp379_ = in_arg_map;
						_tmp380_ = type_param;
						_tmp381_ = vala_symbol_get_name ((ValaSymbol*) _tmp380_);
						_tmp382_ = _tmp381_;
						_tmp383_ = g_utf8_strdown (_tmp382_, (gssize) -1);
						_tmp384_ = _tmp383_;
						_tmp385_ = g_strdup_printf ("%s_type", _tmp384_);
						_tmp386_ = _tmp385_;
						_tmp387_ = vala_ccode_identifier_new (_tmp386_);
						_tmp388_ = _tmp387_;
						vala_map_set ((ValaMap*) _tmp379_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp388_);
						_vala_ccode_node_unref0 (_tmp388_);
						_g_free0 (_tmp386_);
						_g_free0 (_tmp384_);
						_tmp389_ = in_arg_map;
						_tmp390_ = type_param;
						_tmp391_ = vala_symbol_get_name ((ValaSymbol*) _tmp390_);
						_tmp392_ = _tmp391_;
						_tmp393_ = g_utf8_strdown (_tmp392_, (gssize) -1);
						_tmp394_ = _tmp393_;
						_tmp395_ = g_strdup_printf ("%s_dup_func", _tmp394_);
						_tmp396_ = _tmp395_;
						_tmp397_ = vala_ccode_identifier_new (_tmp396_);
						_tmp398_ = _tmp397_;
						vala_map_set ((ValaMap*) _tmp389_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp398_);
						_vala_ccode_node_unref0 (_tmp398_);
						_g_free0 (_tmp396_);
						_g_free0 (_tmp394_);
						_tmp399_ = in_arg_map;
						_tmp400_ = type_param;
						_tmp401_ = vala_symbol_get_name ((ValaSymbol*) _tmp400_);
						_tmp402_ = _tmp401_;
						_tmp403_ = g_utf8_strdown (_tmp402_, (gssize) -1);
						_tmp404_ = _tmp403_;
						_tmp405_ = g_strdup_printf ("%s_destroy_func", _tmp404_);
						_tmp406_ = _tmp405_;
						_tmp407_ = vala_ccode_identifier_new (_tmp406_);
						_tmp408_ = _tmp407_;
						vala_map_set ((ValaMap*) _tmp399_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp408_);
						_vala_ccode_node_unref0 (_tmp408_);
						_g_free0 (_tmp406_);
						_g_free0 (_tmp404_);
						_tmp409_ = type_param_index;
						type_param_index = _tmp409_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp410_;
			ValaClass* _tmp411_;
			ValaClass* _tmp412_;
			ValaClass* _tmp413_;
			ValaClass* _tmp414_;
			_tmp410_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp411_ = _tmp410_;
			_tmp412_ = vala_class_get_base_class (_tmp411_);
			_tmp413_ = _tmp412_;
			_tmp414_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp413_ == _tmp414_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp415_;
				ValaClass* _tmp416_;
				gchar* _tmp417_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp418_;
				ValaCCodeDeclaration* _tmp419_;
				ValaCCodeDeclaration* _tmp420_;
				const gchar* _tmp421_;
				const gchar* _tmp422_;
				const gchar* _tmp423_;
				const gchar* _tmp424_;
				gchar* _tmp425_;
				gchar* _tmp426_;
				ValaCCodeConstant* _tmp427_;
				ValaCCodeConstant* _tmp428_;
				ValaCCodeVariableDeclarator* _tmp429_;
				ValaCCodeVariableDeclarator* _tmp430_;
				ValaCCodeFunction* _tmp431_;
				ValaCCodeFunction* _tmp432_;
				ValaCCodeDeclaration* _tmp433_;
				ValaCCodeFunctionCall* _tmp434_;
				ValaCCodeIdentifier* _tmp435_;
				ValaCCodeIdentifier* _tmp436_;
				ValaCCodeUnaryExpression* _tmp437_;
				ValaCCodeUnaryExpression* _tmp438_;
				ValaCCodeCastExpression* _tmp439_;
				ValaCCodeCastExpression* _tmp440_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp441_;
				ValaCCodeIdentifier* _tmp442_;
				ValaCCodeFunctionCall* _tmp443_;
				ValaCCodeFunctionCall* _tmp444_;
				ValaCCodeFunctionCall* _tmp445_;
				ValaClass* _tmp446_;
				ValaClass* _tmp447_;
				gchar* _tmp448_;
				gchar* _tmp449_;
				ValaCCodeIdentifier* _tmp450_;
				ValaCCodeIdentifier* _tmp451_;
				ValaCCodeFunctionCall* _tmp452_;
				ValaCCodeFunctionCall* _tmp453_;
				_tmp415_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp416_ = _tmp415_;
				_tmp417_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp416_, NULL);
				class_prefix = _tmp417_;
				_tmp418_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp418_;
				_tmp419_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp419_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp420_ = funcs;
				_tmp421_ = class_prefix;
				_tmp422_ = class_prefix;
				_tmp423_ = class_prefix;
				_tmp424_ = class_prefix;
				_tmp425_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp421_, _tmp422_, _tmp423_, _tmp424_);
				_tmp426_ = _tmp425_;
				_tmp427_ = vala_ccode_constant_new (_tmp426_);
				_tmp428_ = _tmp427_;
				_tmp429_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp428_, NULL);
				_tmp430_ = _tmp429_;
				vala_ccode_declaration_add_declarator (_tmp420_, (ValaCCodeDeclarator*) _tmp430_);
				_vala_ccode_node_unref0 (_tmp430_);
				_vala_ccode_node_unref0 (_tmp428_);
				_g_free0 (_tmp426_);
				_tmp431_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp432_ = _tmp431_;
				_tmp433_ = funcs;
				vala_ccode_function_add_statement (_tmp432_, (ValaCCodeNode*) _tmp433_);
				_tmp434_ = ccall;
				_tmp435_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp436_ = _tmp435_;
				_tmp437_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp436_);
				_tmp438_ = _tmp437_;
				_tmp439_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp438_, "GSourceFuncs *");
				_tmp440_ = _tmp439_;
				vala_ccode_function_call_add_argument (_tmp434_, (ValaCCodeExpression*) _tmp440_);
				_vala_ccode_node_unref0 (_tmp440_);
				_vala_ccode_node_unref0 (_tmp438_);
				_vala_ccode_node_unref0 (_tmp436_);
				_tmp441_ = vala_ccode_identifier_new ("sizeof");
				_tmp442_ = _tmp441_;
				_tmp443_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp442_);
				_tmp444_ = _tmp443_;
				_vala_ccode_node_unref0 (_tmp442_);
				csizeof = _tmp444_;
				_tmp445_ = csizeof;
				_tmp446_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp447_ = _tmp446_;
				_tmp448_ = vala_get_ccode_name ((ValaCodeNode*) _tmp447_);
				_tmp449_ = _tmp448_;
				_tmp450_ = vala_ccode_identifier_new (_tmp449_);
				_tmp451_ = _tmp450_;
				vala_ccode_function_call_add_argument (_tmp445_, (ValaCCodeExpression*) _tmp451_);
				_vala_ccode_node_unref0 (_tmp451_);
				_g_free0 (_tmp449_);
				_tmp452_ = ccall;
				_tmp453_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp452_, (ValaCCodeExpression*) _tmp453_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp454_ = FALSE;
		ValaMethod* _tmp455_;
		_tmp455_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp455_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp456_;
			ValaSymbol* _tmp457_;
			ValaSymbol* _tmp458_;
			_tmp456_ = m;
			_tmp457_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp456_);
			_tmp458_ = _tmp457_;
			_tmp454_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp458_, VALA_TYPE_STRUCT);
		} else {
			_tmp454_ = FALSE;
		}
		if (_tmp454_) {
			ValaCCodeFunctionCall* _tmp459_;
			ValaCCodeExpression* _tmp460_;
			ValaCCodeExpression* _tmp461_;
			_tmp459_ = ccall;
			_tmp460_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp461_ = _tmp460_;
			vala_ccode_function_call_add_argument (_tmp459_, _tmp461_);
			_vala_ccode_node_unref0 (_tmp461_);
		} else {
			gboolean _tmp462_ = FALSE;
			gboolean _tmp463_ = FALSE;
			gboolean _tmp464_ = FALSE;
			gboolean _tmp465_ = FALSE;
			ValaMethod* _tmp466_;
			_tmp466_ = m;
			if (_tmp466_ != NULL) {
				ValaMethod* _tmp467_;
				_tmp467_ = m;
				_tmp465_ = vala_method_has_type_parameters (_tmp467_);
			} else {
				_tmp465_ = FALSE;
			}
			if (_tmp465_) {
				ValaMethod* _tmp468_;
				_tmp468_ = m;
				_tmp464_ = !vala_get_ccode_has_generic_type_parameter (_tmp468_);
			} else {
				_tmp464_ = FALSE;
			}
			if (_tmp464_) {
				ValaMethod* _tmp469_;
				_tmp469_ = m;
				_tmp463_ = !vala_get_ccode_simple_generics (_tmp469_);
			} else {
				_tmp463_ = FALSE;
			}
			if (_tmp463_) {
				gboolean _tmp470_ = FALSE;
				ValaCCodeFunctionCall* _tmp471_;
				ValaCCodeFunctionCall* _tmp472_;
				_tmp471_ = ccall;
				_tmp472_ = finish_call;
				if (_tmp471_ != _tmp472_) {
					_tmp470_ = TRUE;
				} else {
					gboolean _tmp473_;
					gboolean _tmp474_;
					_tmp473_ = vala_method_call_get_is_yield_expression (expr);
					_tmp474_ = _tmp473_;
					_tmp470_ = _tmp474_;
				}
				_tmp462_ = _tmp470_;
			} else {
				_tmp462_ = FALSE;
			}
			if (_tmp462_) {
				ValaHashMap* _tmp475_;
				ValaMemberAccess* _tmp476_;
				ValaList* _tmp477_;
				ValaList* _tmp478_;
				_tmp475_ = in_arg_map;
				_tmp476_ = ma;
				_tmp477_ = vala_member_access_get_type_arguments (_tmp476_);
				_tmp478_ = _tmp477_;
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp475_, _tmp478_, (ValaCodeNode*) expr, FALSE, NULL);
				_vala_iterable_unref0 (_tmp478_);
			}
		}
	}
	_tmp479_ = ccall;
	_tmp480_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp479_);
	ccall_expr = _tmp480_;
	_tmp481_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp481_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp482_;
		ValaExpression* _tmp483_;
		ValaExpression* _tmp484_;
		ValaDataType* _tmp485_;
		ValaDataType* _tmp486_;
		ValaArrayType* _tmp487_;
		ValaHashMap* _tmp488_;
		ValaArrayType* _tmp489_;
		ValaDataType* _tmp490_;
		ValaDataType* _tmp491_;
		gchar* _tmp492_;
		gchar* _tmp493_;
		ValaCCodeIdentifier* _tmp494_;
		ValaCCodeIdentifier* _tmp495_;
		_tmp482_ = ma;
		_tmp483_ = vala_member_access_get_inner (_tmp482_);
		_tmp484_ = _tmp483_;
		_tmp485_ = vala_expression_get_value_type (_tmp484_);
		_tmp486_ = _tmp485_;
		_tmp487_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp486_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp487_;
		_tmp488_ = in_arg_map;
		_tmp489_ = array_type;
		_tmp490_ = vala_array_type_get_element_type (_tmp489_);
		_tmp491_ = _tmp490_;
		_tmp492_ = vala_get_ccode_name ((ValaCodeNode*) _tmp491_);
		_tmp493_ = _tmp492_;
		_tmp494_ = vala_ccode_identifier_new (_tmp493_);
		_tmp495_ = _tmp494_;
		vala_map_set ((ValaMap*) _tmp488_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp495_);
		_vala_ccode_node_unref0 (_tmp495_);
		_g_free0 (_tmp493_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp496_;
		_tmp496_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp496_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp497_;
			_tmp497_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp497_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp498_;
				ValaExpression* _tmp499_;
				ValaExpression* _tmp500_;
				ValaTargetValue* _tmp501_;
				ValaTargetValue* _tmp502_;
				ValaTargetValue* _tmp503_;
				ValaTargetValue* _tmp504_;
				_tmp498_ = ma;
				_tmp499_ = vala_member_access_get_inner (_tmp498_);
				_tmp500_ = _tmp499_;
				_tmp501_ = vala_expression_get_target_value (_tmp500_);
				_tmp502_ = _tmp501_;
				_tmp503_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp502_, (ValaCodeNode*) expr);
				_tmp504_ = _tmp503_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp504_);
				_vala_target_value_unref0 (_tmp504_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp506_ = m;
	if (_tmp506_ != NULL) {
		ValaMethod* _tmp507_;
		gboolean _tmp508_;
		gboolean _tmp509_;
		_tmp507_ = m;
		_tmp508_ = vala_method_get_is_async_callback (_tmp507_);
		_tmp509_ = _tmp508_;
		_tmp505_ = _tmp509_;
	} else {
		_tmp505_ = FALSE;
	}
	if (_tmp505_) {
		ValaMethod* _tmp510_;
		ValaMethod* _tmp511_;
		gboolean _tmp512_;
		gboolean _tmp513_;
		ValaHashMap* _tmp527_;
		ValaMethod* _tmp528_;
		ValaCCodeExpression* _tmp529_;
		ValaHashMap* _tmp530_;
		ValaMethod* _tmp531_;
		ValaCCodeExpression* _tmp532_;
		_tmp510_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp511_ = _tmp510_;
		_tmp512_ = vala_method_get_closure (_tmp511_);
		_tmp513_ = _tmp512_;
		if (_tmp513_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp514_;
			ValaSymbol* _tmp515_;
			ValaSymbol* _tmp516_;
			ValaBlock* _tmp517_;
			ValaBlock* _tmp518_;
			ValaBlock* _tmp519_;
			ValaBlock* _tmp520_;
			gchar* _tmp521_;
			gchar* _tmp522_;
			ValaCCodeExpression* _tmp523_;
			ValaCCodeExpression* _tmp524_;
			ValaCCodeMemberAccess* _tmp525_;
			_tmp514_ = m;
			_tmp515_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp514_);
			_tmp516_ = _tmp515_;
			_tmp517_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp516_, VALA_TYPE_METHOD, ValaMethod));
			_tmp518_ = _tmp517_;
			_tmp519_ = _vala_code_node_ref0 (_tmp518_);
			block = _tmp519_;
			_tmp520_ = block;
			_tmp521_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp520_));
			_tmp522_ = _tmp521_;
			_tmp523_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp522_);
			_tmp524_ = _tmp523_;
			_tmp525_ = vala_ccode_member_access_new_pointer (_tmp524_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp525_;
			_vala_ccode_node_unref0 (_tmp524_);
			_g_free0 (_tmp522_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp526_;
			_tmp526_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp526_;
		}
		_tmp527_ = in_arg_map;
		_tmp528_ = m;
		_tmp529_ = instance;
		vala_map_set ((ValaMap*) _tmp527_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp528_), FALSE)), _tmp529_);
		_tmp530_ = out_arg_map;
		_tmp531_ = m;
		_tmp532_ = instance;
		vala_map_set ((ValaMap*) _tmp530_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp531_), FALSE)), _tmp532_);
	} else {
		gboolean _tmp533_ = FALSE;
		gboolean _tmp534_ = FALSE;
		ValaMethod* _tmp535_;
		_tmp535_ = m;
		if (_tmp535_ != NULL) {
			ValaMethod* _tmp536_;
			ValaMemberBinding _tmp537_;
			ValaMemberBinding _tmp538_;
			_tmp536_ = m;
			_tmp537_ = vala_method_get_binding (_tmp536_);
			_tmp538_ = _tmp537_;
			_tmp534_ = _tmp538_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp534_ = FALSE;
		}
		if (_tmp534_) {
			ValaMethod* _tmp539_;
			_tmp539_ = m;
			_tmp533_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp539_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp533_ = FALSE;
		}
		if (_tmp533_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp540_;
			ValaExpression* _tmp541_;
			ValaExpression* _tmp542_;
			ValaTargetValue* _tmp543_;
			ValaTargetValue* _tmp544_;
			ValaTargetValue* _tmp545_;
			gboolean _tmp546_ = FALSE;
			gboolean _tmp547_ = FALSE;
			ValaMemberAccess* _tmp548_;
			const gchar* _tmp549_;
			const gchar* _tmp550_;
			ValaTargetValue* _tmp572_;
			ValaCCodeExpression* _tmp573_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp574_;
			ValaSymbol* _tmp575_;
			ValaSymbol* _tmp576_;
			ValaStruct* _tmp577_;
			gboolean _tmp578_ = FALSE;
			ValaStruct* _tmp579_;
			gboolean _tmp588_;
			gboolean _tmp589_;
			_tmp540_ = ma;
			_tmp541_ = vala_member_access_get_inner (_tmp540_);
			_tmp542_ = _tmp541_;
			_tmp543_ = vala_expression_get_target_value (_tmp542_);
			_tmp544_ = _tmp543_;
			_tmp545_ = _vala_target_value_ref0 (_tmp544_);
			instance_value = _tmp545_;
			_tmp548_ = ma;
			_tmp549_ = vala_member_access_get_member_name (_tmp548_);
			_tmp550_ = _tmp549_;
			if (g_strcmp0 (_tmp550_, "begin") == 0) {
				_tmp547_ = TRUE;
			} else {
				ValaMemberAccess* _tmp551_;
				const gchar* _tmp552_;
				const gchar* _tmp553_;
				_tmp551_ = ma;
				_tmp552_ = vala_member_access_get_member_name (_tmp551_);
				_tmp553_ = _tmp552_;
				_tmp547_ = g_strcmp0 (_tmp553_, "end") == 0;
			}
			if (_tmp547_) {
				ValaMemberAccess* _tmp554_;
				ValaExpression* _tmp555_;
				ValaExpression* _tmp556_;
				ValaSymbol* _tmp557_;
				ValaSymbol* _tmp558_;
				ValaMemberAccess* _tmp559_;
				ValaSymbol* _tmp560_;
				ValaSymbol* _tmp561_;
				_tmp554_ = ma;
				_tmp555_ = vala_member_access_get_inner (_tmp554_);
				_tmp556_ = _tmp555_;
				_tmp557_ = vala_expression_get_symbol_reference (_tmp556_);
				_tmp558_ = _tmp557_;
				_tmp559_ = ma;
				_tmp560_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp559_);
				_tmp561_ = _tmp560_;
				_tmp546_ = _tmp558_ == _tmp561_;
			} else {
				_tmp546_ = FALSE;
			}
			if (_tmp546_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp562_;
				ValaExpression* _tmp563_;
				ValaExpression* _tmp564_;
				ValaMemberAccess* _tmp565_;
				ValaMemberAccess* _tmp566_;
				ValaExpression* _tmp567_;
				ValaExpression* _tmp568_;
				ValaTargetValue* _tmp569_;
				ValaTargetValue* _tmp570_;
				ValaTargetValue* _tmp571_;
				_tmp562_ = ma;
				_tmp563_ = vala_member_access_get_inner (_tmp562_);
				_tmp564_ = _tmp563_;
				_tmp565_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp564_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp565_;
				_tmp566_ = inner_ma;
				_tmp567_ = vala_member_access_get_inner (_tmp566_);
				_tmp568_ = _tmp567_;
				_tmp569_ = vala_expression_get_target_value (_tmp568_);
				_tmp570_ = _tmp569_;
				_tmp571_ = _vala_target_value_ref0 (_tmp570_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp571_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp572_ = instance_value;
			_tmp573_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp572_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp573_;
			_tmp574_ = m;
			_tmp575_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp574_);
			_tmp576_ = _tmp575_;
			_tmp577_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp576_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp576_) : NULL);
			st = _tmp577_;
			_tmp579_ = st;
			if (_tmp579_ != NULL) {
				ValaStruct* _tmp580_;
				_tmp580_ = st;
				_tmp578_ = !vala_struct_is_simple_type (_tmp580_);
			} else {
				_tmp578_ = FALSE;
			}
			if (_tmp578_) {
				ValaTargetValue* _tmp581_;
				ValaTargetValue* _tmp584_;
				ValaCCodeExpression* _tmp585_;
				ValaCCodeExpression* _tmp586_;
				ValaCCodeUnaryExpression* _tmp587_;
				_tmp581_ = instance_value;
				if (!vala_ccode_base_module_get_lvalue ((ValaCCodeBaseModule*) self, _tmp581_)) {
					ValaTargetValue* _tmp582_;
					ValaTargetValue* _tmp583_;
					_tmp582_ = instance_value;
					_tmp583_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp582_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp583_;
				}
				_tmp584_ = instance_value;
				_tmp585_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp584_);
				_tmp586_ = _tmp585_;
				_tmp587_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp586_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp587_;
				_vala_ccode_node_unref0 (_tmp586_);
			}
			_tmp588_ = vala_method_call_get_is_yield_expression (expr);
			_tmp589_ = _tmp588_;
			if (_tmp589_) {
				ValaHashMap* _tmp590_;
				ValaMethod* _tmp591_;
				ValaCCodeExpression* _tmp592_;
				ValaMethod* _tmp593_;
				_tmp590_ = in_arg_map;
				_tmp591_ = m;
				_tmp592_ = instance;
				vala_map_set ((ValaMap*) _tmp590_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp591_), FALSE)), _tmp592_);
				_tmp593_ = m;
				if (vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp593_)) {
					ValaHashMap* _tmp594_;
					ValaMethod* _tmp595_;
					ValaCCodeExpression* _tmp596_;
					_tmp594_ = out_arg_map;
					_tmp595_ = m;
					_tmp596_ = instance;
					vala_map_set ((ValaMap*) _tmp594_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp595_), FALSE)), _tmp596_);
				}
			} else {
				gboolean _tmp597_ = FALSE;
				ValaMemberAccess* _tmp598_;
				const gchar* _tmp599_;
				const gchar* _tmp600_;
				_tmp598_ = ma;
				_tmp599_ = vala_member_access_get_member_name (_tmp598_);
				_tmp600_ = _tmp599_;
				if (g_strcmp0 (_tmp600_, "end") != 0) {
					_tmp597_ = TRUE;
				} else {
					ValaMethod* _tmp601_;
					_tmp601_ = m;
					_tmp597_ = vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp601_);
				}
				if (_tmp597_) {
					ValaHashMap* _tmp602_;
					ValaMethod* _tmp603_;
					ValaCCodeExpression* _tmp604_;
					ValaHashMap* _tmp605_;
					ValaMethod* _tmp606_;
					ValaCCodeExpression* _tmp607_;
					_tmp602_ = out_arg_map;
					_tmp603_ = m;
					_tmp604_ = instance;
					vala_map_set ((ValaMap*) _tmp602_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp603_), FALSE)), _tmp604_);
					_tmp605_ = in_arg_map;
					_tmp606_ = m;
					_tmp607_ = instance;
					vala_map_set ((ValaMap*) _tmp605_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp606_), FALSE)), _tmp607_);
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp608_ = FALSE;
			ValaMethod* _tmp609_;
			_tmp609_ = m;
			if (_tmp609_ != NULL) {
				ValaMethod* _tmp610_;
				ValaMemberBinding _tmp611_;
				ValaMemberBinding _tmp612_;
				_tmp610_ = m;
				_tmp611_ = vala_method_get_binding (_tmp610_);
				_tmp612_ = _tmp611_;
				_tmp608_ = _tmp612_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp608_ = FALSE;
			}
			if (_tmp608_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp613_;
				ValaSymbol* _tmp614_;
				ValaSymbol* _tmp615_;
				ValaClass* _tmp616_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp617_;
				gchar* _tmp618_;
				gchar* _tmp619_;
				ValaCCodeIdentifier* _tmp620_;
				ValaCCodeIdentifier* _tmp621_;
				ValaCCodeFunctionCall* _tmp622_;
				ValaCCodeFunctionCall* _tmp623_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp624_;
				ValaExpression* _tmp625_;
				ValaExpression* _tmp626_;
				ValaCCodeFunctionCall* _tmp652_;
				ValaCCodeExpression* _tmp653_;
				ValaHashMap* _tmp654_;
				ValaMethod* _tmp655_;
				ValaCCodeFunctionCall* _tmp656_;
				ValaHashMap* _tmp657_;
				ValaMethod* _tmp658_;
				ValaCCodeFunctionCall* _tmp659_;
				_tmp613_ = m;
				_tmp614_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp613_);
				_tmp615_ = _tmp614_;
				_tmp616_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp615_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp616_;
				_tmp617_ = cl;
				_tmp618_ = vala_get_ccode_class_type_function (_tmp617_);
				_tmp619_ = _tmp618_;
				_tmp620_ = vala_ccode_identifier_new (_tmp619_);
				_tmp621_ = _tmp620_;
				_tmp622_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp621_);
				_tmp623_ = _tmp622_;
				_vala_ccode_node_unref0 (_tmp621_);
				_g_free0 (_tmp619_);
				cast = _tmp623_;
				_tmp624_ = ma;
				_tmp625_ = vala_member_access_get_inner (_tmp624_);
				_tmp626_ = _tmp625_;
				if (_tmp626_ == NULL) {
					ValaDataType* _tmp627_;
					ValaDataType* _tmp628_;
					gboolean _tmp629_;
					_tmp627_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					_tmp628_ = _tmp627_;
					_tmp629_ = _tmp628_ == NULL;
					_vala_code_node_unref0 (_tmp628_);
					if (_tmp629_) {
						ValaCCodeIdentifier* _tmp630_;
						_tmp630_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp630_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp631_;
						ValaCCodeIdentifier* _tmp632_;
						ValaCCodeFunctionCall* _tmp633_;
						ValaCCodeFunctionCall* _tmp634_;
						ValaCCodeFunctionCall* _tmp635_;
						ValaCCodeExpression* _tmp636_;
						ValaCCodeExpression* _tmp637_;
						ValaCCodeFunctionCall* _tmp638_;
						ValaCCodeExpression* _tmp639_;
						_tmp631_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp632_ = _tmp631_;
						_tmp633_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp632_);
						_tmp634_ = _tmp633_;
						_vala_ccode_node_unref0 (_tmp632_);
						k = _tmp634_;
						_tmp635_ = k;
						_tmp636_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp637_ = _tmp636_;
						vala_ccode_function_call_add_argument (_tmp635_, _tmp637_);
						_vala_ccode_node_unref0 (_tmp637_);
						_tmp638_ = k;
						_tmp639_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp638_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp639_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp640_;
					ValaCCodeIdentifier* _tmp641_;
					ValaCCodeFunctionCall* _tmp642_;
					ValaCCodeFunctionCall* _tmp643_;
					ValaCCodeFunctionCall* _tmp644_;
					ValaMemberAccess* _tmp645_;
					ValaExpression* _tmp646_;
					ValaExpression* _tmp647_;
					ValaCCodeExpression* _tmp648_;
					ValaCCodeExpression* _tmp649_;
					ValaCCodeFunctionCall* _tmp650_;
					ValaCCodeExpression* _tmp651_;
					_tmp640_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp641_ = _tmp640_;
					_tmp642_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp641_);
					_tmp643_ = _tmp642_;
					_vala_ccode_node_unref0 (_tmp641_);
					k = _tmp643_;
					_tmp644_ = k;
					_tmp645_ = ma;
					_tmp646_ = vala_member_access_get_inner (_tmp645_);
					_tmp647_ = _tmp646_;
					_tmp648_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp647_);
					_tmp649_ = _tmp648_;
					vala_ccode_function_call_add_argument (_tmp644_, _tmp649_);
					_vala_ccode_node_unref0 (_tmp649_);
					_tmp650_ = k;
					_tmp651_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp650_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp651_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp652_ = cast;
				_tmp653_ = klass;
				vala_ccode_function_call_add_argument (_tmp652_, _tmp653_);
				_tmp654_ = in_arg_map;
				_tmp655_ = m;
				_tmp656_ = cast;
				vala_map_set ((ValaMap*) _tmp654_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp655_), FALSE)), (ValaCCodeExpression*) _tmp656_);
				_tmp657_ = out_arg_map;
				_tmp658_ = m;
				_tmp659_ = cast;
				vala_map_set ((ValaMap*) _tmp657_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp658_), FALSE)), (ValaCCodeExpression*) _tmp659_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp661_ = m;
	if (_tmp661_ != NULL) {
		ValaMethod* _tmp662_;
		_tmp662_ = m;
		_tmp660_ = vala_get_ccode_has_generic_type_parameter (_tmp662_);
	} else {
		_tmp660_ = FALSE;
	}
	if (_tmp660_) {
		ValaMethod* _tmp663_;
		_tmp663_ = m;
		if (vala_method_has_type_parameters (_tmp663_)) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp664_;
				ValaList* _tmp665_;
				gint _type_arg_size = 0;
				ValaList* _tmp666_;
				gint _tmp667_;
				gint _tmp668_;
				gint _type_arg_index = 0;
				_tmp664_ = ma;
				_tmp665_ = vala_member_access_get_type_arguments (_tmp664_);
				_type_arg_list = _tmp665_;
				_tmp666_ = _type_arg_list;
				_tmp667_ = vala_collection_get_size ((ValaCollection*) _tmp666_);
				_tmp668_ = _tmp667_;
				_type_arg_size = _tmp668_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp669_;
					gpointer _tmp670_;
					ValaHashMap* _tmp671_;
					ValaMethod* _tmp672_;
					ValaDataType* _tmp673_;
					gchar* _tmp674_;
					gchar* _tmp675_;
					ValaCCodeIdentifier* _tmp676_;
					ValaCCodeIdentifier* _tmp677_;
					gint _tmp678_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp669_ = _type_arg_list;
					_tmp670_ = vala_list_get (_tmp669_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp670_;
					_tmp671_ = in_arg_map;
					_tmp672_ = m;
					_tmp673_ = type_arg;
					_tmp674_ = vala_get_ccode_name ((ValaCodeNode*) _tmp673_);
					_tmp675_ = _tmp674_;
					_tmp676_ = vala_ccode_identifier_new (_tmp675_);
					_tmp677_ = _tmp676_;
					vala_map_set ((ValaMap*) _tmp671_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp672_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp677_);
					_vala_ccode_node_unref0 (_tmp677_);
					_g_free0 (_tmp675_);
					_tmp678_ = type_param_index;
					type_param_index = _tmp678_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp679_;
				ValaExpression* _tmp680_;
				ValaExpression* _tmp681_;
				ValaDataType* _tmp682_;
				ValaDataType* _tmp683_;
				ValaList* _tmp684_;
				gint _type_arg_size = 0;
				ValaList* _tmp685_;
				gint _tmp686_;
				gint _tmp687_;
				gint _type_arg_index = 0;
				_tmp679_ = ma;
				_tmp680_ = vala_member_access_get_inner (_tmp679_);
				_tmp681_ = _tmp680_;
				_tmp682_ = vala_expression_get_value_type (_tmp681_);
				_tmp683_ = _tmp682_;
				_tmp684_ = vala_data_type_get_type_arguments (_tmp683_);
				_type_arg_list = _tmp684_;
				_tmp685_ = _type_arg_list;
				_tmp686_ = vala_collection_get_size ((ValaCollection*) _tmp685_);
				_tmp687_ = _tmp686_;
				_type_arg_size = _tmp687_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp688_;
					gpointer _tmp689_;
					ValaHashMap* _tmp690_;
					ValaMethod* _tmp691_;
					ValaDataType* _tmp692_;
					gchar* _tmp693_;
					gchar* _tmp694_;
					ValaCCodeIdentifier* _tmp695_;
					ValaCCodeIdentifier* _tmp696_;
					gint _tmp697_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp688_ = _type_arg_list;
					_tmp689_ = vala_list_get (_tmp688_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp689_;
					_tmp690_ = in_arg_map;
					_tmp691_ = m;
					_tmp692_ = type_arg;
					_tmp693_ = vala_get_ccode_name ((ValaCodeNode*) _tmp692_);
					_tmp694_ = _tmp693_;
					_tmp695_ = vala_ccode_identifier_new (_tmp694_);
					_tmp696_ = _tmp695_;
					vala_map_set ((ValaMap*) _tmp690_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp691_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp696_);
					_vala_ccode_node_unref0 (_tmp696_);
					_g_free0 (_tmp694_);
					_tmp697_ = type_param_index;
					type_param_index = _tmp697_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp698_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp698_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp699_;
		ValaExpression* _tmp700_;
		ValaExpression* _tmp701_;
		ValaDataType* _tmp702_;
		ValaDataType* _tmp703_;
		ValaArrayType* _tmp704_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp705_;
		ValaCCodeIdentifier* _tmp706_;
		ValaCCodeFunctionCall* _tmp707_;
		ValaCCodeFunctionCall* _tmp708_;
		ValaCCodeFunctionCall* _tmp709_;
		ValaArrayType* _tmp710_;
		ValaDataType* _tmp711_;
		ValaDataType* _tmp712_;
		gchar* _tmp713_;
		gchar* _tmp714_;
		ValaCCodeIdentifier* _tmp715_;
		ValaCCodeIdentifier* _tmp716_;
		ValaHashMap* _tmp717_;
		ValaCCodeFunctionCall* _tmp718_;
		_tmp699_ = ma;
		_tmp700_ = vala_member_access_get_inner (_tmp699_);
		_tmp701_ = _tmp700_;
		_tmp702_ = vala_expression_get_value_type (_tmp701_);
		_tmp703_ = _tmp702_;
		_tmp704_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp703_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp704_;
		_tmp705_ = vala_ccode_identifier_new ("sizeof");
		_tmp706_ = _tmp705_;
		_tmp707_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp706_);
		_tmp708_ = _tmp707_;
		_vala_ccode_node_unref0 (_tmp706_);
		csizeof = _tmp708_;
		_tmp709_ = csizeof;
		_tmp710_ = array_type;
		_tmp711_ = vala_array_type_get_element_type (_tmp710_);
		_tmp712_ = _tmp711_;
		_tmp713_ = vala_get_ccode_name ((ValaCodeNode*) _tmp712_);
		_tmp714_ = _tmp713_;
		_tmp715_ = vala_ccode_identifier_new (_tmp714_);
		_tmp716_ = _tmp715_;
		vala_ccode_function_call_add_argument (_tmp709_, (ValaCCodeExpression*) _tmp716_);
		_vala_ccode_node_unref0 (_tmp716_);
		_g_free0 (_tmp714_);
		_tmp717_ = in_arg_map;
		_tmp718_ = csizeof;
		vala_map_set ((ValaMap*) _tmp717_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp718_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp719_;
		_tmp719_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp719_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaMethod* _tmp720_;
			gint param_nr = 0;
			ValaMethod* _tmp780_;
			_tmp720_ = m;
			vala_method_clear_parameters (_tmp720_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp721_;
				gint _arg_size = 0;
				ValaList* _tmp722_;
				gint _tmp723_;
				gint _tmp724_;
				gint _arg_index = 0;
				_tmp721_ = vala_method_call_get_argument_list (expr);
				_arg_list = _tmp721_;
				_tmp722_ = _arg_list;
				_tmp723_ = vala_collection_get_size ((ValaCollection*) _tmp722_);
				_tmp724_ = _tmp723_;
				_arg_size = _tmp724_;
				_arg_index = -1;
				while (TRUE) {
					ValaExpression* arg = NULL;
					ValaList* _tmp725_;
					gpointer _tmp726_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp727_;
					ValaUnaryExpression* _tmp728_;
					gboolean _tmp729_ = FALSE;
					ValaUnaryExpression* _tmp730_;
					gint _tmp771_;
					_arg_index = _arg_index + 1;
					if (!(_arg_index < _arg_size)) {
						break;
					}
					_tmp725_ = _arg_list;
					_tmp726_ = vala_list_get (_tmp725_, _arg_index);
					arg = (ValaExpression*) _tmp726_;
					_tmp727_ = arg;
					_tmp728_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp727_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp727_) : NULL);
					unary = _tmp728_;
					_tmp730_ = unary;
					if (_tmp730_ != NULL) {
						ValaUnaryExpression* _tmp731_;
						ValaUnaryOperator _tmp732_;
						ValaUnaryOperator _tmp733_;
						_tmp731_ = unary;
						_tmp732_ = vala_unary_expression_get_operator (_tmp731_);
						_tmp733_ = _tmp732_;
						_tmp729_ = _tmp733_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp729_ = FALSE;
					}
					if (_tmp729_) {
						ValaParameter* param = NULL;
						gchar* _tmp734_;
						gchar* _tmp735_;
						ValaUnaryExpression* _tmp736_;
						ValaExpression* _tmp737_;
						ValaExpression* _tmp738_;
						ValaDataType* _tmp739_;
						ValaDataType* _tmp740_;
						ValaParameter* _tmp741_;
						ValaParameter* _tmp742_;
						ValaParameter* _tmp743_;
						ValaMethod* _tmp744_;
						ValaParameter* _tmp745_;
						_tmp734_ = g_strdup_printf ("param%d", param_nr);
						_tmp735_ = _tmp734_;
						_tmp736_ = unary;
						_tmp737_ = vala_unary_expression_get_inner (_tmp736_);
						_tmp738_ = _tmp737_;
						_tmp739_ = vala_expression_get_value_type (_tmp738_);
						_tmp740_ = _tmp739_;
						_tmp741_ = vala_parameter_new (_tmp735_, _tmp740_, NULL);
						_tmp742_ = _tmp741_;
						_g_free0 (_tmp735_);
						param = _tmp742_;
						_tmp743_ = param;
						vala_parameter_set_direction (_tmp743_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp744_ = m;
						_tmp745_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp744_, _tmp745_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp746_ = FALSE;
						ValaUnaryExpression* _tmp747_;
						_tmp747_ = unary;
						if (_tmp747_ != NULL) {
							ValaUnaryExpression* _tmp748_;
							ValaUnaryOperator _tmp749_;
							ValaUnaryOperator _tmp750_;
							_tmp748_ = unary;
							_tmp749_ = vala_unary_expression_get_operator (_tmp748_);
							_tmp750_ = _tmp749_;
							_tmp746_ = _tmp750_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp746_ = FALSE;
						}
						if (_tmp746_) {
							ValaParameter* param = NULL;
							gchar* _tmp751_;
							gchar* _tmp752_;
							ValaUnaryExpression* _tmp753_;
							ValaExpression* _tmp754_;
							ValaExpression* _tmp755_;
							ValaDataType* _tmp756_;
							ValaDataType* _tmp757_;
							ValaParameter* _tmp758_;
							ValaParameter* _tmp759_;
							ValaParameter* _tmp760_;
							ValaMethod* _tmp761_;
							ValaParameter* _tmp762_;
							_tmp751_ = g_strdup_printf ("param%d", param_nr);
							_tmp752_ = _tmp751_;
							_tmp753_ = unary;
							_tmp754_ = vala_unary_expression_get_inner (_tmp753_);
							_tmp755_ = _tmp754_;
							_tmp756_ = vala_expression_get_value_type (_tmp755_);
							_tmp757_ = _tmp756_;
							_tmp758_ = vala_parameter_new (_tmp752_, _tmp757_, NULL);
							_tmp759_ = _tmp758_;
							_g_free0 (_tmp752_);
							param = _tmp759_;
							_tmp760_ = param;
							vala_parameter_set_direction (_tmp760_, VALA_PARAMETER_DIRECTION_REF);
							_tmp761_ = m;
							_tmp762_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp761_, _tmp762_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp763_;
							gchar* _tmp764_;
							gchar* _tmp765_;
							ValaExpression* _tmp766_;
							ValaDataType* _tmp767_;
							ValaDataType* _tmp768_;
							ValaParameter* _tmp769_;
							ValaParameter* _tmp770_;
							_tmp763_ = m;
							_tmp764_ = g_strdup_printf ("param%d", param_nr);
							_tmp765_ = _tmp764_;
							_tmp766_ = arg;
							_tmp767_ = vala_expression_get_value_type (_tmp766_);
							_tmp768_ = _tmp767_;
							_tmp769_ = vala_parameter_new (_tmp765_, _tmp768_, NULL);
							_tmp770_ = _tmp769_;
							vala_callable_add_parameter ((ValaCallable*) _tmp763_, _tmp770_);
							_vala_code_node_unref0 (_tmp770_);
							_g_free0 (_tmp765_);
						}
					}
					_tmp771_ = param_nr;
					param_nr = _tmp771_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp772_;
				ValaList* _tmp773_;
				gint _param_size = 0;
				ValaList* _tmp774_;
				gint _tmp775_;
				gint _tmp776_;
				gint _param_index = 0;
				_tmp772_ = m;
				_tmp773_ = vala_callable_get_parameters ((ValaCallable*) _tmp772_);
				_param_list = _tmp773_;
				_tmp774_ = _param_list;
				_tmp775_ = vala_collection_get_size ((ValaCollection*) _tmp774_);
				_tmp776_ = _tmp775_;
				_param_size = _tmp776_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp777_;
					gpointer _tmp778_;
					ValaParameter* _tmp779_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp777_ = _param_list;
					_tmp778_ = vala_list_get (_tmp777_, _param_index);
					param = (ValaParameter*) _tmp778_;
					_tmp779_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp779_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp780_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp780_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
		} else {
			gboolean _tmp781_ = FALSE;
			gboolean _tmp782_ = FALSE;
			ValaMethod* _tmp783_;
			_tmp783_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp783_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp784_;
				ValaCodeContext* _tmp785_;
				ValaProfile _tmp786_;
				ValaProfile _tmp787_;
				_tmp784_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp785_ = _tmp784_;
				_tmp786_ = vala_code_context_get_profile (_tmp785_);
				_tmp787_ = _tmp786_;
				_tmp782_ = _tmp787_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp782_ = FALSE;
			}
			if (_tmp782_) {
				ValaMethod* _tmp788_;
				ValaSymbol* _tmp789_;
				ValaSymbol* _tmp790_;
				_tmp788_ = m;
				_tmp789_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp788_);
				_tmp790_ = _tmp789_;
				_tmp781_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp790_, VALA_TYPE_CLASS);
			} else {
				_tmp781_ = FALSE;
			}
			if (_tmp781_) {
				ValaCCodeFunction* _tmp791_;
				ValaCCodeFunction* _tmp792_;
				ValaCCodeExpression* _tmp793_;
				ValaCCodeExpression* _tmp794_;
				ValaCCodeFunctionCall* _tmp795_;
				ValaClass* _tmp796_;
				ValaClass* _tmp797_;
				gchar* _tmp798_;
				gchar* _tmp799_;
				gchar* _tmp800_;
				gchar* _tmp801_;
				ValaCCodeCastExpression* _tmp802_;
				ValaCCodeCastExpression* _tmp803_;
				ValaMethod* _tmp804_;
				ValaMethod* _tmp805_;
				ValaBlock* _tmp806_;
				ValaBlock* _tmp807_;
				gboolean _tmp808_;
				gboolean _tmp809_;
				gboolean _tmp836_ = FALSE;
				ValaClass* _tmp837_;
				ValaClass* _tmp838_;
				gboolean _tmp839_;
				gboolean _tmp840_;
				_tmp791_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp792_ = _tmp791_;
				_tmp793_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp794_ = _tmp793_;
				_tmp795_ = ccall;
				_tmp796_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp797_ = _tmp796_;
				_tmp798_ = vala_get_ccode_name ((ValaCodeNode*) _tmp797_);
				_tmp799_ = _tmp798_;
				_tmp800_ = g_strconcat (_tmp799_, "*", NULL);
				_tmp801_ = _tmp800_;
				_tmp802_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp795_, _tmp801_);
				_tmp803_ = _tmp802_;
				vala_ccode_function_add_assignment (_tmp792_, _tmp794_, (ValaCCodeExpression*) _tmp803_);
				_vala_ccode_node_unref0 (_tmp803_);
				_g_free0 (_tmp801_);
				_g_free0 (_tmp799_);
				_vala_ccode_node_unref0 (_tmp794_);
				_tmp804_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp805_ = _tmp804_;
				_tmp806_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp805_);
				_tmp807_ = _tmp806_;
				_tmp808_ = vala_block_get_captured (_tmp807_);
				_tmp809_ = _tmp808_;
				if (_tmp809_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp810_;
					ValaClass* _tmp811_;
					ValaObjectType* _tmp812_;
					ValaObjectType* _tmp813_;
					ValaSourceReference* _tmp814_;
					ValaSourceReference* _tmp815_;
					ValaCCodeExpression* _tmp816_;
					ValaCCodeExpression* _tmp817_;
					ValaCCodeFunctionCall* _tmp818_;
					ValaCCodeFunctionCall* _tmp819_;
					ValaCCodeFunctionCall* _tmp820_;
					ValaCCodeExpression* _tmp821_;
					ValaCCodeExpression* _tmp822_;
					ValaCCodeFunction* _tmp823_;
					ValaCCodeFunction* _tmp824_;
					ValaMethod* _tmp825_;
					ValaMethod* _tmp826_;
					ValaBlock* _tmp827_;
					ValaBlock* _tmp828_;
					gchar* _tmp829_;
					gchar* _tmp830_;
					ValaCCodeExpression* _tmp831_;
					ValaCCodeExpression* _tmp832_;
					ValaCCodeMemberAccess* _tmp833_;
					ValaCCodeMemberAccess* _tmp834_;
					ValaCCodeFunctionCall* _tmp835_;
					_tmp810_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp811_ = _tmp810_;
					_tmp812_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp811_);
					_tmp813_ = _tmp812_;
					_tmp814_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp815_ = _tmp814_;
					_tmp816_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp813_, _tmp815_, FALSE);
					_tmp817_ = _tmp816_;
					_tmp818_ = vala_ccode_function_call_new (_tmp817_);
					_tmp819_ = _tmp818_;
					_vala_ccode_node_unref0 (_tmp817_);
					_vala_code_node_unref0 (_tmp813_);
					ref_call = _tmp819_;
					_tmp820_ = ref_call;
					_tmp821_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp822_ = _tmp821_;
					vala_ccode_function_call_add_argument (_tmp820_, _tmp822_);
					_vala_ccode_node_unref0 (_tmp822_);
					_tmp823_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp824_ = _tmp823_;
					_tmp825_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp826_ = _tmp825_;
					_tmp827_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp826_);
					_tmp828_ = _tmp827_;
					_tmp829_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp828_));
					_tmp830_ = _tmp829_;
					_tmp831_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp830_);
					_tmp832_ = _tmp831_;
					_tmp833_ = vala_ccode_member_access_new_pointer (_tmp832_, "self");
					_tmp834_ = _tmp833_;
					_tmp835_ = ref_call;
					vala_ccode_function_add_assignment (_tmp824_, (ValaCCodeExpression*) _tmp834_, (ValaCCodeExpression*) _tmp835_);
					_vala_ccode_node_unref0 (_tmp834_);
					_vala_ccode_node_unref0 (_tmp832_);
					_g_free0 (_tmp830_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp837_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp838_ = _tmp837_;
				_tmp839_ = vala_class_get_is_compact (_tmp838_);
				_tmp840_ = _tmp839_;
				if (!_tmp840_) {
					ValaClass* _tmp841_;
					ValaClass* _tmp842_;
					_tmp841_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp842_ = _tmp841_;
					_tmp836_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) _tmp842_);
				} else {
					_tmp836_ = FALSE;
				}
				if (_tmp836_) {
					gchar** suffices = NULL;
					gchar* _tmp843_;
					gchar* _tmp844_;
					gchar* _tmp845_;
					gchar** _tmp846_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp843_ = g_strdup ("type");
					_tmp844_ = g_strdup ("dup_func");
					_tmp845_ = g_strdup ("destroy_func");
					_tmp846_ = g_new0 (gchar*, 3 + 1);
					_tmp846_[0] = _tmp843_;
					_tmp846_[1] = _tmp844_;
					_tmp846_[2] = _tmp845_;
					suffices = _tmp846_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp847_;
						ValaClass* _tmp848_;
						ValaList* _tmp849_;
						gint _type_param_size = 0;
						ValaList* _tmp850_;
						gint _tmp851_;
						gint _tmp852_;
						gint _type_param_index = 0;
						_tmp847_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp848_ = _tmp847_;
						_tmp849_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp848_);
						_type_param_list = _tmp849_;
						_tmp850_ = _type_param_list;
						_tmp851_ = vala_collection_get_size ((ValaCollection*) _tmp850_);
						_tmp852_ = _tmp851_;
						_type_param_size = _tmp852_;
						_type_param_index = -1;
						while (TRUE) {
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp853_;
							gpointer _tmp854_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp855_;
							ValaCCodeIdentifier* _tmp856_;
							ValaCCodeMemberAccess* _tmp857_;
							ValaCCodeMemberAccess* _tmp858_;
							gchar** _tmp859_;
							gint _tmp859__length1;
							_type_param_index = _type_param_index + 1;
							if (!(_type_param_index < _type_param_size)) {
								break;
							}
							_tmp853_ = _type_param_list;
							_tmp854_ = vala_list_get (_tmp853_, _type_param_index);
							type_param = (ValaTypeParameter*) _tmp854_;
							_tmp855_ = vala_ccode_identifier_new ("self");
							_tmp856_ = _tmp855_;
							_tmp857_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp856_, "priv");
							_tmp858_ = _tmp857_;
							_vala_ccode_node_unref0 (_tmp856_);
							priv_access = _tmp858_;
							_tmp859_ = suffices;
							_tmp859__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp859_;
								suffix_collection_length1 = _tmp859__length1;
								for (suffix_it = 0; suffix_it < _tmp859__length1; suffix_it = suffix_it + 1) {
									gchar* _tmp860_;
									gchar* suffix = NULL;
									_tmp860_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp860_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp861_;
										const gchar* _tmp862_;
										const gchar* _tmp863_;
										gchar* _tmp864_;
										gchar* _tmp865_;
										const gchar* _tmp866_;
										gchar* _tmp867_;
										gchar* _tmp868_;
										ValaCCodeIdentifier* _tmp869_;
										ValaCCodeIdentifier* _tmp870_;
										ValaCCodeFunction* _tmp871_;
										ValaCCodeFunction* _tmp872_;
										ValaCCodeMemberAccess* _tmp873_;
										ValaCCodeIdentifier* _tmp874_;
										const gchar* _tmp875_;
										const gchar* _tmp876_;
										ValaCCodeMemberAccess* _tmp877_;
										ValaCCodeMemberAccess* _tmp878_;
										ValaCCodeIdentifier* _tmp879_;
										_tmp861_ = type_param;
										_tmp862_ = vala_symbol_get_name ((ValaSymbol*) _tmp861_);
										_tmp863_ = _tmp862_;
										_tmp864_ = g_utf8_strdown (_tmp863_, (gssize) -1);
										_tmp865_ = _tmp864_;
										_tmp866_ = suffix;
										_tmp867_ = g_strdup_printf ("%s_%s", _tmp865_, _tmp866_);
										_tmp868_ = _tmp867_;
										_tmp869_ = vala_ccode_identifier_new (_tmp868_);
										_tmp870_ = _tmp869_;
										_g_free0 (_tmp868_);
										_g_free0 (_tmp865_);
										param_name = _tmp870_;
										_tmp871_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp872_ = _tmp871_;
										_tmp873_ = priv_access;
										_tmp874_ = param_name;
										_tmp875_ = vala_ccode_identifier_get_name (_tmp874_);
										_tmp876_ = _tmp875_;
										_tmp877_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp873_, _tmp876_);
										_tmp878_ = _tmp877_;
										_tmp879_ = param_name;
										vala_ccode_function_add_assignment (_tmp872_, (ValaCCodeExpression*) _tmp878_, (ValaCCodeExpression*) _tmp879_);
										_vala_ccode_node_unref0 (_tmp878_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp880_ = params;
	_tmp881_ = vala_iterable_iterator ((ValaIterable*) _tmp880_);
	params_it = _tmp881_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp882_;
		gint _arg_size = 0;
		ValaList* _tmp883_;
		gint _tmp884_;
		gint _tmp885_;
		gint _arg_index = 0;
		_tmp882_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp882_;
		_tmp883_ = _arg_list;
		_tmp884_ = vala_collection_get_size ((ValaCollection*) _tmp883_);
		_tmp885_ = _tmp884_;
		_arg_size = _tmp885_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp886_;
			gpointer _tmp887_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp888_;
			ValaCCodeExpression* _tmp889_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp890_;
			ValaHashMap* _tmp891_;
			ValaIterator* _tmp892_;
			ValaHashMap* _tmp1194_;
			ValaCCodeExpression* _tmp1195_;
			gboolean _tmp1196_ = FALSE;
			ValaExpression* _tmp1197_;
			gint _tmp1214_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp886_ = _arg_list;
			_tmp887_ = vala_list_get (_tmp886_, _arg_index);
			arg = (ValaExpression*) _tmp887_;
			_tmp888_ = arg;
			_tmp889_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp888_);
			cexpr = _tmp889_;
			_tmp890_ = in_arg_map;
			_tmp891_ = _vala_map_ref0 (_tmp890_);
			carg_map = _tmp891_;
			_tmp892_ = params_it;
			if (vala_iterator_next (_tmp892_)) {
				ValaParameter* param = NULL;
				ValaIterator* _tmp893_;
				gpointer _tmp894_;
				gboolean _tmp895_ = FALSE;
				ValaParameter* _tmp896_;
				gboolean _tmp897_;
				gboolean _tmp898_;
				ValaParameter* _tmp1190_;
				_tmp893_ = params_it;
				_tmp894_ = vala_iterator_get (_tmp893_);
				param = (ValaParameter*) _tmp894_;
				_tmp896_ = param;
				_tmp897_ = vala_parameter_get_params_array (_tmp896_);
				_tmp898_ = _tmp897_;
				if (_tmp898_) {
					_tmp895_ = TRUE;
				} else {
					ValaParameter* _tmp899_;
					gboolean _tmp900_;
					gboolean _tmp901_;
					_tmp899_ = param;
					_tmp900_ = vala_parameter_get_ellipsis (_tmp899_);
					_tmp901_ = _tmp900_;
					_tmp895_ = _tmp901_;
				}
				ellipsis = _tmp895_;
				if (!ellipsis) {
					ValaParameter* _tmp902_;
					ValaParameterDirection _tmp903_;
					ValaParameterDirection _tmp904_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp907_;
					ValaUnaryExpression* _tmp908_;
					gboolean _tmp909_ = FALSE;
					ValaUnaryExpression* _tmp910_;
					ValaParameter* _tmp1178_;
					gchar* _tmp1179_;
					gchar* _tmp1180_;
					gboolean _tmp1181_;
					_tmp902_ = param;
					_tmp903_ = vala_parameter_get_direction (_tmp902_);
					_tmp904_ = _tmp903_;
					if (_tmp904_ == VALA_PARAMETER_DIRECTION_OUT) {
						ValaHashMap* _tmp905_;
						ValaHashMap* _tmp906_;
						_tmp905_ = out_arg_map;
						_tmp906_ = _vala_map_ref0 (_tmp905_);
						_vala_map_unref0 (carg_map);
						carg_map = _tmp906_;
					}
					_tmp907_ = arg;
					_tmp908_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp907_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp907_) : NULL);
					unary = _tmp908_;
					_tmp910_ = unary;
					if (_tmp910_ == NULL) {
						_tmp909_ = TRUE;
					} else {
						ValaUnaryExpression* _tmp911_;
						ValaUnaryOperator _tmp912_;
						ValaUnaryOperator _tmp913_;
						_tmp911_ = unary;
						_tmp912_ = vala_unary_expression_get_operator (_tmp911_);
						_tmp913_ = _tmp912_;
						_tmp909_ = _tmp913_ != VALA_UNARY_OPERATOR_OUT;
					}
					if (_tmp909_) {
						gboolean _tmp914_ = FALSE;
						gboolean _tmp915_ = FALSE;
						ValaParameter* _tmp916_;
						ValaParameter* _tmp1052_;
						ValaExpression* _tmp1053_;
						ValaCCodeExpression* _tmp1054_;
						ValaCCodeExpression* _tmp1055_;
						_tmp916_ = param;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp916_)) {
							ValaParameter* _tmp917_;
							ValaDataType* _tmp918_;
							ValaDataType* _tmp919_;
							_tmp917_ = param;
							_tmp918_ = vala_variable_get_variable_type ((ValaVariable*) _tmp917_);
							_tmp919_ = _tmp918_;
							_tmp915_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp919_, VALA_TYPE_ARRAY_TYPE);
						} else {
							_tmp915_ = FALSE;
						}
						if (_tmp915_) {
							ValaParameter* _tmp920_;
							ValaDataType* _tmp921_;
							ValaDataType* _tmp922_;
							gboolean _tmp923_;
							gboolean _tmp924_;
							_tmp920_ = param;
							_tmp921_ = vala_variable_get_variable_type ((ValaVariable*) _tmp920_);
							_tmp922_ = _tmp921_;
							_tmp923_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp922_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							_tmp924_ = _tmp923_;
							_tmp914_ = !_tmp924_;
						} else {
							_tmp914_ = FALSE;
						}
						if (_tmp914_) {
							ValaArrayType* array_type = NULL;
							ValaParameter* _tmp925_;
							ValaDataType* _tmp926_;
							ValaDataType* _tmp927_;
							ValaArrayType* _tmp928_;
							gchar* _tmp929_ = NULL;
							ValaParameter* _tmp930_;
							gchar* _tmp931_;
							gchar* length_ctype = NULL;
							gchar* _tmp934_;
							gboolean _tmp935_ = FALSE;
							ValaUnaryExpression* _tmp936_;
							_tmp925_ = param;
							_tmp926_ = vala_variable_get_variable_type ((ValaVariable*) _tmp925_);
							_tmp927_ = _tmp926_;
							_tmp928_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp927_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							array_type = _tmp928_;
							_tmp930_ = param;
							_tmp931_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp930_);
							_tmp929_ = _tmp931_;
							if (_tmp929_ == NULL) {
								ValaArrayType* _tmp932_;
								gchar* _tmp933_;
								_tmp932_ = array_type;
								_tmp933_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp932_);
								_g_free0 (_tmp929_);
								_tmp929_ = _tmp933_;
							}
							_tmp934_ = g_strdup (_tmp929_);
							length_ctype = _tmp934_;
							_tmp936_ = unary;
							if (_tmp936_ != NULL) {
								ValaUnaryExpression* _tmp937_;
								ValaUnaryOperator _tmp938_;
								ValaUnaryOperator _tmp939_;
								_tmp937_ = unary;
								_tmp938_ = vala_unary_expression_get_operator (_tmp937_);
								_tmp939_ = _tmp938_;
								_tmp935_ = _tmp939_ == VALA_UNARY_OPERATOR_REF;
							} else {
								_tmp935_ = FALSE;
							}
							if (_tmp935_) {
								const gchar* _tmp940_;
								gchar* _tmp941_;
								_tmp940_ = length_ctype;
								_tmp941_ = g_strdup_printf ("%s*", _tmp940_);
								_g_free0 (length_ctype);
								length_ctype = _tmp941_;
							}
							{
								gint dim = 0;
								dim = 1;
								{
									gboolean _tmp942_ = FALSE;
									_tmp942_ = TRUE;
									while (TRUE) {
										ValaArrayType* _tmp944_;
										gint _tmp945_;
										gint _tmp946_;
										ValaCCodeCastExpression* array_length_expr = NULL;
										ValaExpression* _tmp947_;
										ValaCCodeExpression* _tmp948_;
										ValaCCodeExpression* _tmp949_;
										const gchar* _tmp950_;
										ValaCCodeCastExpression* _tmp951_;
										ValaCCodeCastExpression* _tmp952_;
										ValaHashMap* _tmp953_;
										ValaParameter* _tmp954_;
										ValaCCodeCastExpression* _tmp955_;
										if (!_tmp942_) {
											gint _tmp943_;
											_tmp943_ = dim;
											dim = _tmp943_ + 1;
										}
										_tmp942_ = FALSE;
										_tmp944_ = array_type;
										_tmp945_ = vala_array_type_get_rank (_tmp944_);
										_tmp946_ = _tmp945_;
										if (!(dim <= _tmp946_)) {
											break;
										}
										_tmp947_ = arg;
										_tmp948_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp947_, dim);
										_tmp949_ = _tmp948_;
										_tmp950_ = length_ctype;
										_tmp951_ = vala_ccode_cast_expression_new (_tmp949_, _tmp950_);
										_tmp952_ = _tmp951_;
										_vala_ccode_node_unref0 (_tmp949_);
										array_length_expr = _tmp952_;
										_tmp953_ = carg_map;
										_tmp954_ = param;
										_tmp955_ = array_length_expr;
										vala_map_set ((ValaMap*) _tmp953_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp954_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp955_);
										_vala_ccode_node_unref0 (array_length_expr);
									}
								}
							}
							_g_free0 (length_ctype);
							_g_free0 (_tmp929_);
							_vala_code_node_unref0 (array_type);
						} else {
							ValaParameter* _tmp956_;
							ValaDataType* _tmp957_;
							ValaDataType* _tmp958_;
							_tmp956_ = param;
							_tmp957_ = vala_variable_get_variable_type ((ValaVariable*) _tmp956_);
							_tmp958_ = _tmp957_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp958_, VALA_TYPE_DELEGATE_TYPE)) {
								ValaDelegateType* deleg_type = NULL;
								ValaParameter* _tmp959_;
								ValaDataType* _tmp960_;
								ValaDataType* _tmp961_;
								ValaDelegateType* _tmp962_;
								ValaDelegateType* _tmp963_;
								ValaDelegate* _tmp964_;
								ValaDelegate* _tmp965_;
								gboolean _tmp966_;
								gboolean _tmp967_;
								_tmp959_ = param;
								_tmp960_ = vala_variable_get_variable_type ((ValaVariable*) _tmp959_);
								_tmp961_ = _tmp960_;
								_tmp962_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp961_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
								deleg_type = _tmp962_;
								_tmp963_ = deleg_type;
								_tmp964_ = vala_delegate_type_get_delegate_symbol (_tmp963_);
								_tmp965_ = _tmp964_;
								_tmp966_ = vala_delegate_get_has_target (_tmp965_);
								_tmp967_ = _tmp966_;
								if (_tmp967_) {
									ValaCCodeExpression* delegate_target_destroy_notify = NULL;
									ValaCCodeExpression* delegate_target = NULL;
									ValaExpression* _tmp968_;
									ValaCCodeExpression* _tmp969_ = NULL;
									ValaCCodeExpression* _tmp970_;
									ValaCCodeExpression* _tmp971_;
									ValaParameter* _tmp972_;
									gchar* _tmp973_;
									gchar* _tmp974_;
									gboolean _tmp975_;
									_tmp968_ = arg;
									_tmp970_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp968_, &_tmp969_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
									delegate_target_destroy_notify = _tmp969_;
									delegate_target = _tmp970_;
									_tmp971_ = delegate_target;
									_vala_assert (_tmp971_ != NULL, "delegate_target != null");
									_tmp972_ = param;
									_tmp973_ = vala_get_ccode_type ((ValaCodeNode*) _tmp972_);
									_tmp974_ = _tmp973_;
									_tmp975_ = g_strcmp0 (_tmp974_, "GClosure*") == 0;
									_g_free0 (_tmp974_);
									if (_tmp975_) {
										ValaCCodeFunctionCall* closure_new = NULL;
										ValaCCodeIdentifier* _tmp976_;
										ValaCCodeIdentifier* _tmp977_;
										ValaCCodeFunctionCall* _tmp978_;
										ValaCCodeFunctionCall* _tmp979_;
										ValaCCodeFunctionCall* _tmp980_;
										ValaCCodeExpression* _tmp981_;
										ValaCCodeCastExpression* _tmp982_;
										ValaCCodeCastExpression* _tmp983_;
										ValaCCodeFunctionCall* _tmp984_;
										ValaCCodeExpression* _tmp985_;
										ValaCCodeFunctionCall* _tmp986_;
										ValaCCodeExpression* _tmp987_;
										ValaCCodeCastExpression* _tmp988_;
										ValaCCodeCastExpression* _tmp989_;
										ValaCCodeExpression* _tmp990_;
										ValaCCodeIdentifier* _tmp991_;
										ValaCCodeIdentifier* _tmp992_;
										ValaCCodeBinaryExpression* _tmp993_;
										ValaCCodeBinaryExpression* _tmp994_;
										ValaCCodeIdentifier* _tmp995_;
										ValaCCodeIdentifier* _tmp996_;
										ValaCCodeFunctionCall* _tmp997_;
										ValaCCodeConditionalExpression* _tmp998_;
										_tmp976_ = vala_ccode_identifier_new ("g_cclosure_new");
										_tmp977_ = _tmp976_;
										_tmp978_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp977_);
										_tmp979_ = _tmp978_;
										_vala_ccode_node_unref0 (_tmp977_);
										closure_new = _tmp979_;
										_tmp980_ = closure_new;
										_tmp981_ = cexpr;
										_tmp982_ = vala_ccode_cast_expression_new (_tmp981_, "GCallback");
										_tmp983_ = _tmp982_;
										vala_ccode_function_call_add_argument (_tmp980_, (ValaCCodeExpression*) _tmp983_);
										_vala_ccode_node_unref0 (_tmp983_);
										_tmp984_ = closure_new;
										_tmp985_ = delegate_target;
										vala_ccode_function_call_add_argument (_tmp984_, _tmp985_);
										_tmp986_ = closure_new;
										_tmp987_ = delegate_target_destroy_notify;
										_tmp988_ = vala_ccode_cast_expression_new (_tmp987_, "GClosureNotify");
										_tmp989_ = _tmp988_;
										vala_ccode_function_call_add_argument (_tmp986_, (ValaCCodeExpression*) _tmp989_);
										_vala_ccode_node_unref0 (_tmp989_);
										_tmp990_ = cexpr;
										_tmp991_ = vala_ccode_identifier_new ("NULL");
										_tmp992_ = _tmp991_;
										_tmp993_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp990_, (ValaCCodeExpression*) _tmp992_);
										_tmp994_ = _tmp993_;
										_tmp995_ = vala_ccode_identifier_new ("NULL");
										_tmp996_ = _tmp995_;
										_tmp997_ = closure_new;
										_tmp998_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp994_, (ValaCCodeExpression*) _tmp996_, (ValaCCodeExpression*) _tmp997_);
										_vala_ccode_node_unref0 (cexpr);
										cexpr = (ValaCCodeExpression*) _tmp998_;
										_vala_ccode_node_unref0 (_tmp996_);
										_vala_ccode_node_unref0 (_tmp994_);
										_vala_ccode_node_unref0 (_tmp992_);
										_vala_ccode_node_unref0 (closure_new);
									} else {
										ValaHashMap* _tmp999_;
										ValaParameter* _tmp1000_;
										ValaCCodeExpression* _tmp1001_;
										ValaDelegateType* _tmp1002_;
										_tmp999_ = carg_map;
										_tmp1000_ = param;
										_tmp1001_ = delegate_target;
										vala_map_set ((ValaMap*) _tmp999_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1000_), FALSE)), _tmp1001_);
										_tmp1002_ = deleg_type;
										if (vala_data_type_is_disposable ((ValaDataType*) _tmp1002_)) {
											ValaCCodeExpression* _tmp1003_;
											ValaHashMap* _tmp1004_;
											ValaParameter* _tmp1005_;
											ValaCCodeExpression* _tmp1006_;
											_tmp1003_ = delegate_target_destroy_notify;
											_vala_assert (_tmp1003_ != NULL, "delegate_target_destroy_notify != null");
											_tmp1004_ = carg_map;
											_tmp1005_ = param;
											_tmp1006_ = delegate_target_destroy_notify;
											vala_map_set ((ValaMap*) _tmp1004_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1005_) + 0.01, FALSE)), _tmp1006_);
										}
									}
									_vala_ccode_node_unref0 (delegate_target);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								}
								_vala_code_node_unref0 (deleg_type);
							} else {
								ValaParameter* _tmp1007_;
								ValaDataType* _tmp1008_;
								ValaDataType* _tmp1009_;
								_tmp1007_ = param;
								_tmp1008_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1007_);
								_tmp1009_ = _tmp1008_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1009_, VALA_TYPE_METHOD_TYPE)) {
									ValaCCodeExpression* delegate_target_destroy_notify = NULL;
									ValaHashMap* _tmp1010_;
									ValaParameter* _tmp1011_;
									ValaExpression* _tmp1012_;
									ValaCCodeExpression* _tmp1013_ = NULL;
									ValaCCodeExpression* _tmp1014_;
									ValaCCodeExpression* _tmp1015_;
									_tmp1010_ = carg_map;
									_tmp1011_ = param;
									_tmp1012_ = arg;
									_tmp1014_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1012_, &_tmp1013_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
									delegate_target_destroy_notify = _tmp1013_;
									_tmp1015_ = _tmp1014_;
									vala_map_set ((ValaMap*) _tmp1010_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1011_), FALSE)), _tmp1015_);
									_vala_ccode_node_unref0 (_tmp1015_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								} else {
									ValaParameter* _tmp1016_;
									ValaDataType* _tmp1017_;
									ValaDataType* _tmp1018_;
									_tmp1016_ = param;
									_tmp1017_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1016_);
									_tmp1018_ = _tmp1017_;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1018_, VALA_TYPE_GENERIC_TYPE)) {
										gboolean _tmp1019_ = FALSE;
										ValaMethod* _tmp1020_;
										_tmp1020_ = m;
										if (_tmp1020_ != NULL) {
											ValaMethod* _tmp1021_;
											_tmp1021_ = m;
											_tmp1019_ = vala_get_ccode_simple_generics (_tmp1021_);
										} else {
											_tmp1019_ = FALSE;
										}
										if (_tmp1019_) {
											ValaGenericType* generic_type = NULL;
											ValaParameter* _tmp1022_;
											ValaDataType* _tmp1023_;
											ValaDataType* _tmp1024_;
											ValaGenericType* _tmp1025_;
											gint type_param_index = 0;
											ValaMethod* _tmp1026_;
											ValaGenericType* _tmp1027_;
											ValaTypeParameter* _tmp1028_;
											ValaTypeParameter* _tmp1029_;
											const gchar* _tmp1030_;
											const gchar* _tmp1031_;
											ValaDataType* type_arg = NULL;
											ValaMemberAccess* _tmp1032_;
											ValaList* _tmp1033_;
											ValaList* _tmp1034_;
											gpointer _tmp1035_;
											ValaDataType* _tmp1036_;
											ValaParameter* _tmp1037_;
											ValaDataType* _tmp1038_;
											ValaDataType* _tmp1039_;
											gboolean _tmp1040_;
											gboolean _tmp1041_;
											_tmp1022_ = param;
											_tmp1023_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1022_);
											_tmp1024_ = _tmp1023_;
											_tmp1025_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1024_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
											generic_type = _tmp1025_;
											_tmp1026_ = m;
											_tmp1027_ = generic_type;
											_tmp1028_ = vala_generic_type_get_type_parameter (_tmp1027_);
											_tmp1029_ = _tmp1028_;
											_tmp1030_ = vala_symbol_get_name ((ValaSymbol*) _tmp1029_);
											_tmp1031_ = _tmp1030_;
											type_param_index = vala_method_get_type_parameter_index (_tmp1026_, _tmp1031_);
											_tmp1032_ = ma;
											_tmp1033_ = vala_member_access_get_type_arguments (_tmp1032_);
											_tmp1034_ = _tmp1033_;
											_tmp1035_ = vala_list_get (_tmp1034_, type_param_index);
											_tmp1036_ = (ValaDataType*) _tmp1035_;
											_vala_iterable_unref0 (_tmp1034_);
											type_arg = _tmp1036_;
											_tmp1037_ = param;
											_tmp1038_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1037_);
											_tmp1039_ = _tmp1038_;
											_tmp1040_ = vala_data_type_get_value_owned (_tmp1039_);
											_tmp1041_ = _tmp1040_;
											if (_tmp1041_) {
												ValaDataType* _tmp1042_;
												_tmp1042_ = type_arg;
												if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, _tmp1042_)) {
													ValaHashMap* _tmp1043_;
													ValaParameter* _tmp1044_;
													ValaDataType* _tmp1045_;
													ValaCCodeExpression* _tmp1046_;
													ValaCCodeExpression* _tmp1047_;
													_tmp1043_ = carg_map;
													_tmp1044_ = param;
													_tmp1045_ = type_arg;
													_tmp1046_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1045_, FALSE);
													_tmp1047_ = _tmp1046_;
													vala_map_set ((ValaMap*) _tmp1043_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1044_), FALSE)), _tmp1047_);
													_vala_ccode_node_unref0 (_tmp1047_);
												} else {
													ValaHashMap* _tmp1048_;
													ValaParameter* _tmp1049_;
													ValaCCodeConstant* _tmp1050_;
													ValaCCodeConstant* _tmp1051_;
													_tmp1048_ = carg_map;
													_tmp1049_ = param;
													_tmp1050_ = vala_ccode_constant_new ("NULL");
													_tmp1051_ = _tmp1050_;
													vala_map_set ((ValaMap*) _tmp1048_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1049_), FALSE)), (ValaCCodeExpression*) _tmp1051_);
													_vala_ccode_node_unref0 (_tmp1051_);
												}
											}
											_vala_code_node_unref0 (type_arg);
											_vala_code_node_unref0 (generic_type);
										}
									}
								}
							}
						}
						_tmp1052_ = param;
						_tmp1053_ = arg;
						_tmp1054_ = cexpr;
						_tmp1055_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1052_, _tmp1053_, _tmp1054_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = _tmp1055_;
					} else {
						ValaExpression* _tmp1056_;
						ValaLocalVariable* temp_var = NULL;
						ValaParameter* _tmp1057_;
						ValaDataType* _tmp1058_;
						ValaDataType* _tmp1059_;
						ValaParameter* _tmp1060_;
						ValaDataType* _tmp1061_;
						ValaDataType* _tmp1062_;
						gboolean _tmp1063_;
						gboolean _tmp1064_;
						ValaLocalVariable* _tmp1065_;
						ValaLocalVariable* _tmp1066_;
						ValaExpression* _tmp1067_;
						ValaLocalVariable* _tmp1068_;
						const gchar* _tmp1069_;
						const gchar* _tmp1070_;
						ValaCCodeExpression* _tmp1071_;
						ValaCCodeExpression* _tmp1072_;
						ValaExpression* _tmp1073_;
						ValaTargetValue* _tmp1074_;
						ValaTargetValue* _tmp1075_;
						ValaExpression* _tmp1076_;
						ValaDataType* _tmp1077_;
						ValaDataType* _tmp1078_;
						ValaExpression* _tmp1079_;
						ValaCCodeExpression* _tmp1080_;
						ValaCCodeExpression* _tmp1081_;
						ValaCCodeUnaryExpression* _tmp1082_;
						gboolean _tmp1083_ = FALSE;
						gboolean _tmp1084_ = FALSE;
						ValaParameter* _tmp1085_;
						_tmp1056_ = arg;
						vala_expression_set_target_value (_tmp1056_, NULL);
						_tmp1057_ = param;
						_tmp1058_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1057_);
						_tmp1059_ = _tmp1058_;
						_tmp1060_ = param;
						_tmp1061_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1060_);
						_tmp1062_ = _tmp1061_;
						_tmp1063_ = vala_data_type_get_value_owned (_tmp1062_);
						_tmp1064_ = _tmp1063_;
						_tmp1065_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1059_, _tmp1064_, NULL, TRUE);
						temp_var = _tmp1065_;
						_tmp1066_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1066_, FALSE);
						_tmp1067_ = arg;
						_tmp1068_ = temp_var;
						_tmp1069_ = vala_symbol_get_name ((ValaSymbol*) _tmp1068_);
						_tmp1070_ = _tmp1069_;
						_tmp1071_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1070_);
						_tmp1072_ = _tmp1071_;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1067_, _tmp1072_);
						_vala_ccode_node_unref0 (_tmp1072_);
						_tmp1073_ = arg;
						_tmp1074_ = vala_expression_get_target_value (_tmp1073_);
						_tmp1075_ = _tmp1074_;
						_tmp1076_ = arg;
						_tmp1077_ = vala_expression_get_target_type (_tmp1076_);
						_tmp1078_ = _tmp1077_;
						vala_target_value_set_value_type (_tmp1075_, _tmp1078_);
						_tmp1079_ = arg;
						_tmp1080_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1079_);
						_tmp1081_ = _tmp1080_;
						_tmp1082_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1081_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = (ValaCCodeExpression*) _tmp1082_;
						_vala_ccode_node_unref0 (_tmp1081_);
						_tmp1085_ = param;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1085_)) {
							ValaParameter* _tmp1086_;
							ValaDataType* _tmp1087_;
							ValaDataType* _tmp1088_;
							_tmp1086_ = param;
							_tmp1087_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1086_);
							_tmp1088_ = _tmp1087_;
							_tmp1084_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1088_, VALA_TYPE_ARRAY_TYPE);
						} else {
							_tmp1084_ = FALSE;
						}
						if (_tmp1084_) {
							ValaParameter* _tmp1089_;
							ValaDataType* _tmp1090_;
							ValaDataType* _tmp1091_;
							gboolean _tmp1092_;
							gboolean _tmp1093_;
							_tmp1089_ = param;
							_tmp1090_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1089_);
							_tmp1091_ = _tmp1090_;
							_tmp1092_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1091_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							_tmp1093_ = _tmp1092_;
							_tmp1083_ = !_tmp1093_;
						} else {
							_tmp1083_ = FALSE;
						}
						if (_tmp1083_) {
							ValaArrayType* array_type = NULL;
							ValaParameter* _tmp1094_;
							ValaDataType* _tmp1095_;
							ValaDataType* _tmp1096_;
							ValaArrayType* _tmp1097_;
							gchar* _tmp1098_ = NULL;
							ValaParameter* _tmp1099_;
							gchar* _tmp1100_;
							gchar* length_ctype = NULL;
							gchar* _tmp1103_;
							_tmp1094_ = param;
							_tmp1095_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1094_);
							_tmp1096_ = _tmp1095_;
							_tmp1097_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1096_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							array_type = _tmp1097_;
							_tmp1099_ = param;
							_tmp1100_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1099_);
							_tmp1098_ = _tmp1100_;
							if (_tmp1098_ == NULL) {
								ValaArrayType* _tmp1101_;
								gchar* _tmp1102_;
								_tmp1101_ = array_type;
								_tmp1102_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1101_);
								_g_free0 (_tmp1098_);
								_tmp1098_ = _tmp1102_;
							}
							_tmp1103_ = g_strdup (_tmp1098_);
							length_ctype = _tmp1103_;
							{
								gint dim = 0;
								dim = 1;
								{
									gboolean _tmp1104_ = FALSE;
									_tmp1104_ = TRUE;
									while (TRUE) {
										ValaArrayType* _tmp1106_;
										gint _tmp1107_;
										gint _tmp1108_;
										ValaLocalVariable* temp_array_length = NULL;
										const gchar* _tmp1109_;
										ValaCType* _tmp1110_;
										ValaCType* _tmp1111_;
										ValaLocalVariable* _tmp1112_;
										ValaLocalVariable* _tmp1113_;
										ValaLocalVariable* _tmp1114_;
										ValaExpression* _tmp1115_;
										ValaLocalVariable* _tmp1116_;
										const gchar* _tmp1117_;
										const gchar* _tmp1118_;
										ValaCCodeExpression* _tmp1119_;
										ValaCCodeExpression* _tmp1120_;
										ValaHashMap* _tmp1121_;
										ValaParameter* _tmp1122_;
										ValaExpression* _tmp1123_;
										ValaList* _tmp1124_;
										ValaList* _tmp1125_;
										gpointer _tmp1126_;
										ValaCCodeExpression* _tmp1127_;
										ValaCCodeUnaryExpression* _tmp1128_;
										ValaCCodeUnaryExpression* _tmp1129_;
										if (!_tmp1104_) {
											gint _tmp1105_;
											_tmp1105_ = dim;
											dim = _tmp1105_ + 1;
										}
										_tmp1104_ = FALSE;
										_tmp1106_ = array_type;
										_tmp1107_ = vala_array_type_get_rank (_tmp1106_);
										_tmp1108_ = _tmp1107_;
										if (!(dim <= _tmp1108_)) {
											break;
										}
										_tmp1109_ = length_ctype;
										_tmp1110_ = vala_ctype_new (_tmp1109_);
										_tmp1111_ = _tmp1110_;
										_tmp1112_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1111_, TRUE, NULL, FALSE);
										_tmp1113_ = _tmp1112_;
										_vala_code_node_unref0 (_tmp1111_);
										temp_array_length = _tmp1113_;
										_tmp1114_ = temp_array_length;
										vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1114_, FALSE);
										_tmp1115_ = arg;
										_tmp1116_ = temp_array_length;
										_tmp1117_ = vala_symbol_get_name ((ValaSymbol*) _tmp1116_);
										_tmp1118_ = _tmp1117_;
										_tmp1119_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1118_);
										_tmp1120_ = _tmp1119_;
										vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, _tmp1115_, _tmp1120_);
										_vala_ccode_node_unref0 (_tmp1120_);
										_tmp1121_ = carg_map;
										_tmp1122_ = param;
										_tmp1123_ = arg;
										_tmp1124_ = vala_ccode_base_module_get_array_lengths ((ValaCCodeBaseModule*) self, _tmp1123_);
										_tmp1125_ = _tmp1124_;
										_tmp1126_ = vala_list_get (_tmp1125_, dim - 1);
										_tmp1127_ = (ValaCCodeExpression*) _tmp1126_;
										_tmp1128_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1127_);
										_tmp1129_ = _tmp1128_;
										vala_map_set ((ValaMap*) _tmp1121_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1122_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1129_);
										_vala_ccode_node_unref0 (_tmp1129_);
										_vala_ccode_node_unref0 (_tmp1127_);
										_vala_iterable_unref0 (_tmp1125_);
										_vala_code_node_unref0 (temp_array_length);
									}
								}
							}
							_g_free0 (length_ctype);
							_g_free0 (_tmp1098_);
							_vala_code_node_unref0 (array_type);
						} else {
							ValaParameter* _tmp1130_;
							ValaDataType* _tmp1131_;
							ValaDataType* _tmp1132_;
							_tmp1130_ = param;
							_tmp1131_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1130_);
							_tmp1132_ = _tmp1131_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1132_, VALA_TYPE_DELEGATE_TYPE)) {
								ValaDelegateType* deleg_type = NULL;
								ValaParameter* _tmp1133_;
								ValaDataType* _tmp1134_;
								ValaDataType* _tmp1135_;
								ValaDelegateType* _tmp1136_;
								ValaDelegateType* _tmp1137_;
								ValaDelegate* _tmp1138_;
								ValaDelegate* _tmp1139_;
								gboolean _tmp1140_;
								gboolean _tmp1141_;
								_tmp1133_ = param;
								_tmp1134_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1133_);
								_tmp1135_ = _tmp1134_;
								_tmp1136_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1135_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
								deleg_type = _tmp1136_;
								_tmp1137_ = deleg_type;
								_tmp1138_ = vala_delegate_type_get_delegate_symbol (_tmp1137_);
								_tmp1139_ = _tmp1138_;
								_tmp1140_ = vala_delegate_get_has_target (_tmp1139_);
								_tmp1141_ = _tmp1140_;
								if (_tmp1141_) {
									ValaVoidType* _tmp1142_;
									ValaVoidType* _tmp1143_;
									ValaPointerType* _tmp1144_;
									ValaPointerType* _tmp1145_;
									ValaLocalVariable* _tmp1146_;
									ValaLocalVariable* _tmp1147_;
									ValaExpression* _tmp1148_;
									ValaLocalVariable* _tmp1149_;
									const gchar* _tmp1150_;
									const gchar* _tmp1151_;
									ValaCCodeExpression* _tmp1152_;
									ValaCCodeExpression* _tmp1153_;
									ValaHashMap* _tmp1154_;
									ValaParameter* _tmp1155_;
									ValaExpression* _tmp1156_;
									ValaCCodeExpression* _tmp1157_;
									ValaCCodeExpression* _tmp1158_;
									ValaCCodeUnaryExpression* _tmp1159_;
									ValaCCodeUnaryExpression* _tmp1160_;
									ValaDelegateType* _tmp1161_;
									_tmp1142_ = vala_void_type_new (NULL);
									_tmp1143_ = _tmp1142_;
									_tmp1144_ = vala_pointer_type_new ((ValaDataType*) _tmp1143_, NULL);
									_tmp1145_ = _tmp1144_;
									_tmp1146_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1145_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1146_;
									_vala_code_node_unref0 (_tmp1145_);
									_vala_code_node_unref0 (_tmp1143_);
									_tmp1147_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1147_, FALSE);
									_tmp1148_ = arg;
									_tmp1149_ = temp_var;
									_tmp1150_ = vala_symbol_get_name ((ValaSymbol*) _tmp1149_);
									_tmp1151_ = _tmp1150_;
									_tmp1152_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1151_);
									_tmp1153_ = _tmp1152_;
									vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, _tmp1148_, _tmp1153_);
									_vala_ccode_node_unref0 (_tmp1153_);
									_tmp1154_ = carg_map;
									_tmp1155_ = param;
									_tmp1156_ = arg;
									_tmp1157_ = vala_ccode_base_module_get_delegate_target ((ValaCCodeBaseModule*) self, _tmp1156_);
									_tmp1158_ = _tmp1157_;
									_tmp1159_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1158_);
									_tmp1160_ = _tmp1159_;
									vala_map_set ((ValaMap*) _tmp1154_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1155_), FALSE)), (ValaCCodeExpression*) _tmp1160_);
									_vala_ccode_node_unref0 (_tmp1160_);
									_vala_ccode_node_unref0 (_tmp1158_);
									_tmp1161_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1161_)) {
										ValaDataType* _tmp1162_;
										ValaLocalVariable* _tmp1163_;
										ValaLocalVariable* _tmp1164_;
										ValaExpression* _tmp1165_;
										ValaLocalVariable* _tmp1166_;
										const gchar* _tmp1167_;
										const gchar* _tmp1168_;
										ValaCCodeExpression* _tmp1169_;
										ValaCCodeExpression* _tmp1170_;
										ValaHashMap* _tmp1171_;
										ValaParameter* _tmp1172_;
										ValaExpression* _tmp1173_;
										ValaCCodeExpression* _tmp1174_;
										ValaCCodeExpression* _tmp1175_;
										ValaCCodeUnaryExpression* _tmp1176_;
										ValaCCodeUnaryExpression* _tmp1177_;
										_tmp1162_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
										_tmp1163_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1162_, TRUE, NULL, TRUE);
										_vala_code_node_unref0 (temp_var);
										temp_var = _tmp1163_;
										_tmp1164_ = temp_var;
										vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1164_, FALSE);
										_tmp1165_ = arg;
										_tmp1166_ = temp_var;
										_tmp1167_ = vala_symbol_get_name ((ValaSymbol*) _tmp1166_);
										_tmp1168_ = _tmp1167_;
										_tmp1169_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1168_);
										_tmp1170_ = _tmp1169_;
										vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1165_, _tmp1170_);
										_vala_ccode_node_unref0 (_tmp1170_);
										_tmp1171_ = carg_map;
										_tmp1172_ = param;
										_tmp1173_ = arg;
										_tmp1174_ = vala_ccode_base_module_get_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1173_);
										_tmp1175_ = _tmp1174_;
										_tmp1176_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1175_);
										_tmp1177_ = _tmp1176_;
										vala_map_set ((ValaMap*) _tmp1171_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1172_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1177_);
										_vala_ccode_node_unref0 (_tmp1177_);
										_vala_ccode_node_unref0 (_tmp1175_);
									}
								}
								_vala_code_node_unref0 (deleg_type);
							}
						}
						_vala_code_node_unref0 (temp_var);
					}
					_tmp1178_ = param;
					_tmp1179_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1178_);
					_tmp1180_ = _tmp1179_;
					_tmp1181_ = _tmp1180_ != NULL;
					_g_free0 (_tmp1180_);
					if (_tmp1181_) {
						ValaCCodeExpression* _tmp1182_;
						ValaParameter* _tmp1183_;
						gchar* _tmp1184_;
						gchar* _tmp1185_;
						ValaCCodeCastExpression* _tmp1186_;
						_tmp1182_ = cexpr;
						_tmp1183_ = param;
						_tmp1184_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1183_);
						_tmp1185_ = _tmp1184_;
						_tmp1186_ = vala_ccode_cast_expression_new (_tmp1182_, _tmp1185_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = (ValaCCodeExpression*) _tmp1186_;
						_g_free0 (_tmp1185_);
					}
					_vala_code_node_unref0 (unary);
				} else {
					ValaExpression* _tmp1187_;
					ValaCCodeExpression* _tmp1188_;
					ValaCCodeExpression* _tmp1189_;
					_tmp1187_ = arg;
					_tmp1188_ = cexpr;
					_tmp1189_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1187_, _tmp1188_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1189_;
				}
				_tmp1190_ = param;
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_pos (_tmp1190_), ellipsis);
				_vala_code_node_unref0 (param);
			} else {
				ValaExpression* _tmp1191_;
				ValaCCodeExpression* _tmp1192_;
				ValaCCodeExpression* _tmp1193_;
				_tmp1191_ = arg;
				_tmp1192_ = cexpr;
				_tmp1193_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1191_, _tmp1192_);
				_vala_ccode_node_unref0 (cexpr);
				cexpr = _tmp1193_;
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) i, ellipsis);
			}
			_tmp1194_ = carg_map;
			_tmp1195_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1194_, (gpointer) ((gintptr) arg_pos), _tmp1195_);
			_tmp1197_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1197_, VALA_TYPE_NAMED_ARGUMENT)) {
				_tmp1196_ = ellipsis;
			} else {
				_tmp1196_ = FALSE;
			}
			if (_tmp1196_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1198_;
				ValaNamedArgument* _tmp1199_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1200_;
				const gchar* _tmp1201_;
				const gchar* _tmp1202_;
				gchar** _tmp1203_;
				gchar** _tmp1204_;
				gchar** _tmp1205_;
				gint _tmp1205__length1;
				gchar* _tmp1206_;
				gchar* _tmp1207_;
				ValaHashMap* _tmp1208_;
				const gchar* _tmp1209_;
				gchar* _tmp1210_;
				gchar* _tmp1211_;
				ValaCCodeConstant* _tmp1212_;
				ValaCCodeConstant* _tmp1213_;
				_tmp1198_ = arg;
				_tmp1199_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1198_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1199_;
				_tmp1200_ = named_arg;
				_tmp1201_ = vala_named_argument_get_name (_tmp1200_);
				_tmp1202_ = _tmp1201_;
				_tmp1204_ = _tmp1203_ = g_strsplit (_tmp1202_, "_", 0);
				_tmp1205_ = _tmp1204_;
				_tmp1205__length1 = _vala_array_length (_tmp1203_);
				_tmp1206_ = _vala_g_strjoinv ("-", _tmp1205_, (gint) _vala_array_length (_tmp1203_));
				_tmp1207_ = _tmp1206_;
				_tmp1205_ = (_vala_array_free (_tmp1205_, _tmp1205__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1207_;
				_tmp1208_ = carg_map;
				_tmp1209_ = name;
				_tmp1210_ = g_strdup_printf ("\"%s\"", _tmp1209_);
				_tmp1211_ = _tmp1210_;
				_tmp1212_ = vala_ccode_constant_new (_tmp1211_);
				_tmp1213_ = _tmp1212_;
				vala_map_set ((ValaMap*) _tmp1208_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, i - 0.1, ellipsis)), (ValaCCodeExpression*) _tmp1213_);
				_vala_ccode_node_unref0 (_tmp1213_);
				_g_free0 (_tmp1211_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1214_ = i;
			i = _tmp1214_ + 1;
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1215_ = params_it;
	if (vala_iterator_next (_tmp1215_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1216_;
		gpointer _tmp1217_;
		gboolean _tmp1218_ = FALSE;
		ValaParameter* _tmp1219_;
		gboolean _tmp1220_;
		gboolean _tmp1221_;
		_tmp1216_ = params_it;
		_tmp1217_ = vala_iterator_get (_tmp1216_);
		param = (ValaParameter*) _tmp1217_;
		_tmp1219_ = param;
		_tmp1220_ = vala_parameter_get_params_array (_tmp1219_);
		_tmp1221_ = _tmp1220_;
		if (_tmp1221_) {
			_tmp1218_ = TRUE;
		} else {
			ValaParameter* _tmp1222_;
			gboolean _tmp1223_;
			gboolean _tmp1224_;
			_tmp1222_ = param;
			_tmp1223_ = vala_parameter_get_ellipsis (_tmp1222_);
			_tmp1224_ = _tmp1223_;
			_tmp1218_ = _tmp1224_;
		}
		_vala_assert (_tmp1218_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1227_ = m;
	if (_tmp1227_ != NULL) {
		ValaMethod* _tmp1228_;
		ValaDataType* _tmp1229_;
		ValaDataType* _tmp1230_;
		_tmp1228_ = m;
		_tmp1229_ = vala_callable_get_return_type ((ValaCallable*) _tmp1228_);
		_tmp1230_ = _tmp1229_;
		_tmp1226_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1230_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1226_ = FALSE;
	}
	if (_tmp1226_) {
		ValaCCodeFunctionCall* _tmp1231_;
		ValaCCodeFunctionCall* _tmp1232_;
		_tmp1231_ = async_call;
		_tmp1232_ = ccall;
		_tmp1225_ = _tmp1231_ != _tmp1232_;
	} else {
		_tmp1225_ = FALSE;
	}
	if (_tmp1225_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1233_;
		ValaDataType* _tmp1234_;
		ValaDataType* _tmp1235_;
		ValaArrayType* _tmp1236_;
		_tmp1233_ = m;
		_tmp1234_ = vala_callable_get_return_type ((ValaCallable*) _tmp1233_);
		_tmp1235_ = _tmp1234_;
		_tmp1236_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1235_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1236_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1237_ = FALSE;
				_tmp1237_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1239_;
					gint _tmp1240_;
					gint _tmp1241_;
					ValaMethod* _tmp1242_;
					if (!_tmp1237_) {
						gint _tmp1238_;
						_tmp1238_ = dim;
						dim = _tmp1238_ + 1;
					}
					_tmp1237_ = FALSE;
					_tmp1239_ = array_type;
					_tmp1240_ = vala_array_type_get_rank (_tmp1239_);
					_tmp1241_ = _tmp1240_;
					if (!(dim <= _tmp1241_)) {
						break;
					}
					_tmp1242_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1242_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1243_;
						ValaDataType* _tmp1244_;
						ValaDataType* _tmp1245_;
						ValaLocalVariable* _tmp1246_;
						ValaLocalVariable* _tmp1247_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1248_;
						const gchar* _tmp1249_;
						const gchar* _tmp1250_;
						ValaCCodeExpression* _tmp1251_;
						ValaLocalVariable* _tmp1252_;
						ValaCCodeExpression* _tmp1253_;
						ValaCCodeExpression* _tmp1254_;
						ValaCCodeAssignment* _tmp1255_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1256_;
						ValaCCodeIdentifier* _tmp1257_;
						ValaCCodeFunctionCall* _tmp1258_;
						ValaCCodeFunctionCall* _tmp1259_;
						ValaCCodeFunctionCall* _tmp1260_;
						ValaCCodeExpression* _tmp1261_;
						ValaCCodeFunctionCall* _tmp1262_;
						_tmp1243_ = itype;
						_tmp1244_ = vala_data_type_get_return_type (_tmp1243_);
						_tmp1245_ = _tmp1244_;
						_tmp1246_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1245_, TRUE, NULL, FALSE);
						_tmp1247_ = _tmp1246_;
						_vala_code_node_unref0 (_tmp1245_);
						temp_var = _tmp1247_;
						_tmp1248_ = temp_var;
						_tmp1249_ = vala_symbol_get_name ((ValaSymbol*) _tmp1248_);
						_tmp1250_ = _tmp1249_;
						_tmp1251_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1250_);
						temp_ref = _tmp1251_;
						_tmp1252_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1252_, FALSE);
						_tmp1253_ = temp_ref;
						_tmp1254_ = ccall_expr;
						_tmp1255_ = vala_ccode_assignment_new (_tmp1253_, _tmp1254_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1255_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1256_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1257_ = _tmp1256_;
						_tmp1258_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1257_);
						_tmp1259_ = _tmp1258_;
						_vala_ccode_node_unref0 (_tmp1257_);
						len_call = _tmp1259_;
						_tmp1260_ = len_call;
						_tmp1261_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1260_, _tmp1261_);
						_tmp1262_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1262_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1263_;
						_tmp1263_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1263_)) {
							gchar* _tmp1264_ = NULL;
							ValaMethod* _tmp1265_;
							gchar* _tmp1266_;
							gchar* length_ctype = NULL;
							gchar* _tmp1269_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1270_;
							ValaCType* _tmp1271_;
							ValaCType* _tmp1272_;
							ValaLocalVariable* _tmp1273_;
							ValaLocalVariable* _tmp1274_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1275_;
							const gchar* _tmp1276_;
							const gchar* _tmp1277_;
							ValaCCodeExpression* _tmp1278_;
							ValaLocalVariable* _tmp1279_;
							ValaHashMap* _tmp1280_;
							ValaMethod* _tmp1281_;
							ValaCCodeExpression* _tmp1282_;
							ValaCCodeUnaryExpression* _tmp1283_;
							ValaCCodeUnaryExpression* _tmp1284_;
							ValaCCodeExpression* _tmp1285_;
							_tmp1265_ = m;
							_tmp1266_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1265_);
							_tmp1264_ = _tmp1266_;
							if (_tmp1264_ == NULL) {
								ValaArrayType* _tmp1267_;
								gchar* _tmp1268_;
								_tmp1267_ = array_type;
								_tmp1268_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1267_);
								_g_free0 (_tmp1264_);
								_tmp1264_ = _tmp1268_;
							}
							_tmp1269_ = g_strdup (_tmp1264_);
							length_ctype = _tmp1269_;
							_tmp1270_ = length_ctype;
							_tmp1271_ = vala_ctype_new (_tmp1270_);
							_tmp1272_ = _tmp1271_;
							_tmp1273_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1272_, TRUE, NULL, TRUE);
							_tmp1274_ = _tmp1273_;
							_vala_code_node_unref0 (_tmp1272_);
							temp_var = _tmp1274_;
							_tmp1275_ = temp_var;
							_tmp1276_ = vala_symbol_get_name ((ValaSymbol*) _tmp1275_);
							_tmp1277_ = _tmp1276_;
							_tmp1278_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1277_);
							temp_ref = _tmp1278_;
							_tmp1279_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1279_, FALSE);
							_tmp1280_ = out_arg_map;
							_tmp1281_ = m;
							_tmp1282_ = temp_ref;
							_tmp1283_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1282_);
							_tmp1284_ = _tmp1283_;
							vala_map_set ((ValaMap*) _tmp1280_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1281_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1284_);
							_vala_ccode_node_unref0 (_tmp1284_);
							_tmp1285_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1285_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
							_g_free0 (_tmp1264_);
						} else {
							ValaMethod* _tmp1286_;
							gchar* _tmp1287_;
							gchar* _tmp1288_;
							gboolean _tmp1289_;
							_tmp1286_ = m;
							_tmp1287_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1286_);
							_tmp1288_ = _tmp1287_;
							_tmp1289_ = _tmp1288_ != NULL;
							_g_free0 (_tmp1288_);
							if (_tmp1289_) {
								ValaMethod* _tmp1290_;
								gchar* _tmp1291_;
								gchar* _tmp1292_;
								ValaCCodeConstant* _tmp1293_;
								ValaCCodeConstant* _tmp1294_;
								_tmp1290_ = m;
								_tmp1291_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1290_);
								_tmp1292_ = _tmp1291_;
								_tmp1293_ = vala_ccode_constant_new (_tmp1292_);
								_tmp1294_ = _tmp1293_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1294_);
								_vala_ccode_node_unref0 (_tmp1294_);
								_g_free0 (_tmp1292_);
							} else {
								ValaCCodeConstant* _tmp1295_;
								ValaCCodeConstant* _tmp1296_;
								_tmp1295_ = vala_ccode_constant_new ("-1");
								_tmp1296_ = _tmp1295_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1296_);
								_vala_ccode_node_unref0 (_tmp1296_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1297_ = FALSE;
		gboolean _tmp1298_ = FALSE;
		ValaMethod* _tmp1299_;
		_tmp1299_ = m;
		if (_tmp1299_ != NULL) {
			ValaMethod* _tmp1300_;
			ValaDataType* _tmp1301_;
			ValaDataType* _tmp1302_;
			_tmp1300_ = m;
			_tmp1301_ = vala_callable_get_return_type ((ValaCallable*) _tmp1300_);
			_tmp1302_ = _tmp1301_;
			_tmp1298_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1302_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1298_ = FALSE;
		}
		if (_tmp1298_) {
			ValaCCodeFunctionCall* _tmp1303_;
			ValaCCodeFunctionCall* _tmp1304_;
			_tmp1303_ = async_call;
			_tmp1304_ = ccall;
			_tmp1297_ = _tmp1303_ != _tmp1304_;
		} else {
			_tmp1297_ = FALSE;
		}
		if (_tmp1297_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1305_;
			ValaDataType* _tmp1306_;
			ValaDataType* _tmp1307_;
			ValaDelegateType* _tmp1308_;
			ValaDelegateType* _tmp1309_;
			ValaDelegate* _tmp1310_;
			ValaDelegate* _tmp1311_;
			gboolean _tmp1312_;
			gboolean _tmp1313_;
			_tmp1305_ = m;
			_tmp1306_ = vala_callable_get_return_type ((ValaCallable*) _tmp1305_);
			_tmp1307_ = _tmp1306_;
			_tmp1308_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1307_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1308_;
			_tmp1309_ = deleg_type;
			_tmp1310_ = vala_delegate_type_get_delegate_symbol (_tmp1309_);
			_tmp1311_ = _tmp1310_;
			_tmp1312_ = vala_delegate_get_has_target (_tmp1311_);
			_tmp1313_ = _tmp1312_;
			if (_tmp1313_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1314_;
				ValaVoidType* _tmp1315_;
				ValaPointerType* _tmp1316_;
				ValaPointerType* _tmp1317_;
				ValaLocalVariable* _tmp1318_;
				ValaLocalVariable* _tmp1319_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1320_;
				const gchar* _tmp1321_;
				const gchar* _tmp1322_;
				ValaCCodeExpression* _tmp1323_;
				ValaLocalVariable* _tmp1324_;
				ValaHashMap* _tmp1325_;
				ValaMethod* _tmp1326_;
				ValaCCodeExpression* _tmp1327_;
				ValaCCodeUnaryExpression* _tmp1328_;
				ValaCCodeUnaryExpression* _tmp1329_;
				ValaCCodeExpression* _tmp1330_;
				ValaDelegateType* _tmp1331_;
				_tmp1314_ = vala_void_type_new (NULL);
				_tmp1315_ = _tmp1314_;
				_tmp1316_ = vala_pointer_type_new ((ValaDataType*) _tmp1315_, NULL);
				_tmp1317_ = _tmp1316_;
				_tmp1318_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1317_, TRUE, NULL, TRUE);
				_tmp1319_ = _tmp1318_;
				_vala_code_node_unref0 (_tmp1317_);
				_vala_code_node_unref0 (_tmp1315_);
				temp_var = _tmp1319_;
				_tmp1320_ = temp_var;
				_tmp1321_ = vala_symbol_get_name ((ValaSymbol*) _tmp1320_);
				_tmp1322_ = _tmp1321_;
				_tmp1323_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1322_);
				temp_ref = _tmp1323_;
				_tmp1324_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1324_, FALSE);
				_tmp1325_ = out_arg_map;
				_tmp1326_ = m;
				_tmp1327_ = temp_ref;
				_tmp1328_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1327_);
				_tmp1329_ = _tmp1328_;
				vala_map_set ((ValaMap*) _tmp1325_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1326_), FALSE)), (ValaCCodeExpression*) _tmp1329_);
				_vala_ccode_node_unref0 (_tmp1329_);
				_tmp1330_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1330_);
				_tmp1331_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1331_)) {
					ValaDataType* _tmp1332_;
					ValaLocalVariable* _tmp1333_;
					ValaLocalVariable* _tmp1334_;
					const gchar* _tmp1335_;
					const gchar* _tmp1336_;
					ValaCCodeExpression* _tmp1337_;
					ValaLocalVariable* _tmp1338_;
					ValaHashMap* _tmp1339_;
					ValaMethod* _tmp1340_;
					ValaCCodeExpression* _tmp1341_;
					ValaCCodeUnaryExpression* _tmp1342_;
					ValaCCodeUnaryExpression* _tmp1343_;
					ValaCCodeExpression* _tmp1344_;
					_tmp1332_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1333_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1332_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1333_;
					_tmp1334_ = temp_var;
					_tmp1335_ = vala_symbol_get_name ((ValaSymbol*) _tmp1334_);
					_tmp1336_ = _tmp1335_;
					_tmp1337_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1336_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1337_;
					_tmp1338_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1338_, FALSE);
					_tmp1339_ = out_arg_map;
					_tmp1340_ = m;
					_tmp1341_ = temp_ref;
					_tmp1342_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1341_);
					_tmp1343_ = _tmp1342_;
					vala_map_set ((ValaMap*) _tmp1339_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1340_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1343_);
					_vala_ccode_node_unref0 (_tmp1343_);
					_tmp1344_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1344_);
				} else {
					ValaCCodeConstant* _tmp1345_;
					ValaCCodeConstant* _tmp1346_;
					_tmp1345_ = vala_ccode_constant_new ("NULL");
					_tmp1346_ = _tmp1345_;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1346_);
					_vala_ccode_node_unref0 (_tmp1346_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1347_;
				ValaCCodeConstant* _tmp1348_;
				_tmp1347_ = vala_ccode_constant_new ("NULL");
				_tmp1348_ = _tmp1347_;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1348_);
				_vala_ccode_node_unref0 (_tmp1348_);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1350_ = deleg;
	if (_tmp1350_ != NULL) {
		ValaDelegate* _tmp1351_;
		ValaDataType* _tmp1352_;
		ValaDataType* _tmp1353_;
		_tmp1351_ = deleg;
		_tmp1352_ = vala_callable_get_return_type ((ValaCallable*) _tmp1351_);
		_tmp1353_ = _tmp1352_;
		_tmp1349_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1353_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1349_ = FALSE;
	}
	if (_tmp1349_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1354_;
		ValaDataType* _tmp1355_;
		ValaDataType* _tmp1356_;
		ValaArrayType* _tmp1357_;
		_tmp1354_ = deleg;
		_tmp1355_ = vala_callable_get_return_type ((ValaCallable*) _tmp1354_);
		_tmp1356_ = _tmp1355_;
		_tmp1357_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1356_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1357_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1358_ = FALSE;
				_tmp1358_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1360_;
					gint _tmp1361_;
					gint _tmp1362_;
					ValaDelegate* _tmp1363_;
					if (!_tmp1358_) {
						gint _tmp1359_;
						_tmp1359_ = dim;
						dim = _tmp1359_ + 1;
					}
					_tmp1358_ = FALSE;
					_tmp1360_ = array_type;
					_tmp1361_ = vala_array_type_get_rank (_tmp1360_);
					_tmp1362_ = _tmp1361_;
					if (!(dim <= _tmp1362_)) {
						break;
					}
					_tmp1363_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1363_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1364_;
						ValaDataType* _tmp1365_;
						ValaDataType* _tmp1366_;
						ValaLocalVariable* _tmp1367_;
						ValaLocalVariable* _tmp1368_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1369_;
						const gchar* _tmp1370_;
						const gchar* _tmp1371_;
						ValaCCodeExpression* _tmp1372_;
						ValaLocalVariable* _tmp1373_;
						ValaCCodeExpression* _tmp1374_;
						ValaCCodeExpression* _tmp1375_;
						ValaCCodeAssignment* _tmp1376_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1377_;
						ValaCCodeIdentifier* _tmp1378_;
						ValaCCodeFunctionCall* _tmp1379_;
						ValaCCodeFunctionCall* _tmp1380_;
						ValaCCodeFunctionCall* _tmp1381_;
						ValaCCodeExpression* _tmp1382_;
						ValaCCodeFunctionCall* _tmp1383_;
						_tmp1364_ = itype;
						_tmp1365_ = vala_data_type_get_return_type (_tmp1364_);
						_tmp1366_ = _tmp1365_;
						_tmp1367_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1366_, TRUE, NULL, FALSE);
						_tmp1368_ = _tmp1367_;
						_vala_code_node_unref0 (_tmp1366_);
						temp_var = _tmp1368_;
						_tmp1369_ = temp_var;
						_tmp1370_ = vala_symbol_get_name ((ValaSymbol*) _tmp1369_);
						_tmp1371_ = _tmp1370_;
						_tmp1372_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1371_);
						temp_ref = _tmp1372_;
						_tmp1373_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1373_, FALSE);
						_tmp1374_ = temp_ref;
						_tmp1375_ = ccall_expr;
						_tmp1376_ = vala_ccode_assignment_new (_tmp1374_, _tmp1375_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1376_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1377_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1378_ = _tmp1377_;
						_tmp1379_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1378_);
						_tmp1380_ = _tmp1379_;
						_vala_ccode_node_unref0 (_tmp1378_);
						len_call = _tmp1380_;
						_tmp1381_ = len_call;
						_tmp1382_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1381_, _tmp1382_);
						_tmp1383_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1383_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1384_;
						_tmp1384_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1384_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaArrayType* _tmp1385_;
							gchar* _tmp1386_;
							gchar* _tmp1387_;
							ValaCType* _tmp1388_;
							ValaCType* _tmp1389_;
							ValaLocalVariable* _tmp1390_;
							ValaLocalVariable* _tmp1391_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1392_;
							const gchar* _tmp1393_;
							const gchar* _tmp1394_;
							ValaCCodeExpression* _tmp1395_;
							ValaLocalVariable* _tmp1396_;
							ValaHashMap* _tmp1397_;
							ValaDelegate* _tmp1398_;
							ValaCCodeExpression* _tmp1399_;
							ValaCCodeUnaryExpression* _tmp1400_;
							ValaCCodeUnaryExpression* _tmp1401_;
							ValaCCodeExpression* _tmp1402_;
							_tmp1385_ = array_type;
							_tmp1386_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1385_);
							_tmp1387_ = _tmp1386_;
							_tmp1388_ = vala_ctype_new (_tmp1387_);
							_tmp1389_ = _tmp1388_;
							_tmp1390_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1389_, TRUE, NULL, TRUE);
							_tmp1391_ = _tmp1390_;
							_vala_code_node_unref0 (_tmp1389_);
							_g_free0 (_tmp1387_);
							temp_var = _tmp1391_;
							_tmp1392_ = temp_var;
							_tmp1393_ = vala_symbol_get_name ((ValaSymbol*) _tmp1392_);
							_tmp1394_ = _tmp1393_;
							_tmp1395_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1394_);
							temp_ref = _tmp1395_;
							_tmp1396_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1396_, FALSE);
							_tmp1397_ = out_arg_map;
							_tmp1398_ = deleg;
							_tmp1399_ = temp_ref;
							_tmp1400_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1399_);
							_tmp1401_ = _tmp1400_;
							vala_map_set ((ValaMap*) _tmp1397_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1398_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1401_);
							_vala_ccode_node_unref0 (_tmp1401_);
							_tmp1402_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1402_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaCCodeConstant* _tmp1403_;
							ValaCCodeConstant* _tmp1404_;
							_tmp1403_ = vala_ccode_constant_new ("-1");
							_tmp1404_ = _tmp1403_;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1404_);
							_vala_ccode_node_unref0 (_tmp1404_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1405_ = FALSE;
		ValaDelegate* _tmp1406_;
		_tmp1406_ = deleg;
		if (_tmp1406_ != NULL) {
			ValaDelegate* _tmp1407_;
			ValaDataType* _tmp1408_;
			ValaDataType* _tmp1409_;
			_tmp1407_ = deleg;
			_tmp1408_ = vala_callable_get_return_type ((ValaCallable*) _tmp1407_);
			_tmp1409_ = _tmp1408_;
			_tmp1405_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1409_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1405_ = FALSE;
		}
		if (_tmp1405_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1410_;
			ValaDataType* _tmp1411_;
			ValaDataType* _tmp1412_;
			ValaDelegateType* _tmp1413_;
			ValaDelegateType* _tmp1414_;
			ValaDelegate* _tmp1415_;
			ValaDelegate* _tmp1416_;
			gboolean _tmp1417_;
			gboolean _tmp1418_;
			_tmp1410_ = deleg;
			_tmp1411_ = vala_callable_get_return_type ((ValaCallable*) _tmp1410_);
			_tmp1412_ = _tmp1411_;
			_tmp1413_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1412_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1413_;
			_tmp1414_ = deleg_type;
			_tmp1415_ = vala_delegate_type_get_delegate_symbol (_tmp1414_);
			_tmp1416_ = _tmp1415_;
			_tmp1417_ = vala_delegate_get_has_target (_tmp1416_);
			_tmp1418_ = _tmp1417_;
			if (_tmp1418_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1419_;
				ValaVoidType* _tmp1420_;
				ValaPointerType* _tmp1421_;
				ValaPointerType* _tmp1422_;
				ValaLocalVariable* _tmp1423_;
				ValaLocalVariable* _tmp1424_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1425_;
				const gchar* _tmp1426_;
				const gchar* _tmp1427_;
				ValaCCodeExpression* _tmp1428_;
				ValaLocalVariable* _tmp1429_;
				ValaHashMap* _tmp1430_;
				ValaDelegate* _tmp1431_;
				ValaCCodeExpression* _tmp1432_;
				ValaCCodeUnaryExpression* _tmp1433_;
				ValaCCodeUnaryExpression* _tmp1434_;
				ValaCCodeExpression* _tmp1435_;
				ValaDelegateType* _tmp1436_;
				_tmp1419_ = vala_void_type_new (NULL);
				_tmp1420_ = _tmp1419_;
				_tmp1421_ = vala_pointer_type_new ((ValaDataType*) _tmp1420_, NULL);
				_tmp1422_ = _tmp1421_;
				_tmp1423_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1422_, TRUE, NULL, TRUE);
				_tmp1424_ = _tmp1423_;
				_vala_code_node_unref0 (_tmp1422_);
				_vala_code_node_unref0 (_tmp1420_);
				temp_var = _tmp1424_;
				_tmp1425_ = temp_var;
				_tmp1426_ = vala_symbol_get_name ((ValaSymbol*) _tmp1425_);
				_tmp1427_ = _tmp1426_;
				_tmp1428_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1427_);
				temp_ref = _tmp1428_;
				_tmp1429_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1429_, FALSE);
				_tmp1430_ = out_arg_map;
				_tmp1431_ = deleg;
				_tmp1432_ = temp_ref;
				_tmp1433_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1432_);
				_tmp1434_ = _tmp1433_;
				vala_map_set ((ValaMap*) _tmp1430_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1431_), FALSE)), (ValaCCodeExpression*) _tmp1434_);
				_vala_ccode_node_unref0 (_tmp1434_);
				_tmp1435_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1435_);
				_tmp1436_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1436_)) {
					ValaDataType* _tmp1437_;
					ValaLocalVariable* _tmp1438_;
					ValaLocalVariable* _tmp1439_;
					const gchar* _tmp1440_;
					const gchar* _tmp1441_;
					ValaCCodeExpression* _tmp1442_;
					ValaLocalVariable* _tmp1443_;
					ValaHashMap* _tmp1444_;
					ValaDelegate* _tmp1445_;
					ValaCCodeExpression* _tmp1446_;
					ValaCCodeUnaryExpression* _tmp1447_;
					ValaCCodeUnaryExpression* _tmp1448_;
					ValaCCodeExpression* _tmp1449_;
					_tmp1437_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1438_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1437_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1438_;
					_tmp1439_ = temp_var;
					_tmp1440_ = vala_symbol_get_name ((ValaSymbol*) _tmp1439_);
					_tmp1441_ = _tmp1440_;
					_tmp1442_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1441_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1442_;
					_tmp1443_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1443_, FALSE);
					_tmp1444_ = out_arg_map;
					_tmp1445_ = deleg;
					_tmp1446_ = temp_ref;
					_tmp1447_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1446_);
					_tmp1448_ = _tmp1447_;
					vala_map_set ((ValaMap*) _tmp1444_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1445_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1448_);
					_vala_ccode_node_unref0 (_tmp1448_);
					_tmp1449_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1449_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1451_ = m;
	if (_tmp1451_ != NULL) {
		ValaMethod* _tmp1452_;
		gboolean _tmp1453_;
		gboolean _tmp1454_;
		_tmp1452_ = m;
		_tmp1453_ = vala_method_get_coroutine (_tmp1452_);
		_tmp1454_ = _tmp1453_;
		_tmp1450_ = _tmp1454_;
	} else {
		_tmp1450_ = FALSE;
	}
	if (_tmp1450_) {
		gboolean _tmp1455_;
		gboolean _tmp1456_;
		_tmp1455_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1456_ = _tmp1455_;
		if (_tmp1456_) {
			ValaHashMap* _tmp1457_;
			ValaMethod* _tmp1458_;
			ValaMethod* _tmp1459_;
			gchar* _tmp1460_;
			gchar* _tmp1461_;
			ValaCCodeIdentifier* _tmp1462_;
			ValaCCodeIdentifier* _tmp1463_;
			ValaHashMap* _tmp1464_;
			ValaCCodeIdentifier* _tmp1465_;
			ValaCCodeIdentifier* _tmp1466_;
			_tmp1457_ = in_arg_map;
			_tmp1458_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1459_ = _tmp1458_;
			_tmp1460_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1459_);
			_tmp1461_ = _tmp1460_;
			_tmp1462_ = vala_ccode_identifier_new (_tmp1461_);
			_tmp1463_ = _tmp1462_;
			vala_map_set ((ValaMap*) _tmp1457_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1463_);
			_vala_ccode_node_unref0 (_tmp1463_);
			_g_free0 (_tmp1461_);
			_tmp1464_ = in_arg_map;
			_tmp1465_ = vala_ccode_identifier_new ("_data_");
			_tmp1466_ = _tmp1465_;
			vala_map_set ((ValaMap*) _tmp1464_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1466_);
			_vala_ccode_node_unref0 (_tmp1466_);
		}
	}
	_tmp1467_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1468_ = _tmp1467_;
	if (_tmp1468_) {
		ValaHashMap* _tmp1469_;
		ValaCCodeExpression* _tmp1470_;
		ValaCCodeExpression* _tmp1471_;
		ValaCCodeUnaryExpression* _tmp1472_;
		ValaCCodeUnaryExpression* _tmp1473_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1469_ = out_arg_map;
		_tmp1470_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_inner_error_");
		_tmp1471_ = _tmp1470_;
		_tmp1472_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1471_);
		_tmp1473_ = _tmp1472_;
		vala_map_set ((ValaMap*) _tmp1469_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1473_);
		_vala_ccode_node_unref0 (_tmp1473_);
		_vala_ccode_node_unref0 (_tmp1471_);
	} else {
		gboolean _tmp1474_ = FALSE;
		gboolean _tmp1475_ = FALSE;
		ValaMethod* _tmp1476_;
		_tmp1476_ = m;
		if (_tmp1476_ != NULL) {
			ValaMethod* _tmp1477_;
			_tmp1477_ = m;
			_tmp1475_ = vala_method_has_error_type_parameter (_tmp1477_);
		} else {
			_tmp1475_ = FALSE;
		}
		if (_tmp1475_) {
			ValaCCodeFunctionCall* _tmp1478_;
			ValaCCodeFunctionCall* _tmp1479_;
			_tmp1478_ = async_call;
			_tmp1479_ = ccall;
			_tmp1474_ = _tmp1478_ != _tmp1479_;
		} else {
			_tmp1474_ = FALSE;
		}
		if (_tmp1474_) {
			ValaHashMap* _tmp1480_;
			ValaCCodeConstant* _tmp1481_;
			ValaCCodeConstant* _tmp1482_;
			_tmp1480_ = out_arg_map;
			_tmp1481_ = vala_ccode_constant_new ("NULL");
			_tmp1482_ = _tmp1481_;
			vala_map_set ((ValaMap*) _tmp1480_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1482_);
			_vala_ccode_node_unref0 (_tmp1482_);
		}
	}
	if (ellipsis) {
		ValaMethod* _tmp1483_;
		_tmp1483_ = m;
		if (_tmp1483_ == NULL) {
			ValaHashMap* _tmp1484_;
			ValaCCodeConstant* _tmp1485_;
			ValaCCodeConstant* _tmp1486_;
			_tmp1484_ = in_arg_map;
			_tmp1485_ = vala_ccode_constant_new ("NULL");
			_tmp1486_ = _tmp1485_;
			vala_map_set ((ValaMap*) _tmp1484_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1486_);
			_vala_ccode_node_unref0 (_tmp1486_);
		} else {
			gboolean _tmp1487_ = FALSE;
			gboolean _tmp1488_ = FALSE;
			gboolean _tmp1489_ = FALSE;
			ValaMethod* _tmp1490_;
			gboolean _tmp1491_;
			gboolean _tmp1492_;
			_tmp1490_ = m;
			_tmp1491_ = vala_method_get_printf_format (_tmp1490_);
			_tmp1492_ = _tmp1491_;
			if (!_tmp1492_) {
				ValaMethod* _tmp1493_;
				gboolean _tmp1494_;
				gboolean _tmp1495_;
				_tmp1493_ = m;
				_tmp1494_ = vala_method_get_scanf_format (_tmp1493_);
				_tmp1495_ = _tmp1494_;
				_tmp1489_ = !_tmp1495_;
			} else {
				_tmp1489_ = FALSE;
			}
			if (_tmp1489_) {
				ValaMethod* _tmp1496_;
				gchar* _tmp1497_;
				gchar* _tmp1498_;
				_tmp1496_ = m;
				_tmp1497_ = vala_get_ccode_sentinel (_tmp1496_);
				_tmp1498_ = _tmp1497_;
				_tmp1488_ = g_strcmp0 (_tmp1498_, "") != 0;
				_g_free0 (_tmp1498_);
			} else {
				_tmp1488_ = FALSE;
			}
			if (_tmp1488_) {
				gboolean _tmp1499_;
				gboolean _tmp1500_;
				_tmp1499_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1500_ = _tmp1499_;
				_tmp1487_ = !_tmp1500_;
			} else {
				_tmp1487_ = FALSE;
			}
			if (_tmp1487_) {
				ValaHashMap* _tmp1501_;
				ValaMethod* _tmp1502_;
				gchar* _tmp1503_;
				gchar* _tmp1504_;
				ValaCCodeConstant* _tmp1505_;
				ValaCCodeConstant* _tmp1506_;
				_tmp1501_ = in_arg_map;
				_tmp1502_ = m;
				_tmp1503_ = vala_get_ccode_sentinel (_tmp1502_);
				_tmp1504_ = _tmp1503_;
				_tmp1505_ = vala_ccode_constant_new (_tmp1504_);
				_tmp1506_ = _tmp1505_;
				vala_map_set ((ValaMap*) _tmp1501_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1506_);
				_vala_ccode_node_unref0 (_tmp1506_);
				_g_free0 (_tmp1504_);
			}
		}
	}
	_tmp1507_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1507_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp1508_;
		ValaDelegateType* _tmp1509_;
		ValaDelegate* d = NULL;
		ValaDelegateType* _tmp1510_;
		ValaDelegate* _tmp1511_;
		ValaDelegate* _tmp1512_;
		ValaDelegate* _tmp1513_;
		ValaDelegate* _tmp1514_;
		gboolean _tmp1515_;
		gboolean _tmp1516_;
		_tmp1508_ = itype;
		_tmp1509_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1508_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		deleg_type = _tmp1509_;
		_tmp1510_ = deleg_type;
		_tmp1511_ = vala_delegate_type_get_delegate_symbol (_tmp1510_);
		_tmp1512_ = _tmp1511_;
		_tmp1513_ = _vala_code_node_ref0 (_tmp1512_);
		d = _tmp1513_;
		_tmp1514_ = d;
		_tmp1515_ = vala_delegate_get_has_target (_tmp1514_);
		_tmp1516_ = _tmp1515_;
		if (_tmp1516_) {
			ValaCCodeExpression* delegate_target_destroy_notify = NULL;
			ValaHashMap* _tmp1517_;
			ValaDelegate* _tmp1518_;
			ValaExpression* _tmp1519_;
			ValaExpression* _tmp1520_;
			ValaCCodeExpression* _tmp1521_ = NULL;
			ValaCCodeExpression* _tmp1522_;
			ValaCCodeExpression* _tmp1523_;
			ValaHashMap* _tmp1524_;
			ValaDelegate* _tmp1525_;
			ValaExpression* _tmp1526_;
			ValaExpression* _tmp1527_;
			ValaCCodeExpression* _tmp1528_ = NULL;
			ValaCCodeExpression* _tmp1529_;
			ValaCCodeExpression* _tmp1530_;
			_tmp1517_ = in_arg_map;
			_tmp1518_ = d;
			_tmp1519_ = vala_method_call_get_call (expr);
			_tmp1520_ = _tmp1519_;
			_tmp1522_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1520_, &_tmp1521_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1521_;
			_tmp1523_ = _tmp1522_;
			vala_map_set ((ValaMap*) _tmp1517_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1518_), FALSE)), _tmp1523_);
			_vala_ccode_node_unref0 (_tmp1523_);
			_tmp1524_ = out_arg_map;
			_tmp1525_ = d;
			_tmp1526_ = vala_method_call_get_call (expr);
			_tmp1527_ = _tmp1526_;
			_tmp1529_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1527_, &_tmp1528_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1528_;
			_tmp1530_ = _tmp1529_;
			vala_map_set ((ValaMap*) _tmp1524_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1525_), FALSE)), _tmp1530_);
			_vala_ccode_node_unref0 (_tmp1530_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		}
		_vala_code_node_unref0 (d);
		_vala_code_node_unref0 (deleg_type);
	}
	_tmp1531_ = itype;
	_tmp1532_ = vala_data_type_get_return_type (_tmp1531_);
	_tmp1533_ = _tmp1532_;
	_tmp1534_ = vala_data_type_is_real_non_null_struct_type (_tmp1533_);
	_vala_code_node_unref0 (_tmp1533_);
	return_result_via_out_param = _tmp1534_;
	_tmp1536_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1536_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1537_;
		ValaDataType* _tmp1538_;
		ValaDataType* _tmp1539_;
		_tmp1537_ = itype;
		_tmp1538_ = vala_data_type_get_return_type (_tmp1537_);
		_tmp1539_ = _tmp1538_;
		_tmp1535_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1539_, VALA_TYPE_VOID_TYPE);
		_vala_code_node_unref0 (_tmp1539_);
	} else {
		_tmp1535_ = FALSE;
	}
	if (_tmp1535_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1540_;
		ValaSignal* _tmp1541_;
		ValaSignal* _tmp1542_;
		ValaSignal* _tmp1543_;
		gboolean _tmp1544_ = FALSE;
		gboolean _tmp1545_ = FALSE;
		ValaMemberAccess* _tmp1546_;
		_tmp1540_ = itype;
		_tmp1541_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1540_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1542_ = _tmp1541_;
		_tmp1543_ = _vala_code_node_ref0 (_tmp1542_);
		sig = _tmp1543_;
		_tmp1546_ = ma;
		if (_tmp1546_ != NULL) {
			ValaMemberAccess* _tmp1547_;
			ValaExpression* _tmp1548_;
			ValaExpression* _tmp1549_;
			_tmp1547_ = ma;
			_tmp1548_ = vala_member_access_get_inner (_tmp1547_);
			_tmp1549_ = _tmp1548_;
			_tmp1545_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1549_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1545_ = FALSE;
		}
		if (_tmp1545_) {
			ValaSignal* _tmp1550_;
			gboolean _tmp1551_;
			gboolean _tmp1552_;
			_tmp1550_ = sig;
			_tmp1551_ = vala_signal_get_is_virtual (_tmp1550_);
			_tmp1552_ = _tmp1551_;
			_tmp1544_ = _tmp1552_;
		} else {
			_tmp1544_ = FALSE;
		}
		if (_tmp1544_) {
		} else {
			gboolean _tmp1553_ = FALSE;
			ValaSignal* _tmp1554_;
			_tmp1554_ = sig;
			if (!vala_ccode_base_module_get_signal_has_emitter ((ValaCCodeBaseModule*) self, _tmp1554_)) {
				_tmp1553_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1555_;
				ValaSourceReference* _tmp1556_;
				ValaSourceReference* _tmp1557_;
				ValaSourceFile* _tmp1558_;
				ValaSourceFile* _tmp1559_;
				ValaSignal* _tmp1560_;
				ValaSourceReference* _tmp1561_;
				ValaSourceReference* _tmp1562_;
				ValaSourceFile* _tmp1563_;
				ValaSourceFile* _tmp1564_;
				_tmp1555_ = ma;
				_tmp1556_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1555_);
				_tmp1557_ = _tmp1556_;
				_tmp1558_ = vala_source_reference_get_file (_tmp1557_);
				_tmp1559_ = _tmp1558_;
				_tmp1560_ = sig;
				_tmp1561_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1560_);
				_tmp1562_ = _tmp1561_;
				_tmp1563_ = vala_source_reference_get_file (_tmp1562_);
				_tmp1564_ = _tmp1563_;
				_tmp1553_ = _tmp1559_ == _tmp1564_;
			}
			if (_tmp1553_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1565_ = async_call;
	_tmp1566_ = ccall;
	if (_tmp1565_ == _tmp1566_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	if (return_result_via_out_param) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1567_;
		ValaDataType* _tmp1568_;
		ValaDataType* _tmp1569_;
		ValaLocalVariable* _tmp1570_;
		ValaLocalVariable* _tmp1571_;
		ValaLocalVariable* _tmp1572_;
		const gchar* _tmp1573_;
		const gchar* _tmp1574_;
		ValaCCodeExpression* _tmp1575_;
		ValaLocalVariable* _tmp1576_;
		ValaHashMap* _tmp1577_;
		ValaCCodeExpression* _tmp1578_;
		ValaCCodeUnaryExpression* _tmp1579_;
		ValaCCodeUnaryExpression* _tmp1580_;
		_tmp1567_ = itype;
		_tmp1568_ = vala_data_type_get_return_type (_tmp1567_);
		_tmp1569_ = _tmp1568_;
		_tmp1570_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1569_, TRUE, NULL, TRUE);
		_tmp1571_ = _tmp1570_;
		_vala_code_node_unref0 (_tmp1569_);
		out_param_var = _tmp1571_;
		_tmp1572_ = out_param_var;
		_tmp1573_ = vala_symbol_get_name ((ValaSymbol*) _tmp1572_);
		_tmp1574_ = _tmp1573_;
		_tmp1575_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1574_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1575_;
		_tmp1576_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1576_, FALSE);
		_tmp1577_ = out_arg_map;
		_tmp1578_ = out_param_ref;
		_tmp1579_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1578_);
		_tmp1580_ = _tmp1579_;
		vala_map_set ((ValaMap*) _tmp1577_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1580_);
		_vala_ccode_node_unref0 (_tmp1580_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1581_ = async_call;
	_tmp1582_ = ccall;
	if (_tmp1581_ != _tmp1582_) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1593_;
			ValaHashMap* _tmp1594_;
			gpointer _tmp1595_;
			ValaCCodeExpression* _tmp1596_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1583_;
				ValaSet* _tmp1584_;
				ValaSet* _tmp1585_;
				ValaIterator* _tmp1586_;
				ValaIterator* _tmp1587_;
				_tmp1583_ = out_arg_map;
				_tmp1584_ = vala_map_get_keys ((ValaMap*) _tmp1583_);
				_tmp1585_ = _tmp1584_;
				_tmp1586_ = vala_iterable_iterator ((ValaIterable*) _tmp1585_);
				_tmp1587_ = _tmp1586_;
				_vala_iterable_unref0 (_tmp1585_);
				_pos_it = _tmp1587_;
				while (TRUE) {
					ValaIterator* _tmp1588_;
					gint pos = 0;
					ValaIterator* _tmp1589_;
					gpointer _tmp1590_;
					gboolean _tmp1591_ = FALSE;
					_tmp1588_ = _pos_it;
					if (!vala_iterator_next (_tmp1588_)) {
						break;
					}
					_tmp1589_ = _pos_it;
					_tmp1590_ = vala_iterator_get (_tmp1589_);
					pos = (gint) ((gintptr) _tmp1590_);
					if (pos > last_pos) {
						gboolean _tmp1592_ = FALSE;
						if (min_pos == -1) {
							_tmp1592_ = TRUE;
						} else {
							_tmp1592_ = pos < min_pos;
						}
						_tmp1591_ = _tmp1592_;
					} else {
						_tmp1591_ = FALSE;
					}
					if (_tmp1591_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1593_ = ccall;
			_tmp1594_ = out_arg_map;
			_tmp1595_ = vala_map_get ((ValaMap*) _tmp1594_, (gpointer) ((gintptr) min_pos));
			_tmp1596_ = (ValaCCodeExpression*) _tmp1595_;
			vala_ccode_function_call_add_argument (_tmp1593_, _tmp1596_);
			_vala_ccode_node_unref0 (_tmp1596_);
			last_pos = min_pos;
		}
	}
	_tmp1597_ = async_call;
	if (_tmp1597_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1608_;
			ValaHashMap* _tmp1609_;
			gpointer _tmp1610_;
			ValaCCodeExpression* _tmp1611_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1598_;
				ValaSet* _tmp1599_;
				ValaSet* _tmp1600_;
				ValaIterator* _tmp1601_;
				ValaIterator* _tmp1602_;
				_tmp1598_ = in_arg_map;
				_tmp1599_ = vala_map_get_keys ((ValaMap*) _tmp1598_);
				_tmp1600_ = _tmp1599_;
				_tmp1601_ = vala_iterable_iterator ((ValaIterable*) _tmp1600_);
				_tmp1602_ = _tmp1601_;
				_vala_iterable_unref0 (_tmp1600_);
				_pos_it = _tmp1602_;
				while (TRUE) {
					ValaIterator* _tmp1603_;
					gint pos = 0;
					ValaIterator* _tmp1604_;
					gpointer _tmp1605_;
					gboolean _tmp1606_ = FALSE;
					_tmp1603_ = _pos_it;
					if (!vala_iterator_next (_tmp1603_)) {
						break;
					}
					_tmp1604_ = _pos_it;
					_tmp1605_ = vala_iterator_get (_tmp1604_);
					pos = (gint) ((gintptr) _tmp1605_);
					if (pos > last_pos) {
						gboolean _tmp1607_ = FALSE;
						if (min_pos == -1) {
							_tmp1607_ = TRUE;
						} else {
							_tmp1607_ = pos < min_pos;
						}
						_tmp1606_ = _tmp1607_;
					} else {
						_tmp1606_ = FALSE;
					}
					if (_tmp1606_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1608_ = async_call;
			_tmp1609_ = in_arg_map;
			_tmp1610_ = vala_map_get ((ValaMap*) _tmp1609_, (gpointer) ((gintptr) min_pos));
			_tmp1611_ = (ValaCCodeExpression*) _tmp1610_;
			vala_ccode_function_call_add_argument (_tmp1608_, _tmp1611_);
			_vala_ccode_node_unref0 (_tmp1611_);
			last_pos = min_pos;
		}
	}
	_tmp1612_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1613_ = _tmp1612_;
	if (_tmp1613_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1614_;
		gint _tmp1615_;
		ValaCCodeFunction* _tmp1616_;
		ValaCCodeFunction* _tmp1617_;
		ValaCCodeIdentifier* _tmp1618_;
		ValaCCodeIdentifier* _tmp1619_;
		ValaCCodeMemberAccess* _tmp1620_;
		ValaCCodeMemberAccess* _tmp1621_;
		gchar* _tmp1622_;
		gchar* _tmp1623_;
		ValaCCodeConstant* _tmp1624_;
		ValaCCodeConstant* _tmp1625_;
		ValaCCodeFunction* _tmp1626_;
		ValaCCodeFunction* _tmp1627_;
		ValaCCodeFunctionCall* _tmp1628_;
		ValaCCodeFunction* _tmp1629_;
		ValaCCodeFunction* _tmp1630_;
		ValaCCodeConstant* _tmp1631_;
		ValaCCodeConstant* _tmp1632_;
		ValaCCodeFunction* _tmp1633_;
		ValaCCodeFunction* _tmp1634_;
		gchar* _tmp1635_;
		gchar* _tmp1636_;
		_tmp1614_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1615_ = _tmp1614_->next_coroutine_state;
		_tmp1614_->next_coroutine_state = _tmp1615_ + 1;
		state = _tmp1615_;
		_tmp1616_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1617_ = _tmp1616_;
		_tmp1618_ = vala_ccode_identifier_new ("_data_");
		_tmp1619_ = _tmp1618_;
		_tmp1620_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1619_, "_state_");
		_tmp1621_ = _tmp1620_;
		_tmp1622_ = g_strdup_printf ("%i", state);
		_tmp1623_ = _tmp1622_;
		_tmp1624_ = vala_ccode_constant_new (_tmp1623_);
		_tmp1625_ = _tmp1624_;
		vala_ccode_function_add_assignment (_tmp1617_, (ValaCCodeExpression*) _tmp1621_, (ValaCCodeExpression*) _tmp1625_);
		_vala_ccode_node_unref0 (_tmp1625_);
		_g_free0 (_tmp1623_);
		_vala_ccode_node_unref0 (_tmp1621_);
		_vala_ccode_node_unref0 (_tmp1619_);
		_tmp1626_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1627_ = _tmp1626_;
		_tmp1628_ = async_call;
		vala_ccode_function_add_expression (_tmp1627_, (ValaCCodeExpression*) _tmp1628_);
		_tmp1629_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1630_ = _tmp1629_;
		_tmp1631_ = vala_ccode_constant_new ("FALSE");
		_tmp1632_ = _tmp1631_;
		vala_ccode_function_add_return (_tmp1630_, (ValaCCodeExpression*) _tmp1632_);
		_vala_ccode_node_unref0 (_tmp1632_);
		_tmp1633_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1634_ = _tmp1633_;
		_tmp1635_ = g_strdup_printf ("_state_%d", state);
		_tmp1636_ = _tmp1635_;
		vala_ccode_function_add_label (_tmp1634_, _tmp1636_);
		_g_free0 (_tmp1636_);
	}
	_tmp1637_ = vala_method_call_get_is_assert (expr);
	_tmp1638_ = _tmp1637_;
	if (_tmp1638_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1639_;
		ValaSourceReference* _tmp1640_;
		ValaSourceLocation _tmp1641_ = {0};
		ValaSourceLocation _tmp1642_;
		gchar* _tmp1643_;
		ValaSourceReference* _tmp1644_;
		ValaSourceReference* _tmp1645_;
		ValaSourceLocation _tmp1646_ = {0};
		ValaSourceLocation _tmp1647_;
		gchar* _tmp1648_;
		ValaSourceReference* _tmp1649_;
		ValaSourceReference* _tmp1650_;
		ValaSourceLocation _tmp1651_ = {0};
		ValaSourceLocation _tmp1652_;
		gchar* _tmp1653_;
		gchar* _tmp1654_;
		ValaCCodeFunctionCall* _tmp1655_;
		ValaCCodeIdentifier* _tmp1656_;
		ValaCCodeIdentifier* _tmp1657_;
		ValaCCodeFunctionCall* _tmp1658_;
		const gchar* _tmp1659_;
		gchar* _tmp1660_;
		gchar* _tmp1661_;
		gchar* _tmp1662_;
		gchar* _tmp1663_;
		gchar* _tmp1664_;
		gchar* _tmp1665_;
		ValaCCodeConstant* _tmp1666_;
		ValaCCodeConstant* _tmp1667_;
		_tmp1639_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1640_ = _tmp1639_;
		vala_source_reference_get_begin (_tmp1640_, &_tmp1641_);
		_tmp1642_ = _tmp1641_;
		_tmp1643_ = _tmp1642_.pos;
		_tmp1644_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1645_ = _tmp1644_;
		vala_source_reference_get_end (_tmp1645_, &_tmp1646_);
		_tmp1647_ = _tmp1646_;
		_tmp1648_ = _tmp1647_.pos;
		_tmp1649_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1650_ = _tmp1649_;
		vala_source_reference_get_begin (_tmp1650_, &_tmp1651_);
		_tmp1652_ = _tmp1651_;
		_tmp1653_ = _tmp1652_.pos;
		_tmp1654_ = string_substring ((const gchar*) _tmp1643_, (glong) 0, (glong) ((gint) (_tmp1648_ - _tmp1653_)));
		message = _tmp1654_;
		_tmp1655_ = ccall;
		_tmp1656_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1657_ = _tmp1656_;
		vala_ccode_function_call_set_call (_tmp1655_, (ValaCCodeExpression*) _tmp1657_);
		_vala_ccode_node_unref0 (_tmp1657_);
		_tmp1658_ = ccall;
		_tmp1659_ = message;
		_tmp1660_ = string_replace (_tmp1659_, "\n", " ");
		_tmp1661_ = _tmp1660_;
		_tmp1662_ = g_strescape (_tmp1661_, "");
		_tmp1663_ = _tmp1662_;
		_tmp1664_ = g_strdup_printf ("\"%s\"", _tmp1663_);
		_tmp1665_ = _tmp1664_;
		_tmp1666_ = vala_ccode_constant_new (_tmp1665_);
		_tmp1667_ = _tmp1666_;
		vala_ccode_function_call_add_argument (_tmp1658_, (ValaCCodeExpression*) _tmp1667_);
		_vala_ccode_node_unref0 (_tmp1667_);
		_g_free0 (_tmp1665_);
		_g_free0 (_tmp1663_);
		_g_free0 (_tmp1661_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	if (return_result_via_out_param) {
		ValaCCodeFunction* _tmp1668_;
		ValaCCodeFunction* _tmp1669_;
		ValaCCodeExpression* _tmp1670_;
		ValaCCodeExpression* _tmp1671_;
		ValaCCodeExpression* _tmp1672_;
		_tmp1668_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1669_ = _tmp1668_;
		_tmp1670_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1669_, _tmp1670_);
		_tmp1671_ = out_param_ref;
		_tmp1672_ = _vala_ccode_node_ref0 (_tmp1671_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1672_;
	}
	_tmp1675_ = m;
	if (_tmp1675_ != NULL) {
		ValaMethod* _tmp1676_;
		ValaMemberBinding _tmp1677_;
		ValaMemberBinding _tmp1678_;
		_tmp1676_ = m;
		_tmp1677_ = vala_method_get_binding (_tmp1676_);
		_tmp1678_ = _tmp1677_;
		_tmp1674_ = _tmp1678_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1674_ = FALSE;
	}
	if (_tmp1674_) {
		ValaMethod* _tmp1679_;
		gboolean _tmp1680_;
		gboolean _tmp1681_;
		_tmp1679_ = m;
		_tmp1680_ = vala_method_get_returns_modified_pointer (_tmp1679_);
		_tmp1681_ = _tmp1680_;
		_tmp1673_ = _tmp1681_;
	} else {
		_tmp1673_ = FALSE;
	}
	if (_tmp1673_) {
		gboolean _tmp1682_ = FALSE;
		gboolean _tmp1683_ = FALSE;
		ValaMemberAccess* _tmp1684_;
		_tmp1684_ = ma;
		if (_tmp1684_ != NULL) {
			ValaMemberAccess* _tmp1685_;
			ValaExpression* _tmp1686_;
			ValaExpression* _tmp1687_;
			ValaSymbol* _tmp1688_;
			ValaSymbol* _tmp1689_;
			_tmp1685_ = ma;
			_tmp1686_ = vala_member_access_get_inner (_tmp1685_);
			_tmp1687_ = _tmp1686_;
			_tmp1688_ = vala_expression_get_symbol_reference (_tmp1687_);
			_tmp1689_ = _tmp1688_;
			_tmp1683_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1689_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1683_ = FALSE;
		}
		if (_tmp1683_) {
			ValaMemberAccess* _tmp1690_;
			ValaExpression* _tmp1691_;
			ValaExpression* _tmp1692_;
			_tmp1690_ = ma;
			_tmp1691_ = vala_member_access_get_inner (_tmp1690_);
			_tmp1692_ = _tmp1691_;
			_tmp1682_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1692_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1682_ = FALSE;
		}
		if (_tmp1682_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1693_;
			ValaExpression* _tmp1694_;
			ValaExpression* _tmp1695_;
			ValaSymbol* _tmp1696_;
			ValaSymbol* _tmp1697_;
			ValaProperty* _tmp1698_;
			ValaProperty* _tmp1699_;
			ValaMemberAccess* _tmp1700_;
			ValaExpression* _tmp1701_;
			ValaExpression* _tmp1702_;
			ValaExpression* _tmp1703_;
			ValaExpression* _tmp1704_;
			ValaDataType* _tmp1705_;
			ValaDataType* _tmp1706_;
			ValaCCodeExpression* _tmp1707_;
			ValaGLibValue* _tmp1708_;
			ValaGLibValue* _tmp1709_;
			_tmp1693_ = ma;
			_tmp1694_ = vala_member_access_get_inner (_tmp1693_);
			_tmp1695_ = _tmp1694_;
			_tmp1696_ = vala_expression_get_symbol_reference (_tmp1695_);
			_tmp1697_ = _tmp1696_;
			_tmp1698_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1697_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1698_;
			_tmp1699_ = prop;
			_tmp1700_ = ma;
			_tmp1701_ = vala_member_access_get_inner (_tmp1700_);
			_tmp1702_ = _tmp1701_;
			_tmp1703_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1702_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1704_ = _tmp1703_;
			_tmp1705_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1706_ = _tmp1705_;
			_tmp1707_ = ccall_expr;
			_tmp1708_ = vala_glib_value_new (_tmp1706_, _tmp1707_, FALSE);
			_tmp1709_ = _tmp1708_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1699_, _tmp1704_, (ValaTargetValue*) _tmp1709_);
			_vala_target_value_unref0 (_tmp1709_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1710_;
			ValaCCodeExpression* _tmp1711_;
			ValaCCodeAssignment* _tmp1712_;
			_tmp1710_ = instance;
			_tmp1711_ = ccall_expr;
			_tmp1712_ = vala_ccode_assignment_new (_tmp1710_, _tmp1711_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1712_;
		}
	}
	_tmp1715_ = m;
	if (_tmp1715_ != NULL) {
		ValaMethod* _tmp1716_;
		gchar* _tmp1717_;
		gchar* _tmp1718_;
		_tmp1716_ = m;
		_tmp1717_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1716_);
		_tmp1718_ = _tmp1717_;
		_tmp1714_ = _tmp1718_ != NULL;
		_g_free0 (_tmp1718_);
	} else {
		_tmp1714_ = FALSE;
	}
	if (_tmp1714_) {
		ValaMethod* _tmp1719_;
		gchar* _tmp1720_;
		gchar* _tmp1721_;
		ValaMethod* _tmp1722_;
		ValaDataType* _tmp1723_;
		ValaDataType* _tmp1724_;
		gchar* _tmp1725_;
		gchar* _tmp1726_;
		_tmp1719_ = m;
		_tmp1720_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1719_);
		_tmp1721_ = _tmp1720_;
		_tmp1722_ = m;
		_tmp1723_ = vala_callable_get_return_type ((ValaCallable*) _tmp1722_);
		_tmp1724_ = _tmp1723_;
		_tmp1725_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1724_);
		_tmp1726_ = _tmp1725_;
		_tmp1713_ = g_strcmp0 (_tmp1721_, _tmp1726_) != 0;
		_g_free0 (_tmp1726_);
		_g_free0 (_tmp1721_);
	} else {
		_tmp1713_ = FALSE;
	}
	if (_tmp1713_) {
		ValaCCodeExpression* _tmp1727_;
		ValaMethod* _tmp1728_;
		ValaDataType* _tmp1729_;
		ValaDataType* _tmp1730_;
		gchar* _tmp1731_;
		gchar* _tmp1732_;
		ValaCCodeCastExpression* _tmp1733_;
		_tmp1727_ = ccall_expr;
		_tmp1728_ = m;
		_tmp1729_ = vala_callable_get_return_type ((ValaCallable*) _tmp1728_);
		_tmp1730_ = _tmp1729_;
		_tmp1731_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1730_);
		_tmp1732_ = _tmp1731_;
		_tmp1733_ = vala_ccode_cast_expression_new (_tmp1727_, _tmp1732_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1733_;
		_g_free0 (_tmp1732_);
	}
	_tmp1734_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1734_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1735_;
		ValaList* _tmp1736_;
		ValaIterator* _tmp1737_;
		ValaIterator* _tmp1738_;
		ValaIterator* _tmp1739_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1740_;
		gpointer _tmp1741_;
		ValaExpression* _tmp1742_;
		ValaCCodeExpression* _tmp1743_;
		ValaCCodeExpression* _tmp1744_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1745_;
		ValaLocalVariable* _tmp1746_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1747_;
		const gchar* _tmp1748_;
		const gchar* _tmp1749_;
		ValaCCodeExpression* _tmp1750_;
		ValaLocalVariable* _tmp1751_;
		ValaCCodeFile* _tmp1752_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1753_;
		ValaExpression* _tmp1754_;
		ValaExpression* _tmp1755_;
		ValaCCodeExpression* _tmp1756_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1757_;
		ValaExpression* _tmp1758_;
		ValaExpression* _tmp1759_;
		ValaCCodeExpression* _tmp1760_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1761_;
		ValaExpression* _tmp1762_;
		ValaExpression* _tmp1763_;
		ValaDataType* _tmp1764_;
		ValaDataType* _tmp1765_;
		ValaArrayType* _tmp1766_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1767_;
		ValaDataType* _tmp1768_;
		ValaDataType* _tmp1769_;
		gchar* _tmp1770_;
		gchar* _tmp1771_;
		gchar* _tmp1772_;
		gchar* _tmp1773_;
		ValaCCodeIdentifier* _tmp1774_;
		ValaCCodeIdentifier* _tmp1775_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1776_;
		ValaCCodeExpression* _tmp1777_;
		ValaCCodeBinaryExpression* _tmp1778_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1779_;
		ValaCCodeExpression* _tmp1780_;
		ValaCCodeBinaryExpression* _tmp1781_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1782_;
		ValaCCodeIdentifier* _tmp1783_;
		ValaCCodeFunctionCall* _tmp1784_;
		ValaCCodeFunctionCall* _tmp1785_;
		ValaCCodeFunctionCall* _tmp1786_;
		ValaCCodeExpression* _tmp1787_;
		ValaCCodeExpression* _tmp1788_;
		ValaCCodeBinaryExpression* _tmp1789_;
		ValaCCodeBinaryExpression* _tmp1790_;
		ValaCCodeFunctionCall* _tmp1791_;
		ValaCCodeConstant* _tmp1792_;
		ValaCCodeConstant* _tmp1793_;
		ValaCCodeFunctionCall* _tmp1794_;
		ValaCCodeIdentifier* _tmp1795_;
		ValaCCodeBinaryExpression* _tmp1796_;
		ValaCCodeBinaryExpression* _tmp1797_;
		ValaCCodeBinaryExpression* _tmp1798_;
		ValaCCodeFunction* _tmp1799_;
		ValaCCodeFunction* _tmp1800_;
		ValaCCodeExpression* _tmp1801_;
		ValaCCodeExpression* _tmp1802_;
		ValaCCodeFunction* _tmp1803_;
		ValaCCodeFunction* _tmp1804_;
		ValaCCodeExpression* _tmp1805_;
		ValaCCodeFunction* _tmp1806_;
		ValaCCodeFunction* _tmp1807_;
		ValaCCodeBinaryExpression* _tmp1808_;
		ValaCCodeFunctionCall* _tmp1809_;
		ValaCCodeConstant* _tmp1810_;
		ValaCCodeConstant* _tmp1811_;
		ValaCCodeConditionalExpression* _tmp1812_;
		ValaCCodeConditionalExpression* _tmp1813_;
		ValaCCodeFunction* _tmp1814_;
		ValaCCodeFunction* _tmp1815_;
		ValaMemberAccess* _tmp1816_;
		ValaExpression* _tmp1817_;
		ValaExpression* _tmp1818_;
		ValaCCodeExpression* _tmp1819_;
		ValaCCodeExpression* _tmp1820_;
		ValaCCodeExpression* _tmp1821_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1822_;
		ValaExpression* _tmp1823_;
		ValaExpression* _tmp1824_;
		ValaSymbol* _tmp1825_;
		ValaSymbol* _tmp1826_;
		ValaSymbol* _tmp1827_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1828_;
		ValaLocalVariable* _tmp1829_;
		gboolean _tmp1830_ = FALSE;
		gboolean _tmp1831_ = FALSE;
		ValaSymbol* _tmp1832_;
		_tmp1735_ = vala_method_call_get_argument_list (expr);
		_tmp1736_ = _tmp1735_;
		_tmp1737_ = vala_iterable_iterator ((ValaIterable*) _tmp1736_);
		_tmp1738_ = _tmp1737_;
		_vala_iterable_unref0 (_tmp1736_);
		arg_it = _tmp1738_;
		_tmp1739_ = arg_it;
		vala_iterator_next (_tmp1739_);
		_tmp1740_ = arg_it;
		_tmp1741_ = vala_iterator_get (_tmp1740_);
		_tmp1742_ = (ValaExpression*) _tmp1741_;
		_tmp1743_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1742_);
		_tmp1744_ = _tmp1743_;
		_vala_code_node_unref0 (_tmp1742_);
		new_size = _tmp1744_;
		_tmp1745_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1746_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1745_, TRUE, NULL, FALSE);
		temp_decl = _tmp1746_;
		_tmp1747_ = temp_decl;
		_tmp1748_ = vala_symbol_get_name ((ValaSymbol*) _tmp1747_);
		_tmp1749_ = _tmp1748_;
		_tmp1750_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1749_);
		temp_ref = _tmp1750_;
		_tmp1751_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1751_, FALSE);
		_tmp1752_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1752_, "string.h", FALSE);
		_tmp1753_ = ma;
		_tmp1754_ = vala_member_access_get_inner (_tmp1753_);
		_tmp1755_ = _tmp1754_;
		_tmp1756_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1755_, 1);
		clen = _tmp1756_;
		_tmp1757_ = ma;
		_tmp1758_ = vala_member_access_get_inner (_tmp1757_);
		_tmp1759_ = _tmp1758_;
		_tmp1760_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1759_);
		celems = _tmp1760_;
		_tmp1761_ = ma;
		_tmp1762_ = vala_member_access_get_inner (_tmp1761_);
		_tmp1763_ = _tmp1762_;
		_tmp1764_ = vala_expression_get_value_type (_tmp1763_);
		_tmp1765_ = _tmp1764_;
		_tmp1766_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1765_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1766_;
		_tmp1767_ = array_type;
		_tmp1768_ = vala_array_type_get_element_type (_tmp1767_);
		_tmp1769_ = _tmp1768_;
		_tmp1770_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1769_);
		_tmp1771_ = _tmp1770_;
		_tmp1772_ = g_strdup_printf ("sizeof (%s)", _tmp1771_);
		_tmp1773_ = _tmp1772_;
		_tmp1774_ = vala_ccode_identifier_new (_tmp1773_);
		_tmp1775_ = _tmp1774_;
		_g_free0 (_tmp1773_);
		_g_free0 (_tmp1771_);
		csizeof = _tmp1775_;
		_tmp1776_ = temp_ref;
		_tmp1777_ = clen;
		_tmp1778_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1776_, _tmp1777_);
		cdelta = _tmp1778_;
		_tmp1779_ = temp_ref;
		_tmp1780_ = clen;
		_tmp1781_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1779_, _tmp1780_);
		ccheck = _tmp1781_;
		_tmp1782_ = vala_ccode_identifier_new ("memset");
		_tmp1783_ = _tmp1782_;
		_tmp1784_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1783_);
		_tmp1785_ = _tmp1784_;
		_vala_ccode_node_unref0 (_tmp1783_);
		czero = _tmp1785_;
		_tmp1786_ = czero;
		_tmp1787_ = celems;
		_tmp1788_ = clen;
		_tmp1789_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1787_, _tmp1788_);
		_tmp1790_ = _tmp1789_;
		vala_ccode_function_call_add_argument (_tmp1786_, (ValaCCodeExpression*) _tmp1790_);
		_vala_ccode_node_unref0 (_tmp1790_);
		_tmp1791_ = czero;
		_tmp1792_ = vala_ccode_constant_new ("0");
		_tmp1793_ = _tmp1792_;
		vala_ccode_function_call_add_argument (_tmp1791_, (ValaCCodeExpression*) _tmp1793_);
		_vala_ccode_node_unref0 (_tmp1793_);
		_tmp1794_ = czero;
		_tmp1795_ = csizeof;
		_tmp1796_ = cdelta;
		_tmp1797_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1795_, (ValaCCodeExpression*) _tmp1796_);
		_tmp1798_ = _tmp1797_;
		vala_ccode_function_call_add_argument (_tmp1794_, (ValaCCodeExpression*) _tmp1798_);
		_vala_ccode_node_unref0 (_tmp1798_);
		_tmp1799_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1800_ = _tmp1799_;
		_tmp1801_ = temp_ref;
		_tmp1802_ = new_size;
		vala_ccode_function_add_assignment (_tmp1800_, _tmp1801_, _tmp1802_);
		_tmp1803_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1804_ = _tmp1803_;
		_tmp1805_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1804_, _tmp1805_);
		_tmp1806_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1807_ = _tmp1806_;
		_tmp1808_ = ccheck;
		_tmp1809_ = czero;
		_tmp1810_ = vala_ccode_constant_new ("NULL");
		_tmp1811_ = _tmp1810_;
		_tmp1812_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1808_, (ValaCCodeExpression*) _tmp1809_, (ValaCCodeExpression*) _tmp1811_);
		_tmp1813_ = _tmp1812_;
		vala_ccode_function_add_expression (_tmp1807_, (ValaCCodeExpression*) _tmp1813_);
		_vala_ccode_node_unref0 (_tmp1813_);
		_vala_ccode_node_unref0 (_tmp1811_);
		_tmp1814_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1815_ = _tmp1814_;
		_tmp1816_ = ma;
		_tmp1817_ = vala_member_access_get_inner (_tmp1816_);
		_tmp1818_ = _tmp1817_;
		_tmp1819_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1818_, 1);
		_tmp1820_ = _tmp1819_;
		_tmp1821_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1815_, _tmp1820_, _tmp1821_);
		_vala_ccode_node_unref0 (_tmp1820_);
		_tmp1822_ = ma;
		_tmp1823_ = vala_member_access_get_inner (_tmp1822_);
		_tmp1824_ = _tmp1823_;
		_tmp1825_ = vala_expression_get_symbol_reference (_tmp1824_);
		_tmp1826_ = _tmp1825_;
		_tmp1827_ = _vala_code_node_ref0 (_tmp1826_);
		array_var = _tmp1827_;
		_tmp1828_ = array_var;
		_tmp1829_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1828_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1828_) : NULL);
		array_local = _tmp1829_;
		_tmp1832_ = array_var;
		if (_tmp1832_ != NULL) {
			ValaSymbol* _tmp1833_;
			_tmp1833_ = array_var;
			_tmp1831_ = vala_symbol_is_internal_symbol (_tmp1833_);
		} else {
			_tmp1831_ = FALSE;
		}
		if (_tmp1831_) {
			gboolean _tmp1834_ = FALSE;
			gboolean _tmp1835_ = FALSE;
			ValaSymbol* _tmp1836_;
			_tmp1836_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1836_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1837_;
				gboolean _tmp1838_;
				gboolean _tmp1839_;
				_tmp1837_ = array_local;
				_tmp1838_ = vala_local_variable_get_captured (_tmp1837_);
				_tmp1839_ = _tmp1838_;
				_tmp1835_ = !_tmp1839_;
			} else {
				_tmp1835_ = FALSE;
			}
			if (_tmp1835_) {
				_tmp1834_ = TRUE;
			} else {
				ValaSymbol* _tmp1840_;
				_tmp1840_ = array_var;
				_tmp1834_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1840_, VALA_TYPE_FIELD);
			}
			_tmp1830_ = _tmp1834_;
		} else {
			_tmp1830_ = FALSE;
		}
		if (_tmp1830_) {
			ValaCCodeFunction* _tmp1841_;
			ValaCCodeFunction* _tmp1842_;
			ValaMemberAccess* _tmp1843_;
			ValaExpression* _tmp1844_;
			ValaExpression* _tmp1845_;
			ValaTargetValue* _tmp1846_;
			ValaTargetValue* _tmp1847_;
			ValaCCodeExpression* _tmp1848_;
			ValaCCodeExpression* _tmp1849_;
			ValaCCodeExpression* _tmp1850_;
			_tmp1841_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1842_ = _tmp1841_;
			_tmp1843_ = ma;
			_tmp1844_ = vala_member_access_get_inner (_tmp1843_);
			_tmp1845_ = _tmp1844_;
			_tmp1846_ = vala_expression_get_target_value (_tmp1845_);
			_tmp1847_ = _tmp1846_;
			_tmp1848_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp1847_);
			_tmp1849_ = _tmp1848_;
			_tmp1850_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1842_, _tmp1849_, _tmp1850_);
			_vala_ccode_node_unref0 (_tmp1849_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1852_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1853_ = _tmp1852_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1853_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1854_;
		ValaDataType* _tmp1855_;
		_tmp1854_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1855_ = _tmp1854_;
		_tmp1851_ = !vala_data_type_is_disposable (_tmp1855_);
	} else {
		_tmp1851_ = FALSE;
	}
	if (_tmp1851_) {
		gboolean _tmp1856_ = FALSE;
		ValaCCodeExpression* _tmp1857_;
		_tmp1857_ = ccall_expr;
		if (_tmp1857_ != NULL) {
			_tmp1856_ = !return_result_via_out_param;
		} else {
			_tmp1856_ = FALSE;
		}
		if (_tmp1856_) {
			ValaCCodeFunction* _tmp1858_;
			ValaCCodeFunction* _tmp1859_;
			ValaCCodeExpression* _tmp1860_;
			_tmp1858_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1859_ = _tmp1858_;
			_tmp1860_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1859_, _tmp1860_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1861_;
		ValaDataType* _tmp1862_;
		gboolean _tmp1863_ = FALSE;
		ValaDataType* _tmp1864_;
		ValaDataType* _tmp1865_;
		gboolean _tmp1892_ = FALSE;
		ValaMethod* _tmp1893_;
		_tmp1861_ = itype;
		_tmp1862_ = vala_data_type_get_return_type (_tmp1861_);
		result_type = _tmp1862_;
		_tmp1864_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1865_ = _tmp1864_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1865_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1866_;
			ValaDataType* _tmp1867_;
			_tmp1866_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1867_ = _tmp1866_;
			_tmp1863_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1867_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1863_ = FALSE;
		}
		if (_tmp1863_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1868_;
			ValaDataType* _tmp1869_;
			ValaTypeParameter* _tmp1870_;
			ValaTypeParameter* _tmp1871_;
			ValaTypeParameter* _tmp1872_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1873_;
			ValaSymbol* _tmp1874_;
			ValaSymbol* _tmp1875_;
			ValaSymbol* _tmp1876_;
			ValaSymbol* _tmp1877_;
			ValaStruct* _tmp1878_;
			gboolean _tmp1879_ = FALSE;
			ValaTypeParameter* _tmp1880_;
			ValaSymbol* _tmp1881_;
			ValaSymbol* _tmp1882_;
			ValaTypeSymbol* _tmp1883_;
			_tmp1868_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1869_ = _tmp1868_;
			_tmp1870_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1869_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1871_ = _tmp1870_;
			_tmp1872_ = _vala_code_node_ref0 (_tmp1871_);
			type_parameter = _tmp1872_;
			_tmp1873_ = type_parameter;
			_tmp1874_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1873_);
			_tmp1875_ = _tmp1874_;
			_tmp1876_ = vala_symbol_get_parent_symbol (_tmp1875_);
			_tmp1877_ = _tmp1876_;
			_tmp1878_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1877_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1877_) : NULL);
			st = _tmp1878_;
			_tmp1880_ = type_parameter;
			_tmp1881_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1880_);
			_tmp1882_ = _tmp1881_;
			_tmp1883_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1882_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1883_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1879_ = TRUE;
			} else {
				gboolean _tmp1884_ = FALSE;
				ValaStruct* _tmp1885_;
				_tmp1885_ = st;
				if (_tmp1885_ != NULL) {
					ValaStruct* _tmp1886_;
					gchar* _tmp1887_;
					gchar* _tmp1888_;
					_tmp1886_ = st;
					_tmp1887_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1886_);
					_tmp1888_ = _tmp1887_;
					_tmp1884_ = g_strcmp0 (_tmp1888_, "va_list") == 0;
					_g_free0 (_tmp1888_);
				} else {
					_tmp1884_ = FALSE;
				}
				_tmp1879_ = _tmp1884_;
			}
			if (_tmp1879_) {
				ValaDataType* _tmp1889_;
				ValaDataType* _tmp1890_;
				ValaDataType* _tmp1891_;
				_tmp1889_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp1890_ = _tmp1889_;
				_tmp1891_ = _vala_code_node_ref0 (_tmp1890_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp1891_;
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp1893_ = m;
		if (_tmp1893_ != NULL) {
			ValaMethod* _tmp1894_;
			_tmp1894_ = m;
			_tmp1892_ = vala_method_get_format_arg_index (_tmp1894_) >= 0;
		} else {
			_tmp1892_ = FALSE;
		}
		if (_tmp1892_) {
			ValaCCodeExpression* _tmp1895_;
			_tmp1895_ = ccall_expr;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1895_);
		} else {
			gboolean _tmp1896_ = FALSE;
			ValaMethod* _tmp1897_;
			_tmp1897_ = m;
			if (_tmp1897_ != NULL) {
				ValaMethod* _tmp1898_;
				_tmp1898_ = m;
				_tmp1896_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp1898_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp1896_ = FALSE;
			}
			if (_tmp1896_) {
				ValaCCodeExpression* _tmp1899_;
				_tmp1899_ = ccall_expr;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1899_);
			} else {
				gboolean _tmp1900_ = FALSE;
				gboolean _tmp1901_ = FALSE;
				if (!return_result_via_out_param) {
					gboolean _tmp1902_ = FALSE;
					gboolean _tmp1903_ = FALSE;
					ValaMethod* _tmp1904_;
					_tmp1904_ = m;
					if (_tmp1904_ != NULL) {
						ValaMethod* _tmp1905_;
						_tmp1905_ = m;
						_tmp1903_ = !vala_ccode_method_call_module_has_ref_out_param (self, (ValaCallable*) _tmp1905_);
					} else {
						_tmp1903_ = FALSE;
					}
					if (_tmp1903_) {
						_tmp1902_ = TRUE;
					} else {
						gboolean _tmp1906_ = FALSE;
						ValaDelegate* _tmp1907_;
						_tmp1907_ = deleg;
						if (_tmp1907_ != NULL) {
							ValaDelegate* _tmp1908_;
							_tmp1908_ = deleg;
							_tmp1906_ = !vala_ccode_method_call_module_has_ref_out_param (self, (ValaCallable*) _tmp1908_);
						} else {
							_tmp1906_ = FALSE;
						}
						_tmp1902_ = _tmp1906_;
					}
					_tmp1901_ = _tmp1902_;
				} else {
					_tmp1901_ = FALSE;
				}
				if (_tmp1901_) {
					gboolean _tmp1909_ = FALSE;
					ValaDataType* _tmp1910_;
					_tmp1910_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1910_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp1911_;
						_tmp1911_ = result_type;
						_tmp1909_ = !vala_data_type_is_disposable (_tmp1911_);
					} else {
						_tmp1909_ = FALSE;
					}
					_tmp1900_ = _tmp1909_;
				} else {
					_tmp1900_ = FALSE;
				}
				if (_tmp1900_) {
					ValaCCodeExpression* _tmp1912_;
					_tmp1912_ = ccall_expr;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1912_);
				} else {
					if (!return_result_via_out_param) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1913_;
						ValaDataType* _tmp1914_;
						gboolean _tmp1915_;
						gboolean _tmp1916_;
						ValaLocalVariable* _tmp1917_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1918_;
						const gchar* _tmp1919_;
						const gchar* _tmp1920_;
						ValaCCodeExpression* _tmp1921_;
						ValaLocalVariable* _tmp1922_;
						ValaCCodeFunction* _tmp1923_;
						ValaCCodeFunction* _tmp1924_;
						ValaCCodeExpression* _tmp1925_;
						ValaCCodeExpression* _tmp1926_;
						ValaCCodeExpression* _tmp1927_;
						ValaTargetValue* _tmp1928_;
						ValaTargetValue* _tmp1929_;
						_tmp1913_ = result_type;
						_tmp1914_ = result_type;
						_tmp1915_ = vala_data_type_get_value_owned (_tmp1914_);
						_tmp1916_ = _tmp1915_;
						_tmp1917_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1913_, _tmp1916_, NULL, FALSE);
						temp_var = _tmp1917_;
						_tmp1918_ = temp_var;
						_tmp1919_ = vala_symbol_get_name ((ValaSymbol*) _tmp1918_);
						_tmp1920_ = _tmp1919_;
						_tmp1921_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1920_);
						temp_ref = _tmp1921_;
						_tmp1922_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1922_, FALSE);
						_tmp1923_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp1924_ = _tmp1923_;
						_tmp1925_ = temp_ref;
						_tmp1926_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp1924_, _tmp1925_, _tmp1926_);
						_tmp1927_ = temp_ref;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1927_);
						_tmp1928_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1929_ = _tmp1928_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1929_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp1930_;
						ValaTargetValue* _tmp1931_;
						ValaTargetValue* _tmp1932_;
						_tmp1930_ = ccall_expr;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1930_);
						_tmp1931_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1932_ = _tmp1931_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1932_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp1933_ = params;
	_tmp1934_ = vala_iterable_iterator ((ValaIterable*) _tmp1933_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp1934_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp1935_;
		gint _arg_size = 0;
		ValaList* _tmp1936_;
		gint _tmp1937_;
		gint _tmp1938_;
		gint _arg_index = 0;
		_tmp1935_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp1935_;
		_tmp1936_ = _arg_list;
		_tmp1937_ = vala_collection_get_size ((ValaCollection*) _tmp1936_);
		_tmp1938_ = _tmp1937_;
		_arg_size = _tmp1938_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp1939_;
			gpointer _tmp1940_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp1941_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp1951_;
			ValaUnaryExpression* _tmp1952_;
			gboolean _tmp1953_ = FALSE;
			ValaUnaryExpression* _tmp1954_;
			ValaUnaryExpression* _tmp1958_;
			ValaExpression* _tmp1959_;
			ValaExpression* _tmp1960_;
			ValaDataType* _tmp1961_;
			ValaDataType* _tmp1962_;
			ValaUnaryExpression* _tmp1972_;
			ValaExpression* _tmp1973_;
			ValaExpression* _tmp1974_;
			ValaTargetValue* _tmp1975_;
			ValaTargetValue* _tmp1976_;
			ValaUnaryExpression* _tmp1977_;
			ValaTargetValue* _tmp1978_;
			ValaTargetValue* _tmp1979_;
			ValaUnaryExpression* _tmp1980_;
			ValaExpression* _tmp1981_;
			ValaExpression* _tmp1982_;
			ValaDataType* _tmp1983_;
			ValaDataType* _tmp1984_;
			ValaExpression* _tmp1985_;
			ValaTargetValue* _tmp1986_;
			ValaTargetValue* _tmp1987_;
			ValaSourceReference* _tmp1988_;
			ValaSourceReference* _tmp1989_;
			gboolean _tmp1990_ = FALSE;
			ValaParameter* _tmp1991_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp1939_ = _arg_list;
			_tmp1940_ = vala_list_get (_tmp1939_, _arg_index);
			arg = (ValaExpression*) _tmp1940_;
			param = NULL;
			_tmp1941_ = params_it;
			if (vala_iterator_next (_tmp1941_)) {
				ValaIterator* _tmp1942_;
				gpointer _tmp1943_;
				gboolean _tmp1944_ = FALSE;
				ValaParameter* _tmp1945_;
				gboolean _tmp1946_;
				gboolean _tmp1947_;
				_tmp1942_ = params_it;
				_tmp1943_ = vala_iterator_get (_tmp1942_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp1943_;
				_tmp1945_ = param;
				_tmp1946_ = vala_parameter_get_params_array (_tmp1945_);
				_tmp1947_ = _tmp1946_;
				if (_tmp1947_) {
					_tmp1944_ = TRUE;
				} else {
					ValaParameter* _tmp1948_;
					gboolean _tmp1949_;
					gboolean _tmp1950_;
					_tmp1948_ = param;
					_tmp1949_ = vala_parameter_get_ellipsis (_tmp1948_);
					_tmp1950_ = _tmp1949_;
					_tmp1944_ = _tmp1950_;
				}
				if (_tmp1944_) {
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (arg);
					break;
				}
			}
			_tmp1951_ = arg;
			_tmp1952_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1951_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1951_) : NULL);
			unary = _tmp1952_;
			_tmp1954_ = unary;
			if (_tmp1954_ == NULL) {
				_tmp1953_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp1955_;
				ValaUnaryOperator _tmp1956_;
				ValaUnaryOperator _tmp1957_;
				_tmp1955_ = unary;
				_tmp1956_ = vala_unary_expression_get_operator (_tmp1955_);
				_tmp1957_ = _tmp1956_;
				_tmp1953_ = _tmp1957_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp1953_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp1958_ = unary;
			_tmp1959_ = vala_unary_expression_get_inner (_tmp1958_);
			_tmp1960_ = _tmp1959_;
			_tmp1961_ = vala_expression_get_value_type (_tmp1960_);
			_tmp1962_ = _tmp1961_;
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, _tmp1962_)) {
				ValaCCodeFunction* _tmp1963_;
				ValaCCodeFunction* _tmp1964_;
				ValaUnaryExpression* _tmp1965_;
				ValaExpression* _tmp1966_;
				ValaExpression* _tmp1967_;
				ValaTargetValue* _tmp1968_;
				ValaTargetValue* _tmp1969_;
				ValaCCodeExpression* _tmp1970_;
				ValaCCodeExpression* _tmp1971_;
				_tmp1963_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp1964_ = _tmp1963_;
				_tmp1965_ = unary;
				_tmp1966_ = vala_unary_expression_get_inner (_tmp1965_);
				_tmp1967_ = _tmp1966_;
				_tmp1968_ = vala_expression_get_target_value (_tmp1967_);
				_tmp1969_ = _tmp1968_;
				_tmp1970_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp1969_, FALSE);
				_tmp1971_ = _tmp1970_;
				vala_ccode_function_add_expression (_tmp1964_, _tmp1971_);
				_vala_ccode_node_unref0 (_tmp1971_);
			}
			_tmp1972_ = unary;
			_tmp1973_ = vala_unary_expression_get_inner (_tmp1972_);
			_tmp1974_ = _tmp1973_;
			_tmp1975_ = vala_expression_get_target_value (_tmp1974_);
			_tmp1976_ = _tmp1975_;
			_tmp1977_ = unary;
			_tmp1978_ = vala_expression_get_target_value ((ValaExpression*) _tmp1977_);
			_tmp1979_ = _tmp1978_;
			_tmp1980_ = unary;
			_tmp1981_ = vala_unary_expression_get_inner (_tmp1980_);
			_tmp1982_ = _tmp1981_;
			_tmp1983_ = vala_expression_get_value_type (_tmp1982_);
			_tmp1984_ = _tmp1983_;
			_tmp1985_ = arg;
			_tmp1986_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp1979_, _tmp1984_, (ValaCodeNode*) _tmp1985_);
			_tmp1987_ = _tmp1986_;
			_tmp1988_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp1989_ = _tmp1988_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp1976_, _tmp1987_, _tmp1989_);
			_vala_target_value_unref0 (_tmp1987_);
			_tmp1991_ = param;
			if (_tmp1991_ != NULL) {
				ValaParameter* _tmp1992_;
				_tmp1992_ = param;
				_tmp1990_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1992_);
			} else {
				_tmp1990_ = FALSE;
			}
			if (_tmp1990_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp1993_;
				ValaCCodeIdentifier* _tmp1994_;
				ValaCCodeFunctionCall* _tmp1995_;
				ValaCCodeFunctionCall* _tmp1996_;
				ValaCCodeFunctionCall* _tmp1997_;
				ValaUnaryExpression* _tmp1998_;
				ValaExpression* _tmp1999_;
				ValaExpression* _tmp2000_;
				ValaTargetValue* _tmp2001_;
				ValaTargetValue* _tmp2002_;
				ValaCCodeExpression* _tmp2003_;
				ValaCCodeExpression* _tmp2004_;
				ValaCCodeFunction* _tmp2005_;
				ValaCCodeFunction* _tmp2006_;
				ValaUnaryExpression* _tmp2007_;
				ValaExpression* _tmp2008_;
				ValaExpression* _tmp2009_;
				ValaTargetValue* _tmp2010_;
				ValaTargetValue* _tmp2011_;
				ValaCCodeExpression* _tmp2012_;
				ValaCCodeExpression* _tmp2013_;
				ValaCCodeFunctionCall* _tmp2014_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp1993_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp1994_ = _tmp1993_;
				_tmp1995_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1994_);
				_tmp1996_ = _tmp1995_;
				_vala_ccode_node_unref0 (_tmp1994_);
				len_call = _tmp1996_;
				_tmp1997_ = len_call;
				_tmp1998_ = unary;
				_tmp1999_ = vala_unary_expression_get_inner (_tmp1998_);
				_tmp2000_ = _tmp1999_;
				_tmp2001_ = vala_expression_get_target_value (_tmp2000_);
				_tmp2002_ = _tmp2001_;
				_tmp2003_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp2002_);
				_tmp2004_ = _tmp2003_;
				vala_ccode_function_call_add_argument (_tmp1997_, _tmp2004_);
				_vala_ccode_node_unref0 (_tmp2004_);
				_tmp2005_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2006_ = _tmp2005_;
				_tmp2007_ = unary;
				_tmp2008_ = vala_unary_expression_get_inner (_tmp2007_);
				_tmp2009_ = _tmp2008_;
				_tmp2010_ = vala_expression_get_target_value (_tmp2009_);
				_tmp2011_ = _tmp2010_;
				_tmp2012_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2011_, 1);
				_tmp2013_ = _tmp2012_;
				_tmp2014_ = len_call;
				vala_ccode_function_add_assignment (_tmp2006_, _tmp2013_, (ValaCCodeExpression*) _tmp2014_);
				_vala_ccode_node_unref0 (_tmp2013_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2017_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2017_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2018_;
		ValaSymbol* _tmp2019_;
		ValaSymbol* _tmp2020_;
		_tmp2018_ = m;
		_tmp2019_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2018_);
		_tmp2020_ = _tmp2019_;
		_tmp2016_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2020_, VALA_TYPE_CLASS);
	} else {
		_tmp2016_ = FALSE;
	}
	if (_tmp2016_) {
		gboolean _tmp2021_ = FALSE;
		gboolean _tmp2022_ = FALSE;
		ValaClass* _tmp2023_;
		ValaClass* _tmp2024_;
		gboolean _tmp2025_;
		gboolean _tmp2026_;
		_tmp2023_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2024_ = _tmp2023_;
		_tmp2025_ = vala_class_get_is_compact (_tmp2024_);
		_tmp2026_ = _tmp2025_;
		if (_tmp2026_) {
			ValaClass* _tmp2027_;
			ValaClass* _tmp2028_;
			ValaClass* _tmp2029_;
			ValaClass* _tmp2030_;
			_tmp2027_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2028_ = _tmp2027_;
			_tmp2029_ = vala_class_get_base_class (_tmp2028_);
			_tmp2030_ = _tmp2029_;
			_tmp2022_ = _tmp2030_ != NULL;
		} else {
			_tmp2022_ = FALSE;
		}
		if (_tmp2022_) {
			_tmp2021_ = TRUE;
		} else {
			ValaClass* _tmp2031_;
			ValaClass* _tmp2032_;
			ValaClass* _tmp2033_;
			ValaClass* _tmp2034_;
			ValaClass* _tmp2035_;
			_tmp2031_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2032_ = _tmp2031_;
			_tmp2033_ = vala_class_get_base_class (_tmp2032_);
			_tmp2034_ = _tmp2033_;
			_tmp2035_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2021_ = _tmp2034_ == _tmp2035_;
		}
		_tmp2015_ = _tmp2021_;
	} else {
		_tmp2015_ = FALSE;
	}
	if (_tmp2015_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2036_;
		ValaClass* _tmp2037_;
		gchar* _tmp2038_;
		gchar* _tmp2039_;
		gchar* _tmp2040_;
		gchar* _tmp2041_;
		ValaCCodeIdentifier* _tmp2042_;
		ValaCCodeIdentifier* _tmp2043_;
		ValaCCodeFunctionCall* _tmp2044_;
		ValaCCodeFunctionCall* _tmp2045_;
		ValaCCodeFunctionCall* _tmp2046_;
		ValaCCodeExpression* _tmp2047_;
		ValaCCodeExpression* _tmp2048_;
		ValaCCodeFunction* _tmp2049_;
		ValaCCodeFunction* _tmp2050_;
		ValaCCodeFunctionCall* _tmp2051_;
		_tmp2036_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2037_ = _tmp2036_;
		_tmp2038_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2037_, NULL);
		_tmp2039_ = _tmp2038_;
		_tmp2040_ = g_strdup_printf ("%s_instance_init", _tmp2039_);
		_tmp2041_ = _tmp2040_;
		_tmp2042_ = vala_ccode_identifier_new (_tmp2041_);
		_tmp2043_ = _tmp2042_;
		_tmp2044_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2043_);
		_tmp2045_ = _tmp2044_;
		_vala_ccode_node_unref0 (_tmp2043_);
		_g_free0 (_tmp2041_);
		_g_free0 (_tmp2039_);
		cinitcall = _tmp2045_;
		_tmp2046_ = cinitcall;
		_tmp2047_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2048_ = _tmp2047_;
		vala_ccode_function_call_add_argument (_tmp2046_, _tmp2048_);
		_vala_ccode_node_unref0 (_tmp2048_);
		_tmp2049_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2050_ = _tmp2049_;
		_tmp2051_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2050_, (ValaCCodeExpression*) _tmp2051_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}

static gchar*
vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                               ValaEnum* en)
{
	gchar* result = NULL;
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp44_;
	ValaCCodeFunction* _tmp45_;
	ValaCCodeFunction* _tmp46_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeConstant* _tmp48_;
	ValaCCodeConstant* _tmp49_;
	ValaCCodeFile* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	ValaCCodeFile* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp24_;
			gpointer _tmp25_;
			ValaCCodeFunction* _tmp26_;
			ValaCCodeFunction* _tmp27_;
			ValaEnumValue* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			ValaCCodeIdentifier* _tmp31_;
			ValaCCodeIdentifier* _tmp32_;
			ValaCCodeFunction* _tmp33_;
			ValaCCodeFunction* _tmp34_;
			ValaEnumValue* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			ValaCCodeConstant* _tmp42_;
			ValaCCodeConstant* _tmp43_;
			_enum_value_index = _enum_value_index + 1;
			if (!(_enum_value_index < _enum_value_size)) {
				break;
			}
			_tmp24_ = _enum_value_list;
			_tmp25_ = vala_list_get (_tmp24_, _enum_value_index);
			enum_value = (ValaEnumValue*) _tmp25_;
			_tmp26_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp27_ = _tmp26_;
			_tmp28_ = enum_value;
			_tmp29_ = vala_get_ccode_name ((ValaCodeNode*) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_ccode_identifier_new (_tmp30_);
			_tmp32_ = _tmp31_;
			vala_ccode_function_add_case (_tmp27_, (ValaCCodeExpression*) _tmp32_);
			_vala_ccode_node_unref0 (_tmp32_);
			_g_free0 (_tmp30_);
			_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp34_ = _tmp33_;
			_tmp35_ = enum_value;
			_tmp36_ = vala_get_ccode_name ((ValaCodeNode*) _tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strconcat ("\"", _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat (_tmp39_, "\"", NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_ccode_constant_new (_tmp41_);
			_tmp43_ = _tmp42_;
			vala_ccode_function_add_return (_tmp34_, (ValaCCodeExpression*) _tmp43_);
			_vala_ccode_node_unref0 (_tmp43_);
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp44_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp45_ = _tmp44_;
	vala_ccode_function_close (_tmp45_);
	_tmp46_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_ccode_constant_new ("NULL");
	_tmp49_ = _tmp48_;
	vala_ccode_function_add_return (_tmp47_, (ValaCCodeExpression*) _tmp49_);
	_vala_ccode_node_unref0 (_tmp49_);
	_tmp50_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp51_ = function;
	vala_ccode_file_add_function_declaration (_tmp50_, _tmp51_);
	_tmp52_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp53_ = function;
	vala_ccode_file_add_function (_tmp52_, _tmp53_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}

static gboolean
vala_ccode_method_call_module_has_ref_out_param (ValaCCodeMethodCallModule* self,
                                                 ValaCallable* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters (c);
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaParameter* _tmp6_;
			ValaParameterDirection _tmp7_;
			ValaParameterDirection _tmp8_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp4_ = _param_list;
			_tmp5_ = vala_list_get (_tmp4_, _param_index);
			param = (ValaParameter*) _tmp5_;
			_tmp6_ = param;
			_tmp7_ = vala_parameter_get_direction (_tmp6_);
			_tmp8_ = _tmp7_;
			if (_tmp8_ != VALA_PARAMETER_DIRECTION_IN) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = FALSE;
	return result;
}

static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	gchar* result = NULL;
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* va_start = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp37_;
	ValaCCodeIdentifier* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	ValaCCodeFunctionCall* _tmp40_;
	ValaCCodeFunctionCall* _tmp41_;
	ValaCCodeConstant* _tmp42_;
	ValaCCodeConstant* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeConstant* _tmp45_;
	ValaCCodeConstant* _tmp46_;
	ValaCCodeFunctionCall* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeIdentifier* _tmp49_;
	ValaCCodeFunctionCall* _tmp50_;
	ValaCCodeIdentifier* _tmp51_;
	ValaCCodeIdentifier* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	ValaCCodeFunction* _tmp54_;
	ValaCCodeIdentifier* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeFunctionCall* _tmp57_;
	ValaCCodeConstant* _tmp58_;
	ValaCCodeConstant* _tmp59_;
	ValaCCodeBinaryExpression* _tmp60_;
	ValaCCodeBinaryExpression* _tmp61_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp62_;
	ValaCCodeIdentifier* _tmp63_;
	ValaCCodeFunctionCall* _tmp64_;
	ValaCCodeFunctionCall* _tmp65_;
	ValaCCodeFunctionCall* _tmp66_;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunction* _tmp69_;
	ValaCCodeFunction* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunctionCall* _tmp74_;
	ValaCCodeFunctionCall* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunction* _tmp79_;
	ValaCCodeFunction* _tmp80_;
	ValaCCodeIdentifier* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeFunctionCall* _tmp83_;
	ValaCCodeIdentifier* _tmp84_;
	ValaCCodeIdentifier* _tmp85_;
	ValaCCodeFunctionCall* _tmp86_;
	ValaCCodeFunctionCall* _tmp87_;
	ValaCCodeIdentifier* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeFunctionCall* _tmp90_;
	ValaCCodeIdentifier* _tmp91_;
	ValaCCodeIdentifier* _tmp92_;
	ValaCCodeFunction* _tmp93_;
	ValaCCodeFunction* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunctionCall* _tmp98_;
	ValaCCodeFunctionCall* _tmp99_;
	ValaCCodeIdentifier* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeFunctionCall* _tmp102_;
	ValaCCodeIdentifier* _tmp103_;
	ValaCCodeIdentifier* _tmp104_;
	ValaCCodeFunctionCall* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeIdentifier* _tmp107_;
	ValaCCodeFunctionCall* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeIdentifier* _tmp110_;
	ValaCCodeFunction* _tmp111_;
	ValaCCodeFunction* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunctionCall* _tmp116_;
	ValaCCodeFunctionCall* _tmp117_;
	ValaCCodeIdentifier* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeFunction* _tmp120_;
	ValaCCodeFunction* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeFunction* _tmp123_;
	ValaCCodeFunction* _tmp124_;
	ValaCCodeIdentifier* _tmp125_;
	ValaCCodeIdentifier* _tmp126_;
	ValaCCodeFile* _tmp127_;
	ValaCCodeFile* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeFile* _tmp130_;
	ValaCCodeFunction* _tmp131_;
	gchar* _tmp132_;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	va_start = _tmp27_;
	_tmp28_ = va_start;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = va_start;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = va_start;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp38_);
	_tmp40_ = _tmp39_;
	_vala_ccode_node_unref0 (_tmp38_);
	vsnprintf = _tmp40_;
	_tmp41_ = vsnprintf;
	_tmp42_ = vala_ccode_constant_new ("NULL");
	_tmp43_ = _tmp42_;
	vala_ccode_function_call_add_argument (_tmp41_, (ValaCCodeExpression*) _tmp43_);
	_vala_ccode_node_unref0 (_tmp43_);
	_tmp44_ = vsnprintf;
	_tmp45_ = vala_ccode_constant_new ("0");
	_tmp46_ = _tmp45_;
	vala_ccode_function_call_add_argument (_tmp44_, (ValaCCodeExpression*) _tmp46_);
	_vala_ccode_node_unref0 (_tmp46_);
	_tmp47_ = vsnprintf;
	_tmp48_ = vala_ccode_identifier_new ("format");
	_tmp49_ = _tmp48_;
	vala_ccode_function_call_add_argument (_tmp47_, (ValaCCodeExpression*) _tmp49_);
	_vala_ccode_node_unref0 (_tmp49_);
	_tmp50_ = vsnprintf;
	_tmp51_ = vala_ccode_identifier_new ("ap");
	_tmp52_ = _tmp51_;
	vala_ccode_function_call_add_argument (_tmp50_, (ValaCCodeExpression*) _tmp52_);
	_vala_ccode_node_unref0 (_tmp52_);
	_tmp53_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_ccode_identifier_new ("length");
	_tmp56_ = _tmp55_;
	_tmp57_ = vsnprintf;
	_tmp58_ = vala_ccode_constant_new ("1");
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp57_, (ValaCCodeExpression*) _tmp59_);
	_tmp61_ = _tmp60_;
	vala_ccode_function_add_assignment (_tmp54_, (ValaCCodeExpression*) _tmp56_, (ValaCCodeExpression*) _tmp61_);
	_vala_ccode_node_unref0 (_tmp61_);
	_vala_ccode_node_unref0 (_tmp59_);
	_vala_ccode_node_unref0 (_tmp56_);
	_tmp62_ = vala_ccode_identifier_new ("va_end");
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp63_);
	_tmp65_ = _tmp64_;
	_vala_ccode_node_unref0 (_tmp63_);
	va_end = _tmp65_;
	_tmp66_ = va_end;
	_tmp67_ = vala_ccode_identifier_new ("ap");
	_tmp68_ = _tmp67_;
	vala_ccode_function_call_add_argument (_tmp66_, (ValaCCodeExpression*) _tmp68_);
	_vala_ccode_node_unref0 (_tmp68_);
	_tmp69_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp70_ = _tmp69_;
	_tmp71_ = va_end;
	vala_ccode_function_add_expression (_tmp70_, (ValaCCodeExpression*) _tmp71_);
	_tmp72_ = vala_ccode_identifier_new ("malloc");
	_tmp73_ = _tmp72_;
	_tmp74_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp73_);
	_tmp75_ = _tmp74_;
	_vala_ccode_node_unref0 (_tmp73_);
	malloc = _tmp75_;
	_tmp76_ = malloc;
	_tmp77_ = vala_ccode_identifier_new ("length");
	_tmp78_ = _tmp77_;
	vala_ccode_function_call_add_argument (_tmp76_, (ValaCCodeExpression*) _tmp78_);
	_vala_ccode_node_unref0 (_tmp78_);
	_tmp79_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_ccode_identifier_new ("result");
	_tmp82_ = _tmp81_;
	_tmp83_ = malloc;
	vala_ccode_function_add_assignment (_tmp80_, (ValaCCodeExpression*) _tmp82_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp82_);
	_tmp84_ = vala_ccode_identifier_new ("va_start");
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp85_);
	_vala_ccode_node_unref0 (va_start);
	va_start = _tmp86_;
	_vala_ccode_node_unref0 (_tmp85_);
	_tmp87_ = va_start;
	_tmp88_ = vala_ccode_identifier_new ("ap");
	_tmp89_ = _tmp88_;
	vala_ccode_function_call_add_argument (_tmp87_, (ValaCCodeExpression*) _tmp89_);
	_vala_ccode_node_unref0 (_tmp89_);
	_tmp90_ = va_start;
	_tmp91_ = vala_ccode_identifier_new ("format");
	_tmp92_ = _tmp91_;
	vala_ccode_function_call_add_argument (_tmp90_, (ValaCCodeExpression*) _tmp92_);
	_vala_ccode_node_unref0 (_tmp92_);
	_tmp93_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp94_ = _tmp93_;
	_tmp95_ = va_start;
	vala_ccode_function_add_expression (_tmp94_, (ValaCCodeExpression*) _tmp95_);
	_tmp96_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp97_ = _tmp96_;
	_tmp98_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp98_;
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp99_ = vsnprintf;
	_tmp100_ = vala_ccode_identifier_new ("result");
	_tmp101_ = _tmp100_;
	vala_ccode_function_call_add_argument (_tmp99_, (ValaCCodeExpression*) _tmp101_);
	_vala_ccode_node_unref0 (_tmp101_);
	_tmp102_ = vsnprintf;
	_tmp103_ = vala_ccode_identifier_new ("length");
	_tmp104_ = _tmp103_;
	vala_ccode_function_call_add_argument (_tmp102_, (ValaCCodeExpression*) _tmp104_);
	_vala_ccode_node_unref0 (_tmp104_);
	_tmp105_ = vsnprintf;
	_tmp106_ = vala_ccode_identifier_new ("format");
	_tmp107_ = _tmp106_;
	vala_ccode_function_call_add_argument (_tmp105_, (ValaCCodeExpression*) _tmp107_);
	_vala_ccode_node_unref0 (_tmp107_);
	_tmp108_ = vsnprintf;
	_tmp109_ = vala_ccode_identifier_new ("ap");
	_tmp110_ = _tmp109_;
	vala_ccode_function_call_add_argument (_tmp108_, (ValaCCodeExpression*) _tmp110_);
	_vala_ccode_node_unref0 (_tmp110_);
	_tmp111_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp112_ = _tmp111_;
	_tmp113_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp112_, (ValaCCodeExpression*) _tmp113_);
	_tmp114_ = vala_ccode_identifier_new ("va_end");
	_tmp115_ = _tmp114_;
	_tmp116_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp116_;
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp117_ = va_end;
	_tmp118_ = vala_ccode_identifier_new ("ap");
	_tmp119_ = _tmp118_;
	vala_ccode_function_call_add_argument (_tmp117_, (ValaCCodeExpression*) _tmp119_);
	_vala_ccode_node_unref0 (_tmp119_);
	_tmp120_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp121_ = _tmp120_;
	_tmp122_ = va_end;
	vala_ccode_function_add_expression (_tmp121_, (ValaCCodeExpression*) _tmp122_);
	_tmp123_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp124_ = _tmp123_;
	_tmp125_ = vala_ccode_identifier_new ("result");
	_tmp126_ = _tmp125_;
	vala_ccode_function_add_return (_tmp124_, (ValaCCodeExpression*) _tmp126_);
	_vala_ccode_node_unref0 (_tmp126_);
	_tmp127_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp127_, "stdarg.h", FALSE);
	_tmp128_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp129_ = function;
	vala_ccode_file_add_function_declaration (_tmp128_, _tmp129_);
	_tmp130_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp131_ = function;
	vala_ccode_file_add_function (_tmp130_, _tmp131_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp132_ = g_strdup ("string_printf");
	result = _tmp132_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (va_start);
	_vala_ccode_node_unref0 (function);
	return result;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}

static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}

static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self)
{
}

GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

