/* valacreationmethod.c generated by valac, the Vala compiler
 * generated from valacreationmethod.vala, do not modify */

/* valacreationmethod.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 * Copyright (C) 2007-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaCreationMethodPrivate {
	gchar* _class_name;
	gboolean _chain_up;
};

static gint ValaCreationMethod_private_offset;
static gpointer vala_creation_method_parent_class = NULL;

static void vala_creation_method_real_accept (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_creation_method_real_accept_children (ValaCodeNode* base,
                                                ValaCodeVisitor* visitor);
static gboolean vala_creation_method_real_check (ValaCodeNode* base,
                                          ValaCodeContext* context);
static void vala_creation_method_finalize (ValaCodeNode * obj);

static inline gpointer
vala_creation_method_get_instance_private (ValaCreationMethod* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCreationMethod_private_offset);
}

/**
 * Creates a new method.
 *
 * @param name             method name
 * @param source_reference reference to source code
 * @return                 newly created method
 */
ValaCreationMethod*
vala_creation_method_construct (GType object_type,
                                const gchar* class_name,
                                const gchar* name,
                                ValaSourceReference* source_reference,
                                ValaComment* comment)
{
	ValaCreationMethod* self = NULL;
	ValaVoidType* _tmp0_;
	ValaVoidType* _tmp1_;
	_tmp0_ = vala_void_type_new (NULL);
	_tmp1_ = _tmp0_;
	self = (ValaCreationMethod*) vala_method_construct (object_type, name, (ValaDataType*) _tmp1_, source_reference, comment);
	_vala_code_node_unref0 (_tmp1_);
	vala_creation_method_set_class_name (self, class_name);
	return self;
}

ValaCreationMethod*
vala_creation_method_new (const gchar* class_name,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	return vala_creation_method_construct (VALA_TYPE_CREATION_METHOD, class_name, name, source_reference, comment);
}

static void
vala_creation_method_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_creation_method (visitor, self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_creation_method_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	ValaList* _tmp7_;
	ValaBlock* _tmp30_;
	ValaBlock* _tmp31_;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters ((ValaCallable*) self);
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaParameter* _tmp6_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp4_ = _param_list;
			_tmp5_ = vala_list_get (_tmp4_, _param_index);
			param = (ValaParameter*) _tmp5_;
			_tmp6_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp6_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp7_ = ((ValaMethod*) self)->error_types;
	if (_tmp7_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp8_;
			ValaList* _tmp9_;
			gint _error_type_size = 0;
			ValaList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gint _error_type_index = 0;
			_tmp8_ = ((ValaMethod*) self)->error_types;
			_tmp9_ = _vala_iterable_ref0 (_tmp8_);
			_error_type_list = _tmp9_;
			_tmp10_ = _error_type_list;
			_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
			_tmp12_ = _tmp11_;
			_error_type_size = _tmp12_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp13_;
				gpointer _tmp14_;
				ValaDataType* _tmp15_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp13_ = _error_type_list;
				_tmp14_ = vala_list_get (_tmp13_, _error_type_index);
				error_type = (ValaDataType*) _tmp14_;
				_tmp15_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp16_;
		gint _precondition_size = 0;
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _precondition_index = 0;
		_tmp16_ = vala_method_get_preconditions ((ValaMethod*) self);
		_precondition_list = _tmp16_;
		_tmp17_ = _precondition_list;
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_precondition_size = _tmp19_;
		_precondition_index = -1;
		while (TRUE) {
			ValaExpression* precondition = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			ValaExpression* _tmp22_;
			_precondition_index = _precondition_index + 1;
			if (!(_precondition_index < _precondition_size)) {
				break;
			}
			_tmp20_ = _precondition_list;
			_tmp21_ = vala_list_get (_tmp20_, _precondition_index);
			precondition = (ValaExpression*) _tmp21_;
			_tmp22_ = precondition;
			vala_code_node_accept ((ValaCodeNode*) _tmp22_, visitor);
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp23_;
		gint _postcondition_size = 0;
		ValaList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _postcondition_index = 0;
		_tmp23_ = vala_method_get_postconditions ((ValaMethod*) self);
		_postcondition_list = _tmp23_;
		_tmp24_ = _postcondition_list;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_postcondition_size = _tmp26_;
		_postcondition_index = -1;
		while (TRUE) {
			ValaExpression* postcondition = NULL;
			ValaList* _tmp27_;
			gpointer _tmp28_;
			ValaExpression* _tmp29_;
			_postcondition_index = _postcondition_index + 1;
			if (!(_postcondition_index < _postcondition_size)) {
				break;
			}
			_tmp27_ = _postcondition_list;
			_tmp28_ = vala_list_get (_tmp27_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp28_;
			_tmp29_ = postcondition;
			vala_code_node_accept ((ValaCodeNode*) _tmp29_, visitor);
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp30_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp31_ = _tmp30_;
	if (_tmp31_ != NULL) {
		ValaBlock* _tmp32_;
		ValaBlock* _tmp33_;
		_tmp32_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp33_ = _tmp32_;
		vala_code_node_accept ((ValaCodeNode*) _tmp33_, visitor);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_creation_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context)
{
	ValaCreationMethod * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaSourceFile* _tmp24_;
	ValaSourceFile* _tmp25_;
	ValaSourceFile* _tmp26_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp27_;
	ValaSemanticAnalyzer* _tmp28_;
	ValaSymbol* _tmp29_;
	ValaSymbol* _tmp30_;
	ValaSymbol* _tmp31_;
	ValaSourceReference* _tmp32_;
	ValaSourceReference* _tmp33_;
	ValaSemanticAnalyzer* _tmp40_;
	ValaSemanticAnalyzer* _tmp41_;
	gint i = 0;
	ValaList* _tmp60_;
	ValaBlock* _tmp83_;
	ValaBlock* _tmp84_;
	ValaSemanticAnalyzer* _tmp209_;
	ValaSemanticAnalyzer* _tmp210_;
	ValaSourceFile* _tmp211_;
	ValaSemanticAnalyzer* _tmp212_;
	ValaSemanticAnalyzer* _tmp213_;
	ValaSymbol* _tmp214_;
	gboolean _tmp215_ = FALSE;
	gboolean _tmp216_ = FALSE;
	gboolean _tmp217_;
	gboolean _tmp218_;
	ValaBlock* _tmp229_;
	ValaBlock* _tmp230_;
	gboolean _tmp265_;
	gboolean _tmp266_;
	self = (ValaCreationMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = self->priv->_class_name;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp6_ = self->priv->_class_name;
		_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = g_strcmp0 (_tmp6_, _tmp10_) != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaSemanticAnalyzer* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_code_context_get_analyzer (context);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_semantic_analyzer_get_current_symbol (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_symbol_get_full_name (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->_class_name;
		_tmp20_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp18_, _tmp19_);
		_tmp21_ = _tmp20_;
		vala_report_error (_tmp12_, _tmp21_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp18_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_semantic_analyzer_get_current_source_file (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = _vala_source_file_ref0 (_tmp25_);
	old_source_file = _tmp26_;
	_tmp27_ = vala_code_context_get_analyzer (context);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_semantic_analyzer_get_current_symbol (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = _vala_code_node_ref0 (_tmp30_);
	old_symbol = _tmp31_;
	_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp33_ = _tmp32_;
	if (_tmp33_ != NULL) {
		ValaSemanticAnalyzer* _tmp34_;
		ValaSemanticAnalyzer* _tmp35_;
		ValaSourceReference* _tmp36_;
		ValaSourceReference* _tmp37_;
		ValaSourceFile* _tmp38_;
		ValaSourceFile* _tmp39_;
		_tmp34_ = vala_code_context_get_analyzer (context);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_source_reference_get_file (_tmp37_);
		_tmp39_ = _tmp38_;
		vala_semantic_analyzer_set_current_source_file (_tmp35_, _tmp39_);
	}
	_tmp40_ = vala_code_context_get_analyzer (context);
	_tmp41_ = _tmp40_;
	vala_semantic_analyzer_set_current_symbol (_tmp41_, (ValaSymbol*) self);
	i = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp42_;
		gint _param_size = 0;
		ValaList* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		gint _param_index = 0;
		_tmp42_ = vala_callable_get_parameters ((ValaCallable*) self);
		_param_list = _tmp42_;
		_tmp43_ = _param_list;
		_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
		_tmp45_ = _tmp44_;
		_param_size = _tmp45_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp46_;
			gpointer _tmp47_;
			ValaParameter* _tmp48_;
			gboolean _tmp49_ = FALSE;
			gboolean _tmp50_ = FALSE;
			gint _tmp59_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp46_ = _param_list;
			_tmp47_ = vala_list_get (_tmp46_, _param_index);
			param = (ValaParameter*) _tmp47_;
			_tmp48_ = param;
			vala_code_node_check ((ValaCodeNode*) _tmp48_, context);
			if (i == 0) {
				ValaParameter* _tmp51_;
				gboolean _tmp52_;
				gboolean _tmp53_;
				_tmp51_ = param;
				_tmp52_ = vala_parameter_get_ellipsis (_tmp51_);
				_tmp53_ = _tmp52_;
				_tmp50_ = _tmp53_;
			} else {
				_tmp50_ = FALSE;
			}
			if (_tmp50_) {
				ValaBlock* _tmp54_;
				ValaBlock* _tmp55_;
				_tmp54_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp55_ = _tmp54_;
				_tmp49_ = _tmp55_ != NULL;
			} else {
				_tmp49_ = FALSE;
			}
			if (_tmp49_) {
				ValaParameter* _tmp56_;
				ValaSourceReference* _tmp57_;
				ValaSourceReference* _tmp58_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp56_ = param;
				_tmp57_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp56_);
				_tmp58_ = _tmp57_;
				vala_report_error (_tmp58_, "Named parameter required before `...'");
			}
			_tmp59_ = i;
			i = _tmp59_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp60_ = ((ValaMethod*) self)->error_types;
	if (_tmp60_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp61_;
			ValaList* _tmp62_;
			gint _error_type_size = 0;
			ValaList* _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			gint _error_type_index = 0;
			_tmp61_ = ((ValaMethod*) self)->error_types;
			_tmp62_ = _vala_iterable_ref0 (_tmp61_);
			_error_type_list = _tmp62_;
			_tmp63_ = _error_type_list;
			_tmp64_ = vala_collection_get_size ((ValaCollection*) _tmp63_);
			_tmp65_ = _tmp64_;
			_error_type_size = _tmp65_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp66_;
				gpointer _tmp67_;
				ValaDataType* _tmp68_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp66_ = _error_type_list;
				_tmp67_ = vala_list_get (_tmp66_, _error_type_index);
				error_type = (ValaDataType*) _tmp67_;
				_tmp68_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp68_, context);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp69_;
		gint _precondition_size = 0;
		ValaList* _tmp70_;
		gint _tmp71_;
		gint _tmp72_;
		gint _precondition_index = 0;
		_tmp69_ = vala_method_get_preconditions ((ValaMethod*) self);
		_precondition_list = _tmp69_;
		_tmp70_ = _precondition_list;
		_tmp71_ = vala_collection_get_size ((ValaCollection*) _tmp70_);
		_tmp72_ = _tmp71_;
		_precondition_size = _tmp72_;
		_precondition_index = -1;
		while (TRUE) {
			ValaExpression* precondition = NULL;
			ValaList* _tmp73_;
			gpointer _tmp74_;
			ValaExpression* _tmp75_;
			_precondition_index = _precondition_index + 1;
			if (!(_precondition_index < _precondition_size)) {
				break;
			}
			_tmp73_ = _precondition_list;
			_tmp74_ = vala_list_get (_tmp73_, _precondition_index);
			precondition = (ValaExpression*) _tmp74_;
			_tmp75_ = precondition;
			vala_code_node_check ((ValaCodeNode*) _tmp75_, context);
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp76_;
		gint _postcondition_size = 0;
		ValaList* _tmp77_;
		gint _tmp78_;
		gint _tmp79_;
		gint _postcondition_index = 0;
		_tmp76_ = vala_method_get_postconditions ((ValaMethod*) self);
		_postcondition_list = _tmp76_;
		_tmp77_ = _postcondition_list;
		_tmp78_ = vala_collection_get_size ((ValaCollection*) _tmp77_);
		_tmp79_ = _tmp78_;
		_postcondition_size = _tmp79_;
		_postcondition_index = -1;
		while (TRUE) {
			ValaExpression* postcondition = NULL;
			ValaList* _tmp80_;
			gpointer _tmp81_;
			ValaExpression* _tmp82_;
			_postcondition_index = _postcondition_index + 1;
			if (!(_postcondition_index < _postcondition_size)) {
				break;
			}
			_tmp80_ = _postcondition_list;
			_tmp81_ = vala_list_get (_tmp80_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp81_;
			_tmp82_ = postcondition;
			vala_code_node_check ((ValaCodeNode*) _tmp82_, context);
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp83_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp84_ = _tmp83_;
	if (_tmp84_ != NULL) {
		ValaBlock* _tmp85_;
		ValaBlock* _tmp86_;
		ValaClass* cl = NULL;
		ValaSymbol* _tmp87_;
		ValaSymbol* _tmp88_;
		ValaClass* _tmp89_;
		gboolean _tmp90_ = FALSE;
		gboolean _tmp91_ = FALSE;
		gboolean _tmp92_;
		_tmp85_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp86_ = _tmp85_;
		vala_code_node_check ((ValaCodeNode*) _tmp86_, context);
		_tmp87_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp88_ = _tmp87_;
		_tmp89_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp88_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp88_) : NULL);
		cl = _tmp89_;
		_tmp92_ = self->priv->_chain_up;
		if (!_tmp92_) {
			ValaClass* _tmp93_;
			_tmp93_ = cl;
			_tmp91_ = _tmp93_ != NULL;
		} else {
			_tmp91_ = FALSE;
		}
		if (_tmp91_) {
			ValaClass* _tmp94_;
			ValaClass* _tmp95_;
			ValaClass* _tmp96_;
			_tmp94_ = cl;
			_tmp95_ = vala_class_get_base_class (_tmp94_);
			_tmp96_ = _tmp95_;
			_tmp90_ = _tmp96_ != NULL;
		} else {
			_tmp90_ = FALSE;
		}
		if (_tmp90_) {
			gboolean _tmp97_ = FALSE;
			gboolean _tmp98_ = FALSE;
			ValaProfile _tmp99_;
			ValaProfile _tmp100_;
			_tmp99_ = vala_code_context_get_profile (context);
			_tmp100_ = _tmp99_;
			if (_tmp100_ == VALA_PROFILE_GOBJECT) {
				ValaClass* _tmp101_;
				ValaClass* _tmp102_;
				ValaClass* _tmp103_;
				ValaCreationMethod* _tmp104_;
				ValaCreationMethod* _tmp105_;
				_tmp101_ = cl;
				_tmp102_ = vala_class_get_base_class (_tmp101_);
				_tmp103_ = _tmp102_;
				_tmp104_ = vala_class_get_default_construction_method (_tmp103_);
				_tmp105_ = _tmp104_;
				_tmp98_ = _tmp105_ != NULL;
			} else {
				_tmp98_ = FALSE;
			}
			if (_tmp98_) {
				ValaClass* _tmp106_;
				ValaClass* _tmp107_;
				ValaClass* _tmp108_;
				ValaCreationMethod* _tmp109_;
				ValaCreationMethod* _tmp110_;
				gboolean _tmp111_;
				gboolean _tmp112_;
				_tmp106_ = cl;
				_tmp107_ = vala_class_get_base_class (_tmp106_);
				_tmp108_ = _tmp107_;
				_tmp109_ = vala_class_get_default_construction_method (_tmp108_);
				_tmp110_ = _tmp109_;
				_tmp111_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp110_);
				_tmp112_ = _tmp111_;
				_tmp97_ = !_tmp112_;
			} else {
				_tmp97_ = FALSE;
			}
			if (_tmp97_) {
				ValaBlock* old_insert_block = NULL;
				ValaSemanticAnalyzer* _tmp113_;
				ValaSemanticAnalyzer* _tmp114_;
				ValaBlock* _tmp115_;
				ValaBlock* _tmp116_;
				ValaSemanticAnalyzer* _tmp117_;
				ValaSemanticAnalyzer* _tmp118_;
				ValaBlock* _tmp119_;
				ValaBlock* _tmp120_;
				ValaSemanticAnalyzer* _tmp121_;
				ValaSemanticAnalyzer* _tmp122_;
				ValaBlock* _tmp123_;
				ValaBlock* _tmp124_;
				ValaBlock* _tmp125_;
				ValaExpressionStatement* stmt = NULL;
				ValaSourceReference* _tmp126_;
				ValaSourceReference* _tmp127_;
				ValaMemberAccess* _tmp128_;
				ValaMemberAccess* _tmp129_;
				ValaSourceReference* _tmp130_;
				ValaSourceReference* _tmp131_;
				ValaMemberAccess* _tmp132_;
				ValaMemberAccess* _tmp133_;
				ValaSourceReference* _tmp134_;
				ValaSourceReference* _tmp135_;
				ValaMethodCall* _tmp136_;
				ValaMethodCall* _tmp137_;
				ValaSourceReference* _tmp138_;
				ValaSourceReference* _tmp139_;
				ValaExpressionStatement* _tmp140_;
				ValaExpressionStatement* _tmp141_;
				ValaBlock* _tmp142_;
				ValaBlock* _tmp143_;
				ValaExpressionStatement* _tmp144_;
				ValaExpressionStatement* _tmp145_;
				ValaSemanticAnalyzer* _tmp146_;
				ValaSemanticAnalyzer* _tmp147_;
				ValaSemanticAnalyzer* _tmp148_;
				ValaSemanticAnalyzer* _tmp149_;
				ValaBlock* _tmp150_;
				ValaBlock* _tmp151_;
				_tmp113_ = vala_code_context_get_analyzer (context);
				_tmp114_ = _tmp113_;
				_tmp115_ = _tmp114_->insert_block;
				_tmp116_ = _vala_code_node_ref0 (_tmp115_);
				old_insert_block = _tmp116_;
				_tmp117_ = vala_code_context_get_analyzer (context);
				_tmp118_ = _tmp117_;
				_tmp119_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp120_ = _tmp119_;
				vala_semantic_analyzer_set_current_symbol (_tmp118_, (ValaSymbol*) _tmp120_);
				_tmp121_ = vala_code_context_get_analyzer (context);
				_tmp122_ = _tmp121_;
				_tmp123_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp124_ = _tmp123_;
				_tmp125_ = _vala_code_node_ref0 (_tmp124_);
				_vala_code_node_unref0 (_tmp122_->insert_block);
				_tmp122_->insert_block = _tmp125_;
				_tmp126_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp127_ = _tmp126_;
				_tmp128_ = vala_member_access_new_simple ("GLib", _tmp127_);
				_tmp129_ = _tmp128_;
				_tmp130_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp131_ = _tmp130_;
				_tmp132_ = vala_member_access_new ((ValaExpression*) _tmp129_, "Object", _tmp131_);
				_tmp133_ = _tmp132_;
				_tmp134_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp135_ = _tmp134_;
				_tmp136_ = vala_method_call_new ((ValaExpression*) _tmp133_, _tmp135_);
				_tmp137_ = _tmp136_;
				_tmp138_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp139_ = _tmp138_;
				_tmp140_ = vala_expression_statement_new ((ValaExpression*) _tmp137_, _tmp139_);
				_tmp141_ = _tmp140_;
				_vala_code_node_unref0 (_tmp137_);
				_vala_code_node_unref0 (_tmp133_);
				_vala_code_node_unref0 (_tmp129_);
				stmt = _tmp141_;
				_tmp142_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp143_ = _tmp142_;
				_tmp144_ = stmt;
				vala_block_insert_statement (_tmp143_, 0, (ValaStatement*) _tmp144_);
				_tmp145_ = stmt;
				vala_code_node_check ((ValaCodeNode*) _tmp145_, context);
				_tmp146_ = vala_code_context_get_analyzer (context);
				_tmp147_ = _tmp146_;
				vala_semantic_analyzer_set_current_symbol (_tmp147_, (ValaSymbol*) self);
				_tmp148_ = vala_code_context_get_analyzer (context);
				_tmp149_ = _tmp148_;
				_tmp150_ = old_insert_block;
				_tmp151_ = _vala_code_node_ref0 (_tmp150_);
				_vala_code_node_unref0 (_tmp149_->insert_block);
				_tmp149_->insert_block = _tmp151_;
				_vala_code_node_unref0 (stmt);
				_vala_code_node_unref0 (old_insert_block);
			} else {
				gboolean _tmp152_ = FALSE;
				ValaClass* _tmp153_;
				ValaClass* _tmp154_;
				ValaClass* _tmp155_;
				ValaCreationMethod* _tmp156_;
				ValaCreationMethod* _tmp157_;
				_tmp153_ = cl;
				_tmp154_ = vala_class_get_base_class (_tmp153_);
				_tmp155_ = _tmp154_;
				_tmp156_ = vala_class_get_default_construction_method (_tmp155_);
				_tmp157_ = _tmp156_;
				if (_tmp157_ == NULL) {
					_tmp152_ = TRUE;
				} else {
					ValaClass* _tmp158_;
					ValaClass* _tmp159_;
					ValaClass* _tmp160_;
					ValaCreationMethod* _tmp161_;
					ValaCreationMethod* _tmp162_;
					ValaSymbolAccessibility _tmp163_;
					ValaSymbolAccessibility _tmp164_;
					_tmp158_ = cl;
					_tmp159_ = vala_class_get_base_class (_tmp158_);
					_tmp160_ = _tmp159_;
					_tmp161_ = vala_class_get_default_construction_method (_tmp160_);
					_tmp162_ = _tmp161_;
					_tmp163_ = vala_symbol_get_access ((ValaSymbol*) _tmp162_);
					_tmp164_ = _tmp163_;
					_tmp152_ = _tmp164_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				}
				if (_tmp152_) {
					ValaSourceReference* _tmp165_;
					ValaSourceReference* _tmp166_;
					_tmp165_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp166_ = _tmp165_;
					vala_report_error (_tmp166_, "unable to chain up to private base constructor");
				} else {
					ValaClass* _tmp167_;
					ValaClass* _tmp168_;
					ValaClass* _tmp169_;
					ValaCreationMethod* _tmp170_;
					ValaCreationMethod* _tmp171_;
					_tmp167_ = cl;
					_tmp168_ = vala_class_get_base_class (_tmp167_);
					_tmp169_ = _tmp168_;
					_tmp170_ = vala_class_get_default_construction_method (_tmp169_);
					_tmp171_ = _tmp170_;
					if (vala_method_get_required_arguments ((ValaMethod*) _tmp171_) > 0) {
						ValaSourceReference* _tmp172_;
						ValaSourceReference* _tmp173_;
						_tmp172_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp173_ = _tmp172_;
						vala_report_error (_tmp173_, "unable to chain up to base constructor requiring arguments");
					} else {
						ValaBlock* old_insert_block = NULL;
						ValaSemanticAnalyzer* _tmp174_;
						ValaSemanticAnalyzer* _tmp175_;
						ValaBlock* _tmp176_;
						ValaBlock* _tmp177_;
						ValaSemanticAnalyzer* _tmp178_;
						ValaSemanticAnalyzer* _tmp179_;
						ValaBlock* _tmp180_;
						ValaBlock* _tmp181_;
						ValaSemanticAnalyzer* _tmp182_;
						ValaSemanticAnalyzer* _tmp183_;
						ValaBlock* _tmp184_;
						ValaBlock* _tmp185_;
						ValaBlock* _tmp186_;
						ValaExpressionStatement* stmt = NULL;
						ValaSourceReference* _tmp187_;
						ValaSourceReference* _tmp188_;
						ValaBaseAccess* _tmp189_;
						ValaBaseAccess* _tmp190_;
						ValaSourceReference* _tmp191_;
						ValaSourceReference* _tmp192_;
						ValaMethodCall* _tmp193_;
						ValaMethodCall* _tmp194_;
						ValaSourceReference* _tmp195_;
						ValaSourceReference* _tmp196_;
						ValaExpressionStatement* _tmp197_;
						ValaExpressionStatement* _tmp198_;
						ValaBlock* _tmp199_;
						ValaBlock* _tmp200_;
						ValaExpressionStatement* _tmp201_;
						ValaExpressionStatement* _tmp202_;
						ValaSemanticAnalyzer* _tmp203_;
						ValaSemanticAnalyzer* _tmp204_;
						ValaSemanticAnalyzer* _tmp205_;
						ValaSemanticAnalyzer* _tmp206_;
						ValaBlock* _tmp207_;
						ValaBlock* _tmp208_;
						_tmp174_ = vala_code_context_get_analyzer (context);
						_tmp175_ = _tmp174_;
						_tmp176_ = _tmp175_->insert_block;
						_tmp177_ = _vala_code_node_ref0 (_tmp176_);
						old_insert_block = _tmp177_;
						_tmp178_ = vala_code_context_get_analyzer (context);
						_tmp179_ = _tmp178_;
						_tmp180_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp181_ = _tmp180_;
						vala_semantic_analyzer_set_current_symbol (_tmp179_, (ValaSymbol*) _tmp181_);
						_tmp182_ = vala_code_context_get_analyzer (context);
						_tmp183_ = _tmp182_;
						_tmp184_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp185_ = _tmp184_;
						_tmp186_ = _vala_code_node_ref0 (_tmp185_);
						_vala_code_node_unref0 (_tmp183_->insert_block);
						_tmp183_->insert_block = _tmp186_;
						_tmp187_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp188_ = _tmp187_;
						_tmp189_ = vala_base_access_new (_tmp188_);
						_tmp190_ = _tmp189_;
						_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp192_ = _tmp191_;
						_tmp193_ = vala_method_call_new ((ValaExpression*) _tmp190_, _tmp192_);
						_tmp194_ = _tmp193_;
						_tmp195_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp196_ = _tmp195_;
						_tmp197_ = vala_expression_statement_new ((ValaExpression*) _tmp194_, _tmp196_);
						_tmp198_ = _tmp197_;
						_vala_code_node_unref0 (_tmp194_);
						_vala_code_node_unref0 (_tmp190_);
						stmt = _tmp198_;
						_tmp199_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp200_ = _tmp199_;
						_tmp201_ = stmt;
						vala_block_insert_statement (_tmp200_, 0, (ValaStatement*) _tmp201_);
						_tmp202_ = stmt;
						vala_code_node_check ((ValaCodeNode*) _tmp202_, context);
						_tmp203_ = vala_code_context_get_analyzer (context);
						_tmp204_ = _tmp203_;
						vala_semantic_analyzer_set_current_symbol (_tmp204_, (ValaSymbol*) self);
						_tmp205_ = vala_code_context_get_analyzer (context);
						_tmp206_ = _tmp205_;
						_tmp207_ = old_insert_block;
						_tmp208_ = _vala_code_node_ref0 (_tmp207_);
						_vala_code_node_unref0 (_tmp206_->insert_block);
						_tmp206_->insert_block = _tmp208_;
						_vala_code_node_unref0 (stmt);
						_vala_code_node_unref0 (old_insert_block);
					}
				}
			}
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp209_ = vala_code_context_get_analyzer (context);
	_tmp210_ = _tmp209_;
	_tmp211_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp210_, _tmp211_);
	_tmp212_ = vala_code_context_get_analyzer (context);
	_tmp213_ = _tmp212_;
	_tmp214_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp213_, _tmp214_);
	_tmp217_ = vala_method_get_is_abstract ((ValaMethod*) self);
	_tmp218_ = _tmp217_;
	if (_tmp218_) {
		_tmp216_ = TRUE;
	} else {
		gboolean _tmp219_;
		gboolean _tmp220_;
		_tmp219_ = vala_method_get_is_virtual ((ValaMethod*) self);
		_tmp220_ = _tmp219_;
		_tmp216_ = _tmp220_;
	}
	if (_tmp216_) {
		_tmp215_ = TRUE;
	} else {
		gboolean _tmp221_;
		gboolean _tmp222_;
		_tmp221_ = vala_method_get_overrides ((ValaMethod*) self);
		_tmp222_ = _tmp221_;
		_tmp215_ = _tmp222_;
	}
	if (_tmp215_) {
		ValaSourceReference* _tmp223_;
		ValaSourceReference* _tmp224_;
		gchar* _tmp225_;
		gchar* _tmp226_;
		gchar* _tmp227_;
		gchar* _tmp228_;
		_tmp223_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp224_ = _tmp223_;
		_tmp225_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp226_ = _tmp225_;
		_tmp227_ = g_strdup_printf ("The creation method `%s' cannot be marked as override, virtual, or abs" \
"tract", _tmp226_);
		_tmp228_ = _tmp227_;
		vala_report_error (_tmp224_, _tmp228_);
		_g_free0 (_tmp228_);
		_g_free0 (_tmp226_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp229_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp230_ = _tmp229_;
	if (_tmp230_ != NULL) {
		ValaArrayList* body_errors = NULL;
		GEqualFunc _tmp231_;
		ValaArrayList* _tmp232_;
		ValaBlock* _tmp233_;
		ValaBlock* _tmp234_;
		ValaArrayList* _tmp235_;
		_tmp231_ = g_direct_equal;
		_tmp232_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp231_);
		body_errors = _tmp232_;
		_tmp233_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp234_ = _tmp233_;
		_tmp235_ = body_errors;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp234_, (ValaCollection*) _tmp235_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp236_;
			ValaArrayList* _tmp237_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp238_;
			gint _tmp239_;
			gint _tmp240_;
			gint _body_error_type_index = 0;
			_tmp236_ = body_errors;
			_tmp237_ = _vala_iterable_ref0 (_tmp236_);
			_body_error_type_list = _tmp237_;
			_tmp238_ = _body_error_type_list;
			_tmp239_ = vala_collection_get_size ((ValaCollection*) _tmp238_);
			_tmp240_ = _tmp239_;
			_body_error_type_size = _tmp240_;
			_body_error_type_index = -1;
			while (TRUE) {
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp241_;
				gpointer _tmp242_;
				gboolean can_propagate_error = FALSE;
				ValaList* _tmp243_;
				gboolean _tmp253_ = FALSE;
				_body_error_type_index = _body_error_type_index + 1;
				if (!(_body_error_type_index < _body_error_type_size)) {
					break;
				}
				_tmp241_ = _body_error_type_list;
				_tmp242_ = vala_list_get ((ValaList*) _tmp241_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp242_;
				can_propagate_error = FALSE;
				_tmp243_ = ((ValaMethod*) self)->error_types;
				if (_tmp243_ != NULL) {
					{
						ValaList* _method_error_type_list = NULL;
						ValaList* _tmp244_;
						ValaList* _tmp245_;
						gint _method_error_type_size = 0;
						ValaList* _tmp246_;
						gint _tmp247_;
						gint _tmp248_;
						gint _method_error_type_index = 0;
						_tmp244_ = ((ValaMethod*) self)->error_types;
						_tmp245_ = _vala_iterable_ref0 (_tmp244_);
						_method_error_type_list = _tmp245_;
						_tmp246_ = _method_error_type_list;
						_tmp247_ = vala_collection_get_size ((ValaCollection*) _tmp246_);
						_tmp248_ = _tmp247_;
						_method_error_type_size = _tmp248_;
						_method_error_type_index = -1;
						while (TRUE) {
							ValaDataType* method_error_type = NULL;
							ValaList* _tmp249_;
							gpointer _tmp250_;
							ValaDataType* _tmp251_;
							ValaDataType* _tmp252_;
							_method_error_type_index = _method_error_type_index + 1;
							if (!(_method_error_type_index < _method_error_type_size)) {
								break;
							}
							_tmp249_ = _method_error_type_list;
							_tmp250_ = vala_list_get (_tmp249_, _method_error_type_index);
							method_error_type = (ValaDataType*) _tmp250_;
							_tmp251_ = body_error_type;
							_tmp252_ = method_error_type;
							if (vala_data_type_compatible (_tmp251_, _tmp252_)) {
								can_propagate_error = TRUE;
							}
							_vala_code_node_unref0 (method_error_type);
						}
						_vala_iterable_unref0 (_method_error_type_list);
					}
				}
				if (!can_propagate_error) {
					ValaDataType* _tmp254_;
					gboolean _tmp255_;
					gboolean _tmp256_;
					_tmp254_ = body_error_type;
					_tmp255_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp254_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp256_ = _tmp255_;
					_tmp253_ = !_tmp256_;
				} else {
					_tmp253_ = FALSE;
				}
				if (_tmp253_) {
					ValaDataType* _tmp257_;
					ValaSourceReference* _tmp258_;
					ValaSourceReference* _tmp259_;
					ValaDataType* _tmp260_;
					gchar* _tmp261_;
					gchar* _tmp262_;
					gchar* _tmp263_;
					gchar* _tmp264_;
					_tmp257_ = body_error_type;
					_tmp258_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp257_);
					_tmp259_ = _tmp258_;
					_tmp260_ = body_error_type;
					_tmp261_ = vala_code_node_to_string ((ValaCodeNode*) _tmp260_);
					_tmp262_ = _tmp261_;
					_tmp263_ = g_strdup_printf ("unhandled error `%s'", _tmp262_);
					_tmp264_ = _tmp263_;
					vala_report_warning (_tmp259_, _tmp264_);
					_g_free0 (_tmp264_);
					_g_free0 (_tmp262_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
		_vala_iterable_unref0 (body_errors);
	}
	_tmp265_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp266_ = _tmp265_;
	result = !_tmp266_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

const gchar*
vala_creation_method_get_class_name (ValaCreationMethod* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_name;
	result = _tmp0_;
	return result;
}

void
vala_creation_method_set_class_name (ValaCreationMethod* self,
                                     const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_class_name);
	self->priv->_class_name = _tmp0_;
}

gboolean
vala_creation_method_get_chain_up (ValaCreationMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_chain_up;
	return result;
}

void
vala_creation_method_set_chain_up (ValaCreationMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_chain_up = value;
}

static void
vala_creation_method_class_init (ValaCreationMethodClass * klass)
{
	vala_creation_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_creation_method_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCreationMethod_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_creation_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_creation_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_creation_method_real_check;
}

static void
vala_creation_method_instance_init (ValaCreationMethod * self)
{
	self->priv = vala_creation_method_get_instance_private (self);
}

static void
vala_creation_method_finalize (ValaCodeNode * obj)
{
	ValaCreationMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
	_g_free0 (self->priv->_class_name);
	VALA_CODE_NODE_CLASS (vala_creation_method_parent_class)->finalize (obj);
}

/**
 * Represents a type creation method.
 */
GType
vala_creation_method_get_type (void)
{
	static volatile gsize vala_creation_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_creation_method_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCreationMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_creation_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCreationMethod), 0, (GInstanceInitFunc) vala_creation_method_instance_init, NULL };
		GType vala_creation_method_type_id;
		vala_creation_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaCreationMethod", &g_define_type_info, 0);
		ValaCreationMethod_private_offset = g_type_add_instance_private (vala_creation_method_type_id, sizeof (ValaCreationMethodPrivate));
		g_once_init_leave (&vala_creation_method_type_id__volatile, vala_creation_method_type_id);
	}
	return vala_creation_method_type_id__volatile;
}

