/* valacallable.c generated by valac, the Vala compiler
 * generated from valacallable.vala, do not modify */

/* valacallable.vala
 *
 * Copyright (C) 2011  Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Luca Bruno <lucabru@src.gnome.org>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>

/**
 * Appends parameter to this callable.
 *
 * @param param a formal parameter
 */
void
vala_callable_add_parameter (ValaCallable* self,
                             ValaParameter* param)
{
	g_return_if_fail (self != NULL);
	VALA_CALLABLE_GET_INTERFACE (self)->add_parameter (self, param);
}

/**
 * Returns the parameter list.
 */
ValaList*
vala_callable_get_parameters (ValaCallable* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_CALLABLE_GET_INTERFACE (self)->get_parameters (self);
}

ValaDataType*
vala_callable_get_return_type (ValaCallable* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_CALLABLE_GET_INTERFACE (self)->get_return_type (self);
}

void
vala_callable_set_return_type (ValaCallable* self,
                               ValaDataType* value)
{
	g_return_if_fail (self != NULL);
	VALA_CALLABLE_GET_INTERFACE (self)->set_return_type (self, value);
}

static void
vala_callable_default_init (ValaCallableIface * iface)
{
}

/**
 * Interface for all callable types.
 */
GType
vala_callable_get_type (void)
{
	static volatile gsize vala_callable_type_id__volatile = 0;
	if (g_once_init_enter (&vala_callable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCallableIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_callable_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType vala_callable_type_id;
		vala_callable_type_id = g_type_register_static (G_TYPE_INTERFACE, "ValaCallable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (vala_callable_type_id, VALA_TYPE_CODE_NODE);
		g_once_init_leave (&vala_callable_type_id__volatile, vala_callable_type_id);
	}
	return vala_callable_type_id__volatile;
}

