/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
typedef struct _ValaGLibValuePrivate ValaGLibValuePrivate;
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGLibValue {
	ValaTargetValue parent_instance;
	ValaCCodeExpression* cvalue;
	gboolean lvalue;
	gboolean non_null;
	gchar* ctype;
	ValaList* array_length_cvalues;
	ValaCCodeExpression* array_size_cvalue;
	gboolean array_null_terminated;
	ValaCCodeExpression* array_length_cexpr;
	ValaCCodeExpression* delegate_target_cvalue;
	ValaCCodeExpression* delegate_target_destroy_notify_cvalue;
	ValaGLibValuePrivate * priv;
};

struct _ValaGLibValueClass {
	ValaTargetValueClass parent_class;
};


static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                                      ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean vala_ccode_method_call_module_has_ref_out_param (ValaCCodeMethodCallModule* self,
                                                          ValaCallable* c);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}


static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}


static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gint _tmp23_;
		gsize _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		const gchar* res = NULL;
		gsize _tmp28_;
		void* _tmp29_;
		void* ptr = NULL;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		void* _tmp32_;
		const gchar* _tmp45_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = str_array_length1;
		_tmp24_ = len;
		_tmp25_ = strlen ((const gchar*) separator);
		_tmp26_ = _tmp25_;
		_tmp27_ = i;
		len = _tmp24_ + (_tmp26_ * (_tmp27_ - 1));
		_tmp28_ = len;
		_tmp29_ = g_malloc (_tmp28_);
		res = _tmp29_;
		_tmp30_ = res;
		_tmp31_ = str_array[0];
		_tmp32_ = g_stpcpy ((void*) _tmp30_, (const gchar*) _tmp31_);
		ptr = _tmp32_;
		{
			gboolean _tmp33_ = FALSE;
			i = 1;
			_tmp33_ = TRUE;
			while (TRUE) {
				gint _tmp35_;
				void* _tmp36_;
				void* _tmp37_;
				const gchar* _tmp38_ = NULL;
				gint _tmp39_;
				const gchar* _tmp40_;
				void* _tmp43_;
				void* _tmp44_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp35_ = i;
				if (!(_tmp35_ < str_array_length1)) {
					break;
				}
				_tmp36_ = ptr;
				_tmp37_ = g_stpcpy (_tmp36_, (const gchar*) separator);
				ptr = _tmp37_;
				_tmp39_ = i;
				_tmp40_ = str_array[_tmp39_];
				if (_tmp40_ != NULL) {
					gint _tmp41_;
					const gchar* _tmp42_;
					_tmp41_ = i;
					_tmp42_ = str_array[_tmp41_];
					_tmp38_ = (const gchar*) _tmp42_;
				} else {
					_tmp38_ = "";
				}
				_tmp43_ = ptr;
				_tmp44_ = g_stpcpy (_tmp43_, _tmp38_);
				ptr = _tmp44_;
			}
		}
		_tmp45_ = res;
		res = NULL;
		result = (gchar*) _tmp45_;
		return result;
	} else {
		gchar* _tmp46_;
		_tmp46_ = g_strdup ("");
		result = _tmp46_;
		return result;
	}
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp15_;
	ValaDataType* _tmp16_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp164_;
	GEqualFunc _tmp165_;
	GEqualFunc _tmp166_;
	ValaHashMap* _tmp167_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp168_;
	ValaHashMap* _tmp169_;
	gboolean _tmp170_ = FALSE;
	ValaMethod* _tmp171_;
	gboolean _tmp316_ = FALSE;
	ValaMethod* _tmp317_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp495_;
	ValaCCodeExpression* _tmp496_;
	ValaMethod* _tmp497_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp521_ = FALSE;
	ValaMethod* _tmp522_;
	gboolean _tmp678_ = FALSE;
	ValaMethod* _tmp679_;
	ValaMethod* _tmp731_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp932_;
	ValaIterator* _tmp933_;
	ValaIterator* _tmp1289_;
	gboolean _tmp1299_ = FALSE;
	gboolean _tmp1300_ = FALSE;
	ValaMethod* _tmp1301_;
	gboolean _tmp1426_ = FALSE;
	ValaDelegate* _tmp1427_;
	gboolean _tmp1524_ = FALSE;
	ValaMethod* _tmp1525_;
	gboolean _tmp1541_;
	gboolean _tmp1542_;
	gboolean _tmp1557_;
	ValaDataType* _tmp1582_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1606_;
	ValaDataType* _tmp1607_;
	ValaDataType* _tmp1608_;
	gboolean _tmp1609_;
	gboolean _tmp1610_ = FALSE;
	ValaDataType* _tmp1611_;
	ValaCCodeFunctionCall* _tmp1640_;
	ValaCCodeFunctionCall* _tmp1641_;
	ValaCCodeExpression* out_param_ref = NULL;
	gboolean _tmp1642_;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1657_;
	ValaCCodeFunctionCall* _tmp1658_;
	ValaCCodeFunctionCall* _tmp1682_;
	gboolean _tmp1706_;
	gboolean _tmp1707_;
	gboolean _tmp1733_;
	gboolean _tmp1734_;
	gboolean _tmp1764_;
	gboolean _tmp1770_ = FALSE;
	gboolean _tmp1771_ = FALSE;
	ValaMethod* _tmp1772_;
	gboolean _tmp1810_ = FALSE;
	gboolean _tmp1811_ = FALSE;
	ValaMethod* _tmp1812_;
	ValaMethod* _tmp1831_;
	gboolean _tmp1948_ = FALSE;
	ValaCodeNode* _tmp1949_;
	ValaCodeNode* _tmp1950_;
	ValaList* _tmp2033_;
	ValaIterator* _tmp2034_;
	gboolean _tmp2119_ = FALSE;
	gboolean _tmp2120_ = FALSE;
	ValaMethod* _tmp2121_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccall = _tmp5_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp6_ = vala_method_call_get_call (expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp7_) : NULL);
	ma = _tmp8_;
	_tmp9_ = vala_method_call_get_call (expr);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	itype = _tmp13_;
	_tmp14_ = itype;
	_tmp15_ = vala_data_type_get_parameters (_tmp14_);
	_vala_iterable_unref0 (params);
	params = _tmp15_;
	_tmp16_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp17_;
		ValaDataType* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaMethod* _tmp22_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		ValaMemberAccess* _tmp26_;
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp17_ = ma;
		_vala_assert (_tmp17_ != NULL, "ma != null");
		_tmp18_ = itype;
		_tmp19_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (m);
		m = _tmp21_;
		_tmp22_ = m;
		if (!vala_get_ccode_simple_generics (_tmp22_)) {
			ValaMemberAccess* _tmp23_;
			_tmp23_ = ma;
			vala_ccode_base_module_check_type_arguments ((ValaCCodeBaseModule*) self, _tmp23_);
		}
		_tmp26_ = ma;
		_tmp27_ = vala_member_access_get_inner (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ != NULL) {
			ValaMemberAccess* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			_tmp29_ = ma;
			_tmp30_ = vala_member_access_get_inner (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_expression_get_value_type (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			ValaMemberAccess* _tmp34_;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaMethod* _tmp39_;
			ValaMethod* _tmp40_;
			ValaMethod* _tmp41_;
			_tmp34_ = ma;
			_tmp35_ = vala_member_access_get_inner (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_expression_get_value_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp40_ = _tmp39_;
			_tmp41_ = m;
			_tmp24_ = _tmp40_ == _tmp41_;
			_vala_code_node_unref0 (_tmp40_);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			ValaTypeSymbol* _tmp47_;
			ValaTypeSymbol* _tmp48_;
			ValaEnum* _tmp49_;
			ValaCCodeFunctionCall* _tmp50_;
			ValaEnum* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			ValaCCodeIdentifier* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_data_type_get_data_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_ENUM, ValaEnum));
			en = _tmp49_;
			_tmp50_ = ccall;
			_tmp51_ = en;
			_tmp52_ = vala_ccode_method_call_module_generate_enum_tostring_function (self, _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_identifier_new (_tmp53_);
			_tmp55_ = _tmp54_;
			vala_ccode_function_call_set_call (_tmp50_, (ValaCCodeExpression*) _tmp55_);
			_vala_ccode_node_unref0 (_tmp55_);
			_g_free0 (_tmp53_);
			_vala_code_node_unref0 (en);
		} else {
			gboolean _tmp56_ = FALSE;
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			ValaCodeContext* _tmp60_;
			ValaCodeContext* _tmp61_;
			ValaProfile _tmp62_;
			ValaProfile _tmp63_;
			_tmp60_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_code_context_get_profile (_tmp61_);
			_tmp63_ = _tmp62_;
			if (_tmp63_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp64_;
				ValaExpression* _tmp65_;
				ValaExpression* _tmp66_;
				_tmp64_ = ma;
				_tmp65_ = vala_member_access_get_inner (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp59_ = _tmp66_ != NULL;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaMemberAccess* _tmp67_;
				ValaExpression* _tmp68_;
				ValaExpression* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				_tmp67_ = ma;
				_tmp68_ = vala_member_access_get_inner (_tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = vala_expression_get_value_type (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp58_ = _tmp71_ != NULL;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaMemberAccess* _tmp72_;
				ValaExpression* _tmp73_;
				ValaExpression* _tmp74_;
				ValaDataType* _tmp75_;
				ValaDataType* _tmp76_;
				ValaTypeSymbol* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaDataType* _tmp79_;
				ValaTypeSymbol* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				_tmp72_ = ma;
				_tmp73_ = vala_member_access_get_inner (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = vala_expression_get_value_type (_tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = vala_data_type_get_data_type (_tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp80_ = vala_data_type_get_data_type (_tmp79_);
				_tmp81_ = _tmp80_;
				_tmp57_ = _tmp78_ == _tmp81_;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaMemberAccess* _tmp82_;
				const gchar* _tmp83_;
				const gchar* _tmp84_;
				_tmp82_ = ma;
				_tmp83_ = vala_member_access_get_member_name (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp56_ = g_strcmp0 (_tmp84_, "printf") == 0;
			} else {
				_tmp56_ = FALSE;
			}
			if (_tmp56_) {
				ValaCCodeFunctionCall* _tmp85_;
				gchar* _tmp86_;
				gchar* _tmp87_;
				ValaCCodeIdentifier* _tmp88_;
				ValaCCodeIdentifier* _tmp89_;
				_tmp85_ = ccall;
				_tmp86_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp87_ = _tmp86_;
				_tmp88_ = vala_ccode_identifier_new (_tmp87_);
				_tmp89_ = _tmp88_;
				vala_ccode_function_call_set_call (_tmp85_, (ValaCCodeExpression*) _tmp89_);
				_vala_ccode_node_unref0 (_tmp89_);
				_g_free0 (_tmp87_);
			} else {
				gboolean _tmp90_;
				gboolean _tmp91_;
				_tmp90_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp91_ = _tmp90_;
				if (_tmp91_) {
					ValaCCodeFunctionCall* _tmp92_;
					ValaMethod* _tmp93_;
					gchar* _tmp94_;
					gchar* _tmp95_;
					ValaCCodeIdentifier* _tmp96_;
					ValaCCodeIdentifier* _tmp97_;
					_tmp92_ = ccall;
					_tmp93_ = m;
					_tmp94_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp95_ = _tmp94_;
					_tmp96_ = vala_ccode_identifier_new (_tmp95_);
					_tmp97_ = _tmp96_;
					vala_ccode_function_call_set_call (_tmp92_, (ValaCCodeExpression*) _tmp97_);
					_vala_ccode_node_unref0 (_tmp97_);
					_g_free0 (_tmp95_);
				}
			}
		}
	} else {
		ValaDataType* _tmp98_;
		_tmp98_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp98_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp99_;
			ValaSignalType* _tmp100_;
			gboolean _tmp101_ = FALSE;
			gboolean _tmp102_ = FALSE;
			ValaMemberAccess* _tmp103_;
			_tmp99_ = itype;
			_tmp100_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp100_;
			_tmp103_ = ma;
			if (_tmp103_ != NULL) {
				ValaMemberAccess* _tmp104_;
				ValaExpression* _tmp105_;
				ValaExpression* _tmp106_;
				_tmp104_ = ma;
				_tmp105_ = vala_member_access_get_inner (_tmp104_);
				_tmp106_ = _tmp105_;
				_tmp102_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp106_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp102_ = FALSE;
			}
			if (_tmp102_) {
				ValaSignalType* _tmp107_;
				ValaSignal* _tmp108_;
				ValaSignal* _tmp109_;
				gboolean _tmp110_;
				gboolean _tmp111_;
				_tmp107_ = sig_type;
				_tmp108_ = vala_signal_type_get_signal_symbol (_tmp107_);
				_tmp109_ = _tmp108_;
				_tmp110_ = vala_signal_get_is_virtual (_tmp109_);
				_tmp111_ = _tmp110_;
				_tmp101_ = _tmp111_;
			} else {
				_tmp101_ = FALSE;
			}
			if (_tmp101_) {
				ValaSignalType* _tmp112_;
				ValaSignal* _tmp113_;
				ValaSignal* _tmp114_;
				ValaMethod* _tmp115_;
				ValaMethod* _tmp116_;
				ValaMethod* _tmp117_;
				_tmp112_ = sig_type;
				_tmp113_ = vala_signal_type_get_signal_symbol (_tmp112_);
				_tmp114_ = _tmp113_;
				_tmp115_ = vala_signal_get_default_handler (_tmp114_);
				_tmp116_ = _tmp115_;
				_tmp117_ = _vala_code_node_ref0 (_tmp116_);
				_vala_code_node_unref0 (m);
				m = _tmp117_;
			} else {
				ValaExpression* _tmp118_;
				ValaExpression* _tmp119_;
				ValaCCodeExpression* _tmp120_;
				_tmp118_ = vala_method_call_get_call (expr);
				_tmp119_ = _tmp118_;
				_tmp120_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp119_);
				_vala_ccode_node_unref0 (ccall);
				ccall = G_TYPE_CHECK_INSTANCE_CAST (_tmp120_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall);
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp121_;
			_tmp121_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp121_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp122_;
				ValaObjectTypeSymbol* _tmp123_;
				ValaObjectTypeSymbol* _tmp124_;
				ValaClass* _tmp125_;
				ValaClass* _tmp126_;
				ValaCreationMethod* _tmp127_;
				ValaCreationMethod* _tmp128_;
				ValaMethod* _tmp129_;
				ValaMethod* _tmp130_;
				ValaCCodeFile* _tmp131_;
				gchar* real_name = NULL;
				ValaMethod* _tmp132_;
				gchar* _tmp133_;
				gboolean _tmp134_;
				gboolean _tmp135_;
				const gchar* _tmp138_;
				ValaCCodeIdentifier* _tmp139_;
				ValaCCodeIdentifier* _tmp140_;
				ValaCCodeFunctionCall* _tmp141_;
				_tmp122_ = itype;
				_tmp123_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp122_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp124_ = _tmp123_;
				_tmp125_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp125_;
				_tmp126_ = cl;
				_tmp127_ = vala_class_get_default_construction_method (_tmp126_);
				_tmp128_ = _tmp127_;
				_tmp129_ = _vala_code_node_ref0 ((ValaMethod*) _tmp128_);
				_vala_code_node_unref0 (m);
				m = _tmp129_;
				_tmp130_ = m;
				_tmp131_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp130_, _tmp131_);
				_tmp132_ = m;
				_tmp133_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp132_);
				real_name = _tmp133_;
				_tmp134_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp135_ = _tmp134_;
				if (_tmp135_) {
					ValaMethod* _tmp136_;
					gchar* _tmp137_;
					_tmp136_ = m;
					_tmp137_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp136_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp137_;
				}
				_tmp138_ = real_name;
				_tmp139_ = vala_ccode_identifier_new (_tmp138_);
				_tmp140_ = _tmp139_;
				_tmp141_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp140_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp141_;
				_vala_ccode_node_unref0 (_tmp140_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp142_;
				_tmp142_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp142_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp143_;
					ValaTypeSymbol* _tmp144_;
					ValaTypeSymbol* _tmp145_;
					ValaStruct* _tmp146_;
					ValaStruct* _tmp147_;
					ValaMethod* _tmp148_;
					ValaMethod* _tmp149_;
					ValaMethod* _tmp150_;
					ValaMethod* _tmp151_;
					ValaCCodeFile* _tmp152_;
					ValaMethod* _tmp153_;
					gchar* _tmp154_;
					gchar* _tmp155_;
					ValaCCodeIdentifier* _tmp156_;
					ValaCCodeIdentifier* _tmp157_;
					ValaCCodeFunctionCall* _tmp158_;
					_tmp143_ = itype;
					_tmp144_ = vala_value_type_get_type_symbol ((ValaValueType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp143_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp145_ = _tmp144_;
					_tmp146_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp146_;
					_tmp147_ = st;
					_tmp148_ = vala_struct_get_default_construction_method (_tmp147_);
					_tmp149_ = _tmp148_;
					_tmp150_ = _vala_code_node_ref0 (_tmp149_);
					_vala_code_node_unref0 (m);
					m = _tmp150_;
					_tmp151_ = m;
					_tmp152_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp151_, _tmp152_);
					_tmp153_ = m;
					_tmp154_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp153_);
					_tmp155_ = _tmp154_;
					_tmp156_ = vala_ccode_identifier_new (_tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp157_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp158_;
					_vala_ccode_node_unref0 (_tmp157_);
					_g_free0 (_tmp155_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp159_;
					_tmp159_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp159_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp160_;
						ValaDelegate* _tmp161_;
						ValaDelegate* _tmp162_;
						ValaDelegate* _tmp163_;
						_tmp160_ = itype;
						_tmp161_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp162_ = _tmp161_;
						_tmp163_ = _vala_code_node_ref0 (_tmp162_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp163_;
					}
				}
			}
		}
	}
	_tmp164_ = g_direct_hash;
	_tmp165_ = g_direct_equal;
	_tmp166_ = g_direct_equal;
	_tmp167_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp164_, _tmp165_, _tmp166_);
	in_arg_map = _tmp167_;
	_tmp168_ = in_arg_map;
	_tmp169_ = _vala_map_ref0 (_tmp168_);
	out_arg_map = _tmp169_;
	_tmp171_ = m;
	if (_tmp171_ != NULL) {
		ValaMethod* _tmp172_;
		gboolean _tmp173_;
		gboolean _tmp174_;
		_tmp172_ = m;
		_tmp173_ = vala_method_get_coroutine (_tmp172_);
		_tmp174_ = _tmp173_;
		_tmp170_ = _tmp174_;
	} else {
		_tmp170_ = FALSE;
	}
	if (_tmp170_) {
		ValaMethod* _tmp175_;
		gchar* _tmp176_;
		gchar* _tmp177_;
		ValaCCodeIdentifier* _tmp178_;
		ValaCCodeIdentifier* _tmp179_;
		ValaCCodeFunctionCall* _tmp180_;
		ValaMethod* _tmp181_;
		gchar* _tmp182_;
		gchar* _tmp183_;
		ValaCCodeIdentifier* _tmp184_;
		ValaCCodeIdentifier* _tmp185_;
		ValaCCodeFunctionCall* _tmp186_;
		ValaMemberAccess* _tmp187_;
		ValaExpression* _tmp188_;
		ValaExpression* _tmp189_;
		gboolean _tmp267_ = FALSE;
		ValaMemberAccess* _tmp268_;
		const gchar* _tmp269_;
		const gchar* _tmp270_;
		_tmp175_ = m;
		_tmp176_ = vala_get_ccode_name ((ValaCodeNode*) _tmp175_);
		_tmp177_ = _tmp176_;
		_tmp178_ = vala_ccode_identifier_new (_tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp179_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp180_;
		_vala_ccode_node_unref0 (_tmp179_);
		_g_free0 (_tmp177_);
		_tmp181_ = m;
		_tmp182_ = vala_get_ccode_finish_name (_tmp181_);
		_tmp183_ = _tmp182_;
		_tmp184_ = vala_ccode_identifier_new (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp185_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp186_;
		_vala_ccode_node_unref0 (_tmp185_);
		_g_free0 (_tmp183_);
		_tmp187_ = ma;
		_tmp188_ = vala_member_access_get_inner (_tmp187_);
		_tmp189_ = _tmp188_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp189_, VALA_TYPE_BASE_ACCESS)) {
			ValaMethod* _tmp190_;
			ValaMethod* _tmp191_;
			ValaMethod* _tmp192_;
			_tmp190_ = m;
			_tmp191_ = vala_method_get_base_method (_tmp190_);
			_tmp192_ = _tmp191_;
			if (_tmp192_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp193_;
				ValaMethod* _tmp194_;
				ValaMethod* _tmp195_;
				ValaSymbol* _tmp196_;
				ValaSymbol* _tmp197_;
				ValaClass* _tmp198_;
				ValaCCodeFunctionCall* vcast = NULL;
				ValaClass* _tmp199_;
				gchar* _tmp200_;
				gchar* _tmp201_;
				gchar* _tmp202_;
				gchar* _tmp203_;
				ValaCCodeIdentifier* _tmp204_;
				ValaCCodeIdentifier* _tmp205_;
				ValaCCodeFunctionCall* _tmp206_;
				ValaCCodeFunctionCall* _tmp207_;
				ValaCCodeFunctionCall* _tmp208_;
				ValaClass* _tmp209_;
				ValaClass* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				gchar* _tmp213_;
				gchar* _tmp214_;
				ValaCCodeIdentifier* _tmp215_;
				ValaCCodeIdentifier* _tmp216_;
				ValaCCodeFunctionCall* _tmp217_;
				ValaCCodeFunctionCall* _tmp218_;
				ValaMethod* _tmp219_;
				gchar* _tmp220_;
				gchar* _tmp221_;
				ValaCCodeMemberAccess* _tmp222_;
				ValaCCodeMemberAccess* _tmp223_;
				ValaCCodeFunctionCall* _tmp224_;
				ValaCCodeFunctionCall* _tmp225_;
				ValaMethod* _tmp226_;
				gchar* _tmp227_;
				gchar* _tmp228_;
				ValaCCodeMemberAccess* _tmp229_;
				ValaCCodeMemberAccess* _tmp230_;
				_tmp193_ = m;
				_tmp194_ = vala_method_get_base_method (_tmp193_);
				_tmp195_ = _tmp194_;
				_tmp196_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp197_, VALA_TYPE_CLASS, ValaClass));
				base_class = _tmp198_;
				_tmp199_ = base_class;
				_tmp200_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp199_, NULL);
				_tmp201_ = _tmp200_;
				_tmp202_ = g_strdup_printf ("%s_CLASS", _tmp201_);
				_tmp203_ = _tmp202_;
				_tmp204_ = vala_ccode_identifier_new (_tmp203_);
				_tmp205_ = _tmp204_;
				_tmp206_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp205_);
				_tmp207_ = _tmp206_;
				_vala_ccode_node_unref0 (_tmp205_);
				_g_free0 (_tmp203_);
				_g_free0 (_tmp201_);
				vcast = _tmp207_;
				_tmp208_ = vcast;
				_tmp209_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp210_ = _tmp209_;
				_tmp211_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp210_, NULL);
				_tmp212_ = _tmp211_;
				_tmp213_ = g_strdup_printf ("%s_parent_class", _tmp212_);
				_tmp214_ = _tmp213_;
				_tmp215_ = vala_ccode_identifier_new (_tmp214_);
				_tmp216_ = _tmp215_;
				vala_ccode_function_call_add_argument (_tmp208_, (ValaCCodeExpression*) _tmp216_);
				_vala_ccode_node_unref0 (_tmp216_);
				_g_free0 (_tmp214_);
				_g_free0 (_tmp212_);
				_tmp217_ = async_call;
				_tmp218_ = vcast;
				_tmp219_ = m;
				_tmp220_ = vala_get_ccode_vfunc_name (_tmp219_);
				_tmp221_ = _tmp220_;
				_tmp222_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp218_, _tmp221_);
				_tmp223_ = _tmp222_;
				vala_ccode_function_call_set_call (_tmp217_, (ValaCCodeExpression*) _tmp223_);
				_vala_ccode_node_unref0 (_tmp223_);
				_g_free0 (_tmp221_);
				_tmp224_ = finish_call;
				_tmp225_ = vcast;
				_tmp226_ = m;
				_tmp227_ = vala_get_ccode_finish_vfunc_name (_tmp226_);
				_tmp228_ = _tmp227_;
				_tmp229_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp225_, _tmp228_);
				_tmp230_ = _tmp229_;
				vala_ccode_function_call_set_call (_tmp224_, (ValaCCodeExpression*) _tmp230_);
				_vala_ccode_node_unref0 (_tmp230_);
				_g_free0 (_tmp228_);
				_vala_ccode_node_unref0 (vcast);
				_vala_code_node_unref0 (base_class);
			} else {
				ValaMethod* _tmp231_;
				ValaMethod* _tmp232_;
				ValaMethod* _tmp233_;
				_tmp231_ = m;
				_tmp232_ = vala_method_get_base_interface_method (_tmp231_);
				_tmp233_ = _tmp232_;
				if (_tmp233_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp234_;
					ValaMethod* _tmp235_;
					ValaMethod* _tmp236_;
					ValaSymbol* _tmp237_;
					ValaSymbol* _tmp238_;
					ValaInterface* _tmp239_;
					gchar* parent_iface_var = NULL;
					ValaClass* _tmp240_;
					ValaClass* _tmp241_;
					gchar* _tmp242_;
					gchar* _tmp243_;
					ValaInterface* _tmp244_;
					gchar* _tmp245_;
					gchar* _tmp246_;
					gchar* _tmp247_;
					gchar* _tmp248_;
					ValaCCodeFunctionCall* _tmp249_;
					const gchar* _tmp250_;
					ValaCCodeIdentifier* _tmp251_;
					ValaCCodeIdentifier* _tmp252_;
					ValaMethod* _tmp253_;
					gchar* _tmp254_;
					gchar* _tmp255_;
					ValaCCodeMemberAccess* _tmp256_;
					ValaCCodeMemberAccess* _tmp257_;
					ValaCCodeFunctionCall* _tmp258_;
					const gchar* _tmp259_;
					ValaCCodeIdentifier* _tmp260_;
					ValaCCodeIdentifier* _tmp261_;
					ValaMethod* _tmp262_;
					gchar* _tmp263_;
					gchar* _tmp264_;
					ValaCCodeMemberAccess* _tmp265_;
					ValaCCodeMemberAccess* _tmp266_;
					_tmp234_ = m;
					_tmp235_ = vala_method_get_base_interface_method (_tmp234_);
					_tmp236_ = _tmp235_;
					_tmp237_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp236_);
					_tmp238_ = _tmp237_;
					_tmp239_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp238_, VALA_TYPE_INTERFACE, ValaInterface));
					base_iface = _tmp239_;
					_tmp240_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp241_ = _tmp240_;
					_tmp242_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp241_, NULL);
					_tmp243_ = _tmp242_;
					_tmp244_ = base_iface;
					_tmp245_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp244_, NULL);
					_tmp246_ = _tmp245_;
					_tmp247_ = g_strdup_printf ("%s_%s_parent_iface", _tmp243_, _tmp246_);
					_tmp248_ = _tmp247_;
					_g_free0 (_tmp246_);
					_g_free0 (_tmp243_);
					parent_iface_var = _tmp248_;
					_tmp249_ = async_call;
					_tmp250_ = parent_iface_var;
					_tmp251_ = vala_ccode_identifier_new (_tmp250_);
					_tmp252_ = _tmp251_;
					_tmp253_ = m;
					_tmp254_ = vala_get_ccode_vfunc_name (_tmp253_);
					_tmp255_ = _tmp254_;
					_tmp256_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp252_, _tmp255_);
					_tmp257_ = _tmp256_;
					vala_ccode_function_call_set_call (_tmp249_, (ValaCCodeExpression*) _tmp257_);
					_vala_ccode_node_unref0 (_tmp257_);
					_g_free0 (_tmp255_);
					_vala_ccode_node_unref0 (_tmp252_);
					_tmp258_ = finish_call;
					_tmp259_ = parent_iface_var;
					_tmp260_ = vala_ccode_identifier_new (_tmp259_);
					_tmp261_ = _tmp260_;
					_tmp262_ = m;
					_tmp263_ = vala_get_ccode_finish_vfunc_name (_tmp262_);
					_tmp264_ = _tmp263_;
					_tmp265_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp261_, _tmp264_);
					_tmp266_ = _tmp265_;
					vala_ccode_function_call_set_call (_tmp258_, (ValaCCodeExpression*) _tmp266_);
					_vala_ccode_node_unref0 (_tmp266_);
					_g_free0 (_tmp264_);
					_vala_ccode_node_unref0 (_tmp261_);
					_g_free0 (parent_iface_var);
					_vala_code_node_unref0 (base_iface);
				}
			}
		}
		_tmp268_ = ma;
		_tmp269_ = vala_member_access_get_member_name (_tmp268_);
		_tmp270_ = _tmp269_;
		if (g_strcmp0 (_tmp270_, "begin") == 0) {
			ValaMemberAccess* _tmp271_;
			ValaExpression* _tmp272_;
			ValaExpression* _tmp273_;
			ValaSymbol* _tmp274_;
			ValaSymbol* _tmp275_;
			ValaMemberAccess* _tmp276_;
			ValaSymbol* _tmp277_;
			ValaSymbol* _tmp278_;
			_tmp271_ = ma;
			_tmp272_ = vala_member_access_get_inner (_tmp271_);
			_tmp273_ = _tmp272_;
			_tmp274_ = vala_expression_get_symbol_reference (_tmp273_);
			_tmp275_ = _tmp274_;
			_tmp276_ = ma;
			_tmp277_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp276_);
			_tmp278_ = _tmp277_;
			_tmp267_ = _tmp275_ == _tmp278_;
		} else {
			_tmp267_ = FALSE;
		}
		if (_tmp267_) {
			ValaCCodeFunctionCall* _tmp279_;
			ValaCCodeFunctionCall* _tmp280_;
			ValaMethod* _tmp281_;
			ValaList* _tmp282_;
			_tmp279_ = async_call;
			_tmp280_ = _vala_ccode_node_ref0 (_tmp279_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp280_;
			_tmp281_ = m;
			_tmp282_ = vala_method_get_async_begin_parameters (_tmp281_);
			_vala_iterable_unref0 (params);
			params = _tmp282_;
		} else {
			gboolean _tmp283_ = FALSE;
			ValaMemberAccess* _tmp284_;
			const gchar* _tmp285_;
			const gchar* _tmp286_;
			_tmp284_ = ma;
			_tmp285_ = vala_member_access_get_member_name (_tmp284_);
			_tmp286_ = _tmp285_;
			if (g_strcmp0 (_tmp286_, "end") == 0) {
				ValaMemberAccess* _tmp287_;
				ValaExpression* _tmp288_;
				ValaExpression* _tmp289_;
				ValaSymbol* _tmp290_;
				ValaSymbol* _tmp291_;
				ValaMemberAccess* _tmp292_;
				ValaSymbol* _tmp293_;
				ValaSymbol* _tmp294_;
				_tmp287_ = ma;
				_tmp288_ = vala_member_access_get_inner (_tmp287_);
				_tmp289_ = _tmp288_;
				_tmp290_ = vala_expression_get_symbol_reference (_tmp289_);
				_tmp291_ = _tmp290_;
				_tmp292_ = ma;
				_tmp293_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp292_);
				_tmp294_ = _tmp293_;
				_tmp283_ = _tmp291_ == _tmp294_;
			} else {
				_tmp283_ = FALSE;
			}
			if (_tmp283_) {
				ValaCCodeFunctionCall* _tmp295_;
				ValaCCodeFunctionCall* _tmp296_;
				ValaMethod* _tmp297_;
				ValaList* _tmp298_;
				_tmp295_ = finish_call;
				_tmp296_ = _vala_ccode_node_ref0 (_tmp295_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp296_;
				_tmp297_ = m;
				_tmp298_ = vala_method_get_async_end_parameters (_tmp297_);
				_vala_iterable_unref0 (params);
				params = _tmp298_;
			} else {
				gboolean _tmp299_;
				gboolean _tmp300_;
				_tmp299_ = vala_method_call_get_is_yield_expression (expr);
				_tmp300_ = _tmp299_;
				if (!_tmp300_) {
					ValaCCodeFunctionCall* _tmp301_;
					ValaCCodeFunctionCall* _tmp302_;
					ValaMethod* _tmp303_;
					ValaList* _tmp304_;
					_tmp301_ = async_call;
					_tmp302_ = _vala_ccode_node_ref0 (_tmp301_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp302_;
					_tmp303_ = m;
					_tmp304_ = vala_method_get_async_begin_parameters (_tmp303_);
					_vala_iterable_unref0 (params);
					params = _tmp304_;
				} else {
					ValaCCodeFunctionCall* _tmp305_;
					ValaCCodeFunctionCall* _tmp306_;
					GHashFunc _tmp307_;
					GEqualFunc _tmp308_;
					GEqualFunc _tmp309_;
					ValaHashMap* _tmp310_;
					ValaHashMap* _tmp311_;
					ValaCCodeIdentifier* _tmp312_;
					ValaCCodeIdentifier* _tmp313_;
					ValaCCodeMemberAccess* _tmp314_;
					ValaCCodeMemberAccess* _tmp315_;
					_tmp305_ = finish_call;
					_tmp306_ = _vala_ccode_node_ref0 (_tmp305_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp306_;
					_tmp307_ = g_direct_hash;
					_tmp308_ = g_direct_equal;
					_tmp309_ = g_direct_equal;
					_tmp310_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp307_, _tmp308_, _tmp309_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp310_;
					_tmp311_ = out_arg_map;
					_tmp312_ = vala_ccode_identifier_new ("_data_");
					_tmp313_ = _tmp312_;
					_tmp314_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp313_, "_res_");
					_tmp315_ = _tmp314_;
					vala_map_set ((ValaMap*) _tmp311_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp315_);
					_vala_ccode_node_unref0 (_tmp315_);
					_vala_ccode_node_unref0 (_tmp313_);
				}
			}
		}
	}
	_tmp317_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp317_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp318_;
		ValaSymbol* _tmp319_;
		ValaSymbol* _tmp320_;
		_tmp318_ = m;
		_tmp319_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp318_);
		_tmp320_ = _tmp319_;
		_tmp316_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp320_, VALA_TYPE_CLASS);
	} else {
		_tmp316_ = FALSE;
	}
	if (_tmp316_) {
		ValaCodeContext* _tmp321_;
		ValaCodeContext* _tmp322_;
		ValaProfile _tmp323_;
		ValaProfile _tmp324_;
		ValaClass* _tmp336_;
		ValaClass* _tmp337_;
		gboolean _tmp338_;
		gboolean _tmp339_;
		_tmp321_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp322_ = _tmp321_;
		_tmp323_ = vala_code_context_get_profile (_tmp322_);
		_tmp324_ = _tmp323_;
		if (_tmp324_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp325_;
			ValaSymbol* _tmp326_;
			ValaSymbol* _tmp327_;
			gboolean _tmp328_;
			gboolean _tmp329_;
			_tmp325_ = m;
			_tmp326_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp325_);
			_tmp327_ = _tmp326_;
			_tmp328_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp327_, VALA_TYPE_CLASS, ValaClass));
			_tmp329_ = _tmp328_;
			if (!_tmp329_) {
				ValaCCodeFunctionCall* _tmp330_;
				ValaCCodeExpression* _tmp331_;
				ValaCCodeExpression* _tmp332_;
				_tmp330_ = ccall;
				_tmp331_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp332_ = _tmp331_;
				vala_ccode_function_call_add_argument (_tmp330_, _tmp332_);
				_vala_ccode_node_unref0 (_tmp332_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp333_;
			ValaCCodeExpression* _tmp334_;
			ValaCCodeExpression* _tmp335_;
			_tmp333_ = ccall;
			_tmp334_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp335_ = _tmp334_;
			vala_ccode_function_call_add_argument (_tmp333_, _tmp335_);
			_vala_ccode_node_unref0 (_tmp335_);
		}
		_tmp336_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp337_ = _tmp336_;
		_tmp338_ = vala_class_get_is_compact (_tmp337_);
		_tmp339_ = _tmp338_;
		if (!_tmp339_) {
			ValaClass* _tmp340_;
			ValaClass* _tmp341_;
			ValaMethod* _tmp342_;
			ValaSymbol* _tmp343_;
			ValaSymbol* _tmp344_;
			_tmp340_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp341_ = _tmp340_;
			_tmp342_ = m;
			_tmp343_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp342_);
			_tmp344_ = _tmp343_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp341_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp344_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp345_;
					ValaClass* _tmp346_;
					ValaList* _tmp347_;
					gint _base_type_size = 0;
					ValaList* _tmp348_;
					gint _tmp349_;
					gint _tmp350_;
					gint _base_type_index = 0;
					_tmp345_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp346_ = _tmp345_;
					_tmp347_ = vala_class_get_base_types (_tmp346_);
					_base_type_list = _tmp347_;
					_tmp348_ = _base_type_list;
					_tmp349_ = vala_collection_get_size ((ValaCollection*) _tmp348_);
					_tmp350_ = _tmp349_;
					_base_type_size = _tmp350_;
					_base_type_index = -1;
					while (TRUE) {
						gint _tmp351_;
						gint _tmp352_;
						gint _tmp353_;
						ValaDataType* base_type = NULL;
						ValaList* _tmp354_;
						gint _tmp355_;
						gpointer _tmp356_;
						ValaDataType* _tmp357_;
						ValaTypeSymbol* _tmp358_;
						ValaTypeSymbol* _tmp359_;
						_tmp351_ = _base_type_index;
						_base_type_index = _tmp351_ + 1;
						_tmp352_ = _base_type_index;
						_tmp353_ = _base_type_size;
						if (!(_tmp352_ < _tmp353_)) {
							break;
						}
						_tmp354_ = _base_type_list;
						_tmp355_ = _base_type_index;
						_tmp356_ = vala_list_get (_tmp354_, _tmp355_);
						base_type = (ValaDataType*) _tmp356_;
						_tmp357_ = base_type;
						_tmp358_ = vala_data_type_get_data_type (_tmp357_);
						_tmp359_ = _tmp358_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp359_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp360_;
							gchar* _tmp361_;
							gchar* _tmp362_;
							gboolean _tmp363_;
							ValaHashMap* _tmp368_;
							ValaDataType* _tmp369_;
							ValaList* _tmp370_;
							ValaList* _tmp371_;
							ValaList* _tmp372_;
							type_parameters = NULL;
							_tmp360_ = m;
							_tmp361_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp360_);
							_tmp362_ = _tmp361_;
							_tmp363_ = g_strcmp0 (_tmp362_, "g_object_new") == 0;
							_g_free0 (_tmp362_);
							if (_tmp363_) {
								ValaDataType* _tmp364_;
								ValaTypeSymbol* _tmp365_;
								ValaTypeSymbol* _tmp366_;
								ValaList* _tmp367_;
								_tmp364_ = base_type;
								_tmp365_ = vala_data_type_get_data_type (_tmp364_);
								_tmp366_ = _tmp365_;
								_tmp367_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp366_, VALA_TYPE_CLASS, ValaClass));
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp367_;
							}
							_tmp368_ = in_arg_map;
							_tmp369_ = base_type;
							_tmp370_ = vala_data_type_get_type_arguments (_tmp369_);
							_tmp371_ = _tmp370_;
							_tmp372_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp368_, _tmp371_, (ValaCodeNode*) expr, TRUE, _tmp372_);
							_vala_iterable_unref0 (_tmp371_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp373_;
				ValaSymbol* _tmp374_;
				ValaSymbol* _tmp375_;
				ValaClass* _tmp376_;
				type_param_index = 0;
				_tmp373_ = m;
				_tmp374_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp373_);
				_tmp375_ = _tmp374_;
				_tmp376_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp375_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp376_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp377_;
					ValaList* _tmp378_;
					gint _type_param_size = 0;
					ValaList* _tmp379_;
					gint _tmp380_;
					gint _tmp381_;
					gint _type_param_index = 0;
					_tmp377_ = cl;
					_tmp378_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp377_);
					_type_param_list = _tmp378_;
					_tmp379_ = _type_param_list;
					_tmp380_ = vala_collection_get_size ((ValaCollection*) _tmp379_);
					_tmp381_ = _tmp380_;
					_type_param_size = _tmp381_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp382_;
						gint _tmp383_;
						gint _tmp384_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp385_;
						gint _tmp386_;
						gpointer _tmp387_;
						ValaHashMap* _tmp388_;
						gint _tmp389_;
						ValaTypeParameter* _tmp390_;
						const gchar* _tmp391_;
						const gchar* _tmp392_;
						gchar* _tmp393_;
						gchar* _tmp394_;
						gchar* _tmp395_;
						gchar* _tmp396_;
						ValaCCodeIdentifier* _tmp397_;
						ValaCCodeIdentifier* _tmp398_;
						ValaHashMap* _tmp399_;
						gint _tmp400_;
						ValaTypeParameter* _tmp401_;
						const gchar* _tmp402_;
						const gchar* _tmp403_;
						gchar* _tmp404_;
						gchar* _tmp405_;
						gchar* _tmp406_;
						gchar* _tmp407_;
						ValaCCodeIdentifier* _tmp408_;
						ValaCCodeIdentifier* _tmp409_;
						ValaHashMap* _tmp410_;
						gint _tmp411_;
						ValaTypeParameter* _tmp412_;
						const gchar* _tmp413_;
						const gchar* _tmp414_;
						gchar* _tmp415_;
						gchar* _tmp416_;
						gchar* _tmp417_;
						gchar* _tmp418_;
						ValaCCodeIdentifier* _tmp419_;
						ValaCCodeIdentifier* _tmp420_;
						gint _tmp421_;
						_tmp382_ = _type_param_index;
						_type_param_index = _tmp382_ + 1;
						_tmp383_ = _type_param_index;
						_tmp384_ = _type_param_size;
						if (!(_tmp383_ < _tmp384_)) {
							break;
						}
						_tmp385_ = _type_param_list;
						_tmp386_ = _type_param_index;
						_tmp387_ = vala_list_get (_tmp385_, _tmp386_);
						type_param = (ValaTypeParameter*) _tmp387_;
						_tmp388_ = in_arg_map;
						_tmp389_ = type_param_index;
						_tmp390_ = type_param;
						_tmp391_ = vala_symbol_get_name ((ValaSymbol*) _tmp390_);
						_tmp392_ = _tmp391_;
						_tmp393_ = g_utf8_strdown (_tmp392_, (gssize) -1);
						_tmp394_ = _tmp393_;
						_tmp395_ = g_strdup_printf ("%s_type", _tmp394_);
						_tmp396_ = _tmp395_;
						_tmp397_ = vala_ccode_identifier_new (_tmp396_);
						_tmp398_ = _tmp397_;
						vala_map_set ((ValaMap*) _tmp388_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp389_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp398_);
						_vala_ccode_node_unref0 (_tmp398_);
						_g_free0 (_tmp396_);
						_g_free0 (_tmp394_);
						_tmp399_ = in_arg_map;
						_tmp400_ = type_param_index;
						_tmp401_ = type_param;
						_tmp402_ = vala_symbol_get_name ((ValaSymbol*) _tmp401_);
						_tmp403_ = _tmp402_;
						_tmp404_ = g_utf8_strdown (_tmp403_, (gssize) -1);
						_tmp405_ = _tmp404_;
						_tmp406_ = g_strdup_printf ("%s_dup_func", _tmp405_);
						_tmp407_ = _tmp406_;
						_tmp408_ = vala_ccode_identifier_new (_tmp407_);
						_tmp409_ = _tmp408_;
						vala_map_set ((ValaMap*) _tmp399_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp400_) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp409_);
						_vala_ccode_node_unref0 (_tmp409_);
						_g_free0 (_tmp407_);
						_g_free0 (_tmp405_);
						_tmp410_ = in_arg_map;
						_tmp411_ = type_param_index;
						_tmp412_ = type_param;
						_tmp413_ = vala_symbol_get_name ((ValaSymbol*) _tmp412_);
						_tmp414_ = _tmp413_;
						_tmp415_ = g_utf8_strdown (_tmp414_, (gssize) -1);
						_tmp416_ = _tmp415_;
						_tmp417_ = g_strdup_printf ("%s_destroy_func", _tmp416_);
						_tmp418_ = _tmp417_;
						_tmp419_ = vala_ccode_identifier_new (_tmp418_);
						_tmp420_ = _tmp419_;
						vala_map_set ((ValaMap*) _tmp410_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp411_) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp420_);
						_vala_ccode_node_unref0 (_tmp420_);
						_g_free0 (_tmp418_);
						_g_free0 (_tmp416_);
						_tmp421_ = type_param_index;
						type_param_index = _tmp421_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp422_;
			ValaClass* _tmp423_;
			ValaClass* _tmp424_;
			ValaClass* _tmp425_;
			ValaClass* _tmp426_;
			_tmp422_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp423_ = _tmp422_;
			_tmp424_ = vala_class_get_base_class (_tmp423_);
			_tmp425_ = _tmp424_;
			_tmp426_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp425_ == _tmp426_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp427_;
				ValaClass* _tmp428_;
				gchar* _tmp429_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp430_;
				ValaCCodeDeclaration* _tmp431_;
				ValaCCodeDeclaration* _tmp432_;
				const gchar* _tmp433_;
				const gchar* _tmp434_;
				const gchar* _tmp435_;
				const gchar* _tmp436_;
				gchar* _tmp437_;
				gchar* _tmp438_;
				ValaCCodeConstant* _tmp439_;
				ValaCCodeConstant* _tmp440_;
				ValaCCodeVariableDeclarator* _tmp441_;
				ValaCCodeVariableDeclarator* _tmp442_;
				ValaCCodeFunction* _tmp443_;
				ValaCCodeFunction* _tmp444_;
				ValaCCodeDeclaration* _tmp445_;
				ValaCCodeFunctionCall* _tmp446_;
				ValaCCodeIdentifier* _tmp447_;
				ValaCCodeIdentifier* _tmp448_;
				ValaCCodeUnaryExpression* _tmp449_;
				ValaCCodeUnaryExpression* _tmp450_;
				ValaCCodeCastExpression* _tmp451_;
				ValaCCodeCastExpression* _tmp452_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp453_;
				ValaCCodeIdentifier* _tmp454_;
				ValaCCodeFunctionCall* _tmp455_;
				ValaCCodeFunctionCall* _tmp456_;
				ValaCCodeFunctionCall* _tmp457_;
				ValaClass* _tmp458_;
				ValaClass* _tmp459_;
				gchar* _tmp460_;
				gchar* _tmp461_;
				ValaCCodeIdentifier* _tmp462_;
				ValaCCodeIdentifier* _tmp463_;
				ValaCCodeFunctionCall* _tmp464_;
				ValaCCodeFunctionCall* _tmp465_;
				_tmp427_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp428_ = _tmp427_;
				_tmp429_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp428_, NULL);
				class_prefix = _tmp429_;
				_tmp430_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp430_;
				_tmp431_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp431_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp432_ = funcs;
				_tmp433_ = class_prefix;
				_tmp434_ = class_prefix;
				_tmp435_ = class_prefix;
				_tmp436_ = class_prefix;
				_tmp437_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp433_, _tmp434_, _tmp435_, _tmp436_);
				_tmp438_ = _tmp437_;
				_tmp439_ = vala_ccode_constant_new (_tmp438_);
				_tmp440_ = _tmp439_;
				_tmp441_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp440_, NULL);
				_tmp442_ = _tmp441_;
				vala_ccode_declaration_add_declarator (_tmp432_, (ValaCCodeDeclarator*) _tmp442_);
				_vala_ccode_node_unref0 (_tmp442_);
				_vala_ccode_node_unref0 (_tmp440_);
				_g_free0 (_tmp438_);
				_tmp443_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp444_ = _tmp443_;
				_tmp445_ = funcs;
				vala_ccode_function_add_statement (_tmp444_, (ValaCCodeNode*) _tmp445_);
				_tmp446_ = ccall;
				_tmp447_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp448_ = _tmp447_;
				_tmp449_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp448_);
				_tmp450_ = _tmp449_;
				_tmp451_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp450_, "GSourceFuncs *");
				_tmp452_ = _tmp451_;
				vala_ccode_function_call_add_argument (_tmp446_, (ValaCCodeExpression*) _tmp452_);
				_vala_ccode_node_unref0 (_tmp452_);
				_vala_ccode_node_unref0 (_tmp450_);
				_vala_ccode_node_unref0 (_tmp448_);
				_tmp453_ = vala_ccode_identifier_new ("sizeof");
				_tmp454_ = _tmp453_;
				_tmp455_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp454_);
				_tmp456_ = _tmp455_;
				_vala_ccode_node_unref0 (_tmp454_);
				csizeof = _tmp456_;
				_tmp457_ = csizeof;
				_tmp458_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp459_ = _tmp458_;
				_tmp460_ = vala_get_ccode_name ((ValaCodeNode*) _tmp459_);
				_tmp461_ = _tmp460_;
				_tmp462_ = vala_ccode_identifier_new (_tmp461_);
				_tmp463_ = _tmp462_;
				vala_ccode_function_call_add_argument (_tmp457_, (ValaCCodeExpression*) _tmp463_);
				_vala_ccode_node_unref0 (_tmp463_);
				_g_free0 (_tmp461_);
				_tmp464_ = ccall;
				_tmp465_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp464_, (ValaCCodeExpression*) _tmp465_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp466_ = FALSE;
		ValaMethod* _tmp467_;
		_tmp467_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp467_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp468_;
			ValaSymbol* _tmp469_;
			ValaSymbol* _tmp470_;
			_tmp468_ = m;
			_tmp469_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp468_);
			_tmp470_ = _tmp469_;
			_tmp466_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp470_, VALA_TYPE_STRUCT);
		} else {
			_tmp466_ = FALSE;
		}
		if (_tmp466_) {
			ValaCCodeFunctionCall* _tmp471_;
			ValaCCodeExpression* _tmp472_;
			ValaCCodeExpression* _tmp473_;
			_tmp471_ = ccall;
			_tmp472_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp473_ = _tmp472_;
			vala_ccode_function_call_add_argument (_tmp471_, _tmp473_);
			_vala_ccode_node_unref0 (_tmp473_);
		} else {
			gboolean _tmp474_ = FALSE;
			gboolean _tmp475_ = FALSE;
			gboolean _tmp476_ = FALSE;
			gboolean _tmp477_ = FALSE;
			ValaMethod* _tmp478_;
			_tmp478_ = m;
			if (_tmp478_ != NULL) {
				ValaMethod* _tmp479_;
				ValaList* _tmp480_;
				ValaList* _tmp481_;
				gint _tmp482_;
				gint _tmp483_;
				_tmp479_ = m;
				_tmp480_ = vala_method_get_type_parameters (_tmp479_);
				_tmp481_ = _tmp480_;
				_tmp482_ = vala_collection_get_size ((ValaCollection*) _tmp481_);
				_tmp483_ = _tmp482_;
				_tmp477_ = _tmp483_ > 0;
				_vala_iterable_unref0 (_tmp481_);
			} else {
				_tmp477_ = FALSE;
			}
			if (_tmp477_) {
				ValaMethod* _tmp484_;
				_tmp484_ = m;
				_tmp476_ = !vala_get_ccode_has_generic_type_parameter (_tmp484_);
			} else {
				_tmp476_ = FALSE;
			}
			if (_tmp476_) {
				ValaMethod* _tmp485_;
				_tmp485_ = m;
				_tmp475_ = !vala_get_ccode_simple_generics (_tmp485_);
			} else {
				_tmp475_ = FALSE;
			}
			if (_tmp475_) {
				gboolean _tmp486_ = FALSE;
				ValaCCodeFunctionCall* _tmp487_;
				ValaCCodeFunctionCall* _tmp488_;
				_tmp487_ = ccall;
				_tmp488_ = finish_call;
				if (_tmp487_ != _tmp488_) {
					_tmp486_ = TRUE;
				} else {
					gboolean _tmp489_;
					gboolean _tmp490_;
					_tmp489_ = vala_method_call_get_is_yield_expression (expr);
					_tmp490_ = _tmp489_;
					_tmp486_ = _tmp490_;
				}
				_tmp474_ = _tmp486_;
			} else {
				_tmp474_ = FALSE;
			}
			if (_tmp474_) {
				ValaHashMap* _tmp491_;
				ValaMemberAccess* _tmp492_;
				ValaList* _tmp493_;
				ValaList* _tmp494_;
				_tmp491_ = in_arg_map;
				_tmp492_ = ma;
				_tmp493_ = vala_member_access_get_type_arguments (_tmp492_);
				_tmp494_ = _tmp493_;
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp491_, _tmp494_, (ValaCodeNode*) expr, FALSE, NULL);
				_vala_iterable_unref0 (_tmp494_);
			}
		}
	}
	_tmp495_ = ccall;
	_tmp496_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp495_);
	ccall_expr = _tmp496_;
	_tmp497_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp497_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp498_;
		ValaExpression* _tmp499_;
		ValaExpression* _tmp500_;
		ValaDataType* _tmp501_;
		ValaDataType* _tmp502_;
		ValaArrayType* _tmp503_;
		ValaHashMap* _tmp504_;
		ValaArrayType* _tmp505_;
		ValaDataType* _tmp506_;
		ValaDataType* _tmp507_;
		gchar* _tmp508_;
		gchar* _tmp509_;
		ValaCCodeIdentifier* _tmp510_;
		ValaCCodeIdentifier* _tmp511_;
		_tmp498_ = ma;
		_tmp499_ = vala_member_access_get_inner (_tmp498_);
		_tmp500_ = _tmp499_;
		_tmp501_ = vala_expression_get_value_type (_tmp500_);
		_tmp502_ = _tmp501_;
		_tmp503_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp502_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp503_;
		_tmp504_ = in_arg_map;
		_tmp505_ = array_type;
		_tmp506_ = vala_array_type_get_element_type (_tmp505_);
		_tmp507_ = _tmp506_;
		_tmp508_ = vala_get_ccode_name ((ValaCodeNode*) _tmp507_);
		_tmp509_ = _tmp508_;
		_tmp510_ = vala_ccode_identifier_new (_tmp509_);
		_tmp511_ = _tmp510_;
		vala_map_set ((ValaMap*) _tmp504_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp511_);
		_vala_ccode_node_unref0 (_tmp511_);
		_g_free0 (_tmp509_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp512_;
		_tmp512_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp512_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp513_;
			_tmp513_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp513_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp514_;
				ValaExpression* _tmp515_;
				ValaExpression* _tmp516_;
				ValaTargetValue* _tmp517_;
				ValaTargetValue* _tmp518_;
				ValaTargetValue* _tmp519_;
				ValaTargetValue* _tmp520_;
				_tmp514_ = ma;
				_tmp515_ = vala_member_access_get_inner (_tmp514_);
				_tmp516_ = _tmp515_;
				_tmp517_ = vala_expression_get_target_value (_tmp516_);
				_tmp518_ = _tmp517_;
				_tmp519_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp518_, (ValaCodeNode*) expr);
				_tmp520_ = _tmp519_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp520_);
				_vala_target_value_unref0 (_tmp520_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp522_ = m;
	if (_tmp522_ != NULL) {
		ValaMethod* _tmp523_;
		gboolean _tmp524_;
		gboolean _tmp525_;
		_tmp523_ = m;
		_tmp524_ = vala_method_get_is_async_callback (_tmp523_);
		_tmp525_ = _tmp524_;
		_tmp521_ = _tmp525_;
	} else {
		_tmp521_ = FALSE;
	}
	if (_tmp521_) {
		ValaMethod* _tmp526_;
		ValaMethod* _tmp527_;
		gboolean _tmp528_;
		gboolean _tmp529_;
		ValaHashMap* _tmp543_;
		ValaMethod* _tmp544_;
		ValaCCodeExpression* _tmp545_;
		ValaHashMap* _tmp546_;
		ValaMethod* _tmp547_;
		ValaCCodeExpression* _tmp548_;
		_tmp526_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp527_ = _tmp526_;
		_tmp528_ = vala_method_get_closure (_tmp527_);
		_tmp529_ = _tmp528_;
		if (_tmp529_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp530_;
			ValaSymbol* _tmp531_;
			ValaSymbol* _tmp532_;
			ValaBlock* _tmp533_;
			ValaBlock* _tmp534_;
			ValaBlock* _tmp535_;
			ValaBlock* _tmp536_;
			gchar* _tmp537_;
			gchar* _tmp538_;
			ValaCCodeExpression* _tmp539_;
			ValaCCodeExpression* _tmp540_;
			ValaCCodeMemberAccess* _tmp541_;
			_tmp530_ = m;
			_tmp531_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp530_);
			_tmp532_ = _tmp531_;
			_tmp533_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp532_, VALA_TYPE_METHOD, ValaMethod));
			_tmp534_ = _tmp533_;
			_tmp535_ = _vala_code_node_ref0 (_tmp534_);
			block = _tmp535_;
			_tmp536_ = block;
			_tmp537_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp536_));
			_tmp538_ = _tmp537_;
			_tmp539_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp538_);
			_tmp540_ = _tmp539_;
			_tmp541_ = vala_ccode_member_access_new_pointer (_tmp540_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp541_;
			_vala_ccode_node_unref0 (_tmp540_);
			_g_free0 (_tmp538_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp542_;
			_tmp542_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp542_;
		}
		_tmp543_ = in_arg_map;
		_tmp544_ = m;
		_tmp545_ = instance;
		vala_map_set ((ValaMap*) _tmp543_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp544_), FALSE)), _tmp545_);
		_tmp546_ = out_arg_map;
		_tmp547_ = m;
		_tmp548_ = instance;
		vala_map_set ((ValaMap*) _tmp546_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp547_), FALSE)), _tmp548_);
	} else {
		gboolean _tmp549_ = FALSE;
		gboolean _tmp550_ = FALSE;
		ValaMethod* _tmp551_;
		_tmp551_ = m;
		if (_tmp551_ != NULL) {
			ValaMethod* _tmp552_;
			ValaMemberBinding _tmp553_;
			ValaMemberBinding _tmp554_;
			_tmp552_ = m;
			_tmp553_ = vala_method_get_binding (_tmp552_);
			_tmp554_ = _tmp553_;
			_tmp550_ = _tmp554_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp550_ = FALSE;
		}
		if (_tmp550_) {
			ValaMethod* _tmp555_;
			_tmp555_ = m;
			_tmp549_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp555_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp549_ = FALSE;
		}
		if (_tmp549_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp556_;
			ValaExpression* _tmp557_;
			ValaExpression* _tmp558_;
			ValaTargetValue* _tmp559_;
			ValaTargetValue* _tmp560_;
			ValaTargetValue* _tmp561_;
			gboolean _tmp562_ = FALSE;
			gboolean _tmp563_ = FALSE;
			ValaMemberAccess* _tmp564_;
			const gchar* _tmp565_;
			const gchar* _tmp566_;
			ValaTargetValue* _tmp588_;
			ValaCCodeExpression* _tmp589_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp590_;
			ValaSymbol* _tmp591_;
			ValaSymbol* _tmp592_;
			ValaStruct* _tmp593_;
			gboolean _tmp594_ = FALSE;
			ValaStruct* _tmp595_;
			gboolean _tmp604_;
			gboolean _tmp605_;
			_tmp556_ = ma;
			_tmp557_ = vala_member_access_get_inner (_tmp556_);
			_tmp558_ = _tmp557_;
			_tmp559_ = vala_expression_get_target_value (_tmp558_);
			_tmp560_ = _tmp559_;
			_tmp561_ = _vala_target_value_ref0 (_tmp560_);
			instance_value = _tmp561_;
			_tmp564_ = ma;
			_tmp565_ = vala_member_access_get_member_name (_tmp564_);
			_tmp566_ = _tmp565_;
			if (g_strcmp0 (_tmp566_, "begin") == 0) {
				_tmp563_ = TRUE;
			} else {
				ValaMemberAccess* _tmp567_;
				const gchar* _tmp568_;
				const gchar* _tmp569_;
				_tmp567_ = ma;
				_tmp568_ = vala_member_access_get_member_name (_tmp567_);
				_tmp569_ = _tmp568_;
				_tmp563_ = g_strcmp0 (_tmp569_, "end") == 0;
			}
			if (_tmp563_) {
				ValaMemberAccess* _tmp570_;
				ValaExpression* _tmp571_;
				ValaExpression* _tmp572_;
				ValaSymbol* _tmp573_;
				ValaSymbol* _tmp574_;
				ValaMemberAccess* _tmp575_;
				ValaSymbol* _tmp576_;
				ValaSymbol* _tmp577_;
				_tmp570_ = ma;
				_tmp571_ = vala_member_access_get_inner (_tmp570_);
				_tmp572_ = _tmp571_;
				_tmp573_ = vala_expression_get_symbol_reference (_tmp572_);
				_tmp574_ = _tmp573_;
				_tmp575_ = ma;
				_tmp576_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp575_);
				_tmp577_ = _tmp576_;
				_tmp562_ = _tmp574_ == _tmp577_;
			} else {
				_tmp562_ = FALSE;
			}
			if (_tmp562_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp578_;
				ValaExpression* _tmp579_;
				ValaExpression* _tmp580_;
				ValaMemberAccess* _tmp581_;
				ValaMemberAccess* _tmp582_;
				ValaExpression* _tmp583_;
				ValaExpression* _tmp584_;
				ValaTargetValue* _tmp585_;
				ValaTargetValue* _tmp586_;
				ValaTargetValue* _tmp587_;
				_tmp578_ = ma;
				_tmp579_ = vala_member_access_get_inner (_tmp578_);
				_tmp580_ = _tmp579_;
				_tmp581_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp580_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp581_;
				_tmp582_ = inner_ma;
				_tmp583_ = vala_member_access_get_inner (_tmp582_);
				_tmp584_ = _tmp583_;
				_tmp585_ = vala_expression_get_target_value (_tmp584_);
				_tmp586_ = _tmp585_;
				_tmp587_ = _vala_target_value_ref0 (_tmp586_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp587_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp588_ = instance_value;
			_tmp589_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp588_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp589_;
			_tmp590_ = m;
			_tmp591_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp590_);
			_tmp592_ = _tmp591_;
			_tmp593_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp592_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp592_) : NULL);
			st = _tmp593_;
			_tmp595_ = st;
			if (_tmp595_ != NULL) {
				ValaStruct* _tmp596_;
				_tmp596_ = st;
				_tmp594_ = !vala_struct_is_simple_type (_tmp596_);
			} else {
				_tmp594_ = FALSE;
			}
			if (_tmp594_) {
				ValaTargetValue* _tmp597_;
				ValaTargetValue* _tmp600_;
				ValaCCodeExpression* _tmp601_;
				ValaCCodeExpression* _tmp602_;
				ValaCCodeUnaryExpression* _tmp603_;
				_tmp597_ = instance_value;
				if (!vala_ccode_base_module_get_lvalue ((ValaCCodeBaseModule*) self, _tmp597_)) {
					ValaTargetValue* _tmp598_;
					ValaTargetValue* _tmp599_;
					_tmp598_ = instance_value;
					_tmp599_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp598_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp599_;
				}
				_tmp600_ = instance_value;
				_tmp601_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp600_);
				_tmp602_ = _tmp601_;
				_tmp603_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp602_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp603_;
				_vala_ccode_node_unref0 (_tmp602_);
			}
			_tmp604_ = vala_method_call_get_is_yield_expression (expr);
			_tmp605_ = _tmp604_;
			if (_tmp605_) {
				ValaHashMap* _tmp606_;
				ValaMethod* _tmp607_;
				ValaCCodeExpression* _tmp608_;
				ValaMethod* _tmp609_;
				_tmp606_ = in_arg_map;
				_tmp607_ = m;
				_tmp608_ = instance;
				vala_map_set ((ValaMap*) _tmp606_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp607_), FALSE)), _tmp608_);
				_tmp609_ = m;
				if (vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp609_)) {
					ValaHashMap* _tmp610_;
					ValaMethod* _tmp611_;
					ValaCCodeExpression* _tmp612_;
					_tmp610_ = out_arg_map;
					_tmp611_ = m;
					_tmp612_ = instance;
					vala_map_set ((ValaMap*) _tmp610_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp611_), FALSE)), _tmp612_);
				}
			} else {
				gboolean _tmp613_ = FALSE;
				ValaMemberAccess* _tmp614_;
				const gchar* _tmp615_;
				const gchar* _tmp616_;
				_tmp614_ = ma;
				_tmp615_ = vala_member_access_get_member_name (_tmp614_);
				_tmp616_ = _tmp615_;
				if (g_strcmp0 (_tmp616_, "end") != 0) {
					_tmp613_ = TRUE;
				} else {
					ValaMethod* _tmp617_;
					_tmp617_ = m;
					_tmp613_ = vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp617_);
				}
				if (_tmp613_) {
					ValaHashMap* _tmp618_;
					ValaMethod* _tmp619_;
					ValaCCodeExpression* _tmp620_;
					ValaHashMap* _tmp621_;
					ValaMethod* _tmp622_;
					ValaCCodeExpression* _tmp623_;
					_tmp618_ = out_arg_map;
					_tmp619_ = m;
					_tmp620_ = instance;
					vala_map_set ((ValaMap*) _tmp618_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp619_), FALSE)), _tmp620_);
					_tmp621_ = in_arg_map;
					_tmp622_ = m;
					_tmp623_ = instance;
					vala_map_set ((ValaMap*) _tmp621_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp622_), FALSE)), _tmp623_);
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp624_ = FALSE;
			ValaMethod* _tmp625_;
			_tmp625_ = m;
			if (_tmp625_ != NULL) {
				ValaMethod* _tmp626_;
				ValaMemberBinding _tmp627_;
				ValaMemberBinding _tmp628_;
				_tmp626_ = m;
				_tmp627_ = vala_method_get_binding (_tmp626_);
				_tmp628_ = _tmp627_;
				_tmp624_ = _tmp628_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp624_ = FALSE;
			}
			if (_tmp624_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp629_;
				ValaSymbol* _tmp630_;
				ValaSymbol* _tmp631_;
				ValaClass* _tmp632_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp633_;
				gchar* _tmp634_;
				gchar* _tmp635_;
				gchar* _tmp636_;
				gchar* _tmp637_;
				ValaCCodeIdentifier* _tmp638_;
				ValaCCodeIdentifier* _tmp639_;
				ValaCCodeFunctionCall* _tmp640_;
				ValaCCodeFunctionCall* _tmp641_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp642_;
				ValaExpression* _tmp643_;
				ValaExpression* _tmp644_;
				ValaCCodeFunctionCall* _tmp670_;
				ValaCCodeExpression* _tmp671_;
				ValaHashMap* _tmp672_;
				ValaMethod* _tmp673_;
				ValaCCodeFunctionCall* _tmp674_;
				ValaHashMap* _tmp675_;
				ValaMethod* _tmp676_;
				ValaCCodeFunctionCall* _tmp677_;
				_tmp629_ = m;
				_tmp630_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp629_);
				_tmp631_ = _tmp630_;
				_tmp632_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp631_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp632_;
				_tmp633_ = cl;
				_tmp634_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp633_, NULL);
				_tmp635_ = _tmp634_;
				_tmp636_ = g_strconcat (_tmp635_, "_CLASS", NULL);
				_tmp637_ = _tmp636_;
				_tmp638_ = vala_ccode_identifier_new (_tmp637_);
				_tmp639_ = _tmp638_;
				_tmp640_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp639_);
				_tmp641_ = _tmp640_;
				_vala_ccode_node_unref0 (_tmp639_);
				_g_free0 (_tmp637_);
				_g_free0 (_tmp635_);
				cast = _tmp641_;
				_tmp642_ = ma;
				_tmp643_ = vala_member_access_get_inner (_tmp642_);
				_tmp644_ = _tmp643_;
				if (_tmp644_ == NULL) {
					ValaDataType* _tmp645_;
					ValaDataType* _tmp646_;
					gboolean _tmp647_;
					_tmp645_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					_tmp646_ = _tmp645_;
					_tmp647_ = _tmp646_ == NULL;
					_vala_code_node_unref0 (_tmp646_);
					if (_tmp647_) {
						ValaCCodeIdentifier* _tmp648_;
						_tmp648_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp648_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp649_;
						ValaCCodeIdentifier* _tmp650_;
						ValaCCodeFunctionCall* _tmp651_;
						ValaCCodeFunctionCall* _tmp652_;
						ValaCCodeFunctionCall* _tmp653_;
						ValaCCodeExpression* _tmp654_;
						ValaCCodeExpression* _tmp655_;
						ValaCCodeFunctionCall* _tmp656_;
						ValaCCodeExpression* _tmp657_;
						_tmp649_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp650_ = _tmp649_;
						_tmp651_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp650_);
						_tmp652_ = _tmp651_;
						_vala_ccode_node_unref0 (_tmp650_);
						k = _tmp652_;
						_tmp653_ = k;
						_tmp654_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp655_ = _tmp654_;
						vala_ccode_function_call_add_argument (_tmp653_, _tmp655_);
						_vala_ccode_node_unref0 (_tmp655_);
						_tmp656_ = k;
						_tmp657_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp656_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp657_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp658_;
					ValaCCodeIdentifier* _tmp659_;
					ValaCCodeFunctionCall* _tmp660_;
					ValaCCodeFunctionCall* _tmp661_;
					ValaCCodeFunctionCall* _tmp662_;
					ValaMemberAccess* _tmp663_;
					ValaExpression* _tmp664_;
					ValaExpression* _tmp665_;
					ValaCCodeExpression* _tmp666_;
					ValaCCodeExpression* _tmp667_;
					ValaCCodeFunctionCall* _tmp668_;
					ValaCCodeExpression* _tmp669_;
					_tmp658_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp659_ = _tmp658_;
					_tmp660_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp659_);
					_tmp661_ = _tmp660_;
					_vala_ccode_node_unref0 (_tmp659_);
					k = _tmp661_;
					_tmp662_ = k;
					_tmp663_ = ma;
					_tmp664_ = vala_member_access_get_inner (_tmp663_);
					_tmp665_ = _tmp664_;
					_tmp666_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp665_);
					_tmp667_ = _tmp666_;
					vala_ccode_function_call_add_argument (_tmp662_, _tmp667_);
					_vala_ccode_node_unref0 (_tmp667_);
					_tmp668_ = k;
					_tmp669_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp668_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp669_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp670_ = cast;
				_tmp671_ = klass;
				vala_ccode_function_call_add_argument (_tmp670_, _tmp671_);
				_tmp672_ = in_arg_map;
				_tmp673_ = m;
				_tmp674_ = cast;
				vala_map_set ((ValaMap*) _tmp672_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp673_), FALSE)), (ValaCCodeExpression*) _tmp674_);
				_tmp675_ = out_arg_map;
				_tmp676_ = m;
				_tmp677_ = cast;
				vala_map_set ((ValaMap*) _tmp675_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp676_), FALSE)), (ValaCCodeExpression*) _tmp677_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp679_ = m;
	if (_tmp679_ != NULL) {
		ValaMethod* _tmp680_;
		_tmp680_ = m;
		_tmp678_ = vala_get_ccode_has_generic_type_parameter (_tmp680_);
	} else {
		_tmp678_ = FALSE;
	}
	if (_tmp678_) {
		ValaMethod* _tmp681_;
		ValaList* _tmp682_;
		ValaList* _tmp683_;
		gint _tmp684_;
		gint _tmp685_;
		gboolean _tmp686_;
		_tmp681_ = m;
		_tmp682_ = vala_method_get_type_parameters (_tmp681_);
		_tmp683_ = _tmp682_;
		_tmp684_ = vala_collection_get_size ((ValaCollection*) _tmp683_);
		_tmp685_ = _tmp684_;
		_tmp686_ = _tmp685_ > 0;
		_vala_iterable_unref0 (_tmp683_);
		if (_tmp686_) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp687_;
				ValaList* _tmp688_;
				gint _type_arg_size = 0;
				ValaList* _tmp689_;
				gint _tmp690_;
				gint _tmp691_;
				gint _type_arg_index = 0;
				_tmp687_ = ma;
				_tmp688_ = vala_member_access_get_type_arguments (_tmp687_);
				_type_arg_list = _tmp688_;
				_tmp689_ = _type_arg_list;
				_tmp690_ = vala_collection_get_size ((ValaCollection*) _tmp689_);
				_tmp691_ = _tmp690_;
				_type_arg_size = _tmp691_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp692_;
					gint _tmp693_;
					gint _tmp694_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp695_;
					gint _tmp696_;
					gpointer _tmp697_;
					ValaHashMap* _tmp698_;
					ValaMethod* _tmp699_;
					gint _tmp700_;
					ValaDataType* _tmp701_;
					gchar* _tmp702_;
					gchar* _tmp703_;
					ValaCCodeIdentifier* _tmp704_;
					ValaCCodeIdentifier* _tmp705_;
					gint _tmp706_;
					_tmp692_ = _type_arg_index;
					_type_arg_index = _tmp692_ + 1;
					_tmp693_ = _type_arg_index;
					_tmp694_ = _type_arg_size;
					if (!(_tmp693_ < _tmp694_)) {
						break;
					}
					_tmp695_ = _type_arg_list;
					_tmp696_ = _type_arg_index;
					_tmp697_ = vala_list_get (_tmp695_, _tmp696_);
					type_arg = (ValaDataType*) _tmp697_;
					_tmp698_ = in_arg_map;
					_tmp699_ = m;
					_tmp700_ = type_param_index;
					_tmp701_ = type_arg;
					_tmp702_ = vala_get_ccode_name ((ValaCodeNode*) _tmp701_);
					_tmp703_ = _tmp702_;
					_tmp704_ = vala_ccode_identifier_new (_tmp703_);
					_tmp705_ = _tmp704_;
					vala_map_set ((ValaMap*) _tmp698_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp699_) + (0.01 * _tmp700_), FALSE)), (ValaCCodeExpression*) _tmp705_);
					_vala_ccode_node_unref0 (_tmp705_);
					_g_free0 (_tmp703_);
					_tmp706_ = type_param_index;
					type_param_index = _tmp706_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp707_;
				ValaExpression* _tmp708_;
				ValaExpression* _tmp709_;
				ValaDataType* _tmp710_;
				ValaDataType* _tmp711_;
				ValaList* _tmp712_;
				gint _type_arg_size = 0;
				ValaList* _tmp713_;
				gint _tmp714_;
				gint _tmp715_;
				gint _type_arg_index = 0;
				_tmp707_ = ma;
				_tmp708_ = vala_member_access_get_inner (_tmp707_);
				_tmp709_ = _tmp708_;
				_tmp710_ = vala_expression_get_value_type (_tmp709_);
				_tmp711_ = _tmp710_;
				_tmp712_ = vala_data_type_get_type_arguments (_tmp711_);
				_type_arg_list = _tmp712_;
				_tmp713_ = _type_arg_list;
				_tmp714_ = vala_collection_get_size ((ValaCollection*) _tmp713_);
				_tmp715_ = _tmp714_;
				_type_arg_size = _tmp715_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp716_;
					gint _tmp717_;
					gint _tmp718_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp719_;
					gint _tmp720_;
					gpointer _tmp721_;
					ValaHashMap* _tmp722_;
					ValaMethod* _tmp723_;
					gint _tmp724_;
					ValaDataType* _tmp725_;
					gchar* _tmp726_;
					gchar* _tmp727_;
					ValaCCodeIdentifier* _tmp728_;
					ValaCCodeIdentifier* _tmp729_;
					gint _tmp730_;
					_tmp716_ = _type_arg_index;
					_type_arg_index = _tmp716_ + 1;
					_tmp717_ = _type_arg_index;
					_tmp718_ = _type_arg_size;
					if (!(_tmp717_ < _tmp718_)) {
						break;
					}
					_tmp719_ = _type_arg_list;
					_tmp720_ = _type_arg_index;
					_tmp721_ = vala_list_get (_tmp719_, _tmp720_);
					type_arg = (ValaDataType*) _tmp721_;
					_tmp722_ = in_arg_map;
					_tmp723_ = m;
					_tmp724_ = type_param_index;
					_tmp725_ = type_arg;
					_tmp726_ = vala_get_ccode_name ((ValaCodeNode*) _tmp725_);
					_tmp727_ = _tmp726_;
					_tmp728_ = vala_ccode_identifier_new (_tmp727_);
					_tmp729_ = _tmp728_;
					vala_map_set ((ValaMap*) _tmp722_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp723_) + (0.01 * _tmp724_), FALSE)), (ValaCCodeExpression*) _tmp729_);
					_vala_ccode_node_unref0 (_tmp729_);
					_g_free0 (_tmp727_);
					_tmp730_ = type_param_index;
					type_param_index = _tmp730_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp731_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp731_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp732_;
		ValaExpression* _tmp733_;
		ValaExpression* _tmp734_;
		ValaDataType* _tmp735_;
		ValaDataType* _tmp736_;
		ValaArrayType* _tmp737_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp738_;
		ValaCCodeIdentifier* _tmp739_;
		ValaCCodeFunctionCall* _tmp740_;
		ValaCCodeFunctionCall* _tmp741_;
		ValaCCodeFunctionCall* _tmp742_;
		ValaArrayType* _tmp743_;
		ValaDataType* _tmp744_;
		ValaDataType* _tmp745_;
		gchar* _tmp746_;
		gchar* _tmp747_;
		ValaCCodeIdentifier* _tmp748_;
		ValaCCodeIdentifier* _tmp749_;
		ValaHashMap* _tmp750_;
		ValaCCodeFunctionCall* _tmp751_;
		_tmp732_ = ma;
		_tmp733_ = vala_member_access_get_inner (_tmp732_);
		_tmp734_ = _tmp733_;
		_tmp735_ = vala_expression_get_value_type (_tmp734_);
		_tmp736_ = _tmp735_;
		_tmp737_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp736_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp737_;
		_tmp738_ = vala_ccode_identifier_new ("sizeof");
		_tmp739_ = _tmp738_;
		_tmp740_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp739_);
		_tmp741_ = _tmp740_;
		_vala_ccode_node_unref0 (_tmp739_);
		csizeof = _tmp741_;
		_tmp742_ = csizeof;
		_tmp743_ = array_type;
		_tmp744_ = vala_array_type_get_element_type (_tmp743_);
		_tmp745_ = _tmp744_;
		_tmp746_ = vala_get_ccode_name ((ValaCodeNode*) _tmp745_);
		_tmp747_ = _tmp746_;
		_tmp748_ = vala_ccode_identifier_new (_tmp747_);
		_tmp749_ = _tmp748_;
		vala_ccode_function_call_add_argument (_tmp742_, (ValaCCodeExpression*) _tmp749_);
		_vala_ccode_node_unref0 (_tmp749_);
		_g_free0 (_tmp747_);
		_tmp750_ = in_arg_map;
		_tmp751_ = csizeof;
		vala_map_set ((ValaMap*) _tmp750_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp751_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp752_;
		_tmp752_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp752_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaMethod* _tmp753_;
			gint param_nr = 0;
			ValaMethod* _tmp824_;
			_tmp753_ = m;
			vala_method_clear_parameters (_tmp753_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp754_;
				gint _arg_size = 0;
				ValaList* _tmp755_;
				gint _tmp756_;
				gint _tmp757_;
				gint _arg_index = 0;
				_tmp754_ = vala_method_call_get_argument_list (expr);
				_arg_list = _tmp754_;
				_tmp755_ = _arg_list;
				_tmp756_ = vala_collection_get_size ((ValaCollection*) _tmp755_);
				_tmp757_ = _tmp756_;
				_arg_size = _tmp757_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp758_;
					gint _tmp759_;
					gint _tmp760_;
					ValaExpression* arg = NULL;
					ValaList* _tmp761_;
					gint _tmp762_;
					gpointer _tmp763_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp764_;
					ValaUnaryExpression* _tmp765_;
					gboolean _tmp766_ = FALSE;
					ValaUnaryExpression* _tmp767_;
					gint _tmp811_;
					_tmp758_ = _arg_index;
					_arg_index = _tmp758_ + 1;
					_tmp759_ = _arg_index;
					_tmp760_ = _arg_size;
					if (!(_tmp759_ < _tmp760_)) {
						break;
					}
					_tmp761_ = _arg_list;
					_tmp762_ = _arg_index;
					_tmp763_ = vala_list_get (_tmp761_, _tmp762_);
					arg = (ValaExpression*) _tmp763_;
					_tmp764_ = arg;
					_tmp765_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp764_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp764_) : NULL);
					unary = _tmp765_;
					_tmp767_ = unary;
					if (_tmp767_ != NULL) {
						ValaUnaryExpression* _tmp768_;
						ValaUnaryOperator _tmp769_;
						ValaUnaryOperator _tmp770_;
						_tmp768_ = unary;
						_tmp769_ = vala_unary_expression_get_operator (_tmp768_);
						_tmp770_ = _tmp769_;
						_tmp766_ = _tmp770_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp766_ = FALSE;
					}
					if (_tmp766_) {
						ValaParameter* param = NULL;
						gint _tmp771_;
						gchar* _tmp772_;
						gchar* _tmp773_;
						ValaUnaryExpression* _tmp774_;
						ValaExpression* _tmp775_;
						ValaExpression* _tmp776_;
						ValaDataType* _tmp777_;
						ValaDataType* _tmp778_;
						ValaParameter* _tmp779_;
						ValaParameter* _tmp780_;
						ValaParameter* _tmp781_;
						ValaMethod* _tmp782_;
						ValaParameter* _tmp783_;
						_tmp771_ = param_nr;
						_tmp772_ = g_strdup_printf ("param%d", _tmp771_);
						_tmp773_ = _tmp772_;
						_tmp774_ = unary;
						_tmp775_ = vala_unary_expression_get_inner (_tmp774_);
						_tmp776_ = _tmp775_;
						_tmp777_ = vala_expression_get_value_type (_tmp776_);
						_tmp778_ = _tmp777_;
						_tmp779_ = vala_parameter_new (_tmp773_, _tmp778_, NULL);
						_tmp780_ = _tmp779_;
						_g_free0 (_tmp773_);
						param = _tmp780_;
						_tmp781_ = param;
						vala_parameter_set_direction (_tmp781_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp782_ = m;
						_tmp783_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp782_, _tmp783_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp784_ = FALSE;
						ValaUnaryExpression* _tmp785_;
						_tmp785_ = unary;
						if (_tmp785_ != NULL) {
							ValaUnaryExpression* _tmp786_;
							ValaUnaryOperator _tmp787_;
							ValaUnaryOperator _tmp788_;
							_tmp786_ = unary;
							_tmp787_ = vala_unary_expression_get_operator (_tmp786_);
							_tmp788_ = _tmp787_;
							_tmp784_ = _tmp788_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp784_ = FALSE;
						}
						if (_tmp784_) {
							ValaParameter* param = NULL;
							gint _tmp789_;
							gchar* _tmp790_;
							gchar* _tmp791_;
							ValaUnaryExpression* _tmp792_;
							ValaExpression* _tmp793_;
							ValaExpression* _tmp794_;
							ValaDataType* _tmp795_;
							ValaDataType* _tmp796_;
							ValaParameter* _tmp797_;
							ValaParameter* _tmp798_;
							ValaParameter* _tmp799_;
							ValaMethod* _tmp800_;
							ValaParameter* _tmp801_;
							_tmp789_ = param_nr;
							_tmp790_ = g_strdup_printf ("param%d", _tmp789_);
							_tmp791_ = _tmp790_;
							_tmp792_ = unary;
							_tmp793_ = vala_unary_expression_get_inner (_tmp792_);
							_tmp794_ = _tmp793_;
							_tmp795_ = vala_expression_get_value_type (_tmp794_);
							_tmp796_ = _tmp795_;
							_tmp797_ = vala_parameter_new (_tmp791_, _tmp796_, NULL);
							_tmp798_ = _tmp797_;
							_g_free0 (_tmp791_);
							param = _tmp798_;
							_tmp799_ = param;
							vala_parameter_set_direction (_tmp799_, VALA_PARAMETER_DIRECTION_REF);
							_tmp800_ = m;
							_tmp801_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp800_, _tmp801_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp802_;
							gint _tmp803_;
							gchar* _tmp804_;
							gchar* _tmp805_;
							ValaExpression* _tmp806_;
							ValaDataType* _tmp807_;
							ValaDataType* _tmp808_;
							ValaParameter* _tmp809_;
							ValaParameter* _tmp810_;
							_tmp802_ = m;
							_tmp803_ = param_nr;
							_tmp804_ = g_strdup_printf ("param%d", _tmp803_);
							_tmp805_ = _tmp804_;
							_tmp806_ = arg;
							_tmp807_ = vala_expression_get_value_type (_tmp806_);
							_tmp808_ = _tmp807_;
							_tmp809_ = vala_parameter_new (_tmp805_, _tmp808_, NULL);
							_tmp810_ = _tmp809_;
							vala_callable_add_parameter ((ValaCallable*) _tmp802_, _tmp810_);
							_vala_code_node_unref0 (_tmp810_);
							_g_free0 (_tmp805_);
						}
					}
					_tmp811_ = param_nr;
					param_nr = _tmp811_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp812_;
				ValaList* _tmp813_;
				gint _param_size = 0;
				ValaList* _tmp814_;
				gint _tmp815_;
				gint _tmp816_;
				gint _param_index = 0;
				_tmp812_ = m;
				_tmp813_ = vala_callable_get_parameters ((ValaCallable*) _tmp812_);
				_param_list = _tmp813_;
				_tmp814_ = _param_list;
				_tmp815_ = vala_collection_get_size ((ValaCollection*) _tmp814_);
				_tmp816_ = _tmp815_;
				_param_size = _tmp816_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp817_;
					gint _tmp818_;
					gint _tmp819_;
					ValaParameter* param = NULL;
					ValaList* _tmp820_;
					gint _tmp821_;
					gpointer _tmp822_;
					ValaParameter* _tmp823_;
					_tmp817_ = _param_index;
					_param_index = _tmp817_ + 1;
					_tmp818_ = _param_index;
					_tmp819_ = _param_size;
					if (!(_tmp818_ < _tmp819_)) {
						break;
					}
					_tmp820_ = _param_list;
					_tmp821_ = _param_index;
					_tmp822_ = vala_list_get (_tmp820_, _tmp821_);
					param = (ValaParameter*) _tmp822_;
					_tmp823_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp823_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp824_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp824_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
		} else {
			gboolean _tmp825_ = FALSE;
			gboolean _tmp826_ = FALSE;
			ValaMethod* _tmp827_;
			_tmp827_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp827_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp828_;
				ValaCodeContext* _tmp829_;
				ValaProfile _tmp830_;
				ValaProfile _tmp831_;
				_tmp828_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp829_ = _tmp828_;
				_tmp830_ = vala_code_context_get_profile (_tmp829_);
				_tmp831_ = _tmp830_;
				_tmp826_ = _tmp831_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp826_ = FALSE;
			}
			if (_tmp826_) {
				ValaMethod* _tmp832_;
				ValaSymbol* _tmp833_;
				ValaSymbol* _tmp834_;
				_tmp832_ = m;
				_tmp833_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp832_);
				_tmp834_ = _tmp833_;
				_tmp825_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp834_, VALA_TYPE_CLASS);
			} else {
				_tmp825_ = FALSE;
			}
			if (_tmp825_) {
				ValaCCodeFunction* _tmp835_;
				ValaCCodeFunction* _tmp836_;
				ValaCCodeExpression* _tmp837_;
				ValaCCodeExpression* _tmp838_;
				ValaCCodeFunctionCall* _tmp839_;
				ValaClass* _tmp840_;
				ValaClass* _tmp841_;
				gchar* _tmp842_;
				gchar* _tmp843_;
				gchar* _tmp844_;
				gchar* _tmp845_;
				ValaCCodeCastExpression* _tmp846_;
				ValaCCodeCastExpression* _tmp847_;
				ValaMethod* _tmp848_;
				ValaMethod* _tmp849_;
				ValaBlock* _tmp850_;
				ValaBlock* _tmp851_;
				gboolean _tmp852_;
				gboolean _tmp853_;
				gboolean _tmp880_ = FALSE;
				ValaClass* _tmp881_;
				ValaClass* _tmp882_;
				gboolean _tmp883_;
				gboolean _tmp884_;
				_tmp835_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp836_ = _tmp835_;
				_tmp837_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp838_ = _tmp837_;
				_tmp839_ = ccall;
				_tmp840_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp841_ = _tmp840_;
				_tmp842_ = vala_get_ccode_name ((ValaCodeNode*) _tmp841_);
				_tmp843_ = _tmp842_;
				_tmp844_ = g_strconcat (_tmp843_, "*", NULL);
				_tmp845_ = _tmp844_;
				_tmp846_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp839_, _tmp845_);
				_tmp847_ = _tmp846_;
				vala_ccode_function_add_assignment (_tmp836_, _tmp838_, (ValaCCodeExpression*) _tmp847_);
				_vala_ccode_node_unref0 (_tmp847_);
				_g_free0 (_tmp845_);
				_g_free0 (_tmp843_);
				_vala_ccode_node_unref0 (_tmp838_);
				_tmp848_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp849_ = _tmp848_;
				_tmp850_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp849_);
				_tmp851_ = _tmp850_;
				_tmp852_ = vala_block_get_captured (_tmp851_);
				_tmp853_ = _tmp852_;
				if (_tmp853_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp854_;
					ValaClass* _tmp855_;
					ValaObjectType* _tmp856_;
					ValaObjectType* _tmp857_;
					ValaSourceReference* _tmp858_;
					ValaSourceReference* _tmp859_;
					ValaCCodeExpression* _tmp860_;
					ValaCCodeExpression* _tmp861_;
					ValaCCodeFunctionCall* _tmp862_;
					ValaCCodeFunctionCall* _tmp863_;
					ValaCCodeFunctionCall* _tmp864_;
					ValaCCodeExpression* _tmp865_;
					ValaCCodeExpression* _tmp866_;
					ValaCCodeFunction* _tmp867_;
					ValaCCodeFunction* _tmp868_;
					ValaMethod* _tmp869_;
					ValaMethod* _tmp870_;
					ValaBlock* _tmp871_;
					ValaBlock* _tmp872_;
					gchar* _tmp873_;
					gchar* _tmp874_;
					ValaCCodeExpression* _tmp875_;
					ValaCCodeExpression* _tmp876_;
					ValaCCodeMemberAccess* _tmp877_;
					ValaCCodeMemberAccess* _tmp878_;
					ValaCCodeFunctionCall* _tmp879_;
					_tmp854_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp855_ = _tmp854_;
					_tmp856_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp855_);
					_tmp857_ = _tmp856_;
					_tmp858_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp859_ = _tmp858_;
					_tmp860_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp857_, _tmp859_, FALSE);
					_tmp861_ = _tmp860_;
					_tmp862_ = vala_ccode_function_call_new (_tmp861_);
					_tmp863_ = _tmp862_;
					_vala_ccode_node_unref0 (_tmp861_);
					_vala_code_node_unref0 (_tmp857_);
					ref_call = _tmp863_;
					_tmp864_ = ref_call;
					_tmp865_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp866_ = _tmp865_;
					vala_ccode_function_call_add_argument (_tmp864_, _tmp866_);
					_vala_ccode_node_unref0 (_tmp866_);
					_tmp867_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp868_ = _tmp867_;
					_tmp869_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp870_ = _tmp869_;
					_tmp871_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp870_);
					_tmp872_ = _tmp871_;
					_tmp873_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp872_));
					_tmp874_ = _tmp873_;
					_tmp875_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp874_);
					_tmp876_ = _tmp875_;
					_tmp877_ = vala_ccode_member_access_new_pointer (_tmp876_, "self");
					_tmp878_ = _tmp877_;
					_tmp879_ = ref_call;
					vala_ccode_function_add_assignment (_tmp868_, (ValaCCodeExpression*) _tmp878_, (ValaCCodeExpression*) _tmp879_);
					_vala_ccode_node_unref0 (_tmp878_);
					_vala_ccode_node_unref0 (_tmp876_);
					_g_free0 (_tmp874_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp881_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp882_ = _tmp881_;
				_tmp883_ = vala_class_get_is_compact (_tmp882_);
				_tmp884_ = _tmp883_;
				if (!_tmp884_) {
					ValaClass* _tmp885_;
					ValaClass* _tmp886_;
					ValaList* _tmp887_;
					ValaList* _tmp888_;
					gint _tmp889_;
					gint _tmp890_;
					_tmp885_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp886_ = _tmp885_;
					_tmp887_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp886_);
					_tmp888_ = _tmp887_;
					_tmp889_ = vala_collection_get_size ((ValaCollection*) _tmp888_);
					_tmp890_ = _tmp889_;
					_tmp880_ = _tmp890_ > 0;
					_vala_iterable_unref0 (_tmp888_);
				} else {
					_tmp880_ = FALSE;
				}
				if (_tmp880_) {
					gchar** suffices = NULL;
					gchar* _tmp891_;
					gchar* _tmp892_;
					gchar* _tmp893_;
					gchar** _tmp894_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp891_ = g_strdup ("type");
					_tmp892_ = g_strdup ("dup_func");
					_tmp893_ = g_strdup ("destroy_func");
					_tmp894_ = g_new0 (gchar*, 3 + 1);
					_tmp894_[0] = _tmp891_;
					_tmp894_[1] = _tmp892_;
					_tmp894_[2] = _tmp893_;
					suffices = _tmp894_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp895_;
						ValaClass* _tmp896_;
						ValaList* _tmp897_;
						gint _type_param_size = 0;
						ValaList* _tmp898_;
						gint _tmp899_;
						gint _tmp900_;
						gint _type_param_index = 0;
						_tmp895_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp896_ = _tmp895_;
						_tmp897_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp896_);
						_type_param_list = _tmp897_;
						_tmp898_ = _type_param_list;
						_tmp899_ = vala_collection_get_size ((ValaCollection*) _tmp898_);
						_tmp900_ = _tmp899_;
						_type_param_size = _tmp900_;
						_type_param_index = -1;
						while (TRUE) {
							gint _tmp901_;
							gint _tmp902_;
							gint _tmp903_;
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp904_;
							gint _tmp905_;
							gpointer _tmp906_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp907_;
							ValaCCodeIdentifier* _tmp908_;
							ValaCCodeMemberAccess* _tmp909_;
							ValaCCodeMemberAccess* _tmp910_;
							gchar** _tmp911_;
							gint _tmp911__length1;
							_tmp901_ = _type_param_index;
							_type_param_index = _tmp901_ + 1;
							_tmp902_ = _type_param_index;
							_tmp903_ = _type_param_size;
							if (!(_tmp902_ < _tmp903_)) {
								break;
							}
							_tmp904_ = _type_param_list;
							_tmp905_ = _type_param_index;
							_tmp906_ = vala_list_get (_tmp904_, _tmp905_);
							type_param = (ValaTypeParameter*) _tmp906_;
							_tmp907_ = vala_ccode_identifier_new ("self");
							_tmp908_ = _tmp907_;
							_tmp909_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp908_, "priv");
							_tmp910_ = _tmp909_;
							_vala_ccode_node_unref0 (_tmp908_);
							priv_access = _tmp910_;
							_tmp911_ = suffices;
							_tmp911__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp911_;
								suffix_collection_length1 = _tmp911__length1;
								for (suffix_it = 0; suffix_it < _tmp911__length1; suffix_it = suffix_it + 1) {
									gchar* _tmp912_;
									gchar* suffix = NULL;
									_tmp912_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp912_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp913_;
										const gchar* _tmp914_;
										const gchar* _tmp915_;
										gchar* _tmp916_;
										gchar* _tmp917_;
										const gchar* _tmp918_;
										gchar* _tmp919_;
										gchar* _tmp920_;
										ValaCCodeIdentifier* _tmp921_;
										ValaCCodeIdentifier* _tmp922_;
										ValaCCodeFunction* _tmp923_;
										ValaCCodeFunction* _tmp924_;
										ValaCCodeMemberAccess* _tmp925_;
										ValaCCodeIdentifier* _tmp926_;
										const gchar* _tmp927_;
										const gchar* _tmp928_;
										ValaCCodeMemberAccess* _tmp929_;
										ValaCCodeMemberAccess* _tmp930_;
										ValaCCodeIdentifier* _tmp931_;
										_tmp913_ = type_param;
										_tmp914_ = vala_symbol_get_name ((ValaSymbol*) _tmp913_);
										_tmp915_ = _tmp914_;
										_tmp916_ = g_utf8_strdown (_tmp915_, (gssize) -1);
										_tmp917_ = _tmp916_;
										_tmp918_ = suffix;
										_tmp919_ = g_strdup_printf ("%s_%s", _tmp917_, _tmp918_);
										_tmp920_ = _tmp919_;
										_tmp921_ = vala_ccode_identifier_new (_tmp920_);
										_tmp922_ = _tmp921_;
										_g_free0 (_tmp920_);
										_g_free0 (_tmp917_);
										param_name = _tmp922_;
										_tmp923_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp924_ = _tmp923_;
										_tmp925_ = priv_access;
										_tmp926_ = param_name;
										_tmp927_ = vala_ccode_identifier_get_name (_tmp926_);
										_tmp928_ = _tmp927_;
										_tmp929_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp925_, _tmp928_);
										_tmp930_ = _tmp929_;
										_tmp931_ = param_name;
										vala_ccode_function_add_assignment (_tmp924_, (ValaCCodeExpression*) _tmp930_, (ValaCCodeExpression*) _tmp931_);
										_vala_ccode_node_unref0 (_tmp930_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp932_ = params;
	_tmp933_ = vala_iterable_iterator ((ValaIterable*) _tmp932_);
	params_it = _tmp933_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp934_;
		gint _arg_size = 0;
		ValaList* _tmp935_;
		gint _tmp936_;
		gint _tmp937_;
		gint _arg_index = 0;
		_tmp934_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp934_;
		_tmp935_ = _arg_list;
		_tmp936_ = vala_collection_get_size ((ValaCollection*) _tmp935_);
		_tmp937_ = _tmp936_;
		_arg_size = _tmp937_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp938_;
			gint _tmp939_;
			gint _tmp940_;
			ValaExpression* arg = NULL;
			ValaList* _tmp941_;
			gint _tmp942_;
			gpointer _tmp943_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp944_;
			ValaCCodeExpression* _tmp945_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp946_;
			ValaHashMap* _tmp947_;
			ValaIterator* _tmp948_;
			ValaHashMap* _tmp1264_;
			gint _tmp1265_;
			ValaCCodeExpression* _tmp1266_;
			gboolean _tmp1267_ = FALSE;
			ValaExpression* _tmp1268_;
			gint _tmp1288_;
			_tmp938_ = _arg_index;
			_arg_index = _tmp938_ + 1;
			_tmp939_ = _arg_index;
			_tmp940_ = _arg_size;
			if (!(_tmp939_ < _tmp940_)) {
				break;
			}
			_tmp941_ = _arg_list;
			_tmp942_ = _arg_index;
			_tmp943_ = vala_list_get (_tmp941_, _tmp942_);
			arg = (ValaExpression*) _tmp943_;
			_tmp944_ = arg;
			_tmp945_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp944_);
			cexpr = _tmp945_;
			_tmp946_ = in_arg_map;
			_tmp947_ = _vala_map_ref0 (_tmp946_);
			carg_map = _tmp947_;
			_tmp948_ = params_it;
			if (vala_iterator_next (_tmp948_)) {
				ValaParameter* param = NULL;
				ValaIterator* _tmp949_;
				gpointer _tmp950_;
				gboolean _tmp951_ = FALSE;
				ValaParameter* _tmp952_;
				gboolean _tmp953_;
				gboolean _tmp954_;
				gboolean _tmp958_;
				ValaParameter* _tmp1257_;
				gboolean _tmp1258_;
				_tmp949_ = params_it;
				_tmp950_ = vala_iterator_get (_tmp949_);
				param = (ValaParameter*) _tmp950_;
				_tmp952_ = param;
				_tmp953_ = vala_parameter_get_params_array (_tmp952_);
				_tmp954_ = _tmp953_;
				if (_tmp954_) {
					_tmp951_ = TRUE;
				} else {
					ValaParameter* _tmp955_;
					gboolean _tmp956_;
					gboolean _tmp957_;
					_tmp955_ = param;
					_tmp956_ = vala_parameter_get_ellipsis (_tmp955_);
					_tmp957_ = _tmp956_;
					_tmp951_ = _tmp957_;
				}
				ellipsis = _tmp951_;
				_tmp958_ = ellipsis;
				if (!_tmp958_) {
					ValaParameter* _tmp959_;
					ValaParameterDirection _tmp960_;
					ValaParameterDirection _tmp961_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp964_;
					ValaUnaryExpression* _tmp965_;
					gboolean _tmp966_ = FALSE;
					ValaUnaryExpression* _tmp967_;
					ValaParameter* _tmp1245_;
					gchar* _tmp1246_;
					gchar* _tmp1247_;
					gboolean _tmp1248_;
					_tmp959_ = param;
					_tmp960_ = vala_parameter_get_direction (_tmp959_);
					_tmp961_ = _tmp960_;
					if (_tmp961_ == VALA_PARAMETER_DIRECTION_OUT) {
						ValaHashMap* _tmp962_;
						ValaHashMap* _tmp963_;
						_tmp962_ = out_arg_map;
						_tmp963_ = _vala_map_ref0 (_tmp962_);
						_vala_map_unref0 (carg_map);
						carg_map = _tmp963_;
					}
					_tmp964_ = arg;
					_tmp965_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp964_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp964_) : NULL);
					unary = _tmp965_;
					_tmp967_ = unary;
					if (_tmp967_ == NULL) {
						_tmp966_ = TRUE;
					} else {
						ValaUnaryExpression* _tmp968_;
						ValaUnaryOperator _tmp969_;
						ValaUnaryOperator _tmp970_;
						_tmp968_ = unary;
						_tmp969_ = vala_unary_expression_get_operator (_tmp968_);
						_tmp970_ = _tmp969_;
						_tmp966_ = _tmp970_ != VALA_UNARY_OPERATOR_OUT;
					}
					if (_tmp966_) {
						gboolean _tmp971_ = FALSE;
						gboolean _tmp972_ = FALSE;
						ValaParameter* _tmp973_;
						ValaParameter* _tmp1115_;
						ValaExpression* _tmp1116_;
						ValaCCodeExpression* _tmp1117_;
						ValaCCodeExpression* _tmp1118_;
						_tmp973_ = param;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp973_)) {
							ValaParameter* _tmp974_;
							ValaDataType* _tmp975_;
							ValaDataType* _tmp976_;
							_tmp974_ = param;
							_tmp975_ = vala_variable_get_variable_type ((ValaVariable*) _tmp974_);
							_tmp976_ = _tmp975_;
							_tmp972_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp976_, VALA_TYPE_ARRAY_TYPE);
						} else {
							_tmp972_ = FALSE;
						}
						if (_tmp972_) {
							ValaParameter* _tmp977_;
							ValaDataType* _tmp978_;
							ValaDataType* _tmp979_;
							gboolean _tmp980_;
							gboolean _tmp981_;
							_tmp977_ = param;
							_tmp978_ = vala_variable_get_variable_type ((ValaVariable*) _tmp977_);
							_tmp979_ = _tmp978_;
							_tmp980_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp979_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							_tmp981_ = _tmp980_;
							_tmp971_ = !_tmp981_;
						} else {
							_tmp971_ = FALSE;
						}
						if (_tmp971_) {
							ValaArrayType* array_type = NULL;
							ValaParameter* _tmp982_;
							ValaDataType* _tmp983_;
							ValaDataType* _tmp984_;
							ValaArrayType* _tmp985_;
							_tmp982_ = param;
							_tmp983_ = vala_variable_get_variable_type ((ValaVariable*) _tmp982_);
							_tmp984_ = _tmp983_;
							_tmp985_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp984_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							array_type = _tmp985_;
							{
								gint dim = 0;
								dim = 1;
								{
									gboolean _tmp986_ = FALSE;
									_tmp986_ = TRUE;
									while (TRUE) {
										gint _tmp988_;
										ValaArrayType* _tmp989_;
										gint _tmp990_;
										gint _tmp991_;
										ValaCCodeExpression* array_length_expr = NULL;
										ValaParameter* _tmp992_;
										gchar* _tmp993_;
										gchar* _tmp994_;
										gboolean _tmp995_;
										ValaHashMap* _tmp1014_;
										ValaParameter* _tmp1015_;
										gint _tmp1016_;
										ValaCCodeExpression* _tmp1017_;
										if (!_tmp986_) {
											gint _tmp987_;
											_tmp987_ = dim;
											dim = _tmp987_ + 1;
										}
										_tmp986_ = FALSE;
										_tmp988_ = dim;
										_tmp989_ = array_type;
										_tmp990_ = vala_array_type_get_rank (_tmp989_);
										_tmp991_ = _tmp990_;
										if (!(_tmp988_ <= _tmp991_)) {
											break;
										}
										array_length_expr = NULL;
										_tmp992_ = param;
										_tmp993_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp992_);
										_tmp994_ = _tmp993_;
										_tmp995_ = _tmp994_ != NULL;
										_g_free0 (_tmp994_);
										if (_tmp995_) {
											gchar* length_ctype = NULL;
											ValaParameter* _tmp996_;
											gchar* _tmp997_;
											gboolean _tmp998_ = FALSE;
											ValaUnaryExpression* _tmp999_;
											ValaExpression* _tmp1005_;
											gint _tmp1006_;
											ValaCCodeExpression* _tmp1007_;
											ValaCCodeExpression* _tmp1008_;
											const gchar* _tmp1009_;
											ValaCCodeCastExpression* _tmp1010_;
											_tmp996_ = param;
											_tmp997_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp996_);
											length_ctype = _tmp997_;
											_tmp999_ = unary;
											if (_tmp999_ != NULL) {
												ValaUnaryExpression* _tmp1000_;
												ValaUnaryOperator _tmp1001_;
												ValaUnaryOperator _tmp1002_;
												_tmp1000_ = unary;
												_tmp1001_ = vala_unary_expression_get_operator (_tmp1000_);
												_tmp1002_ = _tmp1001_;
												_tmp998_ = _tmp1002_ == VALA_UNARY_OPERATOR_REF;
											} else {
												_tmp998_ = FALSE;
											}
											if (_tmp998_) {
												const gchar* _tmp1003_;
												gchar* _tmp1004_;
												_tmp1003_ = length_ctype;
												_tmp1004_ = g_strdup_printf ("%s*", _tmp1003_);
												_g_free0 (length_ctype);
												length_ctype = _tmp1004_;
											}
											_tmp1005_ = arg;
											_tmp1006_ = dim;
											_tmp1007_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1005_, _tmp1006_);
											_tmp1008_ = _tmp1007_;
											_tmp1009_ = length_ctype;
											_tmp1010_ = vala_ccode_cast_expression_new (_tmp1008_, _tmp1009_);
											_vala_ccode_node_unref0 (array_length_expr);
											array_length_expr = (ValaCCodeExpression*) _tmp1010_;
											_vala_ccode_node_unref0 (_tmp1008_);
											_g_free0 (length_ctype);
										} else {
											ValaExpression* _tmp1011_;
											gint _tmp1012_;
											ValaCCodeExpression* _tmp1013_;
											_tmp1011_ = arg;
											_tmp1012_ = dim;
											_tmp1013_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1011_, _tmp1012_);
											_vala_ccode_node_unref0 (array_length_expr);
											array_length_expr = _tmp1013_;
										}
										_tmp1014_ = carg_map;
										_tmp1015_ = param;
										_tmp1016_ = dim;
										_tmp1017_ = array_length_expr;
										vala_map_set ((ValaMap*) _tmp1014_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1015_) + (0.01 * _tmp1016_), FALSE)), _tmp1017_);
										_vala_ccode_node_unref0 (array_length_expr);
									}
								}
							}
							_vala_code_node_unref0 (array_type);
						} else {
							ValaParameter* _tmp1018_;
							ValaDataType* _tmp1019_;
							ValaDataType* _tmp1020_;
							_tmp1018_ = param;
							_tmp1019_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1018_);
							_tmp1020_ = _tmp1019_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1020_, VALA_TYPE_DELEGATE_TYPE)) {
								ValaDelegateType* deleg_type = NULL;
								ValaParameter* _tmp1021_;
								ValaDataType* _tmp1022_;
								ValaDataType* _tmp1023_;
								ValaDelegateType* _tmp1024_;
								ValaDelegateType* _tmp1025_;
								ValaDelegate* _tmp1026_;
								ValaDelegate* _tmp1027_;
								gboolean _tmp1028_;
								gboolean _tmp1029_;
								_tmp1021_ = param;
								_tmp1022_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1021_);
								_tmp1023_ = _tmp1022_;
								_tmp1024_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1023_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
								deleg_type = _tmp1024_;
								_tmp1025_ = deleg_type;
								_tmp1026_ = vala_delegate_type_get_delegate_symbol (_tmp1025_);
								_tmp1027_ = _tmp1026_;
								_tmp1028_ = vala_delegate_get_has_target (_tmp1027_);
								_tmp1029_ = _tmp1028_;
								if (_tmp1029_) {
									ValaCCodeExpression* delegate_target_destroy_notify = NULL;
									ValaCCodeExpression* delegate_target = NULL;
									ValaExpression* _tmp1030_;
									ValaCCodeExpression* _tmp1031_ = NULL;
									ValaCCodeExpression* _tmp1032_;
									ValaCCodeExpression* _tmp1033_;
									ValaParameter* _tmp1034_;
									gchar* _tmp1035_;
									gchar* _tmp1036_;
									gboolean _tmp1037_;
									_tmp1030_ = arg;
									_tmp1032_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1030_, &_tmp1031_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
									delegate_target_destroy_notify = _tmp1031_;
									delegate_target = _tmp1032_;
									_tmp1033_ = delegate_target;
									_vala_assert (_tmp1033_ != NULL, "delegate_target != null");
									_tmp1034_ = param;
									_tmp1035_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1034_);
									_tmp1036_ = _tmp1035_;
									_tmp1037_ = g_strcmp0 (_tmp1036_, "GClosure*") == 0;
									_g_free0 (_tmp1036_);
									if (_tmp1037_) {
										ValaCCodeFunctionCall* closure_new = NULL;
										ValaCCodeIdentifier* _tmp1038_;
										ValaCCodeIdentifier* _tmp1039_;
										ValaCCodeFunctionCall* _tmp1040_;
										ValaCCodeFunctionCall* _tmp1041_;
										ValaCCodeFunctionCall* _tmp1042_;
										ValaCCodeExpression* _tmp1043_;
										ValaCCodeCastExpression* _tmp1044_;
										ValaCCodeCastExpression* _tmp1045_;
										ValaCCodeFunctionCall* _tmp1046_;
										ValaCCodeExpression* _tmp1047_;
										ValaCCodeFunctionCall* _tmp1048_;
										ValaCCodeExpression* _tmp1049_;
										ValaCCodeCastExpression* _tmp1050_;
										ValaCCodeCastExpression* _tmp1051_;
										ValaCCodeExpression* _tmp1052_;
										ValaCCodeIdentifier* _tmp1053_;
										ValaCCodeIdentifier* _tmp1054_;
										ValaCCodeBinaryExpression* _tmp1055_;
										ValaCCodeBinaryExpression* _tmp1056_;
										ValaCCodeIdentifier* _tmp1057_;
										ValaCCodeIdentifier* _tmp1058_;
										ValaCCodeFunctionCall* _tmp1059_;
										ValaCCodeConditionalExpression* _tmp1060_;
										_tmp1038_ = vala_ccode_identifier_new ("g_cclosure_new");
										_tmp1039_ = _tmp1038_;
										_tmp1040_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1039_);
										_tmp1041_ = _tmp1040_;
										_vala_ccode_node_unref0 (_tmp1039_);
										closure_new = _tmp1041_;
										_tmp1042_ = closure_new;
										_tmp1043_ = cexpr;
										_tmp1044_ = vala_ccode_cast_expression_new (_tmp1043_, "GCallback");
										_tmp1045_ = _tmp1044_;
										vala_ccode_function_call_add_argument (_tmp1042_, (ValaCCodeExpression*) _tmp1045_);
										_vala_ccode_node_unref0 (_tmp1045_);
										_tmp1046_ = closure_new;
										_tmp1047_ = delegate_target;
										vala_ccode_function_call_add_argument (_tmp1046_, _tmp1047_);
										_tmp1048_ = closure_new;
										_tmp1049_ = delegate_target_destroy_notify;
										_tmp1050_ = vala_ccode_cast_expression_new (_tmp1049_, "GClosureNotify");
										_tmp1051_ = _tmp1050_;
										vala_ccode_function_call_add_argument (_tmp1048_, (ValaCCodeExpression*) _tmp1051_);
										_vala_ccode_node_unref0 (_tmp1051_);
										_tmp1052_ = cexpr;
										_tmp1053_ = vala_ccode_identifier_new ("NULL");
										_tmp1054_ = _tmp1053_;
										_tmp1055_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp1052_, (ValaCCodeExpression*) _tmp1054_);
										_tmp1056_ = _tmp1055_;
										_tmp1057_ = vala_ccode_identifier_new ("NULL");
										_tmp1058_ = _tmp1057_;
										_tmp1059_ = closure_new;
										_tmp1060_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1056_, (ValaCCodeExpression*) _tmp1058_, (ValaCCodeExpression*) _tmp1059_);
										_vala_ccode_node_unref0 (cexpr);
										cexpr = (ValaCCodeExpression*) _tmp1060_;
										_vala_ccode_node_unref0 (_tmp1058_);
										_vala_ccode_node_unref0 (_tmp1056_);
										_vala_ccode_node_unref0 (_tmp1054_);
										_vala_ccode_node_unref0 (closure_new);
									} else {
										ValaHashMap* _tmp1061_;
										ValaParameter* _tmp1062_;
										ValaCCodeExpression* _tmp1063_;
										ValaDelegateType* _tmp1064_;
										_tmp1061_ = carg_map;
										_tmp1062_ = param;
										_tmp1063_ = delegate_target;
										vala_map_set ((ValaMap*) _tmp1061_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1062_), FALSE)), _tmp1063_);
										_tmp1064_ = deleg_type;
										if (vala_data_type_is_disposable ((ValaDataType*) _tmp1064_)) {
											ValaCCodeExpression* _tmp1065_;
											ValaHashMap* _tmp1066_;
											ValaParameter* _tmp1067_;
											ValaCCodeExpression* _tmp1068_;
											_tmp1065_ = delegate_target_destroy_notify;
											_vala_assert (_tmp1065_ != NULL, "delegate_target_destroy_notify != null");
											_tmp1066_ = carg_map;
											_tmp1067_ = param;
											_tmp1068_ = delegate_target_destroy_notify;
											vala_map_set ((ValaMap*) _tmp1066_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1067_) + 0.01, FALSE)), _tmp1068_);
										}
									}
									_vala_ccode_node_unref0 (delegate_target);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								}
								_vala_code_node_unref0 (deleg_type);
							} else {
								ValaParameter* _tmp1069_;
								ValaDataType* _tmp1070_;
								ValaDataType* _tmp1071_;
								_tmp1069_ = param;
								_tmp1070_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1069_);
								_tmp1071_ = _tmp1070_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1071_, VALA_TYPE_METHOD_TYPE)) {
									ValaCCodeExpression* delegate_target_destroy_notify = NULL;
									ValaHashMap* _tmp1072_;
									ValaParameter* _tmp1073_;
									ValaExpression* _tmp1074_;
									ValaCCodeExpression* _tmp1075_ = NULL;
									ValaCCodeExpression* _tmp1076_;
									ValaCCodeExpression* _tmp1077_;
									_tmp1072_ = carg_map;
									_tmp1073_ = param;
									_tmp1074_ = arg;
									_tmp1076_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1074_, &_tmp1075_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
									delegate_target_destroy_notify = _tmp1075_;
									_tmp1077_ = _tmp1076_;
									vala_map_set ((ValaMap*) _tmp1072_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1073_), FALSE)), _tmp1077_);
									_vala_ccode_node_unref0 (_tmp1077_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								} else {
									ValaParameter* _tmp1078_;
									ValaDataType* _tmp1079_;
									ValaDataType* _tmp1080_;
									_tmp1078_ = param;
									_tmp1079_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1078_);
									_tmp1080_ = _tmp1079_;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1080_, VALA_TYPE_GENERIC_TYPE)) {
										gboolean _tmp1081_ = FALSE;
										ValaMethod* _tmp1082_;
										_tmp1082_ = m;
										if (_tmp1082_ != NULL) {
											ValaMethod* _tmp1083_;
											_tmp1083_ = m;
											_tmp1081_ = vala_get_ccode_simple_generics (_tmp1083_);
										} else {
											_tmp1081_ = FALSE;
										}
										if (_tmp1081_) {
											ValaGenericType* generic_type = NULL;
											ValaParameter* _tmp1084_;
											ValaDataType* _tmp1085_;
											ValaDataType* _tmp1086_;
											ValaGenericType* _tmp1087_;
											gint type_param_index = 0;
											ValaMethod* _tmp1088_;
											ValaGenericType* _tmp1089_;
											ValaTypeParameter* _tmp1090_;
											ValaTypeParameter* _tmp1091_;
											const gchar* _tmp1092_;
											const gchar* _tmp1093_;
											ValaDataType* type_arg = NULL;
											ValaMemberAccess* _tmp1094_;
											ValaList* _tmp1095_;
											ValaList* _tmp1096_;
											gint _tmp1097_;
											gpointer _tmp1098_;
											ValaDataType* _tmp1099_;
											ValaParameter* _tmp1100_;
											ValaDataType* _tmp1101_;
											ValaDataType* _tmp1102_;
											gboolean _tmp1103_;
											gboolean _tmp1104_;
											_tmp1084_ = param;
											_tmp1085_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1084_);
											_tmp1086_ = _tmp1085_;
											_tmp1087_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1086_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
											generic_type = _tmp1087_;
											_tmp1088_ = m;
											_tmp1089_ = generic_type;
											_tmp1090_ = vala_generic_type_get_type_parameter (_tmp1089_);
											_tmp1091_ = _tmp1090_;
											_tmp1092_ = vala_symbol_get_name ((ValaSymbol*) _tmp1091_);
											_tmp1093_ = _tmp1092_;
											type_param_index = vala_method_get_type_parameter_index (_tmp1088_, _tmp1093_);
											_tmp1094_ = ma;
											_tmp1095_ = vala_member_access_get_type_arguments (_tmp1094_);
											_tmp1096_ = _tmp1095_;
											_tmp1097_ = type_param_index;
											_tmp1098_ = vala_list_get (_tmp1096_, _tmp1097_);
											_tmp1099_ = (ValaDataType*) _tmp1098_;
											_vala_iterable_unref0 (_tmp1096_);
											type_arg = _tmp1099_;
											_tmp1100_ = param;
											_tmp1101_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1100_);
											_tmp1102_ = _tmp1101_;
											_tmp1103_ = vala_data_type_get_value_owned (_tmp1102_);
											_tmp1104_ = _tmp1103_;
											if (_tmp1104_) {
												ValaDataType* _tmp1105_;
												_tmp1105_ = type_arg;
												if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, _tmp1105_)) {
													ValaHashMap* _tmp1106_;
													ValaParameter* _tmp1107_;
													ValaDataType* _tmp1108_;
													ValaCCodeExpression* _tmp1109_;
													ValaCCodeExpression* _tmp1110_;
													_tmp1106_ = carg_map;
													_tmp1107_ = param;
													_tmp1108_ = type_arg;
													_tmp1109_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1108_, FALSE);
													_tmp1110_ = _tmp1109_;
													vala_map_set ((ValaMap*) _tmp1106_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1107_), FALSE)), _tmp1110_);
													_vala_ccode_node_unref0 (_tmp1110_);
												} else {
													ValaHashMap* _tmp1111_;
													ValaParameter* _tmp1112_;
													ValaCCodeConstant* _tmp1113_;
													ValaCCodeConstant* _tmp1114_;
													_tmp1111_ = carg_map;
													_tmp1112_ = param;
													_tmp1113_ = vala_ccode_constant_new ("NULL");
													_tmp1114_ = _tmp1113_;
													vala_map_set ((ValaMap*) _tmp1111_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1112_), FALSE)), (ValaCCodeExpression*) _tmp1114_);
													_vala_ccode_node_unref0 (_tmp1114_);
												}
											}
											_vala_code_node_unref0 (type_arg);
											_vala_code_node_unref0 (generic_type);
										}
									}
								}
							}
						}
						_tmp1115_ = param;
						_tmp1116_ = arg;
						_tmp1117_ = cexpr;
						_tmp1118_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1115_, _tmp1116_, _tmp1117_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = _tmp1118_;
					} else {
						ValaExpression* _tmp1119_;
						ValaLocalVariable* temp_var = NULL;
						ValaParameter* _tmp1120_;
						ValaDataType* _tmp1121_;
						ValaDataType* _tmp1122_;
						ValaParameter* _tmp1123_;
						ValaDataType* _tmp1124_;
						ValaDataType* _tmp1125_;
						gboolean _tmp1126_;
						gboolean _tmp1127_;
						ValaLocalVariable* _tmp1128_;
						ValaLocalVariable* _tmp1129_;
						ValaExpression* _tmp1130_;
						ValaLocalVariable* _tmp1131_;
						const gchar* _tmp1132_;
						const gchar* _tmp1133_;
						ValaCCodeExpression* _tmp1134_;
						ValaCCodeExpression* _tmp1135_;
						ValaExpression* _tmp1136_;
						ValaTargetValue* _tmp1137_;
						ValaTargetValue* _tmp1138_;
						ValaExpression* _tmp1139_;
						ValaDataType* _tmp1140_;
						ValaDataType* _tmp1141_;
						ValaExpression* _tmp1142_;
						ValaCCodeExpression* _tmp1143_;
						ValaCCodeExpression* _tmp1144_;
						ValaCCodeUnaryExpression* _tmp1145_;
						gboolean _tmp1146_ = FALSE;
						gboolean _tmp1147_ = FALSE;
						ValaParameter* _tmp1148_;
						_tmp1119_ = arg;
						vala_expression_set_target_value (_tmp1119_, NULL);
						_tmp1120_ = param;
						_tmp1121_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1120_);
						_tmp1122_ = _tmp1121_;
						_tmp1123_ = param;
						_tmp1124_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1123_);
						_tmp1125_ = _tmp1124_;
						_tmp1126_ = vala_data_type_get_value_owned (_tmp1125_);
						_tmp1127_ = _tmp1126_;
						_tmp1128_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1122_, _tmp1127_, NULL, TRUE);
						temp_var = _tmp1128_;
						_tmp1129_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1129_, FALSE);
						_tmp1130_ = arg;
						_tmp1131_ = temp_var;
						_tmp1132_ = vala_symbol_get_name ((ValaSymbol*) _tmp1131_);
						_tmp1133_ = _tmp1132_;
						_tmp1134_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1133_);
						_tmp1135_ = _tmp1134_;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1130_, _tmp1135_);
						_vala_ccode_node_unref0 (_tmp1135_);
						_tmp1136_ = arg;
						_tmp1137_ = vala_expression_get_target_value (_tmp1136_);
						_tmp1138_ = _tmp1137_;
						_tmp1139_ = arg;
						_tmp1140_ = vala_expression_get_target_type (_tmp1139_);
						_tmp1141_ = _tmp1140_;
						vala_target_value_set_value_type (_tmp1138_, _tmp1141_);
						_tmp1142_ = arg;
						_tmp1143_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1142_);
						_tmp1144_ = _tmp1143_;
						_tmp1145_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1144_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = (ValaCCodeExpression*) _tmp1145_;
						_vala_ccode_node_unref0 (_tmp1144_);
						_tmp1148_ = param;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1148_)) {
							ValaParameter* _tmp1149_;
							ValaDataType* _tmp1150_;
							ValaDataType* _tmp1151_;
							_tmp1149_ = param;
							_tmp1150_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1149_);
							_tmp1151_ = _tmp1150_;
							_tmp1147_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1151_, VALA_TYPE_ARRAY_TYPE);
						} else {
							_tmp1147_ = FALSE;
						}
						if (_tmp1147_) {
							ValaParameter* _tmp1152_;
							ValaDataType* _tmp1153_;
							ValaDataType* _tmp1154_;
							gboolean _tmp1155_;
							gboolean _tmp1156_;
							_tmp1152_ = param;
							_tmp1153_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1152_);
							_tmp1154_ = _tmp1153_;
							_tmp1155_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1154_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							_tmp1156_ = _tmp1155_;
							_tmp1146_ = !_tmp1156_;
						} else {
							_tmp1146_ = FALSE;
						}
						if (_tmp1146_) {
							ValaArrayType* array_type = NULL;
							ValaParameter* _tmp1157_;
							ValaDataType* _tmp1158_;
							ValaDataType* _tmp1159_;
							ValaArrayType* _tmp1160_;
							ValaDataType* array_length_type = NULL;
							ValaDataType* _tmp1161_;
							ValaDataType* _tmp1162_;
							ValaParameter* _tmp1163_;
							gchar* _tmp1164_;
							gchar* _tmp1165_;
							gboolean _tmp1166_;
							_tmp1157_ = param;
							_tmp1158_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1157_);
							_tmp1159_ = _tmp1158_;
							_tmp1160_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1159_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							array_type = _tmp1160_;
							_tmp1161_ = ((ValaCCodeBaseModule*) self)->int_type;
							_tmp1162_ = _vala_code_node_ref0 (_tmp1161_);
							array_length_type = _tmp1162_;
							_tmp1163_ = param;
							_tmp1164_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1163_);
							_tmp1165_ = _tmp1164_;
							_tmp1166_ = _tmp1165_ != NULL;
							_g_free0 (_tmp1165_);
							if (_tmp1166_) {
								ValaParameter* _tmp1167_;
								gchar* _tmp1168_;
								gchar* _tmp1169_;
								ValaCType* _tmp1170_;
								_tmp1167_ = param;
								_tmp1168_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1167_);
								_tmp1169_ = _tmp1168_;
								_tmp1170_ = vala_ctype_new (_tmp1169_);
								_vala_code_node_unref0 (array_length_type);
								array_length_type = (ValaDataType*) _tmp1170_;
								_g_free0 (_tmp1169_);
							}
							{
								gint dim = 0;
								dim = 1;
								{
									gboolean _tmp1171_ = FALSE;
									_tmp1171_ = TRUE;
									while (TRUE) {
										gint _tmp1173_;
										ValaArrayType* _tmp1174_;
										gint _tmp1175_;
										gint _tmp1176_;
										ValaLocalVariable* temp_array_length = NULL;
										ValaDataType* _tmp1177_;
										ValaLocalVariable* _tmp1178_;
										ValaLocalVariable* _tmp1179_;
										ValaExpression* _tmp1180_;
										ValaLocalVariable* _tmp1181_;
										const gchar* _tmp1182_;
										const gchar* _tmp1183_;
										ValaCCodeExpression* _tmp1184_;
										ValaCCodeExpression* _tmp1185_;
										ValaHashMap* _tmp1186_;
										ValaParameter* _tmp1187_;
										gint _tmp1188_;
										ValaExpression* _tmp1189_;
										ValaList* _tmp1190_;
										ValaList* _tmp1191_;
										gint _tmp1192_;
										gpointer _tmp1193_;
										ValaCCodeExpression* _tmp1194_;
										ValaCCodeUnaryExpression* _tmp1195_;
										ValaCCodeUnaryExpression* _tmp1196_;
										if (!_tmp1171_) {
											gint _tmp1172_;
											_tmp1172_ = dim;
											dim = _tmp1172_ + 1;
										}
										_tmp1171_ = FALSE;
										_tmp1173_ = dim;
										_tmp1174_ = array_type;
										_tmp1175_ = vala_array_type_get_rank (_tmp1174_);
										_tmp1176_ = _tmp1175_;
										if (!(_tmp1173_ <= _tmp1176_)) {
											break;
										}
										_tmp1177_ = array_length_type;
										_tmp1178_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1177_, TRUE, NULL, FALSE);
										temp_array_length = _tmp1178_;
										_tmp1179_ = temp_array_length;
										vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1179_, FALSE);
										_tmp1180_ = arg;
										_tmp1181_ = temp_array_length;
										_tmp1182_ = vala_symbol_get_name ((ValaSymbol*) _tmp1181_);
										_tmp1183_ = _tmp1182_;
										_tmp1184_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1183_);
										_tmp1185_ = _tmp1184_;
										vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, _tmp1180_, _tmp1185_);
										_vala_ccode_node_unref0 (_tmp1185_);
										_tmp1186_ = carg_map;
										_tmp1187_ = param;
										_tmp1188_ = dim;
										_tmp1189_ = arg;
										_tmp1190_ = vala_ccode_base_module_get_array_lengths ((ValaCCodeBaseModule*) self, _tmp1189_);
										_tmp1191_ = _tmp1190_;
										_tmp1192_ = dim;
										_tmp1193_ = vala_list_get (_tmp1191_, _tmp1192_ - 1);
										_tmp1194_ = (ValaCCodeExpression*) _tmp1193_;
										_tmp1195_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1194_);
										_tmp1196_ = _tmp1195_;
										vala_map_set ((ValaMap*) _tmp1186_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1187_) + (0.01 * _tmp1188_), FALSE)), (ValaCCodeExpression*) _tmp1196_);
										_vala_ccode_node_unref0 (_tmp1196_);
										_vala_ccode_node_unref0 (_tmp1194_);
										_vala_iterable_unref0 (_tmp1191_);
										_vala_code_node_unref0 (temp_array_length);
									}
								}
							}
							_vala_code_node_unref0 (array_length_type);
							_vala_code_node_unref0 (array_type);
						} else {
							ValaParameter* _tmp1197_;
							ValaDataType* _tmp1198_;
							ValaDataType* _tmp1199_;
							_tmp1197_ = param;
							_tmp1198_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1197_);
							_tmp1199_ = _tmp1198_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1199_, VALA_TYPE_DELEGATE_TYPE)) {
								ValaDelegateType* deleg_type = NULL;
								ValaParameter* _tmp1200_;
								ValaDataType* _tmp1201_;
								ValaDataType* _tmp1202_;
								ValaDelegateType* _tmp1203_;
								ValaDelegateType* _tmp1204_;
								ValaDelegate* _tmp1205_;
								ValaDelegate* _tmp1206_;
								gboolean _tmp1207_;
								gboolean _tmp1208_;
								_tmp1200_ = param;
								_tmp1201_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1200_);
								_tmp1202_ = _tmp1201_;
								_tmp1203_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1202_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
								deleg_type = _tmp1203_;
								_tmp1204_ = deleg_type;
								_tmp1205_ = vala_delegate_type_get_delegate_symbol (_tmp1204_);
								_tmp1206_ = _tmp1205_;
								_tmp1207_ = vala_delegate_get_has_target (_tmp1206_);
								_tmp1208_ = _tmp1207_;
								if (_tmp1208_) {
									ValaVoidType* _tmp1209_;
									ValaVoidType* _tmp1210_;
									ValaPointerType* _tmp1211_;
									ValaPointerType* _tmp1212_;
									ValaLocalVariable* _tmp1213_;
									ValaLocalVariable* _tmp1214_;
									ValaExpression* _tmp1215_;
									ValaLocalVariable* _tmp1216_;
									const gchar* _tmp1217_;
									const gchar* _tmp1218_;
									ValaCCodeExpression* _tmp1219_;
									ValaCCodeExpression* _tmp1220_;
									ValaHashMap* _tmp1221_;
									ValaParameter* _tmp1222_;
									ValaExpression* _tmp1223_;
									ValaCCodeExpression* _tmp1224_;
									ValaCCodeExpression* _tmp1225_;
									ValaCCodeUnaryExpression* _tmp1226_;
									ValaCCodeUnaryExpression* _tmp1227_;
									ValaDelegateType* _tmp1228_;
									_tmp1209_ = vala_void_type_new (NULL);
									_tmp1210_ = _tmp1209_;
									_tmp1211_ = vala_pointer_type_new ((ValaDataType*) _tmp1210_, NULL);
									_tmp1212_ = _tmp1211_;
									_tmp1213_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1212_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1213_;
									_vala_code_node_unref0 (_tmp1212_);
									_vala_code_node_unref0 (_tmp1210_);
									_tmp1214_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1214_, FALSE);
									_tmp1215_ = arg;
									_tmp1216_ = temp_var;
									_tmp1217_ = vala_symbol_get_name ((ValaSymbol*) _tmp1216_);
									_tmp1218_ = _tmp1217_;
									_tmp1219_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1218_);
									_tmp1220_ = _tmp1219_;
									vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, _tmp1215_, _tmp1220_);
									_vala_ccode_node_unref0 (_tmp1220_);
									_tmp1221_ = carg_map;
									_tmp1222_ = param;
									_tmp1223_ = arg;
									_tmp1224_ = vala_ccode_base_module_get_delegate_target ((ValaCCodeBaseModule*) self, _tmp1223_);
									_tmp1225_ = _tmp1224_;
									_tmp1226_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1225_);
									_tmp1227_ = _tmp1226_;
									vala_map_set ((ValaMap*) _tmp1221_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1222_), FALSE)), (ValaCCodeExpression*) _tmp1227_);
									_vala_ccode_node_unref0 (_tmp1227_);
									_vala_ccode_node_unref0 (_tmp1225_);
									_tmp1228_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1228_)) {
										ValaDataType* _tmp1229_;
										ValaLocalVariable* _tmp1230_;
										ValaLocalVariable* _tmp1231_;
										ValaExpression* _tmp1232_;
										ValaLocalVariable* _tmp1233_;
										const gchar* _tmp1234_;
										const gchar* _tmp1235_;
										ValaCCodeExpression* _tmp1236_;
										ValaCCodeExpression* _tmp1237_;
										ValaHashMap* _tmp1238_;
										ValaParameter* _tmp1239_;
										ValaExpression* _tmp1240_;
										ValaCCodeExpression* _tmp1241_;
										ValaCCodeExpression* _tmp1242_;
										ValaCCodeUnaryExpression* _tmp1243_;
										ValaCCodeUnaryExpression* _tmp1244_;
										_tmp1229_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
										_tmp1230_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1229_, TRUE, NULL, TRUE);
										_vala_code_node_unref0 (temp_var);
										temp_var = _tmp1230_;
										_tmp1231_ = temp_var;
										vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1231_, FALSE);
										_tmp1232_ = arg;
										_tmp1233_ = temp_var;
										_tmp1234_ = vala_symbol_get_name ((ValaSymbol*) _tmp1233_);
										_tmp1235_ = _tmp1234_;
										_tmp1236_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1235_);
										_tmp1237_ = _tmp1236_;
										vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1232_, _tmp1237_);
										_vala_ccode_node_unref0 (_tmp1237_);
										_tmp1238_ = carg_map;
										_tmp1239_ = param;
										_tmp1240_ = arg;
										_tmp1241_ = vala_ccode_base_module_get_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1240_);
										_tmp1242_ = _tmp1241_;
										_tmp1243_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1242_);
										_tmp1244_ = _tmp1243_;
										vala_map_set ((ValaMap*) _tmp1238_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1239_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1244_);
										_vala_ccode_node_unref0 (_tmp1244_);
										_vala_ccode_node_unref0 (_tmp1242_);
									}
								}
								_vala_code_node_unref0 (deleg_type);
							}
						}
						_vala_code_node_unref0 (temp_var);
					}
					_tmp1245_ = param;
					_tmp1246_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1245_);
					_tmp1247_ = _tmp1246_;
					_tmp1248_ = _tmp1247_ != NULL;
					_g_free0 (_tmp1247_);
					if (_tmp1248_) {
						ValaCCodeExpression* _tmp1249_;
						ValaParameter* _tmp1250_;
						gchar* _tmp1251_;
						gchar* _tmp1252_;
						ValaCCodeCastExpression* _tmp1253_;
						_tmp1249_ = cexpr;
						_tmp1250_ = param;
						_tmp1251_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1250_);
						_tmp1252_ = _tmp1251_;
						_tmp1253_ = vala_ccode_cast_expression_new (_tmp1249_, _tmp1252_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = (ValaCCodeExpression*) _tmp1253_;
						_g_free0 (_tmp1252_);
					}
					_vala_code_node_unref0 (unary);
				} else {
					ValaExpression* _tmp1254_;
					ValaCCodeExpression* _tmp1255_;
					ValaCCodeExpression* _tmp1256_;
					_tmp1254_ = arg;
					_tmp1255_ = cexpr;
					_tmp1256_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1254_, _tmp1255_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1256_;
				}
				_tmp1257_ = param;
				_tmp1258_ = ellipsis;
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_pos (_tmp1257_), _tmp1258_);
				_vala_code_node_unref0 (param);
			} else {
				ValaExpression* _tmp1259_;
				ValaCCodeExpression* _tmp1260_;
				ValaCCodeExpression* _tmp1261_;
				gint _tmp1262_;
				gboolean _tmp1263_;
				_tmp1259_ = arg;
				_tmp1260_ = cexpr;
				_tmp1261_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1259_, _tmp1260_);
				_vala_ccode_node_unref0 (cexpr);
				cexpr = _tmp1261_;
				_tmp1262_ = i;
				_tmp1263_ = ellipsis;
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) _tmp1262_, _tmp1263_);
			}
			_tmp1264_ = carg_map;
			_tmp1265_ = arg_pos;
			_tmp1266_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1264_, (gpointer) ((gintptr) _tmp1265_), _tmp1266_);
			_tmp1268_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1268_, VALA_TYPE_NAMED_ARGUMENT)) {
				gboolean _tmp1269_;
				_tmp1269_ = ellipsis;
				_tmp1267_ = _tmp1269_;
			} else {
				_tmp1267_ = FALSE;
			}
			if (_tmp1267_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1270_;
				ValaNamedArgument* _tmp1271_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1272_;
				const gchar* _tmp1273_;
				const gchar* _tmp1274_;
				gchar** _tmp1275_;
				gchar** _tmp1276_;
				gchar** _tmp1277_;
				gint _tmp1277__length1;
				gchar* _tmp1278_;
				gchar* _tmp1279_;
				ValaHashMap* _tmp1280_;
				gint _tmp1281_;
				gboolean _tmp1282_;
				const gchar* _tmp1283_;
				gchar* _tmp1284_;
				gchar* _tmp1285_;
				ValaCCodeConstant* _tmp1286_;
				ValaCCodeConstant* _tmp1287_;
				_tmp1270_ = arg;
				_tmp1271_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1270_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1271_;
				_tmp1272_ = named_arg;
				_tmp1273_ = vala_named_argument_get_name (_tmp1272_);
				_tmp1274_ = _tmp1273_;
				_tmp1276_ = _tmp1275_ = g_strsplit (_tmp1274_, "_", 0);
				_tmp1277_ = _tmp1276_;
				_tmp1277__length1 = _vala_array_length (_tmp1275_);
				_tmp1278_ = _vala_g_strjoinv ("-", _tmp1277_, _vala_array_length (_tmp1275_));
				_tmp1279_ = _tmp1278_;
				_tmp1277_ = (_vala_array_free (_tmp1277_, _tmp1277__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1279_;
				_tmp1280_ = carg_map;
				_tmp1281_ = i;
				_tmp1282_ = ellipsis;
				_tmp1283_ = name;
				_tmp1284_ = g_strdup_printf ("\"%s\"", _tmp1283_);
				_tmp1285_ = _tmp1284_;
				_tmp1286_ = vala_ccode_constant_new (_tmp1285_);
				_tmp1287_ = _tmp1286_;
				vala_map_set ((ValaMap*) _tmp1280_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1281_ - 0.1, _tmp1282_)), (ValaCCodeExpression*) _tmp1287_);
				_vala_ccode_node_unref0 (_tmp1287_);
				_g_free0 (_tmp1285_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1288_ = i;
			i = _tmp1288_ + 1;
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1289_ = params_it;
	if (vala_iterator_next (_tmp1289_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1290_;
		gpointer _tmp1291_;
		gboolean _tmp1292_ = FALSE;
		ValaParameter* _tmp1293_;
		gboolean _tmp1294_;
		gboolean _tmp1295_;
		_tmp1290_ = params_it;
		_tmp1291_ = vala_iterator_get (_tmp1290_);
		param = (ValaParameter*) _tmp1291_;
		_tmp1293_ = param;
		_tmp1294_ = vala_parameter_get_params_array (_tmp1293_);
		_tmp1295_ = _tmp1294_;
		if (_tmp1295_) {
			_tmp1292_ = TRUE;
		} else {
			ValaParameter* _tmp1296_;
			gboolean _tmp1297_;
			gboolean _tmp1298_;
			_tmp1296_ = param;
			_tmp1297_ = vala_parameter_get_ellipsis (_tmp1296_);
			_tmp1298_ = _tmp1297_;
			_tmp1292_ = _tmp1298_;
		}
		_vala_assert (_tmp1292_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1301_ = m;
	if (_tmp1301_ != NULL) {
		ValaMethod* _tmp1302_;
		ValaDataType* _tmp1303_;
		ValaDataType* _tmp1304_;
		_tmp1302_ = m;
		_tmp1303_ = vala_callable_get_return_type ((ValaCallable*) _tmp1302_);
		_tmp1304_ = _tmp1303_;
		_tmp1300_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1304_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1300_ = FALSE;
	}
	if (_tmp1300_) {
		ValaCCodeFunctionCall* _tmp1305_;
		ValaCCodeFunctionCall* _tmp1306_;
		_tmp1305_ = async_call;
		_tmp1306_ = ccall;
		_tmp1299_ = _tmp1305_ != _tmp1306_;
	} else {
		_tmp1299_ = FALSE;
	}
	if (_tmp1299_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1307_;
		ValaDataType* _tmp1308_;
		ValaDataType* _tmp1309_;
		ValaArrayType* _tmp1310_;
		_tmp1307_ = m;
		_tmp1308_ = vala_callable_get_return_type ((ValaCallable*) _tmp1307_);
		_tmp1309_ = _tmp1308_;
		_tmp1310_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1309_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1310_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1311_ = FALSE;
				_tmp1311_ = TRUE;
				while (TRUE) {
					gint _tmp1313_;
					ValaArrayType* _tmp1314_;
					gint _tmp1315_;
					gint _tmp1316_;
					ValaMethod* _tmp1317_;
					if (!_tmp1311_) {
						gint _tmp1312_;
						_tmp1312_ = dim;
						dim = _tmp1312_ + 1;
					}
					_tmp1311_ = FALSE;
					_tmp1313_ = dim;
					_tmp1314_ = array_type;
					_tmp1315_ = vala_array_type_get_rank (_tmp1314_);
					_tmp1316_ = _tmp1315_;
					if (!(_tmp1313_ <= _tmp1316_)) {
						break;
					}
					_tmp1317_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1317_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1318_;
						ValaDataType* _tmp1319_;
						ValaDataType* _tmp1320_;
						ValaLocalVariable* _tmp1321_;
						ValaLocalVariable* _tmp1322_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1323_;
						const gchar* _tmp1324_;
						const gchar* _tmp1325_;
						ValaCCodeExpression* _tmp1326_;
						ValaLocalVariable* _tmp1327_;
						ValaCCodeExpression* _tmp1328_;
						ValaCCodeExpression* _tmp1329_;
						ValaCCodeAssignment* _tmp1330_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1331_;
						ValaCCodeIdentifier* _tmp1332_;
						ValaCCodeFunctionCall* _tmp1333_;
						ValaCCodeFunctionCall* _tmp1334_;
						ValaCCodeFunctionCall* _tmp1335_;
						ValaCCodeExpression* _tmp1336_;
						ValaCCodeFunctionCall* _tmp1337_;
						_tmp1318_ = itype;
						_tmp1319_ = vala_data_type_get_return_type (_tmp1318_);
						_tmp1320_ = _tmp1319_;
						_tmp1321_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1320_, TRUE, NULL, FALSE);
						_tmp1322_ = _tmp1321_;
						_vala_code_node_unref0 (_tmp1320_);
						temp_var = _tmp1322_;
						_tmp1323_ = temp_var;
						_tmp1324_ = vala_symbol_get_name ((ValaSymbol*) _tmp1323_);
						_tmp1325_ = _tmp1324_;
						_tmp1326_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1325_);
						temp_ref = _tmp1326_;
						_tmp1327_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1327_, FALSE);
						_tmp1328_ = temp_ref;
						_tmp1329_ = ccall_expr;
						_tmp1330_ = vala_ccode_assignment_new (_tmp1328_, _tmp1329_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1330_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1331_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1332_ = _tmp1331_;
						_tmp1333_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1332_);
						_tmp1334_ = _tmp1333_;
						_vala_ccode_node_unref0 (_tmp1332_);
						len_call = _tmp1334_;
						_tmp1335_ = len_call;
						_tmp1336_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1335_, _tmp1336_);
						_tmp1337_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1337_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1338_;
						_tmp1338_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1338_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaMethod* _tmp1339_;
							gchar* _tmp1340_;
							gchar* _tmp1341_;
							gboolean _tmp1342_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1351_;
							const gchar* _tmp1352_;
							const gchar* _tmp1353_;
							ValaCCodeExpression* _tmp1354_;
							ValaLocalVariable* _tmp1355_;
							ValaHashMap* _tmp1356_;
							ValaMethod* _tmp1357_;
							gint _tmp1358_;
							ValaCCodeExpression* _tmp1359_;
							ValaCCodeUnaryExpression* _tmp1360_;
							ValaCCodeUnaryExpression* _tmp1361_;
							ValaCCodeExpression* _tmp1362_;
							_tmp1339_ = m;
							_tmp1340_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1339_);
							_tmp1341_ = _tmp1340_;
							_tmp1342_ = _tmp1341_ == NULL;
							_g_free0 (_tmp1341_);
							if (_tmp1342_) {
								ValaDataType* _tmp1343_;
								ValaLocalVariable* _tmp1344_;
								_tmp1343_ = ((ValaCCodeBaseModule*) self)->int_type;
								_tmp1344_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1343_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1344_;
							} else {
								ValaMethod* _tmp1345_;
								gchar* _tmp1346_;
								gchar* _tmp1347_;
								ValaCType* _tmp1348_;
								ValaCType* _tmp1349_;
								ValaLocalVariable* _tmp1350_;
								_tmp1345_ = m;
								_tmp1346_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1345_);
								_tmp1347_ = _tmp1346_;
								_tmp1348_ = vala_ctype_new (_tmp1347_);
								_tmp1349_ = _tmp1348_;
								_tmp1350_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1349_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1350_;
								_vala_code_node_unref0 (_tmp1349_);
								_g_free0 (_tmp1347_);
							}
							_tmp1351_ = temp_var;
							_tmp1352_ = vala_symbol_get_name ((ValaSymbol*) _tmp1351_);
							_tmp1353_ = _tmp1352_;
							_tmp1354_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1353_);
							temp_ref = _tmp1354_;
							_tmp1355_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1355_, FALSE);
							_tmp1356_ = out_arg_map;
							_tmp1357_ = m;
							_tmp1358_ = dim;
							_tmp1359_ = temp_ref;
							_tmp1360_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1359_);
							_tmp1361_ = _tmp1360_;
							vala_map_set ((ValaMap*) _tmp1356_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1357_) + (0.01 * _tmp1358_), FALSE)), (ValaCCodeExpression*) _tmp1361_);
							_vala_ccode_node_unref0 (_tmp1361_);
							_tmp1362_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1362_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaMethod* _tmp1363_;
							gchar* _tmp1364_;
							gchar* _tmp1365_;
							gboolean _tmp1366_;
							_tmp1363_ = m;
							_tmp1364_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1363_);
							_tmp1365_ = _tmp1364_;
							_tmp1366_ = _tmp1365_ != NULL;
							_g_free0 (_tmp1365_);
							if (_tmp1366_) {
								ValaMethod* _tmp1367_;
								gchar* _tmp1368_;
								gchar* _tmp1369_;
								ValaCCodeConstant* _tmp1370_;
								ValaCCodeConstant* _tmp1371_;
								_tmp1367_ = m;
								_tmp1368_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1367_);
								_tmp1369_ = _tmp1368_;
								_tmp1370_ = vala_ccode_constant_new (_tmp1369_);
								_tmp1371_ = _tmp1370_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1371_);
								_vala_ccode_node_unref0 (_tmp1371_);
								_g_free0 (_tmp1369_);
							} else {
								ValaCCodeConstant* _tmp1372_;
								ValaCCodeConstant* _tmp1373_;
								_tmp1372_ = vala_ccode_constant_new ("-1");
								_tmp1373_ = _tmp1372_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1373_);
								_vala_ccode_node_unref0 (_tmp1373_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1374_ = FALSE;
		gboolean _tmp1375_ = FALSE;
		ValaMethod* _tmp1376_;
		_tmp1376_ = m;
		if (_tmp1376_ != NULL) {
			ValaMethod* _tmp1377_;
			ValaDataType* _tmp1378_;
			ValaDataType* _tmp1379_;
			_tmp1377_ = m;
			_tmp1378_ = vala_callable_get_return_type ((ValaCallable*) _tmp1377_);
			_tmp1379_ = _tmp1378_;
			_tmp1375_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1379_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1375_ = FALSE;
		}
		if (_tmp1375_) {
			ValaCCodeFunctionCall* _tmp1380_;
			ValaCCodeFunctionCall* _tmp1381_;
			_tmp1380_ = async_call;
			_tmp1381_ = ccall;
			_tmp1374_ = _tmp1380_ != _tmp1381_;
		} else {
			_tmp1374_ = FALSE;
		}
		if (_tmp1374_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1382_;
			ValaDataType* _tmp1383_;
			ValaDataType* _tmp1384_;
			ValaDelegateType* _tmp1385_;
			ValaDelegateType* _tmp1386_;
			ValaDelegate* _tmp1387_;
			ValaDelegate* _tmp1388_;
			gboolean _tmp1389_;
			gboolean _tmp1390_;
			_tmp1382_ = m;
			_tmp1383_ = vala_callable_get_return_type ((ValaCallable*) _tmp1382_);
			_tmp1384_ = _tmp1383_;
			_tmp1385_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1384_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1385_;
			_tmp1386_ = deleg_type;
			_tmp1387_ = vala_delegate_type_get_delegate_symbol (_tmp1386_);
			_tmp1388_ = _tmp1387_;
			_tmp1389_ = vala_delegate_get_has_target (_tmp1388_);
			_tmp1390_ = _tmp1389_;
			if (_tmp1390_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1391_;
				ValaVoidType* _tmp1392_;
				ValaPointerType* _tmp1393_;
				ValaPointerType* _tmp1394_;
				ValaLocalVariable* _tmp1395_;
				ValaLocalVariable* _tmp1396_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1397_;
				const gchar* _tmp1398_;
				const gchar* _tmp1399_;
				ValaCCodeExpression* _tmp1400_;
				ValaLocalVariable* _tmp1401_;
				ValaHashMap* _tmp1402_;
				ValaMethod* _tmp1403_;
				ValaCCodeExpression* _tmp1404_;
				ValaCCodeUnaryExpression* _tmp1405_;
				ValaCCodeUnaryExpression* _tmp1406_;
				ValaCCodeExpression* _tmp1407_;
				ValaDelegateType* _tmp1408_;
				_tmp1391_ = vala_void_type_new (NULL);
				_tmp1392_ = _tmp1391_;
				_tmp1393_ = vala_pointer_type_new ((ValaDataType*) _tmp1392_, NULL);
				_tmp1394_ = _tmp1393_;
				_tmp1395_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1394_, TRUE, NULL, TRUE);
				_tmp1396_ = _tmp1395_;
				_vala_code_node_unref0 (_tmp1394_);
				_vala_code_node_unref0 (_tmp1392_);
				temp_var = _tmp1396_;
				_tmp1397_ = temp_var;
				_tmp1398_ = vala_symbol_get_name ((ValaSymbol*) _tmp1397_);
				_tmp1399_ = _tmp1398_;
				_tmp1400_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1399_);
				temp_ref = _tmp1400_;
				_tmp1401_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1401_, FALSE);
				_tmp1402_ = out_arg_map;
				_tmp1403_ = m;
				_tmp1404_ = temp_ref;
				_tmp1405_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1404_);
				_tmp1406_ = _tmp1405_;
				vala_map_set ((ValaMap*) _tmp1402_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1403_), FALSE)), (ValaCCodeExpression*) _tmp1406_);
				_vala_ccode_node_unref0 (_tmp1406_);
				_tmp1407_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1407_);
				_tmp1408_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1408_)) {
					ValaDataType* _tmp1409_;
					ValaLocalVariable* _tmp1410_;
					ValaLocalVariable* _tmp1411_;
					const gchar* _tmp1412_;
					const gchar* _tmp1413_;
					ValaCCodeExpression* _tmp1414_;
					ValaLocalVariable* _tmp1415_;
					ValaHashMap* _tmp1416_;
					ValaMethod* _tmp1417_;
					ValaCCodeExpression* _tmp1418_;
					ValaCCodeUnaryExpression* _tmp1419_;
					ValaCCodeUnaryExpression* _tmp1420_;
					ValaCCodeExpression* _tmp1421_;
					_tmp1409_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1410_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1409_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1410_;
					_tmp1411_ = temp_var;
					_tmp1412_ = vala_symbol_get_name ((ValaSymbol*) _tmp1411_);
					_tmp1413_ = _tmp1412_;
					_tmp1414_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1413_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1414_;
					_tmp1415_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1415_, FALSE);
					_tmp1416_ = out_arg_map;
					_tmp1417_ = m;
					_tmp1418_ = temp_ref;
					_tmp1419_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1418_);
					_tmp1420_ = _tmp1419_;
					vala_map_set ((ValaMap*) _tmp1416_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1417_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1420_);
					_vala_ccode_node_unref0 (_tmp1420_);
					_tmp1421_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1421_);
				} else {
					ValaCCodeConstant* _tmp1422_;
					ValaCCodeConstant* _tmp1423_;
					_tmp1422_ = vala_ccode_constant_new ("NULL");
					_tmp1423_ = _tmp1422_;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1423_);
					_vala_ccode_node_unref0 (_tmp1423_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1424_;
				ValaCCodeConstant* _tmp1425_;
				_tmp1424_ = vala_ccode_constant_new ("NULL");
				_tmp1425_ = _tmp1424_;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1425_);
				_vala_ccode_node_unref0 (_tmp1425_);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1427_ = deleg;
	if (_tmp1427_ != NULL) {
		ValaDelegate* _tmp1428_;
		ValaDataType* _tmp1429_;
		ValaDataType* _tmp1430_;
		_tmp1428_ = deleg;
		_tmp1429_ = vala_callable_get_return_type ((ValaCallable*) _tmp1428_);
		_tmp1430_ = _tmp1429_;
		_tmp1426_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1430_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1426_ = FALSE;
	}
	if (_tmp1426_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1431_;
		ValaDataType* _tmp1432_;
		ValaDataType* _tmp1433_;
		ValaArrayType* _tmp1434_;
		_tmp1431_ = deleg;
		_tmp1432_ = vala_callable_get_return_type ((ValaCallable*) _tmp1431_);
		_tmp1433_ = _tmp1432_;
		_tmp1434_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1433_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1434_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1435_ = FALSE;
				_tmp1435_ = TRUE;
				while (TRUE) {
					gint _tmp1437_;
					ValaArrayType* _tmp1438_;
					gint _tmp1439_;
					gint _tmp1440_;
					ValaDelegate* _tmp1441_;
					if (!_tmp1435_) {
						gint _tmp1436_;
						_tmp1436_ = dim;
						dim = _tmp1436_ + 1;
					}
					_tmp1435_ = FALSE;
					_tmp1437_ = dim;
					_tmp1438_ = array_type;
					_tmp1439_ = vala_array_type_get_rank (_tmp1438_);
					_tmp1440_ = _tmp1439_;
					if (!(_tmp1437_ <= _tmp1440_)) {
						break;
					}
					_tmp1441_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1441_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1442_;
						ValaDataType* _tmp1443_;
						ValaDataType* _tmp1444_;
						ValaLocalVariable* _tmp1445_;
						ValaLocalVariable* _tmp1446_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1447_;
						const gchar* _tmp1448_;
						const gchar* _tmp1449_;
						ValaCCodeExpression* _tmp1450_;
						ValaLocalVariable* _tmp1451_;
						ValaCCodeExpression* _tmp1452_;
						ValaCCodeExpression* _tmp1453_;
						ValaCCodeAssignment* _tmp1454_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1455_;
						ValaCCodeIdentifier* _tmp1456_;
						ValaCCodeFunctionCall* _tmp1457_;
						ValaCCodeFunctionCall* _tmp1458_;
						ValaCCodeFunctionCall* _tmp1459_;
						ValaCCodeExpression* _tmp1460_;
						ValaCCodeFunctionCall* _tmp1461_;
						_tmp1442_ = itype;
						_tmp1443_ = vala_data_type_get_return_type (_tmp1442_);
						_tmp1444_ = _tmp1443_;
						_tmp1445_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1444_, TRUE, NULL, FALSE);
						_tmp1446_ = _tmp1445_;
						_vala_code_node_unref0 (_tmp1444_);
						temp_var = _tmp1446_;
						_tmp1447_ = temp_var;
						_tmp1448_ = vala_symbol_get_name ((ValaSymbol*) _tmp1447_);
						_tmp1449_ = _tmp1448_;
						_tmp1450_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1449_);
						temp_ref = _tmp1450_;
						_tmp1451_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1451_, FALSE);
						_tmp1452_ = temp_ref;
						_tmp1453_ = ccall_expr;
						_tmp1454_ = vala_ccode_assignment_new (_tmp1452_, _tmp1453_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1454_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1455_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1456_ = _tmp1455_;
						_tmp1457_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1456_);
						_tmp1458_ = _tmp1457_;
						_vala_ccode_node_unref0 (_tmp1456_);
						len_call = _tmp1458_;
						_tmp1459_ = len_call;
						_tmp1460_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1459_, _tmp1460_);
						_tmp1461_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1461_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1462_;
						_tmp1462_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1462_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaDataType* _tmp1463_;
							ValaLocalVariable* _tmp1464_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1465_;
							const gchar* _tmp1466_;
							const gchar* _tmp1467_;
							ValaCCodeExpression* _tmp1468_;
							ValaLocalVariable* _tmp1469_;
							ValaHashMap* _tmp1470_;
							ValaDelegate* _tmp1471_;
							gint _tmp1472_;
							ValaCCodeExpression* _tmp1473_;
							ValaCCodeUnaryExpression* _tmp1474_;
							ValaCCodeUnaryExpression* _tmp1475_;
							ValaCCodeExpression* _tmp1476_;
							_tmp1463_ = ((ValaCCodeBaseModule*) self)->int_type;
							_tmp1464_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1463_, TRUE, NULL, TRUE);
							temp_var = _tmp1464_;
							_tmp1465_ = temp_var;
							_tmp1466_ = vala_symbol_get_name ((ValaSymbol*) _tmp1465_);
							_tmp1467_ = _tmp1466_;
							_tmp1468_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1467_);
							temp_ref = _tmp1468_;
							_tmp1469_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1469_, FALSE);
							_tmp1470_ = out_arg_map;
							_tmp1471_ = deleg;
							_tmp1472_ = dim;
							_tmp1473_ = temp_ref;
							_tmp1474_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1473_);
							_tmp1475_ = _tmp1474_;
							vala_map_set ((ValaMap*) _tmp1470_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1471_) + (0.01 * _tmp1472_), FALSE)), (ValaCCodeExpression*) _tmp1475_);
							_vala_ccode_node_unref0 (_tmp1475_);
							_tmp1476_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1476_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaCCodeConstant* _tmp1477_;
							ValaCCodeConstant* _tmp1478_;
							_tmp1477_ = vala_ccode_constant_new ("-1");
							_tmp1478_ = _tmp1477_;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1478_);
							_vala_ccode_node_unref0 (_tmp1478_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1479_ = FALSE;
		ValaDelegate* _tmp1480_;
		_tmp1480_ = deleg;
		if (_tmp1480_ != NULL) {
			ValaDelegate* _tmp1481_;
			ValaDataType* _tmp1482_;
			ValaDataType* _tmp1483_;
			_tmp1481_ = deleg;
			_tmp1482_ = vala_callable_get_return_type ((ValaCallable*) _tmp1481_);
			_tmp1483_ = _tmp1482_;
			_tmp1479_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1483_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1479_ = FALSE;
		}
		if (_tmp1479_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1484_;
			ValaDataType* _tmp1485_;
			ValaDataType* _tmp1486_;
			ValaDelegateType* _tmp1487_;
			ValaDelegateType* _tmp1488_;
			ValaDelegate* _tmp1489_;
			ValaDelegate* _tmp1490_;
			gboolean _tmp1491_;
			gboolean _tmp1492_;
			_tmp1484_ = deleg;
			_tmp1485_ = vala_callable_get_return_type ((ValaCallable*) _tmp1484_);
			_tmp1486_ = _tmp1485_;
			_tmp1487_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1486_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1487_;
			_tmp1488_ = deleg_type;
			_tmp1489_ = vala_delegate_type_get_delegate_symbol (_tmp1488_);
			_tmp1490_ = _tmp1489_;
			_tmp1491_ = vala_delegate_get_has_target (_tmp1490_);
			_tmp1492_ = _tmp1491_;
			if (_tmp1492_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1493_;
				ValaVoidType* _tmp1494_;
				ValaPointerType* _tmp1495_;
				ValaPointerType* _tmp1496_;
				ValaLocalVariable* _tmp1497_;
				ValaLocalVariable* _tmp1498_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1499_;
				const gchar* _tmp1500_;
				const gchar* _tmp1501_;
				ValaCCodeExpression* _tmp1502_;
				ValaLocalVariable* _tmp1503_;
				ValaHashMap* _tmp1504_;
				ValaDelegate* _tmp1505_;
				ValaCCodeExpression* _tmp1506_;
				ValaCCodeUnaryExpression* _tmp1507_;
				ValaCCodeUnaryExpression* _tmp1508_;
				ValaCCodeExpression* _tmp1509_;
				ValaDelegateType* _tmp1510_;
				_tmp1493_ = vala_void_type_new (NULL);
				_tmp1494_ = _tmp1493_;
				_tmp1495_ = vala_pointer_type_new ((ValaDataType*) _tmp1494_, NULL);
				_tmp1496_ = _tmp1495_;
				_tmp1497_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1496_, TRUE, NULL, TRUE);
				_tmp1498_ = _tmp1497_;
				_vala_code_node_unref0 (_tmp1496_);
				_vala_code_node_unref0 (_tmp1494_);
				temp_var = _tmp1498_;
				_tmp1499_ = temp_var;
				_tmp1500_ = vala_symbol_get_name ((ValaSymbol*) _tmp1499_);
				_tmp1501_ = _tmp1500_;
				_tmp1502_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1501_);
				temp_ref = _tmp1502_;
				_tmp1503_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1503_, FALSE);
				_tmp1504_ = out_arg_map;
				_tmp1505_ = deleg;
				_tmp1506_ = temp_ref;
				_tmp1507_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1506_);
				_tmp1508_ = _tmp1507_;
				vala_map_set ((ValaMap*) _tmp1504_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1505_), FALSE)), (ValaCCodeExpression*) _tmp1508_);
				_vala_ccode_node_unref0 (_tmp1508_);
				_tmp1509_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1509_);
				_tmp1510_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1510_)) {
					ValaDataType* _tmp1511_;
					ValaLocalVariable* _tmp1512_;
					ValaLocalVariable* _tmp1513_;
					const gchar* _tmp1514_;
					const gchar* _tmp1515_;
					ValaCCodeExpression* _tmp1516_;
					ValaLocalVariable* _tmp1517_;
					ValaHashMap* _tmp1518_;
					ValaDelegate* _tmp1519_;
					ValaCCodeExpression* _tmp1520_;
					ValaCCodeUnaryExpression* _tmp1521_;
					ValaCCodeUnaryExpression* _tmp1522_;
					ValaCCodeExpression* _tmp1523_;
					_tmp1511_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1512_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1511_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1512_;
					_tmp1513_ = temp_var;
					_tmp1514_ = vala_symbol_get_name ((ValaSymbol*) _tmp1513_);
					_tmp1515_ = _tmp1514_;
					_tmp1516_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1515_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1516_;
					_tmp1517_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1517_, FALSE);
					_tmp1518_ = out_arg_map;
					_tmp1519_ = deleg;
					_tmp1520_ = temp_ref;
					_tmp1521_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1520_);
					_tmp1522_ = _tmp1521_;
					vala_map_set ((ValaMap*) _tmp1518_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1519_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1522_);
					_vala_ccode_node_unref0 (_tmp1522_);
					_tmp1523_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1523_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1525_ = m;
	if (_tmp1525_ != NULL) {
		ValaMethod* _tmp1526_;
		gboolean _tmp1527_;
		gboolean _tmp1528_;
		_tmp1526_ = m;
		_tmp1527_ = vala_method_get_coroutine (_tmp1526_);
		_tmp1528_ = _tmp1527_;
		_tmp1524_ = _tmp1528_;
	} else {
		_tmp1524_ = FALSE;
	}
	if (_tmp1524_) {
		gboolean _tmp1529_;
		gboolean _tmp1530_;
		_tmp1529_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1530_ = _tmp1529_;
		if (_tmp1530_) {
			ValaHashMap* _tmp1531_;
			ValaMethod* _tmp1532_;
			ValaMethod* _tmp1533_;
			gchar* _tmp1534_;
			gchar* _tmp1535_;
			ValaCCodeIdentifier* _tmp1536_;
			ValaCCodeIdentifier* _tmp1537_;
			ValaHashMap* _tmp1538_;
			ValaCCodeIdentifier* _tmp1539_;
			ValaCCodeIdentifier* _tmp1540_;
			_tmp1531_ = in_arg_map;
			_tmp1532_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1533_ = _tmp1532_;
			_tmp1534_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1533_);
			_tmp1535_ = _tmp1534_;
			_tmp1536_ = vala_ccode_identifier_new (_tmp1535_);
			_tmp1537_ = _tmp1536_;
			vala_map_set ((ValaMap*) _tmp1531_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1537_);
			_vala_ccode_node_unref0 (_tmp1537_);
			_g_free0 (_tmp1535_);
			_tmp1538_ = in_arg_map;
			_tmp1539_ = vala_ccode_identifier_new ("_data_");
			_tmp1540_ = _tmp1539_;
			vala_map_set ((ValaMap*) _tmp1538_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1540_);
			_vala_ccode_node_unref0 (_tmp1540_);
		}
	}
	_tmp1541_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1542_ = _tmp1541_;
	if (_tmp1542_) {
		ValaHashMap* _tmp1543_;
		ValaCCodeExpression* _tmp1544_;
		ValaCCodeExpression* _tmp1545_;
		ValaCCodeUnaryExpression* _tmp1546_;
		ValaCCodeUnaryExpression* _tmp1547_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1543_ = out_arg_map;
		_tmp1544_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_inner_error_");
		_tmp1545_ = _tmp1544_;
		_tmp1546_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1545_);
		_tmp1547_ = _tmp1546_;
		vala_map_set ((ValaMap*) _tmp1543_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1547_);
		_vala_ccode_node_unref0 (_tmp1547_);
		_vala_ccode_node_unref0 (_tmp1545_);
	} else {
		gboolean _tmp1548_ = FALSE;
		gboolean _tmp1549_ = FALSE;
		ValaMethod* _tmp1550_;
		_tmp1550_ = m;
		if (_tmp1550_ != NULL) {
			ValaMethod* _tmp1551_;
			_tmp1551_ = m;
			_tmp1549_ = vala_method_has_error_type_parameter (_tmp1551_);
		} else {
			_tmp1549_ = FALSE;
		}
		if (_tmp1549_) {
			ValaCCodeFunctionCall* _tmp1552_;
			ValaCCodeFunctionCall* _tmp1553_;
			_tmp1552_ = async_call;
			_tmp1553_ = ccall;
			_tmp1548_ = _tmp1552_ != _tmp1553_;
		} else {
			_tmp1548_ = FALSE;
		}
		if (_tmp1548_) {
			ValaHashMap* _tmp1554_;
			ValaCCodeConstant* _tmp1555_;
			ValaCCodeConstant* _tmp1556_;
			_tmp1554_ = out_arg_map;
			_tmp1555_ = vala_ccode_constant_new ("NULL");
			_tmp1556_ = _tmp1555_;
			vala_map_set ((ValaMap*) _tmp1554_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1556_);
			_vala_ccode_node_unref0 (_tmp1556_);
		}
	}
	_tmp1557_ = ellipsis;
	if (_tmp1557_) {
		ValaMethod* _tmp1558_;
		_tmp1558_ = m;
		if (_tmp1558_ == NULL) {
			ValaHashMap* _tmp1559_;
			ValaCCodeConstant* _tmp1560_;
			ValaCCodeConstant* _tmp1561_;
			_tmp1559_ = in_arg_map;
			_tmp1560_ = vala_ccode_constant_new ("NULL");
			_tmp1561_ = _tmp1560_;
			vala_map_set ((ValaMap*) _tmp1559_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1561_);
			_vala_ccode_node_unref0 (_tmp1561_);
		} else {
			gboolean _tmp1562_ = FALSE;
			gboolean _tmp1563_ = FALSE;
			gboolean _tmp1564_ = FALSE;
			ValaMethod* _tmp1565_;
			gboolean _tmp1566_;
			gboolean _tmp1567_;
			_tmp1565_ = m;
			_tmp1566_ = vala_method_get_printf_format (_tmp1565_);
			_tmp1567_ = _tmp1566_;
			if (!_tmp1567_) {
				ValaMethod* _tmp1568_;
				gboolean _tmp1569_;
				gboolean _tmp1570_;
				_tmp1568_ = m;
				_tmp1569_ = vala_method_get_scanf_format (_tmp1568_);
				_tmp1570_ = _tmp1569_;
				_tmp1564_ = !_tmp1570_;
			} else {
				_tmp1564_ = FALSE;
			}
			if (_tmp1564_) {
				ValaMethod* _tmp1571_;
				gchar* _tmp1572_;
				gchar* _tmp1573_;
				_tmp1571_ = m;
				_tmp1572_ = vala_get_ccode_sentinel (_tmp1571_);
				_tmp1573_ = _tmp1572_;
				_tmp1563_ = g_strcmp0 (_tmp1573_, "") != 0;
				_g_free0 (_tmp1573_);
			} else {
				_tmp1563_ = FALSE;
			}
			if (_tmp1563_) {
				gboolean _tmp1574_;
				gboolean _tmp1575_;
				_tmp1574_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1575_ = _tmp1574_;
				_tmp1562_ = !_tmp1575_;
			} else {
				_tmp1562_ = FALSE;
			}
			if (_tmp1562_) {
				ValaHashMap* _tmp1576_;
				ValaMethod* _tmp1577_;
				gchar* _tmp1578_;
				gchar* _tmp1579_;
				ValaCCodeConstant* _tmp1580_;
				ValaCCodeConstant* _tmp1581_;
				_tmp1576_ = in_arg_map;
				_tmp1577_ = m;
				_tmp1578_ = vala_get_ccode_sentinel (_tmp1577_);
				_tmp1579_ = _tmp1578_;
				_tmp1580_ = vala_ccode_constant_new (_tmp1579_);
				_tmp1581_ = _tmp1580_;
				vala_map_set ((ValaMap*) _tmp1576_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1581_);
				_vala_ccode_node_unref0 (_tmp1581_);
				_g_free0 (_tmp1579_);
			}
		}
	}
	_tmp1582_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1582_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp1583_;
		ValaDelegateType* _tmp1584_;
		ValaDelegate* d = NULL;
		ValaDelegateType* _tmp1585_;
		ValaDelegate* _tmp1586_;
		ValaDelegate* _tmp1587_;
		ValaDelegate* _tmp1588_;
		ValaDelegate* _tmp1589_;
		gboolean _tmp1590_;
		gboolean _tmp1591_;
		_tmp1583_ = itype;
		_tmp1584_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1583_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		deleg_type = _tmp1584_;
		_tmp1585_ = deleg_type;
		_tmp1586_ = vala_delegate_type_get_delegate_symbol (_tmp1585_);
		_tmp1587_ = _tmp1586_;
		_tmp1588_ = _vala_code_node_ref0 (_tmp1587_);
		d = _tmp1588_;
		_tmp1589_ = d;
		_tmp1590_ = vala_delegate_get_has_target (_tmp1589_);
		_tmp1591_ = _tmp1590_;
		if (_tmp1591_) {
			ValaCCodeExpression* delegate_target_destroy_notify = NULL;
			ValaHashMap* _tmp1592_;
			ValaDelegate* _tmp1593_;
			ValaExpression* _tmp1594_;
			ValaExpression* _tmp1595_;
			ValaCCodeExpression* _tmp1596_ = NULL;
			ValaCCodeExpression* _tmp1597_;
			ValaCCodeExpression* _tmp1598_;
			ValaHashMap* _tmp1599_;
			ValaDelegate* _tmp1600_;
			ValaExpression* _tmp1601_;
			ValaExpression* _tmp1602_;
			ValaCCodeExpression* _tmp1603_ = NULL;
			ValaCCodeExpression* _tmp1604_;
			ValaCCodeExpression* _tmp1605_;
			_tmp1592_ = in_arg_map;
			_tmp1593_ = d;
			_tmp1594_ = vala_method_call_get_call (expr);
			_tmp1595_ = _tmp1594_;
			_tmp1597_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1595_, &_tmp1596_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1596_;
			_tmp1598_ = _tmp1597_;
			vala_map_set ((ValaMap*) _tmp1592_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1593_), FALSE)), _tmp1598_);
			_vala_ccode_node_unref0 (_tmp1598_);
			_tmp1599_ = out_arg_map;
			_tmp1600_ = d;
			_tmp1601_ = vala_method_call_get_call (expr);
			_tmp1602_ = _tmp1601_;
			_tmp1604_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1602_, &_tmp1603_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1603_;
			_tmp1605_ = _tmp1604_;
			vala_map_set ((ValaMap*) _tmp1599_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1600_), FALSE)), _tmp1605_);
			_vala_ccode_node_unref0 (_tmp1605_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		}
		_vala_code_node_unref0 (d);
		_vala_code_node_unref0 (deleg_type);
	}
	_tmp1606_ = itype;
	_tmp1607_ = vala_data_type_get_return_type (_tmp1606_);
	_tmp1608_ = _tmp1607_;
	_tmp1609_ = vala_data_type_is_real_non_null_struct_type (_tmp1608_);
	_vala_code_node_unref0 (_tmp1608_);
	return_result_via_out_param = _tmp1609_;
	_tmp1611_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1611_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1612_;
		ValaDataType* _tmp1613_;
		ValaDataType* _tmp1614_;
		_tmp1612_ = itype;
		_tmp1613_ = vala_data_type_get_return_type (_tmp1612_);
		_tmp1614_ = _tmp1613_;
		_tmp1610_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1614_, VALA_TYPE_VOID_TYPE);
		_vala_code_node_unref0 (_tmp1614_);
	} else {
		_tmp1610_ = FALSE;
	}
	if (_tmp1610_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1615_;
		ValaSignal* _tmp1616_;
		ValaSignal* _tmp1617_;
		ValaSignal* _tmp1618_;
		gboolean _tmp1619_ = FALSE;
		gboolean _tmp1620_ = FALSE;
		ValaMemberAccess* _tmp1621_;
		_tmp1615_ = itype;
		_tmp1616_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1615_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1617_ = _tmp1616_;
		_tmp1618_ = _vala_code_node_ref0 (_tmp1617_);
		sig = _tmp1618_;
		_tmp1621_ = ma;
		if (_tmp1621_ != NULL) {
			ValaMemberAccess* _tmp1622_;
			ValaExpression* _tmp1623_;
			ValaExpression* _tmp1624_;
			_tmp1622_ = ma;
			_tmp1623_ = vala_member_access_get_inner (_tmp1622_);
			_tmp1624_ = _tmp1623_;
			_tmp1620_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1624_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1620_ = FALSE;
		}
		if (_tmp1620_) {
			ValaSignal* _tmp1625_;
			gboolean _tmp1626_;
			gboolean _tmp1627_;
			_tmp1625_ = sig;
			_tmp1626_ = vala_signal_get_is_virtual (_tmp1625_);
			_tmp1627_ = _tmp1626_;
			_tmp1619_ = _tmp1627_;
		} else {
			_tmp1619_ = FALSE;
		}
		if (_tmp1619_) {
		} else {
			gboolean _tmp1628_ = FALSE;
			ValaSignal* _tmp1629_;
			_tmp1629_ = sig;
			if (!vala_ccode_base_module_get_signal_has_emitter ((ValaCCodeBaseModule*) self, _tmp1629_)) {
				_tmp1628_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1630_;
				ValaSourceReference* _tmp1631_;
				ValaSourceReference* _tmp1632_;
				ValaSourceFile* _tmp1633_;
				ValaSourceFile* _tmp1634_;
				ValaSignal* _tmp1635_;
				ValaSourceReference* _tmp1636_;
				ValaSourceReference* _tmp1637_;
				ValaSourceFile* _tmp1638_;
				ValaSourceFile* _tmp1639_;
				_tmp1630_ = ma;
				_tmp1631_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1630_);
				_tmp1632_ = _tmp1631_;
				_tmp1633_ = vala_source_reference_get_file (_tmp1632_);
				_tmp1634_ = _tmp1633_;
				_tmp1635_ = sig;
				_tmp1636_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1635_);
				_tmp1637_ = _tmp1636_;
				_tmp1638_ = vala_source_reference_get_file (_tmp1637_);
				_tmp1639_ = _tmp1638_;
				_tmp1628_ = _tmp1634_ == _tmp1639_;
			}
			if (_tmp1628_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1640_ = async_call;
	_tmp1641_ = ccall;
	if (_tmp1640_ == _tmp1641_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	_tmp1642_ = return_result_via_out_param;
	if (_tmp1642_) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1643_;
		ValaDataType* _tmp1644_;
		ValaDataType* _tmp1645_;
		ValaLocalVariable* _tmp1646_;
		ValaLocalVariable* _tmp1647_;
		ValaLocalVariable* _tmp1648_;
		const gchar* _tmp1649_;
		const gchar* _tmp1650_;
		ValaCCodeExpression* _tmp1651_;
		ValaLocalVariable* _tmp1652_;
		ValaHashMap* _tmp1653_;
		ValaCCodeExpression* _tmp1654_;
		ValaCCodeUnaryExpression* _tmp1655_;
		ValaCCodeUnaryExpression* _tmp1656_;
		_tmp1643_ = itype;
		_tmp1644_ = vala_data_type_get_return_type (_tmp1643_);
		_tmp1645_ = _tmp1644_;
		_tmp1646_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1645_, TRUE, NULL, TRUE);
		_tmp1647_ = _tmp1646_;
		_vala_code_node_unref0 (_tmp1645_);
		out_param_var = _tmp1647_;
		_tmp1648_ = out_param_var;
		_tmp1649_ = vala_symbol_get_name ((ValaSymbol*) _tmp1648_);
		_tmp1650_ = _tmp1649_;
		_tmp1651_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1650_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1651_;
		_tmp1652_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1652_, FALSE);
		_tmp1653_ = out_arg_map;
		_tmp1654_ = out_param_ref;
		_tmp1655_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1654_);
		_tmp1656_ = _tmp1655_;
		vala_map_set ((ValaMap*) _tmp1653_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1656_);
		_vala_ccode_node_unref0 (_tmp1656_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1657_ = async_call;
	_tmp1658_ = ccall;
	if (_tmp1657_ != _tmp1658_) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1675_;
			ValaCCodeFunctionCall* _tmp1676_;
			ValaHashMap* _tmp1677_;
			gint _tmp1678_;
			gpointer _tmp1679_;
			ValaCCodeExpression* _tmp1680_;
			gint _tmp1681_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1659_;
				ValaSet* _tmp1660_;
				ValaSet* _tmp1661_;
				ValaIterator* _tmp1662_;
				ValaIterator* _tmp1663_;
				_tmp1659_ = out_arg_map;
				_tmp1660_ = vala_map_get_keys ((ValaMap*) _tmp1659_);
				_tmp1661_ = _tmp1660_;
				_tmp1662_ = vala_iterable_iterator ((ValaIterable*) _tmp1661_);
				_tmp1663_ = _tmp1662_;
				_vala_iterable_unref0 (_tmp1661_);
				_pos_it = _tmp1663_;
				while (TRUE) {
					ValaIterator* _tmp1664_;
					gint pos = 0;
					ValaIterator* _tmp1665_;
					gpointer _tmp1666_;
					gboolean _tmp1667_ = FALSE;
					gint _tmp1668_;
					gint _tmp1669_;
					_tmp1664_ = _pos_it;
					if (!vala_iterator_next (_tmp1664_)) {
						break;
					}
					_tmp1665_ = _pos_it;
					_tmp1666_ = vala_iterator_get (_tmp1665_);
					pos = (gint) ((gintptr) _tmp1666_);
					_tmp1668_ = pos;
					_tmp1669_ = last_pos;
					if (_tmp1668_ > _tmp1669_) {
						gboolean _tmp1670_ = FALSE;
						gint _tmp1671_;
						_tmp1671_ = min_pos;
						if (_tmp1671_ == -1) {
							_tmp1670_ = TRUE;
						} else {
							gint _tmp1672_;
							gint _tmp1673_;
							_tmp1672_ = pos;
							_tmp1673_ = min_pos;
							_tmp1670_ = _tmp1672_ < _tmp1673_;
						}
						_tmp1667_ = _tmp1670_;
					} else {
						_tmp1667_ = FALSE;
					}
					if (_tmp1667_) {
						gint _tmp1674_;
						_tmp1674_ = pos;
						min_pos = _tmp1674_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1675_ = min_pos;
			if (_tmp1675_ == -1) {
				break;
			}
			_tmp1676_ = ccall;
			_tmp1677_ = out_arg_map;
			_tmp1678_ = min_pos;
			_tmp1679_ = vala_map_get ((ValaMap*) _tmp1677_, (gpointer) ((gintptr) _tmp1678_));
			_tmp1680_ = (ValaCCodeExpression*) _tmp1679_;
			vala_ccode_function_call_add_argument (_tmp1676_, _tmp1680_);
			_vala_ccode_node_unref0 (_tmp1680_);
			_tmp1681_ = min_pos;
			last_pos = _tmp1681_;
		}
	}
	_tmp1682_ = async_call;
	if (_tmp1682_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1699_;
			ValaCCodeFunctionCall* _tmp1700_;
			ValaHashMap* _tmp1701_;
			gint _tmp1702_;
			gpointer _tmp1703_;
			ValaCCodeExpression* _tmp1704_;
			gint _tmp1705_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1683_;
				ValaSet* _tmp1684_;
				ValaSet* _tmp1685_;
				ValaIterator* _tmp1686_;
				ValaIterator* _tmp1687_;
				_tmp1683_ = in_arg_map;
				_tmp1684_ = vala_map_get_keys ((ValaMap*) _tmp1683_);
				_tmp1685_ = _tmp1684_;
				_tmp1686_ = vala_iterable_iterator ((ValaIterable*) _tmp1685_);
				_tmp1687_ = _tmp1686_;
				_vala_iterable_unref0 (_tmp1685_);
				_pos_it = _tmp1687_;
				while (TRUE) {
					ValaIterator* _tmp1688_;
					gint pos = 0;
					ValaIterator* _tmp1689_;
					gpointer _tmp1690_;
					gboolean _tmp1691_ = FALSE;
					gint _tmp1692_;
					gint _tmp1693_;
					_tmp1688_ = _pos_it;
					if (!vala_iterator_next (_tmp1688_)) {
						break;
					}
					_tmp1689_ = _pos_it;
					_tmp1690_ = vala_iterator_get (_tmp1689_);
					pos = (gint) ((gintptr) _tmp1690_);
					_tmp1692_ = pos;
					_tmp1693_ = last_pos;
					if (_tmp1692_ > _tmp1693_) {
						gboolean _tmp1694_ = FALSE;
						gint _tmp1695_;
						_tmp1695_ = min_pos;
						if (_tmp1695_ == -1) {
							_tmp1694_ = TRUE;
						} else {
							gint _tmp1696_;
							gint _tmp1697_;
							_tmp1696_ = pos;
							_tmp1697_ = min_pos;
							_tmp1694_ = _tmp1696_ < _tmp1697_;
						}
						_tmp1691_ = _tmp1694_;
					} else {
						_tmp1691_ = FALSE;
					}
					if (_tmp1691_) {
						gint _tmp1698_;
						_tmp1698_ = pos;
						min_pos = _tmp1698_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1699_ = min_pos;
			if (_tmp1699_ == -1) {
				break;
			}
			_tmp1700_ = async_call;
			_tmp1701_ = in_arg_map;
			_tmp1702_ = min_pos;
			_tmp1703_ = vala_map_get ((ValaMap*) _tmp1701_, (gpointer) ((gintptr) _tmp1702_));
			_tmp1704_ = (ValaCCodeExpression*) _tmp1703_;
			vala_ccode_function_call_add_argument (_tmp1700_, _tmp1704_);
			_vala_ccode_node_unref0 (_tmp1704_);
			_tmp1705_ = min_pos;
			last_pos = _tmp1705_;
		}
	}
	_tmp1706_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1707_ = _tmp1706_;
	if (_tmp1707_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1708_;
		gint _tmp1709_;
		ValaCCodeFunction* _tmp1710_;
		ValaCCodeFunction* _tmp1711_;
		ValaCCodeIdentifier* _tmp1712_;
		ValaCCodeIdentifier* _tmp1713_;
		ValaCCodeMemberAccess* _tmp1714_;
		ValaCCodeMemberAccess* _tmp1715_;
		gint _tmp1716_;
		gchar* _tmp1717_;
		gchar* _tmp1718_;
		ValaCCodeConstant* _tmp1719_;
		ValaCCodeConstant* _tmp1720_;
		ValaCCodeFunction* _tmp1721_;
		ValaCCodeFunction* _tmp1722_;
		ValaCCodeFunctionCall* _tmp1723_;
		ValaCCodeFunction* _tmp1724_;
		ValaCCodeFunction* _tmp1725_;
		ValaCCodeConstant* _tmp1726_;
		ValaCCodeConstant* _tmp1727_;
		ValaCCodeFunction* _tmp1728_;
		ValaCCodeFunction* _tmp1729_;
		gint _tmp1730_;
		gchar* _tmp1731_;
		gchar* _tmp1732_;
		_tmp1708_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1709_ = _tmp1708_->next_coroutine_state;
		_tmp1708_->next_coroutine_state = _tmp1709_ + 1;
		state = _tmp1709_;
		_tmp1710_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1711_ = _tmp1710_;
		_tmp1712_ = vala_ccode_identifier_new ("_data_");
		_tmp1713_ = _tmp1712_;
		_tmp1714_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1713_, "_state_");
		_tmp1715_ = _tmp1714_;
		_tmp1716_ = state;
		_tmp1717_ = g_strdup_printf ("%i", _tmp1716_);
		_tmp1718_ = _tmp1717_;
		_tmp1719_ = vala_ccode_constant_new (_tmp1718_);
		_tmp1720_ = _tmp1719_;
		vala_ccode_function_add_assignment (_tmp1711_, (ValaCCodeExpression*) _tmp1715_, (ValaCCodeExpression*) _tmp1720_);
		_vala_ccode_node_unref0 (_tmp1720_);
		_g_free0 (_tmp1718_);
		_vala_ccode_node_unref0 (_tmp1715_);
		_vala_ccode_node_unref0 (_tmp1713_);
		_tmp1721_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1722_ = _tmp1721_;
		_tmp1723_ = async_call;
		vala_ccode_function_add_expression (_tmp1722_, (ValaCCodeExpression*) _tmp1723_);
		_tmp1724_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1725_ = _tmp1724_;
		_tmp1726_ = vala_ccode_constant_new ("FALSE");
		_tmp1727_ = _tmp1726_;
		vala_ccode_function_add_return (_tmp1725_, (ValaCCodeExpression*) _tmp1727_);
		_vala_ccode_node_unref0 (_tmp1727_);
		_tmp1728_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1729_ = _tmp1728_;
		_tmp1730_ = state;
		_tmp1731_ = g_strdup_printf ("_state_%d", _tmp1730_);
		_tmp1732_ = _tmp1731_;
		vala_ccode_function_add_label (_tmp1729_, _tmp1732_);
		_g_free0 (_tmp1732_);
	}
	_tmp1733_ = vala_method_call_get_is_assert (expr);
	_tmp1734_ = _tmp1733_;
	if (_tmp1734_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1735_;
		ValaSourceReference* _tmp1736_;
		ValaSourceLocation _tmp1737_ = {0};
		ValaSourceLocation _tmp1738_;
		gchar* _tmp1739_;
		ValaSourceReference* _tmp1740_;
		ValaSourceReference* _tmp1741_;
		ValaSourceLocation _tmp1742_ = {0};
		ValaSourceLocation _tmp1743_;
		gchar* _tmp1744_;
		ValaSourceReference* _tmp1745_;
		ValaSourceReference* _tmp1746_;
		ValaSourceLocation _tmp1747_ = {0};
		ValaSourceLocation _tmp1748_;
		gchar* _tmp1749_;
		gchar* _tmp1750_;
		ValaCCodeFunctionCall* _tmp1751_;
		ValaCCodeIdentifier* _tmp1752_;
		ValaCCodeIdentifier* _tmp1753_;
		ValaCCodeFunctionCall* _tmp1754_;
		const gchar* _tmp1755_;
		gchar* _tmp1756_;
		gchar* _tmp1757_;
		gchar* _tmp1758_;
		gchar* _tmp1759_;
		gchar* _tmp1760_;
		gchar* _tmp1761_;
		ValaCCodeConstant* _tmp1762_;
		ValaCCodeConstant* _tmp1763_;
		_tmp1735_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1736_ = _tmp1735_;
		vala_source_reference_get_begin (_tmp1736_, &_tmp1737_);
		_tmp1738_ = _tmp1737_;
		_tmp1739_ = _tmp1738_.pos;
		_tmp1740_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1741_ = _tmp1740_;
		vala_source_reference_get_end (_tmp1741_, &_tmp1742_);
		_tmp1743_ = _tmp1742_;
		_tmp1744_ = _tmp1743_.pos;
		_tmp1745_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1746_ = _tmp1745_;
		vala_source_reference_get_begin (_tmp1746_, &_tmp1747_);
		_tmp1748_ = _tmp1747_;
		_tmp1749_ = _tmp1748_.pos;
		_tmp1750_ = string_substring ((const gchar*) _tmp1739_, (glong) 0, (glong) ((gint) (_tmp1744_ - _tmp1749_)));
		message = _tmp1750_;
		_tmp1751_ = ccall;
		_tmp1752_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1753_ = _tmp1752_;
		vala_ccode_function_call_set_call (_tmp1751_, (ValaCCodeExpression*) _tmp1753_);
		_vala_ccode_node_unref0 (_tmp1753_);
		_tmp1754_ = ccall;
		_tmp1755_ = message;
		_tmp1756_ = string_replace (_tmp1755_, "\n", " ");
		_tmp1757_ = _tmp1756_;
		_tmp1758_ = g_strescape (_tmp1757_, "");
		_tmp1759_ = _tmp1758_;
		_tmp1760_ = g_strdup_printf ("\"%s\"", _tmp1759_);
		_tmp1761_ = _tmp1760_;
		_tmp1762_ = vala_ccode_constant_new (_tmp1761_);
		_tmp1763_ = _tmp1762_;
		vala_ccode_function_call_add_argument (_tmp1754_, (ValaCCodeExpression*) _tmp1763_);
		_vala_ccode_node_unref0 (_tmp1763_);
		_g_free0 (_tmp1761_);
		_g_free0 (_tmp1759_);
		_g_free0 (_tmp1757_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	_tmp1764_ = return_result_via_out_param;
	if (_tmp1764_) {
		ValaCCodeFunction* _tmp1765_;
		ValaCCodeFunction* _tmp1766_;
		ValaCCodeExpression* _tmp1767_;
		ValaCCodeExpression* _tmp1768_;
		ValaCCodeExpression* _tmp1769_;
		_tmp1765_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1766_ = _tmp1765_;
		_tmp1767_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1766_, _tmp1767_);
		_tmp1768_ = out_param_ref;
		_tmp1769_ = _vala_ccode_node_ref0 (_tmp1768_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1769_;
	}
	_tmp1772_ = m;
	if (_tmp1772_ != NULL) {
		ValaMethod* _tmp1773_;
		ValaMemberBinding _tmp1774_;
		ValaMemberBinding _tmp1775_;
		_tmp1773_ = m;
		_tmp1774_ = vala_method_get_binding (_tmp1773_);
		_tmp1775_ = _tmp1774_;
		_tmp1771_ = _tmp1775_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1771_ = FALSE;
	}
	if (_tmp1771_) {
		ValaMethod* _tmp1776_;
		gboolean _tmp1777_;
		gboolean _tmp1778_;
		_tmp1776_ = m;
		_tmp1777_ = vala_method_get_returns_modified_pointer (_tmp1776_);
		_tmp1778_ = _tmp1777_;
		_tmp1770_ = _tmp1778_;
	} else {
		_tmp1770_ = FALSE;
	}
	if (_tmp1770_) {
		gboolean _tmp1779_ = FALSE;
		gboolean _tmp1780_ = FALSE;
		ValaMemberAccess* _tmp1781_;
		_tmp1781_ = ma;
		if (_tmp1781_ != NULL) {
			ValaMemberAccess* _tmp1782_;
			ValaExpression* _tmp1783_;
			ValaExpression* _tmp1784_;
			ValaSymbol* _tmp1785_;
			ValaSymbol* _tmp1786_;
			_tmp1782_ = ma;
			_tmp1783_ = vala_member_access_get_inner (_tmp1782_);
			_tmp1784_ = _tmp1783_;
			_tmp1785_ = vala_expression_get_symbol_reference (_tmp1784_);
			_tmp1786_ = _tmp1785_;
			_tmp1780_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1786_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1780_ = FALSE;
		}
		if (_tmp1780_) {
			ValaMemberAccess* _tmp1787_;
			ValaExpression* _tmp1788_;
			ValaExpression* _tmp1789_;
			_tmp1787_ = ma;
			_tmp1788_ = vala_member_access_get_inner (_tmp1787_);
			_tmp1789_ = _tmp1788_;
			_tmp1779_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1789_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1779_ = FALSE;
		}
		if (_tmp1779_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1790_;
			ValaExpression* _tmp1791_;
			ValaExpression* _tmp1792_;
			ValaSymbol* _tmp1793_;
			ValaSymbol* _tmp1794_;
			ValaProperty* _tmp1795_;
			ValaProperty* _tmp1796_;
			ValaMemberAccess* _tmp1797_;
			ValaExpression* _tmp1798_;
			ValaExpression* _tmp1799_;
			ValaExpression* _tmp1800_;
			ValaExpression* _tmp1801_;
			ValaDataType* _tmp1802_;
			ValaDataType* _tmp1803_;
			ValaCCodeExpression* _tmp1804_;
			ValaGLibValue* _tmp1805_;
			ValaGLibValue* _tmp1806_;
			_tmp1790_ = ma;
			_tmp1791_ = vala_member_access_get_inner (_tmp1790_);
			_tmp1792_ = _tmp1791_;
			_tmp1793_ = vala_expression_get_symbol_reference (_tmp1792_);
			_tmp1794_ = _tmp1793_;
			_tmp1795_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1794_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1795_;
			_tmp1796_ = prop;
			_tmp1797_ = ma;
			_tmp1798_ = vala_member_access_get_inner (_tmp1797_);
			_tmp1799_ = _tmp1798_;
			_tmp1800_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1799_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1801_ = _tmp1800_;
			_tmp1802_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1803_ = _tmp1802_;
			_tmp1804_ = ccall_expr;
			_tmp1805_ = vala_glib_value_new (_tmp1803_, _tmp1804_, FALSE);
			_tmp1806_ = _tmp1805_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1796_, _tmp1801_, (ValaTargetValue*) _tmp1806_);
			_vala_target_value_unref0 (_tmp1806_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1807_;
			ValaCCodeExpression* _tmp1808_;
			ValaCCodeAssignment* _tmp1809_;
			_tmp1807_ = instance;
			_tmp1808_ = ccall_expr;
			_tmp1809_ = vala_ccode_assignment_new (_tmp1807_, _tmp1808_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1809_;
		}
	}
	_tmp1812_ = m;
	if (_tmp1812_ != NULL) {
		ValaMethod* _tmp1813_;
		gchar* _tmp1814_;
		gchar* _tmp1815_;
		_tmp1813_ = m;
		_tmp1814_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1813_);
		_tmp1815_ = _tmp1814_;
		_tmp1811_ = _tmp1815_ != NULL;
		_g_free0 (_tmp1815_);
	} else {
		_tmp1811_ = FALSE;
	}
	if (_tmp1811_) {
		ValaMethod* _tmp1816_;
		gchar* _tmp1817_;
		gchar* _tmp1818_;
		ValaMethod* _tmp1819_;
		ValaDataType* _tmp1820_;
		ValaDataType* _tmp1821_;
		gchar* _tmp1822_;
		gchar* _tmp1823_;
		_tmp1816_ = m;
		_tmp1817_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1816_);
		_tmp1818_ = _tmp1817_;
		_tmp1819_ = m;
		_tmp1820_ = vala_callable_get_return_type ((ValaCallable*) _tmp1819_);
		_tmp1821_ = _tmp1820_;
		_tmp1822_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1821_);
		_tmp1823_ = _tmp1822_;
		_tmp1810_ = g_strcmp0 (_tmp1818_, _tmp1823_) != 0;
		_g_free0 (_tmp1823_);
		_g_free0 (_tmp1818_);
	} else {
		_tmp1810_ = FALSE;
	}
	if (_tmp1810_) {
		ValaCCodeExpression* _tmp1824_;
		ValaMethod* _tmp1825_;
		ValaDataType* _tmp1826_;
		ValaDataType* _tmp1827_;
		gchar* _tmp1828_;
		gchar* _tmp1829_;
		ValaCCodeCastExpression* _tmp1830_;
		_tmp1824_ = ccall_expr;
		_tmp1825_ = m;
		_tmp1826_ = vala_callable_get_return_type ((ValaCallable*) _tmp1825_);
		_tmp1827_ = _tmp1826_;
		_tmp1828_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1827_);
		_tmp1829_ = _tmp1828_;
		_tmp1830_ = vala_ccode_cast_expression_new (_tmp1824_, _tmp1829_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1830_;
		_g_free0 (_tmp1829_);
	}
	_tmp1831_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1831_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1832_;
		ValaList* _tmp1833_;
		ValaIterator* _tmp1834_;
		ValaIterator* _tmp1835_;
		ValaIterator* _tmp1836_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1837_;
		gpointer _tmp1838_;
		ValaExpression* _tmp1839_;
		ValaCCodeExpression* _tmp1840_;
		ValaCCodeExpression* _tmp1841_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1842_;
		ValaLocalVariable* _tmp1843_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1844_;
		const gchar* _tmp1845_;
		const gchar* _tmp1846_;
		ValaCCodeExpression* _tmp1847_;
		ValaLocalVariable* _tmp1848_;
		ValaCCodeFile* _tmp1849_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1850_;
		ValaExpression* _tmp1851_;
		ValaExpression* _tmp1852_;
		ValaCCodeExpression* _tmp1853_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1854_;
		ValaExpression* _tmp1855_;
		ValaExpression* _tmp1856_;
		ValaCCodeExpression* _tmp1857_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1858_;
		ValaExpression* _tmp1859_;
		ValaExpression* _tmp1860_;
		ValaDataType* _tmp1861_;
		ValaDataType* _tmp1862_;
		ValaArrayType* _tmp1863_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1864_;
		ValaDataType* _tmp1865_;
		ValaDataType* _tmp1866_;
		gchar* _tmp1867_;
		gchar* _tmp1868_;
		gchar* _tmp1869_;
		gchar* _tmp1870_;
		ValaCCodeIdentifier* _tmp1871_;
		ValaCCodeIdentifier* _tmp1872_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1873_;
		ValaCCodeExpression* _tmp1874_;
		ValaCCodeBinaryExpression* _tmp1875_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1876_;
		ValaCCodeExpression* _tmp1877_;
		ValaCCodeBinaryExpression* _tmp1878_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1879_;
		ValaCCodeIdentifier* _tmp1880_;
		ValaCCodeFunctionCall* _tmp1881_;
		ValaCCodeFunctionCall* _tmp1882_;
		ValaCCodeFunctionCall* _tmp1883_;
		ValaCCodeExpression* _tmp1884_;
		ValaCCodeExpression* _tmp1885_;
		ValaCCodeBinaryExpression* _tmp1886_;
		ValaCCodeBinaryExpression* _tmp1887_;
		ValaCCodeFunctionCall* _tmp1888_;
		ValaCCodeConstant* _tmp1889_;
		ValaCCodeConstant* _tmp1890_;
		ValaCCodeFunctionCall* _tmp1891_;
		ValaCCodeIdentifier* _tmp1892_;
		ValaCCodeBinaryExpression* _tmp1893_;
		ValaCCodeBinaryExpression* _tmp1894_;
		ValaCCodeBinaryExpression* _tmp1895_;
		ValaCCodeFunction* _tmp1896_;
		ValaCCodeFunction* _tmp1897_;
		ValaCCodeExpression* _tmp1898_;
		ValaCCodeExpression* _tmp1899_;
		ValaCCodeFunction* _tmp1900_;
		ValaCCodeFunction* _tmp1901_;
		ValaCCodeExpression* _tmp1902_;
		ValaCCodeFunction* _tmp1903_;
		ValaCCodeFunction* _tmp1904_;
		ValaCCodeBinaryExpression* _tmp1905_;
		ValaCCodeFunctionCall* _tmp1906_;
		ValaCCodeConstant* _tmp1907_;
		ValaCCodeConstant* _tmp1908_;
		ValaCCodeConditionalExpression* _tmp1909_;
		ValaCCodeConditionalExpression* _tmp1910_;
		ValaCCodeFunction* _tmp1911_;
		ValaCCodeFunction* _tmp1912_;
		ValaMemberAccess* _tmp1913_;
		ValaExpression* _tmp1914_;
		ValaExpression* _tmp1915_;
		ValaCCodeExpression* _tmp1916_;
		ValaCCodeExpression* _tmp1917_;
		ValaCCodeExpression* _tmp1918_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1919_;
		ValaExpression* _tmp1920_;
		ValaExpression* _tmp1921_;
		ValaSymbol* _tmp1922_;
		ValaSymbol* _tmp1923_;
		ValaSymbol* _tmp1924_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1925_;
		ValaLocalVariable* _tmp1926_;
		gboolean _tmp1927_ = FALSE;
		gboolean _tmp1928_ = FALSE;
		ValaSymbol* _tmp1929_;
		_tmp1832_ = vala_method_call_get_argument_list (expr);
		_tmp1833_ = _tmp1832_;
		_tmp1834_ = vala_iterable_iterator ((ValaIterable*) _tmp1833_);
		_tmp1835_ = _tmp1834_;
		_vala_iterable_unref0 (_tmp1833_);
		arg_it = _tmp1835_;
		_tmp1836_ = arg_it;
		vala_iterator_next (_tmp1836_);
		_tmp1837_ = arg_it;
		_tmp1838_ = vala_iterator_get (_tmp1837_);
		_tmp1839_ = (ValaExpression*) _tmp1838_;
		_tmp1840_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1839_);
		_tmp1841_ = _tmp1840_;
		_vala_code_node_unref0 (_tmp1839_);
		new_size = _tmp1841_;
		_tmp1842_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1843_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1842_, TRUE, NULL, FALSE);
		temp_decl = _tmp1843_;
		_tmp1844_ = temp_decl;
		_tmp1845_ = vala_symbol_get_name ((ValaSymbol*) _tmp1844_);
		_tmp1846_ = _tmp1845_;
		_tmp1847_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1846_);
		temp_ref = _tmp1847_;
		_tmp1848_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1848_, FALSE);
		_tmp1849_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1849_, "string.h", FALSE);
		_tmp1850_ = ma;
		_tmp1851_ = vala_member_access_get_inner (_tmp1850_);
		_tmp1852_ = _tmp1851_;
		_tmp1853_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1852_, 1);
		clen = _tmp1853_;
		_tmp1854_ = ma;
		_tmp1855_ = vala_member_access_get_inner (_tmp1854_);
		_tmp1856_ = _tmp1855_;
		_tmp1857_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1856_);
		celems = _tmp1857_;
		_tmp1858_ = ma;
		_tmp1859_ = vala_member_access_get_inner (_tmp1858_);
		_tmp1860_ = _tmp1859_;
		_tmp1861_ = vala_expression_get_value_type (_tmp1860_);
		_tmp1862_ = _tmp1861_;
		_tmp1863_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1862_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1863_;
		_tmp1864_ = array_type;
		_tmp1865_ = vala_array_type_get_element_type (_tmp1864_);
		_tmp1866_ = _tmp1865_;
		_tmp1867_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1866_);
		_tmp1868_ = _tmp1867_;
		_tmp1869_ = g_strdup_printf ("sizeof (%s)", _tmp1868_);
		_tmp1870_ = _tmp1869_;
		_tmp1871_ = vala_ccode_identifier_new (_tmp1870_);
		_tmp1872_ = _tmp1871_;
		_g_free0 (_tmp1870_);
		_g_free0 (_tmp1868_);
		csizeof = _tmp1872_;
		_tmp1873_ = temp_ref;
		_tmp1874_ = clen;
		_tmp1875_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1873_, _tmp1874_);
		cdelta = _tmp1875_;
		_tmp1876_ = temp_ref;
		_tmp1877_ = clen;
		_tmp1878_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1876_, _tmp1877_);
		ccheck = _tmp1878_;
		_tmp1879_ = vala_ccode_identifier_new ("memset");
		_tmp1880_ = _tmp1879_;
		_tmp1881_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1880_);
		_tmp1882_ = _tmp1881_;
		_vala_ccode_node_unref0 (_tmp1880_);
		czero = _tmp1882_;
		_tmp1883_ = czero;
		_tmp1884_ = celems;
		_tmp1885_ = clen;
		_tmp1886_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1884_, _tmp1885_);
		_tmp1887_ = _tmp1886_;
		vala_ccode_function_call_add_argument (_tmp1883_, (ValaCCodeExpression*) _tmp1887_);
		_vala_ccode_node_unref0 (_tmp1887_);
		_tmp1888_ = czero;
		_tmp1889_ = vala_ccode_constant_new ("0");
		_tmp1890_ = _tmp1889_;
		vala_ccode_function_call_add_argument (_tmp1888_, (ValaCCodeExpression*) _tmp1890_);
		_vala_ccode_node_unref0 (_tmp1890_);
		_tmp1891_ = czero;
		_tmp1892_ = csizeof;
		_tmp1893_ = cdelta;
		_tmp1894_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1892_, (ValaCCodeExpression*) _tmp1893_);
		_tmp1895_ = _tmp1894_;
		vala_ccode_function_call_add_argument (_tmp1891_, (ValaCCodeExpression*) _tmp1895_);
		_vala_ccode_node_unref0 (_tmp1895_);
		_tmp1896_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1897_ = _tmp1896_;
		_tmp1898_ = temp_ref;
		_tmp1899_ = new_size;
		vala_ccode_function_add_assignment (_tmp1897_, _tmp1898_, _tmp1899_);
		_tmp1900_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1901_ = _tmp1900_;
		_tmp1902_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1901_, _tmp1902_);
		_tmp1903_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1904_ = _tmp1903_;
		_tmp1905_ = ccheck;
		_tmp1906_ = czero;
		_tmp1907_ = vala_ccode_constant_new ("NULL");
		_tmp1908_ = _tmp1907_;
		_tmp1909_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1905_, (ValaCCodeExpression*) _tmp1906_, (ValaCCodeExpression*) _tmp1908_);
		_tmp1910_ = _tmp1909_;
		vala_ccode_function_add_expression (_tmp1904_, (ValaCCodeExpression*) _tmp1910_);
		_vala_ccode_node_unref0 (_tmp1910_);
		_vala_ccode_node_unref0 (_tmp1908_);
		_tmp1911_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1912_ = _tmp1911_;
		_tmp1913_ = ma;
		_tmp1914_ = vala_member_access_get_inner (_tmp1913_);
		_tmp1915_ = _tmp1914_;
		_tmp1916_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1915_, 1);
		_tmp1917_ = _tmp1916_;
		_tmp1918_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1912_, _tmp1917_, _tmp1918_);
		_vala_ccode_node_unref0 (_tmp1917_);
		_tmp1919_ = ma;
		_tmp1920_ = vala_member_access_get_inner (_tmp1919_);
		_tmp1921_ = _tmp1920_;
		_tmp1922_ = vala_expression_get_symbol_reference (_tmp1921_);
		_tmp1923_ = _tmp1922_;
		_tmp1924_ = _vala_code_node_ref0 (_tmp1923_);
		array_var = _tmp1924_;
		_tmp1925_ = array_var;
		_tmp1926_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1925_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1925_) : NULL);
		array_local = _tmp1926_;
		_tmp1929_ = array_var;
		if (_tmp1929_ != NULL) {
			ValaSymbol* _tmp1930_;
			_tmp1930_ = array_var;
			_tmp1928_ = vala_symbol_is_internal_symbol (_tmp1930_);
		} else {
			_tmp1928_ = FALSE;
		}
		if (_tmp1928_) {
			gboolean _tmp1931_ = FALSE;
			gboolean _tmp1932_ = FALSE;
			ValaSymbol* _tmp1933_;
			_tmp1933_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1933_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1934_;
				gboolean _tmp1935_;
				gboolean _tmp1936_;
				_tmp1934_ = array_local;
				_tmp1935_ = vala_local_variable_get_captured (_tmp1934_);
				_tmp1936_ = _tmp1935_;
				_tmp1932_ = !_tmp1936_;
			} else {
				_tmp1932_ = FALSE;
			}
			if (_tmp1932_) {
				_tmp1931_ = TRUE;
			} else {
				ValaSymbol* _tmp1937_;
				_tmp1937_ = array_var;
				_tmp1931_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1937_, VALA_TYPE_FIELD);
			}
			_tmp1927_ = _tmp1931_;
		} else {
			_tmp1927_ = FALSE;
		}
		if (_tmp1927_) {
			ValaCCodeFunction* _tmp1938_;
			ValaCCodeFunction* _tmp1939_;
			ValaMemberAccess* _tmp1940_;
			ValaExpression* _tmp1941_;
			ValaExpression* _tmp1942_;
			ValaTargetValue* _tmp1943_;
			ValaTargetValue* _tmp1944_;
			ValaCCodeExpression* _tmp1945_;
			ValaCCodeExpression* _tmp1946_;
			ValaCCodeExpression* _tmp1947_;
			_tmp1938_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1939_ = _tmp1938_;
			_tmp1940_ = ma;
			_tmp1941_ = vala_member_access_get_inner (_tmp1940_);
			_tmp1942_ = _tmp1941_;
			_tmp1943_ = vala_expression_get_target_value (_tmp1942_);
			_tmp1944_ = _tmp1943_;
			_tmp1945_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp1944_);
			_tmp1946_ = _tmp1945_;
			_tmp1947_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1939_, _tmp1946_, _tmp1947_);
			_vala_ccode_node_unref0 (_tmp1946_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1949_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1950_ = _tmp1949_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1950_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1951_;
		ValaDataType* _tmp1952_;
		_tmp1951_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1952_ = _tmp1951_;
		_tmp1948_ = !vala_data_type_is_disposable (_tmp1952_);
	} else {
		_tmp1948_ = FALSE;
	}
	if (_tmp1948_) {
		gboolean _tmp1953_ = FALSE;
		ValaCCodeExpression* _tmp1954_;
		_tmp1954_ = ccall_expr;
		if (_tmp1954_ != NULL) {
			gboolean _tmp1955_;
			_tmp1955_ = return_result_via_out_param;
			_tmp1953_ = !_tmp1955_;
		} else {
			_tmp1953_ = FALSE;
		}
		if (_tmp1953_) {
			ValaCCodeFunction* _tmp1956_;
			ValaCCodeFunction* _tmp1957_;
			ValaCCodeExpression* _tmp1958_;
			_tmp1956_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1957_ = _tmp1956_;
			_tmp1958_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1957_, _tmp1958_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1959_;
		ValaDataType* _tmp1960_;
		gboolean _tmp1961_ = FALSE;
		ValaDataType* _tmp1962_;
		ValaDataType* _tmp1963_;
		gboolean _tmp1990_ = FALSE;
		ValaMethod* _tmp1991_;
		_tmp1959_ = itype;
		_tmp1960_ = vala_data_type_get_return_type (_tmp1959_);
		result_type = _tmp1960_;
		_tmp1962_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1963_ = _tmp1962_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1963_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1964_;
			ValaDataType* _tmp1965_;
			_tmp1964_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1965_ = _tmp1964_;
			_tmp1961_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1965_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1961_ = FALSE;
		}
		if (_tmp1961_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1966_;
			ValaDataType* _tmp1967_;
			ValaTypeParameter* _tmp1968_;
			ValaTypeParameter* _tmp1969_;
			ValaTypeParameter* _tmp1970_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1971_;
			ValaSymbol* _tmp1972_;
			ValaSymbol* _tmp1973_;
			ValaSymbol* _tmp1974_;
			ValaSymbol* _tmp1975_;
			ValaStruct* _tmp1976_;
			gboolean _tmp1977_ = FALSE;
			ValaTypeParameter* _tmp1978_;
			ValaSymbol* _tmp1979_;
			ValaSymbol* _tmp1980_;
			ValaTypeSymbol* _tmp1981_;
			_tmp1966_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1967_ = _tmp1966_;
			_tmp1968_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1967_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1969_ = _tmp1968_;
			_tmp1970_ = _vala_code_node_ref0 (_tmp1969_);
			type_parameter = _tmp1970_;
			_tmp1971_ = type_parameter;
			_tmp1972_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1971_);
			_tmp1973_ = _tmp1972_;
			_tmp1974_ = vala_symbol_get_parent_symbol (_tmp1973_);
			_tmp1975_ = _tmp1974_;
			_tmp1976_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1975_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1975_) : NULL);
			st = _tmp1976_;
			_tmp1978_ = type_parameter;
			_tmp1979_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1978_);
			_tmp1980_ = _tmp1979_;
			_tmp1981_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1980_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1981_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1977_ = TRUE;
			} else {
				gboolean _tmp1982_ = FALSE;
				ValaStruct* _tmp1983_;
				_tmp1983_ = st;
				if (_tmp1983_ != NULL) {
					ValaStruct* _tmp1984_;
					gchar* _tmp1985_;
					gchar* _tmp1986_;
					_tmp1984_ = st;
					_tmp1985_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1984_);
					_tmp1986_ = _tmp1985_;
					_tmp1982_ = g_strcmp0 (_tmp1986_, "va_list") == 0;
					_g_free0 (_tmp1986_);
				} else {
					_tmp1982_ = FALSE;
				}
				_tmp1977_ = _tmp1982_;
			}
			if (_tmp1977_) {
				ValaDataType* _tmp1987_;
				ValaDataType* _tmp1988_;
				ValaDataType* _tmp1989_;
				_tmp1987_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp1988_ = _tmp1987_;
				_tmp1989_ = _vala_code_node_ref0 (_tmp1988_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp1989_;
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp1991_ = m;
		if (_tmp1991_ != NULL) {
			ValaMethod* _tmp1992_;
			_tmp1992_ = m;
			_tmp1990_ = vala_method_get_format_arg_index (_tmp1992_) >= 0;
		} else {
			_tmp1990_ = FALSE;
		}
		if (_tmp1990_) {
			ValaCCodeExpression* _tmp1993_;
			_tmp1993_ = ccall_expr;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1993_);
		} else {
			gboolean _tmp1994_ = FALSE;
			ValaMethod* _tmp1995_;
			_tmp1995_ = m;
			if (_tmp1995_ != NULL) {
				ValaMethod* _tmp1996_;
				_tmp1996_ = m;
				_tmp1994_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp1996_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp1994_ = FALSE;
			}
			if (_tmp1994_) {
				ValaCCodeExpression* _tmp1997_;
				_tmp1997_ = ccall_expr;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1997_);
			} else {
				gboolean _tmp1998_ = FALSE;
				gboolean _tmp1999_ = FALSE;
				gboolean _tmp2000_;
				_tmp2000_ = return_result_via_out_param;
				if (!_tmp2000_) {
					gboolean _tmp2001_ = FALSE;
					gboolean _tmp2002_ = FALSE;
					ValaMethod* _tmp2003_;
					_tmp2003_ = m;
					if (_tmp2003_ != NULL) {
						ValaMethod* _tmp2004_;
						_tmp2004_ = m;
						_tmp2002_ = !vala_ccode_method_call_module_has_ref_out_param (self, (ValaCallable*) _tmp2004_);
					} else {
						_tmp2002_ = FALSE;
					}
					if (_tmp2002_) {
						_tmp2001_ = TRUE;
					} else {
						gboolean _tmp2005_ = FALSE;
						ValaDelegate* _tmp2006_;
						_tmp2006_ = deleg;
						if (_tmp2006_ != NULL) {
							ValaDelegate* _tmp2007_;
							_tmp2007_ = deleg;
							_tmp2005_ = !vala_ccode_method_call_module_has_ref_out_param (self, (ValaCallable*) _tmp2007_);
						} else {
							_tmp2005_ = FALSE;
						}
						_tmp2001_ = _tmp2005_;
					}
					_tmp1999_ = _tmp2001_;
				} else {
					_tmp1999_ = FALSE;
				}
				if (_tmp1999_) {
					gboolean _tmp2008_ = FALSE;
					ValaDataType* _tmp2009_;
					_tmp2009_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2009_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp2010_;
						_tmp2010_ = result_type;
						_tmp2008_ = !vala_data_type_is_disposable (_tmp2010_);
					} else {
						_tmp2008_ = FALSE;
					}
					_tmp1998_ = _tmp2008_;
				} else {
					_tmp1998_ = FALSE;
				}
				if (_tmp1998_) {
					ValaCCodeExpression* _tmp2011_;
					_tmp2011_ = ccall_expr;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2011_);
				} else {
					gboolean _tmp2012_;
					_tmp2012_ = return_result_via_out_param;
					if (!_tmp2012_) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp2013_;
						ValaDataType* _tmp2014_;
						gboolean _tmp2015_;
						gboolean _tmp2016_;
						ValaLocalVariable* _tmp2017_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp2018_;
						const gchar* _tmp2019_;
						const gchar* _tmp2020_;
						ValaCCodeExpression* _tmp2021_;
						ValaLocalVariable* _tmp2022_;
						ValaCCodeFunction* _tmp2023_;
						ValaCCodeFunction* _tmp2024_;
						ValaCCodeExpression* _tmp2025_;
						ValaCCodeExpression* _tmp2026_;
						ValaCCodeExpression* _tmp2027_;
						ValaTargetValue* _tmp2028_;
						ValaTargetValue* _tmp2029_;
						_tmp2013_ = result_type;
						_tmp2014_ = result_type;
						_tmp2015_ = vala_data_type_get_value_owned (_tmp2014_);
						_tmp2016_ = _tmp2015_;
						_tmp2017_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2013_, _tmp2016_, NULL, FALSE);
						temp_var = _tmp2017_;
						_tmp2018_ = temp_var;
						_tmp2019_ = vala_symbol_get_name ((ValaSymbol*) _tmp2018_);
						_tmp2020_ = _tmp2019_;
						_tmp2021_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2020_);
						temp_ref = _tmp2021_;
						_tmp2022_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2022_, FALSE);
						_tmp2023_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2024_ = _tmp2023_;
						_tmp2025_ = temp_ref;
						_tmp2026_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp2024_, _tmp2025_, _tmp2026_);
						_tmp2027_ = temp_ref;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2027_);
						_tmp2028_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2029_ = _tmp2028_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2029_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp2030_;
						ValaTargetValue* _tmp2031_;
						ValaTargetValue* _tmp2032_;
						_tmp2030_ = ccall_expr;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2030_);
						_tmp2031_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2032_ = _tmp2031_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2032_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp2033_ = params;
	_tmp2034_ = vala_iterable_iterator ((ValaIterable*) _tmp2033_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp2034_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2035_;
		gint _arg_size = 0;
		ValaList* _tmp2036_;
		gint _tmp2037_;
		gint _tmp2038_;
		gint _arg_index = 0;
		_tmp2035_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp2035_;
		_tmp2036_ = _arg_list;
		_tmp2037_ = vala_collection_get_size ((ValaCollection*) _tmp2036_);
		_tmp2038_ = _tmp2037_;
		_arg_size = _tmp2038_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp2039_;
			gint _tmp2040_;
			gint _tmp2041_;
			ValaExpression* arg = NULL;
			ValaList* _tmp2042_;
			gint _tmp2043_;
			gpointer _tmp2044_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2045_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2055_;
			ValaUnaryExpression* _tmp2056_;
			gboolean _tmp2057_ = FALSE;
			ValaUnaryExpression* _tmp2058_;
			ValaUnaryExpression* _tmp2062_;
			ValaExpression* _tmp2063_;
			ValaExpression* _tmp2064_;
			ValaDataType* _tmp2065_;
			ValaDataType* _tmp2066_;
			ValaUnaryExpression* _tmp2076_;
			ValaExpression* _tmp2077_;
			ValaExpression* _tmp2078_;
			ValaTargetValue* _tmp2079_;
			ValaTargetValue* _tmp2080_;
			ValaUnaryExpression* _tmp2081_;
			ValaTargetValue* _tmp2082_;
			ValaTargetValue* _tmp2083_;
			ValaUnaryExpression* _tmp2084_;
			ValaExpression* _tmp2085_;
			ValaExpression* _tmp2086_;
			ValaDataType* _tmp2087_;
			ValaDataType* _tmp2088_;
			ValaExpression* _tmp2089_;
			ValaTargetValue* _tmp2090_;
			ValaTargetValue* _tmp2091_;
			ValaSourceReference* _tmp2092_;
			ValaSourceReference* _tmp2093_;
			gboolean _tmp2094_ = FALSE;
			ValaParameter* _tmp2095_;
			_tmp2039_ = _arg_index;
			_arg_index = _tmp2039_ + 1;
			_tmp2040_ = _arg_index;
			_tmp2041_ = _arg_size;
			if (!(_tmp2040_ < _tmp2041_)) {
				break;
			}
			_tmp2042_ = _arg_list;
			_tmp2043_ = _arg_index;
			_tmp2044_ = vala_list_get (_tmp2042_, _tmp2043_);
			arg = (ValaExpression*) _tmp2044_;
			param = NULL;
			_tmp2045_ = params_it;
			if (vala_iterator_next (_tmp2045_)) {
				ValaIterator* _tmp2046_;
				gpointer _tmp2047_;
				gboolean _tmp2048_ = FALSE;
				ValaParameter* _tmp2049_;
				gboolean _tmp2050_;
				gboolean _tmp2051_;
				_tmp2046_ = params_it;
				_tmp2047_ = vala_iterator_get (_tmp2046_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2047_;
				_tmp2049_ = param;
				_tmp2050_ = vala_parameter_get_params_array (_tmp2049_);
				_tmp2051_ = _tmp2050_;
				if (_tmp2051_) {
					_tmp2048_ = TRUE;
				} else {
					ValaParameter* _tmp2052_;
					gboolean _tmp2053_;
					gboolean _tmp2054_;
					_tmp2052_ = param;
					_tmp2053_ = vala_parameter_get_ellipsis (_tmp2052_);
					_tmp2054_ = _tmp2053_;
					_tmp2048_ = _tmp2054_;
				}
				if (_tmp2048_) {
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (arg);
					break;
				}
			}
			_tmp2055_ = arg;
			_tmp2056_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2055_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2055_) : NULL);
			unary = _tmp2056_;
			_tmp2058_ = unary;
			if (_tmp2058_ == NULL) {
				_tmp2057_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2059_;
				ValaUnaryOperator _tmp2060_;
				ValaUnaryOperator _tmp2061_;
				_tmp2059_ = unary;
				_tmp2060_ = vala_unary_expression_get_operator (_tmp2059_);
				_tmp2061_ = _tmp2060_;
				_tmp2057_ = _tmp2061_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2057_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2062_ = unary;
			_tmp2063_ = vala_unary_expression_get_inner (_tmp2062_);
			_tmp2064_ = _tmp2063_;
			_tmp2065_ = vala_expression_get_value_type (_tmp2064_);
			_tmp2066_ = _tmp2065_;
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, _tmp2066_)) {
				ValaCCodeFunction* _tmp2067_;
				ValaCCodeFunction* _tmp2068_;
				ValaUnaryExpression* _tmp2069_;
				ValaExpression* _tmp2070_;
				ValaExpression* _tmp2071_;
				ValaTargetValue* _tmp2072_;
				ValaTargetValue* _tmp2073_;
				ValaCCodeExpression* _tmp2074_;
				ValaCCodeExpression* _tmp2075_;
				_tmp2067_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2068_ = _tmp2067_;
				_tmp2069_ = unary;
				_tmp2070_ = vala_unary_expression_get_inner (_tmp2069_);
				_tmp2071_ = _tmp2070_;
				_tmp2072_ = vala_expression_get_target_value (_tmp2071_);
				_tmp2073_ = _tmp2072_;
				_tmp2074_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2073_, FALSE);
				_tmp2075_ = _tmp2074_;
				vala_ccode_function_add_expression (_tmp2068_, _tmp2075_);
				_vala_ccode_node_unref0 (_tmp2075_);
			}
			_tmp2076_ = unary;
			_tmp2077_ = vala_unary_expression_get_inner (_tmp2076_);
			_tmp2078_ = _tmp2077_;
			_tmp2079_ = vala_expression_get_target_value (_tmp2078_);
			_tmp2080_ = _tmp2079_;
			_tmp2081_ = unary;
			_tmp2082_ = vala_expression_get_target_value ((ValaExpression*) _tmp2081_);
			_tmp2083_ = _tmp2082_;
			_tmp2084_ = unary;
			_tmp2085_ = vala_unary_expression_get_inner (_tmp2084_);
			_tmp2086_ = _tmp2085_;
			_tmp2087_ = vala_expression_get_value_type (_tmp2086_);
			_tmp2088_ = _tmp2087_;
			_tmp2089_ = arg;
			_tmp2090_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2083_, _tmp2088_, (ValaCodeNode*) _tmp2089_);
			_tmp2091_ = _tmp2090_;
			_tmp2092_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2093_ = _tmp2092_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2080_, _tmp2091_, _tmp2093_);
			_vala_target_value_unref0 (_tmp2091_);
			_tmp2095_ = param;
			if (_tmp2095_ != NULL) {
				ValaParameter* _tmp2096_;
				_tmp2096_ = param;
				_tmp2094_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2096_);
			} else {
				_tmp2094_ = FALSE;
			}
			if (_tmp2094_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2097_;
				ValaCCodeIdentifier* _tmp2098_;
				ValaCCodeFunctionCall* _tmp2099_;
				ValaCCodeFunctionCall* _tmp2100_;
				ValaCCodeFunctionCall* _tmp2101_;
				ValaUnaryExpression* _tmp2102_;
				ValaExpression* _tmp2103_;
				ValaExpression* _tmp2104_;
				ValaTargetValue* _tmp2105_;
				ValaTargetValue* _tmp2106_;
				ValaCCodeExpression* _tmp2107_;
				ValaCCodeExpression* _tmp2108_;
				ValaCCodeFunction* _tmp2109_;
				ValaCCodeFunction* _tmp2110_;
				ValaUnaryExpression* _tmp2111_;
				ValaExpression* _tmp2112_;
				ValaExpression* _tmp2113_;
				ValaTargetValue* _tmp2114_;
				ValaTargetValue* _tmp2115_;
				ValaCCodeExpression* _tmp2116_;
				ValaCCodeExpression* _tmp2117_;
				ValaCCodeFunctionCall* _tmp2118_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2097_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2098_ = _tmp2097_;
				_tmp2099_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2098_);
				_tmp2100_ = _tmp2099_;
				_vala_ccode_node_unref0 (_tmp2098_);
				len_call = _tmp2100_;
				_tmp2101_ = len_call;
				_tmp2102_ = unary;
				_tmp2103_ = vala_unary_expression_get_inner (_tmp2102_);
				_tmp2104_ = _tmp2103_;
				_tmp2105_ = vala_expression_get_target_value (_tmp2104_);
				_tmp2106_ = _tmp2105_;
				_tmp2107_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp2106_);
				_tmp2108_ = _tmp2107_;
				vala_ccode_function_call_add_argument (_tmp2101_, _tmp2108_);
				_vala_ccode_node_unref0 (_tmp2108_);
				_tmp2109_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2110_ = _tmp2109_;
				_tmp2111_ = unary;
				_tmp2112_ = vala_unary_expression_get_inner (_tmp2111_);
				_tmp2113_ = _tmp2112_;
				_tmp2114_ = vala_expression_get_target_value (_tmp2113_);
				_tmp2115_ = _tmp2114_;
				_tmp2116_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2115_, 1);
				_tmp2117_ = _tmp2116_;
				_tmp2118_ = len_call;
				vala_ccode_function_add_assignment (_tmp2110_, _tmp2117_, (ValaCCodeExpression*) _tmp2118_);
				_vala_ccode_node_unref0 (_tmp2117_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2121_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2121_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2122_;
		ValaSymbol* _tmp2123_;
		ValaSymbol* _tmp2124_;
		_tmp2122_ = m;
		_tmp2123_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2122_);
		_tmp2124_ = _tmp2123_;
		_tmp2120_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2124_, VALA_TYPE_CLASS);
	} else {
		_tmp2120_ = FALSE;
	}
	if (_tmp2120_) {
		gboolean _tmp2125_ = FALSE;
		gboolean _tmp2126_ = FALSE;
		ValaClass* _tmp2127_;
		ValaClass* _tmp2128_;
		gboolean _tmp2129_;
		gboolean _tmp2130_;
		_tmp2127_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2128_ = _tmp2127_;
		_tmp2129_ = vala_class_get_is_compact (_tmp2128_);
		_tmp2130_ = _tmp2129_;
		if (_tmp2130_) {
			ValaClass* _tmp2131_;
			ValaClass* _tmp2132_;
			ValaClass* _tmp2133_;
			ValaClass* _tmp2134_;
			_tmp2131_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2132_ = _tmp2131_;
			_tmp2133_ = vala_class_get_base_class (_tmp2132_);
			_tmp2134_ = _tmp2133_;
			_tmp2126_ = _tmp2134_ != NULL;
		} else {
			_tmp2126_ = FALSE;
		}
		if (_tmp2126_) {
			_tmp2125_ = TRUE;
		} else {
			ValaClass* _tmp2135_;
			ValaClass* _tmp2136_;
			ValaClass* _tmp2137_;
			ValaClass* _tmp2138_;
			ValaClass* _tmp2139_;
			_tmp2135_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2136_ = _tmp2135_;
			_tmp2137_ = vala_class_get_base_class (_tmp2136_);
			_tmp2138_ = _tmp2137_;
			_tmp2139_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2125_ = _tmp2138_ == _tmp2139_;
		}
		_tmp2119_ = _tmp2125_;
	} else {
		_tmp2119_ = FALSE;
	}
	if (_tmp2119_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2140_;
		ValaClass* _tmp2141_;
		gchar* _tmp2142_;
		gchar* _tmp2143_;
		gchar* _tmp2144_;
		gchar* _tmp2145_;
		ValaCCodeIdentifier* _tmp2146_;
		ValaCCodeIdentifier* _tmp2147_;
		ValaCCodeFunctionCall* _tmp2148_;
		ValaCCodeFunctionCall* _tmp2149_;
		ValaCCodeFunctionCall* _tmp2150_;
		ValaCCodeExpression* _tmp2151_;
		ValaCCodeExpression* _tmp2152_;
		ValaCCodeFunction* _tmp2153_;
		ValaCCodeFunction* _tmp2154_;
		ValaCCodeFunctionCall* _tmp2155_;
		_tmp2140_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2141_ = _tmp2140_;
		_tmp2142_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2141_, NULL);
		_tmp2143_ = _tmp2142_;
		_tmp2144_ = g_strdup_printf ("%s_instance_init", _tmp2143_);
		_tmp2145_ = _tmp2144_;
		_tmp2146_ = vala_ccode_identifier_new (_tmp2145_);
		_tmp2147_ = _tmp2146_;
		_tmp2148_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2147_);
		_tmp2149_ = _tmp2148_;
		_vala_ccode_node_unref0 (_tmp2147_);
		_g_free0 (_tmp2145_);
		_g_free0 (_tmp2143_);
		cinitcall = _tmp2149_;
		_tmp2150_ = cinitcall;
		_tmp2151_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2152_ = _tmp2151_;
		vala_ccode_function_call_add_argument (_tmp2150_, _tmp2152_);
		_vala_ccode_node_unref0 (_tmp2152_);
		_tmp2153_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2154_ = _tmp2153_;
		_tmp2155_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2154_, (ValaCCodeExpression*) _tmp2155_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}


static gchar*
vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                               ValaEnum* en)
{
	gchar* result = NULL;
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeFunction* _tmp49_;
	ValaCCodeFunction* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	ValaCCodeConstant* _tmp52_;
	ValaCCodeConstant* _tmp53_;
	ValaCCodeFile* _tmp54_;
	ValaCCodeFunction* _tmp55_;
	ValaCCodeFile* _tmp56_;
	ValaCCodeFunction* _tmp57_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			ValaCCodeFunction* _tmp30_;
			ValaCCodeFunction* _tmp31_;
			ValaEnumValue* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			ValaCCodeIdentifier* _tmp35_;
			ValaCCodeIdentifier* _tmp36_;
			ValaCCodeFunction* _tmp37_;
			ValaCCodeFunction* _tmp38_;
			ValaEnumValue* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ValaCCodeConstant* _tmp46_;
			ValaCCodeConstant* _tmp47_;
			_tmp24_ = _enum_value_index;
			_enum_value_index = _tmp24_ + 1;
			_tmp25_ = _enum_value_index;
			_tmp26_ = _enum_value_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _enum_value_list;
			_tmp28_ = _enum_value_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			enum_value = (ValaEnumValue*) _tmp29_;
			_tmp30_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp31_ = _tmp30_;
			_tmp32_ = enum_value;
			_tmp33_ = vala_get_ccode_name ((ValaCodeNode*) _tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_ccode_identifier_new (_tmp34_);
			_tmp36_ = _tmp35_;
			vala_ccode_function_add_case (_tmp31_, (ValaCCodeExpression*) _tmp36_);
			_vala_ccode_node_unref0 (_tmp36_);
			_g_free0 (_tmp34_);
			_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp38_ = _tmp37_;
			_tmp39_ = enum_value;
			_tmp40_ = vala_get_ccode_name ((ValaCodeNode*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat ("\"", _tmp41_, NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strconcat (_tmp43_, "\"", NULL);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_ccode_constant_new (_tmp45_);
			_tmp47_ = _tmp46_;
			vala_ccode_function_add_return (_tmp38_, (ValaCCodeExpression*) _tmp47_);
			_vala_ccode_node_unref0 (_tmp47_);
			_g_free0 (_tmp45_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp48_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp49_ = _tmp48_;
	vala_ccode_function_close (_tmp49_);
	_tmp50_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_ccode_constant_new ("NULL");
	_tmp53_ = _tmp52_;
	vala_ccode_function_add_return (_tmp51_, (ValaCCodeExpression*) _tmp53_);
	_vala_ccode_node_unref0 (_tmp53_);
	_tmp54_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp55_ = function;
	vala_ccode_file_add_function_declaration (_tmp54_, _tmp55_);
	_tmp56_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp57_ = function;
	vala_ccode_file_add_function (_tmp56_, _tmp57_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}


static gboolean
vala_ccode_method_call_module_has_ref_out_param (ValaCCodeMethodCallModule* self,
                                                 ValaCallable* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters (c);
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaParameter* _tmp10_;
			ValaParameterDirection _tmp11_;
			ValaParameterDirection _tmp12_;
			_tmp4_ = _param_index;
			_param_index = _tmp4_ + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = _param_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			param = (ValaParameter*) _tmp9_;
			_tmp10_ = param;
			_tmp11_ = vala_parameter_get_direction (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ != VALA_PARAMETER_DIRECTION_IN) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = FALSE;
	return result;
}


static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	gchar* result = NULL;
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* va_start = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp37_;
	ValaCCodeIdentifier* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	ValaCCodeFunctionCall* _tmp40_;
	ValaCCodeFunctionCall* _tmp41_;
	ValaCCodeConstant* _tmp42_;
	ValaCCodeConstant* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeConstant* _tmp45_;
	ValaCCodeConstant* _tmp46_;
	ValaCCodeFunctionCall* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeIdentifier* _tmp49_;
	ValaCCodeFunctionCall* _tmp50_;
	ValaCCodeIdentifier* _tmp51_;
	ValaCCodeIdentifier* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	ValaCCodeFunction* _tmp54_;
	ValaCCodeIdentifier* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeFunctionCall* _tmp57_;
	ValaCCodeConstant* _tmp58_;
	ValaCCodeConstant* _tmp59_;
	ValaCCodeBinaryExpression* _tmp60_;
	ValaCCodeBinaryExpression* _tmp61_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp62_;
	ValaCCodeIdentifier* _tmp63_;
	ValaCCodeFunctionCall* _tmp64_;
	ValaCCodeFunctionCall* _tmp65_;
	ValaCCodeFunctionCall* _tmp66_;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunction* _tmp69_;
	ValaCCodeFunction* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunctionCall* _tmp74_;
	ValaCCodeFunctionCall* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunction* _tmp79_;
	ValaCCodeFunction* _tmp80_;
	ValaCCodeIdentifier* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeFunctionCall* _tmp83_;
	ValaCCodeIdentifier* _tmp84_;
	ValaCCodeIdentifier* _tmp85_;
	ValaCCodeFunctionCall* _tmp86_;
	ValaCCodeFunctionCall* _tmp87_;
	ValaCCodeIdentifier* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeFunctionCall* _tmp90_;
	ValaCCodeIdentifier* _tmp91_;
	ValaCCodeIdentifier* _tmp92_;
	ValaCCodeFunction* _tmp93_;
	ValaCCodeFunction* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunctionCall* _tmp98_;
	ValaCCodeFunctionCall* _tmp99_;
	ValaCCodeIdentifier* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeFunctionCall* _tmp102_;
	ValaCCodeIdentifier* _tmp103_;
	ValaCCodeIdentifier* _tmp104_;
	ValaCCodeFunctionCall* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeIdentifier* _tmp107_;
	ValaCCodeFunctionCall* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeIdentifier* _tmp110_;
	ValaCCodeFunction* _tmp111_;
	ValaCCodeFunction* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunctionCall* _tmp116_;
	ValaCCodeFunctionCall* _tmp117_;
	ValaCCodeIdentifier* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeFunction* _tmp120_;
	ValaCCodeFunction* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeFunction* _tmp123_;
	ValaCCodeFunction* _tmp124_;
	ValaCCodeIdentifier* _tmp125_;
	ValaCCodeIdentifier* _tmp126_;
	ValaCCodeFile* _tmp127_;
	ValaCCodeFile* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeFile* _tmp130_;
	ValaCCodeFunction* _tmp131_;
	gchar* _tmp132_;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	va_start = _tmp27_;
	_tmp28_ = va_start;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = va_start;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = va_start;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp38_);
	_tmp40_ = _tmp39_;
	_vala_ccode_node_unref0 (_tmp38_);
	vsnprintf = _tmp40_;
	_tmp41_ = vsnprintf;
	_tmp42_ = vala_ccode_constant_new ("NULL");
	_tmp43_ = _tmp42_;
	vala_ccode_function_call_add_argument (_tmp41_, (ValaCCodeExpression*) _tmp43_);
	_vala_ccode_node_unref0 (_tmp43_);
	_tmp44_ = vsnprintf;
	_tmp45_ = vala_ccode_constant_new ("0");
	_tmp46_ = _tmp45_;
	vala_ccode_function_call_add_argument (_tmp44_, (ValaCCodeExpression*) _tmp46_);
	_vala_ccode_node_unref0 (_tmp46_);
	_tmp47_ = vsnprintf;
	_tmp48_ = vala_ccode_identifier_new ("format");
	_tmp49_ = _tmp48_;
	vala_ccode_function_call_add_argument (_tmp47_, (ValaCCodeExpression*) _tmp49_);
	_vala_ccode_node_unref0 (_tmp49_);
	_tmp50_ = vsnprintf;
	_tmp51_ = vala_ccode_identifier_new ("ap");
	_tmp52_ = _tmp51_;
	vala_ccode_function_call_add_argument (_tmp50_, (ValaCCodeExpression*) _tmp52_);
	_vala_ccode_node_unref0 (_tmp52_);
	_tmp53_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_ccode_identifier_new ("length");
	_tmp56_ = _tmp55_;
	_tmp57_ = vsnprintf;
	_tmp58_ = vala_ccode_constant_new ("1");
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp57_, (ValaCCodeExpression*) _tmp59_);
	_tmp61_ = _tmp60_;
	vala_ccode_function_add_assignment (_tmp54_, (ValaCCodeExpression*) _tmp56_, (ValaCCodeExpression*) _tmp61_);
	_vala_ccode_node_unref0 (_tmp61_);
	_vala_ccode_node_unref0 (_tmp59_);
	_vala_ccode_node_unref0 (_tmp56_);
	_tmp62_ = vala_ccode_identifier_new ("va_end");
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp63_);
	_tmp65_ = _tmp64_;
	_vala_ccode_node_unref0 (_tmp63_);
	va_end = _tmp65_;
	_tmp66_ = va_end;
	_tmp67_ = vala_ccode_identifier_new ("ap");
	_tmp68_ = _tmp67_;
	vala_ccode_function_call_add_argument (_tmp66_, (ValaCCodeExpression*) _tmp68_);
	_vala_ccode_node_unref0 (_tmp68_);
	_tmp69_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp70_ = _tmp69_;
	_tmp71_ = va_end;
	vala_ccode_function_add_expression (_tmp70_, (ValaCCodeExpression*) _tmp71_);
	_tmp72_ = vala_ccode_identifier_new ("malloc");
	_tmp73_ = _tmp72_;
	_tmp74_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp73_);
	_tmp75_ = _tmp74_;
	_vala_ccode_node_unref0 (_tmp73_);
	malloc = _tmp75_;
	_tmp76_ = malloc;
	_tmp77_ = vala_ccode_identifier_new ("length");
	_tmp78_ = _tmp77_;
	vala_ccode_function_call_add_argument (_tmp76_, (ValaCCodeExpression*) _tmp78_);
	_vala_ccode_node_unref0 (_tmp78_);
	_tmp79_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_ccode_identifier_new ("result");
	_tmp82_ = _tmp81_;
	_tmp83_ = malloc;
	vala_ccode_function_add_assignment (_tmp80_, (ValaCCodeExpression*) _tmp82_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp82_);
	_tmp84_ = vala_ccode_identifier_new ("va_start");
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp85_);
	_vala_ccode_node_unref0 (va_start);
	va_start = _tmp86_;
	_vala_ccode_node_unref0 (_tmp85_);
	_tmp87_ = va_start;
	_tmp88_ = vala_ccode_identifier_new ("ap");
	_tmp89_ = _tmp88_;
	vala_ccode_function_call_add_argument (_tmp87_, (ValaCCodeExpression*) _tmp89_);
	_vala_ccode_node_unref0 (_tmp89_);
	_tmp90_ = va_start;
	_tmp91_ = vala_ccode_identifier_new ("format");
	_tmp92_ = _tmp91_;
	vala_ccode_function_call_add_argument (_tmp90_, (ValaCCodeExpression*) _tmp92_);
	_vala_ccode_node_unref0 (_tmp92_);
	_tmp93_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp94_ = _tmp93_;
	_tmp95_ = va_start;
	vala_ccode_function_add_expression (_tmp94_, (ValaCCodeExpression*) _tmp95_);
	_tmp96_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp97_ = _tmp96_;
	_tmp98_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp98_;
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp99_ = vsnprintf;
	_tmp100_ = vala_ccode_identifier_new ("result");
	_tmp101_ = _tmp100_;
	vala_ccode_function_call_add_argument (_tmp99_, (ValaCCodeExpression*) _tmp101_);
	_vala_ccode_node_unref0 (_tmp101_);
	_tmp102_ = vsnprintf;
	_tmp103_ = vala_ccode_identifier_new ("length");
	_tmp104_ = _tmp103_;
	vala_ccode_function_call_add_argument (_tmp102_, (ValaCCodeExpression*) _tmp104_);
	_vala_ccode_node_unref0 (_tmp104_);
	_tmp105_ = vsnprintf;
	_tmp106_ = vala_ccode_identifier_new ("format");
	_tmp107_ = _tmp106_;
	vala_ccode_function_call_add_argument (_tmp105_, (ValaCCodeExpression*) _tmp107_);
	_vala_ccode_node_unref0 (_tmp107_);
	_tmp108_ = vsnprintf;
	_tmp109_ = vala_ccode_identifier_new ("ap");
	_tmp110_ = _tmp109_;
	vala_ccode_function_call_add_argument (_tmp108_, (ValaCCodeExpression*) _tmp110_);
	_vala_ccode_node_unref0 (_tmp110_);
	_tmp111_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp112_ = _tmp111_;
	_tmp113_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp112_, (ValaCCodeExpression*) _tmp113_);
	_tmp114_ = vala_ccode_identifier_new ("va_end");
	_tmp115_ = _tmp114_;
	_tmp116_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp116_;
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp117_ = va_end;
	_tmp118_ = vala_ccode_identifier_new ("ap");
	_tmp119_ = _tmp118_;
	vala_ccode_function_call_add_argument (_tmp117_, (ValaCCodeExpression*) _tmp119_);
	_vala_ccode_node_unref0 (_tmp119_);
	_tmp120_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp121_ = _tmp120_;
	_tmp122_ = va_end;
	vala_ccode_function_add_expression (_tmp121_, (ValaCCodeExpression*) _tmp122_);
	_tmp123_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp124_ = _tmp123_;
	_tmp125_ = vala_ccode_identifier_new ("result");
	_tmp126_ = _tmp125_;
	vala_ccode_function_add_return (_tmp124_, (ValaCCodeExpression*) _tmp126_);
	_vala_ccode_node_unref0 (_tmp126_);
	_tmp127_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp127_, "stdarg.h", FALSE);
	_tmp128_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp129_ = function;
	vala_ccode_file_add_function_declaration (_tmp128_, _tmp129_);
	_tmp130_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp131_ = function;
	vala_ccode_file_add_function (_tmp130_, _tmp131_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp132_ = g_strdup ("string_printf");
	result = _tmp132_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (va_start);
	_vala_ccode_node_unref0 (function);
	return result;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}


static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor *, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}


static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self)
{
}


GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



