/* libepc-1.0.vapi generated by vapigen, do not modify. */

namespace Epc {
	[CCode (cheader_filename = "libepc/publisher.h")]
	[Compact]
	public class AuthContext {
		public bool check_password (string password);
		public unowned string get_key ();
		public unowned string get_password ();
		public unowned Epc.Publisher get_publisher ();
	}
	[CCode (cheader_filename = "libepc/consumer.h")]
	public class Consumer : GLib.Object {
		[CCode (has_construct_function = false)]
		public Consumer (Epc.ServiceInfo service);
		[CCode (has_construct_function = false)]
		public Consumer.for_name (string name);
		[CCode (has_construct_function = false)]
		public Consumer.for_name_full (string name, string application, string domain);
		public unowned string get_password ();
		public Epc.Protocol get_protocol ();
		public unowned string get_username ();
		public bool is_publisher_resolved ();
		public unowned GLib.List list (string pattern) throws GLib.Error;
		public void* lookup (string key, out unowned size_t? length) throws GLib.Error;
		public bool resolve_publisher (uint timeout);
		public void set_password (string password);
		public void set_protocol (Epc.Protocol protocol);
		public void set_username (string username);
		[NoAccessorMethod]
		public string application { owned get; construct; }
		[NoAccessorMethod]
		public string domain { owned get; construct; }
		[NoAccessorMethod]
		public string hostname { owned get; construct; }
		[NoAccessorMethod]
		public string name { owned get; construct; }
		public string password { get; set construct; }
		[NoAccessorMethod]
		public string path { owned get; construct; }
		[NoAccessorMethod]
		public int port { get; construct; }
		public Epc.Protocol protocol { get; set construct; }
		public string username { get; set construct; }
		public virtual signal bool authenticate (string realm);
		public virtual signal void publisher_resolved (Epc.Protocol protocol, string hostname, uint port);
	}
	[CCode (cheader_filename = "libepc/contents.h", ref_function = "epc_contents_ref", unref_function = "epc_contents_unref")]
	[Compact]
	public class Contents {
		[CCode (has_construct_function = false)]
		public Contents (string type, void* data, ssize_t length, GLib.DestroyNotify destroy_data);
		[CCode (has_construct_function = false)]
		public Contents.dup (string type, void* data, ssize_t length);
		public void* get_data (size_t length);
		public unowned string get_mime_type ();
		public bool is_stream ();
		public static unowned Epc.Contents stream_new (string type, Epc.ContentsReadFunc callback, GLib.DestroyNotify destroy_data);
		public void* stream_read (size_t length);
	}
	[CCode (cheader_filename = "libepc/dispatcher.h")]
	public class Dispatcher : GLib.Object {
		[CCode (has_construct_function = false)]
		public Dispatcher (string name);
		public void add_service (Epc.AddressFamily protocol, string type, string domain, string host, uint16 port);
		public void add_service_subtype (string type, string subtype);
		public Epc.CollisionHandling get_collision_handling ();
		public unowned string get_cookie ();
		public unowned string get_name ();
		public void reset ();
		public bool run () throws GLib.Error;
		public void set_collision_handling (Epc.CollisionHandling method);
		public void set_cookie (string cookie);
		public void set_name (string name);
		public void set_service_details (string type);
		public Epc.CollisionHandling collision_handling { get; set construct; }
		public string cookie { get; set construct; }
		public string name { get; set construct; }
	}
	[CCode (cheader_filename = "libepc/publisher.h")]
	public class Publisher : GLib.Object {
		[CCode (has_construct_function = false)]
		public Publisher (string? name, string application, string? domain);
		public void add (string key, void* data, ssize_t length);
		public void add_bookmark (string key, string label);
		public void add_file (string key, string filename);
		public void add_handler (string key, Epc.ContentsHandler handler, GLib.DestroyNotify destroy_data);
		public static unowned string expand_name (string name) throws GLib.Error;
		public Epc.AuthFlags get_auth_flags ();
		public unowned string get_certificate_file ();
		public Epc.CollisionHandling get_collision_handling ();
		public unowned string get_contents_path ();
		public unowned string get_path (string key);
		public unowned string get_private_key_file ();
		public Epc.Protocol get_protocol ();
		public unowned string get_service_cookie ();
		public unowned string get_service_domain ();
		public unowned string get_service_name ();
		public unowned string get_uri (string key) throws GLib.Error;
		public bool has_key (string key);
		public unowned GLib.List list (string pattern);
		public void* lookup (string key);
		public bool quit ();
		public bool remove (string key);
		public bool run () throws GLib.Error;
		public bool run_async () throws GLib.Error;
		public void set_auth_flags (Epc.AuthFlags flags);
		public void set_auth_handler (string key, Epc.AuthHandler handler, GLib.DestroyNotify destroy_data);
		public void set_collision_handling (Epc.CollisionHandling method);
		public void set_contents_path (string path);
		public void set_credentials (string certfile, string keyfile);
		public void set_protocol (Epc.Protocol protocol);
		public void set_service_cookie (string cookie);
		public void set_service_name (string name);
		[NoAccessorMethod]
		public string application { owned get; set construct; }
		public Epc.AuthFlags auth_flags { get; set construct; }
		[NoAccessorMethod]
		public string certificate_file { owned get; set construct; }
		public Epc.CollisionHandling collision_handling { get; set construct; }
		public string contents_path { get; set construct; }
		[NoAccessorMethod]
		public string private_key_file { owned get; set construct; }
		public Epc.Protocol protocol { get; set construct; }
		public string service_cookie { get; set construct; }
		[NoAccessorMethod]
		public string service_domain { owned get; set construct; }
		public string service_name { get; set construct; }
	}
	[CCode (cheader_filename = "libepc/service-info.h", ref_function = "epc_service_info_ref", unref_function = "epc_service_info_unref")]
	[Compact]
	public class ServiceInfo {
		public Epc.AddressFamily get_address_family ();
		public unowned string get_detail (string name);
		public unowned string get_host ();
		public unowned string get_interface ();
		public uint get_port ();
		public unowned string get_service_type ();
	}
	[CCode (cheader_filename = "libepc/service-monitor.h")]
	public class ServiceMonitor : GLib.Object {
		[CCode (has_construct_function = false)]
		public ServiceMonitor (string? application, string? domain, ...);
		[CCode (has_construct_function = false)]
		public ServiceMonitor.for_types (string? domain, ...);
		[CCode (has_construct_function = false)]
		public ServiceMonitor.for_types_strv (string? domain, string types);
		public bool get_skip_our_own ();
		public void set_skip_our_own (bool setting);
		[NoAccessorMethod]
		public string application { owned get; construct; }
		[NoAccessorMethod]
		public string domain { owned get; construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] service_types { owned get; construct; }
		public bool skip_our_own { get; set construct; }
		public virtual signal void scanning_done (string type);
		public virtual signal void service_found (string name, Epc.ServiceInfo info);
		public virtual signal void service_removed (string name, string type);
	}
	[CCode (cheader_filename = "libepc/enums.h", cprefix = "EPC_ADDRESS_")]
	public enum AddressFamily {
		UNSPEC,
		IPV4,
		IPV6
	}
	[CCode (cheader_filename = "libepc/enums.h", cprefix = "EPC_AUTH_")]
	[Flags]
	public enum AuthFlags {
		DEFAULT,
		PASSWORD_TEXT_NEEDED
	}
	[CCode (cheader_filename = "libepc/enums.h", cprefix = "EPC_COLLISIONS_")]
	public enum CollisionHandling {
		IGNORE,
		CHANGE_NAME,
		UNIQUE_SERVICE
	}
	[CCode (cheader_filename = "libepc/enums.h", cprefix = "EPC_PROTOCOL_")]
	public enum Protocol {
		UNKNOWN,
		HTTP,
		HTTPS
	}
	[CCode (cheader_filename = "libepc/service-type.h")]
	public delegate bool AuthHandler (Epc.AuthContext context, string username);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public delegate unowned Epc.Contents ContentsHandler (Epc.Publisher publisher, string key);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public delegate bool ContentsReadFunc (Epc.Contents contents, void* buffer, size_t length);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public const string SERVICE_TYPE_HTTP;
	[CCode (cheader_filename = "libepc/service-type.h")]
	public const string SERVICE_TYPE_HTTPS;
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static unowned GLib.EnumClass address_family_get_class ();
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static unowned GLib.FlagsClass auth_flags_get_class ();
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static unowned string auth_flags_to_string (Epc.AuthFlags value);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static unowned GLib.EnumClass collision_handling_get_class ();
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static unowned string collision_handling_to_string (Epc.CollisionHandling value);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static GLib.Quark http_error_quark ();
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static unowned string protocol_build_uri (Epc.Protocol protocol, string hostname, uint16 port, string path);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static Epc.Protocol protocol_from_name (string name, Epc.Protocol fallback);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static unowned GLib.EnumClass protocol_get_class ();
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static unowned string protocol_get_service_type (Epc.Protocol protocol);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static unowned string protocol_get_uri_scheme (Epc.Protocol protocol);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static unowned string protocol_to_string (Epc.Protocol value);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static unowned string service_type_get_base (string type);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static Epc.Protocol service_type_get_protocol (string service_type);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static unowned string service_type_list_supported (string application);
	[CCode (cheader_filename = "libepc/service-type.h")]
	public static unowned string service_type_new (Epc.Protocol protocol, string application);
}
