/* valadelegate.c generated by valac, the Vala compiler
 * generated from valadelegate.vala, do not modify */

/* valadelegate.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_SUBROUTINE (vala_subroutine_get_type ())
#define VALA_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutine))
#define VALA_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))
#define VALA_IS_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SUBROUTINE))
#define VALA_IS_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SUBROUTINE))
#define VALA_SUBROUTINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))

typedef struct _ValaSubroutine ValaSubroutine;
typedef struct _ValaSubroutineClass ValaSubroutineClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;
typedef struct _ValaTypeSymbolPrivate ValaTypeSymbolPrivate;
typedef struct _ValaDelegatePrivate ValaDelegatePrivate;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;

#define VALA_TYPE_PARAMETER (vala_parameter_get_type ())
#define VALA_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PARAMETER, ValaParameter))
#define VALA_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PARAMETER, ValaParameterClass))
#define VALA_IS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PARAMETER))
#define VALA_IS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PARAMETER))
#define VALA_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PARAMETER, ValaParameterClass))

typedef struct _ValaParameter ValaParameter;
typedef struct _ValaParameterClass ValaParameterClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_MEMBER_ACCESS (vala_member_access_get_type ())
#define VALA_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess))
#define VALA_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))
#define VALA_IS_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_ACCESS))
#define VALA_IS_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_ACCESS))
#define VALA_MEMBER_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))

typedef struct _ValaMemberAccess ValaMemberAccess;
typedef struct _ValaMemberAccessClass ValaMemberAccessClass;
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

#define VALA_TYPE_MEMBER_BINDING (vala_member_binding_get_type ())

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;

#define VALA_TYPE_PARAMETER_DIRECTION (vala_parameter_direction_get_type ())

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaCodeContext* context);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*add_namespace) (ValaSymbol* self, ValaNamespace* ns);
	void (*add_class) (ValaSymbol* self, ValaClass* cl);
	void (*add_interface) (ValaSymbol* self, ValaInterface* iface);
	void (*add_struct) (ValaSymbol* self, ValaStruct* st);
	void (*add_enum) (ValaSymbol* self, ValaEnum* en);
	void (*add_error_domain) (ValaSymbol* self, ValaErrorDomain* edomain);
	void (*add_delegate) (ValaSymbol* self, ValaDelegate* d);
	void (*add_constant) (ValaSymbol* self, ValaConstant* constant);
	void (*add_field) (ValaSymbol* self, ValaField* f);
	void (*add_method) (ValaSymbol* self, ValaMethod* m);
	void (*add_property) (ValaSymbol* self, ValaProperty* prop);
	void (*add_signal) (ValaSymbol* self, ValaSignal* sig);
	void (*add_constructor) (ValaSymbol* self, ValaConstructor* c);
	void (*add_destructor) (ValaSymbol* self, ValaDestructor* d);
};

struct _ValaTypeSymbol {
	ValaSymbol parent_instance;
	ValaTypeSymbolPrivate * priv;
};

struct _ValaTypeSymbolClass {
	ValaSymbolClass parent_class;
	gboolean (*is_reference_type) (ValaTypeSymbol* self);
	gboolean (*is_subtype_of) (ValaTypeSymbol* self, ValaTypeSymbol* t);
	gint (*get_type_parameter_index) (ValaTypeSymbol* self, const gchar* name);
};

struct _ValaDelegate {
	ValaTypeSymbol parent_instance;
	ValaDelegatePrivate * priv;
};

struct _ValaDelegateClass {
	ValaTypeSymbolClass parent_class;
};

struct _ValaDelegatePrivate {
	ValaDataType* _sender_type;
	ValaList* type_parameters;
	ValaList* parameters;
	ValaDataType* _return_type;
	gboolean* _has_target;
};

typedef enum  {
	VALA_MEMBER_BINDING_INSTANCE,
	VALA_MEMBER_BINDING_CLASS,
	VALA_MEMBER_BINDING_STATIC
} ValaMemberBinding;

typedef enum  {
	VALA_PARAMETER_DIRECTION_IN,
	VALA_PARAMETER_DIRECTION_OUT,
	VALA_PARAMETER_DIRECTION_REF
} ValaParameterDirection;


static gpointer vala_delegate_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_object_type_symbol_get_type (void) G_GNUC_CONST;
GType vala_class_get_type (void) G_GNUC_CONST;
GType vala_interface_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_error_domain_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_subroutine_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_property_get_type (void) G_GNUC_CONST;
GType vala_signal_get_type (void) G_GNUC_CONST;
GType vala_constructor_get_type (void) G_GNUC_CONST;
GType vala_destructor_get_type (void) G_GNUC_CONST;
GType vala_typeparameter_get_type (void) G_GNUC_CONST;
GType vala_parameter_get_type (void) G_GNUC_CONST;
#define VALA_DELEGATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DELEGATE, ValaDelegatePrivate))
enum  {
	VALA_DELEGATE_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
ValaDelegate* vala_delegate_new (const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment);
ValaDelegate* vala_delegate_construct (GType object_type, const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment);
ValaTypeSymbol* vala_typesymbol_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
void vala_delegate_set_return_type (ValaDelegate* self, ValaDataType* value);
void vala_delegate_add_type_parameter (ValaDelegate* self, ValaTypeParameter* p);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
void vala_scope_add (ValaScope* self, const gchar* name, ValaSymbol* sym);
const gchar* vala_symbol_get_name (ValaSymbol* self);
ValaList* vala_delegate_get_type_parameters (ValaDelegate* self);
static gint vala_delegate_real_get_type_parameter_index (ValaTypeSymbol* base, const gchar* name);
void vala_delegate_add_parameter (ValaDelegate* self, ValaParameter* param);
ValaList* vala_delegate_get_parameters (ValaDelegate* self);
gboolean vala_delegate_matches_method (ValaDelegate* self, ValaMethod* m, ValaDataType* dt);
gboolean vala_method_get_coroutine (ValaMethod* self);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
ValaDataType* vala_method_get_return_type (ValaMethod* self);
gboolean vala_data_type_stricter (ValaDataType* self, ValaDataType* type2);
ValaDataType* vala_delegate_get_return_type (ValaDelegate* self);
GType vala_member_access_get_type (void) G_GNUC_CONST;
ValaDataType* vala_data_type_get_actual_type (ValaDataType* self, ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaCodeNode* node_reference);
ValaList* vala_method_get_parameters (ValaMethod* self);
ValaDataType* vala_delegate_get_sender_type (ValaDelegate* self);
ValaDataType* vala_variable_get_variable_type (ValaVariable* self);
GType vala_member_binding_get_type (void) G_GNUC_CONST;
ValaMemberBinding vala_method_get_binding (ValaMethod* self);
gboolean vala_delegate_get_has_target (ValaDelegate* self);
ValaList* vala_code_node_get_error_types (ValaCodeNode* self);
gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type);
static void vala_delegate_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_delegate (ValaCodeVisitor* self, ValaDelegate* d);
static void vala_delegate_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
static gboolean vala_delegate_real_is_reference_type (ValaTypeSymbol* base);
static void vala_delegate_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
gchar* vala_delegate_get_prototype_string (ValaDelegate* self, const gchar* name);
static gchar* vala_delegate_get_return_type_string (ValaDelegate* self);
static gchar* vala_delegate_get_parameters_string (ValaDelegate* self);
gboolean vala_data_type_get_value_owned (ValaDataType* self);
GType vala_reference_type_get_type (void) G_GNUC_CONST;
gchar* vala_code_node_to_string (ValaCodeNode* self);
GType vala_parameter_direction_get_type (void) G_GNUC_CONST;
ValaParameterDirection vala_parameter_get_direction (ValaParameter* self);
static gboolean vala_delegate_real_check (ValaCodeNode* base, ValaCodeContext* context);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
ValaSemanticAnalyzer* vala_code_context_get_analyzer (ValaCodeContext* self);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaCodeContext* context);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
gboolean vala_code_node_get_attribute_bool (ValaCodeNode* self, const gchar* attribute, const gchar* argument, gboolean default_value);
static gboolean* _bool_dup (gboolean* self);
void vala_delegate_set_has_target (ValaDelegate* self, gboolean value);
void vala_code_node_remove_attribute_argument (ValaCodeNode* self, const gchar* attribute, const gchar* argument);
void vala_code_node_set_attribute_bool (ValaCodeNode* self, const gchar* attribute, const gchar* argument, gboolean value, ValaSourceReference* source_reference);
void vala_delegate_set_sender_type (ValaDelegate* self, ValaDataType* value);
static void vala_delegate_finalize (ValaCodeNode* obj);


/**
 * Creates a new delegate.
 *
 * @param name        delegate type name
 * @param return_type return type
 * @param source      reference to source code
 * @return            newly created delegate
 */
ValaDelegate* vala_delegate_construct (GType object_type, const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaDelegate* self = NULL;
	const gchar* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaComment* _tmp2_;
	ValaDataType* _tmp3_;
	g_return_val_if_fail (return_type != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = source_reference;
	_tmp2_ = comment;
	self = (ValaDelegate*) vala_typesymbol_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = return_type;
	vala_delegate_set_return_type (self, _tmp3_);
	return self;
}


ValaDelegate* vala_delegate_new (const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_delegate_construct (VALA_TYPE_DELEGATE, name, return_type, source_reference, comment);
}


/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void vala_delegate_add_type_parameter (ValaDelegate* self, ValaTypeParameter* p) {
	ValaList* _tmp0_;
	ValaTypeParameter* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaTypeParameter* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaTypeParameter* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	_tmp1_ = p;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = p;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = p;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_delegate_get_type_parameters (ValaDelegate* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static gint vala_delegate_real_get_type_parameter_index (ValaTypeSymbol* base, const gchar* name) {
	ValaDelegate * self;
	gint result = 0;
	gint i;
	self = (ValaDelegate*) base;
	g_return_val_if_fail (name != NULL, 0);
	i = 0;
	{
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		ValaList* _parameter_list;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _parameter_size;
		gint _parameter_index;
		_tmp0_ = self->priv->type_parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_parameter_list = _tmp1_;
		_tmp2_ = _parameter_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_parameter_size = _tmp4_;
		_parameter_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			ValaTypeParameter* parameter;
			ValaTypeParameter* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			_tmp5_ = _parameter_index;
			_parameter_index = _tmp5_ + 1;
			_tmp6_ = _parameter_index;
			_tmp7_ = _parameter_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _parameter_list;
			_tmp9_ = _parameter_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			parameter = (ValaTypeParameter*) _tmp10_;
			_tmp11_ = parameter;
			_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = name;
			if (g_strcmp0 (_tmp13_, _tmp14_) == 0) {
				result = i;
				_vala_code_node_unref0 (parameter);
				_vala_iterable_unref0 (_parameter_list);
				return result;
			}
			_tmp15_ = i;
			i = _tmp15_ + 1;
			_vala_code_node_unref0 (parameter);
		}
		_vala_iterable_unref0 (_parameter_list);
	}
	result = -1;
	return result;
}


/**
 * Appends paramater to this callback function.
 *
 * @param param a formal parameter
 */
void vala_delegate_add_parameter (ValaDelegate* self, ValaParameter* param) {
	ValaList* _tmp0_;
	ValaParameter* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaParameter* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaParameter* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	_tmp1_ = param;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = param;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = param;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Return copy of parameter list.
 *
 * @return parameter list
 */
ValaList* vala_delegate_get_parameters (ValaDelegate* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Checks whether the arguments and return type of the specified method
 * matches this callback.
 *
 * @param m a method
 * @return  true if the specified method is compatible to this callback
 */
gboolean vala_delegate_matches_method (ValaDelegate* self, ValaMethod* m, ValaDataType* dt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaMethod* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp6_;
	ValaMethod* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_ = NULL;
	ValaDataType* _tmp14_;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_;
	ValaMethod* _tmp17_;
	ValaList* _tmp18_ = NULL;
	ValaList* method_params;
	ValaList* _tmp19_;
	ValaIterator* _tmp20_ = NULL;
	ValaIterator* method_params_it;
	gboolean _tmp21_ = FALSE;
	ValaDataType* _tmp22_;
	gboolean _tmp29_;
	gboolean first;
	ValaIterator* _tmp74_;
	gboolean _tmp75_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	g_return_val_if_fail (dt != NULL, FALSE);
	_tmp1_ = m;
	_tmp2_ = vala_method_get_coroutine (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		_tmp4_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp5_ = _tmp4_;
		_tmp0_ = !VALA_IS_SIGNAL (_tmp5_);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		result = FALSE;
		return result;
	}
	_tmp7_ = m;
	_tmp8_ = vala_method_get_return_type (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_delegate_get_return_type (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = dt;
	_tmp13_ = vala_data_type_get_actual_type (_tmp11_, _tmp12_, NULL, (ValaCodeNode*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_data_type_stricter (_tmp9_, _tmp14_);
	_tmp16_ = !_tmp15_;
	_vala_code_node_unref0 (_tmp14_);
	if (_tmp16_) {
		result = FALSE;
		return result;
	}
	_tmp17_ = m;
	_tmp18_ = vala_method_get_parameters (_tmp17_);
	method_params = _tmp18_;
	_tmp19_ = method_params;
	_tmp20_ = vala_iterable_iterator ((ValaIterable*) _tmp19_);
	method_params_it = _tmp20_;
	_tmp22_ = self->priv->_sender_type;
	if (_tmp22_ != NULL) {
		ValaList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		ValaList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		_tmp23_ = method_params;
		_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = self->priv->parameters;
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp21_ = _tmp25_ == (_tmp28_ + 1);
	} else {
		_tmp21_ = FALSE;
	}
	_tmp29_ = _tmp21_;
	if (_tmp29_) {
		ValaIterator* _tmp30_;
		ValaIterator* _tmp31_;
		gpointer _tmp32_ = NULL;
		ValaParameter* method_param;
		ValaDataType* _tmp33_;
		ValaParameter* _tmp34_;
		ValaDataType* _tmp35_;
		ValaDataType* _tmp36_;
		gboolean _tmp37_ = FALSE;
		_tmp30_ = method_params_it;
		vala_iterator_next (_tmp30_);
		_tmp31_ = method_params_it;
		_tmp32_ = vala_iterator_get (_tmp31_);
		method_param = (ValaParameter*) _tmp32_;
		_tmp33_ = self->priv->_sender_type;
		_tmp34_ = method_param;
		_tmp35_ = vala_variable_get_variable_type ((ValaVariable*) _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_data_type_stricter (_tmp33_, _tmp36_);
		if (!_tmp37_) {
			result = FALSE;
			_vala_code_node_unref0 (method_param);
			_vala_iterator_unref0 (method_params_it);
			_vala_iterable_unref0 (method_params);
			return result;
		}
		_vala_code_node_unref0 (method_param);
	}
	first = TRUE;
	{
		ValaList* _tmp38_;
		ValaList* _tmp39_;
		ValaList* _param_list;
		ValaList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _param_size;
		gint _param_index;
		_tmp38_ = self->priv->parameters;
		_tmp39_ = _vala_iterable_ref0 (_tmp38_);
		_param_list = _tmp39_;
		_tmp40_ = _param_list;
		_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_param_size = _tmp42_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			ValaList* _tmp46_;
			gint _tmp47_;
			gpointer _tmp48_ = NULL;
			ValaParameter* param;
			gboolean _tmp49_ = FALSE;
			gboolean _tmp50_ = FALSE;
			gboolean _tmp51_;
			gboolean _tmp55_;
			gboolean _tmp58_;
			ValaIterator* _tmp59_;
			gboolean _tmp60_ = FALSE;
			ValaIterator* _tmp61_;
			gpointer _tmp62_ = NULL;
			ValaParameter* method_param;
			ValaParameter* _tmp63_;
			ValaDataType* _tmp64_;
			ValaDataType* _tmp65_;
			ValaDataType* _tmp66_;
			ValaDataType* _tmp67_ = NULL;
			ValaDataType* _tmp68_;
			ValaParameter* _tmp69_;
			ValaDataType* _tmp70_;
			ValaDataType* _tmp71_;
			gboolean _tmp72_ = FALSE;
			gboolean _tmp73_;
			_tmp43_ = _param_index;
			_param_index = _tmp43_ + 1;
			_tmp44_ = _param_index;
			_tmp45_ = _param_size;
			if (!(_tmp44_ < _tmp45_)) {
				break;
			}
			_tmp46_ = _param_list;
			_tmp47_ = _param_index;
			_tmp48_ = vala_list_get (_tmp46_, _tmp47_);
			param = (ValaParameter*) _tmp48_;
			_tmp51_ = first;
			if (_tmp51_) {
				ValaMethod* _tmp52_;
				ValaMemberBinding _tmp53_;
				ValaMemberBinding _tmp54_;
				_tmp52_ = m;
				_tmp53_ = vala_method_get_binding (_tmp52_);
				_tmp54_ = _tmp53_;
				_tmp50_ = _tmp54_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp50_ = FALSE;
			}
			_tmp55_ = _tmp50_;
			if (_tmp55_) {
				gboolean _tmp56_;
				gboolean _tmp57_;
				_tmp56_ = vala_delegate_get_has_target (self);
				_tmp57_ = _tmp56_;
				_tmp49_ = !_tmp57_;
			} else {
				_tmp49_ = FALSE;
			}
			_tmp58_ = _tmp49_;
			if (_tmp58_) {
				first = FALSE;
				_vala_code_node_unref0 (param);
				continue;
			}
			_tmp59_ = method_params_it;
			_tmp60_ = vala_iterator_next (_tmp59_);
			if (!_tmp60_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp61_ = method_params_it;
			_tmp62_ = vala_iterator_get (_tmp61_);
			method_param = (ValaParameter*) _tmp62_;
			_tmp63_ = param;
			_tmp64_ = vala_variable_get_variable_type ((ValaVariable*) _tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = dt;
			_tmp67_ = vala_data_type_get_actual_type (_tmp65_, _tmp66_, NULL, (ValaCodeNode*) self);
			_tmp68_ = _tmp67_;
			_tmp69_ = method_param;
			_tmp70_ = vala_variable_get_variable_type ((ValaVariable*) _tmp69_);
			_tmp71_ = _tmp70_;
			_tmp72_ = vala_data_type_stricter (_tmp68_, _tmp71_);
			_tmp73_ = !_tmp72_;
			_vala_code_node_unref0 (_tmp68_);
			if (_tmp73_) {
				result = FALSE;
				_vala_code_node_unref0 (method_param);
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_iterable_unref0 (method_params);
				return result;
			}
			_vala_code_node_unref0 (method_param);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp74_ = method_params_it;
	_tmp75_ = vala_iterator_next (_tmp74_);
	if (_tmp75_) {
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_iterable_unref0 (method_params);
		return result;
	}
	{
		ValaMethod* _tmp76_;
		ValaList* _tmp77_ = NULL;
		ValaList* _method_error_type_list;
		ValaList* _tmp78_;
		gint _tmp79_;
		gint _tmp80_;
		gint _method_error_type_size;
		gint _method_error_type_index;
		_tmp76_ = m;
		_tmp77_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp76_);
		_method_error_type_list = _tmp77_;
		_tmp78_ = _method_error_type_list;
		_tmp79_ = vala_collection_get_size ((ValaCollection*) _tmp78_);
		_tmp80_ = _tmp79_;
		_method_error_type_size = _tmp80_;
		_method_error_type_index = -1;
		while (TRUE) {
			gint _tmp81_;
			gint _tmp82_;
			gint _tmp83_;
			ValaList* _tmp84_;
			gint _tmp85_;
			gpointer _tmp86_ = NULL;
			ValaDataType* method_error_type;
			gboolean match;
			gboolean _tmp100_;
			_tmp81_ = _method_error_type_index;
			_method_error_type_index = _tmp81_ + 1;
			_tmp82_ = _method_error_type_index;
			_tmp83_ = _method_error_type_size;
			if (!(_tmp82_ < _tmp83_)) {
				break;
			}
			_tmp84_ = _method_error_type_list;
			_tmp85_ = _method_error_type_index;
			_tmp86_ = vala_list_get (_tmp84_, _tmp85_);
			method_error_type = (ValaDataType*) _tmp86_;
			match = FALSE;
			{
				ValaList* _tmp87_ = NULL;
				ValaList* _delegate_error_type_list;
				ValaList* _tmp88_;
				gint _tmp89_;
				gint _tmp90_;
				gint _delegate_error_type_size;
				gint _delegate_error_type_index;
				_tmp87_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
				_delegate_error_type_list = _tmp87_;
				_tmp88_ = _delegate_error_type_list;
				_tmp89_ = vala_collection_get_size ((ValaCollection*) _tmp88_);
				_tmp90_ = _tmp89_;
				_delegate_error_type_size = _tmp90_;
				_delegate_error_type_index = -1;
				while (TRUE) {
					gint _tmp91_;
					gint _tmp92_;
					gint _tmp93_;
					ValaList* _tmp94_;
					gint _tmp95_;
					gpointer _tmp96_ = NULL;
					ValaDataType* delegate_error_type;
					ValaDataType* _tmp97_;
					ValaDataType* _tmp98_;
					gboolean _tmp99_ = FALSE;
					_tmp91_ = _delegate_error_type_index;
					_delegate_error_type_index = _tmp91_ + 1;
					_tmp92_ = _delegate_error_type_index;
					_tmp93_ = _delegate_error_type_size;
					if (!(_tmp92_ < _tmp93_)) {
						break;
					}
					_tmp94_ = _delegate_error_type_list;
					_tmp95_ = _delegate_error_type_index;
					_tmp96_ = vala_list_get (_tmp94_, _tmp95_);
					delegate_error_type = (ValaDataType*) _tmp96_;
					_tmp97_ = method_error_type;
					_tmp98_ = delegate_error_type;
					_tmp99_ = vala_data_type_compatible (_tmp97_, _tmp98_);
					if (_tmp99_) {
						match = TRUE;
						_vala_code_node_unref0 (delegate_error_type);
						break;
					}
					_vala_code_node_unref0 (delegate_error_type);
				}
				_vala_iterable_unref0 (_delegate_error_type_list);
			}
			_tmp100_ = match;
			if (!_tmp100_) {
				result = FALSE;
				_vala_code_node_unref0 (method_error_type);
				_vala_iterable_unref0 (_method_error_type_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_iterable_unref0 (method_params);
				return result;
			}
			_vala_code_node_unref0 (method_error_type);
		}
		_vala_iterable_unref0 (_method_error_type_list);
	}
	result = TRUE;
	_vala_iterator_unref0 (method_params_it);
	_vala_iterable_unref0 (method_params);
	return result;
}


static void vala_delegate_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaDelegate * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaDelegate*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_delegate (_tmp0_, self);
}


static void vala_delegate_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaDelegate * self;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaCodeVisitor* _tmp15_;
	self = (ValaDelegate*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		ValaList* _p_list;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_size;
		gint _p_index;
		_tmp0_ = self->priv->type_parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			ValaTypeParameter* p;
			ValaTypeParameter* _tmp11_;
			ValaCodeVisitor* _tmp12_;
			_tmp5_ = _p_index;
			_p_index = _tmp5_ + 1;
			_tmp6_ = _p_index;
			_tmp7_ = _p_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _p_list;
			_tmp9_ = _p_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			p = (ValaTypeParameter*) _tmp10_;
			_tmp11_ = p;
			_tmp12_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, _tmp12_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp13_ = vala_delegate_get_return_type (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp14_, _tmp15_);
	{
		ValaList* _tmp16_;
		ValaList* _tmp17_;
		ValaList* _param_list;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _param_size;
		gint _param_index;
		_tmp16_ = self->priv->parameters;
		_tmp17_ = _vala_iterable_ref0 (_tmp16_);
		_param_list = _tmp17_;
		_tmp18_ = _param_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_param_size = _tmp20_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			ValaList* _tmp24_;
			gint _tmp25_;
			gpointer _tmp26_ = NULL;
			ValaParameter* param;
			ValaParameter* _tmp27_;
			ValaCodeVisitor* _tmp28_;
			_tmp21_ = _param_index;
			_param_index = _tmp21_ + 1;
			_tmp22_ = _param_index;
			_tmp23_ = _param_size;
			if (!(_tmp22_ < _tmp23_)) {
				break;
			}
			_tmp24_ = _param_list;
			_tmp25_ = _param_index;
			_tmp26_ = vala_list_get (_tmp24_, _tmp25_);
			param = (ValaParameter*) _tmp26_;
			_tmp27_ = param;
			_tmp28_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp27_, _tmp28_);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	{
		ValaList* _tmp29_ = NULL;
		ValaList* _error_type_list;
		ValaList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _error_type_size;
		gint _error_type_index;
		_tmp29_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_error_type_list = _tmp29_;
		_tmp30_ = _error_type_list;
		_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_error_type_size = _tmp32_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			ValaList* _tmp36_;
			gint _tmp37_;
			gpointer _tmp38_ = NULL;
			ValaDataType* error_type;
			ValaDataType* _tmp39_;
			ValaCodeVisitor* _tmp40_;
			_tmp33_ = _error_type_index;
			_error_type_index = _tmp33_ + 1;
			_tmp34_ = _error_type_index;
			_tmp35_ = _error_type_size;
			if (!(_tmp34_ < _tmp35_)) {
				break;
			}
			_tmp36_ = _error_type_list;
			_tmp37_ = _error_type_index;
			_tmp38_ = vala_list_get (_tmp36_, _tmp37_);
			error_type = (ValaDataType*) _tmp38_;
			_tmp39_ = error_type;
			_tmp40_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp39_, _tmp40_);
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
}


static gboolean vala_delegate_real_is_reference_type (ValaTypeSymbol* base) {
	ValaDelegate * self;
	gboolean result = FALSE;
	self = (ValaDelegate*) base;
	result = FALSE;
	return result;
}


static void vala_delegate_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaDelegate * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaList* _tmp4_ = NULL;
	ValaList* error_types;
	self = (ValaDelegate*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_delegate_get_return_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_type;
	if (_tmp1_ == _tmp2_) {
		ValaDataType* _tmp3_;
		_tmp3_ = new_type;
		vala_delegate_set_return_type (self, _tmp3_);
		return;
	}
	_tmp4_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
	error_types = _tmp4_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_;
				gint _tmp8_;
				ValaList* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				ValaList* _tmp12_;
				gint _tmp13_;
				gpointer _tmp14_ = NULL;
				ValaDataType* _tmp15_;
				ValaDataType* _tmp16_;
				gboolean _tmp17_;
				_tmp6_ = _tmp5_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp8_ = i;
				_tmp9_ = error_types;
				_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
				_tmp11_ = _tmp10_;
				if (!(_tmp8_ < _tmp11_)) {
					break;
				}
				_tmp12_ = error_types;
				_tmp13_ = i;
				_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
				_tmp15_ = (ValaDataType*) _tmp14_;
				_tmp16_ = old_type;
				_tmp17_ = _tmp15_ == _tmp16_;
				_vala_code_node_unref0 (_tmp15_);
				if (_tmp17_) {
					ValaList* _tmp18_;
					gint _tmp19_;
					ValaDataType* _tmp20_;
					_tmp18_ = error_types;
					_tmp19_ = i;
					_tmp20_ = new_type;
					vala_list_set (_tmp18_, _tmp19_, _tmp20_);
					_vala_iterable_unref0 (error_types);
					return;
				}
			}
		}
	}
	_vala_iterable_unref0 (error_types);
}


gchar* vala_delegate_get_prototype_string (ValaDelegate* self, const gchar* name) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = vala_delegate_get_return_type_string (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = name;
	_tmp3_ = vala_delegate_get_parameters_string (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s %s %s", _tmp1_, _tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
	result = _tmp6_;
	return result;
}


static gchar* vala_delegate_get_return_type_string (ValaDelegate* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* str;
	gboolean _tmp1_ = FALSE;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp8_;
	const gchar* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gchar* _tmp15_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	str = _tmp0_;
	_tmp2_ = vala_delegate_get_return_type (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_data_type_get_value_owned (_tmp3_);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp6_ = vala_delegate_get_return_type (self);
		_tmp7_ = _tmp6_;
		_tmp1_ = VALA_IS_REFERENCE_TYPE (_tmp7_);
	} else {
		_tmp1_ = FALSE;
	}
	_tmp8_ = _tmp1_;
	if (_tmp8_) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("weak ");
		_g_free0 (str);
		str = _tmp9_;
	}
	_tmp10_ = str;
	_tmp11_ = vala_delegate_get_return_type (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strconcat (_tmp10_, _tmp14_, NULL);
	_g_free0 (str);
	str = _tmp15_;
	_g_free0 (_tmp14_);
	result = str;
	return result;
}


static gchar* vala_delegate_get_parameters_string (ValaDelegate* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* str;
	gint i;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("(");
	str = _tmp0_;
	i = 1;
	{
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		ValaList* _param_list;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _param_size;
		gint _param_index;
		_tmp1_ = self->priv->parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_param_list = _tmp2_;
		_tmp3_ = _param_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_param_size = _tmp5_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			ValaList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			ValaParameter* param;
			gint _tmp12_;
			ValaParameter* _tmp15_;
			ValaParameterDirection _tmp16_;
			ValaParameterDirection _tmp17_;
			const gchar* _tmp47_;
			ValaParameter* _tmp48_;
			ValaDataType* _tmp49_;
			ValaDataType* _tmp50_;
			gchar* _tmp51_ = NULL;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gint _tmp54_;
			_tmp6_ = _param_index;
			_param_index = _tmp6_ + 1;
			_tmp7_ = _param_index;
			_tmp8_ = _param_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _param_list;
			_tmp10_ = _param_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			param = (ValaParameter*) _tmp11_;
			_tmp12_ = i;
			if (_tmp12_ > 1) {
				const gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp13_ = str;
				_tmp14_ = g_strconcat (_tmp13_, ", ", NULL);
				_g_free0 (str);
				str = _tmp14_;
			}
			_tmp15_ = param;
			_tmp16_ = vala_parameter_get_direction (_tmp15_);
			_tmp17_ = _tmp16_;
			if (_tmp17_ == VALA_PARAMETER_DIRECTION_IN) {
				ValaParameter* _tmp18_;
				ValaDataType* _tmp19_;
				ValaDataType* _tmp20_;
				gboolean _tmp21_;
				gboolean _tmp22_;
				_tmp18_ = param;
				_tmp19_ = vala_variable_get_variable_type ((ValaVariable*) _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = vala_data_type_get_value_owned (_tmp20_);
				_tmp22_ = _tmp21_;
				if (_tmp22_) {
					const gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp23_ = str;
					_tmp24_ = g_strconcat (_tmp23_, "owned ", NULL);
					_g_free0 (str);
					str = _tmp24_;
				}
			} else {
				ValaParameter* _tmp25_;
				ValaParameterDirection _tmp26_;
				ValaParameterDirection _tmp27_;
				gboolean _tmp35_ = FALSE;
				ValaParameter* _tmp36_;
				ValaDataType* _tmp37_;
				ValaDataType* _tmp38_;
				gboolean _tmp39_;
				gboolean _tmp40_;
				gboolean _tmp44_;
				_tmp25_ = param;
				_tmp26_ = vala_parameter_get_direction (_tmp25_);
				_tmp27_ = _tmp26_;
				if (_tmp27_ == VALA_PARAMETER_DIRECTION_REF) {
					const gchar* _tmp28_;
					gchar* _tmp29_;
					_tmp28_ = str;
					_tmp29_ = g_strconcat (_tmp28_, "ref ", NULL);
					_g_free0 (str);
					str = _tmp29_;
				} else {
					ValaParameter* _tmp30_;
					ValaParameterDirection _tmp31_;
					ValaParameterDirection _tmp32_;
					_tmp30_ = param;
					_tmp31_ = vala_parameter_get_direction (_tmp30_);
					_tmp32_ = _tmp31_;
					if (_tmp32_ == VALA_PARAMETER_DIRECTION_OUT) {
						const gchar* _tmp33_;
						gchar* _tmp34_;
						_tmp33_ = str;
						_tmp34_ = g_strconcat (_tmp33_, "out ", NULL);
						_g_free0 (str);
						str = _tmp34_;
					}
				}
				_tmp36_ = param;
				_tmp37_ = vala_variable_get_variable_type ((ValaVariable*) _tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = vala_data_type_get_value_owned (_tmp38_);
				_tmp40_ = _tmp39_;
				if (!_tmp40_) {
					ValaParameter* _tmp41_;
					ValaDataType* _tmp42_;
					ValaDataType* _tmp43_;
					_tmp41_ = param;
					_tmp42_ = vala_variable_get_variable_type ((ValaVariable*) _tmp41_);
					_tmp43_ = _tmp42_;
					_tmp35_ = VALA_IS_REFERENCE_TYPE (_tmp43_);
				} else {
					_tmp35_ = FALSE;
				}
				_tmp44_ = _tmp35_;
				if (_tmp44_) {
					const gchar* _tmp45_;
					gchar* _tmp46_;
					_tmp45_ = str;
					_tmp46_ = g_strconcat (_tmp45_, "weak ", NULL);
					_g_free0 (str);
					str = _tmp46_;
				}
			}
			_tmp47_ = str;
			_tmp48_ = param;
			_tmp49_ = vala_variable_get_variable_type ((ValaVariable*) _tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_code_node_to_string ((ValaCodeNode*) _tmp50_);
			_tmp52_ = _tmp51_;
			_tmp53_ = g_strconcat (_tmp47_, _tmp52_, NULL);
			_g_free0 (str);
			str = _tmp53_;
			_g_free0 (_tmp52_);
			_tmp54_ = i;
			i = _tmp54_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp55_ = str;
	_tmp56_ = g_strconcat (_tmp55_, ")", NULL);
	_g_free0 (str);
	str = _tmp56_;
	result = str;
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean vala_delegate_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaDelegate * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaCodeContext* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaSourceFile* old_source_file;
	ValaSourceReference* _tmp10_;
	ValaSourceReference* _tmp11_;
	ValaDataType* _tmp32_;
	ValaDataType* _tmp33_;
	ValaCodeContext* _tmp34_;
	ValaCodeContext* _tmp60_;
	ValaSemanticAnalyzer* _tmp61_;
	ValaSemanticAnalyzer* _tmp62_;
	ValaSourceFile* _tmp63_;
	gboolean _tmp64_;
	gboolean _tmp65_;
	self = (ValaDelegate*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = context;
	_tmp5_ = vala_code_context_get_analyzer (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_source_file (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_source_file_ref0 (_tmp8_);
	old_source_file = _tmp9_;
	_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		ValaCodeContext* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaSemanticAnalyzer* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaSourceReference* _tmp16_;
		ValaSourceFile* _tmp17_;
		ValaSourceFile* _tmp18_;
		_tmp12_ = context;
		_tmp13_ = vala_code_context_get_analyzer (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_source_reference_get_file (_tmp16_);
		_tmp18_ = _tmp17_;
		vala_semantic_analyzer_set_current_source_file (_tmp14_, _tmp18_);
	}
	{
		ValaList* _tmp19_;
		ValaList* _tmp20_;
		ValaList* _p_list;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _p_size;
		gint _p_index;
		_tmp19_ = self->priv->type_parameters;
		_tmp20_ = _vala_iterable_ref0 (_tmp19_);
		_p_list = _tmp20_;
		_tmp21_ = _p_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_p_size = _tmp23_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_ = NULL;
			ValaTypeParameter* p;
			ValaTypeParameter* _tmp30_;
			ValaCodeContext* _tmp31_;
			_tmp24_ = _p_index;
			_p_index = _tmp24_ + 1;
			_tmp25_ = _p_index;
			_tmp26_ = _p_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _p_list;
			_tmp28_ = _p_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			p = (ValaTypeParameter*) _tmp29_;
			_tmp30_ = p;
			_tmp31_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp30_, _tmp31_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp32_ = vala_delegate_get_return_type (self);
	_tmp33_ = _tmp32_;
	_tmp34_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp33_, _tmp34_);
	{
		ValaList* _tmp35_;
		ValaList* _tmp36_;
		ValaList* _param_list;
		ValaList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gint _param_size;
		gint _param_index;
		_tmp35_ = self->priv->parameters;
		_tmp36_ = _vala_iterable_ref0 (_tmp35_);
		_param_list = _tmp36_;
		_tmp37_ = _param_list;
		_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_param_size = _tmp39_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			ValaList* _tmp43_;
			gint _tmp44_;
			gpointer _tmp45_ = NULL;
			ValaParameter* param;
			ValaParameter* _tmp46_;
			ValaCodeContext* _tmp47_;
			_tmp40_ = _param_index;
			_param_index = _tmp40_ + 1;
			_tmp41_ = _param_index;
			_tmp42_ = _param_size;
			if (!(_tmp41_ < _tmp42_)) {
				break;
			}
			_tmp43_ = _param_list;
			_tmp44_ = _param_index;
			_tmp45_ = vala_list_get (_tmp43_, _tmp44_);
			param = (ValaParameter*) _tmp45_;
			_tmp46_ = param;
			_tmp47_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp46_, _tmp47_);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	{
		ValaList* _tmp48_ = NULL;
		ValaList* _error_type_list;
		ValaList* _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		gint _error_type_size;
		gint _error_type_index;
		_tmp48_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_error_type_list = _tmp48_;
		_tmp49_ = _error_type_list;
		_tmp50_ = vala_collection_get_size ((ValaCollection*) _tmp49_);
		_tmp51_ = _tmp50_;
		_error_type_size = _tmp51_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp52_;
			gint _tmp53_;
			gint _tmp54_;
			ValaList* _tmp55_;
			gint _tmp56_;
			gpointer _tmp57_ = NULL;
			ValaDataType* error_type;
			ValaDataType* _tmp58_;
			ValaCodeContext* _tmp59_;
			_tmp52_ = _error_type_index;
			_error_type_index = _tmp52_ + 1;
			_tmp53_ = _error_type_index;
			_tmp54_ = _error_type_size;
			if (!(_tmp53_ < _tmp54_)) {
				break;
			}
			_tmp55_ = _error_type_list;
			_tmp56_ = _error_type_index;
			_tmp57_ = vala_list_get (_tmp55_, _tmp56_);
			error_type = (ValaDataType*) _tmp57_;
			_tmp58_ = error_type;
			_tmp59_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp58_, _tmp59_);
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	_tmp60_ = context;
	_tmp61_ = vala_code_context_get_analyzer (_tmp60_);
	_tmp62_ = _tmp61_;
	_tmp63_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp62_, _tmp63_);
	_tmp64_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp65_ = _tmp64_;
	result = !_tmp65_;
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaDataType* vala_delegate_get_return_type (ValaDelegate* self) {
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_delegate_set_return_type (ValaDelegate* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp1_;
	_tmp2_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer __bool_dup0 (gpointer self) {
	return self ? _bool_dup (self) : NULL;
}


gboolean vala_delegate_get_has_target (ValaDelegate* self) {
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_target;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_;
		gboolean* _tmp3_;
		_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "has_target", TRUE);
		_tmp2_ = _tmp1_;
		_tmp3_ = __bool_dup0 (&_tmp2_);
		_g_free0 (self->priv->_has_target);
		self->priv->_has_target = _tmp3_;
	}
	_tmp4_ = self->priv->_has_target;
	result = *_tmp4_;
	return result;
}


void vala_delegate_set_has_target (ValaDelegate* self, gboolean value) {
	gboolean _tmp0_;
	gboolean* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (self->priv->_has_target);
	self->priv->_has_target = _tmp1_;
	_tmp2_ = value;
	if (_tmp2_) {
		vala_code_node_remove_attribute_argument ((ValaCodeNode*) self, "CCode", "has_target");
	} else {
		vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "has_target", FALSE, NULL);
	}
}


ValaDataType* vala_delegate_get_sender_type (ValaDelegate* self) {
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sender_type;
	result = _tmp0_;
	return result;
}


void vala_delegate_set_sender_type (ValaDelegate* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_sender_type);
	self->priv->_sender_type = _tmp1_;
}


static void vala_delegate_class_init (ValaDelegateClass * klass) {
	vala_delegate_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_delegate_finalize;
	g_type_class_add_private (klass, sizeof (ValaDelegatePrivate));
	VALA_TYPESYMBOL_CLASS (klass)->get_type_parameter_index = vala_delegate_real_get_type_parameter_index;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_delegate_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_delegate_real_accept_children;
	VALA_TYPESYMBOL_CLASS (klass)->is_reference_type = vala_delegate_real_is_reference_type;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_delegate_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->check = vala_delegate_real_check;
}


static void vala_delegate_instance_init (ValaDelegate * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = VALA_DELEGATE_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp0_);
	self->priv->type_parameters = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp2_);
	self->priv->parameters = (ValaList*) _tmp3_;
}


static void vala_delegate_finalize (ValaCodeNode* obj) {
	ValaDelegate * self;
	self = VALA_DELEGATE (obj);
	_vala_code_node_unref0 (self->priv->_sender_type);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_code_node_unref0 (self->priv->_return_type);
	_g_free0 (self->priv->_has_target);
	VALA_CODE_NODE_CLASS (vala_delegate_parent_class)->finalize (obj);
}


/**
 * Represents a function callback type.
 */
GType vala_delegate_get_type (void) {
	static volatile gsize vala_delegate_type_id__volatile = 0;
	if (g_once_init_enter (&vala_delegate_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDelegateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_delegate_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDelegate), 0, (GInstanceInitFunc) vala_delegate_instance_init, NULL };
		GType vala_delegate_type_id;
		vala_delegate_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaDelegate", &g_define_type_info, 0);
		g_once_init_leave (&vala_delegate_type_id__volatile, vala_delegate_type_id);
	}
	return vala_delegate_type_id__volatile;
}



