/* valaerrordomain.c generated by valac, the Vala compiler
 * generated from valaerrordomain.vala, do not modify */

/* valaerrordomain.vala
 *
 * Copyright (C) 2008-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_SUBROUTINE (vala_subroutine_get_type ())
#define VALA_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutine))
#define VALA_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))
#define VALA_IS_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SUBROUTINE))
#define VALA_IS_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SUBROUTINE))
#define VALA_SUBROUTINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))

typedef struct _ValaSubroutine ValaSubroutine;
typedef struct _ValaSubroutineClass ValaSubroutineClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;
typedef struct _ValaTypeSymbolPrivate ValaTypeSymbolPrivate;
typedef struct _ValaErrorDomainPrivate ValaErrorDomainPrivate;

#define VALA_TYPE_ERROR_CODE (vala_error_code_get_type ())
#define VALA_ERROR_CODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_CODE, ValaErrorCode))
#define VALA_ERROR_CODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_CODE, ValaErrorCodeClass))
#define VALA_IS_ERROR_CODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_CODE))
#define VALA_IS_ERROR_CODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_CODE))
#define VALA_ERROR_CODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_CODE, ValaErrorCodeClass))

typedef struct _ValaErrorCode ValaErrorCode;
typedef struct _ValaErrorCodeClass ValaErrorCodeClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_CREATION_METHOD (vala_creation_method_get_type ())
#define VALA_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethod))
#define VALA_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))
#define VALA_IS_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CREATION_METHOD))
#define VALA_IS_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CREATION_METHOD))
#define VALA_CREATION_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))

typedef struct _ValaCreationMethod ValaCreationMethod;
typedef struct _ValaCreationMethodClass ValaCreationMethodClass;

#define VALA_TYPE_MEMBER_BINDING (vala_member_binding_get_type ())

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;

#define VALA_TYPE_ERROR_TYPE (vala_error_type_get_type ())
#define VALA_ERROR_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_TYPE, ValaErrorType))
#define VALA_ERROR_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_TYPE, ValaErrorTypeClass))
#define VALA_IS_ERROR_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_TYPE))
#define VALA_IS_ERROR_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_TYPE))
#define VALA_ERROR_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_TYPE, ValaErrorTypeClass))

typedef struct _ValaErrorType ValaErrorType;
typedef struct _ValaErrorTypeClass ValaErrorTypeClass;

#define VALA_TYPE_PARAMETER (vala_parameter_get_type ())
#define VALA_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PARAMETER, ValaParameter))
#define VALA_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PARAMETER, ValaParameterClass))
#define VALA_IS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PARAMETER))
#define VALA_IS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PARAMETER))
#define VALA_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PARAMETER, ValaParameterClass))

typedef struct _ValaParameter ValaParameter;
typedef struct _ValaParameterClass ValaParameterClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaCodeContext* context);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	gchar* (*get_cprefix) (ValaSymbol* self);
	gchar* (*get_lower_case_cname) (ValaSymbol* self, const gchar* infix);
	gchar* (*get_lower_case_cprefix) (ValaSymbol* self);
	ValaList* (*get_cheader_filenames) (ValaSymbol* self);
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*process_deprecated_attribute) (ValaSymbol* self, ValaAttribute* attr);
	void (*process_experimental_attribute) (ValaSymbol* self, ValaAttribute* attr);
	void (*add_namespace) (ValaSymbol* self, ValaNamespace* ns);
	void (*add_class) (ValaSymbol* self, ValaClass* cl);
	void (*add_interface) (ValaSymbol* self, ValaInterface* iface);
	void (*add_struct) (ValaSymbol* self, ValaStruct* st);
	void (*add_enum) (ValaSymbol* self, ValaEnum* en);
	void (*add_error_domain) (ValaSymbol* self, ValaErrorDomain* edomain);
	void (*add_delegate) (ValaSymbol* self, ValaDelegate* d);
	void (*add_constant) (ValaSymbol* self, ValaConstant* constant);
	void (*add_field) (ValaSymbol* self, ValaField* f);
	void (*add_method) (ValaSymbol* self, ValaMethod* m);
	void (*add_property) (ValaSymbol* self, ValaProperty* prop);
	void (*add_signal) (ValaSymbol* self, ValaSignal* sig);
	void (*add_constructor) (ValaSymbol* self, ValaConstructor* c);
	void (*add_destructor) (ValaSymbol* self, ValaDestructor* d);
};

struct _ValaTypeSymbol {
	ValaSymbol parent_instance;
	ValaTypeSymbolPrivate * priv;
};

struct _ValaTypeSymbolClass {
	ValaSymbolClass parent_class;
	gchar* (*get_cname) (ValaTypeSymbol* self, gboolean const_type);
	gboolean (*is_reference_type) (ValaTypeSymbol* self);
	gchar* (*get_dup_function) (ValaTypeSymbol* self);
	gchar* (*get_free_function) (ValaTypeSymbol* self);
	gchar* (*get_copy_function) (ValaTypeSymbol* self);
	gchar* (*get_destroy_function) (ValaTypeSymbol* self);
	gboolean (*is_reference_counting) (ValaTypeSymbol* self);
	gchar* (*get_ref_function) (ValaTypeSymbol* self);
	gchar* (*get_unref_function) (ValaTypeSymbol* self);
	gchar* (*get_ref_sink_function) (ValaTypeSymbol* self);
	gchar* (*get_type_id) (ValaTypeSymbol* self);
	gchar* (*get_marshaller_type_name) (ValaTypeSymbol* self);
	gchar* (*get_param_spec_function) (ValaTypeSymbol* self);
	gchar* (*get_get_value_function) (ValaTypeSymbol* self);
	gchar* (*get_set_value_function) (ValaTypeSymbol* self);
	gchar* (*get_take_value_function) (ValaTypeSymbol* self);
	gchar* (*get_upper_case_cname) (ValaTypeSymbol* self, const gchar* infix);
	gchar* (*get_default_value) (ValaTypeSymbol* self);
	gboolean (*is_subtype_of) (ValaTypeSymbol* self, ValaTypeSymbol* t);
	gint (*get_type_parameter_index) (ValaTypeSymbol* self, const gchar* name);
};

struct _ValaErrorDomain {
	ValaTypeSymbol parent_instance;
	ValaErrorDomainPrivate * priv;
};

struct _ValaErrorDomainClass {
	ValaTypeSymbolClass parent_class;
};

struct _ValaErrorDomainPrivate {
	ValaList* codes;
	ValaList* methods;
	gchar* cname;
	gchar* cprefix;
	gchar* lower_case_cprefix;
	gchar* lower_case_csuffix;
};

typedef enum  {
	VALA_MEMBER_BINDING_INSTANCE,
	VALA_MEMBER_BINDING_CLASS,
	VALA_MEMBER_BINDING_STATIC
} ValaMemberBinding;


static gpointer vala_error_domain_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_local_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_object_type_symbol_get_type (void) G_GNUC_CONST;
GType vala_class_get_type (void) G_GNUC_CONST;
GType vala_interface_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_error_domain_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_subroutine_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_property_get_type (void) G_GNUC_CONST;
GType vala_signal_get_type (void) G_GNUC_CONST;
GType vala_constructor_get_type (void) G_GNUC_CONST;
GType vala_destructor_get_type (void) G_GNUC_CONST;
GType vala_error_code_get_type (void) G_GNUC_CONST;
#define VALA_ERROR_DOMAIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainPrivate))
enum  {
	VALA_ERROR_DOMAIN_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
ValaErrorDomain* vala_error_domain_new (const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
ValaErrorDomain* vala_error_domain_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
ValaTypeSymbol* vala_typesymbol_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
void vala_error_domain_add_code (ValaErrorDomain* self, ValaErrorCode* ecode);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
void vala_scope_add (ValaScope* self, const gchar* name, ValaSymbol* sym);
const gchar* vala_symbol_get_name (ValaSymbol* self);
static void vala_error_domain_real_add_method (ValaSymbol* base, ValaMethod* m);
GType vala_creation_method_get_type (void) G_GNUC_CONST;
void vala_report_error (ValaSourceReference* source, const gchar* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
GType vala_member_binding_get_type (void) G_GNUC_CONST;
ValaMemberBinding vala_method_get_binding (ValaMethod* self);
ValaErrorType* vala_error_type_new (ValaErrorDomain* error_domain, ValaErrorCode* error_code, ValaSourceReference* source_reference);
ValaErrorType* vala_error_type_construct (GType object_type, ValaErrorDomain* error_domain, ValaErrorCode* error_code, ValaSourceReference* source_reference);
GType vala_reference_type_get_type (void) G_GNUC_CONST;
GType vala_error_type_get_type (void) G_GNUC_CONST;
ValaParameter* vala_parameter_new (const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference);
ValaParameter* vala_parameter_construct (GType object_type, const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference);
GType vala_parameter_get_type (void) G_GNUC_CONST;
void vala_method_set_this_parameter (ValaMethod* self, ValaParameter* value);
ValaParameter* vala_method_get_this_parameter (ValaMethod* self);
ValaList* vala_error_domain_get_codes (ValaErrorDomain* self);
ValaList* vala_error_domain_get_methods (ValaErrorDomain* self);
static void vala_error_domain_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_error_domain (ValaCodeVisitor* self, ValaErrorDomain* edomain);
static void vala_error_domain_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
static gchar* vala_error_domain_real_get_cname (ValaTypeSymbol* base, gboolean const_type);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
gchar* vala_symbol_get_cprefix (ValaSymbol* self);
static gchar* vala_error_domain_real_get_lower_case_cprefix (ValaSymbol* base);
gchar* vala_symbol_get_lower_case_cname (ValaSymbol* self, const gchar* infix);
static gchar* vala_error_domain_get_lower_case_csuffix (ValaErrorDomain* self);
gchar* vala_symbol_camel_case_to_lower_case (const gchar* camel_case);
static gchar* vala_error_domain_real_get_lower_case_cname (ValaSymbol* base, const gchar* infix);
gchar* vala_symbol_get_lower_case_cprefix (ValaSymbol* self);
static gchar* vala_error_domain_real_get_upper_case_cname (ValaTypeSymbol* base, const gchar* infix);
static gboolean vala_error_domain_real_is_reference_type (ValaTypeSymbol* base);
void vala_error_domain_set_cname (ValaErrorDomain* self, const gchar* cname);
static gchar* vala_error_domain_real_get_cprefix (ValaSymbol* base);
gchar* vala_typesymbol_get_upper_case_cname (ValaTypeSymbol* self, const gchar* infix);
void vala_error_domain_set_cprefix (ValaErrorDomain* self, const gchar* cprefix);
static void vala_error_domain_process_ccode_attribute (ValaErrorDomain* self, ValaAttribute* a);
gboolean vala_attribute_has_argument (ValaAttribute* self, const gchar* name);
gchar* vala_attribute_get_string (ValaAttribute* self, const gchar* name);
void vala_symbol_add_cheader_filename (ValaSymbol* self, const gchar* filename);
void vala_error_domain_process_attributes (ValaErrorDomain* self);
const gchar* vala_attribute_get_name (ValaAttribute* self);
void vala_symbol_process_deprecated_attribute (ValaSymbol* self, ValaAttribute* attr);
void vala_symbol_process_experimental_attribute (ValaSymbol* self, ValaAttribute* attr);
static gchar* vala_error_domain_real_get_type_id (ValaTypeSymbol* base);
static gchar* vala_error_domain_real_get_marshaller_type_name (ValaTypeSymbol* base);
static gchar* vala_error_domain_real_get_get_value_function (ValaTypeSymbol* base);
static gchar* vala_error_domain_real_get_set_value_function (ValaTypeSymbol* base);
static gboolean vala_error_domain_real_check (ValaCodeNode* base, ValaCodeContext* context);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaCodeContext* context);
static void vala_error_domain_finalize (ValaCodeNode* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * Creates a new error domain.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @return                 newly created error domain
 */
ValaErrorDomain* vala_error_domain_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaErrorDomain* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaErrorDomain*) vala_typesymbol_construct (object_type, name, source_reference, comment);
	return self;
}


ValaErrorDomain* vala_error_domain_new (const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_error_domain_construct (VALA_TYPE_ERROR_DOMAIN, name, source_reference, comment);
}


/**
 * Appends the specified code to the list of error codes.
 *
 * @param ecode an error code
 */
void vala_error_domain_add_code (ValaErrorDomain* self, ValaErrorCode* ecode) {
	ValaScope* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ecode != NULL);
	vala_collection_add ((ValaCollection*) self->priv->codes, ecode);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp1_ = vala_symbol_get_name ((ValaSymbol*) ecode);
	vala_scope_add (_tmp0_, _tmp1_, (ValaSymbol*) ecode);
}


/**
 * Adds the specified method as a member to this error domain.
 *
 * @param m a method
 */
static void vala_error_domain_real_add_method (ValaSymbol* base, ValaMethod* m) {
	ValaErrorDomain * self;
	ValaMemberBinding _tmp1_;
	ValaScope* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	self = (ValaErrorDomain*) base;
	g_return_if_fail (m != NULL);
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaSourceReference* _tmp0_ = NULL;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		vala_report_error (_tmp0_, "construction methods may only be declared within classes and structs");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	}
	_tmp1_ = vala_method_get_binding (m);
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaErrorType* _tmp2_ = NULL;
		ValaErrorType* _tmp3_;
		ValaParameter* _tmp4_ = NULL;
		ValaParameter* _tmp5_;
		ValaScope* _tmp6_ = NULL;
		ValaParameter* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		ValaParameter* _tmp9_ = NULL;
		_tmp2_ = vala_error_type_new (self, NULL, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_parameter_new ("this", (ValaDataType*) _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		vala_method_set_this_parameter (m, _tmp5_);
		_vala_code_node_unref0 (_tmp5_);
		_vala_code_node_unref0 (_tmp3_);
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp7_ = vala_method_get_this_parameter (m);
		_tmp8_ = vala_symbol_get_name ((ValaSymbol*) _tmp7_);
		_tmp9_ = vala_method_get_this_parameter (m);
		vala_scope_add (_tmp6_, _tmp8_, (ValaSymbol*) _tmp9_);
	}
	vala_collection_add ((ValaCollection*) self->priv->methods, m);
	_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) m);
	vala_scope_add (_tmp10_, _tmp11_, (ValaSymbol*) m);
}


/**
 * Returns a copy of the list of error codes.
 *
 * @return list of error codes
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_error_domain_get_codes (ValaErrorDomain* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->codes);
	result = _tmp0_;
	return result;
}


/**
 * Returns a copy of the list of methods.
 *
 * @return list of methods
 */
ValaList* vala_error_domain_get_methods (ValaErrorDomain* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->methods);
	result = _tmp0_;
	return result;
}


static void vala_error_domain_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaErrorDomain * self;
	self = (ValaErrorDomain*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_error_domain (visitor, self);
}


static void vala_error_domain_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaErrorDomain * self;
	self = (ValaErrorDomain*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _tmp0_;
		ValaList* _ecode_list;
		gint _tmp1_;
		gint _ecode_size;
		gint _ecode_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->codes);
		_ecode_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _ecode_list);
		_ecode_size = _tmp1_;
		_ecode_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			ValaErrorCode* ecode;
			_ecode_index = _ecode_index + 1;
			if (!(_ecode_index < _ecode_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_ecode_list, _ecode_index);
			ecode = (ValaErrorCode*) _tmp2_;
			vala_code_node_accept ((ValaCodeNode*) ecode, visitor);
			_vala_code_node_unref0 (ecode);
		}
		_vala_iterable_unref0 (_ecode_list);
	}
	{
		ValaList* _tmp3_;
		ValaList* _m_list;
		gint _tmp4_;
		gint _m_size;
		gint _m_index;
		_tmp3_ = _vala_iterable_ref0 (self->priv->methods);
		_m_list = _tmp3_;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _m_list);
		_m_size = _tmp4_;
		_m_index = -1;
		while (TRUE) {
			gpointer _tmp5_ = NULL;
			ValaMethod* m;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp5_ = vala_list_get (_m_list, _m_index);
			m = (ValaMethod*) _tmp5_;
			vala_code_node_accept ((ValaCodeNode*) m, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
}


static gchar* vala_error_domain_real_get_cname (ValaTypeSymbol* base, gboolean const_type) {
	ValaErrorDomain * self;
	gchar* result = NULL;
	gchar* _tmp5_;
	self = (ValaErrorDomain*) base;
	if (self->priv->cname == NULL) {
		ValaSymbol* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp1_ = vala_symbol_get_cprefix (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp4_ = g_strdup_printf ("%s%s", _tmp2_, _tmp3_);
		_g_free0 (self->priv->cname);
		self->priv->cname = _tmp4_;
		_g_free0 (_tmp2_);
	}
	_tmp5_ = g_strdup (self->priv->cname);
	result = _tmp5_;
	return result;
}


static gchar* vala_error_domain_real_get_lower_case_cprefix (ValaSymbol* base) {
	ValaErrorDomain * self;
	gchar* result = NULL;
	gchar* _tmp3_;
	self = (ValaErrorDomain*) base;
	if (self->priv->lower_case_cprefix == NULL) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		_tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, NULL);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strdup_printf ("%s_", _tmp1_);
		_g_free0 (self->priv->lower_case_cprefix);
		self->priv->lower_case_cprefix = _tmp2_;
		_g_free0 (_tmp1_);
	}
	_tmp3_ = g_strdup (self->priv->lower_case_cprefix);
	result = _tmp3_;
	return result;
}


static gchar* vala_error_domain_get_lower_case_csuffix (ValaErrorDomain* self) {
	gchar* result = NULL;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->lower_case_csuffix == NULL) {
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		_tmp0_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp1_ = vala_symbol_camel_case_to_lower_case (_tmp0_);
		_g_free0 (self->priv->lower_case_csuffix);
		self->priv->lower_case_csuffix = _tmp1_;
	}
	_tmp2_ = g_strdup (self->priv->lower_case_csuffix);
	result = _tmp2_;
	return result;
}


static gchar* vala_error_domain_real_get_lower_case_cname (ValaSymbol* base, const gchar* infix) {
	ValaErrorDomain * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* cprefix;
	ValaSymbol* _tmp1_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	self = (ValaErrorDomain*) base;
	if (infix == NULL) {
		infix = "";
	}
	_tmp0_ = g_strdup ("");
	cprefix = _tmp0_;
	_tmp1_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	if (_tmp1_ != NULL) {
		ValaSymbol* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp3_ = vala_symbol_get_lower_case_cprefix (_tmp2_);
		_g_free0 (cprefix);
		cprefix = _tmp3_;
	}
	_tmp4_ = vala_error_domain_get_lower_case_csuffix (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%s%s%s", cprefix, infix, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	result = _tmp7_;
	_g_free0 (cprefix);
	return result;
}


static gchar* vala_error_domain_real_get_upper_case_cname (ValaTypeSymbol* base, const gchar* infix) {
	ValaErrorDomain * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	self = (ValaErrorDomain*) base;
	_tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, infix);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_strup (_tmp1_, (gssize) (-1));
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static gboolean vala_error_domain_real_is_reference_type (ValaTypeSymbol* base) {
	ValaErrorDomain * self;
	gboolean result = FALSE;
	self = (ValaErrorDomain*) base;
	result = FALSE;
	return result;
}


void vala_error_domain_set_cname (ValaErrorDomain* self, const gchar* cname) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	_tmp0_ = g_strdup (cname);
	_g_free0 (self->priv->cname);
	self->priv->cname = _tmp0_;
}


static gchar* vala_error_domain_real_get_cprefix (ValaSymbol* base) {
	ValaErrorDomain * self;
	gchar* result = NULL;
	gchar* _tmp3_;
	self = (ValaErrorDomain*) base;
	if (self->priv->cprefix == NULL) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		_tmp0_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) self, NULL);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strdup_printf ("%s_", _tmp1_);
		_g_free0 (self->priv->cprefix);
		self->priv->cprefix = _tmp2_;
		_g_free0 (_tmp1_);
	}
	_tmp3_ = g_strdup (self->priv->cprefix);
	result = _tmp3_;
	return result;
}


/**
 * Sets the string to be prepended to the name of members of this error
 * domain when used in C code.
 *
 * @param cprefix the prefix to be used in C code
 */
void vala_error_domain_set_cprefix (ValaErrorDomain* self, const gchar* cprefix) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cprefix != NULL);
	_tmp0_ = g_strdup (cprefix);
	_g_free0 (self->priv->cprefix);
	self->priv->cprefix = _tmp0_;
}


static void vala_error_domain_process_ccode_attribute (ValaErrorDomain* self, ValaAttribute* a) {
	gboolean _tmp0_;
	gboolean _tmp3_;
	gboolean _tmp6_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	_tmp0_ = vala_attribute_has_argument (a, "cname");
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = vala_attribute_get_string (a, "cname");
		_tmp2_ = _tmp1_;
		vala_error_domain_set_cname (self, _tmp2_);
		_g_free0 (_tmp2_);
	}
	_tmp3_ = vala_attribute_has_argument (a, "cprefix");
	if (_tmp3_) {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp4_ = vala_attribute_get_string (a, "cprefix");
		_tmp5_ = _tmp4_;
		vala_error_domain_set_cprefix (self, _tmp5_);
		_g_free0 (_tmp5_);
	}
	_tmp6_ = vala_attribute_has_argument (a, "lower_case_csuffix");
	if (_tmp6_) {
		gchar* _tmp7_ = NULL;
		_tmp7_ = vala_attribute_get_string (a, "lower_case_csuffix");
		_g_free0 (self->priv->lower_case_csuffix);
		self->priv->lower_case_csuffix = _tmp7_;
	}
	_tmp8_ = vala_attribute_has_argument (a, "cheader_filename");
	if (_tmp8_) {
		gchar* _tmp9_ = NULL;
		gchar* val;
		gchar** _tmp10_;
		gchar** _tmp11_ = NULL;
		_tmp9_ = vala_attribute_get_string (a, "cheader_filename");
		val = _tmp9_;
		_tmp11_ = _tmp10_ = g_strsplit (val, ",", 0);
		{
			gchar** filename_collection = NULL;
			gint filename_collection_length1 = 0;
			gint _filename_collection_size_ = 0;
			gint filename_it;
			filename_collection = _tmp11_;
			filename_collection_length1 = _vala_array_length (_tmp10_);
			for (filename_it = 0; filename_it < _vala_array_length (_tmp10_); filename_it = filename_it + 1) {
				gchar* _tmp12_;
				gchar* filename = NULL;
				_tmp12_ = g_strdup (filename_collection[filename_it]);
				filename = _tmp12_;
				{
					vala_symbol_add_cheader_filename ((ValaSymbol*) self, filename);
					_g_free0 (filename);
				}
			}
			filename_collection = (_vala_array_free (filename_collection, filename_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (val);
	}
}


/**
 * Process all associated attributes.
 */
static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_error_domain_process_attributes (ValaErrorDomain* self) {
	g_return_if_fail (self != NULL);
	{
		GList* a_collection = NULL;
		GList* a_it = NULL;
		a_collection = ((ValaCodeNode*) self)->attributes;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* _tmp0_;
			ValaAttribute* a = NULL;
			_tmp0_ = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
			a = _tmp0_;
			{
				const gchar* _tmp1_ = NULL;
				_tmp1_ = vala_attribute_get_name (a);
				if (g_strcmp0 (_tmp1_, "CCode") == 0) {
					vala_error_domain_process_ccode_attribute (self, a);
				} else {
					const gchar* _tmp2_ = NULL;
					_tmp2_ = vala_attribute_get_name (a);
					if (g_strcmp0 (_tmp2_, "Deprecated") == 0) {
						vala_symbol_process_deprecated_attribute ((ValaSymbol*) self, a);
					} else {
						const gchar* _tmp3_ = NULL;
						_tmp3_ = vala_attribute_get_name (a);
						if (g_strcmp0 (_tmp3_, "Experimental") == 0) {
							vala_symbol_process_experimental_attribute ((ValaSymbol*) self, a);
						}
					}
				}
				_vala_code_node_unref0 (a);
			}
		}
	}
}


static gchar* vala_error_domain_real_get_type_id (ValaTypeSymbol* base) {
	ValaErrorDomain * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (ValaErrorDomain*) base;
	_tmp0_ = g_strdup ("G_TYPE_POINTER");
	result = _tmp0_;
	return result;
}


static gchar* vala_error_domain_real_get_marshaller_type_name (ValaTypeSymbol* base) {
	ValaErrorDomain * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (ValaErrorDomain*) base;
	_tmp0_ = g_strdup ("POINTER");
	result = _tmp0_;
	return result;
}


static gchar* vala_error_domain_real_get_get_value_function (ValaTypeSymbol* base) {
	ValaErrorDomain * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (ValaErrorDomain*) base;
	_tmp0_ = g_strdup ("g_value_get_pointer");
	result = _tmp0_;
	return result;
}


static gchar* vala_error_domain_real_get_set_value_function (ValaTypeSymbol* base) {
	ValaErrorDomain * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (ValaErrorDomain*) base;
	_tmp0_ = g_strdup ("g_value_set_pointer");
	result = _tmp0_;
	return result;
}


static gboolean vala_error_domain_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaErrorDomain * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp8_;
	self = (ValaErrorDomain*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = vala_code_node_get_error ((ValaCodeNode*) self);
		result = !_tmp1_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	vala_error_domain_process_attributes (self);
	{
		ValaList* _tmp2_;
		ValaList* _ecode_list;
		gint _tmp3_;
		gint _ecode_size;
		gint _ecode_index;
		_tmp2_ = _vala_iterable_ref0 (self->priv->codes);
		_ecode_list = _tmp2_;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _ecode_list);
		_ecode_size = _tmp3_;
		_ecode_index = -1;
		while (TRUE) {
			gpointer _tmp4_ = NULL;
			ValaErrorCode* ecode;
			_ecode_index = _ecode_index + 1;
			if (!(_ecode_index < _ecode_size)) {
				break;
			}
			_tmp4_ = vala_list_get (_ecode_list, _ecode_index);
			ecode = (ValaErrorCode*) _tmp4_;
			vala_code_node_check ((ValaCodeNode*) ecode, context);
			_vala_code_node_unref0 (ecode);
		}
		_vala_iterable_unref0 (_ecode_list);
	}
	{
		ValaList* _tmp5_;
		ValaList* _m_list;
		gint _tmp6_;
		gint _m_size;
		gint _m_index;
		_tmp5_ = _vala_iterable_ref0 (self->priv->methods);
		_m_list = _tmp5_;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _m_list);
		_m_size = _tmp6_;
		_m_index = -1;
		while (TRUE) {
			gpointer _tmp7_ = NULL;
			ValaMethod* m;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp7_ = vala_list_get (_m_list, _m_index);
			m = (ValaMethod*) _tmp7_;
			vala_code_node_check ((ValaCodeNode*) m, context);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	_tmp8_ = vala_code_node_get_error ((ValaCodeNode*) self);
	result = !_tmp8_;
	return result;
}


static void vala_error_domain_class_init (ValaErrorDomainClass * klass) {
	vala_error_domain_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_error_domain_finalize;
	g_type_class_add_private (klass, sizeof (ValaErrorDomainPrivate));
	VALA_SYMBOL_CLASS (klass)->add_method = vala_error_domain_real_add_method;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_error_domain_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_error_domain_real_accept_children;
	VALA_TYPESYMBOL_CLASS (klass)->get_cname = vala_error_domain_real_get_cname;
	VALA_SYMBOL_CLASS (klass)->get_lower_case_cprefix = vala_error_domain_real_get_lower_case_cprefix;
	VALA_SYMBOL_CLASS (klass)->get_lower_case_cname = vala_error_domain_real_get_lower_case_cname;
	VALA_TYPESYMBOL_CLASS (klass)->get_upper_case_cname = vala_error_domain_real_get_upper_case_cname;
	VALA_TYPESYMBOL_CLASS (klass)->is_reference_type = vala_error_domain_real_is_reference_type;
	VALA_SYMBOL_CLASS (klass)->get_cprefix = vala_error_domain_real_get_cprefix;
	VALA_TYPESYMBOL_CLASS (klass)->get_type_id = vala_error_domain_real_get_type_id;
	VALA_TYPESYMBOL_CLASS (klass)->get_marshaller_type_name = vala_error_domain_real_get_marshaller_type_name;
	VALA_TYPESYMBOL_CLASS (klass)->get_get_value_function = vala_error_domain_real_get_get_value_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_set_value_function = vala_error_domain_real_get_set_value_function;
	VALA_CODE_NODE_CLASS (klass)->check = vala_error_domain_real_check;
}


static void vala_error_domain_instance_init (ValaErrorDomain * self) {
	ValaArrayList* _tmp0_ = NULL;
	ValaArrayList* _tmp1_ = NULL;
	self->priv = VALA_ERROR_DOMAIN_GET_PRIVATE (self);
	_tmp0_ = vala_array_list_new (VALA_TYPE_ERROR_CODE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->codes = (ValaList*) _tmp0_;
	_tmp1_ = vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->methods = (ValaList*) _tmp1_;
}


static void vala_error_domain_finalize (ValaCodeNode* obj) {
	ValaErrorDomain * self;
	self = VALA_ERROR_DOMAIN (obj);
	_vala_iterable_unref0 (self->priv->codes);
	_vala_iterable_unref0 (self->priv->methods);
	_g_free0 (self->priv->cname);
	_g_free0 (self->priv->cprefix);
	_g_free0 (self->priv->lower_case_cprefix);
	_g_free0 (self->priv->lower_case_csuffix);
	VALA_CODE_NODE_CLASS (vala_error_domain_parent_class)->finalize (obj);
}


/**
 * Represents an error domain declaration in the source code.
 */
GType vala_error_domain_get_type (void) {
	static volatile gsize vala_error_domain_type_id__volatile = 0;
	if (g_once_init_enter (&vala_error_domain_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaErrorDomainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_error_domain_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaErrorDomain), 0, (GInstanceInitFunc) vala_error_domain_instance_init, NULL };
		GType vala_error_domain_type_id;
		vala_error_domain_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaErrorDomain", &g_define_type_info, 0);
		g_once_init_leave (&vala_error_domain_type_id__volatile, vala_error_domain_type_id);
	}
	return vala_error_domain_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



