/* valavapigen.c generated by valac, the Vala compiler
 * generated from valavapigen.vala, do not modify */

/* valavapigen.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <valagee.h>
#include <version.h>


#define VALA_TYPE_VAPI_GEN (vala_vapi_gen_get_type ())
#define VALA_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGen))
#define VALA_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))
#define VALA_IS_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VAPI_GEN))
#define VALA_IS_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VAPI_GEN))
#define VALA_VAPI_GEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))

typedef struct _ValaVAPIGen ValaVAPIGen;
typedef struct _ValaVAPIGenClass ValaVAPIGenClass;
typedef struct _ValaVAPIGenPrivate ValaVAPIGenPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))

typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _ValaVAPIGen {
	GObject parent_instance;
	ValaVAPIGenPrivate * priv;
};

struct _ValaVAPIGenClass {
	GObjectClass parent_class;
};

struct _ValaVAPIGenPrivate {
	ValaCodeContext* context;
};


static gpointer vala_vapi_gen_parent_class = NULL;
static gchar* vala_vapi_gen_directory;
static gchar* vala_vapi_gen_directory = NULL;
static gboolean vala_vapi_gen_version;
static gboolean vala_vapi_gen_version = FALSE;
static gboolean vala_vapi_gen_quiet_mode;
static gboolean vala_vapi_gen_quiet_mode = FALSE;
static gboolean vala_vapi_gen_disable_warnings;
static gboolean vala_vapi_gen_disable_warnings = FALSE;
static gchar** vala_vapi_gen_sources;
static gchar** vala_vapi_gen_sources = NULL;
static gchar** vala_vapi_gen_vapi_directories;
static gchar** vala_vapi_gen_vapi_directories = NULL;
static gchar** vala_vapi_gen_gir_directories;
static gchar** vala_vapi_gen_gir_directories = NULL;
static gchar* vala_vapi_gen_library;
static gchar* vala_vapi_gen_library = NULL;
static gchar** vala_vapi_gen_packages;
static gchar** vala_vapi_gen_packages = NULL;

GType vala_vapi_gen_get_type (void) G_GNUC_CONST;
#define VALA_VAPI_GEN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_VAPI_GEN, ValaVAPIGenPrivate))
enum  {
	VALA_VAPI_GEN_DUMMY_PROPERTY
};
static gint vala_vapi_gen_quit (ValaVAPIGen* self);
static gint vala_vapi_gen_run (ValaVAPIGen* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
ValaGIdlParser* vala_gidl_parser_new (void);
ValaGIdlParser* vala_gidl_parser_construct (GType object_type);
GType vala_gidl_parser_get_type (void) G_GNUC_CONST;
void vala_gidl_parser_parse (ValaGIdlParser* self, ValaCodeContext* context);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static gint vala_vapi_gen_main (gchar** args, int args_length1);
ValaVAPIGen* vala_vapi_gen_new (void);
ValaVAPIGen* vala_vapi_gen_construct (GType object_type);
static void vala_vapi_gen_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_VAPI_GEN_options[10] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_gir_directories, "Look for GIR bindings in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_vapi_gen_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_vapi_gen_library, "Library name", "NAME"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_vapi_gen_directory, "Output directory", "DIRECTORY"}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_disable_warnings, "Disable warnings", NULL}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_version, "Display version number", NULL}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_vapi_gen_quiet_mode, "Do not print messages to the console", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_sources, NULL, "FILE..."}, {NULL}};

static gint vala_vapi_gen_quit (ValaVAPIGen* self) {
	gint result = 0;
	ValaReport* _tmp0_ = NULL;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_get_report (self->priv->context);
	_tmp1_ = vala_report_get_errors (_tmp0_);
	if (_tmp1_ == 0) {
		if (!vala_vapi_gen_quiet_mode) {
			ValaReport* _tmp2_ = NULL;
			gint _tmp3_;
			_tmp2_ = vala_code_context_get_report (self->priv->context);
			_tmp3_ = vala_report_get_warnings (_tmp2_);
			fprintf (stdout, "Generation succeeded - %d warning(s)\n", _tmp3_);
		}
		result = 0;
		return result;
	} else {
		if (!vala_vapi_gen_quiet_mode) {
			ValaReport* _tmp4_ = NULL;
			gint _tmp5_;
			ValaReport* _tmp6_ = NULL;
			gint _tmp7_;
			_tmp4_ = vala_code_context_get_report (self->priv->context);
			_tmp5_ = vala_report_get_errors (_tmp4_);
			_tmp6_ = vala_code_context_get_report (self->priv->context);
			_tmp7_ = vala_report_get_warnings (_tmp6_);
			fprintf (stdout, "Generation failed: %d error(s), %d warning(s)\n", _tmp5_, _tmp7_);
		}
		result = 1;
		return result;
	}
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static gint vala_vapi_gen_run (ValaVAPIGen* self) {
	gint result = 0;
	ValaCodeContext* _tmp0_ = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	ValaReport* _tmp5_ = NULL;
	ValaReport* _tmp6_ = NULL;
	ValaReport* _tmp7_ = NULL;
	gint _tmp8_;
	ValaReport* _tmp18_ = NULL;
	gint _tmp19_;
	ValaReport* _tmp22_ = NULL;
	gint _tmp23_;
	ValaReport* _tmp26_ = NULL;
	gint _tmp27_;
	ValaReport* _tmp35_ = NULL;
	gint _tmp36_;
	ValaParser* _tmp38_ = NULL;
	ValaParser* parser;
	ValaReport* _tmp39_ = NULL;
	gint _tmp40_;
	ValaGirParser* _tmp42_ = NULL;
	ValaGirParser* girparser;
	ValaReport* _tmp43_ = NULL;
	gint _tmp44_;
	ValaGIdlParser* _tmp46_ = NULL;
	ValaGIdlParser* gidlparser;
	ValaReport* _tmp47_ = NULL;
	gint _tmp48_;
	ValaReport* _tmp50_ = NULL;
	gint _tmp51_;
	ValaCodeWriter* _tmp69_ = NULL;
	ValaCodeWriter* interface_writer;
	gchar* _tmp70_ = NULL;
	gchar* vapi_filename;
	gint _tmp72_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	vala_code_context_set_profile (self->priv->context, VALA_PROFILE_GOBJECT);
	_tmp1_ = (_tmp2_ = vala_vapi_gen_vapi_directories, (_tmp2_ == NULL) ? ((gpointer) _tmp2_) : _vala_array_dup1 (_tmp2_, _vala_array_length (vala_vapi_gen_vapi_directories)));
	self->priv->context->vapi_directories = (_vala_array_free (self->priv->context->vapi_directories, self->priv->context->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	self->priv->context->vapi_directories = _tmp1_;
	self->priv->context->vapi_directories_length1 = _vala_array_length (vala_vapi_gen_vapi_directories);
	_tmp3_ = (_tmp4_ = vala_vapi_gen_gir_directories, (_tmp4_ == NULL) ? ((gpointer) _tmp4_) : _vala_array_dup2 (_tmp4_, _vala_array_length (vala_vapi_gen_gir_directories)));
	self->priv->context->gir_directories = (_vala_array_free (self->priv->context->gir_directories, self->priv->context->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	self->priv->context->gir_directories = _tmp3_;
	self->priv->context->gir_directories_length1 = _vala_array_length (vala_vapi_gen_gir_directories);
	_tmp5_ = vala_code_context_get_report (self->priv->context);
	vala_report_set_enable_warnings (_tmp5_, !vala_vapi_gen_disable_warnings);
	_tmp6_ = vala_code_context_get_report (self->priv->context);
	vala_report_set_verbose_errors (_tmp6_, !vala_vapi_gen_quiet_mode);
	vala_code_context_push (self->priv->context);
	vala_code_context_add_external_package (self->priv->context, "glib-2.0");
	vala_code_context_add_external_package (self->priv->context, "gobject-2.0");
	_tmp7_ = vala_code_context_get_report (self->priv->context);
	_tmp8_ = vala_report_get_errors (_tmp7_);
	if (_tmp8_ > 0) {
		gint _tmp9_;
		_tmp9_ = vala_vapi_gen_quit (self);
		result = _tmp9_;
		return result;
	}
	{
		gchar** source_collection;
		int source_collection_length1;
		int source_it;
		source_collection = vala_vapi_gen_sources;
		source_collection_length1 = _vala_array_length (vala_vapi_gen_sources);
		for (source_it = 0; source_it < _vala_array_length (vala_vapi_gen_sources); source_it = source_it + 1) {
			gchar* _tmp10_;
			gchar* source;
			_tmp10_ = g_strdup (source_collection[source_it]);
			source = _tmp10_;
			{
				gboolean _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* depsfile;
				_tmp11_ = g_str_has_suffix (source, ".gi");
				if (!_tmp11_) {
					_g_free0 (source);
					continue;
				}
				_tmp12_ = strlen (source);
				_tmp13_ = strlen ("gi");
				_tmp14_ = string_substring (source, (glong) 0, (glong) (_tmp12_ - _tmp13_));
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strconcat (_tmp15_, "deps", NULL);
				_tmp17_ = _tmp16_;
				_g_free0 (_tmp15_);
				depsfile = _tmp17_;
				vala_code_context_add_packages_from_file (self->priv->context, depsfile);
				_g_free0 (depsfile);
				_g_free0 (source);
			}
		}
	}
	_tmp18_ = vala_code_context_get_report (self->priv->context);
	_tmp19_ = vala_report_get_errors (_tmp18_);
	if (_tmp19_ > 0) {
		gint _tmp20_;
		_tmp20_ = vala_vapi_gen_quit (self);
		result = _tmp20_;
		return result;
	}
	if (vala_vapi_gen_library != NULL) {
		gchar* _tmp21_;
		gchar* depsfile;
		_tmp21_ = g_strconcat (vala_vapi_gen_library, ".deps", NULL);
		depsfile = _tmp21_;
		vala_code_context_add_packages_from_file (self->priv->context, depsfile);
		_g_free0 (depsfile);
	} else {
		vala_report_error (NULL, "--library option must be specified");
	}
	_tmp22_ = vala_code_context_get_report (self->priv->context);
	_tmp23_ = vala_report_get_errors (_tmp22_);
	if (_tmp23_ > 0) {
		gint _tmp24_;
		_tmp24_ = vala_vapi_gen_quit (self);
		result = _tmp24_;
		return result;
	}
	if (vala_vapi_gen_packages != NULL) {
		{
			gchar** package_collection;
			int package_collection_length1;
			int package_it;
			package_collection = vala_vapi_gen_packages;
			package_collection_length1 = _vala_array_length (vala_vapi_gen_packages);
			for (package_it = 0; package_it < _vala_array_length (vala_vapi_gen_packages); package_it = package_it + 1) {
				gchar* _tmp25_;
				gchar* package;
				_tmp25_ = g_strdup (package_collection[package_it]);
				package = _tmp25_;
				{
					vala_code_context_add_external_package (self->priv->context, package);
					_g_free0 (package);
				}
			}
		}
		vala_vapi_gen_packages = (_vala_array_free (vala_vapi_gen_packages, _vala_array_length (vala_vapi_gen_packages), (GDestroyNotify) g_free), NULL);
		vala_vapi_gen_packages = NULL;
	}
	_tmp26_ = vala_code_context_get_report (self->priv->context);
	_tmp27_ = vala_report_get_errors (_tmp26_);
	if (_tmp27_ > 0) {
		gint _tmp28_;
		_tmp28_ = vala_vapi_gen_quit (self);
		result = _tmp28_;
		return result;
	}
	{
		gchar** source_collection;
		int source_collection_length1;
		int source_it;
		source_collection = vala_vapi_gen_sources;
		source_collection_length1 = _vala_array_length (vala_vapi_gen_sources);
		for (source_it = 0; source_it < _vala_array_length (vala_vapi_gen_sources); source_it = source_it + 1) {
			gchar* _tmp29_;
			gchar* source;
			_tmp29_ = g_strdup (source_collection[source_it]);
			source = _tmp29_;
			{
				gboolean _tmp30_;
				_tmp30_ = g_file_test (source, G_FILE_TEST_EXISTS);
				if (_tmp30_) {
					ValaSourceFile* _tmp31_ = NULL;
					ValaSourceFile* _tmp32_;
					_tmp31_ = vala_source_file_new (self->priv->context, VALA_SOURCE_FILE_TYPE_PACKAGE, source, NULL);
					_tmp32_ = _tmp31_;
					vala_code_context_add_source_file (self->priv->context, _tmp32_);
					_vala_source_file_unref0 (_tmp32_);
				} else {
					gchar* _tmp33_ = NULL;
					gchar* _tmp34_;
					_tmp33_ = g_strdup_printf ("%s not found", source);
					_tmp34_ = _tmp33_;
					vala_report_error (NULL, _tmp34_);
					_g_free0 (_tmp34_);
				}
				_g_free0 (source);
			}
		}
	}
	_tmp35_ = vala_code_context_get_report (self->priv->context);
	_tmp36_ = vala_report_get_errors (_tmp35_);
	if (_tmp36_ > 0) {
		gint _tmp37_;
		_tmp37_ = vala_vapi_gen_quit (self);
		result = _tmp37_;
		return result;
	}
	_tmp38_ = vala_parser_new ();
	parser = _tmp38_;
	vala_parser_parse (parser, self->priv->context);
	_tmp39_ = vala_code_context_get_report (self->priv->context);
	_tmp40_ = vala_report_get_errors (_tmp39_);
	if (_tmp40_ > 0) {
		gint _tmp41_;
		_tmp41_ = vala_vapi_gen_quit (self);
		result = _tmp41_;
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp42_ = vala_gir_parser_new ();
	girparser = _tmp42_;
	vala_gir_parser_parse (girparser, self->priv->context);
	_tmp43_ = vala_code_context_get_report (self->priv->context);
	_tmp44_ = vala_report_get_errors (_tmp43_);
	if (_tmp44_ > 0) {
		gint _tmp45_;
		_tmp45_ = vala_vapi_gen_quit (self);
		result = _tmp45_;
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp46_ = vala_gidl_parser_new ();
	gidlparser = _tmp46_;
	vala_gidl_parser_parse (gidlparser, self->priv->context);
	_tmp47_ = vala_code_context_get_report (self->priv->context);
	_tmp48_ = vala_report_get_errors (_tmp47_);
	if (_tmp48_ > 0) {
		gint _tmp49_;
		_tmp49_ = vala_vapi_gen_quit (self);
		result = _tmp49_;
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	vala_code_context_check (self->priv->context);
	_tmp50_ = vala_code_context_get_report (self->priv->context);
	_tmp51_ = vala_report_get_errors (_tmp50_);
	if (_tmp51_ > 0) {
		gint _tmp52_;
		_tmp52_ = vala_vapi_gen_quit (self);
		result = _tmp52_;
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	{
		ValaList* _tmp53_ = NULL;
		ValaList* _file_list;
		gint _tmp54_;
		gint _file_size;
		gint _file_index;
		_tmp53_ = vala_code_context_get_source_files (self->priv->context);
		_file_list = _tmp53_;
		_tmp54_ = vala_collection_get_size ((ValaCollection*) _file_list);
		_file_size = _tmp54_;
		_file_index = -1;
		while (TRUE) {
			gpointer _tmp55_ = NULL;
			ValaSourceFile* file;
			const gchar* _tmp56_ = NULL;
			gboolean _tmp57_;
			const gchar* _tmp58_ = NULL;
			_file_index = _file_index + 1;
			if (!(_file_index < _file_size)) {
				break;
			}
			_tmp55_ = vala_list_get (_file_list, _file_index);
			file = (ValaSourceFile*) _tmp55_;
			_tmp56_ = vala_source_file_get_filename (file);
			_tmp57_ = g_str_has_suffix (_tmp56_, ".vapi");
			if (_tmp57_) {
				_vala_source_file_unref0 (file);
				continue;
			}
			_tmp58_ = vala_source_file_get_filename (file);
			if (_vala_string_array_contains (vala_vapi_gen_sources, _vala_array_length (vala_vapi_gen_sources), _tmp58_)) {
				vala_source_file_set_file_type (file, VALA_SOURCE_FILE_TYPE_SOURCE);
			} else {
				const gchar* _tmp59_ = NULL;
				gboolean _tmp60_;
				_tmp59_ = vala_source_file_get_filename (file);
				_tmp60_ = g_str_has_suffix (_tmp59_, ".metadata");
				if (_tmp60_) {
					const gchar* _tmp61_ = NULL;
					const gchar* _tmp62_ = NULL;
					gint _tmp63_;
					gint _tmp64_;
					gchar* _tmp65_ = NULL;
					gchar* _tmp66_;
					gchar* _tmp67_ = NULL;
					gchar* _tmp68_;
					gchar* gir_filename;
					_tmp61_ = vala_source_file_get_filename (file);
					_tmp62_ = vala_source_file_get_filename (file);
					_tmp63_ = strlen (_tmp62_);
					_tmp64_ = strlen (".metadata");
					_tmp65_ = string_substring (_tmp61_, (glong) 0, (glong) (_tmp63_ - _tmp64_));
					_tmp66_ = _tmp65_;
					_tmp67_ = g_strdup_printf ("%s.gir", _tmp66_);
					_tmp68_ = _tmp67_;
					_g_free0 (_tmp66_);
					gir_filename = _tmp68_;
					if (_vala_string_array_contains (vala_vapi_gen_sources, _vala_array_length (vala_vapi_gen_sources), gir_filename)) {
						vala_source_file_set_file_type (file, VALA_SOURCE_FILE_TYPE_SOURCE);
					}
					_g_free0 (gir_filename);
				}
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp69_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
	interface_writer = _tmp69_;
	_tmp70_ = g_strdup_printf ("%s.vapi", vala_vapi_gen_library);
	vapi_filename = _tmp70_;
	if (vala_vapi_gen_directory != NULL) {
		gchar* _tmp71_ = NULL;
		_tmp71_ = g_build_filename (vala_vapi_gen_directory, vapi_filename, NULL);
		_g_free0 (vapi_filename);
		vapi_filename = _tmp71_;
	}
	vala_code_writer_write_file (interface_writer, self->priv->context, vapi_filename);
	_g_free0 (vala_vapi_gen_library);
	vala_vapi_gen_library = NULL;
	_tmp72_ = vala_vapi_gen_quit (self);
	result = _tmp72_;
	_g_free0 (vapi_filename);
	_vala_code_visitor_unref0 (interface_writer);
	_vala_code_visitor_unref0 (gidlparser);
	_vala_code_visitor_unref0 (girparser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static gint vala_vapi_gen_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* opt_context;
	ValaVAPIGen* _tmp1_ = NULL;
	ValaVAPIGen* vapigen;
	gint _tmp2_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new ("- Vala API Generator");
	opt_context = _tmp0_;
	g_option_context_set_help_enabled (opt_context, TRUE);
	g_option_context_add_main_entries (opt_context, VALA_VAPI_GEN_options, NULL);
	g_option_context_parse (opt_context, &args_length1, &args, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (opt_context);
		if (_inner_error_->domain == G_OPTION_ERROR) {
			goto __catch3_g_option_error;
		}
		_g_option_context_free0 (opt_context);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_g_option_context_free0 (opt_context);
	goto __finally3;
	__catch3_g_option_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stdout, "%s\n", e->message);
		fprintf (stdout, "Run '%s --help' to see a full list of available command line options.\n", args[0]);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (vala_vapi_gen_version) {
		fprintf (stdout, "Vala API Generator %s\n", BUILD_VERSION);
		result = 0;
		return result;
	}
	if (vala_vapi_gen_sources == NULL) {
		fprintf (stderr, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp1_ = vala_vapi_gen_new ();
	vapigen = _tmp1_;
	_tmp2_ = vala_vapi_gen_run (vapigen);
	result = _tmp2_;
	_g_object_unref0 (vapigen);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return vala_vapi_gen_main (argv, argc);
}


ValaVAPIGen* vala_vapi_gen_construct (GType object_type) {
	ValaVAPIGen * self = NULL;
	self = (ValaVAPIGen*) g_object_new (object_type, NULL);
	return self;
}


ValaVAPIGen* vala_vapi_gen_new (void) {
	return vala_vapi_gen_construct (VALA_TYPE_VAPI_GEN);
}


static void vala_vapi_gen_class_init (ValaVAPIGenClass * klass) {
	vala_vapi_gen_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaVAPIGenPrivate));
	G_OBJECT_CLASS (klass)->finalize = vala_vapi_gen_finalize;
}


static void vala_vapi_gen_instance_init (ValaVAPIGen * self) {
	self->priv = VALA_VAPI_GEN_GET_PRIVATE (self);
}


static void vala_vapi_gen_finalize (GObject* obj) {
	ValaVAPIGen * self;
	self = VALA_VAPI_GEN (obj);
	_vala_code_context_unref0 (self->priv->context);
	G_OBJECT_CLASS (vala_vapi_gen_parent_class)->finalize (obj);
}


GType vala_vapi_gen_get_type (void) {
	static volatile gsize vala_vapi_gen_type_id__volatile = 0;
	if (g_once_init_enter (&vala_vapi_gen_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaVAPIGenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_vapi_gen_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaVAPIGen), 0, (GInstanceInitFunc) vala_vapi_gen_instance_init, NULL };
		GType vala_vapi_gen_type_id;
		vala_vapi_gen_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaVAPIGen", &g_define_type_info, 0);
		g_once_init_leave (&vala_vapi_gen_type_id__volatile, vala_vapi_gen_type_id);
	}
	return vala_vapi_gen_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



