/* valainitializerlist.c generated by valac, the Vala compiler
 * generated from valainitializerlist.vala, do not modify */

/* valainitializerlist.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaExpressionPrivate ValaExpressionPrivate;

#define VALA_TYPE_INITIALIZER_LIST (vala_initializer_list_get_type ())
#define VALA_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerList))
#define VALA_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))
#define VALA_IS_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INITIALIZER_LIST))
#define VALA_IS_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INITIALIZER_LIST))
#define VALA_INITIALIZER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))

typedef struct _ValaInitializerList ValaInitializerList;
typedef struct _ValaInitializerListClass ValaInitializerListClass;
typedef struct _ValaInitializerListPrivate ValaInitializerListPrivate;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;

#define VALA_TYPE_ARRAY_TYPE (vala_array_type_get_type ())
#define VALA_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayType))
#define VALA_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))
#define VALA_IS_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_TYPE))
#define VALA_IS_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_TYPE))
#define VALA_ARRAY_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))

typedef struct _ValaArrayType ValaArrayType;
typedef struct _ValaArrayTypeClass ValaArrayTypeClass;

#define VALA_TYPE_ARRAY_CREATION_EXPRESSION (vala_array_creation_expression_get_type ())
#define VALA_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression))
#define VALA_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))
#define VALA_IS_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_IS_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_ARRAY_CREATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))

typedef struct _ValaArrayCreationExpression ValaArrayCreationExpression;
typedef struct _ValaArrayCreationExpressionClass ValaArrayCreationExpressionClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

#define VALA_TYPE_MEMBER_BINDING (vala_member_binding_get_type ())

#define VALA_TYPE_UNARY_EXPRESSION (vala_unary_expression_get_type ())
#define VALA_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression))
#define VALA_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionClass))
#define VALA_IS_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_UNARY_EXPRESSION))
#define VALA_IS_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_UNARY_EXPRESSION))
#define VALA_UNARY_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionClass))

typedef struct _ValaUnaryExpression ValaUnaryExpression;
typedef struct _ValaUnaryExpressionClass ValaUnaryExpressionClass;

#define VALA_TYPE_UNARY_OPERATOR (vala_unary_operator_get_type ())

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaCodeContext* context);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaExpression {
	ValaCodeNode parent_instance;
	ValaExpressionPrivate * priv;
};

struct _ValaExpressionClass {
	ValaCodeNodeClass parent_class;
	gboolean (*is_constant) (ValaExpression* self);
	gboolean (*is_pure) (ValaExpression* self);
	gboolean (*is_non_null) (ValaExpression* self);
};

struct _ValaInitializerList {
	ValaExpression parent_instance;
	ValaInitializerListPrivate * priv;
};

struct _ValaInitializerListClass {
	ValaExpressionClass parent_class;
};

struct _ValaInitializerListPrivate {
	ValaList* initializers;
};

typedef enum  {
	VALA_MEMBER_BINDING_INSTANCE,
	VALA_MEMBER_BINDING_CLASS,
	VALA_MEMBER_BINDING_STATIC
} ValaMemberBinding;

typedef enum  {
	VALA_UNARY_OPERATOR_NONE,
	VALA_UNARY_OPERATOR_PLUS,
	VALA_UNARY_OPERATOR_MINUS,
	VALA_UNARY_OPERATOR_LOGICAL_NEGATION,
	VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT,
	VALA_UNARY_OPERATOR_INCREMENT,
	VALA_UNARY_OPERATOR_DECREMENT,
	VALA_UNARY_OPERATOR_REF,
	VALA_UNARY_OPERATOR_OUT
} ValaUnaryOperator;


static gpointer vala_initializer_list_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_local_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_initializer_list_get_type (void) G_GNUC_CONST;
#define VALA_INITIALIZER_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListPrivate))
enum  {
	VALA_INITIALIZER_LIST_DUMMY_PROPERTY
};
void vala_initializer_list_append (ValaInitializerList* self, ValaExpression* expr);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
ValaList* vala_initializer_list_get_initializers (ValaInitializerList* self);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
ValaInitializerList* vala_initializer_list_new (ValaSourceReference* source_reference);
ValaInitializerList* vala_initializer_list_construct (GType object_type, ValaSourceReference* source_reference);
ValaExpression* vala_expression_construct (GType object_type);
void vala_code_node_set_source_reference (ValaCodeNode* self, ValaSourceReference* value);
static void vala_initializer_list_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
static void vala_initializer_list_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_initializer_list (ValaCodeVisitor* self, ValaInitializerList* list);
static gboolean vala_initializer_list_real_is_pure (ValaExpression* base);
gboolean vala_expression_is_pure (ValaExpression* self);
static void vala_initializer_list_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_initializer_list_real_check (ValaCodeNode* base, ValaCodeContext* context);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
ValaDataType* vala_expression_get_target_type (ValaExpression* self);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
void vala_report_error (ValaSourceReference* source, const gchar* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
GType vala_reference_type_get_type (void) G_GNUC_CONST;
GType vala_array_type_get_type (void) G_GNUC_CONST;
ValaCodeNode* vala_code_node_get_parent_node (ValaCodeNode* self);
GType vala_array_creation_expression_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
ValaDataType* vala_array_type_get_element_type (ValaArrayType* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
gint vala_array_type_get_rank (ValaArrayType* self);
ValaArrayCreationExpression* vala_array_creation_expression_new (ValaDataType* element_type, gint rank, ValaInitializerList* initializer_list, ValaSourceReference* source_reference);
ValaArrayCreationExpression* vala_array_creation_expression_construct (GType object_type, ValaDataType* element_type, gint rank, ValaInitializerList* initializer_list, ValaSourceReference* source_reference);
void vala_expression_set_target_type (ValaExpression* self, ValaDataType* value);
void vala_code_node_replace_expression (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
gboolean vala_code_node_check (ValaCodeNode* self, ValaCodeContext* context);
void vala_array_type_set_rank (ValaArrayType* self, gint value);
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
ValaList* vala_struct_get_fields (ValaStruct* self);
gchar* vala_code_node_to_string (ValaCodeNode* self);
GType vala_member_binding_get_type (void) G_GNUC_CONST;
ValaMemberBinding vala_field_get_binding (ValaField* self);
ValaDataType* vala_variable_get_variable_type (ValaVariable* self);
gboolean vala_data_type_get_value_owned (ValaDataType* self);
void vala_data_type_set_value_owned (ValaDataType* self, gboolean value);
ValaDataType* vala_expression_get_value_type (ValaExpression* self);
GType vala_unary_expression_get_type (void) G_GNUC_CONST;
GType vala_unary_operator_get_type (void) G_GNUC_CONST;
ValaUnaryOperator vala_unary_expression_get_operator (ValaUnaryExpression* self);
gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type);
void vala_expression_set_value_type (ValaExpression* self, ValaDataType* value);
static void vala_initializer_list_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
void vala_code_node_emit (ValaCodeNode* self, ValaCodeGenerator* codegen);
gint vala_initializer_list_get_size (ValaInitializerList* self);
static void vala_initializer_list_finalize (ValaCodeNode* obj);


/**
 * Appends the specified expression to this initializer 
 *
 * @param expr an expression
 */
void vala_initializer_list_append (ValaInitializerList* self, ValaExpression* expr) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	vala_collection_add ((ValaCollection*) self->priv->initializers, expr);
	vala_code_node_set_parent_node ((ValaCodeNode*) expr, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the expression 
 *
 * @return expression list
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_initializer_list_get_initializers (ValaInitializerList* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->initializers);
	result = _tmp0_;
	return result;
}


/**
 * Creates a new initializer 
 *
 * @param source_reference reference to source code
 * @return                 newly created initializer list
 */
ValaInitializerList* vala_initializer_list_construct (GType object_type, ValaSourceReference* source_reference) {
	ValaInitializerList* self = NULL;
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaInitializerList*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaInitializerList* vala_initializer_list_new (ValaSourceReference* source_reference) {
	return vala_initializer_list_construct (VALA_TYPE_INITIALIZER_LIST, source_reference);
}


static void vala_initializer_list_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _tmp0_;
		ValaList* _expr_list;
		gint _tmp1_;
		gint _expr_size;
		gint _expr_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->initializers);
		_expr_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _expr_list);
		_expr_size = _tmp1_;
		_expr_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			ValaExpression* expr;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_expr_list, _expr_index);
			expr = (ValaExpression*) _tmp2_;
			vala_code_node_accept ((ValaCodeNode*) expr, visitor);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}


static void vala_initializer_list_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_initializer_list (visitor, self);
}


static gboolean vala_initializer_list_real_is_pure (ValaExpression* base) {
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	{
		ValaList* _tmp0_;
		ValaList* _initializer_list;
		gint _tmp1_;
		gint _initializer_size;
		gint _initializer_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->initializers);
		_initializer_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _initializer_list);
		_initializer_size = _tmp1_;
		_initializer_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			ValaExpression* initializer;
			gboolean _tmp3_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_initializer_list, _initializer_index);
			initializer = (ValaExpression*) _tmp2_;
			_tmp3_ = vala_expression_is_pure (initializer);
			if (!_tmp3_) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}


static void vala_initializer_list_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp1_;
				gpointer _tmp2_ = NULL;
				ValaExpression* _tmp3_;
				gboolean _tmp4_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				_tmp1_ = vala_collection_get_size ((ValaCollection*) self->priv->initializers);
				if (!(i < _tmp1_)) {
					break;
				}
				_tmp2_ = vala_list_get (self->priv->initializers, i);
				_tmp3_ = (ValaExpression*) _tmp2_;
				if ((_tmp4_ = _tmp3_ == old_node, _vala_code_node_unref0 (_tmp3_), _tmp4_)) {
					vala_list_set (self->priv->initializers, i, new_node);
				}
			}
		}
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_initializer_list_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaInitializerList * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	ValaDataType* _tmp2_ = NULL;
	gboolean _error_;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = vala_code_node_get_error ((ValaCodeNode*) self);
		result = !_tmp1_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp2_ = vala_expression_get_target_type ((ValaExpression*) self);
	if (_tmp2_ == NULL) {
		ValaSourceReference* _tmp3_ = NULL;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp3_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		vala_report_error (_tmp3_, "initializer list used for unknown type");
		result = FALSE;
		return result;
	} else {
		ValaDataType* _tmp4_ = NULL;
		_tmp4_ = vala_expression_get_target_type ((ValaExpression*) self);
		if (VALA_IS_ARRAY_TYPE (_tmp4_)) {
			ValaDataType* _tmp5_ = NULL;
			ValaArrayType* _tmp6_;
			ValaArrayType* array_type;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			ValaCodeNode* _tmp9_ = NULL;
			ValaDataType* inner_target_type;
			gint _tmp23_;
			_tmp5_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp6_ = _vala_code_node_ref0 (VALA_ARRAY_TYPE (_tmp5_));
			array_type = _tmp6_;
			_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			if (!VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp9_)) {
				ValaCodeNode* _tmp10_ = NULL;
				_tmp10_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp8_ = !VALA_IS_CONSTANT (_tmp10_);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				ValaCodeNode* _tmp11_ = NULL;
				_tmp11_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp7_ = !VALA_IS_INITIALIZER_LIST (_tmp11_);
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				ValaCodeNode* _tmp12_ = NULL;
				ValaCodeNode* _tmp13_;
				ValaCodeNode* old_parent_node;
				ValaDataType* _tmp14_ = NULL;
				ValaDataType* _tmp15_ = NULL;
				ValaDataType* _tmp16_;
				gint _tmp17_;
				ValaSourceReference* _tmp18_ = NULL;
				ValaArrayCreationExpression* _tmp19_ = NULL;
				ValaArrayCreationExpression* _tmp20_;
				ValaArrayCreationExpression* array_creation;
				ValaDataType* _tmp21_ = NULL;
				gboolean _tmp22_;
				_tmp12_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp13_ = _vala_code_node_ref0 (_tmp12_);
				old_parent_node = _tmp13_;
				_tmp14_ = vala_array_type_get_element_type (array_type);
				_tmp15_ = vala_data_type_copy (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = vala_array_type_get_rank (array_type);
				_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp19_ = vala_array_creation_expression_new (_tmp16_, _tmp17_, self, _tmp18_);
				array_creation = (_tmp20_ = _tmp19_, _vala_code_node_unref0 (_tmp16_), _tmp20_);
				_tmp21_ = vala_expression_get_target_type ((ValaExpression*) self);
				vala_expression_set_target_type ((ValaExpression*) array_creation, _tmp21_);
				vala_code_node_replace_expression (old_parent_node, (ValaExpression*) self, (ValaExpression*) array_creation);
				vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
				_tmp22_ = vala_code_node_check ((ValaCodeNode*) array_creation, context);
				result = _tmp22_;
				_vala_code_node_unref0 (array_creation);
				_vala_code_node_unref0 (old_parent_node);
				_vala_code_node_unref0 (array_type);
				return result;
			}
			inner_target_type = NULL;
			_tmp23_ = vala_array_type_get_rank (array_type);
			if (_tmp23_ > 1) {
				ValaDataType* _tmp24_ = NULL;
				ValaArrayType* inner_array_type;
				gint _tmp25_;
				gint _tmp26_;
				ValaDataType* _tmp27_;
				ValaDataType* _tmp28_;
				_tmp24_ = vala_data_type_copy ((ValaDataType*) array_type);
				inner_array_type = VALA_ARRAY_TYPE (_tmp24_);
				_tmp25_ = vala_array_type_get_rank (inner_array_type);
				_tmp26_ = _tmp25_;
				vala_array_type_set_rank (inner_array_type, _tmp26_ - 1);
				_tmp27_ = _vala_code_node_ref0 ((ValaDataType*) inner_array_type);
				_tmp28_ = _tmp27_;
				_vala_code_node_unref0 (inner_target_type);
				inner_target_type = _tmp28_;
				_vala_code_node_unref0 (inner_array_type);
			} else {
				ValaDataType* _tmp29_ = NULL;
				ValaDataType* _tmp30_ = NULL;
				ValaDataType* _tmp31_;
				_tmp29_ = vala_array_type_get_element_type (array_type);
				_tmp30_ = vala_data_type_copy (_tmp29_);
				_tmp31_ = _tmp30_;
				_vala_code_node_unref0 (inner_target_type);
				inner_target_type = _tmp31_;
			}
			{
				ValaList* _tmp32_ = NULL;
				ValaList* _e_list;
				gint _tmp33_;
				gint _e_size;
				gint _e_index;
				_tmp32_ = vala_initializer_list_get_initializers (self);
				_e_list = _tmp32_;
				_tmp33_ = vala_collection_get_size ((ValaCollection*) _e_list);
				_e_size = _tmp33_;
				_e_index = -1;
				while (TRUE) {
					gpointer _tmp34_ = NULL;
					ValaExpression* e;
					_e_index = _e_index + 1;
					if (!(_e_index < _e_size)) {
						break;
					}
					_tmp34_ = vala_list_get (_e_list, _e_index);
					e = (ValaExpression*) _tmp34_;
					vala_expression_set_target_type (e, inner_target_type);
					_vala_code_node_unref0 (e);
				}
				_vala_iterable_unref0 (_e_list);
			}
			_vala_code_node_unref0 (inner_target_type);
			_vala_code_node_unref0 (array_type);
		} else {
			ValaDataType* _tmp35_ = NULL;
			ValaTypeSymbol* _tmp36_ = NULL;
			_tmp35_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp36_ = vala_data_type_get_data_type (_tmp35_);
			if (VALA_IS_STRUCT (_tmp36_)) {
				ValaDataType* _tmp37_ = NULL;
				ValaTypeSymbol* _tmp38_ = NULL;
				ValaStruct* _tmp39_;
				ValaStruct* st;
				ValaList* _tmp40_ = NULL;
				ValaList* _tmp41_;
				ValaIterator* _tmp42_ = NULL;
				ValaIterator* _tmp43_;
				ValaIterator* field_it;
				_tmp37_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp38_ = vala_data_type_get_data_type (_tmp37_);
				_tmp39_ = _vala_code_node_ref0 (VALA_STRUCT (_tmp38_));
				st = _tmp39_;
				_tmp40_ = vala_struct_get_fields (st);
				_tmp41_ = _tmp40_;
				_tmp42_ = vala_iterable_iterator ((ValaIterable*) _tmp41_);
				field_it = (_tmp43_ = _tmp42_, _vala_iterable_unref0 (_tmp41_), _tmp43_);
				{
					ValaList* _tmp44_ = NULL;
					ValaList* _e_list;
					gint _tmp45_;
					gint _e_size;
					gint _e_index;
					_tmp44_ = vala_initializer_list_get_initializers (self);
					_e_list = _tmp44_;
					_tmp45_ = vala_collection_get_size ((ValaCollection*) _e_list);
					_e_size = _tmp45_;
					_e_index = -1;
					while (TRUE) {
						gpointer _tmp46_ = NULL;
						ValaExpression* e;
						ValaField* field;
						ValaDataType* _tmp58_ = NULL;
						ValaDataType* _tmp59_ = NULL;
						ValaDataType* _tmp60_;
						ValaDataType* _tmp61_ = NULL;
						gboolean _tmp62_;
						_e_index = _e_index + 1;
						if (!(_e_index < _e_size)) {
							break;
						}
						_tmp46_ = vala_list_get (_e_list, _e_index);
						e = (ValaExpression*) _tmp46_;
						field = NULL;
						while (TRUE) {
							gboolean _tmp47_;
							gpointer _tmp54_ = NULL;
							ValaField* _tmp55_;
							ValaMemberBinding _tmp56_;
							if (!(field == NULL)) {
								break;
							}
							_tmp47_ = vala_iterator_next (field_it);
							if (!_tmp47_) {
								ValaSourceReference* _tmp48_ = NULL;
								ValaDataType* _tmp49_ = NULL;
								gchar* _tmp50_ = NULL;
								gchar* _tmp51_;
								gchar* _tmp52_ = NULL;
								gchar* _tmp53_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) e);
								_tmp49_ = vala_expression_get_target_type ((ValaExpression*) self);
								_tmp50_ = vala_code_node_to_string ((ValaCodeNode*) _tmp49_);
								_tmp51_ = _tmp50_;
								_tmp52_ = g_strdup_printf ("too many expressions in initializer list for `%s'", _tmp51_);
								_tmp53_ = _tmp52_;
								vala_report_error (_tmp48_, _tmp53_);
								_g_free0 (_tmp53_);
								_g_free0 (_tmp51_);
								result = FALSE;
								_vala_code_node_unref0 (field);
								_vala_code_node_unref0 (e);
								_vala_iterable_unref0 (_e_list);
								_vala_iterator_unref0 (field_it);
								_vala_code_node_unref0 (st);
								return result;
							}
							_tmp54_ = vala_iterator_get (field_it);
							_tmp55_ = (ValaField*) _tmp54_;
							_vala_code_node_unref0 (field);
							field = _tmp55_;
							_tmp56_ = vala_field_get_binding (field);
							if (_tmp56_ != VALA_MEMBER_BINDING_INSTANCE) {
								ValaField* _tmp57_;
								_tmp57_ = NULL;
								_vala_code_node_unref0 (field);
								field = _tmp57_;
							}
						}
						_tmp58_ = vala_variable_get_variable_type ((ValaVariable*) field);
						_tmp59_ = vala_data_type_copy (_tmp58_);
						_tmp60_ = _tmp59_;
						vala_expression_set_target_type (e, _tmp60_);
						_vala_code_node_unref0 (_tmp60_);
						_tmp61_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp62_ = vala_data_type_get_value_owned (_tmp61_);
						if (!_tmp62_) {
							ValaDataType* _tmp63_ = NULL;
							_tmp63_ = vala_expression_get_target_type (e);
							vala_data_type_set_value_owned (_tmp63_, FALSE);
						}
						_vala_code_node_unref0 (field);
						_vala_code_node_unref0 (e);
					}
					_vala_iterable_unref0 (_e_list);
				}
				_vala_iterator_unref0 (field_it);
				_vala_code_node_unref0 (st);
			} else {
				ValaSourceReference* _tmp64_ = NULL;
				ValaDataType* _tmp65_ = NULL;
				gchar* _tmp66_ = NULL;
				gchar* _tmp67_;
				gchar* _tmp68_ = NULL;
				gchar* _tmp69_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp64_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp65_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp66_ = vala_code_node_to_string ((ValaCodeNode*) _tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = g_strdup_printf ("initializer list used for `%s', which is neither array nor struct", _tmp67_);
				_tmp69_ = _tmp68_;
				vala_report_error (_tmp64_, _tmp69_);
				_g_free0 (_tmp69_);
				_g_free0 (_tmp67_);
				result = FALSE;
				return result;
			}
		}
	}
	{
		ValaList* _tmp70_;
		ValaList* _expr_list;
		gint _tmp71_;
		gint _expr_size;
		gint _expr_index;
		_tmp70_ = _vala_iterable_ref0 (self->priv->initializers);
		_expr_list = _tmp70_;
		_tmp71_ = vala_collection_get_size ((ValaCollection*) _expr_list);
		_expr_size = _tmp71_;
		_expr_index = -1;
		while (TRUE) {
			gpointer _tmp72_ = NULL;
			ValaExpression* expr;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp72_ = vala_list_get (_expr_list, _expr_index);
			expr = (ValaExpression*) _tmp72_;
			vala_code_node_check ((ValaCodeNode*) expr, context);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_error_ = FALSE;
	{
		ValaList* _tmp73_ = NULL;
		ValaList* _e_list;
		gint _tmp74_;
		gint _e_size;
		gint _e_index;
		_tmp73_ = vala_initializer_list_get_initializers (self);
		_e_list = _tmp73_;
		_tmp74_ = vala_collection_get_size ((ValaCollection*) _e_list);
		_e_size = _tmp74_;
		_e_index = -1;
		while (TRUE) {
			gpointer _tmp75_ = NULL;
			ValaExpression* e;
			ValaDataType* _tmp76_ = NULL;
			ValaExpression* _tmp78_;
			ValaUnaryExpression* _tmp79_;
			ValaUnaryExpression* unary;
			gboolean _tmp80_ = FALSE;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp75_ = vala_list_get (_e_list, _e_index);
			e = (ValaExpression*) _tmp75_;
			_tmp76_ = vala_expression_get_value_type (e);
			if (_tmp76_ == NULL) {
				ValaSourceReference* _tmp77_ = NULL;
				_error_ = TRUE;
				_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) e);
				vala_report_error (_tmp77_, "expression type not allowed as initializer");
				_vala_code_node_unref0 (e);
				continue;
			}
			_tmp79_ = _vala_code_node_ref0 ((_tmp78_ = e, VALA_IS_UNARY_EXPRESSION (_tmp78_) ? ((ValaUnaryExpression*) _tmp78_) : NULL));
			unary = _tmp79_;
			if (unary != NULL) {
				gboolean _tmp81_ = FALSE;
				ValaUnaryOperator _tmp82_;
				_tmp82_ = vala_unary_expression_get_operator (unary);
				if (_tmp82_ == VALA_UNARY_OPERATOR_REF) {
					_tmp81_ = TRUE;
				} else {
					ValaUnaryOperator _tmp83_;
					_tmp83_ = vala_unary_expression_get_operator (unary);
					_tmp81_ = _tmp83_ == VALA_UNARY_OPERATOR_OUT;
				}
				_tmp80_ = _tmp81_;
			} else {
				_tmp80_ = FALSE;
			}
			if (_tmp80_) {
			} else {
				ValaDataType* _tmp84_ = NULL;
				ValaDataType* _tmp85_ = NULL;
				gboolean _tmp86_;
				_tmp84_ = vala_expression_get_value_type (e);
				_tmp85_ = vala_expression_get_target_type (e);
				_tmp86_ = vala_data_type_compatible (_tmp84_, _tmp85_);
				if (!_tmp86_) {
					ValaSourceReference* _tmp87_ = NULL;
					ValaDataType* _tmp88_ = NULL;
					gchar* _tmp89_ = NULL;
					gchar* _tmp90_;
					ValaDataType* _tmp91_ = NULL;
					gchar* _tmp92_ = NULL;
					gchar* _tmp93_;
					gchar* _tmp94_ = NULL;
					gchar* _tmp95_;
					_error_ = TRUE;
					vala_code_node_set_error ((ValaCodeNode*) e, TRUE);
					_tmp87_ = vala_code_node_get_source_reference ((ValaCodeNode*) e);
					_tmp88_ = vala_expression_get_target_type (e);
					_tmp89_ = vala_code_node_to_string ((ValaCodeNode*) _tmp88_);
					_tmp90_ = _tmp89_;
					_tmp91_ = vala_expression_get_value_type (e);
					_tmp92_ = vala_code_node_to_string ((ValaCodeNode*) _tmp91_);
					_tmp93_ = _tmp92_;
					_tmp94_ = g_strdup_printf ("Expected initializer of type `%s' but got `%s'", _tmp90_, _tmp93_);
					_tmp95_ = _tmp94_;
					vala_report_error (_tmp87_, _tmp95_);
					_g_free0 (_tmp95_);
					_g_free0 (_tmp93_);
					_g_free0 (_tmp90_);
				}
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	if (!_error_) {
		ValaDataType* _tmp96_ = NULL;
		_tmp96_ = vala_expression_get_target_type ((ValaExpression*) self);
		vala_expression_set_value_type ((ValaExpression*) self, _tmp96_);
	}
	result = !_error_;
	return result;
}


static void vala_initializer_list_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _tmp0_;
		ValaList* _expr_list;
		gint _tmp1_;
		gint _expr_size;
		gint _expr_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->initializers);
		_expr_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _expr_list);
		_expr_size = _tmp1_;
		_expr_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			ValaExpression* expr;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_expr_list, _expr_index);
			expr = (ValaExpression*) _tmp2_;
			vala_code_node_emit ((ValaCodeNode*) expr, codegen);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	vala_code_visitor_visit_initializer_list ((ValaCodeVisitor*) codegen, self);
}


gint vala_initializer_list_get_size (ValaInitializerList* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_collection_get_size ((ValaCollection*) self->priv->initializers);
	result = _tmp0_;
	return result;
}


static void vala_initializer_list_class_init (ValaInitializerListClass * klass) {
	vala_initializer_list_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_initializer_list_finalize;
	g_type_class_add_private (klass, sizeof (ValaInitializerListPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_initializer_list_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_initializer_list_real_accept;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_initializer_list_real_is_pure;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_initializer_list_real_replace_expression;
	VALA_CODE_NODE_CLASS (klass)->check = vala_initializer_list_real_check;
	VALA_CODE_NODE_CLASS (klass)->emit = vala_initializer_list_real_emit;
}


static void vala_initializer_list_instance_init (ValaInitializerList * self) {
	ValaArrayList* _tmp0_ = NULL;
	self->priv = VALA_INITIALIZER_LIST_GET_PRIVATE (self);
	_tmp0_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->initializers = (ValaList*) _tmp0_;
}


static void vala_initializer_list_finalize (ValaCodeNode* obj) {
	ValaInitializerList * self;
	self = VALA_INITIALIZER_LIST (obj);
	_vala_iterable_unref0 (self->priv->initializers);
	VALA_CODE_NODE_CLASS (vala_initializer_list_parent_class)->finalize (obj);
}


/**
 * Represents an array or struct initializer list in the source code.
 */
GType vala_initializer_list_get_type (void) {
	static volatile gsize vala_initializer_list_type_id__volatile = 0;
	if (g_once_init_enter (&vala_initializer_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInitializerListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_initializer_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInitializerList), 0, (GInstanceInitFunc) vala_initializer_list_instance_init, NULL };
		GType vala_initializer_list_type_id;
		vala_initializer_list_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaInitializerList", &g_define_type_info, 0);
		g_once_init_leave (&vala_initializer_list_type_id__volatile, vala_initializer_list_type_id);
	}
	return vala_initializer_list_type_id__volatile;
}



