/* gdk-3.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Gdk", lower_case_cprefix = "gdk_", gir_namespace = "Gdk", gir_version = "2.0")]
namespace Gdk {
	[CCode (cprefix = "GdkSelection", lower_case_cprefix = "gdk_selection_")]
	namespace Selection {
		[CCode (cheader_filename = "gdk/gdk.h")]
		public static void convert (Gdk.Window requestor, Gdk.Atom selection, Gdk.Atom target, uint32 time_);
		[CCode (cheader_filename = "gdk/gdk.h")]
		public static unowned Gdk.Window owner_get (Gdk.Atom selection);
		[CCode (cheader_filename = "gdk/gdk.h")]
		public static unowned Gdk.Window owner_get_for_display (Gdk.Display display, Gdk.Atom selection);
		[CCode (cheader_filename = "gdk/gdk.h")]
		public static bool owner_set (Gdk.Window owner, Gdk.Atom selection, uint32 time_, bool send_event);
		[CCode (cheader_filename = "gdk/gdk.h")]
		public static bool owner_set_for_display (Gdk.Display display, Gdk.Window owner, Gdk.Atom selection, uint32 time_, bool send_event);
		[CCode (cheader_filename = "gdk/gdk.h")]
		public static int property_get (Gdk.Window requestor, uchar[] data, Gdk.Atom prop_type, int prop_format);
		[CCode (cheader_filename = "gdk/gdk.h")]
		public static void send_notify (Gdk.NativeWindow requestor, Gdk.Atom selection, Gdk.Atom target, Gdk.Atom property, uint32 time_);
		[CCode (cheader_filename = "gdk/gdk.h")]
		public static void send_notify_for_display (Gdk.Display display, Gdk.NativeWindow requestor, Gdk.Atom selection, Gdk.Atom target, Gdk.Atom property, uint32 time_);
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class AppLaunchContext : GLib.AppLaunchContext {
		[CCode (has_construct_function = false)]
		public AppLaunchContext ();
		public void set_desktop (int desktop);
		public void set_display (Gdk.Display display);
		public void set_icon (GLib.Icon icon);
		public void set_icon_name (string icon_name);
		public void set_screen (Gdk.Screen screen);
		public void set_timestamp (uint32 timestamp);
	}
	[CCode (ref_function = "g_object_ref", unref_function = "g_object_unref", cheader_filename = "gdk/gdk.h")]
	public class Bitmap {
	}
	[Compact]
	[CCode (ref_function = "gdk_cursor_ref", unref_function = "gdk_cursor_unref", type_id = "GDK_TYPE_CURSOR", cheader_filename = "gdk/gdk.h")]
	public class Cursor {
		[CCode (has_construct_function = false)]
		public Cursor (Gdk.CursorType cursor_type);
		[CCode (has_construct_function = false)]
		public Cursor.for_display (Gdk.Display display, Gdk.CursorType cursor_type);
		[CCode (has_construct_function = false)]
		public Cursor.from_name (Gdk.Display display, string name);
		[CCode (has_construct_function = false)]
		public Cursor.from_pixbuf (Gdk.Display display, Gdk.Pixbuf pixbuf, int x, int y);
		public Gdk.CursorType get_cursor_type ();
		public unowned Gdk.Display get_display ();
		public unowned Gdk.Pixbuf get_image ();
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class Device : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Device ();
		public static void free_history (Gdk.TimeCoord[] events);
		public unowned Gdk.Device get_associated_device ();
		public bool get_axis ([CCode (array_length = false)] double[] axes, Gdk.AxisUse use, out double value);
		public Gdk.AxisUse get_axis_use (uint index_);
		public bool get_axis_value (double axes, Gdk.Atom axis_label, double value);
		public Gdk.DeviceType get_device_type ();
		public unowned Gdk.Display get_display ();
		public bool get_has_cursor ();
		public bool get_history (Gdk.Window window, uint32 start, uint32 stop, Gdk.TimeCoord[] events);
		public bool get_key (uint index_, uint keyval, Gdk.ModifierType modifiers);
		public Gdk.InputMode get_mode ();
		public uint get_n_axes ();
		public unowned string get_name ();
		public Gdk.InputSource get_source ();
		public void get_state (Gdk.Window window, double axes, Gdk.ModifierType mask);
		public Gdk.GrabStatus grab (Gdk.Window window, Gdk.GrabOwnership grab_ownership, bool owner_events, Gdk.EventMask event_mask, Gdk.Cursor cursor, uint32 time_);
		public static bool grab_info_libgtk_only (Gdk.Display display, Gdk.Device device, out unowned Gdk.Window grab_window, bool owner_events);
		public unowned GLib.List list_axes ();
		public void set_axis_use (uint index_, Gdk.AxisUse use);
		public void set_key (uint index_, uint keyval, Gdk.ModifierType modifiers);
		public bool set_mode (Gdk.InputMode mode);
		public void set_source (Gdk.InputSource source);
		public void ungrab (uint32 time_);
		public Gdk.Device associated_device { get; }
		[NoAccessorMethod]
		public Gdk.DeviceManager device_manager { owned get; construct; }
		public Gdk.Display display { get; construct; }
		public bool has_cursor { get; construct; }
		[NoAccessorMethod]
		public Gdk.InputMode input_mode { get; set; }
		[NoAccessorMethod]
		public Gdk.InputSource input_source { get; construct; }
		public uint n_axes { get; }
		public string name { get; construct; }
		[NoAccessorMethod]
		public Gdk.DeviceType type { get; construct; }
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class DeviceManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected DeviceManager ();
		public virtual unowned Gdk.Device get_client_pointer ();
		public unowned Gdk.Display get_display ();
		public virtual unowned GLib.List list_devices (Gdk.DeviceType type);
		public Gdk.Display display { get; construct; }
		public virtual signal void device_added (Gdk.Device device);
		public virtual signal void device_changed (Gdk.Device device);
		public virtual signal void device_removed (Gdk.Device device);
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class Display : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Display ();
		public void add_client_message_filter (Gdk.Atom message_type, Gdk.FilterFunc func);
		public void beep ();
		public void close ();
		public bool device_is_grabbed (Gdk.Device device);
		public void flush ();
		public static unowned Gdk.Display get_default ();
		public uint get_default_cursor_size ();
		public unowned Gdk.Window get_default_group ();
		public virtual unowned Gdk.Screen get_default_screen ();
		public unowned Gdk.DeviceManager get_device_manager ();
		public void get_device_state (Gdk.Device device, out unowned Gdk.Screen screen, int x, int y, Gdk.ModifierType mask);
		[NoWrapper]
		public virtual unowned string get_display_name ();
		public Gdk.Event get_event ();
		public void get_maximal_cursor_size (out uint width, out uint height);
		public virtual int get_n_screens ();
		public unowned string get_name ();
		public void get_pointer (out unowned Gdk.Screen screen, out int x, out int y, out Gdk.ModifierType mask);
		public virtual unowned Gdk.Screen get_screen (int screen_num);
		public unowned Gdk.Window get_window_at_device_position (Gdk.Device device, int win_x, int win_y);
		public unowned Gdk.Window get_window_at_pointer (int win_x, int win_y);
		public bool is_closed ();
		public void keyboard_ungrab (uint32 time_);
		public static unowned Gdk.Display open (string display_name);
		public static unowned Gdk.Display open_default_libgtk_only ();
		public Gdk.Event peek_event ();
		public bool pointer_is_grabbed ();
		public void pointer_ungrab (uint32 time_);
		public void put_event (Gdk.Event event);
		public bool request_selection_notification (Gdk.Atom selection);
		public unowned Gdk.DisplayDeviceHooks set_device_hooks (Gdk.DisplayDeviceHooks new_hooks);
		public void set_double_click_distance (uint distance);
		public void set_double_click_time (uint msec);
		public unowned Gdk.DisplayPointerHooks set_pointer_hooks (Gdk.DisplayPointerHooks new_hooks);
		public void store_clipboard (Gdk.Window clipboard_window, uint32 time_, Gdk.Atom[] targets);
		public bool supports_clipboard_persistence ();
		public bool supports_composite ();
		public bool supports_cursor_alpha ();
		public bool supports_cursor_color ();
		public bool supports_input_shapes ();
		public bool supports_selection_notification ();
		public bool supports_shapes ();
		public void sync ();
		public void warp_device (Gdk.Device device, Gdk.Screen screen, int x, int y);
		public void warp_pointer (Gdk.Screen screen, int x, int y);
		public virtual signal void closed (bool is_error);
		public virtual signal void opened ();
	}
	[Compact]
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class DisplayDeviceHooks {
		public weak GLib.Callback get_device_state;
		public weak GLib.Callback window_at_device_position;
		public weak GLib.Callback window_get_device_position;
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class DisplayManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected DisplayManager ();
		public static unowned Gdk.DisplayManager @get ();
		public unowned Gdk.Display get_default_display ();
		public GLib.SList<weak Gdk.Display> list_displays ();
		public void set_default_display (Gdk.Display display);
		public Gdk.Display default_display { get; set; }
		public virtual signal void display_opened (Gdk.Display display);
	}
	[Compact]
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class DisplayPointerHooks {
		public weak GLib.Callback get_pointer;
		public weak GLib.Callback window_at_pointer;
		public weak GLib.Callback window_get_pointer;
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class DragContext : GLib.Object {
		[CCode (has_construct_function = false)]
		public DragContext ();
		public Gdk.DragAction get_actions ();
		public unowned Gdk.Device get_device ();
		public Gdk.DragAction get_selected_action ();
		public unowned Gdk.Window get_source_window ();
		public Gdk.DragAction get_suggested_action ();
		public unowned GLib.List list_targets ();
		public void set_device (Gdk.Device device);
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class Drawable : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Drawable ();
		[NoWrapper]
		public virtual unowned Cairo.Surface create_cairo_surface (int width, int height);
		public virtual unowned Cairo.Region get_clip_region ();
		public virtual unowned Cairo.Region get_visible_region ();
		[NoWrapper]
		public virtual unowned Cairo.Surface ref_cairo_surface ();
		[NoWrapper]
		public virtual void set_cairo_clip (Cairo.Context cr);
	}
	[Compact]
	[CCode (copy_function = "gdk_event_copy", type_id = "GDK_TYPE_EVENT", cheader_filename = "gdk/gdk.h")]
	public class Event {
		public Gdk.EventAny any;
		public Gdk.EventButton button;
		public Gdk.EventClient client;
		public Gdk.EventConfigure configure;
		public Gdk.EventCrossing crossing;
		public Gdk.EventDND dnd;
		public Gdk.EventExpose expose;
		public Gdk.EventFocus focus_change;
		public Gdk.EventGrabBroken grab_broken;
		public Gdk.EventKey key;
		public Gdk.EventMotion motion;
		public Gdk.EventNoExpose no_expose;
		public Gdk.EventOwnerChange owner_change;
		public Gdk.EventProperty property;
		public Gdk.EventProximity proximity;
		public Gdk.EventScroll scroll;
		public Gdk.EventSelection selection;
		public Gdk.EventSetting setting;
		public Gdk.EventType type;
		public Gdk.EventVisibility visibility;
		public Gdk.EventWindowState window_state;
		[CCode (has_construct_function = false)]
		public Event (Gdk.EventType type);
		public Gdk.Event copy ();
		public static unowned Gdk.Event @get ();
		public bool get_axis (Gdk.AxisUse axis_use, out double value);
		public bool get_coords (out double x_win, out double y_win);
		public unowned Gdk.Device get_device ();
		public bool get_root_coords (out double x_root, out double y_root);
		public unowned Gdk.Screen get_screen ();
		public bool get_state (out Gdk.ModifierType state);
		public uint32 get_time ();
		public static void handler_set (owned Gdk.EventFunc func);
		public static unowned Gdk.Event peek ();
		public void put ();
		public static void request_motions (Gdk.EventMotion event);
		public bool send_client_message (Gdk.NativeWindow winid);
		public static bool send_client_message_for_display (Gdk.Display display, Gdk.Event event, Gdk.NativeWindow winid);
		public void send_clientmessage_toall ();
		public void set_device (Gdk.Device device);
		public void set_screen (Gdk.Screen screen);
	}
	[Compact]
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class KeyboardGrabInfo {
		public weak Gdk.Window native_window;
		public bool owner_events;
		public ulong serial;
		public uint32 time;
		public weak Gdk.Window window;
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class Keymap : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Keymap ();
		public void add_virtual_modifiers (Gdk.ModifierType state);
		public bool get_caps_lock_state ();
		public static unowned Gdk.Keymap get_default ();
		public Pango.Direction get_direction ();
		public bool get_entries_for_keycode (uint hardware_keycode, out unowned Gdk.KeymapKey[] keys, out unowned uint[] keyvals, int n_entries);
		public bool get_entries_for_keyval (uint keyval, out unowned Gdk.KeymapKey[] keys);
		public static unowned Gdk.Keymap get_for_display (Gdk.Display display);
		public bool get_num_lock_state ();
		public bool have_bidi_layouts ();
		public uint lookup_key (Gdk.KeymapKey key);
		public bool map_virtual_modifiers (Gdk.ModifierType state);
		public bool translate_keyboard_state (uint hardware_keycode, Gdk.ModifierType state, int group, uint keyval, int effective_group, int level, Gdk.ModifierType consumed_modifiers);
		public virtual signal void direction_changed ();
		public virtual signal void keys_changed ();
		public virtual signal void state_changed ();
	}
	[Compact]
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class MultipleClickInfo {
		[CCode (array_length = false)]
		public weak uint32[] button_click_time;
		[CCode (array_length = false)]
		public weak int[] button_number;
		[CCode (array_length = false)]
		public weak Gdk.Window[] button_window;
		[CCode (array_length = false)]
		public weak int[] button_x;
		[CCode (array_length = false)]
		public weak int[] button_y;
	}
	[Compact]
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class PointerHooks {
		public weak GLib.Callback get_pointer;
		public weak GLib.Callback window_at_pointer;
	}
	[Compact]
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class PointerWindowInfo {
		public uint32 button;
		public uint32 state;
		public weak Gdk.Window toplevel_under_pointer;
		public double toplevel_x;
		public double toplevel_y;
		public weak Gdk.Window window_under_pointer;
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class Screen : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Screen ();
		public void broadcast_client_message (Gdk.Event event);
		public unowned Gdk.Window get_active_window ();
		public static unowned Gdk.Screen get_default ();
		public unowned Gdk.Display get_display ();
		public unowned Cairo.FontOptions get_font_options ();
		public int get_height ();
		public int get_height_mm ();
		public int get_monitor_at_point (int x, int y);
		public int get_monitor_at_window (Gdk.Window window);
		public void get_monitor_geometry (int monitor_num, out Gdk.Rectangle dest);
		public int get_monitor_height_mm (int monitor_num);
		public unowned string get_monitor_plug_name (int monitor_num);
		public int get_monitor_width_mm (int monitor_num);
		public int get_n_monitors ();
		public int get_number ();
		public int get_primary_monitor ();
		public double get_resolution ();
		public unowned Gdk.Visual get_rgba_visual ();
		public unowned Gdk.Window get_root_window ();
		public bool get_setting (string name, GLib.Value value);
		public unowned Gdk.Visual get_system_visual ();
		public GLib.List<weak Gdk.Window> get_toplevel_windows ();
		public int get_width ();
		public int get_width_mm ();
		public GLib.List<Gdk.Window>? get_window_stack ();
		public static int height ();
		public static int height_mm ();
		public bool is_composited ();
		public GLib.List<weak Gdk.Visual> list_visuals ();
		public unowned string make_display_name ();
		public void set_font_options (Cairo.FontOptions options);
		public void set_resolution (double dpi);
		public static int width ();
		public static int width_mm ();
		public void* font_options { get; set; }
		public double resolution { get; set; }
		public virtual signal void composited_changed ();
		public virtual signal void monitors_changed ();
		public virtual signal void size_changed ();
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class Visual : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Visual ();
		public static unowned Gdk.Visual get_best ();
		public static int get_best_depth ();
		public static Gdk.VisualType get_best_type ();
		public static unowned Gdk.Visual get_best_with_both (int depth, Gdk.VisualType visual_type);
		public static unowned Gdk.Visual get_best_with_depth (int depth);
		public static unowned Gdk.Visual get_best_with_type (Gdk.VisualType visual_type);
		public int get_bits_per_rgb ();
		public void get_blue_pixel_details (uint32 mask, int shift, int precision);
		public Gdk.ByteOrder get_byte_order ();
		public int get_colormap_size ();
		public int get_depth ();
		public void get_green_pixel_details (uint32 mask, int shift, int precision);
		public void get_red_pixel_details (uint32 mask, int shift, int precision);
		public unowned Gdk.Screen get_screen ();
		public static unowned Gdk.Visual get_system ();
		public Gdk.VisualType get_visual_type ();
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public class Window : Gdk.Drawable {
		[CCode (has_construct_function = false)]
		public Window (Gdk.Window? parent, Gdk.WindowAttr attributes, int attributes_mask);
		public void add_filter (Gdk.FilterFunc function);
		public static unowned Gdk.Window at_pointer (out int win_x, out int win_y);
		public void beep ();
		public void begin_move_drag (int button, int root_x, int root_y, uint32 timestamp);
		public void begin_paint_rect (Gdk.Rectangle rectangle);
		public void begin_paint_region (Cairo.Region region);
		public void begin_resize_drag (Gdk.WindowEdge edge, int button, int root_x, int root_y, uint32 timestamp);
		public void configure_finished ();
		public static void constrain_size (Gdk.Geometry geometry, uint flags, int width, int height, out int new_width, out int new_height);
		public void coords_from_parent (double parent_x, double parent_y, double x, double y);
		public void coords_to_parent (double x, double y, double parent_x, double parent_y);
		public unowned Cairo.Surface create_similar_surface (Cairo.Content content, int width, int height);
		public void deiconify ();
		public void destroy ();
		public void enable_synchronized_configure ();
		public void end_paint ();
		public bool ensure_native ();
		public void flush ();
		public void focus (uint32 timestamp);
		public static unowned Gdk.Window foreign_new (Gdk.NativeWindow anid);
		public static unowned Gdk.Window foreign_new_for_display (Gdk.Display display, Gdk.NativeWindow anid);
		public void freeze_toplevel_updates_libgtk_only ();
		public void freeze_updates ();
		public void fullscreen ();
		public void geometry_changed ();
		public bool get_accept_focus ();
		public unowned Cairo.Pattern get_background_pattern ();
		public GLib.List<weak Gdk.Window> get_children ();
		public bool get_composited ();
		public unowned Gdk.Cursor? get_cursor ();
		public bool get_decorations (out Gdk.WMDecoration decorations);
		public unowned Gdk.Cursor get_device_cursor (Gdk.Device device);
		public Gdk.EventMask get_device_events (Gdk.Device device);
		public unowned Gdk.Window get_device_position (Gdk.Device device, int x, int y, Gdk.ModifierType mask);
		public unowned Gdk.Display get_display ();
		public unowned Gdk.Window get_effective_parent ();
		public unowned Gdk.Window get_effective_toplevel ();
		public Gdk.EventMask get_events ();
		public bool get_focus_on_map ();
		public void get_frame_extents (out Gdk.Rectangle rect);
		public void get_geometry (out int x, out int y, out int width, out int height, out int depth);
		public unowned Gdk.Window get_group ();
		public int get_height ();
		public bool get_modal_hint ();
		public int get_origin (out int x, out int y);
		public unowned Gdk.Window get_parent ();
		public unowned Gdk.Window get_pointer (out int x, out int y, out Gdk.ModifierType mask);
		public void get_position (out int x, out int y);
		public void get_root_coords (int x, int y, int root_x, int root_y);
		public void get_root_origin (out int x, out int y);
		public unowned Gdk.Screen get_screen ();
		public Gdk.WindowState get_state ();
		public bool get_support_multidevice ();
		public unowned Gdk.Window get_toplevel ();
		public Gdk.WindowTypeHint get_type_hint ();
		public unowned Cairo.Region get_update_area ();
		public void get_user_data (void* data);
		public unowned Gdk.Visual get_visual ();
		public int get_width ();
		public Gdk.WindowType get_window_type ();
		public bool has_native ();
		public void hide ();
		public void iconify ();
		public void input_shape_combine_region (Cairo.Region shape_region, int offset_x, int offset_y);
		public void invalidate_maybe_recurse (Cairo.Region region, Gdk.WindowChildFunc child_func);
		public void invalidate_rect (Gdk.Rectangle? rect, bool invalidate_children);
		public void invalidate_region (Cairo.Region region, bool invalidate_children);
		public bool is_destroyed ();
		public bool is_input_only ();
		public bool is_shaped ();
		public bool is_viewable ();
		public bool is_visible ();
		public static unowned Gdk.Window lookup (Gdk.NativeWindow anid);
		public static unowned Gdk.Window lookup_for_display (Gdk.Display display, Gdk.NativeWindow anid);
		public void lower ();
		public void maximize ();
		public void merge_child_input_shapes ();
		public void merge_child_shapes ();
		public void move (int x, int y);
		public void move_region (Cairo.Region region, int dx, int dy);
		public void move_resize (int x, int y, int width, int height);
		public unowned GLib.List<Gdk.Window> peek_children ();
		public static void process_all_updates ();
		public void process_updates (bool update_children);
		public void raise ();
		public void register_dnd ();
		public void remove_filter (Gdk.FilterFunc function);
		public void reparent (Gdk.Window new_parent, int x, int y);
		public void resize (int width, int height);
		public void restack (Gdk.Window sibling, bool above);
		public void scroll (int dx, int dy);
		public void set_accept_focus (bool accept_focus);
		public void set_background (Gdk.Color color);
		public void set_background_pattern (Cairo.Pattern pattern);
		public void set_background_rgba (Gdk.RGBA rgba);
		public void set_child_input_shapes ();
		public void set_child_shapes ();
		public void set_composited (bool composited);
		public void set_cursor (Gdk.Cursor? cursor);
		public static void set_debug_updates (bool setting);
		public void set_decorations (Gdk.WMDecoration decorations);
		public void set_device_cursor (Gdk.Device device, Gdk.Cursor cursor);
		public void set_device_events (Gdk.Device device, Gdk.EventMask event_mask);
		public void set_events (Gdk.EventMask event_mask);
		public void set_focus_on_map (bool focus_on_map);
		public void set_functions (Gdk.WMFunction functions);
		public void set_geometry_hints (Gdk.Geometry geometry, Gdk.WindowHints geom_mask);
		public void set_group (Gdk.Window leader);
		public void set_icon_list (GLib.List<Gdk.Pixbuf> pixbufs);
		public void set_icon_name (string name);
		public void set_keep_above (bool setting);
		public void set_keep_below (bool setting);
		public void set_modal_hint (bool modal);
		public void set_opacity (double opacity);
		public void set_override_redirect (bool override_redirect);
		public void set_role (string role);
		public void set_skip_pager_hint (bool skips_pager);
		public void set_skip_taskbar_hint (bool skips_taskbar);
		public void set_startup_id (string startup_id);
		public bool set_static_gravities (bool use_static);
		public void set_support_multidevice (bool support_multidevice);
		public void set_title (string title);
		public void set_transient_for (Gdk.Window parent);
		public void set_type_hint (Gdk.WindowTypeHint hint);
		public void set_urgency_hint (bool urgent);
		public void set_user_data (void* user_data);
		public void shape_combine_region (Cairo.Region shape_region, int offset_x, int offset_y);
		public void show ();
		public void show_unraised ();
		public void stick ();
		public void thaw_toplevel_updates_libgtk_only ();
		public void thaw_updates ();
		public void unfullscreen ();
		public void unmaximize ();
		public void unstick ();
		public void withdraw ();
		public Gdk.Cursor cursor { get; set; }
		public virtual signal Cairo.Surface create_surface (int p0, int p1);
		public virtual signal void from_embedder (double p0, double p1, void* p2, void* p3);
		public virtual signal unowned Gdk.Window pick_embedded_child (double p0, double p1);
		public virtual signal void to_embedder (double p0, double p1, void* p2, void* p3);
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	[SimpleType]
	public struct Atom {
		public static Gdk.Atom intern (string atom_name, bool only_if_exists);
		public static Gdk.Atom intern_static_string (string atom_name);
		public unowned string name ();
	}
	[CCode (type_id = "GDK_TYPE_COLOR", cheader_filename = "gdk/gdk.h")]
	public struct Color {
		public uint32 pixel;
		public uint16 red;
		public uint16 green;
		public uint16 blue;
		public Gdk.Color copy ();
		public bool equal (Gdk.Color colorb);
		public void free ();
		public uint hash ();
		public static bool parse (string spec, out Gdk.Color color);
		public string to_string ();
	}
	[CCode (type_id = "GDK_TYPE_DEVICE_AXIS", cheader_filename = "gdk/gdk.h")]
	public struct DeviceAxis {
		public Gdk.AxisUse use;
		public double min;
		public double max;
	}
	[CCode (type_id = "GDK_TYPE_DEVICE_KEY", cheader_filename = "gdk/gdk.h")]
	public struct DeviceKey {
		public uint keyval;
		public Gdk.ModifierType modifiers;
	}
	[CCode (has_type_id = false, cheader_filename = "gdk/gdk.h")]
	public struct EventAny {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
	}
	[CCode (has_type_id = false, cheader_filename = "gdk/gdk.h")]
	public struct EventButton {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public uint32 time;
		public double x;
		public double y;
		public double axes;
		public Gdk.ModifierType state;
		public uint button;
		public weak Gdk.Device device;
		public double x_root;
		public double y_root;
	}
	[CCode (has_type_id = false, cheader_filename = "gdk/gdk.h")]
	public struct EventClient {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public Gdk.Atom message_type;
		public ushort data_format;
		public void* data;
	}
	[CCode (has_type_id = false, cheader_filename = "gdk/gdk.h")]
	public struct EventConfigure {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public int x;
		public int y;
		public int width;
		public int height;
	}
	[CCode (has_type_id = false, cheader_filename = "gdk/gdk.h")]
	public struct EventCrossing {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public weak Gdk.Window subwindow;
		public uint32 time;
		public double x;
		public double y;
		public double x_root;
		public double y_root;
		public Gdk.CrossingMode mode;
		public Gdk.NotifyType detail;
		public bool focus;
		public Gdk.ModifierType state;
	}
	[CCode (has_type_id = false, cheader_filename = "gdk/gdk.h")]
	public struct EventDND {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public weak Gdk.DragContext context;
		public uint32 time;
		public short x_root;
		public short y_root;
	}
	[CCode (has_type_id = false, cheader_filename = "gdk/gdk.h")]
	public struct EventExpose {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public Gdk.Rectangle area;
		public weak Cairo.Region region;
		public int count;
	}
	[CCode (has_type_id = false, cheader_filename = "gdk/gdk.h")]
	public struct EventFocus {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public int16 @in;
	}
	[CCode (has_type_id = false, cheader_filename = "gdk/gdk.h")]
	public struct EventGrabBroken {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public bool keyboard;
		public bool implicit;
		public weak Gdk.Window grab_window;
	}
	[CCode (has_type_id = false, cheader_filename = "gdk/gdk.h")]
	public struct EventKey {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public uint32 time;
		public Gdk.ModifierType state;
		public uint keyval;
		public int length;
		[CCode (cname = "string")]
		public weak string str;
		public uint16 hardware_keycode;
		public uchar group;
		public uint is_modifier;
	}
	[CCode (has_type_id = false, cheader_filename = "gdk/gdk.h")]
	public struct EventMotion {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public uint32 time;
		public double x;
		public double y;
		public double axes;
		public Gdk.ModifierType state;
		public bool is_hint;
		public weak Gdk.Device device;
		public double x_root;
		public double y_root;
	}
	[CCode (has_type_id = false, cheader_filename = "gdk/gdk.h")]
	public struct EventNoExpose {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
	}
	[CCode (has_type_id = false, cheader_filename = "gdk/gdk.h")]
	public struct EventOwnerChange {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public Gdk.NativeWindow owner;
		public Gdk.OwnerChange reason;
		public Gdk.Atom selection;
		public uint32 time;
		public uint32 selection_time;
	}
	[CCode (has_type_id = false, cheader_filename = "gdk/gdk.h")]
	public struct EventProperty {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public Gdk.Atom atom;
		public uint32 time;
		public Gdk.PropertyState state;
	}
	[CCode (has_type_id = false, cheader_filename = "gdk/gdk.h")]
	public struct EventProximity {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public uint32 time;
		public weak Gdk.Device device;
	}
	[CCode (has_type_id = false, cheader_filename = "gdk/gdk.h")]
	public struct EventScroll {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public uint32 time;
		public double x;
		public double y;
		public Gdk.ModifierType state;
		public Gdk.ScrollDirection direction;
		public weak Gdk.Device device;
		public double x_root;
		public double y_root;
	}
	[CCode (has_type_id = false, cheader_filename = "gdk/gdk.h")]
	public struct EventSelection {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public Gdk.Atom selection;
		public Gdk.Atom target;
		public Gdk.Atom property;
		public uint32 time;
		public Gdk.NativeWindow requestor;
	}
	[CCode (has_type_id = false, cheader_filename = "gdk/gdk.h")]
	public struct EventSetting {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public Gdk.SettingAction action;
		public weak string name;
	}
	[CCode (has_type_id = false, cheader_filename = "gdk/gdk.h")]
	public struct EventVisibility {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public Gdk.VisibilityState state;
	}
	[CCode (has_type_id = false, cheader_filename = "gdk/gdk.h")]
	public struct EventWindowState {
		public Gdk.EventType type;
		public weak Gdk.Window window;
		public char send_event;
		public Gdk.WindowState changed_mask;
		public Gdk.WindowState new_window_state;
	}
	[CCode (type_id = "GDK_TYPE_GEOMETRY", cheader_filename = "gdk/gdk.h")]
	public struct Geometry {
		public int min_width;
		public int min_height;
		public int max_width;
		public int max_height;
		public int base_width;
		public int base_height;
		public int width_inc;
		public int height_inc;
		public double min_aspect;
		public double max_aspect;
		public Gdk.Gravity win_gravity;
	}
	[CCode (type_id = "GDK_TYPE_KEYMAP_KEY", cheader_filename = "gdk/gdk.h")]
	public struct KeymapKey {
		public uint keycode;
		public int group;
		public int level;
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	[SimpleType]
	public struct NativeWindow {
	}
	[CCode (type_id = "GDK_TYPE_POINT", cheader_filename = "gdk/gdk.h")]
	public struct Point {
		public int x;
		public int y;
	}
	[CCode (type_id = "GDK_TYPE_RGBA", cheader_filename = "gdk/gdk.h")]
	public struct RGBA {
		public double red;
		public double green;
		public double blue;
		public double alpha;
		public Gdk.RGBA copy ();
		public static bool equal (void* p1, void* p2);
		public void free ();
		public static uint hash (void* p);
		public static bool parse (string spec, Gdk.RGBA rgba);
		public unowned string to_string ();
	}
	[CCode (type_id = "GDK_TYPE_RECTANGLE", cheader_filename = "gdk/gdk.h")]
	public struct Rectangle {
		public bool intersect (Gdk.Rectangle src2, Gdk.Rectangle dest);
		public void union (Gdk.Rectangle src2, out Gdk.Rectangle dest);
	}
	[CCode (type_id = "GDK_TYPE_TIME_COORD", cheader_filename = "gdk/gdk.h")]
	public struct TimeCoord {
		public uint32 time;
		[CCode (array_length = false)]
		public weak double[] axes;
	}
	[CCode (type_id = "GDK_TYPE_WINDOW_ATTR", cheader_filename = "gdk/gdk.h")]
	public struct WindowAttr {
		public weak string title;
		public int event_mask;
		public int x;
		public int y;
		public int width;
		public int height;
		public Gdk.WindowClass wclass;
		public weak Gdk.Visual visual;
		public Gdk.WindowType window_type;
		public weak Gdk.Cursor cursor;
		public weak string wmclass_name;
		public weak string wmclass_class;
		public bool override_redirect;
		public Gdk.WindowTypeHint type_hint;
	}
	[CCode (type_id = "GDK_TYPE_WINDOW_REDIRECT", cheader_filename = "gdk/gdk.h")]
	public struct WindowRedirect {
	}
	[CCode (type_id = "GDK_TYPE_XEVENT", cheader_filename = "gdk/gdk.h")]
	public struct XEvent {
	}
	[CCode (cprefix = "GDK_AXIS_", cheader_filename = "gdk/gdk.h")]
	public enum AxisUse {
		IGNORE,
		X,
		Y,
		PRESSURE,
		XTILT,
		YTILT,
		WHEEL,
		LAST
	}
	[CCode (cprefix = "GDK_", cheader_filename = "gdk/gdk.h")]
	public enum ByteOrder {
		LSB_FIRST,
		MSB_FIRST
	}
	[CCode (cprefix = "GDK_CROSSING_", cheader_filename = "gdk/gdk.h")]
	public enum CrossingMode {
		NORMAL,
		GRAB,
		UNGRAB,
		GTK_GRAB,
		GTK_UNGRAB,
		STATE_CHANGED
	}
	[CCode (cprefix = "GDK_", cheader_filename = "gdk/gdk.h")]
	public enum CursorType {
		X_CURSOR,
		ARROW,
		BASED_ARROW_DOWN,
		BASED_ARROW_UP,
		BOAT,
		BOGOSITY,
		BOTTOM_LEFT_CORNER,
		BOTTOM_RIGHT_CORNER,
		BOTTOM_SIDE,
		BOTTOM_TEE,
		BOX_SPIRAL,
		CENTER_PTR,
		CIRCLE,
		CLOCK,
		COFFEE_MUG,
		CROSS,
		CROSS_REVERSE,
		CROSSHAIR,
		DIAMOND_CROSS,
		DOT,
		DOTBOX,
		DOUBLE_ARROW,
		DRAFT_LARGE,
		DRAFT_SMALL,
		DRAPED_BOX,
		EXCHANGE,
		FLEUR,
		GOBBLER,
		GUMBY,
		HAND1,
		HAND2,
		HEART,
		ICON,
		IRON_CROSS,
		LEFT_PTR,
		LEFT_SIDE,
		LEFT_TEE,
		LEFTBUTTON,
		LL_ANGLE,
		LR_ANGLE,
		MAN,
		MIDDLEBUTTON,
		MOUSE,
		PENCIL,
		PIRATE,
		PLUS,
		QUESTION_ARROW,
		RIGHT_PTR,
		RIGHT_SIDE,
		RIGHT_TEE,
		RIGHTBUTTON,
		RTL_LOGO,
		SAILBOAT,
		SB_DOWN_ARROW,
		SB_H_DOUBLE_ARROW,
		SB_LEFT_ARROW,
		SB_RIGHT_ARROW,
		SB_UP_ARROW,
		SB_V_DOUBLE_ARROW,
		SHUTTLE,
		SIZING,
		SPIDER,
		SPRAYCAN,
		STAR,
		TARGET,
		TCROSS,
		TOP_LEFT_ARROW,
		TOP_LEFT_CORNER,
		TOP_RIGHT_CORNER,
		TOP_SIDE,
		TOP_TEE,
		TREK,
		UL_ANGLE,
		UMBRELLA,
		UR_ANGLE,
		WATCH,
		XTERM,
		LAST_CURSOR,
		BLANK_CURSOR,
		CURSOR_IS_PIXMAP
	}
	[CCode (cprefix = "GDK_DEVICE_TYPE_", cheader_filename = "gdk/gdk.h")]
	public enum DeviceType {
		MASTER,
		SLAVE,
		FLOATING
	}
	[CCode (cprefix = "GDK_ACTION_", cheader_filename = "gdk/gdk.h")]
	[Flags]
	public enum DragAction {
		DEFAULT,
		COPY,
		MOVE,
		LINK,
		PRIVATE,
		ASK
	}
	[CCode (cprefix = "GDK_DRAG_PROTO_", cheader_filename = "gdk/gdk.h")]
	public enum DragProtocol {
		MOTIF,
		XDND,
		ROOTWIN,
		NONE,
		WIN32_DROPFILES,
		OLE2,
		LOCAL
	}
	[CCode (cprefix = "GDK_", cheader_filename = "gdk/gdk.h")]
	[Flags]
	public enum EventMask {
		EXPOSURE_MASK,
		POINTER_MOTION_MASK,
		POINTER_MOTION_HINT_MASK,
		BUTTON_MOTION_MASK,
		BUTTON1_MOTION_MASK,
		BUTTON2_MOTION_MASK,
		BUTTON3_MOTION_MASK,
		BUTTON_PRESS_MASK,
		BUTTON_RELEASE_MASK,
		KEY_PRESS_MASK,
		KEY_RELEASE_MASK,
		ENTER_NOTIFY_MASK,
		LEAVE_NOTIFY_MASK,
		FOCUS_CHANGE_MASK,
		STRUCTURE_MASK,
		PROPERTY_CHANGE_MASK,
		VISIBILITY_NOTIFY_MASK,
		PROXIMITY_IN_MASK,
		PROXIMITY_OUT_MASK,
		SUBSTRUCTURE_MASK,
		SCROLL_MASK,
		ALL_EVENTS_MASK
	}
	[CCode (cprefix = "GDK_", cheader_filename = "gdk/gdk.h")]
	public enum EventType {
		NOTHING,
		DELETE,
		DESTROY,
		EXPOSE,
		MOTION_NOTIFY,
		BUTTON_PRESS,
		@2BUTTON_PRESS,
		@3BUTTON_PRESS,
		BUTTON_RELEASE,
		KEY_PRESS,
		KEY_RELEASE,
		ENTER_NOTIFY,
		LEAVE_NOTIFY,
		FOCUS_CHANGE,
		CONFIGURE,
		MAP,
		UNMAP,
		PROPERTY_NOTIFY,
		SELECTION_CLEAR,
		SELECTION_REQUEST,
		SELECTION_NOTIFY,
		PROXIMITY_IN,
		PROXIMITY_OUT,
		DRAG_ENTER,
		DRAG_LEAVE,
		DRAG_MOTION,
		DRAG_STATUS,
		DROP_START,
		DROP_FINISHED,
		CLIENT_EVENT,
		VISIBILITY_NOTIFY,
		NO_EXPOSE,
		SCROLL,
		WINDOW_STATE,
		SETTING,
		OWNER_CHANGE,
		GRAB_BROKEN,
		DAMAGE,
		EVENT_LAST
	}
	[CCode (cprefix = "GDK_EXTENSION_EVENTS_", cheader_filename = "gdk/gdk.h")]
	public enum ExtensionMode {
		NONE,
		ALL,
		CURSOR
	}
	[CCode (cprefix = "GDK_FILTER_", cheader_filename = "gdk/gdk.h")]
	public enum FilterReturn {
		CONTINUE,
		TRANSLATE,
		REMOVE
	}
	[CCode (cprefix = "GDK_OWNERSHIP_", cheader_filename = "gdk/gdk.h")]
	public enum GrabOwnership {
		NONE,
		WINDOW,
		APPLICATION
	}
	[CCode (cprefix = "GDK_GRAB_", cheader_filename = "gdk/gdk.h")]
	public enum GrabStatus {
		SUCCESS,
		ALREADY_GRABBED,
		INVALID_TIME,
		NOT_VIEWABLE,
		FROZEN
	}
	[CCode (cprefix = "GDK_GRAVITY_", cheader_filename = "gdk/gdk.h")]
	public enum Gravity {
		NORTH_WEST,
		NORTH,
		NORTH_EAST,
		WEST,
		CENTER,
		EAST,
		SOUTH_WEST,
		SOUTH,
		SOUTH_EAST,
		STATIC
	}
	[CCode (cprefix = "GDK_MODE_", cheader_filename = "gdk/gdk.h")]
	public enum InputMode {
		DISABLED,
		SCREEN,
		WINDOW
	}
	[CCode (cprefix = "GDK_SOURCE_", cheader_filename = "gdk/gdk.h")]
	public enum InputSource {
		MOUSE,
		PEN,
		ERASER,
		CURSOR,
		KEYBOARD
	}
	[CCode (cprefix = "GDK_", cheader_filename = "gdk/gdk.h")]
	[Flags]
	public enum ModifierType {
		SHIFT_MASK,
		LOCK_MASK,
		CONTROL_MASK,
		MOD1_MASK,
		MOD2_MASK,
		MOD3_MASK,
		MOD4_MASK,
		MOD5_MASK,
		BUTTON1_MASK,
		BUTTON2_MASK,
		BUTTON3_MASK,
		BUTTON4_MASK,
		BUTTON5_MASK,
		SUPER_MASK,
		HYPER_MASK,
		META_MASK,
		RELEASE_MASK,
		MODIFIER_MASK
	}
	[CCode (cprefix = "GDK_NOTIFY_", cheader_filename = "gdk/gdk.h")]
	public enum NotifyType {
		ANCESTOR,
		VIRTUAL,
		INFERIOR,
		NONLINEAR,
		NONLINEAR_VIRTUAL,
		UNKNOWN
	}
	[CCode (cprefix = "GDK_OWNER_CHANGE_", cheader_filename = "gdk/gdk.h")]
	public enum OwnerChange {
		NEW_OWNER,
		DESTROY,
		CLOSE
	}
	[CCode (cprefix = "GDK_PROP_MODE_", cheader_filename = "gdk/gdk.h")]
	public enum PropMode {
		REPLACE,
		PREPEND,
		APPEND
	}
	[CCode (cprefix = "GDK_PROPERTY_", cheader_filename = "gdk/gdk.h")]
	public enum PropertyState {
		NEW_VALUE,
		DELETE
	}
	[CCode (cprefix = "GDK_SCROLL_", cheader_filename = "gdk/gdk.h")]
	public enum ScrollDirection {
		UP,
		DOWN,
		LEFT,
		RIGHT
	}
	[CCode (cprefix = "GDK_SETTING_ACTION_", cheader_filename = "gdk/gdk.h")]
	public enum SettingAction {
		NEW,
		CHANGED,
		DELETED
	}
	[CCode (cprefix = "GDK_", cheader_filename = "gdk/gdk.h")]
	public enum Status {
		OK,
		ERROR,
		ERROR_PARAM,
		ERROR_FILE,
		ERROR_MEM
	}
	[CCode (cprefix = "GDK_VISIBILITY_", cheader_filename = "gdk/gdk.h")]
	public enum VisibilityState {
		UNOBSCURED,
		PARTIAL,
		FULLY_OBSCURED
	}
	[CCode (cprefix = "GDK_VISUAL_", cheader_filename = "gdk/gdk.h")]
	public enum VisualType {
		STATIC_GRAY,
		GRAYSCALE,
		STATIC_COLOR,
		PSEUDO_COLOR,
		TRUE_COLOR,
		DIRECT_COLOR
	}
	[CCode (cprefix = "GDK_DECOR_", cheader_filename = "gdk/gdk.h")]
	[Flags]
	public enum WMDecoration {
		ALL,
		BORDER,
		RESIZEH,
		TITLE,
		MENU,
		MINIMIZE,
		MAXIMIZE
	}
	[CCode (cprefix = "GDK_FUNC_", cheader_filename = "gdk/gdk.h")]
	[Flags]
	public enum WMFunction {
		ALL,
		RESIZE,
		MOVE,
		MINIMIZE,
		MAXIMIZE,
		CLOSE
	}
	[CCode (cprefix = "GDK_WA_", cheader_filename = "gdk/gdk.h")]
	[Flags]
	public enum WindowAttributesType {
		TITLE,
		X,
		Y,
		CURSOR,
		VISUAL,
		WMCLASS,
		NOREDIR,
		TYPE_HINT
	}
	[CCode (cprefix = "GDK_", cheader_filename = "gdk/gdk.h")]
	public enum WindowClass {
		INPUT_OUTPUT,
		INPUT_ONLY
	}
	[CCode (cprefix = "GDK_WINDOW_EDGE_", cheader_filename = "gdk/gdk.h")]
	public enum WindowEdge {
		NORTH_WEST,
		NORTH,
		NORTH_EAST,
		WEST,
		EAST,
		SOUTH_WEST,
		SOUTH,
		SOUTH_EAST
	}
	[CCode (cprefix = "GDK_HINT_", cheader_filename = "gdk/gdk.h")]
	[Flags]
	public enum WindowHints {
		POS,
		MIN_SIZE,
		MAX_SIZE,
		BASE_SIZE,
		ASPECT,
		RESIZE_INC,
		WIN_GRAVITY,
		USER_POS,
		USER_SIZE
	}
	[CCode (cprefix = "GDK_WINDOW_STATE_", cheader_filename = "gdk/gdk.h")]
	[Flags]
	public enum WindowState {
		WITHDRAWN,
		ICONIFIED,
		MAXIMIZED,
		STICKY,
		FULLSCREEN,
		ABOVE,
		BELOW
	}
	[CCode (cprefix = "GDK_WINDOW_", cheader_filename = "gdk/gdk.h")]
	public enum WindowType {
		ROOT,
		TOPLEVEL,
		CHILD,
		TEMP,
		FOREIGN,
		OFFSCREEN
	}
	[CCode (cprefix = "GDK_WINDOW_TYPE_HINT_", cheader_filename = "gdk/gdk.h")]
	public enum WindowTypeHint {
		NORMAL,
		DIALOG,
		MENU,
		TOOLBAR,
		SPLASHSCREEN,
		UTILITY,
		DOCK,
		DESKTOP,
		DROPDOWN_MENU,
		POPUP_MENU,
		TOOLTIP,
		NOTIFICATION,
		COMBO,
		DND
	}
	[CCode (cheader_filename = "gdk/gdk.h")]
	public delegate void EventFunc (Gdk.Event event);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public delegate Gdk.FilterReturn FilterFunc (Gdk.XEvent xevent, Gdk.Event event);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public delegate bool WindowChildFunc (Gdk.Window window);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public const int CURRENT_TIME;
	[CCode (cheader_filename = "gdk/gdk.h")]
	public const int MAX_TIMECOORD_AXES;
	[CCode (cheader_filename = "gdk/gdk.h")]
	public const int PARENT_RELATIVE;
	[CCode (cheader_filename = "gdk/gdk.h")]
	public const int PRIORITY_REDRAW;
	[CCode (cheader_filename = "gdk/gdk.h")]
	public const Gdk.Atom SELECTION_CLIPBOARD;
	[CCode (cheader_filename = "gdk/gdk.h")]
	public const Gdk.Atom SELECTION_PRIMARY;
	[CCode (cheader_filename = "gdk/gdk.h")]
	public const Gdk.Atom SELECTION_SECONDARY;
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void add_client_message_filter (Gdk.Atom message_type, Gdk.FilterFunc func);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void add_option_entries_libgtk_only (GLib.OptionGroup group);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void beep ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static Cairo.Context cairo_create (Gdk.Drawable drawable);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool cairo_get_clip_rectangle (Cairo.Context cr, Gdk.Rectangle rect);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void cairo_rectangle (Cairo.Context cr, Gdk.Rectangle rectangle);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void cairo_region (Cairo.Context cr, Cairo.Region region);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Cairo.Region cairo_region_create_from_surface (Cairo.Surface surface);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void cairo_reset_clip (Cairo.Context cr, Gdk.Drawable drawable);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void cairo_set_source_color (Cairo.Context cr, Gdk.Color color);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void cairo_set_source_pixbuf (Cairo.Context cr, Gdk.Pixbuf pixbuf, double pixbuf_x, double pixbuf_y);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void cairo_set_source_rgba (Cairo.Context cr, Gdk.RGBA rgba);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void cairo_set_source_window (Cairo.Context cr, Gdk.Window window, double x, double y);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void drag_abort (Gdk.DragContext context, uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Gdk.DragContext drag_begin (Gdk.Window window, GLib.List targets);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void drag_drop (Gdk.DragContext context, uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool drag_drop_succeeded (Gdk.DragContext context);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void drag_find_window (Gdk.DragContext context, Gdk.Window drag_window, int x_root, int y_root, out unowned Gdk.Window dest_window, Gdk.DragProtocol protocol);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void drag_find_window_for_screen (Gdk.DragContext context, Gdk.Window drag_window, Gdk.Screen screen, int x_root, int y_root, out unowned Gdk.Window dest_window, Gdk.DragProtocol protocol);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static Gdk.NativeWindow drag_get_protocol (Gdk.NativeWindow xid, Gdk.DragProtocol protocol);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static Gdk.NativeWindow drag_get_protocol_for_display (Gdk.Display display, Gdk.NativeWindow xid, Gdk.DragProtocol protocol);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static Gdk.Atom drag_get_selection (Gdk.DragContext context);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool drag_motion (Gdk.DragContext context, Gdk.Window dest_window, Gdk.DragProtocol protocol, int x_root, int y_root, Gdk.DragAction suggested_action, Gdk.DragAction possible_actions, uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void drag_status (Gdk.DragContext context, Gdk.DragAction action, uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void drop_finish (Gdk.DragContext context, bool success, uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void drop_reply (Gdk.DragContext context, bool ok, uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void enable_multidevice ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static int error_trap_pop ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void error_trap_pop_ignored ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void error_trap_push ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool events_get_angle (Gdk.Event event1, Gdk.Event event2, double angle);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool events_get_center (Gdk.Event event1, Gdk.Event event2, double x, double y);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool events_get_distance (Gdk.Event event1, Gdk.Event event2, double distance);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool events_pending ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void flush ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void free_compound_text (uchar[] ctext);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void free_text_list (string list);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Gdk.Window get_default_root_window ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned string get_display ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned string get_display_arg_name ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned string get_program_class ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool get_show_events ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void init ([CCode (array_length_pos = 0.9)] ref unowned string[] argv);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool init_check ([CCode (array_length_pos = 0.9)] ref unowned string[] argv);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static Gdk.GrabStatus keyboard_grab (Gdk.Window window, bool owner_events, uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void keyboard_ungrab (uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void keyval_convert_case (uint symbol, uint lower, uint upper);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static uint keyval_from_name (string keyval_name);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool keyval_is_lower (uint keyval);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool keyval_is_upper (uint keyval);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned string keyval_name (uint keyval);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static uint keyval_to_lower (uint keyval);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static uint32 keyval_to_unicode (uint keyval);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static uint keyval_to_upper (uint keyval);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static GLib.List<weak Gdk.Visual> list_visuals ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void notify_startup_complete ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void notify_startup_complete_with_id (string startup_id);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Gdk.Window? offscreen_window_get_embedder (Gdk.Window window);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Cairo.Surface offscreen_window_get_surface (Gdk.Window window);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void offscreen_window_set_embedder (Gdk.Window window, Gdk.Window embedder);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Pango.Context pango_context_get ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Pango.Context pango_context_get_for_screen (Gdk.Screen screen);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Cairo.Region pango_layout_get_clip_region (Pango.Layout layout, int x_origin, int y_origin, int index_ranges, int n_ranges);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Cairo.Region pango_layout_line_get_clip_region (Pango.LayoutLine line, int x_origin, int y_origin, int index_ranges, int n_ranges);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void parse_args (int argc, string argv);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Gdk.Pixbuf pixbuf_get_from_surface (Cairo.Surface surface, int src_x, int src_y, int width, int height);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Gdk.Pixbuf pixbuf_get_from_window (Gdk.Window window, int src_x, int src_y, int width, int height);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static Gdk.GrabStatus pointer_grab (Gdk.Window window, bool owner_events, Gdk.EventMask event_mask, Gdk.Window? confine_to, Gdk.Cursor? cursor, uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool pointer_is_grabbed ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void pointer_ungrab (uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void pre_parse_libgtk_only ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void property_change (Gdk.Window window, Gdk.Atom property, Gdk.Atom type, int format, Gdk.PropMode mode, [CCode (array_length = false)] uchar[] data, int nelements);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void property_delete (Gdk.Window window, Gdk.Atom property);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool property_get (Gdk.Window window, Gdk.Atom property, Gdk.Atom type, ulong offset, ulong length, int pdelete, out Gdk.Atom actual_property_type, out int actual_format, [CCode (array_length_pos = 8.9)] out uchar[] data);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void query_depths (int depths, int count);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void query_visual_types (out Gdk.VisualType visual_types, int count);
	[Deprecated (since = "vala-0.12", replacement = "Selection.convert")]
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void selection_convert (Gdk.Window requestor, Gdk.Atom selection, Gdk.Atom target, uint32 time_);
	[Deprecated (since = "vala-0.12", replacement = "Selection.owner_get")]
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Gdk.Window selection_owner_get (Gdk.Atom selection);
	[Deprecated (since = "vala-0.12", replacement = "Selection.owner_get_for_display")]
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Gdk.Window selection_owner_get_for_display (Gdk.Display display, Gdk.Atom selection);
	[Deprecated (since = "vala-0.12", replacement = "Selection.owner_set")]
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool selection_owner_set (Gdk.Window owner, Gdk.Atom selection, uint32 time_, bool send_event);
	[Deprecated (since = "vala-0.12", replacement = "Selection.owner_set_for_display")]
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool selection_owner_set_for_display (Gdk.Display display, Gdk.Window owner, Gdk.Atom selection, uint32 time_, bool send_event);
	[Deprecated (since = "vala-0.12", replacement = "Selection.property_get")]
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static int selection_property_get (Gdk.Window requestor, uchar[] data, out Gdk.Atom prop_type, int prop_format);
	[Deprecated (since = "vala-0.12", replacement = "Selection.send_notify")]
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void selection_send_notify (Gdk.NativeWindow requestor, Gdk.Atom selection, Gdk.Atom target, Gdk.Atom property, uint32 time_);
	[Deprecated (since = "vala-0.12", replacement = "Selection.send_notify_for_display")]
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void selection_send_notify_for_display (Gdk.Display display, Gdk.NativeWindow requestor, Gdk.Atom selection, Gdk.Atom target, Gdk.Atom property, uint32 time_);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void set_double_click_time (uint msec);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned string set_locale ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned Gdk.PointerHooks set_pointer_hooks (Gdk.PointerHooks new_hooks);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void set_program_class (string program_class);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void set_show_events (bool show_events);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void set_sm_client_id (string sm_client_id);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool setting_get (string name, GLib.Value value);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool spawn_command_line_on_screen (Gdk.Screen screen, string command_line) throws GLib.Error;
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool spawn_on_screen (Gdk.Screen screen, string? working_directory, [CCode (array_length = false)] string[] argv, [CCode (array_length = false)] string[]? envp, GLib.SpawnFlags flags, GLib.SpawnChildSetupFunc? child_setup, out GLib.Pid child_pid) throws GLib.Error;
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool spawn_on_screen_with_pipes (Gdk.Screen screen, string? working_directory, [CCode (array_length = false)] string[] argv, [CCode (array_length = false)] string[] envp, GLib.SpawnFlags flags, GLib.SpawnChildSetupFunc? child_setup, out GLib.Pid child_pid, out int standard_input, out int standard_output, out int standard_error) throws GLib.Error;
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static int string_to_compound_text (string str, Gdk.Atom encoding, int format, uchar[] ctext, int length);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static int string_to_compound_text_for_display (Gdk.Display display, string str, Gdk.Atom encoding, int format, uchar[] ctext, int length);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void test_render_sync (Gdk.Window window);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool test_simulate_button (Gdk.Window window, int x, int y, uint button, Gdk.ModifierType modifiers, Gdk.EventType button_pressrelease);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool test_simulate_key (Gdk.Window window, int x, int y, uint keyval, Gdk.ModifierType modifiers, Gdk.EventType key_pressrelease);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static int text_property_to_text_list (Gdk.Atom encoding, int format, uchar[] text, int length, string list);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static int text_property_to_text_list_for_display (Gdk.Display display, Gdk.Atom encoding, int format, uchar[] text, int length, string list);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static int text_property_to_utf8_list (Gdk.Atom encoding, int format, uchar[] text, int length, string list);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static int text_property_to_utf8_list_for_display (Gdk.Display display, Gdk.Atom encoding, int format, uchar[] text, int length, string list);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static uint threads_add_idle (GLib.SourceFunc function);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static uint threads_add_idle_full (int priority, GLib.SourceFunc function, void* data, GLib.DestroyNotify notify);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static uint threads_add_timeout (uint interval, GLib.SourceFunc function, void* data);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static uint threads_add_timeout_full (int priority, uint interval, GLib.SourceFunc function, void* data, GLib.DestroyNotify notify);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static uint threads_add_timeout_seconds (uint interval, GLib.SourceFunc function, void* data);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static uint threads_add_timeout_seconds_full (int priority, uint interval, GLib.SourceFunc function, void* data, GLib.DestroyNotify notify);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void threads_enter ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void threads_init ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void threads_leave ();
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static void threads_set_lock_functions (GLib.Callback enter_fn, GLib.Callback leave_fn);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static uint unicode_to_keyval (uint32 wc);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool utf8_to_compound_text (string str, Gdk.Atom encoding, int format, uchar[] ctext, int length);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static bool utf8_to_compound_text_for_display (Gdk.Display display, string str, Gdk.Atom encoding, int format, uchar[] ctext, int length);
	[CCode (cheader_filename = "gdk/gdk.h")]
	public static unowned string utf8_to_string_target (string str);
}
