/* valagidlparser.c generated by valac, the Vala compiler
 * generated from valagidlparser.vala, do not modify */

/* valagidlparser.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gidlparser.h>
#include <gidlmodule.h>
#include <stdio.h>
#include <gidlnode.h>
#include <gmetadata.h>
#include <float.h>
#include <math.h>


#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))

typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
typedef struct _ValaGIdlParserPrivate ValaGIdlParserPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_idl_module_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_idl_module_free0_ (var), NULL)))
#define __g_list_free__vala_code_node_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__vala_code_node_unref0_ (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define __g_slist_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_free0_ (var), NULL)))

struct _ValaGIdlParser {
	ValaCodeVisitor parent_instance;
	ValaGIdlParserPrivate * priv;
};

struct _ValaGIdlParserClass {
	ValaCodeVisitorClass parent_class;
};

struct _ValaGIdlParserPrivate {
	ValaCodeContext* context;
	ValaSourceFile* current_source_file;
	ValaSourceReference* current_source_reference;
	ValaNamespace* current_namespace;
	ValaTypeSymbol* current_data_type;
	ValaMap* codenode_attributes_map;
	ValaMap* codenode_attributes_patterns;
	ValaSet* current_type_symbol_set;
	ValaMap* cname_type_map;
};


static gpointer vala_gidl_parser_parent_class = NULL;

GType vala_gidl_parser_get_type (void) G_GNUC_CONST;
#define VALA_GIDL_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GIDL_PARSER, ValaGIdlParserPrivate))
enum  {
	VALA_GIDL_PARSER_DUMMY_PROPERTY
};
void vala_gidl_parser_parse (ValaGIdlParser* self, ValaCodeContext* context);
static void vala_gidl_parser_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void vala_gidl_parser_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_gidl_parser_visit_type (ValaGIdlParser* self, ValaTypeSymbol* t);
static void vala_gidl_parser_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_gidl_parser_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_gidl_parser_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_gidl_parser_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed);
static void vala_gidl_parser_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d);
static void vala_gidl_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static void vala_gidl_parser_parse_file (ValaGIdlParser* self, ValaSourceFile* source_file);
static ValaNamespace* vala_gidl_parser_parse_module (ValaGIdlParser* self, GIdlModule* module);
static void _g_idl_module_free0_ (gpointer var);
static void _g_list_free__g_idl_module_free0_ (GList* self);
static gchar* vala_gidl_parser_fix_type_name (ValaGIdlParser* self, const gchar* type_name, ValaSymbol* container);
static gchar** vala_gidl_parser_get_attributes (ValaGIdlParser* self, const gchar* codenode, int* result_length1);
static gchar* vala_gidl_parser_eval (ValaGIdlParser* self, const gchar* s);
static gchar* vala_gidl_parser_fix_const_name (ValaGIdlParser* self, const gchar* const_name, ValaSymbol* container);
static gchar** vala_gidl_parser_get_attributes_for_node (ValaGIdlParser* self, GIdlNode* node, int* result_length1);
static void vala_gidl_parser_add_symbol_to_container (ValaGIdlParser* self, ValaSymbol* container, ValaSymbol* sym);
static void vala_gidl_parser_parse_node (ValaGIdlParser* self, GIdlNode* node, GIdlModule* module, ValaSymbol* container);
static ValaDelegate* vala_gidl_parser_parse_delegate (ValaGIdlParser* self, GIdlNodeFunction* f_node);
static void vala_gidl_parser_parse_struct (ValaGIdlParser* self, GIdlNodeStruct* st_node, ValaSymbol* container, GIdlModule* module);
static void vala_gidl_parser_parse_union (ValaGIdlParser* self, GIdlNodeUnion* un_node, ValaSymbol* container, GIdlModule* module);
static void vala_gidl_parser_parse_boxed (ValaGIdlParser* self, GIdlNodeBoxed* boxed_node, ValaSymbol* container, GIdlModule* module);
static void vala_gidl_parser_parse_enum (ValaGIdlParser* self, GIdlNodeEnum* en_node, ValaSymbol* container, GIdlModule* module, gboolean is_flags);
static void vala_gidl_parser_parse_object (ValaGIdlParser* self, GIdlNodeInterface* node, ValaSymbol* container, GIdlModule* module);
static void vala_gidl_parser_parse_interface (ValaGIdlParser* self, GIdlNodeInterface* node, ValaSymbol* container, GIdlModule* module);
static ValaConstant* vala_gidl_parser_parse_constant (ValaGIdlParser* self, GIdlNodeConstant* const_node);
static ValaMethod* vala_gidl_parser_parse_function (ValaGIdlParser* self, GIdlNodeFunction* f, gboolean is_interface);
static ValaSymbol* vala_gidl_parser_get_container_from_name (ValaGIdlParser* self, const gchar* name);
static void _vala_code_node_unref0_ (gpointer var);
static void _g_list_free__vala_code_node_unref0_ (GList* self);
static ValaDataType* vala_gidl_parser_parse_param (ValaGIdlParser* self, GIdlNodeParam* param, ValaParameterDirection* direction);
ValaDataType* vala_gidl_parser_get_type_from_string (ValaGIdlParser* self, const gchar* type_arg);
static gboolean vala_gidl_parser_is_reference_type (ValaGIdlParser* self, const gchar* cname);
static ValaDataType* vala_gidl_parser_parse_type_string (ValaGIdlParser* self, const gchar* n);
static ValaField* vala_gidl_parser_parse_field (ValaGIdlParser* self, GIdlNodeField* field_node);
static ValaDataType* vala_gidl_parser_parse_type (ValaGIdlParser* self, GIdlNodeType* type_node, ValaParameterDirection* direction);
static ValaMethod* vala_gidl_parser_parse_virtual (ValaGIdlParser* self, GIdlNodeVFunc* v, GIdlNodeFunction* func, gboolean is_interface);
static ValaProperty* vala_gidl_parser_parse_property (ValaGIdlParser* self, GIdlNodeProperty* prop_node);
static ValaSignal* vala_gidl_parser_parse_signal (ValaGIdlParser* self, GIdlNodeSignal* sig_node);
static void vala_gidl_parser_handle_async_methods (ValaGIdlParser* self, ValaObjectTypeSymbol* type_symbol);
static gboolean vala_gidl_parser_is_simple_type (ValaGIdlParser* self, const gchar* type_name);
static ValaMethod* vala_gidl_parser_create_method (ValaGIdlParser* self, const gchar* name, const gchar* symbol, GIdlNodeParam* res, GList* parameters, gboolean is_constructor, gboolean is_interface);
static gboolean vala_gidl_parser_param_is_exception (ValaGIdlParser* self, GIdlNodeParam* param);
static gchar* vala_gidl_parser_fix_prop_name (ValaGIdlParser* self, const gchar* name);
static void _g_free0_ (gpointer var);
static void _g_slist_free__g_free0_ (GSList* self);
ValaGIdlParser* vala_gidl_parser_new (void);
ValaGIdlParser* vala_gidl_parser_construct (GType object_type);
static void vala_gidl_parser_finalize (ValaCodeVisitor* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * Parse all source files in the specified code context and build a
 * code tree.
 *
 * @param context a code context
 */
static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


void vala_gidl_parser_parse (ValaGIdlParser* self, ValaCodeContext* context) {
	ValaHashMap* _tmp0_ = NULL;
	ValaMap* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaCodeContext* _tmp3_;
	ValaMap* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_str_hash, g_str_equal, g_direct_equal);
	_tmp1_ = (ValaMap*) _tmp0_;
	_vala_map_unref0 (self->priv->cname_type_map);
	self->priv->cname_type_map = _tmp1_;
	_tmp2_ = _vala_code_context_ref0 (context);
	_tmp3_ = _tmp2_;
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp3_;
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	_tmp4_ = NULL;
	_vala_map_unref0 (self->priv->cname_type_map);
	self->priv->cname_type_map = _tmp4_;
}


static void vala_gidl_parser_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (ns != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) ns, (ValaCodeVisitor*) self);
}


static void vala_gidl_parser_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (cl != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) cl);
}


static void vala_gidl_parser_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (st != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) st);
}


static void vala_gidl_parser_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (iface != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) iface);
}


static void vala_gidl_parser_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (en != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) en);
}


static void vala_gidl_parser_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (ed != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) ed);
}


static void vala_gidl_parser_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (d != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) d);
}


static void vala_gidl_parser_visit_type (ValaGIdlParser* self, ValaTypeSymbol* t) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	_tmp0_ = vala_typesymbol_get_cname (t, FALSE);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_map_contains (self->priv->cname_type_map, _tmp1_);
	if ((_tmp3_ = !_tmp2_, _g_free0 (_tmp1_), _tmp3_)) {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp4_ = vala_typesymbol_get_cname (t, FALSE);
		_tmp5_ = _tmp4_;
		vala_map_set (self->priv->cname_type_map, _tmp5_, t);
		_g_free0 (_tmp5_);
	}
}


static void vala_gidl_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file) {
	ValaGIdlParser * self;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0_ = vala_source_file_get_filename (source_file);
	_tmp1_ = g_str_has_suffix (_tmp0_, ".gi");
	if (_tmp1_) {
		vala_gidl_parser_parse_file (self, source_file);
	}
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static void _g_idl_module_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_idl_module_free (var), NULL));
}


static void _g_list_free__g_idl_module_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_idl_module_free0_, NULL);
	g_list_free (self);
}


static void vala_gidl_parser_parse_file (ValaGIdlParser* self, ValaSourceFile* source_file) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	glong _tmp2_;
	glong _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* metadata_filename;
	ValaSourceFile* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaHashMap* _tmp10_ = NULL;
	ValaMap* _tmp11_;
	ValaHashMap* _tmp12_ = NULL;
	ValaMap* _tmp13_;
	gboolean _tmp14_;
	const gchar* _tmp27_ = NULL;
	GList* _tmp28_ = NULL;
	GList* modules;
	ValaSourceReference* _tmp29_ = NULL;
	ValaSourceReference* _tmp30_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_file != NULL);
	_tmp0_ = vala_source_file_get_filename (source_file);
	_tmp1_ = vala_source_file_get_filename (source_file);
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = strlen (".gi");
	_tmp4_ = g_strndup (_tmp0_, (gsize) (_tmp2_ - _tmp3_));
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%s.metadata", _tmp5_);
	metadata_filename = (_tmp7_ = _tmp6_, _g_free0 (_tmp5_), _tmp7_);
	_tmp8_ = _vala_source_file_ref0 (source_file);
	_tmp9_ = _tmp8_;
	_vala_source_file_unref0 (self->priv->current_source_file);
	self->priv->current_source_file = _tmp9_;
	_tmp10_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal);
	_tmp11_ = (ValaMap*) _tmp10_;
	_vala_map_unref0 (self->priv->codenode_attributes_map);
	self->priv->codenode_attributes_map = _tmp11_;
	_tmp12_ = vala_hash_map_new (G_TYPE_POINTER, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_hash, (GEqualFunc) g_pattern_spec_equal, g_direct_equal);
	_tmp13_ = (ValaMap*) _tmp12_;
	_vala_map_unref0 (self->priv->codenode_attributes_patterns);
	self->priv->codenode_attributes_patterns = _tmp13_;
	_tmp14_ = g_file_test (metadata_filename, G_FILE_TEST_EXISTS);
	if (_tmp14_) {
		gchar* metadata;
		gchar* _tmp15_ = NULL;
		gchar** _tmp16_;
		gchar** _tmp17_ = NULL;
		metadata = NULL;
		g_file_get_contents (metadata_filename, &_tmp15_, NULL, &_inner_error_);
		_g_free0 (metadata);
		metadata = _tmp15_;
		if (_inner_error_ != NULL) {
			_g_free0 (metadata);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (metadata);
			_g_free0 (metadata_filename);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp17_ = _tmp16_ = g_strsplit (metadata, "\n", 0);
		{
			gchar** line_collection;
			int line_collection_length1;
			int line_it;
			line_collection = _tmp17_;
			line_collection_length1 = _vala_array_length (_tmp16_);
			for (line_it = 0; line_it < _vala_array_length (_tmp16_); line_it = line_it + 1) {
				gchar* _tmp18_;
				gchar* line;
				_tmp18_ = g_strdup (line_collection[line_it]);
				line = _tmp18_;
				{
					gboolean _tmp19_;
					gchar** _tmp20_;
					gchar** _tmp21_ = NULL;
					gint tokens_length1;
					gint _tokens_size_;
					gchar** _tmp22_;
					gchar** tokens;
					const gchar* _tmp23_ = NULL;
					_tmp19_ = g_str_has_prefix (line, "#");
					if (_tmp19_) {
						_g_free0 (line);
						continue;
					}
					_tmp21_ = _tmp20_ = g_strsplit (line, " ", 2);
					_tmp22_ = _tmp21_;
					tokens_length1 = _vala_array_length (_tmp20_);
					_tokens_size_ = tokens_length1;
					tokens = _tmp22_;
					if (NULL == tokens[0]) {
						tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (line);
						continue;
					}
					_tmp23_ = g_utf8_strchr (tokens[0], (gssize) (-1), (gunichar) '*');
					if (NULL != _tmp23_) {
						GPatternSpec* _tmp24_ = NULL;
						GPatternSpec* pattern;
						_tmp24_ = g_pattern_spec_new (tokens[0]);
						pattern = _tmp24_;
						vala_map_set (self->priv->codenode_attributes_patterns, pattern, tokens[0]);
					}
					vala_map_set (self->priv->codenode_attributes_map, tokens[0], tokens[1]);
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
				}
			}
			line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (metadata);
		goto __finally0;
		__catch0_g_file_error:
		{
			GError * e;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp25_ = g_strdup_printf ("Unable to read metadata file: %s", e->message);
			_tmp26_ = _tmp25_;
			vala_report_error (NULL, _tmp26_);
			_g_free0 (_tmp26_);
			_g_error_free0 (e);
		}
		__finally0:
		if (_inner_error_ != NULL) {
			_g_free0 (metadata_filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp27_ = vala_source_file_get_filename (source_file);
	_tmp28_ = g_idl_parse_file (_tmp27_, &_inner_error_);
	modules = _tmp28_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_MARKUP_ERROR) {
			goto __catch1_g_markup_error;
		}
		_g_free0 (metadata_filename);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp29_ = vala_source_reference_new (source_file, 0, 0, 0, 0);
	_tmp30_ = _tmp29_;
	_vala_source_reference_unref0 (self->priv->current_source_reference);
	self->priv->current_source_reference = _tmp30_;
	{
		GList* module_collection;
		GList* module_it;
		module_collection = modules;
		for (module_it = module_collection; module_it != NULL; module_it = module_it->next) {
			GIdlModule* module;
			module = (GIdlModule*) module_it->data;
			{
				ValaNamespace* _tmp31_ = NULL;
				ValaNamespace* ns;
				_tmp31_ = vala_gidl_parser_parse_module (self, module);
				ns = _tmp31_;
				if (ns != NULL) {
					ValaNamespace* _tmp32_ = NULL;
					_tmp32_ = vala_code_context_get_root (self->priv->context);
					vala_symbol_add_namespace ((ValaSymbol*) _tmp32_, ns);
				}
				_vala_code_node_unref0 (ns);
			}
		}
	}
	__g_list_free__g_idl_module_free0_0 (modules);
	goto __finally1;
	__catch1_g_markup_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stdout, "error parsing GIDL file: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (metadata_filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (metadata_filename);
}


static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}


static gchar* vala_gidl_parser_fix_type_name (ValaGIdlParser* self, const gchar* type_name, ValaSymbol* container) {
	gchar* result = NULL;
	gint _tmp0_;
	gchar** _tmp1_ = NULL;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp2_;
	gchar** attributes;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp9_;
	gchar* _tmp33_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	_tmp1_ = vala_gidl_parser_get_attributes (self, type_name, &_tmp0_);
	_tmp2_ = _tmp1_;
	attributes_length1 = _tmp0_;
	_attributes_size_ = attributes_length1;
	attributes = _tmp2_;
	if (attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp3_;
				gchar* attr;
				_tmp3_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp3_;
				{
					gchar** _tmp4_;
					gchar** _tmp5_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp6_;
					gchar** nv;
					_tmp5_ = _tmp4_ = g_strsplit (attr, "=", 2);
					_tmp6_ = _tmp5_;
					nv_length1 = _vala_array_length (_tmp4_);
					_nv_size_ = nv_length1;
					nv = _tmp6_;
					if (g_strcmp0 (nv[0], "name") == 0) {
						gchar* _tmp7_ = NULL;
						_tmp7_ = vala_gidl_parser_eval (self, nv[1]);
						result = _tmp7_;
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp8_ = vala_symbol_get_name (container);
	_tmp9_ = g_str_has_prefix (type_name, _tmp8_);
	if (_tmp9_) {
		const gchar* _tmp10_ = NULL;
		glong _tmp11_;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		_tmp10_ = vala_symbol_get_name (container);
		_tmp11_ = strlen (_tmp10_);
		_tmp12_ = string_offset (type_name, _tmp11_);
		_tmp13_ = g_strdup (_tmp12_);
		result = _tmp13_;
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_ = NULL;
		_tmp15_ = vala_symbol_get_name (container);
		if (g_strcmp0 (_tmp15_, "GLib") == 0) {
			gboolean _tmp16_;
			_tmp16_ = g_str_has_prefix (type_name, "G");
			_tmp14_ = _tmp16_;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			_tmp17_ = string_offset (type_name, (glong) 1);
			_tmp18_ = g_strdup (_tmp17_);
			result = _tmp18_;
			attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
			return result;
		} else {
			gchar* best_match;
			best_match = NULL;
			if (VALA_IS_NAMESPACE (container)) {
				{
					ValaList* _tmp19_ = NULL;
					ValaList* _cprefix_list;
					gint _tmp20_;
					gint _cprefix_size;
					gint _cprefix_index;
					_tmp19_ = vala_namespace_get_cprefixes (VALA_NAMESPACE (container));
					_cprefix_list = _tmp19_;
					_tmp20_ = vala_collection_get_size ((ValaCollection*) _cprefix_list);
					_cprefix_size = _tmp20_;
					_cprefix_index = -1;
					while (TRUE) {
						gpointer _tmp21_ = NULL;
						gchar* cprefix;
						gboolean _tmp22_;
						_cprefix_index = _cprefix_index + 1;
						if (!(_cprefix_index < _cprefix_size)) {
							break;
						}
						_tmp21_ = vala_list_get (_cprefix_list, _cprefix_index);
						cprefix = (gchar*) _tmp21_;
						_tmp22_ = g_str_has_prefix (type_name, cprefix);
						if (_tmp22_) {
							gboolean _tmp23_ = FALSE;
							if (best_match == NULL) {
								_tmp23_ = TRUE;
							} else {
								glong _tmp24_;
								glong _tmp25_;
								_tmp24_ = strlen (cprefix);
								_tmp25_ = strlen (best_match);
								_tmp23_ = _tmp24_ > _tmp25_;
							}
							if (_tmp23_) {
								gchar* _tmp26_;
								gchar* _tmp27_;
								_tmp26_ = g_strdup (cprefix);
								_tmp27_ = _tmp26_;
								_g_free0 (best_match);
								best_match = _tmp27_;
							}
						}
						_g_free0 (cprefix);
					}
					_vala_iterable_unref0 (_cprefix_list);
				}
			} else {
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_;
				_tmp28_ = vala_symbol_get_cprefix (container);
				_tmp29_ = _tmp28_;
				_g_free0 (best_match);
				best_match = _tmp29_;
			}
			if (best_match != NULL) {
				glong _tmp30_;
				const gchar* _tmp31_ = NULL;
				gchar* _tmp32_;
				_tmp30_ = strlen (best_match);
				_tmp31_ = string_offset (type_name, _tmp30_);
				_tmp32_ = g_strdup (_tmp31_);
				result = _tmp32_;
				_g_free0 (best_match);
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				return result;
			}
			_g_free0 (best_match);
		}
	}
	_tmp33_ = g_strdup (type_name);
	result = _tmp33_;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gchar* vala_gidl_parser_fix_const_name (ValaGIdlParser* self, const gchar* const_name, ValaSymbol* container) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* pref;
	gboolean _tmp4_;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (const_name != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	_tmp0_ = vala_symbol_get_lower_case_cprefix (container);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_strup (_tmp1_, (gssize) (-1));
	pref = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	_tmp4_ = g_str_has_prefix (const_name, pref);
	if (_tmp4_) {
		glong _tmp5_;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp5_ = strlen (pref);
		_tmp6_ = string_offset (const_name, _tmp5_);
		_tmp7_ = g_strdup (_tmp6_);
		result = _tmp7_;
		_g_free0 (pref);
		return result;
	}
	_tmp8_ = g_strdup (const_name);
	result = _tmp8_;
	_g_free0 (pref);
	return result;
}


static gchar** vala_gidl_parser_get_attributes_for_node (ValaGIdlParser* self, GIdlNode* node, int* result_length1) {
	gchar** result = NULL;
	gchar* name;
	gint _tmp16_;
	gchar** _tmp17_ = NULL;
	gchar** _tmp18_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	name = NULL;
	if (node->type == G_IDL_NODE_FUNCTION) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = g_strdup (((GIdlNodeFunction*) node)->symbol);
		_tmp1_ = _tmp0_;
		_g_free0 (name);
		name = _tmp1_;
	} else {
		if (node->type == G_IDL_NODE_SIGNAL) {
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			_tmp2_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
			_tmp3_ = _tmp2_;
			_tmp4_ = g_strdup_printf ("%s::%s", _tmp3_, node->name);
			_tmp5_ = _tmp4_;
			_g_free0 (name);
			name = _tmp5_;
			_g_free0 (_tmp3_);
		} else {
			if (node->type == G_IDL_NODE_PROPERTY) {
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				_tmp6_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strdup_printf ("%s:%s", _tmp7_, node->name);
				_tmp9_ = _tmp8_;
				_g_free0 (name);
				name = _tmp9_;
				_g_free0 (_tmp7_);
			} else {
				if (node->type == G_IDL_NODE_FIELD) {
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_;
					_tmp10_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
					_tmp11_ = _tmp10_;
					_tmp12_ = g_strdup_printf ("%s.%s", _tmp11_, node->name);
					_tmp13_ = _tmp12_;
					_g_free0 (name);
					name = _tmp13_;
					_g_free0 (_tmp11_);
				} else {
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp14_ = g_strdup (node->name);
					_tmp15_ = _tmp14_;
					_g_free0 (name);
					name = _tmp15_;
				}
			}
		}
	}
	_tmp17_ = vala_gidl_parser_get_attributes (self, name, &_tmp16_);
	_tmp18_ = _tmp17_;
	*result_length1 = _tmp16_;
	result = _tmp18_;
	_g_free0 (name);
	return result;
}


static void vala_gidl_parser_add_symbol_to_container (ValaGIdlParser* self, ValaSymbol* container, ValaSymbol* sym) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (sym != NULL);
	if (VALA_IS_CLASS (container)) {
		ValaClass* cl;
		cl = VALA_CLASS (container);
		if (VALA_IS_CLASS (sym)) {
			vala_symbol_add_class ((ValaSymbol*) cl, VALA_CLASS (sym));
		} else {
			if (VALA_IS_CONSTANT (sym)) {
				vala_symbol_add_constant ((ValaSymbol*) cl, VALA_CONSTANT (sym));
			} else {
				if (VALA_IS_ENUM (sym)) {
					vala_symbol_add_enum ((ValaSymbol*) cl, VALA_ENUM (sym));
				} else {
					if (VALA_IS_FIELD (sym)) {
						vala_symbol_add_field ((ValaSymbol*) cl, VALA_FIELD (sym));
					} else {
						if (VALA_IS_METHOD (sym)) {
							vala_symbol_add_method ((ValaSymbol*) cl, VALA_METHOD (sym));
						} else {
							if (VALA_IS_PROPERTY (sym)) {
								vala_symbol_add_property ((ValaSymbol*) cl, VALA_PROPERTY (sym));
							} else {
								if (VALA_IS_SIGNAL (sym)) {
									vala_symbol_add_signal ((ValaSymbol*) cl, VALA_SIGNAL (sym));
								} else {
									if (VALA_IS_STRUCT (sym)) {
										vala_symbol_add_struct ((ValaSymbol*) cl, VALA_STRUCT (sym));
									}
								}
							}
						}
					}
				}
			}
		}
	} else {
		if (VALA_IS_ENUM (container)) {
			ValaEnum* en;
			en = VALA_ENUM (container);
			if (VALA_IS_ENUM_VALUE (sym)) {
				vala_enum_add_value (en, VALA_ENUM_VALUE (sym));
			} else {
				if (VALA_IS_CONSTANT (sym)) {
					vala_symbol_add_constant ((ValaSymbol*) en, VALA_CONSTANT (sym));
				} else {
					if (VALA_IS_METHOD (sym)) {
						vala_symbol_add_method ((ValaSymbol*) en, VALA_METHOD (sym));
					}
				}
			}
		} else {
			if (VALA_IS_INTERFACE (container)) {
				ValaInterface* iface;
				iface = VALA_INTERFACE (container);
				if (VALA_IS_CLASS (sym)) {
					vala_symbol_add_class ((ValaSymbol*) iface, VALA_CLASS (sym));
				} else {
					if (VALA_IS_CONSTANT (sym)) {
						vala_symbol_add_constant ((ValaSymbol*) iface, VALA_CONSTANT (sym));
					} else {
						if (VALA_IS_ENUM (sym)) {
							vala_symbol_add_enum ((ValaSymbol*) iface, VALA_ENUM (sym));
						} else {
							if (VALA_IS_FIELD (sym)) {
								vala_symbol_add_field ((ValaSymbol*) iface, VALA_FIELD (sym));
							} else {
								if (VALA_IS_METHOD (sym)) {
									vala_symbol_add_method ((ValaSymbol*) iface, VALA_METHOD (sym));
								} else {
									if (VALA_IS_PROPERTY (sym)) {
										vala_symbol_add_property ((ValaSymbol*) iface, VALA_PROPERTY (sym));
									} else {
										if (VALA_IS_SIGNAL (sym)) {
											vala_symbol_add_signal ((ValaSymbol*) iface, VALA_SIGNAL (sym));
										} else {
											if (VALA_IS_STRUCT (sym)) {
												vala_symbol_add_struct ((ValaSymbol*) iface, VALA_STRUCT (sym));
											}
										}
									}
								}
							}
						}
					}
				}
			} else {
				if (VALA_IS_NAMESPACE (container)) {
					ValaNamespace* ns;
					ns = VALA_NAMESPACE (container);
					if (VALA_IS_NAMESPACE (sym)) {
						vala_symbol_add_namespace ((ValaSymbol*) ns, VALA_NAMESPACE (sym));
					} else {
						if (VALA_IS_CLASS (sym)) {
							vala_symbol_add_class ((ValaSymbol*) ns, VALA_CLASS (sym));
						} else {
							if (VALA_IS_CONSTANT (sym)) {
								vala_symbol_add_constant ((ValaSymbol*) ns, VALA_CONSTANT (sym));
							} else {
								if (VALA_IS_DELEGATE (sym)) {
									vala_symbol_add_delegate ((ValaSymbol*) ns, VALA_DELEGATE (sym));
								} else {
									if (VALA_IS_ENUM (sym)) {
										vala_symbol_add_enum ((ValaSymbol*) ns, VALA_ENUM (sym));
									} else {
										if (VALA_IS_ERROR_DOMAIN (sym)) {
											vala_symbol_add_error_domain ((ValaSymbol*) ns, VALA_ERROR_DOMAIN (sym));
										} else {
											if (VALA_IS_FIELD (sym)) {
												vala_symbol_add_field ((ValaSymbol*) ns, VALA_FIELD (sym));
											} else {
												if (VALA_IS_INTERFACE (sym)) {
													vala_symbol_add_interface ((ValaSymbol*) ns, VALA_INTERFACE (sym));
												} else {
													if (VALA_IS_METHOD (sym)) {
														vala_symbol_add_method ((ValaSymbol*) ns, VALA_METHOD (sym));
													} else {
														if (VALA_IS_NAMESPACE (sym)) {
															vala_symbol_add_namespace ((ValaSymbol*) ns, VALA_NAMESPACE (sym));
														} else {
															if (VALA_IS_STRUCT (sym)) {
																vala_symbol_add_struct ((ValaSymbol*) ns, VALA_STRUCT (sym));
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				} else {
					if (VALA_IS_STRUCT (container)) {
						ValaStruct* st;
						st = VALA_STRUCT (container);
						if (VALA_IS_CONSTANT (sym)) {
							vala_symbol_add_constant ((ValaSymbol*) st, VALA_CONSTANT (sym));
						} else {
							if (VALA_IS_FIELD (sym)) {
								vala_symbol_add_field ((ValaSymbol*) st, VALA_FIELD (sym));
							} else {
								if (VALA_IS_METHOD (sym)) {
									vala_symbol_add_method ((ValaSymbol*) st, VALA_METHOD (sym));
								} else {
									if (VALA_IS_PROPERTY (sym)) {
										vala_symbol_add_property ((ValaSymbol*) st, VALA_PROPERTY (sym));
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static void vala_gidl_parser_parse_node (ValaGIdlParser* self, GIdlNode* node, GIdlModule* module, ValaSymbol* container) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (module != NULL);
	g_return_if_fail (container != NULL);
	if (node->type == G_IDL_NODE_CALLBACK) {
		ValaDelegate* _tmp0_ = NULL;
		ValaDelegate* cb;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp0_ = vala_gidl_parser_parse_delegate (self, (GIdlNodeFunction*) node);
		cb = _tmp0_;
		if (cb == NULL) {
			_vala_code_node_unref0 (cb);
			return;
		}
		_tmp1_ = vala_symbol_get_name ((ValaSymbol*) cb);
		_tmp2_ = vala_gidl_parser_fix_type_name (self, _tmp1_, container);
		_tmp3_ = _tmp2_;
		vala_symbol_set_name ((ValaSymbol*) cb, _tmp3_);
		_g_free0 (_tmp3_);
		vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) cb);
		vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cb);
		_vala_code_node_unref0 (cb);
	} else {
		if (node->type == G_IDL_NODE_STRUCT) {
			vala_gidl_parser_parse_struct (self, (GIdlNodeStruct*) node, container, module);
		} else {
			if (node->type == G_IDL_NODE_UNION) {
				vala_gidl_parser_parse_union (self, (GIdlNodeUnion*) node, container, module);
			} else {
				if (node->type == G_IDL_NODE_BOXED) {
					vala_gidl_parser_parse_boxed (self, (GIdlNodeBoxed*) node, container, module);
				} else {
					if (node->type == G_IDL_NODE_ENUM) {
						vala_gidl_parser_parse_enum (self, (GIdlNodeEnum*) node, container, module, FALSE);
					} else {
						if (node->type == G_IDL_NODE_FLAGS) {
							vala_gidl_parser_parse_enum (self, (GIdlNodeEnum*) node, container, module, TRUE);
						} else {
							if (node->type == G_IDL_NODE_OBJECT) {
								vala_gidl_parser_parse_object (self, (GIdlNodeInterface*) node, container, module);
							} else {
								if (node->type == G_IDL_NODE_INTERFACE) {
									vala_gidl_parser_parse_interface (self, (GIdlNodeInterface*) node, container, module);
								} else {
									if (node->type == G_IDL_NODE_CONSTANT) {
										ValaConstant* _tmp4_ = NULL;
										ValaConstant* c;
										_tmp4_ = vala_gidl_parser_parse_constant (self, (GIdlNodeConstant*) node);
										c = _tmp4_;
										if (c != NULL) {
											const gchar* _tmp5_ = NULL;
											gchar* _tmp6_ = NULL;
											gchar* _tmp7_;
											_tmp5_ = vala_symbol_get_name ((ValaSymbol*) c);
											_tmp6_ = vala_gidl_parser_fix_const_name (self, _tmp5_, container);
											_tmp7_ = _tmp6_;
											vala_symbol_set_name ((ValaSymbol*) c, _tmp7_);
											_g_free0 (_tmp7_);
											vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) c);
											vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) c);
										}
										_vala_code_node_unref0 (c);
									} else {
										if (node->type == G_IDL_NODE_FUNCTION) {
											ValaMethod* _tmp8_ = NULL;
											ValaMethod* m;
											_tmp8_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) node, FALSE);
											m = _tmp8_;
											if (m != NULL) {
												vala_method_set_binding (m, VALA_MEMBER_BINDING_STATIC);
												vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) m);
												vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) m);
											}
											_vala_code_node_unref0 (m);
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static ValaSymbol* vala_gidl_parser_get_container_from_name (ValaGIdlParser* self, const gchar* name) {
	ValaSymbol* result = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gint path_length1;
	gint _path_size_;
	gchar** _tmp2_;
	gchar** path;
	ValaSymbol* _tmp3_;
	ValaSymbol* cp;
	ValaSymbol* cc;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (name, ".", 0);
	_tmp2_ = _tmp1_;
	path_length1 = _vala_array_length (_tmp0_);
	_path_size_ = path_length1;
	path = _tmp2_;
	_tmp3_ = _vala_code_node_ref0 ((ValaSymbol*) self->priv->current_namespace);
	cp = _tmp3_;
	cc = NULL;
	{
		gchar** tok_collection;
		int tok_collection_length1;
		int tok_it;
		tok_collection = path;
		tok_collection_length1 = path_length1;
		for (tok_it = 0; tok_it < path_length1; tok_it = tok_it + 1) {
			const gchar* tok;
			tok = tok_collection[tok_it];
			{
				ValaScope* _tmp4_ = NULL;
				ValaSymbol* _tmp5_ = NULL;
				ValaSymbol* _tmp6_;
				ValaSymbol* _tmp7_;
				ValaSymbol* _tmp13_;
				ValaSymbol* _tmp14_;
				_tmp4_ = vala_symbol_get_scope (cp);
				_tmp5_ = vala_scope_lookup (_tmp4_, tok);
				_tmp7_ = (_tmp6_ = _tmp5_, VALA_IS_SYMBOL (_tmp6_) ? ((ValaSymbol*) _tmp6_) : NULL);
				_vala_code_node_unref0 (cc);
				cc = _tmp7_;
				if (cc == NULL) {
					ValaNamespace* _tmp8_ = NULL;
					ValaSymbol* _tmp9_;
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_;
					gchar* _tmp12_;
					_tmp8_ = vala_namespace_new (tok, self->priv->current_source_reference);
					_tmp9_ = (ValaSymbol*) _tmp8_;
					_vala_code_node_unref0 (cc);
					cc = _tmp9_;
					_tmp10_ = vala_symbol_get_cprefix (cp);
					_tmp11_ = _tmp10_;
					_tmp12_ = g_strconcat (_tmp11_, tok, NULL);
					vala_namespace_add_cprefix (VALA_NAMESPACE (cc), _tmp12_);
					_g_free0 (_tmp12_);
					_g_free0 (_tmp11_);
					vala_gidl_parser_add_symbol_to_container (self, cp, cc);
				}
				_tmp13_ = _vala_code_node_ref0 (cc);
				_tmp14_ = _tmp13_;
				_vala_code_node_unref0 (cp);
				cp = _tmp14_;
			}
		}
	}
	result = cc;
	_vala_code_node_unref0 (cp);
	path = (_vala_array_free (path, path_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void _vala_code_node_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}


static void _g_list_free__vala_code_node_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _vala_code_node_unref0_, NULL);
	g_list_free (self);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static ValaNamespace* vala_gidl_parser_parse_module (ValaGIdlParser* self, GIdlModule* module) {
	ValaNamespace* result = NULL;
	ValaNamespace* _tmp0_ = NULL;
	ValaScope* _tmp1_ = NULL;
	ValaSymbol* _tmp2_ = NULL;
	ValaSymbol* sym;
	ValaNamespace* ns;
	ValaNamespace* _tmp9_;
	ValaNamespace* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gint _tmp12_;
	gchar** _tmp13_ = NULL;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp14_;
	gchar** attributes;
	ValaArrayList* _tmp38_ = NULL;
	ValaArrayList* deferred;
	ValaNamespace* _tmp59_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (module != NULL, NULL);
	_tmp0_ = vala_code_context_get_root (self->priv->context);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) _tmp0_);
	_tmp2_ = vala_scope_lookup (_tmp1_, module->name);
	sym = _tmp2_;
	ns = NULL;
	if (VALA_IS_NAMESPACE (sym)) {
		ValaNamespace* _tmp3_;
		ValaNamespace* _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = _vala_code_node_ref0 (VALA_NAMESPACE (sym));
		_tmp4_ = _tmp3_;
		_vala_code_node_unref0 (ns);
		ns = _tmp4_;
		_tmp5_ = vala_symbol_get_external_package ((ValaSymbol*) ns);
		if (_tmp5_) {
			GList* _tmp6_;
			_tmp6_ = NULL;
			__g_list_free__vala_code_node_unref0_0 (((ValaCodeNode*) ns)->attributes);
			((ValaCodeNode*) ns)->attributes = _tmp6_;
			vala_code_node_set_source_reference ((ValaCodeNode*) ns, self->priv->current_source_reference);
		}
	} else {
		ValaNamespace* _tmp7_ = NULL;
		ValaNamespace* _tmp8_;
		_tmp7_ = vala_namespace_new (module->name, self->priv->current_source_reference);
		_tmp8_ = _tmp7_;
		_vala_code_node_unref0 (ns);
		ns = _tmp8_;
	}
	_tmp9_ = _vala_code_node_ref0 (ns);
	_tmp10_ = _tmp9_;
	_vala_code_node_unref0 (self->priv->current_namespace);
	self->priv->current_namespace = _tmp10_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) ns);
	_tmp13_ = vala_gidl_parser_get_attributes (self, _tmp11_, &_tmp12_);
	_tmp14_ = _tmp13_;
	attributes_length1 = _tmp12_;
	_attributes_size_ = attributes_length1;
	attributes = _tmp14_;
	if (attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp15_;
				gchar* attr;
				_tmp15_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp15_;
				{
					gchar** _tmp16_;
					gchar** _tmp17_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp18_;
					gchar** nv;
					_tmp17_ = _tmp16_ = g_strsplit (attr, "=", 2);
					_tmp18_ = _tmp17_;
					nv_length1 = _vala_array_length (_tmp16_);
					_nv_size_ = nv_length1;
					nv = _tmp18_;
					if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
						gchar* _tmp19_ = NULL;
						gchar* _tmp20_;
						_tmp19_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp20_ = _tmp19_;
						vala_symbol_set_cheader_filename ((ValaSymbol*) ns, _tmp20_);
						_g_free0 (_tmp20_);
					} else {
						if (g_strcmp0 (nv[0], "cprefix") == 0) {
							gchar* _tmp21_ = NULL;
							gchar* _tmp22_;
							gchar** _tmp23_;
							gchar** _tmp24_ = NULL;
							gchar** _tmp25_;
							gint cprefixes_length1;
							gint _cprefixes_size_;
							gchar** _tmp26_;
							gchar** cprefixes;
							_tmp21_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp22_ = _tmp21_;
							_tmp24_ = _tmp23_ = g_strsplit (_tmp22_, ",", 0);
							_tmp26_ = (_tmp25_ = _tmp24_, _g_free0 (_tmp22_), _tmp25_);
							cprefixes_length1 = _vala_array_length (_tmp23_);
							_cprefixes_size_ = cprefixes_length1;
							cprefixes = _tmp26_;
							{
								gchar** name_collection;
								int name_collection_length1;
								int name_it;
								name_collection = cprefixes;
								name_collection_length1 = cprefixes_length1;
								for (name_it = 0; name_it < cprefixes_length1; name_it = name_it + 1) {
									gchar* _tmp27_;
									gchar* name;
									_tmp27_ = g_strdup (name_collection[name_it]);
									name = _tmp27_;
									{
										vala_namespace_add_cprefix (ns, name);
										_g_free0 (name);
									}
								}
							}
							cprefixes = (_vala_array_free (cprefixes, cprefixes_length1, (GDestroyNotify) g_free), NULL);
						} else {
							if (g_strcmp0 (nv[0], "lower_case_cprefix") == 0) {
								gchar* _tmp28_ = NULL;
								gchar* _tmp29_;
								_tmp28_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp29_ = _tmp28_;
								vala_namespace_set_lower_case_cprefix (ns, _tmp29_);
								_g_free0 (_tmp29_);
							} else {
								if (g_strcmp0 (nv[0], "gir_namespace") == 0) {
									ValaSourceReference* _tmp30_ = NULL;
									ValaSourceFile* _tmp31_ = NULL;
									gchar* _tmp32_ = NULL;
									gchar* _tmp33_;
									_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
									_tmp31_ = vala_source_reference_get_file (_tmp30_);
									_tmp32_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp33_ = _tmp32_;
									vala_source_file_set_gir_namespace (_tmp31_, _tmp33_);
									_g_free0 (_tmp33_);
								} else {
									if (g_strcmp0 (nv[0], "gir_version") == 0) {
										ValaSourceReference* _tmp34_ = NULL;
										ValaSourceFile* _tmp35_ = NULL;
										gchar* _tmp36_ = NULL;
										gchar* _tmp37_;
										_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
										_tmp35_ = vala_source_reference_get_file (_tmp34_);
										_tmp36_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp37_ = _tmp36_;
										vala_source_file_set_gir_version (_tmp35_, _tmp37_);
										_g_free0 (_tmp37_);
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp38_ = vala_array_list_new (G_TYPE_POINTER, NULL, NULL, g_direct_equal);
	deferred = _tmp38_;
	{
		GList* node_collection;
		GList* node_it;
		node_collection = module->entries;
		for (node_it = node_collection; node_it != NULL; node_it = node_it->next) {
			GIdlNode* node;
			node = (GIdlNode*) node_it->data;
			{
				gboolean is_deferred;
				gint _tmp39_;
				gchar** _tmp40_ = NULL;
				gint child_attributes_length1;
				gint _child_attributes_size_;
				gchar** _tmp41_;
				gchar** child_attributes;
				is_deferred = FALSE;
				_tmp40_ = vala_gidl_parser_get_attributes_for_node (self, node, &_tmp39_);
				_tmp41_ = _tmp40_;
				child_attributes_length1 = _tmp39_;
				_child_attributes_size_ = child_attributes_length1;
				child_attributes = _tmp41_;
				if (child_attributes != NULL) {
					{
						gchar** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = child_attributes;
						attr_collection_length1 = child_attributes_length1;
						for (attr_it = 0; attr_it < child_attributes_length1; attr_it = attr_it + 1) {
							const gchar* attr;
							attr = attr_collection[attr_it];
							{
								gchar** _tmp42_;
								gchar** _tmp43_ = NULL;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp44_;
								gchar** nv;
								_tmp43_ = _tmp42_ = g_strsplit (attr, "=", 2);
								_tmp44_ = _tmp43_;
								nv_length1 = _vala_array_length (_tmp42_);
								_nv_size_ = nv_length1;
								nv = _tmp44_;
								if (g_strcmp0 (nv[0], "parent") == 0) {
									vala_collection_add ((ValaCollection*) deferred, node);
									is_deferred = TRUE;
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							}
						}
					}
				}
				if (!is_deferred) {
					vala_gidl_parser_parse_node (self, node, module, (ValaSymbol*) ns);
				}
				child_attributes = (_vala_array_free (child_attributes, child_attributes_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	{
		ValaArrayList* _tmp45_;
		ValaArrayList* _node_list;
		gint _tmp46_;
		gint _node_size;
		gint _node_index;
		_tmp45_ = _vala_iterable_ref0 (deferred);
		_node_list = _tmp45_;
		_tmp46_ = vala_collection_get_size ((ValaCollection*) _node_list);
		_node_size = _tmp46_;
		_node_index = -1;
		while (TRUE) {
			gpointer _tmp47_ = NULL;
			GIdlNode* node;
			ValaSymbol* _tmp48_;
			ValaSymbol* container;
			gint _tmp49_;
			gchar** _tmp50_ = NULL;
			gint child_attributes_length1;
			gint _child_attributes_size_;
			gchar** _tmp51_;
			gchar** child_attributes;
			_node_index = _node_index + 1;
			if (!(_node_index < _node_size)) {
				break;
			}
			_tmp47_ = vala_list_get ((ValaList*) _node_list, _node_index);
			node = (GIdlNode*) _tmp47_;
			_tmp48_ = _vala_code_node_ref0 ((ValaSymbol*) ns);
			container = _tmp48_;
			_tmp50_ = vala_gidl_parser_get_attributes_for_node (self, node, &_tmp49_);
			_tmp51_ = _tmp50_;
			child_attributes_length1 = _tmp49_;
			_child_attributes_size_ = child_attributes_length1;
			child_attributes = _tmp51_;
			if (child_attributes != NULL) {
				{
					gchar** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = child_attributes;
					attr_collection_length1 = child_attributes_length1;
					for (attr_it = 0; attr_it < child_attributes_length1; attr_it = attr_it + 1) {
						const gchar* attr;
						attr = attr_collection[attr_it];
						{
							gchar** _tmp52_;
							gchar** _tmp53_ = NULL;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp54_;
							gchar** nv;
							_tmp53_ = _tmp52_ = g_strsplit (attr, "=", 2);
							_tmp54_ = _tmp53_;
							nv_length1 = _vala_array_length (_tmp52_);
							_nv_size_ = nv_length1;
							nv = _tmp54_;
							if (g_strcmp0 (nv[0], "parent") == 0) {
								gchar* _tmp55_ = NULL;
								gchar* _tmp56_;
								ValaSymbol* _tmp57_ = NULL;
								ValaSymbol* _tmp58_;
								_tmp55_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp56_ = _tmp55_;
								_tmp57_ = vala_gidl_parser_get_container_from_name (self, _tmp56_);
								_tmp58_ = _tmp57_;
								_vala_code_node_unref0 (container);
								container = _tmp58_;
								_g_free0 (_tmp56_);
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						}
					}
				}
			}
			vala_gidl_parser_parse_node (self, node, module, container);
			child_attributes = (_vala_array_free (child_attributes, child_attributes_length1, (GDestroyNotify) g_free), NULL);
			_vala_code_node_unref0 (container);
		}
		_vala_iterable_unref0 (_node_list);
	}
	_tmp59_ = NULL;
	_vala_code_node_unref0 (self->priv->current_namespace);
	self->priv->current_namespace = _tmp59_;
	if (VALA_IS_NAMESPACE (sym)) {
		result = NULL;
		_vala_iterable_unref0 (deferred);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		_vala_code_node_unref0 (ns);
		_vala_code_node_unref0 (sym);
		return result;
	}
	result = ns;
	_vala_iterable_unref0 (deferred);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (sym);
	return result;
}


static ValaDelegate* vala_gidl_parser_parse_delegate (ValaGIdlParser* self, GIdlNodeFunction* f_node) {
	ValaDelegate* result = NULL;
	GIdlNode* node;
	ValaDataType* _tmp0_ = NULL;
	ValaDataType* return_type;
	ValaDelegate* _tmp1_ = NULL;
	ValaDelegate* cb;
	gboolean check_has_target;
	gint _tmp2_;
	gchar** _tmp3_ = NULL;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp4_;
	gchar** attributes;
	guint _tmp50_;
	guint remaining_params;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (f_node != NULL, NULL);
	node = (GIdlNode*) f_node;
	_tmp0_ = vala_gidl_parser_parse_param (self, f_node->result, NULL);
	return_type = _tmp0_;
	_tmp1_ = vala_delegate_new (node->name, return_type, self->priv->current_source_reference, NULL);
	cb = _tmp1_;
	vala_symbol_set_access ((ValaSymbol*) cb, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	check_has_target = TRUE;
	_tmp3_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp2_);
	_tmp4_ = _tmp3_;
	attributes_length1 = _tmp2_;
	_attributes_size_ = attributes_length1;
	attributes = _tmp4_;
	if (attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp5_;
				gchar* attr;
				_tmp5_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp5_;
				{
					gchar** _tmp6_;
					gchar** _tmp7_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp8_;
					gchar** nv;
					_tmp7_ = _tmp6_ = g_strsplit (attr, "=", 2);
					_tmp8_ = _tmp7_;
					nv_length1 = _vala_array_length (_tmp6_);
					_nv_size_ = nv_length1;
					nv = _tmp8_;
					if (g_strcmp0 (nv[0], "hidden") == 0) {
						gchar* _tmp9_ = NULL;
						gchar* _tmp10_;
						gboolean _tmp11_;
						_tmp9_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp10_ = _tmp9_;
						if ((_tmp11_ = g_strcmp0 (_tmp10_, "1") == 0, _g_free0 (_tmp10_), _tmp11_)) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (cb);
							_vala_code_node_unref0 (return_type);
							return result;
						}
					} else {
						if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
							gchar* _tmp12_ = NULL;
							gchar* _tmp13_;
							_tmp12_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp13_ = _tmp12_;
							vala_symbol_add_cheader_filename ((ValaSymbol*) cb, _tmp13_);
							_g_free0 (_tmp13_);
						} else {
							if (g_strcmp0 (nv[0], "has_target") == 0) {
								gchar* _tmp14_ = NULL;
								gchar* _tmp15_;
								gboolean _tmp16_;
								_tmp14_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp15_ = _tmp14_;
								if ((_tmp16_ = g_strcmp0 (_tmp15_, "0") == 0, _g_free0 (_tmp15_), _tmp16_)) {
									check_has_target = FALSE;
								} else {
									gchar* _tmp17_ = NULL;
									gchar* _tmp18_;
									gboolean _tmp19_;
									_tmp17_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp18_ = _tmp17_;
									if ((_tmp19_ = g_strcmp0 (_tmp18_, "1") == 0, _g_free0 (_tmp18_), _tmp19_)) {
										vala_delegate_set_has_target (cb, TRUE);
									}
								}
							} else {
								if (g_strcmp0 (nv[0], "transfer_ownership") == 0) {
									gchar* _tmp20_ = NULL;
									gchar* _tmp21_;
									gboolean _tmp22_;
									_tmp20_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp21_ = _tmp20_;
									if ((_tmp22_ = g_strcmp0 (_tmp21_, "1") == 0, _g_free0 (_tmp21_), _tmp22_)) {
										vala_data_type_set_value_owned (return_type, TRUE);
									}
								} else {
									if (g_strcmp0 (nv[0], "deprecated") == 0) {
										gchar* _tmp23_ = NULL;
										gchar* _tmp24_;
										gboolean _tmp25_;
										_tmp23_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp24_ = _tmp23_;
										if ((_tmp25_ = g_strcmp0 (_tmp24_, "1") == 0, _g_free0 (_tmp24_), _tmp25_)) {
											vala_symbol_set_deprecated ((ValaSymbol*) cb, TRUE);
										}
									} else {
										if (g_strcmp0 (nv[0], "replacement") == 0) {
											gchar* _tmp26_ = NULL;
											gchar* _tmp27_;
											_tmp26_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp27_ = _tmp26_;
											vala_symbol_set_replacement ((ValaSymbol*) cb, _tmp27_);
											_g_free0 (_tmp27_);
										} else {
											if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
												gchar* _tmp28_ = NULL;
												gchar* _tmp29_;
												_tmp28_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp29_ = _tmp28_;
												vala_symbol_set_deprecated_since ((ValaSymbol*) cb, _tmp29_);
												_g_free0 (_tmp29_);
											} else {
												if (g_strcmp0 (nv[0], "type_arguments") == 0) {
													gchar* _tmp30_ = NULL;
													gchar* _tmp31_;
													gchar** _tmp32_;
													gchar** _tmp33_ = NULL;
													gchar** _tmp34_;
													gint type_args_length1;
													gint _type_args_size_;
													gchar** _tmp35_;
													gchar** type_args;
													_tmp30_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp31_ = _tmp30_;
													_tmp33_ = _tmp32_ = g_strsplit (_tmp31_, ",", 0);
													_tmp35_ = (_tmp34_ = _tmp33_, _g_free0 (_tmp31_), _tmp34_);
													type_args_length1 = _vala_array_length (_tmp32_);
													_type_args_size_ = type_args_length1;
													type_args = _tmp35_;
													{
														gchar** type_arg_collection;
														int type_arg_collection_length1;
														int type_arg_it;
														type_arg_collection = type_args;
														type_arg_collection_length1 = type_args_length1;
														for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
															gchar* _tmp36_;
															gchar* type_arg;
															_tmp36_ = g_strdup (type_arg_collection[type_arg_it]);
															type_arg = _tmp36_;
															{
																ValaDataType* _tmp37_ = NULL;
																ValaDataType* _tmp38_;
																_tmp37_ = vala_gidl_parser_get_type_from_string (self, type_arg);
																_tmp38_ = _tmp37_;
																vala_data_type_add_type_argument (return_type, _tmp38_);
																_vala_code_node_unref0 (_tmp38_);
																_g_free0 (type_arg);
															}
														}
													}
													type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
												} else {
													if (g_strcmp0 (nv[0], "instance_pos") == 0) {
														gchar* _tmp39_ = NULL;
														gchar* _tmp40_;
														gdouble _tmp41_;
														_tmp39_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp40_ = _tmp39_;
														_tmp41_ = g_ascii_strtod (_tmp40_, NULL);
														vala_delegate_set_cinstance_parameter_position (cb, _tmp41_);
														_g_free0 (_tmp40_);
													} else {
														if (g_strcmp0 (nv[0], "type_parameters") == 0) {
															gchar* _tmp42_ = NULL;
															gchar* _tmp43_;
															gchar** _tmp44_;
															gchar** _tmp45_ = NULL;
															gchar** _tmp46_;
															_tmp42_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp43_ = _tmp42_;
															_tmp45_ = _tmp44_ = g_strsplit (_tmp43_, ",", 0);
															{
																gchar** type_param_name_collection;
																int type_param_name_collection_length1;
																int type_param_name_it;
																type_param_name_collection = (_tmp46_ = _tmp45_, _g_free0 (_tmp43_), _tmp46_);
																type_param_name_collection_length1 = _vala_array_length (_tmp44_);
																for (type_param_name_it = 0; type_param_name_it < _vala_array_length (_tmp44_); type_param_name_it = type_param_name_it + 1) {
																	gchar* _tmp47_;
																	gchar* type_param_name;
																	_tmp47_ = g_strdup (type_param_name_collection[type_param_name_it]);
																	type_param_name = _tmp47_;
																	{
																		ValaTypeParameter* _tmp48_ = NULL;
																		ValaTypeParameter* _tmp49_;
																		_tmp48_ = vala_typeparameter_new (type_param_name, self->priv->current_source_reference);
																		_tmp49_ = _tmp48_;
																		vala_delegate_add_type_parameter (cb, _tmp49_);
																		_vala_code_node_unref0 (_tmp49_);
																		_g_free0 (type_param_name);
																	}
																}
																type_param_name_collection = (_vala_array_free (type_param_name_collection, type_param_name_collection_length1, (GDestroyNotify) g_free), NULL);
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp50_ = g_list_length (f_node->parameters);
	remaining_params = _tmp50_;
	{
		GList* param_collection;
		GList* param_it;
		param_collection = f_node->parameters;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNode* param_node;
				gboolean _tmp51_ = FALSE;
				gboolean _tmp52_ = FALSE;
				param_node = (GIdlNode*) param;
				if (check_has_target) {
					_tmp52_ = remaining_params == 1;
				} else {
					_tmp52_ = FALSE;
				}
				if (_tmp52_) {
					gboolean _tmp53_ = FALSE;
					if (g_strcmp0 (param_node->name, "user_data") == 0) {
						_tmp53_ = TRUE;
					} else {
						_tmp53_ = g_strcmp0 (param_node->name, "data") == 0;
					}
					_tmp51_ = _tmp53_;
				} else {
					_tmp51_ = FALSE;
				}
				if (_tmp51_) {
					vala_delegate_set_has_target (cb, TRUE);
				} else {
					gchar* _tmp54_;
					gchar* param_name;
					ValaParameterDirection direction = 0;
					ValaParameterDirection _tmp59_;
					ValaDataType* _tmp60_ = NULL;
					ValaDataType* param_type;
					ValaParameter* _tmp61_ = NULL;
					ValaParameter* p;
					gboolean hide_param;
					gboolean show_param;
					gboolean array_requested;
					gboolean out_requested;
					gchar* _tmp62_ = NULL;
					gchar* _tmp63_;
					gint _tmp64_;
					gchar** _tmp65_ = NULL;
					gchar** _tmp66_;
					gboolean _tmp124_ = FALSE;
					_tmp54_ = g_strdup (param_node->name);
					param_name = _tmp54_;
					if (g_strcmp0 (param_name, "string") == 0) {
						gchar* _tmp55_;
						gchar* _tmp56_;
						_tmp55_ = g_strdup ("str");
						_tmp56_ = _tmp55_;
						_g_free0 (param_name);
						param_name = _tmp56_;
					} else {
						if (g_strcmp0 (param_name, "self") == 0) {
							gchar* _tmp57_;
							gchar* _tmp58_;
							_tmp57_ = g_strdup ("_self");
							_tmp58_ = _tmp57_;
							_g_free0 (param_name);
							param_name = _tmp58_;
						}
					}
					_tmp60_ = vala_gidl_parser_parse_param (self, param, &_tmp59_);
					direction = _tmp59_;
					param_type = _tmp60_;
					_tmp61_ = vala_parameter_new (param_name, param_type, NULL);
					p = _tmp61_;
					vala_parameter_set_direction (p, direction);
					hide_param = FALSE;
					show_param = FALSE;
					array_requested = FALSE;
					out_requested = FALSE;
					_tmp62_ = g_strdup_printf ("%s.%s", node->name, param_node->name);
					_tmp63_ = _tmp62_;
					_tmp65_ = vala_gidl_parser_get_attributes (self, _tmp63_, &_tmp64_);
					_tmp66_ = _tmp65_;
					attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
					attributes_length1 = _tmp64_;
					_attributes_size_ = attributes_length1;
					attributes = _tmp66_;
					_g_free0 (_tmp63_);
					if (attributes != NULL) {
						{
							gchar** attr_collection;
							int attr_collection_length1;
							int attr_it;
							attr_collection = attributes;
							attr_collection_length1 = attributes_length1;
							for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
								gchar* _tmp67_;
								gchar* attr;
								_tmp67_ = g_strdup (attr_collection[attr_it]);
								attr = _tmp67_;
								{
									gchar** _tmp68_;
									gchar** _tmp69_ = NULL;
									gint nv_length1;
									gint _nv_size_;
									gchar** _tmp70_;
									gchar** nv;
									_tmp69_ = _tmp68_ = g_strsplit (attr, "=", 2);
									_tmp70_ = _tmp69_;
									nv_length1 = _vala_array_length (_tmp68_);
									_nv_size_ = nv_length1;
									nv = _tmp70_;
									if (g_strcmp0 (nv[0], "hidden") == 0) {
										gchar* _tmp71_ = NULL;
										gchar* _tmp72_;
										gboolean _tmp73_;
										_tmp71_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp72_ = _tmp71_;
										if ((_tmp73_ = g_strcmp0 (_tmp72_, "1") == 0, _g_free0 (_tmp72_), _tmp73_)) {
											hide_param = TRUE;
										} else {
											gchar* _tmp74_ = NULL;
											gchar* _tmp75_;
											gboolean _tmp76_;
											_tmp74_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp75_ = _tmp74_;
											if ((_tmp76_ = g_strcmp0 (_tmp75_, "0") == 0, _g_free0 (_tmp75_), _tmp76_)) {
												show_param = TRUE;
											}
										}
									} else {
										if (g_strcmp0 (nv[0], "is_array") == 0) {
											gchar* _tmp77_ = NULL;
											gchar* _tmp78_;
											gboolean _tmp79_;
											_tmp77_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp78_ = _tmp77_;
											if ((_tmp79_ = g_strcmp0 (_tmp78_, "1") == 0, _g_free0 (_tmp78_), _tmp79_)) {
												ValaSourceReference* _tmp80_ = NULL;
												ValaArrayType* _tmp81_ = NULL;
												ValaDataType* _tmp82_;
												_tmp80_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
												_tmp81_ = vala_array_type_new (param_type, 1, _tmp80_);
												_tmp82_ = (ValaDataType*) _tmp81_;
												_vala_code_node_unref0 (param_type);
												param_type = _tmp82_;
												vala_variable_set_variable_type ((ValaVariable*) p, param_type);
												if (!out_requested) {
													vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_IN);
												}
												array_requested = TRUE;
											}
										} else {
											if (g_strcmp0 (nv[0], "is_out") == 0) {
												gchar* _tmp83_ = NULL;
												gchar* _tmp84_;
												gboolean _tmp85_;
												_tmp83_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp84_ = _tmp83_;
												if ((_tmp85_ = g_strcmp0 (_tmp84_, "1") == 0, _g_free0 (_tmp84_), _tmp85_)) {
													gboolean _tmp86_ = FALSE;
													vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_OUT);
													out_requested = TRUE;
													if (!array_requested) {
														_tmp86_ = VALA_IS_ARRAY_TYPE (param_type);
													} else {
														_tmp86_ = FALSE;
													}
													if (_tmp86_) {
														ValaArrayType* _tmp87_;
														ValaArrayType* array_type;
														ValaDataType* _tmp88_ = NULL;
														ValaDataType* _tmp89_;
														ValaDataType* _tmp90_;
														_tmp87_ = _vala_code_node_ref0 (VALA_ARRAY_TYPE (param_type));
														array_type = _tmp87_;
														_tmp88_ = vala_array_type_get_element_type (array_type);
														_tmp89_ = _vala_code_node_ref0 (_tmp88_);
														_tmp90_ = _tmp89_;
														_vala_code_node_unref0 (param_type);
														param_type = _tmp90_;
														vala_variable_set_variable_type ((ValaVariable*) p, param_type);
														_vala_code_node_unref0 (array_type);
													}
												}
											} else {
												if (g_strcmp0 (nv[0], "is_ref") == 0) {
													gchar* _tmp91_ = NULL;
													gchar* _tmp92_;
													gboolean _tmp93_;
													_tmp91_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp92_ = _tmp91_;
													if ((_tmp93_ = g_strcmp0 (_tmp92_, "1") == 0, _g_free0 (_tmp92_), _tmp93_)) {
														gboolean _tmp94_ = FALSE;
														vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_REF);
														if (!array_requested) {
															_tmp94_ = VALA_IS_ARRAY_TYPE (param_type);
														} else {
															_tmp94_ = FALSE;
														}
														if (_tmp94_) {
															ValaArrayType* _tmp95_;
															ValaArrayType* array_type;
															ValaDataType* _tmp96_ = NULL;
															ValaDataType* _tmp97_;
															ValaDataType* _tmp98_;
															_tmp95_ = _vala_code_node_ref0 (VALA_ARRAY_TYPE (param_type));
															array_type = _tmp95_;
															_tmp96_ = vala_array_type_get_element_type (array_type);
															_tmp97_ = _vala_code_node_ref0 (_tmp96_);
															_tmp98_ = _tmp97_;
															_vala_code_node_unref0 (param_type);
															param_type = _tmp98_;
															vala_variable_set_variable_type ((ValaVariable*) p, param_type);
															_vala_code_node_unref0 (array_type);
														}
													}
												} else {
													if (g_strcmp0 (nv[0], "takes_ownership") == 0) {
														gchar* _tmp99_ = NULL;
														gchar* _tmp100_;
														gboolean _tmp101_;
														_tmp99_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp100_ = _tmp99_;
														if ((_tmp101_ = g_strcmp0 (_tmp100_, "1") == 0, _g_free0 (_tmp100_), _tmp101_)) {
															vala_data_type_set_value_owned (param_type, TRUE);
														}
													} else {
														if (g_strcmp0 (nv[0], "nullable") == 0) {
															gchar* _tmp102_ = NULL;
															gchar* _tmp103_;
															gboolean _tmp104_;
															_tmp102_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp103_ = _tmp102_;
															if ((_tmp104_ = g_strcmp0 (_tmp103_, "1") == 0, _g_free0 (_tmp103_), _tmp104_)) {
																vala_data_type_set_nullable (param_type, TRUE);
															}
														} else {
															if (g_strcmp0 (nv[0], "type_arguments") == 0) {
																gchar* _tmp105_ = NULL;
																gchar* _tmp106_;
																gchar** _tmp107_;
																gchar** _tmp108_ = NULL;
																gchar** _tmp109_;
																gint type_args_length1;
																gint _type_args_size_;
																gchar** _tmp110_;
																gchar** type_args;
																_tmp105_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp106_ = _tmp105_;
																_tmp108_ = _tmp107_ = g_strsplit (_tmp106_, ",", 0);
																_tmp110_ = (_tmp109_ = _tmp108_, _g_free0 (_tmp106_), _tmp109_);
																type_args_length1 = _vala_array_length (_tmp107_);
																_type_args_size_ = type_args_length1;
																type_args = _tmp110_;
																{
																	gchar** type_arg_collection;
																	int type_arg_collection_length1;
																	int type_arg_it;
																	type_arg_collection = type_args;
																	type_arg_collection_length1 = type_args_length1;
																	for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
																		gchar* _tmp111_;
																		gchar* type_arg;
																		_tmp111_ = g_strdup (type_arg_collection[type_arg_it]);
																		type_arg = _tmp111_;
																		{
																			ValaDataType* _tmp112_ = NULL;
																			ValaDataType* _tmp113_;
																			_tmp112_ = vala_gidl_parser_get_type_from_string (self, type_arg);
																			_tmp113_ = _tmp112_;
																			vala_data_type_add_type_argument (param_type, _tmp113_);
																			_vala_code_node_unref0 (_tmp113_);
																			_g_free0 (type_arg);
																		}
																	}
																}
																type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
															} else {
																if (g_strcmp0 (nv[0], "no_array_length") == 0) {
																	gchar* _tmp114_ = NULL;
																	gchar* _tmp115_;
																	gboolean _tmp116_;
																	_tmp114_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp115_ = _tmp114_;
																	if ((_tmp116_ = g_strcmp0 (_tmp115_, "1") == 0, _g_free0 (_tmp115_), _tmp116_)) {
																		vala_parameter_set_no_array_length (p, TRUE);
																	}
																} else {
																	if (g_strcmp0 (nv[0], "type_name") == 0) {
																		gchar* _tmp117_ = NULL;
																		gchar* _tmp118_;
																		ValaUnresolvedSymbol* _tmp119_ = NULL;
																		ValaUnresolvedSymbol* _tmp120_;
																		ValaUnresolvedSymbol* sym;
																		_tmp117_ = vala_gidl_parser_eval (self, nv[1]);
																		_tmp118_ = _tmp117_;
																		_tmp119_ = vala_unresolved_symbol_new (NULL, _tmp118_, NULL);
																		sym = (_tmp120_ = _tmp119_, _g_free0 (_tmp118_), _tmp120_);
																		if (VALA_IS_UNRESOLVED_TYPE (param_type)) {
																			vala_unresolved_type_set_unresolved_symbol (VALA_UNRESOLVED_TYPE (param_type), sym);
																		} else {
																			ValaSourceReference* _tmp121_ = NULL;
																			ValaUnresolvedType* _tmp122_ = NULL;
																			ValaDataType* _tmp123_;
																			_tmp121_ = vala_code_node_get_source_reference ((ValaCodeNode*) return_type);
																			_tmp122_ = vala_unresolved_type_new_from_symbol (sym, _tmp121_);
																			_tmp123_ = (ValaDataType*) _tmp122_;
																			_vala_code_node_unref0 (param_type);
																			param_type = _tmp123_;
																			vala_variable_set_variable_type ((ValaVariable*) p, param_type);
																		}
																		_vala_code_node_unref0 (sym);
																	}
																}
															}
														}
													}
												}
											}
										}
									}
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
								}
							}
						}
					}
					if (show_param) {
						_tmp124_ = TRUE;
					} else {
						_tmp124_ = !hide_param;
					}
					if (_tmp124_) {
						vala_delegate_add_parameter (cb, p);
					}
					_vala_code_node_unref0 (p);
					_vala_code_node_unref0 (param_type);
					_g_free0 (param_name);
				}
				remaining_params--;
			}
		}
	}
	result = cb;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (return_type);
	return result;
}


static gboolean vala_gidl_parser_is_reference_type (ValaGIdlParser* self, const gchar* cname) {
	gboolean result = FALSE;
	gint _tmp0_;
	gchar** _tmp1_ = NULL;
	gint st_attributes_length1;
	gint _st_attributes_size_;
	gchar** _tmp2_;
	gchar** st_attributes;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cname != NULL, FALSE);
	_tmp1_ = vala_gidl_parser_get_attributes (self, cname, &_tmp0_);
	_tmp2_ = _tmp1_;
	st_attributes_length1 = _tmp0_;
	_st_attributes_size_ = st_attributes_length1;
	st_attributes = _tmp2_;
	if (st_attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = st_attributes;
			attr_collection_length1 = st_attributes_length1;
			for (attr_it = 0; attr_it < st_attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp3_;
				gchar* attr;
				_tmp3_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp3_;
				{
					gchar** _tmp4_;
					gchar** _tmp5_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp6_;
					gchar** nv;
					gboolean _tmp7_ = FALSE;
					_tmp5_ = _tmp4_ = g_strsplit (attr, "=", 2);
					_tmp6_ = _tmp5_;
					nv_length1 = _vala_array_length (_tmp4_);
					_nv_size_ = nv_length1;
					nv = _tmp6_;
					if (g_strcmp0 (nv[0], "is_value_type") == 0) {
						gchar* _tmp8_ = NULL;
						gchar* _tmp9_;
						_tmp8_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp9_ = _tmp8_;
						_tmp7_ = g_strcmp0 (_tmp9_, "1") == 0;
						_g_free0 (_tmp9_);
					} else {
						_tmp7_ = FALSE;
					}
					if (_tmp7_) {
						result = FALSE;
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	result = TRUE;
	st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void vala_gidl_parser_parse_struct (ValaGIdlParser* self, GIdlNodeStruct* st_node, ValaSymbol* container, GIdlModule* module) {
	GIdlNode* node;
	gchar* _tmp0_ = NULL;
	gchar* name;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) st_node;
	if (st_node->deprecated) {
		return;
	}
	_tmp0_ = vala_gidl_parser_fix_type_name (self, node->name, container);
	name = _tmp0_;
	_tmp1_ = vala_gidl_parser_is_reference_type (self, node->name);
	if (!_tmp1_) {
		ValaScope* _tmp2_ = NULL;
		ValaSymbol* _tmp3_ = NULL;
		ValaSymbol* _tmp4_;
		ValaStruct* st;
		ValaTypeSymbol* _tmp50_;
		ValaTypeSymbol* _tmp51_;
		ValaTypeSymbol* _tmp54_;
		_tmp2_ = vala_symbol_get_scope (container);
		_tmp3_ = vala_scope_lookup (_tmp2_, name);
		st = (_tmp4_ = _tmp3_, VALA_IS_STRUCT (_tmp4_) ? ((ValaStruct*) _tmp4_) : NULL);
		if (st == NULL) {
			ValaStruct* _tmp5_ = NULL;
			ValaStruct* _tmp6_;
			gint _tmp7_;
			gchar** _tmp8_ = NULL;
			gint st_attributes_length1;
			gint _st_attributes_size_;
			gchar** _tmp9_;
			gchar** st_attributes;
			_tmp5_ = vala_struct_new (name, self->priv->current_source_reference, NULL);
			_tmp6_ = _tmp5_;
			_vala_code_node_unref0 (st);
			st = _tmp6_;
			vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp8_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp7_);
			_tmp9_ = _tmp8_;
			st_attributes_length1 = _tmp7_;
			_st_attributes_size_ = st_attributes_length1;
			st_attributes = _tmp9_;
			if (st_attributes != NULL) {
				{
					gchar** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = st_attributes;
					attr_collection_length1 = st_attributes_length1;
					for (attr_it = 0; attr_it < st_attributes_length1; attr_it = attr_it + 1) {
						gchar* _tmp10_;
						gchar* attr;
						_tmp10_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp10_;
						{
							gchar** _tmp11_;
							gchar** _tmp12_ = NULL;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp13_;
							gchar** nv;
							_tmp12_ = _tmp11_ = g_strsplit (attr, "=", 2);
							_tmp13_ = _tmp12_;
							nv_length1 = _vala_array_length (_tmp11_);
							_nv_size_ = nv_length1;
							nv = _tmp13_;
							if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
								gchar* _tmp14_ = NULL;
								gchar* _tmp15_;
								_tmp14_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp15_ = _tmp14_;
								vala_symbol_add_cheader_filename ((ValaSymbol*) st, _tmp15_);
								_g_free0 (_tmp15_);
							} else {
								if (g_strcmp0 (nv[0], "hidden") == 0) {
									gchar* _tmp16_ = NULL;
									gchar* _tmp17_;
									gboolean _tmp18_;
									_tmp16_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp17_ = _tmp16_;
									if ((_tmp18_ = g_strcmp0 (_tmp17_, "1") == 0, _g_free0 (_tmp17_), _tmp18_)) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (st);
										_g_free0 (name);
										return;
									}
								} else {
									if (g_strcmp0 (nv[0], "base_type") == 0) {
										gchar* _tmp19_ = NULL;
										gchar* _tmp20_;
										ValaDataType* _tmp21_ = NULL;
										ValaDataType* _tmp22_;
										_tmp19_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp20_ = _tmp19_;
										_tmp21_ = vala_gidl_parser_parse_type_string (self, _tmp20_);
										_tmp22_ = _tmp21_;
										vala_struct_set_base_type (st, _tmp22_);
										_vala_code_node_unref0 (_tmp22_);
										_g_free0 (_tmp20_);
									} else {
										if (g_strcmp0 (nv[0], "rank") == 0) {
											gchar* _tmp23_ = NULL;
											gchar* _tmp24_;
											gint _tmp25_;
											_tmp23_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp24_ = _tmp23_;
											_tmp25_ = atoi (_tmp24_);
											vala_struct_set_rank (st, _tmp25_);
											_g_free0 (_tmp24_);
										} else {
											if (g_strcmp0 (nv[0], "simple_type") == 0) {
												gchar* _tmp26_ = NULL;
												gchar* _tmp27_;
												gboolean _tmp28_;
												_tmp26_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp27_ = _tmp26_;
												if ((_tmp28_ = g_strcmp0 (_tmp27_, "1") == 0, _g_free0 (_tmp27_), _tmp28_)) {
													vala_struct_set_simple_type (st, TRUE);
												}
											} else {
												if (g_strcmp0 (nv[0], "immutable") == 0) {
													gchar* _tmp29_ = NULL;
													gchar* _tmp30_;
													gboolean _tmp31_;
													_tmp29_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp30_ = _tmp29_;
													if ((_tmp31_ = g_strcmp0 (_tmp30_, "1") == 0, _g_free0 (_tmp30_), _tmp31_)) {
														vala_struct_set_is_immutable (st, TRUE);
													}
												} else {
													if (g_strcmp0 (nv[0], "has_type_id") == 0) {
														gchar* _tmp32_ = NULL;
														gchar* _tmp33_;
														gboolean _tmp34_;
														_tmp32_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp33_ = _tmp32_;
														if ((_tmp34_ = g_strcmp0 (_tmp33_, "0") == 0, _g_free0 (_tmp33_), _tmp34_)) {
															vala_struct_set_has_type_id (st, FALSE);
														}
													} else {
														if (g_strcmp0 (nv[0], "type_id") == 0) {
															gchar* _tmp35_ = NULL;
															gchar* _tmp36_;
															_tmp35_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp36_ = _tmp35_;
															vala_struct_set_type_id (st, _tmp36_);
															_g_free0 (_tmp36_);
														} else {
															if (g_strcmp0 (nv[0], "has_copy_function") == 0) {
																gchar* _tmp37_ = NULL;
																gchar* _tmp38_;
																gboolean _tmp39_;
																_tmp37_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp38_ = _tmp37_;
																if ((_tmp39_ = g_strcmp0 (_tmp38_, "0") == 0, _g_free0 (_tmp38_), _tmp39_)) {
																	vala_struct_set_has_copy_function (st, FALSE);
																}
															} else {
																if (g_strcmp0 (nv[0], "deprecated") == 0) {
																	gchar* _tmp40_ = NULL;
																	gchar* _tmp41_;
																	gboolean _tmp42_;
																	_tmp40_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp41_ = _tmp40_;
																	if ((_tmp42_ = g_strcmp0 (_tmp41_, "1") == 0, _g_free0 (_tmp41_), _tmp42_)) {
																		vala_symbol_set_deprecated ((ValaSymbol*) st, TRUE);
																	}
																} else {
																	if (g_strcmp0 (nv[0], "replacement") == 0) {
																		gchar* _tmp43_ = NULL;
																		gchar* _tmp44_;
																		_tmp43_ = vala_gidl_parser_eval (self, nv[1]);
																		_tmp44_ = _tmp43_;
																		vala_symbol_set_replacement ((ValaSymbol*) st, _tmp44_);
																		_g_free0 (_tmp44_);
																	} else {
																		if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
																			gchar* _tmp45_ = NULL;
																			gchar* _tmp46_;
																			_tmp45_ = vala_gidl_parser_eval (self, nv[1]);
																			_tmp46_ = _tmp45_;
																			vala_symbol_set_deprecated_since ((ValaSymbol*) st, _tmp46_);
																			_g_free0 (_tmp46_);
																		} else {
																			if (g_strcmp0 (nv[0], "has_destroy_function") == 0) {
																				gchar* _tmp47_ = NULL;
																				gchar* _tmp48_;
																				gboolean _tmp49_;
																				_tmp47_ = vala_gidl_parser_eval (self, nv[1]);
																				_tmp48_ = _tmp47_;
																				if ((_tmp49_ = g_strcmp0 (_tmp48_, "0") == 0, _g_free0 (_tmp48_), _tmp49_)) {
																					vala_struct_set_has_destroy_function (st, FALSE);
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) st);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) st);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp50_ = _vala_code_node_ref0 ((ValaTypeSymbol*) st);
		_tmp51_ = _tmp50_;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp51_;
		{
			GList* member_collection;
			GList* member_it;
			member_collection = st_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						ValaMethod* _tmp52_ = NULL;
						ValaMethod* m;
						_tmp52_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
						m = _tmp52_;
						if (m != NULL) {
							vala_symbol_add_method ((ValaSymbol*) st, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* _tmp53_ = NULL;
							ValaField* f;
							_tmp53_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							f = _tmp53_;
							if (f != NULL) {
								vala_symbol_add_field ((ValaSymbol*) st, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_tmp54_ = NULL;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp54_;
		_vala_code_node_unref0 (st);
	} else {
		gboolean ref_function_void;
		gchar* ref_function;
		gchar* unref_function;
		gchar* copy_function;
		gchar* free_function;
		ValaScope* _tmp55_ = NULL;
		ValaSymbol* _tmp56_ = NULL;
		ValaSymbol* _tmp57_;
		ValaClass* cl;
		ValaTypeSymbol* _tmp113_;
		ValaTypeSymbol* _tmp114_;
		ValaTypeSymbol* _tmp132_;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		_tmp55_ = vala_symbol_get_scope (container);
		_tmp56_ = vala_scope_lookup (_tmp55_, name);
		cl = (_tmp57_ = _tmp56_, VALA_IS_CLASS (_tmp57_) ? ((ValaClass*) _tmp57_) : NULL);
		if (cl == NULL) {
			gchar* base_class;
			ValaClass* _tmp58_ = NULL;
			ValaClass* _tmp59_;
			gint _tmp60_;
			gchar** _tmp61_ = NULL;
			gint cl_attributes_length1;
			gint _cl_attributes_size_;
			gchar** _tmp62_;
			gchar** cl_attributes;
			base_class = NULL;
			_tmp58_ = vala_class_new (name, self->priv->current_source_reference, NULL);
			_tmp59_ = _tmp58_;
			_vala_code_node_unref0 (cl);
			cl = _tmp59_;
			vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			vala_class_set_is_compact (cl, TRUE);
			_tmp61_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp60_);
			_tmp62_ = _tmp61_;
			cl_attributes_length1 = _tmp60_;
			_cl_attributes_size_ = cl_attributes_length1;
			cl_attributes = _tmp62_;
			if (cl_attributes != NULL) {
				{
					gchar** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = cl_attributes;
					attr_collection_length1 = cl_attributes_length1;
					for (attr_it = 0; attr_it < cl_attributes_length1; attr_it = attr_it + 1) {
						gchar* _tmp63_;
						gchar* attr;
						_tmp63_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp63_;
						{
							gchar** _tmp64_;
							gchar** _tmp65_ = NULL;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp66_;
							gchar** nv;
							_tmp65_ = _tmp64_ = g_strsplit (attr, "=", 2);
							_tmp66_ = _tmp65_;
							nv_length1 = _vala_array_length (_tmp64_);
							_nv_size_ = nv_length1;
							nv = _tmp66_;
							if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
								gchar* _tmp67_ = NULL;
								gchar* _tmp68_;
								_tmp67_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp68_ = _tmp67_;
								vala_symbol_add_cheader_filename ((ValaSymbol*) cl, _tmp68_);
								_g_free0 (_tmp68_);
							} else {
								if (g_strcmp0 (nv[0], "base_class") == 0) {
									gchar* _tmp69_ = NULL;
									gchar* _tmp70_;
									_tmp69_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp70_ = _tmp69_;
									_g_free0 (base_class);
									base_class = _tmp70_;
								} else {
									if (g_strcmp0 (nv[0], "hidden") == 0) {
										gchar* _tmp71_ = NULL;
										gchar* _tmp72_;
										gboolean _tmp73_;
										_tmp71_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp72_ = _tmp71_;
										if ((_tmp73_ = g_strcmp0 (_tmp72_, "1") == 0, _g_free0 (_tmp72_), _tmp73_)) {
											nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (attr);
											cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (base_class);
											_vala_code_node_unref0 (cl);
											_g_free0 (free_function);
											_g_free0 (copy_function);
											_g_free0 (unref_function);
											_g_free0 (ref_function);
											_g_free0 (name);
											return;
										}
									} else {
										if (g_strcmp0 (nv[0], "is_immutable") == 0) {
											gchar* _tmp74_ = NULL;
											gchar* _tmp75_;
											gboolean _tmp76_;
											_tmp74_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp75_ = _tmp74_;
											if ((_tmp76_ = g_strcmp0 (_tmp75_, "1") == 0, _g_free0 (_tmp75_), _tmp76_)) {
												vala_class_set_is_immutable (cl, TRUE);
											}
										} else {
											if (g_strcmp0 (nv[0], "const_cname") == 0) {
												gchar* _tmp77_ = NULL;
												gchar* _tmp78_;
												_tmp77_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp78_ = _tmp77_;
												vala_class_set_const_cname (cl, _tmp78_);
												_g_free0 (_tmp78_);
											} else {
												if (g_strcmp0 (nv[0], "is_fundamental") == 0) {
													gchar* _tmp79_ = NULL;
													gchar* _tmp80_;
													gboolean _tmp81_;
													_tmp79_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp80_ = _tmp79_;
													if ((_tmp81_ = g_strcmp0 (_tmp80_, "1") == 0, _g_free0 (_tmp80_), _tmp81_)) {
														vala_class_set_is_compact (cl, FALSE);
													}
												} else {
													gboolean _tmp82_ = FALSE;
													if (g_strcmp0 (nv[0], "abstract") == 0) {
														_tmp82_ = base_class != NULL;
													} else {
														_tmp82_ = FALSE;
													}
													if (_tmp82_) {
														gchar* _tmp83_ = NULL;
														gchar* _tmp84_;
														gboolean _tmp85_;
														_tmp83_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp84_ = _tmp83_;
														if ((_tmp85_ = g_strcmp0 (_tmp84_, "1") == 0, _g_free0 (_tmp84_), _tmp85_)) {
															vala_class_set_is_abstract (cl, TRUE);
														}
													} else {
														if (g_strcmp0 (nv[0], "free_function") == 0) {
															gchar* _tmp86_ = NULL;
															gchar* _tmp87_;
															_tmp86_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp87_ = _tmp86_;
															_g_free0 (free_function);
															free_function = _tmp87_;
														} else {
															if (g_strcmp0 (nv[0], "ref_function") == 0) {
																gchar* _tmp88_ = NULL;
																gchar* _tmp89_;
																_tmp88_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp89_ = _tmp88_;
																_g_free0 (ref_function);
																ref_function = _tmp89_;
															} else {
																if (g_strcmp0 (nv[0], "unref_function") == 0) {
																	gchar* _tmp90_ = NULL;
																	gchar* _tmp91_;
																	_tmp90_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp91_ = _tmp90_;
																	_g_free0 (unref_function);
																	unref_function = _tmp91_;
																} else {
																	if (g_strcmp0 (nv[0], "copy_function") == 0) {
																		gchar* _tmp92_ = NULL;
																		gchar* _tmp93_;
																		_tmp92_ = vala_gidl_parser_eval (self, nv[1]);
																		_tmp93_ = _tmp92_;
																		_g_free0 (copy_function);
																		copy_function = _tmp93_;
																	} else {
																		if (g_strcmp0 (nv[0], "ref_function_void") == 0) {
																			gchar* _tmp94_ = NULL;
																			gchar* _tmp95_;
																			gboolean _tmp96_;
																			_tmp94_ = vala_gidl_parser_eval (self, nv[1]);
																			_tmp95_ = _tmp94_;
																			if ((_tmp96_ = g_strcmp0 (_tmp95_, "1") == 0, _g_free0 (_tmp95_), _tmp96_)) {
																				ref_function_void = TRUE;
																			}
																		} else {
																			if (g_strcmp0 (nv[0], "deprecated") == 0) {
																				gchar* _tmp97_ = NULL;
																				gchar* _tmp98_;
																				gboolean _tmp99_;
																				_tmp97_ = vala_gidl_parser_eval (self, nv[1]);
																				_tmp98_ = _tmp97_;
																				if ((_tmp99_ = g_strcmp0 (_tmp98_, "1") == 0, _g_free0 (_tmp98_), _tmp99_)) {
																					vala_symbol_set_deprecated ((ValaSymbol*) cl, TRUE);
																				}
																			} else {
																				if (g_strcmp0 (nv[0], "replacement") == 0) {
																					gchar* _tmp100_ = NULL;
																					gchar* _tmp101_;
																					_tmp100_ = vala_gidl_parser_eval (self, nv[1]);
																					_tmp101_ = _tmp100_;
																					vala_symbol_set_replacement ((ValaSymbol*) cl, _tmp101_);
																					_g_free0 (_tmp101_);
																				} else {
																					if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
																						gchar* _tmp102_ = NULL;
																						gchar* _tmp103_;
																						_tmp102_ = vala_gidl_parser_eval (self, nv[1]);
																						_tmp103_ = _tmp102_;
																						vala_symbol_set_deprecated_since ((ValaSymbol*) cl, _tmp103_);
																						_g_free0 (_tmp103_);
																					} else {
																						if (g_strcmp0 (nv[0], "type_parameters") == 0) {
																							gchar* _tmp104_ = NULL;
																							gchar* _tmp105_;
																							gchar** _tmp106_;
																							gchar** _tmp107_ = NULL;
																							gchar** _tmp108_;
																							_tmp104_ = vala_gidl_parser_eval (self, nv[1]);
																							_tmp105_ = _tmp104_;
																							_tmp107_ = _tmp106_ = g_strsplit (_tmp105_, ",", 0);
																							{
																								gchar** type_param_name_collection;
																								int type_param_name_collection_length1;
																								int type_param_name_it;
																								type_param_name_collection = (_tmp108_ = _tmp107_, _g_free0 (_tmp105_), _tmp108_);
																								type_param_name_collection_length1 = _vala_array_length (_tmp106_);
																								for (type_param_name_it = 0; type_param_name_it < _vala_array_length (_tmp106_); type_param_name_it = type_param_name_it + 1) {
																									gchar* _tmp109_;
																									gchar* type_param_name;
																									_tmp109_ = g_strdup (type_param_name_collection[type_param_name_it]);
																									type_param_name = _tmp109_;
																									{
																										ValaTypeParameter* _tmp110_ = NULL;
																										ValaTypeParameter* _tmp111_;
																										_tmp110_ = vala_typeparameter_new (type_param_name, self->priv->current_source_reference);
																										_tmp111_ = _tmp110_;
																										vala_object_type_symbol_add_type_parameter ((ValaObjectTypeSymbol*) cl, _tmp111_);
																										_vala_code_node_unref0 (_tmp111_);
																										_g_free0 (type_param_name);
																									}
																								}
																								type_param_name_collection = (_vala_array_free (type_param_name_collection, type_param_name_collection_length1, (GDestroyNotify) g_free), NULL);
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) cl);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cl);
			if (base_class != NULL) {
				ValaDataType* _tmp112_ = NULL;
				ValaDataType* parent;
				_tmp112_ = vala_gidl_parser_parse_type_string (self, base_class);
				parent = _tmp112_;
				vala_class_add_base_type (cl, parent);
				_vala_code_node_unref0 (parent);
			}
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (base_class);
		}
		_tmp113_ = _vala_code_node_ref0 ((ValaTypeSymbol*) cl);
		_tmp114_ = _tmp113_;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp114_;
		{
			GList* member_collection;
			GList* member_it;
			member_collection = st_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						gboolean _tmp115_ = FALSE;
						if (ref_function == NULL) {
							_tmp115_ = g_strcmp0 (member->name, "ref") == 0;
						} else {
							_tmp115_ = FALSE;
						}
						if (_tmp115_) {
							gchar* _tmp116_;
							gchar* _tmp117_;
							ValaDataType* _tmp118_ = NULL;
							ValaDataType* _tmp119_;
							_tmp116_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
							_tmp117_ = _tmp116_;
							_g_free0 (ref_function);
							ref_function = _tmp117_;
							_tmp118_ = vala_gidl_parser_parse_type (self, ((GIdlNodeFunction*) member)->result->type, NULL);
							_tmp119_ = _tmp118_;
							ref_function_void = VALA_IS_VOID_TYPE (_tmp119_);
							_vala_code_node_unref0 (_tmp119_);
						} else {
							gboolean _tmp120_ = FALSE;
							if (unref_function == NULL) {
								_tmp120_ = g_strcmp0 (member->name, "unref") == 0;
							} else {
								_tmp120_ = FALSE;
							}
							if (_tmp120_) {
								gchar* _tmp121_;
								gchar* _tmp122_;
								_tmp121_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
								_tmp122_ = _tmp121_;
								_g_free0 (unref_function);
								unref_function = _tmp122_;
							} else {
								gboolean _tmp123_ = FALSE;
								if (free_function == NULL) {
									gboolean _tmp124_ = FALSE;
									if (g_strcmp0 (member->name, "free") == 0) {
										_tmp124_ = TRUE;
									} else {
										_tmp124_ = g_strcmp0 (member->name, "destroy") == 0;
									}
									_tmp123_ = _tmp124_;
								} else {
									_tmp123_ = FALSE;
								}
								if (_tmp123_) {
									gchar* _tmp125_;
									gchar* _tmp126_;
									_tmp125_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
									_tmp126_ = _tmp125_;
									_g_free0 (free_function);
									free_function = _tmp126_;
								} else {
									gboolean _tmp127_ = FALSE;
									ValaMethod* _tmp130_ = NULL;
									ValaMethod* m;
									if (copy_function == NULL) {
										_tmp127_ = g_strcmp0 (member->name, "copy") == 0;
									} else {
										_tmp127_ = FALSE;
									}
									if (_tmp127_) {
										gchar* _tmp128_;
										gchar* _tmp129_;
										_tmp128_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
										_tmp129_ = _tmp128_;
										_g_free0 (copy_function);
										copy_function = _tmp129_;
									}
									_tmp130_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
									m = _tmp130_;
									if (m != NULL) {
										vala_symbol_add_method ((ValaSymbol*) cl, m);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* _tmp131_ = NULL;
							ValaField* f;
							_tmp131_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							f = _tmp131_;
							if (f != NULL) {
								vala_symbol_add_field ((ValaSymbol*) cl, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		if (ref_function != NULL) {
			vala_class_set_ref_function (cl, ref_function);
			vala_class_set_ref_function_void (cl, ref_function_void);
		}
		if (copy_function != NULL) {
			vala_class_set_dup_function (cl, copy_function);
		}
		if (unref_function != NULL) {
			vala_class_set_unref_function (cl, unref_function);
		} else {
			if (free_function != NULL) {
				vala_class_set_free_function (cl, free_function);
			}
		}
		_tmp132_ = NULL;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp132_;
		_vala_code_node_unref0 (cl);
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
	}
	_g_free0 (name);
}


static void vala_gidl_parser_parse_union (ValaGIdlParser* self, GIdlNodeUnion* un_node, ValaSymbol* container, GIdlModule* module) {
	GIdlNode* node;
	gchar* _tmp0_ = NULL;
	gchar* name;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (un_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) un_node;
	if (un_node->deprecated) {
		return;
	}
	_tmp0_ = vala_gidl_parser_fix_type_name (self, node->name, container);
	name = _tmp0_;
	_tmp1_ = vala_gidl_parser_is_reference_type (self, node->name);
	if (!_tmp1_) {
		ValaScope* _tmp2_ = NULL;
		ValaSymbol* _tmp3_ = NULL;
		ValaSymbol* _tmp4_;
		ValaStruct* st;
		ValaTypeSymbol* _tmp26_;
		ValaTypeSymbol* _tmp27_;
		ValaTypeSymbol* _tmp30_;
		_tmp2_ = vala_symbol_get_scope (container);
		_tmp3_ = vala_scope_lookup (_tmp2_, name);
		st = (_tmp4_ = _tmp3_, VALA_IS_STRUCT (_tmp4_) ? ((ValaStruct*) _tmp4_) : NULL);
		if (st == NULL) {
			ValaStruct* _tmp5_ = NULL;
			ValaStruct* _tmp6_;
			gint _tmp7_;
			gchar** _tmp8_ = NULL;
			gint st_attributes_length1;
			gint _st_attributes_size_;
			gchar** _tmp9_;
			gchar** st_attributes;
			_tmp5_ = vala_struct_new (name, self->priv->current_source_reference, NULL);
			_tmp6_ = _tmp5_;
			_vala_code_node_unref0 (st);
			st = _tmp6_;
			vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp8_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp7_);
			_tmp9_ = _tmp8_;
			st_attributes_length1 = _tmp7_;
			_st_attributes_size_ = st_attributes_length1;
			st_attributes = _tmp9_;
			if (st_attributes != NULL) {
				{
					gchar** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = st_attributes;
					attr_collection_length1 = st_attributes_length1;
					for (attr_it = 0; attr_it < st_attributes_length1; attr_it = attr_it + 1) {
						gchar* _tmp10_;
						gchar* attr;
						_tmp10_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp10_;
						{
							gchar** _tmp11_;
							gchar** _tmp12_ = NULL;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp13_;
							gchar** nv;
							_tmp12_ = _tmp11_ = g_strsplit (attr, "=", 2);
							_tmp13_ = _tmp12_;
							nv_length1 = _vala_array_length (_tmp11_);
							_nv_size_ = nv_length1;
							nv = _tmp13_;
							if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
								gchar* _tmp14_ = NULL;
								gchar* _tmp15_;
								_tmp14_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp15_ = _tmp14_;
								vala_symbol_add_cheader_filename ((ValaSymbol*) st, _tmp15_);
								_g_free0 (_tmp15_);
							} else {
								if (g_strcmp0 (nv[0], "deprecated") == 0) {
									gchar* _tmp16_ = NULL;
									gchar* _tmp17_;
									gboolean _tmp18_;
									_tmp16_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp17_ = _tmp16_;
									if ((_tmp18_ = g_strcmp0 (_tmp17_, "1") == 0, _g_free0 (_tmp17_), _tmp18_)) {
										vala_symbol_set_deprecated ((ValaSymbol*) st, TRUE);
									}
								} else {
									if (g_strcmp0 (nv[0], "replacement") == 0) {
										gchar* _tmp19_ = NULL;
										gchar* _tmp20_;
										_tmp19_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp20_ = _tmp19_;
										vala_symbol_set_replacement ((ValaSymbol*) st, _tmp20_);
										_g_free0 (_tmp20_);
									} else {
										if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
											gchar* _tmp21_ = NULL;
											gchar* _tmp22_;
											_tmp21_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp22_ = _tmp21_;
											vala_symbol_set_deprecated_since ((ValaSymbol*) st, _tmp22_);
											_g_free0 (_tmp22_);
										} else {
											if (g_strcmp0 (nv[0], "hidden") == 0) {
												gchar* _tmp23_ = NULL;
												gchar* _tmp24_;
												gboolean _tmp25_;
												_tmp23_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp24_ = _tmp23_;
												if ((_tmp25_ = g_strcmp0 (_tmp24_, "1") == 0, _g_free0 (_tmp24_), _tmp25_)) {
													nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
													_g_free0 (attr);
													st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
													_vala_code_node_unref0 (st);
													_g_free0 (name);
													return;
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) st);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) st);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp26_ = _vala_code_node_ref0 ((ValaTypeSymbol*) st);
		_tmp27_ = _tmp26_;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp27_;
		{
			GList* member_collection;
			GList* member_it;
			member_collection = un_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						ValaMethod* _tmp28_ = NULL;
						ValaMethod* m;
						_tmp28_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
						m = _tmp28_;
						if (m != NULL) {
							vala_symbol_add_method ((ValaSymbol*) st, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* _tmp29_ = NULL;
							ValaField* f;
							_tmp29_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							f = _tmp29_;
							if (f != NULL) {
								vala_symbol_add_field ((ValaSymbol*) st, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_tmp30_ = NULL;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp30_;
		_vala_code_node_unref0 (st);
	} else {
		ValaScope* _tmp31_ = NULL;
		ValaSymbol* _tmp32_ = NULL;
		ValaSymbol* _tmp33_;
		ValaClass* cl;
		ValaTypeSymbol* _tmp48_;
		ValaTypeSymbol* _tmp49_;
		gboolean ref_function_void;
		gchar* ref_function;
		gchar* unref_function;
		gchar* copy_function;
		gchar* free_function;
		ValaTypeSymbol* _tmp63_;
		_tmp31_ = vala_symbol_get_scope (container);
		_tmp32_ = vala_scope_lookup (_tmp31_, name);
		cl = (_tmp33_ = _tmp32_, VALA_IS_CLASS (_tmp33_) ? ((ValaClass*) _tmp33_) : NULL);
		if (cl == NULL) {
			ValaClass* _tmp34_ = NULL;
			ValaClass* _tmp35_;
			gint _tmp36_;
			gchar** _tmp37_ = NULL;
			gint cl_attributes_length1;
			gint _cl_attributes_size_;
			gchar** _tmp38_;
			gchar** cl_attributes;
			_tmp34_ = vala_class_new (name, self->priv->current_source_reference, NULL);
			_tmp35_ = _tmp34_;
			_vala_code_node_unref0 (cl);
			cl = _tmp35_;
			vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			vala_class_set_is_compact (cl, TRUE);
			_tmp37_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp36_);
			_tmp38_ = _tmp37_;
			cl_attributes_length1 = _tmp36_;
			_cl_attributes_size_ = cl_attributes_length1;
			cl_attributes = _tmp38_;
			if (cl_attributes != NULL) {
				{
					gchar** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = cl_attributes;
					attr_collection_length1 = cl_attributes_length1;
					for (attr_it = 0; attr_it < cl_attributes_length1; attr_it = attr_it + 1) {
						gchar* _tmp39_;
						gchar* attr;
						_tmp39_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp39_;
						{
							gchar** _tmp40_;
							gchar** _tmp41_ = NULL;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp42_;
							gchar** nv;
							_tmp41_ = _tmp40_ = g_strsplit (attr, "=", 2);
							_tmp42_ = _tmp41_;
							nv_length1 = _vala_array_length (_tmp40_);
							_nv_size_ = nv_length1;
							nv = _tmp42_;
							if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
								gchar* _tmp43_ = NULL;
								gchar* _tmp44_;
								_tmp43_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp44_ = _tmp43_;
								vala_symbol_add_cheader_filename ((ValaSymbol*) cl, _tmp44_);
								_g_free0 (_tmp44_);
							} else {
								if (g_strcmp0 (nv[0], "hidden") == 0) {
									gchar* _tmp45_ = NULL;
									gchar* _tmp46_;
									gboolean _tmp47_;
									_tmp45_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp46_ = _tmp45_;
									if ((_tmp47_ = g_strcmp0 (_tmp46_, "1") == 0, _g_free0 (_tmp46_), _tmp47_)) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (cl);
										_g_free0 (name);
										return;
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) cl);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cl);
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp48_ = _vala_code_node_ref0 ((ValaTypeSymbol*) cl);
		_tmp49_ = _tmp48_;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp49_;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		{
			GList* member_collection;
			GList* member_it;
			member_collection = un_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						if (g_strcmp0 (member->name, "ref") == 0) {
							gchar* _tmp50_;
							gchar* _tmp51_;
							ValaDataType* _tmp52_ = NULL;
							ValaDataType* _tmp53_;
							_tmp50_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
							_tmp51_ = _tmp50_;
							_g_free0 (ref_function);
							ref_function = _tmp51_;
							_tmp52_ = vala_gidl_parser_parse_type (self, ((GIdlNodeFunction*) member)->result->type, NULL);
							_tmp53_ = _tmp52_;
							ref_function_void = VALA_IS_VOID_TYPE (_tmp53_);
							_vala_code_node_unref0 (_tmp53_);
						} else {
							if (g_strcmp0 (member->name, "unref") == 0) {
								gchar* _tmp54_;
								gchar* _tmp55_;
								_tmp54_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
								_tmp55_ = _tmp54_;
								_g_free0 (unref_function);
								unref_function = _tmp55_;
							} else {
								gboolean _tmp56_ = FALSE;
								if (g_strcmp0 (member->name, "free") == 0) {
									_tmp56_ = TRUE;
								} else {
									_tmp56_ = g_strcmp0 (member->name, "destroy") == 0;
								}
								if (_tmp56_) {
									gchar* _tmp57_;
									gchar* _tmp58_;
									_tmp57_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
									_tmp58_ = _tmp57_;
									_g_free0 (free_function);
									free_function = _tmp58_;
								} else {
									ValaMethod* _tmp61_ = NULL;
									ValaMethod* m;
									if (g_strcmp0 (member->name, "copy") == 0) {
										gchar* _tmp59_;
										gchar* _tmp60_;
										_tmp59_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
										_tmp60_ = _tmp59_;
										_g_free0 (copy_function);
										copy_function = _tmp60_;
									}
									_tmp61_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
									m = _tmp61_;
									if (m != NULL) {
										vala_symbol_add_method ((ValaSymbol*) cl, m);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* _tmp62_ = NULL;
							ValaField* f;
							_tmp62_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							f = _tmp62_;
							if (f != NULL) {
								vala_symbol_add_field ((ValaSymbol*) cl, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		if (ref_function != NULL) {
			vala_class_set_ref_function (cl, ref_function);
			vala_class_set_ref_function_void (cl, ref_function_void);
		}
		if (copy_function != NULL) {
			vala_class_set_dup_function (cl, copy_function);
		}
		if (unref_function != NULL) {
			vala_class_set_unref_function (cl, unref_function);
		} else {
			if (free_function != NULL) {
				vala_class_set_free_function (cl, free_function);
			}
		}
		_tmp63_ = NULL;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp63_;
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
		_vala_code_node_unref0 (cl);
	}
	_g_free0 (name);
}


static void vala_gidl_parser_parse_boxed (ValaGIdlParser* self, GIdlNodeBoxed* boxed_node, ValaSymbol* container, GIdlModule* module) {
	GIdlNode* node;
	gchar* _tmp0_ = NULL;
	gchar* name;
	gint _tmp1_;
	gchar** _tmp2_ = NULL;
	gint node_attributes_length1;
	gint _node_attributes_size_;
	gchar** _tmp3_;
	gchar** node_attributes;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (boxed_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) boxed_node;
	_tmp0_ = vala_gidl_parser_fix_type_name (self, node->name, container);
	name = _tmp0_;
	_tmp2_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp1_);
	_tmp3_ = _tmp2_;
	node_attributes_length1 = _tmp1_;
	_node_attributes_size_ = node_attributes_length1;
	node_attributes = _tmp3_;
	if (node_attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = node_attributes;
			attr_collection_length1 = node_attributes_length1;
			for (attr_it = 0; attr_it < node_attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp4_;
				gchar* attr;
				_tmp4_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp4_;
				{
					gchar** _tmp5_;
					gchar** _tmp6_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp7_;
					gchar** nv;
					_tmp6_ = _tmp5_ = g_strsplit (attr, "=", 2);
					_tmp7_ = _tmp6_;
					nv_length1 = _vala_array_length (_tmp5_);
					_nv_size_ = nv_length1;
					nv = _tmp7_;
					if (g_strcmp0 (nv[0], "hidden") == 0) {
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						node_attributes = (_vala_array_free (node_attributes, node_attributes_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (name);
						return;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp8_ = vala_gidl_parser_is_reference_type (self, node->name);
	if (!_tmp8_) {
		ValaScope* _tmp9_ = NULL;
		ValaSymbol* _tmp10_ = NULL;
		ValaSymbol* _tmp11_;
		ValaStruct* st;
		ValaTypeSymbol* _tmp41_;
		ValaTypeSymbol* _tmp42_;
		ValaTypeSymbol* _tmp45_;
		_tmp9_ = vala_symbol_get_scope (container);
		_tmp10_ = vala_scope_lookup (_tmp9_, name);
		st = (_tmp11_ = _tmp10_, VALA_IS_STRUCT (_tmp11_) ? ((ValaStruct*) _tmp11_) : NULL);
		if (st == NULL) {
			ValaStruct* _tmp12_ = NULL;
			ValaStruct* _tmp13_;
			gint _tmp14_;
			gchar** _tmp15_ = NULL;
			gint st_attributes_length1;
			gint _st_attributes_size_;
			gchar** _tmp16_;
			gchar** st_attributes;
			gchar* _tmp39_ = NULL;
			gchar* _tmp40_;
			_tmp12_ = vala_struct_new (name, self->priv->current_source_reference, NULL);
			_tmp13_ = _tmp12_;
			_vala_code_node_unref0 (st);
			st = _tmp13_;
			vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp15_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp14_);
			_tmp16_ = _tmp15_;
			st_attributes_length1 = _tmp14_;
			_st_attributes_size_ = st_attributes_length1;
			st_attributes = _tmp16_;
			if (st_attributes != NULL) {
				{
					gchar** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = st_attributes;
					attr_collection_length1 = st_attributes_length1;
					for (attr_it = 0; attr_it < st_attributes_length1; attr_it = attr_it + 1) {
						gchar* _tmp17_;
						gchar* attr;
						_tmp17_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp17_;
						{
							gchar** _tmp18_;
							gchar** _tmp19_ = NULL;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp20_;
							gchar** nv;
							_tmp19_ = _tmp18_ = g_strsplit (attr, "=", 2);
							_tmp20_ = _tmp19_;
							nv_length1 = _vala_array_length (_tmp18_);
							_nv_size_ = nv_length1;
							nv = _tmp20_;
							if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
								gchar* _tmp21_ = NULL;
								gchar* _tmp22_;
								_tmp21_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp22_ = _tmp21_;
								vala_symbol_add_cheader_filename ((ValaSymbol*) st, _tmp22_);
								_g_free0 (_tmp22_);
							} else {
								if (g_strcmp0 (nv[0], "deprecated") == 0) {
									gchar* _tmp23_ = NULL;
									gchar* _tmp24_;
									gboolean _tmp25_;
									_tmp23_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp24_ = _tmp23_;
									if ((_tmp25_ = g_strcmp0 (_tmp24_, "1") == 0, _g_free0 (_tmp24_), _tmp25_)) {
										vala_symbol_set_deprecated ((ValaSymbol*) st, TRUE);
									}
								} else {
									if (g_strcmp0 (nv[0], "replacement") == 0) {
										gchar* _tmp26_ = NULL;
										gchar* _tmp27_;
										_tmp26_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp27_ = _tmp26_;
										vala_symbol_set_replacement ((ValaSymbol*) st, _tmp27_);
										_g_free0 (_tmp27_);
									} else {
										if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
											gchar* _tmp28_ = NULL;
											gchar* _tmp29_;
											_tmp28_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp29_ = _tmp28_;
											vala_symbol_set_deprecated_since ((ValaSymbol*) st, _tmp29_);
											_g_free0 (_tmp29_);
										} else {
											if (g_strcmp0 (nv[0], "immutable") == 0) {
												gchar* _tmp30_ = NULL;
												gchar* _tmp31_;
												gboolean _tmp32_;
												_tmp30_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp31_ = _tmp30_;
												if ((_tmp32_ = g_strcmp0 (_tmp31_, "1") == 0, _g_free0 (_tmp31_), _tmp32_)) {
													vala_struct_set_is_immutable (st, TRUE);
												}
											} else {
												if (g_strcmp0 (nv[0], "has_copy_function") == 0) {
													gchar* _tmp33_ = NULL;
													gchar* _tmp34_;
													gboolean _tmp35_;
													_tmp33_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp34_ = _tmp33_;
													if ((_tmp35_ = g_strcmp0 (_tmp34_, "0") == 0, _g_free0 (_tmp34_), _tmp35_)) {
														vala_struct_set_has_copy_function (st, FALSE);
													}
												} else {
													if (g_strcmp0 (nv[0], "has_destroy_function") == 0) {
														gchar* _tmp36_ = NULL;
														gchar* _tmp37_;
														gboolean _tmp38_;
														_tmp36_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp37_ = _tmp36_;
														if ((_tmp38_ = g_strcmp0 (_tmp37_, "0") == 0, _g_free0 (_tmp37_), _tmp38_)) {
															vala_struct_set_has_destroy_function (st, FALSE);
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) st);
			_tmp39_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) st, "TYPE_");
			_tmp40_ = _tmp39_;
			vala_struct_set_type_id (st, _tmp40_);
			_g_free0 (_tmp40_);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) st);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp41_ = _vala_code_node_ref0 ((ValaTypeSymbol*) st);
		_tmp42_ = _tmp41_;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp42_;
		{
			GList* member_collection;
			GList* member_it;
			member_collection = boxed_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						ValaMethod* _tmp43_ = NULL;
						ValaMethod* m;
						_tmp43_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
						m = _tmp43_;
						if (m != NULL) {
							vala_symbol_add_method ((ValaSymbol*) st, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* _tmp44_ = NULL;
							ValaField* f;
							_tmp44_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							f = _tmp44_;
							if (f != NULL) {
								vala_symbol_add_field ((ValaSymbol*) st, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_tmp45_ = NULL;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp45_;
		_vala_code_node_unref0 (st);
	} else {
		gboolean ref_function_void;
		gchar* ref_function;
		gchar* unref_function;
		gchar* copy_function;
		gchar* free_function;
		ValaScope* _tmp46_ = NULL;
		ValaSymbol* _tmp47_ = NULL;
		ValaSymbol* _tmp48_;
		ValaClass* cl;
		ValaTypeSymbol* _tmp88_;
		ValaTypeSymbol* _tmp89_;
		ValaTypeSymbol* _tmp103_;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		_tmp46_ = vala_symbol_get_scope (container);
		_tmp47_ = vala_scope_lookup (_tmp46_, name);
		cl = (_tmp48_ = _tmp47_, VALA_IS_CLASS (_tmp48_) ? ((ValaClass*) _tmp48_) : NULL);
		if (cl == NULL) {
			gchar* base_class;
			ValaClass* _tmp49_ = NULL;
			ValaClass* _tmp50_;
			gint _tmp51_;
			gchar** _tmp52_ = NULL;
			gint cl_attributes_length1;
			gint _cl_attributes_size_;
			gchar** _tmp53_;
			gchar** cl_attributes;
			gchar* _tmp85_ = NULL;
			gchar* _tmp86_;
			base_class = NULL;
			_tmp49_ = vala_class_new (name, self->priv->current_source_reference, NULL);
			_tmp50_ = _tmp49_;
			_vala_code_node_unref0 (cl);
			cl = _tmp50_;
			vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			vala_class_set_is_compact (cl, TRUE);
			_tmp52_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp51_);
			_tmp53_ = _tmp52_;
			cl_attributes_length1 = _tmp51_;
			_cl_attributes_size_ = cl_attributes_length1;
			cl_attributes = _tmp53_;
			if (cl_attributes != NULL) {
				{
					gchar** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = cl_attributes;
					attr_collection_length1 = cl_attributes_length1;
					for (attr_it = 0; attr_it < cl_attributes_length1; attr_it = attr_it + 1) {
						gchar* _tmp54_;
						gchar* attr;
						_tmp54_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp54_;
						{
							gchar** _tmp55_;
							gchar** _tmp56_ = NULL;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp57_;
							gchar** nv;
							_tmp56_ = _tmp55_ = g_strsplit (attr, "=", 2);
							_tmp57_ = _tmp56_;
							nv_length1 = _vala_array_length (_tmp55_);
							_nv_size_ = nv_length1;
							nv = _tmp57_;
							if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
								gchar* _tmp58_ = NULL;
								gchar* _tmp59_;
								_tmp58_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp59_ = _tmp58_;
								vala_symbol_add_cheader_filename ((ValaSymbol*) cl, _tmp59_);
								_g_free0 (_tmp59_);
							} else {
								if (g_strcmp0 (nv[0], "base_class") == 0) {
									gchar* _tmp60_ = NULL;
									gchar* _tmp61_;
									_tmp60_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp61_ = _tmp60_;
									_g_free0 (base_class);
									base_class = _tmp61_;
								} else {
									if (g_strcmp0 (nv[0], "is_immutable") == 0) {
										gchar* _tmp62_ = NULL;
										gchar* _tmp63_;
										gboolean _tmp64_;
										_tmp62_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp63_ = _tmp62_;
										if ((_tmp64_ = g_strcmp0 (_tmp63_, "1") == 0, _g_free0 (_tmp63_), _tmp64_)) {
											vala_class_set_is_immutable (cl, TRUE);
										}
									} else {
										if (g_strcmp0 (nv[0], "deprecated") == 0) {
											gchar* _tmp65_ = NULL;
											gchar* _tmp66_;
											gboolean _tmp67_;
											_tmp65_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp66_ = _tmp65_;
											if ((_tmp67_ = g_strcmp0 (_tmp66_, "1") == 0, _g_free0 (_tmp66_), _tmp67_)) {
												vala_symbol_set_deprecated ((ValaSymbol*) cl, TRUE);
											}
										} else {
											if (g_strcmp0 (nv[0], "replacement") == 0) {
												gchar* _tmp68_ = NULL;
												gchar* _tmp69_;
												_tmp68_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp69_ = _tmp68_;
												vala_symbol_set_replacement ((ValaSymbol*) cl, _tmp69_);
												_g_free0 (_tmp69_);
											} else {
												if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
													gchar* _tmp70_ = NULL;
													gchar* _tmp71_;
													_tmp70_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp71_ = _tmp70_;
													vala_symbol_set_deprecated_since ((ValaSymbol*) cl, _tmp71_);
													_g_free0 (_tmp71_);
												} else {
													if (g_strcmp0 (nv[0], "const_cname") == 0) {
														gchar* _tmp72_ = NULL;
														gchar* _tmp73_;
														_tmp72_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp73_ = _tmp72_;
														vala_class_set_const_cname (cl, _tmp73_);
														_g_free0 (_tmp73_);
													} else {
														if (g_strcmp0 (nv[0], "free_function") == 0) {
															gchar* _tmp74_ = NULL;
															gchar* _tmp75_;
															_tmp74_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp75_ = _tmp74_;
															_g_free0 (free_function);
															free_function = _tmp75_;
														} else {
															if (g_strcmp0 (nv[0], "ref_function") == 0) {
																gchar* _tmp76_ = NULL;
																gchar* _tmp77_;
																_tmp76_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp77_ = _tmp76_;
																_g_free0 (ref_function);
																ref_function = _tmp77_;
															} else {
																if (g_strcmp0 (nv[0], "unref_function") == 0) {
																	gchar* _tmp78_ = NULL;
																	gchar* _tmp79_;
																	_tmp78_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp79_ = _tmp78_;
																	_g_free0 (unref_function);
																	unref_function = _tmp79_;
																} else {
																	if (g_strcmp0 (nv[0], "copy_function") == 0) {
																		gchar* _tmp80_ = NULL;
																		gchar* _tmp81_;
																		_tmp80_ = vala_gidl_parser_eval (self, nv[1]);
																		_tmp81_ = _tmp80_;
																		_g_free0 (copy_function);
																		copy_function = _tmp81_;
																	} else {
																		if (g_strcmp0 (nv[0], "ref_function_void") == 0) {
																			gchar* _tmp82_ = NULL;
																			gchar* _tmp83_;
																			gboolean _tmp84_;
																			_tmp82_ = vala_gidl_parser_eval (self, nv[1]);
																			_tmp83_ = _tmp82_;
																			if ((_tmp84_ = g_strcmp0 (_tmp83_, "1") == 0, _g_free0 (_tmp83_), _tmp84_)) {
																				ref_function_void = TRUE;
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) cl);
			_tmp85_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, "TYPE_");
			_tmp86_ = _tmp85_;
			vala_class_set_type_id (cl, _tmp86_);
			_g_free0 (_tmp86_);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cl);
			if (base_class != NULL) {
				ValaDataType* _tmp87_ = NULL;
				ValaDataType* parent;
				_tmp87_ = vala_gidl_parser_parse_type_string (self, base_class);
				parent = _tmp87_;
				vala_class_add_base_type (cl, parent);
				_vala_code_node_unref0 (parent);
			}
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (base_class);
		}
		_tmp88_ = _vala_code_node_ref0 ((ValaTypeSymbol*) cl);
		_tmp89_ = _tmp88_;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp89_;
		{
			GList* member_collection;
			GList* member_it;
			member_collection = boxed_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						if (g_strcmp0 (member->name, "ref") == 0) {
							gchar* _tmp90_;
							gchar* _tmp91_;
							ValaDataType* _tmp92_ = NULL;
							ValaDataType* _tmp93_;
							_tmp90_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
							_tmp91_ = _tmp90_;
							_g_free0 (ref_function);
							ref_function = _tmp91_;
							_tmp92_ = vala_gidl_parser_parse_type (self, ((GIdlNodeFunction*) member)->result->type, NULL);
							_tmp93_ = _tmp92_;
							ref_function_void = VALA_IS_VOID_TYPE (_tmp93_);
							_vala_code_node_unref0 (_tmp93_);
						} else {
							if (g_strcmp0 (member->name, "unref") == 0) {
								gchar* _tmp94_;
								gchar* _tmp95_;
								_tmp94_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
								_tmp95_ = _tmp94_;
								_g_free0 (unref_function);
								unref_function = _tmp95_;
							} else {
								gboolean _tmp96_ = FALSE;
								if (g_strcmp0 (member->name, "free") == 0) {
									_tmp96_ = TRUE;
								} else {
									_tmp96_ = g_strcmp0 (member->name, "destroy") == 0;
								}
								if (_tmp96_) {
									gchar* _tmp97_;
									gchar* _tmp98_;
									_tmp97_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
									_tmp98_ = _tmp97_;
									_g_free0 (free_function);
									free_function = _tmp98_;
								} else {
									ValaMethod* _tmp101_ = NULL;
									ValaMethod* m;
									if (g_strcmp0 (member->name, "copy") == 0) {
										gchar* _tmp99_;
										gchar* _tmp100_;
										_tmp99_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
										_tmp100_ = _tmp99_;
										_g_free0 (copy_function);
										copy_function = _tmp100_;
									}
									_tmp101_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
									m = _tmp101_;
									if (m != NULL) {
										vala_symbol_add_method ((ValaSymbol*) cl, m);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* _tmp102_ = NULL;
							ValaField* f;
							_tmp102_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							f = _tmp102_;
							if (f != NULL) {
								vala_symbol_add_field ((ValaSymbol*) cl, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		if (ref_function != NULL) {
			vala_class_set_ref_function (cl, ref_function);
			vala_class_set_ref_function_void (cl, ref_function_void);
		}
		if (copy_function != NULL) {
			vala_class_set_dup_function (cl, copy_function);
		}
		if (unref_function != NULL) {
			vala_class_set_unref_function (cl, unref_function);
		} else {
			if (free_function != NULL) {
				vala_class_set_free_function (cl, free_function);
			}
		}
		_tmp103_ = NULL;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp103_;
		_vala_code_node_unref0 (cl);
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
	}
	node_attributes = (_vala_array_free (node_attributes, node_attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (name);
}


static gunichar string_get_char (const gchar* self, gint index) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_utf8_get_char (((gchar*) self) + index);
	result = _tmp0_;
	return result;
}


static void vala_gidl_parser_parse_enum (ValaGIdlParser* self, GIdlNodeEnum* en_node, ValaSymbol* container, GIdlModule* module, gboolean is_flags) {
	GIdlNode* node;
	gchar* _tmp0_ = NULL;
	gchar* name;
	gboolean existing;
	ValaScope* _tmp1_ = NULL;
	ValaSymbol* _tmp2_ = NULL;
	ValaSymbol* _tmp3_;
	ValaEnum* en;
	gboolean _tmp11_ = FALSE;
	gchar* common_prefix;
	gboolean is_errordomain;
	ValaArrayList* _tmp48_ = NULL;
	ValaArrayList* cheader_filenames;
	gint _tmp49_;
	gchar** _tmp50_ = NULL;
	gint en_attributes_length1;
	gint _en_attributes_size_;
	gchar** _tmp51_;
	gchar** en_attributes;
	g_return_if_fail (self != NULL);
	g_return_if_fail (en_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) en_node;
	_tmp0_ = vala_gidl_parser_fix_type_name (self, node->name, container);
	name = _tmp0_;
	existing = TRUE;
	_tmp1_ = vala_symbol_get_scope (container);
	_tmp2_ = vala_scope_lookup (_tmp1_, name);
	en = (_tmp3_ = _tmp2_, VALA_IS_ENUM (_tmp3_) ? ((ValaEnum*) _tmp3_) : NULL);
	if (en == NULL) {
		ValaEnum* _tmp4_ = NULL;
		ValaEnum* _tmp5_;
		_tmp4_ = vala_enum_new (name, self->priv->current_source_reference, NULL);
		_tmp5_ = _tmp4_;
		_vala_code_node_unref0 (en);
		en = _tmp5_;
		vala_symbol_set_access ((ValaSymbol*) en, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		existing = FALSE;
	} else {
		ValaScope* _tmp6_ = NULL;
		ValaSymbol* _tmp7_ = NULL;
		ValaEnumValue* dummy;
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) en);
		_tmp7_ = vala_scope_lookup (_tmp6_, "__DUMMY__");
		dummy = VALA_ENUM_VALUE (_tmp7_);
		if (dummy != NULL) {
			ValaList* _tmp8_ = NULL;
			ValaList* _tmp9_;
			ValaScope* _tmp10_ = NULL;
			_tmp8_ = vala_enum_get_values (en);
			_tmp9_ = _tmp8_;
			vala_collection_remove ((ValaCollection*) _tmp9_, dummy);
			_vala_iterable_unref0 (_tmp9_);
			_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) en);
			vala_scope_remove (_tmp10_, "__DUMMY__");
		}
		_vala_code_node_unref0 (dummy);
	}
	if (en_node->gtype_name != NULL) {
		_tmp11_ = g_strcmp0 (en_node->gtype_name, "") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	vala_enum_set_has_type_id (en, _tmp11_);
	common_prefix = NULL;
	{
		GList* value_collection;
		GList* value_it;
		value_collection = en_node->values;
		for (value_it = value_collection; value_it != NULL; value_it = value_it->next) {
			GIdlNode* value;
			value = (GIdlNode*) value_it->data;
			{
				gint _tmp12_;
				gchar** _tmp13_ = NULL;
				gint val_attributes_length1;
				gint _val_attributes_size_;
				gchar** _tmp14_;
				gchar** val_attributes;
				gboolean is_hidden;
				_tmp13_ = vala_gidl_parser_get_attributes (self, value->name, &_tmp12_);
				_tmp14_ = _tmp13_;
				val_attributes_length1 = _tmp12_;
				_val_attributes_size_ = val_attributes_length1;
				val_attributes = _tmp14_;
				is_hidden = FALSE;
				if (val_attributes != NULL) {
					{
						gchar** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = val_attributes;
						attr_collection_length1 = val_attributes_length1;
						for (attr_it = 0; attr_it < val_attributes_length1; attr_it = attr_it + 1) {
							gchar* _tmp15_;
							gchar* attr;
							_tmp15_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp15_;
							{
								gchar** _tmp16_;
								gchar** _tmp17_ = NULL;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp18_;
								gchar** nv;
								gboolean _tmp19_ = FALSE;
								_tmp17_ = _tmp16_ = g_strsplit (attr, "=", 2);
								_tmp18_ = _tmp17_;
								nv_length1 = _vala_array_length (_tmp16_);
								_nv_size_ = nv_length1;
								nv = _tmp18_;
								if (g_strcmp0 (nv[0], "hidden") == 0) {
									gchar* _tmp20_ = NULL;
									gchar* _tmp21_;
									_tmp20_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp21_ = _tmp20_;
									_tmp19_ = g_strcmp0 (_tmp21_, "1") == 0;
									_g_free0 (_tmp21_);
								} else {
									_tmp19_ = FALSE;
								}
								if (_tmp19_) {
									is_hidden = TRUE;
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				if (is_hidden) {
					val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
					continue;
				}
				if (common_prefix == NULL) {
					gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp22_ = g_strdup (value->name);
					_tmp23_ = _tmp22_;
					_g_free0 (common_prefix);
					common_prefix = _tmp23_;
					while (TRUE) {
						gboolean _tmp24_ = FALSE;
						glong _tmp25_;
						glong _tmp27_;
						gchar* _tmp28_ = NULL;
						gchar* _tmp29_;
						_tmp25_ = strlen (common_prefix);
						if (_tmp25_ > 0) {
							gboolean _tmp26_;
							_tmp26_ = g_str_has_suffix (common_prefix, "_");
							_tmp24_ = !_tmp26_;
						} else {
							_tmp24_ = FALSE;
						}
						if (!_tmp24_) {
							break;
						}
						_tmp27_ = strlen (common_prefix);
						_tmp28_ = g_strndup (common_prefix, (gsize) (_tmp27_ - 1));
						_tmp29_ = _tmp28_;
						_g_free0 (common_prefix);
						common_prefix = _tmp29_;
					}
				} else {
					while (TRUE) {
						gboolean _tmp30_;
						glong _tmp31_;
						gchar* _tmp32_ = NULL;
						gchar* _tmp33_;
						_tmp30_ = g_str_has_prefix (value->name, common_prefix);
						if (!(!_tmp30_)) {
							break;
						}
						_tmp31_ = strlen (common_prefix);
						_tmp32_ = g_strndup (common_prefix, (gsize) (_tmp31_ - 1));
						_tmp33_ = _tmp32_;
						_g_free0 (common_prefix);
						common_prefix = _tmp33_;
					}
				}
				while (TRUE) {
					gboolean _tmp34_ = FALSE;
					glong _tmp35_;
					glong _tmp45_;
					gchar* _tmp46_ = NULL;
					gchar* _tmp47_;
					_tmp35_ = strlen (common_prefix);
					if (_tmp35_ > 0) {
						gboolean _tmp36_ = FALSE;
						gboolean _tmp37_;
						_tmp37_ = g_str_has_suffix (common_prefix, "_");
						if (!_tmp37_) {
							_tmp36_ = TRUE;
						} else {
							gboolean _tmp38_ = FALSE;
							glong _tmp39_;
							const gchar* _tmp40_ = NULL;
							gunichar _tmp41_;
							gboolean _tmp42_;
							_tmp39_ = strlen (common_prefix);
							_tmp40_ = string_offset (value->name, _tmp39_);
							_tmp41_ = string_get_char (_tmp40_, 0);
							_tmp42_ = g_unichar_isdigit (_tmp41_);
							if (_tmp42_) {
								glong _tmp43_;
								glong _tmp44_;
								_tmp43_ = strlen (value->name);
								_tmp44_ = strlen (common_prefix);
								_tmp38_ = (_tmp43_ - _tmp44_) <= 1;
							} else {
								_tmp38_ = FALSE;
							}
							_tmp36_ = _tmp38_;
						}
						_tmp34_ = _tmp36_;
					} else {
						_tmp34_ = FALSE;
					}
					if (!_tmp34_) {
						break;
					}
					_tmp45_ = strlen (common_prefix);
					_tmp46_ = g_strndup (common_prefix, (gsize) (_tmp45_ - 1));
					_tmp47_ = _tmp46_;
					_g_free0 (common_prefix);
					common_prefix = _tmp47_;
				}
				val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	is_errordomain = FALSE;
	_tmp48_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	cheader_filenames = _tmp48_;
	_tmp50_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp49_);
	_tmp51_ = _tmp50_;
	en_attributes_length1 = _tmp49_;
	_en_attributes_size_ = en_attributes_length1;
	en_attributes = _tmp51_;
	if (en_attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = en_attributes;
			attr_collection_length1 = en_attributes_length1;
			for (attr_it = 0; attr_it < en_attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp52_;
				gchar* attr;
				_tmp52_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp52_;
				{
					gchar** _tmp53_;
					gchar** _tmp54_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp55_;
					gchar** nv;
					_tmp54_ = _tmp53_ = g_strsplit (attr, "=", 2);
					_tmp55_ = _tmp54_;
					nv_length1 = _vala_array_length (_tmp53_);
					_nv_size_ = nv_length1;
					nv = _tmp55_;
					if (g_strcmp0 (nv[0], "common_prefix") == 0) {
						gchar* _tmp56_ = NULL;
						gchar* _tmp57_;
						_tmp56_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp57_ = _tmp56_;
						_g_free0 (common_prefix);
						common_prefix = _tmp57_;
					} else {
						if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
							gchar* _tmp58_ = NULL;
							gchar* _tmp59_;
							gchar* _tmp60_ = NULL;
							gchar* _tmp61_;
							_tmp58_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp59_ = _tmp58_;
							vala_collection_add ((ValaCollection*) cheader_filenames, _tmp59_);
							_g_free0 (_tmp59_);
							_tmp60_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp61_ = _tmp60_;
							vala_symbol_add_cheader_filename ((ValaSymbol*) en, _tmp61_);
							_g_free0 (_tmp61_);
						} else {
							if (g_strcmp0 (nv[0], "hidden") == 0) {
								gchar* _tmp62_ = NULL;
								gchar* _tmp63_;
								gboolean _tmp64_;
								_tmp62_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp63_ = _tmp62_;
								if ((_tmp64_ = g_strcmp0 (_tmp63_, "1") == 0, _g_free0 (_tmp63_), _tmp64_)) {
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
									en_attributes = (_vala_array_free (en_attributes, en_attributes_length1, (GDestroyNotify) g_free), NULL);
									_vala_iterable_unref0 (cheader_filenames);
									_g_free0 (common_prefix);
									_vala_code_node_unref0 (en);
									_g_free0 (name);
									return;
								}
							} else {
								if (g_strcmp0 (nv[0], "deprecated") == 0) {
									gchar* _tmp65_ = NULL;
									gchar* _tmp66_;
									gboolean _tmp67_;
									_tmp65_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp66_ = _tmp65_;
									if ((_tmp67_ = g_strcmp0 (_tmp66_, "1") == 0, _g_free0 (_tmp66_), _tmp67_)) {
										vala_symbol_set_deprecated ((ValaSymbol*) en, TRUE);
									}
								} else {
									if (g_strcmp0 (nv[0], "replacement") == 0) {
										gchar* _tmp68_ = NULL;
										gchar* _tmp69_;
										_tmp68_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp69_ = _tmp68_;
										vala_symbol_set_replacement ((ValaSymbol*) en, _tmp69_);
										_g_free0 (_tmp69_);
									} else {
										if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
											gchar* _tmp70_ = NULL;
											gchar* _tmp71_;
											_tmp70_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp71_ = _tmp70_;
											vala_symbol_set_deprecated_since ((ValaSymbol*) en, _tmp71_);
											_g_free0 (_tmp71_);
										} else {
											if (g_strcmp0 (nv[0], "rename_to") == 0) {
												gchar* _tmp72_ = NULL;
												gchar* _tmp73_;
												_tmp72_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp73_ = _tmp72_;
												vala_symbol_set_name ((ValaSymbol*) en, _tmp73_);
												_g_free0 (_tmp73_);
											} else {
												if (g_strcmp0 (nv[0], "errordomain") == 0) {
													gchar* _tmp74_ = NULL;
													gchar* _tmp75_;
													gboolean _tmp76_;
													_tmp74_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp75_ = _tmp74_;
													if ((_tmp76_ = g_strcmp0 (_tmp75_, "1") == 0, _g_free0 (_tmp75_), _tmp76_)) {
														is_errordomain = TRUE;
													}
												} else {
													if (g_strcmp0 (nv[0], "to_string") == 0) {
														ValaUnresolvedType* _tmp77_ = NULL;
														ValaUnresolvedType* return_type;
														ValaUnresolvedSymbol* _tmp78_ = NULL;
														ValaUnresolvedSymbol* _tmp79_;
														ValaMethod* _tmp80_ = NULL;
														ValaMethod* m;
														gchar* _tmp81_ = NULL;
														gchar* _tmp82_;
														_tmp77_ = vala_unresolved_type_new ();
														return_type = _tmp77_;
														_tmp78_ = vala_unresolved_symbol_new (NULL, "string", NULL);
														_tmp79_ = _tmp78_;
														vala_unresolved_type_set_unresolved_symbol (return_type, _tmp79_);
														_vala_code_node_unref0 (_tmp79_);
														vala_data_type_set_value_owned ((ValaDataType*) return_type, FALSE);
														_tmp80_ = vala_method_new ("to_string", (ValaDataType*) return_type, self->priv->current_source_reference, NULL);
														m = _tmp80_;
														vala_symbol_set_access ((ValaSymbol*) m, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
														_tmp81_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp82_ = _tmp81_;
														vala_method_set_cname (m, _tmp82_);
														_g_free0 (_tmp82_);
														vala_symbol_add_method ((ValaSymbol*) en, m);
														_vala_code_node_unref0 (m);
														_vala_code_node_unref0 (return_type);
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	vala_enum_set_cprefix (en, common_prefix);
	{
		GList* value2_collection;
		GList* value2_it;
		value2_collection = en_node->values;
		for (value2_it = value2_collection; value2_it != NULL; value2_it = value2_it->next) {
			GIdlNode* value2;
			value2 = (GIdlNode*) value2_it->data;
			{
				gint _tmp83_;
				gchar** _tmp84_ = NULL;
				gint val_attributes_length1;
				gint _val_attributes_size_;
				gchar** _tmp85_;
				gchar** val_attributes;
				gboolean is_hidden;
				_tmp84_ = vala_gidl_parser_get_attributes (self, value2->name, &_tmp83_);
				_tmp85_ = _tmp84_;
				val_attributes_length1 = _tmp83_;
				_val_attributes_size_ = val_attributes_length1;
				val_attributes = _tmp85_;
				is_hidden = FALSE;
				if (val_attributes != NULL) {
					{
						gchar** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = val_attributes;
						attr_collection_length1 = val_attributes_length1;
						for (attr_it = 0; attr_it < val_attributes_length1; attr_it = attr_it + 1) {
							gchar* _tmp86_;
							gchar* attr;
							_tmp86_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp86_;
							{
								gchar** _tmp87_;
								gchar** _tmp88_ = NULL;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp89_;
								gchar** nv;
								gboolean _tmp90_ = FALSE;
								_tmp88_ = _tmp87_ = g_strsplit (attr, "=", 2);
								_tmp89_ = _tmp88_;
								nv_length1 = _vala_array_length (_tmp87_);
								_nv_size_ = nv_length1;
								nv = _tmp89_;
								if (g_strcmp0 (nv[0], "hidden") == 0) {
									gchar* _tmp91_ = NULL;
									gchar* _tmp92_;
									_tmp91_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp92_ = _tmp91_;
									_tmp90_ = g_strcmp0 (_tmp92_, "1") == 0;
									_g_free0 (_tmp92_);
								} else {
									_tmp90_ = FALSE;
								}
								if (_tmp90_) {
									is_hidden = TRUE;
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				if (!is_hidden) {
					glong _tmp93_;
					const gchar* _tmp94_ = NULL;
					ValaEnumValue* _tmp95_ = NULL;
					ValaEnumValue* ev;
					_tmp93_ = strlen (common_prefix);
					_tmp94_ = string_offset (value2->name, _tmp93_);
					_tmp95_ = vala_enum_value_new (_tmp94_, NULL, NULL, NULL);
					ev = _tmp95_;
					vala_enum_add_value (en, ev);
					_vala_code_node_unref0 (ev);
				}
				val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	if (is_errordomain) {
		const gchar* _tmp96_ = NULL;
		ValaErrorDomain* _tmp97_ = NULL;
		ValaErrorDomain* ed;
		_tmp96_ = vala_symbol_get_name ((ValaSymbol*) en);
		_tmp97_ = vala_error_domain_new (_tmp96_, self->priv->current_source_reference, NULL);
		ed = _tmp97_;
		vala_symbol_set_access ((ValaSymbol*) ed, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		vala_error_domain_set_cprefix (ed, common_prefix);
		{
			ValaArrayList* _tmp98_;
			ValaArrayList* _filename_list;
			gint _tmp99_;
			gint _filename_size;
			gint _filename_index;
			_tmp98_ = _vala_iterable_ref0 (cheader_filenames);
			_filename_list = _tmp98_;
			_tmp99_ = vala_collection_get_size ((ValaCollection*) _filename_list);
			_filename_size = _tmp99_;
			_filename_index = -1;
			while (TRUE) {
				gpointer _tmp100_ = NULL;
				gchar* filename;
				_filename_index = _filename_index + 1;
				if (!(_filename_index < _filename_size)) {
					break;
				}
				_tmp100_ = vala_list_get ((ValaList*) _filename_list, _filename_index);
				filename = (gchar*) _tmp100_;
				vala_symbol_add_cheader_filename ((ValaSymbol*) ed, filename);
				_g_free0 (filename);
			}
			_vala_iterable_unref0 (_filename_list);
		}
		{
			ValaList* _tmp101_ = NULL;
			ValaList* _ev_list;
			gint _tmp102_;
			gint _ev_size;
			gint _ev_index;
			_tmp101_ = vala_enum_get_values (en);
			_ev_list = _tmp101_;
			_tmp102_ = vala_collection_get_size ((ValaCollection*) _ev_list);
			_ev_size = _tmp102_;
			_ev_index = -1;
			while (TRUE) {
				gpointer _tmp103_ = NULL;
				ValaEnumValue* ev;
				const gchar* _tmp104_ = NULL;
				ValaErrorCode* _tmp105_ = NULL;
				ValaErrorCode* _tmp106_;
				_ev_index = _ev_index + 1;
				if (!(_ev_index < _ev_size)) {
					break;
				}
				_tmp103_ = vala_list_get (_ev_list, _ev_index);
				ev = (ValaEnumValue*) _tmp103_;
				_tmp104_ = vala_symbol_get_name ((ValaSymbol*) ev);
				_tmp105_ = vala_error_code_new (_tmp104_, NULL, NULL);
				_tmp106_ = _tmp105_;
				vala_error_domain_add_code (ed, _tmp106_);
				_vala_code_node_unref0 (_tmp106_);
				_vala_code_node_unref0 (ev);
			}
			_vala_iterable_unref0 (_ev_list);
		}
		vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) ed);
		if (!existing) {
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) ed);
		}
		_vala_code_node_unref0 (ed);
	} else {
		vala_enum_set_is_flags (en, is_flags);
		vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) en);
		if (!existing) {
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) en);
		}
	}
	en_attributes = (_vala_array_free (en_attributes, en_attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_iterable_unref0 (cheader_filenames);
	_g_free0 (common_prefix);
	_vala_code_node_unref0 (en);
	_g_free0 (name);
}


static void vala_gidl_parser_parse_object (ValaGIdlParser* self, GIdlNodeInterface* node, ValaSymbol* container, GIdlModule* module) {
	gchar* _tmp0_ = NULL;
	gchar* name;
	gchar* base_class;
	ValaScope* _tmp1_ = NULL;
	ValaSymbol* _tmp2_ = NULL;
	ValaSymbol* _tmp3_;
	ValaClass* cl;
	ValaTypeSymbol* _tmp44_;
	ValaTypeSymbol* _tmp45_;
	ValaHashSet* _tmp46_ = NULL;
	ValaSet* _tmp47_;
	ValaHashMap* _tmp48_ = NULL;
	ValaHashMap* current_type_func_map;
	ValaHashMap* _tmp49_ = NULL;
	ValaHashMap* current_type_vfunc_map;
	ValaMethod* _tmp79_ = NULL;
	ValaTypeSymbol* _tmp82_;
	ValaSet* _tmp83_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	_tmp0_ = vala_gidl_parser_fix_type_name (self, ((GIdlNode*) node)->name, container);
	name = _tmp0_;
	base_class = NULL;
	_tmp1_ = vala_symbol_get_scope (container);
	_tmp2_ = vala_scope_lookup (_tmp1_, name);
	cl = (_tmp3_ = _tmp2_, VALA_IS_CLASS (_tmp3_) ? ((ValaClass*) _tmp3_) : NULL);
	if (cl == NULL) {
		ValaClass* _tmp4_ = NULL;
		ValaClass* _tmp5_;
		gint _tmp6_;
		gchar** _tmp7_ = NULL;
		gint attributes_length1;
		gint _attributes_size_;
		gchar** _tmp8_;
		gchar** attributes;
		_tmp4_ = vala_class_new (name, self->priv->current_source_reference, NULL);
		_tmp5_ = _tmp4_;
		_vala_code_node_unref0 (cl);
		cl = _tmp5_;
		vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp7_ = vala_gidl_parser_get_attributes (self, node->gtype_name, &_tmp6_);
		_tmp8_ = _tmp7_;
		attributes_length1 = _tmp6_;
		_attributes_size_ = attributes_length1;
		attributes = _tmp8_;
		if (attributes != NULL) {
			{
				gchar** attr_collection;
				int attr_collection_length1;
				int attr_it;
				attr_collection = attributes;
				attr_collection_length1 = attributes_length1;
				for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
					gchar* _tmp9_;
					gchar* attr;
					_tmp9_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp9_;
					{
						gchar** _tmp10_;
						gchar** _tmp11_ = NULL;
						gint nv_length1;
						gint _nv_size_;
						gchar** _tmp12_;
						gchar** nv;
						_tmp11_ = _tmp10_ = g_strsplit (attr, "=", 2);
						_tmp12_ = _tmp11_;
						nv_length1 = _vala_array_length (_tmp10_);
						_nv_size_ = nv_length1;
						nv = _tmp12_;
						if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
							gchar* _tmp13_ = NULL;
							gchar* _tmp14_;
							_tmp13_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp14_ = _tmp13_;
							vala_symbol_add_cheader_filename ((ValaSymbol*) cl, _tmp14_);
							_g_free0 (_tmp14_);
						} else {
							if (g_strcmp0 (nv[0], "base_class") == 0) {
								gchar* _tmp15_ = NULL;
								gchar* _tmp16_;
								_tmp15_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp16_ = _tmp15_;
								_g_free0 (base_class);
								base_class = _tmp16_;
							} else {
								if (g_strcmp0 (nv[0], "hidden") == 0) {
									gchar* _tmp17_ = NULL;
									gchar* _tmp18_;
									gboolean _tmp19_;
									_tmp17_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp18_ = _tmp17_;
									if ((_tmp19_ = g_strcmp0 (_tmp18_, "1") == 0, _g_free0 (_tmp18_), _tmp19_)) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (cl);
										_g_free0 (base_class);
										_g_free0 (name);
										return;
									}
								} else {
									if (g_strcmp0 (nv[0], "type_check_function") == 0) {
										gchar* _tmp20_ = NULL;
										gchar* _tmp21_;
										_tmp20_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp21_ = _tmp20_;
										vala_class_set_type_check_function (cl, _tmp21_);
										_g_free0 (_tmp21_);
									} else {
										if (g_strcmp0 (nv[0], "deprecated") == 0) {
											gchar* _tmp22_ = NULL;
											gchar* _tmp23_;
											gboolean _tmp24_;
											_tmp22_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp23_ = _tmp22_;
											if ((_tmp24_ = g_strcmp0 (_tmp23_, "1") == 0, _g_free0 (_tmp23_), _tmp24_)) {
												vala_symbol_set_deprecated ((ValaSymbol*) cl, TRUE);
											}
										} else {
											if (g_strcmp0 (nv[0], "replacement") == 0) {
												gchar* _tmp25_ = NULL;
												gchar* _tmp26_;
												_tmp25_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp26_ = _tmp25_;
												vala_symbol_set_replacement ((ValaSymbol*) cl, _tmp26_);
												_g_free0 (_tmp26_);
											} else {
												if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
													gchar* _tmp27_ = NULL;
													gchar* _tmp28_;
													_tmp27_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp28_ = _tmp27_;
													vala_symbol_set_deprecated_since ((ValaSymbol*) cl, _tmp28_);
													_g_free0 (_tmp28_);
												} else {
													if (g_strcmp0 (nv[0], "type_id") == 0) {
														gchar* _tmp29_ = NULL;
														gchar* _tmp30_;
														_tmp29_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp30_ = _tmp29_;
														vala_class_set_type_id (cl, _tmp30_);
														_g_free0 (_tmp30_);
													} else {
														if (g_strcmp0 (nv[0], "abstract") == 0) {
															gchar* _tmp31_ = NULL;
															gchar* _tmp32_;
															gboolean _tmp33_;
															_tmp31_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp32_ = _tmp31_;
															if ((_tmp33_ = g_strcmp0 (_tmp32_, "1") == 0, _g_free0 (_tmp32_), _tmp33_)) {
																vala_class_set_is_abstract (cl, TRUE);
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) cl);
		vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cl);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	if (base_class != NULL) {
		ValaDataType* _tmp34_ = NULL;
		ValaDataType* parent;
		_tmp34_ = vala_gidl_parser_parse_type_string (self, base_class);
		parent = _tmp34_;
		vala_class_add_base_type (cl, parent);
		_vala_code_node_unref0 (parent);
	} else {
		if (node->parent != NULL) {
			ValaDataType* _tmp35_ = NULL;
			ValaDataType* parent;
			_tmp35_ = vala_gidl_parser_parse_type_string (self, node->parent);
			parent = _tmp35_;
			vala_class_add_base_type (cl, parent);
			_vala_code_node_unref0 (parent);
		} else {
			ValaUnresolvedSymbol* _tmp36_ = NULL;
			ValaUnresolvedSymbol* _tmp37_;
			ValaUnresolvedSymbol* _tmp38_ = NULL;
			ValaUnresolvedSymbol* _tmp39_;
			ValaUnresolvedSymbol* gobject_symbol;
			ValaUnresolvedType* _tmp40_ = NULL;
			ValaUnresolvedType* _tmp41_;
			_tmp36_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_unresolved_symbol_new (_tmp37_, "Object", NULL);
			gobject_symbol = (_tmp39_ = _tmp38_, _vala_code_node_unref0 (_tmp37_), _tmp39_);
			_tmp40_ = vala_unresolved_type_new_from_symbol (gobject_symbol, NULL);
			_tmp41_ = _tmp40_;
			vala_class_add_base_type (cl, (ValaDataType*) _tmp41_);
			_vala_code_node_unref0 (_tmp41_);
			_vala_code_node_unref0 (gobject_symbol);
		}
	}
	{
		GList* iface_name_collection;
		GList* iface_name_it;
		iface_name_collection = node->interfaces;
		for (iface_name_it = iface_name_collection; iface_name_it != NULL; iface_name_it = iface_name_it->next) {
			gchar* _tmp42_;
			gchar* iface_name;
			_tmp42_ = g_strdup ((const gchar*) iface_name_it->data);
			iface_name = _tmp42_;
			{
				ValaDataType* _tmp43_ = NULL;
				ValaDataType* iface;
				_tmp43_ = vala_gidl_parser_parse_type_string (self, iface_name);
				iface = _tmp43_;
				vala_class_add_base_type (cl, iface);
				_vala_code_node_unref0 (iface);
				_g_free0 (iface_name);
			}
		}
	}
	_tmp44_ = _vala_code_node_ref0 ((ValaTypeSymbol*) cl);
	_tmp45_ = _tmp44_;
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = _tmp45_;
	_tmp46_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	_tmp47_ = (ValaSet*) _tmp46_;
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	self->priv->current_type_symbol_set = _tmp47_;
	_tmp48_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_POINTER, NULL, NULL, g_str_hash, g_str_equal, g_direct_equal);
	current_type_func_map = _tmp48_;
	_tmp49_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal);
	current_type_vfunc_map = _tmp49_;
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FUNCTION) {
					vala_map_set ((ValaMap*) current_type_func_map, member->name, (GIdlNodeFunction*) member);
				}
				if (member->type == G_IDL_NODE_VFUNC) {
					vala_map_set ((ValaMap*) current_type_vfunc_map, member->name, "1");
				}
			}
		}
	}
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FUNCTION) {
					gboolean _tmp50_;
					_tmp50_ = vala_map_contains ((ValaMap*) current_type_vfunc_map, member->name);
					if (!_tmp50_) {
						ValaMethod* _tmp51_ = NULL;
						ValaMethod* m;
						_tmp51_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
						m = _tmp51_;
						if (m != NULL) {
							vala_symbol_add_method ((ValaSymbol*) cl, m);
						}
						_vala_code_node_unref0 (m);
					}
				} else {
					if (member->type == G_IDL_NODE_VFUNC) {
						gpointer _tmp52_ = NULL;
						ValaMethod* _tmp53_ = NULL;
						ValaMethod* m;
						_tmp52_ = vala_map_get ((ValaMap*) current_type_func_map, member->name);
						_tmp53_ = vala_gidl_parser_parse_virtual (self, (GIdlNodeVFunc*) member, (GIdlNodeFunction*) _tmp52_, FALSE);
						m = _tmp53_;
						if (m != NULL) {
							vala_symbol_add_method ((ValaSymbol*) cl, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_PROPERTY) {
							ValaProperty* _tmp54_ = NULL;
							ValaProperty* prop;
							_tmp54_ = vala_gidl_parser_parse_property (self, (GIdlNodeProperty*) member);
							prop = _tmp54_;
							if (prop != NULL) {
								vala_symbol_add_property ((ValaSymbol*) cl, prop);
							}
							_vala_code_node_unref0 (prop);
						} else {
							if (member->type == G_IDL_NODE_SIGNAL) {
								ValaSignal* _tmp55_ = NULL;
								ValaSignal* sig;
								_tmp55_ = vala_gidl_parser_parse_signal (self, (GIdlNodeSignal*) member);
								sig = _tmp55_;
								if (sig != NULL) {
									vala_symbol_add_signal ((ValaSymbol*) cl, sig);
								}
								_vala_code_node_unref0 (sig);
							}
						}
					}
				}
			}
		}
	}
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FIELD) {
					gboolean _tmp56_;
					_tmp56_ = vala_collection_contains ((ValaCollection*) self->priv->current_type_symbol_set, member->name);
					if (!_tmp56_) {
						ValaField* _tmp57_ = NULL;
						ValaField* f;
						_tmp57_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
						f = _tmp57_;
						if (f != NULL) {
							vala_symbol_add_field ((ValaSymbol*) cl, f);
						}
						_vala_code_node_unref0 (f);
					}
				}
			}
		}
	}
	{
		ValaList* _tmp58_ = NULL;
		ValaList* _prop_list;
		gint _tmp59_;
		gint _prop_size;
		gint _prop_index;
		_tmp58_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
		_prop_list = _tmp58_;
		_tmp59_ = vala_collection_get_size ((ValaCollection*) _prop_list);
		_prop_size = _tmp59_;
		_prop_index = -1;
		while (TRUE) {
			gpointer _tmp60_ = NULL;
			ValaProperty* prop;
			const gchar* _tmp61_ = NULL;
			gchar* _tmp62_ = NULL;
			gchar* getter;
			gboolean _tmp63_ = FALSE;
			ValaPropertyAccessor* _tmp64_ = NULL;
			const gchar* _tmp66_ = NULL;
			gchar* _tmp67_ = NULL;
			gchar* setter;
			gboolean _tmp68_ = FALSE;
			gboolean _tmp69_ = FALSE;
			ValaPropertyAccessor* _tmp70_ = NULL;
			gboolean _tmp74_ = FALSE;
			gboolean _tmp75_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp60_ = vala_list_get (_prop_list, _prop_index);
			prop = (ValaProperty*) _tmp60_;
			_tmp61_ = vala_symbol_get_name ((ValaSymbol*) prop);
			_tmp62_ = g_strdup_printf ("get_%s", _tmp61_);
			getter = _tmp62_;
			_tmp64_ = vala_property_get_get_accessor (prop);
			if (_tmp64_ != NULL) {
				gboolean _tmp65_;
				_tmp65_ = vala_collection_contains ((ValaCollection*) self->priv->current_type_symbol_set, getter);
				_tmp63_ = !_tmp65_;
			} else {
				_tmp63_ = FALSE;
			}
			if (_tmp63_) {
				vala_property_set_no_accessor_method (prop, TRUE);
			}
			_tmp66_ = vala_symbol_get_name ((ValaSymbol*) prop);
			_tmp67_ = g_strdup_printf ("set_%s", _tmp66_);
			setter = _tmp67_;
			_tmp70_ = vala_property_get_set_accessor (prop);
			if (_tmp70_ != NULL) {
				ValaPropertyAccessor* _tmp71_ = NULL;
				gboolean _tmp72_;
				_tmp71_ = vala_property_get_set_accessor (prop);
				_tmp72_ = vala_property_accessor_get_writable (_tmp71_);
				_tmp69_ = _tmp72_;
			} else {
				_tmp69_ = FALSE;
			}
			if (_tmp69_) {
				gboolean _tmp73_;
				_tmp73_ = vala_collection_contains ((ValaCollection*) self->priv->current_type_symbol_set, setter);
				_tmp68_ = !_tmp73_;
			} else {
				_tmp68_ = FALSE;
			}
			if (_tmp68_) {
				vala_property_set_no_accessor_method (prop, TRUE);
			}
			_tmp75_ = vala_property_get_no_accessor_method (prop);
			if (_tmp75_) {
				ValaPropertyAccessor* _tmp76_ = NULL;
				_tmp76_ = vala_property_get_get_accessor (prop);
				_tmp74_ = _tmp76_ != NULL;
			} else {
				_tmp74_ = FALSE;
			}
			if (_tmp74_) {
				ValaPropertyAccessor* _tmp77_ = NULL;
				ValaDataType* _tmp78_ = NULL;
				_tmp77_ = vala_property_get_get_accessor (prop);
				_tmp78_ = vala_property_accessor_get_value_type (_tmp77_);
				vala_data_type_set_value_owned (_tmp78_, TRUE);
			}
			_g_free0 (setter);
			_g_free0 (getter);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	vala_gidl_parser_handle_async_methods (self, (ValaObjectTypeSymbol*) cl);
	_tmp79_ = vala_class_get_default_construction_method (cl);
	if (_tmp79_ == NULL) {
		ValaSourceReference* _tmp80_ = NULL;
		ValaCreationMethod* _tmp81_ = NULL;
		ValaCreationMethod* cm;
		_tmp80_ = vala_code_node_get_source_reference ((ValaCodeNode*) cl);
		_tmp81_ = vala_creation_method_new (NULL, NULL, _tmp80_, NULL);
		cm = _tmp81_;
		vala_method_set_has_construct_function ((ValaMethod*) cm, FALSE);
		vala_symbol_set_access ((ValaSymbol*) cm, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
		vala_symbol_add_method ((ValaSymbol*) cl, (ValaMethod*) cm);
		_vala_code_node_unref0 (cm);
	}
	_tmp82_ = NULL;
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = _tmp82_;
	_tmp83_ = NULL;
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	self->priv->current_type_symbol_set = _tmp83_;
	_vala_map_unref0 (current_type_vfunc_map);
	_vala_map_unref0 (current_type_func_map);
	_vala_code_node_unref0 (cl);
	_g_free0 (base_class);
	_g_free0 (name);
}


static void vala_gidl_parser_parse_interface (ValaGIdlParser* self, GIdlNodeInterface* node, ValaSymbol* container, GIdlModule* module) {
	gchar* _tmp0_ = NULL;
	gchar* name;
	ValaScope* _tmp1_ = NULL;
	ValaSymbol* _tmp2_ = NULL;
	ValaSymbol* _tmp3_;
	ValaInterface* iface;
	ValaTypeSymbol* _tmp19_;
	ValaTypeSymbol* _tmp20_;
	ValaHashMap* _tmp21_ = NULL;
	ValaHashMap* current_type_func_map;
	ValaHashMap* _tmp22_ = NULL;
	ValaHashMap* current_type_vfunc_map;
	ValaTypeSymbol* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	_tmp0_ = vala_gidl_parser_fix_type_name (self, node->gtype_name, container);
	name = _tmp0_;
	_tmp1_ = vala_symbol_get_scope (container);
	_tmp2_ = vala_scope_lookup (_tmp1_, name);
	iface = (_tmp3_ = _tmp2_, VALA_IS_INTERFACE (_tmp3_) ? ((ValaInterface*) _tmp3_) : NULL);
	if (iface == NULL) {
		ValaInterface* _tmp4_ = NULL;
		ValaInterface* _tmp5_;
		gint _tmp6_;
		gchar** _tmp7_ = NULL;
		gint attributes_length1;
		gint _attributes_size_;
		gchar** _tmp8_;
		gchar** attributes;
		_tmp4_ = vala_interface_new (name, self->priv->current_source_reference, NULL);
		_tmp5_ = _tmp4_;
		_vala_code_node_unref0 (iface);
		iface = _tmp5_;
		vala_symbol_set_access ((ValaSymbol*) iface, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp7_ = vala_gidl_parser_get_attributes (self, node->gtype_name, &_tmp6_);
		_tmp8_ = _tmp7_;
		attributes_length1 = _tmp6_;
		_attributes_size_ = attributes_length1;
		attributes = _tmp8_;
		if (attributes != NULL) {
			{
				gchar** attr_collection;
				int attr_collection_length1;
				int attr_it;
				attr_collection = attributes;
				attr_collection_length1 = attributes_length1;
				for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
					gchar* _tmp9_;
					gchar* attr;
					_tmp9_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp9_;
					{
						gchar** _tmp10_;
						gchar** _tmp11_ = NULL;
						gint nv_length1;
						gint _nv_size_;
						gchar** _tmp12_;
						gchar** nv;
						_tmp11_ = _tmp10_ = g_strsplit (attr, "=", 2);
						_tmp12_ = _tmp11_;
						nv_length1 = _vala_array_length (_tmp10_);
						_nv_size_ = nv_length1;
						nv = _tmp12_;
						if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
							gchar* _tmp13_ = NULL;
							gchar* _tmp14_;
							_tmp13_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp14_ = _tmp13_;
							vala_symbol_add_cheader_filename ((ValaSymbol*) iface, _tmp14_);
							_g_free0 (_tmp14_);
						} else {
							if (g_strcmp0 (nv[0], "lower_case_csuffix") == 0) {
								gchar* _tmp15_ = NULL;
								gchar* _tmp16_;
								_tmp15_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp16_ = _tmp15_;
								vala_interface_set_lower_case_csuffix (iface, _tmp16_);
								_g_free0 (_tmp16_);
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		{
			GList* prereq_name_collection;
			GList* prereq_name_it;
			prereq_name_collection = node->prerequisites;
			for (prereq_name_it = prereq_name_collection; prereq_name_it != NULL; prereq_name_it = prereq_name_it->next) {
				gchar* _tmp17_;
				gchar* prereq_name;
				_tmp17_ = g_strdup ((const gchar*) prereq_name_it->data);
				prereq_name = _tmp17_;
				{
					ValaDataType* _tmp18_ = NULL;
					ValaDataType* prereq;
					_tmp18_ = vala_gidl_parser_parse_type_string (self, prereq_name);
					prereq = _tmp18_;
					vala_interface_add_prerequisite (iface, prereq);
					_vala_code_node_unref0 (prereq);
					_g_free0 (prereq_name);
				}
			}
		}
		vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) iface);
		vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) iface);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp19_ = _vala_code_node_ref0 ((ValaTypeSymbol*) iface);
	_tmp20_ = _tmp19_;
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = _tmp20_;
	_tmp21_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_POINTER, NULL, NULL, g_str_hash, g_str_equal, g_direct_equal);
	current_type_func_map = _tmp21_;
	_tmp22_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal);
	current_type_vfunc_map = _tmp22_;
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FUNCTION) {
					vala_map_set ((ValaMap*) current_type_func_map, member->name, (GIdlNodeFunction*) member);
				}
				if (member->type == G_IDL_NODE_VFUNC) {
					vala_map_set ((ValaMap*) current_type_vfunc_map, member->name, "1");
				}
			}
		}
	}
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FUNCTION) {
					gboolean _tmp23_;
					_tmp23_ = vala_map_contains ((ValaMap*) current_type_vfunc_map, member->name);
					if (!_tmp23_) {
						ValaMethod* _tmp24_ = NULL;
						ValaMethod* m;
						_tmp24_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, TRUE);
						m = _tmp24_;
						if (m != NULL) {
							vala_symbol_add_method ((ValaSymbol*) iface, m);
						}
						_vala_code_node_unref0 (m);
					}
				} else {
					if (member->type == G_IDL_NODE_VFUNC) {
						gpointer _tmp25_ = NULL;
						ValaMethod* _tmp26_ = NULL;
						ValaMethod* m;
						_tmp25_ = vala_map_get ((ValaMap*) current_type_func_map, member->name);
						_tmp26_ = vala_gidl_parser_parse_virtual (self, (GIdlNodeVFunc*) member, (GIdlNodeFunction*) _tmp25_, TRUE);
						m = _tmp26_;
						if (m != NULL) {
							vala_symbol_add_method ((ValaSymbol*) iface, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_PROPERTY) {
							ValaProperty* _tmp27_ = NULL;
							ValaProperty* prop;
							_tmp27_ = vala_gidl_parser_parse_property (self, (GIdlNodeProperty*) member);
							prop = _tmp27_;
							if (prop != NULL) {
								vala_symbol_add_property ((ValaSymbol*) iface, prop);
							}
							_vala_code_node_unref0 (prop);
						} else {
							if (member->type == G_IDL_NODE_SIGNAL) {
								ValaSignal* _tmp28_ = NULL;
								ValaSignal* sig;
								_tmp28_ = vala_gidl_parser_parse_signal (self, (GIdlNodeSignal*) member);
								sig = _tmp28_;
								if (sig != NULL) {
									vala_symbol_add_signal ((ValaSymbol*) iface, sig);
									vala_signal_set_is_virtual (sig, FALSE);
								}
								_vala_code_node_unref0 (sig);
							}
						}
					}
				}
			}
		}
	}
	vala_gidl_parser_handle_async_methods (self, (ValaObjectTypeSymbol*) iface);
	_tmp29_ = NULL;
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = _tmp29_;
	_vala_map_unref0 (current_type_vfunc_map);
	_vala_map_unref0 (current_type_func_map);
	_vala_code_node_unref0 (iface);
	_g_free0 (name);
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong _tmp0_;
	glong string_length;
	const gchar* _tmp1_ = NULL;
	const gchar* start;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = _tmp0_;
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp1_ = string_offset (self, offset);
	start = _tmp1_;
	_tmp2_ = string_offset (start, len);
	_tmp3_ = g_strndup (start, ((gchar*) _tmp2_) - ((gchar*) start));
	result = _tmp3_;
	return result;
}


static void vala_gidl_parser_handle_async_methods (ValaGIdlParser* self, ValaObjectTypeSymbol* type_symbol) {
	ValaHashSet* _tmp0_ = NULL;
	ValaSet* finish_methods;
	ValaList* _tmp1_ = NULL;
	ValaList* methods;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_symbol != NULL);
	_tmp0_ = vala_hash_set_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_hash, g_direct_equal);
	finish_methods = (ValaSet*) _tmp0_;
	_tmp1_ = vala_object_type_symbol_get_methods (type_symbol);
	methods = _tmp1_;
	{
		ValaList* _tmp2_;
		ValaList* _m_list;
		gint _tmp3_;
		gint _m_size;
		gint _m_index;
		_tmp2_ = _vala_iterable_ref0 (methods);
		_m_list = _tmp2_;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _m_list);
		_m_size = _tmp3_;
		_m_index = -1;
		while (TRUE) {
			gpointer _tmp4_ = NULL;
			ValaMethod* m;
			gboolean _tmp5_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp4_ = vala_list_get (_m_list, _m_index);
			m = (ValaMethod*) _tmp4_;
			_tmp5_ = vala_method_get_coroutine (m);
			if (_tmp5_) {
				gchar* finish_method_base;
				const gchar* _tmp6_ = NULL;
				gboolean _tmp7_;
				ValaScope* _tmp17_ = NULL;
				gchar* _tmp18_;
				ValaSymbol* _tmp19_ = NULL;
				ValaSymbol* _tmp20_;
				ValaMethod* _tmp21_;
				ValaMethod* finish_method;
				finish_method_base = NULL;
				_tmp6_ = vala_symbol_get_name ((ValaSymbol*) m);
				_tmp7_ = g_str_has_suffix (_tmp6_, "_async");
				if (_tmp7_) {
					const gchar* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					glong _tmp10_;
					glong _tmp11_;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_;
					_tmp8_ = vala_symbol_get_name ((ValaSymbol*) m);
					_tmp9_ = vala_symbol_get_name ((ValaSymbol*) m);
					_tmp10_ = strlen (_tmp9_);
					_tmp11_ = strlen ("_async");
					_tmp12_ = string_substring (_tmp8_, (glong) 0, _tmp10_ - _tmp11_);
					_tmp13_ = _tmp12_;
					_g_free0 (finish_method_base);
					finish_method_base = _tmp13_;
				} else {
					const gchar* _tmp14_ = NULL;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp14_ = vala_symbol_get_name ((ValaSymbol*) m);
					_tmp15_ = g_strdup (_tmp14_);
					_tmp16_ = _tmp15_;
					_g_free0 (finish_method_base);
					finish_method_base = _tmp16_;
				}
				_tmp17_ = vala_symbol_get_scope ((ValaSymbol*) type_symbol);
				_tmp18_ = g_strconcat (finish_method_base, "_finish", NULL);
				_tmp19_ = vala_scope_lookup (_tmp17_, _tmp18_);
				finish_method = (_tmp21_ = (_tmp20_ = _tmp19_, VALA_IS_METHOD (_tmp20_) ? ((ValaMethod*) _tmp20_) : NULL), _g_free0 (_tmp18_), _tmp21_);
				if (finish_method == NULL) {
					gchar* _tmp22_ = NULL;
					gchar* method_cname;
					_tmp22_ = vala_method_get_finish_cname (m);
					method_cname = _tmp22_;
					{
						ValaList* _tmp23_ = NULL;
						ValaList* _method_list;
						gint _tmp24_;
						gint _method_size;
						gint _method_index;
						_tmp23_ = vala_object_type_symbol_get_methods (type_symbol);
						_method_list = _tmp23_;
						_tmp24_ = vala_collection_get_size ((ValaCollection*) _method_list);
						_method_size = _tmp24_;
						_method_index = -1;
						while (TRUE) {
							gpointer _tmp25_ = NULL;
							ValaMethod* method;
							gchar* _tmp26_ = NULL;
							gchar* _tmp27_;
							gboolean _tmp28_;
							_method_index = _method_index + 1;
							if (!(_method_index < _method_size)) {
								break;
							}
							_tmp25_ = vala_list_get (_method_list, _method_index);
							method = (ValaMethod*) _tmp25_;
							_tmp26_ = vala_method_get_cname (method);
							_tmp27_ = _tmp26_;
							if ((_tmp28_ = g_strcmp0 (_tmp27_, method_cname) == 0, _g_free0 (_tmp27_), _tmp28_)) {
								ValaMethod* _tmp29_;
								ValaMethod* _tmp30_;
								_tmp29_ = _vala_code_node_ref0 (method);
								_tmp30_ = _tmp29_;
								_vala_code_node_unref0 (finish_method);
								finish_method = _tmp30_;
								_vala_code_node_unref0 (method);
								break;
							}
							_vala_code_node_unref0 (method);
						}
						_vala_iterable_unref0 (_method_list);
					}
					_g_free0 (method_cname);
				}
				if (finish_method != NULL) {
					ValaDataType* _tmp31_ = NULL;
					ValaDataType* _tmp32_ = NULL;
					ValaDataType* _tmp33_;
					gboolean _tmp34_;
					gboolean _tmp35_;
					_tmp31_ = vala_method_get_return_type (finish_method);
					_tmp32_ = vala_data_type_copy (_tmp31_);
					_tmp33_ = _tmp32_;
					vala_method_set_return_type (m, _tmp33_);
					_vala_code_node_unref0 (_tmp33_);
					_tmp34_ = vala_method_get_no_array_length (finish_method);
					vala_method_set_no_array_length (m, _tmp34_);
					_tmp35_ = vala_method_get_array_null_terminated (finish_method);
					vala_method_set_array_null_terminated (m, _tmp35_);
					{
						ValaList* _tmp36_ = NULL;
						ValaList* _param_list;
						gint _tmp37_;
						gint _param_size;
						gint _param_index;
						_tmp36_ = vala_method_get_parameters (finish_method);
						_param_list = _tmp36_;
						_tmp37_ = vala_collection_get_size ((ValaCollection*) _param_list);
						_param_size = _tmp37_;
						_param_index = -1;
						while (TRUE) {
							gpointer _tmp38_ = NULL;
							ValaParameter* param;
							ValaParameterDirection _tmp39_;
							_param_index = _param_index + 1;
							if (!(_param_index < _param_size)) {
								break;
							}
							_tmp38_ = vala_list_get (_param_list, _param_index);
							param = (ValaParameter*) _tmp38_;
							_tmp39_ = vala_parameter_get_direction (param);
							if (_tmp39_ == VALA_PARAMETER_DIRECTION_OUT) {
								ValaParameter* _tmp40_ = NULL;
								ValaParameter* async_param;
								ValaScope* _tmp41_ = NULL;
								const gchar* _tmp42_ = NULL;
								ValaSymbol* _tmp43_ = NULL;
								ValaSymbol* _tmp44_;
								gboolean _tmp45_;
								_tmp40_ = vala_parameter_copy (param);
								async_param = _tmp40_;
								_tmp41_ = vala_symbol_get_scope ((ValaSymbol*) m);
								_tmp42_ = vala_symbol_get_name ((ValaSymbol*) param);
								_tmp43_ = vala_scope_lookup (_tmp41_, _tmp42_);
								_tmp44_ = _tmp43_;
								if ((_tmp45_ = _tmp44_ != NULL, _vala_code_node_unref0 (_tmp44_), _tmp45_)) {
									const gchar* _tmp46_ = NULL;
									gchar* _tmp47_;
									_tmp46_ = vala_symbol_get_name ((ValaSymbol*) async_param);
									_tmp47_ = g_strconcat (_tmp46_, "_out", NULL);
									vala_symbol_set_name ((ValaSymbol*) async_param, _tmp47_);
									_g_free0 (_tmp47_);
								}
								vala_method_add_parameter (m, async_param);
								_vala_code_node_unref0 (async_param);
							}
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
					{
						ValaList* _tmp48_ = NULL;
						ValaList* _error_type_list;
						gint _tmp49_;
						gint _error_type_size;
						gint _error_type_index;
						_tmp48_ = vala_code_node_get_error_types ((ValaCodeNode*) finish_method);
						_error_type_list = _tmp48_;
						_tmp49_ = vala_collection_get_size ((ValaCollection*) _error_type_list);
						_error_type_size = _tmp49_;
						_error_type_index = -1;
						while (TRUE) {
							gpointer _tmp50_ = NULL;
							ValaDataType* error_type;
							ValaDataType* _tmp51_ = NULL;
							ValaDataType* _tmp52_;
							_error_type_index = _error_type_index + 1;
							if (!(_error_type_index < _error_type_size)) {
								break;
							}
							_tmp50_ = vala_list_get (_error_type_list, _error_type_index);
							error_type = (ValaDataType*) _tmp50_;
							_tmp51_ = vala_data_type_copy (error_type);
							_tmp52_ = _tmp51_;
							vala_code_node_add_error_type ((ValaCodeNode*) m, _tmp52_);
							_vala_code_node_unref0 (_tmp52_);
							_vala_code_node_unref0 (error_type);
						}
						_vala_iterable_unref0 (_error_type_list);
					}
					vala_collection_add ((ValaCollection*) finish_methods, finish_method);
				}
				_vala_code_node_unref0 (finish_method);
				_g_free0 (finish_method_base);
			}
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaIterator* _tmp53_ = NULL;
		ValaIterator* _m_it;
		_tmp53_ = vala_iterable_iterator ((ValaIterable*) finish_methods);
		_m_it = _tmp53_;
		while (TRUE) {
			gboolean _tmp54_;
			gpointer _tmp55_ = NULL;
			ValaMethod* m;
			ValaScope* _tmp56_ = NULL;
			const gchar* _tmp57_ = NULL;
			_tmp54_ = vala_iterator_next (_m_it);
			if (!_tmp54_) {
				break;
			}
			_tmp55_ = vala_iterator_get (_m_it);
			m = (ValaMethod*) _tmp55_;
			_tmp56_ = vala_symbol_get_scope ((ValaSymbol*) type_symbol);
			_tmp57_ = vala_symbol_get_name ((ValaSymbol*) m);
			vala_scope_remove (_tmp56_, _tmp57_);
			vala_collection_remove ((ValaCollection*) methods, m);
			_vala_code_node_unref0 (m);
		}
		_vala_iterator_unref0 (_m_it);
	}
	_vala_iterable_unref0 (methods);
	_vala_iterable_unref0 (finish_methods);
}


static ValaDataType* vala_gidl_parser_parse_type (ValaGIdlParser* self, GIdlNodeType* type_node, ValaParameterDirection* direction) {
	ValaParameterDirection _direction = 0;
	ValaDataType* result = NULL;
	ValaParameterDirection dir;
	ValaUnresolvedType* _tmp0_ = NULL;
	ValaUnresolvedType* type;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_node != NULL, NULL);
	dir = VALA_PARAMETER_DIRECTION_IN;
	_tmp0_ = vala_unresolved_type_new ();
	type = _tmp0_;
	if (type_node->tag == TYPE_TAG_VOID) {
		if (type_node->is_pointer) {
			ValaVoidType* _tmp1_ = NULL;
			ValaVoidType* _tmp2_;
			ValaPointerType* _tmp3_ = NULL;
			ValaDataType* _tmp4_;
			_tmp1_ = vala_void_type_new (NULL);
			_tmp2_ = _tmp1_;
			_tmp3_ = vala_pointer_type_new ((ValaDataType*) _tmp2_, NULL);
			result = (_tmp4_ = (ValaDataType*) _tmp3_, _vala_code_node_unref0 (_tmp2_), _tmp4_);
			_vala_code_node_unref0 (type);
			if (direction) {
				*direction = _direction;
			}
			return result;
		} else {
			ValaVoidType* _tmp5_ = NULL;
			_tmp5_ = vala_void_type_new (NULL);
			result = (ValaDataType*) _tmp5_;
			_vala_code_node_unref0 (type);
			if (direction) {
				*direction = _direction;
			}
			return result;
		}
	} else {
		if (type_node->tag == TYPE_TAG_BOOLEAN) {
			ValaUnresolvedSymbol* _tmp6_ = NULL;
			ValaUnresolvedSymbol* _tmp7_;
			_tmp6_ = vala_unresolved_symbol_new (NULL, "bool", NULL);
			_tmp7_ = _tmp6_;
			vala_unresolved_type_set_unresolved_symbol (type, _tmp7_);
			_vala_code_node_unref0 (_tmp7_);
		} else {
			if (type_node->tag == TYPE_TAG_INT8) {
				ValaUnresolvedSymbol* _tmp8_ = NULL;
				ValaUnresolvedSymbol* _tmp9_;
				_tmp8_ = vala_unresolved_symbol_new (NULL, "char", NULL);
				_tmp9_ = _tmp8_;
				vala_unresolved_type_set_unresolved_symbol (type, _tmp9_);
				_vala_code_node_unref0 (_tmp9_);
			} else {
				if (type_node->tag == TYPE_TAG_UINT8) {
					ValaUnresolvedSymbol* _tmp10_ = NULL;
					ValaUnresolvedSymbol* _tmp11_;
					_tmp10_ = vala_unresolved_symbol_new (NULL, "uchar", NULL);
					_tmp11_ = _tmp10_;
					vala_unresolved_type_set_unresolved_symbol (type, _tmp11_);
					_vala_code_node_unref0 (_tmp11_);
				} else {
					if (type_node->tag == TYPE_TAG_INT16) {
						ValaUnresolvedSymbol* _tmp12_ = NULL;
						ValaUnresolvedSymbol* _tmp13_;
						_tmp12_ = vala_unresolved_symbol_new (NULL, "int16", NULL);
						_tmp13_ = _tmp12_;
						vala_unresolved_type_set_unresolved_symbol (type, _tmp13_);
						_vala_code_node_unref0 (_tmp13_);
					} else {
						if (type_node->tag == TYPE_TAG_UINT16) {
							ValaUnresolvedSymbol* _tmp14_ = NULL;
							ValaUnresolvedSymbol* _tmp15_;
							_tmp14_ = vala_unresolved_symbol_new (NULL, "uint16", NULL);
							_tmp15_ = _tmp14_;
							vala_unresolved_type_set_unresolved_symbol (type, _tmp15_);
							_vala_code_node_unref0 (_tmp15_);
						} else {
							if (type_node->tag == TYPE_TAG_INT32) {
								ValaUnresolvedSymbol* _tmp16_ = NULL;
								ValaUnresolvedSymbol* _tmp17_;
								_tmp16_ = vala_unresolved_symbol_new (NULL, "int32", NULL);
								_tmp17_ = _tmp16_;
								vala_unresolved_type_set_unresolved_symbol (type, _tmp17_);
								_vala_code_node_unref0 (_tmp17_);
							} else {
								if (type_node->tag == TYPE_TAG_UINT32) {
									ValaUnresolvedSymbol* _tmp18_ = NULL;
									ValaUnresolvedSymbol* _tmp19_;
									_tmp18_ = vala_unresolved_symbol_new (NULL, "uint32", NULL);
									_tmp19_ = _tmp18_;
									vala_unresolved_type_set_unresolved_symbol (type, _tmp19_);
									_vala_code_node_unref0 (_tmp19_);
								} else {
									if (type_node->tag == TYPE_TAG_INT64) {
										ValaUnresolvedSymbol* _tmp20_ = NULL;
										ValaUnresolvedSymbol* _tmp21_;
										_tmp20_ = vala_unresolved_symbol_new (NULL, "int64", NULL);
										_tmp21_ = _tmp20_;
										vala_unresolved_type_set_unresolved_symbol (type, _tmp21_);
										_vala_code_node_unref0 (_tmp21_);
									} else {
										if (type_node->tag == TYPE_TAG_UINT64) {
											ValaUnresolvedSymbol* _tmp22_ = NULL;
											ValaUnresolvedSymbol* _tmp23_;
											_tmp22_ = vala_unresolved_symbol_new (NULL, "uint64", NULL);
											_tmp23_ = _tmp22_;
											vala_unresolved_type_set_unresolved_symbol (type, _tmp23_);
											_vala_code_node_unref0 (_tmp23_);
										} else {
											if (type_node->tag == TYPE_TAG_INT) {
												ValaUnresolvedSymbol* _tmp24_ = NULL;
												ValaUnresolvedSymbol* _tmp25_;
												_tmp24_ = vala_unresolved_symbol_new (NULL, "int", NULL);
												_tmp25_ = _tmp24_;
												vala_unresolved_type_set_unresolved_symbol (type, _tmp25_);
												_vala_code_node_unref0 (_tmp25_);
											} else {
												if (type_node->tag == TYPE_TAG_UINT) {
													ValaUnresolvedSymbol* _tmp26_ = NULL;
													ValaUnresolvedSymbol* _tmp27_;
													_tmp26_ = vala_unresolved_symbol_new (NULL, "uint", NULL);
													_tmp27_ = _tmp26_;
													vala_unresolved_type_set_unresolved_symbol (type, _tmp27_);
													_vala_code_node_unref0 (_tmp27_);
												} else {
													if (type_node->tag == TYPE_TAG_LONG) {
														ValaUnresolvedSymbol* _tmp28_ = NULL;
														ValaUnresolvedSymbol* _tmp29_;
														_tmp28_ = vala_unresolved_symbol_new (NULL, "long", NULL);
														_tmp29_ = _tmp28_;
														vala_unresolved_type_set_unresolved_symbol (type, _tmp29_);
														_vala_code_node_unref0 (_tmp29_);
													} else {
														if (type_node->tag == TYPE_TAG_ULONG) {
															ValaUnresolvedSymbol* _tmp30_ = NULL;
															ValaUnresolvedSymbol* _tmp31_;
															_tmp30_ = vala_unresolved_symbol_new (NULL, "ulong", NULL);
															_tmp31_ = _tmp30_;
															vala_unresolved_type_set_unresolved_symbol (type, _tmp31_);
															_vala_code_node_unref0 (_tmp31_);
														} else {
															if (type_node->tag == TYPE_TAG_SSIZE) {
																ValaUnresolvedSymbol* _tmp32_ = NULL;
																ValaUnresolvedSymbol* _tmp33_;
																_tmp32_ = vala_unresolved_symbol_new (NULL, "ssize_t", NULL);
																_tmp33_ = _tmp32_;
																vala_unresolved_type_set_unresolved_symbol (type, _tmp33_);
																_vala_code_node_unref0 (_tmp33_);
															} else {
																if (type_node->tag == TYPE_TAG_SIZE) {
																	ValaUnresolvedSymbol* _tmp34_ = NULL;
																	ValaUnresolvedSymbol* _tmp35_;
																	_tmp34_ = vala_unresolved_symbol_new (NULL, "size_t", NULL);
																	_tmp35_ = _tmp34_;
																	vala_unresolved_type_set_unresolved_symbol (type, _tmp35_);
																	_vala_code_node_unref0 (_tmp35_);
																} else {
																	if (type_node->tag == TYPE_TAG_FLOAT) {
																		ValaUnresolvedSymbol* _tmp36_ = NULL;
																		ValaUnresolvedSymbol* _tmp37_;
																		_tmp36_ = vala_unresolved_symbol_new (NULL, "float", NULL);
																		_tmp37_ = _tmp36_;
																		vala_unresolved_type_set_unresolved_symbol (type, _tmp37_);
																		_vala_code_node_unref0 (_tmp37_);
																	} else {
																		if (type_node->tag == TYPE_TAG_DOUBLE) {
																			ValaUnresolvedSymbol* _tmp38_ = NULL;
																			ValaUnresolvedSymbol* _tmp39_;
																			_tmp38_ = vala_unresolved_symbol_new (NULL, "double", NULL);
																			_tmp39_ = _tmp38_;
																			vala_unresolved_type_set_unresolved_symbol (type, _tmp39_);
																			_vala_code_node_unref0 (_tmp39_);
																		} else {
																			if (type_node->tag == TYPE_TAG_UTF8) {
																				ValaUnresolvedSymbol* _tmp40_ = NULL;
																				ValaUnresolvedSymbol* _tmp41_;
																				_tmp40_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																				_tmp41_ = _tmp40_;
																				vala_unresolved_type_set_unresolved_symbol (type, _tmp41_);
																				_vala_code_node_unref0 (_tmp41_);
																			} else {
																				if (type_node->tag == TYPE_TAG_FILENAME) {
																					ValaUnresolvedSymbol* _tmp42_ = NULL;
																					ValaUnresolvedSymbol* _tmp43_;
																					_tmp42_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																					_tmp43_ = _tmp42_;
																					vala_unresolved_type_set_unresolved_symbol (type, _tmp43_);
																					_vala_code_node_unref0 (_tmp43_);
																				} else {
																					if (type_node->tag == TYPE_TAG_ARRAY) {
																						ValaDataType* _tmp44_ = NULL;
																						ValaDataType* element_type;
																						ValaDataType* _tmp45_;
																						ValaUnresolvedType* _tmp46_;
																						ValaUnresolvedType* _tmp47_;
																						ValaSourceReference* _tmp48_ = NULL;
																						ValaArrayType* _tmp49_ = NULL;
																						_tmp44_ = vala_gidl_parser_parse_type (self, type_node->parameter_type1, NULL);
																						element_type = _tmp44_;
																						_tmp46_ = _vala_code_node_ref0 ((_tmp45_ = element_type, VALA_IS_UNRESOLVED_TYPE (_tmp45_) ? ((ValaUnresolvedType*) _tmp45_) : NULL));
																						_tmp47_ = _tmp46_;
																						_vala_code_node_unref0 (type);
																						type = _tmp47_;
																						if (type == NULL) {
																							result = element_type;
																							_vala_code_node_unref0 (type);
																							if (direction) {
																								*direction = _direction;
																							}
																							return result;
																						}
																						_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) element_type);
																						_tmp49_ = vala_array_type_new (element_type, 1, _tmp48_);
																						result = (ValaDataType*) _tmp49_;
																						_vala_code_node_unref0 (element_type);
																						_vala_code_node_unref0 (type);
																						if (direction) {
																							*direction = _direction;
																						}
																						return result;
																					} else {
																						if (type_node->tag == TYPE_TAG_LIST) {
																							ValaUnresolvedSymbol* _tmp50_ = NULL;
																							ValaUnresolvedSymbol* _tmp51_;
																							ValaUnresolvedSymbol* _tmp52_ = NULL;
																							ValaUnresolvedSymbol* _tmp53_;
																							_tmp50_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																							_tmp51_ = _tmp50_;
																							_tmp52_ = vala_unresolved_symbol_new (_tmp51_, "List", NULL);
																							_tmp53_ = _tmp52_;
																							vala_unresolved_type_set_unresolved_symbol (type, _tmp53_);
																							_vala_code_node_unref0 (_tmp53_);
																							_vala_code_node_unref0 (_tmp51_);
																						} else {
																							if (type_node->tag == TYPE_TAG_SLIST) {
																								ValaUnresolvedSymbol* _tmp54_ = NULL;
																								ValaUnresolvedSymbol* _tmp55_;
																								ValaUnresolvedSymbol* _tmp56_ = NULL;
																								ValaUnresolvedSymbol* _tmp57_;
																								_tmp54_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																								_tmp55_ = _tmp54_;
																								_tmp56_ = vala_unresolved_symbol_new (_tmp55_, "SList", NULL);
																								_tmp57_ = _tmp56_;
																								vala_unresolved_type_set_unresolved_symbol (type, _tmp57_);
																								_vala_code_node_unref0 (_tmp57_);
																								_vala_code_node_unref0 (_tmp55_);
																							} else {
																								if (type_node->tag == TYPE_TAG_HASH) {
																									ValaUnresolvedSymbol* _tmp58_ = NULL;
																									ValaUnresolvedSymbol* _tmp59_;
																									ValaUnresolvedSymbol* _tmp60_ = NULL;
																									ValaUnresolvedSymbol* _tmp61_;
																									_tmp58_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																									_tmp59_ = _tmp58_;
																									_tmp60_ = vala_unresolved_symbol_new (_tmp59_, "HashTable", NULL);
																									_tmp61_ = _tmp60_;
																									vala_unresolved_type_set_unresolved_symbol (type, _tmp61_);
																									_vala_code_node_unref0 (_tmp61_);
																									_vala_code_node_unref0 (_tmp59_);
																								} else {
																									if (type_node->tag == TYPE_TAG_ERROR) {
																										ValaUnresolvedSymbol* _tmp62_ = NULL;
																										ValaUnresolvedSymbol* _tmp63_;
																										ValaUnresolvedSymbol* _tmp64_ = NULL;
																										ValaUnresolvedSymbol* _tmp65_;
																										_tmp62_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																										_tmp63_ = _tmp62_;
																										_tmp64_ = vala_unresolved_symbol_new (_tmp63_, "Error", NULL);
																										_tmp65_ = _tmp64_;
																										vala_unresolved_type_set_unresolved_symbol (type, _tmp65_);
																										_vala_code_node_unref0 (_tmp65_);
																										_vala_code_node_unref0 (_tmp63_);
																									} else {
																										if (type_node->is_interface) {
																											gchar* _tmp66_;
																											gchar* n;
																											gboolean _tmp67_;
																											gboolean _tmp72_ = FALSE;
																											_tmp66_ = g_strdup (type_node->interface);
																											n = _tmp66_;
																											if (g_strcmp0 (n, "") == 0) {
																												result = NULL;
																												_g_free0 (n);
																												_vala_code_node_unref0 (type);
																												if (direction) {
																													*direction = _direction;
																												}
																												return result;
																											}
																											_tmp67_ = g_str_has_prefix (n, "const-");
																											if (_tmp67_) {
																												glong _tmp68_;
																												const gchar* _tmp69_ = NULL;
																												gchar* _tmp70_;
																												gchar* _tmp71_;
																												_tmp68_ = strlen ("const-");
																												_tmp69_ = string_offset (n, _tmp68_);
																												_tmp70_ = g_strdup (_tmp69_);
																												_tmp71_ = _tmp70_;
																												_g_free0 (n);
																												n = _tmp71_;
																											}
																											if (type_node->is_pointer) {
																												gboolean _tmp73_ = FALSE;
																												if (g_strcmp0 (n, "gchar") == 0) {
																													_tmp73_ = TRUE;
																												} else {
																													_tmp73_ = g_strcmp0 (n, "char") == 0;
																												}
																												_tmp72_ = _tmp73_;
																											} else {
																												_tmp72_ = FALSE;
																											}
																											if (_tmp72_) {
																												ValaUnresolvedSymbol* _tmp74_ = NULL;
																												ValaUnresolvedSymbol* _tmp75_;
																												gboolean _tmp76_;
																												_tmp74_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																												_tmp75_ = _tmp74_;
																												vala_unresolved_type_set_unresolved_symbol (type, _tmp75_);
																												_vala_code_node_unref0 (_tmp75_);
																												_tmp76_ = g_str_has_suffix (type_node->unparsed, "**");
																												if (_tmp76_) {
																													dir = VALA_PARAMETER_DIRECTION_OUT;
																												}
																											} else {
																												if (g_strcmp0 (n, "gunichar") == 0) {
																													ValaUnresolvedSymbol* _tmp77_ = NULL;
																													ValaUnresolvedSymbol* _tmp78_;
																													_tmp77_ = vala_unresolved_symbol_new (NULL, "unichar", NULL);
																													_tmp78_ = _tmp77_;
																													vala_unresolved_type_set_unresolved_symbol (type, _tmp78_);
																													_vala_code_node_unref0 (_tmp78_);
																												} else {
																													if (g_strcmp0 (n, "gchar") == 0) {
																														ValaUnresolvedSymbol* _tmp79_ = NULL;
																														ValaUnresolvedSymbol* _tmp80_;
																														_tmp79_ = vala_unresolved_symbol_new (NULL, "char", NULL);
																														_tmp80_ = _tmp79_;
																														vala_unresolved_type_set_unresolved_symbol (type, _tmp80_);
																														_vala_code_node_unref0 (_tmp80_);
																													} else {
																														gboolean _tmp81_ = FALSE;
																														if (g_strcmp0 (n, "guchar") == 0) {
																															_tmp81_ = TRUE;
																														} else {
																															_tmp81_ = g_strcmp0 (n, "guint8") == 0;
																														}
																														if (_tmp81_) {
																															ValaUnresolvedSymbol* _tmp82_ = NULL;
																															ValaUnresolvedSymbol* _tmp83_;
																															_tmp82_ = vala_unresolved_symbol_new (NULL, "uchar", NULL);
																															_tmp83_ = _tmp82_;
																															vala_unresolved_type_set_unresolved_symbol (type, _tmp83_);
																															_vala_code_node_unref0 (_tmp83_);
																															if (type_node->is_pointer) {
																																ValaSourceReference* _tmp84_ = NULL;
																																ValaArrayType* _tmp85_ = NULL;
																																_tmp84_ = vala_code_node_get_source_reference ((ValaCodeNode*) type);
																																_tmp85_ = vala_array_type_new ((ValaDataType*) type, 1, _tmp84_);
																																result = (ValaDataType*) _tmp85_;
																																_g_free0 (n);
																																_vala_code_node_unref0 (type);
																																if (direction) {
																																	*direction = _direction;
																																}
																																return result;
																															}
																														} else {
																															if (g_strcmp0 (n, "gushort") == 0) {
																																ValaUnresolvedSymbol* _tmp86_ = NULL;
																																ValaUnresolvedSymbol* _tmp87_;
																																_tmp86_ = vala_unresolved_symbol_new (NULL, "ushort", NULL);
																																_tmp87_ = _tmp86_;
																																vala_unresolved_type_set_unresolved_symbol (type, _tmp87_);
																																_vala_code_node_unref0 (_tmp87_);
																															} else {
																																if (g_strcmp0 (n, "gshort") == 0) {
																																	ValaUnresolvedSymbol* _tmp88_ = NULL;
																																	ValaUnresolvedSymbol* _tmp89_;
																																	_tmp88_ = vala_unresolved_symbol_new (NULL, "short", NULL);
																																	_tmp89_ = _tmp88_;
																																	vala_unresolved_type_set_unresolved_symbol (type, _tmp89_);
																																	_vala_code_node_unref0 (_tmp89_);
																																} else {
																																	gboolean _tmp90_ = FALSE;
																																	if (g_strcmp0 (n, "gconstpointer") == 0) {
																																		_tmp90_ = TRUE;
																																	} else {
																																		_tmp90_ = g_strcmp0 (n, "void") == 0;
																																	}
																																	if (_tmp90_) {
																																		ValaVoidType* _tmp91_ = NULL;
																																		ValaVoidType* _tmp92_;
																																		ValaPointerType* _tmp93_ = NULL;
																																		ValaDataType* _tmp94_;
																																		_tmp91_ = vala_void_type_new (NULL);
																																		_tmp92_ = _tmp91_;
																																		_tmp93_ = vala_pointer_type_new ((ValaDataType*) _tmp92_, NULL);
																																		result = (_tmp94_ = (ValaDataType*) _tmp93_, _vala_code_node_unref0 (_tmp92_), _tmp94_);
																																		_g_free0 (n);
																																		_vala_code_node_unref0 (type);
																																		if (direction) {
																																			*direction = _direction;
																																		}
																																		return result;
																																	} else {
																																		gboolean _tmp95_ = FALSE;
																																		if (g_strcmp0 (n, "goffset") == 0) {
																																			_tmp95_ = TRUE;
																																		} else {
																																			_tmp95_ = g_strcmp0 (n, "off_t") == 0;
																																		}
																																		if (_tmp95_) {
																																			ValaUnresolvedSymbol* _tmp96_ = NULL;
																																			ValaUnresolvedSymbol* _tmp97_;
																																			_tmp96_ = vala_unresolved_symbol_new (NULL, "int64", NULL);
																																			_tmp97_ = _tmp96_;
																																			vala_unresolved_type_set_unresolved_symbol (type, _tmp97_);
																																			_vala_code_node_unref0 (_tmp97_);
																																		} else {
																																			if (g_strcmp0 (n, "value_array") == 0) {
																																				ValaUnresolvedSymbol* _tmp98_ = NULL;
																																				ValaUnresolvedSymbol* _tmp99_;
																																				ValaUnresolvedSymbol* _tmp100_ = NULL;
																																				ValaUnresolvedSymbol* _tmp101_;
																																				_tmp98_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																																				_tmp99_ = _tmp98_;
																																				_tmp100_ = vala_unresolved_symbol_new (_tmp99_, "ValueArray", NULL);
																																				_tmp101_ = _tmp100_;
																																				vala_unresolved_type_set_unresolved_symbol (type, _tmp101_);
																																				_vala_code_node_unref0 (_tmp101_);
																																				_vala_code_node_unref0 (_tmp99_);
																																			} else {
																																				if (g_strcmp0 (n, "time_t") == 0) {
																																					ValaUnresolvedSymbol* _tmp102_ = NULL;
																																					ValaUnresolvedSymbol* _tmp103_;
																																					_tmp102_ = vala_unresolved_symbol_new (NULL, "ulong", NULL);
																																					_tmp103_ = _tmp102_;
																																					vala_unresolved_type_set_unresolved_symbol (type, _tmp103_);
																																					_vala_code_node_unref0 (_tmp103_);
																																				} else {
																																					if (g_strcmp0 (n, "socklen_t") == 0) {
																																						ValaUnresolvedSymbol* _tmp104_ = NULL;
																																						ValaUnresolvedSymbol* _tmp105_;
																																						_tmp104_ = vala_unresolved_symbol_new (NULL, "uint32", NULL);
																																						_tmp105_ = _tmp104_;
																																						vala_unresolved_type_set_unresolved_symbol (type, _tmp105_);
																																						_vala_code_node_unref0 (_tmp105_);
																																					} else {
																																						if (g_strcmp0 (n, "mode_t") == 0) {
																																							ValaUnresolvedSymbol* _tmp106_ = NULL;
																																							ValaUnresolvedSymbol* _tmp107_;
																																							_tmp106_ = vala_unresolved_symbol_new (NULL, "uint", NULL);
																																							_tmp107_ = _tmp106_;
																																							vala_unresolved_type_set_unresolved_symbol (type, _tmp107_);
																																							_vala_code_node_unref0 (_tmp107_);
																																						} else {
																																							gboolean _tmp108_ = FALSE;
																																							if (g_strcmp0 (n, "gint") == 0) {
																																								_tmp108_ = TRUE;
																																							} else {
																																								_tmp108_ = g_strcmp0 (n, "pid_t") == 0;
																																							}
																																							if (_tmp108_) {
																																								ValaUnresolvedSymbol* _tmp109_ = NULL;
																																								ValaUnresolvedSymbol* _tmp110_;
																																								_tmp109_ = vala_unresolved_symbol_new (NULL, "int", NULL);
																																								_tmp110_ = _tmp109_;
																																								vala_unresolved_type_set_unresolved_symbol (type, _tmp110_);
																																								_vala_code_node_unref0 (_tmp110_);
																																							} else {
																																								gboolean _tmp111_ = FALSE;
																																								if (g_strcmp0 (n, "unsigned") == 0) {
																																									_tmp111_ = TRUE;
																																								} else {
																																									_tmp111_ = g_strcmp0 (n, "unsigned-int") == 0;
																																								}
																																								if (_tmp111_) {
																																									ValaUnresolvedSymbol* _tmp112_ = NULL;
																																									ValaUnresolvedSymbol* _tmp113_;
																																									_tmp112_ = vala_unresolved_symbol_new (NULL, "uint", NULL);
																																									_tmp113_ = _tmp112_;
																																									vala_unresolved_type_set_unresolved_symbol (type, _tmp113_);
																																									_vala_code_node_unref0 (_tmp113_);
																																								} else {
																																									if (g_strcmp0 (n, "FILE") == 0) {
																																										ValaUnresolvedSymbol* _tmp114_ = NULL;
																																										ValaUnresolvedSymbol* _tmp115_;
																																										ValaUnresolvedSymbol* _tmp116_ = NULL;
																																										ValaUnresolvedSymbol* _tmp117_;
																																										_tmp114_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																																										_tmp115_ = _tmp114_;
																																										_tmp116_ = vala_unresolved_symbol_new (_tmp115_, "FileStream", NULL);
																																										_tmp117_ = _tmp116_;
																																										vala_unresolved_type_set_unresolved_symbol (type, _tmp117_);
																																										_vala_code_node_unref0 (_tmp117_);
																																										_vala_code_node_unref0 (_tmp115_);
																																									} else {
																																										if (g_strcmp0 (n, "struct") == 0) {
																																											ValaVoidType* _tmp118_ = NULL;
																																											ValaVoidType* _tmp119_;
																																											ValaPointerType* _tmp120_ = NULL;
																																											ValaDataType* _tmp121_;
																																											_tmp118_ = vala_void_type_new (NULL);
																																											_tmp119_ = _tmp118_;
																																											_tmp120_ = vala_pointer_type_new ((ValaDataType*) _tmp119_, NULL);
																																											result = (_tmp121_ = (ValaDataType*) _tmp120_, _vala_code_node_unref0 (_tmp119_), _tmp121_);
																																											_g_free0 (n);
																																											_vala_code_node_unref0 (type);
																																											if (direction) {
																																												*direction = _direction;
																																											}
																																											return result;
																																										} else {
																																											if (g_strcmp0 (n, "iconv_t") == 0) {
																																												ValaVoidType* _tmp122_ = NULL;
																																												ValaVoidType* _tmp123_;
																																												ValaPointerType* _tmp124_ = NULL;
																																												ValaDataType* _tmp125_;
																																												_tmp122_ = vala_void_type_new (NULL);
																																												_tmp123_ = _tmp122_;
																																												_tmp124_ = vala_pointer_type_new ((ValaDataType*) _tmp123_, NULL);
																																												result = (_tmp125_ = (ValaDataType*) _tmp124_, _vala_code_node_unref0 (_tmp123_), _tmp125_);
																																												_g_free0 (n);
																																												_vala_code_node_unref0 (type);
																																												if (direction) {
																																													*direction = _direction;
																																												}
																																												return result;
																																											} else {
																																												if (g_strcmp0 (n, "GType") == 0) {
																																													ValaUnresolvedSymbol* _tmp126_ = NULL;
																																													ValaUnresolvedSymbol* _tmp127_;
																																													ValaUnresolvedSymbol* _tmp128_ = NULL;
																																													ValaUnresolvedSymbol* _tmp129_;
																																													_tmp126_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																																													_tmp127_ = _tmp126_;
																																													_tmp128_ = vala_unresolved_symbol_new (_tmp127_, "Type", NULL);
																																													_tmp129_ = _tmp128_;
																																													vala_unresolved_type_set_unresolved_symbol (type, _tmp129_);
																																													_vala_code_node_unref0 (_tmp129_);
																																													_vala_code_node_unref0 (_tmp127_);
																																													if (type_node->is_pointer) {
																																														ValaSourceReference* _tmp130_ = NULL;
																																														ValaArrayType* _tmp131_ = NULL;
																																														_tmp130_ = vala_code_node_get_source_reference ((ValaCodeNode*) type);
																																														_tmp131_ = vala_array_type_new ((ValaDataType*) type, 1, _tmp130_);
																																														result = (ValaDataType*) _tmp131_;
																																														_g_free0 (n);
																																														_vala_code_node_unref0 (type);
																																														if (direction) {
																																															*direction = _direction;
																																														}
																																														return result;
																																													}
																																												} else {
																																													if (g_strcmp0 (n, "GStrv") == 0) {
																																														ValaUnresolvedSymbol* _tmp132_ = NULL;
																																														ValaUnresolvedSymbol* _tmp133_;
																																														ValaSourceReference* _tmp134_ = NULL;
																																														ValaArrayType* _tmp135_ = NULL;
																																														_tmp132_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																																														_tmp133_ = _tmp132_;
																																														vala_unresolved_type_set_unresolved_symbol (type, _tmp133_);
																																														_vala_code_node_unref0 (_tmp133_);
																																														_tmp134_ = vala_code_node_get_source_reference ((ValaCodeNode*) type);
																																														_tmp135_ = vala_array_type_new ((ValaDataType*) type, 1, _tmp134_);
																																														result = (ValaDataType*) _tmp135_;
																																														_g_free0 (n);
																																														_vala_code_node_unref0 (type);
																																														if (direction) {
																																															*direction = _direction;
																																														}
																																														return result;
																																													} else {
																																														ValaDataType* _tmp136_ = NULL;
																																														ValaDataType* named_type;
																																														ValaDataType* _tmp137_;
																																														ValaUnresolvedType* _tmp138_;
																																														ValaUnresolvedType* _tmp139_;
																																														gboolean _tmp140_;
																																														_tmp136_ = vala_gidl_parser_parse_type_string (self, n);
																																														named_type = _tmp136_;
																																														_tmp138_ = _vala_code_node_ref0 ((_tmp137_ = named_type, VALA_IS_UNRESOLVED_TYPE (_tmp137_) ? ((ValaUnresolvedType*) _tmp137_) : NULL));
																																														_tmp139_ = _tmp138_;
																																														_vala_code_node_unref0 (type);
																																														type = _tmp139_;
																																														if (type == NULL) {
																																															result = named_type;
																																															_g_free0 (n);
																																															_vala_code_node_unref0 (type);
																																															if (direction) {
																																																*direction = _direction;
																																															}
																																															return result;
																																														}
																																														_tmp140_ = vala_gidl_parser_is_simple_type (self, n);
																																														if (_tmp140_) {
																																															if (type_node->is_pointer) {
																																																dir = VALA_PARAMETER_DIRECTION_OUT;
																																															}
																																														} else {
																																															gboolean _tmp141_;
																																															_tmp141_ = g_str_has_suffix (type_node->unparsed, "**");
																																															if (_tmp141_) {
																																																dir = VALA_PARAMETER_DIRECTION_OUT;
																																															}
																																														}
																																														_vala_code_node_unref0 (named_type);
																																													}
																																												}
																																											}
																																										}
																																									}
																																								}
																																							}
																																						}
																																					}
																																				}
																																			}
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																											}
																											_g_free0 (n);
																										} else {
																											fprintf (stdout, "%d\n", (gint) type_node->tag);
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	if ((&_direction) != NULL) {
		_direction = dir;
	}
	result = (ValaDataType*) type;
	if (direction) {
		*direction = _direction;
	}
	return result;
}


static gboolean vala_gidl_parser_is_simple_type (ValaGIdlParser* self, const gchar* type_name) {
	gboolean result = FALSE;
	gpointer _tmp0_ = NULL;
	ValaTypeSymbol* _tmp1_;
	ValaStruct* st;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_name != NULL, FALSE);
	_tmp0_ = vala_map_get (self->priv->cname_type_map, type_name);
	st = (_tmp1_ = (ValaTypeSymbol*) _tmp0_, VALA_IS_STRUCT (_tmp1_) ? ((ValaStruct*) _tmp1_) : NULL);
	if (st != NULL) {
		gboolean _tmp3_;
		_tmp3_ = vala_struct_is_simple_type (st);
		_tmp2_ = _tmp3_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (st);
	return result;
}


static ValaDataType* vala_gidl_parser_parse_type_string (ValaGIdlParser* self, const gchar* n) {
	ValaDataType* result = NULL;
	ValaUnresolvedType* _tmp4_ = NULL;
	ValaUnresolvedType* type;
	gpointer _tmp5_ = NULL;
	ValaTypeSymbol* dt;
	gint _tmp15_;
	gchar** _tmp16_ = NULL;
	gint type_attributes_length1;
	gint _type_attributes_size_;
	gchar** _tmp17_;
	gchar** type_attributes;
	gchar* ns_name;
	ValaUnresolvedSymbol* _tmp38_ = NULL;
	const gchar* _tmp48_ = NULL;
	gboolean _tmp49_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	if (g_strcmp0 (n, "va_list") == 0) {
		ValaVoidType* _tmp0_ = NULL;
		ValaVoidType* _tmp1_;
		ValaPointerType* _tmp2_ = NULL;
		ValaDataType* _tmp3_;
		_tmp0_ = vala_void_type_new (NULL);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_pointer_type_new ((ValaDataType*) _tmp1_, NULL);
		result = (_tmp3_ = (ValaDataType*) _tmp2_, _vala_code_node_unref0 (_tmp1_), _tmp3_);
		return result;
	}
	_tmp4_ = vala_unresolved_type_new ();
	type = _tmp4_;
	_tmp5_ = vala_map_get (self->priv->cname_type_map, n);
	dt = (ValaTypeSymbol*) _tmp5_;
	if (dt != NULL) {
		ValaUnresolvedSymbol* parent_symbol;
		ValaSymbol* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp12_ = NULL;
		ValaUnresolvedSymbol* _tmp13_ = NULL;
		ValaUnresolvedSymbol* _tmp14_;
		parent_symbol = NULL;
		_tmp6_ = vala_symbol_get_parent_symbol ((ValaSymbol*) dt);
		_tmp7_ = vala_symbol_get_name (_tmp6_);
		if (_tmp7_ != NULL) {
			ValaSymbol* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			ValaUnresolvedSymbol* _tmp10_ = NULL;
			ValaUnresolvedSymbol* _tmp11_;
			_tmp8_ = vala_symbol_get_parent_symbol ((ValaSymbol*) dt);
			_tmp9_ = vala_symbol_get_name (_tmp8_);
			_tmp10_ = vala_unresolved_symbol_new (NULL, _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			_vala_code_node_unref0 (parent_symbol);
			parent_symbol = _tmp11_;
		}
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) dt);
		_tmp13_ = vala_unresolved_symbol_new (parent_symbol, _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		vala_unresolved_type_set_unresolved_symbol (type, _tmp14_);
		_vala_code_node_unref0 (_tmp14_);
		result = (ValaDataType*) type;
		_vala_code_node_unref0 (parent_symbol);
		_vala_code_node_unref0 (dt);
		return result;
	}
	_tmp16_ = vala_gidl_parser_get_attributes (self, n, &_tmp15_);
	_tmp17_ = _tmp16_;
	type_attributes_length1 = _tmp15_;
	_type_attributes_size_ = type_attributes_length1;
	type_attributes = _tmp17_;
	ns_name = NULL;
	if (NULL != type_attributes) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = type_attributes;
			attr_collection_length1 = type_attributes_length1;
			for (attr_it = 0; attr_it < type_attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp18_;
				gchar* attr;
				_tmp18_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp18_;
				{
					gchar** _tmp19_;
					gchar** _tmp20_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp21_;
					gchar** nv;
					_tmp20_ = _tmp19_ = g_strsplit (attr, "=", 2);
					_tmp21_ = _tmp20_;
					nv_length1 = _vala_array_length (_tmp19_);
					_nv_size_ = nv_length1;
					nv = _tmp21_;
					if (g_strcmp0 (nv[0], "cprefix") == 0) {
						gchar* _tmp22_ = NULL;
						gchar* _tmp23_;
						glong _tmp24_;
						const gchar* _tmp25_ = NULL;
						ValaUnresolvedSymbol* _tmp26_ = NULL;
						ValaUnresolvedSymbol* _tmp27_;
						_tmp22_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp23_ = _tmp22_;
						_tmp24_ = strlen (_tmp23_);
						_tmp25_ = string_offset (n, _tmp24_);
						_tmp26_ = vala_unresolved_symbol_new (NULL, _tmp25_, NULL);
						_tmp27_ = _tmp26_;
						vala_unresolved_type_set_unresolved_symbol (type, _tmp27_);
						_vala_code_node_unref0 (_tmp27_);
						_g_free0 (_tmp23_);
					} else {
						if (g_strcmp0 (nv[0], "name") == 0) {
							gchar* _tmp28_ = NULL;
							gchar* _tmp29_;
							ValaUnresolvedSymbol* _tmp30_ = NULL;
							ValaUnresolvedSymbol* _tmp31_;
							_tmp28_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp29_ = _tmp28_;
							_tmp30_ = vala_unresolved_symbol_new (NULL, _tmp29_, NULL);
							_tmp31_ = _tmp30_;
							vala_unresolved_type_set_unresolved_symbol (type, _tmp31_);
							_vala_code_node_unref0 (_tmp31_);
							_g_free0 (_tmp29_);
						} else {
							if (g_strcmp0 (nv[0], "namespace") == 0) {
								gchar* _tmp32_ = NULL;
								gchar* _tmp33_;
								_tmp32_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp33_ = _tmp32_;
								_g_free0 (ns_name);
								ns_name = _tmp33_;
							} else {
								if (g_strcmp0 (nv[0], "rename_to") == 0) {
									gchar* _tmp34_ = NULL;
									gchar* _tmp35_;
									ValaUnresolvedSymbol* _tmp36_ = NULL;
									ValaUnresolvedSymbol* _tmp37_;
									_tmp34_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp35_ = _tmp34_;
									_tmp36_ = vala_unresolved_symbol_new (NULL, _tmp35_, NULL);
									_tmp37_ = _tmp36_;
									vala_unresolved_type_set_unresolved_symbol (type, _tmp37_);
									_vala_code_node_unref0 (_tmp37_);
									_g_free0 (_tmp35_);
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp38_ = vala_unresolved_type_get_unresolved_symbol (type);
	if (_tmp38_ != NULL) {
		ValaUnresolvedSymbol* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		_tmp39_ = vala_unresolved_type_get_unresolved_symbol (type);
		_tmp40_ = vala_symbol_get_name ((ValaSymbol*) _tmp39_);
		if (g_strcmp0 (_tmp40_, "pointer") == 0) {
			ValaVoidType* _tmp41_ = NULL;
			ValaVoidType* _tmp42_;
			ValaPointerType* _tmp43_ = NULL;
			ValaDataType* _tmp44_;
			_tmp41_ = vala_void_type_new (NULL);
			_tmp42_ = _tmp41_;
			_tmp43_ = vala_pointer_type_new ((ValaDataType*) _tmp42_, NULL);
			result = (_tmp44_ = (ValaDataType*) _tmp43_, _vala_code_node_unref0 (_tmp42_), _tmp44_);
			_g_free0 (ns_name);
			type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
			_vala_code_node_unref0 (dt);
			_vala_code_node_unref0 (type);
			return result;
		}
		if (ns_name != NULL) {
			ValaUnresolvedSymbol* _tmp45_ = NULL;
			ValaUnresolvedSymbol* _tmp46_ = NULL;
			ValaUnresolvedSymbol* _tmp47_;
			_tmp45_ = vala_unresolved_type_get_unresolved_symbol (type);
			_tmp46_ = vala_unresolved_symbol_new (NULL, ns_name, NULL);
			_tmp47_ = _tmp46_;
			vala_unresolved_symbol_set_inner (_tmp45_, _tmp47_);
			_vala_code_node_unref0 (_tmp47_);
		}
		result = (ValaDataType*) type;
		_g_free0 (ns_name);
		type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
		_vala_code_node_unref0 (dt);
		return result;
	}
	_tmp48_ = vala_symbol_get_name ((ValaSymbol*) self->priv->current_namespace);
	_tmp49_ = g_str_has_prefix (n, _tmp48_);
	if (_tmp49_) {
		const gchar* _tmp50_ = NULL;
		ValaUnresolvedSymbol* _tmp51_ = NULL;
		ValaUnresolvedSymbol* _tmp52_;
		const gchar* _tmp53_ = NULL;
		glong _tmp54_;
		const gchar* _tmp55_ = NULL;
		ValaUnresolvedSymbol* _tmp56_ = NULL;
		ValaUnresolvedSymbol* _tmp57_;
		_tmp50_ = vala_symbol_get_name ((ValaSymbol*) self->priv->current_namespace);
		_tmp51_ = vala_unresolved_symbol_new (NULL, _tmp50_, NULL);
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_symbol_get_name ((ValaSymbol*) self->priv->current_namespace);
		_tmp54_ = strlen (_tmp53_);
		_tmp55_ = string_offset (n, _tmp54_);
		_tmp56_ = vala_unresolved_symbol_new (_tmp52_, _tmp55_, NULL);
		_tmp57_ = _tmp56_;
		vala_unresolved_type_set_unresolved_symbol (type, _tmp57_);
		_vala_code_node_unref0 (_tmp57_);
		_vala_code_node_unref0 (_tmp52_);
	} else {
		gboolean _tmp58_;
		_tmp58_ = g_str_has_prefix (n, "G");
		if (_tmp58_) {
			ValaUnresolvedSymbol* _tmp59_ = NULL;
			ValaUnresolvedSymbol* _tmp60_;
			const gchar* _tmp61_ = NULL;
			ValaUnresolvedSymbol* _tmp62_ = NULL;
			ValaUnresolvedSymbol* _tmp63_;
			_tmp59_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
			_tmp60_ = _tmp59_;
			_tmp61_ = string_offset (n, (glong) 1);
			_tmp62_ = vala_unresolved_symbol_new (_tmp60_, _tmp61_, NULL);
			_tmp63_ = _tmp62_;
			vala_unresolved_type_set_unresolved_symbol (type, _tmp63_);
			_vala_code_node_unref0 (_tmp63_);
			_vala_code_node_unref0 (_tmp60_);
		} else {
			gchar** _tmp64_;
			gchar** _tmp65_ = NULL;
			gint name_parts_length1;
			gint _name_parts_size_;
			gchar** _tmp66_;
			gchar** name_parts;
			_tmp65_ = _tmp64_ = g_strsplit (n, ".", 2);
			_tmp66_ = _tmp65_;
			name_parts_length1 = _vala_array_length (_tmp64_);
			_name_parts_size_ = name_parts_length1;
			name_parts = _tmp66_;
			if (name_parts[1] == NULL) {
				ValaUnresolvedSymbol* _tmp67_ = NULL;
				ValaUnresolvedSymbol* _tmp68_;
				_tmp67_ = vala_unresolved_symbol_new (NULL, name_parts[0], NULL);
				_tmp68_ = _tmp67_;
				vala_unresolved_type_set_unresolved_symbol (type, _tmp68_);
				_vala_code_node_unref0 (_tmp68_);
			} else {
				ValaUnresolvedSymbol* _tmp69_ = NULL;
				ValaUnresolvedSymbol* _tmp70_;
				ValaUnresolvedSymbol* _tmp71_ = NULL;
				ValaUnresolvedSymbol* _tmp72_;
				_tmp69_ = vala_unresolved_symbol_new (NULL, name_parts[0], NULL);
				_tmp70_ = _tmp69_;
				_tmp71_ = vala_unresolved_symbol_new (_tmp70_, name_parts[1], NULL);
				_tmp72_ = _tmp71_;
				vala_unresolved_type_set_unresolved_symbol (type, _tmp72_);
				_vala_code_node_unref0 (_tmp72_);
				_vala_code_node_unref0 (_tmp70_);
			}
			name_parts = (_vala_array_free (name_parts, name_parts_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	result = (ValaDataType*) type;
	_g_free0 (ns_name);
	type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (dt);
	return result;
}


static ValaDataType* vala_gidl_parser_parse_param (ValaGIdlParser* self, GIdlNodeParam* param, ValaParameterDirection* direction) {
	ValaParameterDirection _direction = 0;
	ValaDataType* result = NULL;
	ValaParameterDirection _tmp0_;
	ValaDataType* _tmp1_ = NULL;
	ValaDataType* type;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (param != NULL, NULL);
	_tmp1_ = vala_gidl_parser_parse_type (self, param->type, &_tmp0_);
	_direction = _tmp0_;
	type = _tmp1_;
	result = type;
	if (direction) {
		*direction = _direction;
	}
	return result;
}


ValaDataType* vala_gidl_parser_get_type_from_string (ValaGIdlParser* self, const gchar* type_arg) {
	ValaDataType* result = NULL;
	gboolean is_unowned;
	ValaUnresolvedSymbol* sym;
	gboolean _tmp4_;
	gchar** _tmp7_;
	gchar** _tmp8_ = NULL;
	ValaUnresolvedType* _tmp11_ = NULL;
	ValaUnresolvedType* arg_type;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_arg != NULL, NULL);
	is_unowned = FALSE;
	sym = NULL;
	if (g_strcmp0 (type_arg, "pointer") == 0) {
		ValaVoidType* _tmp0_ = NULL;
		ValaVoidType* _tmp1_;
		ValaPointerType* _tmp2_ = NULL;
		ValaDataType* _tmp3_;
		_tmp0_ = vala_void_type_new (NULL);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_pointer_type_new ((ValaDataType*) _tmp1_, NULL);
		result = (_tmp3_ = (ValaDataType*) _tmp2_, _vala_code_node_unref0 (_tmp1_), _tmp3_);
		_vala_code_node_unref0 (sym);
		return result;
	}
	_tmp4_ = g_str_has_prefix (type_arg, "unowned ");
	if (_tmp4_) {
		glong _tmp5_;
		const gchar* _tmp6_ = NULL;
		_tmp5_ = strlen ("unowned ");
		_tmp6_ = string_offset (type_arg, _tmp5_);
		type_arg = _tmp6_;
		is_unowned = TRUE;
	}
	_tmp8_ = _tmp7_ = g_strsplit (type_arg, ".", 0);
	{
		gchar** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = _tmp8_;
		s_collection_length1 = _vala_array_length (_tmp7_);
		for (s_it = 0; s_it < _vala_array_length (_tmp7_); s_it = s_it + 1) {
			const gchar* s;
			s = s_collection[s_it];
			{
				ValaUnresolvedSymbol* _tmp9_ = NULL;
				ValaUnresolvedSymbol* _tmp10_;
				_tmp9_ = vala_unresolved_symbol_new (sym, s, NULL);
				_tmp10_ = _tmp9_;
				_vala_code_node_unref0 (sym);
				sym = _tmp10_;
			}
		}
		s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp11_ = vala_unresolved_type_new_from_symbol (sym, NULL);
	arg_type = _tmp11_;
	vala_data_type_set_value_owned ((ValaDataType*) arg_type, !is_unowned);
	result = (ValaDataType*) arg_type;
	_vala_code_node_unref0 (sym);
	return result;
}


static ValaMethod* vala_gidl_parser_create_method (ValaGIdlParser* self, const gchar* name, const gchar* symbol, GIdlNodeParam* res, GList* parameters, gboolean is_constructor, gboolean is_interface) {
	ValaMethod* result = NULL;
	ValaDataType* return_type;
	ValaMethod* m;
	gboolean _tmp2_ = FALSE;
	gboolean add_ellipsis;
	gboolean suppress_throws;
	gchar* error_types;
	gint _tmp36_;
	gchar** _tmp37_ = NULL;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp38_;
	gchar** attributes;
	gboolean first;
	ValaParameter* last_param;
	ValaDataType* last_param_type;
	gboolean _tmp304_ = FALSE;
	gboolean _tmp314_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	return_type = NULL;
	if (res != NULL) {
		ValaDataType* _tmp0_ = NULL;
		ValaDataType* _tmp1_;
		_tmp0_ = vala_gidl_parser_parse_param (self, res, NULL);
		_tmp1_ = _tmp0_;
		_vala_code_node_unref0 (return_type);
		return_type = _tmp1_;
	}
	m = NULL;
	if (!is_interface) {
		gboolean _tmp3_ = FALSE;
		if (is_constructor) {
			_tmp3_ = TRUE;
		} else {
			gboolean _tmp4_;
			_tmp4_ = g_str_has_prefix (name, "new");
			_tmp3_ = _tmp4_;
		}
		_tmp2_ = _tmp3_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaCreationMethod* _tmp5_ = NULL;
		ValaMethod* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gboolean _tmp13_ = FALSE;
		_tmp5_ = vala_creation_method_new (NULL, name, self->priv->current_source_reference, NULL);
		_tmp6_ = (ValaMethod*) _tmp5_;
		_vala_code_node_unref0 (m);
		m = _tmp6_;
		vala_method_set_has_construct_function (m, FALSE);
		_tmp7_ = vala_symbol_get_name ((ValaSymbol*) m);
		if (g_strcmp0 (_tmp7_, "new") == 0) {
			vala_symbol_set_name ((ValaSymbol*) m, NULL);
		} else {
			const gchar* _tmp8_ = NULL;
			gboolean _tmp9_;
			_tmp8_ = vala_symbol_get_name ((ValaSymbol*) m);
			_tmp9_ = g_str_has_prefix (_tmp8_, "new_");
			if (_tmp9_) {
				const gchar* _tmp10_ = NULL;
				glong _tmp11_;
				const gchar* _tmp12_ = NULL;
				_tmp10_ = vala_symbol_get_name ((ValaSymbol*) m);
				_tmp11_ = strlen ("new_");
				_tmp12_ = string_offset (_tmp10_, _tmp11_);
				vala_symbol_set_name ((ValaSymbol*) m, _tmp12_);
			}
		}
		if (VALA_IS_CLASS (self->priv->current_data_type)) {
			_tmp13_ = res != NULL;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			gboolean _tmp18_;
			_tmp14_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strdup_printf ("%s*", _tmp15_);
			_tmp17_ = _tmp16_;
			if ((_tmp18_ = g_strcmp0 (_tmp17_, res->type->unparsed) != 0, _g_free0 (_tmp17_), _g_free0 (_tmp15_), _tmp18_)) {
				vala_creation_method_set_custom_return_type_cname (VALA_CREATION_METHOD (m), res->type->unparsed);
			}
		}
	} else {
		ValaMethod* _tmp19_ = NULL;
		ValaMethod* _tmp20_;
		_tmp19_ = vala_method_new (name, return_type, self->priv->current_source_reference, NULL);
		_tmp20_ = _tmp19_;
		_vala_code_node_unref0 (m);
		m = _tmp20_;
	}
	vala_symbol_set_access ((ValaSymbol*) m, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	if (self->priv->current_type_symbol_set != NULL) {
		vala_collection_add ((ValaCollection*) self->priv->current_type_symbol_set, name);
	}
	if (self->priv->current_data_type != NULL) {
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		gint _tmp25_;
		gchar** _tmp26_ = NULL;
		gchar** _tmp27_;
		gint sig_attributes_length1;
		gint _sig_attributes_size_;
		gchar** _tmp28_;
		gchar** sig_attributes;
		_tmp21_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strdup_printf ("%s::%s", _tmp22_, name);
		_tmp24_ = _tmp23_;
		_tmp26_ = vala_gidl_parser_get_attributes (self, _tmp24_, &_tmp25_);
		_tmp28_ = (_tmp27_ = _tmp26_, _g_free0 (_tmp24_), _g_free0 (_tmp22_), _tmp27_);
		sig_attributes_length1 = _tmp25_;
		_sig_attributes_size_ = sig_attributes_length1;
		sig_attributes = _tmp28_;
		if (sig_attributes != NULL) {
			{
				gchar** attr_collection;
				int attr_collection_length1;
				int attr_it;
				attr_collection = sig_attributes;
				attr_collection_length1 = sig_attributes_length1;
				for (attr_it = 0; attr_it < sig_attributes_length1; attr_it = attr_it + 1) {
					gchar* _tmp29_;
					gchar* attr;
					_tmp29_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp29_;
					{
						gchar** _tmp30_;
						gchar** _tmp31_ = NULL;
						gint nv_length1;
						gint _nv_size_;
						gchar** _tmp32_;
						gchar** nv;
						gboolean _tmp33_ = FALSE;
						_tmp31_ = _tmp30_ = g_strsplit (attr, "=", 2);
						_tmp32_ = _tmp31_;
						nv_length1 = _vala_array_length (_tmp30_);
						_nv_size_ = nv_length1;
						nv = _tmp32_;
						if (g_strcmp0 (nv[0], "has_emitter") == 0) {
							gchar* _tmp34_ = NULL;
							gchar* _tmp35_;
							_tmp34_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp35_ = _tmp34_;
							_tmp33_ = g_strcmp0 (_tmp35_, "1") == 0;
							_g_free0 (_tmp35_);
						} else {
							_tmp33_ = FALSE;
						}
						if (_tmp33_) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							sig_attributes = (_vala_array_free (sig_attributes, sig_attributes_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (m);
							_vala_code_node_unref0 (return_type);
							return result;
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		sig_attributes = (_vala_array_free (sig_attributes, sig_attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	add_ellipsis = FALSE;
	suppress_throws = FALSE;
	error_types = NULL;
	_tmp37_ = vala_gidl_parser_get_attributes (self, symbol, &_tmp36_);
	_tmp38_ = _tmp37_;
	attributes_length1 = _tmp36_;
	_attributes_size_ = attributes_length1;
	attributes = _tmp38_;
	if (attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp39_;
				gchar* attr;
				_tmp39_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp39_;
				{
					gchar** _tmp40_;
					gchar** _tmp41_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp42_;
					gchar** nv;
					_tmp41_ = _tmp40_ = g_strsplit (attr, "=", 2);
					_tmp42_ = _tmp41_;
					nv_length1 = _vala_array_length (_tmp40_);
					_nv_size_ = nv_length1;
					nv = _tmp42_;
					if (g_strcmp0 (nv[0], "name") == 0) {
						const gchar* _tmp43_ = NULL;
						gchar* _tmp44_ = NULL;
						gchar* _tmp45_;
						_tmp43_ = vala_symbol_get_name ((ValaSymbol*) m);
						vala_method_set_cname (m, _tmp43_);
						_tmp44_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp45_ = _tmp44_;
						vala_symbol_set_name ((ValaSymbol*) m, _tmp45_);
						_g_free0 (_tmp45_);
					} else {
						if (g_strcmp0 (nv[0], "hidden") == 0) {
							gchar* _tmp46_ = NULL;
							gchar* _tmp47_;
							gboolean _tmp48_;
							_tmp46_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp47_ = _tmp46_;
							if ((_tmp48_ = g_strcmp0 (_tmp47_, "1") == 0, _g_free0 (_tmp47_), _tmp48_)) {
								result = NULL;
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
								attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (error_types);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (return_type);
								return result;
							}
						} else {
							if (g_strcmp0 (nv[0], "ellipsis") == 0) {
								gchar* _tmp49_ = NULL;
								gchar* _tmp50_;
								gboolean _tmp51_;
								_tmp49_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp50_ = _tmp49_;
								if ((_tmp51_ = g_strcmp0 (_tmp50_, "1") == 0, _g_free0 (_tmp50_), _tmp51_)) {
									add_ellipsis = TRUE;
								}
							} else {
								if (g_strcmp0 (nv[0], "printf_format") == 0) {
									gchar* _tmp52_ = NULL;
									gchar* _tmp53_;
									gboolean _tmp54_;
									_tmp52_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp53_ = _tmp52_;
									if ((_tmp54_ = g_strcmp0 (_tmp53_, "1") == 0, _g_free0 (_tmp53_), _tmp54_)) {
										vala_method_set_printf_format (m, TRUE);
									}
								} else {
									if (g_strcmp0 (nv[0], "transfer_ownership") == 0) {
										gchar* _tmp55_ = NULL;
										gchar* _tmp56_;
										gboolean _tmp57_;
										_tmp55_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp56_ = _tmp55_;
										if ((_tmp57_ = g_strcmp0 (_tmp56_, "1") == 0, _g_free0 (_tmp56_), _tmp57_)) {
											vala_data_type_set_value_owned (return_type, TRUE);
										}
									} else {
										if (g_strcmp0 (nv[0], "nullable") == 0) {
											gchar* _tmp58_ = NULL;
											gchar* _tmp59_;
											gboolean _tmp60_;
											_tmp58_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp59_ = _tmp58_;
											if ((_tmp60_ = g_strcmp0 (_tmp59_, "1") == 0, _g_free0 (_tmp59_), _tmp60_)) {
												vala_data_type_set_nullable (return_type, TRUE);
											}
										} else {
											if (g_strcmp0 (nv[0], "sentinel") == 0) {
												gchar* _tmp61_ = NULL;
												gchar* _tmp62_;
												_tmp61_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp62_ = _tmp61_;
												vala_method_set_sentinel (m, _tmp62_);
												_g_free0 (_tmp62_);
											} else {
												if (g_strcmp0 (nv[0], "is_array") == 0) {
													gchar* _tmp63_ = NULL;
													gchar* _tmp64_;
													gboolean _tmp65_;
													_tmp63_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp64_ = _tmp63_;
													if ((_tmp65_ = g_strcmp0 (_tmp64_, "1") == 0, _g_free0 (_tmp64_), _tmp65_)) {
														ValaSourceReference* _tmp66_ = NULL;
														ValaArrayType* _tmp67_ = NULL;
														ValaDataType* _tmp68_;
														_tmp66_ = vala_code_node_get_source_reference ((ValaCodeNode*) return_type);
														_tmp67_ = vala_array_type_new (return_type, 1, _tmp66_);
														_tmp68_ = (ValaDataType*) _tmp67_;
														_vala_code_node_unref0 (return_type);
														return_type = _tmp68_;
														vala_method_set_return_type (m, return_type);
													}
												} else {
													if (g_strcmp0 (nv[0], "throws") == 0) {
														gchar* _tmp69_ = NULL;
														gchar* _tmp70_;
														gboolean _tmp71_;
														_tmp69_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp70_ = _tmp69_;
														if ((_tmp71_ = g_strcmp0 (_tmp70_, "0") == 0, _g_free0 (_tmp70_), _tmp71_)) {
															suppress_throws = TRUE;
														}
													} else {
														if (g_strcmp0 (nv[0], "error_types") == 0) {
															gchar* _tmp72_ = NULL;
															gchar* _tmp73_;
															_tmp72_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp73_ = _tmp72_;
															_g_free0 (error_types);
															error_types = _tmp73_;
														} else {
															if (g_strcmp0 (nv[0], "no_array_length") == 0) {
																gchar* _tmp74_ = NULL;
																gchar* _tmp75_;
																gboolean _tmp76_;
																_tmp74_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp75_ = _tmp74_;
																if ((_tmp76_ = g_strcmp0 (_tmp75_, "1") == 0, _g_free0 (_tmp75_), _tmp76_)) {
																	vala_method_set_no_array_length (m, TRUE);
																}
															} else {
																if (g_strcmp0 (nv[0], "array_null_terminated") == 0) {
																	gchar* _tmp77_ = NULL;
																	gchar* _tmp78_;
																	gboolean _tmp79_;
																	_tmp77_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp78_ = _tmp77_;
																	if ((_tmp79_ = g_strcmp0 (_tmp78_, "1") == 0, _g_free0 (_tmp78_), _tmp79_)) {
																		vala_method_set_no_array_length (m, TRUE);
																		vala_method_set_array_null_terminated (m, TRUE);
																	}
																} else {
																	if (g_strcmp0 (nv[0], "array_length_type") == 0) {
																		gchar* _tmp80_ = NULL;
																		gchar* _tmp81_;
																		_tmp80_ = vala_gidl_parser_eval (self, nv[1]);
																		_tmp81_ = _tmp80_;
																		vala_method_set_array_length_type (m, _tmp81_);
																		_g_free0 (_tmp81_);
																	} else {
																		if (g_strcmp0 (nv[0], "type_name") == 0) {
																			gchar* _tmp82_ = NULL;
																			gchar* _tmp83_;
																			ValaUnresolvedSymbol* _tmp84_ = NULL;
																			ValaUnresolvedSymbol* _tmp85_;
																			ValaUnresolvedSymbol* sym;
																			_tmp82_ = vala_gidl_parser_eval (self, nv[1]);
																			_tmp83_ = _tmp82_;
																			_tmp84_ = vala_unresolved_symbol_new (NULL, _tmp83_, NULL);
																			sym = (_tmp85_ = _tmp84_, _g_free0 (_tmp83_), _tmp85_);
																			if (VALA_IS_UNRESOLVED_TYPE (return_type)) {
																				vala_unresolved_type_set_unresolved_symbol (VALA_UNRESOLVED_TYPE (return_type), sym);
																			} else {
																				ValaSourceReference* _tmp86_ = NULL;
																				ValaUnresolvedType* _tmp87_ = NULL;
																				ValaDataType* _tmp88_;
																				_tmp86_ = vala_code_node_get_source_reference ((ValaCodeNode*) return_type);
																				_tmp87_ = vala_unresolved_type_new_from_symbol (sym, _tmp86_);
																				_tmp88_ = (ValaDataType*) _tmp87_;
																				_vala_code_node_unref0 (return_type);
																				return_type = _tmp88_;
																				vala_method_set_return_type (m, return_type);
																			}
																			_vala_code_node_unref0 (sym);
																		} else {
																			if (g_strcmp0 (nv[0], "type_arguments") == 0) {
																				gchar* _tmp89_ = NULL;
																				gchar* _tmp90_;
																				gchar** _tmp91_;
																				gchar** _tmp92_ = NULL;
																				gchar** _tmp93_;
																				gint type_args_length1;
																				gint _type_args_size_;
																				gchar** _tmp94_;
																				gchar** type_args;
																				_tmp89_ = vala_gidl_parser_eval (self, nv[1]);
																				_tmp90_ = _tmp89_;
																				_tmp92_ = _tmp91_ = g_strsplit (_tmp90_, ",", 0);
																				_tmp94_ = (_tmp93_ = _tmp92_, _g_free0 (_tmp90_), _tmp93_);
																				type_args_length1 = _vala_array_length (_tmp91_);
																				_type_args_size_ = type_args_length1;
																				type_args = _tmp94_;
																				{
																					gchar** type_arg_collection;
																					int type_arg_collection_length1;
																					int type_arg_it;
																					type_arg_collection = type_args;
																					type_arg_collection_length1 = type_args_length1;
																					for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
																						gchar* _tmp95_;
																						gchar* type_arg;
																						_tmp95_ = g_strdup (type_arg_collection[type_arg_it]);
																						type_arg = _tmp95_;
																						{
																							ValaDataType* _tmp96_ = NULL;
																							ValaDataType* _tmp97_;
																							_tmp96_ = vala_gidl_parser_get_type_from_string (self, type_arg);
																							_tmp97_ = _tmp96_;
																							vala_data_type_add_type_argument (return_type, _tmp97_);
																							_vala_code_node_unref0 (_tmp97_);
																							_g_free0 (type_arg);
																						}
																					}
																				}
																				type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
																			} else {
																				if (g_strcmp0 (nv[0], "deprecated") == 0) {
																					gchar* _tmp98_ = NULL;
																					gchar* _tmp99_;
																					gboolean _tmp100_;
																					_tmp98_ = vala_gidl_parser_eval (self, nv[1]);
																					_tmp99_ = _tmp98_;
																					if ((_tmp100_ = g_strcmp0 (_tmp99_, "1") == 0, _g_free0 (_tmp99_), _tmp100_)) {
																						vala_symbol_set_deprecated ((ValaSymbol*) m, TRUE);
																					}
																				} else {
																					if (g_strcmp0 (nv[0], "replacement") == 0) {
																						gchar* _tmp101_ = NULL;
																						gchar* _tmp102_;
																						_tmp101_ = vala_gidl_parser_eval (self, nv[1]);
																						_tmp102_ = _tmp101_;
																						vala_symbol_set_replacement ((ValaSymbol*) m, _tmp102_);
																						_g_free0 (_tmp102_);
																					} else {
																						if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
																							gchar* _tmp103_ = NULL;
																							gchar* _tmp104_;
																							_tmp103_ = vala_gidl_parser_eval (self, nv[1]);
																							_tmp104_ = _tmp103_;
																							vala_symbol_set_deprecated_since ((ValaSymbol*) m, _tmp104_);
																							_g_free0 (_tmp104_);
																						} else {
																							if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
																								gchar* _tmp105_ = NULL;
																								gchar* _tmp106_;
																								_tmp105_ = vala_gidl_parser_eval (self, nv[1]);
																								_tmp106_ = _tmp105_;
																								vala_symbol_add_cheader_filename ((ValaSymbol*) m, _tmp106_);
																								_g_free0 (_tmp106_);
																							} else {
																								if (g_strcmp0 (nv[0], "abstract") == 0) {
																									gchar* _tmp107_ = NULL;
																									gchar* _tmp108_;
																									gboolean _tmp109_;
																									_tmp107_ = vala_gidl_parser_eval (self, nv[1]);
																									_tmp108_ = _tmp107_;
																									if ((_tmp109_ = g_strcmp0 (_tmp108_, "1") == 0, _g_free0 (_tmp108_), _tmp109_)) {
																										vala_method_set_is_abstract (m, TRUE);
																									}
																								} else {
																									if (g_strcmp0 (nv[0], "virtual") == 0) {
																										gchar* _tmp110_ = NULL;
																										gchar* _tmp111_;
																										gboolean _tmp112_;
																										_tmp110_ = vala_gidl_parser_eval (self, nv[1]);
																										_tmp111_ = _tmp110_;
																										if ((_tmp112_ = g_strcmp0 (_tmp111_, "1") == 0, _g_free0 (_tmp111_), _tmp112_)) {
																											vala_method_set_is_virtual (m, TRUE);
																										}
																									} else {
																										if (g_strcmp0 (nv[0], "vfunc_name") == 0) {
																											gchar* _tmp113_ = NULL;
																											gchar* _tmp114_;
																											_tmp113_ = vala_gidl_parser_eval (self, nv[1]);
																											_tmp114_ = _tmp113_;
																											vala_method_set_vfunc_name (m, _tmp114_);
																											_g_free0 (_tmp114_);
																										} else {
																											if (g_strcmp0 (nv[0], "finish_name") == 0) {
																												gchar* _tmp115_ = NULL;
																												gchar* _tmp116_;
																												_tmp115_ = vala_gidl_parser_eval (self, nv[1]);
																												_tmp116_ = _tmp115_;
																												vala_method_set_finish_cname (m, _tmp116_);
																												_g_free0 (_tmp116_);
																											} else {
																												if (g_strcmp0 (nv[0], "async") == 0) {
																													gchar* _tmp117_ = NULL;
																													gchar* _tmp118_;
																													gboolean _tmp119_;
																													_tmp117_ = vala_gidl_parser_eval (self, nv[1]);
																													_tmp118_ = _tmp117_;
																													if ((_tmp119_ = g_strcmp0 (_tmp118_, "1") == 0, _g_free0 (_tmp118_), _tmp119_)) {
																														vala_method_set_coroutine (m, TRUE);
																													}
																												} else {
																													if (g_strcmp0 (nv[0], "parent") == 0) {
																														gchar* _tmp120_ = NULL;
																														gchar* _tmp121_;
																														ValaSymbol* _tmp122_ = NULL;
																														ValaSymbol* _tmp123_;
																														ValaSymbol* container;
																														gchar* _tmp124_ = NULL;
																														gchar* prefix;
																														gboolean _tmp125_;
																														_tmp120_ = vala_gidl_parser_eval (self, nv[1]);
																														_tmp121_ = _tmp120_;
																														_tmp122_ = vala_gidl_parser_get_container_from_name (self, _tmp121_);
																														container = (_tmp123_ = _tmp122_, _g_free0 (_tmp121_), _tmp123_);
																														_tmp124_ = vala_symbol_get_lower_case_cprefix (container);
																														prefix = _tmp124_;
																														_tmp125_ = g_str_has_prefix (symbol, prefix);
																														if (_tmp125_) {
																															const gchar* _tmp126_ = NULL;
																															glong _tmp127_;
																															const gchar* _tmp128_ = NULL;
																															_tmp126_ = vala_symbol_get_name ((ValaSymbol*) m);
																															vala_method_set_cname (m, _tmp126_);
																															_tmp127_ = strlen (prefix);
																															_tmp128_ = string_offset (symbol, _tmp127_);
																															vala_symbol_set_name ((ValaSymbol*) m, _tmp128_);
																														}
																														_g_free0 (prefix);
																														_vala_code_node_unref0 (container);
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	vala_method_set_cname (m, symbol);
	first = TRUE;
	last_param = NULL;
	last_param_type = NULL;
	{
		GList* param_collection;
		GList* param_it;
		param_collection = parameters;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNode* param_node;
				gboolean _tmp154_ = FALSE;
				gboolean _tmp158_ = FALSE;
				gchar* _tmp162_;
				gchar* param_name;
				ValaParameterDirection direction = 0;
				ValaParameterDirection _tmp167_;
				ValaDataType* _tmp168_ = NULL;
				ValaDataType* param_type;
				ValaParameter* _tmp169_ = NULL;
				ValaParameter* p;
				gboolean hide_param;
				gboolean show_param;
				gboolean set_array_length_pos;
				gdouble array_length_pos;
				gboolean set_delegate_target_pos;
				gdouble delegate_target_pos;
				gboolean array_requested;
				gboolean out_requested;
				gchar* _tmp170_ = NULL;
				gchar* _tmp171_;
				gint _tmp172_;
				gchar** _tmp173_ = NULL;
				gchar** _tmp174_;
				gboolean _tmp290_ = FALSE;
				gboolean _tmp299_ = FALSE;
				ValaParameter* _tmp300_;
				ValaParameter* _tmp301_;
				ValaDataType* _tmp302_;
				ValaDataType* _tmp303_;
				param_node = (GIdlNode*) param;
				if (first) {
					gboolean _tmp129_ = FALSE;
					gboolean _tmp130_ = FALSE;
					gboolean _tmp131_ = FALSE;
					first = FALSE;
					if (!VALA_IS_CREATION_METHOD (m)) {
						_tmp131_ = self->priv->current_data_type != NULL;
					} else {
						_tmp131_ = FALSE;
					}
					if (_tmp131_) {
						_tmp130_ = param->type->is_interface;
					} else {
						_tmp130_ = FALSE;
					}
					if (_tmp130_) {
						gboolean _tmp132_ = FALSE;
						if (g_strcmp0 (param_node->name, "self") == 0) {
							_tmp132_ = TRUE;
						} else {
							gchar* _tmp133_ = NULL;
							gchar* _tmp134_;
							gboolean _tmp135_;
							_tmp133_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
							_tmp134_ = _tmp133_;
							_tmp135_ = g_str_has_suffix (param->type->interface, _tmp134_);
							_tmp132_ = _tmp135_;
							_g_free0 (_tmp134_);
						}
						_tmp129_ = _tmp132_;
					} else {
						_tmp129_ = FALSE;
					}
					if (_tmp129_) {
						continue;
					} else {
						gboolean _tmp136_ = FALSE;
						gboolean _tmp137_ = FALSE;
						gboolean _tmp138_ = FALSE;
						if (!VALA_IS_CREATION_METHOD (m)) {
							_tmp138_ = self->priv->current_data_type != NULL;
						} else {
							_tmp138_ = FALSE;
						}
						if (_tmp138_) {
							_tmp137_ = param->type->is_interface;
						} else {
							_tmp137_ = FALSE;
						}
						if (_tmp137_) {
							gboolean _tmp139_ = FALSE;
							if (g_strcmp0 (param_node->name, "klass") == 0) {
								_tmp139_ = TRUE;
							} else {
								gchar* _tmp140_ = NULL;
								gchar* _tmp141_;
								gchar* _tmp142_ = NULL;
								gchar* _tmp143_;
								gboolean _tmp144_;
								_tmp140_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
								_tmp141_ = _tmp140_;
								_tmp142_ = g_strdup_printf ("%sClass", _tmp141_);
								_tmp143_ = _tmp142_;
								_tmp144_ = g_str_has_suffix (param->type->interface, _tmp143_);
								_tmp139_ = _tmp144_;
								_g_free0 (_tmp143_);
								_g_free0 (_tmp141_);
							}
							_tmp136_ = _tmp139_;
						} else {
							_tmp136_ = FALSE;
						}
						if (_tmp136_) {
							const gchar* _tmp145_ = NULL;
							gboolean _tmp146_;
							vala_method_set_binding (m, VALA_MEMBER_BINDING_CLASS);
							_tmp145_ = vala_symbol_get_name ((ValaSymbol*) m);
							_tmp146_ = g_str_has_prefix (_tmp145_, "class_");
							if (_tmp146_) {
								const gchar* _tmp147_ = NULL;
								glong _tmp148_;
								const gchar* _tmp149_ = NULL;
								glong _tmp150_;
								glong _tmp151_;
								gchar* _tmp152_ = NULL;
								gchar* _tmp153_;
								_tmp147_ = vala_symbol_get_name ((ValaSymbol*) m);
								_tmp148_ = strlen ("class_");
								_tmp149_ = vala_symbol_get_name ((ValaSymbol*) m);
								_tmp150_ = strlen (_tmp149_);
								_tmp151_ = strlen ("class_");
								_tmp152_ = string_substring (_tmp147_, _tmp148_, _tmp150_ - _tmp151_);
								_tmp153_ = _tmp152_;
								vala_symbol_set_name ((ValaSymbol*) m, _tmp153_);
								_g_free0 (_tmp153_);
							}
							continue;
						} else {
							vala_method_set_binding (m, VALA_MEMBER_BINDING_STATIC);
						}
					}
				}
				if (g_strcmp0 (param->type->interface, "GAsyncReadyCallback") == 0) {
					gboolean _tmp155_ = FALSE;
					gboolean _tmp156_;
					_tmp156_ = g_str_has_suffix (symbol, "_async");
					if (_tmp156_) {
						_tmp155_ = TRUE;
					} else {
						gboolean _tmp157_;
						_tmp157_ = vala_method_get_coroutine (m);
						_tmp155_ = _tmp157_;
					}
					_tmp154_ = _tmp155_;
				} else {
					_tmp154_ = FALSE;
				}
				if (_tmp154_) {
					vala_method_set_coroutine (m, TRUE);
					continue;
				}
				if (suppress_throws == FALSE) {
					gboolean _tmp159_;
					_tmp159_ = vala_gidl_parser_param_is_exception (self, param);
					_tmp158_ = _tmp159_;
				} else {
					_tmp158_ = FALSE;
				}
				if (_tmp158_) {
					if (error_types == NULL) {
						ValaDataType* _tmp160_ = NULL;
						ValaDataType* _tmp161_;
						_tmp160_ = vala_gidl_parser_parse_type (self, param->type, NULL);
						_tmp161_ = _tmp160_;
						vala_code_node_add_error_type ((ValaCodeNode*) m, _tmp161_);
						_vala_code_node_unref0 (_tmp161_);
					}
					continue;
				}
				_tmp162_ = g_strdup (param_node->name);
				param_name = _tmp162_;
				if (g_strcmp0 (param_name, "result") == 0) {
					gchar* _tmp163_;
					gchar* _tmp164_;
					_tmp163_ = g_strdup ("_result");
					_tmp164_ = _tmp163_;
					_g_free0 (param_name);
					param_name = _tmp164_;
				} else {
					if (g_strcmp0 (param_name, "string") == 0) {
						gchar* _tmp165_;
						gchar* _tmp166_;
						_tmp165_ = g_strdup ("str");
						_tmp166_ = _tmp165_;
						_g_free0 (param_name);
						param_name = _tmp166_;
					}
				}
				_tmp168_ = vala_gidl_parser_parse_param (self, param, &_tmp167_);
				direction = _tmp167_;
				param_type = _tmp168_;
				_tmp169_ = vala_parameter_new (param_name, param_type, NULL);
				p = _tmp169_;
				vala_parameter_set_direction (p, direction);
				hide_param = FALSE;
				show_param = FALSE;
				set_array_length_pos = FALSE;
				array_length_pos = (gdouble) 0;
				set_delegate_target_pos = FALSE;
				delegate_target_pos = (gdouble) 0;
				array_requested = FALSE;
				out_requested = FALSE;
				_tmp170_ = g_strdup_printf ("%s.%s", symbol, param_node->name);
				_tmp171_ = _tmp170_;
				_tmp173_ = vala_gidl_parser_get_attributes (self, _tmp171_, &_tmp172_);
				_tmp174_ = _tmp173_;
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				attributes_length1 = _tmp172_;
				_attributes_size_ = attributes_length1;
				attributes = _tmp174_;
				_g_free0 (_tmp171_);
				if (attributes != NULL) {
					{
						gchar** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = attributes;
						attr_collection_length1 = attributes_length1;
						for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
							gchar* _tmp175_;
							gchar* attr;
							_tmp175_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp175_;
							{
								gchar** _tmp176_;
								gchar** _tmp177_ = NULL;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp178_;
								gchar** nv;
								_tmp177_ = _tmp176_ = g_strsplit (attr, "=", 2);
								_tmp178_ = _tmp177_;
								nv_length1 = _vala_array_length (_tmp176_);
								_nv_size_ = nv_length1;
								nv = _tmp178_;
								if (g_strcmp0 (nv[0], "is_array") == 0) {
									gchar* _tmp179_ = NULL;
									gchar* _tmp180_;
									gboolean _tmp181_;
									_tmp179_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp180_ = _tmp179_;
									if ((_tmp181_ = g_strcmp0 (_tmp180_, "1") == 0, _g_free0 (_tmp180_), _tmp181_)) {
										ValaSourceReference* _tmp182_ = NULL;
										ValaArrayType* _tmp183_ = NULL;
										ValaDataType* _tmp184_;
										_tmp182_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
										_tmp183_ = vala_array_type_new (param_type, 1, _tmp182_);
										_tmp184_ = (ValaDataType*) _tmp183_;
										_vala_code_node_unref0 (param_type);
										param_type = _tmp184_;
										vala_variable_set_variable_type ((ValaVariable*) p, param_type);
										if (!out_requested) {
											vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_IN);
										}
										array_requested = TRUE;
									}
								} else {
									if (g_strcmp0 (nv[0], "is_out") == 0) {
										gchar* _tmp185_ = NULL;
										gchar* _tmp186_;
										gboolean _tmp187_;
										_tmp185_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp186_ = _tmp185_;
										if ((_tmp187_ = g_strcmp0 (_tmp186_, "1") == 0, _g_free0 (_tmp186_), _tmp187_)) {
											gboolean _tmp188_ = FALSE;
											vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_OUT);
											out_requested = TRUE;
											if (!array_requested) {
												_tmp188_ = VALA_IS_ARRAY_TYPE (param_type);
											} else {
												_tmp188_ = FALSE;
											}
											if (_tmp188_) {
												ValaArrayType* _tmp189_;
												ValaArrayType* array_type;
												ValaDataType* _tmp190_ = NULL;
												ValaDataType* _tmp191_;
												ValaDataType* _tmp192_;
												_tmp189_ = _vala_code_node_ref0 (VALA_ARRAY_TYPE (param_type));
												array_type = _tmp189_;
												_tmp190_ = vala_array_type_get_element_type (array_type);
												_tmp191_ = _vala_code_node_ref0 (_tmp190_);
												_tmp192_ = _tmp191_;
												_vala_code_node_unref0 (param_type);
												param_type = _tmp192_;
												vala_variable_set_variable_type ((ValaVariable*) p, param_type);
												_vala_code_node_unref0 (array_type);
											}
										}
									} else {
										if (g_strcmp0 (nv[0], "is_ref") == 0) {
											gchar* _tmp193_ = NULL;
											gchar* _tmp194_;
											gboolean _tmp195_;
											_tmp193_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp194_ = _tmp193_;
											if ((_tmp195_ = g_strcmp0 (_tmp194_, "1") == 0, _g_free0 (_tmp194_), _tmp195_)) {
												gboolean _tmp196_ = FALSE;
												vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_REF);
												if (!array_requested) {
													_tmp196_ = VALA_IS_ARRAY_TYPE (param_type);
												} else {
													_tmp196_ = FALSE;
												}
												if (_tmp196_) {
													ValaArrayType* _tmp197_;
													ValaArrayType* array_type;
													ValaDataType* _tmp198_ = NULL;
													ValaDataType* _tmp199_;
													ValaDataType* _tmp200_;
													_tmp197_ = _vala_code_node_ref0 (VALA_ARRAY_TYPE (param_type));
													array_type = _tmp197_;
													_tmp198_ = vala_array_type_get_element_type (array_type);
													_tmp199_ = _vala_code_node_ref0 (_tmp198_);
													_tmp200_ = _tmp199_;
													_vala_code_node_unref0 (param_type);
													param_type = _tmp200_;
													vala_variable_set_variable_type ((ValaVariable*) p, param_type);
													_vala_code_node_unref0 (array_type);
												}
											}
										} else {
											if (g_strcmp0 (nv[0], "nullable") == 0) {
												gchar* _tmp201_ = NULL;
												gchar* _tmp202_;
												gboolean _tmp203_;
												_tmp201_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp202_ = _tmp201_;
												if ((_tmp203_ = g_strcmp0 (_tmp202_, "1") == 0, _g_free0 (_tmp202_), _tmp203_)) {
													vala_data_type_set_nullable (param_type, TRUE);
												}
											} else {
												if (g_strcmp0 (nv[0], "transfer_ownership") == 0) {
													gchar* _tmp204_ = NULL;
													gchar* _tmp205_;
													gboolean _tmp206_;
													_tmp204_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp205_ = _tmp204_;
													if ((_tmp206_ = g_strcmp0 (_tmp205_, "1") == 0, _g_free0 (_tmp205_), _tmp206_)) {
														vala_data_type_set_value_owned (param_type, TRUE);
													}
												} else {
													if (g_strcmp0 (nv[0], "takes_ownership") == 0) {
														gchar* _tmp207_ = NULL;
														gchar* _tmp208_;
														gboolean _tmp209_;
														_tmp207_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp208_ = _tmp207_;
														if ((_tmp209_ = g_strcmp0 (_tmp208_, "1") == 0, _g_free0 (_tmp208_), _tmp209_)) {
															vala_data_type_set_value_owned (param_type, TRUE);
														}
													} else {
														if (g_strcmp0 (nv[0], "value_owned") == 0) {
															gchar* _tmp210_ = NULL;
															gchar* _tmp211_;
															gboolean _tmp212_;
															_tmp210_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp211_ = _tmp210_;
															if ((_tmp212_ = g_strcmp0 (_tmp211_, "0") == 0, _g_free0 (_tmp211_), _tmp212_)) {
																vala_data_type_set_value_owned (param_type, FALSE);
															} else {
																gchar* _tmp213_ = NULL;
																gchar* _tmp214_;
																gboolean _tmp215_;
																_tmp213_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp214_ = _tmp213_;
																if ((_tmp215_ = g_strcmp0 (_tmp214_, "1") == 0, _g_free0 (_tmp214_), _tmp215_)) {
																	vala_data_type_set_value_owned (param_type, TRUE);
																}
															}
														} else {
															if (g_strcmp0 (nv[0], "hidden") == 0) {
																gchar* _tmp216_ = NULL;
																gchar* _tmp217_;
																gboolean _tmp218_;
																_tmp216_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp217_ = _tmp216_;
																if ((_tmp218_ = g_strcmp0 (_tmp217_, "1") == 0, _g_free0 (_tmp217_), _tmp218_)) {
																	hide_param = TRUE;
																} else {
																	gchar* _tmp219_ = NULL;
																	gchar* _tmp220_;
																	gboolean _tmp221_;
																	_tmp219_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp220_ = _tmp219_;
																	if ((_tmp221_ = g_strcmp0 (_tmp220_, "0") == 0, _g_free0 (_tmp220_), _tmp221_)) {
																		show_param = TRUE;
																	}
																}
															} else {
																if (g_strcmp0 (nv[0], "no_array_length") == 0) {
																	gchar* _tmp222_ = NULL;
																	gchar* _tmp223_;
																	gboolean _tmp224_;
																	_tmp222_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp223_ = _tmp222_;
																	if ((_tmp224_ = g_strcmp0 (_tmp223_, "1") == 0, _g_free0 (_tmp223_), _tmp224_)) {
																		vala_parameter_set_no_array_length (p, TRUE);
																	}
																} else {
																	if (g_strcmp0 (nv[0], "array_length_type") == 0) {
																		gchar* _tmp225_ = NULL;
																		gchar* _tmp226_;
																		_tmp225_ = vala_gidl_parser_eval (self, nv[1]);
																		_tmp226_ = _tmp225_;
																		vala_parameter_set_array_length_type (p, _tmp226_);
																		_g_free0 (_tmp226_);
																	} else {
																		if (g_strcmp0 (nv[0], "array_null_terminated") == 0) {
																			gchar* _tmp227_ = NULL;
																			gchar* _tmp228_;
																			gboolean _tmp229_;
																			_tmp227_ = vala_gidl_parser_eval (self, nv[1]);
																			_tmp228_ = _tmp227_;
																			if ((_tmp229_ = g_strcmp0 (_tmp228_, "1") == 0, _g_free0 (_tmp228_), _tmp229_)) {
																				vala_parameter_set_no_array_length (p, TRUE);
																				vala_parameter_set_array_null_terminated (p, TRUE);
																			}
																		} else {
																			if (g_strcmp0 (nv[0], "array_length_pos") == 0) {
																				gchar* _tmp230_ = NULL;
																				gchar* _tmp231_;
																				gdouble _tmp232_;
																				set_array_length_pos = TRUE;
																				_tmp230_ = vala_gidl_parser_eval (self, nv[1]);
																				_tmp231_ = _tmp230_;
																				_tmp232_ = g_ascii_strtod (_tmp231_, NULL);
																				array_length_pos = _tmp232_;
																				_g_free0 (_tmp231_);
																			} else {
																				if (g_strcmp0 (nv[0], "delegate_target_pos") == 0) {
																					gchar* _tmp233_ = NULL;
																					gchar* _tmp234_;
																					gdouble _tmp235_;
																					set_delegate_target_pos = TRUE;
																					_tmp233_ = vala_gidl_parser_eval (self, nv[1]);
																					_tmp234_ = _tmp233_;
																					_tmp235_ = g_ascii_strtod (_tmp234_, NULL);
																					delegate_target_pos = _tmp235_;
																					_g_free0 (_tmp234_);
																				} else {
																					if (g_strcmp0 (nv[0], "type_name") == 0) {
																						gchar* _tmp236_ = NULL;
																						gchar* _tmp237_;
																						ValaUnresolvedSymbol* _tmp238_ = NULL;
																						ValaUnresolvedSymbol* _tmp239_;
																						ValaUnresolvedSymbol* sym;
																						_tmp236_ = vala_gidl_parser_eval (self, nv[1]);
																						_tmp237_ = _tmp236_;
																						_tmp238_ = vala_unresolved_symbol_new (NULL, _tmp237_, NULL);
																						sym = (_tmp239_ = _tmp238_, _g_free0 (_tmp237_), _tmp239_);
																						if (VALA_IS_UNRESOLVED_TYPE (param_type)) {
																							vala_unresolved_type_set_unresolved_symbol (VALA_UNRESOLVED_TYPE (param_type), sym);
																						} else {
																							ValaSourceReference* _tmp240_ = NULL;
																							ValaUnresolvedType* _tmp241_ = NULL;
																							ValaDataType* _tmp242_;
																							_tmp240_ = vala_code_node_get_source_reference ((ValaCodeNode*) return_type);
																							_tmp241_ = vala_unresolved_type_new_from_symbol (sym, _tmp240_);
																							_tmp242_ = (ValaDataType*) _tmp241_;
																							_vala_code_node_unref0 (param_type);
																							param_type = _tmp242_;
																							vala_variable_set_variable_type ((ValaVariable*) p, param_type);
																						}
																						_vala_code_node_unref0 (sym);
																					} else {
																						if (g_strcmp0 (nv[0], "ctype") == 0) {
																							gchar* _tmp243_ = NULL;
																							gchar* _tmp244_;
																							_tmp243_ = vala_gidl_parser_eval (self, nv[1]);
																							_tmp244_ = _tmp243_;
																							vala_parameter_set_ctype (p, _tmp244_);
																							_g_free0 (_tmp244_);
																						} else {
																							if (g_strcmp0 (nv[0], "type_arguments") == 0) {
																								gchar* _tmp245_ = NULL;
																								gchar* _tmp246_;
																								gchar** _tmp247_;
																								gchar** _tmp248_ = NULL;
																								gchar** _tmp249_;
																								gint type_args_length1;
																								gint _type_args_size_;
																								gchar** _tmp250_;
																								gchar** type_args;
																								_tmp245_ = vala_gidl_parser_eval (self, nv[1]);
																								_tmp246_ = _tmp245_;
																								_tmp248_ = _tmp247_ = g_strsplit (_tmp246_, ",", 0);
																								_tmp250_ = (_tmp249_ = _tmp248_, _g_free0 (_tmp246_), _tmp249_);
																								type_args_length1 = _vala_array_length (_tmp247_);
																								_type_args_size_ = type_args_length1;
																								type_args = _tmp250_;
																								{
																									gchar** type_arg_collection;
																									int type_arg_collection_length1;
																									int type_arg_it;
																									type_arg_collection = type_args;
																									type_arg_collection_length1 = type_args_length1;
																									for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
																										gchar* _tmp251_;
																										gchar* type_arg;
																										_tmp251_ = g_strdup (type_arg_collection[type_arg_it]);
																										type_arg = _tmp251_;
																										{
																											ValaDataType* _tmp252_ = NULL;
																											ValaDataType* _tmp253_;
																											_tmp252_ = vala_gidl_parser_get_type_from_string (self, type_arg);
																											_tmp253_ = _tmp252_;
																											vala_data_type_add_type_argument (param_type, _tmp253_);
																											_vala_code_node_unref0 (_tmp253_);
																											_g_free0 (type_arg);
																										}
																									}
																								}
																								type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
																							} else {
																								if (g_strcmp0 (nv[0], "default_value") == 0) {
																									gchar* _tmp254_ = NULL;
																									gchar* val;
																									_tmp254_ = vala_gidl_parser_eval (self, nv[1]);
																									val = _tmp254_;
																									if (g_strcmp0 (val, "null") == 0) {
																										ValaSourceReference* _tmp255_ = NULL;
																										ValaNullLiteral* _tmp256_ = NULL;
																										ValaNullLiteral* _tmp257_;
																										_tmp255_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																										_tmp256_ = vala_null_literal_new (_tmp255_);
																										_tmp257_ = _tmp256_;
																										vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp257_);
																										_vala_code_node_unref0 (_tmp257_);
																									} else {
																										if (g_strcmp0 (val, "true") == 0) {
																											ValaSourceReference* _tmp258_ = NULL;
																											ValaBooleanLiteral* _tmp259_ = NULL;
																											ValaBooleanLiteral* _tmp260_;
																											_tmp258_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																											_tmp259_ = vala_boolean_literal_new (TRUE, _tmp258_);
																											_tmp260_ = _tmp259_;
																											vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp260_);
																											_vala_code_node_unref0 (_tmp260_);
																										} else {
																											if (g_strcmp0 (val, "false") == 0) {
																												ValaSourceReference* _tmp261_ = NULL;
																												ValaBooleanLiteral* _tmp262_ = NULL;
																												ValaBooleanLiteral* _tmp263_;
																												_tmp261_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																												_tmp262_ = vala_boolean_literal_new (FALSE, _tmp261_);
																												_tmp263_ = _tmp262_;
																												vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp263_);
																												_vala_code_node_unref0 (_tmp263_);
																											} else {
																												if (g_strcmp0 (val, "") == 0) {
																													ValaSourceReference* _tmp264_ = NULL;
																													ValaStringLiteral* _tmp265_ = NULL;
																													ValaStringLiteral* _tmp266_;
																													_tmp264_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																													_tmp265_ = vala_string_literal_new ("\"\"", _tmp264_);
																													_tmp266_ = _tmp265_;
																													vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp266_);
																													_vala_code_node_unref0 (_tmp266_);
																												} else {
																													const gchar* endptr;
																													glong _tmp267_;
																													const gchar* _tmp268_ = NULL;
																													const gchar* val_end;
																													const gchar* _tmp269_ = NULL;
																													endptr = NULL;
																													_tmp267_ = strlen (val);
																													_tmp268_ = string_offset (val, _tmp267_);
																													val_end = _tmp268_;
																													strtol (val, &_tmp269_, 0);
																													endptr = _tmp269_;
																													if (((glong) endptr) == ((glong) val_end)) {
																														ValaSourceReference* _tmp270_ = NULL;
																														ValaIntegerLiteral* _tmp271_ = NULL;
																														ValaIntegerLiteral* _tmp272_;
																														_tmp270_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																														_tmp271_ = vala_integer_literal_new (val, _tmp270_);
																														_tmp272_ = _tmp271_;
																														vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp272_);
																														_vala_code_node_unref0 (_tmp272_);
																													} else {
																														const gchar* _tmp273_ = NULL;
																														g_ascii_strtod (val, &_tmp273_);
																														endptr = _tmp273_;
																														if (((glong) endptr) == ((glong) val_end)) {
																															ValaSourceReference* _tmp274_ = NULL;
																															ValaRealLiteral* _tmp275_ = NULL;
																															ValaRealLiteral* _tmp276_;
																															_tmp274_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																															_tmp275_ = vala_real_literal_new (val, _tmp274_);
																															_tmp276_ = _tmp275_;
																															vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp276_);
																															_vala_code_node_unref0 (_tmp276_);
																														} else {
																															gboolean _tmp277_ = FALSE;
																															gboolean _tmp278_;
																															_tmp278_ = g_str_has_prefix (val, "\"");
																															if (_tmp278_) {
																																gboolean _tmp279_;
																																_tmp279_ = g_str_has_suffix (val, "\"");
																																_tmp277_ = _tmp279_;
																															} else {
																																_tmp277_ = FALSE;
																															}
																															if (_tmp277_) {
																																ValaSourceReference* _tmp280_ = NULL;
																																ValaStringLiteral* _tmp281_ = NULL;
																																ValaStringLiteral* _tmp282_;
																																_tmp280_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																																_tmp281_ = vala_string_literal_new (val, _tmp280_);
																																_tmp282_ = _tmp281_;
																																vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp282_);
																																_vala_code_node_unref0 (_tmp282_);
																															} else {
																																gchar** _tmp283_;
																																gchar** _tmp284_ = NULL;
																																_tmp284_ = _tmp283_ = g_strsplit (val, ".", 0);
																																{
																																	gchar** member_collection;
																																	int member_collection_length1;
																																	int member_it;
																																	member_collection = _tmp284_;
																																	member_collection_length1 = _vala_array_length (_tmp283_);
																																	for (member_it = 0; member_it < _vala_array_length (_tmp283_); member_it = member_it + 1) {
																																		gchar* _tmp285_;
																																		gchar* member;
																																		_tmp285_ = g_strdup (member_collection[member_it]);
																																		member = _tmp285_;
																																		{
																																			ValaExpression* _tmp286_ = NULL;
																																			ValaSourceReference* _tmp287_ = NULL;
																																			ValaMemberAccess* _tmp288_ = NULL;
																																			ValaMemberAccess* _tmp289_;
																																			_tmp286_ = vala_variable_get_initializer ((ValaVariable*) p);
																																			_tmp287_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																																			_tmp288_ = vala_member_access_new (_tmp286_, member, _tmp287_);
																																			_tmp289_ = _tmp288_;
																																			vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp289_);
																																			_vala_code_node_unref0 (_tmp289_);
																																			_g_free0 (member);
																																		}
																																	}
																																	member_collection = (_vala_array_free (member_collection, member_collection_length1, (GDestroyNotify) g_free), NULL);
																																}
																															}
																														}
																													}
																												}
																											}
																										}
																									}
																									_g_free0 (val);
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				if (last_param != NULL) {
					const gchar* _tmp291_ = NULL;
					const gchar* _tmp292_ = NULL;
					gchar* _tmp293_;
					_tmp291_ = vala_symbol_get_name ((ValaSymbol*) p);
					_tmp292_ = vala_symbol_get_name ((ValaSymbol*) last_param);
					_tmp293_ = g_strconcat ("n_", _tmp292_, NULL);
					_tmp290_ = g_strcmp0 (_tmp291_, _tmp293_) == 0;
					_g_free0 (_tmp293_);
				} else {
					_tmp290_ = FALSE;
				}
				if (_tmp290_) {
					if (!VALA_IS_ARRAY_TYPE (last_param_type)) {
						ValaSourceReference* _tmp294_ = NULL;
						ValaArrayType* _tmp295_ = NULL;
						ValaDataType* _tmp296_;
						_tmp294_ = vala_code_node_get_source_reference ((ValaCodeNode*) last_param_type);
						_tmp295_ = vala_array_type_new (last_param_type, 1, _tmp294_);
						_tmp296_ = (ValaDataType*) _tmp295_;
						_vala_code_node_unref0 (last_param_type);
						last_param_type = _tmp296_;
						vala_variable_set_variable_type ((ValaVariable*) last_param, last_param_type);
						vala_parameter_set_direction (last_param, VALA_PARAMETER_DIRECTION_IN);
					}
					hide_param = TRUE;
				} else {
					gboolean _tmp297_ = FALSE;
					if (last_param != NULL) {
						const gchar* _tmp298_ = NULL;
						_tmp298_ = vala_symbol_get_name ((ValaSymbol*) p);
						_tmp297_ = g_strcmp0 (_tmp298_, "user_data") == 0;
					} else {
						_tmp297_ = FALSE;
					}
					if (_tmp297_) {
						hide_param = TRUE;
					}
				}
				if (show_param) {
					_tmp299_ = TRUE;
				} else {
					_tmp299_ = !hide_param;
				}
				if (_tmp299_) {
					vala_method_add_parameter (m, p);
					if (set_array_length_pos) {
						vala_parameter_set_carray_length_parameter_position (p, array_length_pos);
					}
					if (set_delegate_target_pos) {
						vala_parameter_set_cdelegate_target_parameter_position (p, delegate_target_pos);
					}
				}
				_tmp300_ = _vala_code_node_ref0 (p);
				_tmp301_ = _tmp300_;
				_vala_code_node_unref0 (last_param);
				last_param = _tmp301_;
				_tmp302_ = _vala_code_node_ref0 (param_type);
				_tmp303_ = _tmp302_;
				_vala_code_node_unref0 (last_param_type);
				last_param_type = _tmp303_;
				_vala_code_node_unref0 (p);
				_vala_code_node_unref0 (param_type);
				_g_free0 (param_name);
			}
		}
	}
	if (suppress_throws == FALSE) {
		_tmp304_ = error_types != NULL;
	} else {
		_tmp304_ = FALSE;
	}
	if (_tmp304_) {
		gchar* _tmp305_ = NULL;
		gchar* _tmp306_;
		gchar** _tmp307_;
		gchar** _tmp308_ = NULL;
		gchar** _tmp309_;
		gint type_args_length1;
		gint _type_args_size_;
		gchar** _tmp310_;
		gchar** type_args;
		_tmp305_ = vala_gidl_parser_eval (self, error_types);
		_tmp306_ = _tmp305_;
		_tmp308_ = _tmp307_ = g_strsplit (_tmp306_, ",", 0);
		_tmp310_ = (_tmp309_ = _tmp308_, _g_free0 (_tmp306_), _tmp309_);
		type_args_length1 = _vala_array_length (_tmp307_);
		_type_args_size_ = type_args_length1;
		type_args = _tmp310_;
		{
			gchar** type_arg_collection;
			int type_arg_collection_length1;
			int type_arg_it;
			type_arg_collection = type_args;
			type_arg_collection_length1 = type_args_length1;
			for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
				gchar* _tmp311_;
				gchar* type_arg;
				_tmp311_ = g_strdup (type_arg_collection[type_arg_it]);
				type_arg = _tmp311_;
				{
					ValaDataType* _tmp312_ = NULL;
					ValaDataType* _tmp313_;
					_tmp312_ = vala_gidl_parser_get_type_from_string (self, type_arg);
					_tmp313_ = _tmp312_;
					vala_code_node_add_error_type ((ValaCodeNode*) m, _tmp313_);
					_vala_code_node_unref0 (_tmp313_);
					_g_free0 (type_arg);
				}
			}
		}
		type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
	}
	if (first) {
		vala_method_set_binding (m, VALA_MEMBER_BINDING_STATIC);
	}
	if (last_param != NULL) {
		const gchar* _tmp315_ = NULL;
		gboolean _tmp316_;
		_tmp315_ = vala_symbol_get_name ((ValaSymbol*) last_param);
		_tmp316_ = g_str_has_prefix (_tmp315_, "first_");
		_tmp314_ = _tmp316_;
	} else {
		_tmp314_ = FALSE;
	}
	if (_tmp314_) {
		vala_parameter_set_ellipsis (last_param, TRUE);
	} else {
		if (add_ellipsis) {
			ValaParameter* _tmp317_ = NULL;
			ValaParameter* _tmp318_;
			_tmp317_ = vala_parameter_new_with_ellipsis (NULL);
			_tmp318_ = _tmp317_;
			vala_method_add_parameter (m, _tmp318_);
			_vala_code_node_unref0 (_tmp318_);
		}
	}
	result = m;
	_vala_code_node_unref0 (last_param_type);
	_vala_code_node_unref0 (last_param);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (error_types);
	_vala_code_node_unref0 (return_type);
	return result;
}


static gchar* string_chomp (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}


static gboolean vala_gidl_parser_param_is_exception (ValaGIdlParser* self, GIdlNodeParam* param) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* s;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (param != NULL, FALSE);
	if (!param->type->is_error) {
		result = FALSE;
		return result;
	}
	_tmp0_ = string_chomp (param->type->unparsed);
	s = _tmp0_;
	_tmp1_ = g_str_has_suffix (s, "**");
	if (_tmp1_) {
		result = TRUE;
		_g_free0 (s);
		return result;
	}
	result = FALSE;
	_g_free0 (s);
	return result;
}


static ValaMethod* vala_gidl_parser_parse_function (ValaGIdlParser* self, GIdlNodeFunction* f, gboolean is_interface) {
	ValaMethod* result = NULL;
	GIdlNode* node;
	ValaMethod* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (f != NULL, NULL);
	node = (GIdlNode*) f;
	if (f->deprecated) {
		result = NULL;
		return result;
	}
	_tmp0_ = vala_gidl_parser_create_method (self, node->name, f->symbol, f->result, f->parameters, f->is_constructor, is_interface);
	result = _tmp0_;
	return result;
}


static ValaMethod* vala_gidl_parser_parse_virtual (ValaGIdlParser* self, GIdlNodeVFunc* v, GIdlNodeFunction* func, gboolean is_interface) {
	ValaMethod* result = NULL;
	GIdlNode* node;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* symbol;
	GList* _tmp6_;
	ValaMethod* _tmp7_ = NULL;
	ValaMethod* m;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (v != NULL, NULL);
	node = (GIdlNode*) v;
	_tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self->priv->current_data_type);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s%s", _tmp1_, node->name);
	symbol = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	if (func != NULL) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = g_strdup (func->symbol);
		_tmp5_ = _tmp4_;
		_g_free0 (symbol);
		symbol = _tmp5_;
	}
	_tmp6_ = NULL;
	if (func != NULL) {
		_tmp6_ = func->parameters;
	} else {
		_tmp6_ = v->parameters;
	}
	_tmp7_ = vala_gidl_parser_create_method (self, node->name, symbol, v->result, _tmp6_, FALSE, is_interface);
	m = _tmp7_;
	if (m != NULL) {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_;
		gint _tmp12_;
		gchar** _tmp13_ = NULL;
		gint attributes_length1;
		gint _attributes_size_;
		gchar** _tmp14_;
		gchar** attributes;
		vala_method_set_binding (m, VALA_MEMBER_BINDING_INSTANCE);
		_tmp9_ = vala_method_get_is_abstract (m);
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = is_interface;
		}
		vala_method_set_is_virtual (m, !_tmp8_);
		_tmp11_ = vala_method_get_is_abstract (m);
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			_tmp10_ = is_interface;
		}
		vala_method_set_is_abstract (m, _tmp10_);
		_tmp13_ = vala_gidl_parser_get_attributes (self, symbol, &_tmp12_);
		_tmp14_ = _tmp13_;
		attributes_length1 = _tmp12_;
		_attributes_size_ = attributes_length1;
		attributes = _tmp14_;
		if (attributes != NULL) {
			{
				gchar** attr_collection;
				int attr_collection_length1;
				int attr_it;
				attr_collection = attributes;
				attr_collection_length1 = attributes_length1;
				for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
					gchar* _tmp15_;
					gchar* attr;
					_tmp15_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp15_;
					{
						gchar** _tmp16_;
						gchar** _tmp17_ = NULL;
						gint nv_length1;
						gint _nv_size_;
						gchar** _tmp18_;
						gchar** nv;
						_tmp17_ = _tmp16_ = g_strsplit (attr, "=", 2);
						_tmp18_ = _tmp17_;
						nv_length1 = _vala_array_length (_tmp16_);
						_nv_size_ = nv_length1;
						nv = _tmp18_;
						if (g_strcmp0 (nv[0], "virtual") == 0) {
							gchar* _tmp19_ = NULL;
							gchar* _tmp20_;
							gboolean _tmp21_;
							_tmp19_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp20_ = _tmp19_;
							if ((_tmp21_ = g_strcmp0 (_tmp20_, "0") == 0, _g_free0 (_tmp20_), _tmp21_)) {
								vala_method_set_is_virtual (m, FALSE);
								vala_method_set_is_abstract (m, FALSE);
							} else {
								vala_method_set_is_virtual (m, TRUE);
								vala_method_set_is_abstract (m, FALSE);
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		if (func == NULL) {
			ValaAttribute* _tmp22_ = NULL;
			_tmp22_ = vala_attribute_new ("NoWrapper", NULL);
			((ValaCodeNode*) m)->attributes = g_list_append (((ValaCodeNode*) m)->attributes, _tmp22_);
		}
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	result = m;
	_g_free0 (symbol);
	return result;
}


static gchar* vala_gidl_parser_fix_prop_name (ValaGIdlParser* self, const gchar* name) {
	gchar* result = NULL;
	GString* _tmp0_ = NULL;
	GString* str;
	gchar* _tmp1_;
	gchar* i;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_string_new ("");
	str = _tmp0_;
	_tmp1_ = g_strdup (name);
	i = _tmp1_;
	while (TRUE) {
		glong _tmp2_;
		gunichar _tmp3_;
		gunichar c;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp2_ = strlen (i);
		if (!(_tmp2_ > 0)) {
			break;
		}
		_tmp3_ = string_get_char (i, 0);
		c = _tmp3_;
		if (c == '-') {
			g_string_append_c (str, '_');
		} else {
			g_string_append_unichar (str, c);
		}
		_tmp4_ = g_utf8_next_char (i);
		_tmp5_ = g_strdup (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (i);
		i = _tmp6_;
	}
	_tmp7_ = g_strdup (str->str);
	result = _tmp7_;
	_g_free0 (i);
	_g_string_free0 (str);
	return result;
}


static ValaProperty* vala_gidl_parser_parse_property (ValaGIdlParser* self, GIdlNodeProperty* prop_node) {
	ValaProperty* result = NULL;
	GIdlNode* node;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	ValaDataType* _tmp3_ = NULL;
	ValaDataType* _tmp4_;
	ValaProperty* _tmp5_ = NULL;
	ValaProperty* _tmp6_;
	ValaProperty* prop;
	gboolean _tmp7_ = FALSE;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_;
	gint _tmp25_;
	gchar** _tmp26_ = NULL;
	gchar** _tmp27_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp28_;
	gchar** attributes;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop_node != NULL, NULL);
	node = (GIdlNode*) prop_node;
	if (prop_node->deprecated) {
		result = NULL;
		return result;
	}
	if (!prop_node->readable) {
		_tmp0_ = !prop_node->writable;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		prop_node->readable = TRUE;
		prop_node->writable = TRUE;
	}
	_tmp1_ = vala_gidl_parser_fix_prop_name (self, node->name);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_gidl_parser_parse_type (self, prop_node->type, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_property_new (_tmp2_, _tmp4_, NULL, NULL, self->priv->current_source_reference, NULL);
	prop = (_tmp6_ = _tmp5_, _vala_code_node_unref0 (_tmp4_), _g_free0 (_tmp2_), _tmp6_);
	vala_symbol_set_access ((ValaSymbol*) prop, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_property_set_interface_only (prop, TRUE);
	if (prop_node->type->is_interface) {
		_tmp7_ = g_strcmp0 (prop_node->type->interface, "GStrv") == 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		vala_property_set_no_array_length (prop, TRUE);
		vala_property_set_array_null_terminated (prop, TRUE);
	}
	if (prop_node->readable) {
		ValaDataType* _tmp8_ = NULL;
		ValaDataType* _tmp9_ = NULL;
		ValaDataType* _tmp10_;
		ValaPropertyAccessor* _tmp11_ = NULL;
		ValaPropertyAccessor* _tmp12_;
		_tmp8_ = vala_property_get_property_type (prop);
		_tmp9_ = vala_data_type_copy (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp10_, NULL, NULL, NULL);
		_tmp12_ = _tmp11_;
		vala_property_set_get_accessor (prop, _tmp12_);
		_vala_code_node_unref0 (_tmp12_);
		_vala_code_node_unref0 (_tmp10_);
	}
	if (prop_node->writable) {
		ValaDataType* _tmp13_ = NULL;
		ValaDataType* _tmp14_ = NULL;
		ValaDataType* _tmp15_;
		ValaPropertyAccessor* _tmp16_ = NULL;
		ValaPropertyAccessor* _tmp17_;
		_tmp13_ = vala_property_get_property_type (prop);
		_tmp14_ = vala_data_type_copy (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_property_accessor_new (FALSE, FALSE, FALSE, _tmp15_, NULL, NULL, NULL);
		_tmp17_ = _tmp16_;
		vala_property_set_set_accessor (prop, _tmp17_);
		_vala_code_node_unref0 (_tmp17_);
		_vala_code_node_unref0 (_tmp15_);
		if (prop_node->construct_only) {
			ValaPropertyAccessor* _tmp18_ = NULL;
			_tmp18_ = vala_property_get_set_accessor (prop);
			vala_property_accessor_set_construction (_tmp18_, TRUE);
		} else {
			ValaPropertyAccessor* _tmp19_ = NULL;
			ValaPropertyAccessor* _tmp20_ = NULL;
			_tmp19_ = vala_property_get_set_accessor (prop);
			vala_property_accessor_set_writable (_tmp19_, TRUE);
			_tmp20_ = vala_property_get_set_accessor (prop);
			vala_property_accessor_set_construction (_tmp20_, prop_node->construct);
		}
	}
	_tmp21_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strdup_printf ("%s:%s", _tmp22_, node->name);
	_tmp24_ = _tmp23_;
	_tmp26_ = vala_gidl_parser_get_attributes (self, _tmp24_, &_tmp25_);
	_tmp28_ = (_tmp27_ = _tmp26_, _g_free0 (_tmp24_), _g_free0 (_tmp22_), _tmp27_);
	attributes_length1 = _tmp25_;
	_attributes_size_ = attributes_length1;
	attributes = _tmp28_;
	if (attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp29_;
				gchar* attr;
				_tmp29_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp29_;
				{
					gchar** _tmp30_;
					gchar** _tmp31_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp32_;
					gchar** nv;
					_tmp31_ = _tmp30_ = g_strsplit (attr, "=", 2);
					_tmp32_ = _tmp31_;
					nv_length1 = _vala_array_length (_tmp30_);
					_nv_size_ = nv_length1;
					nv = _tmp32_;
					if (g_strcmp0 (nv[0], "hidden") == 0) {
						gchar* _tmp33_ = NULL;
						gchar* _tmp34_;
						gboolean _tmp35_;
						_tmp33_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp34_ = _tmp33_;
						if ((_tmp35_ = g_strcmp0 (_tmp34_, "1") == 0, _g_free0 (_tmp34_), _tmp35_)) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (prop);
							return result;
						}
					} else {
						if (g_strcmp0 (nv[0], "type_arguments") == 0) {
							gchar* _tmp36_ = NULL;
							gchar* _tmp37_;
							gchar** _tmp38_;
							gchar** _tmp39_ = NULL;
							gchar** _tmp40_;
							gint type_args_length1;
							gint _type_args_size_;
							gchar** _tmp41_;
							gchar** type_args;
							_tmp36_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp37_ = _tmp36_;
							_tmp39_ = _tmp38_ = g_strsplit (_tmp37_, ",", 0);
							_tmp41_ = (_tmp40_ = _tmp39_, _g_free0 (_tmp37_), _tmp40_);
							type_args_length1 = _vala_array_length (_tmp38_);
							_type_args_size_ = type_args_length1;
							type_args = _tmp41_;
							{
								gchar** type_arg_collection;
								int type_arg_collection_length1;
								int type_arg_it;
								type_arg_collection = type_args;
								type_arg_collection_length1 = type_args_length1;
								for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
									gchar* _tmp42_;
									gchar* type_arg;
									_tmp42_ = g_strdup (type_arg_collection[type_arg_it]);
									type_arg = _tmp42_;
									{
										ValaDataType* _tmp43_ = NULL;
										ValaDataType* _tmp44_ = NULL;
										ValaDataType* _tmp45_;
										_tmp43_ = vala_property_get_property_type (prop);
										_tmp44_ = vala_gidl_parser_get_type_from_string (self, type_arg);
										_tmp45_ = _tmp44_;
										vala_data_type_add_type_argument (_tmp43_, _tmp45_);
										_vala_code_node_unref0 (_tmp45_);
										_g_free0 (type_arg);
									}
								}
							}
							type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
						} else {
							if (g_strcmp0 (nv[0], "deprecated") == 0) {
								gchar* _tmp46_ = NULL;
								gchar* _tmp47_;
								gboolean _tmp48_;
								_tmp46_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp47_ = _tmp46_;
								if ((_tmp48_ = g_strcmp0 (_tmp47_, "1") == 0, _g_free0 (_tmp47_), _tmp48_)) {
									vala_symbol_set_deprecated ((ValaSymbol*) prop, TRUE);
								}
							} else {
								if (g_strcmp0 (nv[0], "replacement") == 0) {
									gchar* _tmp49_ = NULL;
									gchar* _tmp50_;
									_tmp49_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp50_ = _tmp49_;
									vala_symbol_set_replacement ((ValaSymbol*) prop, _tmp50_);
									_g_free0 (_tmp50_);
								} else {
									if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
										gchar* _tmp51_ = NULL;
										gchar* _tmp52_;
										_tmp51_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp52_ = _tmp51_;
										vala_symbol_set_deprecated_since ((ValaSymbol*) prop, _tmp52_);
										_g_free0 (_tmp52_);
									} else {
										if (g_strcmp0 (nv[0], "accessor_method") == 0) {
											gchar* _tmp53_ = NULL;
											gchar* _tmp54_;
											gboolean _tmp55_;
											_tmp53_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp54_ = _tmp53_;
											if ((_tmp55_ = g_strcmp0 (_tmp54_, "0") == 0, _g_free0 (_tmp54_), _tmp55_)) {
												vala_property_set_no_accessor_method (prop, TRUE);
											}
										} else {
											if (g_strcmp0 (nv[0], "owned_get") == 0) {
												gchar* _tmp56_ = NULL;
												gchar* _tmp57_;
												gboolean _tmp58_;
												_tmp56_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp57_ = _tmp56_;
												if ((_tmp58_ = g_strcmp0 (_tmp57_, "1") == 0, _g_free0 (_tmp57_), _tmp58_)) {
													ValaPropertyAccessor* _tmp59_ = NULL;
													ValaDataType* _tmp60_ = NULL;
													_tmp59_ = vala_property_get_get_accessor (prop);
													_tmp60_ = vala_property_accessor_get_value_type (_tmp59_);
													vala_data_type_set_value_owned (_tmp60_, TRUE);
												}
											} else {
												if (g_strcmp0 (nv[0], "type_name") == 0) {
													gchar* _tmp61_ = NULL;
													gchar* _tmp62_;
													ValaDataType* _tmp63_ = NULL;
													ValaDataType* _tmp64_;
													_tmp61_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp62_ = _tmp61_;
													_tmp63_ = vala_gidl_parser_get_type_from_string (self, _tmp62_);
													_tmp64_ = _tmp63_;
													vala_property_set_property_type (prop, _tmp64_);
													_vala_code_node_unref0 (_tmp64_);
													_g_free0 (_tmp62_);
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	if (self->priv->current_type_symbol_set != NULL) {
		const gchar* _tmp65_ = NULL;
		_tmp65_ = vala_symbol_get_name ((ValaSymbol*) prop);
		vala_collection_add ((ValaCollection*) self->priv->current_type_symbol_set, _tmp65_);
	}
	result = prop;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static ValaConstant* vala_gidl_parser_parse_constant (ValaGIdlParser* self, GIdlNodeConstant* const_node) {
	ValaConstant* result = NULL;
	GIdlNode* node;
	ValaDataType* _tmp0_ = NULL;
	ValaDataType* type;
	ValaConstant* _tmp1_ = NULL;
	ValaConstant* c;
	gint _tmp2_;
	gchar** _tmp3_ = NULL;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp4_;
	gchar** attributes;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (const_node != NULL, NULL);
	node = (GIdlNode*) const_node;
	_tmp0_ = vala_gidl_parser_parse_type (self, const_node->type, NULL);
	type = _tmp0_;
	if (type == NULL) {
		result = NULL;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp1_ = vala_constant_new (node->name, type, NULL, self->priv->current_source_reference, NULL);
	c = _tmp1_;
	vala_symbol_set_external ((ValaSymbol*) c, TRUE);
	_tmp3_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp2_);
	_tmp4_ = _tmp3_;
	attributes_length1 = _tmp2_;
	_attributes_size_ = attributes_length1;
	attributes = _tmp4_;
	if (attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp5_;
				gchar* attr;
				_tmp5_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp5_;
				{
					gchar** _tmp6_;
					gchar** _tmp7_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp8_;
					gchar** nv;
					_tmp7_ = _tmp6_ = g_strsplit (attr, "=", 2);
					_tmp8_ = _tmp7_;
					nv_length1 = _vala_array_length (_tmp6_);
					_nv_size_ = nv_length1;
					nv = _tmp8_;
					if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
						gchar* _tmp9_ = NULL;
						gchar* _tmp10_;
						_tmp9_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp10_ = _tmp9_;
						vala_symbol_add_cheader_filename ((ValaSymbol*) c, _tmp10_);
						_g_free0 (_tmp10_);
					} else {
						if (g_strcmp0 (nv[0], "deprecated") == 0) {
							gchar* _tmp11_ = NULL;
							gchar* _tmp12_;
							gboolean _tmp13_;
							_tmp11_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp12_ = _tmp11_;
							if ((_tmp13_ = g_strcmp0 (_tmp12_, "1") == 0, _g_free0 (_tmp12_), _tmp13_)) {
								vala_symbol_set_deprecated ((ValaSymbol*) c, TRUE);
							}
						} else {
							if (g_strcmp0 (nv[0], "replacement") == 0) {
								gchar* _tmp14_ = NULL;
								gchar* _tmp15_;
								_tmp14_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp15_ = _tmp14_;
								vala_symbol_set_replacement ((ValaSymbol*) c, _tmp15_);
								_g_free0 (_tmp15_);
							} else {
								if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
									gchar* _tmp16_ = NULL;
									gchar* _tmp17_;
									_tmp16_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp17_ = _tmp16_;
									vala_symbol_set_deprecated_since ((ValaSymbol*) c, _tmp17_);
									_g_free0 (_tmp17_);
								} else {
									if (g_strcmp0 (nv[0], "hidden") == 0) {
										gchar* _tmp18_ = NULL;
										gchar* _tmp19_;
										gboolean _tmp20_;
										_tmp18_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp19_ = _tmp18_;
										if ((_tmp20_ = g_strcmp0 (_tmp19_, "1") == 0, _g_free0 (_tmp19_), _tmp20_)) {
											result = NULL;
											nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (attr);
											attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
											_vala_code_node_unref0 (c);
											_vala_code_node_unref0 (type);
											return result;
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	vala_symbol_set_access ((ValaSymbol*) c, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	result = c;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (type);
	return result;
}


static ValaField* vala_gidl_parser_parse_field (ValaGIdlParser* self, GIdlNodeField* field_node) {
	ValaField* result = NULL;
	GIdlNode* node;
	gboolean unhidden;
	ValaDataType* _tmp0_ = NULL;
	ValaDataType* type;
	gchar* cheader_filename;
	gchar* ctype;
	gchar* array_length_cname;
	gchar* array_length_type;
	gboolean array_null_terminated;
	gboolean deprecated;
	gchar* deprecated_since;
	gchar* replacement;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gint _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp8_;
	gchar** attributes;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp57_;
	gchar* _tmp58_;
	gchar* field_name;
	ValaField* _tmp61_ = NULL;
	ValaField* field;
	gboolean _tmp62_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (field_node != NULL, NULL);
	node = (GIdlNode*) field_node;
	unhidden = FALSE;
	_tmp0_ = vala_gidl_parser_parse_type (self, field_node->type, NULL);
	type = _tmp0_;
	if (type == NULL) {
		result = NULL;
		_vala_code_node_unref0 (type);
		return result;
	}
	cheader_filename = NULL;
	ctype = NULL;
	array_length_cname = NULL;
	array_length_type = NULL;
	array_null_terminated = FALSE;
	deprecated = FALSE;
	deprecated_since = NULL;
	replacement = NULL;
	_tmp1_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%s.%s", _tmp2_, node->name);
	_tmp4_ = _tmp3_;
	_tmp6_ = vala_gidl_parser_get_attributes (self, _tmp4_, &_tmp5_);
	_tmp8_ = (_tmp7_ = _tmp6_, _g_free0 (_tmp4_), _g_free0 (_tmp2_), _tmp7_);
	attributes_length1 = _tmp5_;
	_attributes_size_ = attributes_length1;
	attributes = _tmp8_;
	if (attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp9_;
				gchar* attr;
				_tmp9_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp9_;
				{
					gchar** _tmp10_;
					gchar** _tmp11_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp12_;
					gchar** nv;
					_tmp11_ = _tmp10_ = g_strsplit (attr, "=", 2);
					_tmp12_ = _tmp11_;
					nv_length1 = _vala_array_length (_tmp10_);
					_nv_size_ = nv_length1;
					nv = _tmp12_;
					if (g_strcmp0 (nv[0], "hidden") == 0) {
						gchar* _tmp13_ = NULL;
						gchar* _tmp14_;
						gboolean _tmp15_;
						_tmp13_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp14_ = _tmp13_;
						if ((_tmp15_ = g_strcmp0 (_tmp14_, "1") == 0, _g_free0 (_tmp14_), _tmp15_)) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (replacement);
							_g_free0 (deprecated_since);
							_g_free0 (array_length_type);
							_g_free0 (array_length_cname);
							_g_free0 (ctype);
							_g_free0 (cheader_filename);
							_vala_code_node_unref0 (type);
							return result;
						} else {
							unhidden = TRUE;
						}
					} else {
						if (g_strcmp0 (nv[0], "is_array") == 0) {
							gchar* _tmp16_ = NULL;
							gchar* _tmp17_;
							gboolean _tmp18_;
							_tmp16_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp17_ = _tmp16_;
							if ((_tmp18_ = g_strcmp0 (_tmp17_, "1") == 0, _g_free0 (_tmp17_), _tmp18_)) {
								ValaSourceReference* _tmp19_ = NULL;
								ValaArrayType* _tmp20_ = NULL;
								ValaDataType* _tmp21_;
								_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) type);
								_tmp20_ = vala_array_type_new (type, 1, _tmp19_);
								_tmp21_ = (ValaDataType*) _tmp20_;
								_vala_code_node_unref0 (type);
								type = _tmp21_;
							}
						} else {
							if (g_strcmp0 (nv[0], "weak") == 0) {
								gchar* _tmp22_ = NULL;
								gchar* _tmp23_;
								gboolean _tmp24_;
								_tmp22_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp23_ = _tmp22_;
								if ((_tmp24_ = g_strcmp0 (_tmp23_, "0") == 0, _g_free0 (_tmp23_), _tmp24_)) {
									vala_data_type_set_value_owned (type, TRUE);
								}
							} else {
								if (g_strcmp0 (nv[0], "type_name") == 0) {
									gchar* _tmp25_ = NULL;
									gchar* _tmp26_;
									ValaDataType* _tmp27_ = NULL;
									ValaDataType* _tmp28_;
									_tmp25_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp26_ = _tmp25_;
									_tmp27_ = vala_gidl_parser_get_type_from_string (self, _tmp26_);
									_tmp28_ = _tmp27_;
									_vala_code_node_unref0 (type);
									type = _tmp28_;
									_g_free0 (_tmp26_);
								} else {
									if (g_strcmp0 (nv[0], "type_arguments") == 0) {
										gchar* _tmp29_ = NULL;
										gchar* _tmp30_;
										gchar** _tmp31_;
										gchar** _tmp32_ = NULL;
										gchar** _tmp33_;
										gint type_args_length1;
										gint _type_args_size_;
										gchar** _tmp34_;
										gchar** type_args;
										_tmp29_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp30_ = _tmp29_;
										_tmp32_ = _tmp31_ = g_strsplit (_tmp30_, ",", 0);
										_tmp34_ = (_tmp33_ = _tmp32_, _g_free0 (_tmp30_), _tmp33_);
										type_args_length1 = _vala_array_length (_tmp31_);
										_type_args_size_ = type_args_length1;
										type_args = _tmp34_;
										{
											gchar** type_arg_collection;
											int type_arg_collection_length1;
											int type_arg_it;
											type_arg_collection = type_args;
											type_arg_collection_length1 = type_args_length1;
											for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
												gchar* _tmp35_;
												gchar* type_arg;
												_tmp35_ = g_strdup (type_arg_collection[type_arg_it]);
												type_arg = _tmp35_;
												{
													ValaDataType* _tmp36_ = NULL;
													ValaDataType* _tmp37_;
													_tmp36_ = vala_gidl_parser_get_type_from_string (self, type_arg);
													_tmp37_ = _tmp36_;
													vala_data_type_add_type_argument (type, _tmp37_);
													_vala_code_node_unref0 (_tmp37_);
													_g_free0 (type_arg);
												}
											}
										}
										type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
									} else {
										if (g_strcmp0 (nv[0], "deprecated") == 0) {
											gchar* _tmp38_ = NULL;
											gchar* _tmp39_;
											gboolean _tmp40_;
											_tmp38_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp39_ = _tmp38_;
											if ((_tmp40_ = g_strcmp0 (_tmp39_, "1") == 0, _g_free0 (_tmp39_), _tmp40_)) {
												deprecated = TRUE;
											}
										} else {
											if (g_strcmp0 (nv[0], "replacement") == 0) {
												gchar* _tmp41_ = NULL;
												gchar* _tmp42_;
												_tmp41_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp42_ = _tmp41_;
												_g_free0 (replacement);
												replacement = _tmp42_;
											} else {
												if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
													gchar* _tmp43_ = NULL;
													gchar* _tmp44_;
													_tmp43_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp44_ = _tmp43_;
													_g_free0 (deprecated_since);
													deprecated_since = _tmp44_;
												} else {
													if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
														gchar* _tmp45_ = NULL;
														gchar* _tmp46_;
														_tmp45_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp46_ = _tmp45_;
														_g_free0 (cheader_filename);
														cheader_filename = _tmp46_;
													} else {
														if (g_strcmp0 (nv[0], "ctype") == 0) {
															gchar* _tmp47_ = NULL;
															gchar* _tmp48_;
															_tmp47_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp48_ = _tmp47_;
															_g_free0 (ctype);
															ctype = _tmp48_;
														} else {
															if (g_strcmp0 (nv[0], "array_null_terminated") == 0) {
																gchar* _tmp49_ = NULL;
																gchar* _tmp50_;
																gboolean _tmp51_;
																_tmp49_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp50_ = _tmp49_;
																if ((_tmp51_ = g_strcmp0 (_tmp50_, "1") == 0, _g_free0 (_tmp50_), _tmp51_)) {
																	array_null_terminated = TRUE;
																}
															} else {
																if (g_strcmp0 (nv[0], "array_length_cname") == 0) {
																	gchar* _tmp52_ = NULL;
																	gchar* _tmp53_;
																	_tmp52_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp53_ = _tmp52_;
																	_g_free0 (array_length_cname);
																	array_length_cname = _tmp53_;
																} else {
																	if (g_strcmp0 (nv[0], "array_length_type") == 0) {
																		gchar* _tmp54_ = NULL;
																		gchar* _tmp55_;
																		_tmp54_ = vala_gidl_parser_eval (self, nv[1]);
																		_tmp55_ = _tmp54_;
																		_g_free0 (array_length_type);
																		array_length_type = _tmp55_;
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp57_ = g_str_has_prefix (node->name, "_");
	if (_tmp57_) {
		_tmp56_ = !unhidden;
	} else {
		_tmp56_ = FALSE;
	}
	if (_tmp56_) {
		result = NULL;
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (replacement);
		_g_free0 (deprecated_since);
		_g_free0 (array_length_type);
		_g_free0 (array_length_cname);
		_g_free0 (ctype);
		_g_free0 (cheader_filename);
		_vala_code_node_unref0 (type);
		return result;
	}
	if (self->priv->current_type_symbol_set != NULL) {
		vala_collection_add ((ValaCollection*) self->priv->current_type_symbol_set, node->name);
	}
	_tmp58_ = g_strdup (node->name);
	field_name = _tmp58_;
	if (g_strcmp0 (field_name, "string") == 0) {
		gchar* _tmp59_;
		gchar* _tmp60_;
		_tmp59_ = g_strdup ("str");
		_tmp60_ = _tmp59_;
		_g_free0 (field_name);
		field_name = _tmp60_;
	}
	_tmp61_ = vala_field_new (field_name, type, NULL, self->priv->current_source_reference, NULL);
	field = _tmp61_;
	vala_symbol_set_access ((ValaSymbol*) field, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	if (g_strcmp0 (field_name, node->name) != 0) {
		vala_field_set_cname (field, node->name);
	}
	if (deprecated) {
		vala_symbol_set_deprecated ((ValaSymbol*) field, TRUE);
		if (deprecated_since != NULL) {
			vala_symbol_set_deprecated_since ((ValaSymbol*) field, deprecated_since);
		}
		if (replacement != NULL) {
			vala_symbol_set_replacement ((ValaSymbol*) field, replacement);
		}
	}
	if (ctype != NULL) {
		vala_field_set_ctype (field, ctype);
	}
	if (cheader_filename != NULL) {
		vala_symbol_add_cheader_filename ((ValaSymbol*) field, cheader_filename);
	}
	if (array_null_terminated) {
		vala_field_set_array_null_terminated (field, TRUE);
	}
	if (array_length_cname != NULL) {
		_tmp62_ = TRUE;
	} else {
		_tmp62_ = array_length_type != NULL;
	}
	if (_tmp62_) {
		if (array_length_cname != NULL) {
			vala_field_set_array_length_cname (field, array_length_cname);
		}
		if (array_length_type != NULL) {
			vala_field_set_array_length_type (field, array_length_type);
		}
	} else {
		vala_field_set_no_array_length (field, TRUE);
	}
	result = field;
	_g_free0 (field_name);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (replacement);
	_g_free0 (deprecated_since);
	_g_free0 (array_length_type);
	_g_free0 (array_length_cname);
	_g_free0 (ctype);
	_g_free0 (cheader_filename);
	_vala_code_node_unref0 (type);
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_slist_free__g_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_free0_, NULL);
	g_slist_free (self);
}


static gchar** vala_gidl_parser_get_attributes (ValaGIdlParser* self, const gchar* codenode, int* result_length1) {
	gchar** result = NULL;
	gpointer _tmp0_ = NULL;
	gchar* attributes;
	GSList* attr_list;
	glong _tmp18_;
	GString* _tmp19_ = NULL;
	GString* attr;
	glong _tmp20_;
	glong attributes_len;
	const gchar* remaining;
	gboolean quoted;
	gboolean escaped;
	guint _tmp27_;
	gchar** _tmp28_ = NULL;
	gint attrs_length1;
	gint _attrs_size_;
	gchar** _tmp29_;
	gchar** attrs;
	GSList* attr_i;
	gchar** _tmp34_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (codenode != NULL, NULL);
	_tmp0_ = vala_map_get (self->priv->codenode_attributes_map, codenode);
	attributes = (gchar*) _tmp0_;
	if (attributes == NULL) {
		const gchar* _tmp1_ = NULL;
		gboolean dot_required;
		const gchar* _tmp2_ = NULL;
		gboolean colon_required;
		ValaSet* _tmp3_ = NULL;
		ValaSet* pattern_specs;
		_tmp1_ = g_utf8_strchr (codenode, (gssize) (-1), (gunichar) '.');
		dot_required = NULL != _tmp1_;
		_tmp2_ = g_utf8_strchr (codenode, (gssize) (-1), (gunichar) ':');
		colon_required = NULL != _tmp2_;
		_tmp3_ = vala_map_get_keys (self->priv->codenode_attributes_patterns);
		pattern_specs = _tmp3_;
		{
			ValaIterator* _tmp4_ = NULL;
			ValaIterator* _pattern_it;
			_tmp4_ = vala_iterable_iterator ((ValaIterable*) pattern_specs);
			_pattern_it = _tmp4_;
			while (TRUE) {
				gboolean _tmp5_;
				gpointer _tmp6_ = NULL;
				GPatternSpec* pattern;
				gpointer _tmp7_ = NULL;
				gchar* pspec;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp13_;
				_tmp5_ = vala_iterator_next (_pattern_it);
				if (!_tmp5_) {
					break;
				}
				_tmp6_ = vala_iterator_get (_pattern_it);
				pattern = _tmp6_;
				_tmp7_ = vala_map_get (self->priv->codenode_attributes_patterns, pattern);
				pspec = (gchar*) _tmp7_;
				if (dot_required) {
					const gchar* _tmp10_ = NULL;
					_tmp10_ = g_utf8_strchr (pspec, (gssize) (-1), (gunichar) '.');
					_tmp9_ = NULL == _tmp10_;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					_tmp8_ = TRUE;
				} else {
					gboolean _tmp11_ = FALSE;
					if (colon_required) {
						const gchar* _tmp12_ = NULL;
						_tmp12_ = g_utf8_strchr (pspec, (gssize) (-1), (gunichar) ':');
						_tmp11_ = NULL == _tmp12_;
					} else {
						_tmp11_ = FALSE;
					}
					_tmp8_ = _tmp11_;
				}
				if (_tmp8_) {
					_g_free0 (pspec);
					continue;
				}
				_tmp13_ = g_pattern_match_string (pattern, codenode);
				if (_tmp13_) {
					gint _tmp14_;
					gchar** _tmp15_ = NULL;
					gchar** _tmp16_;
					_tmp15_ = vala_gidl_parser_get_attributes (self, pspec, &_tmp14_);
					_tmp16_ = _tmp15_;
					*result_length1 = _tmp14_;
					result = _tmp16_;
					_g_free0 (pspec);
					_vala_iterator_unref0 (_pattern_it);
					_vala_iterable_unref0 (pattern_specs);
					_g_free0 (attributes);
					return result;
				}
				_g_free0 (pspec);
			}
			_vala_iterator_unref0 (_pattern_it);
		}
		_vala_iterable_unref0 (pattern_specs);
	}
	if (attributes == NULL) {
		gpointer _tmp17_;
		_tmp17_ = NULL;
		*result_length1 = 0;
		result = _tmp17_;
		_g_free0 (attributes);
		return result;
	}
	attr_list = NULL;
	_tmp18_ = strlen (attributes);
	_tmp19_ = g_string_sized_new ((gsize) _tmp18_);
	attr = _tmp19_;
	_tmp20_ = strlen (attributes);
	attributes_len = _tmp20_;
	remaining = attributes;
	quoted = FALSE;
	escaped = FALSE;
	{
		gint b;
		b = 0;
		{
			gboolean _tmp21_;
			_tmp21_ = TRUE;
			while (TRUE) {
				gunichar _tmp22_;
				gunichar c;
				const gchar* _tmp25_ = NULL;
				if (!_tmp21_) {
					b++;
				}
				_tmp21_ = FALSE;
				if (!(b < attributes_len)) {
					break;
				}
				_tmp22_ = string_get_char (remaining, 0);
				c = _tmp22_;
				if (escaped) {
					escaped = FALSE;
					g_string_append_unichar (attr, c);
				} else {
					if (c == '"') {
						g_string_append_unichar (attr, c);
						quoted = !quoted;
					} else {
						if (c == '\\') {
							escaped = TRUE;
						} else {
							gboolean _tmp23_ = FALSE;
							if (!quoted) {
								_tmp23_ = c == ' ';
							} else {
								_tmp23_ = FALSE;
							}
							if (_tmp23_) {
								gchar* _tmp24_;
								_tmp24_ = g_strdup (attr->str);
								attr_list = g_slist_prepend (attr_list, _tmp24_);
								g_string_truncate (attr, (gsize) 0);
							} else {
								g_string_append_unichar (attr, c);
							}
						}
					}
				}
				_tmp25_ = string_offset (remaining, (glong) 1);
				remaining = _tmp25_;
			}
		}
	}
	if (attr->len > 0) {
		gchar* _tmp26_;
		_tmp26_ = g_strdup (attr->str);
		attr_list = g_slist_prepend (attr_list, _tmp26_);
	}
	_tmp27_ = g_slist_length (attr_list);
	_tmp28_ = g_new0 (gchar*, _tmp27_ + 1);
	_tmp29_ = _tmp28_;
	attrs_length1 = _tmp27_;
	_attrs_size_ = attrs_length1;
	attrs = _tmp29_;
	attr_i = attr_list;
	{
		gint a;
		a = 0;
		{
			gboolean _tmp30_;
			_tmp30_ = TRUE;
			while (TRUE) {
				gchar* _tmp31_;
				gchar* *_tmp32_;
				gchar* _tmp33_;
				if (!_tmp30_) {
					a++;
					attr_i = attr_i->next;
				}
				_tmp30_ = FALSE;
				if (!(a < attrs_length1)) {
					break;
				}
				_tmp31_ = g_strdup ((const gchar*) attr_i->data);
				_tmp32_ = &attrs[(attrs_length1 - 1) - a];
				_tmp33_ = _tmp31_;
				_g_free0 ((*_tmp32_));
				(*_tmp32_) = _tmp33_;
			}
		}
	}
	_tmp34_ = attrs;
	*result_length1 = attrs_length1;
	result = _tmp34_;
	_g_string_free0 (attr);
	__g_slist_free__g_free0_0 (attr_list);
	_g_free0 (attributes);
	return result;
}


static gchar* vala_gidl_parser_eval (ValaGIdlParser* self, const gchar* s) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	glong _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = NULL;
	_tmp3_ = strlen (s);
	if (_tmp3_ >= 2) {
		gboolean _tmp4_;
		_tmp4_ = g_str_has_prefix (s, "\"");
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp5_;
		_tmp5_ = g_str_has_suffix (s, "\"");
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp6_ = NULL;
		glong _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp6_ = string_offset (s, (glong) 1);
		_tmp7_ = strlen (s);
		_tmp8_ = g_strndup (_tmp6_, (gsize) (_tmp7_ - 2));
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp9_;
	} else {
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = g_strdup (s);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp11_;
	}
	result = _tmp0_;
	return result;
}


static ValaSignal* vala_gidl_parser_parse_signal (ValaGIdlParser* self, GIdlNodeSignal* sig_node) {
	ValaSignal* result = NULL;
	GIdlNode* node;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	ValaDataType* _tmp3_ = NULL;
	ValaDataType* _tmp4_;
	ValaSignal* _tmp5_ = NULL;
	ValaSignal* _tmp6_;
	ValaSignal* sig;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gint _tmp12_;
	gchar** _tmp13_ = NULL;
	gchar** _tmp14_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp15_;
	gchar** attributes;
	gboolean first;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig_node != NULL, NULL);
	node = (GIdlNode*) sig_node;
	if (sig_node->deprecated) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = sig_node->result == NULL;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = vala_gidl_parser_fix_prop_name (self, node->name);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_gidl_parser_parse_param (self, sig_node->result, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_signal_new (_tmp2_, _tmp4_, self->priv->current_source_reference, NULL);
	sig = (_tmp6_ = _tmp5_, _vala_code_node_unref0 (_tmp4_), _g_free0 (_tmp2_), _tmp6_);
	vala_symbol_set_access ((ValaSymbol*) sig, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp7_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_symbol_get_name ((ValaSymbol*) sig);
	_tmp10_ = g_strdup_printf ("%s::%s", _tmp8_, _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp13_ = vala_gidl_parser_get_attributes (self, _tmp11_, &_tmp12_);
	_tmp15_ = (_tmp14_ = _tmp13_, _g_free0 (_tmp11_), _g_free0 (_tmp8_), _tmp14_);
	attributes_length1 = _tmp12_;
	_attributes_size_ = attributes_length1;
	attributes = _tmp15_;
	if (attributes != NULL) {
		gchar* ns_name;
		ns_name = NULL;
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp16_;
				gchar* attr;
				_tmp16_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp16_;
				{
					gchar** _tmp17_;
					gchar** _tmp18_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp19_;
					gchar** nv;
					_tmp18_ = _tmp17_ = g_strsplit (attr, "=", 2);
					_tmp19_ = _tmp18_;
					nv_length1 = _vala_array_length (_tmp17_);
					_nv_size_ = nv_length1;
					nv = _tmp19_;
					if (g_strcmp0 (nv[0], "name") == 0) {
						const gchar* _tmp20_ = NULL;
						gchar* _tmp21_ = NULL;
						gchar* _tmp22_;
						_tmp20_ = vala_symbol_get_name ((ValaSymbol*) sig);
						vala_signal_set_cname (sig, _tmp20_);
						_tmp21_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp22_ = _tmp21_;
						vala_symbol_set_name ((ValaSymbol*) sig, _tmp22_);
						_g_free0 (_tmp22_);
					} else {
						gboolean _tmp23_ = FALSE;
						if (g_strcmp0 (nv[0], "has_emitter") == 0) {
							gchar* _tmp24_ = NULL;
							gchar* _tmp25_;
							_tmp24_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp25_ = _tmp24_;
							_tmp23_ = g_strcmp0 (_tmp25_, "1") == 0;
							_g_free0 (_tmp25_);
						} else {
							_tmp23_ = FALSE;
						}
						if (_tmp23_) {
							vala_signal_set_has_emitter (sig, TRUE);
						} else {
							if (g_strcmp0 (nv[0], "hidden") == 0) {
								gchar* _tmp26_ = NULL;
								gchar* _tmp27_;
								gboolean _tmp28_;
								_tmp26_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp27_ = _tmp26_;
								if ((_tmp28_ = g_strcmp0 (_tmp27_, "1") == 0, _g_free0 (_tmp27_), _tmp28_)) {
									result = NULL;
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
									_g_free0 (ns_name);
									attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
									_vala_code_node_unref0 (sig);
									return result;
								}
							} else {
								if (g_strcmp0 (nv[0], "deprecated") == 0) {
									gchar* _tmp29_ = NULL;
									gchar* _tmp30_;
									gboolean _tmp31_;
									_tmp29_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp30_ = _tmp29_;
									if ((_tmp31_ = g_strcmp0 (_tmp30_, "1") == 0, _g_free0 (_tmp30_), _tmp31_)) {
										vala_symbol_set_deprecated ((ValaSymbol*) sig, TRUE);
									}
								} else {
									if (g_strcmp0 (nv[0], "replacement") == 0) {
										gchar* _tmp32_ = NULL;
										gchar* _tmp33_;
										_tmp32_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp33_ = _tmp32_;
										vala_symbol_set_replacement ((ValaSymbol*) sig, _tmp33_);
										_g_free0 (_tmp33_);
									} else {
										if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
											gchar* _tmp34_ = NULL;
											gchar* _tmp35_;
											_tmp34_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp35_ = _tmp34_;
											vala_symbol_set_deprecated_since ((ValaSymbol*) sig, _tmp35_);
											_g_free0 (_tmp35_);
										} else {
											if (g_strcmp0 (nv[0], "transfer_ownership") == 0) {
												gchar* _tmp36_ = NULL;
												gchar* _tmp37_;
												gboolean _tmp38_;
												_tmp36_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp37_ = _tmp36_;
												if ((_tmp38_ = g_strcmp0 (_tmp37_, "1") == 0, _g_free0 (_tmp37_), _tmp38_)) {
													ValaDataType* _tmp39_ = NULL;
													_tmp39_ = vala_signal_get_return_type (sig);
													vala_data_type_set_value_owned (_tmp39_, TRUE);
												}
											} else {
												if (g_strcmp0 (nv[0], "namespace_name") == 0) {
													gchar* _tmp40_ = NULL;
													gchar* _tmp41_;
													_tmp40_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp41_ = _tmp40_;
													_g_free0 (ns_name);
													ns_name = _tmp41_;
												} else {
													if (g_strcmp0 (nv[0], "type_name") == 0) {
														gchar* _tmp42_ = NULL;
														gchar* _tmp43_;
														ValaUnresolvedSymbol* _tmp44_ = NULL;
														ValaUnresolvedSymbol* _tmp45_;
														ValaUnresolvedSymbol* sym;
														ValaDataType* _tmp46_ = NULL;
														_tmp42_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp43_ = _tmp42_;
														_tmp44_ = vala_unresolved_symbol_new (NULL, _tmp43_, NULL);
														sym = (_tmp45_ = _tmp44_, _g_free0 (_tmp43_), _tmp45_);
														_tmp46_ = vala_signal_get_return_type (sig);
														if (VALA_IS_UNRESOLVED_TYPE (_tmp46_)) {
															ValaDataType* _tmp47_ = NULL;
															_tmp47_ = vala_signal_get_return_type (sig);
															vala_unresolved_type_set_unresolved_symbol (VALA_UNRESOLVED_TYPE (_tmp47_), sym);
														} else {
															ValaDataType* _tmp48_ = NULL;
															ValaSourceReference* _tmp49_ = NULL;
															ValaUnresolvedType* _tmp50_ = NULL;
															ValaUnresolvedType* _tmp51_;
															_tmp48_ = vala_signal_get_return_type (sig);
															_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp48_);
															_tmp50_ = vala_unresolved_type_new_from_symbol (sym, _tmp49_);
															_tmp51_ = _tmp50_;
															vala_signal_set_return_type (sig, (ValaDataType*) _tmp51_);
															_vala_code_node_unref0 (_tmp51_);
														}
														_vala_code_node_unref0 (sym);
													} else {
														if (g_strcmp0 (nv[0], "type_arguments") == 0) {
															gchar* _tmp52_ = NULL;
															gchar* _tmp53_;
															gchar** _tmp54_;
															gchar** _tmp55_ = NULL;
															gchar** _tmp56_;
															gint type_args_length1;
															gint _type_args_size_;
															gchar** _tmp57_;
															gchar** type_args;
															_tmp52_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp53_ = _tmp52_;
															_tmp55_ = _tmp54_ = g_strsplit (_tmp53_, ",", 0);
															_tmp57_ = (_tmp56_ = _tmp55_, _g_free0 (_tmp53_), _tmp56_);
															type_args_length1 = _vala_array_length (_tmp54_);
															_type_args_size_ = type_args_length1;
															type_args = _tmp57_;
															{
																gchar** type_arg_collection;
																int type_arg_collection_length1;
																int type_arg_it;
																type_arg_collection = type_args;
																type_arg_collection_length1 = type_args_length1;
																for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
																	gchar* _tmp58_;
																	gchar* type_arg;
																	_tmp58_ = g_strdup (type_arg_collection[type_arg_it]);
																	type_arg = _tmp58_;
																	{
																		ValaDataType* _tmp59_ = NULL;
																		ValaDataType* _tmp60_ = NULL;
																		ValaDataType* _tmp61_;
																		_tmp59_ = vala_signal_get_return_type (sig);
																		_tmp60_ = vala_gidl_parser_get_type_from_string (self, type_arg);
																		_tmp61_ = _tmp60_;
																		vala_data_type_add_type_argument (_tmp59_, _tmp61_);
																		_vala_code_node_unref0 (_tmp61_);
																		_g_free0 (type_arg);
																	}
																}
															}
															type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
		if (ns_name != NULL) {
			ValaDataType* _tmp62_ = NULL;
			ValaUnresolvedSymbol* _tmp63_ = NULL;
			ValaUnresolvedSymbol* _tmp64_ = NULL;
			ValaUnresolvedSymbol* _tmp65_;
			_tmp62_ = vala_signal_get_return_type (sig);
			_tmp63_ = vala_unresolved_type_get_unresolved_symbol (VALA_UNRESOLVED_TYPE (_tmp62_));
			_tmp64_ = vala_unresolved_symbol_new (NULL, ns_name, NULL);
			_tmp65_ = _tmp64_;
			vala_unresolved_symbol_set_inner (_tmp63_, _tmp65_);
			_vala_code_node_unref0 (_tmp65_);
		}
		_g_free0 (ns_name);
	}
	vala_signal_set_is_virtual (sig, TRUE);
	first = TRUE;
	{
		GList* param_collection;
		GList* param_it;
		param_collection = sig_node->parameters;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNode* param_node;
				ValaParameterDirection direction = 0;
				ValaParameterDirection _tmp66_;
				ValaDataType* _tmp67_ = NULL;
				ValaDataType* param_type;
				ValaParameter* _tmp68_ = NULL;
				ValaParameter* p;
				gboolean hide_param;
				gboolean show_param;
				gchar* _tmp69_ = NULL;
				gchar* _tmp70_;
				const gchar* _tmp71_ = NULL;
				gchar* _tmp72_ = NULL;
				gchar* _tmp73_;
				gint _tmp74_;
				gchar** _tmp75_ = NULL;
				gchar** _tmp76_;
				gboolean _tmp126_ = FALSE;
				if (first) {
					first = FALSE;
					continue;
				}
				param_node = (GIdlNode*) param;
				_tmp67_ = vala_gidl_parser_parse_param (self, param, &_tmp66_);
				direction = _tmp66_;
				param_type = _tmp67_;
				_tmp68_ = vala_parameter_new (param_node->name, param_type, NULL);
				p = _tmp68_;
				vala_parameter_set_direction (p, direction);
				hide_param = FALSE;
				show_param = FALSE;
				_tmp69_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
				_tmp70_ = _tmp69_;
				_tmp71_ = vala_symbol_get_name ((ValaSymbol*) sig);
				_tmp72_ = g_strdup_printf ("%s::%s.%s", _tmp70_, _tmp71_, param_node->name);
				_tmp73_ = _tmp72_;
				_tmp75_ = vala_gidl_parser_get_attributes (self, _tmp73_, &_tmp74_);
				_tmp76_ = _tmp75_;
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				attributes_length1 = _tmp74_;
				_attributes_size_ = attributes_length1;
				attributes = _tmp76_;
				_g_free0 (_tmp73_);
				_g_free0 (_tmp70_);
				if (attributes != NULL) {
					gchar* ns_name;
					ns_name = NULL;
					{
						gchar** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = attributes;
						attr_collection_length1 = attributes_length1;
						for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
							gchar* _tmp77_;
							gchar* attr;
							_tmp77_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp77_;
							{
								gchar** _tmp78_;
								gchar** _tmp79_ = NULL;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp80_;
								gchar** nv;
								_tmp79_ = _tmp78_ = g_strsplit (attr, "=", 2);
								_tmp80_ = _tmp79_;
								nv_length1 = _vala_array_length (_tmp78_);
								_nv_size_ = nv_length1;
								nv = _tmp80_;
								if (g_strcmp0 (nv[0], "hidden") == 0) {
									gchar* _tmp81_ = NULL;
									gchar* _tmp82_;
									gboolean _tmp83_;
									_tmp81_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp82_ = _tmp81_;
									if ((_tmp83_ = g_strcmp0 (_tmp82_, "1") == 0, _g_free0 (_tmp82_), _tmp83_)) {
										hide_param = TRUE;
									} else {
										gchar* _tmp84_ = NULL;
										gchar* _tmp85_;
										gboolean _tmp86_;
										_tmp84_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp85_ = _tmp84_;
										if ((_tmp86_ = g_strcmp0 (_tmp85_, "0") == 0, _g_free0 (_tmp85_), _tmp86_)) {
											show_param = TRUE;
										}
									}
								} else {
									if (g_strcmp0 (nv[0], "is_array") == 0) {
										gchar* _tmp87_ = NULL;
										gchar* _tmp88_;
										gboolean _tmp89_;
										_tmp87_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp88_ = _tmp87_;
										if ((_tmp89_ = g_strcmp0 (_tmp88_, "1") == 0, _g_free0 (_tmp88_), _tmp89_)) {
											ValaSourceReference* _tmp90_ = NULL;
											ValaArrayType* _tmp91_ = NULL;
											ValaDataType* _tmp92_;
											_tmp90_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
											_tmp91_ = vala_array_type_new (param_type, 1, _tmp90_);
											_tmp92_ = (ValaDataType*) _tmp91_;
											_vala_code_node_unref0 (param_type);
											param_type = _tmp92_;
											vala_variable_set_variable_type ((ValaVariable*) p, param_type);
											vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_IN);
										}
									} else {
										if (g_strcmp0 (nv[0], "is_out") == 0) {
											gchar* _tmp93_ = NULL;
											gchar* _tmp94_;
											gboolean _tmp95_;
											_tmp93_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp94_ = _tmp93_;
											if ((_tmp95_ = g_strcmp0 (_tmp94_, "1") == 0, _g_free0 (_tmp94_), _tmp95_)) {
												vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_OUT);
											}
										} else {
											if (g_strcmp0 (nv[0], "is_ref") == 0) {
												gchar* _tmp96_ = NULL;
												gchar* _tmp97_;
												gboolean _tmp98_;
												_tmp96_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp97_ = _tmp96_;
												if ((_tmp98_ = g_strcmp0 (_tmp97_, "1") == 0, _g_free0 (_tmp97_), _tmp98_)) {
													vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_REF);
												}
											} else {
												if (g_strcmp0 (nv[0], "nullable") == 0) {
													gchar* _tmp99_ = NULL;
													gchar* _tmp100_;
													gboolean _tmp101_;
													_tmp99_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp100_ = _tmp99_;
													if ((_tmp101_ = g_strcmp0 (_tmp100_, "1") == 0, _g_free0 (_tmp100_), _tmp101_)) {
														vala_data_type_set_nullable (param_type, TRUE);
													}
												} else {
													if (g_strcmp0 (nv[0], "transfer_ownership") == 0) {
														gchar* _tmp102_ = NULL;
														gchar* _tmp103_;
														gboolean _tmp104_;
														_tmp102_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp103_ = _tmp102_;
														if ((_tmp104_ = g_strcmp0 (_tmp103_, "1") == 0, _g_free0 (_tmp103_), _tmp104_)) {
															vala_data_type_set_value_owned (param_type, TRUE);
														}
													} else {
														if (g_strcmp0 (nv[0], "type_name") == 0) {
															gchar* _tmp107_ = NULL;
															gchar* _tmp108_;
															ValaUnresolvedSymbol* _tmp109_ = NULL;
															ValaUnresolvedSymbol* _tmp110_;
															if (!VALA_IS_UNRESOLVED_TYPE (param_type)) {
																ValaUnresolvedType* _tmp105_ = NULL;
																ValaDataType* _tmp106_;
																_tmp105_ = vala_unresolved_type_new ();
																_tmp106_ = (ValaDataType*) _tmp105_;
																_vala_code_node_unref0 (param_type);
																param_type = _tmp106_;
																vala_variable_set_variable_type ((ValaVariable*) p, param_type);
															}
															_tmp107_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp108_ = _tmp107_;
															_tmp109_ = vala_unresolved_symbol_new (NULL, _tmp108_, NULL);
															_tmp110_ = _tmp109_;
															vala_unresolved_type_set_unresolved_symbol (VALA_UNRESOLVED_TYPE (param_type), _tmp110_);
															_vala_code_node_unref0 (_tmp110_);
															_g_free0 (_tmp108_);
														} else {
															if (g_strcmp0 (nv[0], "type_arguments") == 0) {
																gchar* _tmp111_ = NULL;
																gchar* _tmp112_;
																gchar** _tmp113_;
																gchar** _tmp114_ = NULL;
																gchar** _tmp115_;
																gint type_args_length1;
																gint _type_args_size_;
																gchar** _tmp116_;
																gchar** type_args;
																_tmp111_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp112_ = _tmp111_;
																_tmp114_ = _tmp113_ = g_strsplit (_tmp112_, ",", 0);
																_tmp116_ = (_tmp115_ = _tmp114_, _g_free0 (_tmp112_), _tmp115_);
																type_args_length1 = _vala_array_length (_tmp113_);
																_type_args_size_ = type_args_length1;
																type_args = _tmp116_;
																{
																	gchar** type_arg_collection;
																	int type_arg_collection_length1;
																	int type_arg_it;
																	type_arg_collection = type_args;
																	type_arg_collection_length1 = type_args_length1;
																	for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
																		gchar* _tmp117_;
																		gchar* type_arg;
																		_tmp117_ = g_strdup (type_arg_collection[type_arg_it]);
																		type_arg = _tmp117_;
																		{
																			ValaDataType* _tmp118_ = NULL;
																			ValaDataType* _tmp119_ = NULL;
																			ValaDataType* _tmp120_;
																			_tmp118_ = vala_variable_get_variable_type ((ValaVariable*) p);
																			_tmp119_ = vala_gidl_parser_get_type_from_string (self, type_arg);
																			_tmp120_ = _tmp119_;
																			vala_data_type_add_type_argument (_tmp118_, _tmp120_);
																			_vala_code_node_unref0 (_tmp120_);
																			_g_free0 (type_arg);
																		}
																	}
																}
																type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
															} else {
																if (g_strcmp0 (nv[0], "namespace_name") == 0) {
																	gchar* _tmp121_ = NULL;
																	gchar* _tmp122_;
																	_tmp121_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp122_ = _tmp121_;
																	_g_free0 (ns_name);
																	ns_name = _tmp122_;
																}
															}
														}
													}
												}
											}
										}
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
					if (ns_name != NULL) {
						ValaUnresolvedSymbol* _tmp123_ = NULL;
						ValaUnresolvedSymbol* _tmp124_ = NULL;
						ValaUnresolvedSymbol* _tmp125_;
						_tmp123_ = vala_unresolved_type_get_unresolved_symbol (VALA_UNRESOLVED_TYPE (param_type));
						_tmp124_ = vala_unresolved_symbol_new (NULL, ns_name, NULL);
						_tmp125_ = _tmp124_;
						vala_unresolved_symbol_set_inner (_tmp123_, _tmp125_);
						_vala_code_node_unref0 (_tmp125_);
					}
					_g_free0 (ns_name);
				}
				if (show_param) {
					_tmp126_ = TRUE;
				} else {
					_tmp126_ = !hide_param;
				}
				if (_tmp126_) {
					vala_signal_add_parameter (sig, p);
				}
				_vala_code_node_unref0 (p);
				_vala_code_node_unref0 (param_type);
			}
		}
	}
	result = sig;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


ValaGIdlParser* vala_gidl_parser_construct (GType object_type) {
	ValaGIdlParser* self = NULL;
	self = (ValaGIdlParser*) vala_code_visitor_construct (object_type);
	return self;
}


ValaGIdlParser* vala_gidl_parser_new (void) {
	return vala_gidl_parser_construct (VALA_TYPE_GIDL_PARSER);
}


static void vala_gidl_parser_class_init (ValaGIdlParserClass * klass) {
	vala_gidl_parser_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = vala_gidl_parser_finalize;
	g_type_class_add_private (klass, sizeof (ValaGIdlParserPrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace = vala_gidl_parser_real_visit_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_gidl_parser_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_gidl_parser_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_gidl_parser_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_gidl_parser_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_domain = vala_gidl_parser_real_visit_error_domain;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delegate = vala_gidl_parser_real_visit_delegate;
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_gidl_parser_real_visit_source_file;
}


static void vala_gidl_parser_instance_init (ValaGIdlParser * self) {
	self->priv = VALA_GIDL_PARSER_GET_PRIVATE (self);
}


static void vala_gidl_parser_finalize (ValaCodeVisitor* obj) {
	ValaGIdlParser * self;
	self = VALA_GIDL_PARSER (obj);
	_vala_code_context_unref0 (self->priv->context);
	_vala_source_file_unref0 (self->priv->current_source_file);
	_vala_source_reference_unref0 (self->priv->current_source_reference);
	_vala_code_node_unref0 (self->priv->current_namespace);
	_vala_code_node_unref0 (self->priv->current_data_type);
	_vala_map_unref0 (self->priv->codenode_attributes_map);
	_vala_map_unref0 (self->priv->codenode_attributes_patterns);
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	_vala_map_unref0 (self->priv->cname_type_map);
	VALA_CODE_VISITOR_CLASS (vala_gidl_parser_parent_class)->finalize (obj);
}


/**
 * Code visitor parsing all GIDL files.
 */
GType vala_gidl_parser_get_type (void) {
	static volatile gsize vala_gidl_parser_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gidl_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGIdlParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gidl_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGIdlParser), 0, (GInstanceInitFunc) vala_gidl_parser_instance_init, NULL };
		GType vala_gidl_parser_type_id;
		vala_gidl_parser_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGIdlParser", &g_define_type_info, 0);
		g_once_init_leave (&vala_gidl_parser_type_id__volatile, vala_gidl_parser_type_id);
	}
	return vala_gidl_parser_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



