/* valanamespace.c generated by valac, the Vala compiler
 * generated from valanamespace.vala, do not modify */

/* valanamespace.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;
typedef struct _ValaNamespacePrivate ValaNamespacePrivate;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_USING_DIRECTIVE (vala_using_directive_get_type ())
#define VALA_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirective))
#define VALA_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))
#define VALA_IS_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_USING_DIRECTIVE))
#define VALA_IS_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_USING_DIRECTIVE))
#define VALA_USING_DIRECTIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))

typedef struct _ValaUsingDirective ValaUsingDirective;
typedef struct _ValaUsingDirectiveClass ValaUsingDirectiveClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))

#define TYPE_MEMBER_BINDING (member_binding_get_type ())

#define VALA_TYPE_CREATION_METHOD (vala_creation_method_get_type ())
#define VALA_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethod))
#define VALA_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))
#define VALA_IS_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CREATION_METHOD))
#define VALA_IS_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CREATION_METHOD))
#define VALA_CREATION_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))

typedef struct _ValaCreationMethod ValaCreationMethod;
typedef struct _ValaCreationMethodClass ValaCreationMethodClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_PROFILE (vala_profile_get_type ())
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	char* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	char* (*get_cprefix) (ValaSymbol* self);
	char* (*get_lower_case_cname) (ValaSymbol* self, const char* infix);
	char* (*get_lower_case_cprefix) (ValaSymbol* self);
	ValaList* (*get_cheader_filenames) (ValaSymbol* self);
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*process_deprecated_attribute) (ValaSymbol* self, ValaAttribute* attr);
	void (*add_namespace) (ValaSymbol* self, ValaNamespace* ns);
	void (*add_class) (ValaSymbol* self, ValaClass* cl);
	void (*add_interface) (ValaSymbol* self, ValaInterface* iface);
	void (*add_struct) (ValaSymbol* self, ValaStruct* st);
	void (*add_enum) (ValaSymbol* self, ValaEnum* en);
	void (*add_error_domain) (ValaSymbol* self, ValaErrorDomain* edomain);
	void (*add_delegate) (ValaSymbol* self, ValaDelegate* d);
	void (*add_constant) (ValaSymbol* self, ValaConstant* constant);
	void (*add_field) (ValaSymbol* self, ValaField* f);
	void (*add_method) (ValaSymbol* self, ValaMethod* m);
	void (*add_property) (ValaSymbol* self, ValaProperty* prop);
	void (*add_signal) (ValaSymbol* self, ValaSignal* sig);
	void (*add_constructor) (ValaSymbol* self, ValaConstructor* c);
	void (*add_destructor) (ValaSymbol* self, ValaDestructor* d);
};

struct _ValaNamespace {
	ValaSymbol parent_instance;
	ValaNamespacePrivate * priv;
};

struct _ValaNamespaceClass {
	ValaSymbolClass parent_class;
};

struct _ValaNamespacePrivate {
	ValaList* classes;
	ValaList* interfaces;
	ValaList* structs;
	ValaList* enums;
	ValaList* error_domains;
	ValaList* delegates;
	ValaList* constants;
	ValaList* fields;
	ValaList* methods;
	ValaList* comments;
	ValaList* cprefixes;
	char* lower_case_cprefix;
	ValaList* namespaces;
	ValaList* using_directives;
};

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;

typedef enum  {
	MEMBER_BINDING_INSTANCE,
	MEMBER_BINDING_CLASS,
	MEMBER_BINDING_STATIC
} MemberBinding;

typedef enum  {
	VALA_PROFILE_POSIX,
	VALA_PROFILE_GOBJECT,
	VALA_PROFILE_DOVA
} ValaProfile;


static gpointer vala_namespace_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_local_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_object_type_symbol_get_type (void) G_GNUC_CONST;
GType vala_class_get_type (void) G_GNUC_CONST;
GType vala_interface_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_error_domain_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_property_get_type (void) G_GNUC_CONST;
GType vala_signal_get_type (void) G_GNUC_CONST;
GType vala_constructor_get_type (void) G_GNUC_CONST;
GType vala_destructor_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
GType vala_using_directive_get_type (void) G_GNUC_CONST;
#define VALA_NAMESPACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_NAMESPACE, ValaNamespacePrivate))
enum  {
	VALA_NAMESPACE_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
ValaNamespace* vala_namespace_new (const char* name, ValaSourceReference* source_reference);
ValaNamespace* vala_namespace_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
ValaSymbol* vala_symbol_construct (GType object_type, const char* name, ValaSourceReference* source_reference, ValaComment* comment);
GType vala_symbol_accessibility_get_type (void) G_GNUC_CONST;
void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value);
void vala_namespace_add_using_directive (ValaNamespace* self, ValaUsingDirective* ns);
void vala_namespace_add_comment (ValaNamespace* self, ValaComment* comment);
ValaList* vala_namespace_get_comments (ValaNamespace* self);
static void vala_namespace_real_add_namespace (ValaSymbol* base, ValaNamespace* ns);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
ValaScope* vala_symbol_get_owner (ValaSymbol* self);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_source_file_add_node (ValaSourceFile* self, ValaCodeNode* node);
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
ValaSymbol* vala_scope_lookup (ValaScope* self, const char* name);
const char* vala_symbol_get_name (ValaSymbol* self);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
void vala_code_node_set_source_reference (ValaCodeNode* self, ValaSourceReference* value);
ValaList* vala_namespace_get_namespaces (ValaNamespace* self);
void vala_symbol_add_namespace (ValaSymbol* self, ValaNamespace* ns);
ValaList* vala_namespace_get_classes (ValaNamespace* self);
void vala_symbol_add_class (ValaSymbol* self, ValaClass* cl);
ValaList* vala_namespace_get_structs (ValaNamespace* self);
void vala_symbol_add_struct (ValaSymbol* self, ValaStruct* st);
ValaList* vala_namespace_get_interfaces (ValaNamespace* self);
void vala_symbol_add_interface (ValaSymbol* self, ValaInterface* iface);
ValaList* vala_namespace_get_delegates (ValaNamespace* self);
void vala_symbol_add_delegate (ValaSymbol* self, ValaDelegate* d);
ValaList* vala_namespace_get_enums (ValaNamespace* self);
void vala_symbol_add_enum (ValaSymbol* self, ValaEnum* en);
ValaList* vala_namespace_get_error_domains (ValaNamespace* self);
void vala_symbol_add_error_domain (ValaSymbol* self, ValaErrorDomain* edomain);
ValaList* vala_namespace_get_constants (ValaNamespace* self);
void vala_symbol_add_constant (ValaSymbol* self, ValaConstant* constant);
ValaList* vala_namespace_get_fields (ValaNamespace* self);
void vala_symbol_add_field (ValaSymbol* self, ValaField* f);
ValaList* vala_namespace_get_methods (ValaNamespace* self);
void vala_symbol_add_method (ValaSymbol* self, ValaMethod* m);
void vala_scope_add (ValaScope* self, const char* name, ValaSymbol* sym);
static void vala_namespace_real_add_class (ValaSymbol* base, ValaClass* cl);
ValaSymbolAccessibility vala_symbol_get_access (ValaSymbol* self);
static void vala_namespace_real_add_interface (ValaSymbol* base, ValaInterface* iface);
static void vala_namespace_real_add_struct (ValaSymbol* base, ValaStruct* st);
void vala_namespace_remove_struct (ValaNamespace* self, ValaStruct* st);
void vala_scope_remove (ValaScope* self, const char* name);
static void vala_namespace_real_add_enum (ValaSymbol* base, ValaEnum* en);
static void vala_namespace_real_add_error_domain (ValaSymbol* base, ValaErrorDomain* edomain);
static void vala_namespace_real_add_delegate (ValaSymbol* base, ValaDelegate* d);
static void vala_namespace_real_add_constant (ValaSymbol* base, ValaConstant* constant);
static void vala_namespace_real_add_field (ValaSymbol* base, ValaField* f);
GType member_binding_get_type (void) G_GNUC_CONST;
MemberBinding vala_field_get_binding (ValaField* self);
void vala_field_set_binding (ValaField* self, MemberBinding value);
void vala_report_error (ValaSourceReference* source, const char* message);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
static void vala_namespace_real_add_method (ValaSymbol* base, ValaMethod* m);
MemberBinding vala_method_get_binding (ValaMethod* self);
void vala_method_set_binding (ValaMethod* self, MemberBinding value);
GType vala_creation_method_get_type (void) G_GNUC_CONST;
ValaDataType* vala_method_get_return_type (ValaMethod* self);
GType vala_void_type_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
ValaCodeContext* vala_code_context_get (void);
GType vala_profile_get_type (void) G_GNUC_CONST;
ValaProfile vala_code_context_get_profile (ValaCodeContext* self);
ValaList* vala_method_get_postconditions (ValaMethod* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
ValaLocalVariable* vala_local_variable_new (ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaLocalVariable* vala_local_variable_construct (GType object_type, ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
void vala_method_set_result_var (ValaMethod* self, ValaLocalVariable* value);
ValaLocalVariable* vala_method_get_result_var (ValaMethod* self);
void vala_local_variable_set_is_result (ValaLocalVariable* self, gboolean value);
static void vala_namespace_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_namespace (ValaCodeVisitor* self, ValaNamespace* ns);
static void vala_namespace_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
static char* vala_namespace_real_get_cprefix (ValaSymbol* base);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
char* vala_symbol_get_cprefix (ValaSymbol* self);
ValaList* vala_namespace_get_cprefixes (ValaNamespace* self);
void vala_namespace_add_cprefix (ValaNamespace* self, const char* cprefix);
static char* vala_namespace_real_get_lower_case_cprefix (ValaSymbol* base);
char* vala_symbol_get_lower_case_cprefix (ValaSymbol* self);
char* vala_symbol_camel_case_to_lower_case (const char* camel_case);
void vala_namespace_set_lower_case_cprefix (ValaNamespace* self, const char* cprefix);
static void vala_namespace_process_ccode_attribute (ValaNamespace* self, ValaAttribute* a);
gboolean vala_attribute_has_argument (ValaAttribute* self, const char* name);
char* vala_attribute_get_string (ValaAttribute* self, const char* name);
void vala_symbol_add_cheader_filename (ValaSymbol* self, const char* filename);
void vala_source_file_set_gir_namespace (ValaSourceFile* self, const char* value);
void vala_source_file_set_gir_version (ValaSourceFile* self, const char* value);
void vala_namespace_process_attributes (ValaNamespace* self);
const char* vala_attribute_get_name (ValaAttribute* self);
static gboolean vala_namespace_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
static void vala_namespace_finalize (ValaCodeNode* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);


/**
 * Creates a new namespace.
 *
 * @param name             namespace name
 * @param source_reference reference to source code
 * @return                 newly created namespace
 */
ValaNamespace* vala_namespace_construct (GType object_type, const char* name, ValaSourceReference* source_reference) {
	ValaNamespace* self;
	self = (ValaNamespace*) vala_symbol_construct (object_type, name, source_reference, NULL);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}


ValaNamespace* vala_namespace_new (const char* name, ValaSourceReference* source_reference) {
	return vala_namespace_construct (VALA_TYPE_NAMESPACE, name, source_reference);
}


/**
 * Adds a new using directive with the specified namespace.
 *
 * @param ns reference to namespace
 */
void vala_namespace_add_using_directive (ValaNamespace* self, ValaUsingDirective* ns) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	vala_collection_add ((ValaCollection*) self->priv->using_directives, ns);
}


void vala_namespace_add_comment (ValaNamespace* self, ValaComment* comment) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment != NULL);
	vala_collection_add ((ValaCollection*) self->priv->comments, comment);
}


/**
 * Returns a copy of the list of namespaces.
 *
 * @return comment list
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_namespace_get_comments (ValaNamespace* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_iterable_ref0 (self->priv->comments);
	return result;
}


/**
 * Adds the specified namespace to this source file.
 *
 * @param ns a namespace
 */
static void vala_namespace_real_add_namespace (ValaSymbol* base, ValaNamespace* ns) {
	ValaNamespace * self;
	ValaSymbol* _tmp0_;
	gboolean _tmp1_;
	self = (ValaNamespace*) base;
	g_return_if_fail (ns != NULL);
	if (vala_symbol_get_owner ((ValaSymbol*) ns) == NULL) {
		vala_source_file_add_node (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) ns)), (ValaCodeNode*) ns);
	}
	if ((_tmp1_ = VALA_IS_NAMESPACE (_tmp0_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) ns))), _vala_code_node_unref0 (_tmp0_), _tmp1_)) {
		ValaNamespace* old_ns;
		gboolean _tmp2_ = FALSE;
		old_ns = VALA_NAMESPACE (vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) ns)));
		if (vala_symbol_get_external_package ((ValaSymbol*) old_ns)) {
			_tmp2_ = !vala_symbol_get_external_package ((ValaSymbol*) ns);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			vala_code_node_set_source_reference ((ValaCodeNode*) old_ns, vala_code_node_get_source_reference ((ValaCodeNode*) ns));
		}
		{
			ValaList* _using_directive_list;
			gint _using_directive_size;
			gint _using_directive_index;
			_using_directive_list = _vala_iterable_ref0 (ns->priv->using_directives);
			_using_directive_size = vala_collection_get_size ((ValaCollection*) _using_directive_list);
			_using_directive_index = -1;
			while (TRUE) {
				ValaUsingDirective* using_directive;
				if (!((_using_directive_index = _using_directive_index + 1) < _using_directive_size)) {
					break;
				}
				using_directive = (ValaUsingDirective*) vala_list_get (_using_directive_list, _using_directive_index);
				vala_namespace_add_using_directive (old_ns, using_directive);
				_vala_code_node_unref0 (using_directive);
			}
			_vala_iterable_unref0 (_using_directive_list);
		}
		{
			ValaList* _sub_ns_list;
			gint _sub_ns_size;
			gint _sub_ns_index;
			_sub_ns_list = vala_namespace_get_namespaces (ns);
			_sub_ns_size = vala_collection_get_size ((ValaCollection*) _sub_ns_list);
			_sub_ns_index = -1;
			while (TRUE) {
				ValaNamespace* sub_ns;
				if (!((_sub_ns_index = _sub_ns_index + 1) < _sub_ns_size)) {
					break;
				}
				sub_ns = (ValaNamespace*) vala_list_get (_sub_ns_list, _sub_ns_index);
				vala_symbol_add_namespace ((ValaSymbol*) old_ns, sub_ns);
				_vala_code_node_unref0 (sub_ns);
			}
			_vala_iterable_unref0 (_sub_ns_list);
		}
		{
			ValaList* _cl_list;
			gint _cl_size;
			gint _cl_index;
			_cl_list = vala_namespace_get_classes (ns);
			_cl_size = vala_collection_get_size ((ValaCollection*) _cl_list);
			_cl_index = -1;
			while (TRUE) {
				ValaClass* cl;
				if (!((_cl_index = _cl_index + 1) < _cl_size)) {
					break;
				}
				cl = (ValaClass*) vala_list_get (_cl_list, _cl_index);
				vala_symbol_add_class ((ValaSymbol*) old_ns, cl);
				_vala_code_node_unref0 (cl);
			}
			_vala_iterable_unref0 (_cl_list);
		}
		{
			ValaList* _st_list;
			gint _st_size;
			gint _st_index;
			_st_list = vala_namespace_get_structs (ns);
			_st_size = vala_collection_get_size ((ValaCollection*) _st_list);
			_st_index = -1;
			while (TRUE) {
				ValaStruct* st;
				if (!((_st_index = _st_index + 1) < _st_size)) {
					break;
				}
				st = (ValaStruct*) vala_list_get (_st_list, _st_index);
				vala_symbol_add_struct ((ValaSymbol*) old_ns, st);
				_vala_code_node_unref0 (st);
			}
			_vala_iterable_unref0 (_st_list);
		}
		{
			ValaList* _iface_list;
			gint _iface_size;
			gint _iface_index;
			_iface_list = vala_namespace_get_interfaces (ns);
			_iface_size = vala_collection_get_size ((ValaCollection*) _iface_list);
			_iface_index = -1;
			while (TRUE) {
				ValaInterface* iface;
				if (!((_iface_index = _iface_index + 1) < _iface_size)) {
					break;
				}
				iface = (ValaInterface*) vala_list_get (_iface_list, _iface_index);
				vala_symbol_add_interface ((ValaSymbol*) old_ns, iface);
				_vala_code_node_unref0 (iface);
			}
			_vala_iterable_unref0 (_iface_list);
		}
		{
			ValaList* _d_list;
			gint _d_size;
			gint _d_index;
			_d_list = vala_namespace_get_delegates (ns);
			_d_size = vala_collection_get_size ((ValaCollection*) _d_list);
			_d_index = -1;
			while (TRUE) {
				ValaDelegate* d;
				if (!((_d_index = _d_index + 1) < _d_size)) {
					break;
				}
				d = (ValaDelegate*) vala_list_get (_d_list, _d_index);
				vala_symbol_add_delegate ((ValaSymbol*) old_ns, d);
				_vala_code_node_unref0 (d);
			}
			_vala_iterable_unref0 (_d_list);
		}
		{
			ValaList* _en_list;
			gint _en_size;
			gint _en_index;
			_en_list = vala_namespace_get_enums (ns);
			_en_size = vala_collection_get_size ((ValaCollection*) _en_list);
			_en_index = -1;
			while (TRUE) {
				ValaEnum* en;
				if (!((_en_index = _en_index + 1) < _en_size)) {
					break;
				}
				en = (ValaEnum*) vala_list_get (_en_list, _en_index);
				vala_symbol_add_enum ((ValaSymbol*) old_ns, en);
				_vala_code_node_unref0 (en);
			}
			_vala_iterable_unref0 (_en_list);
		}
		{
			ValaList* _ed_list;
			gint _ed_size;
			gint _ed_index;
			_ed_list = vala_namespace_get_error_domains (ns);
			_ed_size = vala_collection_get_size ((ValaCollection*) _ed_list);
			_ed_index = -1;
			while (TRUE) {
				ValaErrorDomain* ed;
				if (!((_ed_index = _ed_index + 1) < _ed_size)) {
					break;
				}
				ed = (ValaErrorDomain*) vala_list_get (_ed_list, _ed_index);
				vala_symbol_add_error_domain ((ValaSymbol*) old_ns, ed);
				_vala_code_node_unref0 (ed);
			}
			_vala_iterable_unref0 (_ed_list);
		}
		{
			ValaList* _c_list;
			gint _c_size;
			gint _c_index;
			_c_list = vala_namespace_get_constants (ns);
			_c_size = vala_collection_get_size ((ValaCollection*) _c_list);
			_c_index = -1;
			while (TRUE) {
				ValaConstant* c;
				if (!((_c_index = _c_index + 1) < _c_size)) {
					break;
				}
				c = (ValaConstant*) vala_list_get (_c_list, _c_index);
				vala_symbol_add_constant ((ValaSymbol*) old_ns, c);
				_vala_code_node_unref0 (c);
			}
			_vala_iterable_unref0 (_c_list);
		}
		{
			ValaList* _f_list;
			gint _f_size;
			gint _f_index;
			_f_list = vala_namespace_get_fields (ns);
			_f_size = vala_collection_get_size ((ValaCollection*) _f_list);
			_f_index = -1;
			while (TRUE) {
				ValaField* f;
				if (!((_f_index = _f_index + 1) < _f_size)) {
					break;
				}
				f = (ValaField*) vala_list_get (_f_list, _f_index);
				vala_symbol_add_field ((ValaSymbol*) old_ns, f);
				_vala_code_node_unref0 (f);
			}
			_vala_iterable_unref0 (_f_list);
		}
		{
			ValaList* _m_list;
			gint _m_size;
			gint _m_index;
			_m_list = vala_namespace_get_methods (ns);
			_m_size = vala_collection_get_size ((ValaCollection*) _m_list);
			_m_index = -1;
			while (TRUE) {
				ValaMethod* m;
				if (!((_m_index = _m_index + 1) < _m_size)) {
					break;
				}
				m = (ValaMethod*) vala_list_get (_m_list, _m_index);
				vala_symbol_add_method ((ValaSymbol*) old_ns, m);
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		{
			ValaList* _c_list;
			gint _c_size;
			gint _c_index;
			_c_list = vala_namespace_get_comments (ns);
			_c_size = vala_collection_get_size ((ValaCollection*) _c_list);
			_c_index = -1;
			while (TRUE) {
				ValaComment* c;
				if (!((_c_index = _c_index + 1) < _c_size)) {
					break;
				}
				c = (ValaComment*) vala_list_get (_c_list, _c_index);
				vala_namespace_add_comment (old_ns, c);
				_vala_comment_unref0 (c);
			}
			_vala_iterable_unref0 (_c_list);
		}
		_vala_code_node_unref0 (old_ns);
	} else {
		vala_collection_add ((ValaCollection*) self->priv->namespaces, ns);
		vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) ns), (ValaSymbol*) ns);
	}
}


/**
 * Returns a copy of the list of namespaces.
 *
 * @return namespace list
 */
ValaList* vala_namespace_get_namespaces (ValaNamespace* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_iterable_ref0 (self->priv->namespaces);
	return result;
}


/**
 * Adds the specified class to this namespace.
 *
 * @param cl a class
 */
static void vala_namespace_real_add_class (ValaSymbol* base, ValaClass* cl) {
	ValaNamespace * self;
	self = (ValaNamespace*) base;
	g_return_if_fail (cl != NULL);
	if (vala_symbol_get_access ((ValaSymbol*) cl) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	if (vala_symbol_get_owner ((ValaSymbol*) cl) == NULL) {
		vala_source_file_add_node (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) cl)), (ValaCodeNode*) cl);
	}
	vala_collection_add ((ValaCollection*) self->priv->classes, cl);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) cl), (ValaSymbol*) cl);
}


/**
 * Adds the specified interface to this namespace.
 *
 * @param iface an interface
 */
static void vala_namespace_real_add_interface (ValaSymbol* base, ValaInterface* iface) {
	ValaNamespace * self;
	self = (ValaNamespace*) base;
	g_return_if_fail (iface != NULL);
	if (vala_symbol_get_access ((ValaSymbol*) iface) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) iface, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	if (vala_symbol_get_owner ((ValaSymbol*) iface) == NULL) {
		vala_source_file_add_node (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) iface)), (ValaCodeNode*) iface);
	}
	vala_collection_add ((ValaCollection*) self->priv->interfaces, iface);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) iface), (ValaSymbol*) iface);
}


/**
 * Adds the specified struct to this namespace.
 *
 * @param st a struct
 */
static void vala_namespace_real_add_struct (ValaSymbol* base, ValaStruct* st) {
	ValaNamespace * self;
	self = (ValaNamespace*) base;
	g_return_if_fail (st != NULL);
	if (vala_symbol_get_access ((ValaSymbol*) st) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	if (vala_symbol_get_owner ((ValaSymbol*) st) == NULL) {
		vala_source_file_add_node (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) st)), (ValaCodeNode*) st);
	}
	vala_collection_add ((ValaCollection*) self->priv->structs, st);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) st), (ValaSymbol*) st);
}


/**
 * Removes the specified struct from this namespace.
 *
 * @param st a struct
 */
void vala_namespace_remove_struct (ValaNamespace* self, ValaStruct* st) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	vala_collection_remove ((ValaCollection*) self->priv->structs, st);
	vala_scope_remove (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) st));
}


/**
 * Adds the specified enum to this namespace.
 *
 * @param en an enum
 */
static void vala_namespace_real_add_enum (ValaSymbol* base, ValaEnum* en) {
	ValaNamespace * self;
	self = (ValaNamespace*) base;
	g_return_if_fail (en != NULL);
	if (vala_symbol_get_access ((ValaSymbol*) en) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) en, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	if (vala_symbol_get_owner ((ValaSymbol*) en) == NULL) {
		vala_source_file_add_node (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) en)), (ValaCodeNode*) en);
	}
	vala_collection_add ((ValaCollection*) self->priv->enums, en);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) en), (ValaSymbol*) en);
}


/**
 * Adds the specified error domain to this namespace.
 *
 * @param edomain an error domain
 */
static void vala_namespace_real_add_error_domain (ValaSymbol* base, ValaErrorDomain* edomain) {
	ValaNamespace * self;
	self = (ValaNamespace*) base;
	g_return_if_fail (edomain != NULL);
	if (vala_symbol_get_access ((ValaSymbol*) edomain) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) edomain, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	if (vala_symbol_get_owner ((ValaSymbol*) edomain) == NULL) {
		vala_source_file_add_node (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) edomain)), (ValaCodeNode*) edomain);
	}
	vala_collection_add ((ValaCollection*) self->priv->error_domains, edomain);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) edomain), (ValaSymbol*) edomain);
}


/**
 * Adds the specified delegate to this namespace.
 *
 * @param d a delegate
 */
static void vala_namespace_real_add_delegate (ValaSymbol* base, ValaDelegate* d) {
	ValaNamespace * self;
	self = (ValaNamespace*) base;
	g_return_if_fail (d != NULL);
	if (vala_symbol_get_access ((ValaSymbol*) d) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) d, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	if (vala_symbol_get_owner ((ValaSymbol*) d) == NULL) {
		vala_source_file_add_node (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) d)), (ValaCodeNode*) d);
	}
	vala_collection_add ((ValaCollection*) self->priv->delegates, d);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) d), (ValaSymbol*) d);
}


/**
 * Returns a copy of the list of structs.
 *
 * @return struct list
 */
ValaList* vala_namespace_get_structs (ValaNamespace* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_iterable_ref0 (self->priv->structs);
	return result;
}


/**
 * Returns a copy of the list of classes.
 *
 * @return class list
 */
ValaList* vala_namespace_get_classes (ValaNamespace* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_iterable_ref0 (self->priv->classes);
	return result;
}


/**
 * Returns a copy of the list of interfaces.
 *
 * @return interface list
 */
ValaList* vala_namespace_get_interfaces (ValaNamespace* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_iterable_ref0 (self->priv->interfaces);
	return result;
}


/**
 * Returns a copy of the list of enums.
 *
 * @return enum list
 */
ValaList* vala_namespace_get_enums (ValaNamespace* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_iterable_ref0 (self->priv->enums);
	return result;
}


/**
 * Returns a copy of the list of error domains.
 *
 * @return error domain list
 */
ValaList* vala_namespace_get_error_domains (ValaNamespace* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_iterable_ref0 (self->priv->error_domains);
	return result;
}


/**
 * Returns a copy of the list of fields.
 *
 * @return field list
 */
ValaList* vala_namespace_get_fields (ValaNamespace* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_iterable_ref0 (self->priv->fields);
	return result;
}


/**
 * Returns a copy of the list of constants.
 *
 * @return constant list
 */
ValaList* vala_namespace_get_constants (ValaNamespace* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_iterable_ref0 (self->priv->constants);
	return result;
}


/**
 * Returns a copy of the list of delegates.
 *
 * @return delegate list
 */
ValaList* vala_namespace_get_delegates (ValaNamespace* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_iterable_ref0 (self->priv->delegates);
	return result;
}


/**
 * Returns a copy of the list of methods.
 *
 * @return method list
 */
ValaList* vala_namespace_get_methods (ValaNamespace* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_iterable_ref0 (self->priv->methods);
	return result;
}


/**
 * Adds the specified constant to this namespace.
 *
 * @param constant a constant
 */
static void vala_namespace_real_add_constant (ValaSymbol* base, ValaConstant* constant) {
	ValaNamespace * self;
	self = (ValaNamespace*) base;
	g_return_if_fail (constant != NULL);
	if (vala_symbol_get_access ((ValaSymbol*) constant) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) constant, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	if (vala_symbol_get_owner ((ValaSymbol*) constant) == NULL) {
		vala_source_file_add_node (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) constant)), (ValaCodeNode*) constant);
	}
	vala_collection_add ((ValaCollection*) self->priv->constants, constant);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) constant), (ValaSymbol*) constant);
}


/**
 * Adds the specified field to this namespace.
 *
 * @param f a field
 */
static void vala_namespace_real_add_field (ValaSymbol* base, ValaField* f) {
	ValaNamespace * self;
	self = (ValaNamespace*) base;
	g_return_if_fail (f != NULL);
	if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
		vala_field_set_binding (f, MEMBER_BINDING_STATIC);
	}
	if (vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) f, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) f), "instance members are not allowed outside of data types");
		vala_code_node_set_error ((ValaCodeNode*) f, TRUE);
		return;
	} else {
		if (vala_field_get_binding (f) == MEMBER_BINDING_CLASS) {
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) f), "class members are not allowed outside of classes");
			vala_code_node_set_error ((ValaCodeNode*) f, TRUE);
			return;
		}
	}
	if (vala_symbol_get_owner ((ValaSymbol*) f) == NULL) {
		vala_source_file_add_node (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) f)), (ValaCodeNode*) f);
	}
	vala_collection_add ((ValaCollection*) self->priv->fields, f);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) f), (ValaSymbol*) f);
}


/**
 * Adds the specified method to this namespace.
 *
 * @param m a method
 */
static void vala_namespace_real_add_method (ValaSymbol* base, ValaMethod* m) {
	ValaNamespace * self;
	gboolean _tmp0_ = FALSE;
	self = (ValaNamespace*) base;
	g_return_if_fail (m != NULL);
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		vala_method_set_binding (m, MEMBER_BINDING_STATIC);
	}
	if (vala_symbol_get_access ((ValaSymbol*) m) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) m, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) m), "construction methods may only be declared within classes and structs");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	}
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) m), "instance members are not allowed outside of data types");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	} else {
		if (vala_method_get_binding (m) == MEMBER_BINDING_CLASS) {
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) m), "class members are not allowed outside of classes");
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			return;
		}
	}
	if (!VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		gboolean _tmp1_ = FALSE;
		ValaCodeContext* _tmp2_;
		gboolean _tmp3_;
		if ((_tmp3_ = vala_code_context_get_profile (_tmp2_ = vala_code_context_get ()) == VALA_PROFILE_DOVA, _vala_code_context_unref0 (_tmp2_), _tmp3_)) {
			_tmp1_ = TRUE;
		} else {
			ValaList* _tmp4_;
			_tmp1_ = vala_collection_get_size ((ValaCollection*) (_tmp4_ = vala_method_get_postconditions (m))) > 0;
			_vala_iterable_unref0 (_tmp4_);
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaDataType* _tmp5_;
		ValaLocalVariable* _tmp6_;
		vala_method_set_result_var (m, _tmp6_ = vala_local_variable_new (_tmp5_ = vala_data_type_copy (vala_method_get_return_type (m)), "result", NULL, vala_code_node_get_source_reference ((ValaCodeNode*) self)));
		_vala_code_node_unref0 (_tmp6_);
		_vala_code_node_unref0 (_tmp5_);
		vala_local_variable_set_is_result (vala_method_get_result_var (m), TRUE);
	}
	if (vala_symbol_get_owner ((ValaSymbol*) m) == NULL) {
		vala_source_file_add_node (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) m)), (ValaCodeNode*) m);
	}
	vala_collection_add ((ValaCollection*) self->priv->methods, m);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) m), (ValaSymbol*) m);
}


static void vala_namespace_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaNamespace * self;
	self = (ValaNamespace*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_namespace (visitor, self);
}


static void vala_namespace_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaNamespace * self;
	self = (ValaNamespace*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _ns_ref_list;
		gint _ns_ref_size;
		gint _ns_ref_index;
		_ns_ref_list = _vala_iterable_ref0 (self->priv->using_directives);
		_ns_ref_size = vala_collection_get_size ((ValaCollection*) _ns_ref_list);
		_ns_ref_index = -1;
		while (TRUE) {
			ValaUsingDirective* ns_ref;
			if (!((_ns_ref_index = _ns_ref_index + 1) < _ns_ref_size)) {
				break;
			}
			ns_ref = (ValaUsingDirective*) vala_list_get (_ns_ref_list, _ns_ref_index);
			vala_code_node_accept ((ValaCodeNode*) ns_ref, visitor);
			_vala_code_node_unref0 (ns_ref);
		}
		_vala_iterable_unref0 (_ns_ref_list);
	}
	{
		ValaList* _ns_list;
		gint _ns_size;
		gint _ns_index;
		_ns_list = _vala_iterable_ref0 (self->priv->namespaces);
		_ns_size = vala_collection_get_size ((ValaCollection*) _ns_list);
		_ns_index = -1;
		while (TRUE) {
			ValaNamespace* ns;
			if (!((_ns_index = _ns_index + 1) < _ns_size)) {
				break;
			}
			ns = (ValaNamespace*) vala_list_get (_ns_list, _ns_index);
			vala_code_node_accept ((ValaCodeNode*) ns, visitor);
			_vala_code_node_unref0 (ns);
		}
		_vala_iterable_unref0 (_ns_list);
	}
	{
		ValaList* _en_list;
		gint _en_size;
		gint _en_index;
		_en_list = _vala_iterable_ref0 (self->priv->enums);
		_en_size = vala_collection_get_size ((ValaCollection*) _en_list);
		_en_index = -1;
		while (TRUE) {
			ValaEnum* en;
			if (!((_en_index = _en_index + 1) < _en_size)) {
				break;
			}
			en = (ValaEnum*) vala_list_get (_en_list, _en_index);
			vala_code_node_accept ((ValaCodeNode*) en, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _edomain_list;
		gint _edomain_size;
		gint _edomain_index;
		_edomain_list = _vala_iterable_ref0 (self->priv->error_domains);
		_edomain_size = vala_collection_get_size ((ValaCollection*) _edomain_list);
		_edomain_index = -1;
		while (TRUE) {
			ValaErrorDomain* edomain;
			if (!((_edomain_index = _edomain_index + 1) < _edomain_size)) {
				break;
			}
			edomain = (ValaErrorDomain*) vala_list_get (_edomain_list, _edomain_index);
			vala_code_node_accept ((ValaCodeNode*) edomain, visitor);
			_vala_code_node_unref0 (edomain);
		}
		_vala_iterable_unref0 (_edomain_list);
	}
	{
		ValaList* _cl_list;
		gint _cl_size;
		gint _cl_index;
		_cl_list = _vala_iterable_ref0 (self->priv->classes);
		_cl_size = vala_collection_get_size ((ValaCollection*) _cl_list);
		_cl_index = -1;
		while (TRUE) {
			ValaClass* cl;
			if (!((_cl_index = _cl_index + 1) < _cl_size)) {
				break;
			}
			cl = (ValaClass*) vala_list_get (_cl_list, _cl_index);
			vala_code_node_accept ((ValaCodeNode*) cl, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _iface_list;
		gint _iface_size;
		gint _iface_index;
		_iface_list = _vala_iterable_ref0 (self->priv->interfaces);
		_iface_size = vala_collection_get_size ((ValaCollection*) _iface_list);
		_iface_index = -1;
		while (TRUE) {
			ValaInterface* iface;
			if (!((_iface_index = _iface_index + 1) < _iface_size)) {
				break;
			}
			iface = (ValaInterface*) vala_list_get (_iface_list, _iface_index);
			vala_code_node_accept ((ValaCodeNode*) iface, visitor);
			_vala_code_node_unref0 (iface);
		}
		_vala_iterable_unref0 (_iface_list);
	}
	{
		ValaList* _st_list;
		gint _st_size;
		gint _st_index;
		_st_list = _vala_iterable_ref0 (self->priv->structs);
		_st_size = vala_collection_get_size ((ValaCollection*) _st_list);
		_st_index = -1;
		while (TRUE) {
			ValaStruct* st;
			if (!((_st_index = _st_index + 1) < _st_size)) {
				break;
			}
			st = (ValaStruct*) vala_list_get (_st_list, _st_index);
			vala_code_node_accept ((ValaCodeNode*) st, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list;
		gint _d_size;
		gint _d_index;
		_d_list = _vala_iterable_ref0 (self->priv->delegates);
		_d_size = vala_collection_get_size ((ValaCollection*) _d_list);
		_d_index = -1;
		while (TRUE) {
			ValaDelegate* d;
			if (!((_d_index = _d_index + 1) < _d_size)) {
				break;
			}
			d = (ValaDelegate*) vala_list_get (_d_list, _d_index);
			vala_code_node_accept ((ValaCodeNode*) d, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	{
		ValaList* _c_list;
		gint _c_size;
		gint _c_index;
		_c_list = _vala_iterable_ref0 (self->priv->constants);
		_c_size = vala_collection_get_size ((ValaCollection*) _c_list);
		_c_index = -1;
		while (TRUE) {
			ValaConstant* c;
			if (!((_c_index = _c_index + 1) < _c_size)) {
				break;
			}
			c = (ValaConstant*) vala_list_get (_c_list, _c_index);
			vala_code_node_accept ((ValaCodeNode*) c, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _f_list;
		gint _f_size;
		gint _f_index;
		_f_list = _vala_iterable_ref0 (self->priv->fields);
		_f_size = vala_collection_get_size ((ValaCollection*) _f_list);
		_f_index = -1;
		while (TRUE) {
			ValaField* f;
			if (!((_f_index = _f_index + 1) < _f_size)) {
				break;
			}
			f = (ValaField*) vala_list_get (_f_list, _f_index);
			vala_code_node_accept ((ValaCodeNode*) f, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _m_list;
		gint _m_size;
		gint _m_index;
		_m_list = _vala_iterable_ref0 (self->priv->methods);
		_m_size = vala_collection_get_size ((ValaCollection*) _m_list);
		_m_index = -1;
		while (TRUE) {
			ValaMethod* m;
			if (!((_m_index = _m_index + 1) < _m_size)) {
				break;
			}
			m = (ValaMethod*) vala_list_get (_m_list, _m_index);
			vala_code_node_accept ((ValaCodeNode*) m, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
}


static char* vala_namespace_real_get_cprefix (ValaSymbol* base) {
	ValaNamespace * self;
	char* result = NULL;
	self = (ValaNamespace*) base;
	if (vala_collection_get_size ((ValaCollection*) self->priv->cprefixes) > 0) {
		result = (char*) vala_list_get (self->priv->cprefixes, 0);
		return result;
	} else {
		if (NULL != vala_symbol_get_name ((ValaSymbol*) self)) {
			char* parent_prefix;
			parent_prefix = NULL;
			if (vala_symbol_get_parent_symbol ((ValaSymbol*) self) == NULL) {
				char* _tmp0_;
				parent_prefix = (_tmp0_ = g_strdup (""), _g_free0 (parent_prefix), _tmp0_);
			} else {
				char* _tmp1_;
				parent_prefix = (_tmp1_ = vala_symbol_get_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), _g_free0 (parent_prefix), _tmp1_);
			}
			result = g_strconcat (parent_prefix, vala_symbol_get_name ((ValaSymbol*) self), NULL);
			_g_free0 (parent_prefix);
			return result;
		} else {
			result = g_strdup ("");
			return result;
		}
	}
}


ValaList* vala_namespace_get_cprefixes (ValaNamespace* self) {
	ValaList* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	if (0 == vala_collection_get_size ((ValaCollection*) self->priv->cprefixes)) {
		_tmp0_ = NULL != vala_symbol_get_name ((ValaSymbol*) self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_collection_add ((ValaCollection*) self->priv->cprefixes, vala_symbol_get_name ((ValaSymbol*) self));
	}
	result = _vala_iterable_ref0 (self->priv->cprefixes);
	return result;
}


/**
 * Adds a camel case string to be prepended to the name of members of
 * this namespace when used in C code.
 *
 * @param cprefixes the camel case prefixes used in C code
 */
void vala_namespace_add_cprefix (ValaNamespace* self, const char* cprefix) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cprefix != NULL);
	vala_collection_add ((ValaCollection*) self->priv->cprefixes, cprefix);
}


/**
 * Returns the lower case string to be prepended to the name of members
 * of this namespace when used in C code.
 *
 * @return the lower case prefix to be used in C code
 */
static char* vala_namespace_real_get_lower_case_cprefix (ValaSymbol* base) {
	ValaNamespace * self;
	char* result = NULL;
	self = (ValaNamespace*) base;
	if (self->priv->lower_case_cprefix == NULL) {
		if (vala_symbol_get_name ((ValaSymbol*) self) == NULL) {
			char* _tmp0_;
			self->priv->lower_case_cprefix = (_tmp0_ = g_strdup (""), _g_free0 (self->priv->lower_case_cprefix), _tmp0_);
		} else {
			char* parent_prefix;
			char* _tmp3_;
			char* _tmp4_;
			parent_prefix = NULL;
			if (vala_symbol_get_parent_symbol ((ValaSymbol*) self) == NULL) {
				char* _tmp1_;
				parent_prefix = (_tmp1_ = g_strdup (""), _g_free0 (parent_prefix), _tmp1_);
			} else {
				char* _tmp2_;
				parent_prefix = (_tmp2_ = vala_symbol_get_lower_case_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), _g_free0 (parent_prefix), _tmp2_);
			}
			self->priv->lower_case_cprefix = (_tmp4_ = g_strdup_printf ("%s%s_", parent_prefix, _tmp3_ = vala_symbol_camel_case_to_lower_case (vala_symbol_get_name ((ValaSymbol*) self))), _g_free0 (self->priv->lower_case_cprefix), _tmp4_);
			_g_free0 (_tmp3_);
			_g_free0 (parent_prefix);
		}
	}
	result = g_strdup (self->priv->lower_case_cprefix);
	return result;
}


/**
 * Sets the lower case string to be prepended to the name of members of
 * this namespace when used in C code.
 *
 * @param cprefix the lower case prefix to be used in C code
 */
void vala_namespace_set_lower_case_cprefix (ValaNamespace* self, const char* cprefix) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cprefix != NULL);
	self->priv->lower_case_cprefix = (_tmp0_ = g_strdup (cprefix), _g_free0 (self->priv->lower_case_cprefix), _tmp0_);
}


static void vala_namespace_process_ccode_attribute (ValaNamespace* self, ValaAttribute* a) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	if (vala_attribute_has_argument (a, "cprefix")) {
		char* value;
		value = vala_attribute_get_string (a, "cprefix");
		if (_vala_strcmp0 (value, "") == 0) {
			vala_namespace_add_cprefix (self, "");
		} else {
			char** _tmp0_;
			{
				char** name_collection;
				int name_collection_length1;
				int name_it;
				name_collection = _tmp0_ = g_strsplit (value, ",", 0);
				name_collection_length1 = _vala_array_length (_tmp0_);
				for (name_it = 0; name_it < _vala_array_length (_tmp0_); name_it = name_it + 1) {
					char* name;
					name = g_strdup (name_collection[name_it]);
					{
						vala_namespace_add_cprefix (self, name);
						_g_free0 (name);
					}
				}
				name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
			}
		}
		_g_free0 (value);
	}
	if (vala_attribute_has_argument (a, "lower_case_cprefix")) {
		char* _tmp1_;
		vala_namespace_set_lower_case_cprefix (self, _tmp1_ = vala_attribute_get_string (a, "lower_case_cprefix"));
		_g_free0 (_tmp1_);
	}
	if (vala_attribute_has_argument (a, "cheader_filename")) {
		char* val;
		char** _tmp2_;
		val = vala_attribute_get_string (a, "cheader_filename");
		{
			char** filename_collection;
			int filename_collection_length1;
			int filename_it;
			filename_collection = _tmp2_ = g_strsplit (val, ",", 0);
			filename_collection_length1 = _vala_array_length (_tmp2_);
			for (filename_it = 0; filename_it < _vala_array_length (_tmp2_); filename_it = filename_it + 1) {
				char* filename;
				filename = g_strdup (filename_collection[filename_it]);
				{
					vala_symbol_add_cheader_filename ((ValaSymbol*) self, filename);
					_g_free0 (filename);
				}
			}
			filename_collection = (_vala_array_free (filename_collection, filename_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (val);
	}
	if (vala_attribute_has_argument (a, "gir_namespace")) {
		char* _tmp3_;
		vala_source_file_set_gir_namespace (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)), _tmp3_ = vala_attribute_get_string (a, "gir_namespace"));
		_g_free0 (_tmp3_);
	}
	if (vala_attribute_has_argument (a, "gir_version")) {
		char* _tmp4_;
		vala_source_file_set_gir_version (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)), _tmp4_ = vala_attribute_get_string (a, "gir_version"));
		_g_free0 (_tmp4_);
	}
}


/**
 * Process all associated attributes.
 */
static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_namespace_process_attributes (ValaNamespace* self) {
	g_return_if_fail (self != NULL);
	{
		GList* a_collection;
		GList* a_it;
		a_collection = ((ValaCodeNode*) self)->attributes;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* a;
			a = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
			{
				if (_vala_strcmp0 (vala_attribute_get_name (a), "CCode") == 0) {
					vala_namespace_process_ccode_attribute (self, a);
				}
				_vala_code_node_unref0 (a);
			}
		}
	}
}


static gboolean vala_namespace_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaNamespace * self;
	gboolean result = FALSE;
	self = (ValaNamespace*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		result = !vala_code_node_get_error ((ValaCodeNode*) self);
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	vala_namespace_process_attributes (self);
	{
		ValaList* _ns_list;
		gint _ns_size;
		gint _ns_index;
		_ns_list = _vala_iterable_ref0 (self->priv->namespaces);
		_ns_size = vala_collection_get_size ((ValaCollection*) _ns_list);
		_ns_index = -1;
		while (TRUE) {
			ValaNamespace* ns;
			if (!((_ns_index = _ns_index + 1) < _ns_size)) {
				break;
			}
			ns = (ValaNamespace*) vala_list_get (_ns_list, _ns_index);
			vala_code_node_check ((ValaCodeNode*) ns, analyzer);
			_vala_code_node_unref0 (ns);
		}
		_vala_iterable_unref0 (_ns_list);
	}
	result = !vala_code_node_get_error ((ValaCodeNode*) self);
	return result;
}


static void vala_namespace_class_init (ValaNamespaceClass * klass) {
	vala_namespace_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_namespace_finalize;
	g_type_class_add_private (klass, sizeof (ValaNamespacePrivate));
	VALA_SYMBOL_CLASS (klass)->add_namespace = vala_namespace_real_add_namespace;
	VALA_SYMBOL_CLASS (klass)->add_class = vala_namespace_real_add_class;
	VALA_SYMBOL_CLASS (klass)->add_interface = vala_namespace_real_add_interface;
	VALA_SYMBOL_CLASS (klass)->add_struct = vala_namespace_real_add_struct;
	VALA_SYMBOL_CLASS (klass)->add_enum = vala_namespace_real_add_enum;
	VALA_SYMBOL_CLASS (klass)->add_error_domain = vala_namespace_real_add_error_domain;
	VALA_SYMBOL_CLASS (klass)->add_delegate = vala_namespace_real_add_delegate;
	VALA_SYMBOL_CLASS (klass)->add_constant = vala_namespace_real_add_constant;
	VALA_SYMBOL_CLASS (klass)->add_field = vala_namespace_real_add_field;
	VALA_SYMBOL_CLASS (klass)->add_method = vala_namespace_real_add_method;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_namespace_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_namespace_real_accept_children;
	VALA_SYMBOL_CLASS (klass)->get_cprefix = vala_namespace_real_get_cprefix;
	VALA_SYMBOL_CLASS (klass)->get_lower_case_cprefix = vala_namespace_real_get_lower_case_cprefix;
	VALA_CODE_NODE_CLASS (klass)->check = vala_namespace_real_check;
}


static void vala_namespace_instance_init (ValaNamespace * self) {
	self->priv = VALA_NAMESPACE_GET_PRIVATE (self);
	self->priv->classes = (ValaList*) vala_array_list_new (VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->interfaces = (ValaList*) vala_array_list_new (VALA_TYPE_INTERFACE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->structs = (ValaList*) vala_array_list_new (VALA_TYPE_STRUCT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->enums = (ValaList*) vala_array_list_new (VALA_TYPE_ENUM, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->error_domains = (ValaList*) vala_array_list_new (VALA_TYPE_ERROR_DOMAIN, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->delegates = (ValaList*) vala_array_list_new (VALA_TYPE_DELEGATE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->constants = (ValaList*) vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->fields = (ValaList*) vala_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->methods = (ValaList*) vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->comments = (ValaList*) vala_array_list_new (VALA_TYPE_COMMENT, (GBoxedCopyFunc) vala_comment_ref, vala_comment_unref, g_direct_equal);
	self->priv->cprefixes = (ValaList*) vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	self->priv->namespaces = (ValaList*) vala_array_list_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->using_directives = (ValaList*) vala_array_list_new (VALA_TYPE_USING_DIRECTIVE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
}


static void vala_namespace_finalize (ValaCodeNode* obj) {
	ValaNamespace * self;
	self = VALA_NAMESPACE (obj);
	_vala_iterable_unref0 (self->priv->classes);
	_vala_iterable_unref0 (self->priv->interfaces);
	_vala_iterable_unref0 (self->priv->structs);
	_vala_iterable_unref0 (self->priv->enums);
	_vala_iterable_unref0 (self->priv->error_domains);
	_vala_iterable_unref0 (self->priv->delegates);
	_vala_iterable_unref0 (self->priv->constants);
	_vala_iterable_unref0 (self->priv->fields);
	_vala_iterable_unref0 (self->priv->methods);
	_vala_iterable_unref0 (self->priv->comments);
	_vala_iterable_unref0 (self->priv->cprefixes);
	_g_free0 (self->priv->lower_case_cprefix);
	_vala_iterable_unref0 (self->priv->namespaces);
	_vala_iterable_unref0 (self->priv->using_directives);
	VALA_CODE_NODE_CLASS (vala_namespace_parent_class)->finalize (obj);
}


/**
 * Represents a namespace declaration in the source code.
 */
GType vala_namespace_get_type (void) {
	static volatile gsize vala_namespace_type_id__volatile = 0;
	if (g_once_init_enter (&vala_namespace_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaNamespaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_namespace_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaNamespace), 0, (GInstanceInitFunc) vala_namespace_instance_init, NULL };
		GType vala_namespace_type_id;
		vala_namespace_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaNamespace", &g_define_type_info, 0);
		g_once_init_leave (&vala_namespace_type_id__volatile, vala_namespace_type_id);
	}
	return vala_namespace_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



