/* valacodecontext.c generated by valac, the Vala compiler
 * generated from valacodecontext.vala, do not modify */

/* valacodecontext.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib/gstdio.h>
#include <config.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;
typedef struct _ValaCodeContextPrivate ValaCodeContextPrivate;

#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROFILE (vala_profile_get_type ())

#define VALA_TYPE_REPORT (vala_report_get_type ())
#define VALA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REPORT, ValaReport))
#define VALA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REPORT, ValaReportClass))
#define VALA_IS_REPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REPORT))
#define VALA_IS_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REPORT))
#define VALA_REPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REPORT, ValaReportClass))

typedef struct _ValaReport ValaReport;
typedef struct _ValaReportClass ValaReportClass;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

#define TYPE_SOURCE_FILE_TYPE (source_file_type_get_type ())
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_UNRESOLVED_SYMBOL (vala_unresolved_symbol_get_type ())
#define VALA_UNRESOLVED_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbol))
#define VALA_UNRESOLVED_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbolClass))
#define VALA_IS_UNRESOLVED_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_UNRESOLVED_SYMBOL))
#define VALA_IS_UNRESOLVED_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_UNRESOLVED_SYMBOL))
#define VALA_UNRESOLVED_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbolClass))

typedef struct _ValaUnresolvedSymbol ValaUnresolvedSymbol;
typedef struct _ValaUnresolvedSymbolClass ValaUnresolvedSymbolClass;

#define VALA_TYPE_USING_DIRECTIVE (vala_using_directive_get_type ())
#define VALA_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirective))
#define VALA_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))
#define VALA_IS_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_USING_DIRECTIVE))
#define VALA_IS_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_USING_DIRECTIVE))
#define VALA_USING_DIRECTIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))

typedef struct _ValaUsingDirective ValaUsingDirective;
typedef struct _ValaUsingDirectiveClass ValaUsingDirectiveClass;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
typedef struct _ValaParamSpecCodeContext ValaParamSpecCodeContext;

struct _ValaCodeContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeContextPrivate * priv;
	char** vapi_directories;
	gint vapi_directories_length1;
	char** gir_directories;
	gint gir_directories_length1;
};

struct _ValaCodeContextClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeContext *self);
};

typedef enum  {
	VALA_PROFILE_POSIX,
	VALA_PROFILE_GOBJECT,
	VALA_PROFILE_DOVA
} ValaProfile;

struct _ValaCodeContextPrivate {
	gboolean _assert;
	gboolean _checking;
	gboolean _deprecated;
	gboolean _experimental;
	gboolean _experimental_non_null;
	gboolean _dbus_transformation;
	gboolean _ccode_only;
	char* _header_filename;
	char* _internal_header_filename;
	gboolean _use_header;
	char* _includedir;
	char* _symbols_filename;
	gboolean _compile_only;
	char* _output;
	char* _basedir;
	char* _directory;
	gboolean _debug;
	gint _optlevel;
	gboolean _thread;
	gboolean _mem_profiler;
	ValaMethod* _module_init_method;
	gboolean _save_temps;
	ValaProfile _profile;
	gint _target_glib_major;
	gint _target_glib_minor;
	gboolean _verbose_mode;
	gboolean _version_header;
	gboolean _nostdpkg;
	ValaReport* _report;
	ValaMethod* _entry_point;
	char* _entry_point_name;
	gboolean _run_output;
	ValaList* source_files;
	ValaList* c_source_files;
	ValaNamespace* _root;
	ValaList* packages;
	ValaSet* defines;
	ValaCodeGenerator* _codegen;
};

typedef enum  {
	SOURCE_FILE_TYPE_NONE,
	SOURCE_FILE_TYPE_SOURCE,
	SOURCE_FILE_TYPE_PACKAGE,
	SOURCE_FILE_TYPE_FAST
} SourceFileType;

struct _ValaParamSpecCodeContext {
	GParamSpec parent_instance;
};


static gpointer vala_code_context_parent_class = NULL;
static GStaticPrivate vala_code_context_context_stack_key;
static GStaticPrivate vala_code_context_context_stack_key = {0};

gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_profile_get_type (void) G_GNUC_CONST;
GType vala_report_get_type (void) G_GNUC_CONST;
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
#define VALA_CODE_CONTEXT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CODE_CONTEXT, ValaCodeContextPrivate))
enum  {
	VALA_CODE_CONTEXT_DUMMY_PROPERTY
};
ValaReport* vala_report_new (void);
ValaReport* vala_report_construct (GType object_type);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
ValaNamespace* vala_namespace_new (const char* name, ValaSourceReference* source_reference);
ValaNamespace* vala_namespace_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
ValaCodeGenerator* vala_code_generator_new (void);
ValaCodeGenerator* vala_code_generator_construct (GType object_type);
gboolean vala_code_context_require_glib_version (ValaCodeContext* self, gint major, gint minor);
gint vala_code_context_get_target_glib_major (ValaCodeContext* self);
gint vala_code_context_get_target_glib_minor (ValaCodeContext* self);
ValaCodeContext* vala_code_context_new (void);
ValaCodeContext* vala_code_context_construct (GType object_type);
ValaCodeContext* vala_code_context_get (void);
void vala_code_context_push (ValaCodeContext* context);
void vala_code_context_pop (void);
ValaList* vala_code_context_get_source_files (ValaCodeContext* self);
ValaList* vala_code_context_get_c_source_files (ValaCodeContext* self);
void vala_code_context_add_source_file (ValaCodeContext* self, ValaSourceFile* file);
void vala_code_context_add_c_source_file (ValaCodeContext* self, const char* file);
ValaList* vala_code_context_get_packages (ValaCodeContext* self);
gboolean vala_code_context_has_package (ValaCodeContext* self, const char* pkg);
void vala_code_context_add_package (ValaCodeContext* self, const char* pkg);
gboolean vala_code_context_add_external_package (ValaCodeContext* self, const char* pkg);
char* vala_code_context_get_vapi_path (ValaCodeContext* self, const char* pkg);
char* vala_code_context_get_gir_path (ValaCodeContext* self, const char* gir);
void vala_report_error (ValaSourceReference* source, const char* message);
GType source_file_type_get_type (void) G_GNUC_CONST;
ValaSourceFile* vala_source_file_new (ValaCodeContext* context, SourceFileType type, const char* filename, const char* content);
ValaSourceFile* vala_source_file_construct (GType object_type, ValaCodeContext* context, SourceFileType type, const char* filename, const char* content);
gboolean vala_code_context_add_packages_from_file (ValaCodeContext* self, const char* filename);
gboolean vala_code_context_add_source_filename (ValaCodeContext* self, const char* filename, gboolean is_source);
char* vala_code_context_realpath (const char* name);
void vala_source_file_set_relative_filename (ValaSourceFile* self, const char* value);
ValaProfile vala_code_context_get_profile (ValaCodeContext* self);
GType vala_unresolved_symbol_get_type (void) G_GNUC_CONST;
ValaUnresolvedSymbol* vala_unresolved_symbol_new (ValaUnresolvedSymbol* inner, const char* name, ValaSourceReference* source_reference);
ValaUnresolvedSymbol* vala_unresolved_symbol_construct (GType object_type, ValaUnresolvedSymbol* inner, const char* name, ValaSourceReference* source_reference);
ValaUsingDirective* vala_using_directive_new (ValaSymbol* namespace_symbol, ValaSourceReference* source_reference);
ValaUsingDirective* vala_using_directive_construct (GType object_type, ValaSymbol* namespace_symbol, ValaSourceReference* source_reference);
GType vala_using_directive_get_type (void) G_GNUC_CONST;
void vala_source_file_add_using_directive (ValaSourceFile* self, ValaUsingDirective* ns);
ValaNamespace* vala_code_context_get_root (ValaCodeContext* self);
void vala_namespace_add_using_directive (ValaNamespace* self, ValaUsingDirective* ns);
void vala_code_context_accept (ValaCodeContext* self, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
void vala_source_file_accept (ValaSourceFile* self, ValaCodeVisitor* visitor);
void vala_code_context_add_define (ValaCodeContext* self, const char* define);
gboolean vala_code_context_is_defined (ValaCodeContext* self, const char* define);
static char* vala_code_context_get_file_path (ValaCodeContext* self, const char* basename, const char* versioned_data_dir, const char* data_dir, char** directories, int directories_length1);
void vala_code_context_write_dependencies (ValaCodeContext* self, const char* filename);
SourceFileType vala_source_file_get_file_type (ValaSourceFile* self);
gboolean vala_source_file_get_used (ValaSourceFile* self);
const char* vala_source_file_get_filename (ValaSourceFile* self);
static gboolean vala_code_context_ends_with_dir_separator (const char* s);
gboolean vala_code_context_get_assert (ValaCodeContext* self);
void vala_code_context_set_assert (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_checking (ValaCodeContext* self);
void vala_code_context_set_checking (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_deprecated (ValaCodeContext* self);
void vala_code_context_set_deprecated (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_experimental (ValaCodeContext* self);
void vala_code_context_set_experimental (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_experimental_non_null (ValaCodeContext* self);
void vala_code_context_set_experimental_non_null (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_dbus_transformation (ValaCodeContext* self);
void vala_code_context_set_dbus_transformation (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_ccode_only (ValaCodeContext* self);
void vala_code_context_set_ccode_only (ValaCodeContext* self, gboolean value);
const char* vala_code_context_get_header_filename (ValaCodeContext* self);
void vala_code_context_set_header_filename (ValaCodeContext* self, const char* value);
const char* vala_code_context_get_internal_header_filename (ValaCodeContext* self);
void vala_code_context_set_internal_header_filename (ValaCodeContext* self, const char* value);
gboolean vala_code_context_get_use_header (ValaCodeContext* self);
void vala_code_context_set_use_header (ValaCodeContext* self, gboolean value);
const char* vala_code_context_get_includedir (ValaCodeContext* self);
void vala_code_context_set_includedir (ValaCodeContext* self, const char* value);
const char* vala_code_context_get_symbols_filename (ValaCodeContext* self);
void vala_code_context_set_symbols_filename (ValaCodeContext* self, const char* value);
gboolean vala_code_context_get_compile_only (ValaCodeContext* self);
void vala_code_context_set_compile_only (ValaCodeContext* self, gboolean value);
const char* vala_code_context_get_output (ValaCodeContext* self);
void vala_code_context_set_output (ValaCodeContext* self, const char* value);
const char* vala_code_context_get_basedir (ValaCodeContext* self);
void vala_code_context_set_basedir (ValaCodeContext* self, const char* value);
const char* vala_code_context_get_directory (ValaCodeContext* self);
void vala_code_context_set_directory (ValaCodeContext* self, const char* value);
gboolean vala_code_context_get_debug (ValaCodeContext* self);
void vala_code_context_set_debug (ValaCodeContext* self, gboolean value);
gint vala_code_context_get_optlevel (ValaCodeContext* self);
void vala_code_context_set_optlevel (ValaCodeContext* self, gint value);
gboolean vala_code_context_get_thread (ValaCodeContext* self);
void vala_code_context_set_thread (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_mem_profiler (ValaCodeContext* self);
void vala_code_context_set_mem_profiler (ValaCodeContext* self, gboolean value);
ValaMethod* vala_code_context_get_module_init_method (ValaCodeContext* self);
void vala_code_context_set_module_init_method (ValaCodeContext* self, ValaMethod* value);
gboolean vala_code_context_get_save_temps (ValaCodeContext* self);
void vala_code_context_set_save_temps (ValaCodeContext* self, gboolean value);
void vala_code_context_set_profile (ValaCodeContext* self, ValaProfile value);
void vala_code_context_set_target_glib_major (ValaCodeContext* self, gint value);
void vala_code_context_set_target_glib_minor (ValaCodeContext* self, gint value);
gboolean vala_code_context_get_verbose_mode (ValaCodeContext* self);
void vala_code_context_set_verbose_mode (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_version_header (ValaCodeContext* self);
void vala_code_context_set_version_header (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_nostdpkg (ValaCodeContext* self);
void vala_code_context_set_nostdpkg (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_save_csources (ValaCodeContext* self);
ValaReport* vala_code_context_get_report (ValaCodeContext* self);
void vala_code_context_set_report (ValaCodeContext* self, ValaReport* value);
ValaMethod* vala_code_context_get_entry_point (ValaCodeContext* self);
void vala_code_context_set_entry_point (ValaCodeContext* self, ValaMethod* value);
const char* vala_code_context_get_entry_point_name (ValaCodeContext* self);
void vala_code_context_set_entry_point_name (ValaCodeContext* self, const char* value);
gboolean vala_code_context_get_run_output (ValaCodeContext* self);
void vala_code_context_set_run_output (ValaCodeContext* self, gboolean value);
ValaCodeGenerator* vala_code_context_get_codegen (ValaCodeContext* self);
void vala_code_context_set_codegen (ValaCodeContext* self, ValaCodeGenerator* value);
static void vala_code_context_finalize (ValaCodeContext* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);


/**
 * Returns true if the target version of glib is greater than or 
 * equal to the specified version.
 */
gboolean vala_code_context_require_glib_version (ValaCodeContext* self, gint major, gint minor) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_target_glib_major > major) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		if (self->priv->_target_glib_major == major) {
			_tmp1_ = self->priv->_target_glib_minor >= minor;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	result = _tmp0_;
	return result;
}


ValaCodeContext* vala_code_context_construct (GType object_type) {
	ValaCodeContext* self;
	self = (ValaCodeContext*) g_type_create_instance (object_type);
	return self;
}


ValaCodeContext* vala_code_context_new (void) {
	return vala_code_context_construct (VALA_TYPE_CODE_CONTEXT);
}


/**
 * Return the topmost context from the context stack.
 */
ValaCodeContext* vala_code_context_get (void) {
	ValaCodeContext* result = NULL;
	ValaList* context_stack;
	context_stack = g_static_private_get (&vala_code_context_context_stack_key);
	result = (ValaCodeContext*) vala_list_get (context_stack, vala_collection_get_size ((ValaCollection*) context_stack) - 1);
	return result;
}


/**
 * Push the specified context to the context stack.
 */
void vala_code_context_push (ValaCodeContext* context) {
	ValaArrayList* context_stack;
	g_return_if_fail (context != NULL);
	context_stack = g_static_private_get (&vala_code_context_context_stack_key);
	if (context_stack == NULL) {
		context_stack = vala_array_list_new (VALA_TYPE_CODE_CONTEXT, (GBoxedCopyFunc) vala_code_context_ref, vala_code_context_unref, g_direct_equal);
		g_static_private_set (&vala_code_context_context_stack_key, context_stack, NULL);
	}
	vala_collection_add ((ValaCollection*) context_stack, context);
}


/**
 * Remove the topmost context from the context stack.
 */
void vala_code_context_pop (void) {
	ValaList* context_stack;
	context_stack = g_static_private_get (&vala_code_context_context_stack_key);
	vala_list_remove_at (context_stack, vala_collection_get_size ((ValaCollection*) context_stack) - 1);
}


/**
 * Returns a copy of the list of source files.
 *
 * @return list of source files
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_code_context_get_source_files (ValaCodeContext* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_iterable_ref0 (self->priv->source_files);
	return result;
}


/**
 * Returns a copy of the list of C source files.
 *
 * @return list of C source files
 */
ValaList* vala_code_context_get_c_source_files (ValaCodeContext* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_iterable_ref0 (self->priv->c_source_files);
	return result;
}


/**
 * Adds the specified file to the list of source files.
 *
 * @param file a source file
 */
void vala_code_context_add_source_file (ValaCodeContext* self, ValaSourceFile* file) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	vala_collection_add ((ValaCollection*) self->priv->source_files, file);
}


/**
 * Adds the specified file to the list of C source files.
 *
 * @param file a C source file
 */
void vala_code_context_add_c_source_file (ValaCodeContext* self, const char* file) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	vala_collection_add ((ValaCollection*) self->priv->c_source_files, file);
}


/**
 * Returns a copy of the list of used packages.
 *
 * @return list of used packages
 */
ValaList* vala_code_context_get_packages (ValaCodeContext* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_iterable_ref0 (self->priv->packages);
	return result;
}


/**
 * Returns whether the specified package is being used.
 *
 * @param pkg a package name
 * @return    true if the specified package is being used
 */
gboolean vala_code_context_has_package (ValaCodeContext* self, const char* pkg) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pkg != NULL, FALSE);
	result = vala_collection_contains ((ValaCollection*) self->priv->packages, pkg);
	return result;
}


/**
 * Adds the specified package to the list of used packages.
 *
 * @param pkg a package name
 */
void vala_code_context_add_package (ValaCodeContext* self, const char* pkg) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (pkg != NULL);
	vala_collection_add ((ValaCollection*) self->priv->packages, pkg);
}


/**
 * Pull the specified package into the context.
 * The method is tolerant if the package has been already loaded.
 *
 * @param pkg a package name
 * @return false if the package could not be loaded
 *
 */
gboolean vala_code_context_add_external_package (ValaCodeContext* self, const char* pkg) {
	gboolean result = FALSE;
	char* path;
	ValaSourceFile* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* deps_filename;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pkg != NULL, FALSE);
	if (vala_code_context_has_package (self, pkg)) {
		result = TRUE;
		return result;
	}
	path = vala_code_context_get_vapi_path (self, pkg);
	if (path == NULL) {
		char* _tmp0_;
		path = (_tmp0_ = vala_code_context_get_gir_path (self, pkg), _g_free0 (path), _tmp0_);
	}
	if (path == NULL) {
		char* _tmp1_;
		vala_report_error (NULL, _tmp1_ = g_strdup_printf ("Package `%s' not found in specified Vala API directories or GObject-In" \
"trospection GIR directories", pkg));
		_g_free0 (_tmp1_);
		result = FALSE;
		_g_free0 (path);
		return result;
	}
	vala_code_context_add_package (self, pkg);
	vala_code_context_add_source_file (self, _tmp2_ = vala_source_file_new (self, SOURCE_FILE_TYPE_PACKAGE, path, NULL));
	_vala_source_file_unref0 (_tmp2_);
	deps_filename = (_tmp5_ = g_build_filename (_tmp3_ = g_path_get_dirname (path), _tmp4_ = g_strdup_printf ("%s.deps", pkg), NULL), _g_free0 (_tmp4_), _g_free0 (_tmp3_), _tmp5_);
	if (!vala_code_context_add_packages_from_file (self, deps_filename)) {
		result = FALSE;
		_g_free0 (deps_filename);
		_g_free0 (path);
		return result;
	}
	result = TRUE;
	_g_free0 (deps_filename);
	_g_free0 (path);
	return result;
}


/**
 * Read the given filename and pull in packages.
 * The method is tolerant if the file does not exist.
 *
 * @param filename a filanem
 * @return false if an error occurs while reading the file or if a package could not be added
 */
static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


gboolean vala_code_context_add_packages_from_file (ValaCodeContext* self, const char* filename) {
	gboolean result = FALSE;
	char* contents;
	char* _tmp0_ = NULL;
	char* _tmp1_;
	char** _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	if (!g_file_test (filename, G_FILE_TEST_EXISTS)) {
		result = TRUE;
		return result;
	}
	contents = NULL;
	g_file_get_contents (filename, &_tmp0_, NULL, &_inner_error_);
	contents = (_tmp1_ = _tmp0_, _g_free0 (contents), _tmp1_);
	if (_inner_error_ != NULL) {
		_g_free0 (contents);
		if (_inner_error_->domain == G_FILE_ERROR) {
			goto __catch0_g_file_error;
		}
		_g_free0 (contents);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	{
		char** package_collection;
		int package_collection_length1;
		int package_it;
		package_collection = _tmp2_ = g_strsplit (contents, "\n", 0);
		package_collection_length1 = _vala_array_length (_tmp2_);
		for (package_it = 0; package_it < _vala_array_length (_tmp2_); package_it = package_it + 1) {
			char* package;
			package = g_strdup (package_collection[package_it]);
			{
				char* _tmp3_;
				package = (_tmp3_ = string_strip (package), _g_free0 (package), _tmp3_);
				if (_vala_strcmp0 (package, "") != 0) {
					vala_code_context_add_external_package (self, package);
				}
				_g_free0 (package);
			}
		}
		package_collection = (_vala_array_free (package_collection, package_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (contents);
	goto __finally0;
	__catch0_g_file_error:
	{
		GError * e;
		char* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		vala_report_error (NULL, _tmp4_ = g_strdup_printf ("Unable to read dependency file: %s", e->message));
		_g_free0 (_tmp4_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


/**
 * Add the specified source file to the context. Only .vala, .vapi, .gs,
 * and .c extensions are supported.
 *
 * @param filename a filename
 * @param is_source true to force adding the file as .vala or .gs
 * @return false if the file is not recognized or the file does not exist
 */
gboolean vala_code_context_add_source_filename (ValaCodeContext* self, const char* filename, gboolean is_source) {
	gboolean result = FALSE;
	char* rpath;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	if (!g_file_test (filename, G_FILE_TEST_EXISTS)) {
		char* _tmp0_;
		vala_report_error (NULL, _tmp0_ = g_strdup_printf ("%s not found", filename));
		_g_free0 (_tmp0_);
		result = FALSE;
		return result;
	}
	rpath = vala_code_context_realpath (filename);
	if (is_source) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_str_has_suffix (filename, ".vala");
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_str_has_suffix (filename, ".gs");
	}
	if (_tmp1_) {
		ValaSourceFile* source_file;
		source_file = vala_source_file_new (self, SOURCE_FILE_TYPE_SOURCE, rpath, NULL);
		vala_source_file_set_relative_filename (source_file, filename);
		if (self->priv->_profile == VALA_PROFILE_POSIX) {
			ValaUnresolvedSymbol* _tmp3_;
			ValaUsingDirective* _tmp4_;
			ValaUsingDirective* ns_ref;
			ns_ref = (_tmp4_ = vala_using_directive_new ((ValaSymbol*) (_tmp3_ = vala_unresolved_symbol_new (NULL, "Posix", NULL)), NULL), _vala_code_node_unref0 (_tmp3_), _tmp4_);
			vala_source_file_add_using_directive (source_file, ns_ref);
			vala_namespace_add_using_directive (vala_code_context_get_root (self), ns_ref);
			_vala_code_node_unref0 (ns_ref);
		} else {
			if (self->priv->_profile == VALA_PROFILE_GOBJECT) {
				ValaUnresolvedSymbol* _tmp5_;
				ValaUsingDirective* _tmp6_;
				ValaUsingDirective* ns_ref;
				ns_ref = (_tmp6_ = vala_using_directive_new ((ValaSymbol*) (_tmp5_ = vala_unresolved_symbol_new (NULL, "GLib", NULL)), NULL), _vala_code_node_unref0 (_tmp5_), _tmp6_);
				vala_source_file_add_using_directive (source_file, ns_ref);
				vala_namespace_add_using_directive (vala_code_context_get_root (self), ns_ref);
				_vala_code_node_unref0 (ns_ref);
			} else {
				if (self->priv->_profile == VALA_PROFILE_DOVA) {
					ValaUnresolvedSymbol* _tmp7_;
					ValaUsingDirective* _tmp8_;
					ValaUsingDirective* ns_ref;
					ns_ref = (_tmp8_ = vala_using_directive_new ((ValaSymbol*) (_tmp7_ = vala_unresolved_symbol_new (NULL, "Dova", NULL)), NULL), _vala_code_node_unref0 (_tmp7_), _tmp8_);
					vala_source_file_add_using_directive (source_file, ns_ref);
					vala_namespace_add_using_directive (vala_code_context_get_root (self), ns_ref);
					_vala_code_node_unref0 (ns_ref);
				}
			}
		}
		vala_code_context_add_source_file (self, source_file);
		_vala_source_file_unref0 (source_file);
	} else {
		gboolean _tmp9_ = FALSE;
		if (g_str_has_suffix (filename, ".vapi")) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = g_str_has_suffix (filename, ".gir");
		}
		if (_tmp9_) {
			ValaSourceFile* source_file;
			char* _tmp10_;
			char* _tmp11_;
			char* deps_filename;
			source_file = vala_source_file_new (self, SOURCE_FILE_TYPE_PACKAGE, rpath, NULL);
			vala_source_file_set_relative_filename (source_file, filename);
			vala_code_context_add_source_file (self, source_file);
			deps_filename = (_tmp11_ = g_strdup_printf ("%s.deps", _tmp10_ = g_strndup (filename, (gsize) (strlen (filename) - strlen (".vapi")))), _g_free0 (_tmp10_), _tmp11_);
			if (!vala_code_context_add_packages_from_file (self, deps_filename)) {
				result = FALSE;
				_g_free0 (deps_filename);
				_vala_source_file_unref0 (source_file);
				_g_free0 (rpath);
				return result;
			}
			_g_free0 (deps_filename);
			_vala_source_file_unref0 (source_file);
		} else {
			if (g_str_has_suffix (filename, ".c")) {
				vala_code_context_add_c_source_file (self, rpath);
			} else {
				char* _tmp12_;
				vala_report_error (NULL, _tmp12_ = g_strdup_printf ("%s is not a supported source file type. Only .vala, .vapi, .gs, and .c" \
" files are supported.", filename));
				_g_free0 (_tmp12_);
				result = FALSE;
				_g_free0 (rpath);
				return result;
			}
		}
	}
	result = TRUE;
	_g_free0 (rpath);
	return result;
}


/**
 * Visits the complete code tree file by file.
 * It is possible to add new source files while visiting the tree.
 *
 * @param visitor the visitor to be called when traversing
 */
void vala_code_context_accept (ValaCodeContext* self, ValaCodeVisitor* visitor) {
	gint index;
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
	vala_code_node_accept ((ValaCodeNode*) vala_code_context_get_root (self), visitor);
	index = 0;
	while (TRUE) {
		ValaSourceFile* source_file;
		if (!(index < vala_collection_get_size ((ValaCollection*) self->priv->source_files))) {
			break;
		}
		source_file = (ValaSourceFile*) vala_list_get (self->priv->source_files, index);
		vala_source_file_accept (source_file, visitor);
		index++;
		_vala_source_file_unref0 (source_file);
	}
}


void vala_code_context_add_define (ValaCodeContext* self, const char* define) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (define != NULL);
	vala_collection_add ((ValaCollection*) self->priv->defines, define);
}


gboolean vala_code_context_is_defined (ValaCodeContext* self, const char* define) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (define != NULL, FALSE);
	result = vala_collection_contains ((ValaCollection*) self->priv->defines, define);
	return result;
}


char* vala_code_context_get_vapi_path (ValaCodeContext* self, const char* pkg) {
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	char* path;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pkg != NULL, NULL);
	path = (_tmp1_ = vala_code_context_get_file_path (self, _tmp0_ = g_strconcat (pkg, ".vapi", NULL), "vala" PACKAGE_SUFFIX "/vapi", "vala/vapi", self->vapi_directories, self->vapi_directories_length1), _g_free0 (_tmp0_), _tmp1_);
	if (path == NULL) {
		char* _tmp2_;
		char* _tmp3_;
		char* filename;
		filename = (_tmp3_ = g_build_filename (PACKAGE_DATADIR, "vapi", _tmp2_ = g_strconcat (pkg, ".vapi", NULL), NULL), _g_free0 (_tmp2_), _tmp3_);
		if (g_file_test (filename, G_FILE_TEST_EXISTS)) {
			char* _tmp4_;
			path = (_tmp4_ = g_strdup (filename), _g_free0 (path), _tmp4_);
		}
		_g_free0 (filename);
	}
	result = path;
	return result;
}


char* vala_code_context_get_gir_path (ValaCodeContext* self, const char* gir) {
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gir != NULL, NULL);
	result = (_tmp1_ = vala_code_context_get_file_path (self, _tmp0_ = g_strconcat (gir, ".gir", NULL), "gir-1.0", NULL, self->gir_directories, self->gir_directories_length1), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static char* vala_code_context_get_file_path (ValaCodeContext* self, const char* basename, const char* versioned_data_dir, const char* data_dir, char** directories, int directories_length1) {
	char* result = NULL;
	char* filename;
	char** _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (basename != NULL, NULL);
	g_return_val_if_fail (versioned_data_dir != NULL, NULL);
	filename = NULL;
	if (directories != NULL) {
		{
			char** dir_collection;
			int dir_collection_length1;
			int dir_it;
			dir_collection = directories;
			dir_collection_length1 = directories_length1;
			for (dir_it = 0; dir_it < directories_length1; dir_it = dir_it + 1) {
				char* dir;
				dir = g_strdup (dir_collection[dir_it]);
				{
					char* _tmp0_;
					filename = (_tmp0_ = g_build_filename (dir, basename, NULL), _g_free0 (filename), _tmp0_);
					if (g_file_test (filename, G_FILE_TEST_EXISTS)) {
						result = filename;
						_g_free0 (dir);
						return result;
					}
					_g_free0 (dir);
				}
			}
		}
	}
	{
		char** dir_collection;
		int dir_collection_length1;
		int dir_it;
		dir_collection = _tmp1_ = g_get_system_data_dirs ();
		dir_collection_length1 = _vala_array_length (_tmp1_);
		for (dir_it = 0; dir_it < _vala_array_length (_tmp1_); dir_it = dir_it + 1) {
			char* dir;
			dir = g_strdup (dir_collection[dir_it]);
			{
				char* _tmp2_;
				filename = (_tmp2_ = g_build_filename (dir, versioned_data_dir, basename, NULL), _g_free0 (filename), _tmp2_);
				if (g_file_test (filename, G_FILE_TEST_EXISTS)) {
					result = filename;
					_g_free0 (dir);
					return result;
				}
				_g_free0 (dir);
			}
		}
	}
	if (data_dir != NULL) {
		char** _tmp3_;
		{
			char** dir_collection;
			int dir_collection_length1;
			int dir_it;
			dir_collection = _tmp3_ = g_get_system_data_dirs ();
			dir_collection_length1 = _vala_array_length (_tmp3_);
			for (dir_it = 0; dir_it < _vala_array_length (_tmp3_); dir_it = dir_it + 1) {
				char* dir;
				dir = g_strdup (dir_collection[dir_it]);
				{
					char* _tmp4_;
					filename = (_tmp4_ = g_build_filename (dir, data_dir, basename, NULL), _g_free0 (filename), _tmp4_);
					if (g_file_test (filename, G_FILE_TEST_EXISTS)) {
						result = filename;
						_g_free0 (dir);
						return result;
					}
					_g_free0 (dir);
				}
			}
		}
	}
	result = NULL;
	_g_free0 (filename);
	return result;
}


void vala_code_context_write_dependencies (ValaCodeContext* self, const char* filename) {
	FILE* stream;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	stream = fopen (filename, "w");
	if (stream == NULL) {
		char* _tmp0_;
		vala_report_error (NULL, _tmp0_ = g_strdup_printf ("unable to open `%s' for writing", filename));
		_g_free0 (_tmp0_);
		_fclose0 (stream);
		return;
	}
	fprintf (stream, "%s:", filename);
	{
		ValaList* _src_list;
		gint _src_size;
		gint _src_index;
		_src_list = _vala_iterable_ref0 (self->priv->source_files);
		_src_size = vala_collection_get_size ((ValaCollection*) _src_list);
		_src_index = -1;
		while (TRUE) {
			ValaSourceFile* src;
			gboolean _tmp1_ = FALSE;
			if (!((_src_index = _src_index + 1) < _src_size)) {
				break;
			}
			src = (ValaSourceFile*) vala_list_get (_src_list, _src_index);
			if (vala_source_file_get_file_type (src) == SOURCE_FILE_TYPE_FAST) {
				_tmp1_ = vala_source_file_get_used (src);
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				fprintf (stream, " %s", vala_source_file_get_filename (src));
			}
			_vala_source_file_unref0 (src);
		}
		_vala_iterable_unref0 (_src_list);
	}
	fprintf (stream, "\n\n");
	_fclose0 (stream);
}


static const char* string_offset (const char* self, glong offset) {
	const char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const char*) (((gchar*) self) + offset);
	return result;
}


static gunichar string_get_char (const char* self, gint index) {
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}


static gboolean vala_code_context_ends_with_dir_separator (const char* s) {
	gboolean result = FALSE;
	g_return_val_if_fail (s != NULL, FALSE);
	result = G_IS_DIR_SEPARATOR (string_get_char (string_offset (s, strlen (s) - 1), 0));
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = strlen (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = string_offset (self, offset);
	result = g_strndup (start, ((gchar*) string_offset (start, len)) - ((gchar*) start));
	return result;
}


static glong string_pointer_to_offset (const char* self, const char* pos) {
	glong result = 0L;
	g_return_val_if_fail (self != NULL, 0L);
	g_return_val_if_fail (pos != NULL, 0L);
	result = (glong) (((gchar*) pos) - ((gchar*) self));
	return result;
}


char* vala_code_context_realpath (const char* name) {
	char* result = NULL;
	char* rpath;
	const char* start;
	const char* end;
	glong root_len;
	gboolean _tmp12_ = FALSE;
	g_return_val_if_fail (name != NULL, NULL);
	rpath = NULL;
	start = NULL;
	end = NULL;
	if (!g_path_is_absolute (name)) {
		char* _tmp0_;
		rpath = (_tmp0_ = g_get_current_dir (), _g_free0 (rpath), _tmp0_);
		start = end = name;
	} else {
		char* _tmp1_;
		start = end = g_path_skip_root (name);
		rpath = (_tmp1_ = string_substring (name, (glong) 0, string_pointer_to_offset (name, start)), _g_free0 (rpath), _tmp1_);
	}
	root_len = string_pointer_to_offset (rpath, g_path_skip_root (rpath));
	{
		gboolean _tmp2_;
		_tmp2_ = TRUE;
		while (TRUE) {
			glong len;
			if (!_tmp2_) {
				start = end;
			}
			_tmp2_ = FALSE;
			if (!(string_get_char (start, 0) != 0)) {
				break;
			}
			while (TRUE) {
				if (!G_IS_DIR_SEPARATOR (string_get_char (start, 0))) {
					break;
				}
				start = g_utf8_next_char (start);
			}
			len = (glong) 0;
			{
				gboolean _tmp3_;
				end = start;
				_tmp3_ = TRUE;
				while (TRUE) {
					gboolean _tmp4_ = FALSE;
					if (!_tmp3_) {
						end = g_utf8_next_char (end);
					}
					_tmp3_ = FALSE;
					if (string_get_char (end, 0) != 0) {
						_tmp4_ = !G_IS_DIR_SEPARATOR (string_get_char (end, 0));
					} else {
						_tmp4_ = FALSE;
					}
					if (!_tmp4_) {
						break;
					}
					len++;
				}
			}
			if (len == 0) {
				break;
			} else {
				gboolean _tmp5_ = FALSE;
				if (len == 1) {
					_tmp5_ = string_get_char (start, 0) == '.';
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
				} else {
					gboolean _tmp6_ = FALSE;
					if (len == 2) {
						_tmp6_ = g_str_has_prefix (start, "..");
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						if (strlen (rpath) > root_len) {
							{
								gboolean _tmp7_;
								_tmp7_ = TRUE;
								while (TRUE) {
									char* _tmp8_;
									if (!_tmp7_) {
										if (!(!vala_code_context_ends_with_dir_separator (rpath))) {
											break;
										}
									}
									_tmp7_ = FALSE;
									rpath = (_tmp8_ = string_substring (rpath, (glong) 0, strlen (rpath) - 1), _g_free0 (rpath), _tmp8_);
								}
							}
						}
					} else {
						char* _tmp10_;
						char* _tmp11_;
						if (!vala_code_context_ends_with_dir_separator (rpath)) {
							char* _tmp9_;
							rpath = (_tmp9_ = g_strconcat (rpath, G_DIR_SEPARATOR_S, NULL), _g_free0 (rpath), _tmp9_);
						}
						rpath = (_tmp11_ = g_strconcat (rpath, _tmp10_ = string_substring (start, (glong) 0, len), NULL), _g_free0 (rpath), _tmp11_);
						_g_free0 (_tmp10_);
					}
				}
			}
		}
	}
	if (strlen (rpath) > root_len) {
		_tmp12_ = vala_code_context_ends_with_dir_separator (rpath);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		char* _tmp13_;
		rpath = (_tmp13_ = string_substring (rpath, (glong) 0, strlen (rpath) - 1), _g_free0 (rpath), _tmp13_);
	}
	if (G_DIR_SEPARATOR != '/') {
		char** _tmp14_;
		gint components_length1;
		gint _components_size_;
		char** _tmp15_;
		char** components;
		char* _tmp16_;
		components = (_tmp15_ = _tmp14_ = g_strsplit (rpath, "\\", 0), components_length1 = _vala_array_length (_tmp14_), _components_size_ = components_length1, _tmp15_);
		rpath = (_tmp16_ = g_strjoinv ("/", components), _g_free0 (rpath), _tmp16_);
		components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
	}
	result = rpath;
	return result;
}


gboolean vala_code_context_get_assert (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_assert;
	return result;
}


void vala_code_context_set_assert (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_assert = value;
}


gboolean vala_code_context_get_checking (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_checking;
	return result;
}


void vala_code_context_set_checking (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_checking = value;
}


gboolean vala_code_context_get_deprecated (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_deprecated;
	return result;
}


void vala_code_context_set_deprecated (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_deprecated = value;
}


gboolean vala_code_context_get_experimental (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_experimental;
	return result;
}


void vala_code_context_set_experimental (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_experimental = value;
}


gboolean vala_code_context_get_experimental_non_null (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_experimental_non_null;
	return result;
}


void vala_code_context_set_experimental_non_null (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_experimental_non_null = value;
}


gboolean vala_code_context_get_dbus_transformation (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_dbus_transformation;
	return result;
}


void vala_code_context_set_dbus_transformation (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_dbus_transformation = value;
}


gboolean vala_code_context_get_ccode_only (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_ccode_only;
	return result;
}


void vala_code_context_set_ccode_only (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_ccode_only = value;
}


const char* vala_code_context_get_header_filename (ValaCodeContext* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_header_filename;
	return result;
}


void vala_code_context_set_header_filename (ValaCodeContext* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_header_filename = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_header_filename), _tmp0_);
}


const char* vala_code_context_get_internal_header_filename (ValaCodeContext* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_internal_header_filename;
	return result;
}


void vala_code_context_set_internal_header_filename (ValaCodeContext* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_internal_header_filename = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_internal_header_filename), _tmp0_);
}


gboolean vala_code_context_get_use_header (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_use_header;
	return result;
}


void vala_code_context_set_use_header (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_use_header = value;
}


const char* vala_code_context_get_includedir (ValaCodeContext* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_includedir;
	return result;
}


void vala_code_context_set_includedir (ValaCodeContext* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_includedir = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_includedir), _tmp0_);
}


const char* vala_code_context_get_symbols_filename (ValaCodeContext* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_symbols_filename;
	return result;
}


void vala_code_context_set_symbols_filename (ValaCodeContext* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_symbols_filename = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_symbols_filename), _tmp0_);
}


gboolean vala_code_context_get_compile_only (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_compile_only;
	return result;
}


void vala_code_context_set_compile_only (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_compile_only = value;
}


const char* vala_code_context_get_output (ValaCodeContext* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_output;
	return result;
}


void vala_code_context_set_output (ValaCodeContext* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_output = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_output), _tmp0_);
}


const char* vala_code_context_get_basedir (ValaCodeContext* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_basedir;
	return result;
}


void vala_code_context_set_basedir (ValaCodeContext* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_basedir = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_basedir), _tmp0_);
}


const char* vala_code_context_get_directory (ValaCodeContext* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_directory;
	return result;
}


void vala_code_context_set_directory (ValaCodeContext* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_directory = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_directory), _tmp0_);
}


gboolean vala_code_context_get_debug (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_debug;
	return result;
}


void vala_code_context_set_debug (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_debug = value;
}


gint vala_code_context_get_optlevel (ValaCodeContext* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_optlevel;
	return result;
}


void vala_code_context_set_optlevel (ValaCodeContext* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_optlevel = value;
}


gboolean vala_code_context_get_thread (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_thread;
	return result;
}


void vala_code_context_set_thread (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_thread = value;
}


gboolean vala_code_context_get_mem_profiler (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_mem_profiler;
	return result;
}


void vala_code_context_set_mem_profiler (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_mem_profiler = value;
}


ValaMethod* vala_code_context_get_module_init_method (ValaCodeContext* self) {
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_module_init_method;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_code_context_set_module_init_method (ValaCodeContext* self, ValaMethod* value) {
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_module_init_method = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_module_init_method), _tmp0_);
}


gboolean vala_code_context_get_save_temps (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_save_temps;
	return result;
}


void vala_code_context_set_save_temps (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_save_temps = value;
}


ValaProfile vala_code_context_get_profile (ValaCodeContext* self) {
	ValaProfile result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_profile;
	return result;
}


void vala_code_context_set_profile (ValaCodeContext* self, ValaProfile value) {
	g_return_if_fail (self != NULL);
	self->priv->_profile = value;
}


gint vala_code_context_get_target_glib_major (ValaCodeContext* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_target_glib_major;
	return result;
}


void vala_code_context_set_target_glib_major (ValaCodeContext* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_target_glib_major = value;
}


gint vala_code_context_get_target_glib_minor (ValaCodeContext* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_target_glib_minor;
	return result;
}


void vala_code_context_set_target_glib_minor (ValaCodeContext* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_target_glib_minor = value;
}


gboolean vala_code_context_get_verbose_mode (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_verbose_mode;
	return result;
}


void vala_code_context_set_verbose_mode (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_verbose_mode = value;
}


gboolean vala_code_context_get_version_header (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_version_header;
	return result;
}


void vala_code_context_set_version_header (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_version_header = value;
}


gboolean vala_code_context_get_nostdpkg (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_nostdpkg;
	return result;
}


void vala_code_context_set_nostdpkg (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_nostdpkg = value;
}


gboolean vala_code_context_get_save_csources (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_save_temps;
	return result;
}


ValaReport* vala_code_context_get_report (ValaCodeContext* self) {
	ValaReport* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_report;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void vala_code_context_set_report (ValaCodeContext* self, ValaReport* value) {
	ValaReport* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_report = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_report), _tmp0_);
}


ValaMethod* vala_code_context_get_entry_point (ValaCodeContext* self) {
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_entry_point;
	return result;
}


void vala_code_context_set_entry_point (ValaCodeContext* self, ValaMethod* value) {
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_entry_point = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_entry_point), _tmp0_);
}


const char* vala_code_context_get_entry_point_name (ValaCodeContext* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_entry_point_name;
	return result;
}


void vala_code_context_set_entry_point_name (ValaCodeContext* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_entry_point_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_entry_point_name), _tmp0_);
}


gboolean vala_code_context_get_run_output (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_run_output;
	return result;
}


void vala_code_context_set_run_output (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_run_output = value;
}


ValaNamespace* vala_code_context_get_root (ValaCodeContext* self) {
	ValaNamespace* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_root;
	return result;
}


ValaCodeGenerator* vala_code_context_get_codegen (ValaCodeContext* self) {
	ValaCodeGenerator* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_codegen;
	return result;
}


static gpointer _vala_code_visitor_ref0 (gpointer self) {
	return self ? vala_code_visitor_ref (self) : NULL;
}


void vala_code_context_set_codegen (ValaCodeContext* self, ValaCodeGenerator* value) {
	ValaCodeGenerator* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_codegen = (_tmp0_ = _vala_code_visitor_ref0 (value), _vala_code_visitor_unref0 (self->priv->_codegen), _tmp0_);
}


static void vala_value_code_context_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_code_context_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_code_context_unref (value->data[0].v_pointer);
	}
}


static void vala_value_code_context_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_code_context_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_code_context_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_code_context_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCodeContext* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_code_context_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_code_context_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCodeContext** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_code_context_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCodeContext* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CODE_CONTEXT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_code_context (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_CONTEXT), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_code_context (GValue* value, gpointer v_object) {
	ValaCodeContext* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CODE_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_code_context_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_code_context_unref (old);
	}
}


void vala_value_take_code_context (GValue* value, gpointer v_object) {
	ValaCodeContext* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CODE_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_code_context_unref (old);
	}
}


static void vala_code_context_class_init (ValaCodeContextClass * klass) {
	GStaticPrivate _tmp0_ = {0};
	vala_code_context_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_CONTEXT_CLASS (klass)->finalize = vala_code_context_finalize;
	g_type_class_add_private (klass, sizeof (ValaCodeContextPrivate));
	vala_code_context_context_stack_key = (g_static_private_init (&_tmp0_), _tmp0_);
}


static void vala_code_context_instance_init (ValaCodeContext * self) {
	self->priv = VALA_CODE_CONTEXT_GET_PRIVATE (self);
	self->priv->_report = vala_report_new ();
	self->priv->source_files = (ValaList*) vala_array_list_new (VALA_TYPE_SOURCE_FILE, (GBoxedCopyFunc) vala_source_file_ref, vala_source_file_unref, g_direct_equal);
	self->priv->c_source_files = (ValaList*) vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	self->priv->_root = vala_namespace_new (NULL, NULL);
	self->priv->packages = (ValaList*) vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	self->priv->defines = (ValaSet*) vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	self->priv->_codegen = vala_code_generator_new ();
	self->ref_count = 1;
}


static void vala_code_context_finalize (ValaCodeContext* obj) {
	ValaCodeContext * self;
	self = VALA_CODE_CONTEXT (obj);
	_g_free0 (self->priv->_header_filename);
	_g_free0 (self->priv->_internal_header_filename);
	_g_free0 (self->priv->_includedir);
	_g_free0 (self->priv->_symbols_filename);
	_g_free0 (self->priv->_output);
	_g_free0 (self->priv->_basedir);
	_g_free0 (self->priv->_directory);
	self->vapi_directories = (_vala_array_free (self->vapi_directories, self->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	self->gir_directories = (_vala_array_free (self->gir_directories, self->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (self->priv->_module_init_method);
	_g_object_unref0 (self->priv->_report);
	_vala_code_node_unref0 (self->priv->_entry_point);
	_g_free0 (self->priv->_entry_point_name);
	_vala_iterable_unref0 (self->priv->source_files);
	_vala_iterable_unref0 (self->priv->c_source_files);
	_vala_code_node_unref0 (self->priv->_root);
	_vala_iterable_unref0 (self->priv->packages);
	_vala_iterable_unref0 (self->priv->defines);
	_vala_code_visitor_unref0 (self->priv->_codegen);
}


/**
 * The root of the code tree.
 */
GType vala_code_context_get_type (void) {
	static volatile gsize vala_code_context_type_id__volatile = 0;
	if (g_once_init_enter (&vala_code_context_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_code_context_init, vala_value_code_context_free_value, vala_value_code_context_copy_value, vala_value_code_context_peek_pointer, "p", vala_value_code_context_collect_value, "p", vala_value_code_context_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCodeContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_code_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCodeContext), 0, (GInstanceInitFunc) vala_code_context_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_code_context_type_id;
		vala_code_context_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCodeContext", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_code_context_type_id__volatile, vala_code_context_type_id);
	}
	return vala_code_context_type_id__volatile;
}


gpointer vala_code_context_ref (gpointer instance) {
	ValaCodeContext* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_code_context_unref (gpointer instance) {
	ValaCodeContext* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CODE_CONTEXT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



