/* valaccodecontrolflowmodule.c generated by valac, the Vala compiler
 * generated from valaccodecontrolflowmodule.vala, do not modify */

/* valaccodecontrolflowmodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>


#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT (vala_ccode_base_module_emit_context_get_type ())
#define VALA_CCODE_BASE_MODULE_EMIT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT, ValaCCodeBaseModuleEmitContext))
#define VALA_CCODE_BASE_MODULE_EMIT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT, ValaCCodeBaseModuleEmitContextClass))
#define VALA_CCODE_BASE_MODULE_IS_EMIT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT))
#define VALA_CCODE_BASE_MODULE_IS_EMIT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT))
#define VALA_CCODE_BASE_MODULE_EMIT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT, ValaCCodeBaseModuleEmitContextClass))

typedef struct _ValaCCodeBaseModuleEmitContext ValaCCodeBaseModuleEmitContext;
typedef struct _ValaCCodeBaseModuleEmitContextClass ValaCCodeBaseModuleEmitContextClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaCCodeBaseModule {
	ValaCodeGenerator parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaCCodeBaseModuleEmitContext* emit_context;
	ValaCCodeFile* header_file;
	ValaCCodeFile* internal_header_file;
	ValaCCodeFile* cfile;
	ValaCCodeBaseModuleEmitContext* class_init_context;
	ValaCCodeBaseModuleEmitContext* base_init_context;
	ValaCCodeBaseModuleEmitContext* class_finalize_context;
	ValaCCodeBaseModuleEmitContext* base_finalize_context;
	ValaCCodeBaseModuleEmitContext* instance_init_context;
	ValaCCodeBaseModuleEmitContext* instance_finalize_context;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaSet* user_marshal_set;
	ValaSet* predefined_marshal_set;
	gint next_regex_id;
	gboolean in_constructor;
	gboolean in_static_or_class_context;
	gint next_coroutine_state;
	ValaDataType* void_type;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* regex_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaClass* gnode_type;
	ValaClass* gvaluearray_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaTypeSymbol* gthreadpool_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaClass* gvariant_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_proxy_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	ValaSet* wrappers;
};

struct _ValaCCodeBaseModuleClass {
	ValaCodeGeneratorClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	gboolean (*generate_enum_declaration) (ValaCCodeBaseModule* self, ValaEnum* en, ValaCCodeFile* decl_space);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeFile* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeFile* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeFile* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeFile* decl_space, ValaMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, ValaMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
	char* (*append_struct_array_free) (ValaCCodeBaseModule* self, ValaStruct* st);
	ValaCCodeExpression* (*get_unref_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr, gboolean is_macro_definition);
	void (*append_local_free) (ValaCCodeBaseModule* self, ValaSymbol* sym, gboolean stop_at_loop);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr, ValaCCodeExpression** delegate_target_destroy_notify);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeFile* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeFile* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeFile* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeFile* decl_space);
	ValaCCodeExpression* (*deserialize_expression) (ValaCCodeBaseModule* self, ValaCCodeFragment* fragment, ValaDataType* type, ValaCCodeExpression* variant_expr, ValaCCodeExpression* expr);
	ValaCCodeExpression* (*serialize_expression) (ValaCCodeBaseModule* self, ValaCCodeFragment* fragment, ValaDataType* type, ValaCCodeExpression* expr);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
	gboolean (*is_gobject_property) (ValaCCodeBaseModule* self, ValaProperty* prop);
	char* (*get_custom_creturn_type) (ValaCCodeBaseModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeBaseModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeBaseModule* self, ValaMethod* method);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeBaseModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeBaseModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeBaseModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeBaseModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeBaseModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_after_wrapper_name) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeBaseModule* self, ValaList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeBaseModule* self, ValaList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeBaseModule* self, const char* array_cname, gint dim);
	char* (*get_parameter_array_length_cname) (ValaCCodeBaseModule* self, ValaFormalParameter* param, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeBaseModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeBaseModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeBaseModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeBaseModule* self, ValaCodeNode* node, gboolean always_fails);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeFile* decl_space, ValaCCodeFunction* cfunc, ValaMap* cparam_map, ValaMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeFile* decl_space, ValaMap* cparam_map, ValaMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};


static gpointer vala_ccode_control_flow_module_parent_class = NULL;

GType vala_ccode_base_module_get_type (void) G_GNUC_CONST;
gpointer vala_ccode_base_module_emit_context_ref (gpointer instance);
void vala_ccode_base_module_emit_context_unref (gpointer instance);
GParamSpec* vala_ccode_base_module_param_spec_emit_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_ccode_base_module_value_set_emit_context (GValue* value, gpointer v_object);
void vala_ccode_base_module_value_take_emit_context (GValue* value, gpointer v_object);
gpointer vala_ccode_base_module_value_get_emit_context (const GValue* value);
GType vala_ccode_base_module_emit_context_get_type (void) G_GNUC_CONST;
GType vala_ccode_struct_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_method_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_control_flow_module_get_type (void) G_GNUC_CONST;
enum  {
	VALA_CCODE_CONTROL_FLOW_MODULE_DUMMY_PROPERTY
};
static void vala_ccode_control_flow_module_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt);
ValaCCodeFunction* vala_ccode_base_module_get_ccode (ValaCCodeBaseModule* self);
static void vala_ccode_control_flow_module_visit_string_switch_statement (ValaCCodeControlFlowModule* self, ValaSwitchStatement* stmt);
ValaLocalVariable* vala_ccode_base_module_get_temp_variable (ValaCCodeBaseModule* self, ValaDataType* type, gboolean value_owned, ValaCodeNode* node_reference, gboolean init);
void vala_ccode_base_module_emit_temp_var (ValaCCodeBaseModule* self, ValaLocalVariable* local);
ValaCCodeExpression* vala_ccode_base_module_get_variable_cexpression (ValaCCodeBaseModule* self, const char* name);
gboolean vala_ccode_base_module_is_constant_ccode_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr);
static void vala_ccode_control_flow_module_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt);
static void vala_ccode_control_flow_module_real_visit_switch_label (ValaCodeVisitor* base, ValaSwitchLabel* label);
static void vala_ccode_control_flow_module_real_visit_loop (ValaCodeVisitor* base, ValaLoop* stmt);
ValaCodeContext* vala_ccode_base_module_get_context (ValaCCodeBaseModule* self);
static void vala_ccode_control_flow_module_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt);
ValaMethod* vala_ccode_base_module_get_current_method (ValaCCodeBaseModule* self);
void vala_ccode_base_module_add_simple_check (ValaCCodeBaseModule* self, ValaCodeNode* node, gboolean always_fails);
ValaCCodeExpression* vala_ccode_base_module_get_array_length_cexpression (ValaCCodeBaseModule* self, ValaExpression* array_expr, gint dim);
char* vala_ccode_base_module_get_array_length_cname (ValaCCodeBaseModule* self, const char* array_cname, gint dim);
ValaCCodeExpression* vala_ccode_base_module_transform_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
ValaCCodeExpression* vala_ccode_base_module_convert_from_generic_pointer (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type);
ValaCCodeExpression* vala_ccode_base_module_get_ref_cexpression (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
gboolean vala_ccode_base_module_requires_destroy (ValaCCodeBaseModule* self, ValaDataType* type);
ValaCCodeExpression* vala_ccode_base_module_get_unref_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr, gboolean is_macro_definition);
static void vala_ccode_control_flow_module_real_visit_break_statement (ValaCodeVisitor* base, ValaBreakStatement* stmt);
void vala_ccode_base_module_append_local_free (ValaCCodeBaseModule* self, ValaSymbol* sym, gboolean stop_at_loop);
ValaSymbol* vala_ccode_base_module_get_current_symbol (ValaCCodeBaseModule* self);
static void vala_ccode_control_flow_module_real_visit_continue_statement (ValaCodeVisitor* base, ValaContinueStatement* stmt);
ValaCCodeControlFlowModule* vala_ccode_control_flow_module_new (void);
ValaCCodeControlFlowModule* vala_ccode_control_flow_module_construct (GType object_type);
ValaCCodeMethodModule* vala_ccode_method_module_new (void);
ValaCCodeMethodModule* vala_ccode_method_module_construct (GType object_type);


static void vala_ccode_control_flow_module_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_function_open_if (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_if_statement_get_condition (stmt))));
	vala_code_node_emit ((ValaCodeNode*) vala_if_statement_get_true_statement (stmt), (ValaCodeGenerator*) self);
	if (vala_if_statement_get_false_statement (stmt) != NULL) {
		vala_ccode_function_add_else (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self));
		vala_code_node_emit ((ValaCodeNode*) vala_if_statement_get_false_statement (stmt), (ValaCodeGenerator*) self);
	}
	vala_ccode_function_close (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self));
}


static gpointer _vala_ccode_node_ref0 (gpointer self) {
	return self ? vala_ccode_node_ref (self) : NULL;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static void vala_ccode_control_flow_module_visit_string_switch_statement (ValaCCodeControlFlowModule* self, ValaSwitchStatement* stmt) {
	ValaLocalVariable* temp_var;
	ValaCCodeExpression* ctemp;
	ValaCCodeAssignment* cinit;
	ValaCCodeConstant* czero;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeFunctionCall* _tmp1_;
	ValaCCodeFunctionCall* free_call;
	ValaCCodeConstant* _tmp2_;
	ValaCCodeBinaryExpression* _tmp3_;
	ValaCCodeBinaryExpression* cisnull;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* cquark;
	ValaCCodeConstant* _tmp6_;
	ValaCCodeConditionalExpression* _tmp7_;
	ValaCCodeConditionalExpression* ccond;
	ValaLocalVariable* _tmp8_;
	gint label_count;
	ValaCCodeExpression* _tmp11_;
	ValaCCodeAssignment* _tmp12_;
	ValaSwitchSection* default_section;
	gint n;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_switch_statement_get_expression (stmt)), vala_data_type_get_value_owned (vala_expression_get_value_type (vala_switch_statement_get_expression (stmt))), (ValaCodeNode*) stmt, FALSE);
	vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, temp_var);
	ctemp = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
	cinit = vala_ccode_assignment_new (ctemp, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_switch_statement_get_expression (stmt))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	czero = vala_ccode_constant_new ("0");
	free_call = (_tmp1_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("g_free"))), _vala_ccode_node_unref0 (_tmp0_), _tmp1_);
	vala_ccode_function_call_add_argument (free_call, ctemp);
	cisnull = (_tmp3_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp2_ = vala_ccode_constant_new ("NULL")), ctemp), _vala_ccode_node_unref0 (_tmp2_), _tmp3_);
	cquark = (_tmp5_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("g_quark_from_string"))), _vala_ccode_node_unref0 (_tmp4_), _tmp5_);
	vala_ccode_function_call_add_argument (cquark, ctemp);
	ccond = (_tmp7_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) cisnull, (ValaCCodeExpression*) (_tmp6_ = vala_ccode_constant_new ("0")), (ValaCCodeExpression*) cquark), _vala_ccode_node_unref0 (_tmp6_), _tmp7_);
	temp_var = (_tmp8_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->gquark_type, TRUE, NULL, TRUE), _vala_code_node_unref0 (temp_var), _tmp8_);
	vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, temp_var);
	label_count = 0;
	{
		ValaList* _section_list;
		gint _section_size;
		gint _section_index;
		_section_list = vala_switch_statement_get_sections (stmt);
		_section_size = vala_collection_get_size ((ValaCollection*) _section_list);
		_section_index = -1;
		while (TRUE) {
			ValaSwitchSection* section;
			if (!((_section_index = _section_index + 1) < _section_size)) {
				break;
			}
			section = (ValaSwitchSection*) vala_list_get (_section_list, _section_index);
			if (vala_switch_section_has_default_label (section)) {
				_vala_code_node_unref0 (section);
				continue;
			}
			{
				ValaList* _label_list;
				gint _label_size;
				gint _label_index;
				_label_list = vala_switch_section_get_labels (section);
				_label_size = vala_collection_get_size ((ValaCollection*) _label_list);
				_label_index = -1;
				while (TRUE) {
					ValaSwitchLabel* label;
					ValaCCodeExpression* cexpr;
					if (!((_label_index = _label_index + 1) < _label_size)) {
						break;
					}
					label = (ValaSwitchLabel*) vala_list_get (_label_list, _label_index);
					vala_code_node_emit ((ValaCodeNode*) vala_switch_label_get_expression (label), (ValaCodeGenerator*) self);
					cexpr = _vala_ccode_node_ref0 (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_switch_label_get_expression (label))));
					if (vala_ccode_base_module_is_constant_ccode_expression ((ValaCCodeBaseModule*) self, cexpr)) {
						char* cname;
						char* _tmp9_;
						ValaCCodeVariableDeclarator* _tmp10_;
						cname = g_strdup_printf ("%s_label%d", vala_symbol_get_name ((ValaSymbol*) temp_var), label_count++);
						vala_ccode_function_add_declaration (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), _tmp9_ = vala_data_type_get_cname (((ValaCCodeBaseModule*) self)->gquark_type), (ValaCCodeDeclarator*) (_tmp10_ = vala_ccode_variable_declarator_new (cname, (ValaCCodeExpression*) czero, NULL)), VALA_CCODE_MODIFIERS_STATIC);
						_vala_ccode_node_unref0 (_tmp10_);
						_g_free0 (_tmp9_);
						_g_free0 (cname);
					}
					_vala_ccode_node_unref0 (cexpr);
					_vala_code_node_unref0 (label);
				}
				_vala_iterable_unref0 (_label_list);
			}
			_vala_code_node_unref0 (section);
		}
		_vala_iterable_unref0 (_section_list);
	}
	vala_ccode_function_add_expression (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) cinit);
	ctemp = (_tmp11_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var)), _vala_ccode_node_unref0 (ctemp), _tmp11_);
	cinit = (_tmp12_ = vala_ccode_assignment_new (ctemp, (ValaCCodeExpression*) ccond, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), _vala_ccode_node_unref0 (cinit), _tmp12_);
	vala_ccode_function_add_expression (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) cinit);
	if (vala_data_type_get_value_owned (vala_expression_get_value_type (vala_switch_statement_get_expression (stmt)))) {
		vala_ccode_function_add_expression (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) free_call);
	}
	default_section = NULL;
	label_count = 0;
	n = 0;
	{
		ValaList* _section_list;
		gint _section_size;
		gint _section_index;
		_section_list = vala_switch_statement_get_sections (stmt);
		_section_size = vala_collection_get_size ((ValaCollection*) _section_list);
		_section_index = -1;
		while (TRUE) {
			ValaSwitchSection* section;
			ValaCCodeBinaryExpression* cor;
			ValaCCodeConstant* _tmp25_;
			if (!((_section_index = _section_index + 1) < _section_size)) {
				break;
			}
			section = (ValaSwitchSection*) vala_list_get (_section_list, _section_index);
			if (vala_switch_section_has_default_label (section)) {
				ValaSwitchSection* _tmp13_;
				default_section = (_tmp13_ = _vala_code_node_ref0 (section), _vala_code_node_unref0 (default_section), _tmp13_);
				_vala_code_node_unref0 (section);
				continue;
			}
			cor = NULL;
			{
				ValaList* _label_list;
				gint _label_size;
				gint _label_index;
				_label_list = vala_switch_section_get_labels (section);
				_label_size = vala_collection_get_size ((ValaCollection*) _label_list);
				_label_index = -1;
				while (TRUE) {
					ValaSwitchLabel* label;
					ValaCCodeExpression* cexpr;
					ValaCCodeBinaryExpression* ccmp;
					if (!((_label_index = _label_index + 1) < _label_size)) {
						break;
					}
					label = (ValaSwitchLabel*) vala_list_get (_label_list, _label_index);
					vala_code_node_emit ((ValaCodeNode*) vala_switch_label_get_expression (label), (ValaCodeGenerator*) self);
					cexpr = _vala_ccode_node_ref0 (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_switch_label_get_expression (label))));
					if (vala_ccode_base_module_is_constant_ccode_expression ((ValaCCodeBaseModule*) self, cexpr)) {
						char* _tmp14_;
						ValaCCodeIdentifier* _tmp15_;
						ValaCCodeIdentifier* cname;
						ValaCCodeBinaryExpression* ccondition;
						ValaCCodeIdentifier* _tmp16_;
						ValaCCodeFunctionCall* _tmp17_;
						ValaCCodeFunctionCall* ccall;
						ValaCCodeAssignment* _tmp18_;
						ValaCCodeExpression* _tmp19_;
						cname = (_tmp15_ = vala_ccode_identifier_new (_tmp14_ = g_strdup_printf ("%s_label%d", vala_symbol_get_name ((ValaSymbol*) temp_var), label_count++)), _g_free0 (_tmp14_), _tmp15_);
						ccondition = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) czero, (ValaCCodeExpression*) cname);
						ccall = (_tmp17_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new ("g_quark_from_static_string"))), _vala_ccode_node_unref0 (_tmp16_), _tmp17_);
						cinit = (_tmp18_ = vala_ccode_assignment_new ((ValaCCodeExpression*) cname, (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), _vala_ccode_node_unref0 (cinit), _tmp18_);
						vala_ccode_function_call_add_argument (ccall, cexpr);
						cexpr = (_tmp19_ = (ValaCCodeExpression*) vala_ccode_conditional_expression_new ((ValaCCodeExpression*) ccondition, (ValaCCodeExpression*) cname, (ValaCCodeExpression*) cinit), _vala_ccode_node_unref0 (cexpr), _tmp19_);
						_vala_ccode_node_unref0 (ccall);
						_vala_ccode_node_unref0 (ccondition);
						_vala_ccode_node_unref0 (cname);
					} else {
						ValaCCodeIdentifier* _tmp20_;
						ValaCCodeFunctionCall* _tmp21_;
						ValaCCodeFunctionCall* ccall;
						ValaCCodeExpression* _tmp22_;
						ccall = (_tmp21_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp20_ = vala_ccode_identifier_new ("g_quark_from_string"))), _vala_ccode_node_unref0 (_tmp20_), _tmp21_);
						vala_ccode_function_call_add_argument (ccall, cexpr);
						cexpr = (_tmp22_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) ccall), _vala_ccode_node_unref0 (cexpr), _tmp22_);
						_vala_ccode_node_unref0 (ccall);
					}
					ccmp = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, ctemp, cexpr);
					if (cor == NULL) {
						ValaCCodeBinaryExpression* _tmp23_;
						cor = (_tmp23_ = _vala_ccode_node_ref0 (ccmp), _vala_ccode_node_unref0 (cor), _tmp23_);
					} else {
						ValaCCodeBinaryExpression* _tmp24_;
						cor = (_tmp24_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, (ValaCCodeExpression*) cor, (ValaCCodeExpression*) ccmp), _vala_ccode_node_unref0 (cor), _tmp24_);
					}
					_vala_ccode_node_unref0 (ccmp);
					_vala_ccode_node_unref0 (cexpr);
					_vala_code_node_unref0 (label);
				}
				_vala_iterable_unref0 (_label_list);
			}
			if (n > 0) {
				vala_ccode_function_else_if (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) cor);
			} else {
				vala_ccode_function_open_if (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) cor);
			}
			vala_ccode_function_open_switch (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) (_tmp25_ = vala_ccode_constant_new ("0")));
			_vala_ccode_node_unref0 (_tmp25_);
			vala_ccode_function_add_default (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self));
			vala_code_node_emit ((ValaCodeNode*) section, (ValaCodeGenerator*) self);
			vala_ccode_function_close (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self));
			n++;
			_vala_ccode_node_unref0 (cor);
			_vala_code_node_unref0 (section);
		}
		_vala_iterable_unref0 (_section_list);
	}
	if (default_section != NULL) {
		ValaCCodeConstant* _tmp26_;
		if (n > 0) {
			vala_ccode_function_add_else (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self));
		}
		vala_ccode_function_open_switch (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) (_tmp26_ = vala_ccode_constant_new ("0")));
		_vala_ccode_node_unref0 (_tmp26_);
		vala_ccode_function_add_default (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self));
		vala_code_node_emit ((ValaCodeNode*) default_section, (ValaCodeGenerator*) self);
		vala_ccode_function_close (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self));
	}
	vala_ccode_function_close (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self));
	_vala_code_node_unref0 (default_section);
	_vala_ccode_node_unref0 (ccond);
	_vala_ccode_node_unref0 (cquark);
	_vala_ccode_node_unref0 (cisnull);
	_vala_ccode_node_unref0 (free_call);
	_vala_ccode_node_unref0 (czero);
	_vala_ccode_node_unref0 (cinit);
	_vala_ccode_node_unref0 (ctemp);
	_vala_code_node_unref0 (temp_var);
}


static void vala_ccode_control_flow_module_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_data_type_compatible (vala_expression_get_value_type (vala_switch_statement_get_expression (stmt)), ((ValaCCodeBaseModule*) self)->string_type)) {
		vala_ccode_control_flow_module_visit_string_switch_statement (self, stmt);
		return;
	}
	vala_ccode_function_open_switch (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_switch_statement_get_expression (stmt))));
	{
		ValaList* _section_list;
		gint _section_size;
		gint _section_index;
		_section_list = vala_switch_statement_get_sections (stmt);
		_section_size = vala_collection_get_size ((ValaCollection*) _section_list);
		_section_index = -1;
		while (TRUE) {
			ValaSwitchSection* section;
			if (!((_section_index = _section_index + 1) < _section_size)) {
				break;
			}
			section = (ValaSwitchSection*) vala_list_get (_section_list, _section_index);
			if (vala_switch_section_has_default_label (section)) {
				vala_ccode_function_add_default (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self));
			}
			vala_code_node_emit ((ValaCodeNode*) section, (ValaCodeGenerator*) self);
			_vala_code_node_unref0 (section);
		}
		_vala_iterable_unref0 (_section_list);
	}
	vala_ccode_function_close (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self));
}


static void vala_ccode_control_flow_module_real_visit_switch_label (ValaCodeVisitor* base, ValaSwitchLabel* label) {
	ValaCCodeControlFlowModule * self;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (label != NULL);
	if (vala_data_type_compatible (vala_expression_get_value_type (vala_switch_statement_get_expression (VALA_SWITCH_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) vala_switch_label_get_section (label))))), ((ValaCCodeBaseModule*) self)->string_type)) {
		return;
	}
	if (vala_switch_label_get_expression (label) != NULL) {
		vala_code_node_emit ((ValaCodeNode*) vala_switch_label_get_expression (label), (ValaCodeGenerator*) self);
		vala_code_visitor_visit_end_full_expression ((ValaCodeVisitor*) self, vala_switch_label_get_expression (label));
		vala_ccode_function_add_case (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_switch_label_get_expression (label))));
	}
}


static void vala_ccode_control_flow_module_real_visit_loop (ValaCodeVisitor* base, ValaLoop* stmt) {
	ValaCCodeControlFlowModule * self;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_code_context_get_profile (vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self)) == VALA_PROFILE_GOBJECT) {
		ValaCCodeConstant* _tmp0_;
		vala_ccode_function_open_while (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) (_tmp0_ = vala_ccode_constant_new ("TRUE")));
		_vala_ccode_node_unref0 (_tmp0_);
	} else {
		ValaCCodeConstant* _tmp1_;
		vala_ccode_file_add_include (((ValaCCodeBaseModule*) self)->cfile, "stdbool.h", FALSE);
		vala_ccode_function_open_while (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) (_tmp1_ = vala_ccode_constant_new ("true")));
		_vala_ccode_node_unref0 (_tmp1_);
	}
	vala_code_node_emit ((ValaCodeNode*) vala_loop_get_body (stmt), (ValaCodeGenerator*) self);
	vala_ccode_function_close (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self));
}


static void vala_ccode_control_flow_module_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	ValaLocalVariable* collection_backup;
	ValaDataType* collection_type;
	ValaDataType* _tmp0_;
	ValaArrayType* array_type;
	gboolean _tmp1_ = FALSE;
	ValaCCodeExpression* _tmp4_;
	ValaCCodeAssignment* _tmp5_;
	gboolean _tmp6_ = FALSE;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_function_open_block (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self));
	collection_backup = _vala_code_node_ref0 (vala_foreach_statement_get_collection_variable (stmt));
	collection_type = vala_data_type_copy (vala_variable_get_variable_type ((ValaVariable*) collection_backup));
	array_type = _vala_code_node_ref0 ((_tmp0_ = collection_type, VALA_IS_ARRAY_TYPE (_tmp0_) ? ((ValaArrayType*) _tmp0_) : NULL));
	if (array_type != NULL) {
		vala_array_type_set_fixed_length (array_type, FALSE);
	}
	if (vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self) != NULL) {
		_tmp1_ = vala_method_get_coroutine (vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self));
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		char* _tmp2_;
		vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, _tmp2_ = vala_data_type_get_cname (collection_type), vala_symbol_get_name ((ValaSymbol*) collection_backup), NULL);
		_g_free0 (_tmp2_);
	} else {
		ValaCCodeVariableDeclarator* ccolvardecl;
		char* _tmp3_;
		ccolvardecl = vala_ccode_variable_declarator_new (vala_symbol_get_name ((ValaSymbol*) collection_backup), NULL, NULL);
		vala_ccode_function_add_declaration (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), _tmp3_ = vala_data_type_get_cname (collection_type), (ValaCCodeDeclarator*) ccolvardecl, 0);
		_g_free0 (_tmp3_);
		_vala_ccode_node_unref0 (ccolvardecl);
	}
	vala_ccode_function_add_expression (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) (_tmp5_ = vala_ccode_assignment_new (_tmp4_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) collection_backup)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_foreach_statement_get_collection (stmt))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	_vala_ccode_node_unref0 (_tmp5_);
	_vala_ccode_node_unref0 (_tmp4_);
	if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) stmt)) {
		_tmp6_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) vala_foreach_statement_get_collection (stmt));
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		vala_ccode_base_module_add_simple_check ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_foreach_statement_get_collection (stmt), FALSE);
	}
	if (VALA_IS_ARRAY_TYPE (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)))) {
		ValaArrayType* _tmp7_;
		ValaCCodeExpression* array_len;
		gboolean _tmp8_ = FALSE;
		char* _tmp12_;
		ValaCCodeExpression* _tmp13_;
		ValaCCodeAssignment* _tmp14_;
		char* it_name;
		gboolean _tmp15_ = FALSE;
		ValaCCodeExpression* _tmp17_;
		ValaCCodeBinaryExpression* _tmp18_;
		ValaCCodeBinaryExpression* ccond;
		ValaCCodeExpression* _tmp19_;
		ValaCCodeConstant* _tmp20_;
		ValaCCodeAssignment* _tmp21_;
		ValaCCodeExpression* _tmp22_;
		ValaCCodeExpression* _tmp23_;
		ValaCCodeConstant* _tmp24_;
		ValaCCodeBinaryExpression* _tmp25_;
		ValaCCodeAssignment* _tmp26_;
		ValaCCodeExpression* _tmp27_;
		ValaCCodeExpression* _tmp28_;
		ValaCCodeExpression* _tmp29_;
		ValaCCodeExpression* element_expr;
		ValaDataType* element_type;
		ValaCCodeExpression* _tmp30_;
		gboolean _tmp31_ = FALSE;
		ValaCCodeExpression* _tmp35_;
		ValaCCodeAssignment* _tmp36_;
		array_type = (_tmp7_ = _vala_code_node_ref0 (VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)))), _vala_code_node_unref0 (array_type), _tmp7_);
		array_len = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, vala_foreach_statement_get_collection (stmt), -1);
		if (vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self) != NULL) {
			_tmp8_ = vala_method_get_coroutine (vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self));
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			char* _tmp9_;
			vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, "int", _tmp9_ = vala_ccode_base_module_get_array_length_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) collection_backup), 1), NULL);
			_g_free0 (_tmp9_);
		} else {
			char* _tmp10_;
			ValaCCodeVariableDeclarator* _tmp11_;
			vala_ccode_function_add_declaration (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), "int", (ValaCCodeDeclarator*) (_tmp11_ = vala_ccode_variable_declarator_new (_tmp10_ = vala_ccode_base_module_get_array_length_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) collection_backup), 1), NULL, NULL)), 0);
			_vala_ccode_node_unref0 (_tmp11_);
			_g_free0 (_tmp10_);
		}
		vala_ccode_function_add_expression (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) (_tmp14_ = vala_ccode_assignment_new (_tmp13_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp12_ = vala_ccode_base_module_get_array_length_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) collection_backup), 1)), array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		_vala_ccode_node_unref0 (_tmp14_);
		_vala_ccode_node_unref0 (_tmp13_);
		_g_free0 (_tmp12_);
		it_name = g_strconcat (vala_foreach_statement_get_variable_name (stmt), "_it", NULL);
		if (vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self) != NULL) {
			_tmp15_ = vala_method_get_coroutine (vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self));
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, "int", it_name, NULL);
		} else {
			ValaCCodeVariableDeclarator* _tmp16_;
			vala_ccode_function_add_declaration (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), "int", (ValaCCodeDeclarator*) (_tmp16_ = vala_ccode_variable_declarator_new (it_name, NULL, NULL)), 0);
			_vala_ccode_node_unref0 (_tmp16_);
		}
		ccond = (_tmp18_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, _tmp17_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), array_len), _vala_ccode_node_unref0 (_tmp17_), _tmp18_);
		vala_ccode_function_open_for (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) (_tmp21_ = vala_ccode_assignment_new (_tmp19_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), (ValaCCodeExpression*) (_tmp20_ = vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)), (ValaCCodeExpression*) ccond, (ValaCCodeExpression*) (_tmp26_ = vala_ccode_assignment_new (_tmp22_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), (ValaCCodeExpression*) (_tmp25_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp23_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), (ValaCCodeExpression*) (_tmp24_ = vala_ccode_constant_new ("1")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		_vala_ccode_node_unref0 (_tmp26_);
		_vala_ccode_node_unref0 (_tmp25_);
		_vala_ccode_node_unref0 (_tmp24_);
		_vala_ccode_node_unref0 (_tmp23_);
		_vala_ccode_node_unref0 (_tmp22_);
		_vala_ccode_node_unref0 (_tmp21_);
		_vala_ccode_node_unref0 (_tmp20_);
		_vala_ccode_node_unref0 (_tmp19_);
		element_expr = (_tmp29_ = (ValaCCodeExpression*) vala_ccode_element_access_new (_tmp27_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) collection_backup)), _tmp28_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name)), _vala_ccode_node_unref0 (_tmp28_), _vala_ccode_node_unref0 (_tmp27_), _tmp29_);
		element_type = vala_data_type_copy (vala_array_type_get_element_type (array_type));
		vala_data_type_set_value_owned (element_type, FALSE);
		element_expr = (_tmp30_ = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, element_expr, element_type, vala_foreach_statement_get_type_reference (stmt), NULL), _vala_ccode_node_unref0 (element_expr), _tmp30_);
		if (vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self) != NULL) {
			_tmp31_ = vala_method_get_coroutine (vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self));
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			char* _tmp32_;
			vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, _tmp32_ = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt)), vala_foreach_statement_get_variable_name (stmt), NULL);
			_g_free0 (_tmp32_);
		} else {
			char* _tmp33_;
			ValaCCodeVariableDeclarator* _tmp34_;
			vala_ccode_function_add_declaration (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), _tmp33_ = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt)), (ValaCCodeDeclarator*) (_tmp34_ = vala_ccode_variable_declarator_new (vala_foreach_statement_get_variable_name (stmt), NULL, NULL)), 0);
			_vala_ccode_node_unref0 (_tmp34_);
			_g_free0 (_tmp33_);
		}
		vala_ccode_function_add_expression (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) (_tmp36_ = vala_ccode_assignment_new (_tmp35_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_foreach_statement_get_variable_name (stmt)), element_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		_vala_ccode_node_unref0 (_tmp36_);
		_vala_ccode_node_unref0 (_tmp35_);
		if (VALA_IS_ARRAY_TYPE (vala_foreach_statement_get_type_reference (stmt))) {
			ValaArrayType* inner_array_type;
			inner_array_type = _vala_code_node_ref0 (VALA_ARRAY_TYPE (vala_foreach_statement_get_type_reference (stmt)));
			{
				gint dim;
				dim = 1;
				{
					gboolean _tmp37_;
					_tmp37_ = TRUE;
					while (TRUE) {
						gboolean _tmp38_ = FALSE;
						if (!_tmp37_) {
							dim++;
						}
						_tmp37_ = FALSE;
						if (!(dim <= vala_array_type_get_rank (inner_array_type))) {
							break;
						}
						if (vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self) != NULL) {
							_tmp38_ = vala_method_get_coroutine (vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self));
						} else {
							_tmp38_ = FALSE;
						}
						if (_tmp38_) {
							char* _tmp39_;
							char* _tmp40_;
							ValaCCodeExpression* _tmp41_;
							ValaCCodeConstant* _tmp42_;
							ValaCCodeAssignment* _tmp43_;
							vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, "int", _tmp39_ = vala_ccode_base_module_get_array_length_cname ((ValaCCodeBaseModule*) self, vala_foreach_statement_get_variable_name (stmt), dim), NULL);
							_g_free0 (_tmp39_);
							vala_ccode_function_add_expression (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) (_tmp43_ = vala_ccode_assignment_new (_tmp41_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp40_ = vala_ccode_base_module_get_array_length_cname ((ValaCCodeBaseModule*) self, vala_foreach_statement_get_variable_name (stmt), dim)), (ValaCCodeExpression*) (_tmp42_ = vala_ccode_constant_new ("-1")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							_vala_ccode_node_unref0 (_tmp43_);
							_vala_ccode_node_unref0 (_tmp42_);
							_vala_ccode_node_unref0 (_tmp41_);
							_g_free0 (_tmp40_);
						} else {
							char* _tmp44_;
							ValaCCodeConstant* _tmp45_;
							ValaCCodeVariableDeclarator* _tmp46_;
							vala_ccode_function_add_declaration (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), "int", (ValaCCodeDeclarator*) (_tmp46_ = vala_ccode_variable_declarator_new (_tmp44_ = vala_ccode_base_module_get_array_length_cname ((ValaCCodeBaseModule*) self, vala_foreach_statement_get_variable_name (stmt), dim), (ValaCCodeExpression*) (_tmp45_ = vala_ccode_constant_new ("-1")), NULL)), 0);
							_vala_ccode_node_unref0 (_tmp46_);
							_vala_ccode_node_unref0 (_tmp45_);
							_g_free0 (_tmp44_);
						}
					}
				}
			}
			_vala_code_node_unref0 (inner_array_type);
		}
		vala_code_node_emit ((ValaCodeNode*) vala_foreach_statement_get_body (stmt), (ValaCodeGenerator*) self);
		vala_ccode_function_close (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self));
		_vala_code_node_unref0 (element_type);
		_vala_ccode_node_unref0 (element_expr);
		_vala_ccode_node_unref0 (ccond);
		_g_free0 (it_name);
		_vala_ccode_node_unref0 (array_len);
	} else {
		gboolean _tmp47_ = FALSE;
		ValaObjectType* _tmp48_;
		gboolean _tmp49_;
		if ((_tmp49_ = vala_data_type_compatible (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)), (ValaDataType*) (_tmp48_ = vala_object_type_new ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->glist_type))), _vala_code_node_unref0 (_tmp48_), _tmp49_)) {
			_tmp47_ = TRUE;
		} else {
			ValaObjectType* _tmp50_;
			_tmp47_ = vala_data_type_compatible (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)), (ValaDataType*) (_tmp50_ = vala_object_type_new ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->gslist_type)));
			_vala_code_node_unref0 (_tmp50_);
		}
		if (_tmp47_) {
			char* it_name;
			gboolean _tmp51_ = FALSE;
			ValaCCodeExpression* _tmp55_;
			ValaCCodeConstant* _tmp56_;
			ValaCCodeBinaryExpression* _tmp57_;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeExpression* _tmp58_;
			ValaCCodeExpression* _tmp59_;
			ValaCCodeAssignment* _tmp60_;
			ValaCCodeExpression* _tmp61_;
			ValaCCodeExpression* _tmp62_;
			ValaCCodeMemberAccess* _tmp63_;
			ValaCCodeAssignment* _tmp64_;
			ValaCCodeExpression* _tmp65_;
			ValaCCodeExpression* _tmp66_;
			ValaCCodeExpression* element_expr;
			ValaList* _tmp67_;
			gboolean _tmp68_;
			ValaList* _tmp69_;
			ValaDataType* _tmp70_;
			ValaDataType* _tmp71_;
			ValaDataType* element_data_type;
			ValaCCodeExpression* _tmp72_;
			ValaCCodeExpression* _tmp73_;
			gboolean _tmp74_ = FALSE;
			ValaCCodeExpression* _tmp78_;
			ValaCCodeAssignment* _tmp79_;
			it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
			if (vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self) != NULL) {
				_tmp51_ = vala_method_get_coroutine (vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self));
			} else {
				_tmp51_ = FALSE;
			}
			if (_tmp51_) {
				char* _tmp52_;
				vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, _tmp52_ = vala_data_type_get_cname (collection_type), it_name, NULL);
				_g_free0 (_tmp52_);
			} else {
				char* _tmp53_;
				ValaCCodeVariableDeclarator* _tmp54_;
				vala_ccode_function_add_declaration (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), _tmp53_ = vala_data_type_get_cname (collection_type), (ValaCCodeDeclarator*) (_tmp54_ = vala_ccode_variable_declarator_new (it_name, NULL, NULL)), 0);
				_vala_ccode_node_unref0 (_tmp54_);
				_g_free0 (_tmp53_);
			}
			ccond = (_tmp57_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, _tmp55_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), (ValaCCodeExpression*) (_tmp56_ = vala_ccode_constant_new ("NULL"))), _vala_ccode_node_unref0 (_tmp56_), _vala_ccode_node_unref0 (_tmp55_), _tmp57_);
			vala_ccode_function_open_for (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) (_tmp60_ = vala_ccode_assignment_new (_tmp58_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), _tmp59_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) collection_backup)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)), (ValaCCodeExpression*) ccond, (ValaCCodeExpression*) (_tmp64_ = vala_ccode_assignment_new (_tmp61_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), (ValaCCodeExpression*) (_tmp63_ = vala_ccode_member_access_new_pointer (_tmp62_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), "next")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
			_vala_ccode_node_unref0 (_tmp64_);
			_vala_ccode_node_unref0 (_tmp63_);
			_vala_ccode_node_unref0 (_tmp62_);
			_vala_ccode_node_unref0 (_tmp61_);
			_vala_ccode_node_unref0 (_tmp60_);
			_vala_ccode_node_unref0 (_tmp59_);
			_vala_ccode_node_unref0 (_tmp58_);
			element_expr = (_tmp66_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (_tmp65_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), "data"), _vala_ccode_node_unref0 (_tmp65_), _tmp66_);
			if ((_tmp68_ = vala_collection_get_size ((ValaCollection*) (_tmp67_ = vala_data_type_get_type_arguments (collection_type))) != 1, _vala_iterable_unref0 (_tmp67_), _tmp68_)) {
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) stmt), "internal error: missing generic type argument");
				vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
				_vala_ccode_node_unref0 (element_expr);
				_vala_ccode_node_unref0 (ccond);
				_g_free0 (it_name);
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (collection_type);
				_vala_code_node_unref0 (collection_backup);
				return;
			}
			element_data_type = (_tmp71_ = vala_data_type_copy (_tmp70_ = (ValaDataType*) vala_list_get (_tmp69_ = vala_data_type_get_type_arguments (collection_type), 0)), _vala_code_node_unref0 (_tmp70_), _vala_iterable_unref0 (_tmp69_), _tmp71_);
			vala_data_type_set_value_owned (element_data_type, FALSE);
			element_expr = (_tmp72_ = vala_ccode_base_module_convert_from_generic_pointer ((ValaCCodeBaseModule*) self, element_expr, element_data_type), _vala_ccode_node_unref0 (element_expr), _tmp72_);
			element_expr = (_tmp73_ = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, element_expr, element_data_type, vala_foreach_statement_get_type_reference (stmt), NULL), _vala_ccode_node_unref0 (element_expr), _tmp73_);
			if (vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self) != NULL) {
				_tmp74_ = vala_method_get_coroutine (vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self));
			} else {
				_tmp74_ = FALSE;
			}
			if (_tmp74_) {
				char* _tmp75_;
				vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, _tmp75_ = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt)), vala_foreach_statement_get_variable_name (stmt), NULL);
				_g_free0 (_tmp75_);
			} else {
				char* _tmp76_;
				ValaCCodeVariableDeclarator* _tmp77_;
				vala_ccode_function_add_declaration (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), _tmp76_ = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt)), (ValaCCodeDeclarator*) (_tmp77_ = vala_ccode_variable_declarator_new (vala_foreach_statement_get_variable_name (stmt), NULL, NULL)), 0);
				_vala_ccode_node_unref0 (_tmp77_);
				_g_free0 (_tmp76_);
			}
			vala_ccode_function_add_expression (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) (_tmp79_ = vala_ccode_assignment_new (_tmp78_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_foreach_statement_get_variable_name (stmt)), element_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
			_vala_ccode_node_unref0 (_tmp79_);
			_vala_ccode_node_unref0 (_tmp78_);
			vala_code_node_emit ((ValaCodeNode*) vala_foreach_statement_get_body (stmt), (ValaCodeGenerator*) self);
			vala_ccode_function_close (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self));
			_vala_code_node_unref0 (element_data_type);
			_vala_ccode_node_unref0 (element_expr);
			_vala_ccode_node_unref0 (ccond);
			_g_free0 (it_name);
		} else {
			ValaObjectType* _tmp80_;
			gboolean _tmp81_;
			if ((_tmp81_ = vala_data_type_compatible (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)), (ValaDataType*) (_tmp80_ = vala_object_type_new ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->gvaluearray_type))), _vala_code_node_unref0 (_tmp80_), _tmp81_)) {
				char* arr_index;
				gboolean _tmp82_ = FALSE;
				ValaCCodeExpression* _tmp86_;
				ValaCCodeExpression* _tmp87_;
				ValaCCodeMemberAccess* _tmp88_;
				ValaCCodeBinaryExpression* _tmp89_;
				ValaCCodeBinaryExpression* ccond;
				ValaCCodeExpression* _tmp90_;
				ValaCCodeConstant* _tmp91_;
				ValaCCodeAssignment* _tmp92_;
				ValaCCodeExpression* _tmp93_;
				ValaCCodeExpression* _tmp94_;
				ValaCCodeConstant* _tmp95_;
				ValaCCodeBinaryExpression* _tmp96_;
				ValaCCodeAssignment* _tmp97_;
				ValaCCodeIdentifier* _tmp98_;
				ValaCCodeFunctionCall* _tmp99_;
				ValaCCodeFunctionCall* get_item;
				ValaCCodeExpression* _tmp100_;
				ValaCCodeExpression* _tmp101_;
				ValaCCodeExpression* element_expr;
				gboolean _tmp104_ = FALSE;
				ValaCCodeExpression* _tmp108_;
				ValaCCodeAssignment* _tmp109_;
				arr_index = g_strdup_printf ("%s_index", vala_foreach_statement_get_variable_name (stmt));
				if (vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self) != NULL) {
					_tmp82_ = vala_method_get_coroutine (vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self));
				} else {
					_tmp82_ = FALSE;
				}
				if (_tmp82_) {
					char* _tmp83_;
					vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, _tmp83_ = vala_data_type_get_cname (((ValaCCodeBaseModule*) self)->uint_type), arr_index, NULL);
					_g_free0 (_tmp83_);
				} else {
					char* _tmp84_;
					ValaCCodeVariableDeclarator* _tmp85_;
					vala_ccode_function_add_declaration (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), _tmp84_ = vala_data_type_get_cname (((ValaCCodeBaseModule*) self)->uint_type), (ValaCCodeDeclarator*) (_tmp85_ = vala_ccode_variable_declarator_new (arr_index, NULL, NULL)), 0);
					_vala_ccode_node_unref0 (_tmp85_);
					_g_free0 (_tmp84_);
				}
				ccond = (_tmp89_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, _tmp86_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, arr_index), (ValaCCodeExpression*) (_tmp88_ = vala_ccode_member_access_new_pointer (_tmp87_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) collection_backup)), "n_values"))), _vala_ccode_node_unref0 (_tmp88_), _vala_ccode_node_unref0 (_tmp87_), _vala_ccode_node_unref0 (_tmp86_), _tmp89_);
				vala_ccode_function_open_for (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) (_tmp92_ = vala_ccode_assignment_new (_tmp90_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, arr_index), (ValaCCodeExpression*) (_tmp91_ = vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)), (ValaCCodeExpression*) ccond, (ValaCCodeExpression*) (_tmp97_ = vala_ccode_assignment_new (_tmp93_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, arr_index), (ValaCCodeExpression*) (_tmp96_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp94_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, arr_index), (ValaCCodeExpression*) (_tmp95_ = vala_ccode_constant_new ("1")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
				_vala_ccode_node_unref0 (_tmp97_);
				_vala_ccode_node_unref0 (_tmp96_);
				_vala_ccode_node_unref0 (_tmp95_);
				_vala_ccode_node_unref0 (_tmp94_);
				_vala_ccode_node_unref0 (_tmp93_);
				_vala_ccode_node_unref0 (_tmp92_);
				_vala_ccode_node_unref0 (_tmp91_);
				_vala_ccode_node_unref0 (_tmp90_);
				get_item = (_tmp99_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp98_ = vala_ccode_identifier_new ("g_value_array_get_nth"))), _vala_ccode_node_unref0 (_tmp98_), _tmp99_);
				vala_ccode_function_call_add_argument (get_item, _tmp100_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) collection_backup)));
				_vala_ccode_node_unref0 (_tmp100_);
				vala_ccode_function_call_add_argument (get_item, _tmp101_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, arr_index));
				_vala_ccode_node_unref0 (_tmp101_);
				element_expr = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) get_item);
				if (vala_data_type_get_value_owned (vala_foreach_statement_get_type_reference (stmt))) {
					ValaStructValueType* _tmp102_;
					ValaCCodeExpression* _tmp103_;
					element_expr = (_tmp103_ = vala_ccode_base_module_get_ref_cexpression ((ValaCCodeBaseModule*) self, vala_foreach_statement_get_type_reference (stmt), element_expr, NULL, (ValaCodeNode*) (_tmp102_ = vala_struct_value_type_new (((ValaCCodeBaseModule*) self)->gvalue_type))), _vala_ccode_node_unref0 (element_expr), _tmp103_);
					_vala_code_node_unref0 (_tmp102_);
				}
				if (vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self) != NULL) {
					_tmp104_ = vala_method_get_coroutine (vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self));
				} else {
					_tmp104_ = FALSE;
				}
				if (_tmp104_) {
					char* _tmp105_;
					vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, _tmp105_ = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt)), vala_foreach_statement_get_variable_name (stmt), NULL);
					_g_free0 (_tmp105_);
				} else {
					char* _tmp106_;
					ValaCCodeVariableDeclarator* _tmp107_;
					vala_ccode_function_add_declaration (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), _tmp106_ = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt)), (ValaCCodeDeclarator*) (_tmp107_ = vala_ccode_variable_declarator_new (vala_foreach_statement_get_variable_name (stmt), NULL, NULL)), 0);
					_vala_ccode_node_unref0 (_tmp107_);
					_g_free0 (_tmp106_);
				}
				vala_ccode_function_add_expression (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) (_tmp109_ = vala_ccode_assignment_new (_tmp108_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_foreach_statement_get_variable_name (stmt)), element_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
				_vala_ccode_node_unref0 (_tmp109_);
				_vala_ccode_node_unref0 (_tmp108_);
				vala_code_node_emit ((ValaCodeNode*) vala_foreach_statement_get_body (stmt), (ValaCodeGenerator*) self);
				vala_ccode_function_close (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self));
				_vala_ccode_node_unref0 (element_expr);
				_vala_ccode_node_unref0 (get_item);
				_vala_ccode_node_unref0 (ccond);
				_g_free0 (arr_index);
			}
		}
	}
	{
		ValaList* _local_list;
		gint _local_size;
		gint _local_index;
		_local_list = vala_block_get_local_variables ((ValaBlock*) stmt);
		_local_size = vala_collection_get_size ((ValaCollection*) _local_list);
		_local_index = -1;
		while (TRUE) {
			ValaLocalVariable* local;
			if (!((_local_index = _local_index + 1) < _local_size)) {
				break;
			}
			local = (ValaLocalVariable*) vala_list_get (_local_list, _local_index);
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, vala_variable_get_variable_type ((ValaVariable*) local))) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* _tmp110_;
				ValaCCodeExpression* _tmp111_;
				ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
				vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
				vala_ccode_function_add_expression (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), _tmp111_ = vala_ccode_base_module_get_unref_expression ((ValaCCodeBaseModule*) self, _tmp110_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local)), vala_variable_get_variable_type ((ValaVariable*) local), (ValaExpression*) ma, FALSE));
				_vala_ccode_node_unref0 (_tmp111_);
				_vala_ccode_node_unref0 (_tmp110_);
				_vala_code_node_unref0 (ma);
			}
			_vala_code_node_unref0 (local);
		}
		_vala_iterable_unref0 (_local_list);
	}
	vala_ccode_function_close (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self));
	_vala_code_node_unref0 (array_type);
	_vala_code_node_unref0 (collection_type);
	_vala_code_node_unref0 (collection_backup);
}


static void vala_ccode_control_flow_module_real_visit_break_statement (ValaCodeVisitor* base, ValaBreakStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, vala_ccode_base_module_get_current_symbol ((ValaCCodeBaseModule*) self), TRUE);
	vala_ccode_function_add_break (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self));
}


static void vala_ccode_control_flow_module_real_visit_continue_statement (ValaCodeVisitor* base, ValaContinueStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, vala_ccode_base_module_get_current_symbol ((ValaCCodeBaseModule*) self), TRUE);
	vala_ccode_function_add_continue (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self));
}


ValaCCodeControlFlowModule* vala_ccode_control_flow_module_construct (GType object_type) {
	ValaCCodeControlFlowModule* self;
	self = (ValaCCodeControlFlowModule*) vala_ccode_method_module_construct (object_type);
	return self;
}


ValaCCodeControlFlowModule* vala_ccode_control_flow_module_new (void) {
	return vala_ccode_control_flow_module_construct (VALA_TYPE_CCODE_CONTROL_FLOW_MODULE);
}


static void vala_ccode_control_flow_module_class_init (ValaCCodeControlFlowModuleClass * klass) {
	vala_ccode_control_flow_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->visit_if_statement = vala_ccode_control_flow_module_real_visit_if_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_statement = vala_ccode_control_flow_module_real_visit_switch_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_label = vala_ccode_control_flow_module_real_visit_switch_label;
	VALA_CODE_VISITOR_CLASS (klass)->visit_loop = vala_ccode_control_flow_module_real_visit_loop;
	VALA_CODE_VISITOR_CLASS (klass)->visit_foreach_statement = vala_ccode_control_flow_module_real_visit_foreach_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_break_statement = vala_ccode_control_flow_module_real_visit_break_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_continue_statement = vala_ccode_control_flow_module_real_visit_continue_statement;
}


static void vala_ccode_control_flow_module_instance_init (ValaCCodeControlFlowModule * self) {
}


GType vala_ccode_control_flow_module_get_type (void) {
	static volatile gsize vala_ccode_control_flow_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_control_flow_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeControlFlowModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_control_flow_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeControlFlowModule), 0, (GInstanceInitFunc) vala_ccode_control_flow_module_instance_init, NULL };
		GType vala_ccode_control_flow_module_type_id;
		vala_ccode_control_flow_module_type_id = g_type_register_static (VALA_TYPE_CCODE_METHOD_MODULE, "ValaCCodeControlFlowModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_control_flow_module_type_id__volatile, vala_ccode_control_flow_module_type_id);
	}
	return vala_ccode_control_flow_module_type_id__volatile;
}



