/* valaccodedeclaration.c generated by valac, the Vala compiler
 * generated from valaccodedeclaration.vala, do not modify */

/* valaccodedeclaration.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CCODE_NODE (vala_ccode_node_get_type ())
#define VALA_CCODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_NODE, ValaCCodeNode))
#define VALA_CCODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_NODE, ValaCCodeNodeClass))
#define VALA_IS_CCODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_NODE))
#define VALA_IS_CCODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_NODE))
#define VALA_CCODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_NODE, ValaCCodeNodeClass))

typedef struct _ValaCCodeNode ValaCCodeNode;
typedef struct _ValaCCodeNodeClass ValaCCodeNodeClass;
typedef struct _ValaCCodeNodePrivate ValaCCodeNodePrivate;

#define VALA_TYPE_CCODE_WRITER (vala_ccode_writer_get_type ())
#define VALA_CCODE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_WRITER, ValaCCodeWriter))
#define VALA_CCODE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_WRITER, ValaCCodeWriterClass))
#define VALA_IS_CCODE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_WRITER))
#define VALA_IS_CCODE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_WRITER))
#define VALA_CCODE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_WRITER, ValaCCodeWriterClass))

typedef struct _ValaCCodeWriter ValaCCodeWriter;
typedef struct _ValaCCodeWriterClass ValaCCodeWriterClass;

#define VALA_TYPE_CCODE_STATEMENT (vala_ccode_statement_get_type ())
#define VALA_CCODE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STATEMENT, ValaCCodeStatement))
#define VALA_CCODE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STATEMENT, ValaCCodeStatementClass))
#define VALA_IS_CCODE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STATEMENT))
#define VALA_IS_CCODE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STATEMENT))
#define VALA_CCODE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STATEMENT, ValaCCodeStatementClass))

typedef struct _ValaCCodeStatement ValaCCodeStatement;
typedef struct _ValaCCodeStatementClass ValaCCodeStatementClass;
typedef struct _ValaCCodeStatementPrivate ValaCCodeStatementPrivate;

#define VALA_TYPE_CCODE_DECLARATION (vala_ccode_declaration_get_type ())
#define VALA_CCODE_DECLARATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION, ValaCCodeDeclaration))
#define VALA_CCODE_DECLARATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION, ValaCCodeDeclarationClass))
#define VALA_IS_CCODE_DECLARATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION))
#define VALA_IS_CCODE_DECLARATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION))
#define VALA_CCODE_DECLARATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION, ValaCCodeDeclarationClass))

typedef struct _ValaCCodeDeclaration ValaCCodeDeclaration;
typedef struct _ValaCCodeDeclarationClass ValaCCodeDeclarationClass;
typedef struct _ValaCCodeDeclarationPrivate ValaCCodeDeclarationPrivate;

#define VALA_TYPE_CCODE_MODIFIERS (vala_ccode_modifiers_get_type ())

#define VALA_TYPE_CCODE_DECLARATOR (vala_ccode_declarator_get_type ())
#define VALA_CCODE_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATOR, ValaCCodeDeclarator))
#define VALA_CCODE_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATOR, ValaCCodeDeclaratorClass))
#define VALA_IS_CCODE_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATOR))
#define VALA_IS_CCODE_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATOR))
#define VALA_CCODE_DECLARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATOR, ValaCCodeDeclaratorClass))

typedef struct _ValaCCodeDeclarator ValaCCodeDeclarator;
typedef struct _ValaCCodeDeclaratorClass ValaCCodeDeclaratorClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))

#define VALA_TYPE_CCODE_VARIABLE_DECLARATOR (vala_ccode_variable_declarator_get_type ())
#define VALA_CCODE_VARIABLE_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_VARIABLE_DECLARATOR, ValaCCodeVariableDeclarator))
#define VALA_CCODE_VARIABLE_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_VARIABLE_DECLARATOR, ValaCCodeVariableDeclaratorClass))
#define VALA_IS_CCODE_VARIABLE_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_VARIABLE_DECLARATOR))
#define VALA_IS_CCODE_VARIABLE_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_VARIABLE_DECLARATOR))
#define VALA_CCODE_VARIABLE_DECLARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_VARIABLE_DECLARATOR, ValaCCodeVariableDeclaratorClass))

typedef struct _ValaCCodeVariableDeclarator ValaCCodeVariableDeclarator;
typedef struct _ValaCCodeVariableDeclaratorClass ValaCCodeVariableDeclaratorClass;

#define VALA_TYPE_CCODE_EXPRESSION (vala_ccode_expression_get_type ())
#define VALA_CCODE_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_EXPRESSION, ValaCCodeExpression))
#define VALA_CCODE_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_EXPRESSION, ValaCCodeExpressionClass))
#define VALA_IS_CCODE_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_EXPRESSION))
#define VALA_IS_CCODE_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_EXPRESSION))
#define VALA_CCODE_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_EXPRESSION, ValaCCodeExpressionClass))

typedef struct _ValaCCodeExpression ValaCCodeExpression;
typedef struct _ValaCCodeExpressionClass ValaCCodeExpressionClass;

#define VALA_TYPE_CCODE_LINE_DIRECTIVE (vala_ccode_line_directive_get_type ())
#define VALA_CCODE_LINE_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_LINE_DIRECTIVE, ValaCCodeLineDirective))
#define VALA_CCODE_LINE_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_LINE_DIRECTIVE, ValaCCodeLineDirectiveClass))
#define VALA_IS_CCODE_LINE_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_LINE_DIRECTIVE))
#define VALA_IS_CCODE_LINE_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_LINE_DIRECTIVE))
#define VALA_CCODE_LINE_DIRECTIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_LINE_DIRECTIVE, ValaCCodeLineDirectiveClass))

typedef struct _ValaCCodeLineDirective ValaCCodeLineDirective;
typedef struct _ValaCCodeLineDirectiveClass ValaCCodeLineDirectiveClass;

struct _ValaCCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeNodePrivate * priv;
};

struct _ValaCCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeNode *self);
	void (*write) (ValaCCodeNode* self, ValaCCodeWriter* writer);
	void (*write_declaration) (ValaCCodeNode* self, ValaCCodeWriter* writer);
	void (*write_combined) (ValaCCodeNode* self, ValaCCodeWriter* writer);
};

struct _ValaCCodeStatement {
	ValaCCodeNode parent_instance;
	ValaCCodeStatementPrivate * priv;
};

struct _ValaCCodeStatementClass {
	ValaCCodeNodeClass parent_class;
};

struct _ValaCCodeDeclaration {
	ValaCCodeStatement parent_instance;
	ValaCCodeDeclarationPrivate * priv;
};

struct _ValaCCodeDeclarationClass {
	ValaCCodeStatementClass parent_class;
};

typedef enum  {
	VALA_CCODE_MODIFIERS_NONE = 0,
	VALA_CCODE_MODIFIERS_STATIC = 1 << 0,
	VALA_CCODE_MODIFIERS_REGISTER = 1 << 1,
	VALA_CCODE_MODIFIERS_EXTERN = 1 << 2,
	VALA_CCODE_MODIFIERS_INLINE = 1 << 3,
	VALA_CCODE_MODIFIERS_VOLATILE = 1 << 4,
	VALA_CCODE_MODIFIERS_DEPRECATED = 1 << 5,
	VALA_CCODE_MODIFIERS_THREAD_LOCAL = 1 << 6
} ValaCCodeModifiers;

struct _ValaCCodeDeclarationPrivate {
	char* _type_name;
	ValaCCodeModifiers _modifiers;
	ValaList* declarators;
};


static gpointer vala_ccode_declaration_parent_class = NULL;

gpointer vala_ccode_node_ref (gpointer instance);
void vala_ccode_node_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_node (GValue* value, gpointer v_object);
void vala_value_take_ccode_node (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_node (const GValue* value);
GType vala_ccode_node_get_type (void) G_GNUC_CONST;
gpointer vala_ccode_writer_ref (gpointer instance);
void vala_ccode_writer_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_writer (GValue* value, gpointer v_object);
void vala_value_take_ccode_writer (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_writer (const GValue* value);
GType vala_ccode_writer_get_type (void) G_GNUC_CONST;
GType vala_ccode_statement_get_type (void) G_GNUC_CONST;
GType vala_ccode_declaration_get_type (void) G_GNUC_CONST;
GType vala_ccode_modifiers_get_type (void) G_GNUC_CONST;
GType vala_ccode_declarator_get_type (void) G_GNUC_CONST;
#define VALA_CCODE_DECLARATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_DECLARATION, ValaCCodeDeclarationPrivate))
enum  {
	VALA_CCODE_DECLARATION_DUMMY_PROPERTY
};
ValaCCodeDeclaration* vala_ccode_declaration_new (const char* type_name);
ValaCCodeDeclaration* vala_ccode_declaration_construct (GType object_type, const char* type_name);
ValaCCodeStatement* vala_ccode_statement_construct (GType object_type);
void vala_ccode_declaration_set_type_name (ValaCCodeDeclaration* self, const char* value);
void vala_ccode_declaration_add_declarator (ValaCCodeDeclaration* self, ValaCCodeDeclarator* decl);
static void vala_ccode_declaration_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
ValaCCodeModifiers vala_ccode_declaration_get_modifiers (ValaCCodeDeclaration* self);
void vala_ccode_declarator_write_initialization (ValaCCodeDeclarator* self, ValaCCodeWriter* writer);
static gboolean vala_ccode_declaration_has_initializer (ValaCCodeDeclaration* self);
GType vala_ccode_variable_declarator_get_type (void) G_GNUC_CONST;
GType vala_ccode_expression_get_type (void) G_GNUC_CONST;
ValaCCodeExpression* vala_ccode_variable_declarator_get_initializer (ValaCCodeVariableDeclarator* self);
static void vala_ccode_declaration_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer);
GType vala_ccode_line_directive_get_type (void) G_GNUC_CONST;
void vala_ccode_writer_write_indent (ValaCCodeWriter* self, ValaCCodeLineDirective* line);
ValaCCodeLineDirective* vala_ccode_node_get_line (ValaCCodeNode* self);
void vala_ccode_writer_write_string (ValaCCodeWriter* self, const char* s);
const char* vala_ccode_declaration_get_type_name (ValaCCodeDeclaration* self);
void vala_ccode_node_write (ValaCCodeNode* self, ValaCCodeWriter* writer);
void vala_ccode_writer_write_newline (ValaCCodeWriter* self);
void vala_ccode_node_write_declaration (ValaCCodeNode* self, ValaCCodeWriter* writer);
void vala_ccode_declaration_set_modifiers (ValaCCodeDeclaration* self, ValaCCodeModifiers value);
static void vala_ccode_declaration_finalize (ValaCCodeNode* obj);


ValaCCodeDeclaration* vala_ccode_declaration_construct (GType object_type, const char* type_name) {
	ValaCCodeDeclaration* self;
	g_return_val_if_fail (type_name != NULL, NULL);
	self = (ValaCCodeDeclaration*) vala_ccode_statement_construct (object_type);
	vala_ccode_declaration_set_type_name (self, type_name);
	return self;
}


ValaCCodeDeclaration* vala_ccode_declaration_new (const char* type_name) {
	return vala_ccode_declaration_construct (VALA_TYPE_CCODE_DECLARATION, type_name);
}


/**
 * Adds the specified declarator to this declaration.
 *
 * @param decl a declarator
 */
void vala_ccode_declaration_add_declarator (ValaCCodeDeclaration* self, ValaCCodeDeclarator* decl) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (decl != NULL);
	vala_collection_add ((ValaCollection*) self->priv->declarators, decl);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static void vala_ccode_declaration_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeDeclaration * self;
	self = (ValaCCodeDeclaration*) base;
	g_return_if_fail (writer != NULL);
	if ((self->priv->_modifiers & (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_EXTERN)) == 0) {
		{
			ValaList* _decl_list;
			gint _decl_size;
			gint _decl_index;
			_decl_list = _vala_iterable_ref0 (self->priv->declarators);
			_decl_size = vala_collection_get_size ((ValaCollection*) _decl_list);
			_decl_index = -1;
			while (TRUE) {
				ValaCCodeDeclarator* decl;
				if (!((_decl_index = _decl_index + 1) < _decl_size)) {
					break;
				}
				decl = (ValaCCodeDeclarator*) vala_list_get (_decl_list, _decl_index);
				vala_ccode_declarator_write_initialization (decl, writer);
				_vala_ccode_node_unref0 (decl);
			}
			_vala_iterable_unref0 (_decl_list);
		}
	}
}


static gpointer _vala_ccode_node_ref0 (gpointer self) {
	return self ? vala_ccode_node_ref (self) : NULL;
}


static gboolean vala_ccode_declaration_has_initializer (ValaCCodeDeclaration* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaList* _decl_list;
		gint _decl_size;
		gint _decl_index;
		_decl_list = _vala_iterable_ref0 (self->priv->declarators);
		_decl_size = vala_collection_get_size ((ValaCollection*) _decl_list);
		_decl_index = -1;
		while (TRUE) {
			ValaCCodeDeclarator* decl;
			ValaCCodeDeclarator* _tmp0_;
			ValaCCodeVariableDeclarator* var_decl;
			gboolean _tmp1_ = FALSE;
			if (!((_decl_index = _decl_index + 1) < _decl_size)) {
				break;
			}
			decl = (ValaCCodeDeclarator*) vala_list_get (_decl_list, _decl_index);
			var_decl = _vala_ccode_node_ref0 ((_tmp0_ = decl, VALA_IS_CCODE_VARIABLE_DECLARATOR (_tmp0_) ? ((ValaCCodeVariableDeclarator*) _tmp0_) : NULL));
			if (var_decl != NULL) {
				_tmp1_ = vala_ccode_variable_declarator_get_initializer (var_decl) == NULL;
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				result = FALSE;
				_vala_ccode_node_unref0 (var_decl);
				_vala_ccode_node_unref0 (decl);
				_vala_iterable_unref0 (_decl_list);
				return result;
			}
			_vala_ccode_node_unref0 (var_decl);
			_vala_ccode_node_unref0 (decl);
		}
		_vala_iterable_unref0 (_decl_list);
	}
	result = TRUE;
	return result;
}


static void vala_ccode_declaration_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeDeclaration * self;
	gboolean first;
	self = (ValaCCodeDeclaration*) base;
	g_return_if_fail (writer != NULL);
	if ((self->priv->_modifiers & (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_EXTERN)) != 0) {
		gboolean _tmp0_ = FALSE;
		gboolean first;
		vala_ccode_writer_write_indent (writer, vala_ccode_node_get_line ((ValaCCodeNode*) self));
		if ((self->priv->_modifiers & VALA_CCODE_MODIFIERS_STATIC) != 0) {
			vala_ccode_writer_write_string (writer, "static ");
		}
		if ((self->priv->_modifiers & VALA_CCODE_MODIFIERS_VOLATILE) != 0) {
			vala_ccode_writer_write_string (writer, "volatile ");
		}
		if ((self->priv->_modifiers & VALA_CCODE_MODIFIERS_EXTERN) != 0) {
			_tmp0_ = !vala_ccode_declaration_has_initializer (self);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			vala_ccode_writer_write_string (writer, "extern ");
		}
		if ((self->priv->_modifiers & VALA_CCODE_MODIFIERS_THREAD_LOCAL) != 0) {
			vala_ccode_writer_write_string (writer, "thread_local ");
		}
		vala_ccode_writer_write_string (writer, self->priv->_type_name);
		vala_ccode_writer_write_string (writer, " ");
		first = TRUE;
		{
			ValaList* _decl_list;
			gint _decl_size;
			gint _decl_index;
			_decl_list = _vala_iterable_ref0 (self->priv->declarators);
			_decl_size = vala_collection_get_size ((ValaCollection*) _decl_list);
			_decl_index = -1;
			while (TRUE) {
				ValaCCodeDeclarator* decl;
				if (!((_decl_index = _decl_index + 1) < _decl_size)) {
					break;
				}
				decl = (ValaCCodeDeclarator*) vala_list_get (_decl_list, _decl_index);
				if (!first) {
					vala_ccode_writer_write_string (writer, ", ");
				} else {
					first = FALSE;
				}
				vala_ccode_node_write ((ValaCCodeNode*) decl, writer);
				_vala_ccode_node_unref0 (decl);
			}
			_vala_iterable_unref0 (_decl_list);
		}
		if ((self->priv->_modifiers & VALA_CCODE_MODIFIERS_DEPRECATED) == VALA_CCODE_MODIFIERS_DEPRECATED) {
			vala_ccode_writer_write_string (writer, " G_GNUC_DEPRECATED");
		}
		vala_ccode_writer_write_string (writer, ";");
		vala_ccode_writer_write_newline (writer);
		return;
	}
	vala_ccode_writer_write_indent (writer, NULL);
	if ((self->priv->_modifiers & VALA_CCODE_MODIFIERS_REGISTER) == VALA_CCODE_MODIFIERS_REGISTER) {
		vala_ccode_writer_write_string (writer, "register ");
	}
	vala_ccode_writer_write_string (writer, self->priv->_type_name);
	vala_ccode_writer_write_string (writer, " ");
	first = TRUE;
	{
		ValaList* _decl_list;
		gint _decl_size;
		gint _decl_index;
		_decl_list = _vala_iterable_ref0 (self->priv->declarators);
		_decl_size = vala_collection_get_size ((ValaCollection*) _decl_list);
		_decl_index = -1;
		while (TRUE) {
			ValaCCodeDeclarator* decl;
			if (!((_decl_index = _decl_index + 1) < _decl_size)) {
				break;
			}
			decl = (ValaCCodeDeclarator*) vala_list_get (_decl_list, _decl_index);
			if (!first) {
				vala_ccode_writer_write_string (writer, ", ");
			} else {
				first = FALSE;
			}
			vala_ccode_node_write_declaration ((ValaCCodeNode*) decl, writer);
			_vala_ccode_node_unref0 (decl);
		}
		_vala_iterable_unref0 (_decl_list);
	}
	vala_ccode_writer_write_string (writer, ";");
	vala_ccode_writer_write_newline (writer);
}


const char* vala_ccode_declaration_get_type_name (ValaCCodeDeclaration* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_type_name;
	return result;
}


void vala_ccode_declaration_set_type_name (ValaCCodeDeclaration* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_type_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_type_name), _tmp0_);
}


ValaCCodeModifiers vala_ccode_declaration_get_modifiers (ValaCCodeDeclaration* self) {
	ValaCCodeModifiers result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_modifiers;
	return result;
}


void vala_ccode_declaration_set_modifiers (ValaCCodeDeclaration* self, ValaCCodeModifiers value) {
	g_return_if_fail (self != NULL);
	self->priv->_modifiers = value;
}


static void vala_ccode_declaration_class_init (ValaCCodeDeclarationClass * klass) {
	vala_ccode_declaration_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_declaration_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeDeclarationPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_declaration_real_write;
	VALA_CCODE_NODE_CLASS (klass)->write_declaration = vala_ccode_declaration_real_write_declaration;
}


static void vala_ccode_declaration_instance_init (ValaCCodeDeclaration * self) {
	self->priv = VALA_CCODE_DECLARATION_GET_PRIVATE (self);
	self->priv->declarators = (ValaList*) vala_array_list_new (VALA_TYPE_CCODE_DECLARATOR, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_equal);
}


static void vala_ccode_declaration_finalize (ValaCCodeNode* obj) {
	ValaCCodeDeclaration * self;
	self = VALA_CCODE_DECLARATION (obj);
	_g_free0 (self->priv->_type_name);
	_vala_iterable_unref0 (self->priv->declarators);
	VALA_CCODE_NODE_CLASS (vala_ccode_declaration_parent_class)->finalize (obj);
}


/**
 * Represents a local variable declaration in the C code.
 */
GType vala_ccode_declaration_get_type (void) {
	static volatile gsize vala_ccode_declaration_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_declaration_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeDeclarationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_declaration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeDeclaration), 0, (GInstanceInitFunc) vala_ccode_declaration_instance_init, NULL };
		GType vala_ccode_declaration_type_id;
		vala_ccode_declaration_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeDeclaration", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_declaration_type_id__volatile, vala_ccode_declaration_type_id);
	}
	return vala_ccode_declaration_type_id__volatile;
}



