/* tracker-backup.c generated by valac 0.32.0, the Vala compiler
 * generated from tracker-backup.vala, do not modify */

/*
 * Copyright (C) 2006, Jamie McCracken <jamiemcc@gnome.org>
 * Copyright (C) 2008-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "tracker-store/tracker-events.h"
#include "libtracker-common/tracker-common.h"
#include "libtracker-data/tracker-data-backup.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-data/tracker-data-update.h"


#define TRACKER_TYPE_BACKUP (tracker_backup_get_type ())
#define TRACKER_BACKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_BACKUP, TrackerBackup))
#define TRACKER_BACKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_BACKUP, TrackerBackupClass))
#define TRACKER_IS_BACKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_BACKUP))
#define TRACKER_IS_BACKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_BACKUP))
#define TRACKER_BACKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_BACKUP, TrackerBackupClass))

typedef struct _TrackerBackup TrackerBackup;
typedef struct _TrackerBackupClass TrackerBackupClass;
typedef struct _TrackerBackupPrivate TrackerBackupPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

#define TRACKER_TYPE_RESOURCES (tracker_resources_get_type ())
#define TRACKER_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_RESOURCES, TrackerResources))
#define TRACKER_RESOURCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_RESOURCES, TrackerResourcesClass))
#define TRACKER_IS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_RESOURCES))
#define TRACKER_IS_RESOURCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_RESOURCES))
#define TRACKER_RESOURCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_RESOURCES, TrackerResourcesClass))

typedef struct _TrackerResources TrackerResources;
typedef struct _TrackerResourcesClass TrackerResourcesClass;
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerBackupSaveData TrackerBackupSaveData;

#define TRACKER_TYPE_STATUS (tracker_status_get_type ())
#define TRACKER_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STATUS, TrackerStatus))
#define TRACKER_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STATUS, TrackerStatusClass))
#define TRACKER_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STATUS))
#define TRACKER_IS_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STATUS))
#define TRACKER_STATUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STATUS, TrackerStatusClass))

typedef struct _TrackerStatus TrackerStatus;
typedef struct _TrackerStatusClass TrackerStatusClass;
typedef struct _TrackerBackupRestoreData TrackerBackupRestoreData;

struct _TrackerBackup {
	GObject parent_instance;
	TrackerBackupPrivate * priv;
};

struct _TrackerBackupClass {
	GObjectClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	TrackerBackup* self;
	gpointer _async_data_;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	GError* backup_error;
};

struct _TrackerBackupSaveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerBackup* self;
	char* sender;
	gchar* destination_uri;
	Block1Data* _data1_;
	TrackerResources* resources;
	GObject* _tmp0_;
	TrackerResources* _tmp1_;
	TrackerResources* _tmp2_;
	TrackerDBusRequest* request;
	const char* _tmp3_;
	const gchar* _tmp4_;
	TrackerDBusRequest* _tmp5_;
	Block2Data* _data2_;
	GFile* destination;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	gboolean _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GError* _tmp18_;
	GError* _tmp19_;
	GFile* _tmp20_;
	GError* _tmp21_;
	GError* _tmp22_;
	GError* _tmp23_;
	TrackerDBusRequest* _tmp24_;
	GError* e;
	TrackerDBusRequest* _tmp25_;
	GError* _tmp26_;
	GError* _tmp27_;
	GError* _tmp28_;
	TrackerResources* _tmp29_;
	TrackerResources* _tmp30_;
	GError * _inner_error_;
};

struct _TrackerBackupRestoreData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerBackup* self;
	char* sender;
	gchar* journal_uri;
	TrackerResources* resources;
	GObject* _tmp0_;
	TrackerResources* _tmp1_;
	TrackerResources* _tmp2_;
	TrackerDBusRequest* request;
	const char* _tmp3_;
	const gchar* _tmp4_;
	TrackerDBusRequest* _tmp5_;
	GFile* journal;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	gboolean _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GError* _tmp18_;
	GError* _tmp19_;
	TrackerStatus* notifier;
	GObject* _tmp20_;
	TrackerBusyCallback busy_callback;
	TrackerStatus* _tmp21_;
	void* _tmp22_;
	GDestroyNotify _tmp23_;
	TrackerBusyCallback _tmp24_;
	void* busy_callback_target;
	GDestroyNotify busy_callback_target_destroy_notify;
	GFile* _tmp25_;
	TrackerBusyCallback _tmp26_;
	void* _tmp26__target;
	TrackerDBusRequest* _tmp27_;
	GError* e;
	TrackerDBusRequest* _tmp28_;
	GError* _tmp29_;
	GError* _tmp30_;
	GError* _tmp31_;
	TrackerResources* _tmp32_;
	TrackerResources* _tmp33_;
	GError * _inner_error_;
};


static gpointer tracker_backup_parent_class = NULL;

GType tracker_backup_get_type (void) G_GNUC_CONST;
guint tracker_backup_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
enum  {
	TRACKER_BACKUP_DUMMY_PROPERTY
};
#define TRACKER_BACKUP_PATH "/org/freedesktop/Tracker1/Backup"
static void tracker_backup_save_data_free (gpointer _data);
void tracker_backup_save (TrackerBackup* self, const char* sender, const gchar* destination_uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_backup_save_finish (TrackerBackup* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_backup_save_co (TrackerBackupSaveData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
GType tracker_resources_get_type (void) G_GNUC_CONST;
guint tracker_resources_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GObject* tracker_dbus_get_object (GType type);
void tracker_resources_disable_signals (TrackerResources* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
void tracker_store_pause (GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_pause_finish (GAsyncResult* _res_);
static void tracker_backup_save_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void ___lambda10_ (Block2Data* _data2_, GError* _error_);
static void ____lambda10__tracker_data_backup_finished (GError* _error_, gpointer self);
void tracker_resources_enable_signals (TrackerResources* self);
void tracker_store_resume (void);
static void tracker_backup_restore_data_free (gpointer _data);
void tracker_backup_restore (TrackerBackup* self, const char* sender, const gchar* journal_uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_backup_restore_finish (TrackerBackup* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_backup_restore_co (TrackerBackupRestoreData* _data_);
static void tracker_backup_restore_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType tracker_status_get_type (void) G_GNUC_CONST;
guint tracker_status_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
TrackerBusyCallback tracker_status_get_callback (TrackerStatus* self, void** result_target, GDestroyNotify* result_target_destroy_notify);
TrackerBackup* tracker_backup_new (void);
TrackerBackup* tracker_backup_construct (GType object_type);
static void _dbus_tracker_backup_save (TrackerBackup* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_tracker_backup_save_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_tracker_backup_restore (TrackerBackup* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_tracker_backup_restore_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void tracker_backup_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* tracker_backup_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean tracker_backup_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _tracker_backup_unregister_object (gpointer user_data);

static const GDBusArgInfo _tracker_backup_dbus_arg_info_save_destination_uri = {-1, "destination_uri", "s"};
static const GDBusArgInfo * const _tracker_backup_dbus_arg_info_save_in[] = {&_tracker_backup_dbus_arg_info_save_destination_uri, NULL};
static const GDBusArgInfo * const _tracker_backup_dbus_arg_info_save_out[] = {NULL};
static const GDBusMethodInfo _tracker_backup_dbus_method_info_save = {-1, "Save", (GDBusArgInfo **) (&_tracker_backup_dbus_arg_info_save_in), (GDBusArgInfo **) (&_tracker_backup_dbus_arg_info_save_out)};
static const GDBusArgInfo _tracker_backup_dbus_arg_info_restore_journal_uri = {-1, "journal_uri", "s"};
static const GDBusArgInfo * const _tracker_backup_dbus_arg_info_restore_in[] = {&_tracker_backup_dbus_arg_info_restore_journal_uri, NULL};
static const GDBusArgInfo * const _tracker_backup_dbus_arg_info_restore_out[] = {NULL};
static const GDBusMethodInfo _tracker_backup_dbus_method_info_restore = {-1, "Restore", (GDBusArgInfo **) (&_tracker_backup_dbus_arg_info_restore_in), (GDBusArgInfo **) (&_tracker_backup_dbus_arg_info_restore_out)};
static const GDBusMethodInfo * const _tracker_backup_dbus_method_info[] = {&_tracker_backup_dbus_method_info_save, &_tracker_backup_dbus_method_info_restore, NULL};
static const GDBusSignalInfo * const _tracker_backup_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _tracker_backup_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _tracker_backup_dbus_interface_info = {-1, "org.freedesktop.Tracker1.Backup", (GDBusMethodInfo **) (&_tracker_backup_dbus_method_info), (GDBusSignalInfo **) (&_tracker_backup_dbus_signal_info), (GDBusPropertyInfo **) (&_tracker_backup_dbus_property_info)};
static const GDBusInterfaceVTable _tracker_backup_dbus_interface_vtable = {tracker_backup_dbus_interface_method_call, tracker_backup_dbus_interface_get_property, tracker_backup_dbus_interface_set_property};

static void tracker_backup_save_data_free (gpointer _data) {
	TrackerBackupSaveData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_g_free0 (_data_->destination_uri);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_g_object_unref0 (_data_->self);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	g_slice_free (TrackerBackupSaveData, _data_);
#line 270 "tracker-backup.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	return self ? g_object_ref (self) : NULL;
#line 277 "tracker-backup.c"
}


void tracker_backup_save (TrackerBackup* self, const char* sender, const gchar* destination_uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerBackupSaveData* _data_;
	TrackerBackup* _tmp0_ = NULL;
	const char* _tmp1_ = NULL;
	char* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_ = g_slice_new0 (TrackerBackupSaveData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_backup_save);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_backup_save_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->self = _tmp0_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_tmp1_ = sender;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->sender = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_tmp3_ = destination_uri;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_g_free0 (_data_->destination_uri);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->destination_uri = _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	tracker_backup_save_co (_data_);
#line 316 "tracker-backup.c"
}


void tracker_backup_save_finish (TrackerBackup* self, GAsyncResult* _res_, GError** error) {
	TrackerBackupSaveData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		return;
#line 326 "tracker-backup.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 330 "tracker-backup.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	return _data1_;
#line 339 "tracker-backup.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 348 "tracker-backup.c"
		TrackerBackup* self;
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		self = _data1_->self;
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_g_object_unref0 (self);
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		g_slice_free (Block1Data, _data1_);
#line 356 "tracker-backup.c"
	}
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	return _data2_;
#line 366 "tracker-backup.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 375 "tracker-backup.c"
		TrackerBackup* self;
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		self = _data2_->_data1_->self;
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_g_error_free0 (_data2_->backup_error);
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		block1_data_unref (_data2_->_data1_);
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data2_->_data1_ = NULL;
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		g_slice_free (Block2Data, _data2_);
#line 387 "tracker-backup.c"
	}
}


static void tracker_backup_save_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerBackupSaveData* _data_;
#line 40 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_ = _user_data_;
#line 40 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_source_object_ = source_object;
#line 40 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_res_ = _res_;
#line 40 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	tracker_backup_save_co (_data_);
#line 402 "tracker-backup.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 44 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	return self ? g_error_copy (self) : NULL;
#line 409 "tracker-backup.c"
}


static void ___lambda10_ (Block2Data* _data2_, GError* _error_) {
	Block1Data* _data1_;
	TrackerBackup* self;
	GError* _tmp0_ = NULL;
	GError* _tmp1_ = NULL;
#line 43 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data1_ = _data2_->_data1_;
#line 43 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	self = _data1_->self;
#line 44 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_tmp0_ = _error_;
#line 44 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_tmp1_ = _g_error_copy0 (_tmp0_);
#line 44 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_g_error_free0 (_data2_->backup_error);
#line 44 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data2_->backup_error = _tmp1_;
#line 45 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	tracker_backup_save_co (_data1_->_async_data_);
#line 432 "tracker-backup.c"
}


static void ____lambda10__tracker_data_backup_finished (GError* _error_, gpointer self) {
#line 43 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	___lambda10_ (self, _error_);
#line 439 "tracker-backup.c"
}


static gboolean tracker_backup_save_co (TrackerBackupSaveData* _data_) {
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	switch (_data_->_state_) {
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		case 0:
#line 448 "tracker-backup.c"
		goto _state_0;
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		case 1:
#line 452 "tracker-backup.c"
		goto _state_1;
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		case 2:
#line 456 "tracker-backup.c"
		goto _state_2;
		default:
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		g_assert_not_reached ();
#line 461 "tracker-backup.c"
	}
	_state_0:
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_data1_ = g_slice_new0 (Block1Data);
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_data1_->_ref_count_ = 1;
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_data1_->self = g_object_ref (_data_->self);
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_data1_->_async_data_ = _data_;
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_tmp0_ = NULL;
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_tmp0_ = tracker_dbus_get_object (TRACKER_TYPE_RESOURCES);
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->resources = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, TRACKER_TYPE_RESOURCES, TrackerResources);
#line 27 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_tmp1_ = NULL;
#line 27 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_tmp1_ = _data_->resources;
#line 27 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	if (_data_->_tmp1_ != NULL) {
#line 28 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp2_ = NULL;
#line 28 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp2_ = _data_->resources;
#line 28 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		tracker_resources_disable_signals (_data_->_tmp2_);
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		tracker_events_shutdown ();
#line 492 "tracker-backup.c"
	}
#line 32 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_tmp3_ = NULL;
#line 32 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_tmp3_ = _data_->sender;
#line 32 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_tmp4_ = NULL;
#line 32 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_tmp4_ = _data_->destination_uri;
#line 32 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_tmp5_ = NULL;
#line 32 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_tmp5_ = tracker_dbus_request_begin ((const gchar*) _data_->_tmp3_, "D-Bus request to save backup into '%s'", _data_->_tmp4_, NULL);
#line 32 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->request = _data_->_tmp5_;
#line 508 "tracker-backup.c"
	{
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_data2_ = g_slice_new0 (Block2Data);
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_data2_->_ref_count_ = 1;
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_data2_->_data1_ = block1_data_ref (_data_->_data1_);
#line 34 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp6_ = NULL;
#line 34 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp6_ = _data_->destination_uri;
#line 34 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp7_ = NULL;
#line 34 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp7_ = g_file_new_for_uri (_data_->_tmp6_);
#line 34 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->destination = _data_->_tmp7_;
#line 36 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp9_ = NULL;
#line 36 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp9_ = _data_->destination;
#line 36 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		if (_data_->_tmp9_ == NULL) {
#line 36 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp8_ = TRUE;
#line 534 "tracker-backup.c"
		} else {
#line 36 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp10_ = NULL;
#line 36 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp10_ = _data_->destination;
#line 36 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp11_ = NULL;
#line 36 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp11_ = g_file_get_path (_data_->_tmp10_);
#line 36 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp12_ = NULL;
#line 36 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp12_ = _data_->_tmp11_;
#line 36 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp8_ = _data_->_tmp12_ == NULL;
#line 36 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_g_free0 (_data_->_tmp12_);
#line 552 "tracker-backup.c"
		}
#line 36 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		if (_data_->_tmp8_) {
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp13_ = NULL;
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp13_ = _data_->destination_uri;
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp14_ = NULL;
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp14_ = g_strconcat ("'", _data_->_tmp13_, NULL);
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp15_ = NULL;
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp15_ = _data_->_tmp14_;
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp16_ = NULL;
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp16_ = g_strconcat (_data_->_tmp15_, "' is not a valid uri", NULL);
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp17_ = NULL;
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp17_ = _data_->_tmp16_;
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp18_ = NULL;
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp18_ = g_error_new_literal (TRACKER_DATA_BACKUP_ERROR, TRACKER_DATA_BACKUP_ERROR_INVALID_URI, _data_->_tmp17_);
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp19_ = NULL;
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp19_ = _data_->_tmp18_;
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_g_free0 (_data_->_tmp17_);
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_g_free0 (_data_->_tmp15_);
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_inner_error_ = _data_->_tmp19_;
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_g_object_unref0 (_data_->destination);
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			block2_data_unref (_data_->_data2_);
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_data2_ = NULL;
#line 596 "tracker-backup.c"
			goto __catch0_g_error;
		}
#line 40 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_state_ = 1;
#line 40 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		tracker_store_pause (tracker_backup_save_ready, _data_);
#line 40 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		return FALSE;
#line 605 "tracker-backup.c"
		_state_1:
#line 40 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		tracker_store_pause_finish (_data_->_res_);
#line 42 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_data2_->backup_error = NULL;
#line 43 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp20_ = NULL;
#line 43 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp20_ = _data_->destination;
#line 43 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		tracker_data_backup_save (_data_->_tmp20_, ____lambda10__tracker_data_backup_finished, block2_data_ref (_data_->_data2_), block2_data_unref);
#line 47 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_state_ = 2;
#line 47 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		return FALSE;
#line 621 "tracker-backup.c"
		_state_2:
		;
#line 49 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp21_ = NULL;
#line 49 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp21_ = _data_->_data2_->backup_error;
#line 49 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		if (_data_->_tmp21_ != NULL) {
#line 50 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp22_ = NULL;
#line 50 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp22_ = _data_->_data2_->backup_error;
#line 50 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp23_ = NULL;
#line 50 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp23_ = _g_error_copy0 (_data_->_tmp22_);
#line 50 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_inner_error_ = _data_->_tmp23_;
#line 50 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_g_object_unref0 (_data_->destination);
#line 50 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			block2_data_unref (_data_->_data2_);
#line 50 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_data2_ = NULL;
#line 646 "tracker-backup.c"
			goto __catch0_g_error;
		}
#line 53 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp24_ = NULL;
#line 53 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp24_ = _data_->request;
#line 53 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		tracker_dbus_request_end (_data_->_tmp24_, NULL);
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_g_object_unref0 (_data_->destination);
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		block2_data_unref (_data_->_data2_);
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_data2_ = NULL;
#line 661 "tracker-backup.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->e = _data_->_inner_error_;
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_inner_error_ = NULL;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp25_ = NULL;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp25_ = _data_->request;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp26_ = NULL;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp26_ = _data_->e;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		tracker_dbus_request_end (_data_->_tmp25_, _data_->_tmp26_);
#line 56 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp27_ = NULL;
#line 56 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp27_ = _data_->e;
#line 56 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp28_ = NULL;
#line 56 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp28_ = _g_error_copy0 (_data_->_tmp27_);
#line 56 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_inner_error_ = _data_->_tmp28_;
#line 56 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_g_error_free0 (_data_->e);
#line 692 "tracker-backup.c"
		goto __finally0;
	}
	__finally0:
	{
#line 58 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp29_ = NULL;
#line 58 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp29_ = _data_->resources;
#line 58 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		if (_data_->_tmp29_ != NULL) {
#line 59 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			tracker_events_init ();
#line 60 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp30_ = NULL;
#line 60 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp30_ = _data_->resources;
#line 60 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			tracker_resources_enable_signals (_data_->_tmp30_);
#line 711 "tracker-backup.c"
		}
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		tracker_store_resume ();
#line 715 "tracker-backup.c"
	}
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		g_error_free (_data_->_inner_error_);
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_g_object_unref0 (_data_->resources);
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		block1_data_unref (_data_->_data1_);
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_data1_ = NULL;
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		if (_data_->_state_ == 0) {
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 733 "tracker-backup.c"
		} else {
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 737 "tracker-backup.c"
		}
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		g_object_unref (_data_->_async_result);
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		return FALSE;
#line 743 "tracker-backup.c"
	}
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_g_object_unref0 (_data_->resources);
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	block1_data_unref (_data_->_data1_);
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_data1_ = NULL;
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	if (_data_->_state_ == 0) {
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 755 "tracker-backup.c"
	} else {
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 759 "tracker-backup.c"
	}
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	g_object_unref (_data_->_async_result);
#line 25 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	return FALSE;
#line 765 "tracker-backup.c"
}


static void tracker_backup_restore_data_free (gpointer _data) {
	TrackerBackupRestoreData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_g_free0 (_data_->journal_uri);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_g_object_unref0 (_data_->self);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	g_slice_free (TrackerBackupRestoreData, _data_);
#line 780 "tracker-backup.c"
}


void tracker_backup_restore (TrackerBackup* self, const char* sender, const gchar* journal_uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerBackupRestoreData* _data_;
	TrackerBackup* _tmp0_ = NULL;
	const char* _tmp1_ = NULL;
	char* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_ = g_slice_new0 (TrackerBackupRestoreData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_backup_restore);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_backup_restore_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->self = _tmp0_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_tmp1_ = sender;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->sender = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_tmp3_ = journal_uri;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_g_free0 (_data_->journal_uri);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->journal_uri = _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	tracker_backup_restore_co (_data_);
#line 819 "tracker-backup.c"
}


void tracker_backup_restore_finish (TrackerBackup* self, GAsyncResult* _res_, GError** error) {
	TrackerBackupRestoreData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		return;
#line 829 "tracker-backup.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 833 "tracker-backup.c"
}


static void tracker_backup_restore_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerBackupRestoreData* _data_;
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_ = _user_data_;
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_source_object_ = source_object;
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_res_ = _res_;
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	tracker_backup_restore_co (_data_);
#line 847 "tracker-backup.c"
}


static gboolean tracker_backup_restore_co (TrackerBackupRestoreData* _data_) {
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	switch (_data_->_state_) {
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		case 0:
#line 856 "tracker-backup.c"
		goto _state_0;
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		case 1:
#line 860 "tracker-backup.c"
		goto _state_1;
		default:
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		g_assert_not_reached ();
#line 865 "tracker-backup.c"
	}
	_state_0:
#line 68 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_tmp0_ = NULL;
#line 68 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_tmp0_ = tracker_dbus_get_object (TRACKER_TYPE_RESOURCES);
#line 68 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->resources = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, TRACKER_TYPE_RESOURCES, TrackerResources);
#line 69 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_tmp1_ = NULL;
#line 69 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_tmp1_ = _data_->resources;
#line 69 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	if (_data_->_tmp1_ != NULL) {
#line 70 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp2_ = NULL;
#line 70 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp2_ = _data_->resources;
#line 70 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		tracker_resources_disable_signals (_data_->_tmp2_);
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		tracker_events_shutdown ();
#line 888 "tracker-backup.c"
	}
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_tmp3_ = NULL;
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_tmp3_ = _data_->sender;
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_tmp4_ = NULL;
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_tmp4_ = _data_->journal_uri;
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_tmp5_ = NULL;
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->_tmp5_ = tracker_dbus_request_begin ((const gchar*) _data_->_tmp3_, "D-Bus request to restore backup from '%s'", _data_->_tmp4_, NULL);
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_data_->request = _data_->_tmp5_;
#line 904 "tracker-backup.c"
	{
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_state_ = 1;
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		tracker_store_pause (tracker_backup_restore_ready, _data_);
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		return FALSE;
#line 912 "tracker-backup.c"
		_state_1:
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		tracker_store_pause_finish (_data_->_res_);
#line 78 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp6_ = NULL;
#line 78 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp6_ = _data_->journal_uri;
#line 78 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp7_ = NULL;
#line 78 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp7_ = g_file_new_for_uri (_data_->_tmp6_);
#line 78 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->journal = _data_->_tmp7_;
#line 80 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp9_ = NULL;
#line 80 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp9_ = _data_->journal;
#line 80 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		if (_data_->_tmp9_ == NULL) {
#line 80 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp8_ = TRUE;
#line 934 "tracker-backup.c"
		} else {
#line 80 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp10_ = NULL;
#line 80 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp10_ = _data_->journal;
#line 80 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp11_ = NULL;
#line 80 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp11_ = g_file_get_path (_data_->_tmp10_);
#line 80 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp12_ = NULL;
#line 80 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp12_ = _data_->_tmp11_;
#line 80 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp8_ = _data_->_tmp12_ == NULL;
#line 80 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_g_free0 (_data_->_tmp12_);
#line 952 "tracker-backup.c"
		}
#line 80 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		if (_data_->_tmp8_) {
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp13_ = NULL;
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp13_ = _data_->journal_uri;
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp14_ = NULL;
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp14_ = g_strconcat ("'", _data_->_tmp13_, NULL);
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp15_ = NULL;
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp15_ = _data_->_tmp14_;
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp16_ = NULL;
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp16_ = g_strconcat (_data_->_tmp15_, "' is not a valid uri", NULL);
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp17_ = NULL;
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp17_ = _data_->_tmp16_;
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp18_ = NULL;
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp18_ = g_error_new_literal (TRACKER_DATA_BACKUP_ERROR, TRACKER_DATA_BACKUP_ERROR_INVALID_URI, _data_->_tmp17_);
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp19_ = NULL;
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp19_ = _data_->_tmp18_;
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_g_free0 (_data_->_tmp17_);
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_g_free0 (_data_->_tmp15_);
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_inner_error_ = _data_->_tmp19_;
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_g_object_unref0 (_data_->journal);
#line 992 "tracker-backup.c"
			goto __catch1_g_error;
		}
#line 84 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp20_ = NULL;
#line 84 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp20_ = tracker_dbus_get_object (TRACKER_TYPE_STATUS);
#line 84 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->notifier = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp20_, TRACKER_TYPE_STATUS, TrackerStatus);
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp21_ = NULL;
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp21_ = _data_->notifier;
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp22_ = NULL;
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp23_ = NULL;
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp24_ = NULL;
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp24_ = tracker_status_get_callback (_data_->_tmp21_, &_data_->_tmp22_, &_data_->_tmp23_);
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->busy_callback_target = NULL;
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->busy_callback_target_destroy_notify = NULL;
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->busy_callback = _data_->_tmp24_;
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->busy_callback_target = _data_->_tmp22_;
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->busy_callback_target_destroy_notify = _data_->_tmp23_;
#line 87 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp25_ = NULL;
#line 87 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp25_ = _data_->journal;
#line 87 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp26_ = NULL;
#line 87 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp26__target = NULL;
#line 87 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp26_ = _data_->busy_callback;
#line 87 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp26__target = _data_->busy_callback_target;
#line 87 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		tracker_data_backup_restore (_data_->_tmp25_, NULL, _data_->_tmp26_, _data_->_tmp26__target, &_data_->_inner_error_);
#line 87 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 87 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			(_data_->busy_callback_target_destroy_notify == NULL) ? NULL : (_data_->busy_callback_target_destroy_notify (_data_->busy_callback_target), NULL);
#line 87 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->busy_callback = NULL;
#line 87 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->busy_callback_target = NULL;
#line 87 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->busy_callback_target_destroy_notify = NULL;
#line 87 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_g_object_unref0 (_data_->notifier);
#line 87 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_g_object_unref0 (_data_->journal);
#line 1051 "tracker-backup.c"
			goto __catch1_g_error;
		}
#line 89 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp27_ = NULL;
#line 89 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp27_ = _data_->request;
#line 89 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		tracker_dbus_request_end (_data_->_tmp27_, NULL);
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		(_data_->busy_callback_target_destroy_notify == NULL) ? NULL : (_data_->busy_callback_target_destroy_notify (_data_->busy_callback_target), NULL);
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->busy_callback = NULL;
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->busy_callback_target = NULL;
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->busy_callback_target_destroy_notify = NULL;
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_g_object_unref0 (_data_->notifier);
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_g_object_unref0 (_data_->journal);
#line 1072 "tracker-backup.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->e = _data_->_inner_error_;
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_inner_error_ = NULL;
#line 91 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp28_ = NULL;
#line 91 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp28_ = _data_->request;
#line 91 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp29_ = NULL;
#line 91 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp29_ = _data_->e;
#line 91 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		tracker_dbus_request_end (_data_->_tmp28_, _data_->_tmp29_);
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp30_ = NULL;
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp30_ = _data_->e;
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp31_ = NULL;
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp31_ = _g_error_copy0 (_data_->_tmp30_);
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_inner_error_ = _data_->_tmp31_;
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_g_error_free0 (_data_->e);
#line 1103 "tracker-backup.c"
		goto __finally1;
	}
	__finally1:
	{
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp32_ = NULL;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_data_->_tmp32_ = _data_->resources;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		if (_data_->_tmp32_ != NULL) {
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			tracker_events_init ();
#line 96 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp33_ = NULL;
#line 96 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			_data_->_tmp33_ = _data_->resources;
#line 96 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			tracker_resources_enable_signals (_data_->_tmp33_);
#line 1122 "tracker-backup.c"
		}
#line 99 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		tracker_store_resume ();
#line 1126 "tracker-backup.c"
	}
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		g_error_free (_data_->_inner_error_);
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		_g_object_unref0 (_data_->resources);
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		if (_data_->_state_ == 0) {
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1140 "tracker-backup.c"
		} else {
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1144 "tracker-backup.c"
		}
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		g_object_unref (_data_->_async_result);
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		return FALSE;
#line 1150 "tracker-backup.c"
	}
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	_g_object_unref0 (_data_->resources);
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	if (_data_->_state_ == 0) {
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1158 "tracker-backup.c"
	} else {
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1162 "tracker-backup.c"
	}
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	g_object_unref (_data_->_async_result);
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	return FALSE;
#line 1168 "tracker-backup.c"
}


TrackerBackup* tracker_backup_construct (GType object_type) {
	TrackerBackup * self = NULL;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	self = (TrackerBackup*) g_object_new (object_type, NULL);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	return self;
#line 1178 "tracker-backup.c"
}


TrackerBackup* tracker_backup_new (void) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	return tracker_backup_construct (TRACKER_TYPE_BACKUP);
#line 1185 "tracker-backup.c"
}


static void tracker_backup_class_init (TrackerBackupClass * klass) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-backup.vala"
	tracker_backup_parent_class = g_type_class_peek_parent (klass);
#line 1192 "tracker-backup.c"
}


static void tracker_backup_instance_init (TrackerBackup * self) {
}


GType tracker_backup_get_type (void) {
	static volatile gsize tracker_backup_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_backup_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerBackupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_backup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerBackup), 0, (GInstanceInitFunc) tracker_backup_instance_init, NULL };
		GType tracker_backup_type_id;
		tracker_backup_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerBackup", &g_define_type_info, 0);
		g_type_set_qdata (tracker_backup_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) tracker_backup_register_object);
		g_once_init_leave (&tracker_backup_type_id__volatile, tracker_backup_type_id);
	}
	return tracker_backup_type_id__volatile;
}


static void _dbus_tracker_backup_save (TrackerBackup* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* destination_uri = NULL;
	GVariant* _tmp0_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	destination_uri = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	tracker_backup_save (self, g_dbus_method_invocation_get_sender (invocation), destination_uri, (GAsyncReadyCallback) _dbus_tracker_backup_save_ready, invocation);
	_g_free0 (destination_uri);
}


static void _dbus_tracker_backup_save_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	tracker_backup_save_finish ((TrackerBackup*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_backup_restore (TrackerBackup* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* journal_uri = NULL;
	GVariant* _tmp1_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	journal_uri = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	tracker_backup_restore (self, g_dbus_method_invocation_get_sender (invocation), journal_uri, (GAsyncReadyCallback) _dbus_tracker_backup_restore_ready, invocation);
	_g_free0 (journal_uri);
}


static void _dbus_tracker_backup_restore_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	tracker_backup_restore_finish ((TrackerBackup*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void tracker_backup_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Save") == 0) {
		_dbus_tracker_backup_save (object, parameters, invocation);
	} else if (strcmp (method_name, "Restore") == 0) {
		_dbus_tracker_backup_restore (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* tracker_backup_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean tracker_backup_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint tracker_backup_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_tracker_backup_dbus_interface_info), &_tracker_backup_dbus_interface_vtable, data, _tracker_backup_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _tracker_backup_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}



