/* tracker-turtle-reader.c generated by valac 0.35.1.15-f996c-dirty, the Vala compiler
 * generated from tracker-turtle-reader.vala, do not modify */

/*
 * Copyright (C) 2009, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-sparql/tracker-sparql.h"
#include "libtracker-common/tracker-date-time.h"
#include "libtracker-data/tracker-db-interface.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-data/tracker-data-update.h"
#include "libtracker-data/tracker-data-backup.h"


#define TRACKER_TYPE_TURTLE_READER (tracker_turtle_reader_get_type ())
#define TRACKER_TURTLE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_TURTLE_READER, TrackerTurtleReader))
#define TRACKER_TURTLE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_TURTLE_READER, TrackerTurtleReaderClass))
#define TRACKER_IS_TURTLE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_TURTLE_READER))
#define TRACKER_IS_TURTLE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_TURTLE_READER))
#define TRACKER_TURTLE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_TURTLE_READER, TrackerTurtleReaderClass))

typedef struct _TrackerTurtleReader TrackerTurtleReader;
typedef struct _TrackerTurtleReaderClass TrackerTurtleReaderClass;
typedef struct _TrackerTurtleReaderPrivate TrackerTurtleReaderPrivate;

#define TRACKER_TYPE_SPARQL_SCANNER (tracker_sparql_scanner_get_type ())
#define TRACKER_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScanner))
#define TRACKER_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))
#define TRACKER_IS_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_IS_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_SPARQL_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))

typedef struct _TrackerSparqlScanner TrackerSparqlScanner;
typedef struct _TrackerSparqlScannerClass TrackerSparqlScannerClass;

#define TRACKER_TURTLE_READER_TYPE_TOKEN_INFO (tracker_turtle_reader_token_info_get_type ())

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

#define TRACKER_TYPE_SOURCE_LOCATION (tracker_source_location_get_type ())
typedef struct _TrackerSourceLocation TrackerSourceLocation;
typedef struct _TrackerTurtleReaderTokenInfo TrackerTurtleReaderTokenInfo;

#define TRACKER_TURTLE_READER_TYPE_STATE (tracker_turtle_reader_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _TrackerTurtleReader {
	GObject parent_instance;
	TrackerTurtleReaderPrivate * priv;
};

struct _TrackerTurtleReaderClass {
	GObjectClass parent_class;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_ABS,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BIND,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CEIL,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COALESCE,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_CONTAINS,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATA,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DAY,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FLOOR,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_HAVING,
	TRACKER_SPARQL_TOKEN_TYPE_HOURS,
	TRACKER_SPARQL_TOKEN_TYPE_IF,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LCASE,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MD5,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_MINUTES,
	TRACKER_SPARQL_TOKEN_TYPE_MONTH,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_NOW,
	TRACKER_SPARQL_TOKEN_TYPE_NULL,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_OR,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_RAND,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_REPLACE,
	TRACKER_SPARQL_TOKEN_TYPE_ROUND,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SECONDS,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SHA1,
	TRACKER_SPARQL_TOKEN_TYPE_SHA256,
	TRACKER_SPARQL_TOKEN_TYPE_SHA512,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRAFTER,
	TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE,
	TRACKER_SPARQL_TOKEN_TYPE_STRENDS,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_STRLEN,
	TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS,
	TRACKER_SPARQL_TOKEN_TYPE_SUBSTR,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UCASE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH,
	TRACKER_SPARQL_TOKEN_TYPE_YEAR
} TrackerSparqlTokenType;

struct _TrackerSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

struct _TrackerTurtleReaderTokenInfo {
	TrackerSparqlTokenType type;
	TrackerSourceLocation begin;
	TrackerSourceLocation end;
};

typedef enum  {
	TRACKER_TURTLE_READER_STATE_INITIAL,
	TRACKER_TURTLE_READER_STATE_BOS,
	TRACKER_TURTLE_READER_STATE_SUBJECT,
	TRACKER_TURTLE_READER_STATE_PREDICATE,
	TRACKER_TURTLE_READER_STATE_OBJECT
} TrackerTurtleReaderState;

struct _TrackerTurtleReaderPrivate {
	TrackerSparqlScanner* scanner;
	TrackerTurtleReaderTokenInfo* tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gint index;
	gint size;
	TrackerTurtleReaderState state;
	gchar* _graph;
	gchar* _subject;
	gchar* _predicate;
	gchar* _object;
	gboolean _object_is_uri;
	GHashTable* prefix_map;
	gchar** subject_stack;
	gint subject_stack_length1;
	gint _subject_stack_size_;
	gchar** predicate_stack;
	gint predicate_stack_length1;
	gint _predicate_stack_size_;
	gint bnodeid;
	guchar* base_uuid;
	gint base_uuid_length1;
	gint _base_uuid_size_;
	GMappedFile* mapped_file;
};


static gpointer tracker_turtle_reader_parent_class = NULL;

GType tracker_turtle_reader_get_type (void) G_GNUC_CONST;
GType tracker_sparql_scanner_get_type (void) G_GNUC_CONST;
static GType tracker_turtle_reader_token_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
GType tracker_source_location_get_type (void) G_GNUC_CONST;
TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self);
void tracker_source_location_free (TrackerSourceLocation* self);
static TrackerTurtleReaderTokenInfo* tracker_turtle_reader_token_info_dup (const TrackerTurtleReaderTokenInfo* self);
static void tracker_turtle_reader_token_info_free (TrackerTurtleReaderTokenInfo* self);
static GType tracker_turtle_reader_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define TRACKER_TURTLE_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_TURTLE_READER, TrackerTurtleReaderPrivate))
enum  {
	TRACKER_TURTLE_READER_DUMMY_PROPERTY,
	TRACKER_TURTLE_READER_GRAPH,
	TRACKER_TURTLE_READER_SUBJECT,
	TRACKER_TURTLE_READER_PREDICATE,
	TRACKER_TURTLE_READER_OBJECT,
	TRACKER_TURTLE_READER_OBJECT_IS_URI
};
#define TRACKER_TURTLE_READER_BUFFER_SIZE 32
TrackerTurtleReader* tracker_turtle_reader_new (const gchar* path, GError** error);
TrackerTurtleReader* tracker_turtle_reader_construct (GType object_type, const gchar* path, GError** error);
TrackerSparqlScanner* tracker_sparql_scanner_new (gchar* input, gsize len);
TrackerSparqlScanner* tracker_sparql_scanner_construct (GType object_type, gchar* input, gsize len);
void uuid_generate (guchar* uuid);
static gchar* tracker_turtle_reader_generate_bnodeid (TrackerTurtleReader* self, const gchar* user_bnodeid);
static inline gboolean tracker_turtle_reader_next_token (TrackerTurtleReader* self, GError** error);
TrackerSparqlTokenType tracker_sparql_scanner_read_token (TrackerSparqlScanner* self, TrackerSourceLocation* token_begin, TrackerSourceLocation* token_end, GError** error);
static inline TrackerSparqlTokenType tracker_turtle_reader_current (TrackerTurtleReader* self);
static inline gboolean tracker_turtle_reader_accept (TrackerTurtleReader* self, TrackerSparqlTokenType type, GError** error);
static GError* tracker_turtle_reader_get_error (TrackerTurtleReader* self, const gchar* msg);
static gboolean tracker_turtle_reader_expect (TrackerTurtleReader* self, TrackerSparqlTokenType type, GError** error);
const gchar* tracker_sparql_token_type_to_string (TrackerSparqlTokenType self);
static gchar* tracker_turtle_reader_get_last_string (TrackerTurtleReader* self, gint strip);
static gchar* tracker_turtle_reader_resolve_prefixed_name (TrackerTurtleReader* self, const gchar* prefix, const gchar* local_name, GError** error);
gboolean tracker_turtle_reader_next (TrackerTurtleReader* self, GError** error);
static void tracker_turtle_reader_set_subject (TrackerTurtleReader* self, const gchar* value);
static void tracker_turtle_reader_set_predicate (TrackerTurtleReader* self, const gchar* value);
static void tracker_turtle_reader_set_object (TrackerTurtleReader* self, const gchar* value);
static void tracker_turtle_reader_set_object_is_uri (TrackerTurtleReader* self, gboolean value);
const gchar* tracker_turtle_reader_get_subject (TrackerTurtleReader* self);
static void _vala_array_add12 (gchar** * array, int* length, int* size, gchar* value);
const gchar* tracker_turtle_reader_get_predicate (TrackerTurtleReader* self);
static void _vala_array_add13 (gchar** * array, int* length, int* size, gchar* value);
void tracker_turtle_reader_load (const gchar* path, GError** error);
gboolean tracker_turtle_reader_get_object_is_uri (TrackerTurtleReader* self);
const gchar* tracker_turtle_reader_get_graph (TrackerTurtleReader* self);
const gchar* tracker_turtle_reader_get_object (TrackerTurtleReader* self);
static void tracker_turtle_reader_set_graph (TrackerTurtleReader* self, const gchar* value);
static void tracker_turtle_reader_finalize (GObject * obj);
static void _vala_tracker_turtle_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_turtle_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static GType tracker_turtle_reader_state_get_type (void) {
	static volatile gsize tracker_turtle_reader_state_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_turtle_reader_state_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_TURTLE_READER_STATE_INITIAL, "TRACKER_TURTLE_READER_STATE_INITIAL", "initial"}, {TRACKER_TURTLE_READER_STATE_BOS, "TRACKER_TURTLE_READER_STATE_BOS", "bos"}, {TRACKER_TURTLE_READER_STATE_SUBJECT, "TRACKER_TURTLE_READER_STATE_SUBJECT", "subject"}, {TRACKER_TURTLE_READER_STATE_PREDICATE, "TRACKER_TURTLE_READER_STATE_PREDICATE", "predicate"}, {TRACKER_TURTLE_READER_STATE_OBJECT, "TRACKER_TURTLE_READER_STATE_OBJECT", "object"}, {0, NULL, NULL}};
		GType tracker_turtle_reader_state_type_id;
		tracker_turtle_reader_state_type_id = g_enum_register_static ("TrackerTurtleReaderState", values);
		g_once_init_leave (&tracker_turtle_reader_state_type_id__volatile, tracker_turtle_reader_state_type_id);
	}
	return tracker_turtle_reader_state_type_id__volatile;
}


TrackerTurtleReader* tracker_turtle_reader_construct (GType object_type, const gchar* path, GError** error) {
	TrackerTurtleReader * self = NULL;
	GMappedFile* _tmp0_;
	const gchar* _tmp1_;
	GMappedFile* _tmp2_;
	GMappedFile* _tmp3_;
	GMappedFile* _tmp4_;
	gchar* _tmp5_;
	GMappedFile* _tmp6_;
	gsize _tmp7_;
	TrackerSparqlScanner* _tmp8_;
	guchar* _tmp9_;
	guchar* _tmp10_;
	gint _tmp10__length1;
	TrackerTurtleReaderTokenInfo* _tmp11_;
	GHashFunc _tmp12_;
	GEqualFunc _tmp13_;
	GDestroyNotify _tmp14_;
	GDestroyNotify _tmp15_;
	GHashTable* _tmp16_;
	GError * _inner_error_ = NULL;
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self = (TrackerTurtleReader*) g_object_new (object_type, NULL);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp1_ = path;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp2_ = g_mapped_file_new (_tmp1_, FALSE, &_inner_error_);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = _tmp2_;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (_inner_error_->domain == G_FILE_ERROR) {
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_propagate_error (error, _inner_error_);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_g_object_unref0 (self);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return NULL;
#line 370 "tracker-turtle-reader.c"
		} else {
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_clear_error (&_inner_error_);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return NULL;
#line 378 "tracker-turtle-reader.c"
		}
	}
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp3_ = _tmp0_;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = NULL;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_mapped_file_unref0 (self->priv->mapped_file);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->mapped_file = _tmp3_;
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp4_ = self->priv->mapped_file;
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp5_ = g_mapped_file_get_contents (_tmp4_);
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp6_ = self->priv->mapped_file;
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp7_ = g_mapped_file_get_length (_tmp6_);
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp8_ = tracker_sparql_scanner_new (_tmp5_, _tmp7_);
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_object_unref0 (self->priv->scanner);
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->scanner = _tmp8_;
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp9_ = g_new0 (guchar, 16);
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->base_uuid = (g_free (self->priv->base_uuid), NULL);
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->base_uuid = _tmp9_;
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->base_uuid_length1 = 16;
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->_base_uuid_size_ = self->priv->base_uuid_length1;
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp10_ = self->priv->base_uuid;
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp10__length1 = self->priv->base_uuid_length1;
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	uuid_generate (_tmp10_);
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp11_ = g_new0 (TrackerTurtleReaderTokenInfo, TRACKER_TURTLE_READER_BUFFER_SIZE);
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->tokens = _tmp11_;
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->tokens_length1 = TRACKER_TURTLE_READER_BUFFER_SIZE;
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->_tokens_size_ = self->priv->tokens_length1;
#line 75 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp12_ = g_str_hash;
#line 75 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp13_ = g_str_equal;
#line 75 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp14_ = g_free;
#line 75 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp15_ = g_free;
#line 75 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp16_ = g_hash_table_new_full (_tmp12_, _tmp13_, _tmp14_, _tmp15_);
#line 75 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_hash_table_unref0 (self->priv->prefix_map);
#line 75 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->prefix_map = _tmp16_;
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_mapped_file_unref0 (_tmp0_);
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return self;
#line 447 "tracker-turtle-reader.c"
}


TrackerTurtleReader* tracker_turtle_reader_new (const gchar* path, GError** error) {
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return tracker_turtle_reader_construct (TRACKER_TYPE_TURTLE_READER, path, error);
#line 454 "tracker-turtle-reader.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 1314 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1314 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1314 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1314 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1315 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1315 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 477 "tracker-turtle-reader.c"
		glong _tmp4_;
#line 1316 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1316 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1316 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 485 "tracker-turtle-reader.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1318 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1318 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1318 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1318 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 497 "tracker-turtle-reader.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
#line 1325 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1327 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1327 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 521 "tracker-turtle-reader.c"
		glong _tmp2_;
#line 1327 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1327 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 527 "tracker-turtle-reader.c"
	} else {
#line 1327 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 531 "tracker-turtle-reader.c"
	}
#line 1327 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 535 "tracker-turtle-reader.c"
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
#line 1329 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1329 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1329 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1329 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 547 "tracker-turtle-reader.c"
	} else {
		gint _tmp6_;
		gint _tmp7_;
#line 1331 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1331 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1331 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 557 "tracker-turtle-reader.c"
	}
#line 1334 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1334 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 563 "tracker-turtle-reader.c"
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
#line 1335 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1335 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1335 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1336 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1336 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 577 "tracker-turtle-reader.c"
	} else {
		glong _tmp12_;
		glong _tmp13_;
#line 1338 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1338 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1338 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 587 "tracker-turtle-reader.c"
	}
#line 1340 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1340 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 593 "tracker-turtle-reader.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1341 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1341 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1341 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 602 "tracker-turtle-reader.c"
	}
#line 1343 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1343 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1343 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1343 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1344 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1344 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1344 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1344 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1344 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 622 "tracker-turtle-reader.c"
}


static gchar* tracker_turtle_reader_generate_bnodeid (TrackerTurtleReader* self, const gchar* user_bnodeid) {
	gchar* result = NULL;
	const gchar* _tmp0_;
#line 78 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = user_bnodeid;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (_tmp0_ == NULL) {
#line 635 "tracker-turtle-reader.c"
		gint _tmp1_;
		gint _tmp2_;
		gchar* _tmp3_;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp1_ = self->priv->bnodeid;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->bnodeid = _tmp1_ + 1;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp2_ = self->priv->bnodeid;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp3_ = g_strdup_printf (":%d", _tmp2_);
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		result = _tmp3_;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		return result;
#line 651 "tracker-turtle-reader.c"
	} else {
		GChecksum* checksum;
		GChecksum* _tmp4_;
		GChecksum* _tmp5_;
		guchar* _tmp6_;
		gint _tmp6__length1;
		GChecksum* _tmp7_;
		const gchar* _tmp8_;
		gchar* sha1;
		GChecksum* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp4_ = g_checksum_new (G_CHECKSUM_SHA1);
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		checksum = _tmp4_;
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp5_ = checksum;
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp6_ = self->priv->base_uuid;
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp6__length1 = self->priv->base_uuid_length1;
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_checksum_update (_tmp5_, _tmp6_, (gsize) 16);
#line 87 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp7_ = checksum;
#line 87 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp8_ = user_bnodeid;
#line 87 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_checksum_update (_tmp7_, (guchar*) _tmp8_, (gsize) -1);
#line 89 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp9_ = checksum;
#line 89 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp10_ = g_checksum_get_string (_tmp9_);
#line 89 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp11_ = g_strdup (_tmp10_);
#line 89 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		sha1 = _tmp11_;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp12_ = sha1;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp13_ = sha1;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp14_ = string_substring (_tmp13_, (glong) 8, (glong) -1);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp15_ = _tmp14_;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp16_ = sha1;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp17_ = string_substring (_tmp16_, (glong) 12, (glong) -1);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp18_ = _tmp17_;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp19_ = sha1;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp20_ = string_substring (_tmp19_, (glong) 16, (glong) -1);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp21_ = _tmp20_;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp22_ = sha1;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp23_ = string_substring (_tmp22_, (glong) 20, (glong) -1);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp24_ = _tmp23_;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp25_ = g_strdup_printf ("urn:uuid:%.8s-%.4s-%.4s-%.4s-%.12s", _tmp12_, _tmp15_, _tmp18_, _tmp21_, _tmp24_);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp26_ = _tmp25_;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_free (_tmp24_);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_free (_tmp21_);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_free (_tmp18_);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_free (_tmp15_);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		result = _tmp26_;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_free (sha1);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_checksum_free0 (checksum);
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		return result;
#line 751 "tracker-turtle-reader.c"
	}
}


static inline gboolean tracker_turtle_reader_next_token (TrackerTurtleReader* self, GError** error) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	TrackerTurtleReaderTokenInfo* _tmp16_;
	gint _tmp16__length1;
	gint _tmp17_;
	TrackerTurtleReaderTokenInfo _tmp18_;
	TrackerSparqlTokenType _tmp19_;
	GError * _inner_error_ = NULL;
#line 97 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 98 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->index;
#line 98 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->index = (_tmp0_ + 1) % TRACKER_TURTLE_READER_BUFFER_SIZE;
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp1_ = self->priv->size;
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->size = _tmp1_ - 1;
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp2_ = self->priv->size;
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (_tmp2_ <= 0) {
#line 781 "tracker-turtle-reader.c"
		TrackerSourceLocation begin = {0};
		TrackerSourceLocation end = {0};
		TrackerSparqlTokenType type;
		TrackerSparqlScanner* _tmp3_;
		TrackerSourceLocation _tmp4_ = {0};
		TrackerSourceLocation _tmp5_ = {0};
		TrackerSparqlTokenType _tmp6_;
		TrackerTurtleReaderTokenInfo* _tmp7_;
		gint _tmp7__length1;
		gint _tmp8_;
		TrackerSparqlTokenType _tmp9_;
		TrackerTurtleReaderTokenInfo* _tmp10_;
		gint _tmp10__length1;
		gint _tmp11_;
		TrackerSourceLocation _tmp12_;
		TrackerTurtleReaderTokenInfo* _tmp13_;
		gint _tmp13__length1;
		gint _tmp14_;
		TrackerSourceLocation _tmp15_;
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp3_ = self->priv->scanner;
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp6_ = tracker_sparql_scanner_read_token (_tmp3_, &_tmp4_, &_tmp5_, &_inner_error_);
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		begin = _tmp4_;
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		end = _tmp5_;
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		type = _tmp6_;
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_propagate_error (error, _inner_error_);
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				return FALSE;
#line 819 "tracker-turtle-reader.c"
			} else {
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_clear_error (&_inner_error_);
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				return FALSE;
#line 827 "tracker-turtle-reader.c"
			}
		}
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp7_ = self->priv->tokens;
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp7__length1 = self->priv->tokens_length1;
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp8_ = self->priv->index;
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp9_ = type;
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp7_[_tmp8_].type = _tmp9_;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp10_ = self->priv->tokens;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp10__length1 = self->priv->tokens_length1;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp11_ = self->priv->index;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp12_ = begin;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp10_[_tmp11_].begin = _tmp12_;
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp13_ = self->priv->tokens;
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp13__length1 = self->priv->tokens_length1;
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp14_ = self->priv->index;
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp15_ = end;
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp13_[_tmp14_].end = _tmp15_;
#line 106 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->size = 1;
#line 862 "tracker-turtle-reader.c"
	}
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp16_ = self->priv->tokens;
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp16__length1 = self->priv->tokens_length1;
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp17_ = self->priv->index;
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp18_ = _tmp16_[_tmp17_];
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp19_ = _tmp18_.type;
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp19_ != TRACKER_SPARQL_TOKEN_TYPE_EOF;
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 878 "tracker-turtle-reader.c"
}


static inline TrackerSparqlTokenType tracker_turtle_reader_current (TrackerTurtleReader* self) {
	TrackerSparqlTokenType result = 0;
	TrackerTurtleReaderTokenInfo* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	TrackerTurtleReaderTokenInfo _tmp2_;
	TrackerSparqlTokenType _tmp3_;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 112 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->tokens;
#line 112 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0__length1 = self->priv->tokens_length1;
#line 112 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp1_ = self->priv->index;
#line 112 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp2_ = _tmp0_[_tmp1_];
#line 112 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp3_ = _tmp2_.type;
#line 112 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp3_;
#line 112 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 905 "tracker-turtle-reader.c"
}


static inline gboolean tracker_turtle_reader_accept (TrackerTurtleReader* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	TrackerSparqlTokenType _tmp0_;
	TrackerSparqlTokenType _tmp1_;
	GError * _inner_error_ = NULL;
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = tracker_turtle_reader_current (self);
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp1_ = type;
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (_tmp0_ == _tmp1_) {
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_turtle_reader_next_token (self, &_inner_error_);
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_propagate_error (error, _inner_error_);
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				return FALSE;
#line 932 "tracker-turtle-reader.c"
			} else {
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_clear_error (&_inner_error_);
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				return FALSE;
#line 940 "tracker-turtle-reader.c"
			}
		}
#line 118 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		result = TRUE;
#line 118 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		return result;
#line 947 "tracker-turtle-reader.c"
	}
#line 120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = FALSE;
#line 120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 953 "tracker-turtle-reader.c"
}


static GError* tracker_turtle_reader_get_error (TrackerTurtleReader* self, const gchar* msg) {
	GError* result = NULL;
	TrackerTurtleReaderTokenInfo* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	TrackerTurtleReaderTokenInfo _tmp2_;
	TrackerSourceLocation _tmp3_;
	gint _tmp4_;
	TrackerTurtleReaderTokenInfo* _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_;
	TrackerTurtleReaderTokenInfo _tmp7_;
	TrackerSourceLocation _tmp8_;
	gint _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
#line 123 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 123 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->tokens;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0__length1 = self->priv->tokens_length1;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp1_ = self->priv->index;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp2_ = _tmp0_[_tmp1_];
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp3_ = _tmp2_.begin;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp4_ = _tmp3_.line;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp5_ = self->priv->tokens;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp5__length1 = self->priv->tokens_length1;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp6_ = self->priv->index;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp7_ = _tmp5_[_tmp6_];
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp8_ = _tmp7_.begin;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp9_ = _tmp8_.column;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp10_ = msg;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp11_ = g_strdup_printf ("%d.%d: syntax error, %s", _tmp4_, _tmp9_, _tmp10_);
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp12_ = _tmp11_;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp13_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, _tmp12_);
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp14_ = _tmp13_;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_free (_tmp12_);
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp14_;
#line 124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 1020 "tracker-turtle-reader.c"
}


static gboolean tracker_turtle_reader_expect (TrackerTurtleReader* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	TrackerSparqlTokenType _tmp1_;
	gboolean _tmp2_;
	TrackerSparqlTokenType _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError * _inner_error_ = NULL;
#line 127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp1_ = type;
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp2_ = tracker_turtle_reader_accept (self, _tmp1_, &_inner_error_);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = _tmp2_;
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_propagate_error (error, _inner_error_);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return FALSE;
#line 1052 "tracker-turtle-reader.c"
		} else {
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_clear_error (&_inner_error_);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return FALSE;
#line 1060 "tracker-turtle-reader.c"
		}
	}
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (_tmp0_) {
#line 129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		result = TRUE;
#line 129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		return result;
#line 1069 "tracker-turtle-reader.c"
	}
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp3_ = type;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp4_ = tracker_sparql_token_type_to_string (_tmp3_);
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp5_ = g_strdup_printf ("expected %s", _tmp4_);
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp6_ = _tmp5_;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp7_ = tracker_turtle_reader_get_error (self, _tmp6_);
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp8_ = _tmp7_;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_free (_tmp6_);
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_inner_error_ = _tmp8_;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_propagate_error (error, _inner_error_);
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		return FALSE;
#line 1093 "tracker-turtle-reader.c"
	} else {
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_clear_error (&_inner_error_);
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		return FALSE;
#line 1101 "tracker-turtle-reader.c"
	}
}


static gchar* tracker_turtle_reader_get_last_string (TrackerTurtleReader* self, gint strip) {
	gchar* result = NULL;
	gint last_index;
	gint _tmp0_;
	TrackerTurtleReaderTokenInfo* _tmp1_;
	gint _tmp1__length1;
	TrackerTurtleReaderTokenInfo _tmp2_;
	TrackerSourceLocation _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	TrackerTurtleReaderTokenInfo* _tmp6_;
	gint _tmp6__length1;
	TrackerTurtleReaderTokenInfo _tmp7_;
	TrackerSourceLocation _tmp8_;
	gchar* _tmp9_;
	TrackerTurtleReaderTokenInfo* _tmp10_;
	gint _tmp10__length1;
	TrackerTurtleReaderTokenInfo _tmp11_;
	TrackerSourceLocation _tmp12_;
	gchar* _tmp13_;
	gint _tmp14_;
	gchar* _tmp15_;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->index;
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	last_index = ((_tmp0_ + TRACKER_TURTLE_READER_BUFFER_SIZE) - 1) % TRACKER_TURTLE_READER_BUFFER_SIZE;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp1_ = self->priv->tokens;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp1__length1 = self->priv->tokens_length1;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp2_ = _tmp1_[last_index];
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp3_ = _tmp2_.begin;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp4_ = _tmp3_.pos;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp5_ = strip;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp6_ = self->priv->tokens;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp6__length1 = self->priv->tokens_length1;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp7_ = _tmp6_[last_index];
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp8_ = _tmp7_.end;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp9_ = _tmp8_.pos;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp10_ = self->priv->tokens;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp10__length1 = self->priv->tokens_length1;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp11_ = _tmp10_[last_index];
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp12_ = _tmp11_.begin;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp13_ = _tmp12_.pos;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp14_ = strip;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp15_ = string_substring ((const gchar*) (_tmp4_ + _tmp5_), (glong) 0, (glong) ((gint) ((_tmp9_ - _tmp13_) - (2 * _tmp14_))));
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp15_;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 1174 "tracker-turtle-reader.c"
}


static gchar* tracker_turtle_reader_resolve_prefixed_name (TrackerTurtleReader* self, const gchar* prefix, const gchar* local_name, GError** error) {
	gchar* result = NULL;
	gchar* ns;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GError * _inner_error_ = NULL;
#line 140 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 140 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 140 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (local_name != NULL, NULL);
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->prefix_map;
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp1_ = prefix;
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	ns = _tmp3_;
#line 142 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp4_ = ns;
#line 142 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (_tmp4_ == NULL) {
#line 1210 "tracker-turtle-reader.c"
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp5_ = prefix;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp6_ = g_strdup_printf ("use of undefined prefix `%s'", _tmp5_);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp7_ = _tmp6_;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp8_ = tracker_turtle_reader_get_error (self, _tmp7_);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp9_ = _tmp8_;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_free (_tmp7_);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_inner_error_ = _tmp9_;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_propagate_error (error, _inner_error_);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_free (ns);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return NULL;
#line 1238 "tracker-turtle-reader.c"
		} else {
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_free (ns);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_clear_error (&_inner_error_);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return NULL;
#line 1248 "tracker-turtle-reader.c"
		}
	}
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp10_ = ns;
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp11_ = local_name;
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp12_ = g_strconcat (_tmp10_, _tmp11_, NULL);
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp12_;
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_free (ns);
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 1263 "tracker-turtle-reader.c"
}


static void _vala_array_add12 (gchar** * array, int* length, int* size, gchar* value) {
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if ((*length) == (*size)) {
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1274 "tracker-turtle-reader.c"
	}
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	(*array)[(*length)++] = value;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	(*array)[*length] = NULL;
#line 1280 "tracker-turtle-reader.c"
}


static void _vala_array_add13 (gchar** * array, int* length, int* size, gchar* value) {
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if ((*length) == (*size)) {
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1291 "tracker-turtle-reader.c"
	}
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	(*array)[(*length)++] = value;
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	(*array)[*length] = NULL;
#line 1297 "tracker-turtle-reader.c"
}


gboolean tracker_turtle_reader_next (TrackerTurtleReader* self, GError** error) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 149 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	while (TRUE) {
#line 1308 "tracker-turtle-reader.c"
		TrackerTurtleReaderState _tmp0_;
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp0_ = self->priv->state;
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		switch (_tmp0_) {
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			case TRACKER_TURTLE_READER_STATE_INITIAL:
#line 1316 "tracker-turtle-reader.c"
			{
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				tracker_turtle_reader_next_token (self, &_inner_error_);
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error_);
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return FALSE;
#line 1328 "tracker-turtle-reader.c"
					} else {
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_clear_error (&_inner_error_);
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return FALSE;
#line 1336 "tracker-turtle-reader.c"
					}
				}
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				self->priv->state = TRACKER_TURTLE_READER_STATE_BOS;
#line 154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				continue;
#line 1343 "tracker-turtle-reader.c"
			}
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			case TRACKER_TURTLE_READER_STATE_BOS:
#line 1347 "tracker-turtle-reader.c"
			{
				gboolean _tmp1_;
				gboolean _tmp2_;
				gboolean _tmp16_;
				gboolean _tmp17_;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp2_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX, &_inner_error_);
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp1_ = _tmp2_;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error_);
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return FALSE;
#line 1365 "tracker-turtle-reader.c"
					} else {
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_clear_error (&_inner_error_);
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return FALSE;
#line 1373 "tracker-turtle-reader.c"
					}
				}
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_tmp1_) {
#line 1378 "tracker-turtle-reader.c"
					gchar* ns;
					gchar* _tmp3_;
					gboolean _tmp4_;
					gboolean _tmp5_;
					gchar* uri;
					gchar* _tmp7_;
					GHashTable* _tmp8_;
					const gchar* _tmp9_;
					gchar* _tmp10_;
					const gchar* _tmp11_;
					gchar* _tmp12_;
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp3_ = g_strdup ("");
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					ns = _tmp3_;
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp5_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp4_ = _tmp5_;
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error_);
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_free (ns);
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return FALSE;
#line 1408 "tracker-turtle-reader.c"
						} else {
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_free (ns);
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error_);
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return FALSE;
#line 1418 "tracker-turtle-reader.c"
						}
					}
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_tmp4_) {
#line 1423 "tracker-turtle-reader.c"
						gchar* _tmp6_;
#line 160 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp6_ = tracker_turtle_reader_get_last_string (self, 0);
#line 160 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_free (ns);
#line 160 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						ns = _tmp6_;
#line 1431 "tracker-turtle-reader.c"
					}
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error_);
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_free (ns);
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return FALSE;
#line 1445 "tracker-turtle-reader.c"
						} else {
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_free (ns);
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error_);
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return FALSE;
#line 1455 "tracker-turtle-reader.c"
						}
					}
#line 163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error_);
#line 163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_free (ns);
#line 163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return FALSE;
#line 1470 "tracker-turtle-reader.c"
						} else {
#line 163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_free (ns);
#line 163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error_);
#line 163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return FALSE;
#line 1480 "tracker-turtle-reader.c"
						}
					}
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp7_ = tracker_turtle_reader_get_last_string (self, 1);
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					uri = _tmp7_;
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp8_ = self->priv->prefix_map;
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp9_ = ns;
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp10_ = g_strdup (_tmp9_);
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp11_ = uri;
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp12_ = g_strdup (_tmp11_);
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					g_hash_table_insert (_tmp8_, _tmp10_, _tmp12_);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error_);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_free (uri);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_free (ns);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return FALSE;
#line 1513 "tracker-turtle-reader.c"
						} else {
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_free (uri);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_free (ns);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error_);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return FALSE;
#line 1525 "tracker-turtle-reader.c"
						}
					}
#line 167 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					g_free (uri);
#line 167 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					g_free (ns);
#line 167 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					continue;
#line 1534 "tracker-turtle-reader.c"
				} else {
					gboolean _tmp13_;
					gboolean _tmp14_;
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp14_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ATBASE, &_inner_error_);
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp13_ = _tmp14_;
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error_);
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return FALSE;
#line 1550 "tracker-turtle-reader.c"
						} else {
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error_);
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return FALSE;
#line 1558 "tracker-turtle-reader.c"
						}
					}
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_tmp13_) {
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 1573 "tracker-turtle-reader.c"
							} else {
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 1581 "tracker-turtle-reader.c"
							}
						}
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 1594 "tracker-turtle-reader.c"
							} else {
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 1602 "tracker-turtle-reader.c"
							}
						}
#line 171 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						continue;
#line 1607 "tracker-turtle-reader.c"
					} else {
						TrackerSparqlTokenType _tmp15_;
#line 172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp15_ = tracker_turtle_reader_current (self);
#line 172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_tmp15_ == TRACKER_SPARQL_TOKEN_TYPE_EOF) {
#line 173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							result = FALSE;
#line 173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return result;
#line 1618 "tracker-turtle-reader.c"
						}
					}
				}
#line 176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp17_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp16_ = _tmp17_;
#line 176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error_);
#line 176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return FALSE;
#line 1634 "tracker-turtle-reader.c"
					} else {
#line 176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_clear_error (&_inner_error_);
#line 176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return FALSE;
#line 1642 "tracker-turtle-reader.c"
					}
				}
#line 176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_tmp16_) {
#line 1647 "tracker-turtle-reader.c"
					gchar* _tmp18_;
					gchar* _tmp19_;
#line 177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp18_ = tracker_turtle_reader_get_last_string (self, 1);
#line 177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp19_ = _tmp18_;
#line 177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					tracker_turtle_reader_set_subject (self, _tmp19_);
#line 177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					g_free (_tmp19_);
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					continue;
#line 1662 "tracker-turtle-reader.c"
				} else {
					gboolean _tmp20_;
					gboolean _tmp21_;
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp21_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp20_ = _tmp21_;
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error_);
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return FALSE;
#line 1678 "tracker-turtle-reader.c"
						} else {
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error_);
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return FALSE;
#line 1686 "tracker-turtle-reader.c"
						}
					}
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_tmp20_) {
#line 1691 "tracker-turtle-reader.c"
						gchar* ns;
						gchar* _tmp22_;
						gchar* _tmp23_;
						const gchar* _tmp24_;
						gchar* _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						gchar* _tmp30_;
#line 182 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp22_ = tracker_turtle_reader_get_last_string (self, 0);
#line 182 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						ns = _tmp22_;
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_free (ns);
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 1718 "tracker-turtle-reader.c"
							} else {
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_free (ns);
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 1728 "tracker-turtle-reader.c"
							}
						}
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp24_ = ns;
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp25_ = tracker_turtle_reader_get_last_string (self, 0);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp26_ = _tmp25_;
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp27_ = string_substring (_tmp26_, (glong) 1, (glong) -1);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp28_ = _tmp27_;
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp29_ = tracker_turtle_reader_resolve_prefixed_name (self, _tmp24_, _tmp28_, &_inner_error_);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp30_ = _tmp29_;
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_free (_tmp28_);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_free (_tmp26_);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp23_ = _tmp30_;
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_free (ns);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 1761 "tracker-turtle-reader.c"
							} else {
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_free (ns);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 1771 "tracker-turtle-reader.c"
							}
						}
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_set_subject (self, _tmp23_);
#line 185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_free (_tmp23_);
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_free (ns);
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						continue;
#line 1784 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp31_;
						gboolean _tmp32_;
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp32_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp31_ = _tmp32_;
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 1800 "tracker-turtle-reader.c"
							} else {
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 1808 "tracker-turtle-reader.c"
							}
						}
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_tmp31_) {
#line 1813 "tracker-turtle-reader.c"
							gchar* _tmp33_;
							gchar* _tmp34_;
							gchar* _tmp35_;
							gchar* _tmp36_;
							gchar* _tmp37_;
							gchar* _tmp38_;
							gchar* _tmp39_;
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp34_ = tracker_turtle_reader_get_last_string (self, 0);
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp35_ = _tmp34_;
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp36_ = string_substring (_tmp35_, (glong) 1, (glong) -1);
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp37_ = _tmp36_;
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp38_ = tracker_turtle_reader_resolve_prefixed_name (self, "", _tmp37_, &_inner_error_);
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp39_ = _tmp38_;
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_free (_tmp37_);
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_free (_tmp35_);
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp33_ = _tmp39_;
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error_);
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return FALSE;
#line 1847 "tracker-turtle-reader.c"
								} else {
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error_);
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return FALSE;
#line 1855 "tracker-turtle-reader.c"
								}
							}
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_subject (self, _tmp33_);
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_free (_tmp33_);
#line 191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							continue;
#line 1866 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp40_;
							gboolean _tmp41_;
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp41_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error_);
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp40_ = _tmp41_;
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error_);
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return FALSE;
#line 1882 "tracker-turtle-reader.c"
								} else {
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error_);
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return FALSE;
#line 1890 "tracker-turtle-reader.c"
								}
							}
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_tmp40_) {
#line 1895 "tracker-turtle-reader.c"
								gchar* _tmp42_;
								gchar* _tmp43_;
								gchar* _tmp44_;
								gchar* _tmp45_;
								gchar* _tmp46_;
								gchar* _tmp47_;
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_propagate_error (error, _inner_error_);
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										return FALSE;
#line 1912 "tracker-turtle-reader.c"
									} else {
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_clear_error (&_inner_error_);
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										return FALSE;
#line 1920 "tracker-turtle-reader.c"
									}
								}
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp42_ = tracker_turtle_reader_get_last_string (self, 0);
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp43_ = _tmp42_;
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp44_ = string_substring (_tmp43_, (glong) 1, (glong) -1);
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp45_ = _tmp44_;
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp46_ = tracker_turtle_reader_generate_bnodeid (self, _tmp45_);
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp47_ = _tmp46_;
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								tracker_turtle_reader_set_subject (self, _tmp47_);
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_free (_tmp47_);
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_free (_tmp45_);
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_free (_tmp43_);
#line 196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								continue;
#line 1947 "tracker-turtle-reader.c"
							} else {
								GError* _tmp48_;
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp48_ = tracker_turtle_reader_get_error (self, "expected subject");
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_inner_error_ = _tmp48_;
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error_);
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return FALSE;
#line 1960 "tracker-turtle-reader.c"
								} else {
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error_);
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return FALSE;
#line 1968 "tracker-turtle-reader.c"
								}
							}
						}
					}
				}
			}
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			case TRACKER_TURTLE_READER_STATE_SUBJECT:
#line 1977 "tracker-turtle-reader.c"
			{
				gboolean _tmp49_;
				gboolean _tmp50_;
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp50_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp49_ = _tmp50_;
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error_);
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return FALSE;
#line 1993 "tracker-turtle-reader.c"
					} else {
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_clear_error (&_inner_error_);
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return FALSE;
#line 2001 "tracker-turtle-reader.c"
					}
				}
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_tmp49_) {
#line 2006 "tracker-turtle-reader.c"
					gchar* _tmp51_;
					gchar* _tmp52_;
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp51_ = tracker_turtle_reader_get_last_string (self, 1);
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp52_ = _tmp51_;
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					tracker_turtle_reader_set_predicate (self, _tmp52_);
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					g_free (_tmp52_);
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					continue;
#line 2021 "tracker-turtle-reader.c"
				} else {
					gboolean _tmp53_;
					gboolean _tmp54_;
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp54_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp53_ = _tmp54_;
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error_);
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return FALSE;
#line 2037 "tracker-turtle-reader.c"
						} else {
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error_);
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return FALSE;
#line 2045 "tracker-turtle-reader.c"
						}
					}
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_tmp53_) {
#line 2050 "tracker-turtle-reader.c"
						gchar* ns;
						gchar* _tmp55_;
						gchar* _tmp56_;
						const gchar* _tmp57_;
						gchar* _tmp58_;
						gchar* _tmp59_;
						gchar* _tmp60_;
						gchar* _tmp61_;
						gchar* _tmp62_;
						gchar* _tmp63_;
#line 208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp55_ = tracker_turtle_reader_get_last_string (self, 0);
#line 208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						ns = _tmp55_;
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_free (ns);
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 2077 "tracker-turtle-reader.c"
							} else {
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_free (ns);
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 2087 "tracker-turtle-reader.c"
							}
						}
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp57_ = ns;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp58_ = tracker_turtle_reader_get_last_string (self, 0);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp59_ = _tmp58_;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp60_ = string_substring (_tmp59_, (glong) 1, (glong) -1);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp61_ = _tmp60_;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp62_ = tracker_turtle_reader_resolve_prefixed_name (self, _tmp57_, _tmp61_, &_inner_error_);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp63_ = _tmp62_;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_free (_tmp61_);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_free (_tmp59_);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp56_ = _tmp63_;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_free (ns);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 2120 "tracker-turtle-reader.c"
							} else {
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_free (ns);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 2130 "tracker-turtle-reader.c"
							}
						}
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_set_predicate (self, _tmp56_);
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_free (_tmp56_);
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_free (ns);
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						continue;
#line 2143 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp64_;
						gboolean _tmp65_;
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp65_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp64_ = _tmp65_;
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 2159 "tracker-turtle-reader.c"
							} else {
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 2167 "tracker-turtle-reader.c"
							}
						}
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_tmp64_) {
#line 2172 "tracker-turtle-reader.c"
							gchar* _tmp66_;
							gchar* _tmp67_;
							gchar* _tmp68_;
							gchar* _tmp69_;
							gchar* _tmp70_;
							gchar* _tmp71_;
							gchar* _tmp72_;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp67_ = tracker_turtle_reader_get_last_string (self, 0);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp68_ = _tmp67_;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp69_ = string_substring (_tmp68_, (glong) 1, (glong) -1);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp70_ = _tmp69_;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp71_ = tracker_turtle_reader_resolve_prefixed_name (self, "", _tmp70_, &_inner_error_);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp72_ = _tmp71_;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_free (_tmp70_);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_free (_tmp68_);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp66_ = _tmp72_;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error_);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return FALSE;
#line 2206 "tracker-turtle-reader.c"
								} else {
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error_);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return FALSE;
#line 2214 "tracker-turtle-reader.c"
								}
							}
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_predicate (self, _tmp66_);
#line 215 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
#line 216 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_free (_tmp66_);
#line 216 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							continue;
#line 2225 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp73_;
							gboolean _tmp74_;
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp74_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_A, &_inner_error_);
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp73_ = _tmp74_;
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error_);
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return FALSE;
#line 2241 "tracker-turtle-reader.c"
								} else {
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error_);
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return FALSE;
#line 2249 "tracker-turtle-reader.c"
								}
							}
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_tmp73_) {
#line 218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								tracker_turtle_reader_set_predicate (self, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
#line 219 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
#line 220 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								continue;
#line 2260 "tracker-turtle-reader.c"
							} else {
								GError* _tmp75_;
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp75_ = tracker_turtle_reader_get_error (self, "expected predicate");
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_inner_error_ = _tmp75_;
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error_);
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return FALSE;
#line 2273 "tracker-turtle-reader.c"
								} else {
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error_);
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return FALSE;
#line 2281 "tracker-turtle-reader.c"
								}
							}
						}
					}
				}
			}
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			case TRACKER_TURTLE_READER_STATE_PREDICATE:
#line 2290 "tracker-turtle-reader.c"
			{
				gboolean _tmp76_;
				gboolean _tmp77_;
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp77_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp76_ = _tmp77_;
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error_);
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return FALSE;
#line 2306 "tracker-turtle-reader.c"
					} else {
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_clear_error (&_inner_error_);
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return FALSE;
#line 2314 "tracker-turtle-reader.c"
					}
				}
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_tmp76_) {
#line 2319 "tracker-turtle-reader.c"
					gchar* _tmp78_;
					gchar* _tmp79_;
#line 227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp78_ = tracker_turtle_reader_get_last_string (self, 1);
#line 227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp79_ = _tmp78_;
#line 227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					tracker_turtle_reader_set_object (self, _tmp79_);
#line 227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					g_free (_tmp79_);
#line 228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					tracker_turtle_reader_set_object_is_uri (self, TRUE);
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 230 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					result = TRUE;
#line 230 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					return result;
#line 2338 "tracker-turtle-reader.c"
				} else {
					gboolean _tmp80_;
					gboolean _tmp81_;
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp81_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp80_ = _tmp81_;
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error_);
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return FALSE;
#line 2354 "tracker-turtle-reader.c"
						} else {
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error_);
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return FALSE;
#line 2362 "tracker-turtle-reader.c"
						}
					}
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_tmp80_) {
#line 2367 "tracker-turtle-reader.c"
						gchar* ns;
						gchar* _tmp82_;
						gchar* _tmp83_;
						const gchar* _tmp84_;
						gchar* _tmp85_;
						gchar* _tmp86_;
						gchar* _tmp87_;
						gchar* _tmp88_;
						gchar* _tmp89_;
						gchar* _tmp90_;
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp82_ = tracker_turtle_reader_get_last_string (self, 0);
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						ns = _tmp82_;
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_free (ns);
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 2394 "tracker-turtle-reader.c"
							} else {
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_free (ns);
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 2404 "tracker-turtle-reader.c"
							}
						}
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp84_ = ns;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp85_ = tracker_turtle_reader_get_last_string (self, 0);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp86_ = _tmp85_;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp87_ = string_substring (_tmp86_, (glong) 1, (glong) -1);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp88_ = _tmp87_;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp89_ = tracker_turtle_reader_resolve_prefixed_name (self, _tmp84_, _tmp88_, &_inner_error_);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp90_ = _tmp89_;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_free (_tmp88_);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_free (_tmp86_);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp83_ = _tmp90_;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_free (ns);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 2437 "tracker-turtle-reader.c"
							} else {
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_free (ns);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 2447 "tracker-turtle-reader.c"
							}
						}
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_set_object (self, _tmp83_);
#line 236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_set_object_is_uri (self, TRUE);
#line 237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						result = TRUE;
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_free (_tmp83_);
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_free (ns);
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return result;
#line 2464 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp91_;
						gboolean _tmp92_;
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp92_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp91_ = _tmp92_;
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 2480 "tracker-turtle-reader.c"
							} else {
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 2488 "tracker-turtle-reader.c"
							}
						}
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_tmp91_) {
#line 2493 "tracker-turtle-reader.c"
							gchar* _tmp93_;
							gchar* _tmp94_;
							gchar* _tmp95_;
							gchar* _tmp96_;
							gchar* _tmp97_;
							gchar* _tmp98_;
							gchar* _tmp99_;
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp94_ = tracker_turtle_reader_get_last_string (self, 0);
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp95_ = _tmp94_;
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp96_ = string_substring (_tmp95_, (glong) 1, (glong) -1);
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp97_ = _tmp96_;
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp98_ = tracker_turtle_reader_resolve_prefixed_name (self, "", _tmp97_, &_inner_error_);
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp99_ = _tmp98_;
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_free (_tmp97_);
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_free (_tmp95_);
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp93_ = _tmp99_;
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error_);
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return FALSE;
#line 2527 "tracker-turtle-reader.c"
								} else {
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error_);
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return FALSE;
#line 2535 "tracker-turtle-reader.c"
								}
							}
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_object (self, _tmp93_);
#line 242 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_object_is_uri (self, TRUE);
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							result = TRUE;
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_free (_tmp93_);
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return result;
#line 2550 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp100_;
							gboolean _tmp101_;
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp101_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error_);
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp100_ = _tmp101_;
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error_);
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return FALSE;
#line 2566 "tracker-turtle-reader.c"
								} else {
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error_);
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return FALSE;
#line 2574 "tracker-turtle-reader.c"
								}
							}
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_tmp100_) {
#line 2579 "tracker-turtle-reader.c"
								gchar* _tmp102_;
								gchar* _tmp103_;
								gchar* _tmp104_;
								gchar* _tmp105_;
								gchar* _tmp106_;
								gchar* _tmp107_;
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_propagate_error (error, _inner_error_);
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										return FALSE;
#line 2596 "tracker-turtle-reader.c"
									} else {
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_clear_error (&_inner_error_);
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										return FALSE;
#line 2604 "tracker-turtle-reader.c"
									}
								}
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp102_ = tracker_turtle_reader_get_last_string (self, 0);
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp103_ = _tmp102_;
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp104_ = string_substring (_tmp103_, (glong) 1, (glong) -1);
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp105_ = _tmp104_;
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp106_ = tracker_turtle_reader_generate_bnodeid (self, _tmp105_);
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp107_ = _tmp106_;
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								tracker_turtle_reader_set_object (self, _tmp107_);
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_free (_tmp107_);
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_free (_tmp105_);
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_free (_tmp103_);
#line 249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								tracker_turtle_reader_set_object_is_uri (self, TRUE);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 251 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								result = TRUE;
#line 251 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return result;
#line 2635 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp108_;
								gboolean _tmp109_;
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp109_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET, &_inner_error_);
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp108_ = _tmp109_;
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_propagate_error (error, _inner_error_);
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										return FALSE;
#line 2651 "tracker-turtle-reader.c"
									} else {
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_clear_error (&_inner_error_);
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										return FALSE;
#line 2659 "tracker-turtle-reader.c"
									}
								}
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_tmp108_) {
#line 2664 "tracker-turtle-reader.c"
									gchar** _tmp110_;
									gint _tmp110__length1;
									const gchar* _tmp111_;
									gchar* _tmp112_;
									gchar** _tmp113_;
									gint _tmp113__length1;
									const gchar* _tmp114_;
									gchar* _tmp115_;
									gchar* _tmp116_;
									gchar* _tmp117_;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp110_ = self->priv->subject_stack;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp110__length1 = self->priv->subject_stack_length1;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp111_ = self->priv->_subject;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp112_ = g_strdup (_tmp111_);
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_vala_array_add12 (&self->priv->subject_stack, &self->priv->subject_stack_length1, &self->priv->_subject_stack_size_, _tmp112_);
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp113_ = self->priv->predicate_stack;
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp113__length1 = self->priv->predicate_stack_length1;
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp114_ = self->priv->_predicate;
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp115_ = g_strdup (_tmp114_);
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_vala_array_add13 (&self->priv->predicate_stack, &self->priv->predicate_stack_length1, &self->priv->_predicate_stack_size_, _tmp115_);
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp116_ = tracker_turtle_reader_generate_bnodeid (self, NULL);
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp117_ = _tmp116_;
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									tracker_turtle_reader_set_subject (self, _tmp117_);
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_free (_tmp117_);
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 258 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									continue;
#line 2707 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp118_ = FALSE;
									gboolean _tmp119_;
									gboolean _tmp120_;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp120_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1, &_inner_error_);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp119_ = _tmp120_;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											g_propagate_error (error, _inner_error_);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											return FALSE;
#line 2724 "tracker-turtle-reader.c"
										} else {
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											g_clear_error (&_inner_error_);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											return FALSE;
#line 2732 "tracker-turtle-reader.c"
										}
									}
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									if (_tmp119_) {
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp118_ = TRUE;
#line 2739 "tracker-turtle-reader.c"
									} else {
										gboolean _tmp121_;
										gboolean _tmp122_;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp122_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2, &_inner_error_);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp121_ = _tmp122_;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_propagate_error (error, _inner_error_);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												return FALSE;
#line 2755 "tracker-turtle-reader.c"
											} else {
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_clear_error (&_inner_error_);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												return FALSE;
#line 2763 "tracker-turtle-reader.c"
											}
										}
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp118_ = _tmp121_;
#line 2768 "tracker-turtle-reader.c"
									}
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									if (_tmp118_) {
#line 2772 "tracker-turtle-reader.c"
										GString* sb;
										GString* _tmp123_;
										gchar* s;
										gchar* _tmp124_;
										const gchar* p;
										const gchar* _tmp125_;
										const gchar* end;
										const gchar* _tmp126_;
										const gchar* _tmp127_;
										gint _tmp128_;
										gint _tmp129_;
										GString* _tmp156_;
										const gchar* _tmp157_;
										gboolean _tmp158_;
										gboolean _tmp159_;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp123_ = g_string_new ("");
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										sb = _tmp123_;
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp124_ = tracker_turtle_reader_get_last_string (self, 1);
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										s = _tmp124_;
#line 263 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp125_ = s;
#line 263 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										p = _tmp125_;
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp126_ = p;
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp127_ = s;
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp128_ = strlen (_tmp127_);
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp129_ = _tmp128_;
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										end = _tmp126_ + _tmp129_;
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										while (TRUE) {
#line 2812 "tracker-turtle-reader.c"
											const gchar* _tmp130_;
											const gchar* _tmp131_;
											const gchar* q;
											const gchar* _tmp132_;
											const gchar* _tmp133_;
											const gchar* _tmp134_;
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp130_ = p;
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp131_ = end;
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (!(((glong) _tmp130_) < ((glong) _tmp131_))) {
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												break;
#line 2827 "tracker-turtle-reader.c"
											}
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp132_ = p;
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp133_ = strchr (_tmp132_, (gint) '\\');
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											q = _tmp133_;
#line 267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp134_ = q;
#line 267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_tmp134_ == NULL) {
#line 2839 "tracker-turtle-reader.c"
												GString* _tmp135_;
												const gchar* _tmp136_;
												const gchar* _tmp137_;
												const gchar* _tmp138_;
												const gchar* _tmp139_;
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp135_ = sb;
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp136_ = p;
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp137_ = end;
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp138_ = p;
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_string_append_len (_tmp135_, _tmp136_, (gssize) ((glong) (_tmp137_ - _tmp138_)));
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp139_ = end;
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												p = _tmp139_;
#line 2859 "tracker-turtle-reader.c"
											} else {
												GString* _tmp140_;
												const gchar* _tmp141_;
												const gchar* _tmp142_;
												const gchar* _tmp143_;
												const gchar* _tmp144_;
												const gchar* _tmp145_;
												gchar _tmp146_;
												const gchar* _tmp155_;
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp140_ = sb;
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp141_ = p;
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp142_ = q;
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp143_ = p;
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_string_append_len (_tmp140_, _tmp141_, (gssize) ((glong) (_tmp142_ - _tmp143_)));
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp144_ = q;
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												p = _tmp144_ + 1;
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp145_ = p;
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp146_ = ((gchar*) _tmp145_)[0];
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												switch (_tmp146_) {
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case '\'':
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case '"':
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case '\\':
#line 2895 "tracker-turtle-reader.c"
													{
														GString* _tmp147_;
														const gchar* _tmp148_;
														gchar _tmp149_;
#line 277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp147_ = sb;
#line 277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp148_ = p;
#line 277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp149_ = ((gchar*) _tmp148_)[0];
#line 277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_string_append_c (_tmp147_, _tmp149_);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														break;
#line 2910 "tracker-turtle-reader.c"
													}
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case 'b':
#line 2914 "tracker-turtle-reader.c"
													{
														GString* _tmp150_;
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp150_ = sb;
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_string_append_c (_tmp150_, '\b');
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														break;
#line 2923 "tracker-turtle-reader.c"
													}
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case 'f':
#line 2927 "tracker-turtle-reader.c"
													{
														GString* _tmp151_;
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp151_ = sb;
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_string_append_c (_tmp151_, '\f');
#line 284 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														break;
#line 2936 "tracker-turtle-reader.c"
													}
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case 'n':
#line 2940 "tracker-turtle-reader.c"
													{
														GString* _tmp152_;
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp152_ = sb;
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_string_append_c (_tmp152_, '\n');
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														break;
#line 2949 "tracker-turtle-reader.c"
													}
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case 'r':
#line 2953 "tracker-turtle-reader.c"
													{
														GString* _tmp153_;
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp153_ = sb;
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_string_append_c (_tmp153_, '\r');
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														break;
#line 2962 "tracker-turtle-reader.c"
													}
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case 't':
#line 2966 "tracker-turtle-reader.c"
													{
														GString* _tmp154_;
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp154_ = sb;
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_string_append_c (_tmp154_, '\t');
#line 293 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														break;
#line 2975 "tracker-turtle-reader.c"
													}
													default:
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													break;
#line 2980 "tracker-turtle-reader.c"
												}
#line 295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp155_ = p;
#line 295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												p = _tmp155_ + 1;
#line 2986 "tracker-turtle-reader.c"
											}
										}
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp156_ = sb;
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp157_ = _tmp156_->str;
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										tracker_turtle_reader_set_object (self, _tmp157_);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										tracker_turtle_reader_set_object_is_uri (self, FALSE);
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp159_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp158_ = _tmp159_;
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_propagate_error (error, _inner_error_);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_free (s);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_g_string_free0 (sb);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												return FALSE;
#line 3015 "tracker-turtle-reader.c"
											} else {
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_free (s);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_g_string_free0 (sb);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_clear_error (&_inner_error_);
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												return FALSE;
#line 3027 "tracker-turtle-reader.c"
											}
										}
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										if (_tmp158_) {
#line 3032 "tracker-turtle-reader.c"
											gboolean _tmp160_;
											gboolean _tmp161_;
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp161_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp160_ = _tmp161_;
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_propagate_error (error, _inner_error_);
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_free (s);
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													_g_string_free0 (sb);
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return FALSE;
#line 3051 "tracker-turtle-reader.c"
												} else {
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_free (s);
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													_g_string_free0 (sb);
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_clear_error (&_inner_error_);
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return FALSE;
#line 3063 "tracker-turtle-reader.c"
												}
											}
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (!_tmp160_) {
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error_);
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_free (s);
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_g_string_free0 (sb);
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return FALSE;
#line 3082 "tracker-turtle-reader.c"
													} else {
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_free (s);
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_g_string_free0 (sb);
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_clear_error (&_inner_error_);
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return FALSE;
#line 3094 "tracker-turtle-reader.c"
													}
												}
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error_);
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_free (s);
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_g_string_free0 (sb);
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return FALSE;
#line 3111 "tracker-turtle-reader.c"
													} else {
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_free (s);
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_g_string_free0 (sb);
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_clear_error (&_inner_error_);
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return FALSE;
#line 3123 "tracker-turtle-reader.c"
													}
												}
											}
										}
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										result = TRUE;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_free (s);
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_g_string_free0 (sb);
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										return result;
#line 3136 "tracker-turtle-reader.c"
									} else {
										gboolean _tmp162_ = FALSE;
										gboolean _tmp163_;
										gboolean _tmp164_;
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp164_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1, &_inner_error_);
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp163_ = _tmp164_;
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_propagate_error (error, _inner_error_);
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												return FALSE;
#line 3153 "tracker-turtle-reader.c"
											} else {
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_clear_error (&_inner_error_);
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												return FALSE;
#line 3161 "tracker-turtle-reader.c"
											}
										}
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										if (_tmp163_) {
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp162_ = TRUE;
#line 3168 "tracker-turtle-reader.c"
										} else {
											gboolean _tmp165_;
											gboolean _tmp166_;
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp166_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2, &_inner_error_);
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp165_ = _tmp166_;
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_propagate_error (error, _inner_error_);
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return FALSE;
#line 3184 "tracker-turtle-reader.c"
												} else {
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_clear_error (&_inner_error_);
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return FALSE;
#line 3192 "tracker-turtle-reader.c"
												}
											}
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp162_ = _tmp165_;
#line 3197 "tracker-turtle-reader.c"
										}
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
										if (_tmp162_) {
#line 3201 "tracker-turtle-reader.c"
											gchar* _tmp167_;
											gchar* _tmp168_;
											gboolean _tmp169_;
											gboolean _tmp170_;
#line 311 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp167_ = tracker_turtle_reader_get_last_string (self, 3);
#line 311 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp168_ = _tmp167_;
#line 311 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											tracker_turtle_reader_set_object (self, _tmp168_);
#line 311 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											g_free (_tmp168_);
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											tracker_turtle_reader_set_object_is_uri (self, FALSE);
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp170_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp169_ = _tmp170_;
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_propagate_error (error, _inner_error_);
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return FALSE;
#line 3230 "tracker-turtle-reader.c"
												} else {
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_clear_error (&_inner_error_);
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return FALSE;
#line 3238 "tracker-turtle-reader.c"
												}
											}
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_tmp169_) {
#line 3243 "tracker-turtle-reader.c"
												gboolean _tmp171_;
												gboolean _tmp172_;
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp172_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp171_ = _tmp172_;
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error_);
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return FALSE;
#line 3258 "tracker-turtle-reader.c"
													} else {
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_clear_error (&_inner_error_);
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return FALSE;
#line 3266 "tracker-turtle-reader.c"
													}
												}
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (!_tmp171_) {
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
															g_propagate_error (error, _inner_error_);
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
															return FALSE;
#line 3281 "tracker-turtle-reader.c"
														} else {
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
															g_clear_error (&_inner_error_);
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
															return FALSE;
#line 3289 "tracker-turtle-reader.c"
														}
													}
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
															g_propagate_error (error, _inner_error_);
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
															return FALSE;
#line 3302 "tracker-turtle-reader.c"
														} else {
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
															g_clear_error (&_inner_error_);
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
															return FALSE;
#line 3310 "tracker-turtle-reader.c"
														}
													}
												}
											}
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											result = TRUE;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											return result;
#line 3319 "tracker-turtle-reader.c"
										} else {
											gboolean _tmp173_ = FALSE;
											gboolean _tmp174_ = FALSE;
											gboolean _tmp175_ = FALSE;
											gboolean _tmp176_ = FALSE;
											gboolean _tmp177_;
											gboolean _tmp178_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp178_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp177_ = _tmp178_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_propagate_error (error, _inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return FALSE;
#line 3339 "tracker-turtle-reader.c"
												} else {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_clear_error (&_inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return FALSE;
#line 3347 "tracker-turtle-reader.c"
												}
											}
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_tmp177_) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp176_ = TRUE;
#line 3354 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp179_;
												gboolean _tmp180_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp180_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DECIMAL, &_inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp179_ = _tmp180_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return FALSE;
#line 3370 "tracker-turtle-reader.c"
													} else {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_clear_error (&_inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return FALSE;
#line 3378 "tracker-turtle-reader.c"
													}
												}
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp176_ = _tmp179_;
#line 3383 "tracker-turtle-reader.c"
											}
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_tmp176_) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp175_ = TRUE;
#line 3389 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp181_;
												gboolean _tmp182_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp182_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE, &_inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp181_ = _tmp182_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return FALSE;
#line 3405 "tracker-turtle-reader.c"
													} else {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_clear_error (&_inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return FALSE;
#line 3413 "tracker-turtle-reader.c"
													}
												}
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp175_ = _tmp181_;
#line 3418 "tracker-turtle-reader.c"
											}
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_tmp175_) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp174_ = TRUE;
#line 3424 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp183_;
												gboolean _tmp184_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp184_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_TRUE, &_inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp183_ = _tmp184_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return FALSE;
#line 3440 "tracker-turtle-reader.c"
													} else {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_clear_error (&_inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return FALSE;
#line 3448 "tracker-turtle-reader.c"
													}
												}
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp174_ = _tmp183_;
#line 3453 "tracker-turtle-reader.c"
											}
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_tmp174_) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp173_ = TRUE;
#line 3459 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp185_;
												gboolean _tmp186_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp186_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_FALSE, &_inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp185_ = _tmp186_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return FALSE;
#line 3475 "tracker-turtle-reader.c"
													} else {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_clear_error (&_inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return FALSE;
#line 3483 "tracker-turtle-reader.c"
													}
												}
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp173_ = _tmp185_;
#line 3488 "tracker-turtle-reader.c"
											}
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_tmp173_) {
#line 3492 "tracker-turtle-reader.c"
												gchar* _tmp187_;
												gchar* _tmp188_;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp187_ = tracker_turtle_reader_get_last_string (self, 0);
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp188_ = _tmp187_;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												tracker_turtle_reader_set_object (self, _tmp188_);
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_free (_tmp188_);
#line 325 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												tracker_turtle_reader_set_object_is_uri (self, FALSE);
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												result = TRUE;
#line 327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												return result;
#line 3511 "tracker-turtle-reader.c"
											} else {
												GError* _tmp189_;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp189_ = tracker_turtle_reader_get_error (self, "expected object");
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_inner_error_ = _tmp189_;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_propagate_error (error, _inner_error_);
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return FALSE;
#line 3524 "tracker-turtle-reader.c"
												} else {
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_clear_error (&_inner_error_);
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return FALSE;
#line 3532 "tracker-turtle-reader.c"
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			case TRACKER_TURTLE_READER_STATE_OBJECT:
#line 3545 "tracker-turtle-reader.c"
			{
				gboolean _tmp190_;
				gboolean _tmp191_;
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp191_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp190_ = _tmp191_;
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error_);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return FALSE;
#line 3561 "tracker-turtle-reader.c"
					} else {
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_clear_error (&_inner_error_);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return FALSE;
#line 3569 "tracker-turtle-reader.c"
					}
				}
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_tmp190_) {
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					continue;
#line 3578 "tracker-turtle-reader.c"
				} else {
					gboolean _tmp192_;
					gboolean _tmp193_;
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp193_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, &_inner_error_);
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp192_ = _tmp193_;
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error_);
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return FALSE;
#line 3594 "tracker-turtle-reader.c"
						} else {
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error_);
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return FALSE;
#line 3602 "tracker-turtle-reader.c"
						}
					}
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_tmp192_) {
#line 3607 "tracker-turtle-reader.c"
						gboolean _tmp194_;
						gboolean _tmp195_;
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp195_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp194_ = _tmp195_;
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error_);
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 3622 "tracker-turtle-reader.c"
							} else {
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error_);
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return FALSE;
#line 3630 "tracker-turtle-reader.c"
							}
						}
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_tmp194_) {
#line 338 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							self->priv->state = TRACKER_TURTLE_READER_STATE_BOS;
#line 339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							continue;
#line 3639 "tracker-turtle-reader.c"
						}
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						continue;
#line 3645 "tracker-turtle-reader.c"
					} else {
						gchar** _tmp196_;
						gint _tmp196__length1;
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp196_ = self->priv->subject_stack;
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp196__length1 = self->priv->subject_stack_length1;
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_tmp196__length1 > 0) {
#line 3655 "tracker-turtle-reader.c"
							const gchar* _tmp197_;
							gchar** _tmp198_;
							gint _tmp198__length1;
							gchar** _tmp199_;
							gint _tmp199__length1;
							const gchar* _tmp200_;
							gint _tmp201_;
							gchar** _tmp202_;
							gint _tmp202__length1;
							gchar** _tmp203_;
							gint _tmp203__length1;
							const gchar* _tmp204_;
							gint _tmp205_;
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error_);
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return FALSE;
#line 3679 "tracker-turtle-reader.c"
								} else {
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error_);
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return FALSE;
#line 3687 "tracker-turtle-reader.c"
								}
							}
#line 347 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp197_ = self->priv->_subject;
#line 347 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_object (self, _tmp197_);
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_object_is_uri (self, TRUE);
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp198_ = self->priv->subject_stack;
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp198__length1 = self->priv->subject_stack_length1;
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp199_ = self->priv->subject_stack;
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp199__length1 = self->priv->subject_stack_length1;
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp200_ = _tmp198_[_tmp199__length1 - 1];
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_subject (self, _tmp200_);
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp201_ = self->priv->subject_stack_length1;
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							self->priv->subject_stack_length1 = _tmp201_ - 1;
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp202_ = self->priv->predicate_stack;
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp202__length1 = self->priv->predicate_stack_length1;
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp203_ = self->priv->predicate_stack;
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp203__length1 = self->priv->predicate_stack_length1;
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp204_ = _tmp202_[_tmp203__length1 - 1];
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_predicate (self, _tmp204_);
#line 354 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp205_ = self->priv->predicate_stack_length1;
#line 354 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							self->priv->predicate_stack_length1 = _tmp205_ - 1;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							result = TRUE;
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return result;
#line 3734 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp206_;
							gboolean _tmp207_;
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp207_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp206_ = _tmp207_;
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error_);
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return FALSE;
#line 3750 "tracker-turtle-reader.c"
								} else {
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error_);
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return FALSE;
#line 3758 "tracker-turtle-reader.c"
								}
							}
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_tmp206_) {
#line 359 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								self->priv->state = TRACKER_TURTLE_READER_STATE_BOS;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								continue;
#line 3767 "tracker-turtle-reader.c"
							} else {
								GError* _tmp208_;
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp208_ = tracker_turtle_reader_get_error (self, "expected comma, semicolon, or dot");
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_inner_error_ = _tmp208_;
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error_);
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return FALSE;
#line 3780 "tracker-turtle-reader.c"
								} else {
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error_);
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return FALSE;
#line 3788 "tracker-turtle-reader.c"
								}
							}
						}
					}
				}
			}
			default:
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			break;
#line 3798 "tracker-turtle-reader.c"
		}
	}
}


static gpointer _g_error_copy0 (gpointer self) {
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return self ? g_error_copy (self) : NULL;
#line 3807 "tracker-turtle-reader.c"
}


void tracker_turtle_reader_load (const gchar* path, GError** error) {
	GError * _inner_error_ = NULL;
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_if_fail (path != NULL);
#line 3815 "tracker-turtle-reader.c"
	{
		TrackerTurtleReader* reader;
		const gchar* _tmp0_;
		TrackerTurtleReader* _tmp1_;
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_data_begin_transaction (&_inner_error_);
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3826 "tracker-turtle-reader.c"
				goto __catch4_tracker_sparql_error;
			}
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 3831 "tracker-turtle-reader.c"
				goto __catch4_tracker_db_interface_error;
			}
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_clear_error (&_inner_error_);
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return;
#line 3840 "tracker-turtle-reader.c"
		}
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp0_ = path;
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp1_ = tracker_turtle_reader_new (_tmp0_, &_inner_error_);
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		reader = _tmp1_;
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3852 "tracker-turtle-reader.c"
				goto __catch4_tracker_sparql_error;
			}
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 3857 "tracker-turtle-reader.c"
				goto __catch4_tracker_db_interface_error;
			}
			goto __finally4;
		}
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		while (TRUE) {
#line 3864 "tracker-turtle-reader.c"
			gboolean _tmp2_;
			TrackerTurtleReader* _tmp3_;
			gboolean _tmp4_;
			TrackerTurtleReader* _tmp5_;
			gboolean _tmp6_;
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_tmp3_ = reader;
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_tmp4_ = tracker_turtle_reader_next (_tmp3_, &_inner_error_);
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_tmp2_ = _tmp4_;
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_g_object_unref0 (reader);
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3882 "tracker-turtle-reader.c"
					goto __catch4_tracker_sparql_error;
				}
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 3887 "tracker-turtle-reader.c"
					goto __catch4_tracker_db_interface_error;
				}
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_g_object_unref0 (reader);
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_clear_error (&_inner_error_);
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				return;
#line 3898 "tracker-turtle-reader.c"
			}
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (!_tmp2_) {
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				break;
#line 3904 "tracker-turtle-reader.c"
			}
#line 374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_tmp5_ = reader;
#line 374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_tmp6_ = _tmp5_->priv->_object_is_uri;
#line 374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_tmp6_) {
#line 3912 "tracker-turtle-reader.c"
				TrackerTurtleReader* _tmp7_;
				const gchar* _tmp8_;
				TrackerTurtleReader* _tmp9_;
				const gchar* _tmp10_;
				TrackerTurtleReader* _tmp11_;
				const gchar* _tmp12_;
				TrackerTurtleReader* _tmp13_;
				const gchar* _tmp14_;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp7_ = reader;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp8_ = _tmp7_->priv->_graph;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp9_ = reader;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp10_ = _tmp9_->priv->_subject;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp11_ = reader;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp12_ = _tmp11_->priv->_predicate;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp13_ = reader;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp14_ = _tmp13_->priv->_object;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				tracker_data_insert_statement_with_uri (_tmp8_, _tmp10_, _tmp12_, _tmp14_, &_inner_error_);
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_g_object_unref0 (reader);
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3945 "tracker-turtle-reader.c"
						goto __catch4_tracker_sparql_error;
					}
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 3950 "tracker-turtle-reader.c"
						goto __catch4_tracker_db_interface_error;
					}
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_g_object_unref0 (reader);
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					g_clear_error (&_inner_error_);
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					return;
#line 3961 "tracker-turtle-reader.c"
				}
			} else {
				TrackerTurtleReader* _tmp15_;
				const gchar* _tmp16_;
				TrackerTurtleReader* _tmp17_;
				const gchar* _tmp18_;
				TrackerTurtleReader* _tmp19_;
				const gchar* _tmp20_;
				TrackerTurtleReader* _tmp21_;
				const gchar* _tmp22_;
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp15_ = reader;
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp16_ = _tmp15_->priv->_graph;
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp17_ = reader;
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp18_ = _tmp17_->priv->_subject;
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp19_ = reader;
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp20_ = _tmp19_->priv->_predicate;
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp21_ = reader;
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp22_ = _tmp21_->priv->_object;
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				tracker_data_insert_statement_with_string (_tmp16_, _tmp18_, _tmp20_, _tmp22_, &_inner_error_);
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_g_object_unref0 (reader);
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3996 "tracker-turtle-reader.c"
						goto __catch4_tracker_sparql_error;
					}
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 4001 "tracker-turtle-reader.c"
						goto __catch4_tracker_db_interface_error;
					}
					goto __finally4;
				}
			}
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			tracker_data_update_buffer_might_flush (&_inner_error_);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_g_object_unref0 (reader);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 4015 "tracker-turtle-reader.c"
					goto __catch4_tracker_sparql_error;
				}
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 4020 "tracker-turtle-reader.c"
					goto __catch4_tracker_db_interface_error;
				}
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_g_object_unref0 (reader);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_clear_error (&_inner_error_);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
				return;
#line 4031 "tracker-turtle-reader.c"
			}
		}
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_data_commit_transaction (&_inner_error_);
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_g_object_unref0 (reader);
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 4042 "tracker-turtle-reader.c"
				goto __catch4_tracker_sparql_error;
			}
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 4047 "tracker-turtle-reader.c"
				goto __catch4_tracker_db_interface_error;
			}
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_g_object_unref0 (reader);
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_clear_error (&_inner_error_);
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return;
#line 4058 "tracker-turtle-reader.c"
		}
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_object_unref0 (reader);
#line 4062 "tracker-turtle-reader.c"
	}
	goto __finally4;
	__catch4_tracker_sparql_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		GError* _tmp24_;
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		e = _inner_error_;
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_inner_error_ = NULL;
#line 384 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_data_rollback_transaction ();
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp23_ = e;
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp24_ = _g_error_copy0 (_tmp23_);
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_inner_error_ = _tmp24_;
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_error_free0 (e);
#line 4084 "tracker-turtle-reader.c"
		goto __finally4;
	}
	goto __finally4;
	__catch4_tracker_db_interface_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		GError* _tmp26_;
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		e = _inner_error_;
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_inner_error_ = NULL;
#line 387 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_data_rollback_transaction ();
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp25_ = e;
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp26_ = _g_error_copy0 (_tmp25_);
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_inner_error_ = _tmp26_;
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_error_free0 (e);
#line 4107 "tracker-turtle-reader.c"
		goto __finally4;
	}
	__finally4:
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if ((((_inner_error_->domain == G_FILE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) || (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR)) {
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_propagate_error (error, _inner_error_);
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return;
#line 4119 "tracker-turtle-reader.c"
		} else {
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_clear_error (&_inner_error_);
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return;
#line 4127 "tracker-turtle-reader.c"
		}
	}
}


const gchar* tracker_turtle_reader_get_graph (TrackerTurtleReader* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->_graph;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp0_;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 4144 "tracker-turtle-reader.c"
}


static void tracker_turtle_reader_set_graph (TrackerTurtleReader* self, const gchar* value) {
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_if_fail (self != NULL);
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (g_strcmp0 (value, tracker_turtle_reader_get_graph (self)) != 0) {
#line 4153 "tracker-turtle-reader.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp0_ = value;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_free (self->priv->_graph);
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->_graph = _tmp1_;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_object_notify ((GObject *) self, "graph");
#line 4166 "tracker-turtle-reader.c"
	}
}


const gchar* tracker_turtle_reader_get_subject (TrackerTurtleReader* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->_subject;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp0_;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 4182 "tracker-turtle-reader.c"
}


static void tracker_turtle_reader_set_subject (TrackerTurtleReader* self, const gchar* value) {
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_if_fail (self != NULL);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (g_strcmp0 (value, tracker_turtle_reader_get_subject (self)) != 0) {
#line 4191 "tracker-turtle-reader.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp0_ = value;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_free (self->priv->_subject);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->_subject = _tmp1_;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_object_notify ((GObject *) self, "subject");
#line 4204 "tracker-turtle-reader.c"
	}
}


const gchar* tracker_turtle_reader_get_predicate (TrackerTurtleReader* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->_predicate;
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp0_;
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 4220 "tracker-turtle-reader.c"
}


static void tracker_turtle_reader_set_predicate (TrackerTurtleReader* self, const gchar* value) {
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_if_fail (self != NULL);
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (g_strcmp0 (value, tracker_turtle_reader_get_predicate (self)) != 0) {
#line 4229 "tracker-turtle-reader.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp0_ = value;
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_free (self->priv->_predicate);
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->_predicate = _tmp1_;
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_object_notify ((GObject *) self, "predicate");
#line 4242 "tracker-turtle-reader.c"
	}
}


const gchar* tracker_turtle_reader_get_object (TrackerTurtleReader* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->_object;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp0_;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 4258 "tracker-turtle-reader.c"
}


static void tracker_turtle_reader_set_object (TrackerTurtleReader* self, const gchar* value) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_if_fail (self != NULL);
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (g_strcmp0 (value, tracker_turtle_reader_get_object (self)) != 0) {
#line 4267 "tracker-turtle-reader.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp0_ = value;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_free (self->priv->_object);
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->_object = _tmp1_;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_object_notify ((GObject *) self, "object");
#line 4280 "tracker-turtle-reader.c"
	}
}


gboolean tracker_turtle_reader_get_object_is_uri (TrackerTurtleReader* self) {
	gboolean result;
	gboolean _tmp0_;
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->_object_is_uri;
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp0_;
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 4296 "tracker-turtle-reader.c"
}


static void tracker_turtle_reader_set_object_is_uri (TrackerTurtleReader* self, gboolean value) {
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_if_fail (self != NULL);
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (tracker_turtle_reader_get_object_is_uri (self) != value) {
#line 4305 "tracker-turtle-reader.c"
		gboolean _tmp0_;
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp0_ = value;
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->_object_is_uri = _tmp0_;
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_object_notify ((GObject *) self, "object-is-uri");
#line 4313 "tracker-turtle-reader.c"
	}
}


static TrackerTurtleReaderTokenInfo* tracker_turtle_reader_token_info_dup (const TrackerTurtleReaderTokenInfo* self) {
	TrackerTurtleReaderTokenInfo* dup;
#line 32 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	dup = g_new0 (TrackerTurtleReaderTokenInfo, 1);
#line 32 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	memcpy (dup, self, sizeof (TrackerTurtleReaderTokenInfo));
#line 32 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return dup;
#line 4326 "tracker-turtle-reader.c"
}


static void tracker_turtle_reader_token_info_free (TrackerTurtleReaderTokenInfo* self) {
#line 32 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_free (self);
#line 4333 "tracker-turtle-reader.c"
}


static GType tracker_turtle_reader_token_info_get_type (void) {
	static volatile gsize tracker_turtle_reader_token_info_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_turtle_reader_token_info_type_id__volatile)) {
		GType tracker_turtle_reader_token_info_type_id;
		tracker_turtle_reader_token_info_type_id = g_boxed_type_register_static ("TrackerTurtleReaderTokenInfo", (GBoxedCopyFunc) tracker_turtle_reader_token_info_dup, (GBoxedFreeFunc) tracker_turtle_reader_token_info_free);
		g_once_init_leave (&tracker_turtle_reader_token_info_type_id__volatile, tracker_turtle_reader_token_info_type_id);
	}
	return tracker_turtle_reader_token_info_type_id__volatile;
}


static void tracker_turtle_reader_class_init (TrackerTurtleReaderClass * klass) {
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	tracker_turtle_reader_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_type_class_add_private (klass, sizeof (TrackerTurtleReaderPrivate));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_turtle_reader_get_property;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_turtle_reader_set_property;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_turtle_reader_finalize;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_GRAPH, g_param_spec_string ("graph", "graph", "graph", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_SUBJECT, g_param_spec_string ("subject", "subject", "subject", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_PREDICATE, g_param_spec_string ("predicate", "predicate", "predicate", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_OBJECT, g_param_spec_string ("object", "object", "object", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_OBJECT_IS_URI, g_param_spec_boolean ("object-is-uri", "object-is-uri", "object-is-uri", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 4369 "tracker-turtle-reader.c"
}


static void tracker_turtle_reader_instance_init (TrackerTurtleReader * self) {
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv = TRACKER_TURTLE_READER_GET_PRIVATE (self);
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->bnodeid = 0;
#line 4378 "tracker-turtle-reader.c"
}


static void tracker_turtle_reader_finalize (GObject * obj) {
	TrackerTurtleReader * self;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_TURTLE_READER, TrackerTurtleReader);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_object_unref0 (self->priv->scanner);
#line 24 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_free (self->priv->_graph);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_free (self->priv->_subject);
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_free (self->priv->_predicate);
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_free (self->priv->_object);
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_hash_table_unref0 (self->priv->prefix_map);
#line 58 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->subject_stack = (_vala_array_free (self->priv->subject_stack, self->priv->subject_stack_length1, (GDestroyNotify) g_free), NULL);
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->predicate_stack = (_vala_array_free (self->priv->predicate_stack, self->priv->predicate_stack_length1, (GDestroyNotify) g_free), NULL);
#line 63 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->base_uuid = (g_free (self->priv->base_uuid), NULL);
#line 65 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_mapped_file_unref0 (self->priv->mapped_file);
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	G_OBJECT_CLASS (tracker_turtle_reader_parent_class)->finalize (obj);
#line 4410 "tracker-turtle-reader.c"
}


GType tracker_turtle_reader_get_type (void) {
	static volatile gsize tracker_turtle_reader_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_turtle_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerTurtleReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_turtle_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerTurtleReader), 0, (GInstanceInitFunc) tracker_turtle_reader_instance_init, NULL };
		GType tracker_turtle_reader_type_id;
		tracker_turtle_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerTurtleReader", &g_define_type_info, 0);
		g_once_init_leave (&tracker_turtle_reader_type_id__volatile, tracker_turtle_reader_type_id);
	}
	return tracker_turtle_reader_type_id__volatile;
}


static void _vala_tracker_turtle_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerTurtleReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_TYPE_TURTLE_READER, TrackerTurtleReader);
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	switch (property_id) {
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_GRAPH:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_value_set_string (value, tracker_turtle_reader_get_graph (self));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_SUBJECT:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_value_set_string (value, tracker_turtle_reader_get_subject (self));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_PREDICATE:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_value_set_string (value, tracker_turtle_reader_get_predicate (self));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_OBJECT:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_value_set_string (value, tracker_turtle_reader_get_object (self));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_OBJECT_IS_URI:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_value_set_boolean (value, tracker_turtle_reader_get_object_is_uri (self));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 4461 "tracker-turtle-reader.c"
		default:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 4467 "tracker-turtle-reader.c"
	}
}


static void _vala_tracker_turtle_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerTurtleReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_TYPE_TURTLE_READER, TrackerTurtleReader);
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
	switch (property_id) {
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_GRAPH:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_turtle_reader_set_graph (self, g_value_get_string (value));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_SUBJECT:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_turtle_reader_set_subject (self, g_value_get_string (value));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_PREDICATE:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_turtle_reader_set_predicate (self, g_value_get_string (value));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_OBJECT:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_turtle_reader_set_object (self, g_value_get_string (value));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_OBJECT_IS_URI:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_turtle_reader_set_object_is_uri (self, g_value_get_boolean (value));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 4507 "tracker-turtle-reader.c"
		default:
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 4513 "tracker-turtle-reader.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



