/* tracker-steroids.c generated by valac 0.11.4, the Vala compiler
 * generated from tracker-steroids.vala, do not modify */

/*
 * Copyright (C) 2010, Codeminded BVBA <abustany@gnome.org>
 * Copyright (C) 2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gio/gunixoutputstream.h>
#include <libtracker-common/tracker-common.h>
#include <libtracker-data/tracker-db-interface.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gio/gunixinputstream.h>
#include <gio/gunixfdlist.h>


#define TRACKER_TYPE_STEROIDS (tracker_steroids_get_type ())
#define TRACKER_STEROIDS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STEROIDS, TrackerSteroids))
#define TRACKER_STEROIDS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STEROIDS, TrackerSteroidsClass))
#define TRACKER_IS_STEROIDS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STEROIDS))
#define TRACKER_IS_STEROIDS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STEROIDS))
#define TRACKER_STEROIDS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STEROIDS, TrackerSteroidsClass))

typedef struct _TrackerSteroids TrackerSteroids;
typedef struct _TrackerSteroidsClass TrackerSteroidsClass;
typedef struct _TrackerSteroidsPrivate TrackerSteroidsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;

#define TRACKER_STORE_TYPE_PRIORITY (tracker_store_priority_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerSteroidsQueryData TrackerSteroidsQueryData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
typedef struct _TrackerSteroidsUpdateInternalData TrackerSteroidsUpdateInternalData;
typedef struct _TrackerSteroidsUpdateData TrackerSteroidsUpdateData;
typedef struct _TrackerSteroidsBatchUpdateData TrackerSteroidsBatchUpdateData;
typedef struct _TrackerSteroidsUpdateBlankData TrackerSteroidsUpdateBlankData;
typedef struct _TrackerSteroidsBatchUpdateBlankData TrackerSteroidsBatchUpdateBlankData;
typedef struct _TrackerSteroidsUpdateArrayData TrackerSteroidsUpdateArrayData;

struct _TrackerSteroids {
	GObject parent_instance;
	TrackerSteroidsPrivate * priv;
};

struct _TrackerSteroidsClass {
	GObjectClass parent_class;
};

struct _Block5Data {
	int _ref_count_;
	TrackerSteroids * self;
	GUnixOutputStream* output_stream;
	gpointer _async_data_;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	gchar** variable_names;
	gint variable_names_length1;
	gint _variable_names_size_;
};

typedef enum  {
	TRACKER_STORE_PRIORITY_HIGH,
	TRACKER_STORE_PRIORITY_LOW,
	TRACKER_STORE_PRIORITY_TURTLE,
	TRACKER_STORE_PRIORITY_N_PRIORITIES
} TrackerStorePriority;

typedef void (*TrackerStoreSparqlQueryInThread) (TrackerDBCursor* cursor, void* user_data, GError** error);
struct _TrackerSteroidsQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSteroids* self;
	char* sender;
	gchar* query;
	GUnixOutputStream* output_stream;
	gchar** result;
	gint result_length1;
	Block5Data* _data5_;
	TrackerDBusRequest* _tmp0_;
	TrackerDBusRequest* request;
	Block6Data* _data6_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	GError * e;
	GError* _tmp5_;
	GError * _inner_error_;
};

struct _TrackerSteroidsUpdateInternalData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSteroids* self;
	char* sender;
	TrackerStorePriority priority;
	gboolean blank;
	GUnixInputStream* input_stream;
	GVariant* result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	TrackerDBusRequest* _tmp2_;
	TrackerDBusRequest* request;
	gsize bytes_read;
	GDataInputStream* _tmp3_;
	GDataInputStream* data_input_stream;
	gint32 _tmp4_;
	gint query_size;
	guint8* _tmp5_;
	gint query_length1;
	gint _query_size_;
	guint8* _tmp6_;
	guint8* query;
	gsize _tmp7_;
	GDataInputStream* _tmp8_;
	GPtrArray* _tmp9_;
	GPtrArray* blank_nodes;
	GVariantBuilder* _tmp10_;
	GVariantBuilder* builder;
	gint i;
	gboolean _tmp11_;
	gint _tmp12_;
	gconstpointer _tmp13_;
	GPtrArray* _tmp14_;
	GPtrArray* inner_array;
	gint j;
	gboolean _tmp15_;
	gint _tmp16_;
	gconstpointer _tmp17_;
	GVariant* _tmp22_;
	GError * e;
	GError* _tmp23_;
	GError * _inner_error_;
};

struct _TrackerSteroidsUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSteroids* self;
	char* sender;
	GUnixInputStream* input_stream;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GError * _inner_error_;
};

struct _TrackerSteroidsBatchUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSteroids* self;
	char* sender;
	GUnixInputStream* input_stream;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GError * _inner_error_;
};

struct _TrackerSteroidsUpdateBlankData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSteroids* self;
	char* sender;
	GUnixInputStream* input_stream;
	GVariant* result;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GError * _inner_error_;
};

struct _TrackerSteroidsBatchUpdateBlankData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSteroids* self;
	char* sender;
	GUnixInputStream* input_stream;
	GVariant* result;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GError * _inner_error_;
};

struct _TrackerSteroidsUpdateArrayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSteroids* self;
	char* sender;
	GUnixInputStream* input_stream;
	GVariant* result;
	TrackerDBusRequest* _tmp0_;
	TrackerDBusRequest* request;
	GDataInputStream* _tmp1_;
	GDataInputStream* data_input_stream;
	gint32 _tmp2_;
	gint query_count;
	gchar** _tmp3_;
	gint query_array_length1;
	gint _query_array_size_;
	gchar** _tmp4_;
	gchar** query_array;
	gint i;
	gboolean _tmp5_;
	gsize bytes_read;
	gint32 _tmp6_;
	gint query_size;
	guint8* _tmp7_;
	gchar* _tmp8_;
	gsize _tmp9_;
	GDataInputStream* _tmp10_;
	GVariantBuilder* _tmp11_;
	GVariantBuilder* builder;
	gboolean _tmp12_;
	GError * e1;
	GVariant* _tmp13_;
	GError * e;
	GError* _tmp14_;
	GError * _inner_error_;
};


static gpointer tracker_steroids_parent_class = NULL;

GType tracker_steroids_get_type (void) G_GNUC_CONST;
guint tracker_steroids_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
enum  {
	TRACKER_STEROIDS_DUMMY_PROPERTY
};
#define TRACKER_STEROIDS_PATH "/org/freedesktop/Tracker1/Steroids"
#define TRACKER_STEROIDS_BUFFER_SIZE 65536
static void tracker_steroids_query_data_free (gpointer _data);
void tracker_steroids_query (TrackerSteroids* self, const char* sender, const gchar* query, GUnixOutputStream* output_stream, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** tracker_steroids_query_finish (TrackerSteroids* self, GAsyncResult* _res_, int* result_length1, GError** error);
static gboolean tracker_steroids_query_co (TrackerSteroidsQueryData* data);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
GType tracker_store_priority_get_type (void) G_GNUC_CONST;
void tracker_store_sparql_query (const gchar* sparql, TrackerStorePriority priority, TrackerStoreSparqlQueryInThread in_thread, void* in_thread_target, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_sparql_query_finish (GAsyncResult* _res_, GError** error);
static void _lambda5_ (TrackerDBCursor* cursor, Block6Data* _data6_, GError** error);
static void __lambda5__tracker_store_sparql_query_in_thread (TrackerDBCursor* cursor, gpointer self, GError** error);
static void tracker_steroids_query_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void tracker_steroids_update_internal_data_free (gpointer _data);
static void tracker_steroids_update_internal (TrackerSteroids* self, const char* sender, TrackerStorePriority priority, gboolean blank, GUnixInputStream* input_stream, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GVariant* tracker_steroids_update_internal_finish (TrackerSteroids* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_steroids_update_internal_co (TrackerSteroidsUpdateInternalData* data);
void tracker_store_sparql_update (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_sparql_update_finish (GAsyncResult* _res_, GError** error);
static void tracker_steroids_update_internal_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tracker_store_sparql_update_blank (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
GPtrArray* tracker_store_sparql_update_blank_finish (GAsyncResult* _res_, GError** error);
static GVariant* _variant_new2 (GHashTable* value);
static void tracker_steroids_update_data_free (gpointer _data);
void tracker_steroids_update (TrackerSteroids* self, const char* sender, GUnixInputStream* input_stream, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_steroids_update_finish (TrackerSteroids* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_steroids_update_co (TrackerSteroidsUpdateData* data);
static void tracker_steroids_update_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_steroids_batch_update_data_free (gpointer _data);
void tracker_steroids_batch_update (TrackerSteroids* self, const char* sender, GUnixInputStream* input_stream, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_steroids_batch_update_finish (TrackerSteroids* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_steroids_batch_update_co (TrackerSteroidsBatchUpdateData* data);
static void tracker_steroids_batch_update_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_steroids_update_blank_data_free (gpointer _data);
void tracker_steroids_update_blank (TrackerSteroids* self, const char* sender, GUnixInputStream* input_stream, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* tracker_steroids_update_blank_finish (TrackerSteroids* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_steroids_update_blank_co (TrackerSteroidsUpdateBlankData* data);
static void tracker_steroids_update_blank_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_steroids_batch_update_blank_data_free (gpointer _data);
void tracker_steroids_batch_update_blank (TrackerSteroids* self, const char* sender, GUnixInputStream* input_stream, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* tracker_steroids_batch_update_blank_finish (TrackerSteroids* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_steroids_batch_update_blank_co (TrackerSteroidsBatchUpdateBlankData* data);
static void tracker_steroids_batch_update_blank_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_steroids_update_array_data_free (gpointer _data);
void tracker_steroids_update_array (TrackerSteroids* self, const char* sender, GUnixInputStream* input_stream, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* tracker_steroids_update_array_finish (TrackerSteroids* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_steroids_update_array_co (TrackerSteroidsUpdateArrayData* data);
static void tracker_steroids_update_array_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
TrackerSteroids* tracker_steroids_new (void);
TrackerSteroids* tracker_steroids_construct (GType object_type);
static void _dbus_tracker_steroids_query (TrackerSteroids* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_tracker_steroids_query_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_tracker_steroids_update (TrackerSteroids* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_tracker_steroids_update_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_tracker_steroids_batch_update (TrackerSteroids* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_tracker_steroids_batch_update_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_tracker_steroids_update_blank (TrackerSteroids* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_tracker_steroids_update_blank_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_tracker_steroids_batch_update_blank (TrackerSteroids* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_tracker_steroids_batch_update_blank_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_tracker_steroids_update_array (TrackerSteroids* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_tracker_steroids_update_array_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void tracker_steroids_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* tracker_steroids_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean tracker_steroids_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _tracker_steroids_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _tracker_steroids_dbus_arg_info_query_query = {-1, "query", "s"};
static const GDBusArgInfo _tracker_steroids_dbus_arg_info_query_output_stream = {-1, "output_stream", "h"};
static const GDBusArgInfo _tracker_steroids_dbus_arg_info_query_result = {-1, "result", "as"};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_query_in[] = {&_tracker_steroids_dbus_arg_info_query_query, &_tracker_steroids_dbus_arg_info_query_output_stream, NULL};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_query_out[] = {&_tracker_steroids_dbus_arg_info_query_result, NULL};
static const GDBusMethodInfo _tracker_steroids_dbus_method_info_query = {-1, "Query", (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_query_in), (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_query_out)};
static const GDBusArgInfo _tracker_steroids_dbus_arg_info_update_input_stream = {-1, "input_stream", "h"};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_update_in[] = {&_tracker_steroids_dbus_arg_info_update_input_stream, NULL};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_update_out[] = {NULL};
static const GDBusMethodInfo _tracker_steroids_dbus_method_info_update = {-1, "Update", (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_update_in), (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_update_out)};
static const GDBusArgInfo _tracker_steroids_dbus_arg_info_batch_update_input_stream = {-1, "input_stream", "h"};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_batch_update_in[] = {&_tracker_steroids_dbus_arg_info_batch_update_input_stream, NULL};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_batch_update_out[] = {NULL};
static const GDBusMethodInfo _tracker_steroids_dbus_method_info_batch_update = {-1, "BatchUpdate", (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_batch_update_in), (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_batch_update_out)};
static const GDBusArgInfo _tracker_steroids_dbus_arg_info_update_blank_input_stream = {-1, "input_stream", "h"};
static const GDBusArgInfo _tracker_steroids_dbus_arg_info_update_blank_result = {-1, "result", "aaa{ss}"};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_update_blank_in[] = {&_tracker_steroids_dbus_arg_info_update_blank_input_stream, NULL};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_update_blank_out[] = {&_tracker_steroids_dbus_arg_info_update_blank_result, NULL};
static const GDBusMethodInfo _tracker_steroids_dbus_method_info_update_blank = {-1, "UpdateBlank", (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_update_blank_in), (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_update_blank_out)};
static const GDBusArgInfo _tracker_steroids_dbus_arg_info_batch_update_blank_input_stream = {-1, "input_stream", "h"};
static const GDBusArgInfo _tracker_steroids_dbus_arg_info_batch_update_blank_result = {-1, "result", "aaa{ss}"};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_batch_update_blank_in[] = {&_tracker_steroids_dbus_arg_info_batch_update_blank_input_stream, NULL};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_batch_update_blank_out[] = {&_tracker_steroids_dbus_arg_info_batch_update_blank_result, NULL};
static const GDBusMethodInfo _tracker_steroids_dbus_method_info_batch_update_blank = {-1, "BatchUpdateBlank", (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_batch_update_blank_in), (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_batch_update_blank_out)};
static const GDBusArgInfo _tracker_steroids_dbus_arg_info_update_array_input_stream = {-1, "input_stream", "h"};
static const GDBusArgInfo _tracker_steroids_dbus_arg_info_update_array_result = {-1, "result", "as"};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_update_array_in[] = {&_tracker_steroids_dbus_arg_info_update_array_input_stream, NULL};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_update_array_out[] = {&_tracker_steroids_dbus_arg_info_update_array_result, NULL};
static const GDBusMethodInfo _tracker_steroids_dbus_method_info_update_array = {-1, "UpdateArray", (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_update_array_in), (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_update_array_out)};
static const GDBusMethodInfo * const _tracker_steroids_dbus_method_info[] = {&_tracker_steroids_dbus_method_info_query, &_tracker_steroids_dbus_method_info_update, &_tracker_steroids_dbus_method_info_batch_update, &_tracker_steroids_dbus_method_info_update_blank, &_tracker_steroids_dbus_method_info_batch_update_blank, &_tracker_steroids_dbus_method_info_update_array, NULL};
static const GDBusSignalInfo * const _tracker_steroids_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _tracker_steroids_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _tracker_steroids_dbus_interface_info = {-1, "org.freedesktop.Tracker1.Steroids", (GDBusMethodInfo **) (&_tracker_steroids_dbus_method_info), (GDBusSignalInfo **) (&_tracker_steroids_dbus_signal_info), (GDBusPropertyInfo **) (&_tracker_steroids_dbus_property_info)};
static const GDBusInterfaceVTable _tracker_steroids_dbus_interface_vtable = {tracker_steroids_dbus_interface_method_call, tracker_steroids_dbus_interface_get_property, tracker_steroids_dbus_interface_set_property};

static void tracker_steroids_query_data_free (gpointer _data) {
	TrackerSteroidsQueryData* data;
	data = _data;
	_g_free0 (data->sender);
	_g_free0 (data->query);
	_g_object_unref0 (data->output_stream);
	data->result = (_vala_array_free (data->result, data->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSteroidsQueryData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void tracker_steroids_query (TrackerSteroids* self, const char* sender, const gchar* query, GUnixOutputStream* output_stream, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSteroidsQueryData* _data_;
	_data_ = g_slice_new0 (TrackerSteroidsQueryData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_steroids_query);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_steroids_query_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sender = g_strdup (sender);
	_data_->query = g_strdup (query);
	_data_->output_stream = _g_object_ref0 (output_stream);
	tracker_steroids_query_co (_data_);
}


gchar** tracker_steroids_query_finish (TrackerSteroids* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	gchar** result;
	TrackerSteroidsQueryData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->self);
		_g_object_unref0 (_data5_->output_stream);
		g_slice_free (Block5Data, _data5_);
	}
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		block5_data_unref (_data6_->_data5_);
		_data6_->variable_names = (_vala_array_free (_data6_->variable_names, _data6_->variable_names_length1, (GDestroyNotify) g_free), NULL);
		g_slice_free (Block6Data, _data6_);
	}
}


static void _lambda5_ (TrackerDBCursor* cursor, Block6Data* _data6_, GError** error) {
	Block5Data* _data5_;
	TrackerSteroids * self;
	GBufferedOutputStream* _tmp0_ = NULL;
	GBufferedOutputStream* _tmp1_;
	GDataOutputStream* _tmp2_ = NULL;
	GDataOutputStream* _tmp3_;
	GDataOutputStream* data_output_stream;
	gint _tmp4_;
	gint n_columns;
	gint* _tmp5_ = NULL;
	gint column_sizes_length1;
	gint _column_sizes_size_;
	gint* _tmp6_;
	gint* column_sizes;
	gint* _tmp7_ = NULL;
	gint column_offsets_length1;
	gint _column_offsets_size_;
	gint* _tmp8_;
	gint* column_offsets;
	gchar** _tmp9_ = NULL;
	gint column_data_length1;
	gint _column_data_size_;
	gchar** _tmp10_;
	gchar** column_data;
	gchar** _tmp11_ = NULL;
	gchar** _tmp12_;
	GError * _inner_error_ = NULL;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	g_return_if_fail (cursor != NULL);
	_tmp0_ = (GBufferedOutputStream*) g_buffered_output_stream_new_sized ((GOutputStream*) _data5_->output_stream, (gsize) TRACKER_STEROIDS_BUFFER_SIZE);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_data_output_stream_new ((GOutputStream*) _tmp1_);
	data_output_stream = (_tmp3_ = _tmp2_, _g_object_unref0 (_tmp1_), _tmp3_);
	g_data_output_stream_set_byte_order (data_output_stream, G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN);
	_tmp4_ = tracker_sparql_cursor_get_n_columns ((TrackerSparqlCursor*) cursor);
	n_columns = _tmp4_;
	_tmp5_ = g_new0 (gint, n_columns);
	_tmp6_ = _tmp5_;
	column_sizes_length1 = n_columns;
	_column_sizes_size_ = column_sizes_length1;
	column_sizes = _tmp6_;
	_tmp7_ = g_new0 (gint, n_columns);
	_tmp8_ = _tmp7_;
	column_offsets_length1 = n_columns;
	_column_offsets_size_ = column_offsets_length1;
	column_offsets = _tmp8_;
	_tmp9_ = g_new0 (gchar*, n_columns + 1);
	_tmp10_ = _tmp9_;
	column_data_length1 = n_columns;
	_column_data_size_ = column_data_length1;
	column_data = _tmp10_;
	_tmp11_ = g_new0 (gchar*, n_columns + 1);
	_tmp12_ = _tmp11_;
	_data6_->variable_names = (_vala_array_free (_data6_->variable_names, _data6_->variable_names_length1, (GDestroyNotify) g_free), NULL);
	_data6_->variable_names_length1 = n_columns;
	_data6_->variable_names = _tmp12_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp13_;
			_tmp13_ = TRUE;
			while (TRUE) {
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				gchar* _tmp16_;
				if (!_tmp13_) {
					i++;
				}
				_tmp13_ = FALSE;
				if (!(i < n_columns)) {
					break;
				}
				_tmp14_ = tracker_sparql_cursor_get_variable_name ((TrackerSparqlCursor*) cursor, i);
				_tmp15_ = g_strdup (_tmp14_);
				_tmp16_ = _tmp15_;
				_g_free0 (_data6_->variable_names[i]);
				_data6_->variable_names[i] = _tmp16_;
			}
		}
	}
	while (TRUE) {
		gboolean _tmp17_;
		gboolean _tmp18_;
		gint last_offset;
		_tmp17_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) cursor, NULL, &_inner_error_);
		_tmp18_ = _tmp17_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			column_data = (_vala_array_free (column_data, column_data_length1, (GDestroyNotify) g_free), NULL);
			column_offsets = (g_free (column_offsets), NULL);
			column_sizes = (g_free (column_sizes), NULL);
			_g_object_unref0 (data_output_stream);
			return;
		}
		if (!_tmp18_) {
			break;
		}
		last_offset = -1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp19_;
				_tmp19_ = TRUE;
				while (TRUE) {
					const gchar* _tmp20_ = NULL;
					const gchar* str;
					gint _tmp21_ = 0;
					gchar* _tmp23_;
					gchar* _tmp24_;
					if (!_tmp19_) {
						i++;
					}
					_tmp19_ = FALSE;
					if (!(i < n_columns)) {
						break;
					}
					_tmp20_ = tracker_sparql_cursor_get_string ((TrackerSparqlCursor*) cursor, i, NULL);
					str = _tmp20_;
					if (str != NULL) {
						gint _tmp22_;
						_tmp22_ = strlen (str);
						_tmp21_ = _tmp22_;
					} else {
						_tmp21_ = 0;
					}
					column_sizes[i] = _tmp21_;
					_tmp23_ = g_strdup (str);
					_tmp24_ = _tmp23_;
					_g_free0 (column_data[i]);
					column_data[i] = _tmp24_;
					last_offset = last_offset + (column_sizes[i] + 1);
					column_offsets[i] = last_offset;
				}
			}
		}
		g_data_output_stream_put_int32 (data_output_stream, (gint32) n_columns, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			column_data = (_vala_array_free (column_data, column_data_length1, (GDestroyNotify) g_free), NULL);
			column_offsets = (g_free (column_offsets), NULL);
			column_sizes = (g_free (column_sizes), NULL);
			_g_object_unref0 (data_output_stream);
			return;
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp25_;
				_tmp25_ = TRUE;
				while (TRUE) {
					TrackerSparqlValueType _tmp26_;
					if (!_tmp25_) {
						i++;
					}
					_tmp25_ = FALSE;
					if (!(i < n_columns)) {
						break;
					}
					_tmp26_ = tracker_sparql_cursor_get_value_type ((TrackerSparqlCursor*) cursor, i);
					g_data_output_stream_put_int32 (data_output_stream, (gint32) ((gint) _tmp26_), NULL, &_inner_error_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						column_data = (_vala_array_free (column_data, column_data_length1, (GDestroyNotify) g_free), NULL);
						column_offsets = (g_free (column_offsets), NULL);
						column_sizes = (g_free (column_sizes), NULL);
						_g_object_unref0 (data_output_stream);
						return;
					}
				}
			}
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp27_;
				_tmp27_ = TRUE;
				while (TRUE) {
					if (!_tmp27_) {
						i++;
					}
					_tmp27_ = FALSE;
					if (!(i < n_columns)) {
						break;
					}
					g_data_output_stream_put_int32 (data_output_stream, (gint32) column_offsets[i], NULL, &_inner_error_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						column_data = (_vala_array_free (column_data, column_data_length1, (GDestroyNotify) g_free), NULL);
						column_offsets = (g_free (column_offsets), NULL);
						column_sizes = (g_free (column_sizes), NULL);
						_g_object_unref0 (data_output_stream);
						return;
					}
				}
			}
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp28_;
				_tmp28_ = TRUE;
				while (TRUE) {
					const gchar* _tmp29_;
					if (!_tmp28_) {
						i++;
					}
					_tmp28_ = FALSE;
					if (!(i < n_columns)) {
						break;
					}
					_tmp29_ = NULL;
					if (column_data[i] != NULL) {
						_tmp29_ = column_data[i];
					} else {
						_tmp29_ = "";
					}
					g_data_output_stream_put_string (data_output_stream, _tmp29_, NULL, &_inner_error_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						column_data = (_vala_array_free (column_data, column_data_length1, (GDestroyNotify) g_free), NULL);
						column_offsets = (g_free (column_offsets), NULL);
						column_sizes = (g_free (column_sizes), NULL);
						_g_object_unref0 (data_output_stream);
						return;
					}
					g_data_output_stream_put_byte (data_output_stream, (guchar) 0, NULL, &_inner_error_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						column_data = (_vala_array_free (column_data, column_data_length1, (GDestroyNotify) g_free), NULL);
						column_offsets = (g_free (column_offsets), NULL);
						column_sizes = (g_free (column_sizes), NULL);
						_g_object_unref0 (data_output_stream);
						return;
					}
				}
			}
		}
	}
	column_data = (_vala_array_free (column_data, column_data_length1, (GDestroyNotify) g_free), NULL);
	column_offsets = (g_free (column_offsets), NULL);
	column_sizes = (g_free (column_sizes), NULL);
	_g_object_unref0 (data_output_stream);
}


static void __lambda5__tracker_store_sparql_query_in_thread (TrackerDBCursor* cursor, gpointer self, GError** error) {
	_lambda5_ (cursor, self, error);
}


static void tracker_steroids_query_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSteroidsQueryData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_steroids_query_co (data);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean tracker_steroids_query_co (TrackerSteroidsQueryData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data5_ = g_slice_new0 (Block5Data);
	data->_data5_->_ref_count_ = 1;
	data->_data5_->self = g_object_ref (data->self);
	data->_data5_->output_stream = _g_object_ref0 (data->output_stream);
	data->_data5_->_async_data_ = data;
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_dbus_request_begin ((const gchar*) data->sender, "Steroids.Query", NULL);
	data->request = data->_tmp0_;
	tracker_dbus_request_debug (data->request, "query: %s", data->query, NULL);
	data->_data6_ = g_slice_new0 (Block6Data);
	data->_data6_->_ref_count_ = 1;
	data->_data6_->_data5_ = block5_data_ref (data->_data5_);
	data->_tmp1_ = NULL;
	data->_data6_->variable_names_length1 = 0;
	data->_data6_->variable_names = data->_tmp1_;
	data->_state_ = 1;
	tracker_store_sparql_query (data->query, TRACKER_STORE_PRIORITY_HIGH, __lambda5__tracker_store_sparql_query_in_thread, data->_data6_, (const gchar*) data->sender, tracker_steroids_query_ready, data);
	return FALSE;
	_state_1:
	tracker_store_sparql_query_finish (data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		block6_data_unref (data->_data6_);
		goto __catch13_g_error;
	}
	tracker_dbus_request_end (data->request, NULL);
	data->_tmp2_ = (data->_tmp3_ = data->_data6_->variable_names, (data->_tmp3_ == NULL) ? ((gpointer) data->_tmp3_) : _vala_array_dup1 (data->_tmp3_, data->_data6_->variable_names_length1));
	data->_tmp4_ = data->_tmp2_;
	data->result_length1 = data->_data6_->variable_names_length1;
	data->result = data->_tmp4_;
	block6_data_unref (data->_data6_);
	block5_data_unref (data->_data5_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	block6_data_unref (data->_data6_);
	goto __finally13;
	__catch13_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		tracker_dbus_request_end (data->request, data->e);
		data->_tmp5_ = _g_error_copy0 (data->e);
		data->_inner_error_ = data->_tmp5_;
		_g_error_free0 (data->e);
		goto __finally13;
	}
	__finally13:
	g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
	g_error_free (data->_inner_error_);
	block5_data_unref (data->_data5_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	block5_data_unref (data->_data5_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_steroids_update_internal_data_free (gpointer _data) {
	TrackerSteroidsUpdateInternalData* data;
	data = _data;
	_g_free0 (data->sender);
	_g_object_unref0 (data->input_stream);
	_g_variant_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSteroidsUpdateInternalData, data);
}


static void tracker_steroids_update_internal (TrackerSteroids* self, const char* sender, TrackerStorePriority priority, gboolean blank, GUnixInputStream* input_stream, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSteroidsUpdateInternalData* _data_;
	_data_ = g_slice_new0 (TrackerSteroidsUpdateInternalData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_steroids_update_internal);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_steroids_update_internal_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sender = g_strdup (sender);
	_data_->priority = priority;
	_data_->blank = blank;
	_data_->input_stream = _g_object_ref0 (input_stream);
	tracker_steroids_update_internal_co (_data_);
}


static GVariant* tracker_steroids_update_internal_finish (TrackerSteroids* self, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerSteroidsUpdateInternalData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_steroids_update_internal_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSteroidsUpdateInternalData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_steroids_update_internal_co (data);
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	g_return_if_fail (self != NULL);
	g_ptr_array_set_size (self, value);
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static GVariant* _variant_new2 (GHashTable* value) {
	GVariantBuilder _tmp18_;
	GHashTableIter _tmp19_;
	gpointer _tmp20_;
	gpointer _tmp21_;
	g_hash_table_iter_init (&_tmp19_, value);
	g_variant_builder_init (&_tmp18_, G_VARIANT_TYPE ("a{ss}"));
	while (g_hash_table_iter_next (&_tmp19_, &_tmp20_, &_tmp21_)) {
		gchar* _key;
		gchar* _value;
		_key = (gchar*) _tmp20_;
		_value = (gchar*) _tmp21_;
		g_variant_builder_add (&_tmp18_, "{?*}", g_variant_new_string (_key), g_variant_new_string (_value));
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp18_));
}


static gboolean tracker_steroids_update_internal_co (TrackerSteroidsUpdateInternalData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->priority != TRACKER_STORE_PRIORITY_HIGH) {
		data->_tmp0_ = "Batch";
	} else {
		data->_tmp0_ = "";
	}
	if (data->blank) {
		data->_tmp1_ = "Blank";
	} else {
		data->_tmp1_ = "";
	}
	data->_tmp2_ = NULL;
	data->_tmp2_ = tracker_dbus_request_begin ((const gchar*) data->sender, "Steroids.%sUpdate%s", data->_tmp0_, data->_tmp1_, NULL);
	data->request = data->_tmp2_;
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_data_input_stream_new ((GInputStream*) data->input_stream);
	data->data_input_stream = data->_tmp3_;
	g_buffered_input_stream_set_buffer_size ((GBufferedInputStream*) data->data_input_stream, (gsize) TRACKER_STEROIDS_BUFFER_SIZE);
	g_data_input_stream_set_byte_order (data->data_input_stream, G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN);
	data->_tmp4_ = g_data_input_stream_read_int32 (data->data_input_stream, NULL, &data->_inner_error_);
	data->query_size = (gint) data->_tmp4_;
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->data_input_stream);
		goto __catch14_g_error;
	}
	data->_tmp5_ = NULL;
	data->_tmp5_ = g_new0 (guint8, data->query_size + 1);
	data->_tmp6_ = data->_tmp5_;
	data->query_length1 = data->query_size + 1;
	data->_query_size_ = data->query_length1;
	data->query = data->_tmp6_;
	g_input_stream_read_all ((GInputStream*) data->data_input_stream, data->query + 0, (gsize) (data->query_size - 0), &data->_tmp7_, NULL, &data->_inner_error_);
	data->bytes_read = data->_tmp7_;
	if (data->_inner_error_ != NULL) {
		data->query = (g_free (data->query), NULL);
		_g_object_unref0 (data->data_input_stream);
		goto __catch14_g_error;
	}
	data->_tmp8_ = NULL;
	_g_object_unref0 (data->data_input_stream);
	data->data_input_stream = data->_tmp8_;
	data->input_stream = NULL;
	tracker_dbus_request_debug (data->request, "query: %s", (const gchar*) data->query, NULL);
	if (!data->blank) {
		data->_state_ = 1;
		tracker_store_sparql_update ((const gchar*) data->query, data->priority, (const gchar*) data->sender, tracker_steroids_update_internal_ready, data);
		return FALSE;
		_state_1:
		tracker_store_sparql_update_finish (data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			data->query = (g_free (data->query), NULL);
			_g_object_unref0 (data->data_input_stream);
			goto __catch14_g_error;
		}
		tracker_dbus_request_end (data->request, NULL);
		data->result = NULL;
		data->query = (g_free (data->query), NULL);
		_g_object_unref0 (data->data_input_stream);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		data->_state_ = 2;
		tracker_store_sparql_update_blank ((const gchar*) data->query, data->priority, (const gchar*) data->sender, tracker_steroids_update_internal_ready, data);
		return FALSE;
		_state_2:
		data->_tmp9_ = NULL;
		data->_tmp9_ = tracker_store_sparql_update_blank_finish (data->_res_, &data->_inner_error_);
		data->blank_nodes = data->_tmp9_;
		if (data->_inner_error_ != NULL) {
			data->query = (g_free (data->query), NULL);
			_g_object_unref0 (data->data_input_stream);
			goto __catch14_g_error;
		}
		tracker_dbus_request_end (data->request, NULL);
		data->_tmp10_ = NULL;
		data->_tmp10_ = g_variant_builder_new ((GVariantType*) "aaa{ss}");
		data->builder = data->_tmp10_;
		{
			data->i = 0;
			{
				data->_tmp11_ = TRUE;
				while (TRUE) {
					if (!data->_tmp11_) {
						data->i++;
					}
					data->_tmp11_ = FALSE;
					data->_tmp12_ = g_ptr_array_get_length (data->blank_nodes);
					if (!(data->i < data->_tmp12_)) {
						break;
					}
					data->_tmp13_ = NULL;
					data->_tmp13_ = g_ptr_array_index (data->blank_nodes, (guint) data->i);
					data->_tmp14_ = _g_ptr_array_ref0 ((GPtrArray*) data->_tmp13_);
					data->inner_array = data->_tmp14_;
					g_variant_builder_open (data->builder, (GVariantType*) "aa{ss}");
					{
						data->j = 0;
						{
							data->_tmp15_ = TRUE;
							while (TRUE) {
								if (!data->_tmp15_) {
									data->j++;
								}
								data->_tmp15_ = FALSE;
								data->_tmp16_ = g_ptr_array_get_length (data->inner_array);
								if (!(data->j < data->_tmp16_)) {
									break;
								}
								data->_tmp17_ = NULL;
								data->_tmp17_ = g_ptr_array_index (data->inner_array, (guint) data->j);
								g_variant_builder_add_value (data->builder, _variant_new2 ((GHashTable*) data->_tmp17_));
							}
						}
					}
					g_variant_builder_close (data->builder);
					_g_ptr_array_unref0 (data->inner_array);
				}
			}
		}
		data->_tmp22_ = NULL;
		data->_tmp22_ = g_variant_builder_end (data->builder);
		data->result = g_variant_ref_sink (data->_tmp22_);
		_g_variant_builder_unref0 (data->builder);
		_g_ptr_array_unref0 (data->blank_nodes);
		data->query = (g_free (data->query), NULL);
		_g_object_unref0 (data->data_input_stream);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->query = (g_free (data->query), NULL);
	_g_object_unref0 (data->data_input_stream);
	goto __finally14;
	__catch14_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		tracker_dbus_request_end (data->request, data->e);
		data->_tmp23_ = _g_error_copy0 (data->e);
		data->_inner_error_ = data->_tmp23_;
		_g_error_free0 (data->e);
		goto __finally14;
	}
	__finally14:
	g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
	g_error_free (data->_inner_error_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_steroids_update_data_free (gpointer _data) {
	TrackerSteroidsUpdateData* data;
	data = _data;
	_g_free0 (data->sender);
	_g_object_unref0 (data->input_stream);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSteroidsUpdateData, data);
}


void tracker_steroids_update (TrackerSteroids* self, const char* sender, GUnixInputStream* input_stream, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSteroidsUpdateData* _data_;
	_data_ = g_slice_new0 (TrackerSteroidsUpdateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_steroids_update);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_steroids_update_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sender = g_strdup (sender);
	_data_->input_stream = _g_object_ref0 (input_stream);
	tracker_steroids_update_co (_data_);
}


void tracker_steroids_update_finish (TrackerSteroids* self, GAsyncResult* _res_, GError** error) {
	TrackerSteroidsUpdateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_steroids_update_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSteroidsUpdateData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_steroids_update_co (data);
}


static gboolean tracker_steroids_update_co (TrackerSteroidsUpdateData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	tracker_steroids_update_internal (data->self, data->sender, TRACKER_STORE_PRIORITY_HIGH, FALSE, data->input_stream, tracker_steroids_update_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_steroids_update_internal_finish (data->self, data->_res_, &data->_inner_error_);
	data->_tmp1_ = data->_tmp0_;
	_g_variant_unref0 (data->_tmp1_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_steroids_batch_update_data_free (gpointer _data) {
	TrackerSteroidsBatchUpdateData* data;
	data = _data;
	_g_free0 (data->sender);
	_g_object_unref0 (data->input_stream);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSteroidsBatchUpdateData, data);
}


void tracker_steroids_batch_update (TrackerSteroids* self, const char* sender, GUnixInputStream* input_stream, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSteroidsBatchUpdateData* _data_;
	_data_ = g_slice_new0 (TrackerSteroidsBatchUpdateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_steroids_batch_update);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_steroids_batch_update_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sender = g_strdup (sender);
	_data_->input_stream = _g_object_ref0 (input_stream);
	tracker_steroids_batch_update_co (_data_);
}


void tracker_steroids_batch_update_finish (TrackerSteroids* self, GAsyncResult* _res_, GError** error) {
	TrackerSteroidsBatchUpdateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_steroids_batch_update_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSteroidsBatchUpdateData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_steroids_batch_update_co (data);
}


static gboolean tracker_steroids_batch_update_co (TrackerSteroidsBatchUpdateData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	tracker_steroids_update_internal (data->self, data->sender, TRACKER_STORE_PRIORITY_LOW, FALSE, data->input_stream, tracker_steroids_batch_update_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_steroids_update_internal_finish (data->self, data->_res_, &data->_inner_error_);
	data->_tmp1_ = data->_tmp0_;
	_g_variant_unref0 (data->_tmp1_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_steroids_update_blank_data_free (gpointer _data) {
	TrackerSteroidsUpdateBlankData* data;
	data = _data;
	_g_free0 (data->sender);
	_g_object_unref0 (data->input_stream);
	_g_variant_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSteroidsUpdateBlankData, data);
}


void tracker_steroids_update_blank (TrackerSteroids* self, const char* sender, GUnixInputStream* input_stream, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSteroidsUpdateBlankData* _data_;
	_data_ = g_slice_new0 (TrackerSteroidsUpdateBlankData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_steroids_update_blank);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_steroids_update_blank_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sender = g_strdup (sender);
	_data_->input_stream = _g_object_ref0 (input_stream);
	tracker_steroids_update_blank_co (_data_);
}


GVariant* tracker_steroids_update_blank_finish (TrackerSteroids* self, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerSteroidsUpdateBlankData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_steroids_update_blank_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSteroidsUpdateBlankData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_steroids_update_blank_co (data);
}


static gboolean tracker_steroids_update_blank_co (TrackerSteroidsUpdateBlankData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	tracker_steroids_update_internal (data->self, data->sender, TRACKER_STORE_PRIORITY_HIGH, TRUE, data->input_stream, tracker_steroids_update_blank_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_steroids_update_internal_finish (data->self, data->_res_, &data->_inner_error_);
	data->_tmp1_ = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->result = data->_tmp1_;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_steroids_batch_update_blank_data_free (gpointer _data) {
	TrackerSteroidsBatchUpdateBlankData* data;
	data = _data;
	_g_free0 (data->sender);
	_g_object_unref0 (data->input_stream);
	_g_variant_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSteroidsBatchUpdateBlankData, data);
}


void tracker_steroids_batch_update_blank (TrackerSteroids* self, const char* sender, GUnixInputStream* input_stream, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSteroidsBatchUpdateBlankData* _data_;
	_data_ = g_slice_new0 (TrackerSteroidsBatchUpdateBlankData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_steroids_batch_update_blank);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_steroids_batch_update_blank_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sender = g_strdup (sender);
	_data_->input_stream = _g_object_ref0 (input_stream);
	tracker_steroids_batch_update_blank_co (_data_);
}


GVariant* tracker_steroids_batch_update_blank_finish (TrackerSteroids* self, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerSteroidsBatchUpdateBlankData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_steroids_batch_update_blank_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSteroidsBatchUpdateBlankData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_steroids_batch_update_blank_co (data);
}


static gboolean tracker_steroids_batch_update_blank_co (TrackerSteroidsBatchUpdateBlankData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	tracker_steroids_update_internal (data->self, data->sender, TRACKER_STORE_PRIORITY_LOW, TRUE, data->input_stream, tracker_steroids_batch_update_blank_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_steroids_update_internal_finish (data->self, data->_res_, &data->_inner_error_);
	data->_tmp1_ = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->result = data->_tmp1_;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_steroids_update_array_data_free (gpointer _data) {
	TrackerSteroidsUpdateArrayData* data;
	data = _data;
	_g_free0 (data->sender);
	_g_object_unref0 (data->input_stream);
	_g_variant_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSteroidsUpdateArrayData, data);
}


void tracker_steroids_update_array (TrackerSteroids* self, const char* sender, GUnixInputStream* input_stream, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSteroidsUpdateArrayData* _data_;
	_data_ = g_slice_new0 (TrackerSteroidsUpdateArrayData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_steroids_update_array);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_steroids_update_array_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sender = g_strdup (sender);
	_data_->input_stream = _g_object_ref0 (input_stream);
	tracker_steroids_update_array_co (_data_);
}


GVariant* tracker_steroids_update_array_finish (TrackerSteroids* self, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerSteroidsUpdateArrayData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_steroids_update_array_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSteroidsUpdateArrayData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_steroids_update_array_co (data);
}


static gboolean tracker_steroids_update_array_co (TrackerSteroidsUpdateArrayData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_dbus_request_begin ((const gchar*) data->sender, "Steroids.UpdateArray", NULL);
	data->request = data->_tmp0_;
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_data_input_stream_new ((GInputStream*) data->input_stream);
	data->data_input_stream = data->_tmp1_;
	g_buffered_input_stream_set_buffer_size ((GBufferedInputStream*) data->data_input_stream, (gsize) TRACKER_STEROIDS_BUFFER_SIZE);
	g_data_input_stream_set_byte_order (data->data_input_stream, G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN);
	data->_tmp2_ = g_data_input_stream_read_int32 (data->data_input_stream, NULL, &data->_inner_error_);
	data->query_count = (gint) data->_tmp2_;
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->data_input_stream);
		goto __catch15_g_error;
	}
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_new0 (gchar*, data->query_count + 1);
	data->_tmp4_ = data->_tmp3_;
	data->query_array_length1 = data->query_count;
	data->_query_array_size_ = data->query_array_length1;
	data->query_array = data->_tmp4_;
	{
		data->i = 0;
		data->_tmp5_ = TRUE;
		while (TRUE) {
			if (!data->_tmp5_) {
				data->i++;
			}
			data->_tmp5_ = FALSE;
			if (!(data->i < data->query_count)) {
				break;
			}
			data->_tmp6_ = g_data_input_stream_read_int32 (data->data_input_stream, NULL, &data->_inner_error_);
			data->query_size = (gint) data->_tmp6_;
			if (data->_inner_error_ != NULL) {
				data->query_array = (_vala_array_free (data->query_array, data->query_array_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (data->data_input_stream);
				goto __catch15_g_error;
			}
			data->_tmp7_ = NULL;
			data->_tmp7_ = g_new0 (guint8, data->query_size + 1);
			data->_tmp8_ = (gchar*) data->_tmp7_;
			_g_free0 (data->query_array[data->i]);
			data->query_array[data->i] = data->_tmp8_;
			g_input_stream_read_all ((GInputStream*) data->data_input_stream, ((guint8*) data->query_array[data->i]) + 0, (gsize) (data->query_size - 0), &data->_tmp9_, NULL, &data->_inner_error_);
			data->bytes_read = data->_tmp9_;
			if (data->_inner_error_ != NULL) {
				data->query_array = (_vala_array_free (data->query_array, data->query_array_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (data->data_input_stream);
				goto __catch15_g_error;
			}
		}
	}
	data->_tmp10_ = NULL;
	_g_object_unref0 (data->data_input_stream);
	data->data_input_stream = data->_tmp10_;
	data->input_stream = NULL;
	data->_tmp11_ = NULL;
	data->_tmp11_ = g_variant_builder_new ((GVariantType*) "as");
	data->builder = data->_tmp11_;
	{
		data->i = 0;
		data->_tmp12_ = TRUE;
		while (TRUE) {
			if (!data->_tmp12_) {
				data->i++;
			}
			data->_tmp12_ = FALSE;
			if (!(data->i < data->query_count)) {
				break;
			}
			tracker_dbus_request_debug (data->request, "query: %s", data->query_array[data->i], NULL);
			data->_state_ = 1;
			tracker_store_sparql_update (data->query_array[data->i], TRACKER_STORE_PRIORITY_HIGH, (const gchar*) data->sender, tracker_steroids_update_array_ready, data);
			return FALSE;
			_state_1:
			tracker_store_sparql_update_finish (data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch16_g_error;
			}
			g_variant_builder_add (data->builder, "s", "", NULL);
			g_variant_builder_add (data->builder, "s", "", NULL);
			goto __finally16;
			__catch16_g_error:
			{
				data->e1 = data->_inner_error_;
				data->_inner_error_ = NULL;
				g_variant_builder_add (data->builder, "s", "org.freedesktop.Tracker1.SparqlError.Internal", NULL);
				g_variant_builder_add (data->builder, "s", data->e1->message, NULL);
				_g_error_free0 (data->e1);
			}
			__finally16:
			if (data->_inner_error_ != NULL) {
				_g_variant_builder_unref0 (data->builder);
				data->query_array = (_vala_array_free (data->query_array, data->query_array_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (data->data_input_stream);
				goto __catch15_g_error;
			}
		}
	}
	tracker_dbus_request_end (data->request, NULL);
	data->_tmp13_ = NULL;
	data->_tmp13_ = g_variant_builder_end (data->builder);
	data->result = g_variant_ref_sink (data->_tmp13_);
	_g_variant_builder_unref0 (data->builder);
	data->query_array = (_vala_array_free (data->query_array, data->query_array_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (data->data_input_stream);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_variant_builder_unref0 (data->builder);
	data->query_array = (_vala_array_free (data->query_array, data->query_array_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (data->data_input_stream);
	goto __finally15;
	__catch15_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		tracker_dbus_request_end (data->request, data->e);
		data->_tmp14_ = _g_error_copy0 (data->e);
		data->_inner_error_ = data->_tmp14_;
		_g_error_free0 (data->e);
		goto __finally15;
	}
	__finally15:
	g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
	g_error_free (data->_inner_error_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


TrackerSteroids* tracker_steroids_construct (GType object_type) {
	TrackerSteroids * self = NULL;
	self = (TrackerSteroids*) g_object_new (object_type, NULL);
	return self;
}


TrackerSteroids* tracker_steroids_new (void) {
	return tracker_steroids_construct (TRACKER_TYPE_STEROIDS);
}


static void tracker_steroids_class_init (TrackerSteroidsClass * klass) {
	tracker_steroids_parent_class = g_type_class_peek_parent (klass);
}


static void tracker_steroids_instance_init (TrackerSteroids * self) {
}


GType tracker_steroids_get_type (void) {
	static volatile gsize tracker_steroids_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_steroids_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSteroidsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_steroids_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSteroids), 0, (GInstanceInitFunc) tracker_steroids_instance_init, NULL };
		GType tracker_steroids_type_id;
		tracker_steroids_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSteroids", &g_define_type_info, 0);
		g_type_set_qdata (tracker_steroids_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) tracker_steroids_register_object);
		g_once_init_leave (&tracker_steroids_type_id__volatile, tracker_steroids_type_id);
	}
	return tracker_steroids_type_id__volatile;
}


static void _dbus_tracker_steroids_query (TrackerSteroids* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gint _fd_index = 0;
	gchar* query = NULL;
	GVariant* _tmp8_;
	GUnixOutputStream* output_stream = NULL;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	query = g_variant_dup_string (_tmp8_, NULL);
	g_variant_unref (_tmp8_);
	g_variant_iter_next (&_arguments_iter, "h", &_fd_index);
	output_stream = (GUnixOutputStream *) g_unix_output_stream_new (g_unix_fd_list_get (g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)), _fd_index, NULL), TRUE);
	tracker_steroids_query (self, g_dbus_method_invocation_get_sender (invocation), query, output_stream, (GAsyncReadyCallback) _dbus_tracker_steroids_query_ready, invocation);
	_g_free0 (query);
	_g_object_unref0 (output_stream);
}


static void _dbus_tracker_steroids_query_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GUnixFDList *_fd_list;
	gchar** result;
	int result_length1 = 0;
	gchar** _tmp9_;
	GVariantBuilder _tmp10_;
	int _tmp11_;
	invocation = _user_data_;
	result = tracker_steroids_query_finish ((TrackerSteroids*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_fd_list = g_unix_fd_list_new ();
	_tmp9_ = result;
	g_variant_builder_init (&_tmp10_, G_VARIANT_TYPE ("as"));
	for (_tmp11_ = 0; _tmp11_ < result_length1; _tmp11_++) {
		g_variant_builder_add_value (&_tmp10_, g_variant_new_string (*_tmp9_));
		_tmp9_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp10_));
	result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_message_set_unix_fd_list (_reply_message, _fd_list);
	g_object_unref (_fd_list);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_steroids_update (TrackerSteroids* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gint _fd_index = 0;
	GUnixInputStream* input_stream = NULL;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_variant_iter_next (&_arguments_iter, "h", &_fd_index);
	input_stream = (GUnixInputStream *) g_unix_input_stream_new (g_unix_fd_list_get (g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)), _fd_index, NULL), TRUE);
	tracker_steroids_update (self, g_dbus_method_invocation_get_sender (invocation), input_stream, (GAsyncReadyCallback) _dbus_tracker_steroids_update_ready, invocation);
	_g_object_unref0 (input_stream);
}


static void _dbus_tracker_steroids_update_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GUnixFDList *_fd_list;
	invocation = _user_data_;
	tracker_steroids_update_finish ((TrackerSteroids*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_fd_list = g_unix_fd_list_new ();
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_message_set_unix_fd_list (_reply_message, _fd_list);
	g_object_unref (_fd_list);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_steroids_batch_update (TrackerSteroids* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gint _fd_index = 0;
	GUnixInputStream* input_stream = NULL;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_variant_iter_next (&_arguments_iter, "h", &_fd_index);
	input_stream = (GUnixInputStream *) g_unix_input_stream_new (g_unix_fd_list_get (g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)), _fd_index, NULL), TRUE);
	tracker_steroids_batch_update (self, g_dbus_method_invocation_get_sender (invocation), input_stream, (GAsyncReadyCallback) _dbus_tracker_steroids_batch_update_ready, invocation);
	_g_object_unref0 (input_stream);
}


static void _dbus_tracker_steroids_batch_update_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GUnixFDList *_fd_list;
	invocation = _user_data_;
	tracker_steroids_batch_update_finish ((TrackerSteroids*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_fd_list = g_unix_fd_list_new ();
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_message_set_unix_fd_list (_reply_message, _fd_list);
	g_object_unref (_fd_list);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_steroids_update_blank (TrackerSteroids* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gint _fd_index = 0;
	GUnixInputStream* input_stream = NULL;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_variant_iter_next (&_arguments_iter, "h", &_fd_index);
	input_stream = (GUnixInputStream *) g_unix_input_stream_new (g_unix_fd_list_get (g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)), _fd_index, NULL), TRUE);
	tracker_steroids_update_blank (self, g_dbus_method_invocation_get_sender (invocation), input_stream, (GAsyncReadyCallback) _dbus_tracker_steroids_update_blank_ready, invocation);
	_g_object_unref0 (input_stream);
}


static void _dbus_tracker_steroids_update_blank_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GUnixFDList *_fd_list;
	GVariant* result;
	invocation = _user_data_;
	result = tracker_steroids_update_blank_finish ((TrackerSteroids*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_fd_list = g_unix_fd_list_new ();
	g_variant_builder_add_value (&_reply_builder, result);
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_message_set_unix_fd_list (_reply_message, _fd_list);
	g_object_unref (_fd_list);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_steroids_batch_update_blank (TrackerSteroids* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gint _fd_index = 0;
	GUnixInputStream* input_stream = NULL;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_variant_iter_next (&_arguments_iter, "h", &_fd_index);
	input_stream = (GUnixInputStream *) g_unix_input_stream_new (g_unix_fd_list_get (g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)), _fd_index, NULL), TRUE);
	tracker_steroids_batch_update_blank (self, g_dbus_method_invocation_get_sender (invocation), input_stream, (GAsyncReadyCallback) _dbus_tracker_steroids_batch_update_blank_ready, invocation);
	_g_object_unref0 (input_stream);
}


static void _dbus_tracker_steroids_batch_update_blank_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GUnixFDList *_fd_list;
	GVariant* result;
	invocation = _user_data_;
	result = tracker_steroids_batch_update_blank_finish ((TrackerSteroids*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_fd_list = g_unix_fd_list_new ();
	g_variant_builder_add_value (&_reply_builder, result);
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_message_set_unix_fd_list (_reply_message, _fd_list);
	g_object_unref (_fd_list);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_steroids_update_array (TrackerSteroids* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gint _fd_index = 0;
	GUnixInputStream* input_stream = NULL;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_variant_iter_next (&_arguments_iter, "h", &_fd_index);
	input_stream = (GUnixInputStream *) g_unix_input_stream_new (g_unix_fd_list_get (g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)), _fd_index, NULL), TRUE);
	tracker_steroids_update_array (self, g_dbus_method_invocation_get_sender (invocation), input_stream, (GAsyncReadyCallback) _dbus_tracker_steroids_update_array_ready, invocation);
	_g_object_unref0 (input_stream);
}


static void _dbus_tracker_steroids_update_array_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GUnixFDList *_fd_list;
	GVariant* result;
	invocation = _user_data_;
	result = tracker_steroids_update_array_finish ((TrackerSteroids*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_fd_list = g_unix_fd_list_new ();
	g_variant_builder_add_value (&_reply_builder, result);
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_message_set_unix_fd_list (_reply_message, _fd_list);
	g_object_unref (_fd_list);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void tracker_steroids_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Query") == 0) {
		_dbus_tracker_steroids_query (object, parameters, invocation);
	} else if (strcmp (method_name, "Update") == 0) {
		_dbus_tracker_steroids_update (object, parameters, invocation);
	} else if (strcmp (method_name, "BatchUpdate") == 0) {
		_dbus_tracker_steroids_batch_update (object, parameters, invocation);
	} else if (strcmp (method_name, "UpdateBlank") == 0) {
		_dbus_tracker_steroids_update_blank (object, parameters, invocation);
	} else if (strcmp (method_name, "BatchUpdateBlank") == 0) {
		_dbus_tracker_steroids_batch_update_blank (object, parameters, invocation);
	} else if (strcmp (method_name, "UpdateArray") == 0) {
		_dbus_tracker_steroids_update_array (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* tracker_steroids_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean tracker_steroids_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint tracker_steroids_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_tracker_steroids_dbus_interface_info), &_tracker_steroids_dbus_interface_vtable, data, _tracker_steroids_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _tracker_steroids_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



