/* tracker-stats.c generated by valac 0.11.2.75-1d35, the Vala compiler
 * generated from tracker-stats.vala, do not modify */

/**/
/* Copyright 2010, Martyn Russell <martyn@lanedo.com>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>


#define TYPE_STATISTICS (statistics_get_type ())
#define STATISTICS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATISTICS, Statistics))
#define IS_STATISTICS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATISTICS))
#define STATISTICS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_STATISTICS, StatisticsIface))

typedef struct _Statistics Statistics;
typedef struct _StatisticsIface StatisticsIface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
typedef struct _StatisticsDBusProxy StatisticsDBusProxy;
typedef DBusGProxyClass StatisticsDBusProxyClass;

#define TRACKER_TYPE_STATS (tracker_stats_get_type ())
#define TRACKER_STATS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STATS, TrackerStats))
#define TRACKER_STATS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STATS, TrackerStatsClass))
#define TRACKER_IS_STATS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STATS))
#define TRACKER_IS_STATS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STATS))
#define TRACKER_STATS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STATS, TrackerStatsClass))

typedef struct _TrackerStats TrackerStats;
typedef struct _TrackerStatsClass TrackerStatsClass;
typedef struct _TrackerStatsPrivate TrackerStatsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _StatisticsIface {
	GTypeInterface parent_iface;
	gchar** (*Get) (Statistics* self, int* result_length1, int* result_length2, GError** error);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _StatisticsDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _TrackerStats {
	GtkDialog parent_instance;
	TrackerStatsPrivate * priv;
};

struct _TrackerStatsClass {
	GtkDialogClass parent_class;
};

struct _TrackerStatsPrivate {
	Statistics* tracker;
};


static gpointer tracker_stats_parent_class = NULL;

#define b APPNAME
Statistics* statistics_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType statistics_get_type (void) G_GNUC_CONST;
gchar** statistics_Get (Statistics* self, int* result_length1, int* result_length2, GError** error);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void statistics_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _statistics_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult statistics_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_statistics_introspect (Statistics* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_statistics_property_get_all (Statistics* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_statistics_Get (Statistics* self, DBusConnection* connection, DBusMessage* message);
GType statistics_dbus_proxy_get_type (void) G_GNUC_CONST;
DBusHandlerResult statistics_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	STATISTICS_DBUS_PROXY_DUMMY_PROPERTY
};
static gchar** statistics_dbus_proxy_Get (Statistics* self, int* result_length1, int* result_length2, GError** error);
static void statistics_dbus_proxy_statistics__interface_init (StatisticsIface* iface);
static void _vala_statistics_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_statistics_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType tracker_stats_get_type (void) G_GNUC_CONST;
#define TRACKER_STATS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_STATS, TrackerStatsPrivate))
enum  {
	TRACKER_STATS_DUMMY_PROPERTY
};
TrackerStats* tracker_stats_new (void);
TrackerStats* tracker_stats_construct (GType object_type);
static void tracker_stats_setup_dbus (TrackerStats* self);
static void tracker_stats_setup_ui (TrackerStats* self);
static void tracker_stats_on_response (TrackerStats* self, GtkDialog* source, gint response_id);
static void _tracker_stats_on_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void tracker_stats_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const DBusObjectPathVTable _statistics_dbus_path_vtable = {_statistics_dbus_unregister, statistics_dbus_message};
static const _DBusObjectVTable _statistics_dbus_vtable = {statistics_dbus_register_object};

gchar** statistics_Get (Statistics* self, int* result_length1, int* result_length2, GError** error) {
	return STATISTICS_GET_INTERFACE (self)->Get (self, result_length1, result_length2, error);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _statistics_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_statistics_introspect (Statistics* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.Tracker1.Statistics\">\n  <method name=\"Get\">\n    <arg name=\"result\" type=\"aas\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_statistics_property_get_all (Statistics* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.freedesktop.Tracker1.Statistics") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_statistics_Get (Statistics* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	gchar** result;
	int result_length1;
	int result_length2;
	DBusMessage* reply;
	gchar** _tmp1_;
	DBusMessageIter _tmp2_;
	int _tmp3_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result_length2 = 0;
	result = statistics_Get (self, &result_length1, &result_length2, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp1_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "as", &_tmp2_);
	for (_tmp3_ = 0; _tmp3_ < result_length1; _tmp3_++) {
		DBusMessageIter _tmp4_;
		int _tmp5_;
		dbus_message_iter_open_container (&_tmp2_, DBUS_TYPE_ARRAY, "s", &_tmp4_);
		for (_tmp5_ = 0; _tmp5_ < result_length2; _tmp5_++) {
			const char* _tmp6_;
			_tmp6_ = *_tmp1_;
			dbus_message_iter_append_basic (&_tmp4_, DBUS_TYPE_STRING, &_tmp6_);
			_tmp1_++;
		}
		dbus_message_iter_close_container (&_tmp2_, &_tmp4_);
	}
	dbus_message_iter_close_container (&iter, &_tmp2_);
	result = (_vala_array_free (result,  result_length1 *  result_length2, (GDestroyNotify) g_free), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult statistics_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_statistics_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_statistics_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Statistics", "Get")) {
		result = _dbus_statistics_Get (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void statistics_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_statistics_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void statistics_base_init (StatisticsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (TYPE_STATISTICS, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_statistics_dbus_vtable));
	}
}


GType statistics_get_type (void) {
	static volatile gsize statistics_type_id__volatile = 0;
	if (g_once_init_enter (&statistics_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StatisticsIface), (GBaseInitFunc) statistics_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType statistics_type_id;
		statistics_type_id = g_type_register_static (G_TYPE_INTERFACE, "Statistics", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (statistics_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (statistics_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &statistics_dbus_proxy_get_type);
		g_once_init_leave (&statistics_type_id__volatile, statistics_type_id);
	}
	return statistics_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (StatisticsDBusProxy, statistics_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_STATISTICS, statistics_dbus_proxy_statistics__interface_init) );
Statistics* statistics_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	Statistics* self;
	self = g_object_new (statistics_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.Tracker1.Statistics", NULL);
	return self;
}


static GObject* statistics_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (statistics_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), statistics_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult statistics_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void statistics_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((StatisticsDBusProxy*) self)->disposed) {
		return;
	}
	((StatisticsDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), statistics_dbus_proxy_filter, self);
	G_OBJECT_CLASS (statistics_dbus_proxy_parent_class)->dispose (self);
}


static void statistics_dbus_proxy_class_init (StatisticsDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = statistics_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = statistics_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_statistics_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_statistics_dbus_proxy_set_property;
}


static void statistics_dbus_proxy_init (StatisticsDBusProxy* self) {
}


static gchar** statistics_dbus_proxy_Get (Statistics* self, int* result_length1, int* result_length2, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	gchar** _result;
	int _result_length1;
	int _result_length2;
	gchar** _tmp0_;
	int _tmp0__length;
	int _tmp0__size;
	int _tmp0__length1;
	DBusMessageIter _tmp1_;
	if (((StatisticsDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Statistics", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp4_;
			_edomain = DBUS_GERROR;
			_tmp4_ = _dbus_error.name + 27;
			if (strcmp (_tmp4_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp4_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp4_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp4_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp4_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp4_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp4_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp4_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp4_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp4_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp4_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp4_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp4_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp4_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp4_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp4_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp4_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp4_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp4_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp4_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp4_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp4_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp4_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp4_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp4_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp4_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp4_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp4_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp4_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp4_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp4_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp4_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp4_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "aas")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "aas", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp0_ = g_new (gchar*, 5);
	_tmp0__length = 0;
	_tmp0__size = 4;
	_tmp0__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp1_);
	for (; dbus_message_iter_get_arg_type (&_tmp1_); _tmp0__length1++) {
		int _tmp0__length2;
		DBusMessageIter _tmp2_;
		_tmp0__length2 = 0;
		dbus_message_iter_recurse (&_tmp1_, &_tmp2_);
		for (; dbus_message_iter_get_arg_type (&_tmp2_); _tmp0__length2++) {
			const char* _tmp3_;
			if (_tmp0__size == _tmp0__length) {
				_tmp0__size = 2 * _tmp0__size;
				_tmp0_ = g_renew (gchar*, _tmp0_, _tmp0__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp2_, &_tmp3_);
			dbus_message_iter_next (&_tmp2_);
			_tmp0_[_tmp0__length++] = g_strdup (_tmp3_);
		}
		_result_length2 = _tmp0__length2;
		dbus_message_iter_next (&_tmp1_);
	}
	_result_length1 = _tmp0__length1;
	_tmp0_[_tmp0__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp0_;
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	dbus_message_unref (_reply);
	return _result;
}


static void statistics_dbus_proxy_statistics__interface_init (StatisticsIface* iface) {
	iface->Get = statistics_dbus_proxy_Get;
}


static void _vala_statistics_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void _vala_statistics_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


TrackerStats* tracker_stats_construct (GType object_type) {
	TrackerStats * self = NULL;
	self = (TrackerStats*) g_object_new (object_type, NULL);
	gtk_window_set_title ((GtkWindow*) self, "Statistics");
	gtk_dialog_set_has_separator ((GtkDialog*) self, FALSE);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 12);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	tracker_stats_setup_dbus (self);
	tracker_stats_setup_ui (self);
	return self;
}


TrackerStats* tracker_stats_new (void) {
	return tracker_stats_construct (TRACKER_TYPE_STATS);
}


static void tracker_stats_setup_dbus (TrackerStats* self) {
	DBusGConnection* _tmp0_ = NULL;
	DBusGConnection* conn;
	DBusGProxy* _tmp1_ = NULL;
	Statistics* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_debug ("tracker-stats.vala:44: Setting up statistics D-Bus connection");
	_tmp0_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
	conn = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			goto __catch5_dbus_gerror;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp1_ = dbus_g_proxy_new_for_name (conn, "org.freedesktop.Tracker1", "/org/freedesktop/Tracker1/Statistics", "org.freedesktop.Tracker1.Statistics");
	_tmp2_ = statistics_dbus_proxy_new (conn, "org.freedesktop.Tracker1", "/org/freedesktop/Tracker1/Statistics");
	_g_object_unref0 (self->priv->tracker);
	self->priv->tracker = _tmp2_;
	_dbus_g_connection_unref0 (conn);
	goto __finally5;
	__catch5_dbus_gerror:
	{
		GError * e;
		GtkMessageDialog* _tmp3_ = NULL;
		GtkMessageDialog* msg;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CANCEL, "Error connecting to D-Bus session bus, %s", e->message);
		msg = g_object_ref_sink (_tmp3_);
		gtk_dialog_run ((GtkDialog*) msg);
		gtk_main_quit ();
		_g_object_unref0 (msg);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _tracker_stats_on_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	tracker_stats_on_response (self, _sender, response_id);
}


static void tracker_stats_setup_ui (TrackerStats* self) {
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* label;
	GtkSizeGroup* _tmp1_ = NULL;
	GtkSizeGroup* sizegroup;
	gint _tmp2_;
	gint _tmp3_;
	gchar** _tmp4_ = NULL;
	gint _result__length1;
	gint _result__length2;
	gchar** _tmp5_;
	gchar** _result_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_debug ("tracker-stats.vala:64: Setting up statistics UI");
	gtk_box_set_spacing ((GtkBox*) ((GtkDialog*) self)->vbox, 18);
	gtk_container_set_border_width ((GtkContainer*) ((GtkDialog*) self)->vbox, (guint) 0);
	_tmp0_ = (GtkLabel*) gtk_label_new ("The statistics represented here do not reflect their availability, rat" \
"her the total data stored:");
	label = g_object_ref_sink (_tmp0_);
	gtk_label_set_line_wrap (label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
	gtk_box_pack_start ((GtkBox*) ((GtkDialog*) self)->vbox, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
	_tmp1_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	sizegroup = _tmp1_;
	_tmp4_ = statistics_Get (self->priv->tracker, &_tmp2_, &_tmp3_, &_inner_error_);
	_tmp5_ = _tmp4_;
	_result__length1 = _tmp2_;
	_result__length2 = _tmp3_;
	_result_ = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			goto __catch6_dbus_gerror;
		}
		_g_object_unref0 (sizegroup);
		_g_object_unref0 (label);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				gchar* _tmp7_;
				gchar* key;
				gchar* _tmp8_;
				gchar* val;
				gchar* key_used;
				const gchar* _tmp9_;
				GQuark _tmp10_;
				static GQuark _tmp10__label0 = 0;
				static GQuark _tmp10__label1 = 0;
				static GQuark _tmp10__label2 = 0;
				static GQuark _tmp10__label3 = 0;
				static GQuark _tmp10__label4 = 0;
				static GQuark _tmp10__label5 = 0;
				static GQuark _tmp10__label6 = 0;
				static GQuark _tmp10__label7 = 0;
				static GQuark _tmp10__label8 = 0;
				static GQuark _tmp10__label9 = 0;
				static GQuark _tmp10__label10 = 0;
				static GQuark _tmp10__label11 = 0;
				static GQuark _tmp10__label12 = 0;
				static GQuark _tmp10__label13 = 0;
				GtkHBox* _tmp67_ = NULL;
				GtkHBox* hbox;
				GtkLabel* _tmp68_ = NULL;
				GtkLabel* label_key;
				GtkLabel* _tmp69_ = NULL;
				GtkLabel* label_val;
				if (!_tmp6_) {
					i++;
				}
				_tmp6_ = FALSE;
				if (!(i < _result__length1)) {
					break;
				}
				_tmp7_ = g_strdup (_result_[(i * _result__length2) + 0]);
				key = _tmp7_;
				_tmp8_ = g_strdup (_result_[(i * _result__length2) + 1]);
				val = _tmp8_;
				key_used = NULL;
				g_debug ("tracker-stats.vala:87: --> %s = %s", key, val);
				_tmp9_ = key;
				_tmp10_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
				if (_tmp10_ == ((0 != _tmp10__label0) ? _tmp10__label0 : (_tmp10__label0 = g_quark_from_static_string ("nao:Tag")))) {
					switch (0) {
						default:
						{
							gint _tmp11_;
							const gchar* _tmp12_ = NULL;
							gchar* _tmp13_;
							gchar* _tmp14_;
							_tmp11_ = atoi (val);
							_tmp12_ = ngettext ("Tag", "Tags", (gulong) _tmp11_);
							_tmp13_ = g_strdup (_tmp12_);
							_tmp14_ = _tmp13_;
							_g_free0 (key_used);
							key_used = _tmp14_;
							break;
						}
					}
				} else if (_tmp10_ == ((0 != _tmp10__label1) ? _tmp10__label1 : (_tmp10__label1 = g_quark_from_static_string ("nco:Contact")))) {
					switch (0) {
						default:
						{
							gint _tmp15_;
							const gchar* _tmp16_ = NULL;
							gchar* _tmp17_;
							gchar* _tmp18_;
							_tmp15_ = atoi (val);
							_tmp16_ = ngettext ("Contact", "Contacts", (gulong) _tmp15_);
							_tmp17_ = g_strdup (_tmp16_);
							_tmp18_ = _tmp17_;
							_g_free0 (key_used);
							key_used = _tmp18_;
							break;
						}
					}
				} else if (_tmp10_ == ((0 != _tmp10__label2) ? _tmp10__label2 : (_tmp10__label2 = g_quark_from_static_string ("nfo:Audio")))) {
					switch (0) {
						default:
						{
							gint _tmp19_;
							const gchar* _tmp20_ = NULL;
							gchar* _tmp21_;
							gchar* _tmp22_;
							_tmp19_ = atoi (val);
							_tmp20_ = ngettext ("Audio", "Audios", (gulong) _tmp19_);
							_tmp21_ = g_strdup (_tmp20_);
							_tmp22_ = _tmp21_;
							_g_free0 (key_used);
							key_used = _tmp22_;
							break;
						}
					}
				} else if (_tmp10_ == ((0 != _tmp10__label3) ? _tmp10__label3 : (_tmp10__label3 = g_quark_from_static_string ("nfo:Document")))) {
					switch (0) {
						default:
						{
							gint _tmp23_;
							const gchar* _tmp24_ = NULL;
							gchar* _tmp25_;
							gchar* _tmp26_;
							_tmp23_ = atoi (val);
							_tmp24_ = ngettext ("Document", "Documents", (gulong) _tmp23_);
							_tmp25_ = g_strdup (_tmp24_);
							_tmp26_ = _tmp25_;
							_g_free0 (key_used);
							key_used = _tmp26_;
							break;
						}
					}
				} else if (_tmp10_ == ((0 != _tmp10__label4) ? _tmp10__label4 : (_tmp10__label4 = g_quark_from_static_string ("nfo:FileDataObject")))) {
					switch (0) {
						default:
						{
							gint _tmp27_;
							const gchar* _tmp28_ = NULL;
							gchar* _tmp29_;
							gchar* _tmp30_;
							_tmp27_ = atoi (val);
							_tmp28_ = ngettext ("File", "Files", (gulong) _tmp27_);
							_tmp29_ = g_strdup (_tmp28_);
							_tmp30_ = _tmp29_;
							_g_free0 (key_used);
							key_used = _tmp30_;
							break;
						}
					}
				} else if (_tmp10_ == ((0 != _tmp10__label5) ? _tmp10__label5 : (_tmp10__label5 = g_quark_from_static_string ("nfo:Folder")))) {
					switch (0) {
						default:
						{
							gint _tmp31_;
							const gchar* _tmp32_ = NULL;
							gchar* _tmp33_;
							gchar* _tmp34_;
							_tmp31_ = atoi (val);
							_tmp32_ = ngettext ("Folder", "Folders", (gulong) _tmp31_);
							_tmp33_ = g_strdup (_tmp32_);
							_tmp34_ = _tmp33_;
							_g_free0 (key_used);
							key_used = _tmp34_;
							break;
						}
					}
				} else if (_tmp10_ == ((0 != _tmp10__label6) ? _tmp10__label6 : (_tmp10__label6 = g_quark_from_static_string ("nfo:Image")))) {
					switch (0) {
						default:
						{
							gint _tmp35_;
							const gchar* _tmp36_ = NULL;
							gchar* _tmp37_;
							gchar* _tmp38_;
							_tmp35_ = atoi (val);
							_tmp36_ = ngettext ("Image", "Images", (gulong) _tmp35_);
							_tmp37_ = g_strdup (_tmp36_);
							_tmp38_ = _tmp37_;
							_g_free0 (key_used);
							key_used = _tmp38_;
							break;
						}
					}
				} else if (_tmp10_ == ((0 != _tmp10__label7) ? _tmp10__label7 : (_tmp10__label7 = g_quark_from_static_string ("nfo:SoftwareApplication")))) {
					switch (0) {
						default:
						{
							gint _tmp39_;
							const gchar* _tmp40_ = NULL;
							gchar* _tmp41_;
							gchar* _tmp42_;
							_tmp39_ = atoi (val);
							_tmp40_ = ngettext ("Application", "Applications", (gulong) _tmp39_);
							_tmp41_ = g_strdup (_tmp40_);
							_tmp42_ = _tmp41_;
							_g_free0 (key_used);
							key_used = _tmp42_;
							break;
						}
					}
				} else if (_tmp10_ == ((0 != _tmp10__label8) ? _tmp10__label8 : (_tmp10__label8 = g_quark_from_static_string ("nfo:Video")))) {
					switch (0) {
						default:
						{
							gint _tmp43_;
							const gchar* _tmp44_ = NULL;
							gchar* _tmp45_;
							gchar* _tmp46_;
							_tmp43_ = atoi (val);
							_tmp44_ = ngettext ("Video", "Videos", (gulong) _tmp43_);
							_tmp45_ = g_strdup (_tmp44_);
							_tmp46_ = _tmp45_;
							_g_free0 (key_used);
							key_used = _tmp46_;
							break;
						}
					}
				} else if (_tmp10_ == ((0 != _tmp10__label9) ? _tmp10__label9 : (_tmp10__label9 = g_quark_from_static_string ("nmm:MusicAlbum")))) {
					switch (0) {
						default:
						{
							gint _tmp47_;
							const gchar* _tmp48_ = NULL;
							gchar* _tmp49_;
							gchar* _tmp50_;
							_tmp47_ = atoi (val);
							_tmp48_ = ngettext ("Album", "Albums", (gulong) _tmp47_);
							_tmp49_ = g_strdup (_tmp48_);
							_tmp50_ = _tmp49_;
							_g_free0 (key_used);
							key_used = _tmp50_;
							break;
						}
					}
				} else if (_tmp10_ == ((0 != _tmp10__label10) ? _tmp10__label10 : (_tmp10__label10 = g_quark_from_static_string ("nmm:MusicPiece")))) {
					switch (0) {
						default:
						{
							gint _tmp51_;
							const gchar* _tmp52_ = NULL;
							gchar* _tmp53_;
							gchar* _tmp54_;
							_tmp51_ = atoi (val);
							_tmp52_ = ngettext ("Music Track", "Music Tracks", (gulong) _tmp51_);
							_tmp53_ = g_strdup (_tmp52_);
							_tmp54_ = _tmp53_;
							_g_free0 (key_used);
							key_used = _tmp54_;
							break;
						}
					}
				} else if (_tmp10_ == ((0 != _tmp10__label11) ? _tmp10__label11 : (_tmp10__label11 = g_quark_from_static_string ("nmm:Photo")))) {
					switch (0) {
						default:
						{
							gint _tmp55_;
							const gchar* _tmp56_ = NULL;
							gchar* _tmp57_;
							gchar* _tmp58_;
							_tmp55_ = atoi (val);
							_tmp56_ = ngettext ("Photo", "Photos", (gulong) _tmp55_);
							_tmp57_ = g_strdup (_tmp56_);
							_tmp58_ = _tmp57_;
							_g_free0 (key_used);
							key_used = _tmp58_;
							break;
						}
					}
				} else if (_tmp10_ == ((0 != _tmp10__label12) ? _tmp10__label12 : (_tmp10__label12 = g_quark_from_static_string ("nmm:Playlist")))) {
					switch (0) {
						default:
						{
							gint _tmp59_;
							const gchar* _tmp60_ = NULL;
							gchar* _tmp61_;
							gchar* _tmp62_;
							_tmp59_ = atoi (val);
							_tmp60_ = ngettext ("Playlist", "Playlists", (gulong) _tmp59_);
							_tmp61_ = g_strdup (_tmp60_);
							_tmp62_ = _tmp61_;
							_g_free0 (key_used);
							key_used = _tmp62_;
							break;
						}
					}
				} else if (_tmp10_ == ((0 != _tmp10__label13) ? _tmp10__label13 : (_tmp10__label13 = g_quark_from_static_string ("nmo:Email")))) {
					switch (0) {
						default:
						{
							gint _tmp63_;
							const gchar* _tmp64_ = NULL;
							gchar* _tmp65_;
							gchar* _tmp66_;
							_tmp63_ = atoi (val);
							_tmp64_ = ngettext ("Email", "Emails", (gulong) _tmp63_);
							_tmp65_ = g_strdup (_tmp64_);
							_tmp66_ = _tmp65_;
							_g_free0 (key_used);
							key_used = _tmp66_;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							continue;
						}
					}
				}
				_tmp67_ = (GtkHBox*) gtk_hbox_new (FALSE, 12);
				hbox = g_object_ref_sink (_tmp67_);
				_tmp68_ = (GtkLabel*) gtk_label_new (key_used);
				label_key = g_object_ref_sink (_tmp68_);
				_tmp69_ = (GtkLabel*) gtk_label_new (val);
				label_val = g_object_ref_sink (_tmp69_);
				gtk_misc_set_alignment ((GtkMisc*) label_key, 0.0f, 0.5f);
				gtk_misc_set_alignment ((GtkMisc*) label_val, 0.0f, 0.5f);
				gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label_key, TRUE, TRUE, (guint) 0);
				gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label_val, FALSE, TRUE, (guint) 0);
				gtk_size_group_add_widget (sizegroup, (GtkWidget*) label_key);
				gtk_box_pack_start ((GtkBox*) ((GtkDialog*) self)->vbox, (GtkWidget*) hbox, TRUE, TRUE, (guint) 0);
				_g_object_unref0 (label_val);
				_g_object_unref0 (label_key);
				_g_object_unref0 (hbox);
				_g_free0 (key_used);
				_g_free0 (val);
				_g_free0 (key);
			}
		}
	}
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	goto __finally6;
	__catch6_dbus_gerror:
	{
		GError * e;
		gchar* _tmp70_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp70_ = g_strconcat ("Could not get Tracker statistics: ", e->message, NULL);
		g_warning ("tracker-stats.vala:152: %s", _tmp70_);
		_g_free0 (_tmp70_);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (sizegroup);
		_g_object_unref0 (label);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	gtk_box_set_spacing ((GtkBox*) ((GtkDialog*) self)->vbox, 10);
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_CLOSE, (gint) GTK_RESPONSE_CLOSE);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) _tracker_stats_on_response_gtk_dialog_response, self, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (sizegroup);
	_g_object_unref0 (label);
}


static void tracker_stats_on_response (TrackerStats* self, GtkDialog* source, gint response_id) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	switch (response_id) {
		case GTK_RESPONSE_CLOSE:
		{
			gtk_object_destroy ((GtkObject*) self);
			break;
		}
	}
}


static void tracker_stats_class_init (TrackerStatsClass * klass) {
	tracker_stats_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerStatsPrivate));
	G_OBJECT_CLASS (klass)->finalize = tracker_stats_finalize;
}


static void tracker_stats_instance_init (TrackerStats * self) {
	self->priv = TRACKER_STATS_GET_PRIVATE (self);
}


static void tracker_stats_finalize (GObject* obj) {
	TrackerStats * self;
	self = TRACKER_STATS (obj);
	_g_object_unref0 (self->priv->tracker);
	G_OBJECT_CLASS (tracker_stats_parent_class)->finalize (obj);
}


GType tracker_stats_get_type (void) {
	static volatile gsize tracker_stats_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_stats_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStatsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_stats_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStats), 0, (GInstanceInitFunc) tracker_stats_instance_init, NULL };
		GType tracker_stats_type_id;
		tracker_stats_type_id = g_type_register_static (GTK_TYPE_DIALOG, "TrackerStats", &g_define_type_info, 0);
		g_once_init_leave (&tracker_stats_type_id__volatile, tracker_stats_type_id);
	}
	return tracker_stats_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



