/* tracker-plugin-loader.c generated by valac 0.9.5.4-19a5, the Vala compiler
 * generated from tracker-plugin-loader.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gmodule.h>


#define TRACKER_SPARQL_TYPE_CONNECTION (tracker_sparql_connection_get_type ())
#define TRACKER_SPARQL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnection))
#define TRACKER_SPARQL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnectionClass))
#define TRACKER_SPARQL_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONNECTION))
#define TRACKER_SPARQL_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONNECTION))
#define TRACKER_SPARQL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnectionClass))

typedef struct _TrackerSparqlConnection TrackerSparqlConnection;
typedef struct _TrackerSparqlConnectionClass TrackerSparqlConnectionClass;
typedef struct _TrackerSparqlConnectionPrivate TrackerSparqlConnectionPrivate;

#define TRACKER_SPARQL_TYPE_CURSOR (tracker_sparql_cursor_get_type ())
#define TRACKER_SPARQL_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursor))
#define TRACKER_SPARQL_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursorClass))
#define TRACKER_SPARQL_IS_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CURSOR))
#define TRACKER_SPARQL_IS_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CURSOR))
#define TRACKER_SPARQL_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursorClass))

typedef struct _TrackerSparqlCursor TrackerSparqlCursor;
typedef struct _TrackerSparqlCursorClass TrackerSparqlCursorClass;

#define TRACKER_SPARQL_TYPE_PLUGIN_LOADER (tracker_sparql_plugin_loader_get_type ())
#define TRACKER_SPARQL_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PLUGIN_LOADER, TrackerSparqlPluginLoader))
#define TRACKER_SPARQL_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PLUGIN_LOADER, TrackerSparqlPluginLoaderClass))
#define TRACKER_SPARQL_IS_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PLUGIN_LOADER))
#define TRACKER_SPARQL_IS_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PLUGIN_LOADER))
#define TRACKER_SPARQL_PLUGIN_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PLUGIN_LOADER, TrackerSparqlPluginLoaderClass))

typedef struct _TrackerSparqlPluginLoader TrackerSparqlPluginLoader;
typedef struct _TrackerSparqlPluginLoaderClass TrackerSparqlPluginLoaderClass;
typedef struct _TrackerSparqlPluginLoaderPrivate TrackerSparqlPluginLoaderPrivate;

#define TRACKER_SPARQL_PLUGIN_LOADER_TYPE_BACKEND (tracker_sparql_plugin_loader_backend_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerSparqlPluginLoaderQueryAsyncData TrackerSparqlPluginLoaderQueryAsyncData;
typedef struct _TrackerSparqlPluginLoaderUpdateAsyncData TrackerSparqlPluginLoaderUpdateAsyncData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _TrackerSparqlPluginLoaderUpdateBlankAsyncData TrackerSparqlPluginLoaderUpdateBlankAsyncData;
typedef struct _TrackerSparqlPluginLoaderLoadAsyncData TrackerSparqlPluginLoaderLoadAsyncData;
typedef struct _TrackerSparqlPluginLoaderStatisticsAsyncData TrackerSparqlPluginLoaderStatisticsAsyncData;
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))

typedef enum  {
	TRACKER_SPARQL_ERROR_PARSE,
	TRACKER_SPARQL_ERROR_UNKNOWN_CLASS,
	TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY,
	TRACKER_SPARQL_ERROR_TYPE,
	TRACKER_SPARQL_ERROR_CONSTRAINT,
	TRACKER_SPARQL_ERROR_NO_SPACE,
	TRACKER_SPARQL_ERROR_INTERNAL,
	TRACKER_SPARQL_ERROR_UNSUPPORTED
} TrackerSparqlError;
#define TRACKER_SPARQL_ERROR tracker_sparql_error_quark ()
struct _TrackerSparqlConnection {
	GObject parent_instance;
	TrackerSparqlConnectionPrivate * priv;
};

struct _TrackerSparqlConnectionClass {
	GObjectClass parent_class;
	TrackerSparqlCursor* (*query) (TrackerSparqlConnection* self, const char* sparql, GCancellable* cancellable, GError** error);
	void (*query_async) (TrackerSparqlConnection* self, const char* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	TrackerSparqlCursor* (*query_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	void (*update) (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GError** error);
	void (*update_async) (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*update_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	GVariant* (*update_blank) (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GError** error);
	void (*update_blank_async) (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GVariant* (*update_blank_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	void (*load) (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GError** error);
	void (*load_async) (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*load_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	TrackerSparqlCursor* (*statistics) (TrackerSparqlConnection* self, GCancellable* cancellable, GError** error);
	void (*statistics_async) (TrackerSparqlConnection* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	TrackerSparqlCursor* (*statistics_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
};

struct _TrackerSparqlPluginLoader {
	TrackerSparqlConnection parent_instance;
	TrackerSparqlPluginLoaderPrivate * priv;
};

struct _TrackerSparqlPluginLoaderClass {
	TrackerSparqlConnectionClass parent_class;
};

typedef enum  {
	TRACKER_SPARQL_PLUGIN_LOADER_BACKEND_AUTO,
	TRACKER_SPARQL_PLUGIN_LOADER_BACKEND_DIRECT,
	TRACKER_SPARQL_PLUGIN_LOADER_BACKEND_BUS
} TrackerSparqlPluginLoaderBackend;

struct _TrackerSparqlPluginLoaderQueryAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlPluginLoader* self;
	char* sparql;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlCursor* _tmp0_;
	TrackerSparqlCursor* _tmp1_;
	GError * _inner_error_;
};

struct _TrackerSparqlPluginLoaderUpdateAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlPluginLoader* self;
	char* sparql;
	gint priority;
	GCancellable* cancellable;
	GError * _inner_error_;
};

struct _TrackerSparqlPluginLoaderUpdateBlankAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlPluginLoader* self;
	char* sparql;
	gint priority;
	GCancellable* cancellable;
	GVariant* result;
	GVariant* _tmp0_;
	GError * _inner_error_;
};

struct _TrackerSparqlPluginLoaderLoadAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlPluginLoader* self;
	GFile* file;
	GCancellable* cancellable;
	char* uri;
	GError * _inner_error_;
};

struct _TrackerSparqlPluginLoaderStatisticsAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlPluginLoader* self;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlCursor* _tmp0_;
	GError * _inner_error_;
};

typedef TrackerSparqlConnection* (*TrackerSparqlPluginLoaderModuleInitFunc) (void* user_data);

static gboolean tracker_sparql_plugin_loader_initialized;
static gboolean tracker_sparql_plugin_loader_initialized = FALSE;
static TrackerSparqlConnection* tracker_sparql_plugin_loader_direct;
static TrackerSparqlConnection* tracker_sparql_plugin_loader_direct = NULL;
static TrackerSparqlConnection* tracker_sparql_plugin_loader_bus;
static TrackerSparqlConnection* tracker_sparql_plugin_loader_bus = NULL;
static gpointer tracker_sparql_plugin_loader_parent_class = NULL;

GType tracker_sparql_connection_get_type (void) G_GNUC_CONST;
GType tracker_sparql_cursor_get_type (void) G_GNUC_CONST;
GQuark tracker_sparql_error_quark (void);
GType tracker_sparql_plugin_loader_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_PLUGIN_LOADER_DUMMY_PROPERTY
};
static GType tracker_sparql_plugin_loader_backend_get_type (void) G_GNUC_UNUSED;
TrackerSparqlConnection* tracker_sparql_connection_construct (GType object_type);
static gboolean tracker_sparql_plugin_loader_load_plugins (TrackerSparqlPluginLoader* self, gboolean direct_only, GError** error);
TrackerSparqlPluginLoader* tracker_sparql_plugin_loader_new (gboolean direct_only, GError** error);
TrackerSparqlPluginLoader* tracker_sparql_plugin_loader_construct (GType object_type, gboolean direct_only, GError** error);
TrackerSparqlCursor* tracker_sparql_connection_query (TrackerSparqlConnection* self, const char* sparql, GCancellable* cancellable, GError** error);
static TrackerSparqlCursor* tracker_sparql_plugin_loader_real_query (TrackerSparqlConnection* base, const char* sparql, GCancellable* cancellable, GError** error);
static void tracker_sparql_plugin_loader_real_query_async_data_free (gpointer _data);
static void tracker_sparql_plugin_loader_real_query_async (TrackerSparqlConnection* base, const char* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_sparql_plugin_loader_query_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tracker_sparql_connection_query_async (TrackerSparqlConnection* self, const char* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlCursor* tracker_sparql_connection_query_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_plugin_loader_real_query_async_co (TrackerSparqlPluginLoaderQueryAsyncData* data);
void tracker_sparql_connection_update (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_sparql_plugin_loader_real_update (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GError** error);
GVariant* tracker_sparql_connection_update_blank (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GError** error);
static GVariant* tracker_sparql_plugin_loader_real_update_blank (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_sparql_plugin_loader_real_update_async_data_free (gpointer _data);
static void tracker_sparql_plugin_loader_real_update_async (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_sparql_plugin_loader_update_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tracker_sparql_connection_update_async (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_sparql_connection_update_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_plugin_loader_real_update_async_co (TrackerSparqlPluginLoaderUpdateAsyncData* data);
static void tracker_sparql_plugin_loader_real_update_blank_async_data_free (gpointer _data);
static void tracker_sparql_plugin_loader_real_update_blank_async (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_sparql_plugin_loader_update_blank_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tracker_sparql_connection_update_blank_async (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* tracker_sparql_connection_update_blank_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_plugin_loader_real_update_blank_async_co (TrackerSparqlPluginLoaderUpdateBlankAsyncData* data);
void tracker_sparql_connection_load (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GError** error);
static void tracker_sparql_plugin_loader_real_load (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GError** error);
static void tracker_sparql_plugin_loader_real_load_async_data_free (gpointer _data);
static void tracker_sparql_plugin_loader_real_load_async (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_sparql_plugin_loader_load_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tracker_sparql_connection_load_async (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_sparql_connection_load_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_plugin_loader_real_load_async_co (TrackerSparqlPluginLoaderLoadAsyncData* data);
TrackerSparqlCursor* tracker_sparql_connection_statistics (TrackerSparqlConnection* self, GCancellable* cancellable, GError** error);
static TrackerSparqlCursor* tracker_sparql_plugin_loader_real_statistics (TrackerSparqlConnection* base, GCancellable* cancellable, GError** error);
static void tracker_sparql_plugin_loader_real_statistics_async_data_free (gpointer _data);
static void tracker_sparql_plugin_loader_real_statistics_async (TrackerSparqlConnection* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_sparql_plugin_loader_statistics_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tracker_sparql_connection_statistics_async (TrackerSparqlConnection* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlCursor* tracker_sparql_connection_statistics_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_plugin_loader_real_statistics_async_co (TrackerSparqlPluginLoaderStatisticsAsyncData* data);
static TrackerSparqlConnection* tracker_sparql_plugin_loader_load_plugins_from_path (TrackerSparqlPluginLoader* self, const char* path, gboolean required, GError** error);
static void tracker_sparql_plugin_loader_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static GType tracker_sparql_plugin_loader_backend_get_type (void) {
	static volatile gsize tracker_sparql_plugin_loader_backend_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_plugin_loader_backend_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_PLUGIN_LOADER_BACKEND_AUTO, "TRACKER_SPARQL_PLUGIN_LOADER_BACKEND_AUTO", "auto"}, {TRACKER_SPARQL_PLUGIN_LOADER_BACKEND_DIRECT, "TRACKER_SPARQL_PLUGIN_LOADER_BACKEND_DIRECT", "direct"}, {TRACKER_SPARQL_PLUGIN_LOADER_BACKEND_BUS, "TRACKER_SPARQL_PLUGIN_LOADER_BACKEND_BUS", "bus"}, {0, NULL, NULL}};
		GType tracker_sparql_plugin_loader_backend_type_id;
		tracker_sparql_plugin_loader_backend_type_id = g_enum_register_static ("TrackerSparqlPluginLoaderBackend", values);
		g_once_init_leave (&tracker_sparql_plugin_loader_backend_type_id__volatile, tracker_sparql_plugin_loader_backend_type_id);
	}
	return tracker_sparql_plugin_loader_backend_type_id__volatile;
}


TrackerSparqlPluginLoader* tracker_sparql_plugin_loader_construct (GType object_type, gboolean direct_only, GError** error) {
	GError * _inner_error_;
	TrackerSparqlPluginLoader * self;
	_inner_error_ = NULL;
	g_return_val_if_fail (!tracker_sparql_plugin_loader_initialized, NULL);
	self = (TrackerSparqlPluginLoader*) tracker_sparql_connection_construct (object_type);
	if (!g_module_supported ()) {
		return self;
	}
	{
		tracker_sparql_plugin_loader_load_plugins (self, direct_only, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, e->message);
			{
				_g_error_free0 (e);
				goto __finally0;
			}
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	tracker_sparql_plugin_loader_initialized = TRUE;
	return self;
}


TrackerSparqlPluginLoader* tracker_sparql_plugin_loader_new (gboolean direct_only, GError** error) {
	return tracker_sparql_plugin_loader_construct (TRACKER_SPARQL_TYPE_PLUGIN_LOADER, direct_only, error);
}


static TrackerSparqlCursor* tracker_sparql_plugin_loader_real_query (TrackerSparqlConnection* base, const char* sparql, GCancellable* cancellable, GError** error) {
	TrackerSparqlPluginLoader * self;
	TrackerSparqlCursor* result = NULL;
	GError * _inner_error_;
	self = (TrackerSparqlPluginLoader*) base;
	g_return_val_if_fail (sparql != NULL, NULL);
	_inner_error_ = NULL;
	g_return_val_if_fail ((tracker_sparql_plugin_loader_bus != NULL) || (tracker_sparql_plugin_loader_direct != NULL), NULL);
	g_debug ("tracker-plugin-loader.vala:49: %s(): '%s'", "Tracker.Sparql.PluginLoader.query", sparql);
	if (tracker_sparql_plugin_loader_direct != NULL) {
		TrackerSparqlCursor* _tmp0_;
		_tmp0_ = tracker_sparql_connection_query (tracker_sparql_plugin_loader_direct, sparql, cancellable, &_inner_error_);
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = _tmp0_;
		return result;
	} else {
		TrackerSparqlCursor* _tmp1_;
		_tmp1_ = tracker_sparql_connection_query (tracker_sparql_plugin_loader_bus, sparql, cancellable, &_inner_error_);
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = _tmp1_;
		return result;
	}
}


static void tracker_sparql_plugin_loader_real_query_async_data_free (gpointer _data) {
	TrackerSparqlPluginLoaderQueryAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (TrackerSparqlPluginLoaderQueryAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void tracker_sparql_plugin_loader_real_query_async (TrackerSparqlConnection* base, const char* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlPluginLoader * self;
	TrackerSparqlPluginLoaderQueryAsyncData* _data_;
	self = (TrackerSparqlPluginLoader*) base;
	_data_ = g_slice_new0 (TrackerSparqlPluginLoaderQueryAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_plugin_loader_real_query_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_plugin_loader_real_query_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->sparql = g_strdup (sparql);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_plugin_loader_real_query_async_co (_data_);
}


static TrackerSparqlCursor* tracker_sparql_plugin_loader_real_query_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerSparqlPluginLoaderQueryAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_plugin_loader_query_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlPluginLoaderQueryAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tracker_sparql_plugin_loader_real_query_async_co (data);
}


static gboolean tracker_sparql_plugin_loader_real_query_async_co (TrackerSparqlPluginLoaderQueryAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_return_val_if_fail ((tracker_sparql_plugin_loader_bus != NULL) || (tracker_sparql_plugin_loader_direct != NULL), NULL);
		g_debug ("tracker-plugin-loader.vala:59: %s(): '%s'", "Tracker.Sparql.PluginLoader.query_async", data->sparql);
		if (tracker_sparql_plugin_loader_direct != NULL) {
			data->_state_ = 1;
			tracker_sparql_connection_query_async (tracker_sparql_plugin_loader_direct, data->sparql, data->cancellable, tracker_sparql_plugin_loader_query_async_ready, data);
			return FALSE;
			_state_1:
			data->_tmp0_ = tracker_sparql_connection_query_finish (tracker_sparql_plugin_loader_direct, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
			}
			data->result = data->_tmp0_;
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			data->_state_ = 2;
			tracker_sparql_connection_query_async (tracker_sparql_plugin_loader_bus, data->sparql, data->cancellable, tracker_sparql_plugin_loader_query_async_ready, data);
			return FALSE;
			_state_2:
			data->_tmp1_ = tracker_sparql_connection_query_finish (tracker_sparql_plugin_loader_bus, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
			}
			data->result = data->_tmp1_;
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void tracker_sparql_plugin_loader_real_update (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GError** error) {
	TrackerSparqlPluginLoader * self;
	GError * _inner_error_;
	self = (TrackerSparqlPluginLoader*) base;
	g_return_if_fail (sparql != NULL);
	_inner_error_ = NULL;
	g_return_if_fail (tracker_sparql_plugin_loader_bus != NULL);
	g_debug ("tracker-plugin-loader.vala:69: %s(priority:%d): '%s'", "Tracker.Sparql.PluginLoader.update", priority, sparql);
	tracker_sparql_connection_update (tracker_sparql_plugin_loader_bus, sparql, priority, cancellable, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static GVariant* tracker_sparql_plugin_loader_real_update_blank (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GError** error) {
	TrackerSparqlPluginLoader * self;
	GVariant* result = NULL;
	GError * _inner_error_;
	GVariant* _tmp0_;
	self = (TrackerSparqlPluginLoader*) base;
	g_return_val_if_fail (sparql != NULL, NULL);
	_inner_error_ = NULL;
	g_return_val_if_fail (tracker_sparql_plugin_loader_bus != NULL, NULL);
	g_debug ("tracker-plugin-loader.vala:75: %s(priority:%d): '%s'", "Tracker.Sparql.PluginLoader.update_blank", priority, sparql);
	_tmp0_ = tracker_sparql_connection_update_blank (tracker_sparql_plugin_loader_bus, sparql, priority, cancellable, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp0_;
	return result;
}


static void tracker_sparql_plugin_loader_real_update_async_data_free (gpointer _data) {
	TrackerSparqlPluginLoaderUpdateAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	g_object_unref (data->self);
	g_slice_free (TrackerSparqlPluginLoaderUpdateAsyncData, data);
}


static void tracker_sparql_plugin_loader_real_update_async (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlPluginLoader * self;
	TrackerSparqlPluginLoaderUpdateAsyncData* _data_;
	self = (TrackerSparqlPluginLoader*) base;
	_data_ = g_slice_new0 (TrackerSparqlPluginLoaderUpdateAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_plugin_loader_real_update_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_plugin_loader_real_update_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->sparql = g_strdup (sparql);
	_data_->priority = priority;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_plugin_loader_real_update_async_co (_data_);
}


static void tracker_sparql_plugin_loader_real_update_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlPluginLoaderUpdateAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_sparql_plugin_loader_update_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlPluginLoaderUpdateAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tracker_sparql_plugin_loader_real_update_async_co (data);
}


static gboolean tracker_sparql_plugin_loader_real_update_async_co (TrackerSparqlPluginLoaderUpdateAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_return_if_fail (tracker_sparql_plugin_loader_bus != NULL);
		g_debug ("tracker-plugin-loader.vala:81: %s(priority:%d): '%s'", "Tracker.Sparql.PluginLoader.update_async", data->priority, data->sparql);
		data->_state_ = 3;
		tracker_sparql_connection_update_async (tracker_sparql_plugin_loader_bus, data->sparql, data->priority, data->cancellable, tracker_sparql_plugin_loader_update_async_ready, data);
		return FALSE;
		_state_3:
		tracker_sparql_connection_update_finish (tracker_sparql_plugin_loader_bus, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void tracker_sparql_plugin_loader_real_update_blank_async_data_free (gpointer _data) {
	TrackerSparqlPluginLoaderUpdateBlankAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	_g_variant_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (TrackerSparqlPluginLoaderUpdateBlankAsyncData, data);
}


static void tracker_sparql_plugin_loader_real_update_blank_async (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlPluginLoader * self;
	TrackerSparqlPluginLoaderUpdateBlankAsyncData* _data_;
	self = (TrackerSparqlPluginLoader*) base;
	_data_ = g_slice_new0 (TrackerSparqlPluginLoaderUpdateBlankAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_plugin_loader_real_update_blank_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_plugin_loader_real_update_blank_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->sparql = g_strdup (sparql);
	_data_->priority = priority;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_plugin_loader_real_update_blank_async_co (_data_);
}


static GVariant* tracker_sparql_plugin_loader_real_update_blank_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerSparqlPluginLoaderUpdateBlankAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_plugin_loader_update_blank_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlPluginLoaderUpdateBlankAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tracker_sparql_plugin_loader_real_update_blank_async_co (data);
}


static gboolean tracker_sparql_plugin_loader_real_update_blank_async_co (TrackerSparqlPluginLoaderUpdateBlankAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_return_val_if_fail (tracker_sparql_plugin_loader_bus != NULL, NULL);
		g_debug ("tracker-plugin-loader.vala:87: %s(priority:%d): '%s'", "Tracker.Sparql.PluginLoader.update_blank_async", data->priority, data->sparql);
		data->_state_ = 4;
		tracker_sparql_connection_update_blank_async (tracker_sparql_plugin_loader_bus, data->sparql, data->priority, data->cancellable, tracker_sparql_plugin_loader_update_blank_async_ready, data);
		return FALSE;
		_state_4:
		data->_tmp0_ = tracker_sparql_connection_update_blank_finish (tracker_sparql_plugin_loader_bus, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
		data->result = data->_tmp0_;
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void tracker_sparql_plugin_loader_real_load (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GError** error) {
	TrackerSparqlPluginLoader * self;
	GError * _inner_error_;
	char* uri;
	self = (TrackerSparqlPluginLoader*) base;
	g_return_if_fail (file != NULL);
	_inner_error_ = NULL;
	g_return_if_fail (tracker_sparql_plugin_loader_bus != NULL);
	uri = g_file_get_uri (file);
	g_debug ("tracker-plugin-loader.vala:94: %s(): '%s'", "Tracker.Sparql.PluginLoader.load", uri);
	tracker_sparql_connection_load (tracker_sparql_plugin_loader_bus, file, cancellable, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (uri);
			return;
		} else {
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (uri);
}


static void tracker_sparql_plugin_loader_real_load_async_data_free (gpointer _data) {
	TrackerSparqlPluginLoaderLoadAsyncData* data;
	data = _data;
	_g_object_unref0 (data->file);
	_g_object_unref0 (data->cancellable);
	g_object_unref (data->self);
	g_slice_free (TrackerSparqlPluginLoaderLoadAsyncData, data);
}


static void tracker_sparql_plugin_loader_real_load_async (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlPluginLoader * self;
	TrackerSparqlPluginLoaderLoadAsyncData* _data_;
	self = (TrackerSparqlPluginLoader*) base;
	_data_ = g_slice_new0 (TrackerSparqlPluginLoaderLoadAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_plugin_loader_real_load_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_plugin_loader_real_load_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->file = _g_object_ref0 (file);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_plugin_loader_real_load_async_co (_data_);
}


static void tracker_sparql_plugin_loader_real_load_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlPluginLoaderLoadAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_sparql_plugin_loader_load_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlPluginLoaderLoadAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tracker_sparql_plugin_loader_real_load_async_co (data);
}


static gboolean tracker_sparql_plugin_loader_real_load_async_co (TrackerSparqlPluginLoaderLoadAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_return_if_fail (tracker_sparql_plugin_loader_bus != NULL);
		data->uri = g_file_get_uri (data->file);
		g_debug ("tracker-plugin-loader.vala:101: %s(): '%s'", "Tracker.Sparql.PluginLoader.load_async", data->uri);
		data->_state_ = 5;
		tracker_sparql_connection_load_async (tracker_sparql_plugin_loader_bus, data->file, data->cancellable, tracker_sparql_plugin_loader_load_async_ready, data);
		return FALSE;
		_state_5:
		tracker_sparql_connection_load_finish (tracker_sparql_plugin_loader_bus, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_free0 (data->uri);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				_g_free0 (data->uri);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
		_g_free0 (data->uri);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static TrackerSparqlCursor* tracker_sparql_plugin_loader_real_statistics (TrackerSparqlConnection* base, GCancellable* cancellable, GError** error) {
	TrackerSparqlPluginLoader * self;
	TrackerSparqlCursor* result = NULL;
	GError * _inner_error_;
	TrackerSparqlCursor* _tmp0_;
	self = (TrackerSparqlPluginLoader*) base;
	_inner_error_ = NULL;
	g_return_val_if_fail (tracker_sparql_plugin_loader_bus != NULL, NULL);
	g_debug ("tracker-plugin-loader.vala:107: %s()", "Tracker.Sparql.PluginLoader.statistics");
	_tmp0_ = tracker_sparql_connection_statistics (tracker_sparql_plugin_loader_bus, cancellable, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp0_;
	return result;
}


static void tracker_sparql_plugin_loader_real_statistics_async_data_free (gpointer _data) {
	TrackerSparqlPluginLoaderStatisticsAsyncData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (TrackerSparqlPluginLoaderStatisticsAsyncData, data);
}


static void tracker_sparql_plugin_loader_real_statistics_async (TrackerSparqlConnection* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlPluginLoader * self;
	TrackerSparqlPluginLoaderStatisticsAsyncData* _data_;
	self = (TrackerSparqlPluginLoader*) base;
	_data_ = g_slice_new0 (TrackerSparqlPluginLoaderStatisticsAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_plugin_loader_real_statistics_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_plugin_loader_real_statistics_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_plugin_loader_real_statistics_async_co (_data_);
}


static TrackerSparqlCursor* tracker_sparql_plugin_loader_real_statistics_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerSparqlPluginLoaderStatisticsAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_plugin_loader_statistics_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlPluginLoaderStatisticsAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tracker_sparql_plugin_loader_real_statistics_async_co (data);
}


static gboolean tracker_sparql_plugin_loader_real_statistics_async_co (TrackerSparqlPluginLoaderStatisticsAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 6:
		goto _state_6;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_return_val_if_fail (tracker_sparql_plugin_loader_bus != NULL, NULL);
		g_debug ("tracker-plugin-loader.vala:113: %s()", "Tracker.Sparql.PluginLoader.statistics_async");
		data->_state_ = 6;
		tracker_sparql_connection_statistics_async (tracker_sparql_plugin_loader_bus, data->cancellable, tracker_sparql_plugin_loader_statistics_async_ready, data);
		return FALSE;
		_state_6:
		data->_tmp0_ = tracker_sparql_connection_statistics_finish (tracker_sparql_plugin_loader_bus, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
		data->result = data->_tmp0_;
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


static gboolean tracker_sparql_plugin_loader_load_plugins (TrackerSparqlPluginLoader* self, gboolean direct_only, GError** error) {
	gboolean result = FALSE;
	GError * _inner_error_;
	char* env_path;
	char* path;
	gboolean _tmp0_ = FALSE;
	GFile* dir;
	char* dir_path;
	char* env_backend;
	TrackerSparqlPluginLoaderBackend backend;
	gboolean _tmp4_ = FALSE;
	TrackerSparqlConnection* connection;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	env_path = g_strdup (g_getenv ("TRACKER_SPARQL_MODULE_PATH"));
	path = NULL;
	if (env_path != NULL) {
		_tmp0_ = string_get_length (env_path) > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		char* _tmp1_;
		path = (_tmp1_ = g_strdup (env_path), _g_free0 (path), _tmp1_);
	} else {
		char* _tmp2_;
		path = (_tmp2_ = g_strdup (SPARQL_MODULES_DIR), _g_free0 (path), _tmp2_);
	}
	dir = g_file_new_for_path (path);
	dir_path = g_file_get_path (dir);
	env_backend = g_strdup (g_getenv ("TRACKER_SPARQL_BACKEND"));
	backend = TRACKER_SPARQL_PLUGIN_LOADER_BACKEND_AUTO;
	if (env_backend != NULL) {
		if (g_ascii_strcasecmp (env_backend, "direct") == 0) {
			backend = TRACKER_SPARQL_PLUGIN_LOADER_BACKEND_DIRECT;
			g_debug ("tracker-plugin-loader.vala:137: Using backend = 'DIRECT'");
		} else {
			if (g_ascii_strcasecmp (env_backend, "bus") == 0) {
				backend = TRACKER_SPARQL_PLUGIN_LOADER_BACKEND_BUS;
				g_debug ("tracker-plugin-loader.vala:140: Using backend = 'BUS'");
			} else {
				g_warning ("tracker-plugin-loader.vala:142: Environment variable TRACKER_SPARQL_BA" \
"CKEND set to unknown value '%s'", env_backend);
			}
		}
	}
	if (backend == TRACKER_SPARQL_PLUGIN_LOADER_BACKEND_AUTO) {
		gboolean _tmp3_ = FALSE;
		if (direct_only) {
			_tmp3_ = backend == TRACKER_SPARQL_PLUGIN_LOADER_BACKEND_AUTO;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			backend = TRACKER_SPARQL_PLUGIN_LOADER_BACKEND_DIRECT;
			g_debug ("tracker-plugin-loader.vala:149: Using backend = 'DIRECT'");
		} else {
			g_debug ("tracker-plugin-loader.vala:151: Using backend = 'AUTO'");
		}
	}
	if (direct_only) {
		_tmp4_ = backend == TRACKER_SPARQL_PLUGIN_LOADER_BACKEND_BUS;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		g_debug ("tracker-plugin-loader.vala:156: Backend set in environment contradicts" \
" requested connection type, using environment to override");
	}
	g_debug ("tracker-plugin-loader.vala:159: Searching for modules in folder '%s' ." \
".", dir_path);
	connection = NULL;
	switch (backend) {
		case TRACKER_SPARQL_PLUGIN_LOADER_BACKEND_AUTO:
		{
			char* direct_path;
			TrackerSparqlConnection* _tmp5_;
			TrackerSparqlConnection* _tmp6_;
			char* bus_path;
			TrackerSparqlConnection* _tmp7_;
			TrackerSparqlConnection* _tmp8_;
			TrackerSparqlConnection* _tmp9_;
			direct_path = g_module_build_path (dir_path, "tracker-direct");
			_tmp5_ = tracker_sparql_plugin_loader_load_plugins_from_path (self, direct_path, FALSE, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (direct_path);
				_g_object_unref0 (connection);
				_g_free0 (env_backend);
				_g_free0 (dir_path);
				_g_object_unref0 (dir);
				_g_free0 (path);
				_g_free0 (env_path);
				return FALSE;
			}
			tracker_sparql_plugin_loader_direct = (_tmp6_ = _tmp5_, _g_object_unref0 (tracker_sparql_plugin_loader_direct), _tmp6_);
			bus_path = g_module_build_path (dir_path, "tracker-bus");
			_tmp7_ = tracker_sparql_plugin_loader_load_plugins_from_path (self, bus_path, TRUE, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (bus_path);
				_g_free0 (direct_path);
				_g_object_unref0 (connection);
				_g_free0 (env_backend);
				_g_free0 (dir_path);
				_g_object_unref0 (dir);
				_g_free0 (path);
				_g_free0 (env_path);
				return FALSE;
			}
			tracker_sparql_plugin_loader_bus = (_tmp8_ = _tmp7_, _g_object_unref0 (tracker_sparql_plugin_loader_bus), _tmp8_);
			connection = (_tmp9_ = _g_object_ref0 (tracker_sparql_plugin_loader_bus), _g_object_unref0 (connection), _tmp9_);
			_g_free0 (bus_path);
			_g_free0 (direct_path);
			break;
		}
		case TRACKER_SPARQL_PLUGIN_LOADER_BACKEND_DIRECT:
		{
			char* direct_path;
			TrackerSparqlConnection* _tmp10_;
			TrackerSparqlConnection* _tmp11_;
			TrackerSparqlConnection* _tmp12_;
			direct_path = g_module_build_path (dir_path, "tracker-direct");
			_tmp10_ = tracker_sparql_plugin_loader_load_plugins_from_path (self, direct_path, TRUE, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (direct_path);
				_g_object_unref0 (connection);
				_g_free0 (env_backend);
				_g_free0 (dir_path);
				_g_object_unref0 (dir);
				_g_free0 (path);
				_g_free0 (env_path);
				return FALSE;
			}
			connection = (_tmp12_ = _g_object_ref0 (tracker_sparql_plugin_loader_direct = (_tmp11_ = _tmp10_, _g_object_unref0 (tracker_sparql_plugin_loader_direct), _tmp11_)), _g_object_unref0 (connection), _tmp12_);
			_g_free0 (direct_path);
			break;
		}
		case TRACKER_SPARQL_PLUGIN_LOADER_BACKEND_BUS:
		{
			char* bus_path;
			TrackerSparqlConnection* _tmp13_;
			TrackerSparqlConnection* _tmp14_;
			TrackerSparqlConnection* _tmp15_;
			bus_path = g_module_build_path (dir_path, "tracker-bus");
			_tmp13_ = tracker_sparql_plugin_loader_load_plugins_from_path (self, bus_path, TRUE, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (bus_path);
				_g_object_unref0 (connection);
				_g_free0 (env_backend);
				_g_free0 (dir_path);
				_g_object_unref0 (dir);
				_g_free0 (path);
				_g_free0 (env_path);
				return FALSE;
			}
			connection = (_tmp15_ = _g_object_ref0 (tracker_sparql_plugin_loader_bus = (_tmp14_ = _tmp13_, _g_object_unref0 (tracker_sparql_plugin_loader_bus), _tmp14_)), _g_object_unref0 (connection), _tmp15_);
			_g_free0 (bus_path);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	g_debug ("tracker-plugin-loader.vala:188: Finished searching for modules");
	result = connection != NULL;
	_g_object_unref0 (connection);
	_g_free0 (env_backend);
	_g_free0 (dir_path);
	_g_object_unref0 (dir);
	_g_free0 (path);
	_g_free0 (env_path);
	return result;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static TrackerSparqlConnection* tracker_sparql_plugin_loader_load_plugins_from_path (TrackerSparqlPluginLoader* self, const char* path, gboolean required, GError** error) {
	TrackerSparqlConnection* result = NULL;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_inner_error_ = NULL;
	{
		GFile* file;
		GFileInfo* info;
		char* attributes;
		GFileInfo* _tmp0_;
		GFileInfo* _tmp1_;
		char* content_type;
		char* mime;
		char* expected_mime;
		GModule* module;
		void* function = NULL;
		void* module_init_target = NULL;
		GDestroyNotify module_init_target_destroy_notify = NULL;
		TrackerSparqlPluginLoaderModuleInitFunc _tmp2_;
		TrackerSparqlPluginLoaderModuleInitFunc module_init;
		TrackerSparqlConnection* c;
		file = g_file_new_for_path (path);
		g_assert (file != NULL);
		info = NULL;
		attributes = g_strdup (G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE);
		_tmp0_ = g_file_query_info (file, attributes, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (attributes);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			goto __catch1_g_error;
		}
		info = (_tmp1_ = _tmp0_, _g_object_unref0 (info), _tmp1_);
		content_type = g_strdup (g_file_info_get_content_type (info));
		mime = g_content_type_get_mime_type (content_type);
		expected_mime = g_strdup ("application/x-sharedlib");
		if (_vala_strcmp0 (mime, expected_mime) != 0) {
			_inner_error_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Could not load plugin, mime type was '%s', expected:'%s'", mime, expected_mime);
			{
				_g_free0 (expected_mime);
				_g_free0 (mime);
				_g_free0 (content_type);
				_g_free0 (attributes);
				_g_object_unref0 (info);
				_g_object_unref0 (file);
				goto __catch1_g_error;
			}
		}
		module = g_module_open (path, G_MODULE_BIND_LOCAL);
		if (module == NULL) {
			_inner_error_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to load module from path '%s': %s", path, g_module_error ());
			{
				_g_module_close0 (module);
				_g_free0 (expected_mime);
				_g_free0 (mime);
				_g_free0 (content_type);
				_g_free0 (attributes);
				_g_object_unref0 (info);
				_g_object_unref0 (file);
				goto __catch1_g_error;
			}
		}
		if (!g_module_symbol (module, "module_init", &function)) {
			_inner_error_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to find entry point function '%s' in '%s': %s", "module_init", path, g_module_error ());
			{
				_g_module_close0 (module);
				_g_free0 (expected_mime);
				_g_free0 (mime);
				_g_free0 (content_type);
				_g_free0 (attributes);
				_g_object_unref0 (info);
				_g_object_unref0 (file);
				goto __catch1_g_error;
			}
		}
		module_init = (_tmp2_ = (TrackerSparqlPluginLoaderModuleInitFunc) function, module_init_target = NULL, module_init_target_destroy_notify = NULL, _tmp2_);
		g_assert (module_init != NULL);
		g_module_make_resident (module);
		c = module_init (module_init_target);
		g_debug ("tracker-plugin-loader.vala:243: Loaded module source: '%s'", g_module_name (module));
		result = c;
		(module_init_target_destroy_notify == NULL) ? NULL : (module_init_target_destroy_notify (module_init_target), NULL);
		module_init = NULL;
		module_init_target = NULL;
		module_init_target_destroy_notify = NULL;
		_g_module_close0 (module);
		_g_free0 (expected_mime);
		_g_free0 (mime);
		_g_free0 (content_type);
		_g_free0 (attributes);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			if (required) {
				_inner_error_ = _g_error_copy0 (e);
				{
					_g_error_free0 (e);
					goto __finally1;
				}
			} else {
				result = NULL;
				_g_error_free0 (e);
				return result;
			}
			_g_error_free0 (e);
		}
	}
	__finally1:
	{
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
}


static void tracker_sparql_plugin_loader_class_init (TrackerSparqlPluginLoaderClass * klass) {
	tracker_sparql_plugin_loader_parent_class = g_type_class_peek_parent (klass);
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query = tracker_sparql_plugin_loader_real_query;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query_async = tracker_sparql_plugin_loader_real_query_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query_finish = tracker_sparql_plugin_loader_real_query_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update = tracker_sparql_plugin_loader_real_update;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank = tracker_sparql_plugin_loader_real_update_blank;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_async = tracker_sparql_plugin_loader_real_update_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_finish = tracker_sparql_plugin_loader_real_update_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank_async = tracker_sparql_plugin_loader_real_update_blank_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank_finish = tracker_sparql_plugin_loader_real_update_blank_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load = tracker_sparql_plugin_loader_real_load;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load_async = tracker_sparql_plugin_loader_real_load_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load_finish = tracker_sparql_plugin_loader_real_load_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics = tracker_sparql_plugin_loader_real_statistics;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics_async = tracker_sparql_plugin_loader_real_statistics_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics_finish = tracker_sparql_plugin_loader_real_statistics_finish;
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_plugin_loader_finalize;
}


static void tracker_sparql_plugin_loader_instance_init (TrackerSparqlPluginLoader * self) {
}


static void tracker_sparql_plugin_loader_finalize (GObject* obj) {
	TrackerSparqlPluginLoader * self;
	self = TRACKER_SPARQL_PLUGIN_LOADER (obj);
	G_OBJECT_CLASS (tracker_sparql_plugin_loader_parent_class)->finalize (obj);
}


GType tracker_sparql_plugin_loader_get_type (void) {
	static volatile gsize tracker_sparql_plugin_loader_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_plugin_loader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlPluginLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_plugin_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlPluginLoader), 0, (GInstanceInitFunc) tracker_sparql_plugin_loader_instance_init, NULL };
		GType tracker_sparql_plugin_loader_type_id;
		tracker_sparql_plugin_loader_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONNECTION, "TrackerSparqlPluginLoader", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_plugin_loader_type_id__volatile, tracker_sparql_plugin_loader_type_id);
	}
	return tracker_sparql_plugin_loader_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




