/* tracker-store.c generated by valac 0.11.4, the Vala compiler
 * generated from tracker-store.vala, do not modify */

/*
 * Copyright (C) 2009-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 *
 * Author: Philip Van Hoof <philip@codeminded.be>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <libtracker-data/tracker-db-interface.h>
#include <libtracker-data/tracker-data-query.h>
#include <libtracker-data/tracker-data-update.h>
#include <libtracker-data/tracker-data-backup.h>
#include <tracker-store/tracker-events.h>
#include <gobject/gvaluecollector.h>


#define TRACKER_TYPE_STORE (tracker_store_get_type ())
#define TRACKER_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STORE, TrackerStore))
#define TRACKER_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STORE, TrackerStoreClass))
#define TRACKER_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STORE))
#define TRACKER_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STORE))
#define TRACKER_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STORE, TrackerStoreClass))

typedef struct _TrackerStore TrackerStore;
typedef struct _TrackerStoreClass TrackerStoreClass;
typedef struct _TrackerStorePrivate TrackerStorePrivate;

#define TRACKER_STORE_TYPE_PRIORITY (tracker_store_priority_get_type ())

#define TRACKER_STORE_TYPE_TASK_TYPE (tracker_store_task_type_get_type ())

#define TRACKER_STORE_TYPE_TASK (tracker_store_task_get_type ())
#define TRACKER_STORE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_TASK, TrackerStoreTask))
#define TRACKER_STORE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_TASK, TrackerStoreTaskClass))
#define TRACKER_STORE_IS_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_TASK))
#define TRACKER_STORE_IS_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_TASK))
#define TRACKER_STORE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_TASK, TrackerStoreTaskClass))

typedef struct _TrackerStoreTask TrackerStoreTask;
typedef struct _TrackerStoreTaskClass TrackerStoreTaskClass;
#define _tracker_store_task_unref0(var) ((var == NULL) ? NULL : (var = (tracker_store_task_unref (var), NULL)))

#define TRACKER_STORE_TYPE_QUERY_TASK (tracker_store_query_task_get_type ())
#define TRACKER_STORE_QUERY_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTask))
#define TRACKER_STORE_QUERY_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTaskClass))
#define TRACKER_STORE_IS_QUERY_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_QUERY_TASK))
#define TRACKER_STORE_IS_QUERY_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_QUERY_TASK))
#define TRACKER_STORE_QUERY_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTaskClass))

typedef struct _TrackerStoreQueryTask TrackerStoreQueryTask;
typedef struct _TrackerStoreQueryTaskClass TrackerStoreQueryTaskClass;
typedef struct _Block7Data Block7Data;
typedef struct _TrackerStoreTaskPrivate TrackerStoreTaskPrivate;
typedef struct _TrackerStoreQueryTaskPrivate TrackerStoreQueryTaskPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TRACKER_STORE_TYPE_UPDATE_TASK (tracker_store_update_task_get_type ())
#define TRACKER_STORE_UPDATE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTask))
#define TRACKER_STORE_UPDATE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTaskClass))
#define TRACKER_STORE_IS_UPDATE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_UPDATE_TASK))
#define TRACKER_STORE_IS_UPDATE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_UPDATE_TASK))
#define TRACKER_STORE_UPDATE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTaskClass))

typedef struct _TrackerStoreUpdateTask TrackerStoreUpdateTask;
typedef struct _TrackerStoreUpdateTaskClass TrackerStoreUpdateTaskClass;
typedef struct _TrackerStoreUpdateTaskPrivate TrackerStoreUpdateTaskPrivate;
typedef struct _Block8Data Block8Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

#define TRACKER_STORE_TYPE_TURTLE_TASK (tracker_store_turtle_task_get_type ())
#define TRACKER_STORE_TURTLE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTask))
#define TRACKER_STORE_TURTLE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTaskClass))
#define TRACKER_STORE_IS_TURTLE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_TURTLE_TASK))
#define TRACKER_STORE_IS_TURTLE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_TURTLE_TASK))
#define TRACKER_STORE_TURTLE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTaskClass))

typedef struct _TrackerStoreTurtleTask TrackerStoreTurtleTask;
typedef struct _TrackerStoreTurtleTaskClass TrackerStoreTurtleTaskClass;
typedef struct _TrackerStoreTurtleTaskPrivate TrackerStoreTurtleTaskPrivate;
#define _g_queue_free0(var) ((var == NULL) ? NULL : (var = (g_queue_free (var), NULL)))
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerStoreSparqlQueryData TrackerStoreSparqlQueryData;
typedef struct _TrackerStoreSparqlUpdateData TrackerStoreSparqlUpdateData;
typedef struct _TrackerStoreSparqlUpdateBlankData TrackerStoreSparqlUpdateBlankData;
typedef struct _TrackerStoreQueueTurtleImportData TrackerStoreQueueTurtleImportData;
typedef struct _TrackerStorePauseData TrackerStorePauseData;
typedef struct _TrackerStoreParamSpecTask TrackerStoreParamSpecTask;
typedef struct _TrackerParamSpecStore TrackerParamSpecStore;

struct _TrackerStore {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerStorePrivate * priv;
};

struct _TrackerStoreClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerStore *self);
};

typedef enum  {
	TRACKER_STORE_PRIORITY_HIGH,
	TRACKER_STORE_PRIORITY_LOW,
	TRACKER_STORE_PRIORITY_TURTLE,
	TRACKER_STORE_PRIORITY_N_PRIORITIES
} TrackerStorePriority;

typedef enum  {
	TRACKER_STORE_TASK_TYPE_QUERY,
	TRACKER_STORE_TASK_TYPE_UPDATE,
	TRACKER_STORE_TASK_TYPE_UPDATE_BLANK,
	TRACKER_STORE_TASK_TYPE_TURTLE
} TrackerStoreTaskType;

struct _Block7Data {
	int _ref_count_;
	TrackerStoreQueryTask* query_task;
};

struct _TrackerStoreTask {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerStoreTaskPrivate * priv;
	TrackerStoreTaskType type;
	gchar* client_id;
	GError* error;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _TrackerStoreTaskClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerStoreTask *self);
};

typedef void (*TrackerStoreSparqlQueryInThread) (TrackerDBCursor* cursor, void* user_data, GError** error);
struct _TrackerStoreQueryTask {
	TrackerStoreTask parent_instance;
	TrackerStoreQueryTaskPrivate * priv;
	gchar* query;
	GCancellable* cancellable;
	guint watchdog_id;
	TrackerStoreSparqlQueryInThread in_thread;
	gpointer in_thread_target;
	GDestroyNotify in_thread_target_destroy_notify;
};

struct _TrackerStoreQueryTaskClass {
	TrackerStoreTaskClass parent_class;
};

struct _TrackerStoreUpdateTask {
	TrackerStoreTask parent_instance;
	TrackerStoreUpdateTaskPrivate * priv;
	gchar* query;
	GPtrArray* blank_nodes;
	TrackerStorePriority priority;
};

struct _TrackerStoreUpdateTaskClass {
	TrackerStoreTaskClass parent_class;
};

struct _Block8Data {
	int _ref_count_;
	TrackerStoreTask* task;
};

struct _TrackerStoreTurtleTask {
	TrackerStoreTask parent_instance;
	TrackerStoreTurtleTaskPrivate * priv;
	gchar* path;
};

struct _TrackerStoreTurtleTaskClass {
	TrackerStoreTaskClass parent_class;
};

struct _TrackerStoreSparqlQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* sparql;
	TrackerStorePriority priority;
	TrackerStoreSparqlQueryInThread in_thread;
	gpointer in_thread_target;
	GDestroyNotify in_thread_target_destroy_notify;
	gchar* client_id;
	TrackerStoreQueryTask* _tmp0_;
	TrackerStoreQueryTask* task;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	TrackerStoreSparqlQueryInThread _tmp5_;
	TrackerStoreSparqlQueryInThread _tmp6_;
	GSourceFunc _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	TrackerStoreTask* _tmp10_;
	GError* _tmp11_;
	GError * _inner_error_;
};

struct _TrackerStoreSparqlUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* sparql;
	TrackerStorePriority priority;
	gchar* client_id;
	TrackerStoreUpdateTask* _tmp0_;
	TrackerStoreUpdateTask* task;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GSourceFunc _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	TrackerStoreTask* _tmp6_;
	GError* _tmp7_;
	GError * _inner_error_;
};

struct _TrackerStoreSparqlUpdateBlankData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* sparql;
	TrackerStorePriority priority;
	gchar* client_id;
	GPtrArray* result;
	TrackerStoreUpdateTask* _tmp0_;
	TrackerStoreUpdateTask* task;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GSourceFunc _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	TrackerStoreTask* _tmp6_;
	GError* _tmp7_;
	GPtrArray* _tmp8_;
	GError * _inner_error_;
};

struct _TrackerStoreQueueTurtleImportData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GFile* file;
	gchar* client_id;
	TrackerStoreTurtleTask* _tmp0_;
	TrackerStoreTurtleTask* task;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GSourceFunc _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	TrackerStoreTask* _tmp6_;
	GError* _tmp7_;
	GError * _inner_error_;
};

struct _TrackerStorePauseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gboolean _tmp0_;
	GSourceFunc _tmp1_;
	GSourceFunc _tmp2_;
};

struct _TrackerStoreParamSpecTask {
	GParamSpec parent_instance;
};

struct _TrackerParamSpecStore {
	GParamSpec parent_instance;
};


static gpointer tracker_store_parent_class = NULL;
static GQueue* tracker_store_query_queues[3];
static GQueue* tracker_store_query_queues[3] = {0};
static GQueue* tracker_store_update_queues[3];
static GQueue* tracker_store_update_queues[3] = {0};
static gint tracker_store_n_queries_running;
static gint tracker_store_n_queries_running = 0;
static gboolean tracker_store_update_running;
static gboolean tracker_store_update_running = FALSE;
static GThreadPool* tracker_store_update_pool;
static GThreadPool* tracker_store_update_pool = NULL;
static GThreadPool* tracker_store_query_pool;
static GThreadPool* tracker_store_query_pool = NULL;
static GPtrArray* tracker_store_running_tasks;
static GPtrArray* tracker_store_running_tasks = NULL;
static gint tracker_store_max_task_time;
static gint tracker_store_max_task_time = 0;
static gboolean tracker_store_active;
static gboolean tracker_store_active = FALSE;
static GSourceFunc tracker_store_active_callback;
static gpointer tracker_store_active_callback_target;
static GDestroyNotify tracker_store_active_callback_target_destroy_notify;
static GSourceFunc tracker_store_active_callback = NULL;
static gpointer tracker_store_active_callback_target = NULL;
static GDestroyNotify tracker_store_active_callback_target_destroy_notify = NULL;
static gpointer tracker_store_task_parent_class = NULL;
static gpointer tracker_store_query_task_parent_class = NULL;
static gpointer tracker_store_update_task_parent_class = NULL;
static gpointer tracker_store_turtle_task_parent_class = NULL;

gpointer tracker_store_ref (gpointer instance);
void tracker_store_unref (gpointer instance);
GParamSpec* tracker_param_spec_store (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_store (GValue* value, gpointer v_object);
void tracker_value_take_store (GValue* value, gpointer v_object);
gpointer tracker_value_get_store (const GValue* value);
GType tracker_store_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_STORE_DUMMY_PROPERTY
};
GType tracker_store_priority_get_type (void) G_GNUC_CONST;
static GType tracker_store_task_type_get_type (void) G_GNUC_UNUSED;
static gpointer tracker_store_task_ref (gpointer instance);
static void tracker_store_task_unref (gpointer instance);
static GParamSpec* tracker_store_param_spec_task (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void tracker_store_value_set_task (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void tracker_store_value_take_task (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer tracker_store_value_get_task (const GValue* value) G_GNUC_UNUSED;
static GType tracker_store_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define TRACKER_STORE_MAX_CONCURRENT_QUERIES 2
#define TRACKER_STORE_MAX_TASK_TIME 30
static void tracker_store_sched (void);
static GType tracker_store_query_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
static gboolean _lambda0_ (Block7Data* _data7_);
static gboolean __lambda0__gsource_func (gpointer self);
static gboolean tracker_store_start_timer_or_not (TrackerStoreTask* task);
static GType tracker_store_update_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean tracker_store_task_finish_cb (TrackerStoreTask* task);
static void tracker_store_pool_dispatch_cb (TrackerStoreTask* task);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (Block8Data* _data8_);
static GType tracker_store_turtle_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean _lambda1_ (Block8Data* _data8_);
static gboolean __lambda1__gsource_func (gpointer self);
void tracker_store_init (void);
static void _tracker_store_task_unref0_ (gpointer var);
static void _tracker_store_pool_dispatch_cb_gfunc (gconstpointer data, gpointer self);
void tracker_store_shutdown (void);
static void tracker_store_sparql_query_data_free (gpointer _data);
void tracker_store_sparql_query (const gchar* sparql, TrackerStorePriority priority, TrackerStoreSparqlQueryInThread in_thread, void* in_thread_target, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_sparql_query_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_store_sparql_query_co (TrackerStoreSparqlQueryData* data);
static TrackerStoreQueryTask* tracker_store_query_task_new (void);
static TrackerStoreQueryTask* tracker_store_query_task_construct (GType object_type);
static gboolean _tracker_store_sparql_query_co_gsource_func (gpointer self);
static void tracker_store_sparql_update_data_free (gpointer _data);
void tracker_store_sparql_update (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_sparql_update_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_store_sparql_update_co (TrackerStoreSparqlUpdateData* data);
static TrackerStoreUpdateTask* tracker_store_update_task_new (void);
static TrackerStoreUpdateTask* tracker_store_update_task_construct (GType object_type);
static gboolean _tracker_store_sparql_update_co_gsource_func (gpointer self);
static void tracker_store_sparql_update_blank_data_free (gpointer _data);
void tracker_store_sparql_update_blank (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
GPtrArray* tracker_store_sparql_update_blank_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_store_sparql_update_blank_co (TrackerStoreSparqlUpdateBlankData* data);
static gboolean _tracker_store_sparql_update_blank_co_gsource_func (gpointer self);
static void tracker_store_queue_turtle_import_data_free (gpointer _data);
void tracker_store_queue_turtle_import (GFile* file, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_queue_turtle_import_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_store_queue_turtle_import_co (TrackerStoreQueueTurtleImportData* data);
static TrackerStoreTurtleTask* tracker_store_turtle_task_new (void);
static TrackerStoreTurtleTask* tracker_store_turtle_task_construct (GType object_type);
static gboolean _tracker_store_queue_turtle_import_co_gsource_func (gpointer self);
guint tracker_store_get_queue_size (TrackerStore* self);
void tracker_store_unreg_batches (const gchar* client_id);
static void tracker_store_pause_data_free (gpointer _data);
void tracker_store_pause (GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_pause_finish (GAsyncResult* _res_);
static gboolean tracker_store_pause_co (TrackerStorePauseData* data);
static gboolean _tracker_store_pause_co_gsource_func (gpointer self);
void tracker_store_resume (void);
TrackerStore* tracker_store_new (void);
TrackerStore* tracker_store_construct (GType object_type);
enum  {
	TRACKER_STORE_TASK_DUMMY_PROPERTY
};
static TrackerStoreTask* tracker_store_task_construct (GType object_type);
static void tracker_store_task_finalize (TrackerStoreTask* obj);
enum  {
	TRACKER_STORE_QUERY_TASK_DUMMY_PROPERTY
};
static void tracker_store_query_task_finalize (TrackerStoreTask* obj);
enum  {
	TRACKER_STORE_UPDATE_TASK_DUMMY_PROPERTY
};
static void tracker_store_update_task_finalize (TrackerStoreTask* obj);
enum  {
	TRACKER_STORE_TURTLE_TASK_DUMMY_PROPERTY
};
static void tracker_store_turtle_task_finalize (TrackerStoreTask* obj);
static void tracker_store_finalize (TrackerStore* obj);


GType tracker_store_priority_get_type (void) {
	static volatile gsize tracker_store_priority_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_priority_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_STORE_PRIORITY_HIGH, "TRACKER_STORE_PRIORITY_HIGH", "high"}, {TRACKER_STORE_PRIORITY_LOW, "TRACKER_STORE_PRIORITY_LOW", "low"}, {TRACKER_STORE_PRIORITY_TURTLE, "TRACKER_STORE_PRIORITY_TURTLE", "turtle"}, {TRACKER_STORE_PRIORITY_N_PRIORITIES, "TRACKER_STORE_PRIORITY_N_PRIORITIES", "n-priorities"}, {0, NULL, NULL}};
		GType tracker_store_priority_type_id;
		tracker_store_priority_type_id = g_enum_register_static ("TrackerStorePriority", values);
		g_once_init_leave (&tracker_store_priority_type_id__volatile, tracker_store_priority_type_id);
	}
	return tracker_store_priority_type_id__volatile;
}


static GType tracker_store_task_type_get_type (void) {
	static volatile gsize tracker_store_task_type_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_task_type_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_STORE_TASK_TYPE_QUERY, "TRACKER_STORE_TASK_TYPE_QUERY", "query"}, {TRACKER_STORE_TASK_TYPE_UPDATE, "TRACKER_STORE_TASK_TYPE_UPDATE", "update"}, {TRACKER_STORE_TASK_TYPE_UPDATE_BLANK, "TRACKER_STORE_TASK_TYPE_UPDATE_BLANK", "update-blank"}, {TRACKER_STORE_TASK_TYPE_TURTLE, "TRACKER_STORE_TASK_TYPE_TURTLE", "turtle"}, {0, NULL, NULL}};
		GType tracker_store_task_type_type_id;
		tracker_store_task_type_type_id = g_enum_register_static ("TrackerStoreTaskType", values);
		g_once_init_leave (&tracker_store_task_type_type_id__volatile, tracker_store_task_type_type_id);
	}
	return tracker_store_task_type_type_id__volatile;
}


static gpointer _tracker_store_task_ref0 (gpointer self) {
	return self ? tracker_store_task_ref (self) : NULL;
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		_tracker_store_task_unref0 (_data7_->query_task);
		g_slice_free (Block7Data, _data7_);
	}
}


static gboolean _lambda0_ (Block7Data* _data7_) {
	gboolean result = FALSE;
	g_cancellable_cancel (_data7_->query_task->cancellable);
	result = FALSE;
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


static void tracker_store_sched (void) {
	TrackerStoreTask* task;
	GError * _inner_error_ = NULL;
	task = NULL;
	if (!tracker_store_active) {
		_tracker_store_task_unref0 (task);
		return;
	}
	while (TRUE) {
		TrackerStoreTask* _tmp3_;
		if (!(tracker_store_n_queries_running < TRACKER_STORE_MAX_CONCURRENT_QUERIES)) {
			break;
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp0_;
				_tmp0_ = TRUE;
				while (TRUE) {
					gpointer _tmp1_ = NULL;
					TrackerStoreTask* _tmp2_;
					if (!_tmp0_) {
						i++;
					}
					_tmp0_ = FALSE;
					if (!(i < TRACKER_STORE_PRIORITY_N_PRIORITIES)) {
						break;
					}
					_tmp1_ = g_queue_pop_head (tracker_store_query_queues[i]);
					_tmp2_ = (TrackerStoreTask*) _tmp1_;
					_tracker_store_task_unref0 (task);
					task = _tmp2_;
					if (task != NULL) {
						break;
					}
				}
			}
		}
		if (task == NULL) {
			break;
		}
		_tmp3_ = _tracker_store_task_ref0 (task);
		g_ptr_array_add (tracker_store_running_tasks, _tmp3_);
		if (tracker_store_max_task_time != 0) {
			Block7Data* _data7_;
			TrackerStoreQueryTask* _tmp4_;
			guint _tmp5_;
			_data7_ = g_slice_new0 (Block7Data);
			_data7_->_ref_count_ = 1;
			_tmp4_ = _tracker_store_task_ref0 (TRACKER_STORE_QUERY_TASK (task));
			_data7_->query_task = _tmp4_;
			_tmp5_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) tracker_store_max_task_time, __lambda0__gsource_func, block7_data_ref (_data7_), block7_data_unref);
			_data7_->query_task->watchdog_id = _tmp5_;
			block7_data_unref (_data7_);
		}
		tracker_store_n_queries_running++;
		g_thread_pool_push (tracker_store_query_pool, task, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
		goto __finally18;
		__catch18_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally18:
		if (_inner_error_ != NULL) {
			_tracker_store_task_unref0 (task);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (!tracker_store_update_running) {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp6_;
				_tmp6_ = TRUE;
				while (TRUE) {
					gpointer _tmp7_ = NULL;
					TrackerStoreTask* _tmp8_;
					if (!_tmp6_) {
						i++;
					}
					_tmp6_ = FALSE;
					if (!(i < TRACKER_STORE_PRIORITY_N_PRIORITIES)) {
						break;
					}
					_tmp7_ = g_queue_pop_head (tracker_store_update_queues[i]);
					_tmp8_ = (TrackerStoreTask*) _tmp7_;
					_tracker_store_task_unref0 (task);
					task = _tmp8_;
					if (task != NULL) {
						break;
					}
				}
			}
		}
		if (task != NULL) {
			tracker_store_update_running = TRUE;
			g_thread_pool_push (tracker_store_update_pool, task, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch19_g_error;
			}
			goto __finally19;
			__catch19_g_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (e);
			}
			__finally19:
			if (_inner_error_ != NULL) {
				_tracker_store_task_unref0 (task);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_tracker_store_task_unref0 (task);
}


static gboolean tracker_store_start_timer_or_not (TrackerStoreTask* task) {
	gboolean result = FALSE;
	gboolean _result_ = FALSE;
	g_return_val_if_fail (task != NULL, FALSE);
	switch (task->type) {
		case TRACKER_STORE_TASK_TYPE_UPDATE:
		case TRACKER_STORE_TASK_TYPE_UPDATE_BLANK:
		{
			gboolean _tmp0_ = FALSE;
			if (TRACKER_STORE_UPDATE_TASK (task)->priority == TRACKER_STORE_PRIORITY_LOW) {
				guint _tmp1_;
				_tmp1_ = g_queue_get_length (tracker_store_update_queues[TRACKER_STORE_PRIORITY_LOW]);
				_tmp0_ = _tmp1_ > 0;
			} else {
				_tmp0_ = FALSE;
			}
			_result_ = !_tmp0_;
			break;
		}
		case TRACKER_STORE_TASK_TYPE_TURTLE:
		{
			guint _tmp2_;
			_tmp2_ = g_queue_get_length (tracker_store_update_queues[TRACKER_STORE_PRIORITY_TURTLE]);
			_result_ = _tmp2_ == 0;
			break;
		}
		default:
		case TRACKER_STORE_TASK_TYPE_QUERY:
		{
			_result_ = FALSE;
			break;
		}
	}
	result = _result_;
	return result;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean tracker_store_task_finish_cb (TrackerStoreTask* task) {
	gboolean result = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (task != NULL, FALSE);
	if (task->type == TRACKER_STORE_TASK_TYPE_QUERY) {
		TrackerStoreQueryTask* _tmp0_;
		TrackerStoreQueryTask* query_task;
		GError* _tmp3_;
		_tmp0_ = _tracker_store_task_ref0 (TRACKER_STORE_QUERY_TASK (task));
		query_task = _tmp0_;
		if (task->error == NULL) {
			g_cancellable_set_error_if_cancelled (query_task->cancellable, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch20_g_error;
			}
			goto __finally20;
			__catch20_g_error:
			{
				GError * e;
				GError* _tmp1_;
				GError* _tmp2_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp1_ = _g_error_copy0 (e);
				_tmp2_ = _tmp1_;
				_g_error_free0 (task->error);
				task->error = _tmp2_;
				_g_error_free0 (e);
			}
			__finally20:
			if (_inner_error_ != NULL) {
				_tracker_store_task_unref0 (query_task);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		task->callback (task->callback_target);
		_tmp3_ = NULL;
		_g_error_free0 (task->error);
		task->error = _tmp3_;
		g_ptr_array_remove (tracker_store_running_tasks, task);
		tracker_store_n_queries_running--;
		_tracker_store_task_unref0 (query_task);
	} else {
		gboolean _tmp4_ = FALSE;
		if (task->type == TRACKER_STORE_TASK_TYPE_UPDATE) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = task->type == TRACKER_STORE_TASK_TYPE_UPDATE_BLANK;
		}
		if (_tmp4_) {
			GError* _tmp6_;
			if (task->error == NULL) {
				gboolean _tmp5_;
				_tmp5_ = tracker_store_start_timer_or_not (task);
				tracker_data_notify_transaction (_tmp5_);
			}
			task->callback (task->callback_target);
			_tmp6_ = NULL;
			_g_error_free0 (task->error);
			task->error = _tmp6_;
			tracker_store_update_running = FALSE;
		} else {
			if (task->type == TRACKER_STORE_TASK_TYPE_TURTLE) {
				GError* _tmp8_;
				if (task->error == NULL) {
					gboolean _tmp7_;
					_tmp7_ = tracker_store_start_timer_or_not (task);
					tracker_data_notify_transaction (_tmp7_);
				}
				task->callback (task->callback_target);
				_tmp8_ = NULL;
				_g_error_free0 (task->error);
				task->error = _tmp8_;
				tracker_store_update_running = FALSE;
			}
		}
	}
	if (tracker_store_n_queries_running == 0) {
		_tmp10_ = !tracker_store_update_running;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		_tmp9_ = tracker_store_active_callback != NULL;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		tracker_store_active_callback (tracker_store_active_callback_target);
	}
	tracker_store_sched ();
	result = FALSE;
	return result;
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (Block8Data* _data8_) {
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		_tracker_store_task_unref0 (_data8_->task);
		g_slice_free (Block8Data, _data8_);
	}
}


static gboolean _lambda1_ (Block8Data* _data8_) {
	gboolean result = FALSE;
	tracker_store_task_finish_cb (_data8_->task);
	result = FALSE;
	return result;
}


static gboolean __lambda1__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda1_ (self);
	return result;
}


static void tracker_store_pool_dispatch_cb (TrackerStoreTask* task) {
	Block8Data* _data8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (task != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->task = _tracker_store_task_ref0 (task);
	if (_data8_->task->type == TRACKER_STORE_TASK_TYPE_QUERY) {
		TrackerStoreQueryTask* _tmp0_;
		TrackerStoreQueryTask* query_task;
		TrackerDBCursor* _tmp1_ = NULL;
		TrackerDBCursor* cursor;
		_tmp0_ = _tracker_store_task_ref0 (TRACKER_STORE_QUERY_TASK (_data8_->task));
		query_task = _tmp0_;
		_tmp1_ = tracker_data_query_sparql_cursor (query_task->query, &_inner_error_);
		cursor = _tmp1_;
		if (_inner_error_ != NULL) {
			_tracker_store_task_unref0 (query_task);
			goto __catch21_g_error;
		}
		query_task->in_thread (cursor, query_task->in_thread_target, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (cursor);
			_tracker_store_task_unref0 (query_task);
			goto __catch21_g_error;
		}
		_g_object_unref0 (cursor);
		_tracker_store_task_unref0 (query_task);
	} else {
		if (_data8_->task->type == TRACKER_STORE_TASK_TYPE_UPDATE) {
			TrackerStoreUpdateTask* _tmp2_;
			TrackerStoreUpdateTask* update_task;
			_tmp2_ = _tracker_store_task_ref0 (TRACKER_STORE_UPDATE_TASK (_data8_->task));
			update_task = _tmp2_;
			tracker_data_update_sparql (update_task->query, &_inner_error_);
			if (_inner_error_ != NULL) {
				_tracker_store_task_unref0 (update_task);
				goto __catch21_g_error;
			}
			_tracker_store_task_unref0 (update_task);
		} else {
			if (_data8_->task->type == TRACKER_STORE_TASK_TYPE_UPDATE_BLANK) {
				TrackerStoreUpdateTask* _tmp3_;
				TrackerStoreUpdateTask* update_task;
				GPtrArray* _tmp4_ = NULL;
				GPtrArray* _tmp5_;
				GPtrArray* _tmp6_;
				_tmp3_ = _tracker_store_task_ref0 (TRACKER_STORE_UPDATE_TASK (_data8_->task));
				update_task = _tmp3_;
				_tmp4_ = tracker_data_update_sparql_blank (update_task->query, &_inner_error_);
				_tmp5_ = _tmp4_;
				if (_inner_error_ != NULL) {
					_tracker_store_task_unref0 (update_task);
					goto __catch21_g_error;
				}
				_tmp6_ = _tmp5_;
				_g_ptr_array_unref0 (update_task->blank_nodes);
				update_task->blank_nodes = _tmp6_;
				_tracker_store_task_unref0 (update_task);
			} else {
				if (_data8_->task->type == TRACKER_STORE_TASK_TYPE_TURTLE) {
					TrackerStoreTurtleTask* _tmp7_;
					TrackerStoreTurtleTask* turtle_task;
					GFile* _tmp8_ = NULL;
					GFile* file;
					_tmp7_ = _tracker_store_task_ref0 (TRACKER_STORE_TURTLE_TASK (_data8_->task));
					turtle_task = _tmp7_;
					_tmp8_ = g_file_new_for_path (turtle_task->path);
					file = _tmp8_;
					tracker_events_freeze ();
					tracker_data_load_turtle_file (file, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_object_unref0 (file);
						_tracker_store_task_unref0 (turtle_task);
						goto __catch21_g_error;
					}
					tracker_events_reset_pending ();
					_g_object_unref0 (file);
					_tracker_store_task_unref0 (turtle_task);
				}
			}
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError * e;
		GError* _tmp9_;
		GError* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = _g_error_copy0 (e);
		_tmp10_ = _tmp9_;
		_g_error_free0 (_data8_->task->error);
		_data8_->task->error = _tmp10_;
		_g_error_free0 (e);
	}
	__finally21:
	if (_inner_error_ != NULL) {
		block8_data_unref (_data8_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda1__gsource_func, block8_data_ref (_data8_), block8_data_unref);
	block8_data_unref (_data8_);
}


static void _tracker_store_task_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (tracker_store_task_unref (var), NULL));
}


static void _tracker_store_pool_dispatch_cb_gfunc (gconstpointer data, gpointer self) {
	tracker_store_pool_dispatch_cb (data);
}


void tracker_store_init (void) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* max_task_time_env;
	GPtrArray* _tmp3_ = NULL;
	GPtrArray* _tmp4_;
	GThreadPool* _tmp10_ = NULL;
	GThreadPool* _tmp11_;
	GThreadPool* _tmp12_;
	GThreadPool* _tmp13_ = NULL;
	GThreadPool* _tmp14_;
	GThreadPool* _tmp15_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_getenv ("TRACKER_STORE_MAX_TASK_TIME");
	_tmp1_ = g_strdup (_tmp0_);
	max_task_time_env = _tmp1_;
	if (max_task_time_env != NULL) {
		gint _tmp2_;
		_tmp2_ = atoi (max_task_time_env);
		tracker_store_max_task_time = _tmp2_;
	} else {
		tracker_store_max_task_time = TRACKER_STORE_MAX_TASK_TIME;
	}
	_tmp3_ = g_ptr_array_new_with_free_func (_tracker_store_task_unref0_);
	_tmp4_ = _tmp3_;
	_g_ptr_array_unref0 (tracker_store_running_tasks);
	tracker_store_running_tasks = _tmp4_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				GQueue* _tmp6_ = NULL;
				GQueue* _tmp7_;
				GQueue* _tmp8_ = NULL;
				GQueue* _tmp9_;
				if (!_tmp5_) {
					i++;
				}
				_tmp5_ = FALSE;
				if (!(i < TRACKER_STORE_PRIORITY_N_PRIORITIES)) {
					break;
				}
				_tmp6_ = g_queue_new ();
				_tmp7_ = _tmp6_;
				_g_queue_free0 (tracker_store_query_queues[i]);
				tracker_store_query_queues[i] = _tmp7_;
				_tmp8_ = g_queue_new ();
				_tmp9_ = _tmp8_;
				_g_queue_free0 (tracker_store_update_queues[i]);
				tracker_store_update_queues[i] = _tmp9_;
			}
		}
	}
	_tmp10_ = g_thread_pool_new (_tracker_store_pool_dispatch_cb_gfunc, NULL, 1, TRUE, &_inner_error_);
	_tmp11_ = _tmp10_;
	if (_inner_error_ != NULL) {
		goto __catch22_g_error;
	}
	_tmp12_ = _tmp11_;
	_g_thread_pool_free0 (tracker_store_update_pool);
	tracker_store_update_pool = _tmp12_;
	_tmp13_ = g_thread_pool_new (_tracker_store_pool_dispatch_cb_gfunc, NULL, TRACKER_STORE_MAX_CONCURRENT_QUERIES, TRUE, &_inner_error_);
	_tmp14_ = _tmp13_;
	if (_inner_error_ != NULL) {
		goto __catch22_g_error;
	}
	_tmp15_ = _tmp14_;
	_g_thread_pool_free0 (tracker_store_query_pool);
	tracker_store_query_pool = _tmp15_;
	goto __finally22;
	__catch22_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("%s", e->message);
		_g_error_free0 (e);
	}
	__finally22:
	if (_inner_error_ != NULL) {
		_g_free0 (max_task_time_env);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_thread_pool_set_max_idle_time ((guint) (15 * 1000));
	g_thread_pool_set_max_unused_threads (2);
	_g_free0 (max_task_time_env);
}


void tracker_store_shutdown (void) {
	GThreadPool* _tmp0_;
	GThreadPool* _tmp1_;
	_tmp0_ = NULL;
	_g_thread_pool_free0 (tracker_store_query_pool);
	tracker_store_query_pool = _tmp0_;
	_tmp1_ = NULL;
	_g_thread_pool_free0 (tracker_store_update_pool);
	tracker_store_update_pool = _tmp1_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				GQueue* _tmp3_;
				GQueue* _tmp4_;
				if (!_tmp2_) {
					i++;
				}
				_tmp2_ = FALSE;
				if (!(i < TRACKER_STORE_PRIORITY_N_PRIORITIES)) {
					break;
				}
				_tmp3_ = NULL;
				_g_queue_free0 (tracker_store_query_queues[i]);
				tracker_store_query_queues[i] = _tmp3_;
				_tmp4_ = NULL;
				_g_queue_free0 (tracker_store_update_queues[i]);
				tracker_store_update_queues[i] = _tmp4_;
			}
		}
	}
}


static void tracker_store_sparql_query_data_free (gpointer _data) {
	TrackerStoreSparqlQueryData* data;
	data = _data;
	_g_free0 (data->sparql);
	(data->in_thread_target_destroy_notify == NULL) ? NULL : (data->in_thread_target_destroy_notify (data->in_thread_target), NULL);
	data->in_thread = NULL;
	data->in_thread_target = NULL;
	data->in_thread_target_destroy_notify = NULL;
	_g_free0 (data->client_id);
	g_slice_free (TrackerStoreSparqlQueryData, data);
}


void tracker_store_sparql_query (const gchar* sparql, TrackerStorePriority priority, TrackerStoreSparqlQueryInThread in_thread, void* in_thread_target, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStoreSparqlQueryData* _data_;
	_data_ = g_slice_new0 (TrackerStoreSparqlQueryData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_store_sparql_query);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_store_sparql_query_data_free);
	_data_->sparql = g_strdup (sparql);
	_data_->priority = priority;
	_data_->in_thread = in_thread;
	_data_->in_thread_target = in_thread_target;
	_data_->client_id = g_strdup (client_id);
	tracker_store_sparql_query_co (_data_);
}


void tracker_store_sparql_query_finish (GAsyncResult* _res_, GError** error) {
	TrackerStoreSparqlQueryData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean _tracker_store_sparql_query_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_sparql_query_co (self);
	return result;
}


static gboolean tracker_store_sparql_query_co (TrackerStoreSparqlQueryData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_store_query_task_new ();
	data->task = data->_tmp0_;
	((TrackerStoreTask*) data->task)->type = TRACKER_STORE_TASK_TYPE_QUERY;
	data->_tmp1_ = g_strdup (data->sparql);
	data->_tmp2_ = data->_tmp1_;
	_g_free0 (data->task->query);
	data->task->query = data->_tmp2_;
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_cancellable_new ();
	data->_tmp4_ = data->_tmp3_;
	_g_object_unref0 (data->task->cancellable);
	data->task->cancellable = data->_tmp4_;
	data->_tmp5_ = data->in_thread;
	data->_tmp6_ = data->_tmp5_;
	(data->task->in_thread_target_destroy_notify == NULL) ? NULL : (data->task->in_thread_target_destroy_notify (data->task->in_thread_target), NULL);
	data->task->in_thread = NULL;
	data->task->in_thread_target = NULL;
	data->task->in_thread_target_destroy_notify = NULL;
	data->task->in_thread_target = data->in_thread_target;
	data->task->in_thread_target_destroy_notify = data->in_thread_target_destroy_notify;
	data->task->in_thread = data->_tmp6_;
	data->_tmp7_ = _tracker_store_sparql_query_co_gsource_func;
	(((TrackerStoreTask*) data->task)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) data->task)->callback_target_destroy_notify (((TrackerStoreTask*) data->task)->callback_target), NULL);
	((TrackerStoreTask*) data->task)->callback = NULL;
	((TrackerStoreTask*) data->task)->callback_target = NULL;
	((TrackerStoreTask*) data->task)->callback_target_destroy_notify = NULL;
	((TrackerStoreTask*) data->task)->callback_target = data;
	((TrackerStoreTask*) data->task)->callback_target_destroy_notify = NULL;
	((TrackerStoreTask*) data->task)->callback = data->_tmp7_;
	data->_tmp8_ = g_strdup (data->client_id);
	data->_tmp9_ = data->_tmp8_;
	_g_free0 (((TrackerStoreTask*) data->task)->client_id);
	((TrackerStoreTask*) data->task)->client_id = data->_tmp9_;
	data->_tmp10_ = _tracker_store_task_ref0 ((TrackerStoreTask*) data->task);
	g_queue_push_tail (tracker_store_query_queues[data->priority], data->_tmp10_);
	tracker_store_sched ();
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	if (((TrackerStoreTask*) data->task)->error != NULL) {
		data->_tmp11_ = _g_error_copy0 (((TrackerStoreTask*) data->task)->error);
		data->_inner_error_ = data->_tmp11_;
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_tracker_store_task_unref0 (data->task);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_tracker_store_task_unref0 (data->task);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_store_sparql_update_data_free (gpointer _data) {
	TrackerStoreSparqlUpdateData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_free0 (data->client_id);
	g_slice_free (TrackerStoreSparqlUpdateData, data);
}


void tracker_store_sparql_update (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStoreSparqlUpdateData* _data_;
	_data_ = g_slice_new0 (TrackerStoreSparqlUpdateData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_store_sparql_update);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_store_sparql_update_data_free);
	_data_->sparql = g_strdup (sparql);
	_data_->priority = priority;
	_data_->client_id = g_strdup (client_id);
	tracker_store_sparql_update_co (_data_);
}


void tracker_store_sparql_update_finish (GAsyncResult* _res_, GError** error) {
	TrackerStoreSparqlUpdateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean _tracker_store_sparql_update_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_sparql_update_co (self);
	return result;
}


static gboolean tracker_store_sparql_update_co (TrackerStoreSparqlUpdateData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_store_update_task_new ();
	data->task = data->_tmp0_;
	((TrackerStoreTask*) data->task)->type = TRACKER_STORE_TASK_TYPE_UPDATE;
	data->_tmp1_ = g_strdup (data->sparql);
	data->_tmp2_ = data->_tmp1_;
	_g_free0 (data->task->query);
	data->task->query = data->_tmp2_;
	data->task->priority = data->priority;
	data->_tmp3_ = _tracker_store_sparql_update_co_gsource_func;
	(((TrackerStoreTask*) data->task)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) data->task)->callback_target_destroy_notify (((TrackerStoreTask*) data->task)->callback_target), NULL);
	((TrackerStoreTask*) data->task)->callback = NULL;
	((TrackerStoreTask*) data->task)->callback_target = NULL;
	((TrackerStoreTask*) data->task)->callback_target_destroy_notify = NULL;
	((TrackerStoreTask*) data->task)->callback_target = data;
	((TrackerStoreTask*) data->task)->callback_target_destroy_notify = NULL;
	((TrackerStoreTask*) data->task)->callback = data->_tmp3_;
	data->_tmp4_ = g_strdup (data->client_id);
	data->_tmp5_ = data->_tmp4_;
	_g_free0 (((TrackerStoreTask*) data->task)->client_id);
	((TrackerStoreTask*) data->task)->client_id = data->_tmp5_;
	data->_tmp6_ = _tracker_store_task_ref0 ((TrackerStoreTask*) data->task);
	g_queue_push_tail (tracker_store_update_queues[data->priority], data->_tmp6_);
	tracker_store_sched ();
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	if (((TrackerStoreTask*) data->task)->error != NULL) {
		data->_tmp7_ = _g_error_copy0 (((TrackerStoreTask*) data->task)->error);
		data->_inner_error_ = data->_tmp7_;
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_tracker_store_task_unref0 (data->task);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_tracker_store_task_unref0 (data->task);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_store_sparql_update_blank_data_free (gpointer _data) {
	TrackerStoreSparqlUpdateBlankData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_free0 (data->client_id);
	_g_ptr_array_unref0 (data->result);
	g_slice_free (TrackerStoreSparqlUpdateBlankData, data);
}


void tracker_store_sparql_update_blank (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStoreSparqlUpdateBlankData* _data_;
	_data_ = g_slice_new0 (TrackerStoreSparqlUpdateBlankData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_store_sparql_update_blank);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_store_sparql_update_blank_data_free);
	_data_->sparql = g_strdup (sparql);
	_data_->priority = priority;
	_data_->client_id = g_strdup (client_id);
	tracker_store_sparql_update_blank_co (_data_);
}


GPtrArray* tracker_store_sparql_update_blank_finish (GAsyncResult* _res_, GError** error) {
	GPtrArray* result;
	TrackerStoreSparqlUpdateBlankData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean _tracker_store_sparql_update_blank_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_sparql_update_blank_co (self);
	return result;
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static gboolean tracker_store_sparql_update_blank_co (TrackerStoreSparqlUpdateBlankData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_store_update_task_new ();
	data->task = data->_tmp0_;
	((TrackerStoreTask*) data->task)->type = TRACKER_STORE_TASK_TYPE_UPDATE_BLANK;
	data->_tmp1_ = g_strdup (data->sparql);
	data->_tmp2_ = data->_tmp1_;
	_g_free0 (data->task->query);
	data->task->query = data->_tmp2_;
	data->task->priority = data->priority;
	data->_tmp3_ = _tracker_store_sparql_update_blank_co_gsource_func;
	(((TrackerStoreTask*) data->task)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) data->task)->callback_target_destroy_notify (((TrackerStoreTask*) data->task)->callback_target), NULL);
	((TrackerStoreTask*) data->task)->callback = NULL;
	((TrackerStoreTask*) data->task)->callback_target = NULL;
	((TrackerStoreTask*) data->task)->callback_target_destroy_notify = NULL;
	((TrackerStoreTask*) data->task)->callback_target = data;
	((TrackerStoreTask*) data->task)->callback_target_destroy_notify = NULL;
	((TrackerStoreTask*) data->task)->callback = data->_tmp3_;
	data->_tmp4_ = g_strdup (data->client_id);
	data->_tmp5_ = data->_tmp4_;
	_g_free0 (((TrackerStoreTask*) data->task)->client_id);
	((TrackerStoreTask*) data->task)->client_id = data->_tmp5_;
	data->_tmp6_ = _tracker_store_task_ref0 ((TrackerStoreTask*) data->task);
	g_queue_push_tail (tracker_store_update_queues[data->priority], data->_tmp6_);
	tracker_store_sched ();
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	if (((TrackerStoreTask*) data->task)->error != NULL) {
		data->_tmp7_ = _g_error_copy0 (((TrackerStoreTask*) data->task)->error);
		data->_inner_error_ = data->_tmp7_;
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_tracker_store_task_unref0 (data->task);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp8_ = _g_ptr_array_ref0 (data->task->blank_nodes);
	data->result = data->_tmp8_;
	_tracker_store_task_unref0 (data->task);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_tracker_store_task_unref0 (data->task);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_store_queue_turtle_import_data_free (gpointer _data) {
	TrackerStoreQueueTurtleImportData* data;
	data = _data;
	_g_object_unref0 (data->file);
	_g_free0 (data->client_id);
	g_slice_free (TrackerStoreQueueTurtleImportData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void tracker_store_queue_turtle_import (GFile* file, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStoreQueueTurtleImportData* _data_;
	_data_ = g_slice_new0 (TrackerStoreQueueTurtleImportData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_store_queue_turtle_import);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_store_queue_turtle_import_data_free);
	_data_->file = _g_object_ref0 (file);
	_data_->client_id = g_strdup (client_id);
	tracker_store_queue_turtle_import_co (_data_);
}


void tracker_store_queue_turtle_import_finish (GAsyncResult* _res_, GError** error) {
	TrackerStoreQueueTurtleImportData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean _tracker_store_queue_turtle_import_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_queue_turtle_import_co (self);
	return result;
}


static gboolean tracker_store_queue_turtle_import_co (TrackerStoreQueueTurtleImportData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_store_turtle_task_new ();
	data->task = data->_tmp0_;
	((TrackerStoreTask*) data->task)->type = TRACKER_STORE_TASK_TYPE_TURTLE;
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_file_get_path (data->file);
	data->_tmp2_ = data->_tmp1_;
	_g_free0 (data->task->path);
	data->task->path = data->_tmp2_;
	data->_tmp3_ = _tracker_store_queue_turtle_import_co_gsource_func;
	(((TrackerStoreTask*) data->task)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) data->task)->callback_target_destroy_notify (((TrackerStoreTask*) data->task)->callback_target), NULL);
	((TrackerStoreTask*) data->task)->callback = NULL;
	((TrackerStoreTask*) data->task)->callback_target = NULL;
	((TrackerStoreTask*) data->task)->callback_target_destroy_notify = NULL;
	((TrackerStoreTask*) data->task)->callback_target = data;
	((TrackerStoreTask*) data->task)->callback_target_destroy_notify = NULL;
	((TrackerStoreTask*) data->task)->callback = data->_tmp3_;
	data->_tmp4_ = g_strdup (data->client_id);
	data->_tmp5_ = data->_tmp4_;
	_g_free0 (((TrackerStoreTask*) data->task)->client_id);
	((TrackerStoreTask*) data->task)->client_id = data->_tmp5_;
	data->_tmp6_ = _tracker_store_task_ref0 ((TrackerStoreTask*) data->task);
	g_queue_push_tail (tracker_store_update_queues[TRACKER_STORE_PRIORITY_TURTLE], data->_tmp6_);
	tracker_store_sched ();
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	if (((TrackerStoreTask*) data->task)->error != NULL) {
		data->_tmp7_ = _g_error_copy0 (((TrackerStoreTask*) data->task)->error);
		data->_inner_error_ = data->_tmp7_;
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_tracker_store_task_unref0 (data->task);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_tracker_store_task_unref0 (data->task);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


guint tracker_store_get_queue_size (TrackerStore* self) {
	guint result = 0U;
	guint _result_;
	g_return_val_if_fail (self != NULL, 0U);
	_result_ = (guint) 0;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint _tmp1_;
				guint _tmp2_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < TRACKER_STORE_PRIORITY_N_PRIORITIES)) {
					break;
				}
				_tmp1_ = g_queue_get_length (tracker_store_query_queues[i]);
				_result_ = _result_ + _tmp1_;
				_tmp2_ = g_queue_get_length (tracker_store_update_queues[i]);
				_result_ = _result_ + _tmp2_;
			}
		}
	}
	result = _result_;
	return result;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	g_return_if_fail (self != NULL);
	g_ptr_array_set_size (self, value);
}


void tracker_store_unreg_batches (const gchar* client_id) {
	GList* list;
	GList* cur;
	GQueue* queue;
	g_return_if_fail (client_id != NULL);
	list = NULL;
	cur = NULL;
	queue = NULL;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp1_;
				gconstpointer _tmp2_ = NULL;
				TrackerStoreTask* _tmp3_;
				TrackerStoreQueryTask* task;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				_tmp1_ = g_ptr_array_get_length (tracker_store_running_tasks);
				if (!(i < _tmp1_)) {
					break;
				}
				_tmp2_ = g_ptr_array_index (tracker_store_running_tasks, (guint) i);
				task = (_tmp3_ = (TrackerStoreTask*) _tmp2_, TRACKER_STORE_IS_QUERY_TASK (_tmp3_) ? ((TrackerStoreQueryTask*) _tmp3_) : NULL);
				if (task != NULL) {
					_tmp5_ = g_strcmp0 (((TrackerStoreTask*) task)->client_id, client_id) == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					_tmp4_ = task->cancellable != NULL;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					g_cancellable_cancel (task->cancellable);
				}
			}
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				if (!_tmp6_) {
					i++;
				}
				_tmp6_ = FALSE;
				if (!(i < TRACKER_STORE_PRIORITY_N_PRIORITIES)) {
					break;
				}
				queue = tracker_store_query_queues[i];
				list = queue->head;
				while (TRUE) {
					TrackerStoreTask* task;
					gboolean _tmp7_ = FALSE;
					if (!(list != NULL)) {
						break;
					}
					cur = list;
					list = list->next;
					task = (TrackerStoreTask*) cur->data;
					if (task != NULL) {
						_tmp7_ = g_strcmp0 (task->client_id, client_id) == 0;
					} else {
						_tmp7_ = FALSE;
					}
					if (_tmp7_) {
						GError* _tmp8_ = NULL;
						GError* _tmp9_;
						g_queue_delete_link (queue, cur);
						_tmp8_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "Client disappeared");
						_tmp9_ = _tmp8_;
						_g_error_free0 (task->error);
						task->error = _tmp9_;
						task->callback (task->callback_target);
					}
				}
				queue = tracker_store_update_queues[i];
				list = queue->head;
				while (TRUE) {
					TrackerStoreTask* task;
					gboolean _tmp10_ = FALSE;
					if (!(list != NULL)) {
						break;
					}
					cur = list;
					list = list->next;
					task = (TrackerStoreTask*) cur->data;
					if (task != NULL) {
						_tmp10_ = g_strcmp0 (task->client_id, client_id) == 0;
					} else {
						_tmp10_ = FALSE;
					}
					if (_tmp10_) {
						GError* _tmp11_ = NULL;
						GError* _tmp12_;
						g_queue_delete_link (queue, cur);
						_tmp11_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "Client disappeared");
						_tmp12_ = _tmp11_;
						_g_error_free0 (task->error);
						task->error = _tmp12_;
						task->callback (task->callback_target);
					}
				}
			}
		}
	}
	tracker_store_sched ();
}


static void tracker_store_pause_data_free (gpointer _data) {
	TrackerStorePauseData* data;
	data = _data;
	g_slice_free (TrackerStorePauseData, data);
}


void tracker_store_pause (GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStorePauseData* _data_;
	_data_ = g_slice_new0 (TrackerStorePauseData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_store_pause);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_store_pause_data_free);
	tracker_store_pause_co (_data_);
}


void tracker_store_pause_finish (GAsyncResult* _res_) {
	TrackerStorePauseData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean _tracker_store_pause_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_pause_co (self);
	return result;
}


static gboolean tracker_store_pause_co (TrackerStorePauseData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	tracker_store_active = FALSE;
	if (tracker_store_n_queries_running > 0) {
		data->_tmp0_ = TRUE;
	} else {
		data->_tmp0_ = tracker_store_update_running;
	}
	if (data->_tmp0_) {
		data->_tmp1_ = _tracker_store_pause_co_gsource_func;
		(tracker_store_active_callback_target_destroy_notify == NULL) ? NULL : (tracker_store_active_callback_target_destroy_notify (tracker_store_active_callback_target), NULL);
		tracker_store_active_callback = NULL;
		tracker_store_active_callback_target = NULL;
		tracker_store_active_callback_target_destroy_notify = NULL;
		tracker_store_active_callback_target = data;
		tracker_store_active_callback_target_destroy_notify = NULL;
		tracker_store_active_callback = data->_tmp1_;
		data->_state_ = 1;
		return FALSE;
		_state_1:
		;
		data->_tmp2_ = NULL;
		(tracker_store_active_callback_target_destroy_notify == NULL) ? NULL : (tracker_store_active_callback_target_destroy_notify (tracker_store_active_callback_target), NULL);
		tracker_store_active_callback = NULL;
		tracker_store_active_callback_target = NULL;
		tracker_store_active_callback_target_destroy_notify = NULL;
		tracker_store_active_callback_target = NULL;
		tracker_store_active_callback_target_destroy_notify = NULL;
		tracker_store_active_callback = data->_tmp2_;
	}
	if (tracker_store_active) {
		tracker_store_sched ();
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


void tracker_store_resume (void) {
	tracker_store_active = TRUE;
	tracker_store_sched ();
}


TrackerStore* tracker_store_construct (GType object_type) {
	TrackerStore* self = NULL;
	self = (TrackerStore*) g_type_create_instance (object_type);
	return self;
}


TrackerStore* tracker_store_new (void) {
	return tracker_store_construct (TRACKER_TYPE_STORE);
}


static TrackerStoreTask* tracker_store_task_construct (GType object_type) {
	TrackerStoreTask* self = NULL;
	self = (TrackerStoreTask*) g_type_create_instance (object_type);
	return self;
}


static void tracker_store_value_task_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void tracker_store_value_task_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		tracker_store_task_unref (value->data[0].v_pointer);
	}
}


static void tracker_store_value_task_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tracker_store_task_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer tracker_store_value_task_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* tracker_store_value_task_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TrackerStoreTask* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tracker_store_task_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* tracker_store_value_task_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerStoreTask** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tracker_store_task_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* tracker_store_param_spec_task (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerStoreParamSpecTask* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_STORE_TYPE_TASK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer tracker_store_value_get_task (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_TASK), NULL);
	return value->data[0].v_pointer;
}


static void tracker_store_value_set_task (GValue* value, gpointer v_object) {
	TrackerStoreTask* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_TASK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_STORE_TYPE_TASK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tracker_store_task_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_store_task_unref (old);
	}
}


static void tracker_store_value_take_task (GValue* value, gpointer v_object) {
	TrackerStoreTask* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_TASK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_STORE_TYPE_TASK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_store_task_unref (old);
	}
}


static void tracker_store_task_class_init (TrackerStoreTaskClass * klass) {
	tracker_store_task_parent_class = g_type_class_peek_parent (klass);
	TRACKER_STORE_TASK_CLASS (klass)->finalize = tracker_store_task_finalize;
}


static void tracker_store_task_instance_init (TrackerStoreTask * self) {
	self->ref_count = 1;
}


static void tracker_store_task_finalize (TrackerStoreTask* obj) {
	TrackerStoreTask * self;
	self = TRACKER_STORE_TASK (obj);
	_g_free0 (self->client_id);
	_g_error_free0 (self->error);
	(self->callback_target_destroy_notify == NULL) ? NULL : (self->callback_target_destroy_notify (self->callback_target), NULL);
	self->callback = NULL;
	self->callback_target = NULL;
	self->callback_target_destroy_notify = NULL;
}


static GType tracker_store_task_get_type (void) {
	static volatile gsize tracker_store_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_task_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_store_value_task_init, tracker_store_value_task_free_value, tracker_store_value_task_copy_value, tracker_store_value_task_peek_pointer, "p", tracker_store_value_task_collect_value, "p", tracker_store_value_task_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreTask), 0, (GInstanceInitFunc) tracker_store_task_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_store_task_type_id;
		tracker_store_task_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerStoreTask", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&tracker_store_task_type_id__volatile, tracker_store_task_type_id);
	}
	return tracker_store_task_type_id__volatile;
}


static gpointer tracker_store_task_ref (gpointer instance) {
	TrackerStoreTask* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void tracker_store_task_unref (gpointer instance) {
	TrackerStoreTask* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TRACKER_STORE_TASK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static TrackerStoreQueryTask* tracker_store_query_task_construct (GType object_type) {
	TrackerStoreQueryTask* self = NULL;
	self = (TrackerStoreQueryTask*) tracker_store_task_construct (object_type);
	return self;
}


static TrackerStoreQueryTask* tracker_store_query_task_new (void) {
	return tracker_store_query_task_construct (TRACKER_STORE_TYPE_QUERY_TASK);
}


static void tracker_store_query_task_class_init (TrackerStoreQueryTaskClass * klass) {
	tracker_store_query_task_parent_class = g_type_class_peek_parent (klass);
	TRACKER_STORE_TASK_CLASS (klass)->finalize = tracker_store_query_task_finalize;
}


static void tracker_store_query_task_instance_init (TrackerStoreQueryTask * self) {
}


static void tracker_store_query_task_finalize (TrackerStoreTask* obj) {
	TrackerStoreQueryTask * self;
	self = TRACKER_STORE_QUERY_TASK (obj);
	if (self->watchdog_id > 0) {
		g_source_remove (self->watchdog_id);
	}
	_g_free0 (self->query);
	_g_object_unref0 (self->cancellable);
	(self->in_thread_target_destroy_notify == NULL) ? NULL : (self->in_thread_target_destroy_notify (self->in_thread_target), NULL);
	self->in_thread = NULL;
	self->in_thread_target = NULL;
	self->in_thread_target_destroy_notify = NULL;
	TRACKER_STORE_TASK_CLASS (tracker_store_query_task_parent_class)->finalize (obj);
}


static GType tracker_store_query_task_get_type (void) {
	static volatile gsize tracker_store_query_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_query_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreQueryTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_query_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreQueryTask), 0, (GInstanceInitFunc) tracker_store_query_task_instance_init, NULL };
		GType tracker_store_query_task_type_id;
		tracker_store_query_task_type_id = g_type_register_static (TRACKER_STORE_TYPE_TASK, "TrackerStoreQueryTask", &g_define_type_info, 0);
		g_once_init_leave (&tracker_store_query_task_type_id__volatile, tracker_store_query_task_type_id);
	}
	return tracker_store_query_task_type_id__volatile;
}


static TrackerStoreUpdateTask* tracker_store_update_task_construct (GType object_type) {
	TrackerStoreUpdateTask* self = NULL;
	self = (TrackerStoreUpdateTask*) tracker_store_task_construct (object_type);
	return self;
}


static TrackerStoreUpdateTask* tracker_store_update_task_new (void) {
	return tracker_store_update_task_construct (TRACKER_STORE_TYPE_UPDATE_TASK);
}


static void tracker_store_update_task_class_init (TrackerStoreUpdateTaskClass * klass) {
	tracker_store_update_task_parent_class = g_type_class_peek_parent (klass);
	TRACKER_STORE_TASK_CLASS (klass)->finalize = tracker_store_update_task_finalize;
}


static void tracker_store_update_task_instance_init (TrackerStoreUpdateTask * self) {
}


static void tracker_store_update_task_finalize (TrackerStoreTask* obj) {
	TrackerStoreUpdateTask * self;
	self = TRACKER_STORE_UPDATE_TASK (obj);
	_g_free0 (self->query);
	_g_ptr_array_unref0 (self->blank_nodes);
	TRACKER_STORE_TASK_CLASS (tracker_store_update_task_parent_class)->finalize (obj);
}


static GType tracker_store_update_task_get_type (void) {
	static volatile gsize tracker_store_update_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_update_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreUpdateTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_update_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreUpdateTask), 0, (GInstanceInitFunc) tracker_store_update_task_instance_init, NULL };
		GType tracker_store_update_task_type_id;
		tracker_store_update_task_type_id = g_type_register_static (TRACKER_STORE_TYPE_TASK, "TrackerStoreUpdateTask", &g_define_type_info, 0);
		g_once_init_leave (&tracker_store_update_task_type_id__volatile, tracker_store_update_task_type_id);
	}
	return tracker_store_update_task_type_id__volatile;
}


static TrackerStoreTurtleTask* tracker_store_turtle_task_construct (GType object_type) {
	TrackerStoreTurtleTask* self = NULL;
	self = (TrackerStoreTurtleTask*) tracker_store_task_construct (object_type);
	return self;
}


static TrackerStoreTurtleTask* tracker_store_turtle_task_new (void) {
	return tracker_store_turtle_task_construct (TRACKER_STORE_TYPE_TURTLE_TASK);
}


static void tracker_store_turtle_task_class_init (TrackerStoreTurtleTaskClass * klass) {
	tracker_store_turtle_task_parent_class = g_type_class_peek_parent (klass);
	TRACKER_STORE_TASK_CLASS (klass)->finalize = tracker_store_turtle_task_finalize;
}


static void tracker_store_turtle_task_instance_init (TrackerStoreTurtleTask * self) {
}


static void tracker_store_turtle_task_finalize (TrackerStoreTask* obj) {
	TrackerStoreTurtleTask * self;
	self = TRACKER_STORE_TURTLE_TASK (obj);
	_g_free0 (self->path);
	TRACKER_STORE_TASK_CLASS (tracker_store_turtle_task_parent_class)->finalize (obj);
}


static GType tracker_store_turtle_task_get_type (void) {
	static volatile gsize tracker_store_turtle_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_turtle_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreTurtleTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_turtle_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreTurtleTask), 0, (GInstanceInitFunc) tracker_store_turtle_task_instance_init, NULL };
		GType tracker_store_turtle_task_type_id;
		tracker_store_turtle_task_type_id = g_type_register_static (TRACKER_STORE_TYPE_TASK, "TrackerStoreTurtleTask", &g_define_type_info, 0);
		g_once_init_leave (&tracker_store_turtle_task_type_id__volatile, tracker_store_turtle_task_type_id);
	}
	return tracker_store_turtle_task_type_id__volatile;
}


static void tracker_value_store_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void tracker_value_store_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		tracker_store_unref (value->data[0].v_pointer);
	}
}


static void tracker_value_store_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tracker_store_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer tracker_value_store_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* tracker_value_store_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TrackerStore* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tracker_store_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* tracker_value_store_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerStore** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tracker_store_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* tracker_param_spec_store (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerParamSpecStore* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_STORE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer tracker_value_get_store (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE), NULL);
	return value->data[0].v_pointer;
}


void tracker_value_set_store (GValue* value, gpointer v_object) {
	TrackerStore* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_STORE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tracker_store_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_store_unref (old);
	}
}


void tracker_value_take_store (GValue* value, gpointer v_object) {
	TrackerStore* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_STORE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_store_unref (old);
	}
}


static void tracker_store_class_init (TrackerStoreClass * klass) {
	tracker_store_parent_class = g_type_class_peek_parent (klass);
	TRACKER_STORE_CLASS (klass)->finalize = tracker_store_finalize;
}


static void tracker_store_instance_init (TrackerStore * self) {
	self->ref_count = 1;
}


static void tracker_store_finalize (TrackerStore* obj) {
	TrackerStore * self;
	self = TRACKER_STORE (obj);
}


GType tracker_store_get_type (void) {
	static volatile gsize tracker_store_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_value_store_init, tracker_value_store_free_value, tracker_value_store_copy_value, tracker_value_store_peek_pointer, "p", tracker_value_store_collect_value, "p", tracker_value_store_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStore), 0, (GInstanceInitFunc) tracker_store_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_store_type_id;
		tracker_store_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerStore", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_store_type_id__volatile, tracker_store_type_id);
	}
	return tracker_store_type_id__volatile;
}


gpointer tracker_store_ref (gpointer instance) {
	TrackerStore* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void tracker_store_unref (gpointer instance) {
	TrackerStore* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TRACKER_STORE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



