/* tracker-metadata-tile.c generated by valac, the Vala compiler
 * generated from tracker-metadata-tile.gs, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>
#include <gdk-pixbuf/gdk-pixdata.h>


#define TYPE_TRACKER_METADATA_TILE (tracker_metadata_tile_get_type ())
#define TRACKER_METADATA_TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTile))
#define TRACKER_METADATA_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTileClass))
#define IS_TRACKER_METADATA_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_METADATA_TILE))
#define IS_TRACKER_METADATA_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_METADATA_TILE))
#define TRACKER_METADATA_TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTileClass))

typedef struct _TrackerMetadataTile TrackerMetadataTile;
typedef struct _TrackerMetadataTileClass TrackerMetadataTileClass;
typedef struct _TrackerMetadataTilePrivate TrackerMetadataTilePrivate;

#define TYPE_CATEGORIES (categories_get_type ())

#define TYPE_TRACKER_RESULT_GRID (tracker_result_grid_get_type ())
#define TRACKER_RESULT_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_RESULT_GRID, TrackerResultGrid))
#define TRACKER_RESULT_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_RESULT_GRID, TrackerResultGridClass))
#define IS_TRACKER_RESULT_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_RESULT_GRID))
#define IS_TRACKER_RESULT_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_RESULT_GRID))
#define TRACKER_RESULT_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_RESULT_GRID, TrackerResultGridClass))

typedef struct _TrackerResultGrid TrackerResultGrid;
typedef struct _TrackerResultGridClass TrackerResultGridClass;

#define TYPE_TRACKER_QUERY (tracker_query_get_type ())
#define TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_QUERY, TrackerQuery))
#define TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_QUERY, TrackerQueryClass))
#define IS_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_QUERY))
#define IS_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_QUERY))
#define TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_QUERY, TrackerQueryClass))

typedef struct _TrackerQuery TrackerQuery;
typedef struct _TrackerQueryClass TrackerQueryClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerResultGridPrivate TrackerResultGridPrivate;

#define TYPE_RESULT_COLUMNS (result_columns_get_type ())

typedef enum  {
	CATEGORIES_Application,
	CATEGORIES_Contact,
	CATEGORIES_Email,
	CATEGORIES_EmailAttachment,
	CATEGORIES_File,
	CATEGORIES_Folder,
	CATEGORIES_Audio,
	CATEGORIES_Video,
	CATEGORIES_Image,
	CATEGORIES_Document,
	CATEGORIES_Text,
	CATEGORIES_Development,
	CATEGORIES_Web,
	CATEGORIES_WebHistory
} Categories;

struct _TrackerMetadataTile {
	GtkEventBox parent_instance;
	TrackerMetadataTilePrivate * priv;
	char* uri;
	Categories category;
	GtkImage* image;
	GtkLinkButton* name_link;
	GtkLinkButton* path_link;
	GtkTable* table;
	GtkLabel* name_label;
	GtkLabel* path_label;
	GtkLabel* info_label1;
	GtkLabel* info_value1;
	GtkLabel* info_label2;
	GtkLabel* info_value2;
	GtkLabel* info_label3;
	GtkLabel* info_value3;
	GtkLabel* info_label4;
	GtkLabel* info_value4;
	GtkLabel* info_label5;
	GtkLabel* info_value5;
	GtkLabel* info_label6;
	GtkLabel* info_value6;
};

struct _TrackerMetadataTileClass {
	GtkEventBoxClass parent_class;
};

struct _TrackerMetadataTilePrivate {
	TrackerResultGrid* _result_grid;
	TrackerQuery* _Query;
};

struct _TrackerResultGrid {
	GtkScrolledWindow parent_instance;
	TrackerResultGridPrivate * priv;
	GtkListStore* store;
	GtkIconView* iconview;
};

struct _TrackerResultGridClass {
	GtkScrolledWindowClass parent_class;
};

typedef enum  {
	RESULT_COLUMNS_Id,
	RESULT_COLUMNS_Uri,
	RESULT_COLUMNS_Icon,
	RESULT_COLUMNS_DisplayName,
	RESULT_COLUMNS_Mime,
	RESULT_COLUMNS_Category,
	RESULT_COLUMNS_Snippet,
	RESULT_COLUMNS_IsDirectory,
	RESULT_COLUMNS_Path,
	RESULT_COLUMNS_NumOfCols
} ResultColumns;


static gpointer tracker_metadata_tile_parent_class = NULL;

GType tracker_metadata_tile_get_type (void) G_GNUC_CONST;
GType categories_get_type (void) G_GNUC_CONST;
GType tracker_result_grid_get_type (void) G_GNUC_CONST;
GType tracker_query_get_type (void) G_GNUC_CONST;
#define TRACKER_METADATA_TILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTilePrivate))
enum  {
	TRACKER_METADATA_TILE_DUMMY_PROPERTY,
	TRACKER_METADATA_TILE_QUERY,
	TRACKER_METADATA_TILE_RESULT_GRID
};
static gboolean tracker_metadata_tile_expose (TrackerMetadataTile* self, GdkEventExpose* e);
static void tracker_metadata_tile_AttachToTable (TrackerMetadataTile* self, GtkLabel* lab, gint l, gint r, gint t, gint b, gboolean e);
static GtkLabel* tracker_metadata_tile_CreateLabel (TrackerMetadataTile* self, const char* s, gboolean e);
void tracker_metadata_tile_ClearLabels (TrackerMetadataTile* self);
void tracker_metadata_tile_SetLabelValue (TrackerMetadataTile* self, GtkLabel* label, const char* val);
char* tracker_utils_FormatFileSize (gint64 size);
void tracker_metadata_tile_SetLabelSizeValue (TrackerMetadataTile* self, GtkLabel* label, gint64 size);
void tracker_metadata_tile_SetLabelUrnValue (TrackerMetadataTile* self, GtkLabel* label, const char* val);
TrackerQuery* tracker_metadata_tile_get_Query (TrackerMetadataTile* self);
char** tracker_query_Query (TrackerQuery* self, const char* sparql, int* result_length1, int* result_length2);
static Categories tracker_metadata_tile_GetCategory (TrackerMetadataTile* self, const char* uri);
static void tracker_metadata_tile_DisplayFileDetails (TrackerMetadataTile* self, const char* uri, const char* mime);
static void tracker_metadata_tile_DisplayImageDetails (TrackerMetadataTile* self, const char* uri);
static void tracker_metadata_tile_DisplayAudioDetails (TrackerMetadataTile* self, const char* uri);
static void tracker_metadata_tile_DisplayVideoDetails (TrackerMetadataTile* self, const char* uri);
static void tracker_metadata_tile_DisplayEmailDetails (TrackerMetadataTile* self, const char* uri);
static void tracker_metadata_tile_DisplayDocumentDetails (TrackerMetadataTile* self, const char* uri);
static void tracker_metadata_tile_DisplayApplicationDetails (TrackerMetadataTile* self, const char* uri);
GType result_columns_get_type (void) G_GNUC_CONST;
void tracker_metadata_tile_LoadUri (TrackerMetadataTile* self, GtkTreePath* path);
TrackerMetadataTile* tracker_metadata_tile_new (void);
TrackerMetadataTile* tracker_metadata_tile_construct (GType object_type);
void tracker_metadata_tile_set_Query (TrackerMetadataTile* self, TrackerQuery* value);
TrackerResultGrid* tracker_metadata_tile_get_ResultGrid (TrackerMetadataTile* self);
static void _lambda6_ (GtkTreePath* path, TrackerMetadataTile* self);
static void __lambda6__tracker_result_grid_selection_changed (TrackerResultGrid* _sender, GtkTreePath* path, gpointer self);
void tracker_metadata_tile_set_ResultGrid (TrackerMetadataTile* self, TrackerResultGrid* value);
static gboolean _tracker_metadata_tile_expose_gtk_widget_expose_event (TrackerMetadataTile* _sender, GdkEventExpose* event, gpointer self);
static GObject * tracker_metadata_tile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void tracker_metadata_tile_finalize (GObject* obj);
static void tracker_metadata_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void tracker_metadata_tile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 138 "tracker-metadata-tile.gs"
static gboolean tracker_metadata_tile_expose (TrackerMetadataTile* self, GdkEventExpose* e) {
#line 196 "tracker-metadata-tile.c"
	gboolean result = FALSE;
	cairo_t* cr;
	GtkStyle* style;
	GdkColor step1;
	GdkColor step2;
	double w = 0.0;
	double h = 0.0;
	cairo_pattern_t* pat;
#line 138 "tracker-metadata-tile.gs"
	g_return_val_if_fail (self != NULL, FALSE);
#line 140 "tracker-metadata-tile.gs"
	cr = gdk_cairo_create ((GdkDrawable*) ((GtkWidget*) self)->window);
#line 142 "tracker-metadata-tile.gs"
	style = _g_object_ref0 (gtk_widget_get_style ((GtkWidget*) self));
#line 143 "tracker-metadata-tile.gs"
	step1 = style->bg[GTK_STATE_NORMAL];
#line 144 "tracker-metadata-tile.gs"
	step2 = style->bg[GTK_STATE_SELECTED];
#line 147 "tracker-metadata-tile.gs"
	w = (double) ((GtkWidget*) self)->allocation.width;
#line 148 "tracker-metadata-tile.gs"
	h = (double) ((GtkWidget*) self)->allocation.height;
#line 151 "tracker-metadata-tile.gs"
	cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);
#line 152 "tracker-metadata-tile.gs"
	gdk_cairo_set_source_color (cr, &step1);
#line 153 "tracker-metadata-tile.gs"
	cairo_paint (cr);
#line 154 "tracker-metadata-tile.gs"
	cairo_move_to (cr, (double) 0, (double) 0);
#line 155 "tracker-metadata-tile.gs"
	cairo_set_line_width (cr, 1.0);
#line 156 "tracker-metadata-tile.gs"
	cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
#line 159 "tracker-metadata-tile.gs"
	pat = cairo_pattern_create_linear (0.0, 0.0, 0.0, h);
#line 161 "tracker-metadata-tile.gs"
	cairo_pattern_add_color_stop_rgba (pat, 0.0, step2.red / 65535.0, step2.green / 65535.0, step2.blue / 65535.0, 0.05);
#line 163 "tracker-metadata-tile.gs"
	cairo_pattern_add_color_stop_rgba (pat, 1.0, step2.red / 65535.0, step2.green / 65535.0, step2.blue / 65535.0, 0.5);
#line 165 "tracker-metadata-tile.gs"
	cairo_rectangle (cr, (double) 0, (double) 0, w, h);
#line 166 "tracker-metadata-tile.gs"
	cairo_set_source (cr, pat);
#line 167 "tracker-metadata-tile.gs"
	cairo_fill (cr);
#line 170 "tracker-metadata-tile.gs"
	cairo_set_source_rgba (cr, step2.red / 65535.0, step2.green / 65535.0, step2.blue / 65535.0, 0.7);
#line 171 "tracker-metadata-tile.gs"
	cairo_move_to (cr, (double) 0, (double) 0);
#line 172 "tracker-metadata-tile.gs"
	cairo_line_to (cr, w, (double) 0);
#line 173 "tracker-metadata-tile.gs"
	cairo_stroke (cr);
#line 176 "tracker-metadata-tile.gs"
	cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 0.5);
#line 177 "tracker-metadata-tile.gs"
	cairo_move_to (cr, (double) 0, (double) 1);
#line 178 "tracker-metadata-tile.gs"
	cairo_line_to (cr, w, (double) 1);
#line 179 "tracker-metadata-tile.gs"
	cairo_stroke (cr);
#line 259 "tracker-metadata-tile.c"
	result = GTK_WIDGET_CLASS (tracker_metadata_tile_parent_class)->expose_event ((GtkWidget*) GTK_EVENT_BOX (self), e);
	_cairo_pattern_destroy0 (pat);
	_g_object_unref0 (style);
	_cairo_destroy0 (cr);
#line 181 "tracker-metadata-tile.gs"
	return result;
#line 266 "tracker-metadata-tile.c"
}


#line 184 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_AttachToTable (TrackerMetadataTile* self, GtkLabel* lab, gint l, gint r, gint t, gint b, gboolean e) {
#line 184 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 184 "tracker-metadata-tile.gs"
	g_return_if_fail (lab != NULL);
#line 185 "tracker-metadata-tile.gs"
	if (e == TRUE) {
#line 186 "tracker-metadata-tile.gs"
		gtk_table_attach (self->table, (GtkWidget*) lab, (guint) l, (guint) r, (guint) t, (guint) b, GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
#line 280 "tracker-metadata-tile.c"
	} else {
#line 188 "tracker-metadata-tile.gs"
		gtk_table_attach (self->table, (GtkWidget*) lab, (guint) l, (guint) r, (guint) t, (guint) b, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 284 "tracker-metadata-tile.c"
	}
}


#line 191 "tracker-metadata-tile.gs"
static GtkLabel* tracker_metadata_tile_CreateLabel (TrackerMetadataTile* self, const char* s, gboolean e) {
#line 291 "tracker-metadata-tile.c"
	GtkLabel* result = NULL;
	GtkLabel* l;
#line 191 "tracker-metadata-tile.gs"
	g_return_val_if_fail (self != NULL, NULL);
#line 191 "tracker-metadata-tile.gs"
	g_return_val_if_fail (s != NULL, NULL);
#line 192 "tracker-metadata-tile.gs"
	l = g_object_ref_sink ((GtkLabel*) gtk_label_new (s));
#line 193 "tracker-metadata-tile.gs"
	g_object_set ((GtkMisc*) l, "xalign", (float) 0, NULL);
#line 194 "tracker-metadata-tile.gs"
	gtk_label_set_use_markup (l, TRUE);
#line 196 "tracker-metadata-tile.gs"
	if (e == TRUE) {
#line 197 "tracker-metadata-tile.gs"
		gtk_label_set_ellipsize (l, PANGO_ELLIPSIZE_END);
#line 308 "tracker-metadata-tile.c"
	}
	result = l;
#line 199 "tracker-metadata-tile.gs"
	return result;
#line 313 "tracker-metadata-tile.c"
}


#line 202 "tracker-metadata-tile.gs"
void tracker_metadata_tile_ClearLabels (TrackerMetadataTile* self) {
#line 202 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 203 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value1, "");
#line 204 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value2, "");
#line 205 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value3, "");
#line 206 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value4, "");
#line 207 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value5, "");
#line 208 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value6, "");
#line 209 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label1, N_ ("Type:"));
#line 210 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label4, "");
#line 211 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label5, "");
#line 212 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label6, "");
#line 214 "tracker-metadata-tile.gs"
	gtk_link_button_set_uri (self->name_link, "");
#line 215 "tracker-metadata-tile.gs"
	gtk_button_set_label ((GtkButton*) self->name_link, "");
#line 216 "tracker-metadata-tile.gs"
	gtk_link_button_set_uri (self->path_link, "");
#line 217 "tracker-metadata-tile.gs"
	gtk_button_set_label ((GtkButton*) self->path_link, "");
#line 219 "tracker-metadata-tile.gs"
	gtk_widget_set_sensitive ((GtkWidget*) self->name_link, FALSE);
#line 220 "tracker-metadata-tile.gs"
	gtk_widget_show ((GtkWidget*) self->name_link);
#line 222 "tracker-metadata-tile.gs"
	gtk_widget_set_sensitive ((GtkWidget*) self->path_link, FALSE);
#line 223 "tracker-metadata-tile.gs"
	gtk_widget_show ((GtkWidget*) self->path_link);
#line 225 "tracker-metadata-tile.gs"
	gtk_widget_show ((GtkWidget*) self->name_label);
#line 226 "tracker-metadata-tile.gs"
	gtk_widget_show ((GtkWidget*) self->path_label);
#line 227 "tracker-metadata-tile.gs"
	gtk_widget_show ((GtkWidget*) self->info_label1);
#line 228 "tracker-metadata-tile.gs"
	gtk_widget_show ((GtkWidget*) self->info_label2);
#line 229 "tracker-metadata-tile.gs"
	gtk_widget_show ((GtkWidget*) self->info_label3);
#line 367 "tracker-metadata-tile.c"
}


#line 232 "tracker-metadata-tile.gs"
void tracker_metadata_tile_SetLabelValue (TrackerMetadataTile* self, GtkLabel* label, const char* val) {
#line 373 "tracker-metadata-tile.c"
	char* val1;
#line 232 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 232 "tracker-metadata-tile.gs"
	g_return_if_fail (label != NULL);
#line 232 "tracker-metadata-tile.gs"
	g_return_if_fail (val != NULL);
#line 233 "tracker-metadata-tile.gs"
	val1 = g_strdup_printf ("<b>%s</b>", val);
#line 234 "tracker-metadata-tile.gs"
	gtk_label_set_markup (label, val1);
#line 235 "tracker-metadata-tile.gs"
	g_object_set ((GtkMisc*) label, "xalign", (float) 0, NULL);
#line 387 "tracker-metadata-tile.c"
	_g_free0 (val1);
}


#line 238 "tracker-metadata-tile.gs"
void tracker_metadata_tile_SetLabelSizeValue (TrackerMetadataTile* self, GtkLabel* label, gint64 size) {
#line 394 "tracker-metadata-tile.c"
	char* _tmp0_;
	char* _tmp1_;
	char* val1;
#line 238 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 238 "tracker-metadata-tile.gs"
	g_return_if_fail (label != NULL);
#line 239 "tracker-metadata-tile.gs"
	val1 = (_tmp1_ = g_strdup_printf ("<b>%s</b>", _tmp0_ = tracker_utils_FormatFileSize (size)), _g_free0 (_tmp0_), _tmp1_);
#line 240 "tracker-metadata-tile.gs"
	gtk_label_set_markup (label, val1);
#line 241 "tracker-metadata-tile.gs"
	g_object_set ((GtkMisc*) label, "xalign", (float) 0, NULL);
#line 408 "tracker-metadata-tile.c"
	_g_free0 (val1);
}


#line 244 "tracker-metadata-tile.gs"
void tracker_metadata_tile_SetLabelUrnValue (TrackerMetadataTile* self, GtkLabel* label, const char* val) {
#line 415 "tracker-metadata-tile.c"
	char* value;
	char** _tmp1_;
	gint _values_size_;
	gint values_length1;
	char** _tmp0_;
	char** values;
	char** _tmp4_;
	gint _escapes_size_;
	gint escapes_length1;
	char** _tmp3_;
	char** escapes;
	char* _tmp5_;
	char* val1;
#line 244 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 244 "tracker-metadata-tile.gs"
	g_return_if_fail (label != NULL);
#line 244 "tracker-metadata-tile.gs"
	g_return_if_fail (val != NULL);
#line 245 "tracker-metadata-tile.gs"
	value = g_strdup (val);
#line 437 "tracker-metadata-tile.c"
	values = (_tmp1_ = _tmp0_ = g_strsplit (val, ":", 0), values_length1 = _vala_array_length (_tmp0_), _values_size_ = values_length1, _tmp1_);
	{
		char** s_collection;
		int s_collection_length1;
		int s_it;
#line 249 "tracker-metadata-tile.gs"
		s_collection = values;
#line 445 "tracker-metadata-tile.c"
		s_collection_length1 = values_length1;
		for (s_it = 0; s_it < values_length1; s_it = s_it + 1) {
			char* s;
			s = g_strdup (s_collection[s_it]);
			{
				char* _tmp2_;
#line 250 "tracker-metadata-tile.gs"
				value = (_tmp2_ = g_strdup (s), _g_free0 (value), _tmp2_);
#line 454 "tracker-metadata-tile.c"
				_g_free0 (s);
			}
		}
	}
	escapes = (_tmp4_ = _tmp3_ = g_strsplit (value, "%20", 0), escapes_length1 = _vala_array_length (_tmp3_), _escapes_size_ = escapes_length1, _tmp4_);
#line 253 "tracker-metadata-tile.gs"
	value = (_tmp5_ = g_strdup (""), _g_free0 (value), _tmp5_);
#line 462 "tracker-metadata-tile.c"
	{
		char** s_collection;
		int s_collection_length1;
		int s_it;
#line 254 "tracker-metadata-tile.gs"
		s_collection = escapes;
#line 469 "tracker-metadata-tile.c"
		s_collection_length1 = escapes_length1;
		for (s_it = 0; s_it < escapes_length1; s_it = s_it + 1) {
			char* s;
			s = g_strdup (s_collection[s_it]);
			{
				char* _tmp7_;
				char* _tmp6_;
#line 255 "tracker-metadata-tile.gs"
				value = (_tmp7_ = g_strconcat (value, _tmp6_ = g_strconcat (s, " ", NULL), NULL), _g_free0 (value), _tmp7_);
#line 479 "tracker-metadata-tile.c"
				_g_free0 (_tmp6_);
				_g_free0 (s);
			}
		}
	}
#line 257 "tracker-metadata-tile.gs"
	val1 = g_strdup_printf ("<b>%s</b>", value);
#line 258 "tracker-metadata-tile.gs"
	gtk_label_set_markup (label, val1);
#line 259 "tracker-metadata-tile.gs"
	g_object_set ((GtkMisc*) label, "xalign", (float) 0, NULL);
#line 491 "tracker-metadata-tile.c"
	_g_free0 (val1);
	escapes = (_vala_array_free (escapes, escapes_length1, (GDestroyNotify) g_free), NULL);
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (value);
}


#line 1152 "glib-2.0.vapi"
static gboolean string_contains (const char* self, const char* needle) {
#line 501 "tracker-metadata-tile.c"
	gboolean result = FALSE;
#line 1152 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1152 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 507 "tracker-metadata-tile.c"
	result = strstr (self, needle) != NULL;
#line 1153 "glib-2.0.vapi"
	return result;
#line 511 "tracker-metadata-tile.c"
}


#line 262 "tracker-metadata-tile.gs"
static Categories tracker_metadata_tile_GetCategory (TrackerMetadataTile* self, const char* uri) {
#line 517 "tracker-metadata-tile.c"
	Categories result = 0;
	char* query;
	char** _tmp2_;
	gint results_length2;
	gint results_length1;
	gint _tmp1_;
	gint _tmp0_;
	char** results;
	char* res;
#line 262 "tracker-metadata-tile.gs"
	g_return_val_if_fail (self != NULL, 0);
#line 262 "tracker-metadata-tile.gs"
	g_return_val_if_fail (uri != NULL, 0);
#line 263 "tracker-metadata-tile.gs"
	query = g_strdup_printf ("SELECT rdf:type(?s) WHERE { ?s nie:url \"%s\" }", uri);
#line 533 "tracker-metadata-tile.c"
	results = (_tmp2_ = tracker_query_Query (self->priv->_Query, query, &_tmp0_, &_tmp1_), results_length1 = _tmp0_, results_length2 = _tmp1_, _tmp2_);
#line 265 "tracker-metadata-tile.gs"
	res = g_strdup ("");
#line 267 "tracker-metadata-tile.gs"
	if (results == NULL) {
#line 268 "tracker-metadata-tile.gs"
		g_print ("Query result is null!\n");
#line 541 "tracker-metadata-tile.c"
	} else {
		char* _tmp3_;
#line 271 "tracker-metadata-tile.gs"
		res = (_tmp3_ = g_strdup (results[0]), _g_free0 (res), _tmp3_);
#line 546 "tracker-metadata-tile.c"
	}
#line 273 "tracker-metadata-tile.gs"
	if (string_contains (res, "nfo#Video")) {
#line 550 "tracker-metadata-tile.c"
		result = CATEGORIES_Video;
		_g_free0 (res);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
#line 273 "tracker-metadata-tile.gs"
		return result;
#line 557 "tracker-metadata-tile.c"
	}
#line 274 "tracker-metadata-tile.gs"
	if (string_contains (res, "nfo#Image")) {
#line 561 "tracker-metadata-tile.c"
		result = CATEGORIES_Image;
		_g_free0 (res);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
#line 274 "tracker-metadata-tile.gs"
		return result;
#line 568 "tracker-metadata-tile.c"
	}
#line 275 "tracker-metadata-tile.gs"
	if (string_contains (res, "nfo#Audio")) {
#line 572 "tracker-metadata-tile.c"
		result = CATEGORIES_Audio;
		_g_free0 (res);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
#line 275 "tracker-metadata-tile.gs"
		return result;
#line 579 "tracker-metadata-tile.c"
	}
#line 276 "tracker-metadata-tile.gs"
	if (string_contains (res, "nmo#Email")) {
#line 583 "tracker-metadata-tile.c"
		result = CATEGORIES_Email;
		_g_free0 (res);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
#line 276 "tracker-metadata-tile.gs"
		return result;
#line 590 "tracker-metadata-tile.c"
	}
#line 277 "tracker-metadata-tile.gs"
	if (string_contains (res, "nfo#Document")) {
#line 594 "tracker-metadata-tile.c"
		result = CATEGORIES_Document;
		_g_free0 (res);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
#line 277 "tracker-metadata-tile.gs"
		return result;
#line 601 "tracker-metadata-tile.c"
	}
#line 278 "tracker-metadata-tile.gs"
	if (string_contains (res, "nfo#Software")) {
#line 605 "tracker-metadata-tile.c"
		result = CATEGORIES_Application;
		_g_free0 (res);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
#line 278 "tracker-metadata-tile.gs"
		return result;
#line 612 "tracker-metadata-tile.c"
	}
#line 279 "tracker-metadata-tile.gs"
	if (string_contains (res, "nfo#Folder")) {
#line 616 "tracker-metadata-tile.c"
		result = CATEGORIES_Folder;
		_g_free0 (res);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
#line 279 "tracker-metadata-tile.gs"
		return result;
#line 623 "tracker-metadata-tile.c"
	}
	result = CATEGORIES_File;
	_g_free0 (res);
	results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
	_g_free0 (query);
#line 281 "tracker-metadata-tile.gs"
	return result;
#line 631 "tracker-metadata-tile.c"
}


#line 284 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_DisplayFileDetails (TrackerMetadataTile* self, const char* uri, const char* mime) {
#line 637 "tracker-metadata-tile.c"
	GError * _inner_error_;
	GFile* file;
	GFile* displaypath;
	char* _tmp0_;
	char* _tmp1_;
	GtkLabel* link_label;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
#line 284 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 284 "tracker-metadata-tile.gs"
	g_return_if_fail (uri != NULL);
#line 284 "tracker-metadata-tile.gs"
	g_return_if_fail (mime != NULL);
#line 652 "tracker-metadata-tile.c"
	_inner_error_ = NULL;
#line 285 "tracker-metadata-tile.gs"
	file = g_file_new_for_uri (uri);
#line 286 "tracker-metadata-tile.gs"
	displaypath = g_file_get_parent (file);
#line 288 "tracker-metadata-tile.gs"
	gtk_link_button_set_uri (self->name_link, uri);
#line 289 "tracker-metadata-tile.gs"
	gtk_link_button_set_uri (self->path_link, _tmp0_ = g_file_get_uri (displaypath));
#line 662 "tracker-metadata-tile.c"
	_g_free0 (_tmp0_);
#line 290 "tracker-metadata-tile.gs"
	gtk_button_set_label ((GtkButton*) self->path_link, _tmp1_ = g_file_get_parse_name (displaypath));
#line 666 "tracker-metadata-tile.c"
	_g_free0 (_tmp1_);
	link_label = NULL;
#line 293 "tracker-metadata-tile.gs"
	link_label = (_tmp2_ = _g_object_ref0 (GTK_LABEL (gtk_bin_get_child ((GtkBin*) self->path_link))), _g_object_unref0 (link_label), _tmp2_);
#line 294 "tracker-metadata-tile.gs"
	gtk_label_set_ellipsize (link_label, PANGO_ELLIPSIZE_MIDDLE);
#line 296 "tracker-metadata-tile.gs"
	link_label = (_tmp3_ = _g_object_ref0 (GTK_LABEL (gtk_bin_get_child ((GtkBin*) self->name_link))), _g_object_unref0 (link_label), _tmp3_);
#line 297 "tracker-metadata-tile.gs"
	gtk_label_set_ellipsize (link_label, PANGO_ELLIPSIZE_MIDDLE);
#line 299 "tracker-metadata-tile.gs"
	if (mime != NULL) {
#line 300 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelValue (self, self->info_value1, mime);
#line 681 "tracker-metadata-tile.c"
	}
	{
		GFileInfo* info;
		GTimeVal tm = {0};
		char* _tmp4_;
		char* _tmp5_;
		char* val3;
#line 303 "tracker-metadata-tile.gs"
		info = g_file_query_info (file, "standard::size,time::modified,standard::display-name", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 691 "tracker-metadata-tile.c"
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
#line 306 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelSizeValue (self, self->info_value2, g_file_info_get_size (info));
#line 307 "tracker-metadata-tile.gs"
		gtk_button_set_label ((GtkButton*) self->name_link, g_file_info_get_display_name (info));
#line 310 "tracker-metadata-tile.gs"
		g_file_info_get_modification_time (info, &tm);
#line 312 "tracker-metadata-tile.gs"
		val3 = (_tmp5_ = g_strdup_printf ("<b>%s</b>", _tmp4_ = g_time_val_to_iso8601 (&tm)), _g_free0 (_tmp4_), _tmp5_);
#line 314 "tracker-metadata-tile.gs"
		gtk_label_set_markup (self->info_value3, val3);
#line 705 "tracker-metadata-tile.c"
		_g_free0 (val3);
		_g_object_unref0 (info);
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			char* filepath;
#line 317 "tracker-metadata-tile.gs"
			filepath = g_file_get_basename (file);
#line 318 "tracker-metadata-tile.gs"
			gtk_button_set_label ((GtkButton*) self->name_link, filepath);
#line 319 "tracker-metadata-tile.gs"
			g_print ("Could not get file info for %s\n", uri);
#line 723 "tracker-metadata-tile.c"
			_g_free0 (filepath);
			_g_error_free0 (e);
		}
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (link_label);
		_g_object_unref0 (displaypath);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (link_label);
	_g_object_unref0 (displaypath);
	_g_object_unref0 (file);
}


#line 322 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_DisplayImageDetails (TrackerMetadataTile* self, const char* uri) {
#line 745 "tracker-metadata-tile.c"
	char* query;
	char** _tmp2_;
	gint _result__length2;
	gint _result__length1;
	gint _tmp1_;
	gint _tmp0_;
	char** _result_;
	gboolean _tmp3_ = FALSE;
#line 322 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 322 "tracker-metadata-tile.gs"
	g_return_if_fail (uri != NULL);
#line 323 "tracker-metadata-tile.gs"
	query = g_strdup_printf ("SELECT nfo:height(?s) nfo:width(?s) WHERE { ?s nie:url \"%s\" }", uri);
#line 760 "tracker-metadata-tile.c"
	_result_ = (_tmp2_ = tracker_query_Query (self->priv->_Query, query, &_tmp0_, &_tmp1_), _result__length1 = _tmp0_, _result__length2 = _tmp1_, _tmp2_);
#line 326 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label4, N_ ("Height:"));
#line 327 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label5, N_ ("Width:"));
#line 329 "tracker-metadata-tile.gs"
	if (_result_ == NULL) {
#line 329 "tracker-metadata-tile.gs"
		_tmp3_ = TRUE;
#line 770 "tracker-metadata-tile.c"
	} else {
#line 329 "tracker-metadata-tile.gs"
		_tmp3_ = _result_[0] == NULL;
#line 774 "tracker-metadata-tile.c"
	}
#line 329 "tracker-metadata-tile.gs"
	if (_tmp3_) {
#line 778 "tracker-metadata-tile.c"
		_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
#line 329 "tracker-metadata-tile.gs"
		return;
#line 783 "tracker-metadata-tile.c"
	}
#line 331 "tracker-metadata-tile.gs"
	tracker_metadata_tile_SetLabelValue (self, self->info_value4, _result_[0]);
#line 332 "tracker-metadata-tile.gs"
	tracker_metadata_tile_SetLabelValue (self, self->info_value5, _result_[1]);
#line 789 "tracker-metadata-tile.c"
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	_g_free0 (query);
}


#line 335 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_DisplayAudioDetails (TrackerMetadataTile* self, const char* uri) {
#line 797 "tracker-metadata-tile.c"
	char* query;
	char** _tmp2_;
	gint _result__length2;
	gint _result__length1;
	gint _tmp1_;
	gint _tmp0_;
	char** _result_;
	gboolean _tmp3_ = FALSE;
#line 335 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 335 "tracker-metadata-tile.gs"
	g_return_if_fail (uri != NULL);
#line 336 "tracker-metadata-tile.gs"
	query = g_strdup_printf ("SELECT nie:title(?s) nmm:performer(?s) nmm:musicAlbum(?s) WHERE { ?s n" \
"ie:url \"%s\" }", uri);
#line 812 "tracker-metadata-tile.c"
	_result_ = (_tmp2_ = tracker_query_Query (self->priv->_Query, query, &_tmp0_, &_tmp1_), _result__length1 = _tmp0_, _result__length2 = _tmp1_, _tmp2_);
#line 339 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label4, N_ ("Title:"));
#line 340 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label5, N_ ("Artist:"));
#line 341 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label6, N_ ("Album:"));
#line 343 "tracker-metadata-tile.gs"
	if (_result_ == NULL) {
#line 343 "tracker-metadata-tile.gs"
		_tmp3_ = TRUE;
#line 824 "tracker-metadata-tile.c"
	} else {
#line 343 "tracker-metadata-tile.gs"
		_tmp3_ = _result_[0] == NULL;
#line 828 "tracker-metadata-tile.c"
	}
#line 343 "tracker-metadata-tile.gs"
	if (_tmp3_) {
#line 832 "tracker-metadata-tile.c"
		_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
#line 343 "tracker-metadata-tile.gs"
		return;
#line 837 "tracker-metadata-tile.c"
	}
#line 345 "tracker-metadata-tile.gs"
	tracker_metadata_tile_SetLabelValue (self, self->info_value4, _result_[0]);
#line 346 "tracker-metadata-tile.gs"
	tracker_metadata_tile_SetLabelUrnValue (self, self->info_value5, _result_[1]);
#line 347 "tracker-metadata-tile.gs"
	tracker_metadata_tile_SetLabelUrnValue (self, self->info_value6, _result_[2]);
#line 845 "tracker-metadata-tile.c"
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	_g_free0 (query);
}


#line 350 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_DisplayVideoDetails (TrackerMetadataTile* self, const char* uri) {
#line 853 "tracker-metadata-tile.c"
	char* query;
	char** _tmp2_;
	gint _result__length2;
	gint _result__length1;
	gint _tmp1_;
	gint _tmp0_;
	char** _result_;
	gboolean _tmp3_ = FALSE;
#line 350 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 350 "tracker-metadata-tile.gs"
	g_return_if_fail (uri != NULL);
#line 351 "tracker-metadata-tile.gs"
	query = g_strdup_printf ("SELECT nfo:height(?s) nfo:width(?s) nfo:duration (?s) WHERE { ?s nie:u" \
"rl \"%s\" }", uri);
#line 868 "tracker-metadata-tile.c"
	_result_ = (_tmp2_ = tracker_query_Query (self->priv->_Query, query, &_tmp0_, &_tmp1_), _result__length1 = _tmp0_, _result__length2 = _tmp1_, _tmp2_);
#line 354 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label4, N_ ("Height:"));
#line 355 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label5, N_ ("Width:"));
#line 356 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label6, N_ ("Duration:"));
#line 358 "tracker-metadata-tile.gs"
	if (_result_ == NULL) {
#line 358 "tracker-metadata-tile.gs"
		_tmp3_ = TRUE;
#line 880 "tracker-metadata-tile.c"
	} else {
#line 358 "tracker-metadata-tile.gs"
		_tmp3_ = _result_[0] == NULL;
#line 884 "tracker-metadata-tile.c"
	}
#line 358 "tracker-metadata-tile.gs"
	if (_tmp3_) {
#line 888 "tracker-metadata-tile.c"
		_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
#line 358 "tracker-metadata-tile.gs"
		return;
#line 893 "tracker-metadata-tile.c"
	}
#line 360 "tracker-metadata-tile.gs"
	tracker_metadata_tile_SetLabelValue (self, self->info_value4, _result_[0]);
#line 361 "tracker-metadata-tile.gs"
	tracker_metadata_tile_SetLabelValue (self, self->info_value5, _result_[1]);
#line 362 "tracker-metadata-tile.gs"
	tracker_metadata_tile_SetLabelValue (self, self->info_value6, _result_[2]);
#line 901 "tracker-metadata-tile.c"
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	_g_free0 (query);
}


#line 365 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_DisplayEmailDetails (TrackerMetadataTile* self, const char* uri) {
#line 909 "tracker-metadata-tile.c"
	char* query;
	char** _tmp2_;
	gint _result__length2;
	gint _result__length1;
	gint _tmp1_;
	gint _tmp0_;
	char** _result_;
	gboolean _tmp3_ = FALSE;
#line 365 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 365 "tracker-metadata-tile.gs"
	g_return_if_fail (uri != NULL);
#line 366 "tracker-metadata-tile.gs"
	query = g_strdup_printf ("SELECT nmo:messageSubject(?e) nco:fullname(?s) nmo:receivedDate(?e) WH" \
"ERE { ?e nie:url \"%s\" ; nmo:from ?s }", uri);
#line 924 "tracker-metadata-tile.c"
	_result_ = (_tmp2_ = tracker_query_Query (self->priv->_Query, query, &_tmp0_, &_tmp1_), _result__length1 = _tmp0_, _result__length2 = _tmp1_, _tmp2_);
#line 369 "tracker-metadata-tile.gs"
	gtk_widget_hide ((GtkWidget*) self->name_label);
#line 370 "tracker-metadata-tile.gs"
	gtk_widget_hide ((GtkWidget*) self->name_link);
#line 371 "tracker-metadata-tile.gs"
	gtk_widget_hide ((GtkWidget*) self->path_link);
#line 372 "tracker-metadata-tile.gs"
	gtk_widget_hide ((GtkWidget*) self->path_label);
#line 373 "tracker-metadata-tile.gs"
	gtk_widget_hide ((GtkWidget*) self->info_label2);
#line 375 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label1, N_ ("Subject:"));
#line 376 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label4, N_ ("From:"));
#line 377 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label3, N_ ("Received:"));
#line 379 "tracker-metadata-tile.gs"
	if (_result_ == NULL) {
#line 379 "tracker-metadata-tile.gs"
		_tmp3_ = TRUE;
#line 946 "tracker-metadata-tile.c"
	} else {
#line 379 "tracker-metadata-tile.gs"
		_tmp3_ = _result_[0] == NULL;
#line 950 "tracker-metadata-tile.c"
	}
#line 379 "tracker-metadata-tile.gs"
	if (_tmp3_) {
#line 954 "tracker-metadata-tile.c"
		_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
#line 379 "tracker-metadata-tile.gs"
		return;
#line 959 "tracker-metadata-tile.c"
	}
#line 381 "tracker-metadata-tile.gs"
	tracker_metadata_tile_SetLabelValue (self, self->info_value1, _result_[0]);
#line 382 "tracker-metadata-tile.gs"
	tracker_metadata_tile_SetLabelValue (self, self->info_value4, _result_[1]);
#line 383 "tracker-metadata-tile.gs"
	tracker_metadata_tile_SetLabelValue (self, self->info_value3, _result_[2]);
#line 967 "tracker-metadata-tile.c"
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	_g_free0 (query);
}


#line 386 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_DisplayDocumentDetails (TrackerMetadataTile* self, const char* uri) {
#line 975 "tracker-metadata-tile.c"
	char* query;
	char** _tmp2_;
	gint _result__length2;
	gint _result__length1;
	gint _tmp1_;
	gint _tmp0_;
	char** _result_;
	gboolean _tmp3_ = FALSE;
#line 386 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 386 "tracker-metadata-tile.gs"
	g_return_if_fail (uri != NULL);
#line 387 "tracker-metadata-tile.gs"
	query = g_strdup_printf ("SELECT nie:title(?s) nco:fullname(?c) nfo:pageCount(?s) WHERE { ?s nie" \
":url \"%s\" ; nco:creator ?c }", uri);
#line 990 "tracker-metadata-tile.c"
	_result_ = (_tmp2_ = tracker_query_Query (self->priv->_Query, query, &_tmp0_, &_tmp1_), _result__length1 = _tmp0_, _result__length2 = _tmp1_, _tmp2_);
#line 390 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label4, N_ ("Title:"));
#line 391 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label5, N_ ("Author:"));
#line 392 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label6, N_ ("Page count:"));
#line 394 "tracker-metadata-tile.gs"
	if (_result_ == NULL) {
#line 394 "tracker-metadata-tile.gs"
		_tmp3_ = TRUE;
#line 1002 "tracker-metadata-tile.c"
	} else {
#line 394 "tracker-metadata-tile.gs"
		_tmp3_ = _result_[0] == NULL;
#line 1006 "tracker-metadata-tile.c"
	}
#line 394 "tracker-metadata-tile.gs"
	if (_tmp3_) {
#line 1010 "tracker-metadata-tile.c"
		_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
#line 394 "tracker-metadata-tile.gs"
		return;
#line 1015 "tracker-metadata-tile.c"
	}
#line 396 "tracker-metadata-tile.gs"
	tracker_metadata_tile_SetLabelValue (self, self->info_value4, _result_[0]);
#line 397 "tracker-metadata-tile.gs"
	tracker_metadata_tile_SetLabelValue (self, self->info_value5, _result_[1]);
#line 398 "tracker-metadata-tile.gs"
	tracker_metadata_tile_SetLabelValue (self, self->info_value6, _result_[2]);
#line 1023 "tracker-metadata-tile.c"
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	_g_free0 (query);
}


#line 401 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_DisplayApplicationDetails (TrackerMetadataTile* self, const char* uri) {
#line 1031 "tracker-metadata-tile.c"
	GAppInfo* app_info;
	GFile* file;
	GAppInfo* _tmp1_;
	char* _tmp0_;
	char* description;
#line 401 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 401 "tracker-metadata-tile.gs"
	g_return_if_fail (uri != NULL);
#line 1041 "tracker-metadata-tile.c"
	app_info = NULL;
#line 404 "tracker-metadata-tile.gs"
	file = g_file_new_for_uri (uri);
#line 405 "tracker-metadata-tile.gs"
	app_info = (_tmp1_ = (GAppInfo*) g_desktop_app_info_new_from_filename (_tmp0_ = g_file_get_path (file)), _g_object_unref0 (app_info), _tmp1_);
#line 1047 "tracker-metadata-tile.c"
	_g_free0 (_tmp0_);
#line 406 "tracker-metadata-tile.gs"
	if (app_info == NULL) {
#line 407 "tracker-metadata-tile.gs"
		tracker_metadata_tile_DisplayFileDetails (self, uri, "");
#line 1053 "tracker-metadata-tile.c"
		_g_object_unref0 (file);
		_g_object_unref0 (app_info);
#line 408 "tracker-metadata-tile.gs"
		return;
#line 1058 "tracker-metadata-tile.c"
	}
#line 411 "tracker-metadata-tile.gs"
	gtk_widget_set_sensitive ((GtkWidget*) self->path_link, FALSE);
#line 412 "tracker-metadata-tile.gs"
	gtk_widget_hide ((GtkWidget*) self->path_label);
#line 413 "tracker-metadata-tile.gs"
	gtk_widget_hide ((GtkWidget*) self->info_label2);
#line 414 "tracker-metadata-tile.gs"
	gtk_widget_hide ((GtkWidget*) self->info_label3);
#line 416 "tracker-metadata-tile.gs"
	gtk_link_button_set_uri (self->name_link, uri);
#line 417 "tracker-metadata-tile.gs"
	gtk_button_set_label ((GtkButton*) self->name_link, g_app_info_get_display_name (app_info));
#line 418 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label1, N_ ("Description:"));
#line 420 "tracker-metadata-tile.gs"
	description = g_strdup (g_app_info_get_description (app_info));
#line 421 "tracker-metadata-tile.gs"
	if (description != NULL) {
#line 422 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelValue (self, self->info_value1, description);
#line 1080 "tracker-metadata-tile.c"
	}
	_g_free0 (description);
	_g_object_unref0 (file);
	_g_object_unref0 (app_info);
}


#line 425 "tracker-metadata-tile.gs"
void tracker_metadata_tile_LoadUri (TrackerMetadataTile* self, GtkTreePath* path) {
#line 1090 "tracker-metadata-tile.c"
	GtkTreeIter iter = {0};
	const char* id;
	const char* uri;
	const char* mime;
	GdkPixbuf* icon;
	Categories cat;
	gboolean _tmp0_ = FALSE;
#line 425 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 426 "tracker-metadata-tile.gs"
	tracker_metadata_tile_ClearLabels (self);
#line 428 "tracker-metadata-tile.gs"
	if (path == NULL) {
#line 429 "tracker-metadata-tile.gs"
		gtk_image_set_from_icon_name (self->image, "text-x-generic", GTK_ICON_SIZE_DIALOG);
#line 430 "tracker-metadata-tile.gs"
		return;
#line 1108 "tracker-metadata-tile.c"
	}
#line 432 "tracker-metadata-tile.gs"
	gtk_widget_set_sensitive ((GtkWidget*) self->name_link, TRUE);
#line 433 "tracker-metadata-tile.gs"
	gtk_widget_set_sensitive ((GtkWidget*) self->path_link, TRUE);
#line 1114 "tracker-metadata-tile.c"
	id = NULL;
	uri = NULL;
	mime = NULL;
	icon = NULL;
#line 439 "tracker-metadata-tile.gs"
	gtk_tree_model_get_iter ((GtkTreeModel*) self->priv->_result_grid->store, &iter, path);
#line 440 "tracker-metadata-tile.gs"
	gtk_tree_model_get ((GtkTreeModel*) self->priv->_result_grid->store, &iter, RESULT_COLUMNS_Id, &id, RESULT_COLUMNS_Uri, &uri, RESULT_COLUMNS_Mime, &mime, RESULT_COLUMNS_Icon, &icon, -1);
#line 442 "tracker-metadata-tile.gs"
	gtk_image_set_from_pixbuf (self->image, icon);
#line 445 "tracker-metadata-tile.gs"
	cat = tracker_metadata_tile_GetCategory (self, uri);
#line 447 "tracker-metadata-tile.gs"
	if (cat != CATEGORIES_Application) {
#line 447 "tracker-metadata-tile.gs"
		_tmp0_ = cat != CATEGORIES_Email;
#line 1131 "tracker-metadata-tile.c"
	} else {
#line 447 "tracker-metadata-tile.gs"
		_tmp0_ = FALSE;
#line 1135 "tracker-metadata-tile.c"
	}
#line 447 "tracker-metadata-tile.gs"
	if (_tmp0_) {
#line 448 "tracker-metadata-tile.gs"
		tracker_metadata_tile_DisplayFileDetails (self, uri, mime);
#line 1141 "tracker-metadata-tile.c"
	}
#line 450 "tracker-metadata-tile.gs"
	switch (cat) {
#line 1145 "tracker-metadata-tile.c"
		case CATEGORIES_Audio:
		{
#line 451 "tracker-metadata-tile.gs"
			tracker_metadata_tile_DisplayAudioDetails (self, uri);
#line 450 "tracker-metadata-tile.gs"
			break;
#line 1152 "tracker-metadata-tile.c"
		}
		case CATEGORIES_Video:
		{
#line 452 "tracker-metadata-tile.gs"
			tracker_metadata_tile_DisplayVideoDetails (self, uri);
#line 450 "tracker-metadata-tile.gs"
			break;
#line 1160 "tracker-metadata-tile.c"
		}
		case CATEGORIES_Image:
		{
#line 453 "tracker-metadata-tile.gs"
			tracker_metadata_tile_DisplayImageDetails (self, uri);
#line 450 "tracker-metadata-tile.gs"
			break;
#line 1168 "tracker-metadata-tile.c"
		}
		case CATEGORIES_Email:
		{
#line 454 "tracker-metadata-tile.gs"
			tracker_metadata_tile_DisplayEmailDetails (self, uri);
#line 450 "tracker-metadata-tile.gs"
			break;
#line 1176 "tracker-metadata-tile.c"
		}
		case CATEGORIES_Document:
		{
#line 455 "tracker-metadata-tile.gs"
			tracker_metadata_tile_DisplayDocumentDetails (self, uri);
#line 450 "tracker-metadata-tile.gs"
			break;
#line 1184 "tracker-metadata-tile.c"
		}
		case CATEGORIES_Application:
		{
#line 456 "tracker-metadata-tile.gs"
			tracker_metadata_tile_DisplayApplicationDetails (self, uri);
#line 450 "tracker-metadata-tile.gs"
			break;
#line 1192 "tracker-metadata-tile.c"
		}
		default:
		{
			_g_object_unref0 (icon);
#line 457 "tracker-metadata-tile.gs"
			return;
#line 450 "tracker-metadata-tile.gs"
			break;
#line 1201 "tracker-metadata-tile.c"
		}
	}
	_g_object_unref0 (icon);
}


#line 30 "tracker-metadata-tile.gs"
TrackerMetadataTile* tracker_metadata_tile_construct (GType object_type) {
#line 1210 "tracker-metadata-tile.c"
	TrackerMetadataTile * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


#line 30 "tracker-metadata-tile.gs"
TrackerMetadataTile* tracker_metadata_tile_new (void) {
#line 30 "tracker-metadata-tile.gs"
	return tracker_metadata_tile_construct (TYPE_TRACKER_METADATA_TILE);
#line 1221 "tracker-metadata-tile.c"
}


TrackerQuery* tracker_metadata_tile_get_Query (TrackerMetadataTile* self) {
	TrackerQuery* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Query;
#line 62 "tracker-metadata-tile.gs"
	return result;
#line 1231 "tracker-metadata-tile.c"
}


void tracker_metadata_tile_set_Query (TrackerMetadataTile* self, TrackerQuery* value) {
	g_return_if_fail (self != NULL);
	self->priv->_Query = value;
	g_object_notify ((GObject *) self, "Query");
}


TrackerResultGrid* tracker_metadata_tile_get_ResultGrid (TrackerMetadataTile* self) {
	TrackerResultGrid* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_result_grid;
#line 66 "tracker-metadata-tile.gs"
	return result;
#line 1248 "tracker-metadata-tile.c"
}


#line 71 "tracker-metadata-tile.gs"
static void _lambda6_ (GtkTreePath* path, TrackerMetadataTile* self) {
#line 72 "tracker-metadata-tile.gs"
	tracker_metadata_tile_LoadUri (self, path);
#line 1256 "tracker-metadata-tile.c"
}


#line 71 "tracker-metadata-tile.gs"
static void __lambda6__tracker_result_grid_selection_changed (TrackerResultGrid* _sender, GtkTreePath* path, gpointer self) {
#line 1262 "tracker-metadata-tile.c"
	_lambda6_ (path, self);
}


void tracker_metadata_tile_set_ResultGrid (TrackerMetadataTile* self, TrackerResultGrid* value) {
	g_return_if_fail (self != NULL);
#line 68 "tracker-metadata-tile.gs"
	if (value != NULL) {
#line 1271 "tracker-metadata-tile.c"
		TrackerResultGrid* _tmp0_;
#line 69 "tracker-metadata-tile.gs"
		self->priv->_result_grid = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_result_grid), _tmp0_);
#line 71 "tracker-metadata-tile.gs"
		g_signal_connect_object (self->priv->_result_grid, "selection-changed", (GCallback) __lambda6__tracker_result_grid_selection_changed, self, 0);
#line 1277 "tracker-metadata-tile.c"
	}
	g_object_notify ((GObject *) self, "ResultGrid");
}


#line 138 "tracker-metadata-tile.gs"
static gboolean _tracker_metadata_tile_expose_gtk_widget_expose_event (TrackerMetadataTile* _sender, GdkEventExpose* event, gpointer self) {
#line 1285 "tracker-metadata-tile.c"
	gboolean result;
	result = tracker_metadata_tile_expose (self, event);
	return result;
}


static GObject * tracker_metadata_tile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	TrackerMetadataTile * self;
	parent_class = G_OBJECT_CLASS (tracker_metadata_tile_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = TRACKER_METADATA_TILE (obj);
	{
		GtkTable* _tmp0_;
		GtkImage* _tmp1_;
		GtkLinkButton* _tmp2_;
		GtkLabel* _tmp3_;
		GtkLinkButton* _tmp4_;
		GtkLabel* _tmp5_;
		GtkLabel* _tmp6_;
		GtkLabel* _tmp7_;
		GtkLabel* _tmp8_;
		GtkLabel* _tmp9_;
		GtkLabel* _tmp10_;
		GtkLabel* _tmp11_;
		GtkLabel* _tmp12_;
		GtkLabel* _tmp13_;
		GtkLabel* _tmp14_;
		GtkLabel* _tmp15_;
		GtkLabel* _tmp16_;
		GtkLabel* _tmp17_;
#line 77 "tracker-metadata-tile.gs"
		gtk_widget_set_app_paintable ((GtkWidget*) self, TRUE);
#line 79 "tracker-metadata-tile.gs"
		g_signal_connect_object ((GtkWidget*) self, "expose-event", (GCallback) _tracker_metadata_tile_expose_gtk_widget_expose_event, self, 0);
#line 81 "tracker-metadata-tile.gs"
		gtk_container_set_border_width ((GtkContainer*) self, (guint) 0);
#line 83 "tracker-metadata-tile.gs"
		self->table = (_tmp0_ = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) 5, (guint) 7, FALSE)), _g_object_unref0 (self->table), _tmp0_);
#line 84 "tracker-metadata-tile.gs"
		gtk_table_set_col_spacings (self->table, (guint) 3);
#line 85 "tracker-metadata-tile.gs"
		gtk_table_set_row_spacings (self->table, (guint) 3);
#line 87 "tracker-metadata-tile.gs"
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->table);
#line 89 "tracker-metadata-tile.gs"
		self->image = (_tmp1_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("text-x-generic", GTK_ICON_SIZE_DIALOG)), _g_object_unref0 (self->image), _tmp1_);
#line 90 "tracker-metadata-tile.gs"
		gtk_image_set_pixel_size (self->image, 75);
#line 91 "tracker-metadata-tile.gs"
		gtk_table_attach (self->table, (GtkWidget*) self->image, (guint) 0, (guint) 1, (guint) 0, (guint) 5, GTK_FILL, GTK_FILL, (guint) 12, (guint) 0);
#line 93 "tracker-metadata-tile.gs"
		self->name_link = (_tmp2_ = g_object_ref_sink ((GtkLinkButton*) gtk_link_button_new ("")), _g_object_unref0 (self->name_link), _tmp2_);
#line 94 "tracker-metadata-tile.gs"
		g_object_set ((GtkButton*) self->name_link, "xalign", (float) 0, NULL);
#line 95 "tracker-metadata-tile.gs"
		self->name_label = (_tmp3_ = tracker_metadata_tile_CreateLabel (self, N_ ("Name:"), FALSE), _g_object_unref0 (self->name_label), _tmp3_);
#line 96 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->name_label, 1, 2, 0, 1, FALSE);
#line 97 "tracker-metadata-tile.gs"
		gtk_table_attach (self->table, (GtkWidget*) self->name_link, (guint) 2, (guint) 3, (guint) 0, (guint) 1, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 99 "tracker-metadata-tile.gs"
		self->path_link = (_tmp4_ = g_object_ref_sink ((GtkLinkButton*) gtk_link_button_new ("")), _g_object_unref0 (self->path_link), _tmp4_);
#line 100 "tracker-metadata-tile.gs"
		g_object_set ((GtkButton*) self->path_link, "xalign", (float) 0, NULL);
#line 101 "tracker-metadata-tile.gs"
		self->path_label = (_tmp5_ = tracker_metadata_tile_CreateLabel (self, N_ ("Folder:"), FALSE), _g_object_unref0 (self->path_label), _tmp5_);
#line 102 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->path_label, 3, 4, 0, 1, FALSE);
#line 103 "tracker-metadata-tile.gs"
		gtk_table_attach (self->table, (GtkWidget*) self->path_link, (guint) 4, (guint) 7, (guint) 0, (guint) 1, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 105 "tracker-metadata-tile.gs"
		self->info_label1 = (_tmp6_ = tracker_metadata_tile_CreateLabel (self, N_ ("Type:"), FALSE), _g_object_unref0 (self->info_label1), _tmp6_);
#line 106 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label1, 1, 2, 1, 2, FALSE);
#line 107 "tracker-metadata-tile.gs"
		self->info_value1 = (_tmp7_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value1), _tmp7_);
#line 108 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value1, 2, 3, 1, 2, TRUE);
#line 110 "tracker-metadata-tile.gs"
		self->info_label2 = (_tmp8_ = tracker_metadata_tile_CreateLabel (self, N_ ("Size:"), FALSE), _g_object_unref0 (self->info_label2), _tmp8_);
#line 111 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label2, 3, 4, 1, 2, FALSE);
#line 112 "tracker-metadata-tile.gs"
		self->info_value2 = (_tmp9_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value2), _tmp9_);
#line 113 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value2, 4, 5, 1, 2, TRUE);
#line 115 "tracker-metadata-tile.gs"
		self->info_label3 = (_tmp10_ = tracker_metadata_tile_CreateLabel (self, N_ ("Modified:"), FALSE), _g_object_unref0 (self->info_label3), _tmp10_);
#line 116 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label3, 5, 6, 1, 2, FALSE);
#line 117 "tracker-metadata-tile.gs"
		self->info_value3 = (_tmp11_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value3), _tmp11_);
#line 118 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value3, 6, 7, 1, 2, TRUE);
#line 120 "tracker-metadata-tile.gs"
		self->info_label4 = (_tmp12_ = tracker_metadata_tile_CreateLabel (self, "", FALSE), _g_object_unref0 (self->info_label4), _tmp12_);
#line 121 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label4, 1, 2, 2, 3, FALSE);
#line 122 "tracker-metadata-tile.gs"
		self->info_value4 = (_tmp13_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value4), _tmp13_);
#line 123 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value4, 2, 3, 2, 3, TRUE);
#line 125 "tracker-metadata-tile.gs"
		self->info_label5 = (_tmp14_ = tracker_metadata_tile_CreateLabel (self, "", FALSE), _g_object_unref0 (self->info_label5), _tmp14_);
#line 126 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label5, 3, 4, 2, 3, FALSE);
#line 127 "tracker-metadata-tile.gs"
		self->info_value5 = (_tmp15_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value5), _tmp15_);
#line 128 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value5, 4, 5, 2, 3, TRUE);
#line 130 "tracker-metadata-tile.gs"
		self->info_label6 = (_tmp16_ = tracker_metadata_tile_CreateLabel (self, "", FALSE), _g_object_unref0 (self->info_label6), _tmp16_);
#line 131 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label6, 5, 6, 2, 3, FALSE);
#line 132 "tracker-metadata-tile.gs"
		self->info_value6 = (_tmp17_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value6), _tmp17_);
#line 133 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value6, 6, 7, 2, 3, TRUE);
#line 135 "tracker-metadata-tile.gs"
		tracker_metadata_tile_ClearLabels (self);
#line 1408 "tracker-metadata-tile.c"
	}
	return obj;
}


static void tracker_metadata_tile_class_init (TrackerMetadataTileClass * klass) {
	tracker_metadata_tile_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerMetadataTilePrivate));
	G_OBJECT_CLASS (klass)->get_property = tracker_metadata_tile_get_property;
	G_OBJECT_CLASS (klass)->set_property = tracker_metadata_tile_set_property;
	G_OBJECT_CLASS (klass)->constructor = tracker_metadata_tile_constructor;
	G_OBJECT_CLASS (klass)->finalize = tracker_metadata_tile_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_METADATA_TILE_QUERY, g_param_spec_object ("Query", "Query", "Query", TYPE_TRACKER_QUERY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_METADATA_TILE_RESULT_GRID, g_param_spec_object ("ResultGrid", "ResultGrid", "ResultGrid", TYPE_TRACKER_RESULT_GRID, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void tracker_metadata_tile_instance_init (TrackerMetadataTile * self) {
	self->priv = TRACKER_METADATA_TILE_GET_PRIVATE (self);
}


static void tracker_metadata_tile_finalize (GObject* obj) {
	TrackerMetadataTile * self;
	self = TRACKER_METADATA_TILE (obj);
	_g_free0 (self->uri);
	_g_object_unref0 (self->image);
	_g_object_unref0 (self->name_link);
	_g_object_unref0 (self->path_link);
	_g_object_unref0 (self->table);
	_g_object_unref0 (self->name_label);
	_g_object_unref0 (self->path_label);
	_g_object_unref0 (self->info_label1);
	_g_object_unref0 (self->info_value1);
	_g_object_unref0 (self->info_label2);
	_g_object_unref0 (self->info_value2);
	_g_object_unref0 (self->info_label3);
	_g_object_unref0 (self->info_value3);
	_g_object_unref0 (self->info_label4);
	_g_object_unref0 (self->info_value4);
	_g_object_unref0 (self->info_label5);
	_g_object_unref0 (self->info_value5);
	_g_object_unref0 (self->info_label6);
	_g_object_unref0 (self->info_value6);
	_g_object_unref0 (self->priv->_result_grid);
	G_OBJECT_CLASS (tracker_metadata_tile_parent_class)->finalize (obj);
}


GType tracker_metadata_tile_get_type (void) {
	static volatile gsize tracker_metadata_tile_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_metadata_tile_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerMetadataTileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_metadata_tile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerMetadataTile), 0, (GInstanceInitFunc) tracker_metadata_tile_instance_init, NULL };
		GType tracker_metadata_tile_type_id;
		tracker_metadata_tile_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "TrackerMetadataTile", &g_define_type_info, 0);
		g_once_init_leave (&tracker_metadata_tile_type_id__volatile, tracker_metadata_tile_type_id);
	}
	return tracker_metadata_tile_type_id__volatile;
}


static void tracker_metadata_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerMetadataTile * self;
	self = TRACKER_METADATA_TILE (object);
	switch (property_id) {
		case TRACKER_METADATA_TILE_QUERY:
		g_value_set_object (value, tracker_metadata_tile_get_Query (self));
		break;
		case TRACKER_METADATA_TILE_RESULT_GRID:
		g_value_set_object (value, tracker_metadata_tile_get_ResultGrid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void tracker_metadata_tile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerMetadataTile * self;
	self = TRACKER_METADATA_TILE (object);
	switch (property_id) {
		case TRACKER_METADATA_TILE_QUERY:
		tracker_metadata_tile_set_Query (self, g_value_get_object (value));
		break;
		case TRACKER_METADATA_TILE_RESULT_GRID:
		tracker_metadata_tile_set_ResultGrid (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




