/* tracker-query.c generated by valac 0.14.0, the Vala compiler
 * generated from tracker-query.vala, do not modify */

/**/
/* Copyright 2010, Martyn Russell <martyn@lanedo.com>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define TRACKER_TYPE_QUERY (tracker_query_get_type ())
#define TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_QUERY, TrackerQuery))
#define TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_QUERY, TrackerQueryClass))
#define TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_QUERY))
#define TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_QUERY))
#define TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_QUERY, TrackerQueryClass))

typedef struct _TrackerQuery TrackerQuery;
typedef struct _TrackerQueryClass TrackerQueryClass;
typedef struct _TrackerQueryPrivate TrackerQueryPrivate;

#define TRACKER_QUERY_TYPE_TYPE (tracker_query_type_get_type ())

#define TRACKER_QUERY_TYPE_MATCH (tracker_query_match_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (tracker_query_unref (var), NULL)))
typedef struct _TrackerQueryGetCountAsyncData TrackerQueryGetCountAsyncData;
typedef struct _TrackerQueryPerformAsyncData TrackerQueryPerformAsyncData;
typedef struct _TrackerParamSpecQuery TrackerParamSpecQuery;

struct _TrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerQueryPrivate * priv;
};

struct _TrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerQuery *self);
};

struct _TrackerQueryPrivate {
	gchar** match_clauses;
	gint match_clauses_length1;
	gint _match_clauses_size_;
	gchar** where_clauses;
	gint where_clauses_length1;
	gint _where_clauses_size_;
	gchar* _criteria;
	guint _offset;
	guint _limit;
	gchar* _query;
};

typedef enum  {
	TRACKER_QUERY_TYPE_ALL,
	TRACKER_QUERY_TYPE_CONTACTS,
	TRACKER_QUERY_TYPE_APPLICATIONS,
	TRACKER_QUERY_TYPE_MUSIC,
	TRACKER_QUERY_TYPE_IMAGES,
	TRACKER_QUERY_TYPE_VIDEOS,
	TRACKER_QUERY_TYPE_DOCUMENTS,
	TRACKER_QUERY_TYPE_MAIL,
	TRACKER_QUERY_TYPE_CALENDAR,
	TRACKER_QUERY_TYPE_FOLDERS,
	TRACKER_QUERY_TYPE_BOOKMARKS
} TrackerQueryType;

typedef enum  {
	TRACKER_QUERY_MATCH_NONE,
	TRACKER_QUERY_MATCH_FTS,
	TRACKER_QUERY_MATCH_FTS_INDIRECT,
	TRACKER_QUERY_MATCH_TITLES,
	TRACKER_QUERY_MATCH_TITLES_INDIRECT
} TrackerQueryMatch;

struct _TrackerQueryGetCountAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerQuery* self;
	TrackerQueryType query_type;
	TrackerQueryMatch match_type;
	GCancellable* cancellable;
	guint result;
	TrackerSparqlConnection* _tmp0_;
	TrackerSparqlCursor* cursor;
	TrackerQueryType _tmp1_;
	TrackerQueryMatch _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	TrackerQueryMatch _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* criteria_escaped;
	gchar** _tmp15_;
	gint _tmp15__length1;
	TrackerQueryMatch _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* match;
	gchar** _tmp20_;
	gint _tmp20__length1;
	TrackerQueryType _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	TrackerSparqlConnection* _tmp28_;
	const gchar* _tmp29_;
	TrackerSparqlCursor* _tmp30_;
	TrackerSparqlCursor* _tmp31_;
	TrackerSparqlCursor* _tmp32_;
	GError* e;
	GError* _tmp33_;
	const gchar* _tmp34_;
	TrackerSparqlCursor* _tmp35_;
	gint64 _tmp36_;
	GError * _inner_error_;
};

struct _TrackerQueryPerformAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerQuery* self;
	TrackerQueryType query_type;
	TrackerQueryMatch match_type;
	gchar** args;
	gint args_length1;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlConnection* _tmp0_;
	TrackerSparqlCursor* cursor;
	TrackerQueryType _tmp1_;
	TrackerQueryMatch _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	TrackerQueryMatch _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	guint _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* criteria_escaped;
	gchar** _tmp16_;
	gint _tmp16__length1;
	TrackerQueryMatch _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* match;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	TrackerQueryType _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	const gchar* _tmp36_;
	guint _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	guint _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	const gchar* _tmp47_;
	TrackerSparqlConnection* _tmp48_;
	const gchar* _tmp49_;
	TrackerSparqlCursor* _tmp50_;
	TrackerSparqlCursor* _tmp51_;
	GError* e;
	GError* _tmp52_;
	const gchar* _tmp53_;
	GError * _inner_error_;
};

struct _TrackerParamSpecQuery {
	GParamSpec parent_instance;
};


static gpointer tracker_query_parent_class = NULL;
static TrackerSparqlConnection* tracker_query_connection;
static TrackerSparqlConnection* tracker_query_connection = NULL;

gpointer tracker_query_ref (gpointer instance);
void tracker_query_unref (gpointer instance);
GParamSpec* tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_query (GValue* value, gpointer v_object);
void tracker_value_take_query (GValue* value, gpointer v_object);
gpointer tracker_value_get_query (const GValue* value);
GType tracker_query_get_type (void) G_GNUC_CONST;
#define TRACKER_QUERY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_QUERY, TrackerQueryPrivate))
enum  {
	TRACKER_QUERY_DUMMY_PROPERTY
};
GType tracker_query_type_get_type (void) G_GNUC_CONST;
GType tracker_query_match_get_type (void) G_GNUC_CONST;
TrackerQuery* tracker_query_new (void);
TrackerQuery* tracker_query_construct (GType object_type);
static gboolean tracker_query_check_query_and_match_type (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type);
static void tracker_query_get_count_async_data_free (gpointer _data);
void tracker_query_get_count_async (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
guint tracker_query_get_count_finish (TrackerQuery* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_query_get_count_async_co (TrackerQueryGetCountAsyncData* _data_);
const gchar* tracker_query_get_criteria (TrackerQuery* self);
static void tracker_query_set_query (TrackerQuery* self, const gchar* value);
const gchar* tracker_query_get_query (TrackerQuery* self);
static void tracker_query_get_count_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_query_perform_async_data_free (gpointer _data);
static gchar** _vala_array_dup2 (gchar** self, int length);
void tracker_query_perform_async (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type, gchar** args, int args_length1, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlCursor* tracker_query_perform_finish (TrackerQuery* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_query_perform_async_co (TrackerQueryPerformAsyncData* _data_);
guint tracker_query_get_limit (TrackerQuery* self);
guint tracker_query_get_offset (TrackerQuery* self);
static void tracker_query_perform_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tracker_query_set_criteria (TrackerQuery* self, const gchar* value);
void tracker_query_set_offset (TrackerQuery* self, guint value);
void tracker_query_set_limit (TrackerQuery* self, guint value);
static void tracker_query_finalize (TrackerQuery* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType tracker_query_type_get_type (void) {
	static volatile gsize tracker_query_type_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_query_type_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_QUERY_TYPE_ALL, "TRACKER_QUERY_TYPE_ALL", "all"}, {TRACKER_QUERY_TYPE_CONTACTS, "TRACKER_QUERY_TYPE_CONTACTS", "contacts"}, {TRACKER_QUERY_TYPE_APPLICATIONS, "TRACKER_QUERY_TYPE_APPLICATIONS", "applications"}, {TRACKER_QUERY_TYPE_MUSIC, "TRACKER_QUERY_TYPE_MUSIC", "music"}, {TRACKER_QUERY_TYPE_IMAGES, "TRACKER_QUERY_TYPE_IMAGES", "images"}, {TRACKER_QUERY_TYPE_VIDEOS, "TRACKER_QUERY_TYPE_VIDEOS", "videos"}, {TRACKER_QUERY_TYPE_DOCUMENTS, "TRACKER_QUERY_TYPE_DOCUMENTS", "documents"}, {TRACKER_QUERY_TYPE_MAIL, "TRACKER_QUERY_TYPE_MAIL", "mail"}, {TRACKER_QUERY_TYPE_CALENDAR, "TRACKER_QUERY_TYPE_CALENDAR", "calendar"}, {TRACKER_QUERY_TYPE_FOLDERS, "TRACKER_QUERY_TYPE_FOLDERS", "folders"}, {TRACKER_QUERY_TYPE_BOOKMARKS, "TRACKER_QUERY_TYPE_BOOKMARKS", "bookmarks"}, {0, NULL, NULL}};
		GType tracker_query_type_type_id;
		tracker_query_type_type_id = g_enum_register_static ("TrackerQueryType", values);
		g_once_init_leave (&tracker_query_type_type_id__volatile, tracker_query_type_type_id);
	}
	return tracker_query_type_type_id__volatile;
}


GType tracker_query_match_get_type (void) {
	static volatile gsize tracker_query_match_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_query_match_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_QUERY_MATCH_NONE, "TRACKER_QUERY_MATCH_NONE", "none"}, {TRACKER_QUERY_MATCH_FTS, "TRACKER_QUERY_MATCH_FTS", "fts"}, {TRACKER_QUERY_MATCH_FTS_INDIRECT, "TRACKER_QUERY_MATCH_FTS_INDIRECT", "fts-indirect"}, {TRACKER_QUERY_MATCH_TITLES, "TRACKER_QUERY_MATCH_TITLES", "titles"}, {TRACKER_QUERY_MATCH_TITLES_INDIRECT, "TRACKER_QUERY_MATCH_TITLES_INDIRECT", "titles-indirect"}, {0, NULL, NULL}};
		GType tracker_query_match_type_id;
		tracker_query_match_type_id = g_enum_register_static ("TrackerQueryMatch", values);
		g_once_init_leave (&tracker_query_match_type_id__volatile, tracker_query_match_type_id);
	}
	return tracker_query_match_type_id__volatile;
}


TrackerQuery* tracker_query_construct (GType object_type) {
	TrackerQuery* self = NULL;
	GError * _inner_error_ = NULL;
#line 167 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	self = (TrackerQuery*) g_type_create_instance (object_type);
#line 311 "tracker-query.c"
	{
		TrackerSparqlConnection* _tmp0_ = NULL;
		TrackerSparqlConnection* _tmp1_;
#line 169 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_tmp0_ = tracker_sparql_connection_get (NULL, &_inner_error_);
#line 169 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_tmp1_ = _tmp0_;
#line 169 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		if (_inner_error_ != NULL) {
#line 321 "tracker-query.c"
			goto __catch3_g_error;
		}
#line 169 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_g_object_unref0 (tracker_query_connection);
#line 169 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		tracker_query_connection = _tmp1_;
#line 328 "tracker-query.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		e = _inner_error_;
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_inner_error_ = NULL;
#line 171 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_tmp2_ = e;
#line 171 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_tmp3_ = _tmp2_->message;
#line 171 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_warning ("tracker-query.vala:171: Could not get Sparql connection: %s", _tmp3_);
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_g_error_free0 (e);
#line 348 "tracker-query.c"
	}
	__finally3:
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (_inner_error_ != NULL) {
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_clear_error (&_inner_error_);
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		return NULL;
#line 359 "tracker-query.c"
	}
#line 167 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	return self;
#line 363 "tracker-query.c"
}


TrackerQuery* tracker_query_new (void) {
#line 167 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	return tracker_query_construct (TRACKER_TYPE_QUERY);
#line 370 "tracker-query.c"
}


static gboolean tracker_query_check_query_and_match_type (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TrackerQueryType _tmp1_;
	gboolean _tmp3_;
	gboolean _tmp5_ = FALSE;
	TrackerQueryType _tmp6_;
	gboolean _tmp11_;
	gboolean _tmp12_ = FALSE;
	TrackerQueryType _tmp13_;
	gboolean _tmp21_;
#line 175 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 176 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp1_ = query_type;
#line 176 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (_tmp1_ != TRACKER_QUERY_TYPE_IMAGES) {
#line 391 "tracker-query.c"
		TrackerQueryMatch _tmp2_;
#line 176 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_tmp2_ = match_type;
#line 176 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_tmp0_ = _tmp2_ == TRACKER_QUERY_MATCH_NONE;
#line 397 "tracker-query.c"
	} else {
#line 176 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_tmp0_ = FALSE;
#line 401 "tracker-query.c"
	}
#line 176 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp3_ = _tmp0_;
#line 176 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (_tmp3_) {
#line 407 "tracker-query.c"
		TrackerQueryType _tmp4_;
#line 177 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_tmp4_ = query_type;
#line 177 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_critical ("tracker-query.vala:177: You can not use a non-IMAGES query (%d) with N" \
"ONE matching", (gint) _tmp4_);
#line 178 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		result = FALSE;
#line 178 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		return result;
#line 417 "tracker-query.c"
	}
#line 181 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp6_ = query_type;
#line 181 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (_tmp6_ == TRACKER_QUERY_TYPE_MUSIC) {
#line 423 "tracker-query.c"
		gboolean _tmp7_ = FALSE;
		TrackerQueryMatch _tmp8_;
		gboolean _tmp10_;
#line 181 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_tmp8_ = match_type;
#line 181 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		if (_tmp8_ == TRACKER_QUERY_MATCH_FTS_INDIRECT) {
#line 181 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_tmp7_ = TRUE;
#line 433 "tracker-query.c"
		} else {
			TrackerQueryMatch _tmp9_;
#line 182 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_tmp9_ = match_type;
#line 182 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_tmp7_ = _tmp9_ == TRACKER_QUERY_MATCH_TITLES_INDIRECT;
#line 440 "tracker-query.c"
		}
#line 181 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_tmp10_ = _tmp7_;
#line 181 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_tmp5_ = !_tmp10_;
#line 446 "tracker-query.c"
	} else {
#line 181 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_tmp5_ = FALSE;
#line 450 "tracker-query.c"
	}
#line 181 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp11_ = _tmp5_;
#line 181 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (_tmp11_) {
#line 183 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_critical ("tracker-query.vala:183: You can not use a MUSIC query with match TITLE" \
"S or FTS, INDIRECT required");
#line 184 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		result = FALSE;
#line 184 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		return result;
#line 462 "tracker-query.c"
	}
#line 187 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp13_ = query_type;
#line 187 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (_tmp13_ != TRACKER_QUERY_TYPE_MUSIC) {
#line 468 "tracker-query.c"
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		TrackerQueryMatch _tmp16_;
		gboolean _tmp18_;
		gboolean _tmp20_;
#line 187 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_tmp16_ = match_type;
#line 187 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		if (_tmp16_ == TRACKER_QUERY_MATCH_NONE) {
#line 187 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_tmp15_ = TRUE;
#line 480 "tracker-query.c"
		} else {
			TrackerQueryMatch _tmp17_;
#line 188 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_tmp17_ = match_type;
#line 188 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_tmp15_ = _tmp17_ == TRACKER_QUERY_MATCH_FTS;
#line 487 "tracker-query.c"
		}
#line 187 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_tmp18_ = _tmp15_;
#line 187 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		if (_tmp18_) {
#line 187 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_tmp14_ = TRUE;
#line 495 "tracker-query.c"
		} else {
			TrackerQueryMatch _tmp19_;
#line 189 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_tmp19_ = match_type;
#line 189 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_tmp14_ = _tmp19_ == TRACKER_QUERY_MATCH_TITLES;
#line 502 "tracker-query.c"
		}
#line 187 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_tmp20_ = _tmp14_;
#line 187 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_tmp12_ = !_tmp20_;
#line 508 "tracker-query.c"
	} else {
#line 187 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_tmp12_ = FALSE;
#line 512 "tracker-query.c"
	}
#line 187 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp21_ = _tmp12_;
#line 187 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (_tmp21_) {
#line 518 "tracker-query.c"
		TrackerQueryType _tmp22_;
		TrackerQueryMatch _tmp23_;
#line 190 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_tmp22_ = query_type;
#line 190 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_tmp23_ = match_type;
#line 190 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_critical ("tracker-query.vala:190: You can not use a non-MUSIC query (%d) with IN" \
"DIRECT matching (%d)", (gint) _tmp22_, (gint) _tmp23_);
#line 191 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		result = FALSE;
#line 191 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		return result;
#line 531 "tracker-query.c"
	}
#line 194 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	result = TRUE;
#line 194 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	return result;
#line 537 "tracker-query.c"
}


static void tracker_query_get_count_async_data_free (gpointer _data) {
	TrackerQueryGetCountAsyncData* _data_;
	_data_ = _data;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_object_unref0 (_data_->cancellable);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tracker_query_unref0 (_data_->self);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_slice_free (TrackerQueryGetCountAsyncData, _data_);
#line 550 "tracker-query.c"
}


static gpointer _tracker_query_ref0 (gpointer self) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	return self ? tracker_query_ref (self) : NULL;
#line 557 "tracker-query.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	return self ? g_object_ref (self) : NULL;
#line 564 "tracker-query.c"
}


void tracker_query_get_count_async (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerQueryGetCountAsyncData* _data_;
	TrackerQuery* _tmp0_;
	TrackerQueryType _tmp1_;
	TrackerQueryMatch _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_ = g_slice_new0 (TrackerQueryGetCountAsyncData);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_query_get_count_async);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_query_get_count_async_data_free);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp0_ = _tracker_query_ref0 (self);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->self = _tmp0_;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp1_ = query_type;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->query_type = _tmp1_;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp2_ = match_type;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->match_type = _tmp2_;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp3_ = cancellable;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->cancellable = _tmp4_;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	tracker_query_get_count_async_co (_data_);
#line 601 "tracker-query.c"
}


guint tracker_query_get_count_finish (TrackerQuery* self, GAsyncResult* _res_, GError** error) {
	guint result;
	TrackerQueryGetCountAsyncData* _data_;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		return 0U;
#line 612 "tracker-query.c"
	}
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	result = _data_->result;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	return result;
#line 620 "tracker-query.c"
}


static void tracker_query_get_count_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerQueryGetCountAsyncData* _data_;
#line 216 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_ = _user_data_;
#line 216 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_source_object_ = source_object;
#line 216 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_res_ = _res_;
#line 216 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	tracker_query_get_count_async_co (_data_);
#line 634 "tracker-query.c"
}


static gboolean tracker_query_get_count_async_co (TrackerQueryGetCountAsyncData* _data_) {
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	switch (_data_->_state_) {
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		case 0:
#line 643 "tracker-query.c"
		goto _state_0;
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		case 1:
#line 647 "tracker-query.c"
		goto _state_1;
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		case 2:
#line 651 "tracker-query.c"
		goto _state_2;
		default:
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_assert_not_reached ();
#line 656 "tracker-query.c"
	}
	_state_0:
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp0_ = tracker_query_connection;
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_return_val_if_fail (_data_->_tmp0_ != NULL, FALSE);
#line 199 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->cursor = NULL;
#line 201 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp1_ = _data_->query_type;
#line 201 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp2_ = _data_->match_type;
#line 201 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp3_ = FALSE;
#line 201 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp3_ = tracker_query_check_query_and_match_type (_data_->self, _data_->_tmp1_, _data_->_tmp2_);
#line 201 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (!_data_->_tmp3_) {
#line 202 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->result = (guint) 0;
#line 202 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_g_object_unref0 (_data_->cursor);
#line 202 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		if (_data_->_state_ == 0) {
#line 202 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 683 "tracker-query.c"
		} else {
#line 202 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 687 "tracker-query.c"
		}
#line 202 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_object_unref (_data_->_async_result);
#line 202 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		return FALSE;
#line 693 "tracker-query.c"
	}
#line 205 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp5_ = _data_->match_type;
#line 205 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (_data_->_tmp5_ != TRACKER_QUERY_MATCH_NONE) {
#line 205 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp7_ = _data_->self->priv->_criteria;
#line 205 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		if (_data_->_tmp7_ == NULL) {
#line 205 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_data_->_tmp6_ = TRUE;
#line 705 "tracker-query.c"
		} else {
#line 205 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_data_->_tmp8_ = _data_->self->priv->_criteria;
#line 205 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_data_->_tmp9_ = strlen (_data_->_tmp8_);
#line 205 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_data_->_tmp10_ = _data_->_tmp9_;
#line 205 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_data_->_tmp6_ = _data_->_tmp10_ < 1;
#line 715 "tracker-query.c"
		}
#line 205 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp11_ = _data_->_tmp6_;
#line 205 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp4_ = _data_->_tmp11_;
#line 721 "tracker-query.c"
	} else {
#line 205 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp4_ = FALSE;
#line 725 "tracker-query.c"
	}
#line 205 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp12_ = _data_->_tmp4_;
#line 205 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (_data_->_tmp12_) {
#line 206 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_warning ("tracker-query.vala:206: Criteria was NULL or an empty string, no query" \
" performed");
#line 207 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->result = (guint) 0;
#line 207 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_g_object_unref0 (_data_->cursor);
#line 207 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		if (_data_->_state_ == 0) {
#line 207 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 741 "tracker-query.c"
		} else {
#line 207 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 745 "tracker-query.c"
		}
#line 207 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_object_unref (_data_->_async_result);
#line 207 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		return FALSE;
#line 751 "tracker-query.c"
	}
#line 210 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp13_ = _data_->self->priv->_criteria;
#line 210 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp14_ = NULL;
#line 210 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp14_ = tracker_sparql_escape_string (_data_->_tmp13_);
#line 210 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->criteria_escaped = _data_->_tmp14_;
#line 211 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp15_ = _data_->self->priv->match_clauses;
#line 211 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp15__length1 = _data_->self->priv->match_clauses_length1;
#line 211 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp16_ = _data_->match_type;
#line 211 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp17_ = _data_->_tmp15_[_data_->_tmp16_];
#line 211 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp18_ = _data_->criteria_escaped;
#line 211 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp19_ = NULL;
#line 211 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp19_ = g_strdup_printf (_data_->_tmp17_, _data_->_tmp18_);
#line 211 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->match = _data_->_tmp19_;
#line 213 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp20_ = _data_->self->priv->where_clauses;
#line 213 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp20__length1 = _data_->self->priv->where_clauses_length1;
#line 213 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp21_ = _data_->query_type;
#line 213 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp22_ = _data_->_tmp20_[_data_->_tmp21_];
#line 213 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp23_ = _data_->match;
#line 213 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp24_ = NULL;
#line 213 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp24_ = g_strdup_printf (_data_->_tmp22_, _data_->_tmp23_);
#line 213 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp25_ = _data_->_tmp24_;
#line 213 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp26_ = g_strconcat ("SELECT count(?urn) ", _data_->_tmp25_, NULL);
#line 213 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp27_ = _data_->_tmp26_;
#line 213 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	tracker_query_set_query (_data_->self, _data_->_tmp27_);
#line 213 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (_data_->_tmp27_);
#line 213 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (_data_->_tmp25_);
#line 803 "tracker-query.c"
	{
#line 216 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp28_ = tracker_query_connection;
#line 216 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp29_ = _data_->self->priv->_query;
#line 216 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_state_ = 1;
#line 216 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		tracker_sparql_connection_query_async (_data_->_tmp28_, _data_->_tmp29_, NULL, tracker_query_get_count_async_ready, _data_);
#line 216 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		return FALSE;
#line 815 "tracker-query.c"
		_state_1:
#line 216 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp30_ = NULL;
#line 216 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp30_ = tracker_sparql_connection_query_finish (_data_->_tmp28_, _data_->_res_, &_data_->_inner_error_);
#line 216 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp31_ = _data_->_tmp30_;
#line 216 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		if (_data_->_inner_error_ != NULL) {
#line 825 "tracker-query.c"
			goto __catch4_g_error;
		}
#line 216 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_g_object_unref0 (_data_->cursor);
#line 216 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->cursor = _data_->_tmp31_;
#line 217 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp32_ = _data_->cursor;
#line 217 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_state_ = 2;
#line 217 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		tracker_sparql_cursor_next_async (_data_->_tmp32_, NULL, tracker_query_get_count_async_ready, _data_);
#line 217 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		return FALSE;
#line 840 "tracker-query.c"
		_state_2:
#line 217 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		tracker_sparql_cursor_next_finish (_data_->_tmp32_, _data_->_res_, &_data_->_inner_error_);
#line 217 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		if (_data_->_inner_error_ != NULL) {
#line 846 "tracker-query.c"
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
#line 215 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->e = _data_->_inner_error_;
#line 215 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_inner_error_ = NULL;
#line 219 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp33_ = _data_->e;
#line 219 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp34_ = _data_->_tmp33_->message;
#line 219 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_warning ("tracker-query.vala:219: Could not run Sparql count query: %s", _data_->_tmp34_);
#line 215 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_g_error_free0 (_data_->e);
#line 865 "tracker-query.c"
	}
	__finally4:
#line 215 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (_data_->_inner_error_ != NULL) {
#line 215 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		if (_data_->_inner_error_->domain == G_IO_ERROR) {
#line 215 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 215 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			g_error_free (_data_->_inner_error_);
#line 215 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_g_free0 (_data_->match);
#line 215 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_g_free0 (_data_->criteria_escaped);
#line 215 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_g_object_unref0 (_data_->cursor);
#line 215 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			if (_data_->_state_ == 0) {
#line 215 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 886 "tracker-query.c"
			} else {
#line 215 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 890 "tracker-query.c"
			}
#line 215 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			g_object_unref (_data_->_async_result);
#line 215 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			return FALSE;
#line 896 "tracker-query.c"
		} else {
#line 215 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_g_free0 (_data_->match);
#line 215 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_g_free0 (_data_->criteria_escaped);
#line 215 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_g_object_unref0 (_data_->cursor);
#line 215 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 215 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			g_clear_error (&_data_->_inner_error_);
#line 215 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			return FALSE;
#line 910 "tracker-query.c"
		}
	}
#line 222 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp35_ = _data_->cursor;
#line 222 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp36_ = 0LL;
#line 222 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp36_ = tracker_sparql_cursor_get_integer (_data_->_tmp35_, 0);
#line 222 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->result = (guint) _data_->_tmp36_;
#line 222 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (_data_->match);
#line 222 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (_data_->criteria_escaped);
#line 222 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_object_unref0 (_data_->cursor);
#line 222 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (_data_->_state_ == 0) {
#line 222 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 931 "tracker-query.c"
	} else {
#line 222 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 935 "tracker-query.c"
	}
#line 222 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_object_unref (_data_->_async_result);
#line 222 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	return FALSE;
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (_data_->match);
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (_data_->criteria_escaped);
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_object_unref0 (_data_->cursor);
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (_data_->_state_ == 0) {
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 951 "tracker-query.c"
	} else {
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 955 "tracker-query.c"
	}
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_object_unref (_data_->_async_result);
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	return FALSE;
#line 961 "tracker-query.c"
}


static void tracker_query_perform_async_data_free (gpointer _data) {
	TrackerQueryPerformAsyncData* _data_;
	_data_ = _data;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_object_unref0 (_data_->cancellable);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_object_unref0 (_data_->result);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tracker_query_unref0 (_data_->self);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_slice_free (TrackerQueryPerformAsyncData, _data_);
#line 978 "tracker-query.c"
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	result = g_new0 (gchar*, length + 1);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	for (i = 0; i < length; i++) {
#line 989 "tracker-query.c"
		gchar* _tmp0_;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_tmp0_ = g_strdup (self[i]);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		result[i] = _tmp0_;
#line 995 "tracker-query.c"
	}
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	return result;
#line 999 "tracker-query.c"
}


void tracker_query_perform_async (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type, gchar** args, int args_length1, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerQueryPerformAsyncData* _data_;
	TrackerQuery* _tmp0_;
	TrackerQueryType _tmp1_;
	TrackerQueryMatch _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_ = g_slice_new0 (TrackerQueryPerformAsyncData);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_query_perform_async);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_query_perform_async_data_free);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp0_ = _tracker_query_ref0 (self);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->self = _tmp0_;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp1_ = query_type;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->query_type = _tmp1_;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp2_ = match_type;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->match_type = _tmp2_;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp3_ = args;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp3__length1 = args_length1;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup2 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp4__length1 = _tmp3__length1;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->args = _tmp4_;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->args_length1 = _tmp4__length1;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp5_ = cancellable;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->cancellable = _tmp6_;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	tracker_query_perform_async_co (_data_);
#line 1052 "tracker-query.c"
}


TrackerSparqlCursor* tracker_query_perform_finish (TrackerQuery* self, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerQueryPerformAsyncData* _data_;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		return NULL;
#line 1063 "tracker-query.c"
	}
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	result = _data_->result;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->result = NULL;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	return result;
#line 1073 "tracker-query.c"
}


static void tracker_query_perform_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerQueryPerformAsyncData* _data_;
#line 252 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_ = _user_data_;
#line 252 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_source_object_ = source_object;
#line 252 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_res_ = _res_;
#line 252 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	tracker_query_perform_async_co (_data_);
#line 1087 "tracker-query.c"
}


static gboolean tracker_query_perform_async_co (TrackerQueryPerformAsyncData* _data_) {
#line 225 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	switch (_data_->_state_) {
#line 225 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		case 0:
#line 1096 "tracker-query.c"
		goto _state_0;
#line 225 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		case 1:
#line 1100 "tracker-query.c"
		goto _state_1;
		default:
#line 225 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_assert_not_reached ();
#line 1105 "tracker-query.c"
	}
	_state_0:
#line 225 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp0_ = tracker_query_connection;
#line 225 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_return_val_if_fail (_data_->_tmp0_ != NULL, FALSE);
#line 227 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->cursor = NULL;
#line 229 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp1_ = _data_->query_type;
#line 229 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp2_ = _data_->match_type;
#line 229 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp3_ = FALSE;
#line 229 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp3_ = tracker_query_check_query_and_match_type (_data_->self, _data_->_tmp1_, _data_->_tmp2_);
#line 229 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (!_data_->_tmp3_) {
#line 230 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->result = NULL;
#line 230 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_g_object_unref0 (_data_->cursor);
#line 230 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		if (_data_->_state_ == 0) {
#line 230 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1132 "tracker-query.c"
		} else {
#line 230 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1136 "tracker-query.c"
		}
#line 230 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_object_unref (_data_->_async_result);
#line 230 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		return FALSE;
#line 1142 "tracker-query.c"
	}
#line 233 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp5_ = _data_->match_type;
#line 233 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (_data_->_tmp5_ != TRACKER_QUERY_MATCH_NONE) {
#line 233 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp7_ = _data_->self->priv->_criteria;
#line 233 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		if (_data_->_tmp7_ == NULL) {
#line 233 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_data_->_tmp6_ = TRUE;
#line 1154 "tracker-query.c"
		} else {
#line 233 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_data_->_tmp8_ = _data_->self->priv->_criteria;
#line 233 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_data_->_tmp9_ = strlen (_data_->_tmp8_);
#line 233 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_data_->_tmp10_ = _data_->_tmp9_;
#line 233 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_data_->_tmp6_ = _data_->_tmp10_ < 1;
#line 1164 "tracker-query.c"
		}
#line 233 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp11_ = _data_->_tmp6_;
#line 233 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp4_ = _data_->_tmp11_;
#line 1170 "tracker-query.c"
	} else {
#line 233 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp4_ = FALSE;
#line 1174 "tracker-query.c"
	}
#line 233 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp12_ = _data_->_tmp4_;
#line 233 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (_data_->_tmp12_) {
#line 234 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_warning ("tracker-query.vala:234: Criteria was NULL or an empty string, no query" \
" performed");
#line 235 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->result = NULL;
#line 235 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_g_object_unref0 (_data_->cursor);
#line 235 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		if (_data_->_state_ == 0) {
#line 235 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1190 "tracker-query.c"
		} else {
#line 235 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1194 "tracker-query.c"
		}
#line 235 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_object_unref (_data_->_async_result);
#line 235 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		return FALSE;
#line 1200 "tracker-query.c"
	}
#line 238 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp13_ = _data_->self->priv->_limit;
#line 238 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (_data_->_tmp13_ < ((guint) 1)) {
#line 239 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_warning ("tracker-query.vala:239: Limit was < 1, no query performed");
#line 240 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->result = NULL;
#line 240 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_g_object_unref0 (_data_->cursor);
#line 240 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		if (_data_->_state_ == 0) {
#line 240 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1216 "tracker-query.c"
		} else {
#line 240 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1220 "tracker-query.c"
		}
#line 240 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_object_unref (_data_->_async_result);
#line 240 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		return FALSE;
#line 1226 "tracker-query.c"
	}
#line 243 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp14_ = _data_->self->priv->_criteria;
#line 243 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp15_ = NULL;
#line 243 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp15_ = tracker_sparql_escape_string (_data_->_tmp14_);
#line 243 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->criteria_escaped = _data_->_tmp15_;
#line 244 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp16_ = _data_->self->priv->match_clauses;
#line 244 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp16__length1 = _data_->self->priv->match_clauses_length1;
#line 244 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp17_ = _data_->match_type;
#line 244 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp18_ = _data_->_tmp16_[_data_->_tmp17_];
#line 244 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp19_ = _data_->criteria_escaped;
#line 244 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp20_ = NULL;
#line 244 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp20_ = g_strdup_printf (_data_->_tmp18_, _data_->_tmp19_);
#line 244 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->match = _data_->_tmp20_;
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp21_ = _data_->args;
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp21__length1 = _data_->args_length1;
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp22_ = NULL;
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp22_ = g_strjoinv (" ", _data_->_tmp21_);
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp23_ = _data_->_tmp22_;
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp24_ = g_strconcat ("SELECT ", _data_->_tmp23_, NULL);
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp25_ = _data_->_tmp24_;
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp26_ = g_strconcat (_data_->_tmp25_, " ", NULL);
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp27_ = _data_->_tmp26_;
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp28_ = _data_->self->priv->where_clauses;
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp28__length1 = _data_->self->priv->where_clauses_length1;
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp29_ = _data_->query_type;
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp30_ = _data_->_tmp28_[_data_->_tmp29_];
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp31_ = _data_->match;
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp32_ = NULL;
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp32_ = g_strdup_printf (_data_->_tmp30_, _data_->_tmp31_);
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp33_ = _data_->_tmp32_;
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp34_ = g_strconcat (_data_->_tmp27_, _data_->_tmp33_, NULL);
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp35_ = _data_->_tmp34_;
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	tracker_query_set_query (_data_->self, _data_->_tmp35_);
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (_data_->_tmp35_);
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (_data_->_tmp33_);
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (_data_->_tmp27_);
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (_data_->_tmp25_);
#line 246 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (_data_->_tmp23_);
#line 247 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp36_ = _data_->self->priv->_query;
#line 247 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp37_ = _data_->self->priv->_offset;
#line 247 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp38_ = NULL;
#line 247 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp38_ = g_strdup_printf ("%u", _data_->_tmp37_);
#line 247 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp39_ = _data_->_tmp38_;
#line 247 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp40_ = _data_->self->priv->_limit;
#line 247 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp41_ = NULL;
#line 247 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp41_ = g_strdup_printf ("%u", _data_->_tmp40_);
#line 247 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp42_ = _data_->_tmp41_;
#line 247 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp43_ = NULL;
#line 247 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp43_ = g_strconcat (" OFFSET ", _data_->_tmp39_, " LIMIT ", _data_->_tmp42_, NULL);
#line 247 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp44_ = _data_->_tmp43_;
#line 247 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp45_ = g_strconcat (_data_->_tmp36_, _data_->_tmp44_, NULL);
#line 247 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp46_ = _data_->_tmp45_;
#line 247 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	tracker_query_set_query (_data_->self, _data_->_tmp46_);
#line 247 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (_data_->_tmp46_);
#line 247 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (_data_->_tmp44_);
#line 247 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (_data_->_tmp42_);
#line 247 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (_data_->_tmp39_);
#line 249 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->_tmp47_ = _data_->self->priv->_query;
#line 249 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_debug ("tracker-query.vala:249: Running query: '%s'", _data_->_tmp47_);
#line 1344 "tracker-query.c"
	{
#line 252 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp48_ = tracker_query_connection;
#line 252 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp49_ = _data_->self->priv->_query;
#line 252 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_state_ = 1;
#line 252 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		tracker_sparql_connection_query_async (_data_->_tmp48_, _data_->_tmp49_, NULL, tracker_query_perform_async_ready, _data_);
#line 252 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		return FALSE;
#line 1356 "tracker-query.c"
		_state_1:
#line 252 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp50_ = NULL;
#line 252 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp50_ = tracker_sparql_connection_query_finish (_data_->_tmp48_, _data_->_res_, &_data_->_inner_error_);
#line 252 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp51_ = _data_->_tmp50_;
#line 252 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1366 "tracker-query.c"
			goto __catch5_g_error;
		}
#line 252 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_g_object_unref0 (_data_->cursor);
#line 252 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->cursor = _data_->_tmp51_;
#line 1373 "tracker-query.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
#line 251 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->e = _data_->_inner_error_;
#line 251 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_inner_error_ = NULL;
#line 254 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp52_ = _data_->e;
#line 254 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_data_->_tmp53_ = _data_->_tmp52_->message;
#line 254 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_warning ("tracker-query.vala:254: Could not run Sparql query: %s", _data_->_tmp53_);
#line 251 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		_g_error_free0 (_data_->e);
#line 1390 "tracker-query.c"
	}
	__finally5:
#line 251 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (_data_->_inner_error_ != NULL) {
#line 251 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		if (_data_->_inner_error_->domain == G_IO_ERROR) {
#line 251 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 251 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			g_error_free (_data_->_inner_error_);
#line 251 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_g_free0 (_data_->match);
#line 251 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_g_free0 (_data_->criteria_escaped);
#line 251 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_g_object_unref0 (_data_->cursor);
#line 251 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			if (_data_->_state_ == 0) {
#line 251 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1411 "tracker-query.c"
			} else {
#line 251 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1415 "tracker-query.c"
			}
#line 251 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			g_object_unref (_data_->_async_result);
#line 251 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			return FALSE;
#line 1421 "tracker-query.c"
		} else {
#line 251 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_g_free0 (_data_->match);
#line 251 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_g_free0 (_data_->criteria_escaped);
#line 251 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			_g_object_unref0 (_data_->cursor);
#line 251 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 251 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			g_clear_error (&_data_->_inner_error_);
#line 251 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			return FALSE;
#line 1435 "tracker-query.c"
		}
	}
#line 257 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_debug ("tracker-query.vala:257: Done");
#line 259 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_data_->result = _data_->cursor;
#line 259 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (_data_->match);
#line 259 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (_data_->criteria_escaped);
#line 259 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (_data_->_state_ == 0) {
#line 259 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1450 "tracker-query.c"
	} else {
#line 259 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1454 "tracker-query.c"
	}
#line 259 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_object_unref (_data_->_async_result);
#line 259 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	return FALSE;
#line 225 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (_data_->match);
#line 225 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (_data_->criteria_escaped);
#line 225 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_object_unref0 (_data_->cursor);
#line 225 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (_data_->_state_ == 0) {
#line 225 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1470 "tracker-query.c"
	} else {
#line 225 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1474 "tracker-query.c"
	}
#line 225 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_object_unref (_data_->_async_result);
#line 225 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	return FALSE;
#line 1480 "tracker-query.c"
}


const gchar* tracker_query_get_criteria (TrackerQuery* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp0_ = self->priv->_criteria;
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	result = _tmp0_;
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	return result;
#line 1495 "tracker-query.c"
}


void tracker_query_set_criteria (TrackerQuery* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_return_if_fail (self != NULL);
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp0_ = value;
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (self->priv->_criteria);
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	self->priv->_criteria = _tmp1_;
#line 1512 "tracker-query.c"
}


guint tracker_query_get_offset (TrackerQuery* self) {
	guint result;
	guint _tmp0_;
#line 161 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 161 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp0_ = self->priv->_offset;
#line 161 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	result = _tmp0_;
#line 161 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	return result;
#line 1527 "tracker-query.c"
}


void tracker_query_set_offset (TrackerQuery* self, guint value) {
	guint _tmp0_;
#line 161 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_return_if_fail (self != NULL);
#line 161 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp0_ = value;
#line 161 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	self->priv->_offset = _tmp0_;
#line 1539 "tracker-query.c"
}


guint tracker_query_get_limit (TrackerQuery* self) {
	guint result;
	guint _tmp0_;
#line 162 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 162 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp0_ = self->priv->_limit;
#line 162 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	result = _tmp0_;
#line 162 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	return result;
#line 1554 "tracker-query.c"
}


void tracker_query_set_limit (TrackerQuery* self, guint value) {
	guint _tmp0_;
#line 162 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_return_if_fail (self != NULL);
#line 162 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp0_ = value;
#line 162 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	self->priv->_limit = _tmp0_;
#line 1566 "tracker-query.c"
}


const gchar* tracker_query_get_query (TrackerQuery* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 163 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 163 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp0_ = self->priv->_query;
#line 163 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	result = _tmp0_;
#line 163 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	return result;
#line 1581 "tracker-query.c"
}


static void tracker_query_set_query (TrackerQuery* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 163 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_return_if_fail (self != NULL);
#line 163 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp0_ = value;
#line 163 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 163 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (self->priv->_query);
#line 163 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	self->priv->_query = _tmp1_;
#line 1598 "tracker-query.c"
}


static void tracker_value_query_init (GValue* value) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	value->data[0].v_pointer = NULL;
#line 1605 "tracker-query.c"
}


static void tracker_value_query_free_value (GValue* value) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (value->data[0].v_pointer) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		tracker_query_unref (value->data[0].v_pointer);
#line 1614 "tracker-query.c"
	}
}


static void tracker_value_query_copy_value (const GValue* src_value, GValue* dest_value) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (src_value->data[0].v_pointer) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		dest_value->data[0].v_pointer = tracker_query_ref (src_value->data[0].v_pointer);
#line 1624 "tracker-query.c"
	} else {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1628 "tracker-query.c"
	}
}


static gpointer tracker_value_query_peek_pointer (const GValue* value) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	return value->data[0].v_pointer;
#line 1636 "tracker-query.c"
}


static gchar* tracker_value_query_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (collect_values[0].v_pointer) {
#line 1643 "tracker-query.c"
		TrackerQuery* object;
		object = collect_values[0].v_pointer;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		if (object->parent_instance.g_class == NULL) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1650 "tracker-query.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1654 "tracker-query.c"
		}
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		value->data[0].v_pointer = tracker_query_ref (object);
#line 1658 "tracker-query.c"
	} else {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		value->data[0].v_pointer = NULL;
#line 1662 "tracker-query.c"
	}
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	return NULL;
#line 1666 "tracker-query.c"
}


static gchar* tracker_value_query_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerQuery** object_p;
	object_p = collect_values[0].v_pointer;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (!object_p) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1677 "tracker-query.c"
	}
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (!value->data[0].v_pointer) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		*object_p = NULL;
#line 1683 "tracker-query.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		*object_p = value->data[0].v_pointer;
#line 1687 "tracker-query.c"
	} else {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		*object_p = tracker_query_ref (value->data[0].v_pointer);
#line 1691 "tracker-query.c"
	}
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	return NULL;
#line 1695 "tracker-query.c"
}


GParamSpec* tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerParamSpecQuery* spec;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_QUERY), NULL);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	return G_PARAM_SPEC (spec);
#line 1709 "tracker-query.c"
}


gpointer tracker_value_get_query (const GValue* value) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_QUERY), NULL);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	return value->data[0].v_pointer;
#line 1718 "tracker-query.c"
}


void tracker_value_set_query (GValue* value, gpointer v_object) {
	TrackerQuery* old;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_QUERY));
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	old = value->data[0].v_pointer;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (v_object) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_QUERY));
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		value->data[0].v_pointer = v_object;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		tracker_query_ref (value->data[0].v_pointer);
#line 1738 "tracker-query.c"
	} else {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		value->data[0].v_pointer = NULL;
#line 1742 "tracker-query.c"
	}
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (old) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		tracker_query_unref (old);
#line 1748 "tracker-query.c"
	}
}


void tracker_value_take_query (GValue* value, gpointer v_object) {
	TrackerQuery* old;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_QUERY));
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	old = value->data[0].v_pointer;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (v_object) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_QUERY));
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		value->data[0].v_pointer = v_object;
#line 1767 "tracker-query.c"
	} else {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		value->data[0].v_pointer = NULL;
#line 1771 "tracker-query.c"
	}
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (old) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		tracker_query_unref (old);
#line 1777 "tracker-query.c"
	}
}


static void tracker_query_class_init (TrackerQueryClass * klass) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	tracker_query_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	TRACKER_QUERY_CLASS (klass)->finalize = tracker_query_finalize;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_type_class_add_private (klass, sizeof (TrackerQueryPrivate));
#line 1789 "tracker-query.c"
}


static void tracker_query_instance_init (TrackerQuery * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar** _tmp17_ = NULL;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	self->priv = TRACKER_QUERY_GET_PRIVATE (self);
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp0_ = g_strdup ("");
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp1_ = g_strdup ("?urn fts:match \"%s\"");
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp2_ = g_strdup ("?match fts:match \"%s\"");
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp3_ = g_strdup ("FILTER (fn:contains (fn:lower-case (nfo:fileName(?urn)), \"%s\"))");
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp4_ = g_strdup ("FILTER (fn:contains (fn:lower-case (nie:title (?match), \"%s\"))");
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp5_ = g_new0 (gchar*, 5 + 1);
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp5_[0] = _tmp0_;
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp5_[1] = _tmp1_;
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp5_[2] = _tmp2_;
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp5_[3] = _tmp3_;
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp5_[4] = _tmp4_;
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	self->priv->match_clauses = _tmp5_;
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	self->priv->match_clauses_length1 = 5;
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	self->priv->_match_clauses_size_ = self->priv->match_clauses_length1;
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp6_ = g_strdup ("WHERE {\n" \
"		  %s .\n" \
"		  ?urn nfo:belongsToContainer ?parent ;\n" \
"		  tracker:available true .\n" \
"		}");
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp7_ = g_strdup ("");
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp8_ = g_strdup ("WHERE {\n		  ?urn a nfo:Software .\n		  %s\n		}");
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp9_ = g_strdup ("WHERE {\n" \
"		  {\n" \
"		    ?urn nmm:musicAlbum ?match\n" \
"		  } UNION {\n" \
"		    ?urn nmm:performer ?match\n" \
"		  } UNION {\n" \
"		    ?urn a nfo:Audio .\n" \
"		    ?match a nfo:Audio\n" \
"		    FILTER (?urn = ?match)\n" \
"		  }\n" \
"		  %s .\n" \
"		  ?urn nmm:performer [ nmm:artistName ?performer ] ;\n" \
"		       nmm:musicAlbum [ nie:title ?album ] ;\n" \
"		       nie:url ?tooltip\n" \
"		}");
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp10_ = g_strdup ("WHERE {\n" \
"		  ?urn a nfo:Image ;\n" \
"		         nie:url ?tooltip .\n" \
"		  %s\n" \
"		}");
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp11_ = g_strdup ("WHERE {\n" \
"		  ?urn a nfo:Video ;\n" \
"		         nie:url ?tooltip .\n" \
"		  %s\n" \
"		}");
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp12_ = g_strdup ("WHERE {\n" \
"		  ?urn a nfo:Document ;\n" \
"		         nie:url ?tooltip .\n" \
"		  %s\n" \
"		  OPTIONAL {\n" \
"		    ?urn nco:creator ?creator .\n" \
"		  }\n" \
"		  OPTIONAL {\n" \
"		    ?urn nco:publisher ?publisher .\n" \
"		  }\n" \
"		}");
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp13_ = g_strdup ("WHERE {\n" \
"		  ?urn a nmo:Email ;\n" \
"		         nmo:from ?sender ;\n" \
"		         nmo:to ?to .\n" \
"		  %s\n" \
"		}");
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp14_ = g_strdup ("");
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp15_ = g_strdup ("WHERE {\n" \
"		  ?urn a nfo:Folder ;\n" \
"		         nie:url ?tooltip .\n" \
"		  %s\n" \
"		  OPTIONAL {\n" \
"		    ?urn nfo:belongsToContainer ?parent .\n" \
"		  }\n" \
"		}");
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp16_ = g_strdup ("WHERE {\n" \
"		  ?urn a nfo:Bookmark ;\n" \
"               nfo:bookmarks ?bookmark .\n" \
"		  %s\n" \
"		}");
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp17_ = g_new0 (gchar*, 11 + 1);
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp17_[0] = _tmp6_;
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp17_[1] = _tmp7_;
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp17_[2] = _tmp8_;
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp17_[3] = _tmp9_;
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp17_[4] = _tmp10_;
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp17_[5] = _tmp11_;
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp17_[6] = _tmp12_;
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp17_[7] = _tmp13_;
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp17_[8] = _tmp14_;
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp17_[9] = _tmp15_;
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_tmp17_[10] = _tmp16_;
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	self->priv->where_clauses = _tmp17_;
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	self->priv->where_clauses_length1 = 11;
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	self->priv->_where_clauses_size_ = self->priv->where_clauses_length1;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	self->ref_count = 1;
#line 1896 "tracker-query.c"
}


static void tracker_query_finalize (TrackerQuery* obj) {
	TrackerQuery * self;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	self = TRACKER_QUERY (obj);
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	self->priv->match_clauses = (_vala_array_free (self->priv->match_clauses, self->priv->match_clauses_length1, (GDestroyNotify) g_free), NULL);
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	self->priv->where_clauses = (_vala_array_free (self->priv->where_clauses, self->priv->where_clauses_length1, (GDestroyNotify) g_free), NULL);
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (self->priv->_criteria);
#line 163 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	_g_free0 (self->priv->_query);
#line 1912 "tracker-query.c"
}


GType tracker_query_get_type (void) {
	static volatile gsize tracker_query_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_query_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_value_query_init, tracker_value_query_free_value, tracker_value_query_copy_value, tracker_value_query_peek_pointer, "p", tracker_value_query_collect_value, "p", tracker_value_query_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerQuery), 0, (GInstanceInitFunc) tracker_query_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_query_type_id;
		tracker_query_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerQuery", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_query_type_id__volatile, tracker_query_type_id);
	}
	return tracker_query_type_id__volatile;
}


gpointer tracker_query_ref (gpointer instance) {
	TrackerQuery* self;
	self = instance;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	g_atomic_int_inc (&self->ref_count);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	return instance;
#line 1937 "tracker-query.c"
}


void tracker_query_unref (gpointer instance) {
	TrackerQuery* self;
	self = instance;
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		TRACKER_QUERY_GET_CLASS (self)->finalize (self);
#line 22 "/home/martyn/Source/tracker/src/tracker-needle/tracker-query.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1950 "tracker-query.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



