/* tracker-resources.c generated by valac 0.12.0, the Vala compiler
 * generated from tracker-resources.vala, do not modify */

/*
 * Copyright (C) 2006, Jamie McCracken <jamiemcc@gnome.org>
 * Copyright (C) 2008-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-common/tracker-common.h>
#include <libtracker-data/tracker-db-interface.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <libtracker-data/tracker-data-query.h>
#include <libtracker-data/tracker-data-update.h>
#include <libtracker-data/tracker-data-backup.h>
#include <libtracker-data/tracker-class.h>
#include <tracker-store/tracker-events.h>
#include <tracker-store/tracker-writeback.h>


#define TRACKER_TYPE_RESOURCES (tracker_resources_get_type ())
#define TRACKER_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_RESOURCES, TrackerResources))
#define TRACKER_RESOURCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_RESOURCES, TrackerResourcesClass))
#define TRACKER_IS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_RESOURCES))
#define TRACKER_IS_RESOURCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_RESOURCES))
#define TRACKER_RESOURCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_RESOURCES, TrackerResourcesClass))

typedef struct _TrackerResources TrackerResources;
typedef struct _TrackerResourcesClass TrackerResourcesClass;
typedef struct _TrackerResourcesPrivate TrackerResourcesPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerResourcesLoadData TrackerResourcesLoadData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))

#define TRACKER_STORE_TYPE_PRIORITY (tracker_store_priority_get_type ())
typedef struct _TrackerResourcesSparqlQueryData TrackerResourcesSparqlQueryData;
typedef struct _TrackerResourcesSparqlUpdateData TrackerResourcesSparqlUpdateData;
typedef struct _TrackerResourcesSparqlUpdateBlankData TrackerResourcesSparqlUpdateBlankData;
typedef struct _TrackerResourcesBatchSparqlUpdateData TrackerResourcesBatchSparqlUpdateData;
typedef struct _Block4Data Block4Data;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _TrackerResources {
	GObject parent_instance;
	TrackerResourcesPrivate * priv;
};

struct _TrackerResourcesClass {
	GObjectClass parent_class;
};

struct _TrackerResourcesPrivate {
	GDBusConnection* connection;
	guint signal_timeout;
};

struct _TrackerResourcesLoadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* uri;
	TrackerDBusRequest* _tmp0_;
	TrackerDBusRequest* request;
	GFile* _tmp1_;
	GFile* file;
	GError * ie;
	GError* _tmp2_;
	GError * e;
	GError* _tmp3_;
	GError* _tmp4_;
	GError * _inner_error_;
};

struct _Block3Data {
	int _ref_count_;
	TrackerResources * self;
	GVariantBuilder* builder;
};

typedef enum  {
	TRACKER_STORE_PRIORITY_HIGH,
	TRACKER_STORE_PRIORITY_LOW,
	TRACKER_STORE_PRIORITY_TURTLE,
	TRACKER_STORE_PRIORITY_N_PRIORITIES
} TrackerStorePriority;

typedef void (*TrackerStoreSparqlQueryInThread) (TrackerDBCursor* cursor, void* user_data, GError** error);
struct _TrackerResourcesSparqlQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* query;
	GVariant* result;
	TrackerDBusRequest* _tmp0_;
	TrackerDBusRequest* request;
	Block3Data* _data3_;
	GVariantBuilder* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _result_;
	gsize _tmp3_;
	GError* _tmp4_;
	GError * e;
	GError* _tmp5_;
	GError* _tmp6_;
	GError * _inner_error_;
};

struct _TrackerResourcesSparqlUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* update;
	TrackerDBusRequest* _tmp0_;
	TrackerDBusRequest* request;
	GError * ie;
	GError* _tmp1_;
	GError * e;
	GError* _tmp2_;
	GError* _tmp3_;
	GError * _inner_error_;
};

struct _TrackerResourcesSparqlUpdateBlankData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* update;
	GVariant* result;
	TrackerDBusRequest* _tmp0_;
	TrackerDBusRequest* request;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GError * ie;
	GError* _tmp3_;
	GError * e;
	GError* _tmp4_;
	GError* _tmp5_;
	GError * _inner_error_;
};

struct _TrackerResourcesBatchSparqlUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* update;
	TrackerDBusRequest* _tmp0_;
	TrackerDBusRequest* request;
	GError * ie;
	GError* _tmp1_;
	GError * e;
	GError* _tmp2_;
	GError* _tmp3_;
	GError * _inner_error_;
};

struct _Block4Data {
	int _ref_count_;
	TrackerResources * self;
	GVariantBuilder* builder;
};


static gpointer tracker_resources_parent_class = NULL;

GType tracker_resources_get_type (void) G_GNUC_CONST;
guint tracker_resources_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
#define TRACKER_RESOURCES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_RESOURCES, TrackerResourcesPrivate))
enum  {
	TRACKER_RESOURCES_DUMMY_PROPERTY
};
void tracker_resources_disable_signals (TrackerResources* self);
#define TRACKER_RESOURCES_PATH "/org/freedesktop/Tracker1/Resources"
#define TRACKER_RESOURCES_GRAPH_UPDATED_IMMEDIATE_EMIT_AT 50000
#define TRACKER_RESOURCES_SIGNALS_SECONDS_PER_EMIT 1
#define TRACKER_RESOURCES_DBUS_ARBITRARY_MAX_MSG_SIZE 10000000
TrackerResources* tracker_resources_new (GDBusConnection* connection);
TrackerResources* tracker_resources_construct (GType object_type, GDBusConnection* connection);
static void tracker_resources_load_data_free (gpointer _data);
void tracker_resources_load (TrackerResources* self, const char* sender, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_resources_load_finish (TrackerResources* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_resources_load_co (TrackerResourcesLoadData* data);
void tracker_store_queue_turtle_import (GFile* file, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_queue_turtle_import_finish (GAsyncResult* _res_, GError** error);
static void tracker_resources_load_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_resources_sparql_query_data_free (gpointer _data);
void tracker_resources_sparql_query (TrackerResources* self, const char* sender, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* tracker_resources_sparql_query_finish (TrackerResources* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_resources_sparql_query_co (TrackerResourcesSparqlQueryData* data);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
GType tracker_store_priority_get_type (void) G_GNUC_CONST;
void tracker_store_sparql_query (const gchar* sparql, TrackerStorePriority priority, TrackerStoreSparqlQueryInThread in_thread, void* in_thread_target, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_sparql_query_finish (GAsyncResult* _res_, GError** error);
static void _lambda2_ (TrackerDBCursor* cursor, Block3Data* _data3_, GError** error);
static void __lambda2__tracker_store_sparql_query_in_thread (TrackerDBCursor* cursor, gpointer self, GError** error);
static void tracker_resources_sparql_query_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_resources_sparql_update_data_free (gpointer _data);
void tracker_resources_sparql_update (TrackerResources* self, const char* sender, const gchar* update, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_resources_sparql_update_finish (TrackerResources* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_resources_sparql_update_co (TrackerResourcesSparqlUpdateData* data);
void tracker_store_sparql_update (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_sparql_update_finish (GAsyncResult* _res_, GError** error);
static void tracker_resources_sparql_update_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_resources_sparql_update_blank_data_free (gpointer _data);
void tracker_resources_sparql_update_blank (TrackerResources* self, const char* sender, const gchar* update, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* tracker_resources_sparql_update_blank_finish (TrackerResources* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_resources_sparql_update_blank_co (TrackerResourcesSparqlUpdateBlankData* data);
void tracker_store_sparql_update_blank (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* tracker_store_sparql_update_blank_finish (GAsyncResult* _res_, GError** error);
static void tracker_resources_sparql_update_blank_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tracker_resources_sync (TrackerResources* self, const char* sender);
static void tracker_resources_batch_sparql_update_data_free (gpointer _data);
void tracker_resources_batch_sparql_update (TrackerResources* self, const char* sender, const gchar* update, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_resources_batch_sparql_update_finish (TrackerResources* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_resources_batch_sparql_update_co (TrackerResourcesBatchSparqlUpdateData* data);
static void tracker_resources_batch_sparql_update_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tracker_resources_batch_commit (TrackerResources* self);
static gboolean tracker_resources_emit_graph_updated (TrackerResources* self, TrackerClass* cl);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static void _lambda3_ (gint graph_id, gint subject_id, gint pred_id, gint object_id, Block4Data* _data4_);
static void __lambda3__tracker_events_foreach (gint graph_id, gint subject_id, gint pred_id, gint object_id, gpointer self);
static void _lambda4_ (gint graph_id, gint subject_id, gint pred_id, gint object_id, Block4Data* _data4_);
static void __lambda4__tracker_events_foreach (gint graph_id, gint subject_id, gint pred_id, gint object_id, gpointer self);
static gboolean tracker_resources_on_emit_signals (TrackerResources* self);
static void tracker_resources_on_statements_committed (TrackerResources* self, gboolean start_timer);
static gboolean _tracker_resources_on_emit_signals_gsource_func (gpointer self);
static void tracker_resources_on_statements_rolled_back (TrackerResources* self, gboolean start_timer);
static void tracker_resources_check_graph_updated_signal (TrackerResources* self);
static void tracker_resources_on_statement_inserted (TrackerResources* self, gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint pred_id, gint object_id, const gchar* object, GPtrArray* rdf_types);
static void tracker_resources_on_statement_deleted (TrackerResources* self, gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint pred_id, gint object_id, const gchar* object, GPtrArray* rdf_types);
void tracker_resources_enable_signals (TrackerResources* self);
static void _tracker_resources_on_statement_inserted_tracker_statement_callback (gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint predicate_id, gint object_id, const gchar* object, GPtrArray* rdf_types, gpointer self);
static void _tracker_resources_on_statement_deleted_tracker_statement_callback (gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint predicate_id, gint object_id, const gchar* object, GPtrArray* rdf_types, gpointer self);
static void _tracker_resources_on_statements_committed_tracker_commit_callback (gboolean start_timer, gpointer self);
static void _tracker_resources_on_statements_rolled_back_tracker_commit_callback (gboolean start_timer, gpointer self);
void tracker_resources_unreg_batches (TrackerResources* self, const gchar* old_owner);
void tracker_store_unreg_batches (const gchar* client_id);
static void g_cclosure_user_marshal_VOID__VARIANT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_VARIANT_VARIANT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void tracker_resources_finalize (GObject* obj);
static void _dbus_tracker_resources_load (TrackerResources* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_load_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_tracker_resources_sparql_query (TrackerResources* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_sparql_query_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_tracker_resources_sparql_update (TrackerResources* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_sparql_update_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_tracker_resources_sparql_update_blank (TrackerResources* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_sparql_update_blank_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_tracker_resources_sync (TrackerResources* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_batch_sparql_update (TrackerResources* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_batch_sparql_update_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_tracker_resources_batch_commit (TrackerResources* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_enable_signals (TrackerResources* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_disable_signals (TrackerResources* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_unreg_batches (TrackerResources* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void tracker_resources_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* tracker_resources_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean tracker_resources_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_tracker_resources_writeback (GObject* _sender, GVariant* subjects, gpointer* _data);
static void _dbus_tracker_resources_graph_updated (GObject* _sender, const gchar* classname, GVariant* deletes, GVariant* inserts, gpointer* _data);
static void _tracker_resources_unregister_object (gpointer user_data);

static const GDBusArgInfo _tracker_resources_dbus_arg_info_load_uri = {-1, "uri", "s"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_load_in[] = {&_tracker_resources_dbus_arg_info_load_uri, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_load_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_load = {-1, "Load", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_load_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_load_out)};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_query_query = {-1, "query", "s"};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_query_result = {-1, "result", "aas"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_query_in[] = {&_tracker_resources_dbus_arg_info_sparql_query_query, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_query_out[] = {&_tracker_resources_dbus_arg_info_sparql_query_result, NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_sparql_query = {-1, "SparqlQuery", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_query_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_query_out)};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_update_update = {-1, "update", "s"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_update_in[] = {&_tracker_resources_dbus_arg_info_sparql_update_update, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_update_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_sparql_update = {-1, "SparqlUpdate", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_update_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_update_out)};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_update_blank_update = {-1, "update", "s"};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_update_blank_result = {-1, "result", "aaa{ss}"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_update_blank_in[] = {&_tracker_resources_dbus_arg_info_sparql_update_blank_update, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_update_blank_out[] = {&_tracker_resources_dbus_arg_info_sparql_update_blank_result, NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_sparql_update_blank = {-1, "SparqlUpdateBlank", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_update_blank_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_update_blank_out)};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sync_in[] = {NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sync_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_sync = {-1, "Sync", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sync_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sync_out)};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_batch_sparql_update_update = {-1, "update", "s"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_batch_sparql_update_in[] = {&_tracker_resources_dbus_arg_info_batch_sparql_update_update, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_batch_sparql_update_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_batch_sparql_update = {-1, "BatchSparqlUpdate", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_batch_sparql_update_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_batch_sparql_update_out)};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_batch_commit_in[] = {NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_batch_commit_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_batch_commit = {-1, "BatchCommit", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_batch_commit_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_batch_commit_out)};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_enable_signals_in[] = {NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_enable_signals_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_enable_signals = {-1, "EnableSignals", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_enable_signals_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_enable_signals_out)};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_disable_signals_in[] = {NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_disable_signals_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_disable_signals = {-1, "DisableSignals", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_disable_signals_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_disable_signals_out)};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_unreg_batches_old_owner = {-1, "old_owner", "s"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_unreg_batches_in[] = {&_tracker_resources_dbus_arg_info_unreg_batches_old_owner, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_unreg_batches_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_unreg_batches = {-1, "UnregBatches", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_unreg_batches_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_unreg_batches_out)};
static const GDBusMethodInfo * const _tracker_resources_dbus_method_info[] = {&_tracker_resources_dbus_method_info_load, &_tracker_resources_dbus_method_info_sparql_query, &_tracker_resources_dbus_method_info_sparql_update, &_tracker_resources_dbus_method_info_sparql_update_blank, &_tracker_resources_dbus_method_info_sync, &_tracker_resources_dbus_method_info_batch_sparql_update, &_tracker_resources_dbus_method_info_batch_commit, &_tracker_resources_dbus_method_info_enable_signals, &_tracker_resources_dbus_method_info_disable_signals, &_tracker_resources_dbus_method_info_unreg_batches, NULL};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_writeback_subjects = {-1, "subjects", "a{iai}"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_writeback[] = {&_tracker_resources_dbus_arg_info_writeback_subjects, NULL};
static const GDBusSignalInfo _tracker_resources_dbus_signal_info_writeback = {-1, "Writeback", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_writeback)};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_graph_updated_classname = {-1, "classname", "s"};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_graph_updated_deletes = {-1, "deletes", "a(iiii)"};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_graph_updated_inserts = {-1, "inserts", "a(iiii)"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_graph_updated[] = {&_tracker_resources_dbus_arg_info_graph_updated_classname, &_tracker_resources_dbus_arg_info_graph_updated_deletes, &_tracker_resources_dbus_arg_info_graph_updated_inserts, NULL};
static const GDBusSignalInfo _tracker_resources_dbus_signal_info_graph_updated = {-1, "GraphUpdated", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_graph_updated)};
static const GDBusSignalInfo * const _tracker_resources_dbus_signal_info[] = {&_tracker_resources_dbus_signal_info_writeback, &_tracker_resources_dbus_signal_info_graph_updated, NULL};
static const GDBusPropertyInfo * const _tracker_resources_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _tracker_resources_dbus_interface_info = {-1, "org.freedesktop.Tracker1.Resources", (GDBusMethodInfo **) (&_tracker_resources_dbus_method_info), (GDBusSignalInfo **) (&_tracker_resources_dbus_signal_info), (GDBusPropertyInfo **) (&_tracker_resources_dbus_property_info)};
static const GDBusInterfaceVTable _tracker_resources_dbus_interface_vtable = {tracker_resources_dbus_interface_method_call, tracker_resources_dbus_interface_get_property, tracker_resources_dbus_interface_set_property};

static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


TrackerResources* tracker_resources_construct (GType object_type, GDBusConnection* connection) {
	TrackerResources * self = NULL;
	GDBusConnection* _tmp0_;
	g_return_val_if_fail (connection != NULL, NULL);
	self = (TrackerResources*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (connection);
	_g_object_unref0 (self->priv->connection);
	self->priv->connection = _tmp0_;
	return self;
}


TrackerResources* tracker_resources_new (GDBusConnection* connection) {
	return tracker_resources_construct (TRACKER_TYPE_RESOURCES, connection);
}


static void tracker_resources_load_data_free (gpointer _data) {
	TrackerResourcesLoadData* data;
	data = _data;
	_g_free0 (data->sender);
	_g_free0 (data->uri);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerResourcesLoadData, data);
}


void tracker_resources_load (TrackerResources* self, const char* sender, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResourcesLoadData* _data_;
	_data_ = g_slice_new0 (TrackerResourcesLoadData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_resources_load);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_resources_load_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sender = g_strdup (sender);
	_data_->uri = g_strdup (uri);
	tracker_resources_load_co (_data_);
}


void tracker_resources_load_finish (TrackerResources* self, GAsyncResult* _res_, GError** error) {
	TrackerResourcesLoadData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_resources_load_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResourcesLoadData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_resources_load_co (data);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean tracker_resources_load_co (TrackerResourcesLoadData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_dbus_request_begin ((const gchar*) data->sender, "Resources.Load (uri: '%s')", data->uri, NULL);
	data->request = data->_tmp0_;
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_file_new_for_uri (data->uri);
	data->file = data->_tmp1_;
	data->_state_ = 1;
	tracker_store_queue_turtle_import (data->file, (const gchar*) data->sender, tracker_resources_load_ready, data);
	return FALSE;
	_state_1:
	tracker_store_queue_turtle_import_finish (data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->file);
		if (g_error_matches (data->_inner_error_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
			goto __catch8_tracker_db_no_space;
		}
		goto __catch8_g_error;
	}
	tracker_dbus_request_end (data->request, NULL);
	_g_object_unref0 (data->file);
	goto __finally8;
	__catch8_tracker_db_no_space:
	{
		data->ie = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp2_ = NULL;
		data->_tmp2_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_NO_SPACE, data->ie->message);
		data->_inner_error_ = data->_tmp2_;
		_g_error_free0 (data->ie);
		goto __finally8;
	}
	goto __finally8;
	__catch8_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		tracker_dbus_request_end (data->request, data->e);
		if (data->e->domain == TRACKER_SPARQL_ERROR) {
			data->_tmp3_ = _g_error_copy0 (data->e);
			data->_inner_error_ = data->_tmp3_;
			_g_error_free0 (data->e);
			goto __finally8;
		} else {
			data->_tmp4_ = NULL;
			data->_tmp4_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, data->e->message);
			data->_inner_error_ = data->_tmp4_;
			_g_error_free0 (data->e);
			goto __finally8;
		}
		_g_error_free0 (data->e);
	}
	__finally8:
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_resources_sparql_query_data_free (gpointer _data) {
	TrackerResourcesSparqlQueryData* data;
	data = _data;
	_g_free0 (data->sender);
	_g_free0 (data->query);
	_g_variant_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerResourcesSparqlQueryData, data);
}


void tracker_resources_sparql_query (TrackerResources* self, const char* sender, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResourcesSparqlQueryData* _data_;
	_data_ = g_slice_new0 (TrackerResourcesSparqlQueryData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_resources_sparql_query);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_resources_sparql_query_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sender = g_strdup (sender);
	_data_->query = g_strdup (query);
	tracker_resources_sparql_query_co (_data_);
}


GVariant* tracker_resources_sparql_query_finish (TrackerResources* self, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerResourcesSparqlQueryData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_g_variant_builder_unref0 (_data3_->builder);
		g_slice_free (Block3Data, _data3_);
	}
}


static void _lambda2_ (TrackerDBCursor* cursor, Block3Data* _data3_, GError** error) {
	TrackerResources * self;
	GError * _inner_error_ = NULL;
	self = _data3_->self;
	g_return_if_fail (cursor != NULL);
	while (TRUE) {
		gboolean _tmp0_;
		gboolean _tmp1_;
		_tmp0_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) cursor, NULL, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		if (!_tmp1_) {
			break;
		}
		g_variant_builder_open (_data3_->builder, (const GVariantType*) "as");
		{
			gint i;
			i = 0;
			{
				gboolean _tmp2_;
				_tmp2_ = TRUE;
				while (TRUE) {
					gint _tmp3_;
					const gchar* _tmp4_ = NULL;
					const gchar* str;
					if (!_tmp2_) {
						i++;
					}
					_tmp2_ = FALSE;
					_tmp3_ = tracker_sparql_cursor_get_n_columns ((TrackerSparqlCursor*) cursor);
					if (!(i < _tmp3_)) {
						break;
					}
					_tmp4_ = tracker_sparql_cursor_get_string ((TrackerSparqlCursor*) cursor, i, NULL);
					str = _tmp4_;
					if (str == NULL) {
						str = "";
					}
					g_variant_builder_add (_data3_->builder, "s", str, NULL);
				}
			}
		}
		g_variant_builder_close (_data3_->builder);
	}
}


static void __lambda2__tracker_store_sparql_query_in_thread (TrackerDBCursor* cursor, gpointer self, GError** error) {
	_lambda2_ (cursor, self, error);
}


static void tracker_resources_sparql_query_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResourcesSparqlQueryData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_resources_sparql_query_co (data);
}


static gboolean tracker_resources_sparql_query_co (TrackerResourcesSparqlQueryData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_dbus_request_begin ((const gchar*) data->sender, "Resources.SparqlQuery", NULL);
	data->request = data->_tmp0_;
	tracker_dbus_request_debug (data->request, "query: %s", data->query, NULL);
	data->_data3_ = g_slice_new0 (Block3Data);
	data->_data3_->_ref_count_ = 1;
	data->_data3_->self = g_object_ref (data->self);
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_variant_builder_new ((const GVariantType*) "aas");
	data->_data3_->builder = data->_tmp1_;
	data->_state_ = 1;
	tracker_store_sparql_query (data->query, TRACKER_STORE_PRIORITY_HIGH, __lambda2__tracker_store_sparql_query_in_thread, data->_data3_, (const gchar*) data->sender, tracker_resources_sparql_query_ready, data);
	return FALSE;
	_state_1:
	tracker_store_sparql_query_finish (data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		block3_data_unref (data->_data3_);
		data->_data3_ = NULL;
		goto __catch9_g_error;
	}
	data->_tmp2_ = NULL;
	data->_tmp2_ = g_variant_builder_end (data->_data3_->builder);
	data->_result_ = g_variant_ref_sink (data->_tmp2_);
	data->_tmp3_ = g_variant_get_size (data->_result_);
	if (data->_tmp3_ > TRACKER_RESOURCES_DBUS_ARBITRARY_MAX_MSG_SIZE) {
		data->_tmp4_ = NULL;
		data->_tmp4_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "result set of the query is too large");
		data->_inner_error_ = data->_tmp4_;
		_g_variant_unref0 (data->_result_);
		block3_data_unref (data->_data3_);
		data->_data3_ = NULL;
		goto __catch9_g_error;
	}
	tracker_dbus_request_end (data->request, NULL);
	data->result = data->_result_;
	block3_data_unref (data->_data3_);
	data->_data3_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_variant_unref0 (data->_result_);
	block3_data_unref (data->_data3_);
	data->_data3_ = NULL;
	goto __finally9;
	__catch9_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		tracker_dbus_request_end (data->request, data->e);
		if (data->e->domain == TRACKER_SPARQL_ERROR) {
			data->_tmp5_ = _g_error_copy0 (data->e);
			data->_inner_error_ = data->_tmp5_;
			_g_error_free0 (data->e);
			goto __finally9;
		} else {
			data->_tmp6_ = NULL;
			data->_tmp6_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, data->e->message);
			data->_inner_error_ = data->_tmp6_;
			_g_error_free0 (data->e);
			goto __finally9;
		}
		_g_error_free0 (data->e);
	}
	__finally9:
	g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
	g_error_free (data->_inner_error_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_resources_sparql_update_data_free (gpointer _data) {
	TrackerResourcesSparqlUpdateData* data;
	data = _data;
	_g_free0 (data->sender);
	_g_free0 (data->update);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerResourcesSparqlUpdateData, data);
}


void tracker_resources_sparql_update (TrackerResources* self, const char* sender, const gchar* update, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResourcesSparqlUpdateData* _data_;
	_data_ = g_slice_new0 (TrackerResourcesSparqlUpdateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_resources_sparql_update);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_resources_sparql_update_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sender = g_strdup (sender);
	_data_->update = g_strdup (update);
	tracker_resources_sparql_update_co (_data_);
}


void tracker_resources_sparql_update_finish (TrackerResources* self, GAsyncResult* _res_, GError** error) {
	TrackerResourcesSparqlUpdateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_resources_sparql_update_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResourcesSparqlUpdateData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_resources_sparql_update_co (data);
}


static gboolean tracker_resources_sparql_update_co (TrackerResourcesSparqlUpdateData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_dbus_request_begin ((const gchar*) data->sender, "Resources.SparqlUpdate", NULL);
	data->request = data->_tmp0_;
	tracker_dbus_request_debug (data->request, "query: %s", data->update, NULL);
	data->_state_ = 1;
	tracker_store_sparql_update (data->update, TRACKER_STORE_PRIORITY_HIGH, (const gchar*) data->sender, tracker_resources_sparql_update_ready, data);
	return FALSE;
	_state_1:
	tracker_store_sparql_update_finish (data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (g_error_matches (data->_inner_error_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
			goto __catch10_tracker_db_no_space;
		}
		goto __catch10_g_error;
	}
	tracker_dbus_request_end (data->request, NULL);
	goto __finally10;
	__catch10_tracker_db_no_space:
	{
		data->ie = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp1_ = NULL;
		data->_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_NO_SPACE, data->ie->message);
		data->_inner_error_ = data->_tmp1_;
		_g_error_free0 (data->ie);
		goto __finally10;
	}
	goto __finally10;
	__catch10_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		tracker_dbus_request_end (data->request, data->e);
		if (data->e->domain == TRACKER_SPARQL_ERROR) {
			data->_tmp2_ = _g_error_copy0 (data->e);
			data->_inner_error_ = data->_tmp2_;
			_g_error_free0 (data->e);
			goto __finally10;
		} else {
			data->_tmp3_ = NULL;
			data->_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, data->e->message);
			data->_inner_error_ = data->_tmp3_;
			_g_error_free0 (data->e);
			goto __finally10;
		}
		_g_error_free0 (data->e);
	}
	__finally10:
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_resources_sparql_update_blank_data_free (gpointer _data) {
	TrackerResourcesSparqlUpdateBlankData* data;
	data = _data;
	_g_free0 (data->sender);
	_g_free0 (data->update);
	_g_variant_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerResourcesSparqlUpdateBlankData, data);
}


void tracker_resources_sparql_update_blank (TrackerResources* self, const char* sender, const gchar* update, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResourcesSparqlUpdateBlankData* _data_;
	_data_ = g_slice_new0 (TrackerResourcesSparqlUpdateBlankData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_resources_sparql_update_blank);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_resources_sparql_update_blank_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sender = g_strdup (sender);
	_data_->update = g_strdup (update);
	tracker_resources_sparql_update_blank_co (_data_);
}


GVariant* tracker_resources_sparql_update_blank_finish (TrackerResources* self, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerResourcesSparqlUpdateBlankData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_resources_sparql_update_blank_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResourcesSparqlUpdateBlankData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_resources_sparql_update_blank_co (data);
}


static gboolean tracker_resources_sparql_update_blank_co (TrackerResourcesSparqlUpdateBlankData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_dbus_request_begin ((const gchar*) data->sender, "Resources.SparqlUpdateBlank", NULL);
	data->request = data->_tmp0_;
	tracker_dbus_request_debug (data->request, "query: %s", data->update, NULL);
	data->_state_ = 1;
	tracker_store_sparql_update_blank (data->update, TRACKER_STORE_PRIORITY_HIGH, (const gchar*) data->sender, tracker_resources_sparql_update_blank_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = tracker_store_sparql_update_blank_finish (data->_res_, &data->_inner_error_);
	data->_tmp2_ = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		if (g_error_matches (data->_inner_error_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
			goto __catch11_tracker_db_no_space;
		}
		goto __catch11_g_error;
	}
	data->result = data->_tmp2_;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	goto __finally11;
	__catch11_tracker_db_no_space:
	{
		data->ie = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp3_ = NULL;
		data->_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_NO_SPACE, data->ie->message);
		data->_inner_error_ = data->_tmp3_;
		_g_error_free0 (data->ie);
		goto __finally11;
	}
	goto __finally11;
	__catch11_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		tracker_dbus_request_end (data->request, data->e);
		if (data->e->domain == TRACKER_SPARQL_ERROR) {
			data->_tmp4_ = _g_error_copy0 (data->e);
			data->_inner_error_ = data->_tmp4_;
			_g_error_free0 (data->e);
			goto __finally11;
		} else {
			data->_tmp5_ = NULL;
			data->_tmp5_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, data->e->message);
			data->_inner_error_ = data->_tmp5_;
			_g_error_free0 (data->e);
			goto __finally11;
		}
		_g_error_free0 (data->e);
	}
	__finally11:
	g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
	g_error_free (data->_inner_error_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


void tracker_resources_sync (TrackerResources* self, const char* sender) {
	TrackerDBusRequest* _tmp0_ = NULL;
	TrackerDBusRequest* request;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	_tmp0_ = tracker_dbus_request_begin ((const gchar*) sender, "Resources.Sync", NULL);
	request = _tmp0_;
	tracker_data_sync ();
	tracker_dbus_request_end (request, NULL);
}


static void tracker_resources_batch_sparql_update_data_free (gpointer _data) {
	TrackerResourcesBatchSparqlUpdateData* data;
	data = _data;
	_g_free0 (data->sender);
	_g_free0 (data->update);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerResourcesBatchSparqlUpdateData, data);
}


void tracker_resources_batch_sparql_update (TrackerResources* self, const char* sender, const gchar* update, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResourcesBatchSparqlUpdateData* _data_;
	_data_ = g_slice_new0 (TrackerResourcesBatchSparqlUpdateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_resources_batch_sparql_update);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_resources_batch_sparql_update_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sender = g_strdup (sender);
	_data_->update = g_strdup (update);
	tracker_resources_batch_sparql_update_co (_data_);
}


void tracker_resources_batch_sparql_update_finish (TrackerResources* self, GAsyncResult* _res_, GError** error) {
	TrackerResourcesBatchSparqlUpdateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_resources_batch_sparql_update_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResourcesBatchSparqlUpdateData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_resources_batch_sparql_update_co (data);
}


static gboolean tracker_resources_batch_sparql_update_co (TrackerResourcesBatchSparqlUpdateData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_dbus_request_begin ((const gchar*) data->sender, "Resources.BatchSparqlUpdate", NULL);
	data->request = data->_tmp0_;
	tracker_dbus_request_debug (data->request, "query: %s", data->update, NULL);
	data->_state_ = 1;
	tracker_store_sparql_update (data->update, TRACKER_STORE_PRIORITY_LOW, (const gchar*) data->sender, tracker_resources_batch_sparql_update_ready, data);
	return FALSE;
	_state_1:
	tracker_store_sparql_update_finish (data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (g_error_matches (data->_inner_error_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
			goto __catch12_tracker_db_no_space;
		}
		goto __catch12_g_error;
	}
	tracker_dbus_request_end (data->request, NULL);
	goto __finally12;
	__catch12_tracker_db_no_space:
	{
		data->ie = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp1_ = NULL;
		data->_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_NO_SPACE, data->ie->message);
		data->_inner_error_ = data->_tmp1_;
		_g_error_free0 (data->ie);
		goto __finally12;
	}
	goto __finally12;
	__catch12_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		tracker_dbus_request_end (data->request, data->e);
		if (data->e->domain == TRACKER_SPARQL_ERROR) {
			data->_tmp2_ = _g_error_copy0 (data->e);
			data->_inner_error_ = data->_tmp2_;
			_g_error_free0 (data->e);
			goto __finally12;
		} else {
			data->_tmp3_ = NULL;
			data->_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, data->e->message);
			data->_inner_error_ = data->_tmp3_;
			_g_error_free0 (data->e);
			goto __finally12;
		}
		_g_error_free0 (data->e);
	}
	__finally12:
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


void tracker_resources_batch_commit (TrackerResources* self) {
	g_return_if_fail (self != NULL);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		_g_variant_builder_unref0 (_data4_->builder);
		g_slice_free (Block4Data, _data4_);
	}
}


static void _lambda3_ (gint graph_id, gint subject_id, gint pred_id, gint object_id, Block4Data* _data4_) {
	TrackerResources * self;
	self = _data4_->self;
	g_variant_builder_add (_data4_->builder, "(iiii)", graph_id, subject_id, pred_id, object_id, NULL);
}


static void __lambda3__tracker_events_foreach (gint graph_id, gint subject_id, gint pred_id, gint object_id, gpointer self) {
	_lambda3_ (graph_id, subject_id, pred_id, object_id, self);
}


static void _lambda4_ (gint graph_id, gint subject_id, gint pred_id, gint object_id, Block4Data* _data4_) {
	TrackerResources * self;
	self = _data4_->self;
	g_variant_builder_add (_data4_->builder, "(iiii)", graph_id, subject_id, pred_id, object_id, NULL);
}


static void __lambda4__tracker_events_foreach (gint graph_id, gint subject_id, gint pred_id, gint object_id, gpointer self) {
	_lambda4_ (graph_id, subject_id, pred_id, object_id, self);
}


static gboolean tracker_resources_emit_graph_updated (TrackerResources* self, TrackerClass* cl) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	_tmp1_ = tracker_class_has_insert_events (cl);
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = tracker_class_has_delete_events (cl);
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		Block4Data* _data4_;
		GVariantBuilder* _tmp3_ = NULL;
		GVariant* _tmp4_ = NULL;
		GVariant* deletes;
		GVariantBuilder* _tmp5_ = NULL;
		GVariant* _tmp6_ = NULL;
		GVariant* inserts;
		const gchar* _tmp7_ = NULL;
		_data4_ = g_slice_new0 (Block4Data);
		_data4_->_ref_count_ = 1;
		_data4_->self = g_object_ref (self);
		_tmp3_ = g_variant_builder_new ((const GVariantType*) "a(iiii)");
		_data4_->builder = _tmp3_;
		tracker_class_foreach_delete_event (cl, __lambda3__tracker_events_foreach, _data4_);
		_tmp4_ = g_variant_builder_end (_data4_->builder);
		deletes = g_variant_ref_sink (_tmp4_);
		_tmp5_ = g_variant_builder_new ((const GVariantType*) "a(iiii)");
		_g_variant_builder_unref0 (_data4_->builder);
		_data4_->builder = _tmp5_;
		tracker_class_foreach_insert_event (cl, __lambda4__tracker_events_foreach, _data4_);
		_tmp6_ = g_variant_builder_end (_data4_->builder);
		inserts = g_variant_ref_sink (_tmp6_);
		_tmp7_ = tracker_class_get_uri (cl);
		g_signal_emit_by_name (self, "graph-updated", _tmp7_, deletes, inserts);
		tracker_class_reset_ready_events (cl);
		result = TRUE;
		_g_variant_unref0 (inserts);
		_g_variant_unref0 (deletes);
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return result;
	}
	result = FALSE;
	return result;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static gboolean tracker_resources_on_emit_signals (TrackerResources* self) {
	gboolean result = FALSE;
	gboolean had_any;
	gint _tmp0_;
	TrackerClass** _tmp1_ = NULL;
	GHashTable* _tmp4_ = NULL;
	GHashTable* _tmp5_;
	GHashTable* writebacks;
	g_return_val_if_fail (self != NULL, FALSE);
	had_any = FALSE;
	_tmp1_ = tracker_events_get_classes (&_tmp0_);
	{
		TrackerClass** cl_collection;
		int cl_collection_length1;
		int cl_it;
		cl_collection = _tmp1_;
		cl_collection_length1 = _tmp0_;
		for (cl_it = 0; cl_it < _tmp0_; cl_it = cl_it + 1) {
			TrackerClass* _tmp2_;
			TrackerClass* cl;
			_tmp2_ = _g_object_ref0 (cl_collection[cl_it]);
			cl = _tmp2_;
			{
				gboolean _tmp3_;
				_tmp3_ = tracker_resources_emit_graph_updated (self, cl);
				if (_tmp3_) {
					had_any = TRUE;
				}
				_g_object_unref0 (cl);
			}
		}
	}
	tracker_events_get_total (TRUE);
	_tmp4_ = tracker_writeback_get_ready ();
	_tmp5_ = _g_hash_table_ref0 (_tmp4_);
	writebacks = _tmp5_;
	if (writebacks != NULL) {
		GVariantBuilder* _tmp6_ = NULL;
		GVariantBuilder* builder;
		GHashTableIter wb_iter = {0};
		gint subject_id = 0;
		GArray* types = NULL;
		GVariant* _tmp12_ = NULL;
		GVariant* _tmp13_;
		had_any = TRUE;
		_tmp6_ = g_variant_builder_new ((const GVariantType*) "a{iai}");
		builder = _tmp6_;
		g_hash_table_iter_init (&wb_iter, writebacks);
		while (TRUE) {
			gconstpointer _tmp7_ = NULL;
			gconstpointer _tmp8_ = NULL;
			gboolean _tmp9_;
			_tmp9_ = g_hash_table_iter_next (&wb_iter, &_tmp7_, &_tmp8_);
			subject_id = _tmp7_;
			types = _tmp8_;
			if (!_tmp9_) {
				break;
			}
			g_variant_builder_open (builder, (const GVariantType*) "{iai}");
			g_variant_builder_add (builder, "i", subject_id, NULL);
			g_variant_builder_open (builder, (const GVariantType*) "ai");
			{
				gint i;
				i = 0;
				{
					gboolean _tmp10_;
					_tmp10_ = TRUE;
					while (TRUE) {
						gint _tmp11_;
						if (!_tmp10_) {
							i++;
						}
						_tmp10_ = FALSE;
						if (!(i < types->len)) {
							break;
						}
						_tmp11_ = g_array_index (types, gint, (guint) i);
						g_variant_builder_add (builder, "i", _tmp11_, NULL);
					}
				}
			}
			g_variant_builder_close (builder);
			g_variant_builder_close (builder);
		}
		_tmp12_ = g_variant_builder_end (builder);
		_tmp13_ = g_variant_ref_sink (_tmp12_);
		g_signal_emit_by_name (self, "writeback", _tmp13_);
		_g_variant_unref0 (_tmp13_);
		_g_variant_builder_unref0 (builder);
	}
	tracker_writeback_reset_ready ();
	if (!had_any) {
		self->priv->signal_timeout = (guint) 0;
	}
	result = had_any;
	_g_hash_table_unref0 (writebacks);
	return result;
}


static gboolean _tracker_resources_on_emit_signals_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_resources_on_emit_signals (self);
	return result;
}


static void tracker_resources_on_statements_committed (TrackerResources* self, gboolean start_timer) {
	gint _tmp0_;
	TrackerClass** _tmp1_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = tracker_events_get_classes (&_tmp0_);
	{
		TrackerClass** cl_collection;
		int cl_collection_length1;
		int cl_it;
		cl_collection = _tmp1_;
		cl_collection_length1 = _tmp0_;
		for (cl_it = 0; cl_it < _tmp0_; cl_it = cl_it + 1) {
			TrackerClass* _tmp2_;
			TrackerClass* cl;
			_tmp2_ = _g_object_ref0 (cl_collection[cl_it]);
			cl = _tmp2_;
			{
				tracker_class_transact_events (cl);
				_g_object_unref0 (cl);
			}
		}
	}
	if (start_timer) {
		_tmp3_ = self->priv->signal_timeout == 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		guint _tmp4_;
		_tmp4_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) TRACKER_RESOURCES_SIGNALS_SECONDS_PER_EMIT, _tracker_resources_on_emit_signals_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->signal_timeout = _tmp4_;
	}
	tracker_writeback_transact ();
}


static void tracker_resources_on_statements_rolled_back (TrackerResources* self, gboolean start_timer) {
	g_return_if_fail (self != NULL);
	tracker_events_reset_pending ();
	tracker_writeback_reset_pending ();
}


static void tracker_resources_check_graph_updated_signal (TrackerResources* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_events_get_total (FALSE);
	if (_tmp0_ > TRACKER_RESOURCES_GRAPH_UPDATED_IMMEDIATE_EMIT_AT) {
		gint _tmp1_;
		TrackerClass** _tmp2_ = NULL;
		_tmp2_ = tracker_events_get_classes (&_tmp1_);
		{
			TrackerClass** cl_collection;
			int cl_collection_length1;
			int cl_it;
			cl_collection = _tmp2_;
			cl_collection_length1 = _tmp1_;
			for (cl_it = 0; cl_it < _tmp1_; cl_it = cl_it + 1) {
				TrackerClass* _tmp3_;
				TrackerClass* cl;
				_tmp3_ = _g_object_ref0 (cl_collection[cl_it]);
				cl = _tmp3_;
				{
					tracker_resources_emit_graph_updated (self, cl);
					_g_object_unref0 (cl);
				}
			}
		}
		tracker_events_get_total (TRUE);
	}
}


static void tracker_resources_on_statement_inserted (TrackerResources* self, gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint pred_id, gint object_id, const gchar* object, GPtrArray* rdf_types) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (subject != NULL);
	g_return_if_fail (rdf_types != NULL);
	tracker_events_add_insert (graph_id, subject_id, subject, pred_id, object_id, object, rdf_types);
	tracker_writeback_check (graph_id, graph, subject_id, subject, pred_id, object_id, object, rdf_types);
	tracker_resources_check_graph_updated_signal (self);
}


static void tracker_resources_on_statement_deleted (TrackerResources* self, gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint pred_id, gint object_id, const gchar* object, GPtrArray* rdf_types) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (subject != NULL);
	g_return_if_fail (rdf_types != NULL);
	tracker_events_add_delete (graph_id, subject_id, subject, pred_id, object_id, object, rdf_types);
	tracker_writeback_check (graph_id, graph, subject_id, subject, pred_id, object_id, object, rdf_types);
	tracker_resources_check_graph_updated_signal (self);
}


static void _tracker_resources_on_statement_inserted_tracker_statement_callback (gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint predicate_id, gint object_id, const gchar* object, GPtrArray* rdf_types, gpointer self) {
	tracker_resources_on_statement_inserted (self, graph_id, graph, subject_id, subject, predicate_id, object_id, object, rdf_types);
}


static void _tracker_resources_on_statement_deleted_tracker_statement_callback (gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint predicate_id, gint object_id, const gchar* object, GPtrArray* rdf_types, gpointer self) {
	tracker_resources_on_statement_deleted (self, graph_id, graph, subject_id, subject, predicate_id, object_id, object, rdf_types);
}


static void _tracker_resources_on_statements_committed_tracker_commit_callback (gboolean start_timer, gpointer self) {
	tracker_resources_on_statements_committed (self, start_timer);
}


static void _tracker_resources_on_statements_rolled_back_tracker_commit_callback (gboolean start_timer, gpointer self) {
	tracker_resources_on_statements_rolled_back (self, start_timer);
}


void tracker_resources_enable_signals (TrackerResources* self) {
	g_return_if_fail (self != NULL);
	tracker_data_add_insert_statement_callback (_tracker_resources_on_statement_inserted_tracker_statement_callback, self);
	tracker_data_add_delete_statement_callback (_tracker_resources_on_statement_deleted_tracker_statement_callback, self);
	tracker_data_add_commit_statement_callback (_tracker_resources_on_statements_committed_tracker_commit_callback, self);
	tracker_data_add_rollback_statement_callback (_tracker_resources_on_statements_rolled_back_tracker_commit_callback, self);
}


void tracker_resources_disable_signals (TrackerResources* self) {
	g_return_if_fail (self != NULL);
	tracker_data_remove_insert_statement_callback (_tracker_resources_on_statement_inserted_tracker_statement_callback, self);
	tracker_data_remove_delete_statement_callback (_tracker_resources_on_statement_deleted_tracker_statement_callback, self);
	tracker_data_remove_commit_statement_callback (_tracker_resources_on_statements_committed_tracker_commit_callback, self);
	tracker_data_remove_rollback_statement_callback (_tracker_resources_on_statements_rolled_back_tracker_commit_callback, self);
	if (self->priv->signal_timeout != 0) {
		g_source_remove (self->priv->signal_timeout);
	}
}


void tracker_resources_unreg_batches (TrackerResources* self, const gchar* old_owner) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_owner != NULL);
	tracker_store_unreg_batches (old_owner);
}


static void g_cclosure_user_marshal_VOID__VARIANT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__VARIANT) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__VARIANT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__VARIANT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_variant (param_values + 1), data2);
}


static void g_cclosure_user_marshal_VOID__STRING_VARIANT_VARIANT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_VARIANT_VARIANT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_VARIANT_VARIANT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_VARIANT_VARIANT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_variant (param_values + 2), g_value_get_variant (param_values + 3), data2);
}


static void tracker_resources_class_init (TrackerResourcesClass * klass) {
	tracker_resources_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerResourcesPrivate));
	G_OBJECT_CLASS (klass)->finalize = tracker_resources_finalize;
	g_signal_new ("writeback", TRACKER_TYPE_RESOURCES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__VARIANT, G_TYPE_NONE, 1, G_TYPE_VARIANT);
	g_signal_new ("graph_updated", TRACKER_TYPE_RESOURCES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_VARIANT_VARIANT, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_VARIANT);
}


static void tracker_resources_instance_init (TrackerResources * self) {
	self->priv = TRACKER_RESOURCES_GET_PRIVATE (self);
}


static void tracker_resources_finalize (GObject* obj) {
	TrackerResources * self;
	self = TRACKER_RESOURCES (obj);
	tracker_resources_disable_signals (self);
	_g_object_unref0 (self->priv->connection);
	G_OBJECT_CLASS (tracker_resources_parent_class)->finalize (obj);
}


GType tracker_resources_get_type (void) {
	static volatile gsize tracker_resources_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_resources_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerResourcesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_resources_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerResources), 0, (GInstanceInitFunc) tracker_resources_instance_init, NULL };
		GType tracker_resources_type_id;
		tracker_resources_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerResources", &g_define_type_info, 0);
		g_type_set_qdata (tracker_resources_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) tracker_resources_register_object);
		g_once_init_leave (&tracker_resources_type_id__volatile, tracker_resources_type_id);
	}
	return tracker_resources_type_id__volatile;
}


static void _dbus_tracker_resources_load (TrackerResources* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* uri = NULL;
	GVariant* _tmp2_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	uri = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	tracker_resources_load (self, g_dbus_method_invocation_get_sender (invocation), uri, (GAsyncReadyCallback) _dbus_tracker_resources_load_ready, invocation);
	_g_free0 (uri);
}


static void _dbus_tracker_resources_load_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	tracker_resources_load_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_resources_sparql_query (TrackerResources* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* query = NULL;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	query = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	tracker_resources_sparql_query (self, g_dbus_method_invocation_get_sender (invocation), query, (GAsyncReadyCallback) _dbus_tracker_resources_sparql_query_ready, invocation);
	_g_free0 (query);
}


static void _dbus_tracker_resources_sparql_query_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* result;
	invocation = _user_data_;
	result = tracker_resources_sparql_query_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, result);
	_g_variant_unref0 ( result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_resources_sparql_update (TrackerResources* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* update = NULL;
	GVariant* _tmp4_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	update = g_variant_dup_string (_tmp4_, NULL);
	g_variant_unref (_tmp4_);
	tracker_resources_sparql_update (self, g_dbus_method_invocation_get_sender (invocation), update, (GAsyncReadyCallback) _dbus_tracker_resources_sparql_update_ready, invocation);
	_g_free0 (update);
}


static void _dbus_tracker_resources_sparql_update_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	tracker_resources_sparql_update_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_resources_sparql_update_blank (TrackerResources* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* update = NULL;
	GVariant* _tmp5_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	update = g_variant_dup_string (_tmp5_, NULL);
	g_variant_unref (_tmp5_);
	tracker_resources_sparql_update_blank (self, g_dbus_method_invocation_get_sender (invocation), update, (GAsyncReadyCallback) _dbus_tracker_resources_sparql_update_blank_ready, invocation);
	_g_free0 (update);
}


static void _dbus_tracker_resources_sparql_update_blank_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* result;
	invocation = _user_data_;
	result = tracker_resources_sparql_update_blank_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, result);
	_g_variant_unref0 ( result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_resources_sync (TrackerResources* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	tracker_resources_sync (self, g_dbus_method_invocation_get_sender (invocation));
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_resources_batch_sparql_update (TrackerResources* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* update = NULL;
	GVariant* _tmp6_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	update = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	tracker_resources_batch_sparql_update (self, g_dbus_method_invocation_get_sender (invocation), update, (GAsyncReadyCallback) _dbus_tracker_resources_batch_sparql_update_ready, invocation);
	_g_free0 (update);
}


static void _dbus_tracker_resources_batch_sparql_update_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	tracker_resources_batch_sparql_update_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_resources_batch_commit (TrackerResources* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	tracker_resources_batch_commit (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_resources_enable_signals (TrackerResources* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	tracker_resources_enable_signals (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_resources_disable_signals (TrackerResources* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	tracker_resources_disable_signals (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_resources_unreg_batches (TrackerResources* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* old_owner = NULL;
	GVariant* _tmp7_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	old_owner = g_variant_dup_string (_tmp7_, NULL);
	g_variant_unref (_tmp7_);
	tracker_resources_unreg_batches (self, old_owner);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (old_owner);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void tracker_resources_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Load") == 0) {
		_dbus_tracker_resources_load (object, parameters, invocation);
	} else if (strcmp (method_name, "SparqlQuery") == 0) {
		_dbus_tracker_resources_sparql_query (object, parameters, invocation);
	} else if (strcmp (method_name, "SparqlUpdate") == 0) {
		_dbus_tracker_resources_sparql_update (object, parameters, invocation);
	} else if (strcmp (method_name, "SparqlUpdateBlank") == 0) {
		_dbus_tracker_resources_sparql_update_blank (object, parameters, invocation);
	} else if (strcmp (method_name, "Sync") == 0) {
		_dbus_tracker_resources_sync (object, parameters, invocation);
	} else if (strcmp (method_name, "BatchSparqlUpdate") == 0) {
		_dbus_tracker_resources_batch_sparql_update (object, parameters, invocation);
	} else if (strcmp (method_name, "BatchCommit") == 0) {
		_dbus_tracker_resources_batch_commit (object, parameters, invocation);
	} else if (strcmp (method_name, "EnableSignals") == 0) {
		_dbus_tracker_resources_enable_signals (object, parameters, invocation);
	} else if (strcmp (method_name, "DisableSignals") == 0) {
		_dbus_tracker_resources_disable_signals (object, parameters, invocation);
	} else if (strcmp (method_name, "UnregBatches") == 0) {
		_dbus_tracker_resources_unreg_batches (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* tracker_resources_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean tracker_resources_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_tracker_resources_writeback (GObject* _sender, GVariant* subjects, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, subjects);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Tracker1.Resources", "Writeback", _arguments, NULL);
}


static void _dbus_tracker_resources_graph_updated (GObject* _sender, const gchar* classname, GVariant* deletes, GVariant* inserts, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (classname));
	g_variant_builder_add_value (&_arguments_builder, deletes);
	g_variant_builder_add_value (&_arguments_builder, inserts);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Tracker1.Resources", "GraphUpdated", _arguments, NULL);
}


guint tracker_resources_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_tracker_resources_dbus_interface_info), &_tracker_resources_dbus_interface_vtable, data, _tracker_resources_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "writeback", (GCallback) _dbus_tracker_resources_writeback, data);
	g_signal_connect (object, "graph-updated", (GCallback) _dbus_tracker_resources_graph_updated, data);
	return result;
}


static void _tracker_resources_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}



